/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSet;

public class JdbcOdbcDatabaseMetaData
extends JdbcOdbcObject
implements DatabaseMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcConnectionInterface Con;
    protected long hDbc;

    public JdbcOdbcDatabaseMetaData(JdbcOdbc jdbcOdbc, JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        this.OdbcApi = jdbcOdbc;
        this.Con = jdbcOdbcConnectionInterface;
        this.hDbc = this.Con.getHDBC();
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.allProceduresAreCallable");
        }
        return this.getInfoBooleanString((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.allTablesAreSelectable");
        }
        return this.getInfoBooleanString((short)19);
    }

    public String getURL() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getURL");
        }
        return this.Con.getURL();
    }

    public String getUserName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getUserName");
        }
        return this.getInfoString((short)47);
    }

    public boolean isReadOnly() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.isReadOnly");
        }
        return this.getInfoBooleanString((short)25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedHigh");
        }
        return (n2 = this.getInfoShort((short)85)) == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedLow");
        }
        return (n2 = this.getInfo((short)85)) == 1;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedAtStart");
        }
        return (n2 = this.getInfo((short)85)) == 2;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullsAreSortedAtEnd");
        }
        return (n2 = this.getInfo((short)85)) == 4;
    }

    public String getDatabaseProductName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDatabaseProductName");
        }
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDatabaseProductVersion");
        }
        return this.getInfoString((short)18);
    }

    public String getDriverName() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDriverName");
        }
        return "JDBC-ODBC Bridge (" + this.getInfoString((short)6) + ")";
    }

    public String getDriverVersion() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDriverVersion");
        }
        int n2 = this.getDriverMinorVersion();
        String string = "";
        if (n2 < 1000) {
            string = string + "0";
        }
        if (n2 < 100) {
            string = string + "0";
        }
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + "" + n2;
        return "" + this.getDriverMajorVersion() + "." + string + " (" + this.getInfoString((short)7) + ")";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.usesLocalFiles");
        }
        return (n2 = this.getInfoShort((short)84)) == 2;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.usesLocalFilePerTable");
        }
        return (n2 = this.getInfoShort((short)84)) == 1;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        }
        return (n2 = this.getInfoShort((short)28)) == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesUpperCaseIdentifiers");
        }
        return (n2 = this.getInfoShort((short)28)) == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesLowerCaseIdentifiers");
        }
        return (n2 = this.getInfoShort((short)28)) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesMixedCaseIdentifiers");
        }
        return (n2 = this.getInfoShort((short)28)) == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        }
        return (n2 = this.getInfoShort((short)93)) == 3;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        }
        return (n2 = this.getInfoShort((short)93)) == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        }
        return (n2 = this.getInfoShort((short)93)) == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        }
        return (n2 = this.getInfoShort((short)93)) == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getIdentifierQuoteString");
        }
        return this.getInfoString((short)29);
    }

    public String getSQLKeywords() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSQLKeywords");
        }
        return this.getInfoString((short)89, 16383);
    }

    public String getNumericFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getNumericFunctions");
        }
        String string = "";
        int n2 = this.getInfo((short)49);
        if ((n2 & 1) != 0) {
            string = string + "ABS,";
        }
        if ((n2 & 2) != 0) {
            string = string + "ACOS,";
        }
        if ((n2 & 4) != 0) {
            string = string + "ASIN,";
        }
        if ((n2 & 8) != 0) {
            string = string + "ATAN,";
        }
        if ((n2 & 0x10) != 0) {
            string = string + "ATAN2,";
        }
        if ((n2 & 0x20) != 0) {
            string = string + "CEILING,";
        }
        if ((n2 & 0x40) != 0) {
            string = string + "COS,";
        }
        if ((n2 & 0x80) != 0) {
            string = string + "COT,";
        }
        if ((n2 & 0x40000) != 0) {
            string = string + "DEGREES,";
        }
        if ((n2 & 0x100) != 0) {
            string = string + "EXP,";
        }
        if ((n2 & 0x200) != 0) {
            string = string + "FLOOR,";
        }
        if ((n2 & 0x400) != 0) {
            string = string + "LOG,";
        }
        if ((n2 & 0x80000) != 0) {
            string = string + "LOG10,";
        }
        if ((n2 & 0x800) != 0) {
            string = string + "MOD,";
        }
        if ((n2 & 0x10000) != 0) {
            string = string + "PI,";
        }
        if ((n2 & 0x100000) != 0) {
            string = string + "POWER,";
        }
        if ((n2 & 0x200000) != 0) {
            string = string + "RADIANS,";
        }
        if ((n2 & 0x20000) != 0) {
            string = string + "RAND,";
        }
        if ((n2 & 0x400000) != 0) {
            string = string + "ROUND,";
        }
        if ((n2 & 0x1000) != 0) {
            string = string + "SIGN,";
        }
        if ((n2 & 0x2000) != 0) {
            string = string + "SIN,";
        }
        if ((n2 & 0x4000) != 0) {
            string = string + "SQRT,";
        }
        if ((n2 & 0x8000) != 0) {
            string = string + "TAN,";
        }
        if ((n2 & 0x800000) != 0) {
            string = string + "TRUNCATE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getStringFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getStringFunctions");
        }
        String string = "";
        int n2 = this.getInfo((short)50);
        if ((n2 & 0x2000) != 0) {
            string = string + "ASCII,";
        }
        if ((n2 & 0x4000) != 0) {
            string = string + "CHAR,";
        }
        if ((n2 & 1) != 0) {
            string = string + "CONCAT,";
        }
        if ((n2 & 0x8000) != 0) {
            string = string + "DIFFERENCE,";
        }
        if ((n2 & 2) != 0) {
            string = string + "INSERT,";
        }
        if ((n2 & 0x40) != 0) {
            string = string + "LCASE,";
        }
        if ((n2 & 4) != 0) {
            string = string + "LEFT,";
        }
        if ((n2 & 0x10) != 0) {
            string = string + "LENGTH,";
        }
        if ((n2 & 0x20) != 0) {
            string = string + "LOCATE,";
        }
        if ((n2 & 0x10000) != 0) {
            string = string + "LOCATE_2,";
        }
        if ((n2 & 8) != 0) {
            string = string + "LTRIM,";
        }
        if ((n2 & 0x80) != 0) {
            string = string + "REPEAT,";
        }
        if ((n2 & 0x100) != 0) {
            string = string + "REPLACE,";
        }
        if ((n2 & 0x200) != 0) {
            string = string + "RIGHT,";
        }
        if ((n2 & 0x400) != 0) {
            string = string + "RTRIM,";
        }
        if ((n2 & 0x20000) != 0) {
            string = string + "SOUNDEX,";
        }
        if ((n2 & 0x40000) != 0) {
            string = string + "SPACE,";
        }
        if ((n2 & 0x800) != 0) {
            string = string + "SUBSTRING,";
        }
        if ((n2 & 0x1000) != 0) {
            string = string + "UCASE,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSystemFunctions");
        }
        String string = "";
        int n2 = this.getInfo((short)51);
        if ((n2 & 2) != 0) {
            string = string + "DBNAME,";
        }
        if ((n2 & 4) != 0) {
            string = string + "IFNULL,";
        }
        if ((n2 & 1) != 0) {
            string = string + "USERNAME,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getTimeDateFunctions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTimeDateFunctions");
        }
        String string = "";
        int n2 = this.getInfo((short)52);
        if ((n2 & 2) != 0) {
            string = string + "CURDATE,";
        }
        if ((n2 & 0x200) != 0) {
            string = string + "CURTIME,";
        }
        if ((n2 & 0x8000) != 0) {
            string = string + "DAYNAME,";
        }
        if ((n2 & 4) != 0) {
            string = string + "DAYOFMONTH,";
        }
        if ((n2 & 8) != 0) {
            string = string + "DAYOFWEEK,";
        }
        if ((n2 & 0x10) != 0) {
            string = string + "DAYOFYEAR,";
        }
        if ((n2 & 0x400) != 0) {
            string = string + "HOUR,";
        }
        if ((n2 & 0x800) != 0) {
            string = string + "MINUTE,";
        }
        if ((n2 & 0x20) != 0) {
            string = string + "MONTH,";
        }
        if ((n2 & 0x10000) != 0) {
            string = string + "MONTHNAME,";
        }
        if ((n2 & 1) != 0) {
            string = string + "NOW,";
        }
        if ((n2 & 0x40) != 0) {
            string = string + "QUARTER,";
        }
        if ((n2 & 0x1000) != 0) {
            string = string + "SECOND,";
        }
        if ((n2 & 0x2000) != 0) {
            string = string + "TIMESTAMPADD,";
        }
        if ((n2 & 0x4000) != 0) {
            string = string + "TIMESTAMPDIFF,";
        }
        if ((n2 & 0x80) != 0) {
            string = string + "WEEK,";
        }
        if ((n2 & 0x100) != 0) {
            string = string + "YEAR,";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getSearchStringEscape() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSearchStringEscape");
        }
        return this.getInfoString((short)14);
    }

    public String getExtraNameCharacters() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getExtraNameCharacters");
        }
        return this.getInfoString((short)94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        }
        return ((n2 = this.getInfo((short)86)) & 1) > 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        }
        return ((n2 = this.getInfo((short)86)) & 2) > 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsColumnAliasing");
        }
        return this.getInfoBooleanString((short)87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.nullPlusNullIsNull");
        }
        return (n2 = this.getInfoShort((short)22)) == 0;
    }

    public boolean supportsConvert() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsConvert");
        }
        return (n2 = this.getInfo((short)48)) == 1;
    }

    public boolean supportsConvert(int n2, int n3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsConvert (" + n2 + "," + n3 + ")");
        }
        short s2 = 0;
        boolean bl2 = false;
        int n4 = 0;
        switch (n2) {
            case -7: {
                s2 = 55;
                break;
            }
            case -6: {
                s2 = 68;
                break;
            }
            case 5: {
                s2 = 65;
                break;
            }
            case 4: {
                s2 = 61;
                break;
            }
            case -5: {
                s2 = 53;
                break;
            }
            case 6: {
                s2 = 60;
                break;
            }
            case 7: {
                s2 = 64;
                break;
            }
            case 8: {
                s2 = 59;
                break;
            }
            case 2: {
                s2 = 63;
                break;
            }
            case 3: {
                s2 = 58;
                break;
            }
            case 1: {
                s2 = 56;
                break;
            }
            case 12: {
                s2 = 70;
                break;
            }
            case -1: {
                s2 = 62;
                break;
            }
            case 91: {
                s2 = 57;
                break;
            }
            case 92: {
                s2 = 66;
                break;
            }
            case 93: {
                s2 = 67;
                break;
            }
            case -2: {
                s2 = 54;
                break;
            }
            case -3: {
                s2 = 69;
                break;
            }
            case -4: {
                s2 = 71;
            }
        }
        int n5 = this.getInfo(s2);
        switch (n3) {
            case -7: {
                n4 = 4096;
                break;
            }
            case -6: {
                n4 = 8192;
                break;
            }
            case 5: {
                n4 = 16;
                break;
            }
            case 4: {
                n4 = 8;
                break;
            }
            case -5: {
                n4 = 16384;
                break;
            }
            case 6: {
                n4 = 32;
                break;
            }
            case 7: {
                n4 = 64;
                break;
            }
            case 8: {
                n4 = 128;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 3: {
                n4 = 4;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 12: {
                n4 = 256;
                break;
            }
            case -1: {
                n4 = 512;
                break;
            }
            case 91: {
                n4 = 32768;
                break;
            }
            case 92: {
                n4 = 65536;
                break;
            }
            case 93: {
                n4 = 131072;
                break;
            }
            case -2: {
                n4 = 1024;
                break;
            }
            case -3: {
                n4 = 2048;
                break;
            }
            case -4: {
                n4 = 262144;
            }
        }
        return (n5 & n4) > 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTableCorrelationNames");
        }
        return (n2 = this.getInfoShort((short)74)) == 1 || n2 == 2;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        }
        return (n2 = this.getInfoShort((short)74)) == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsExpressionsInOrderBy");
        }
        return this.getInfoBooleanString((short)27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOrderByUnrelated");
        }
        return this.getInfoBooleanString((short)90);
    }

    public boolean supportsGroupBy() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupBy");
        }
        return (n2 = this.getInfoShort((short)88)) != 0;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupByUnrelated");
        }
        return (n2 = this.getInfoShort((short)88)) == 3;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsGroupByBeyondSelect");
        }
        return (n2 = this.getInfoShort((short)88)) == 2;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsLikeEscapeClause");
        }
        return this.getInfoBooleanString((short)113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMultipleResultSets");
        }
        return this.getInfoBooleanString((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMultipleTransactions");
        }
        return this.getInfoBooleanString((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsNonNullableColumns");
        }
        return (n2 = this.getInfoShort((short)75)) == 1;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsMinimumSQLGrammar");
        }
        return (n2 = this.getInfoShort((short)15)) == 0 || n2 == 1 || n2 == 2;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCoreSQLGrammar");
        }
        return (n2 = this.getInfoShort((short)15)) == 1 || n2 == 2;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsExtendedSQLGrammar");
        }
        return (n2 = this.getInfoShort((short)15)) == 2;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        }
        return this.getInfoBooleanString((short)73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        String string;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOuterJoins");
        }
        return !(string = this.getInfoString((short)38)).equalsIgnoreCase("N");
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsFullOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("F");
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsLimitedOuterJoins");
        }
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("P");
    }

    public String getSchemaTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSchemaTerm");
        }
        return this.getInfoString((short)39);
    }

    public String getProcedureTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedureTerm");
        }
        return this.getInfoString((short)40);
    }

    public String getCatalogTerm() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogTerm");
        }
        return this.getInfoString((short)42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.isCatalogAtStart");
        }
        return (n2 = this.getInfoShort((short)114)) == 1;
    }

    public String getCatalogSeparator() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogSeparator");
        }
        return this.getInfoString((short)41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInDataManipulation");
        }
        return ((n2 = this.getInfo((short)91)) & 1) > 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        }
        return ((n2 = this.getInfo((short)91)) & 2) > 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        }
        return ((n2 = this.getInfo((short)91)) & 4) > 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        }
        return ((n2 = this.getInfo((short)91)) & 8) > 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        }
        return ((n2 = this.getInfo((short)91)) & 0x10) > 0;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        }
        return ((n2 = this.getInfo((short)92)) & 1) > 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        }
        return ((n2 = this.getInfo((short)92)) & 2) > 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        }
        return ((n2 = this.getInfo((short)92)) & 4) > 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        }
        return ((n2 = this.getInfo((short)92)) & 8) > 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        }
        return ((n2 = this.getInfo((short)92)) & 0x10) > 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsPositionedDelete");
        }
        return ((n2 = this.getInfo((short)80)) & 1) > 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsPositionedUpdate");
        }
        return ((n2 = this.getInfo((short)80)) & 2) > 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSelectForUpdate");
        }
        return ((n2 = this.getInfo((short)80)) & 4) > 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsStoredProcedures");
        }
        return this.getInfoBooleanString((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInComparisions");
        }
        return ((n2 = this.getInfo((short)95)) & 1) > 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInExists");
        }
        return ((n2 = this.getInfo((short)95)) & 2) > 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInIns");
        }
        return ((n2 = this.getInfo((short)95)) & 4) > 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        }
        return ((n2 = this.getInfo((short)95)) & 8) > 0;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsCorrelatedSubqueries");
        }
        return ((n2 = this.getInfo((short)95)) & 0x10) > 0;
    }

    public boolean supportsUnion() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsUnion");
        }
        return ((n2 = this.getInfo((short)96)) & 1) > 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsUnionAll");
        }
        return ((n2 = this.getInfo((short)96)) & 2) > 0;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        }
        return (n2 = this.getInfoShort((short)23)) == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        }
        return (n2 = this.getInfoShort((short)24)) == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        }
        return (n2 = this.getInfoShort((short)23)) == 2 || n2 == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        }
        return (n2 = this.getInfoShort((short)24)) == 2 || n2 == 1;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxBinaryLiteralLength");
        }
        return this.getInfo((short)112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCharLiteralLength");
        }
        return this.getInfo((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnNameLength");
        }
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInGroupBy");
        }
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInIndex");
        }
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInOrderBy");
        }
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInSeleted");
        }
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxColumnsInTable");
        }
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxConnections");
        }
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCursorNameLength");
        }
        return this.getInfo((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxIndexLength");
        }
        return this.getInfo((short)102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxSchemaNameLength");
        }
        return this.getInfoShort((short)32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxProcedureNameLength");
        }
        return this.getInfoShort((short)33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxCatalogNameLength");
        }
        return this.getInfoShort((short)34);
    }

    public int getMaxRowSize() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxRowSize");
        }
        return this.getInfo((short)104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        }
        return this.getInfoBooleanString((short)103);
    }

    public int getMaxStatementLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxStatementLength");
        }
        return this.getInfo((short)105);
    }

    public int getMaxStatements() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxStatements");
        }
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxTableNameLength");
        }
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxTablesInSelect");
        }
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getMaxUserNameLength");
        }
        return this.getInfoShort((short)107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getDefaultTransactionIsolation");
        }
        int n2 = this.getInfo((short)26);
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 4;
                break;
            }
            case 8: {
                n3 = 8;
            }
        }
        return n3;
    }

    public boolean supportsTransactions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTransactions");
        }
        return (n2 = this.getInfoShort((short)46)) != 0;
    }

    public boolean supportsTransactionIsolationLevel(int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsTransactionIsolationLevel (" + n2 + ")");
        }
        if (n2 == 0) {
            return !this.supportsTransactions();
        }
        int n3 = this.getInfo((short)72);
        boolean bl2 = false;
        switch (n2) {
            case 1: {
                bl2 = (n3 & 1) > 0;
                break;
            }
            case 2: {
                bl2 = (n3 & 2) > 0;
                break;
            }
            case 4: {
                bl2 = (n3 & 4) > 0;
                break;
            }
            case 8: {
                bl2 = (n3 & 8) > 0;
            }
        }
        return bl2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        }
        return ((n2 = this.getInfoShort((short)46)) & 2) > 0;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        }
        return ((n2 = this.getInfoShort((short)46)) & 1) > 0;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        }
        return ((n2 = this.getInfoShort((short)46)) & 3) > 0;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        int n2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        }
        return ((n2 = this.getInfoShort((short)46)) & 4) > 0;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedures (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedures(l2, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getProcedureColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedureColumns(l2, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(6);
            jdbcOdbcResultSet.setAliasColumnName("PRECISION", 8);
            jdbcOdbcResultSet.setAliasColumnName("LENGTH", 9);
            jdbcOdbcResultSet.setAliasColumnName("SCALE", 10);
            jdbcOdbcResultSet.setAliasColumnName("RADIX", 11);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        String string4 = null;
        SQLWarning sQLWarning = null;
        if (stringArray != null) {
            string4 = "";
            int n2 = 0;
            n2 = 0;
            while (n2 < stringArray.length) {
                String string5 = stringArray[n2];
                if (n2 > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + string5;
                n2 = (short)(n2 + 1);
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTables (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTables(l2, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getSchemas");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("", "%", "", null);
        int[] nArray = new int[]{2};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCatalogs");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("%", "", "", null);
        int[] nArray = new int[]{1};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTableTypes");
        }
        String[] stringArray = new String[]{"%"};
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("", "", "", stringArray);
        int[] nArray = new int[]{4};
        jdbcOdbcResultSet.setColumnMappings(nArray);
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumns(l2, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("COLUMN_DEF", 12, 254), new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0), new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0), new JdbcOdbcPseudoCol("CHAR_OCTET_LENGTH", 4, 0), new JdbcOdbcPseudoCol("ORDINAL_POSITION", 4, 0), new JdbcOdbcPseudoCol("IS_NULLABLE", 12, 254)};
            jdbcOdbcResultSet.setPseudoCols(13, 18, jdbcOdbcPseudoColArray);
            jdbcOdbcResultSet.setSQLTypeColumn(5);
        } else if (this.Con.getODBCVer() >= 3) {
            jdbcOdbcResultSet.setSQLTypeColumn(5);
            jdbcOdbcResultSet.setAliasColumnName("SQL_DATETIME_SUB", 15);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getColumnPrivileges (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumnPrivileges(l2, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTablePrivileges (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTablePrivileges(l2, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n2, boolean bl2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getBestRowIdentifier (" + string + "," + string2 + "," + string3 + "," + n2 + "," + bl2 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(l2, (short)1, string, string2, string3, n2, bl2);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getVersionColumns (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(l2, (short)2, string, string2, string3, 0, false);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getPrimaryKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLPrimaryKeys(l2, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getImportedKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l2, null, null, null, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getExportedKeys (" + string + "," + string2 + "," + string3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l2, string, string2, string3, null, null, null);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getCrossReference (" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l2, string, string2, string3, string4, string5, string6);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            jdbcOdbcResultSet.setPseudoCols(14, 14, jdbcOdbcPseudoColArray);
        }
        return jdbcOdbcResultSet;
    }

    public boolean supportsResultSetType(int n2) throws SQLException {
        short s2 = this.getConnectionSupportType(n2);
        switch (n2) {
            case 1003: {
                return s2 == 0;
            }
            case 1004: {
                return s2 == 3 || s2 == 1;
            }
            case 1005: {
                if (s2 == 1) {
                    int n3 = this.Con.getOdbcCursorAttr2(s2);
                    return (n3 & 0x40) != 0;
                }
                return s2 == 2;
            }
        }
        return false;
    }

    public boolean supportsResultSetConcurrency(int n2, int n3) throws SQLException {
        if (this.supportsResultSetType(n2)) {
            short s2 = this.Con.getOdbcConcurrency(n3);
            switch (n3) {
                case 1007: {
                    return s2 == 1;
                }
                case 1008: {
                    if (n2 != 1003) {
                        return s2 == 2;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int n2) throws SQLException {
        if (n2 != 1003) {
            return this.updatesAreDetected(n2);
        }
        return false;
    }

    public boolean ownDeletesAreVisible(int n2) throws SQLException {
        if (n2 != 1003) {
            return this.deletesAreDetected(n2);
        }
        return false;
    }

    public boolean ownInsertsAreVisible(int n2) throws SQLException {
        if (n2 != 1003) {
            return this.insertsAreDetected(n2);
        }
        return false;
    }

    public boolean othersUpdatesAreVisible(int n2) throws SQLException {
        if (n2 == 1005) {
            return this.updatesAreDetected(n2);
        }
        return false;
    }

    public boolean othersDeletesAreVisible(int n2) throws SQLException {
        if (n2 == 1005) {
            return this.deletesAreDetected(n2);
        }
        return false;
    }

    public boolean othersInsertsAreVisible(int n2) throws SQLException {
        if (n2 == 1005) {
            return this.insertsAreDetected(n2);
        }
        return false;
    }

    public boolean updatesAreDetected(int n2) throws SQLException {
        short s2 = this.getCursorAttribute(n2);
        if (s2 > 0) {
            try {
                int n3 = this.OdbcApi.SQLGetInfo(this.hDbc, s2);
                return (n3 & 0x40) > 0;
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return false;
    }

    public boolean deletesAreDetected(int n2) throws SQLException {
        short s2 = this.getCursorAttribute(n2);
        if (s2 > 0) {
            try {
                int n3 = this.OdbcApi.SQLGetInfo(this.hDbc, s2);
                return (n3 & 0x20) > 0;
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return false;
    }

    public boolean insertsAreDetected(int n2) throws SQLException {
        short s2 = this.getCursorAttribute(n2);
        if (s2 > 0) {
            try {
                int n3 = this.OdbcApi.SQLGetInfo(this.hDbc, s2);
                return (n3 & 0x10) > 0;
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.supportsBatchUpdates");
        }
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)121);
            if ((n2 & 2) > 0) {
                bl2 = true;
            }
            if (((n2 = this.OdbcApi.SQLGetInfo(this.hDbc, (short)153)) & 1) > 0) {
                bl4 = true;
            }
        }
        catch (SQLException sQLException) {
            bl2 = false;
            bl4 = false;
        }
        if (bl2 && bl4) {
            return true;
        }
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Connection getConnection() throws SQLException {
        if (this.Con != null && this.hDbc > 0L) {
            return this.Con;
        }
        return null;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getTypeInfo");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLGetTypeInfo(l2, (short)0);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[5];
            jdbcOdbcPseudoColArray[0] = new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0);
            jdbcOdbcPseudoColArray[1] = new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0);
            jdbcOdbcPseudoColArray[2] = new JdbcOdbcPseudoCol("NUM_PREC_RADIX", 5, 0);
            jdbcOdbcResultSet.setPseudoCols(16, 18, jdbcOdbcPseudoColArray);
            jdbcOdbcResultSet.setSQLTypeColumn(2);
        } else if (this.Con.getODBCVer() >= 3) {
            jdbcOdbcResultSet.setSQLTypeColumn(2);
        }
        if (this.Con.getODBCVer() >= 2) {
            jdbcOdbcResultSet.setAliasColumnName("PRECISION", 3);
            jdbcOdbcResultSet.setAliasColumnName("AUTO_INCREMENT", 12);
        }
        return jdbcOdbcResultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl2, boolean bl3) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*DatabaseMetaData.getIndexInfo (" + string + "," + string2 + "," + string3 + bl2 + "," + bl3 + ")");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        long l2 = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLStatistics(l2, string, string2, string3, bl2, bl3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(l2, 1);
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet();
        jdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l2, false, null);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        return jdbcOdbcResultSet;
    }

    protected void validateConnection() throws SQLException {
        this.Con.validateConnection();
    }

    protected int getInfo(short s2) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfo(this.hDbc, s2);
    }

    protected int getInfoShort(short s2) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoShort(this.hDbc, s2);
    }

    protected boolean getInfoBooleanString(short s2) throws SQLException {
        this.validateConnection();
        String string = this.OdbcApi.SQLGetInfoString(this.hDbc, s2);
        return string.equalsIgnoreCase("Y");
    }

    protected String getInfoString(short s2) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s2);
    }

    protected String getInfoString(short s2, int n2) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s2, n2);
    }

    protected short getConnectionSupportType(int n2) throws SQLException {
        short s2 = this.Con.getOdbcCursorType(n2);
        if (s2 == -1) {
            s2 = this.Con.getBestOdbcCursorType();
        }
        return s2;
    }

    protected short getCursorAttribute(int n2) throws SQLException {
        short s2 = 0;
        if (this.supportsResultSetType(n2)) {
            short s3 = this.getConnectionSupportType(n2);
            switch (s3) {
                case 1: {
                    s2 = 151;
                    break;
                }
                case 2: {
                    s2 = 145;
                    break;
                }
                case 3: {
                    s2 = 168;
                }
            }
            return s2;
        }
        return s2;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsResultSetHoldability(int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

