/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class SunVolatileImage
extends VolatileImage {
    protected SurfaceData surfaceData;
    protected Component comp;
    protected GraphicsConfiguration graphicsConfig;
    protected Object context;
    protected ImageCapabilities imageCaps;
    private Font defaultFont;
    private int width;
    private int height;
    protected boolean surfaceLoss;
    protected boolean surfaceLossHw;
    protected SurfaceData surfaceDataHw;
    protected SurfaceData surfaceDataSw;
    protected SurfaceData previousSurfaceData;
    protected static boolean accelerationEnabled = !GraphicsEnvironment.isHeadless();

    private SunVolatileImage(int n2, int n3, Object object) {
        this.width = n2;
        this.height = n3;
        this.context = object;
    }

    public SunVolatileImage(Component component, int n2, int n3) {
        this(component, n2, n3, null);
    }

    public SunVolatileImage(Component component, int n2, int n3, Object object) {
        this(n2, n3, object);
        this.comp = component;
        this.graphicsConfig = component.getGraphicsConfiguration();
        if (accelerationEnabled) {
            this.initAcceleratedBackground();
        }
        if (this.surfaceDataHw == null) {
            this.surfaceData = this.getSurfaceDataSw();
        }
    }

    public SunVolatileImage(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        this(n2, n3, null);
        this.graphicsConfig = graphicsConfiguration;
        if (accelerationEnabled) {
            this.initAcceleratedBackground();
        }
        if (this.surfaceDataHw == null) {
            this.surfaceData = this.getSurfaceDataSw();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public SurfaceData getSurfaceDataSw() {
        if (this.surfaceDataSw == null) {
            BufferedImage bufferedImage = this.getBufferedImage();
            this.surfaceDataSw = BufImgSurfaceData.createData(bufferedImage);
        }
        return this.surfaceDataSw;
    }

    public SurfaceData restoreContents() {
        return this.getSurfaceDataSw();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    protected ColorModel getColorModel() {
        if (this.comp != null) {
            return this.comp.getColorModel();
        }
        return this.graphicsConfig.getColorModel();
    }

    private Color getForeground() {
        if (this.comp != null) {
            return this.comp.getForeground();
        }
        return Color.black;
    }

    private Color getBackground() {
        if (this.comp != null) {
            return this.comp.getBackground();
        }
        return Color.white;
    }

    private Font getFont() {
        if (this.comp != null) {
            return this.comp.getFont();
        }
        if (this.defaultFont == null) {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        return this.defaultFont;
    }

    public Graphics2D createGraphics() {
        return new SunGraphics2D(this.surfaceData, this.getForeground(), this.getBackground(), this.getFont());
    }

    public void initAcceleratedBackground() {
    }

    public void initContents() {
        Graphics2D graphics2D = this.createGraphics();
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.dispose();
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        return null;
    }

    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    protected BufferedImage getBufferedImage() {
        return this.graphicsConfig.createCompatibleImage(this.getWidth(), this.getHeight());
    }

    public BufferedImage getSnapshot() {
        BufferedImage bufferedImage = this.getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public int validate(GraphicsConfiguration graphicsConfiguration) {
        int n2 = 0;
        boolean bl2 = this.surfaceLoss;
        this.surfaceLoss = false;
        if (accelerationEnabled) {
            if (!this.isGCValid(graphicsConfiguration)) {
                n2 = 2;
            } else if (this.surfaceDataHw == null) {
                this.initAcceleratedBackground();
                if (this.surfaceDataHw != null) {
                    this.surfaceLossHw = false;
                    n2 = 1;
                }
            } else if (this.surfaceLossHw) {
                try {
                    this.restoreSurfaceDataHw();
                    this.surfaceData = this.surfaceDataHw;
                    this.initContents();
                    this.surfaceLossHw = false;
                    n2 = 1;
                }
                catch (InvalidPipeException invalidPipeException) {
                    this.surfaceData = this.getSurfaceDataSw();
                }
            } else if (bl2) {
                n2 = 1;
            }
            if (n2 != 2 && this.surfaceData != this.previousSurfaceData) {
                this.previousSurfaceData = this.surfaceData;
                n2 = 1;
            }
        }
        return n2;
    }

    protected void restoreSurfaceDataHw() {
    }

    protected boolean isGCValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration.getDevice() == this.graphicsConfig.getDevice();
    }

    public boolean contentsLost() {
        return this.surfaceLoss;
    }

    public ImageCapabilities getCapabilities() {
        if (this.imageCaps == null) {
            this.imageCaps = new DefaultImageCapabilities();
        }
        return this.imageCaps;
    }

    protected class DefaultImageCapabilities
    extends ImageCapabilities {
        public DefaultImageCapabilities() {
            super(false);
        }

        public boolean isAccelerated() {
            return SunVolatileImage.this.surfaceData == SunVolatileImage.this.surfaceDataHw;
        }
    }
}

