/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseTraversers
extends DTMDefaultBase {
    public DTMDefaultBaseTraversers(DTMManager dTMManager, Source source, int n2, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl2) {
        super(dTMManager, source, n2, dTMWSFilter, xMLStringFactory, bl2);
    }

    public DTMAxisTraverser getAxisTraverser(int n2) {
        DTMAxisTraverser dTMAxisTraverser;
        if (null == this.m_traversers) {
            this.m_traversers = new DTMAxisTraverser[Axis.names.length];
            dTMAxisTraverser = null;
        } else {
            dTMAxisTraverser = this.m_traversers[n2];
            if (dTMAxisTraverser != null) {
                return dTMAxisTraverser;
            }
        }
        switch (n2) {
            case 0: {
                dTMAxisTraverser = new AncestorTraverser();
                break;
            }
            case 1: {
                dTMAxisTraverser = new AncestorOrSelfTraverser();
                break;
            }
            case 2: {
                dTMAxisTraverser = new AttributeTraverser();
                break;
            }
            case 3: {
                dTMAxisTraverser = new ChildTraverser();
                break;
            }
            case 4: {
                dTMAxisTraverser = new DescendantTraverser();
                break;
            }
            case 5: {
                dTMAxisTraverser = new DescendantOrSelfTraverser();
                break;
            }
            case 6: {
                dTMAxisTraverser = new FollowingTraverser();
                break;
            }
            case 7: {
                dTMAxisTraverser = new FollowingSiblingTraverser();
                break;
            }
            case 9: {
                dTMAxisTraverser = new NamespaceTraverser();
                break;
            }
            case 8: {
                dTMAxisTraverser = new NamespaceDeclsTraverser();
                break;
            }
            case 10: {
                dTMAxisTraverser = new ParentTraverser();
                break;
            }
            case 11: {
                dTMAxisTraverser = new PrecedingTraverser();
                break;
            }
            case 12: {
                dTMAxisTraverser = new PrecedingSiblingTraverser();
                break;
            }
            case 13: {
                dTMAxisTraverser = new SelfTraverser();
                break;
            }
            case 16: {
                dTMAxisTraverser = new AllFromRootTraverser();
                break;
            }
            case 14: {
                dTMAxisTraverser = new AllFromNodeTraverser();
                break;
            }
            case 15: {
                dTMAxisTraverser = new PrecedingAndAncestorTraverser();
                break;
            }
            case 17: {
                dTMAxisTraverser = new DescendantFromRootTraverser();
                break;
            }
            case 18: {
                dTMAxisTraverser = new DescendantOrSelfFromRootTraverser();
                break;
            }
            case 19: {
                dTMAxisTraverser = new RootTraverser();
                break;
            }
            case 20: {
                return null;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(168, new Object[]{Integer.toString(n2)}));
            }
        }
        if (null == dTMAxisTraverser) {
            throw new DTMException("Axis traverser not supported: " + Axis.names[n2]);
        }
        this.m_traversers[n2] = dTMAxisTraverser;
        return dTMAxisTraverser;
    }

    private class DescendantFromRootTraverser
    extends DescendantTraverser {
        private DescendantFromRootTraverser() {
        }

        protected int getFirstPotential(int n2) {
            return DTMDefaultBaseTraversers.this._firstch(0);
        }

        protected int getSubtreeRoot(int n2) {
            return 0;
        }

        public int first(int n2) {
            return DTMDefaultBaseTraversers.this._firstch(0) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class DescendantOrSelfFromRootTraverser
    extends DescendantTraverser {
        private DescendantOrSelfFromRootTraverser() {
        }

        protected int getFirstPotential(int n2) {
            return n2;
        }

        protected int getSubtreeRoot(int n2) {
            return DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF;
        }

        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }
    }

    private class RootTraverser
    extends AllFromRootTraverser {
        private RootTraverser() {
        }

        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }
    }

    private class AllFromRootTraverser
    extends AllFromNodeTraverser {
        private AllFromRootTraverser() {
        }

        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.getDocument();
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(DTMDefaultBaseTraversers.this.getDocument() & 0x3FFFFF) == n3 ? n2 : this.next(n2, n2, n3);
        }

        public int next(int n2, int n3) {
            int n4 = n2 & 0x3FFFFF;
            short s2 = DTMDefaultBaseTraversers.this._type(n3 = (n3 & 0x3FFFFF) + 1);
            if (s2 == -1) {
                return -1;
            }
            return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) + 1;
            int n6;
            while ((n6 = DTMDefaultBaseTraversers.this._exptype(n3)) != -1) {
                if (n6 == n4) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n3;
            }
            return -1;
        }
    }

    private class SelfTraverser
    extends DTMAxisTraverser {
        private SelfTraverser() {
        }

        public int first(int n2) {
            return n2;
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2 & 0x3FFFFF) == n3 ? n2 : -1;
        }

        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }
    }

    private class PrecedingSiblingTraverser
    extends DTMAxisTraverser {
        private PrecedingSiblingTraverser() {
        }

        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getPreviousSibling(n3);
        }

        public int next(int n2, int n3, int n4) {
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.getPreviousSibling(n3))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3 & 0x3FFFFF) != n4) continue;
                return n3;
            }
            return -1;
        }
    }

    private class PrecedingAndAncestorTraverser
    extends DTMAxisTraverser {
        private PrecedingAndAncestorTraverser() {
        }

        public int next(int n2, int n3) {
            int n4 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) - 1;
            while (n3 >= 0) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                short s2 = ExpandedNameTable.getType(n5);
                if (2 != s2 && 13 != s2) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n3;
            }
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) - 1;
            while (n3 >= 0) {
                int n6 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                short s2 = ExpandedNameTable.getType(n6);
                if (n6 == n4) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n3;
            }
            return -1;
        }
    }

    private class PrecedingTraverser
    extends DTMAxisTraverser {
        private PrecedingTraverser() {
        }

        protected boolean isAncestor(int n2, int n3) {
            n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2);
            while (-1 != n2) {
                if (n2 == n3) {
                    return true;
                }
                n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2);
            }
            return false;
        }

        public int next(int n2, int n3) {
            int n4 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) - 1;
            while (n3 >= 0) {
                int n5 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                short s2 = ExpandedNameTable.getType(n5);
                if (2 != s2 && 13 != s2 && !this.isAncestor(n4, n3)) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n3;
            }
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) - 1;
            while (n3 >= 0) {
                int n6 = DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3);
                short s2 = ExpandedNameTable.getType(n6);
                if (n6 == n4 && !this.isAncestor(n5, n3)) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                --n3;
            }
            return -1;
        }
    }

    private class ParentTraverser
    extends DTMAxisTraverser {
        private ParentTraverser() {
        }

        public int first(int n2) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(n2 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int n2, int n3) {
            n2 &= 0x3FFFFF;
            while (-1 != (n2 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n2))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2) != n3) continue;
                return n2 | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }

        public int next(int n2, int n3) {
            return -1;
        }

        public int next(int n2, int n3, int n4) {
            return -1;
        }
    }

    private class NamespaceTraverser
    extends DTMAxisTraverser {
        private NamespaceTraverser() {
        }

        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, true) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, true)));
            return -1;
        }
    }

    private class NamespaceDeclsTraverser
    extends DTMAxisTraverser {
        private NamespaceDeclsTraverser() {
        }

        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstNamespaceNode(n2, false) : DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextNamespaceNode(n2, n3, false)));
            return -1;
        }
    }

    private class FollowingSiblingTraverser
    extends DTMAxisTraverser {
        private FollowingSiblingTraverser() {
        }

        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.getNextSibling(n3);
        }

        public int next(int n2, int n3, int n4) {
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextSibling(n3))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3 & 0x3FFFFF) != n4) continue;
                return n3;
            }
            return -1;
        }
    }

    private class FollowingTraverser
    extends DescendantTraverser {
        private FollowingTraverser() {
        }

        public int first(int n2) {
            int n3;
            short s2 = DTMDefaultBaseTraversers.this._type(n2);
            if ((2 == s2 || 13 == s2) && -1 != (n3 = DTMDefaultBaseTraversers.this.getFirstChild(n2 = DTMDefaultBaseTraversers.this.getParent(n2)))) {
                return n3;
            }
            do {
                if (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextSibling(n2))) continue;
                n2 = DTMDefaultBaseTraversers.this.getParent(n2);
            } while (-1 == n3 && -1 != n2);
            return n3;
        }

        public int first(int n2, int n3) {
            int n4;
            short s2 = DTMDefaultBaseTraversers.this._type(n2);
            if ((2 == s2 || 13 == s2) && -1 != (n4 = DTMDefaultBaseTraversers.this.getFirstChild(n2 = DTMDefaultBaseTraversers.this.getParent(n2)))) {
                if (DTMDefaultBaseTraversers.this._exptype(n4) == n3) {
                    return n4;
                }
                return this.next(n2, n4, n3);
            }
            do {
                if (-1 != (n4 = DTMDefaultBaseTraversers.this.getNextSibling(n2))) {
                    if (DTMDefaultBaseTraversers.this._exptype(n4) == n3) {
                        return n4;
                    }
                    return this.next(n2, n4, n3);
                }
                n2 = DTMDefaultBaseTraversers.this.getParent(n2);
            } while (-1 == n4 && -1 != n2);
            return n4;
        }

        public int next(int n2, int n3) {
            short s2;
            do {
                if (-1 != (s2 = DTMDefaultBaseTraversers.this._type(++n3))) continue;
                return -1;
            } while (2 == s2 || 13 == s2);
            return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n2, int n3, int n4) {
            int n5;
            do {
                if (-1 != (n5 = DTMDefaultBaseTraversers.this._exptype(++n3))) continue;
                return -1;
            } while (n5 != n4);
            return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class AllFromNodeTraverser
    extends DescendantOrSelfTraverser {
        private AllFromNodeTraverser() {
        }

        public int next(int n2, int n3) {
            int n4 = n2 & 0x3FFFFF;
            n3 = (n3 & 0x3FFFFF) + 1;
            DTMDefaultBaseTraversers.this._exptype(n3);
            if (!this.isDescendant(n4, n3)) {
                return -1;
            }
            return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }
    }

    private class DescendantOrSelfTraverser
    extends DescendantTraverser {
        private DescendantOrSelfTraverser() {
        }

        protected int getFirstPotential(int n2) {
            return n2;
        }

        public int first(int n2) {
            return n2;
        }
    }

    private class DescendantTraverser
    extends IndexedDTMAxisTraverser {
        private DescendantTraverser() {
        }

        protected int getFirstPotential(int n2) {
            return n2 + 1;
        }

        protected boolean axisHasBeenProcessed(int n2) {
            return DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n2) != -2;
        }

        protected int getSubtreeRoot(int n2) {
            return n2 & 0x3FFFFF;
        }

        protected boolean isDescendant(int n2, int n3) {
            return DTMDefaultBaseTraversers.this._parent(n3) >= n2;
        }

        protected boolean isAfterAxis(int n2, int n3) {
            do {
                if (n3 != n2) continue;
                return false;
            } while ((n3 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n3)) >= n2);
            return true;
        }

        public int first(int n2, int n3) {
            if (this.isIndexed(n3)) {
                int n4 = this.getSubtreeRoot(n2);
                int n5 = this.getFirstPotential(n4);
                return this.getNextIndexed(n4, n5, n3) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return this.next(n2, n2, n3);
        }

        public int next(int n2, int n3) {
            int n4 = this.getSubtreeRoot(n2);
            n3 = (n3 & 0x3FFFFF) + 1;
            while (true) {
                short s2 = DTMDefaultBaseTraversers.this._type(n3);
                if (!this.isDescendant(n4, n3)) {
                    return -1;
                }
                if (2 != s2 && 13 != s2) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n3;
            }
        }

        public int next(int n2, int n3, int n4) {
            int n5 = this.getSubtreeRoot(n2);
            n3 = (n3 & 0x3FFFFF) + 1;
            if (this.isIndexed(n4)) {
                return this.getNextIndexed(n5, n3, n4) | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            while (true) {
                int n6 = DTMDefaultBaseTraversers.this._exptype(n3);
                if (!this.isDescendant(n5, n3)) {
                    return -1;
                }
                if (n6 == n4) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                ++n3;
            }
        }
    }

    private abstract class IndexedDTMAxisTraverser
    extends DTMAxisTraverser {
        private IndexedDTMAxisTraverser() {
        }

        protected final boolean isIndexed(int n2) {
            return DTMDefaultBaseTraversers.this.m_indexing && ExpandedNameTable.ELEMENT == (n2 & ExpandedNameTable.MASK_NODETYPE);
        }

        protected abstract boolean isAfterAxis(int var1, int var2);

        protected abstract boolean axisHasBeenProcessed(int var1);

        protected int getNextIndexed(int n2, int n3, int n4) {
            int n5 = ExpandedNameTable.getNamespaceID(n4);
            int n6 = ExpandedNameTable.getLocalNameID(n4);
            while (true) {
                int n7;
                if (-2 != (n7 = DTMDefaultBaseTraversers.this.findElementFromIndex(n5, n6, n3))) {
                    if (this.isAfterAxis(n2, n7)) {
                        return -1;
                    }
                    return n7;
                }
                if (this.axisHasBeenProcessed(n2)) break;
                DTMDefaultBaseTraversers.this.nextNode();
            }
            return -1;
        }
    }

    private class ChildTraverser
    extends DTMAxisTraverser {
        private ChildTraverser() {
        }

        protected int getNextIndexed(int n2, int n3, int n4) {
            int n5 = ExpandedNameTable.getNamespaceID(n4);
            int n6 = ExpandedNameTable.getLocalNameID(n4);
            while (true) {
                int n7;
                if (-2 != (n7 = DTMDefaultBaseTraversers.this.findElementFromIndex(n5, n6, n3))) {
                    int n8 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n7);
                    if (n8 == n2) {
                        return n7;
                    }
                    if (n8 < n2) {
                        return -1;
                    }
                    do {
                        if ((n8 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n8)) >= n2) continue;
                        return -1;
                    } while (n8 > n2);
                    n3 = n7 + 1;
                    continue;
                }
                DTMDefaultBaseTraversers.this.nextNode();
                if (DTMDefaultBaseTraversers.this.m_nextsib.elementAt(n2) != -2) break;
            }
            return -1;
        }

        public int first(int n2) {
            return DTMDefaultBaseTraversers.this._firstch(n2 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int first(int n2, int n3) {
            int n4 = n2 & 0x3FFFFF;
            int n5 = this.getNextIndexed(n4, DTMDefaultBaseTraversers.this._firstch(n4), n3);
            return n5 | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this._nextsib(n3 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n2, int n3, int n4) {
            n3 = DTMDefaultBaseTraversers.this._nextsib(n3 & 0x3FFFFF);
            while (-1 != n3) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) == n4) {
                    return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
                }
                n3 = DTMDefaultBaseTraversers.this._nextsib(n3);
            }
            return -1;
        }
    }

    private class AttributeTraverser
    extends DTMAxisTraverser {
        private AttributeTraverser() {
        }

        public int next(int n2, int n3) {
            return n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n2) : DTMDefaultBaseTraversers.this.getNextAttribute(n3);
        }

        public int next(int n2, int n3, int n4) {
            int n5 = n3 = n2 == n3 ? DTMDefaultBaseTraversers.this.getFirstAttribute(n2) : DTMDefaultBaseTraversers.this.getNextAttribute(n3);
            do {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) != n4) continue;
                return n3;
            } while (-1 != (n3 = DTMDefaultBaseTraversers.this.getNextAttribute(n3)));
            return -1;
        }
    }

    private class AncestorOrSelfTraverser
    extends AncestorTraverser {
        private AncestorOrSelfTraverser() {
        }

        public int first(int n2) {
            return n2;
        }

        public int first(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.m_exptype.elementAt(n2 & 0x3FFFFF) == n3 ? n2 : this.next(n2, n2, n3);
        }
    }

    private class AncestorTraverser
    extends DTMAxisTraverser {
        private AncestorTraverser() {
        }

        public int next(int n2, int n3) {
            return DTMDefaultBaseTraversers.this.m_parent.elementAt(n3 & 0x3FFFFF) | DTMDefaultBaseTraversers.this.m_dtmIdent;
        }

        public int next(int n2, int n3, int n4) {
            n3 &= 0x3FFFFF;
            while (-1 != (n3 = DTMDefaultBaseTraversers.this.m_parent.elementAt(n3))) {
                if (DTMDefaultBaseTraversers.this.m_exptype.elementAt(n3) != n4) continue;
                return n3 | DTMDefaultBaseTraversers.this.m_dtmIdent;
            }
            return -1;
        }
    }
}

