/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            block4: {
                if (this.directories == null) break block4;
                Vector vector2 = this.directories;
                return vector2;
            }
            Vector vector3 = this.getFiles();
            Vector vector4 = this.directories;
            return vector4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            Serializable serializable;
            block7: {
                if (this.files == null) break block7;
                Vector vector2 = this.files;
                return vector2;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            int n2 = 0;
            while (n2 < this.getSize()) {
                serializable = (File)this.fileCache.get(n2);
                if (this.filechooser.isTraversable((File)serializable)) {
                    this.directories.add(serializable);
                } else {
                    this.files.add(serializable);
                }
                ++n2;
            }
            serializable = this.files;
            return serializable;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            block4: {
                if (!file.renameTo(file2)) break block4;
                this.validateFileCache();
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public Object getElementAt(int n2) {
        return this.fileCache.get(n2);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles(vector);
    }

    protected boolean lt(File file, File file2) {
        int n2 = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n2 != 0) {
            return n2 < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List list, int n2, List list2, int n3, int n4) {
            this.addFiles = list;
            this.addStart = n2;
            this.remFiles = list2;
            this.remStart = n3;
            this.fid = n4;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int n2 = this.remFiles == null ? 0 : this.remFiles.size();
                int n3 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n2 > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n3 > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (n2 > 0 && n3 == 0) {
                    BasicDirectoryModel.super.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + n2 - 1);
                } else if (n3 > 0 && n2 == 0 && BasicDirectoryModel.this.fileCache.size() > n3) {
                    BasicDirectoryModel.super.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + n3 - 1);
                } else {
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File file, int n2) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n2;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        public void run() {
            int n2;
            Serializable serializable;
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            Vector vector = new Vector();
            int n3 = 0;
            while (n3 < fileArray.length) {
                if (BasicDirectoryModel.this.filechooser.accept(fileArray[n3])) {
                    vector.addElement(fileArray[n3]);
                }
                ++n3;
            }
            BasicDirectoryModel.this.sort(vector);
            Vector vector2 = new Vector(50);
            Vector vector3 = new Vector();
            int n4 = 0;
            while (n4 < vector.size()) {
                serializable = (File)vector.elementAt(n4);
                n2 = BasicDirectoryModel.this.filechooser.isTraversable((File)serializable);
                if (n2 != 0) {
                    vector2.addElement(serializable);
                } else if (n2 == 0 && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector3.addElement(serializable);
                }
                if (this.isInterrupted()) {
                    this.cancelRunnables(this.runnables);
                    return;
                }
                ++n4;
            }
            if (this.isInterrupted()) {
                this.cancelRunnables(this.runnables);
                return;
            }
            serializable = new Vector(vector2);
            ((Vector)serializable).addAll(vector3);
            n2 = ((Vector)serializable).size();
            int n5 = BasicDirectoryModel.this.fileCache.size();
            if (n2 > n5) {
                int n6 = n5;
                int n7 = n2;
                int n8 = 0;
                block2: while (n8 < n5) {
                    if (!((Vector)serializable).get(n8).equals(BasicDirectoryModel.this.fileCache.get(n8))) {
                        n6 = n8;
                        int n9 = n8;
                        while (n9 < n2) {
                            if (((Vector)serializable).get(n9).equals(BasicDirectoryModel.this.fileCache.get(n8))) {
                                n7 = n9;
                                break block2;
                            }
                            ++n9;
                        }
                        break;
                    }
                    ++n8;
                }
                if (n6 >= 0 && n7 > n6 && ((Vector)serializable).subList(n7, n2).equals(BasicDirectoryModel.this.fileCache.subList(n6, n5))) {
                    this.invokeLater(new DoChangeContents(((Vector)serializable).subList(n6, n7), n6, null, 0, this.fid));
                    return;
                }
            } else if (n2 < n5) {
                int n10 = -1;
                int n11 = -1;
                int n12 = 0;
                while (n12 < n2) {
                    if (!((Vector)serializable).get(n12).equals(BasicDirectoryModel.this.fileCache.get(n12))) {
                        n10 = n12;
                        n11 = n12 + n5 - n2;
                        break;
                    }
                    ++n12;
                }
                if (n10 >= 0 && n11 > n10 && BasicDirectoryModel.this.fileCache.subList(n11, n5).equals(((Vector)serializable).subList(n10, n2))) {
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(BasicDirectoryModel.this.fileCache.subList(n10, n11)), n10, this.fid));
                    return;
                }
            }
            if (!BasicDirectoryModel.this.fileCache.equals(serializable)) {
                this.invokeLater(new DoChangeContents((List)((Object)serializable), 0, BasicDirectoryModel.this.fileCache, 0, this.fid));
            }
        }

        public void cancelRunnables(Vector vector) {
            int n2 = 0;
            while (n2 < vector.size()) {
                ((DoChangeContents)vector.elementAt(n2)).cancel();
                ++n2;
            }
        }
    }
}

