/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    private static Vector framesCache;
    private NavigateAction nextAction;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.desktop, actionMap);
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void unregisterKeyboardActions() {
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        if (n2 == 1) {
            return (InputMap)UIManager.get("Desktop.ancestorInputMap");
        }
        return null;
    }

    InputMap createInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("restore", new OpenAction());
        actionMapUIResource.put("close", new CloseAction());
        actionMapUIResource.put("move", new MoveResizeAction("move"));
        actionMapUIResource.put("resize", new MoveResizeAction("resize"));
        actionMapUIResource.put("left", new MoveResizeAction("left"));
        actionMapUIResource.put("shrinkLeft", new MoveResizeAction("shrinkLeft"));
        actionMapUIResource.put("right", new MoveResizeAction("right"));
        actionMapUIResource.put("shrinkRight", new MoveResizeAction("shrinkRight"));
        actionMapUIResource.put("up", new MoveResizeAction("up"));
        actionMapUIResource.put("shrinkUp", new MoveResizeAction("shrinkUp"));
        actionMapUIResource.put("down", new MoveResizeAction("down"));
        actionMapUIResource.put("shrinkDown", new MoveResizeAction("shrinkDown"));
        actionMapUIResource.put("escape", new MoveResizeAction("escape"));
        actionMapUIResource.put("minimize", new MinimizeAction());
        actionMapUIResource.put("maximize", new MaximizeAction());
        this.nextAction = new NavigateAction();
        actionMapUIResource.put("selectNextFrame", this.nextAction);
        actionMapUIResource.put("selectPreviousFrame", new PreviousAction());
        actionMapUIResource.put("navigateNext", new NavigateOutAction(true));
        actionMapUIResource.put("navigatePrevious", new NavigateOutAction(false));
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    private void verifyFramesCache() {
        Object object;
        if (framesCache == null) {
            framesCache = new Vector();
        }
        boolean bl2 = false;
        int n2 = framesCache.size();
        int n3 = 0;
        while (n3 < n2) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            object = (JComponent)framesCache.elementAt(n3);
            if (object instanceof JInternalFrame) {
                jComponent = (JInternalFrame)object;
                if (((JInternalFrame)jComponent).isClosed()) {
                    bl2 = true;
                    break;
                }
            } else if (object instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)object)).getInternalFrame()).isClosed()) {
                bl2 = true;
                break;
            }
            ++n3;
        }
        object = this.desktop.getAllFrames();
        if (bl2 || ((JInternalFrame[])object).length != framesCache.size()) {
            int n4;
            framesCache.clear();
            int n5 = this.desktop.lowestLayer();
            int n6 = n4 = this.desktop.highestLayer();
            while (n6 >= n5) {
                Component[] componentArray = this.desktop.getComponentsInLayer(n6);
                if (componentArray.length > 0) {
                    int n7 = 0;
                    while (n7 < componentArray.length) {
                        framesCache.addElement(componentArray[n7]);
                        ++n7;
                    }
                }
                --n6;
            }
        }
    }

    private class NavigateOutAction
    extends AbstractAction {
        private boolean moveForward;

        public NavigateOutAction(boolean bl2) {
            this.moveForward = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy;
            Container container = BasicDesktopPaneUI.this.desktop.getFocusCycleRootAncestor();
            if (container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                boolean bl2 = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                try {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                    if (this.moveForward) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(BasicDesktopPaneUI.this.desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(BasicDesktopPaneUI.this.desktop);
                    }
                    Object var7_6 = null;
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl2);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl2);
                    throw throwable;
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            BasicDesktopPaneUI.this.verifyFramesCache();
            if (framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = framesCache.indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (--n2 == -1) {
                n2 = framesCache.size() - 1;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        protected NavigateAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            BasicDesktopPaneUI.this.verifyFramesCache();
            if (framesCache.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = framesCache.indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = framesCache.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (++n2 == framesCache.size()) {
                n2 = 0;
            }
            if ((jComponent = (JComponent)framesCache.elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame((JInternalFrame)jComponent);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                    BasicDesktopPaneUI.this.desktopManager.activateFrame(((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        protected MaximizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isMaximizable() && !jInternalFrame.isMaximum()) {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        protected MinimizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isIconifiable() && !jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;

        public MoveResizeAction(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if ("move".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = true;
                BasicDesktopPaneUI.this.resizing = false;
                return;
            }
            if ("resize".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = false;
                BasicDesktopPaneUI.this.resizing = true;
                return;
            }
            if ("escape".equals(this.command)) {
                BasicDesktopPaneUI.this.moving = (BasicDesktopPaneUI.this.resizing = false);
                return;
            }
            if (!BasicDesktopPaneUI.this.moving && !BasicDesktopPaneUI.this.resizing) {
                return;
            }
            Dimension dimension = jInternalFrame.getSize();
            Dimension dimension2 = jInternalFrame.getMinimumSize();
            Point point = jInternalFrame.getLocation();
            if ("left".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("right".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("up".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (BasicDesktopPaneUI.this.moving) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (BasicDesktopPaneUI.this.resizing) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("shrinkLeft".equals(this.command) && BasicDesktopPaneUI.this.resizing) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkRight".equals(this.command) && BasicDesktopPaneUI.this.resizing) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setLocation(point.x - dimension2.width + dimension.width, point.y);
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkUp".equals(this.command) && BasicDesktopPaneUI.this.resizing) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            } else if ("shrinkDown".equals(this.command) && BasicDesktopPaneUI.this.resizing) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setLocation(point.x, point.y - dimension2.height + dimension.height);
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class CloseAction
    extends AbstractAction {
        protected CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isClosable()) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        protected OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = BasicDesktopPaneUI.this.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            try {
                if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                } else if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                }
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

