/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectDoubleBufferRU;
import java.nio.DoubleBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferU
extends DoubleBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$nio$DirectDoubleBufferU;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectDoubleBufferU(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 3, directByteBuffer.remaining() >> 3);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectDoubleBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public DoubleBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 3;
        return new DirectDoubleBufferU(this, -1, 0, n4, n4, n5);
    }

    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new DirectDoubleBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 3);
    }

    public double get() {
        return unsafe.getDouble(this.ix(this.nextGetIndex()));
    }

    public double get(int n2) {
        return unsafe.getDouble(this.ix(this.checkIndex(n2)));
    }

    public DoubleBuffer get(double[] dArray, int n2, int n3) {
        if (n3 << 3 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, dArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToDoubleArray(this.ix(n5), dArray, n2 << 3, n3 << 3);
            } else {
                Bits.copyToByteArray(this.ix(n5), dArray, n2 << 3, n3 << 3);
            }
            this.position(n5 + n3);
        } else {
            super.get(dArray, n2, n3);
        }
        return this;
    }

    public DoubleBuffer put(double d2) {
        unsafe.putDouble(this.ix(this.nextPutIndex()), d2);
        return this;
    }

    public DoubleBuffer put(int n2, double d2) {
        unsafe.putDouble(this.ix(this.checkIndex(n2)), d2);
        return this;
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof DirectDoubleBufferU) {
            int n2;
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectDoubleBufferU directDoubleBufferU = (DirectDoubleBufferU)doubleBuffer;
            int n3 = directDoubleBufferU.position();
            int n4 = directDoubleBufferU.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directDoubleBufferU.ix(n3), this.ix(n6), n5 << 3);
            directDoubleBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    public DoubleBuffer put(double[] dArray, int n2, int n3) {
        if (n3 << 3 > 6) {
            int n4;
            Buffer.checkBounds(n2, n3, dArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromDoubleArray(dArray, n2 << 3, this.ix(n5), n3 << 3);
            } else {
                Bits.copyFromByteArray(dArray, n2 << 3, this.ix(n5), n3 << 3);
            }
            this.position(n5 + n3);
        } else {
            super.put(dArray, n2, n3);
        }
        return this;
    }

    public DoubleBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 3);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectDoubleBufferU == null ? (class$java$nio$DirectDoubleBufferU = DirectDoubleBufferU.class$("java.nio.DirectDoubleBufferU")) : class$java$nio$DirectDoubleBufferU).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }
}

