/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import javax.naming.CommunicationException;
import javax.naming.NamingException;

class Header {
    static final int HEADER_SIZE = 12;
    int xid;
    boolean query;
    int opcode;
    boolean authoritative;
    boolean truncated;
    boolean recursionDesired;
    boolean recursionAvail;
    int rcode;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;

    Header(byte[] byArray, int n2) throws NamingException {
        this.decode(byArray, n2);
    }

    private void decode(byte[] byArray, int n2) throws NamingException {
        try {
            int n3 = 0;
            if (n2 < 12) {
                throw new CommunicationException("DNS error: corrupted message header");
            }
            this.xid = Header.getShort(byArray, n3);
            int n4 = Header.getShort(byArray, n3 += 2);
            n3 += 2;
            this.query = (n4 & 0x8000) == 0;
            this.opcode = (n4 & 0x7800) >> 11;
            this.authoritative = (n4 & 0x400) != 0;
            this.truncated = (n4 & 0x200) != 0;
            this.recursionDesired = (n4 & 0x100) != 0;
            this.recursionAvail = (n4 & 0x80) != 0;
            this.rcode = n4 & 0xF;
            this.numQuestions = Header.getShort(byArray, n3);
            this.numAnswers = Header.getShort(byArray, n3 += 2);
            this.numAuthorities = Header.getShort(byArray, n3 += 2);
            this.numAdditionals = Header.getShort(byArray, n3 += 2);
            n3 += 2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CommunicationException("DNS error: corrupted message header");
        }
    }

    private static int getShort(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }
}

