/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.ConnectionTable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class ListenerThread
extends Thread {
    protected static final int MAX_CLEANUP_RETRIES = 5;
    protected ServerSocket serverSocket;
    protected ConnectionTable connectionTable;
    protected String socketType;
    private boolean keepRunning = true;

    ListenerThread(ConnectionTable connectionTable, ThreadGroup threadGroup, ServerSocket serverSocket, String string) {
        super(threadGroup, "JavaIDL Listener");
        this.serverSocket = serverSocket;
        this.connectionTable = connectionTable;
        this.socketType = string;
    }

    public ListenerThread(ConnectionTable connectionTable, ServerSocket serverSocket, String string) {
        super("JavaIDL Listener");
        this.serverSocket = serverSocket;
        this.connectionTable = connectionTable;
        this.socketType = string;
    }

    public ServerSocket getSocket() {
        return this.serverSocket;
    }

    public void run() {
        int n2 = 0;
        while (this.keepRunning) {
            try {
                Socket socket = this.serverSocket.accept();
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Connection connection = this.connectionTable.getConnection(socket, this.socketType);
                n2 = 0;
                this.connectionTable.checkConnectionTable();
            }
            catch (SocketException socketException) {
                if (n2 == 5 || !this.connectionTable.cleanUp()) continue;
                ++n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized void shutdown() {
        this.keepRunning = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

