/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_au;
import com.sun.net.ssl.internal.ssl.SunJSSE_av;
import com.sun.net.ssl.internal.ssl.SunJSSE_e;
import com.sun.net.ssl.internal.ssl.SunJSSE_l;
import com.sun.net.ssl.internal.ssl.SunJSSE_m;
import com.sun.net.ssl.internal.ssl.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.SunJSSE_o;
import com.sun.net.ssl.internal.ssl.SunJSSE_q;
import com.sun.net.ssl.internal.ssl.SunJSSE_s;
import com.sun.net.ssl.internal.ssl.SunJSSE_t;
import com.sun.net.ssl.internal.ssl.SunJSSE_u;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

final class ServerHandshaker
extends Handshaker {
    private byte a;
    private boolean b = false;
    private X509Certificate[] c;
    private PrivateKey d;
    private boolean e = false;
    private PrivateKey f;
    private RSAPublicKey g;
    private SunJSSE_au h;

    private boolean b(boolean bl) {
        Object var2_2 = null;
        try {
            int n = !bl ? 1024 : 512;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n, ((Handshaker)this).g.a());
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.g = (RSAPublicKey)keyPair.getPublic();
            this.f = keyPair.getPrivate();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void c(boolean bl) {
        if (!bl) {
            this.h = new SunJSSE_au();
            this.h.a(((Handshaker)this).g.a(), 768);
        } else {
            this.h = new SunJSSE_au(SunJSSE_au.i, SunJSSE_au.j);
            this.h.a(((Handshaker)this).g.a(), 512);
        }
    }

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, byte by) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, by != 0);
        this.a = by;
    }

    void a(byte by) {
        this.a = by;
    }

    SunJSSE_e c() throws NoSuchAlgorithmException {
        return this.aa.a(this.n, this.p, true);
    }

    MAC d() throws NoSuchAlgorithmException {
        return this.ae.newMAC(this.r);
    }

    SunJSSE_e e() throws NoSuchAlgorithmException {
        return this.aa.a(this.m, this.o, false);
    }

    MAC f() throws NoSuchAlgorithmException {
        return this.ae.newMAC(this.q);
    }

    boolean a(int n, boolean bl) {
        if (this.k) {
            return true;
        }
        X509KeyManager x509KeyManager = ((Handshaker)this).g.b();
        if (n == 1 || n == 2 || n == 5) {
            String string = x509KeyManager.chooseServerAlias("RSA", null, ((Handshaker)this).a);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.c[0].getPublicKey();
            if (n == 2 && rSAPublicKey.getModulus().bitLength() > 512 && !this.b(bl)) {
                return false;
            }
            if (n == 5) {
                this.c(bl);
            }
            return this.d != null && this.d instanceof RSAPrivateKey;
        }
        if (n == 6) {
            String string = x509KeyManager.chooseServerAlias("DSA", null, ((Handshaker)this).a);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            this.c(bl);
            return this.d != null;
        }
        if (n == 7) {
            this.c(bl);
            return true;
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        if (string.startsWith("SSL_RSA_")) {
            return this.a(1, false);
        }
        if (string.startsWith("SSL_DH_anon_")) {
            return this.a(7, false);
        }
        if (string.startsWith("SSL_DHE_DSS_")) {
            return this.a(6, false);
        }
        return false;
    }

    protected void processMessage(byte by, int n) throws IOException, NoSuchAlgorithmException {
        if (((Handshaker)this).f > by && ((Handshaker)this).f != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + ((Handshaker)this).f + ", type = " + by);
        }
        switch (by) {
            case 1: {
                ((Handshaker)this).d.mark(n);
                SunJSSE_n sunJSSE_n = new SunJSSE_n(((Handshaker)this).d);
                ((Handshaker)this).d.reset();
                ((Handshaker)this).d.skip(n);
                this.a(sunJSSE_n);
                break;
            }
            case 11: {
                if (this.a == 0) {
                    ((Handshaker)this).a.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                break;
            }
            case 16: {
                byte[] byArray;
                switch (((CipherSpec)this).q) {
                    case 1: 
                    case 2: {
                        byArray = this.a(new SunJSSE_av(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).g.a(), ((Handshaker)this).d, n, this.d));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byArray = this.a(new ClientDiffieHellmanPublic(((Handshaker)this).d));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("unsupported key exchange algorithm = " + ((CipherSpec)this).q);
                    }
                }
                this.a(byArray);
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = 0;
                    ++n2;
                }
                break;
            }
            case 15: {
                this.a(new SunJSSE_u(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (((Handshaker)this).f < by && by != 15) {
            ((Handshaker)this).f = by;
        }
    }

    private void a(SunJSSE_n sunJSSE_n) throws IOException {
        Object object;
        Object object2;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_n.a(System.out);
        }
        ((Handshaker)this).d.a();
        SunJSSE_o sunJSSE_o = new SunJSSE_o();
        if (sunJSSE_n.a != 3) {
            throw new SSLProtocolException("version mismatch, client is v" + sunJSSE_n.a + "." + sunJSSE_n.b);
        }
        sunJSSE_o.a = (byte)3;
        ((CipherSpec)this).a = sunJSSE_n.a;
        sunJSSE_o.b = sunJSSE_n.b > ((CipherSpec)this).b ? ((CipherSpec)this).b : sunJSSE_n.b;
        ((CipherSpec)this).b = sunJSSE_o.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).h = sunJSSE_n.d;
        sunJSSE_o.d = this.i = new SunJSSE_l(((Handshaker)this).g.a());
        if (sunJSSE_n.e.a() != 0) {
            if (this.j != null && !this.b && !sunJSSE_n.e.equals(this.j.d())) {
                throw new SSLException("Client cannot change existing session");
            }
            this.j = null;
            object2 = ((SSLSessionContextImpl)((Handshaker)this).g.engineGetServerSessionContext()).a(sunJSSE_n.e.b());
            if (object2 != null) {
                object = ((SSLSessionImpl)object2).e().getCipherSuite();
                this.k = ((SSLSessionImpl)object2).b();
                if (this.k) {
                    this.k = this.a(sunJSSE_n, (byte[])object);
                }
                if (this.k && this.a != 0) {
                    try {
                        ((SSLSessionImpl)object2).getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        this.k = false;
                    }
                }
                if (this.k) {
                    this.j = object2;
                    if (Handshaker.s != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                        System.out.println("%% Resuming " + this.j);
                    }
                }
            }
        } else {
            if (this.j != null && !this.b) {
                throw new SSLException("Client cannot change existing session");
            }
            this.j = null;
        }
        if (this.j == null) {
            if (!this.l) {
                throw new SSLException("Client did not resume a session");
            }
            this.j = new SSLSessionImpl((CipherSpec)this, ((Handshaker)this).g.a(), ((Handshaker)this).a.getInetAddress().getHostAddress(), ((Handshaker)this).a.getPort());
            this.b(sunJSSE_n);
        }
        sunJSSE_o.f = this.j.e().getCipherSuite();
        sunJSSE_o.e = this.j.d();
        sunJSSE_o.g = this.j.f();
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_o.a(System.out);
            System.out.println("Cipher suite:  " + this.j.e());
        }
        sunJSSE_o.write(((Handshaker)this).e);
        if (this.k) {
            try {
                this.b(this.j.a());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
            this.d(true);
            return;
        }
        if (((CipherSpec)this).q != 7) {
            if (this.c == null) {
                throw new SSLException("internal error, no certs!");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.c);
            this.j.b(this.c);
            if (Handshaker.s != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateMsg)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(((Handshaker)this).e);
        }
        boolean bl = false;
        if (this.c == null) {
            bl = true;
        } else {
            switch (((CipherSpec)this).q) {
                case 1: 
                case 2: {
                    if (((CipherSpec)this).q != 2 || ((RSAPrivateKey)this.d).getModulus().bitLength() <= 512) break;
                    bl = true;
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bl = true;
                    break;
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + ((CipherSpec)this).q);
                }
            }
        }
        if (bl) {
            switch (((CipherSpec)this).q) {
                case 1: 
                case 2: {
                    try {
                        if (this.c == null) {
                            throw new SSLException("Anonymous RSA not supported");
                        }
                        object = new SunJSSE_q(this.g, this.d, ((Handshaker)this).h, this.i, ((Handshaker)this).g.a());
                        this.d = this.f;
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA key, " + invalidKeyException);
                    }
                }
                case 7: {
                    object = new HandshakeMessage.DH_ServerKeyExchange(this.h);
                    break;
                }
                case 5: 
                case 6: {
                    try {
                        object = new HandshakeMessage.DH_ServerKeyExchange(this.h, this.d, ((Handshaker)this).h.a, this.i.a, ((Handshaker)this).g.a());
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA or DSS key, " + invalidKeyException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + ((CipherSpec)this).q);
                }
            }
            if (Handshaker.s != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        if (this.a != 0 && ((CipherSpec)this).q != 7) {
            X509Certificate[] x509CertificateArray = ((Handshaker)this).g.c().getAcceptedIssuers();
            object = new SunJSSE_s(x509CertificateArray, ((CipherSpec)this).q);
            if (Handshaker.s != null && Debug.isOn("handshake")) {
                ((SunJSSE_s)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        object = new SunJSSE_t();
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            ((SunJSSE_t)object).a(System.out);
        }
        ((HandshakeMessage)object).write(((Handshaker)this).e);
        ((Handshaker)this).e.flush();
    }

    private boolean a(SunJSSE_n sunJSSE_n, byte[] byArray) {
        boolean bl = false;
        int n = 0;
        while (n < sunJSSE_n.f.length) {
            if (byArray[0] == sunJSSE_n.f[n] && byArray[1] == sunJSSE_n.f[n + 1]) break;
            n += 2;
        }
        if (n < sunJSSE_n.f.length) {
            bl = this.a(byArray[0], byArray[1]);
        }
        return bl;
    }

    private void b(SunJSSE_n sunJSSE_n) throws IOException {
        int n = 0;
        while (n < sunJSSE_n.f.length) {
            if (this.a(sunJSSE_n.f[n], sunJSSE_n.f[n + 1]) && (this.a != 2 || ((CipherSpec)this).q != 7)) break;
            n += 2;
        }
        if (n >= sunJSSE_n.f.length) {
            ((Handshaker)this).a.a((byte)40, "no cipher suites in common");
        }
    }

    private byte[] a(SunJSSE_av sunJSSE_av) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_av.a(System.out);
        }
        if (sunJSSE_av.a != ((CipherSpec)this).a || sunJSSE_av.b != ((CipherSpec)this).b) {
            throw new SSLProtocolException("Incorrect RSA Key Exchange");
        }
        return sunJSSE_av.c;
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.a(System.out);
        }
        return this.h.b(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private void a(SunJSSE_u sunJSSE_u) throws IOException {
        boolean bl = false;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_u.a(System.out);
        }
        try {
            PublicKey publicKey = this.j.getPeerCertificates()[0].getPublicKey();
            try {
                bl = sunJSSE_u.a(((CipherSpec)this).b, publicKey, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), this.j.a());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                bl = sunJSSE_u.a(((CipherSpec)this).b, publicKey, ((Handshaker)this).b[2], ((Handshaker)this).c[2], this.j.a());
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ((Handshaker)this).a.a((byte)43, "client cert type is unsupported");
        }
        catch (SignatureException signatureException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        if (!bl) {
            ((Handshaker)this).a.a((byte)42, "client cert didn't verify");
        }
        this.e = false;
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        if (this.a == 2) {
            this.j.getPeerCertificates();
        }
        if (this.e) {
            ((Handshaker)this).a.a((byte)40, "client did not send certificate verify message");
        }
        boolean bl = false;
        try {
            bl = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, this.j.a()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", this.j.a());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, this.j.a()) : finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", this.j.a());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        if (!bl) {
            ((Handshaker)this).a.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.k) {
            ((Handshaker)this).d.a();
            this.d(false);
        }
        this.j.a(System.currentTimeMillis());
        if (!this.k && this.j.b()) {
            ((SSLSessionContextImpl)((Handshaker)this).g.engineGetServerSessionContext()).a(this.j);
            if (Handshaker.s != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.j);
            }
        } else if (!this.k && Handshaker.s != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.j);
        }
    }

    private void d(boolean bl) throws IOException {
        HandshakeMessage.Finished finished;
        block3: {
            ((Handshaker)this).e.flush();
            try {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, this.j.a()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", this.j.a());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, this.j.a()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", this.j.a());
                if (bl && this.k) break block3;
                ((Handshaker)this).b[0] = null;
                ((Handshaker)this).c[0] = null;
            }
        }
        this.sendChangeCipherSpec(finished);
        if (!bl || !this.k) {
            ((Handshaker)this).f = 20;
        }
    }

    protected HandshakeMessage getKickstartMessage() {
        return new SunJSSE_m();
    }

    void b(byte by) throws SSLProtocolException {
        String string = SSLSocketImpl.a(by);
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.a == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            if (this.a == 1) {
                return;
            }
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = ((Handshaker)this).g.c();
        try {
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            String string = publicKey instanceof RSAPublicKey ? "RSA" : (publicKey instanceof DSAPublicKey ? "DSA" : "UNKNOWN");
            x509TrustManager.checkClientTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            ((Handshaker)this).a.a((byte)46, certificateException.getMessage());
        }
        this.e = true;
        this.j.a(x509CertificateArray);
    }
}

