.TH sane\-canon 5 "11 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-canon
.SH NAME
sane\-canon \- SANE backend for Canon SCSI scanners
.SH DESCRIPTION
The
.B sane\-canon
library implements a SANE (Scanner Access Now Easy) backend that
provides access to the following Canon flatbed and film scanners:
.PP
.RS
CanoScan 300
.br
CanoScan 600
.br
CanoScan FB620S
.br
CanoScan FB1200S
.br
CanoScan FS2700F
.br
CanoScan FS2710S
.br
.RE
.PP
Parallel port and USB scanners are not supported by this backend; see
the manual pages for
.BR sane\-canon_pp (5)
and
.BR sane\-canon630u (5)
for further information.
.PP
IMPORTANT: This is beta code. We tested the code on the scanners listed
above, using the computers and operating systems available to us, but we
cannot guarantee that the backend will work smoothly with future operating
systems, SCSI adapters, SANE frontend programs, or Canon scanners not
contained in the list above. In some cases your computer might even hang.
It cannot be excluded (although we consider it extremely unlikely) that your
scanner will be damaged.
.PP
That said, TESTERS ARE WELCOME. Send your bug reports and comments to
Manuel Panea
.IR <mpd@rzg.mpg.de> ;
for questions concerning the FB620 and FB1200S contact Mitsuru Okaniwa
.IR <m\-okaniwa@bea.hi\-ho.ne.jp> ,
for the FS2710S Ulrich Deiters
.IR <ukd@xenon.pc.uni\-koeln.de> .

.SH TIPS (FS2700F)
.PP
Scanning either slides or negatives has been found to require rather
large gamma corrections of about 2.2 to 2.4 (same value for red, green,
and blue). It is recommended to use the automatic exposure controls
of the frontend
.BR xsane (1)
for best results.
.PP
The "Auto Focus" function triggers a special pass to determine the focus
value. After that, the real scanning pass takes place.
.PP
Even with "Auto Focus" turned on, the scanned image is often a bit too
blurred. Using the
.BR gimp (1)
to do a "Filter->Enhance->Sharpen" at about 40 to 60 improves the image
considerably.

.SH TIPS (FS2710S)
.PP
Gamma corrections are done not by the scanner, but by the backend.
The scanner is always run in 12-bit mode. In "color" mode the image
data are corrected for gamma, shadow point, etc., and then truncated
to 8-bit intensities; the default gamma value is 2.0. In "raw" mode the
image data are exported without corrections as 16-bit intensities; this
mode can be recommended if extensive adjustments have to be made to a
picture (and if the frontend can handle 16-bit intensities).
.PP
Negatives are handled by simple color inversion and may require manual
removal of blue discoloration.
.PP
.SH FILES
.TP
.I @LIBDIR@/libsane\-canon.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-canon.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_CANON
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend. Higher
debug levels increase the verbosity of the output.

Example:
export SANE_DEBUG_CANON=4

.SH "SEE ALSO"
.BR sane\-scsi (5)
.br
.I http://www.rzg.mpg.de/~mpd/sane/doc/canon.install2700F.txt
(installation of a CanoScan 2700F)
.br
.SH AUTHOR
Helmut Koeberle, Manuel Panea, and Markus Mertinat;
.br
FB620S and FB1200S support by Mitsuru Okaniwa;
.br
FS2710S support by Ulrich Deiters
.br
Man page by Henning Meier-Geinitz (mostly based on canon.README)
