// RUN: %clang_cc1 -enable-16bit-types -fsyntax-only -Wno-unused-value -ffreestanding -verify -HV 2018 %s

// we use -Wno-unused-value because we generate some no-op expressions to yield errors
// without also putting them in a static assertion

// __decltype is the GCC way of saying 'decltype', but doesn't require C++11
// _Static_assert is the C11 way of saying 'static_assert', but doesn't require C++11
#ifdef VERIFY_FXC
#define _Static_assert(a,b,c) ;
#endif

// :FXC_VERIFY_ARGUMENTS: /E plain /T vs_5_1

// To test with the classic compiler, run
// %sdxroot%\tools\x86\fxc.exe /T vs_5_1 scalar-operators.hlsl
// with vs_2_0 (the default) min16float usage produces a complaint that it's not supported

float4 plain(float4 param4 : FOO) : FOO {
    bool        bools       = 0;
    int         ints        = 0;
    uint        uints       = 0;
    dword       dwords      = 0;
    half        halfs       = 0;
    float       floats      = 0;
    double      doubles     = 0;
    min16float  min16floats = 0; /* expected-warning {{min16float is promoted to float16_t}} fxc-pass {{}} */
    min10float  min10floats = 0; // expected-warning {{min10float is promoted to float16_t}} fxc-pass {{}}
    min16int    min16ints   = 0; /* expected-warning {{min16int is promoted to int16_t}} fxc-pass {{}} */
    min12int    min12ints   = 0; // expected-warning {{min12int is promoted to int16_t}} fxc-pass {{}}
    min16uint   min16uints  = 0; /* expected-warning {{min16uint is promoted to uint16_t}} fxc-pass {{}} */
    int16_t     int16_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int16_t'}} fxc-error {{X3000: unrecognized identifier 'int16_ts'}} */
    int32_t     int32_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int32_t'}} fxc-error {{X3000: unrecognized identifier 'int32_ts'}} */
    int64_t     int64_ts    = 0; /* fxc-error {{X3000: unrecognized identifier 'int64_t'}} fxc-error {{X3000: unrecognized identifier 'int64_ts'}} */
    uint16_t    uint16_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint16_t'}} fxc-error {{X3000: unrecognized identifier 'uint16_ts'}} */
    uint32_t    uint32_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint32_t'}} fxc-error {{X3000: unrecognized identifier 'uint32_ts'}} */
    uint64_t    uint64_ts   = 0; /* fxc-error {{X3000: unrecognized identifier 'uint64_t'}} fxc-error {{X3000: unrecognized identifier 'uint64_ts'}} */
    float16_t   float16_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float16_t'}} fxc-error {{X3000: unrecognized identifier 'float16_ts'}} */
    float32_t   float32_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float32_t'}} fxc-error {{X3000: unrecognized identifier 'float32_ts'}} */
    float64_t   float64_ts  = 0; /* fxc-error {{X3000: unrecognized identifier 'float64_t'}} fxc-error {{X3000: unrecognized identifier 'float64_ts'}} */


// To be generated by CodeTags
/* <py>
import re
rxComments = re.compile(r'(//.*|/\*.*?\*\/)')
def strip_comments(line):
    line = rxComments.sub('', line)
    return line.strip()
def save_error_comments(lines):
    saved = {}
    for line in lines:
        key = strip_comments(line)
        if key and line.strip() != key:
            saved[key] = line
    return saved
def restore_error_comments(saved, lines):
    return [saved.get(line.strip(), line) for line in lines]
def modify(lines, newlines):
    return restore_error_comments(save_error_comments(lines), newlines)

primitiveTypes = [
  # type, size, isFloat, isUnsigned, isMinPrec
  ("bool", 1, False, False, False),
  ("int", 32, False, False, False),
  ("uint", 32, False, True, False),
  ("half", 16, True, False, False),
  ("float", 32, True, False, False),
  ("double", 64, True, False, False),
  ("min16float", 16, True, False, True),
  ("min10float", 10, True, False, True),
  ("min16int", 16, False, False, True),
  ("min12int", 12, False, False, True),
  ("min16uint", 16, False, True, True),
  ("int16_t", 16, False, False, False),
  ("int32_t", 32, False, False, False),
  ("int64_t", 64, False, False, False),
  ("uint16_t", 16, False, True, False),
  ("uint32_t", 32, False, True, False),
  ("uint64_t", 64, False, True, False),
  ("float16_t", 16, True, False, False),
  ("float32_t", 32, True, False, False),
  ("float64_t", 64, True, False, False),
]

ArithOperators = [ "+", "-", "/", "%"]

# Comparison
OrderOperators = [ "<", "<=", ">", ">=", ]

LogicalOperators = [ "&&", "||" ]

# Shift
ShiftOperators = [ "<<", ">>" ]

# Bitwise
BitWiseOperators = [ "&", "|", "^" ]

def GetArithOpResultType(operand1, operand2):
    type1, size1, is_float1, unsigned1, isMinPrec1 = operand1
    type2, size2, is_float2, unsigned2, isMinPrec2 = operand2
    rtn_type = type1
    # return float if one of operand is float
    if is_float1 != is_float2:
        rtn_type = type1 if is_float1 else type2
    elif size1 == size2 and isMinPrec1 != isMinPrec2:
        rtn_type = type1 if isMinPrec2 else type2
    else:
        rtn_type = type1 if size1 >= size2 else type2
    # bool operations return int
    rtn_type = "int" if rtn_type == "bool" else rtn_type
    # if one of the operand is unsigned, make unsigned
    if unsigned1 or unsigned2:
        if rtn_type == "int":
            rtn_type = "uint"
        elif rtn_type == "min16int":
            rtn_type = "min16uint"
        elif rtn_type == "int16_t":
            rtn_type = "uint16_t"
        elif rtn_type == "int32_t":
            rtn_type = "uint32_t"
        elif rtn_type == "int64_t":
            rtn_type = "uint64_t"
    return rtn_type

def GetOrderOpResultType(operand1, operand2):
    return "bool"

def GetLogicalOpResultType(operand1, operand2):
    return "bool"

def GetShiftOpResultType(operand1, operand2):
    return "int" if operand1[0] == "bool" else operand1[0]

def GetBitwiseOpResultType(operand1, operand2):
    # ignore bitwise for floats
    if operand1[2] or operand2[2]:
        return operand1[0]
    # otherwise return same type as arithmetic op
    return GetArithOpResultType(operand1, operand2)

def GetOpResultType(operator, operand1, operand2):
    return GetArithOpResultType(operand1, operand2) if operator in ArithOperators else \
          GetOrderOpResultType(operand1, operand2) if operator in OrderOperators else \
          GetLogicalOpResultType(operand1, operand2)

def GenerateBitWiseStatement(operator, operand1, operand2):
    result_type = GetBitwiseOpResultType(operand1, operand2) if operator in BitWiseOperators else \
                  GetShiftOpResultType(operand1, operand2)
    # is_float
    if operand1[2] or operand2[2]:
        return "{0}s = ({1}s {2} {3}s);".format(result_type, operand1[0], operator, operand2[0])
    return "_Static_assert(std::is_same<{0}, __decltype({1}s {2} {3}s)>::value, \"\");".format(result_type, operand1[0], operator, operand2[0])

def GenerateBinaryOperators():
    result = []
    for operator in ArithOperators + OrderOperators + LogicalOperators:
        for operand1 in primitiveTypes:
            for operand2 in primitiveTypes:
                result += ["_Static_assert(std::is_same<{0}, __decltype({1}s {2} {3}s)>::value, \"\");".format(GetOpResultType(operator, operand1, operand2),operand1[0], operator, operand2[0])]
    for operator in ShiftOperators + BitWiseOperators:
        for operand1 in primitiveTypes:
            for operand2 in primitiveTypes:
                result += [GenerateBitWiseStatement(operator, operand1, operand2)]
    return result

</py>*/
// <py::lines('GENERATED_BINARY_ARITH')>modify(lines, GenerateBinaryOperators())</py>
// GENERATED_BINARY_ARITH:BEGIN
_Static_assert(std::is_same<int, __decltype(bools + bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(bools + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(bools + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(bools + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(bools + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(bools + min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(bools + min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools + min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools + min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools + int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(bools + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(bools + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(bools + float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints + bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(ints + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(ints + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(ints + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(ints + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(ints + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int, __decltype(ints + min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints + min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints + min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints + int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints + int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(ints + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(ints + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(ints + float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uints + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uints + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uints + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uints + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uints + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint, __decltype(uints + min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints + int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uints + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uints + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uints + float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(halfs + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(halfs + doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs + uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(halfs + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(halfs + float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(floats + doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats + uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats + float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(floats + float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles + float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats + bools)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min16floats + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16floats + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16floats + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + min10floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + min16ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + min12ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + min16uints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + int16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + uint16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min16floats + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16floats + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16floats + float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats + bools)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min10floats + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min10floats + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min10floats + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min10floats + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min10floats + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min10floats + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min10floats + float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints + bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16ints + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16ints + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16ints + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16ints + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16ints + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints + min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints + min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints + min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints + int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16ints + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16ints + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16ints + float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints + bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min12ints + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min12ints + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min12ints + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min12ints + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min12ints + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints + min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints + min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints + min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints + int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min12ints + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min12ints + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min12ints + float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints + bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16uints + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16uints + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16uints + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16uints + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16uints + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints + min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints + min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints + min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints + int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints + int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16uints + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16uints + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16uints + float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts + bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int16_ts + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(int16_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int16_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int16_ts + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int16_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts + min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts + min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int16_ts + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(int16_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int16_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int32_ts + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int32_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int32_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int32_ts + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int32_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts + min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int32_ts + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int32_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int32_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int64_ts + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int64_ts + floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(int64_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int64_ts + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int64_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts + min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int64_ts + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int64_ts + float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(int64_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts + ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint16_ts + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(uint16_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint16_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint16_ts + min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint16_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint16_ts + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(uint16_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint16_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint32_ts + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint32_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint32_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint32_ts + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint32_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint32_ts + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint32_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint32_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint64_ts + halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint64_ts + floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(uint64_ts + doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint64_ts + min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint64_ts + min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint64_ts + float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint64_ts + float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(uint64_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(float16_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float16_ts + doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float16_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float16_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float32_ts + doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float32_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts + float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools - bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(bools - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(bools - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(bools - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(bools - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(bools - min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(bools - min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools - min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools - min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools - int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(bools - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(bools - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(bools - float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints - bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(ints - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(ints - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(ints - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(ints - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(ints - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int, __decltype(ints - min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints - min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints - min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints - int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints - int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(ints - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(ints - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(ints - float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uints - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uints - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uints - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uints - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uints - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint, __decltype(uints - min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints - int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uints - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uints - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uints - float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(halfs - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(halfs - doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs - uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(halfs - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(halfs - float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(floats - doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats - uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats - float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(floats - float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles - float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats - bools)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min16floats - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16floats - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16floats - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - min10floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - min16ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - min12ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - min16uints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - int16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - uint16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min16floats - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16floats - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16floats - float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats - bools)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min10floats - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min10floats - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min10floats - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min10floats - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min10floats - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min10floats - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min10floats - float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints - bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16ints - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16ints - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16ints - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16ints - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16ints - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints - min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints - min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints - min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints - int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16ints - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16ints - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16ints - float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints - bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min12ints - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min12ints - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min12ints - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min12ints - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min12ints - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints - min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints - min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints - min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints - int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min12ints - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min12ints - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min12ints - float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints - bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16uints - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16uints - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16uints - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16uints - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16uints - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints - min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints - min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints - min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints - int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints - int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16uints - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16uints - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16uints - float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts - bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int16_ts - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(int16_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int16_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int16_ts - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int16_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts - min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts - min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int16_ts - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(int16_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int16_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int32_ts - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int32_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int32_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int32_ts - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int32_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts - min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int32_ts - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int32_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int32_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int64_ts - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int64_ts - floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(int64_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int64_ts - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int64_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts - min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int64_ts - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int64_ts - float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(int64_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts - ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint16_ts - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(uint16_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint16_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint16_ts - min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint16_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint16_ts - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(uint16_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint16_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint32_ts - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint32_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint32_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint32_ts - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint32_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint32_ts - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint32_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint32_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint64_ts - halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint64_ts - floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(uint64_ts - doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint64_ts - min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint64_ts - min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint64_ts - float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint64_ts - float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(uint64_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(float16_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float16_ts - doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float16_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float16_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float32_ts - doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float32_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts - float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools / bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(bools / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(bools / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(bools / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(bools / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(bools / min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(bools / min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools / min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools / min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools / int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(bools / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(bools / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(bools / float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints / bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(ints / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(ints / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(ints / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(ints / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(ints / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int, __decltype(ints / min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints / min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints / min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints / int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints / int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(ints / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(ints / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(ints / float64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uints / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uints / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uints / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uints / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uints / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint, __decltype(uints / min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints / int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uints / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uints / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uints / float64_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(halfs / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(halfs / doubles)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs / uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(halfs / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(halfs / float64_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(floats / doubles)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats / uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats / float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(floats / float64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / bools)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / halfs)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / doubles)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / min16floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / min10floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / min16ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / min12ints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / min16uints)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / int16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / int32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / int64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / uint16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / uint32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / uint64_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / float16_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / float32_ts)>::value, "");
_Static_assert(std::is_same<double, __decltype(doubles / float64_ts)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats / bools)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min16floats / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16floats / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16floats / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16floats / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / min10floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / min16ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / min12ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / min16uints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / int16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / uint16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min16floats / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16floats / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16floats / float64_ts)>::value, "");
_Static_assert(std::is_same<min10float, __decltype(min10floats / bools)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min10floats / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min10floats / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min10floats / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min10floats / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min10floats / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min10floats / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min10floats / float64_ts)>::value, "");
_Static_assert(std::is_same<min16int, __decltype(min16ints / bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16ints / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16ints / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16ints / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16ints / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16ints / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints / min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints / min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints / min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints / int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16ints / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16ints / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16ints / float64_ts)>::value, "");
_Static_assert(std::is_same<min12int, __decltype(min12ints / bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min12ints / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min12ints / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min12ints / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min12ints / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min12ints / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints / min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints / min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints / min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints / int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min12ints / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min12ints / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min12ints / float64_ts)>::value, "");
_Static_assert(std::is_same<min16uint, __decltype(min16uints / bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16uints / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16uints / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16uints / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(min16uints / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16uints / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints / min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints / min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints / min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints / int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints / int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16uints / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16uints / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16uints / float64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts / bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int16_ts / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(int16_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int16_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int16_ts / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int16_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts / min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts / min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int16_ts / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(int16_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int16_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int32_ts / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int32_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int32_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int32_ts / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int32_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts / min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int32_ts / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int32_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int32_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int64_ts / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int64_ts / floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(int64_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(int64_ts / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int64_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts / min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int64_ts / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int64_ts / float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(int64_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts / ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint16_ts / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(uint16_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint16_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint16_ts / min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint16_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint16_ts / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(uint16_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint16_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint32_ts / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint32_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint32_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint32_ts / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint32_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint32_ts / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint32_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint32_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint64_ts / halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint64_ts / floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(uint64_ts / doubles)>::value, "");
_Static_assert(std::is_same<min16float, __decltype(uint64_ts / min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint64_ts / min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint64_ts / float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint64_ts / float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(uint64_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(float16_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float16_ts / doubles)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float16_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float16_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float32_ts / doubles)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float32_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / bools)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / halfs)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / doubles)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / min16floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / min10floats)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / min16ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / min12ints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / min16uints)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / int16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / int32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / int64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / uint16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / uint32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / uint64_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / float16_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float64_ts / float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools % bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(bools % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(bools % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(bools % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(bools % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(bools % min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(bools % min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools % min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools % min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools % int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(bools % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(bools % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(bools % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<int, __decltype(ints % bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(ints % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(ints % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(ints % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(ints % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(ints % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int, __decltype(ints % min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints % min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints % min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints % int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints % int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(ints % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(ints % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(ints % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<uint, __decltype(uints % bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uints % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uints % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uints % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(uints % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uints % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint, __decltype(uints % min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints % int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uints % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uints % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uints % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<half, __decltype(halfs % bools)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(halfs % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(halfs % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<half, __decltype(halfs % min16floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % min10floats)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % min16ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % min12ints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % min16uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % int16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % uint16_ts)>::value, "");
_Static_assert(std::is_same<half, __decltype(halfs % uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<half, __decltype(halfs % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(halfs % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(halfs % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float, __decltype(floats % bools)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(floats % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float, __decltype(floats % min16floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % min10floats)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % min16ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % min12ints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % min16uints)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % int16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % int32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats % uint16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % uint32_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(floats % float16_ts)>::value, "");
_Static_assert(std::is_same<float, __decltype(floats % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(floats % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % bools)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % uints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % halfs)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % min16floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % min10floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % min16ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % min12ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % min16uints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % int16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % int32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % int64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % uint16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % uint32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % uint64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % float16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % float32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<double, __decltype(doubles % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % bools)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min16floats % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16floats % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16floats % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % min10floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % min16ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % min12ints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % min16uints)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % int16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % uint16_ts)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min16float, __decltype(min16floats % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min16floats % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16floats % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16floats % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % bools)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<half, __decltype(min10floats % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min10floats % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min10floats % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min10floats % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % min10floats)>::value, "");    /* expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min10floats % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<float16_t, __decltype(min10floats % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min10floats % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min10floats % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints % bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16ints % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16ints % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16ints % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min16ints % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16ints % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints % min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints % min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints % min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints % int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16ints % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16ints % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16ints % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints % bools)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min12ints % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min12ints % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min12ints % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min12ints % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min12ints % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints % min16ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints % min12ints)>::value, "");    /* expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints % min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints % int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min12ints % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min12ints % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min12ints % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints % bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(min16uints % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(min16uints % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(min16uints % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(min16uints % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(min16uints % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints % min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints % min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints % min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints % int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints % int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(min16uints % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(min16uints % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(min16uints % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts % bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int16_ts % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(int16_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int16_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(int16_ts % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int16_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts % min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts % min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int16_ts % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(int16_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int16_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int32_ts % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int32_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(int32_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(int32_ts % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int32_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts % min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int32_ts % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int32_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(int32_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(int64_ts % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(int64_ts % floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(int64_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(int64_ts % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(int64_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts % min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(int64_ts % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(int64_ts % float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(int64_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts % ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint16_ts % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(uint16_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint16_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(uint16_ts % min16floats)>::value, "");    /* expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint16_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint16_ts % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(uint16_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint16_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint32_ts % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint32_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(uint32_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(uint32_ts % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint32_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint32_ts % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint32_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(uint32_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % uints)>::value, "");
_Static_assert(std::is_same<half, __decltype(uint64_ts % halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float, __decltype(uint64_ts % floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<double, __decltype(uint64_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<min16float, __decltype(uint64_ts % min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} expected-warning {{min16float is promoted to float16_t}} */
_Static_assert(std::is_same<min10float, __decltype(uint64_ts % min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} expected-warning {{min10float is promoted to float16_t}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts % uint64_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(uint64_ts % float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(uint64_ts % float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<float64_t, __decltype(uint64_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % bools)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % halfs)>::value, "");
_Static_assert(std::is_same<float, __decltype(float16_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float16_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % min16floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % min10floats)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % min16ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % min12ints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % min16uints)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<float16_t, __decltype(float16_ts % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float16_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float16_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % bools)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % halfs)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % floats)>::value, "");
_Static_assert(std::is_same<double, __decltype(float32_ts % doubles)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % min16floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % min10floats)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % min16ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % min12ints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % min16uints)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % int16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % int32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % uint16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % uint32_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % float16_ts)>::value, "");
_Static_assert(std::is_same<float32_t, __decltype(float32_ts % float32_ts)>::value, "");
_Static_assert(std::is_same<float64_t, __decltype(float32_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % bools)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % uints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % halfs)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % doubles)>::value, "");   /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % min16floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % min10floats)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % min16ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % min12ints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % min16uints)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % int16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % int32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % int64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % uint16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % uint32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % uint64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % float16_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % float32_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<float64_t, __decltype(float64_ts % float64_ts)>::value, "");    /* expected-error {{modulo cannot be used with doubles, cast to float first}} */
_Static_assert(std::is_same<bool, __decltype(bools < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16ints < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min12ints < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16uints < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int16_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint16_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts < float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts < float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16ints <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min12ints <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16uints <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int16_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts <= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16ints > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min12ints > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16uints > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int16_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint16_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts > float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts > float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(ints >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uints >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(halfs >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(floats >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16floats >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= min16ints)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= min12ints)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= min16uints)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= int16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= uint16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min10floats >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16ints >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min12int' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min12ints >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'min16uint' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(min16uints >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int16_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int32_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(int64_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint16_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= halfs)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= min16floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min16float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= min10floats)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'min10float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= float16_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'half', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= float32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(uint64_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= ints)>::value, "");    /* expected-warning {{conversion from larger type 'int' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= uints)>::value, "");    /* expected-warning {{conversion from larger type 'uint' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= int32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= uint32_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint32_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float16_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float16_ts >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= int64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'int64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= uint64_ts)>::value, "");    /* expected-warning {{conversion from larger type 'uint64_t' to smaller type 'float32_t', possible loss of data}} */
_Static_assert(std::is_same<bool, __decltype(float32_ts >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts >= float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts && float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(bools || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(ints || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uints || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(halfs || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(floats || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(doubles || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16floats || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min10floats || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16ints || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min12ints || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(min16uints || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int16_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int32_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(int64_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint16_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint32_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(uint64_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float16_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float32_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || bools)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || halfs)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || doubles)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || min16floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || min10floats)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || min16ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || min12ints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || min16uints)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || int16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || int32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || int64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || uint16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || uint32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || uint64_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || float16_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || float32_ts)>::value, "");
_Static_assert(std::is_same<bool, __decltype(float64_ts || float64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << uints)>::value, "");
ints = (bools << halfs);         /* expected-error {{int or unsigned int type required}} */
ints = (bools << floats);        /* expected-error {{int or unsigned int type required}} */
ints = (bools << doubles);       /* expected-error {{int or unsigned int type required}} */
ints = (bools << min16floats);   /* expected-error {{int or unsigned int type required}} */
ints = (bools << min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools << min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools << uint64_ts)>::value, "");
ints = (bools << float16_ts);    /* expected-error {{int or unsigned int type required}} */
ints = (bools << float32_ts);    /* expected-error {{int or unsigned int type required}} */
ints = (bools << float64_ts);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints << bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << uints)>::value, "");
ints = (ints << halfs);          /* expected-error {{int or unsigned int type required}} */
ints = (ints << floats);         /* expected-error {{int or unsigned int type required}} */
ints = (ints << doubles);        /* expected-error {{int or unsigned int type required}} */
ints = (ints << min16floats);    /* expected-error {{int or unsigned int type required}} */
ints = (ints << min10floats);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints << min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints << uint64_ts)>::value, "");
ints = (ints << float16_ts);     /* expected-error {{int or unsigned int type required}} */
ints = (ints << float32_ts);     /* expected-error {{int or unsigned int type required}} */
ints = (ints << float64_ts);     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints << bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << uints)>::value, "");
uints = (uints << halfs);        /* expected-error {{int or unsigned int type required}} */
uints = (uints << floats);       /* expected-error {{int or unsigned int type required}} */
uints = (uints << doubles);      /* expected-error {{int or unsigned int type required}} */
uints = (uints << min16floats);  /* expected-error {{int or unsigned int type required}} */
uints = (uints << min10floats);  /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints << min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints << uint64_ts)>::value, "");
uints = (uints << float16_ts);   /* expected-error {{int or unsigned int type required}} */
uints = (uints << float32_ts);   /* expected-error {{int or unsigned int type required}} */
uints = (uints << float64_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << bools);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << ints);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << uints);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << halfs);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << floats);       /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << doubles);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << min16floats);  /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << min10floats);  /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << min16ints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << min12ints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << min16uints);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << int16_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << int32_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << int64_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << uint16_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << uint32_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << uint64_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << float16_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << float32_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs << float64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats << bools);      /* expected-error {{int or unsigned int type required}} */
floats = (floats << ints);       /* expected-error {{int or unsigned int type required}} */
floats = (floats << uints);      /* expected-error {{int or unsigned int type required}} */
floats = (floats << halfs);      /* expected-error {{int or unsigned int type required}} */
floats = (floats << floats);     /* expected-error {{int or unsigned int type required}} */
floats = (floats << doubles);    /* expected-error {{int or unsigned int type required}} */
floats = (floats << min16floats);                           /* expected-error {{int or unsigned int type required}} */
floats = (floats << min10floats);                           /* expected-error {{int or unsigned int type required}} */
floats = (floats << min16ints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats << min12ints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats << min16uints); /* expected-error {{int or unsigned int type required}} */
floats = (floats << int16_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats << int32_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats << int64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats << uint16_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats << uint32_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats << uint64_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats << float16_ts); /* expected-error {{int or unsigned int type required}} */
floats = (floats << float32_ts); /* expected-error {{int or unsigned int type required}} */
floats = (floats << float64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << bools);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << ints);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << uints);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << halfs);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << floats);   /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << doubles);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << min16floats);                         /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << min10floats);                         /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << min16ints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << min12ints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << min16uints);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << int16_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << int32_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << int64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << uint16_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << uint32_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << uint64_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << float16_ts);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << float32_ts);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles << float64_ts);                          /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << bools);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << ints);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << uints);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << halfs);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << floats);                      /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << doubles);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << min16floats);                 /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << min10floats);                 /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << min16ints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << min12ints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << min16uints);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << int16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << int32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << int64_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << uint16_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << uint32_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << uint64_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << float16_ts);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << float32_ts);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats << float64_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << bools);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << ints);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << uints);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << halfs);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << floats);                      /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << doubles);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << min16floats);                 /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << min10floats);                 /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << min16ints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << min12ints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << min16uints);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << int16_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << int32_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << int64_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << uint16_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << uint32_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << uint64_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << float16_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << float32_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats << float64_ts);                  /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << uints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
min16ints = (min16ints << halfs);                           /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << floats);                          /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << doubles);                         /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << min16floats);                     /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << min16uints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << int16_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << int32_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << int64_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << uint16_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << uint32_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints << uint64_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
min16ints = (min16ints << float16_ts);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << float32_ts);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints << float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << uints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
min12ints = (min12ints << halfs);                           /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << floats);                          /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << doubles);                         /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << min16floats);                     /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << min16ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << min16uints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << int16_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << int32_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << int64_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << uint16_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << uint32_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints << uint64_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
min12ints = (min12ints << float16_ts);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << float32_ts);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints << float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
min16uints = (min16uints << halfs);                         /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << floats);                        /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << doubles);                       /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << min16floats);                   /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << min10floats);                   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << int16_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << int32_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << int64_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << uint16_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << uint32_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints << uint64_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
min16uints = (min16uints << float16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << float32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints << float64_ts);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << uints)>::value, "");
int16_ts = (int16_ts << halfs);  /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << floats); /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << doubles);                           /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << min16floats);                       /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts << uint64_ts)>::value, "");
int16_ts = (int16_ts << float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts << float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << uints)>::value, "");
int32_ts = (int32_ts << halfs);  /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << floats); /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << doubles);                           /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << min16floats);                       /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts << uint64_ts)>::value, "");
int32_ts = (int32_ts << float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts << float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << uints)>::value, "");
int64_ts = (int64_ts << halfs);  /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << floats); /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << doubles);                           /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << min16floats);                       /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts << uint64_ts)>::value, "");
int64_ts = (int64_ts << float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts << float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << uints)>::value, "");
uint16_ts = (uint16_ts << halfs);                           /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << floats);                          /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << doubles);                         /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts << uint64_ts)>::value, "");
uint16_ts = (uint16_ts << float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts << float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << uints)>::value, "");
uint32_ts = (uint32_ts << halfs);                           /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << floats);                          /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << doubles);                         /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts << uint64_ts)>::value, "");
uint32_ts = (uint32_ts << float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts << float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << uints)>::value, "");
uint64_ts = (uint64_ts << halfs);                           /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << floats);                          /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << doubles);                         /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts << uint64_ts)>::value, "");
uint64_ts = (uint64_ts << float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts << float64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << bools);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << ints);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << uints);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << halfs);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << floats);                        /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << doubles);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << min16floats);                   /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << min10floats);                   /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << min16ints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << min12ints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << min16uints);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts << float64_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << bools);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << ints);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << uints);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << halfs);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << floats);                        /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << doubles);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << min16floats);                   /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << min10floats);                   /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << min16ints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << min12ints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << min16uints);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts << float64_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << bools);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << ints);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << uints);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << halfs);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << floats);                        /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << doubles);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << min16floats);                   /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << min10floats);                   /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << min16ints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << min12ints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << min16uints);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts << float64_ts);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools >> bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> uints)>::value, "");
ints = (bools >> halfs);         /* expected-error {{int or unsigned int type required}} */
ints = (bools >> floats);        /* expected-error {{int or unsigned int type required}} */
ints = (bools >> doubles);       /* expected-error {{int or unsigned int type required}} */
ints = (bools >> min16floats);   /* expected-error {{int or unsigned int type required}} */
ints = (bools >> min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools >> min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools >> uint64_ts)>::value, "");
ints = (bools >> float16_ts);    /* expected-error {{int or unsigned int type required}} */
ints = (bools >> float32_ts);    /* expected-error {{int or unsigned int type required}} */
ints = (bools >> float64_ts);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints >> bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> uints)>::value, "");
ints = (ints >> halfs);          /* expected-error {{int or unsigned int type required}} */
ints = (ints >> floats);         /* expected-error {{int or unsigned int type required}} */
ints = (ints >> doubles);        /* expected-error {{int or unsigned int type required}} */
ints = (ints >> min16floats);    /* expected-error {{int or unsigned int type required}} */
ints = (ints >> min10floats);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints >> min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> min12ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> int32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> int64_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> uint16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> uint32_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints >> uint64_ts)>::value, "");
ints = (ints >> float16_ts);     /* expected-error {{int or unsigned int type required}} */
ints = (ints >> float32_ts);     /* expected-error {{int or unsigned int type required}} */
ints = (ints >> float64_ts);     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints >> bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> uints)>::value, "");
uints = (uints >> halfs);        /* expected-error {{int or unsigned int type required}} */
uints = (uints >> floats);       /* expected-error {{int or unsigned int type required}} */
uints = (uints >> doubles);      /* expected-error {{int or unsigned int type required}} */
uints = (uints >> min16floats);  /* expected-error {{int or unsigned int type required}} */
uints = (uints >> min10floats);  /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints >> min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> int32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> uint32_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints >> uint64_ts)>::value, "");
uints = (uints >> float16_ts);   /* expected-error {{int or unsigned int type required}} */
uints = (uints >> float32_ts);   /* expected-error {{int or unsigned int type required}} */
uints = (uints >> float64_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> bools);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> ints);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> uints);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> halfs);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> floats);       /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> doubles);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> min16floats);  /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> min10floats);  /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> min16ints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> min12ints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> min16uints);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> int16_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> int32_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> int64_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> uint16_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> uint32_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> uint64_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> float16_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> float32_ts);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs >> float64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats >> bools);      /* expected-error {{int or unsigned int type required}} */
floats = (floats >> ints);       /* expected-error {{int or unsigned int type required}} */
floats = (floats >> uints);      /* expected-error {{int or unsigned int type required}} */
floats = (floats >> halfs);      /* expected-error {{int or unsigned int type required}} */
floats = (floats >> floats);     /* expected-error {{int or unsigned int type required}} */
floats = (floats >> doubles);    /* expected-error {{int or unsigned int type required}} */
floats = (floats >> min16floats);                           /* expected-error {{int or unsigned int type required}} */
floats = (floats >> min10floats);                           /* expected-error {{int or unsigned int type required}} */
floats = (floats >> min16ints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats >> min12ints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats >> min16uints); /* expected-error {{int or unsigned int type required}} */
floats = (floats >> int16_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats >> int32_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats >> int64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats >> uint16_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats >> uint32_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats >> uint64_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats >> float16_ts); /* expected-error {{int or unsigned int type required}} */
floats = (floats >> float32_ts); /* expected-error {{int or unsigned int type required}} */
floats = (floats >> float64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> bools);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> ints);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> uints);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> halfs);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> floats);   /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> doubles);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> min16floats);                         /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> min10floats);                         /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> min16ints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> min12ints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> min16uints);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> int16_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> int32_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> int64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> uint16_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> uint32_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> uint64_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> float16_ts);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> float32_ts);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles >> float64_ts);                          /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> bools);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> ints);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> uints);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> halfs);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> floats);                      /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> doubles);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> min16floats);                 /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> min10floats);                 /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> min16ints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> min12ints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> min16uints);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> int16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> int32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> int64_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> uint16_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> uint32_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> uint64_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> float16_ts);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> float32_ts);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats >> float64_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> bools);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> ints);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> uints);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> halfs);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> floats);                      /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> doubles);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> min16floats);                 /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> min10floats);                 /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> min16ints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> min12ints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> min16uints);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> int16_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> int32_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> int64_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> uint16_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> uint32_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> uint64_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> float16_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> float32_ts);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats >> float64_ts);                  /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> uints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
min16ints = (min16ints >> halfs);                           /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> floats);                          /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> doubles);                         /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> min16floats);                     /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> min16uints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> int16_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> int32_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> int64_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> uint16_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> uint32_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints >> uint64_ts)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
min16ints = (min16ints >> float16_ts);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> float32_ts);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints >> float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> uints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
min12ints = (min12ints >> halfs);                           /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> floats);                          /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> doubles);                         /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> min16floats);                     /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> min16ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> min16uints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> int16_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> int32_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> int64_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> uint16_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> uint32_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints >> uint64_ts)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
min12ints = (min12ints >> float16_ts);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> float32_ts);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints >> float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
min16uints = (min16uints >> halfs);                         /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> floats);                        /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> doubles);                       /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> min16floats);                   /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> min10floats);                   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> int16_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> int32_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> int64_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> uint16_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> uint32_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints >> uint64_ts)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
min16uints = (min16uints >> float16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> float32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints >> float64_ts);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> bools)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> uints)>::value, "");
int16_ts = (int16_ts >> halfs);  /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> floats); /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> doubles);                           /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> min16floats);                       /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts >> uint64_ts)>::value, "");
int16_ts = (int16_ts >> float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts >> float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> uints)>::value, "");
int32_ts = (int32_ts >> halfs);  /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> floats); /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> doubles);                           /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> min16floats);                       /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts >> uint64_ts)>::value, "");
int32_ts = (int32_ts >> float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts >> float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> uints)>::value, "");
int64_ts = (int64_ts >> halfs);  /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> floats); /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> doubles);                           /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> min16floats);                       /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> min10floats);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts >> uint64_ts)>::value, "");
int64_ts = (int64_ts >> float16_ts);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> float32_ts);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts >> float64_ts);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> bools)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> uints)>::value, "");
uint16_ts = (uint16_ts >> halfs);                           /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> floats);                          /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> doubles);                         /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts >> uint64_ts)>::value, "");
uint16_ts = (uint16_ts >> float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts >> float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> uints)>::value, "");
uint32_ts = (uint32_ts >> halfs);                           /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> floats);                          /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> doubles);                         /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts >> uint64_ts)>::value, "");
uint32_ts = (uint32_ts >> float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts >> float64_ts);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> uints)>::value, "");
uint64_ts = (uint64_ts >> halfs);                           /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> floats);                          /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> doubles);                         /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> min16floats);                     /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> min10floats);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts >> uint64_ts)>::value, "");
uint64_ts = (uint64_ts >> float16_ts);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> float32_ts);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts >> float64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> bools);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> ints);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> uints);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> halfs);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> floats);                        /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> doubles);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> min16floats);                   /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> min10floats);                   /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> min16ints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> min12ints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> min16uints);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts >> float64_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> bools);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> ints);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> uints);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> halfs);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> floats);                        /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> doubles);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> min16floats);                   /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> min10floats);                   /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> min16ints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> min12ints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> min16uints);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts >> float64_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> bools);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> ints);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> uints);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> halfs);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> floats);                        /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> doubles);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> min16floats);                   /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> min10floats);                   /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> min16ints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> min12ints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> min16uints);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> int16_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> int32_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> int64_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> uint16_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> uint32_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> uint64_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> float16_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> float32_ts);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts >> float64_ts);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools & bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools & uints)>::value, "");
bools = (bools & halfs);         /* expected-error {{int or unsigned int type required}} */
bools = (bools & floats);        /* expected-error {{int or unsigned int type required}} */
bools = (bools & doubles);       /* expected-error {{int or unsigned int type required}} */
bools = (bools & min16floats);   /* expected-error {{int or unsigned int type required}} */
bools = (bools & min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(bools & min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools & min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools & min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools & int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools & uint64_ts)>::value, "");
bools = (bools & float16_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools & float32_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools & float64_ts);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints & bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints & uints)>::value, "");
ints = (ints & halfs);           /* expected-error {{int or unsigned int type required}} */
ints = (ints & floats);          /* expected-error {{int or unsigned int type required}} */
ints = (ints & doubles);         /* expected-error {{int or unsigned int type required}} */
ints = (ints & min16floats);     /* expected-error {{int or unsigned int type required}} */
ints = (ints & min10floats);     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints & min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints & min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints & min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints & int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints & int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints & uint64_ts)>::value, "");
ints = (ints & float16_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints & float32_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints & float64_ts);      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints & bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & uints)>::value, "");
uints = (uints & halfs);         /* expected-error {{int or unsigned int type required}} */
uints = (uints & floats);        /* expected-error {{int or unsigned int type required}} */
uints = (uints & doubles);       /* expected-error {{int or unsigned int type required}} */
uints = (uints & min16floats);   /* expected-error {{int or unsigned int type required}} */
uints = (uints & min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints & min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints & int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints & uint64_ts)>::value, "");
uints = (uints & float16_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints & float32_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints & float64_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & bools);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & ints);          /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & uints);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & halfs);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & floats);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & doubles);       /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & min16floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & min10floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & min16ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & min12ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & min16uints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & int16_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & int32_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & int64_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & uint16_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & uint32_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & uint64_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & float16_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & float32_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs & float64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats & bools);       /* expected-error {{int or unsigned int type required}} */
floats = (floats & ints);        /* expected-error {{int or unsigned int type required}} */
floats = (floats & uints);       /* expected-error {{int or unsigned int type required}} */
floats = (floats & halfs);       /* expected-error {{int or unsigned int type required}} */
floats = (floats & floats);      /* expected-error {{int or unsigned int type required}} */
floats = (floats & doubles);     /* expected-error {{int or unsigned int type required}} */
floats = (floats & min16floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats & min10floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats & min16ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats & min12ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats & min16uints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats & int16_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats & int32_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats & int64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats & uint16_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats & uint32_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats & uint64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats & float16_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats & float32_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats & float64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & bools);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & ints);      /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & uints);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & halfs);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & floats);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & doubles);   /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & min16floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & min10floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & min16ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & min12ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & min16uints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & int16_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & int32_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & int64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & uint16_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & uint32_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & uint64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & float16_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & float32_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles & float64_ts);                           /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & bools);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & ints);                         /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & uints);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & halfs);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & floats);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & doubles);                      /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & min16floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & min10floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & min16ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & min12ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & min16uints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats & float64_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & bools);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & ints);                         /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & uints);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & halfs);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & floats);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & doubles);                      /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & min16floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & min10floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & min16ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & min12ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & min16uints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats & float64_ts);                   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints & bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints & uints)>::value, "");
min16ints = (min16ints & halfs); /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & floats);                           /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & doubles);                          /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & min16floats);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints & min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints & min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints & min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints & int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints & uint64_ts)>::value, "");
min16ints = (min16ints & float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints & float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints & bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints & uints)>::value, "");
min12ints = (min12ints & halfs); /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & floats);                           /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & doubles);                          /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & min16floats);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints & min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints & min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints & min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints & int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints & uint64_ts)>::value, "");
min12ints = (min12ints & float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints & float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints & bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints & uints)>::value, "");
min16uints = (min16uints & halfs);                          /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & floats);                         /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & doubles);                        /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & min16floats);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & min10floats);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints & min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints & min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints & min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints & int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints & int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints & uint64_ts)>::value, "");
min16uints = (min16uints & float16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & float32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints & float64_ts);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts & bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts & uints)>::value, "");
int16_ts = (int16_ts & halfs);   /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & floats);  /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & doubles); /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & min16floats);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts & min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts & min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts & uint64_ts)>::value, "");
int16_ts = (int16_ts & float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts & float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts & uints)>::value, "");
int32_ts = (int32_ts & halfs);   /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & floats);  /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & doubles); /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & min16floats);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts & min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts & uint64_ts)>::value, "");
int32_ts = (int32_ts & float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts & float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts & uints)>::value, "");
int64_ts = (int64_ts & halfs);   /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & floats);  /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & doubles); /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & min16floats);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts & min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts & uint64_ts)>::value, "");
int64_ts = (int64_ts & float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts & float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts & ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts & uints)>::value, "");
uint16_ts = (uint16_ts & halfs); /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & floats);                           /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & doubles);                          /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts & uint64_ts)>::value, "");
uint16_ts = (uint16_ts & float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts & float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & uints)>::value, "");
uint32_ts = (uint32_ts & halfs); /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & floats);                           /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & doubles);                          /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts & uint64_ts)>::value, "");
uint32_ts = (uint32_ts & float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts & float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & uints)>::value, "");
uint64_ts = (uint64_ts & halfs); /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & floats);                           /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & doubles);                          /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts & uint64_ts)>::value, "");
uint64_ts = (uint64_ts & float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts & float64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & bools);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & ints);                           /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & uints);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & halfs);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & floats);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & doubles);                        /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & min16floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & min10floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & min16ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & min12ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & min16uints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts & float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & bools);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & ints);                           /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & uints);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & halfs);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & floats);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & doubles);                        /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & min16floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & min10floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & min16ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & min12ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & min16uints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts & float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & bools);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & ints);                           /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & uints);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & halfs);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & floats);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & doubles);                        /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & min16floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & min10floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & min16ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & min12ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & min16uints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts & float64_ts);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools | bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools | uints)>::value, "");
bools = (bools | halfs);         /* expected-error {{int or unsigned int type required}} */
bools = (bools | floats);        /* expected-error {{int or unsigned int type required}} */
bools = (bools | doubles);       /* expected-error {{int or unsigned int type required}} */
bools = (bools | min16floats);   /* expected-error {{int or unsigned int type required}} */
bools = (bools | min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(bools | min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools | min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools | min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools | int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools | uint64_ts)>::value, "");
bools = (bools | float16_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools | float32_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools | float64_ts);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints | bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints | uints)>::value, "");
ints = (ints | halfs);           /* expected-error {{int or unsigned int type required}} */
ints = (ints | floats);          /* expected-error {{int or unsigned int type required}} */
ints = (ints | doubles);         /* expected-error {{int or unsigned int type required}} */
ints = (ints | min16floats);     /* expected-error {{int or unsigned int type required}} */
ints = (ints | min10floats);     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints | min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints | min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints | min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints | int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints | int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints | uint64_ts)>::value, "");
ints = (ints | float16_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints | float32_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints | float64_ts);      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints | bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | uints)>::value, "");
uints = (uints | halfs);         /* expected-error {{int or unsigned int type required}} */
uints = (uints | floats);        /* expected-error {{int or unsigned int type required}} */
uints = (uints | doubles);       /* expected-error {{int or unsigned int type required}} */
uints = (uints | min16floats);   /* expected-error {{int or unsigned int type required}} */
uints = (uints | min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints | min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints | int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints | uint64_ts)>::value, "");
uints = (uints | float16_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints | float32_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints | float64_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | bools);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | ints);          /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | uints);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | halfs);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | floats);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | doubles);       /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | min16floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | min10floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | min16ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | min12ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | min16uints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | int16_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | int32_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | int64_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | uint16_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | uint32_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | uint64_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | float16_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | float32_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs | float64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats | bools);       /* expected-error {{int or unsigned int type required}} */
floats = (floats | ints);        /* expected-error {{int or unsigned int type required}} */
floats = (floats | uints);       /* expected-error {{int or unsigned int type required}} */
floats = (floats | halfs);       /* expected-error {{int or unsigned int type required}} */
floats = (floats | floats);      /* expected-error {{int or unsigned int type required}} */
floats = (floats | doubles);     /* expected-error {{int or unsigned int type required}} */
floats = (floats | min16floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats | min10floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats | min16ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats | min12ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats | min16uints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats | int16_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats | int32_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats | int64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats | uint16_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats | uint32_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats | uint64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats | float16_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats | float32_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats | float64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | bools);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | ints);      /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | uints);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | halfs);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | floats);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | doubles);   /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | min16floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | min10floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | min16ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | min12ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | min16uints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | int16_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | int32_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | int64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | uint16_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | uint32_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | uint64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | float16_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | float32_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles | float64_ts);                           /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | bools);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | ints);                         /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | uints);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | halfs);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | floats);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | doubles);                      /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | min16floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | min10floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | min16ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | min12ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | min16uints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats | float64_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | bools);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | ints);                         /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | uints);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | halfs);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | floats);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | doubles);                      /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | min16floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | min10floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | min16ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | min12ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | min16uints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats | float64_ts);                   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints | bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints | uints)>::value, "");
min16ints = (min16ints | halfs); /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | floats);                           /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | doubles);                          /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | min16floats);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints | min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints | min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints | min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints | int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints | uint64_ts)>::value, "");
min16ints = (min16ints | float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints | float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints | bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints | uints)>::value, "");
min12ints = (min12ints | halfs); /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | floats);                           /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | doubles);                          /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | min16floats);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints | min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints | min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints | min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints | int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints | uint64_ts)>::value, "");
min12ints = (min12ints | float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints | float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints | bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints | uints)>::value, "");
min16uints = (min16uints | halfs);                          /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | floats);                         /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | doubles);                        /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | min16floats);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | min10floats);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints | min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints | min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints | min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints | int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints | int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints | uint64_ts)>::value, "");
min16uints = (min16uints | float16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | float32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints | float64_ts);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts | bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts | uints)>::value, "");
int16_ts = (int16_ts | halfs);   /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | floats);  /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | doubles); /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | min16floats);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts | min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts | min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts | uint64_ts)>::value, "");
int16_ts = (int16_ts | float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts | float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts | uints)>::value, "");
int32_ts = (int32_ts | halfs);   /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | floats);  /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | doubles); /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | min16floats);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts | min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts | uint64_ts)>::value, "");
int32_ts = (int32_ts | float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts | float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts | uints)>::value, "");
int64_ts = (int64_ts | halfs);   /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | floats);  /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | doubles); /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | min16floats);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts | min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts | uint64_ts)>::value, "");
int64_ts = (int64_ts | float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts | float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts | ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts | uints)>::value, "");
uint16_ts = (uint16_ts | halfs); /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | floats);                           /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | doubles);                          /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts | uint64_ts)>::value, "");
uint16_ts = (uint16_ts | float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts | float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | uints)>::value, "");
uint32_ts = (uint32_ts | halfs); /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | floats);                           /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | doubles);                          /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts | uint64_ts)>::value, "");
uint32_ts = (uint32_ts | float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts | float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | uints)>::value, "");
uint64_ts = (uint64_ts | halfs); /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | floats);                           /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | doubles);                          /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts | uint64_ts)>::value, "");
uint64_ts = (uint64_ts | float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts | float64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | bools);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | ints);                           /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | uints);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | halfs);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | floats);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | doubles);                        /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | min16floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | min10floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | min16ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | min12ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | min16uints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts | float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | bools);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | ints);                           /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | uints);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | halfs);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | floats);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | doubles);                        /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | min16floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | min10floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | min16ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | min12ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | min16uints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts | float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | bools);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | ints);                           /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | uints);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | halfs);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | floats);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | doubles);                        /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | min16floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | min10floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | min16ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | min12ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | min16uints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts | float64_ts);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(bools ^ bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(bools ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(bools ^ uints)>::value, "");
bools = (bools ^ halfs);         /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ floats);        /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ doubles);       /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ min16floats);   /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(bools ^ min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(bools ^ min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(bools ^ min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(bools ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(bools ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(bools ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(bools ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(bools ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(bools ^ uint64_ts)>::value, "");
bools = (bools ^ float16_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ float32_ts);    /* expected-error {{int or unsigned int type required}} */
bools = (bools ^ float64_ts);    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints ^ bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints ^ uints)>::value, "");
ints = (ints ^ halfs);           /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ floats);          /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ doubles);         /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ min16floats);     /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ min10floats);     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int, __decltype(ints ^ min16ints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints ^ min16uints)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int, __decltype(ints ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(ints ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(ints ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(ints ^ uint64_ts)>::value, "");
ints = (ints ^ float16_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ float32_ts);      /* expected-error {{int or unsigned int type required}} */
ints = (ints ^ float64_ts);      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints ^ bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ uints)>::value, "");
uints = (uints ^ halfs);         /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ floats);        /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ doubles);       /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ min16floats);   /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ min10floats);   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint, __decltype(uints ^ min16ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ min16uints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ int16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uints ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uints ^ uint64_ts)>::value, "");
uints = (uints ^ float16_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ float32_ts);    /* expected-error {{int or unsigned int type required}} */
uints = (uints ^ float64_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ bools);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ ints);          /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ uints);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ halfs);         /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ floats);        /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ doubles);       /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ min16floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ min10floats);   /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ min16ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ min12ints);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ min16uints);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ int16_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ int32_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ int64_ts);      /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ uint16_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ uint32_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ uint64_ts);     /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ float16_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ float32_ts);    /* expected-error {{int or unsigned int type required}} */
halfs = (halfs ^ float64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ bools);       /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ ints);        /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ uints);       /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ halfs);       /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ floats);      /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ doubles);     /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ min16floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ min10floats); /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ min16ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ min12ints);   /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ min16uints);  /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ int16_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ int32_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ int64_ts);    /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ uint16_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ uint32_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ uint64_ts);   /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ float16_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ float32_ts);  /* expected-error {{int or unsigned int type required}} */
floats = (floats ^ float64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ bools);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ ints);      /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ uints);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ halfs);     /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ floats);    /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ doubles);   /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ min16floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ min10floats);                          /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ min16ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ min12ints); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ min16uints);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ int16_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ int32_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ int64_ts);  /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ uint16_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ uint32_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ uint64_ts); /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ float16_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ float32_ts);                           /* expected-error {{int or unsigned int type required}} */
doubles = (doubles ^ float64_ts);                           /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ bools);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ ints);                         /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ uints);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ halfs);                        /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ floats);                       /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ doubles);                      /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ min16floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ min10floats);                  /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ min16ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ min12ints);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ min16uints);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min16floats = (min16floats ^ float64_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ bools);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ ints);                         /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ uints);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ halfs);                        /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ floats);                       /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ doubles);                      /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ min16floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ min10floats);                  /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ min16ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ min12ints);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ min16uints);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ int16_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ int32_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ int64_ts);                     /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ uint16_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ uint32_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ uint64_ts);                    /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ float16_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ float32_ts);                   /* expected-error {{int or unsigned int type required}} */
min10floats = (min10floats ^ float64_ts);                   /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints ^ bools)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min16ints ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16ints ^ uints)>::value, "");
min16ints = (min16ints ^ halfs); /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ floats);                           /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ doubles);                          /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ min16floats);                      /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints ^ min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16int, __decltype(min16ints ^ min12ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16ints ^ min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min16ints ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min16ints ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min16ints ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16ints ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16ints ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16ints ^ uint64_ts)>::value, "");
min16ints = (min16ints ^ float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min16ints = (min16ints ^ float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints ^ bools)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<int, __decltype(min12ints ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min12ints ^ uints)>::value, "");
min12ints = (min12ints ^ halfs); /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ floats);                           /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ doubles);                          /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ min16floats);                      /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16int, __decltype(min12ints ^ min16ints)>::value, "");    /* expected-warning {{min16int is promoted to int16_t}} */
_Static_assert(std::is_same<min12int, __decltype(min12ints ^ min12ints)>::value, "");    /* expected-warning {{min12int is promoted to int16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min12ints ^ min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<int16_t, __decltype(min12ints ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(min12ints ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(min12ints ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min12ints ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min12ints ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min12ints ^ uint64_ts)>::value, "");
min12ints = (min12ints ^ float16_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ float32_ts);                       /* expected-error {{int or unsigned int type required}} */
min12ints = (min12ints ^ float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^ bools)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint, __decltype(min16uints ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(min16uints ^ uints)>::value, "");
min16uints = (min16uints ^ halfs);                          /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ floats);                         /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ doubles);                        /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ min16floats);                    /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ min10floats);                    /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^ min16ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^ min12ints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<min16uint, __decltype(min16uints ^ min16uints)>::value, "");    /* expected-warning {{min16uint is promoted to uint16_t}} */
_Static_assert(std::is_same<uint16_t, __decltype(min16uints ^ int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints ^ int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(min16uints ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(min16uints ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(min16uints ^ uint64_ts)>::value, "");
min16uints = (min16uints ^ float16_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ float32_ts);                     /* expected-error {{int or unsigned int type required}} */
min16uints = (min16uints ^ float64_ts);                     /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^ bools)>::value, "");
_Static_assert(std::is_same<int, __decltype(int16_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(int16_ts ^ uints)>::value, "");
int16_ts = (int16_ts ^ halfs);   /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ floats);  /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ doubles); /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ min16floats);                        /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<int16_t, __decltype(int16_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int16_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int16_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(int16_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int16_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int16_ts ^ uint64_ts)>::value, "");
int16_ts = (int16_ts ^ float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int16_ts = (int16_ts ^ float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ bools)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts ^ uints)>::value, "");
int32_ts = (int32_ts ^ halfs);   /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ floats);  /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ doubles); /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ min16floats);                        /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int32_t, __decltype(int32_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int32_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(int32_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int32_ts ^ uint64_ts)>::value, "");
int32_ts = (int32_ts ^ float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int32_ts = (int32_ts ^ float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ bools)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts ^ uints)>::value, "");
int64_ts = (int64_ts ^ halfs);   /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ floats);  /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ doubles); /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ min16floats);                        /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ min10floats);                        /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<int64_t, __decltype(int64_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(int64_ts ^ uint64_ts)>::value, "");
int64_ts = (int64_ts ^ float16_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ float32_ts);                         /* expected-error {{int or unsigned int type required}} */
int64_ts = (int64_ts ^ float64_ts);                         /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ bools)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint, __decltype(uint16_ts ^ uints)>::value, "");
uint16_ts = (uint16_ts ^ halfs); /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ floats);                           /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ doubles);                          /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint16_t, __decltype(uint16_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint16_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint16_ts ^ uint64_ts)>::value, "");
uint16_ts = (uint16_ts ^ float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint16_ts = (uint16_ts ^ float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ bools)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ uints)>::value, "");
uint32_ts = (uint32_ts ^ halfs); /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ floats);                           /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ doubles);                          /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint32_t, __decltype(uint32_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint32_ts ^ uint64_ts)>::value, "");
uint32_ts = (uint32_ts ^ float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint32_ts = (uint32_ts ^ float64_ts);                       /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ bools)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ uints)>::value, "");
uint64_ts = (uint64_ts ^ halfs); /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ floats);                           /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ doubles);                          /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ min16floats);                      /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ min10floats);                      /* expected-error {{int or unsigned int type required}} */
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ min16ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ min12ints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ min16uints)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ int16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ int32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ int64_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ uint16_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ uint32_ts)>::value, "");
_Static_assert(std::is_same<uint64_t, __decltype(uint64_ts ^ uint64_ts)>::value, "");
uint64_ts = (uint64_ts ^ float16_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ float32_ts);                       /* expected-error {{int or unsigned int type required}} */
uint64_ts = (uint64_ts ^ float64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ bools);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ ints);                           /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ uints);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ halfs);                          /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ floats);                         /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ doubles);                        /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ min16floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ min10floats);                    /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ min16ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ min12ints);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ min16uints);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float16_ts = (float16_ts ^ float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ bools);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ ints);                           /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ uints);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ halfs);                          /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ floats);                         /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ doubles);                        /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ min16floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ min10floats);                    /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ min16ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ min12ints);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ min16uints);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float32_ts = (float32_ts ^ float64_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ bools);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ ints);                           /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ uints);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ halfs);                          /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ floats);                         /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ doubles);                        /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ min16floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ min10floats);                    /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ min16ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ min12ints);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ min16uints);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ int16_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ int32_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ int64_ts);                       /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ uint16_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ uint32_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ uint64_ts);                      /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ float16_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ float32_ts);                     /* expected-error {{int or unsigned int type required}} */
float64_ts = (float64_ts ^ float64_ts);                     /* expected-error {{int or unsigned int type required}} */
// GENERATED_BINARY_ARITH:END
  return param4;

}
