.\" Copyright 1993 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Error-Msg XtApp-Set-Error-Msg-Handler XtApp-Set-Warning-Msg-Handler XtApp-Warning-Msg wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtAppErrorMsg __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppErrorMsg, XtAppSetErrorMsgHandler, XtAppSetWarningMsgHandler, XtAppWarningMsg \- high-level error handlers
.SH SYNTAX
.HP
void XtAppErrorMsg(XtAppContext \fIapp_context\fP, String \fIname\fP, String
\fItype\fP, String \fIclass\fP, String \fIdefault\fP, String *\fIparams\fP,
Cardinal *\fInum_params\fP);
.HP
void XtAppSetErrorMsgHandler(XtAppContext \fIapp_context\fP, XtErrorMsgHandler
\fImsg_handler\fP);
.HP
void XtAppSetWarningMsgHandler(XtAppContext \fIapp_context\fP,
XtErrorMsgHandler \fImsg_handler\fP);
.HP
void XtAppWarningMsg(XtAppContext \fIapp_context\fP, String \fIname\fP, String
\fItype\fP, String \fIclass\fP, String \fIdefault\fP, String *\fIparams\fP,
Cardinal *\fInum_params\fP);
.SH ARGUMENTS
.IP \fIapp_context\fP 1i
Specifies the application context.
.ds Cl
.IP \fIclass\fP 1i
Specifies the resource class\*(Cl.
.IP \fIdefault\fP 1i
Specifies the default message to use\*(Dm.
.IP \fIname\fP 1i
Specifies the general kind of error.
.IP \fItype\fP 1i
Specifies the detailed name of the error.
.ds Mh fatal error procedure, which should not return \
or the nonfatal error procedure, which usually returns
.IP \fImsg_handler\fP 1i
Specifies the new \*(Mh.
.IP \fInum_params\fP 1i
Specifies the number of values in the parameter list.
.IP \fIparams\fP 1i
Specifies a pointer to a list of values to be stored in the message.
.SH DESCRIPTION
The
.ZN XtAppErrorMsg
function calls the high-level error handler and passes the specified
information.
.LP
The
.ZN XtAppSetErrorMsgHandler
function registers the specified  procedure,
which is called when a fatal error occurs.
.LP
The
.ZN XtAppSetWarningMsgHandler
function registers the specified procedure,
which is called when a nonfatal error condition occurs.
.LP
The
.ZN XtAppWarningMsg
function calls the high-level error handler and passes the specified
information.
.SH "SEE ALSO"
XtAppGetErrorDatabase(__libmansuffix__),
XtAppError(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
