/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* sparql.sql */

static const char *tbl0 = 
"create table DB.DBA.RDF_QUAD (\n"
"G IRI_ID_8,\n"
"S IRI_ID_8,\n"
"P IRI_ID_8,\n"
"O any,\n"
"primary key (P, S, O, G)\n"
")\n"
"alter index RDF_QUAD on DB.DBA.RDF_QUAD partition (S int (0hexffff00))\n"
"\n"
"create distinct no primary key ref bitmap index RDF_QUAD_SP on RDF_QUAD (S, P) partition (S int (0hexffff00))\n"
"create bitmap index RDF_QUAD_POGS on RDF_QUAD (P, O, G, S) partition (O varchar (-1, 0hexffff))\n"
"create distinct no primary key ref bitmap index RDF_QUAD_GS on RDF_QUAD (G, S) partition (S int (0hexffff00))\n"
"create distinct no primary key ref index RDF_QUAD_OP on RDF_QUAD (O, P) partition (O varchar (-1, 0hexffff))\n";

static const char *tbl1 = 
"create table DB.DBA.RDF_QUAD_RECOV_TMP (\n"
"G1 IRI_ID_8,  S1 IRI_ID_8,  P1 IRI_ID_8,  O1 any,  primary key (P1, S1, O1, G1))\n"
"alter index RDF_QUAD_RECOV_TMP on DB.DBA.RDF_QUAD_RECOV_TMP partition (S1 int (0hexffff00))\n"
"create bitmap index RDF_QUAD_RECOV_TMP_POGS on RDF_QUAD_RECOV_TMP (P1, O1, G1, S1) partition (O1 varchar (-1, 0hexffff))\n"
"create distinct no primary key ref index RDF_QUAD_RECOV_TMP_OP on RDF_QUAD_RECOV_TMP (O1, P1) partition (O1 varchar (-1, 0hexffff))\n";

static const char *proc0 = 
"#line 46 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE (in qname any) returns IRI_ID\n"
"{\n"
"return iri_to_id_nosignal (qname);\n"
"}\n"
"--src sparql.sql:44\n";

static const char *proc1 = 
"#line 52 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP (in qname any) returns IRI_ID\n"
"{\n"
"return iri_to_id_nosignal (qname, 0);\n"
"}\n"
"--src sparql.sql:50\n";

static const char *proc2 = 
"#line 58 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QNAME_OF_IID (in iid IRI_ID) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (iid);\n"
"}\n"
"--src sparql.sql:56\n";

static const char *other0 = 
"DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE (null)\n";
static const char *other1 = 
"DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP (null)\n";
static const char *other2 = 
"DB.DBA.RDF_QNAME_OF_IID (null)\n";
static const char *tbl2 = 
"create table DB.DBA.RDF_OBJ (\n"
"RO_ID bigint primary key,\n"
"RO_VAL varchar not null,\n"
"RO_LONG long varchar,\n"
"RO_FLAGS smallint not null default 0,\n"
"RO_DT_AND_LANG integer not null default 16843009 compress any\n"
")\n"
"alter index RDF_OBJ on RDF_OBJ partition (RO_ID int (0hexffff00))\n"
"\n"
"create index RO_VAL on DB.DBA.RDF_OBJ (RO_VAL, RO_DT_AND_LANG)\n"
"partition (RO_VAL varchar (-4, 0hexffff))\n";

static const char *tbl3 = 
"create table DB.DBA.RO_START (RS_START varchar, RS_DT_AND_LANG int, RS_RO_ID any,\n"
"primary key (RS_START, RS_DT_AND_LANG, RS_RO_ID))\n"
"alter index RO_START on DB.DBA.RO_START partition (RS_RO_ID varchar (-1, 0hexffff))\n";

static const char *tbl4 = 
"create table DB.DBA.RDF_DATATYPE (\n"
"RDT_IID IRI_ID_8 not null primary key,\n"
"RDT_TWOBYTE integer not null unique,\n"
"RDT_QNAME varchar not null unique )\n"
"alter index RDF_DATATYPE on RDF_DATATYPE partition cluster replicated\n"
"alter index DB_DBA_RDF_DATATYPE_UNQC_RDT_TWOBYTE   on RDF_DATATYPE partition cluster replicated\n"
"alter index DB_DBA_RDF_DATATYPE_UNQC_RDT_QNAME on RDF_DATATYPE partition cluster replicated\n";

static const char *tbl5 = 
"create table DB.DBA.RDF_LANGUAGE (\n"
"RL_ID varchar not null primary key,\n"
"RL_TWOBYTE integer not null unique )\n"
"alter index RDF_LANGUAGE on RDF_LANGUAGE  partition cluster replicated\n"
"alter index DB_DBA_RDF_LANGUAGE_UNQC_RL_TWOBYTE on RDF_LANGUAGE  partition cluster replicated\n";

static const char *tbl6 = 
"create table DB.DBA.SYS_SPARQL_HOST (\n"
"SH_HOST	varchar not null primary key,\n"
"SH_GRAPH_URI	varchar,\n"
"SH_USER_URI	varchar,\n"
"SH_BASE_URI	varchar,\n"
"SH_DEFINES	long varchar\n"
")\n";

static const char *alter0 = 
"alter table DB.DBA.SYS_SPARQL_HOST add SH_BASE_URI varchar\n";

static const char *tbl7 = 
"create table DB.DBA.RDF_OBJ_FT_RULES (\n"
"ROFR_G varchar not null,\n"
"ROFR_P varchar not null,\n"
"ROFR_REASON varchar not null,\n"
"primary key (ROFR_G, ROFR_P, ROFR_REASON) )\n"
"alter index RDF_OBJ_FT_RULES on RDF_OBJ_FT_RULES partition cluster replicated\n";

static const char *tbl8 = 
"create table DB.DBA.SYS_SPARQL_SW_LOG (\n"
"PL_SERVER varchar,\n"
"PL_URI    varchar,\n"
"PL_TS     timestamp,\n"
"PL_RC     varchar,\n"
"PL_MSG    long varchar,\n"
"primary key (PL_SERVER, PL_URI, PL_TS))\n";

static const char *tbl9 = 
"create table DB.DBA.SYS_XML_PERSISTENT_NS_DECL\n"
"(\n"
"NS_PREFIX varchar not null primary key,\n"
"NS_URL varchar not null\n"
")\n"
"alter index SYS_XML_PERSISTENT_NS_DECL on SYS_XML_PERSISTENT_NS_DECL partition cluster replicated\n";

static const char *tbl10 = 
"create table DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH\n"
"(\n"
"REC_GRAPH_IID IRI_ID not null primary key\n"
")\n"
"alter index RDF_EXPLICITLY_CREATED_GRAPH on RDF_EXPLICITLY_CREATED_GRAPH partition cluster replicated\n";

static const char *tbl11 = 
"create table RDF_GEO (X real no compress, Y real no compress,X2 real no compress, Y2 real no compress, ID bigint no compress, primary key (X, Y, X2, Y2, ID))\n"
"alter index RDF_GEO on RDF_GEO partition (ID int (0hexffff00))\n";

static const char *tbl12 = 
"create table DB.DBA.RDF_LABEL (RL_O any primary key, RL_RO_ID bigint, RL_TEXT varchar, RL_LANG int)\n"
"alter index RDF_LABEL on RDF_LABEL partition (RL_O varchar (-1, 0hexffff))\n"
"create index RDF_LABEL_TEXT on RDF_LABEL (RL_TEXT, RL_O) partition (RL_TEXT varchar (6, 0hexffff))\n";

static const char *tbl13 = 
"create table DB.DBA.RDF_QUAD_DELETE_QUEUE (\n"
"EVENT_ID bigint not null,\n"
"RULE_ID bigint not null,\n"
"QG IRI_ID not null,\n"
"QS IRI_ID not null,\n"
"QP IRI_ID not null,\n"
"QO any not null,\n"
"primary key (EVENT_ID, RULE_ID,  QG, QS, QP, QO)\n"
")\n";

static const char *tbl14 = 
"create table DB.DBA.SYS_IDONLY_EMPTY\n"
"(\n"
"ID integer not null primary key\n"
")\n";

static const char *tbl15 = 
"create table DB.DBA.SYS_IDONLY_ONE\n"
"(\n"
"ID integer not null primary key\n"
")\n";

static const char *other3 = 
"insert soft DB.DBA.SYS_IDONLY_ONE (ID) values (0)\n";
static const char *other4 = 
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 1)\n";
static const char *other5 = 
"sequence_set (\'RDF_PREF_SEQ\', 1, 1)\n";
static const char *other6 = 
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1)\n";
static const char *other7 = 
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 1)\n";
static const char *other8 = 
"sequence_set (\'RDF_RO_ID\', 1, 1)\n";
static const char *other9 = 
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 1)\n";
static const char *other10 = 
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 1)\n";
static const char *proc3 = 
"#line 223 \"[executable]/sparql.sql\"\n"
"create procedure RDF_QUAD_FT_INIT ()\n"
"{\n"
"if (not exists (select 1 from SYS_VT_INDEX where VI_COL = \'o\'))\n"
"{\n"
"insert soft SYS_VT_INDEX (VI_TABLE, VI_INDEX, VI_COL, VI_ID_COL, VI_INDEX_TABLE, VI_ID_IS_PK, VI_OPTIONS)\n"
"values (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'O\', \'O\', \'DB.DBA.RDF_GEO\', 1, \'GR\');\n"
"insert soft SYS_VT_INDEX (VI_TABLE, VI_INDEX, VI_COL, VI_ID_COL, VI_INDEX_TABLE, VI_ID_IS_PK, VI_OPTIONS)\n"
"values (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'o\', \'O\', \'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\', 1, null);\n"
"__ddl_changed (\'DB.DBA.RDF_QUAD\');\n"
"}\n"
"}\n"
"--src sparql.sql:221\n";

static const char *proc4 = 
"#line 236 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_OBJ_RO_FLAGS_INDEX_HOOK (inout vtb any, inout d_id any)\n"
"{\n"
"for (select RO_LONG, RO_VAL, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (no cluster) where RO_ID=d_id and bit_and (RO_FLAGS, 1)) do\n"
"{\n"
"if (bit_and (RO_FLAGS, 2))\n"
"vt_batch_feed (vtb, xml_tree_doc (__xml_deserialize_packed (RO_LONG)), 0);\n"
"else\n"
"vt_batch_feed (vtb, coalesce (RO_LONG, RO_VAL), 0);\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:234\n";

static const char *proc5 = 
"#line 250 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_OBJ_RO_FLAGS_UNINDEX_HOOK (inout vtb any, inout d_id any)\n"
"{\n"
"for (select RO_LONG, RO_VAL, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (no cluster) where RO_ID=d_id and bit_and (RO_FLAGS, 1)) do\n"
"{\n"
"if (bit_and (RO_FLAGS, 2))\n"
"vt_batch_feed (vtb, xml_tree_doc (__xml_deserialize_packed (RO_LONG)), 1);\n"
"else\n"
"vt_batch_feed (vtb, coalesce (RO_LONG, RO_VAL), 1);\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:248\n";

static const char *proc6 = 
"#line 264 \"[executable]/sparql.sql\"\n"
"create procedure sparql_exec_quiet (in expn varchar)\n"
"{\n"
"declare sta, msg varchar;\n"
"exec (expn, sta, msg);\n"
"}\n"
"--src sparql.sql:262\n";

static const char *other11 = 
"sparql_exec_quiet (\'DB.DBA.vt_create_text_index (\n"
"fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'),\n"
"fix_identifier_case (\'\'RO_FLAGS\'\'),\n"
"fix_identifier_case (\'\'RO_ID\'\'),\n"
"0, 0, vector (), 1, \'\'*ini*\'\', \'\'UTF-8-QR\'\')\')\n";
static const char *other12 = 
"sparql_exec_quiet (\'DB.DBA.vt_batch_update (fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'), \'\'ON\'\', 1)\')\n";
static const char *proc7 = 
"#line 285 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.XML_SET_NS_DECL (in prefix varchar, in url varchar, in persist integer := 1) returns integer\n"
"{\n"
"declare res integer;\n"
"res := __xml_set_ns_decl (prefix, url, persist);\n"
"if (bit_and (res, 2))\n"
"{\n"
"declare exit handler for sqlstate \'*\' { __xml_remove_ns_by_prefix (prefix, persist); resignal; };\n"
"if (exists (select 1 from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX = prefix and NS_URL = url))\n"
"return;\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX = prefix;\n"
"insert into DB.DBA.SYS_XML_PERSISTENT_NS_DECL (NS_PREFIX, NS_URL) values (prefix, url);\n"
"commit work;\n"
"}\n"
"return res;\n"
"}\n"
"--src sparql.sql:283\n";

static const char *proc8 = 
"#line 303 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.XML_REMOVE_NS_BY_PREFIX (in prefix varchar, in persist integer := 1)\n"
"{\n"
"declare res integer;\n"
"__xml_remove_ns_by_prefix (prefix, persist);\n"
"if (bit_and (persist, 2))\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL where NS_PREFIX=prefix;\n"
"commit work;\n"
"}\n"
"}\n"
"--src sparql.sql:301\n";

static const char *proc9 = 
"#line 318 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.XML_CLEAR_ALL_NS_DECLS (in persist integer := 1)\n"
"{\n"
"declare res integer;\n"
"__xml_clear_all_ns_decls (persist);\n"
"if (bit_and (persist, 2))\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"delete from DB.DBA.SYS_XML_PERSISTENT_NS_DECL;\n"
"commit work;\n"
"}\n"
"}\n"
"--src sparql.sql:316\n";

static const char *proc10 = 
"#line 333 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.XML_SELECT_ALL_NS_DECLS (in persist integer := 3)\n"
"{\n"
"declare decls any;\n"
"declare ctr, len integer;\n"
"declare PREFIX, URI varchar;\n"
"decls := __xml_get_all_ns_decls (persist);\n"
"result_names (PREFIX, URI);\n"
"len := length (decls);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"result (decls[ctr], decls[ctr+1]);\n"
"}\n"
"--src sparql.sql:331\n";

static const char *proc11 = 
"#line 346 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.XML_LOAD_ALL_NS_DECLS ()\n"
"{\n"
"for (select NS_PREFIX, NS_URL from DB.DBA.SYS_XML_PERSISTENT_NS_DECL) do\n"
"{\n"
"__xml_set_ns_decl (NS_PREFIX, NS_URL, 2);\n"
"}\n"
"DB.DBA.XML_SET_NS_DECL (	\'bif\'	, \'bif:\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dawgt\'	, \'http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dbpedia\'	, \'http://dbpedia.org/resource/\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dbpprop\'	, \'http://dbpedia.org/property/\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'dc\'	, \'http://purl.org/dc/elements/1.1/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'go\'	, \'http://purl.org/obo/owl/GO#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'geo\'	, \'http://www.w3.org/2003/01/geo/wgs84_pos#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'fn\'	, \'http://www.w3.org/2005/xpath-functions/#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'foaf\'	, \'http://xmlns.com/foaf/0.1/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'obo\'	, \'http://www.geneontology.org/formats/oboInOwl#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'owl\'	, \'http://www.w3.org/2002/07/owl#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'mesh\'	, \'http://purl.org/commons/record/mesh/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'math\'	, \'http://www.w3.org/2000/10/swap/math#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'mf\'	, \'http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'nci\'	, \'http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'product\'	, \'http://www.buy.com/rss/module/productV2/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'protseq\'	, \'http://purl.org/science/protein/bysequence/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdf\'	, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdfa\'	, \'http://www.w3.org/ns/rdfa#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdfdf\'	, \'http://www.openlinksw.com/virtrdf-data-formats#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'rdfs\'	, \'http://www.w3.org/2000/01/rdf-schema#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sc\'	, \'http://purl.org/science/owl/sciencecommons/\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sd\'	, \'http://www.w3.org/ns/sparql-service-description#\'		, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sioc\'	, \'http://rdfs.org/sioc/ns#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'skos\'	, \'http://www.w3.org/2004/02/skos/core#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'sql\'	, \'sql:\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'vcard\'	, \'http://www.w3.org/2001/vcard-rdf/3.0#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'vcard2006\'	, \'http://www.w3.org/2006/vcard/ns#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'virtrdf\'	, \'http://www.openlinksw.com/schemas/virtrdf#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'virtcxml\'	, \'http://www.openlinksw.com/schemas/virtcxml#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'void\'	, \'http://rdfs.org/ns/void#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xf\'	, \'http://www.w3.org/2004/07/xpath-functions\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xml\'	, \'http://www.w3.org/XML/1998/namespace\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsd\'	, \'http://www.w3.org/2001/XMLSchema#\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsl10\'	, \'http://www.w3.org/XSL/Transform/1.0\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xsl1999\'	, \'http://www.w3.org/1999/XSL/Transform\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'xslwd\'	, \'http://www.w3.org/TR/WD-xsl\'	, 2);\n"
"DB.DBA.XML_SET_NS_DECL (	\'yago\'	, \'http://dbpedia.org/class/yago/\'	, 2);\n"
"}\n"
"--src sparql.sql:344\n";

static const char *other13 = 
"DB.DBA.XML_LOAD_ALL_NS_DECLS ()\n";
static const char *other14 = 
"rdf_inf_const_init ()\n";
static const char *proc12 = 
"#line 399 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_ALL_FT_RULES ()\n"
"{\n"
"whenever sqlstate \'*\' goto again;\n"
"again:\n"
"for (select ROFR_G as rule_g, ROFR_P as rule_p, ROFR_REASON as reason from DB.DBA.RDF_OBJ_FT_RULES) do\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"\n"
"__rdf_obj_ft_rule_add (rule_g_iid, rule_p_iid, reason);\n"
"}\n"
"}\n"
"--src sparql.sql:397\n";

static const char *other15 = 
"DB.DBA.RDF_LOAD_ALL_FT_RULES ()\n";
static const char *proc13 = 
"#line 417 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_START (in quiet integer := 0)\n"
"{\n"
"if (repl_this_server () is null)\n"
"return;\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')))\n"
"{\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', \'RDF replication is already enabled\');\n"
"}\n"
"for (select RGGM_MEMBER_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\')\n"
"and not __rgs_ack_cbk (RGGM_MEMBER_IID, __rdf_repl_uid(), 1) ) do\n"
"{\n"
"signal (\'RDF99\', \'RDF replication can not be enabled because it will violate security rules for read access to graph <\' || id_to_iri(RGGM_MEMBER_IID) || \'> by __rdf_repl account\');\n"
"}\n"
"repl_publish (\'__rdf_repl\', \'__rdf_repl.log\');\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue()\');\n"
"DB.DBA.RDF_GRAPH_GROUP_CREATE (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\', 1);\n"
"DB.DBA.CL_EXEC (\'registry_set (?,?)\', vector (\'DB.DBA.RDF_REPL\', cast (now() as varchar)));\n"
"exec (\'checkpoint\');\n"
"}\n"
"--src sparql.sql:415\n";

static const char *proc14 = 
"#line 441 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_STOP (in quiet integer := 0)\n"
"{\n"
"if (not isstring (registry_get (\'DB.DBA.RDF_REPL\')))\n"
"{\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', \'RDF replication is not enabled\');\n"
"}\n"
"repl_unpublish (\'__rdf_repl\');\n"
"DB.DBA.CL_EXEC (\'registry_remove (?)\', vector (\'DB.DBA.RDF_REPL\'));\n"
"}\n"
"--src sparql.sql:439\n";

static const char *proc15 = 
"#line 454 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_GRAPH_INS (in memb_iri varchar)\n"
"{\n"
"declare memb_iid IRI_ID;\n"
"memb_iid := iri_to_id (memb_iri);\n"
"memb_iri := id_to_iri (memb_iid);\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\', memb_iri);\n"
"}\n"
"--src sparql.sql:452\n";

static const char *proc16 = 
"#line 463 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_GRAPH_DEL (in memb_iri varchar)\n"
"{\n"
"declare memb_iid IRI_ID;\n"
"DB.DBA.RDF_GRAPH_GROUP_DEL (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\', memb_iri);\n"
"}\n"
"--src sparql.sql:461\n";

static const char *proc17 = 
"#line 470 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_SYNC (in publisher varchar, in u varchar, in pwd varchar)\n"
"{\n"
"declare lvl, stat integer;\n"
"if (repl_this_server () is null)\n"
"return;\n"
"commit work;\n"
"retr:\n"
"\n"
"repl_sync (publisher, \'__rdf_repl\', u, pwd);\n"
"again:\n"
"repl_status (publisher, \'__rdf_repl\', lvl, stat);\n"
"if (0 = stat)\n"
"{\n"
"__rdf_repl_flush_queue();\n"
"return;\n"
"}\n"
"if (1 = stat)\n"
"{\n"
"delay (0.1);\n"
"goto again;\n"
"}\n"
"if (2 = stat)\n"
"{\n"
"__rdf_repl_flush_queue();\n"
"return;\n"
"}\n"
"goto retr;\n"
"}\n"
"--src sparql.sql:468\n";

static const char *proc18 = 
"#line 501 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_INSERT_TRIPLES (in graph_iri varchar, inout triples any)\n"
"{\n"
"declare ctr integer;\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare s_iri, p_iri, o_val, o_type, o_lang any;\n"
"s_iri := iri_canonicalize (triples[ctr][0]);\n"
"p_iri := iri_canonicalize (triples[ctr][1]);\n"
"o_val := triples[ctr][2];\n"
"if (isiri_id (o_val))\n"
"__rdf_repl_quad (84, graph_iri, s_iri, p_iri, iri_canonicalize (o_val));\n"
"else if (__tag of rdf_box <> __tag (o_val))\n"
"__rdf_repl_quad (80, graph_iri, s_iri, p_iri, o_val);\n"
"else\n"
"{\n"
"declare dt_twobyte, lang_twobyte integer;\n"
"dt_twobyte := rdf_box_type (o_val);\n"
"lang_twobyte := rdf_box_lang (o_val);\n"
"if (257 <> dt_twobyte)\n"
"__rdf_repl_quad (81, graph_iri, s_iri, p_iri, rdf_box_data (o_val), (select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = dt_twobyte), NULL);\n"
"else if (257 <> lang_twobyte)\n"
"__rdf_repl_quad (82, graph_iri, s_iri, p_iri, rdf_box_data (o_val), NULL, (select RL_ID from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = lang_twobyte));\n"
"else\n"
"__rdf_repl_quad (80, graph_iri, s_iri, p_iri, rdf_box_data (o_val));\n"
"}\n"
"}\n"
"}\n"
"--src sparql.sql:499\n";

static const char *proc19 = 
"#line 530 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_DELETE_TRIPLES (in graph_iri varchar, inout triples any)\n"
"{\n"
"declare ctr integer;\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare s_iri, p_iri, o_val, o_type, o_lang any;\n"
"s_iri := iri_canonicalize (triples[ctr][0]);\n"
"p_iri := iri_canonicalize (triples[ctr][1]);\n"
"o_val := triples[ctr][2];\n"
"if (isiri_id (o_val))\n"
"__rdf_repl_quad (164, graph_iri, s_iri, p_iri, iri_canonicalize (o_val));\n"
"else if (__tag of rdf_box <> __tag (o_val))\n"
"__rdf_repl_quad (160, graph_iri, s_iri, p_iri, o_val);\n"
"else\n"
"{\n"
"declare dt_twobyte, lang_twobyte integer;\n"
"dt_twobyte := rdf_box_type (o_val);\n"
"lang_twobyte := rdf_box_lang (o_val);\n"
"if (257 <> dt_twobyte)\n"
"__rdf_repl_quad (161, graph_iri, s_iri, p_iri, rdf_box_data (o_val), (select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = dt_twobyte), NULL);\n"
"else if (257 <> lang_twobyte)\n"
"__rdf_repl_quad (162, graph_iri, s_iri, p_iri, rdf_box_data (o_val), NULL, (select RL_ID from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = lang_twobyte));\n"
"else\n"
"__rdf_repl_quad (160, graph_iri, s_iri, p_iri, rdf_box_data (o_val));\n"
"}\n"
"}\n"
"}\n"
"--src sparql.sql:528\n";


static const char *proc20 = 
"#line 560 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_GLOBAL_RESET (in hard integer := 0)\n"
"{\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')))\n"
"{\n"
"signal (\'42RDF\', \'Can not make DB.DBA.RDF_GLOBAL_RESET while an RDF replication is enabled\');\n"
"}\n"
"\n"
"__atomic (1);\n"
"iri_id_cache_flush ();\n"
"__rdf_obj_ft_rule_zap_all ();\n"
"dict_zap (__rdf_graph_group_dict(), 2);\n"
"dict_zap (__rdf_graph_group_of_privates_dict(), 2);\n"
"dict_zap (__rdf_graph_default_perms_of_user_dict(0), 2);\n"
"dict_zap (__rdf_graph_default_perms_of_user_dict(1), 2);\n"
"dict_zap (__rdf_graph_public_perms_dict(), 2);\n"
"for select RS_NAME from DB.DBA.SYS_RDF_SCHEMA do\n"
"rdf_inf_clear (RS_NAME);\n"
"delete from sys_rdf_schema;\n"
"delete from DB.DBA.RDF_QUAD;\n"
"delete from DB.DBA.RDF_OBJ_FT_RULES;\n"
"delete from DB.DBA.RDF_GRAPH_GROUP;\n"
"for (select __id2i(t.RGU_GRAPH_IID) as graph_iri from (select distinct RGU_GRAPH_IID from DB.DBA.RDF_GRAPH_USER) as t) do\n"
"{\n"
"if (graph_iri is not null)\n"
"{\n"
"jso_mark_affected (graph_iri);\n"
"log_text (\'jso_mark_affected (?)\', graph_iri);\n"
"jso_mark_affected (iri_canonicalize (graph_iri));\n"
"log_text (\'jso_mark_affected (?)\', iri_canonicalize (graph_iri));\n"
"log_text (\'jso_mark_affected (iri_canonicalize (?))\', graph_iri);\n"
"}\n"
"}\n"
"for (select __id2i(t.RGGM_GROUP_IID) as group_iri from (select distinct RGGM_GROUP_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER) as t) do\n"
"{\n"
"if (group_iri is not null)\n"
"{\n"
"jso_mark_affected (group_iri);\n"
"log_text (\'jso_mark_affected (?)\', group_iri);\n"
"}\n"
"}\n"
"for (select __id2i(RGGM_MEMBER_IID) as memb_iri from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = __i2id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')) do\n"
"{\n"
"if (memb_iri is not null)\n"
"{\n"
"jso_mark_affected (memb_iri);\n"
"log_text (\'jso_mark_affected (?)\', memb_iri);\n"
"}\n"
"}\n"
"for (sparql define input:storage \"\" select distinct str (?qms) as ?qms_iri from virtrdf: where { ?qms a virtrdf:QuadStorage } ) do\n"
"{\n"
"if (\"qms_iri\" is not null)\n"
"{\n"
"jso_mark_affected (\"qms_iri\");\n"
"log_text (\'jso_mark_affected (?)\', \"qms_iri\");\n"
"}\n"
"}\n"
"jso_mark_affected (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\');\n"
"log_text (\'jso_mark_affected (?)\', \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\');\n"
"jso_mark_affected (\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\');\n"
"log_text (\'jso_mark_affected (?)\', \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\');\n"
"jso_mark_affected (\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\');\n"
"log_text (\'jso_mark_affected (?)\', \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\');\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER;\n"
"delete from DB.DBA.RDF_GRAPH_USER;\n"
"delete from DB.DBA.RDF_LABEL;\n"
"delete from DB.DBA.RDF_GEO;\n"
"commit work;\n"
"if (hard)\n"
"{\n"
"\n"
"delete from DB.DBA.RDF_IRI;\n"
"delete from DB.DBA.RDF_PREFIX;\n"
"delete from DB.DBA.RDF_OBJ;\n"
"delete from DB.DBA.RO_START;\n"
"delete from DB.DBA.RDF_DATATYPE;\n"
"delete from DB.DBA.RDF_LANGUAGE;\n"
"\n"
"\n"
"delete from DB.DBA.VTLOG_DB_DBA_RDF_OBJ;\n"
"delete from DB.DBA.RDF_OBJ_RO_FLAGS_WORDS;\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 0);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 0);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 0);\n"
"sequence_set (\'RDF_PREF_SEQ\', 1, 0);\n"
"sequence_set (\'RDF_RO_ID\', 1, 0);\n"
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 0);\n"
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 0);\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"raw_exit ();\n"
"}\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1000000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()), 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 1, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1, 1);\n"
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 258, 1);\n"
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 258, 1);\n"
"DB.DBA.RDF_LOAD_ALL_FT_RULES ();\n"
"DB.DBA.TTLP (\n"
"cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar ),\n"
"\'\', \'http://www.openlinksw.com/schemas/virtrdf#\' );\n"
"DB.DBA.TTLP (\'\n"
"@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"@prefix atom: <http://atomowl.org/ontologies/atomrdf#> .\n"
"\n"
"virtrdf:DefaultQuadStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultQuadStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultQuadMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultQuadStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\n"
"virtrdf:DefaultServiceStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultServiceStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultServiceMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultServiceStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\n"
"virtrdf:SyncToQuads\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:SyncToQuads-UserMaps .\n"
"virtrdf:SyncToQuads-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\n"
"\', \'\', \'http://www.openlinksw.com/schemas/virtrdf#\' );\n"
"delete from SYS_HTTP_SPONGE where HS_PARSER = \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\';\n"
"commit work;\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1010000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 101, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1001, 1);\n"
"iri_id_cache_flush ();\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"--src sparql.sql:558\n";

static const char *proc21 = 
"#line 713 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_IID_OF_QNAME (in qname varchar) returns IRI_ID\n"
"{\n"
"return iri_to_id (qname);\n"
"}\n"
"--src sparql.sql:711\n";

static const char *proc22 = 
"#line 720 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_IID_OF_LONG (in qname any) returns IRI_ID\n"
"{\n"
"if (isiri_id (qname))\n"
"return qname;\n"
"if (not isstring (qname))\n"
"{\n"
"if (__tag of rdf_box = __tag (qname) and rdf_box_is_complete (qname))\n"
"qname := rdf_box_data (qname, 1);\n"
"else\n"
"qname := __rdf_strsqlval (qname);\n"
"}\n"
"return iri_to_id_nosignal (qname);\n"
"}\n"
"--src sparql.sql:718\n";

static const char *proc23 = 
"#line 735 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES (in qnames any) returns any\n"
"{\n"
"if (__tag of vector <> __tag (qnames))\n"
"return vector ();\n"
"declare res_acc any;\n"
"vectorbld_init (res_acc);\n"
"foreach (any qname in qnames) do\n"
"{\n"
"declare iid IRI_ID;\n"
"whenever sqlstate \'*\' goto skip_acc;\n"
"iid := iri_to_id (qname, 0, 0);\n"
"if (not isinteger (iid))\n"
"vectorbld_acc (res_acc, iid);\n"
"skip_acc: ;\n"
"}\n"
"vectorbld_final (res_acc);\n"
"return res_acc;\n"
"}\n"
"--src sparql.sql:733\n";

static const char *proc24 = 
"#line 758 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TWOBYTE_OF_DATATYPE (in iid any) returns integer\n"
"{\n"
"declare res integer;\n"
"declare qname varchar;\n"
"if (iid is null)\n"
"return 257;\n"
"if (not isiri_id (iid))\n"
"{\n"
"declare new_iid IRI_ID;\n"
"new_iid := iri_to_id (iid);\n"
"if (new_iid is NULL or new_iid >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'Invalid datatype IRI_ID passes as an argument to DB.DBA.RDF_TWOBYTE_OF_DATATYPE()\');\n"
"iid := new_iid;\n"
"}\n"
"qname := id_to_iri (iid);\n"
"res := rdf_cache_id (\'t\', qname);\n"
"if (res)\n"
"return res;\n"
"whenever not found goto mknew;\n"
"set isolation=\'committed\';\n"
"select RDT_TWOBYTE into res from DB.DBA.RDF_DATATYPE where RDT_IID = iid;\n"
"return res;\n"
"\n"
"mknew:\n"
"set isolation=\'serializable\';\n"
"declare tb_cr cursor for select RDT_TWOBYTE from DB.DBA.RDF_DATATYPE where RDT_IID = iid;\n"
"open tb_cr (exclusive);\n"
"whenever not found goto mknew_ser;\n"
"fetch tb_cr into res;\n"
"return res;\n"
"\n"
"mknew_ser:\n"
"res := sequence_next (\'RDF_DATATYPE_TWOBYTE\');\n"
"if (0 = bit_and (res, 255))\n"
"{\n"
"if (res = 0hex7F00)\n"
"{\n"
"sequence_set (\'RDF_DATATYPE_TWOBYTE\', 0hex7F00, 0);\n"
"res := 0hex7F01;\n"
"qname := \'http://www.openlinksw.com/schemas/virtrdf#Unsaved\';\n"
"iid := iri_to_id (qname);\n"
"insert soft DB.DBA.RDF_DATATYPE\n"
"(RDT_IID, RDT_TWOBYTE, RDT_QNAME)\n"
"values (iid, res, qname);\n"
"goto cache_and_log;\n"
"}\n"
"res := sequence_next (\'RDF_DATATYPE_TWOBYTE\');\n"
"}\n"
"insert into DB.DBA.RDF_DATATYPE\n"
"(RDT_IID, RDT_TWOBYTE, RDT_QNAME)\n"
"values (iid, res, qname);\n"
"cache_and_log:\n"
"rdf_cache_id (\'t\', qname, res);\n"
"log_text (\'rdf_cache_id (\\\'t\\\', ?, ?)\', qname, res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:756\n";

static const char *proc25 = 
"#line 816 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (in id varchar) returns integer\n"
"{\n"
"declare res integer;\n"
"if (id is null)\n"
"return 257;\n"
"id := lower (id);\n"
"res := rdf_cache_id (\'l\', id);\n"
"if (res)\n"
"return res;\n"
"whenever not found goto mknew;\n"
"set isolation=\'committed\';\n"
"select RL_TWOBYTE into res from DB.DBA.RDF_LANGUAGE where RL_ID = id;\n"
"return res;\n"
"\n"
"mknew:\n"
"set isolation=\'serializable\';\n"
"declare tb_cr cursor for select RL_TWOBYTE from DB.DBA.RDF_LANGUAGE where RL_ID = id;\n"
"open tb_cr (exclusive);\n"
"whenever not found goto mknew_ser;\n"
"fetch tb_cr into res;\n"
"return res;\n"
"\n"
"mknew_ser:\n"
"res := sequence_next (\'RDF_LANGUAGE_TWOBYTE\');\n"
"if (0 = bit_and (res, 255))\n"
"{\n"
"if (res = 0hex7F00)\n"
"{\n"
"sequence_set (\'RDF_LANGUAGE_TWOBYTE\', 0hex7F00, 0);\n"
"res := 0hex7F01;\n"
"id := \'x-unsaved\';\n"
"insert soft DB.DBA.RDF_LANGUAGE (RL_ID, RL_TWOBYTE) values (id, res);\n"
"goto cache_and_log;\n"
"}\n"
"res := sequence_next (\'RDF_LANGUAGE_TWOBYTE\');\n"
"}\n"
"insert into DB.DBA.RDF_LANGUAGE (RL_ID, RL_TWOBYTE) values (id, res);\n"
"cache_and_log:\n"
"rdf_cache_id (\'l\', id, res);\n"
"log_text (\'rdf_cache_id (\\\'l\\\', ?, ?)\', id, res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:814\n";

static const char *proc26 = 
"#line 863 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RQ_LONG_OF_O (in o_col any) returns any\n"
"{\n"
"return __rdf_long_of_obj (o_col);\n"
"}\n"
"--src sparql.sql:861\n";

static const char *proc27 = 
"#line 869 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_BOX_COMPLETE (inout o_col any)\n"
"{\n"
"__rdf_box_make_complete (o_col);\n"
"}\n"
"--src sparql.sql:867\n";

static const char *proc28 = 
"#line 875 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RQ_SQLVAL_OF_O (in o_col any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (o_col);\n"
"}\n"
"--src sparql.sql:873\n";

static const char *proc29 = 
"#line 881 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RQ_BOOL_OF_O (in o_col any) returns any\n"
"{\n"
"declare t, len integer;\n"
"if (isiri_id (o_col))\n"
"return NULL;\n"
"if (isinteger (o_col))\n"
"{\n"
"if (o_col)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box = __tag (o_col))\n"
"{\n"
"declare twobyte integer;\n"
"declare dtqname any;\n"
"if (__tag of varchar <> rdf_box_data_tag (o_col))\n"
"{\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return neq (rdf_box_data (o_col), 0.0);\n"
"}\n"
"twobyte := rdf_box_type (o_col);\n"
"if (257 = twobyte)\n"
"goto type_ok;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case (length (rdf_box_data (o_col))) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RQ_BOOL_OF_O, bad type id %d, string value \"%s\"\',\n"
"twobyte, cast (rdf_box_data (o_col) as varchar) ) );\n"
"}\n"
"if (o_col is null)\n"
"return null;\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return neq (o_col, 0.0);\n"
"retnull:\n"
"return null;\n"
"}\n"
"--src sparql.sql:879\n";

static const char *proc30 = 
"#line 925 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RQ_IID_OF_O (in shortobj any) returns IRI_ID\n"
"{\n"
"return id_to_iri_nosignal (shortobj);\n"
"}\n"
"--src sparql.sql:923\n";

static const char *proc31 = 
"#line 931 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RQ_O_IS_LIT (in shortobj any) returns integer\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:929\n";

static const char *proc32 = 
"#line 944 \"[executable]/sparql.sql\"\n"
"create procedure RDF_G_INS (in id int, in g any)\n"
"{\n"
"geo_insert (\'DB.DBA.RDF_GEO\', g, id);\n"
"}\n"
"--src sparql.sql:942\n";

static const char *proc33 = 
"#line 950 \"[executable]/sparql.sql\"\n"
"create procedure cl_rdf_geo_insert (in id int, inout g any)\n"
"{\n"
"declare daq any;\n"
"daq := daq (1);\n"
"daq_call (daq, \'DB.DBA.RDF_OBJ\', \'RDF_OBJ\', \'DB.DBA.RDF_G_INS\', vector (id, g), 1);\n"
"daq_results (daq);\n"
"}\n"
"--src sparql.sql:948\n";

static const char *proc34 = 
"#line 959 \"[executable]/sparql.sql\"\n"
"create function rdf_geo_add (in v any)\n"
"{\n"
"declare id, h, ser, g any;\n"
"if (rdf_box_ro_id (v))\n"
"return v;\n"
"g := rdf_box_data (v);\n"
"if (not isgeometry (g))\n"
"signal (\'22023\', \'RDFXX\', \'Must be geometry box if to be stored as geo object\');\n"
"ser := serialize (g);\n"
"if (length (ser) > 50)\n"
"h := mdigest5 (ser);\n"
"else\n"
"{\n"
"h := ser;\n"
"ser := null;\n"
"}\n"
"set isolation = \'committed\';\n"
"id := (select ro_id, ro_val, ro_long from rdf_obj where ro_val = h and ro_dt_and_lang = 0hex1000101 and case when ro_long is not null then equ (blob_to_string (ro_long),  ser) else 1 end );\n"
"if (id is not null)\n"
"{\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"set isolation = \'serializable\';\n"
"id := (select ro_id, ro_val, ro_long from rdf_obj where ro_val = h and ro_dt_and_lang = 0hex1000101 and case when ro_long is not null then equ (blob_to_string (ro_long),  ser) else 1 end for update);\n"
"if (id is not null)\n"
"{\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"set triggers off;\n"
"insert into rdf_obj (ro_id, ro_val, ro_long, ro_dt_and_lang)\n"
"values (id, h, ser, 0hex1000101);\n"
"if (1 = sys_stat (\'cl_run_local_only\'))\n"
"geo_insert (\'DB.DBA.RDF_GEO\', g, id);\n"
"else\n"
"cl_rdf_geo_insert (id, g);\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"--src sparql.sql:957\n";

static const char *proc35 = 
"#line 1002 \"[executable]/sparql.sql\"\n"
"create function rdf_geo_set_id (inout v any)\n"
"{\n"
"declare id, h, ser, g any;\n"
"if (rdf_box_ro_id (v))\n"
"return v;\n"
"g := rdf_box_data (v);\n"
"if (not isgeometry (g))\n"
"signal (\'22023\', \'RDFXX\', \'Must be geometry box if to be stored as geo object\');\n"
"ser := serialize (g);\n"
"if (length (ser) > 50)\n"
"h := mdigest5 (ser);\n"
"else\n"
"{\n"
"h := ser;\n"
"ser := null;\n"
"}\n"
"set isolation = \'committed\';\n"
"id := (select RO_ID from RDF_OBJ where RO_VAL = h and RO_DT_AND_LANG = 0hex1000101\n"
"and case when RO_LONG is not null then equ (blob_to_string (RO_LONG),  ser) else 1 end );\n"
"if (id is not null)\n"
"{\n"
"rdf_box_set_ro_id (v, id);\n"
"return v;\n"
"}\n"
"return null;\n"
"}\n"
"--src sparql.sql:1000\n";

static const char *proc36 = 
"#line 1030 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_ADD (in dt_twobyte integeR, in v varchar, in lang_twobyte integeR, in ro_id_dict any := null) returns varchar\n"
"{\n"
"declare llong, id, need_digest integer;\n"
"declare digest any;\n"
"declare old_flags, dt_and_lang integer;\n"
"\n"
"if (126 = __tag (v))\n"
"v := blob_to_string (v);\n"
"if (isstring (rdf_box_data (v)))\n"
"need_digest := rdf_box_needs_digest (v, ro_id_dict);\n"
"else if (__tag of XML = __tag (v))\n"
"need_digest := 1;\n"
"if (__tag of rdf_box = __tag (v))\n"
"{\n"
"if (256 = rdf_box_type (v))\n"
"return rdf_geo_add (v);\n"
"if (0 = need_digest)\n"
"return v;\n"
"if (1 = need_digest)\n"
"{\n"
"if (0 <> rdf_box_ro_id (v))\n"
"return v;\n"
"}\n"
"dt_twobyte := rdf_box_type (v);\n"
"lang_twobyte := rdf_box_lang (v);\n"
"v := __rdf_sqlval_of_obj (v, 1);\n"
"}\n"
"else\n"
"{\n"
"if (dt_twobyte <> 257 or lang_twobyte <> 257)\n"
"need_digest := 3;\n"
"else if (0 = need_digest)\n"
"return v;\n"
"if (dt_twobyte < 257)\n"
"signal (\'RDFXX\', sprintf (\'Bad datatype code: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"if (lang_twobyte < 257)\n"
"signal (\'RDFXX\', sprintf (\'Bad lang code: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"}\n"
"dt_and_lang := bit_or (bit_shift (dt_twobyte, 16), lang_twobyte);\n"
"if (not isstring (v))\n"
"{\n"
"declare sum64 varchar;\n"
"if (__tag of XML <> __tag (v))\n"
"signal (\'RDFXX\', sprintf (\'Bad call: DB.DBA.RDF_OBJ_ADD (%d, %s, %d)\',\n"
"dt_twobyte, \"LEFT\" (cast (v as varchar), 100), lang_twobyte) );\n"
"sum64 := xtree_sum64 (v);\n"
"whenever not found goto serializable_xtree;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2);\n"
"\n"
"\n"
"goto found_xtree;\n"
"serializable_xtree:\n"
"whenever not found goto new_xtree;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for\n"
"select RO_ID, RO_FLAGS from DB.DBA.RDF_OBJ table option (index RO_VAL) where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2);\n"
"\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_xtree:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (ro_id_dict is not null)\n"
"{\n"
"if (not (bit_and (old_flags, 1)))\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"\n"
"}\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX2\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"\n"
"new_xtree:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_FLAGS, RO_DT_AND_LANG) values\n"
"(id, sum64, __xml_serialize_packed (v), case (isnull (ro_id_dict)) when 0 then 3 else 2 end, dt_and_lang);\n"
"\n"
"\n"
"if (ro_id_dict is not null)\n"
"dict_put (ro_id_dict, id, 1);\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX3\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"\n"
"\n"
"}\n"
"if ((dt_twobyte = 257) and (lang_twobyte = 257) and (length (v) <= -1))\n"
"{\n"
"if (1 >= need_digest)\n"
"return v;\n"
"whenever not found goto serializable_veryshort;\n"
"set isolation=\'committed\';\n"
"select RO_ID into id\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v and RO_DT_AND_LANG = dt_and_lang and not (bit_and (RO_FLAGS, 2));\n"
"goto found_veryshort;\n"
"serializable_veryshort:\n"
"whenever not found goto new_veryshort;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for select RO_ID\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v and RO_DT_AND_LANG = dt_and_lang and not (bit_and (RO_FLAGS, 2));\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id;\n"
"found_veryshort:\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"\n"
"}\n"
"if (not (rdf_box_is_storeable (v)))\n"
"signal (\'RDFX4\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return v;\n"
"new_veryshort:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG) values (id, v, 1, dt_and_lang);\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"values (subseq (v, 0, case when length (v) > 10 then 10 else length (v) end), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (not (rdf_box_is_storeable (v)))\n"
"signal (\'RDFX5\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return v;\n"
"}\n"
"llong := 50;\n"
"if (length (v) > llong)\n"
"{\n"
"declare chksm varchar;\n"
"chksm := mdigest5 (v, 1);\n"
"whenever not found goto serializable_long;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v;\n"
"goto found_long;\n"
"serializable_long:\n"
"whenever not found goto new_long;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for\n"
"select RO_ID, RO_FLAGS from DB.DBA.RDF_OBJ\n"
"table option (index RO_VAL) where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v;\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_long:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if ((not (bit_and (old_flags, 1))) and (1 < need_digest))\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX6\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"new_long:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (1 < need_digest)\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, chksm, v, 1, dt_and_lang);\n"
"else\n"
"{\n"
"set triggers off;\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_LONG, RO_DT_AND_LANG)\n"
"values (id, chksm, v, dt_and_lang);\n"
"set triggers on;\n"
"}\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"\n"
"values (subseq (v, 0, 10), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX7\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"}\n"
"else\n"
"{\n"
"whenever not found goto serializable_short;\n"
"set isolation=\'committed\';\n"
"select RO_ID, RO_FLAGS into id, old_flags\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang;\n"
"goto found_short;\n"
"serializable_short:\n"
"whenever not found goto new_short;\n"
"set isolation=\'serializable\';\n"
"declare id_cr cursor for select RO_ID, RO_FLAGS\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang;\n"
"open id_cr (exclusive);\n"
"fetch id_cr into id, old_flags;\n"
"found_short:\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if ((not (bit_and (old_flags, 1))) and (1 < need_digest))\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id;\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX8\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"new_short:\n"
"id := sequence_next (\'RDF_RO_ID\');\n"
"digest := rdf_box (v, dt_twobyte, lang_twobyte, id, 1);\n"
"if (1 < need_digest)\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, v, 1, dt_and_lang);\n"
"else\n"
"{\n"
"set triggers off;\n"
"insert into DB.DBA.RDF_OBJ (RO_ID, RO_VAL, RO_FLAGS, RO_DT_AND_LANG)\n"
"values (id, v, 0, dt_and_lang);\n"
"set triggers on;\n"
"}\n"
"insert into DB.DBA.RO_START (RS_START, RS_DT_AND_LANG, RS_RO_ID)\n"
"values (subseq (v, 0, case when length (v) > 10 then 10 else length (v) end), dt_and_lang, rdf_box (0, 257, 257, id, 0));\n"
"if (ro_id_dict is not null)\n"
"{\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"if (not (rdf_box_is_storeable (digest)))\n"
"signal (\'RDFX9\', \'DB.DBA.RDF_OBJ_ADD() tries to return bad digest\');\n"
"return digest;\n"
"}\n"
"recheck:\n"
"\n"
"signal (\'FUNNY\', \'Debug code of DB.DBA.RDF_OBJ_ADD() is reached. This can not happen (I believe). Please report this error.\');\n"
"}\n"
"--src sparql.sql:1028\n";

static const char *proc37 = 
"#line 1286 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FIND_RO_DIGEST (in dt_twobyte integeR, in v varchar, in lang_twobyte integeR) returns varchar\n"
"{\n"
"declare llong, dt_and_lang int;\n"
"declare dt_s, lang_s, chksm, sum64 varchar;\n"
"declare digest, old_digest any;\n"
"if (126 = __tag (v))\n"
"v := blob_to_string (v);\n"
"dt_and_lang := bit_or (bit_shift (dt_twobyte, 16), lang_twobyte);\n"
"if (not (isstring (v)))\n"
"{\n"
"if (__tag of XML <> __tag (v))\n"
"return v;\n"
"sum64 := xtree_sum64 (v);\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = sum64\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and bit_and (RO_FLAGS, 2)\n"
"\n"
");\n"
"}\n"
"if ((dt_twobyte = 257) and (lang_twobyte = 257) and (length (v) <= 20))\n"
"return v;\n"
"llong := 50;\n"
"if (length (v) > llong)\n"
"{\n"
"chksm := mdigest5 (v, 1);\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = chksm\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2))\n"
"and blob_to_string (RO_LONG) = v );\n"
"}\n"
"else\n"
"{\n"
"return (select rdf_box (v, dt_twobyte, lang_twobyte, RO_ID, 1)\n"
"from DB.DBA.RDF_OBJ table option (index RO_VAL)\n"
"where RO_VAL = v\n"
"and RO_DT_AND_LANG = dt_and_lang\n"
"and not (bit_and (RO_FLAGS, 2)) );\n"
"}\n"
"}\n"
"--src sparql.sql:1284\n";

static const char *proc38 = 
"#line 1331 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML, __tag of rdf_box)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257);\n"
"}\n"
"--src sparql.sql:1329\n";

static const char *proc39 = 
"#line 1345 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (in v any, in g_iid IRI_ID, in p_iid IRI_ID, in ro_id_dict any := null) returns any\n"
"{\n"
"declare t int;\n"
"\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML, __tag of rdf_box)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"if (not __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"ro_id_dict := null;\n"
"else\n"
"{\n"
"if (ro_id_dict is null)\n"
"{\n"
"declare res any;\n"
"ro_id_dict := dict_new ();\n"
"res := DB.DBA.RDF_OBJ_ADD (257, v, 257, ro_id_dict);\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"return res;\n"
"}\n"
"}\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257, ro_id_dict);\n"
"}\n"
"--src sparql.sql:1343\n";

static const char *proc40 = 
"#line 1373 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (in v any, in dt_iid IRI_ID, in lang varchar) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"\n"
"retry_unrdf:\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"{\n"
"if (__tag of rdf_box = t)\n"
"{\n"
"v := rdf_box_data (v);\n"
"goto retry_unrdf;\n"
"}\n"
"\n"
"return v;\n"
"}\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"\n"
"return DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte);\n"
"}\n"
"--src sparql.sql:1371\n";

static const char *proc41 = 
"#line 1406 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (in v any, in dt_iid IRI_ID, in lang varchar, in g_iid IRI_ID, in p_iid IRI_ID, in ro_id_dict any := null) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"\n"
"retry_unrdf:\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"{\n"
"if (__tag of rdf_box = t)\n"
"{\n"
"v := rdf_box_data (v);\n"
"goto retry_unrdf;\n"
"}\n"
"\n"
"return v;\n"
"}\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"if (not __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"ro_id_dict := null;\n"
"else\n"
"{\n"
"if (ro_id_dict is null)\n"
"{\n"
"declare res any;\n"
"ro_id_dict := dict_new ();\n"
"res := DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte, ro_id_dict);\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"return res;\n"
"}\n"
"}\n"
"return DB.DBA.RDF_OBJ_ADD (dt_twobyte, v, lang_twobyte, ro_id_dict);\n"
"}\n"
"--src sparql.sql:1404\n";

static const char *proc42 = 
"#line 1451 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS (\n"
"in o_val any, in o_type varchar, in o_lang varchar ) returns any\n"
"{\n"
"\n"
"if (__tag (o_type) in (__tag of varchar, 217))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of XML = __tag (parsed))\n"
"{\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"parsed, iri_to_id (o_type), null );\n"
"}\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"{\n"
"if (256 = rdf_box_type (parsed))\n"
"db..rdf_geo_add (parsed);\n"
"else\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"parsed := DB.DBA.RDF_OBJ_ADD (257, parsed, 257, null);\n"
"}\n"
"return parsed;\n"
"}\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"o_lang );\n"
"}\n"
"if (isstring (o_lang))\n"
"{\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (\n"
"o_val, NULL, o_lang );\n"
"}\n"
"return DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (o_val);\n"
"}\n"
"--src sparql.sql:1449\n";

static const char *proc43 = 
"#line 1491 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_LONG_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"return __rdf_long_of_obj (shortobj);\n"
"}\n"
"--src sparql.sql:1489\n";

static const char *proc44 = 
"#line 1497 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_DATATYPE_OF_OBJ (in shortobj any, in dflt varchar := UNAME\'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"declare twobyte integer;\n"
"declare res any;\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return null;\n"
"if (isstring (shortobj) and bit_and (__box_flags (shortobj), 1))\n"
"return null;\n"
"\n"
"return __xsd_type (shortobj, dflt);\n"
"}\n"
"twobyte := rdf_box_type (shortobj);\n"
"\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (shortobj)) when 257 then __uname (dflt) else null end;\n"
"whenever not found goto badtype;\n"
"select __uname (RDT_QNAME) into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RQ_DATATYPE_OF_OBJ, bad type id %d, string value \"%s\"\',\n"
"twobyte, cast (rdf_box_data (shortobj) as varchar) ) );\n"
"}\n"
"--src sparql.sql:1495\n";

static const char *proc45 = 
"#line 1524 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_LANGUAGE_OF_OBJ (in shortobj any, in dflt varchar := \'\') returns any\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return null;\n"
"if (isstring (shortobj) and bit_and (__box_flags (shortobj), 1))\n"
"return null;\n"
"\n"
"return dflt;\n"
"}\n"
"twobyte := rdf_box_lang (shortobj);\n"
"\n"
"if (257 = twobyte)\n"
"return dflt;\n"
"return coalesce ((select lower (RL_ID)  from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte), \n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.RDF_LANGUAGE_OF_OBJ, bad string \"%s\"\', cast (shortobj as varchar))));\n"
"}\n"
"--src sparql.sql:1522\n";

static const char *proc46 = 
"#line 1546 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_SQLVAL_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (shortobj);\n"
"}\n"
"--src sparql.sql:1544\n";

static const char *proc47 = 
"#line 1552 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_BOOL_OF_OBJ (in shortobj any) returns any\n"
"{\n"
"if (isiri_id (shortobj))\n"
"return null;\n"
"if (isinteger (shortobj))\n"
"{\n"
"if (shortobj)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box <> __tag (shortobj))\n"
"{\n"
"if (shortobj is null)\n"
"return null;\n"
"if (equ (shortobj, 0.0) or equ (shortobj, \'\')) return 0; else return 1;\n"
"}\n"
"declare twobyte integer;\n"
"twobyte := rdf_box_type (shortobj);\n"
"if (257 = twobyte)\n"
"goto type_ok;\n"
"declare dtqname varchar;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case length (rdf_box_data (shortobj)) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_BOOL_OF_OBJ, bad type id %d, string value \"%s\"\',\n"
"twobyte, cast (rdf_box_data (shortobj) as varchar) ) );\n"
"}\n"
"--src sparql.sql:1550\n";

static const char *proc48 = 
"#line 1587 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QNAME_OF_OBJ (in shortobj any) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (shortobj);\n"
"}\n"
"--src sparql.sql:1585\n";

static const char *proc49 = 
"#line 1593 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_STRSQLVAL_OF_OBJ (in shortobj any)\n"
"{\n"
"return __rdf_strsqlval (shortobj, 0);\n"
"}\n"
"--src sparql.sql:1591\n";

static const char *proc50 = 
"#line 1599 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_OF_LONG (in longobj any) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (longobj);\n"
"if (__tag of rdf_box <> t)\n"
"{\n"
"if (not (t in (__tag of varchar, 126, 217, __tag of nvarchar, 133, 226)))\n"
"return longobj;\n"
"if (t = 133)\n"
"{\n"
"longobj := cast (longobj as nvarchar);\n"
"t := __tag (longobj);\n"
"}\n"
"if (__tag of nvarchar = t or t = 226)\n"
"longobj := charset_recode (longobj, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"longobj := cast (longobj as varchar);\n"
"else if (bit_and (1, __box_flags (longobj)))\n"
"return iri_to_id (longobj);\n"
"return DB.DBA.RDF_OBJ_ADD (257, longobj, 257);\n"
"}\n"
"if (0 = rdf_box_needs_digest (longobj))\n"
"return longobj;\n"
"return DB.DBA.RDF_OBJ_ADD (257, longobj, 257);\n"
"}\n"
"--src sparql.sql:1597\n";

static const char *proc51 = 
"#line 1626 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (__tag of varchar, 126, 217, __tag of nvarchar)))\n"
"{\n"
"if (__tag of rdf_box = __tag(v) and 0 = rdf_box_ro_id (v))\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257);\n"
"return v;\n"
"}\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"else if (bit_and (1, __box_flags (v)))\n"
"return iri_to_id (v);\n"
"return DB.DBA.RDF_OBJ_ADD (257, v, 257);\n"
"}\n"
"--src sparql.sql:1624\n";

static const char *proc52 = 
"#line 1649 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_LONG_OF_SQLVAL (in v any) returns any\n"
"{\n"
"declare t int;\n"
"declare res any;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar, __tag of XML)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t or 126 = t)\n"
"v := cast (v as varchar);\n"
"else if (bit_and (1, __box_flags (v)))\n"
"return iri_to_id (v);\n"
"res := rdf_box (v, 257, 257, 0, 1);\n"
"return res;\n"
"}\n"
"--src sparql.sql:1647\n";

static const char *proc53 = 
"#line 1668 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (in v any, in dt_iid IRI_ID, in lang varchar) returns any\n"
"{\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"declare res any;\n"
"t := __tag (v);\n"
"\n"
"\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (217 = t)\n"
"v := cast (v as varchar);\n"
"else if (__tag of varchar = t and 1 = __box_flags (v) and dt_iid is null and lang is null)\n"
"return iri_to_id (v);\n"
"if (__tag of varchar <> __tag (v))\n"
"{\n"
"declare xsdt IRI_ID;\n"
"if (lang is not null)\n"
"signal (\'RDFXX\', \'Language is set for typed literal in DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL()\');\n"
"xsdt := cast (__xsd_type (v, UNAME\'http://www.w3.org/2001/XMLSchema#string\', NULL) as varchar);\n"
"if (dt_iid = case (isiri_id (dt_iid)) when 1 then iri_to_id (xsdt) else xsdt end)\n"
"return v;\n"
"\n"
"}\n"
"if (dt_iid is not null)\n"
"dt_twobyte := DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid);\n"
"else\n"
"dt_twobyte := 257;\n"
"if (lang is not null)\n"
"lang_twobyte := DB.DBA.RDF_TWOBYTE_OF_LANGUAGE (lang);\n"
"else\n"
"lang_twobyte := 257;\n"
"res := rdf_box (v, dt_twobyte, lang_twobyte, 0, 1);\n"
"return res;\n"
"}\n"
"--src sparql.sql:1666\n";

static const char *proc54 = 
"#line 1704 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (\n"
"in o_val any, in o_type varchar, in o_lang varchar ) returns any\n"
"{\n"
"if (__tag (o_type) in (__tag of varchar, 217))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of XML = __tag (parsed))\n"
"parsed := rdf_box (parsed, 257, 257, 0, 1);\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"return parsed;\n"
"}\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"null );\n"
"}\n"
"if (__tag (o_lang) in (__tag of varchar, 217))\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (o_val, NULL, o_lang);\n"
"return DB.DBA.RDF_MAKE_LONG_OF_SQLVAL (o_val);\n"
"}\n"
"--src sparql.sql:1702\n";

static const char *proc55 = 
"#line 1731 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QNAME_OF_LONG_SAFE (in longobj any) returns varchar\n"
"{\n"
"return id_to_iri_nosignal (longobj);\n"
"}\n"
"--src sparql.sql:1729\n";

static const char *proc56 = 
"#line 1737 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_SQLVAL_OF_LONG (in longobj any) returns any\n"
"{\n"
"return __rdf_sqlval_of_obj (longobj);\n"
"}\n"
"--src sparql.sql:1735\n";

static const char *proc57 = 
"#line 1743 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_BOOL_OF_LONG (in longobj any) returns any\n"
"{\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"if (isinteger (longobj))\n"
"{\n"
"if (longobj)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag of rdf_box <> __tag (longobj))\n"
"{\n"
"if (longobj is null)\n"
"return null;\n"
"if (equ (longobj, 0.0) or equ (longobj, \'\')) return 0; else return 1;\n"
"}\n"
"declare dtqname any;\n"
"if (257 = rdf_box_type (longobj))\n"
"goto type_ok;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into dtqname from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (longobj);\n"
"if (dtqname <> UNAME\'http://www.w3.org/2001/XMLSchema#string\')\n"
"return null;\n"
"\n"
"type_ok:\n"
"return case (length (rdf_box_data (longobj))) when 0 then 0 else 1 end;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_BOOL_OF_LONG (code %d)\', rdf_box_type (longobj)));\n"
"}\n"
"--src sparql.sql:1741\n";

static const char *proc58 = 
"#line 1775 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_DATATYPE_OF_LONG (in longobj any, in dflt any := UNAME\'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"declare twobyte integer;\n"
"declare res IRI_ID;\n"
"twobyte := rdf_box_type (longobj);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (longobj)) when 257 then __uname (dflt) else null end;\n"
"whenever not found goto badtype;\n"
"select __uname (RDT_QNAME) into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_OF_LONG, bad id %d\', twobyte));\n"
"}\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"return __xsd_type (longobj, dflt);\n"
"}\n"
"--src sparql.sql:1773\n";

static const char *proc59 = 
"#line 1797 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_DATATYPE_IRI_OF_LONG (in longobj any, in dflt any := UNAME\'http://www.w3.org/2001/XMLSchema#string\') returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_type (longobj);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (longobj)) when 257 then dflt else null end;\n"
"whenever not found goto badtype;\n"
"select RDT_QNAME into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_IRI_OF_LONG, bad id %d\', twobyte));\n"
"}\n"
"if (isiri_id (longobj))\n"
"return NULL;\n"
"return __xsd_type (longobj, dflt);\n"
"}\n"
"--src sparql.sql:1795\n";

static const char *proc60 = 
"#line 1819 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_STRSQLVAL_OF_LONG (in longobj any)\n"
"{\n"
"return __rdf_strsqlval (longobj, 0);\n"
"}\n"
"--src sparql.sql:1817\n";

static const char *proc61 = 
"#line 1825 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG (in longobj any)\n"
"{\n"
"declare t, len integer;\n"
"if (__tag of rdf_box = __tag (longobj))\n"
"{\n"
"if (rdf_box_is_complete (longobj))\n"
"{\n"
"if (__tag of varchar = rdf_box_data_tag (longobj))\n"
"return charset_recode (rdf_box_data (longobj), \'UTF-8\', \'_WIDE_\');\n"
"if (__tag of datetime = rdf_box_data_tag (longobj))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (rdf_box_data (longobj) as varchar);\n"
"return cast (replace (vc, \' \', \'T\') as nvarchar);\n"
"}\n"
"if (__tag of XML = rdf_box_data_tag (longobj))\n"
"{\n"
"return charset_recode (serialize_to_UTF8_xml (rdf_box_data (longobj)), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"return cast (rdf_box_data (longobj) as nvarchar);\n"
"}\n"
"declare id integer;\n"
"declare v2 any;\n"
"id := rdf_box_ro_id (longobj);\n"
"if (__tag of XML = rdf_box_data_tag (longobj))\n"
"{\n"
"v2 := (select xml_tree_doc (__xml_deserialize_packed (RO_LONG)) from DB.DBA.RDF_OBJ where RO_ID = id);\n"
"rdf_box_set_data (longobj, v2, 1);\n"
"return charset_recode (serialize_to_UTF8_xml (v2), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"else\n"
"v2 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id);\n"
"if (v2 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG, bad id %d\', id));\n"
"rdf_box_set_data (longobj, v2, 1);\n"
"return charset_recode (v2, \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"if (isiri_id (longobj))\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (longobj);\n"
"\n"
"if (res is null)\n"
"signal (\'RDFXX\', \'Wrong iid in DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG()\');\n"
"return charset_recode (res, \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"if (__tag of datetime = __tag (longobj))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (longobj as varchar);\n"
"return cast (replace (vc, \' \', \'T\') as nvarchar);\n"
"}\n"
"if (__tag of nvarchar = __tag (longobj))\n"
"return longobj;\n"
"if (__tag of XML = __tag (longobj))\n"
"{\n"
"return charset_recode (serialize_to_UTF8_xml (longobj), \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"return cast (longobj as nvarchar);\n"
"}\n"
"--src sparql.sql:1823\n";

static const char *proc62 = 
"#line 1888 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_DATATYPE_OF_SQLVAL (in v any,\n"
"in strg_datatype any := UNAME\'http://www.w3.org/2001/XMLSchema#string\',\n"
"in default_res any := NULL) returns any\n"
"{\n"
"if (__tag of rdf_box = __tag (v))\n"
"{\n"
"declare twobyte integer;\n"
"declare res IRI_ID;\n"
"twobyte := rdf_box_type (v);\n"
"if (257 = twobyte)\n"
"return case (rdf_box_lang (v)) when 257 then __uname (strg_datatype) else null end;\n"
"whenever not found goto badtype;\n"
"select __uname (RDT_QNAME) into res from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown datatype in DB.DBA.RDF_DATATYPE_OF_SQLVAL, bad id %d\', twobyte));\n"
"}\n"
"return __uname (__xsd_type (v, strg_datatype, default_res));\n"
"}\n"
"--src sparql.sql:1886\n";

static const char *proc63 = 
"#line 1911 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_LONG_OF_SQLVAL (in v varchar) returns any\n"
"{\n"
"declare t int;\n"
"t := __tag (v);\n"
"if (not (t in (126, __tag of varchar, 217, __tag of nvarchar)))\n"
"return v;\n"
"if (__tag of nvarchar = t)\n"
"v := charset_recode (v, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"v := cast (v as varchar);\n"
"else if ((t = __tag of varchar) and (1 = __box_flags (v)))\n"
"return iri_to_id (v);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return rdf_box (v, 257, 257, 0, 1);\n"
"}\n"
"--src sparql.sql:1909\n";

static const char *proc64 = 
"#line 1936 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_STRSQLVAL_OF_SQLVAL (in sqlval any)\n"
"{\n"
"declare t, len integer;\n"
"if (__tag of rdf_box = __tag (sqlval))\n"
"sqlval := __ro2sq (sqlval, 1);\n"
"if (isiri_id (sqlval))\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (sqlval);\n"
"\n"
"if (res is null)\n"
"signal (\'RDFXX\', \'Wrong iid in DB.DBA.RDF_STRSQLVAL_OF_SQLVAL()\');\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"declare vc varchar;\n"
"vc := cast (sqlval as varchar);\n"
"return replace (vc, \' \', \'T\');\n"
"}\n"
"if (__tag of nvarchar = __tag (sqlval))\n"
"return charset_recode (sqlval, \'_WIDE_\', \'UTF-8\');\n"
"return cast (sqlval as varchar);\n"
"}\n"
"--src sparql.sql:1934\n";

static const char *proc65 = 
"#line 1964 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_LANGUAGE_OF_SQLVAL (in v any, in dflt varchar := \'\') returns any\n"
"{\n"
"declare t int;\n"
"if (__tag of rdf_box = __tag (v))\n"
"{\n"
"declare twobyte integer;\n"
"declare res varchar;\n"
"twobyte := rdf_box_lang (v);\n"
"whenever not found goto badtype;\n"
"select RL_ID into res from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte;\n"
"return res;\n"
"\n"
"badtype:\n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.RDF_LANGUAGE_OF_SQLVAL, bad id %d\', twobyte));\n"
"}\n"
"return case (isiri_id (v)) when 0 then dflt else null end;\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"--src sparql.sql:1962\n";

static const char *proc66 = 
"#line 1988 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_IS_BLANK_REF (in v any) returns any\n"
"{\n"
"if ((__tag (v) = 217) or ((__tag (v) = __tag of varchar) and bit_and (1, __box_flags (v))))\n"
"{\n"
"if (\"LEFT\" (v, 9) <> \'nodeID://\')\n"
"return 0;\n"
"return 1;\n"
"}\n"
"if (__tag (v) = 243)\n"
"{\n"
"if (v < min_bnode_iri_id ())\n"
"return 0;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:1986\n";

static const char *proc67 = 
"#line 2007 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_IS_URI_REF (in v any) returns any\n"
"{\n"
"if ((__tag (v) = 217) or ((__tag (v) = __tag of varchar) and bit_and (1, __box_flags (v))))\n"
"{\n"
"if (\"LEFT\" (v, 9) <> \'nodeID://\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"if (__tag (v) = 243)\n"
"{\n"
"if (v < min_bnode_iri_id ())\n"
"return 1;\n"
"return 0;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:2005\n";

static const char *proc68 = 
"#line 2026 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_IS_REF (in v any) returns any\n"
"{\n"
"if (__tag (v) in (217, 243))\n"
"return 1;\n"
"if ((__tag of varchar = __tag (v)) and bit_and (1, __box_flags (v)))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:2024\n";

static const char *proc69 = 
"#line 2037 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_IS_LITERAL (in v any) returns any\n"
"{\n"
"if (__tag (v) in (217, 243))\n"
"return 0;\n"
"if ((__tag of varchar = __tag (v)) and bit_and (1, __box_flags (v)))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:2035\n";

static const char *proc70 = 
"#line 2051 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#boolean\" (in strg any) returns integer\n"
"{\n"
"if (isstring (strg))\n"
"{\n"
"if ((\'true\' = strg) or (\'1\' = strg))\n"
"return 1;\n"
"if ((\'false\' = strg) or (\'0\' = strg))\n"
"return 0;\n"
"}\n"
"if (isinteger (strg))\n"
"return case (strg) when 0 then 0 else 1 end;\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2049\n";

static const char *proc71 = 
"#line 2067 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#date\" (in strg any) returns date\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'date\', strg);\n"
"return cast (strg as date);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2065\n";

static const char *proc72 = 
"#line 2081 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#dateTime\" (in strg any) returns datetime\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'dateTime\', strg);\n"
"return cast (strg as datetime);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2079\n";

static const char *proc73 = 
"#line 2095 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#double\" (in strg varchar) returns double precision\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as double precision);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2093\n";

static const char *proc74 = 
"#line 2105 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#float\" (in strg varchar) returns float\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as float);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2103\n";

static const char *proc75 = 
"#line 2115 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#integer\" (in strg varchar) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as integer);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2113\n";

static const char *proc76 = 
"#line 2125 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#int\" (in strg varchar) returns integer\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"return cast (strg as integer);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2123\n";

static const char *proc77 = 
"#line 2135 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#time\" (in strg any) returns time\n"
"{\n"
"if (__tag of datetime = __tag (strg))\n"
"return strg;\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"if (isstring (strg))\n"
"return __xqf_str_parse (\'time\', strg);\n"
"return cast (strg as time);\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2133\n";

static const char *proc78 = 
"#line 2149 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.\"http://www.w3.org/2001/XMLSchema#string\" (in strg any) returns any\n"
"{\n"
"whenever sqlstate \'*\' goto ret_null;\n"
"declare t, dt_twobyte, lang_twobyte int;\n"
"t := __tag (strg);\n"
"if (__tag of nvarchar = t)\n"
"strg := charset_recode (strg, \'_WIDE_\', \'UTF-8\');\n"
"else if (__tag of varchar <> t)\n"
"strg := cast (strg as varchar);\n"
"return DB.DBA.RDF_OBJ_ADD (\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (\'http://www.w3.org/2001/XMLSchema#string\'),\n"
"strg, 257 );\n"
"\n"
"ret_null:\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:2147\n";

static const char *proc79 = 
"#line 2171 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.__and (in e1 any, in e2 any) returns integer\n"
"{\n"
"if (e1 and e2)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:2169\n";

static const char *proc80 = 
"#line 2180 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.__or (in e1 any, in e2 any) returns integer\n"
"{\n"
"if (e1 or e2)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:2178\n";

static const char *proc81 = 
"#line 2189 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.__not (in e1 any) returns integer\n"
"{\n"
"if (e1)\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:2187\n";

static const char *proc82 = 
"#line 2200 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.rdf_strdt_impl (in str varchar, in dt_iri any)\n"
"{\n"
"declare dt_iid IRI_ID;\n"
"declare parsed any;\n"
"dt_iid := __i2id (dt_iri);\n"
"if (dt_iid is null)\n"
"signal (\'22007\', \'Function rdf_strdt_impl needs a valid datatype IRI as its second argument\');\n"
"if (__tag of IRI_ID = __tag (dt_iri))\n"
"dt_iri := __id2i (dt_iri);\n"
"parsed := __xqf_str_parse_to_rdf_box (str, dt_iri, isstring (str));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (dt_iid));\n"
"return parsed;\n"
"}\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (str, dt_iid, null);\n"
"}\n"
"--src sparql.sql:2198\n";

static const char *proc83 = 
"#line 2221 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.rdf_strlang_impl (in str varchar, in lang any)\n"
"{\n"
"\n"
"lang := cast (lang as varchar);\n"
"if ((lang is null) or (regexp_match (\'^(([a-z][a-z](-[A-Z][A-Z])?)|(x-[A-Za-z0-9]+))\\044\', lang) is null))\n"
"signal (\'22007\', \'Function rdf_strlang_impl needs a valid language ID as its second argument\');\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (str, null, cast (lang as varchar));\n"
"}\n"
"--src sparql.sql:2219\n";

static const char *proc84 = 
"#line 2232 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.rdf_replace_impl (in src varchar, in needle varchar, in rpl varchar, in opts varchar := \'\')\n"
"{\n"
"declare src_tag, needle_tag, rpl_tag integer;\n"
"declare res varchar;\n"
"src_tag := __tag (src);\n"
"needle_tag := __tag (needle);\n"
"rpl_tag := __tag (rpl);\n"
"if (__tag of rdf_box = src_tag)\n"
"{\n"
"src := rdf_box_data (src);\n"
"src_tag := __tag (src);\n"
"}\n"
"if (__tag of rdf_box = needle_tag)\n"
"{\n"
"needle := rdf_box_data (needle);\n"
"needle_tag := __tag (needle);\n"
"}\n"
"if (__tag of rdf_box = rpl_tag)\n"
"{\n"
"rpl := rdf_box_data (rpl);\n"
"rpl_tag := __tag (rpl);\n"
"}\n"
"if (__tag of nvarchar = src_tag)\n"
"src := charset_recode (src, \'_WIDE_\', \'UTF-8\');\n"
"else if (__tag of varchar <> src_tag)\n"
"src := cast (src as varchar);\n"
"if (__tag of nvarchar = needle_tag)\n"
"needle := charset_recode (needle, \'_WIDE_\', \'UTF-8\');\n"
"else if (__tag of varchar <> needle_tag)\n"
"needle := cast (needle as varchar);\n"
"if (__tag of nvarchar = rpl_tag)\n"
"rpl := charset_recode (rpl, \'_WIDE_\', \'UTF-8\');\n"
"else if (__tag of varchar <> rpl_tag)\n"
"rpl := cast (rpl as varchar);\n"
"if (__tag of varchar <> __tag (opts))\n"
"opts := cast (opts as varchar);\n"
"if (opts is null)\n"
"opts := \'\';\n"
"if (src is null or needle is null or rpl is null)\n"
"return null;\n"
"if (\'\' = needle)\n"
"return src;\n"
"if (regexp_match (\'^[^()|+?.:^\\044\\\\\\\\\\\\[\\\\]-]+\\044\', needle, 0, \'u\') is not null and strchr (rpl, \'\\044\') is null and strchr (rpl, 92) is null)\n"
"{\n"
"if (\'\' = opts)\n"
"{\n"
"res := replace (src, needle, rpl);\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"if (opts in (\'i\', \'I\'))\n"
"{\n"
"declare src_lc varchar;\n"
"declare hit, needle_len integer;\n"
"declare ses any;\n"
"src_lc := lcase (src);\n"
"needle := lcase (needle);\n"
"hit := strstr (src_lc, needle);\n"
"if (hit is null)\n"
"{\n"
"res := src;\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"ses := string_output();\n"
"needle_len := length (needle);\n"
"while (hit is not null)\n"
"{\n"
"http (subseq (src, 0, hit), ses);\n"
"http (rpl, ses);\n"
"src := subseq (src, hit + needle_len);\n"
"src_lc := subseq (src_lc, hit + needle_len);\n"
"hit := strstr (src_lc, needle);\n"
"}\n"
"http (src, ses);\n"
"res := string_output_string (ses);\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"}\n"
"if (strchr (opts, \'u\') is null and strchr (opts, \'U\') is null)\n"
"opts := opts || \'u\';\n"
"res := regexp_xfn_replace (src, needle, rpl, 0, null, opts);\n"
"__box_flags_set (res, 2);\n"
"return res;\n"
"}\n"
"--src sparql.sql:2230\n";

static const char *proc85 = 
"#line 2321 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.regexp_xfn_replace (in src varchar, in needle varchar, in tmpl varchar, in search_begin_pos integer, in hit_max_count integer, in opts varchar)\n"
"{\n"
"declare hit_list any;\n"
"if (0 = length (src))\n"
"return \'\';\n"
"if (regexp_parse (needle, \'\', 0, opts) is not null)\n"
"signal (\'22023\', \'The regex-based XPATH/XQuery/SPARQL replace() function can not search for a pattern that can be found even in an empty string\');\n"
"hit_list := regexp_parse_list (needle, src, search_begin_pos, opts, coalesce (hit_max_count, 2097152));\n"
"return regexp_replace_hits_with_template (src, tmpl, hit_list, 1);\n"
"}\n"
"--src sparql.sql:2319\n";

static const char *proc86 = 
"#line 2333 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.rdf_uuid_impl ()\n"
"{\n"
"return iri_to_id (\'urn:uuid:\' || uuid());\n"
"}\n"
"--src sparql.sql:2331\n";

static const char *proc87 = 
"#line 2340 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.rdf_timezone_impl (in dt datetime)\n"
"{\n"
"declare minutes integer;\n"
"declare sign, str varchar;\n"
"minutes := timezone (dt);\n"
"if (minutes is null)\n"
"signal (\'22007\', \'Function rdf_timezone_impl needs a datetime with some timezone set as its argument\');\n"
"if (minutes < 0)\n"
"{\n"
"sign := \'-\';\n"
"minutes := -minutes;\n"
"}\n"
"else\n"
"sign := \'\';\n"
"if (mod (minutes, 60))\n"
"str := sprintf (\'%sPT%dH%dM\', sign, minutes / 60, mod (minutes, 60));\n"
"else if (minutes = 0)\n"
"str := \'PT0S\';\n"
"else\n"
"str := sprintf (\'%sPT%dH\', sign, minutes / 60);\n"
"return DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL (str, __i2id (UNAME\'http://www.w3.org/2001/XMLSchema#dayTimeDuration\'), null);\n"
"}\n"
"--src sparql.sql:2338\n";

static const char *proc88 = 
"#line 2365 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.rdf_tz_impl (in dt datetime)\n"
"{\n"
"declare minutes integer;\n"
"declare sign varchar;\n"
"minutes := timezone (dt);\n"
"if (minutes is null)\n"
"return \'\';\n"
"if (minutes = 0)\n"
"return \'Z\';\n"
"if (minutes < 0)\n"
"{\n"
"sign := \'-\';\n"
"minutes := -minutes;\n"
"}\n"
"else\n"
"sign := \'\';\n"
"return sprintf (\'%s%02d:%02d\', sign, minutes / 60, mod (minutes, 60));\n"
"}\n"
"--src sparql.sql:2363\n";

static const char *proc89 = 
"#line 2389 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_URI (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_uri varchar)\n"
"{\n"
"declare g_iid IRI_ID;\n"
"g_iid := iri_to_id (g_uri);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"__rdf_repl_quad (84, iri_canonicalize (g_uri), iri_canonicalize (s_uri), iri_canonicalize (p_uri), iri_canonicalize (o_uri));\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (\n"
"g_iid,\n"
"iri_to_id (s_uri),\n"
"iri_to_id (p_uri),\n"
"iri_to_id (o_uri) );\n"
"}\n"
"--src sparql.sql:2387\n";

static const char *proc90 = 
"#line 2404 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_URI_L (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_lit any, in ro_id_dict any := null)\n"
"{\n"
"declare g_iid, s_iid, p_iid IRI_ID;\n"
"declare o_obj any;\n"
"g_iid := iri_to_id (g_uri);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"o_obj := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_lit, g_iid, p_iid, ro_id_dict);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"{\n"
"declare triples any;\n"
"triples := vector (vector (s_iid, p_iid, o_obj));\n"
"DB.DBA.RDF_REPL_INSERT_TRIPLES (id_to_iri (g_iid), triples);\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_obj);\n"
"}\n"
"--src sparql.sql:2402\n";

static const char *proc91 = 
"#line 2433 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_URI_L_TYPED (in g_uri varchar, in s_uri varchar, in p_uri varchar, in o_lit any, in dt any, in lang varchar, in ro_id_dict any := null)\n"
"{\n"
"declare g_iid, s_iid, p_iid IRI_ID;\n"
"declare o_obj any;\n"
"g_iid := iri_to_id (g_uri);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"if (dt is null and lang is null)\n"
"o_obj := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_lit, g_iid, p_iid, ro_id_dict);\n"
"else\n"
"o_obj := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (o_lit, iri_to_id (dt), lang, g_iid, p_iid, ro_id_dict);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"{\n"
"declare triples any;\n"
"triples := vector (vector (s_iid, p_iid, o_obj));\n"
"DB.DBA.RDF_REPL_INSERT_TRIPLES (id_to_iri (g_iid), triples);\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_obj);\n"
"}\n"
"--src sparql.sql:2431\n";

static const char *proc92 = 
"#line 2463 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_L_RDB2RDF (in g_iid varchar, in s_iid varchar, in p_iid varchar, inout o_val any, inout old_g_iid any, inout ro_id_dict any)\n"
"{\n"
"declare t int;\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"{\n"
"declare triples any;\n"
"triples := vector (vector (s_iid, p_iid, o_val));\n"
"DB.DBA.RDF_REPL_INSERT_TRIPLES (id_to_iri (g_iid), triples);\n"
"}\n"
"t := __tag (o_val);\n"
"if (__tag of rdf_box <> t)\n"
"{\n"
"if (not (t in (__tag of varchar, 126, 133, 217, __tag of nvarchar, 226)))\n"
"{\n"
"goto o_val_done;\n"
"}\n"
"if (t = 133)\n"
"{\n"
"o_val := cast (o_val as nvarchar);\n"
"t := __tag (o_val);\n"
"}\n"
"if (__tag of nvarchar = t or t = 226)\n"
"o_val := charset_recode (o_val, \'_WIDE_\', \'UTF-8\');\n"
"else if (t in (126, 217))\n"
"o_val := cast (o_val as varchar);\n"
"else if (bit_and (1, __box_flags (o_val)))\n"
"{\n"
"o_val := iri_to_id (o_val);\n"
"goto o_val_done;\n"
"}\n"
"}\n"
"if (__rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"{\n"
"if (old_g_iid <> g_iid)\n"
"{\n"
"if (dict_size (ro_id_dict))\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g_iid, ro_id_dict);\n"
"old_g_iid := g_iid;\n"
"}\n"
"if (ro_id_dict is null)\n"
"ro_id_dict := dict_new ();\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257, ro_id_dict);\n"
"}\n"
"else\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257);\n"
"\n"
"o_val_done:\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_val);\n"
"}\n"
"--src sparql.sql:2461\n";

static const char *proc93 = 
"#line 2514 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_NEW_GRAPH (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
"if (__rdf_obj_ft_rule_count_in_graph (g_iid))\n"
"app_env[1] := dict_new (app_env[2]);\n"
"else\n"
"app_env[1] := null;\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"app_env[3] := g;\n"
"else\n"
"app_env[3] := null;\n"
"}\n"
"--src sparql.sql:2512\n";

static const char *proc94 = 
"#line 2527 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"res := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"\n"
"}\n"
"--src sparql.sql:2525\n";

static const char *proc95 = 
"#line 2533 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := iri_to_id (uri);\n"
"\n"
"}\n"
"--src sparql.sql:2531\n";

static const char *proc96 = 
"#line 2540 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (app_env[3] is not null)\n"
"__rdf_repl_quad (84, app_env[3], iri_canonicalize (s_uri), iri_canonicalize (p_uri), iri_canonicalize (o_uri));\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, iri_to_id (s_uri), iri_to_id (p_uri), iri_to_id (o_uri));\n"
"}\n"
"--src sparql.sql:2538\n";

static const char *proc97 = 
"#line 2552 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare p_iid IRI_ID;\n"
"declare ro_id_dict any;\n"
"if (app_env[3] is not null)\n"
"{\n"
"if (isstring (o_type))\n"
"__rdf_repl_quad (81, app_env[3], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, iri_canonicalize (o_type), NULL);\n"
"else if (isstring (o_lang))\n"
"__rdf_repl_quad (82, app_env[3], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, null, o_lang);\n"
"else\n"
"__rdf_repl_quad (80, app_env[3], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val);\n"
"}\n"
"log_mode := app_env[0];\n"
"ro_id_dict := app_env[1];\n"
"p_iid := iri_to_id (p_uri);\n"
"if (isstring (o_type))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of XML = __tag (parsed))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (\n"
"parsed, g_iid, p_iid, ro_id_dict ) );\n"
"return;\n"
"}\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"{\n"
"if (256 = rdf_box_type (parsed))\n"
"db..rdf_geo_add (parsed);\n"
"else\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"parsed := DB.DBA.RDF_OBJ_ADD (257, parsed, 257, ro_id_dict);\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid, parsed);\n"
"return;\n"
"}\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (\n"
"o_val,\n"
"iri_to_id (o_type),\n"
"case (isstring (o_lang)) when 0 then null else o_lang end,\n"
"g_iid, p_iid, ro_id_dict ) );\n"
"return;\n"
"}\n"
"if (isstring (o_lang))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (o_val, NULL, o_lang, g_iid, p_iid, ro_id_dict) );\n"
"return;\n"
"}\n"
"if (isstring (o_val) or (__tag of XML = __tag (o_val)))\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_val, g_iid, p_iid, ro_id_dict) );\n"
"}\n"
"else\n"
"{\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, iri_to_id (s_uri), p_iid,\n"
"o_val );\n"
"}\n"
"}\n"
"--src sparql.sql:2550\n";

static const char *proc98 = 
"#line 2631 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_COMMIT (inout g varchar, inout app_env any) {\n"
"\n"
"declare log_mode integer;\n"
"declare ro_id_dict any;\n"
"log_mode := app_env[0];\n"
"ro_id_dict := app_env[1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (g), ro_id_dict);\n"
"}\n"
"--src sparql.sql:2629\n";

static const char *proc99 = 
"#line 2642 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_REPORT_DEFAULT (\n"
"inout msg_no integer, inout msg_type varchar,\n"
"inout src varchar, inout base varchar, inout graph varchar,\n"
"inout line_no integer, inout triple_no integer,\n"
"inout sstate varchar, inout smore varchar, inout descr varchar,\n"
"inout env any )\n"
"{\n"
"\n"
" ;\n"
"}\n"
"--src sparql.sql:2640\n";

static const char *proc100 = 
"#line 2654 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"declare xlat_cbk, s_xlat, o_xlat varchar;\n"
"declare xlat_env any;\n"
"\n"
"xlat_cbk := app_env[4];\n"
"xlat_env := app_env[5];\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"o_xlat := call(xlat_cbk)(o_uri, xlat_env);\n"
"DB.DBA.TTLP_EV_TRIPLE (g_iid, s_xlat, p_uri, o_xlat, app_env);\n"
"}\n"
"--src sparql.sql:2652\n";

static const char *proc101 = 
"#line 2670 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"declare xlat_cbk, s_xlat varchar;\n"
"declare xlat_env any;\n"
"\n"
"xlat_cbk := app_env[4];\n"
"xlat_env := app_env[5];\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"DB.DBA.TTLP_EV_TRIPLE_L (g_iid, s_xlat, p_uri, o_val, o_type, o_lang, app_env);\n"
"}\n"
"--src sparql.sql:2668\n";

static const char *proc102 = 
"#line 2686 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.TTLP_XLAT_CONCAT (\n"
"inout iri varchar, inout env any )\n"
"{\n"
"if (__tag (iri) <> __tag of varchar)\n"
"return iri;\n"
"if (iri like \'http://%\')\n"
"return concat (env, subseq (iri, 7));\n"
"return iri;\n"
"}\n"
"--src sparql.sql:2684\n";

static const char *proc103 = 
"#line 2697 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_enable int := null, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"declare ret any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (strg, 0, base, graph, flags);\n"
"return;\n"
"}\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (flags, null, __max (length (strg) / 100, 100000), null);\n"
"ret := rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return ret;\n"
"}\n"
"--src sparql.sql:2695\n";

static const char *proc104 = 
"#line 2745 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_WITH_IRI_TRANSLATION (in strg varchar, in base varchar, in graph varchar, in flags integer,\n"
"in log_enable integer, in transactional integer,\n"
"in iri_xlate_cbk varchar, in iri_xlate_env any )\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (flags, null, __max (length (strg) / 100, 100000), null, iri_xlate_cbk, iri_xlate_env);\n"
"return rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_XLAT\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_XLAT\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2743\n";

static const char *proc105 = 
"#line 2790 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_VALIDATE (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0, in report_cbk varchar := \'\')\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"return rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\'\', \'\', \'\', \'\', \'\', \'\', report_cbk),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2788\n";

static const char *proc106 = 
"#line 2802 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_VALIDATE_LOCAL_FILE (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0, in report_cbk varchar := \'\')\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"return rdf_load_turtle_local_file (strg, base, graph, flags,\n"
"vector (\'\', \'\', \'\', \'\', \'\', \'\', report_cbk),\n"
"app_env);\n"
"}\n"
"--src sparql.sql:2800\n";

static const char *proc107 = 
"#line 2814 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_VALIDATE_RDFXML (in strg varchar, in base varchar, in graph varchar)\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_VALIDATE_RDFXML()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_VALIDATE_RDFXML() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"rdf_load_rdfxml (strg, 0, graph, vector ( \'\', \'\', \'\', \'\', \'\', \'\', \'\' ), app_env, base );\n"
"return graph;\n"
"}\n"
"--src sparql.sql:2812\n";

static const char *proc108 = 
"#line 2831 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
" ;\n"
"}\n"
"--src sparql.sql:2829\n";

static const char *proc109 = 
"#line 2837 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"res := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"\n"
"}\n"
"--src sparql.sql:2835\n";

static const char *proc110 = 
"#line 2843 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := iri_to_id (uri);\n"
"\n"
"}\n"
"--src sparql.sql:2841\n";

static const char *proc111 = 
"#line 2850 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"dict_put (app_env,\n"
"vector (iri_to_id (s_uri), iri_to_id (p_uri), iri_to_id (o_uri)),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2848\n";

static const char *proc112 = 
"#line 2861 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"dict_put (app_env,\n"
"vector (\n"
"iri_to_id (s_uri),\n"
"iri_to_id (p_uri),\n"
"DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (o_val,\n"
"case when (isstring (o_type) or __tag (o_type) = 217) then o_type else null end,\n"
"case when (isstring (o_lang) or __tag (o_lang) = 217) then o_lang else null end) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2859\n";

static const char *proc113 = 
"#line 2877 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"declare xlat_cbk, s_xlat, o_xlat varchar;\n"
"declare xlat_env, dict any;\n"
"\n"
"dict := app_env[0];\n"
"xlat_cbk := app_env[1];\n"
"xlat_env := app_env[2];\n"
"if (__proc_params_num (xlat_cbk) = 2)\n"
"{\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"o_xlat := call(xlat_cbk)(o_uri, xlat_env);\n"
"}\n"
"else\n"
"{\n"
"s_xlat := call(xlat_cbk)(s_uri, p_uri, \'s\', xlat_env);\n"
"o_xlat := call(xlat_cbk)(o_uri, p_uri, \'o\', xlat_env);\n"
"}\n"
"\n"
"dict_put (dict, vector (iri_to_id (s_xlat), iri_to_id (p_uri), iri_to_id (o_xlat)), 0);\n"
"}\n"
"--src sparql.sql:2875\n";

static const char *proc114 = 
"#line 2904 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L_XLAT (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"declare xlat_cbk, s_xlat, o_xlat varchar;\n"
"declare xlat_env, dict any;\n"
"\n"
"dict := app_env[0];\n"
"xlat_cbk := app_env[1];\n"
"xlat_env := app_env[2];\n"
"if (__proc_params_num (xlat_cbk) = 2)\n"
"s_xlat := call(xlat_cbk)(s_uri, xlat_env);\n"
"else\n"
"s_xlat := call(xlat_cbk)(s_uri, p_uri, \'s\', xlat_env);\n"
"dict_put (dict,\n"
"vector (\n"
"iri_to_id (s_xlat),\n"
"iri_to_id (p_uri),\n"
"DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (o_val,\n"
"case when (isstring (o_type) or __tag (o_type) = 217) then o_type else null end,\n"
"case when (isstring (o_lang) or __tag (o_lang) = 217) then o_lang else null end) ),\n"
"0);\n"
"}\n"
"--src sparql.sql:2902\n";

static const char *proc115 = 
"#line 2930 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TTL2HASH (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0) returns any\n"
"{\n"
"declare res any;\n"
"res := dict_new ();\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:2928\n";

static const char *proc116 = 
"#line 2951 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TTL_LOAD_DICT (in strg varchar, in base varchar, in graph varchar, in dict any, in flags integer := 0) returns any\n"
"{\n"
"if (__tag (dict) <> 214)\n"
"signal (\'22023\', \'RDFXX\', \'The dict argument must be of type dictionary\');\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"dict);\n"
"return;\n"
"}\n"
"--src sparql.sql:2949\n";

static const char *proc117 = 
"#line 2971 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID (inout uri varchar, inout g_iid IRI_ID, inout app_env any, inout res IRI_ID) {\n"
"\n"
"res := __bft (uri, 1);\n"
"\n"
"}\n"
"--src sparql.sql:2969\n";

static const char *proc118 = 
"#line 2978 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"dict_put (app_env,\n"
"vector (\n"
"__bft (s_uri, 1),\n"
"__bft (p_uri, 1),\n"
"__bft (o_uri, 1) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2976\n";

static const char *proc119 = 
"#line 2992 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"if (not isstring (o_type))\n"
"o_type := null;\n"
"if (not isstring (o_lang))\n"
"o_lang := null;\n"
"dict_put (app_env,\n"
"vector (\n"
"__bft (s_uri, 1),\n"
"__bft (p_uri, 1),\n"
"DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (o_val,\n"
"case (isstring (o_type)) when 0 then null else o_type end,\n"
"case (isstring (o_lang)) when 0 then null else o_lang end) ),\n"
"0 );\n"
"}\n"
"--src sparql.sql:2990\n";

static const char *proc120 = 
"#line 3012 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TTL2SQLHASH (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0) returns any\n"
"{\n"
"declare res any;\n"
"res := dict_new ();\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:3010\n";

static const char *proc121 = 
"#line 3033 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_RDFXML_IMPL (inout strg varchar, in base varchar, in graph varchar,\n"
"in parse_mode integer, in log_enable int := null, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"declare old_log_mode int;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_LOAD_RDFXML() and the like\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFXML() and similar functions require a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"old_log_mode := null;\n"
"if (transactional = 0)\n"
"{\n"
"if (log_enable = 0 or log_enable = 1)\n"
"log_enable := log_enable + 2;\n"
"}\n"
"if (log_enable is not null)\n"
"{\n"
"old_log_mode := log_enable (log_enable, 1);\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return DB.DBA.RDF_LOAD_RDFXML_CL (strg, base, graph, parse_mode);\n"
"app_env := vector (\n"
"null,\n"
"null,\n"
"__max (length (strg) / 100, 100000),\n"
"null );\n"
"rdf_load_rdfxml (strg, parse_mode,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return graph;\n"
"}\n"
"--src sparql.sql:3031\n";

static const char *proc122 = 
"#line 3081 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_RDFXML (in strg varchar, in base varchar, in graph varchar := null,\n"
"in xml_parse_mode integer := 0, in log_enable int := null, in transactional int := 0 )\n"
"{\n"
"return DB.DBA.RDF_LOAD_RDFXML_IMPL (strg, base, graph, bit_shift (xml_parse_mode, 8), log_enable, transactional);\n"
"}\n"
"--src sparql.sql:3079\n";

static const char *proc123 = 
"#line 3089 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_RDFXML_TO_DICT (in strg varchar, in base varchar, in graph varchar := null)\n"
"{\n"
"declare res any;\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res,\n"
"base );\n"
"return res;\n"
"}\n"
"--src sparql.sql:3087\n";

static const char *proc124 = 
"#line 3109 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_RDFXML_LOAD_DICT (in strg varchar, in base varchar, in graph varchar, inout dict any, in flag int := 0, in xml_parse_mode int := 0)\n"
"{\n"
"if (__tag (dict) <> 214)\n"
"signal (\'22023\', \'RDFXX\', \'The dict argument must be of type dictionary\');\n"
"if (flag = 0)\n"
"xml_parse_mode := 0;\n"
"rdf_load_rdfxml (strg, bit_or (flag, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"dict,\n"
"base );\n"
"}\n"
"--src sparql.sql:3107\n";

static const char *proc125 = 
"#line 3130 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDFA_LOAD_DICT (in strg varchar, in base varchar, in graph varchar, inout dict any, in xml_parse_mode int := 0)\n"
"{\n"
"declare app_env any;\n"
"if (__tag (dict) <> 214)\n"
"signal (\'22023\', \'RDFXX\', \'The dict argument must be of type dictionary\');\n"
"rdf_load_rdfxml (strg, bit_or (2, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\'),\n"
"dict,\n"
"base );\n"
"}\n"
"--src sparql.sql:3128\n";

static const char *proc126 = 
"#line 3151 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDFA_LOAD_DICT_XLAT (in strg varchar, in base varchar, in graph varchar, inout dict any, in xml_parse_mode int := 0, in iri_xlate_cbk varchar, in iri_xlate_env any)\n"
"{\n"
"declare app_env any;\n"
"if (__tag (dict) <> 214)\n"
"signal (\'22023\', \'RDFXX\', \'The dict argument must be of type dictionary\');\n"
"rdf_load_rdfxml (strg, bit_or (2, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_XLAT\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L_XLAT\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"vector (dict, iri_xlate_cbk, iri_xlate_env),\n"
"base );\n"
"}\n"
"--src sparql.sql:3149\n";

static const char *proc127 = 
"#line 3173 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_RDFA11_FETCH_PROFILES (in profile_iris any, inout prefixes any, inout terms any, inout vocab any)\n"
"{\n"
"declare agg any;\n"
"\n"
"foreach (varchar profile_iri in profile_iris) do\n"
"{\n"
"if (not exists (sparql define input:storage \"\" ask where { graph `iri(?:profile_iri)` { ?s ?p ?o }}))\n"
"DB.DBA.SPARUL_LOAD (profile_iri, profile_iri, 0, NULL, 0);\n"
"}\n"
"vectorbld_init (agg);\n"
"foreach (varchar profile_iri in profile_iris) do\n"
"{\n"
"for (sparql define input:storage \"\" prefix rdfa: <http://www.w3.org/ns/rdfa#>\n"
"select ?p, ?u\n"
"where {\n"
"graph `iri(?:profile_iri)` {\n"
"?s rdfa:prefix ?p ; rdfa:uri ?u .\n"
"optional { ?s rdfa:uri ?u2 . filter (?u != ?u2). }\n"
"filter (isliteral (?p))\n"
"filter (isliteral (?u))\n"
"filter (?u != \'\')\n"
"filter (!bound (?u2)) } }\n"
") do { vectorbld_acc (agg, \"p\", \"u\"); }\n"
"}\n"
"vectorbld_final (agg);\n"
"prefixes := agg;\n"
"vectorbld_init (agg);\n"
"foreach (varchar profile_iri in profile_iris) do\n"
"{\n"
"for (sparql define input:storage \"\" prefix rdfa: <http://www.w3.org/ns/rdfa#>\n"
"select ?t, ?u\n"
"where {\n"
"graph `iri(?:profile_iri)` {\n"
"?s rdfa:term ?t ; rdfa:uri ?u .\n"
"optional { ?s rdfa:uri ?u2 . filter (?u != ?u2). }\n"
"optional { ?s rdfa:term ?t2 . filter (?t != ?t2). }\n"
"filter (isliteral (?t))\n"
"filter (isliteral (?u))\n"
"filter (?t != \'\')\n"
"filter (?u != \'\')\n"
"filter (!bound (?t2))\n"
"filter (!bound (?u2)) } }\n"
"order by ?t\n"
") do { vectorbld_acc (agg, \"t\", \"u\"); }\n"
"}\n"
"vectorbld_final (agg);\n"
"if (1 < length (profile_iris))\n"
"gvector_sort (agg, 2, 0, 1);\n"
"terms := agg;\n"
"vocab := null;\n"
"foreach (varchar profile_iri in profile_iris) do\n"
"{\n"
"vocab := (sparql define input:storage \"\" prefix rdfa: <http://www.w3.org/ns/rdfa#>\n"
"select (max(str(?v)))\n"
"where {\n"
"graph `iri(?:profile_iri)` {\n"
"?s rdfa:vocabulary ?v } } );\n"
"if (isstring (vocab))\n"
"goto vocab_is_set;\n"
"}\n"
"vocab_is_set: ;\n"
"\n"
"}\n"
"--src sparql.sql:3171\n";

static const char *proc128 = 
"#line 3239 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_RDFA (in strg varchar, in base varchar, in graph varchar := null,\n"
"in xml_parse_mode integer := 0, in log_enable int := null, in transactional int := 0 )\n"
"{\n"
"return DB.DBA.RDF_LOAD_RDFXML_IMPL (strg, base, graph, bit_or (2, bit_shift (xml_parse_mode, 8)), log_enable, transactional);\n"
"}\n"
"--src sparql.sql:3237\n";

static const char *proc129 = 
"#line 3246 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION (in strg varchar, in base varchar, in graph varchar, in xml_parse_mode integer,\n"
"in iri_xlate_cbk varchar, in iri_xlate_env any)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION ()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION () requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION_CL (strg, base, graph, xml_parse_mode, iri_xlate_cbk, iri_xlate_env);\n"
"app_env := vector (\n"
"null,\n"
"null,\n"
"__max (length (strg) / 100, 100000),\n"
"null,\n"
"iri_xlate_cbk,\n"
"iri_xlate_env );\n"
"rdf_load_rdfxml (strg, bit_or (2, bit_shift (xml_parse_mode, 8)),\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_XLAT\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_XLAT\',\n"
"\'DB.DBA.TTLP_EV_COMMIT\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return graph;\n"
"}\n"
"--src sparql.sql:3244\n";

static const char *proc130 = 
"#line 3285 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_RDFA_TO_DICT (in strg varchar, in base varchar, in graph varchar := null)\n"
"{\n"
"declare res any;\n"
"res := dict_new (length (strg) / 100);\n"
"rdf_load_rdfxml (strg, 2,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_GET_IID\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE\',\n"
"\'DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"res,\n"
"base );\n"
"return res;\n"
"}\n"
"--src sparql.sql:3283\n";

static const char *proc131 = 
"#line 3305 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_XHTML_MICRODATA (in strg varchar, in base varchar, in graph varchar := null,\n"
"in xml_parse_mode integer := 1, in log_enable int := null, in transactional int := 0 )\n"
"{\n"
"return DB.DBA.RDF_LOAD_RDFXML_IMPL (strg, base, graph, bit_or (4, bit_shift (xml_parse_mode, 8)), log_enable, transactional);\n"
"}\n"
"--src sparql.sql:3303\n";

static const char *proc132 = 
"#line 3316 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_XML_IRI_TO_TTL (inout obj any, inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (isiri_id (obj))\n"
"{\n"
"if (obj >= min_bnode_iri_id ())\n"
"{\n"
"if (obj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (obj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (obj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (obj), sprintf (\'_:bad_iid_%d\', iri_id_num (obj)));\n"
"\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"{\n"
"if (\"LEFT\" (obj, 9) = \'nodeID://\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http (subseq (obj, 9), ses);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (obj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (cast (obj as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:3314\n";

static const char *proc133 = 
"#line 3362 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_XML_OBJ_TO_TTL (\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (isiri_id (o_val))\n"
"{\n"
"if (o_val >= min_bnode_iri_id ())\n"
"{\n"
"if (o_val >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (o_val) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (o_val)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (o_val), sprintf (\'_:bad_iid_%d\', iri_id_num (o_val)));\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"return;\n"
"}\n"
"http (\'\"\', ses);\n"
"if (__tag of XML = o_val)\n"
"http_escape (serialize_to_UTF8_xml (o_val), 11, ses, 1, 1);\n"
"else\n"
"http_escape (o_val, 11, ses, 1, 1);\n"
"if (isstring (o_type))\n"
"{\n"
"http (\'\"^^<\', ses);\n"
"http_escape (o_type, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (isstring (o_lang))\n"
"{\n"
"http (\'\"@\', ses);\n"
"http (o_lang, ses);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"http (\'\" \', ses);\n"
"}\n"
"--src sparql.sql:3360\n";

static const char *proc134 = 
"#line 3408 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID)\n"
"{\n"
" ;\n"
"}\n"
"--src sparql.sql:3406\n";

static const char *proc135 = 
"#line 3415 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (s_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (p_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (o_uri, app_env);\n"
"http (\'.\\n\', app_env);\n"
"}\n"
"--src sparql.sql:3413\n";

static const char *proc136 = 
"#line 3428 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (s_uri, app_env);\n"
"DB.DBA.RDF_XML_IRI_TO_TTL (p_uri, app_env);\n"
"DB.DBA.RDF_XML_OBJ_TO_TTL (o_val, o_type, o_lang, app_env);\n"
"http (\'.\\n\', app_env);\n"
"}\n"
"--src sparql.sql:3426\n";

static const char *proc137 = 
"#line 3441 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_CONVERT_RDFXML_TO_TTL (in strg varchar, in base varchar, inout ttl_ses any)\n"
"{\n"
"rdf_load_rdfxml (strg, 0,\n"
"\'http://example.com\',\n"
"vector (\n"
"\'\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE\',\n"
"\'DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L\',\n"
"\'\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"ttl_ses,\n"
"base );\n"
"}\n"
"--src sparql.sql:3439\n";

static const char *proc138 = 
"#line 3459 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_CONVERT_RDFXML_FILE_TO_TTL_FILE (in rdfxml_source_filename varchar, in base varchar, in ttl_target_filename varchar)\n"
"{\n"
"declare in_ses, out_ses any;\n"
"in_ses := file_to_string_output (rdfxml_source_filename);\n"
"out_ses := string_output ();\n"
"DB.DBA.RDF_CONVERT_RDFXML_TO_TTL (in_ses, base, out_ses);\n"
"string_to_file (ttl_target_filename, out_ses, -2);\n"
"}\n"
"--src sparql.sql:3457\n";

static const char *proc139 = 
"#line 3472 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_LONG_TO_TTL (inout obj any, inout ses any)\n"
"{\n"
"declare res varchar;\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_LONG_TO_TTL(): object is NULL\');\n"
"if (isiri_id (obj))\n"
"{\n"
"if (obj >= min_bnode_iri_id ())\n"
"{\n"
"if (obj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (obj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (obj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := coalesce (id_to_iri (obj), sprintf (\'_:bad_iid_%d\', iri_id_num (obj)));\n"
"\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"if (rdf_box_data_tag (obj) in (__tag of varchar, __tag of long varchar, __tag of nvarchar, __tag of long nvarchar, 185))\n"
"http_escape (__rdf_sqlval_of_obj (obj, 1), 11, ses, 1, 1);\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"__rdf_long_to_ttl (obj, ses);\n"
"else if (__tag of XML = rdf_box_data_tag (obj))\n"
"http_escape (serialize_to_UTF8_xml (__rdf_sqlval_of_obj (obj, 1)), 11, ses, 1, 1);\n"
"else if (__tag of varbinary = rdf_box_data_tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_sqlval_of_obj (obj, 1), 11, ses, 0, 0);\n"
"http (\'\" \', ses);\n"
"}\n"
"else\n"
"http_escape (cast (__rdf_sqlval_of_obj (obj, 1) as varchar), 11, ses, 1, 1);\n"
"if (257 <> rdf_box_type (obj))\n"
"{\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"if (res is null)\n"
"signal (\'RDFXX\', sprintf (\'Bad rdf box type (%d), box \"%s\"\', rdf_box_type (obj), cast (rdf_box_data (obj) as varchar)));\n"
"http (\'\"^^<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (257 <> rdf_box_lang (obj))\n"
"{\n"
"res := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"http (\'\"@\', ses); http (res, ses); http (\' \', ses);\n"
"}\n"
"else\n"
"http (\'\" \', ses);\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"{\n"
"if (1 = __box_flags (obj))\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (obj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 1, 1);\n"
"http (\'\" \', ses);\n"
"}\n"
"}\n"
"else if (__tag (obj) in (__tag of long varchar, __tag of nvarchar, __tag of long nvarchar, 185))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 1, 1);\n"
"http (\'\" \', ses);\n"
"}\n"
"else if (__tag of datetime = rdf_box_data_tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"__rdf_long_to_ttl (obj, ses);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (obj) as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"else if (__tag of varbinary =  __tag (obj))\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (obj, 11, ses, 0, 0);\n"
"http (\'\" \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_strsqlval (obj), 11, ses, 1, 1);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (obj) as varchar), 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:3470\n";

static const char *proc140 = 
"#line 3578 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (inout triples any)\n"
"{\n"
"return;\n"
"}\n"
"--src sparql.sql:3576\n";

static const char *proc141 = 
"#line 3585 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_VERBOSE_TTL (inout triples any, inout ses any)\n"
"{\n"
"declare tcount, tctr integer;\n"
"declare prev_s, prev_p IRI_ID;\n"
"declare res varchar;\n"
"declare string_subjs_found, string_preds_found integer;\n"
"string_subjs_found := 0;\n"
"string_preds_found := 0;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"return;\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj,pred any;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"if (not (isiri_id (subj)))\n"
"{\n"
"if (isstring (subj) and (1 = __box_flags (subj)))\n"
"string_subjs_found := 1;\n"
"else\n"
"{\n"
"if (subj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): subject is NULL\');\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): subject is literal\');\n"
"}\n"
"}\n"
"if (not isiri_id (pred))\n"
"{\n"
"if (isstring (pred) and (1 = __box_flags (pred)))\n"
"string_preds_found := 1;\n"
"else\n"
"{\n"
"if (pred is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): predicate is NULL\');\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): predicate is literal\');\n"
"}\n"
"}\n"
"if (pred >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_TTL(): blank node as predicate\');\n"
"}\n"
"if (not string_preds_found)\n"
"rowvector_digit_sort (triples, 1, 1);\n"
"if (not string_subjs_found)\n"
"rowvector_digit_sort (triples, 0, 1);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"prev_s := null;\n"
"prev_p := null;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj,pred,obj any;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"if (prev_s = subj)\n"
"{\n"
"if (prev_p = pred)\n"
"{\n"
"http (\',\\n\\t\\t\', ses);\n"
"goto print_o;\n"
"}\n"
"http (\';\\n\\t\', ses);\n"
"goto print_p;\n"
"}\n"
"if (prev_s is not null)\n"
"http (\'.\\n\', ses);\n"
"if (isstring (subj))\n"
"{\n"
"if (subj like \'nodeID://%\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http_escape (subseq (subj, 9), 12, ses, 1, 1);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (subj, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else if (subj >= min_bnode_iri_id ())\n"
"{\n"
"if (subj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (subj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (subj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (subj);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_s := subj;\n"
"prev_p := null;\n"
"print_p:\n"
"if (isstring (pred))\n"
"{\n"
"if (pred like \'nodeID://%\')\n"
"{\n"
"http (\'_:\', ses);\n"
"http_escape (subseq (pred, 9), 12, ses, 1, 1);\n"
"http (\' \', ses);\n"
"}\n"
"else\n"
"{\n"
"http (\'<\', ses);\n"
"http_escape (pred, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (pred);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_p := pred;\n"
"print_o:\n"
"DB.DBA.RDF_LONG_TO_TTL (obj, ses);\n"
"}\n"
"http (\'.\\n\', ses);\n"
"}\n"
"--src sparql.sql:3583\n";

static const char *proc142 = 
"#line 3717 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TRIPLES_TO_TTL_ENV (in tcount integer)\n"
"{\n"
"return vector (dict_new (__min (tcount, 16000)), 0, \'\', \'\', \'\', 0, 0, 0, 0);\n"
"}\n"
"--src sparql.sql:3715\n";

static const char *proc143 = 
"#line 3723 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_TTL (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"return;\n"
"}\n"
"env := DB.DBA.RDF_TRIPLES_TO_TTL_ENV (tcount);\n"
"{ whenever sqlstate \'*\' goto end_pred_sort;\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"end_pred_sort: ;\n"
"}\n"
"{ whenever sqlstate \'*\' goto end_subj_sort;\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"end_subj_sort: ;\n"
"}\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_ttl_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"http (\' .\', ses);\n"
"}\n"
"--src sparql.sql:3721\n";

static const char *proc144 = 
"#line 3752 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_TRIG (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, first_dflt_g_idx integer;\n"
"declare prev_g_iri varchar;\n"
"declare first_g_idx integer;\n"
"tcount := length (triples);\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty TriG\\n\', ses);\n"
"return;\n"
"}\n"
"env := DB.DBA.RDF_TRIPLES_TO_TTL_ENV (tcount);\n"
"{ whenever sqlstate \'*\' goto end_pred_sort;\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"end_pred_sort: ;\n"
"}\n"
"{ whenever sqlstate \'*\' goto end_subj_sort;\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"end_subj_sort: ;\n"
"}\n"
"rowvector_graph_sort (triples, 3, 1);\n"
"\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; (tctr < tcount) and aref_or_default (triples, tctr, 3, null) is null; tctr := tctr + 1)\n"
"{\n"
"http_ttl_prefixes (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"first_g_idx := tctr;\n"
"for (tctr := first_g_idx; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_ttl_prefixes (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"if (0 < first_g_idx)\n"
"{\n"
"http (\'{\\n\', ses);\n"
"for (tctr := 0; tctr < first_g_idx; tctr := tctr + 1)\n"
"{\n"
"http_ttl_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"http (\' .\\n}\\n\', ses);\n"
"}\n"
"prev_g_iri := \'\';\n"
"for (tctr := first_g_idx; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare g_iri varchar;\n"
"g_iri := id_to_iri_nosignal (triples[tctr][3]);\n"
"if (g_iri is not null)\n"
"{\n"
"if (g_iri <> prev_g_iri)\n"
"{\n"
"if (prev_g_iri <> \'\')\n"
"http (\' .\\n}\\n\', ses);\n"
"env[1] := 0;\n"
"http (\'<\', ses);\n"
"http_escape (g_iri, 12, ses, 1, 1);\n"
"http (\'> = {\\n\', ses);\n"
"prev_g_iri := g_iri;\n"
"}\n"
"http_ttl_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"}\n"
"if (prev_g_iri <> \'\')\n"
"http (\' .\\n}\\n\', ses);\n"
"}\n"
"--src sparql.sql:3750\n";

static const char *proc145 = 
"#line 3819 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_NT (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty NT\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (0, 0, 0);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_nt_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"}\n"
"--src sparql.sql:3817\n";

static const char *proc146 = 
"#line 3839 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_TO_TTL (in graph_iri varchar, inout ses any)\n"
"{\n"
"declare tcount integer;\n"
"declare res varchar;\n"
"declare prev_s, prev_p IRI_ID;\n"
"\n"
"tcount := 0;\n"
"prev_s := null;\n"
"prev_p := null;\n"
"for (select S as subj, P as pred, O as obj from DB.DBA.RDF_QUAD where G = iri_to_id (graph_iri)) do\n"
"{\n"
"if (prev_s = subj)\n"
"{\n"
"if (prev_p = pred)\n"
"{\n"
"http (\',\\n\\t\\t\', ses);\n"
"goto print_o;\n"
"}\n"
"http (\';\\n\\t\', ses);\n"
"goto print_p;\n"
"}\n"
"if (prev_s is not null)\n"
"http (\'.\\n\', ses);\n"
"if (subj >= min_bnode_iri_id ())\n"
"{\n"
"if (subj >= #ib0)\n"
"http (sprintf (\'_:bb%d \', iri_id_num (subj) - iri_id_num (#ib0)), ses);\n"
"else\n"
"http (sprintf (\'_:b%d \', iri_id_num (subj)), ses);\n"
"}\n"
"else\n"
"{\n"
"res := id_to_iri (subj);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_s := subj;\n"
"prev_p := null;\n"
"print_p:\n"
"if (pred >= min_bnode_iri_id ())\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_GRAPH_TO_TTL(): blank node as predicate\');\n"
"else\n"
"{\n"
"res := id_to_iri (pred);\n"
"http (\'<\', ses);\n"
"http_escape (res, 12, ses, 1, 1);\n"
"http (\'> \', ses);\n"
"}\n"
"prev_p := pred;\n"
"print_o:\n"
"DB.DBA.RDF_LONG_TO_TTL (obj, ses);\n"
"tcount := tcount + 1;\n"
"}\n"
"if (0 = tcount)\n"
"http (\'# Empty TURTLE\\n\', ses);\n"
"else\n"
"http (\'.\\n\', ses);\n"
"}\n"
"--src sparql.sql:3837\n";

static const char *proc147 = 
"#line 3913 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (inout triples any, in print_top_level integer, inout ses any)\n"
"{\n"
"declare ns_dict, env any;\n"
"declare tcount, tctr integer;\n"
"tcount := length (triples);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"{ whenever sqlstate \'*\' goto end_pred_sort;\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"end_pred_sort: ;\n"
"}\n"
"ns_dict := dict_new (case (print_top_level) when 0 then 10 else __min (tcount, 16000) end);\n"
"dict_put (ns_dict, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\', \'rdf\');\n"
"dict_put (ns_dict, \'http://www.w3.org/2000/01/rdf-schema#\', \'rdfs\');\n"
"env := vector (ns_dict, 0, 0, \'\', \'\', 0, 0, 0, 0);\n"
"if (print_top_level)\n"
"{\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\\n<rdf:RDF\\n\\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\\n\\txmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\', ses);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_rdfxml_p_ns (env, triples[tctr][1], ses);\n"
"}\n"
"http (\' >\', ses);\n"
"}\n"
"{ whenever sqlstate \'*\' goto end_subj_sort;\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"end_subj_sort: ;\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"http_rdfxml_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"}\n"
"if (isstring (env[2]))\n"
"http (\'\\n  </rdf:Description>\', ses);\n"
"if (print_top_level)\n"
"{\n"
"http (\'\\n</rdf:RDF>\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:3911\n";

static const char *proc148 = 
"#line 3966 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, status integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'{ }\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (0, 0, 0, null);\n"
"\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"http (\'{\\n  \', ses);\n"
"status := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"if (http_talis_json_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses))\n"
"status := 1;\n"
"}\n"
"if (status)\n"
"http (\' ] }\\n\', ses);\n"
"http (\'}\\n\', ses);\n"
"}\n"
"--src sparql.sql:3964\n";

static const char *proc149 = 
"#line 3995 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_JSON_LD (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, status integer;\n"
"tcount := length (triples);\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'{ }\\n\', ses);\n"
"return;\n"
"}\n"
"env := vector (0, 0, 0, null);\n"
"\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"http (\'{ \"@graph\": [\\n    \', ses);\n"
"status := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"if (http_ld_json_triple (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses))\n"
"status := 1;\n"
"}\n"
"if (status)\n"
"http (\' ] }\\n\', ses);\n"
"http (\'] }\\n\', ses);\n"
"}\n"
"--src sparql.sql:3993\n";

static const char *proc150 = 
"#line 4024 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_JSON (inout triples any, inout ses any)\n"
"{\n"
"declare tcount, tctr, env integer;\n"
"tcount := length (triples);\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [ \"s\", \"p\", \"o\" ] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', ses);\n"
"tcount := length (triples);\n"
"env := vector (0, 0, vector (\'s\', \'p\', \'o\'), null);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare triple any;\n"
"if (tctr > 0)\n"
"http(\',\', ses);\n"
"triple := aref_set_0 (triples, tctr);\n"
"sparql_rset_json_write_row (ses, env, triple);\n"
"aset_zap_arg (triples, tctr, triple);\n"
"}\n"
"http (\' ] } }\', ses);\n"
"}\n"
"--src sparql.sql:4022\n";

static const char *proc151 = 
"#line 4045 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_CSV (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, status integer;\n"
"http (\'\"subject\",\"predicate\",\"object\"\\n\', ses);\n"
"tcount := length (triples);\n"
"\n"
"{ whenever sqlstate \'*\' goto p_done; rowvector_subj_sort (triples, 1, 1); p_done: ; }\n"
"{ whenever sqlstate \'*\' goto s_done; rowvector_subj_sort (triples, 0, 1); s_done: ; }\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][0]);\n"
"http (\',\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][1]);\n"
"http (\',\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][2]);\n"
"http (\'\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:4043\n";

static const char *proc152 = 
"#line 4067 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_TSV (inout triples any, inout ses any)\n"
"{\n"
"declare env any;\n"
"declare tcount, tctr, status integer;\n"
"http (\'\"subject\",\"predicate\",\"object\"\\n\', ses);\n"
"tcount := length (triples);\n"
"\n"
"{ whenever sqlstate \'*\' goto p_done; rowvector_subj_sort (triples, 1, 1); p_done: ; }\n"
"{ whenever sqlstate \'*\' goto s_done; rowvector_subj_sort (triples, 0, 1); s_done: ; }\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][0]);\n"
"http (\'\\t\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][1]);\n"
"http (\'\\t\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, triples[tctr][2]);\n"
"http (\'\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:4065\n";

static const char *proc153 = 
"#line 4089 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, nsdict, nslist any;\n"
"declare ctr, len, tcount, tctr, status integer;\n"
"tcount := length (triples);\n"
"\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n\n"
"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML+RDFa 1.0//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd\">\\n\', ses);\n"
"if (0 = tcount)\n"
"{\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"<head><title>Empty RDFa+XHTML document</title></head><body>\n"
"<p>This document is empty and basically useless. It is generated by a web service that can make some statements in XHTML+RDFa format.\n"
"This time the service made zero such statements, sorry.</p></body></html>\', ses);\n"
"return;\n"
"}\n"
"nsdict := dict_new (10 + cast (sqrt(tcount) as integer));\n"
"dict_put (nsdict, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\', \'rdf\');\n"
"dict_put (nsdict, \'http://www.w3.org/2001/XMLSchema#\', \'xsdh\');\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; (tctr < tcount) and (1000 > dict_size (nsdict)); tctr := tctr + 1)\n"
"{\n"
"sparql_iri_split_rdfa_qname (triples[tctr][0], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][1], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][2], nsdict, 1);\n"
"}\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\"\', ses);\n"
"nslist := dict_to_vector (nsdict, 0);\n"
"len := length (nslist);\n"
"for (ctr := len - 2; ctr >= 0; ctr := ctr-2)\n"
"{\n"
"http (sprintf (\'\\n  xmlns:%s=\"\', nslist[ctr+1]), ses);\n"
"http_escape (nslist[ctr], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'>\\n<head><title>RDFa+XHTML document</title></head><body>\\n\', ses);\n"
"http (sprintf (\'<p>This document contains %d facts in XHTML+RDFa format.</p>\',\n"
"tcount), ses);\n"
"http (\'<p>A generic web browser may not display them but the document can be saved on disk and used by some appropriate program or sent to a third party.\n"
"Use \"Save As\" or \"Send To\" menu item of the browser; choose \"HTML\" file type, not \"text file\" or \"web archive\".\n"
"</p><p>The rest of the document may look like garbage for humans or not displayed by the browser.</p>\\n<ul>\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"prev_subj := null;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"if (prev_subj is not null)\n"
"http (\'\\n</ul></li>\', ses);\n"
"http (\'\\n<li about=\"[\', ses);\n"
"split := sparql_iri_split_rdfa_qname (subj, nsdict, 2);\n"
"\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\']\">\\n<ul>\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\']\">\\n<ul>\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'s:\', split[2]), 3, ses, 1, 1);\n"
"http (\']\" xmlns:s=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\">\\n<ul>\', ses);\n"
"}\n"
"prev_subj := subj;\n"
"}\n"
"obj_iri_split := sparql_iri_split_rdfa_qname (obj, nsdict, 2);\n"
"http (case (isvector (obj_iri_split)) when 0 then \'\\n<li property=\"\' else \'\\n<li rel=\"\' end, ses);\n"
"split := sparql_iri_split_rdfa_qname (pred, nsdict, 2);\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'p:\', split[2]), 3, ses, 1, 1);\n"
"http (\'\" xmlns:p=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_RDFA_XHTML: object is NULL\');\n"
"if (isvector (obj_iri_split))\n"
"{\n"
"http (\' resource=\"\', ses);\n"
"if (isstring (obj_iri_split[0]))\n"
"{\n"
"http (\'[\', ses);\n"
"http_escape (concat (obj_iri_split[0], \':\', obj_iri_split[2]), 3, ses, 1, 1);\n"
"http (\']\" />\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (obj_iri_split[1], \':\', obj_iri_split[2]), 3, ses, 1, 1);\n"
"http (\'\" />\', ses);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_type (obj))\n"
"dt := coalesce ((select __bft (RDT_QNAME, 1) from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"else if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"if (257 = rdf_box_type (obj))\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"if (not (isinteger (dt)))\n"
"{\n"
"http (\' datatype=\"\', ses);\n"
"split := sparql_iri_split_rdfa_qname (dt, nsdict, 2);\n"
"if (\'\' = split[1])\n"
"{\n"
"http_escape (split[2], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isstring (split[0]))\n"
"{\n"
"http_escape (concat (split[0], \':\', split[2]), 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else\n"
"{\n"
"http_escape (concat (\'dt:\', split[2]), 3, ses, 1, 1);\n"
"http (\'\" xmlns:dt=\"\', ses);\n"
"http_escape (split[1], 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"}\n"
"if (isstring (lang))\n"
"{\n"
"http (\' xml:lang=\"\', ses);\n"
"http_escape (lang, 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'>\', ses);\n"
"if (__tag of datetime = __tag(sqlval))\n"
"__rdf_long_to_ttl (sqlval, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"http_value (charset_recode (sqlval, \'UTF-8\', \'_WIDE_\'), 0, ses);\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (sqlval))\n"
"sqlval := charset_recode (sqlval, \'UTF-8\', \'_WIDE_\');\n"
"http_value (sqlval, 0, ses);\n"
"}\n"
"http (\'</li>\', ses);\n"
"}\n"
"}\n"
"if (prev_subj is not null)\n"
"http (\'\\n</ul></li></ul>\', ses);\n"
"http (\'\\n</body></html>\\n\', ses);\n"
"}\n"
"--src sparql.sql:4087\n";

static const char *proc154 = 
"#line 4283 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_ENDPOINT_DESCRIBE_LINK_FMT (in ul_or_tr varchar)\n"
"{\n"
"declare lpath varchar;\n"
"lpath := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"if (lpath is null)\n"
"lpath := \'/sparql\';\n"
"else\n"
"lpath := \'http://\' || lpath || \'/sparql\';\n"
"whenever sqlstate \'HT013\' goto no_http_context;\n"
"lpath := http_path ();\n"
"no_http_context:\n"
"return \' <a href=\" \' || lpath || \'?query=describe+%%3C%U%%3E&amp;format=text%%2Fx-html%%2B\' || ul_or_tr || \'\">describe</a> \';\n"
"}\n"
"--src sparql.sql:4281\n";

static const char *proc155 = 
"#line 4298 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_PIVOT_DESCRIBE_LINK (in iri varchar)\n"
"{\n"
"return sprintf (\'; <a href=\"/describe/?url=%U&sid=1&amp;urilookup=1\">facets</a> \', iri);\n"
"}\n"
"--src sparql.sql:4296\n";

static const char *proc156 = 
"#line 4304 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_HTML_UL (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, prev_pred any;\n"
"declare can_pivot, ctr, len, tcount, tctr, status, obj_needs_br integer;\n"
"declare endpoint_fmt, subj_iri, pred_iri varchar;\n"
"tcount := length (triples);\n"
"\n"
"http (\'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML+RDFa 1.0//EN\" \"http://www.w3.org/MarkUp/DTD/xhtml-rdfa-1.dtd\">\\n\', ses);\n"
"if (0 = tcount)\n"
"{\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"<head><title>Empty HTML RDFa and Microdata document</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n"
"</head><body>\n"
"<p>This document is empty and basically useless. It is generated by a web service that can make some statements in HTML Microdata format.\n"
"This time the service made zero such statements, sorry.</p></body></html>\', ses);\n"
"return;\n"
"}\n"
"endpoint_fmt := DB.DBA.RDF_ENDPOINT_DESCRIBE_LINK_FMT (\'ul\');\n"
"can_pivot := case (isnull (DB.DBA.VAD_CHECK_VERSION (\'PivotViewer\'))) when 0 then 1 else 0 end;\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\"\', ses);\n"
"http (\'>\\n<head><title>HTML RDFa and Microdata document</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n"
"</head>\\n<body>\\n<ul>\\n\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"prev_subj := prev_pred := null;\n"
"obj_needs_br := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"if (prev_subj is not null)\n"
"http (\'\\n          </ul></li>\\n      </ul></li>\', ses);\n"
"subj_iri := id_to_iri (subj);\n"
"http (\'\\n  <li about=\"\', ses);\n"
"http_escape (subj_iri, 3, ses, 1, 1);\n"
"http (\'\" itemscope=\"\" itemid=\"\', ses);\n"
"http_escape (subj_iri, 3, ses, 1, 1);\n"
"http (\'\"><a href=\"\', ses);\n"
"http_escape (subj_iri, 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"http_escape (subj_iri, 1, ses, 1, 1);\n"
"http (\'</a> (\', ses);\n"
"http (sprintf (endpoint_fmt, subj_iri), ses);\n"
"if (can_pivot)\n"
"http (DB.DBA.RDF_PIVOT_DESCRIBE_LINK (subj_iri), ses);\n"
"http (\')\\n    <ul>\', ses);\n"
"prev_subj := subj;\n"
"prev_pred := null;\n"
"}\n"
"if (prev_pred is null or (pred <> prev_pred))\n"
"{\n"
"if (prev_pred is not null)\n"
"http (\'\\n        </ul></li>\', ses);\n"
"pred_iri := id_to_iri (pred);\n"
"http (\'\\n      <li><a href=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"http_escape (pred_iri, 1, ses, 1, 1);\n"
"http (\'</a> (\', ses);\n"
"http (sprintf (endpoint_fmt, pred_iri), ses);\n"
"if (can_pivot)\n"
"http (DB.DBA.RDF_PIVOT_DESCRIBE_LINK (pred_iri), ses);\n"
"http (\')\\n        <ul>\', ses);\n"
"prev_pred := pred;\n"
"obj_needs_br := 0;\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_HTML_UL: object is NULL\');\n"
"if (obj_needs_br)\n"
"http (\'\\n\', ses);\n"
"else\n"
"obj_needs_br := 1;\n"
"if (isiri_id (obj))\n"
"{\n"
"declare obj_iri varchar;\n"
"obj_iri := id_to_iri (obj);\n"
"http (\'\\n          <li><a rel=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" resource=\"\', ses);\n"
"http_escape (obj_iri, 3, ses, 1, 1);\n"
"http (\'\" itemprop=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" href=\"\', ses);\n"
"http_escape (obj_iri, 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"http_escape (obj_iri, 1, ses, 1, 1);\n"
"http (\'</a> (\', ses);\n"
"http (sprintf (endpoint_fmt, obj_iri), ses);\n"
"if (can_pivot)\n"
"http (DB.DBA.RDF_PIVOT_DESCRIBE_LINK (obj_iri), ses);\n"
"http (\')</li>\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"http (\'\\n          <li property=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" itemprop=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"else if (257 <> rdf_box_type (obj))\n"
"dt := coalesce ((select __bft (RDT_QNAME, 1) from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"if (257 = rdf_box_type (obj))\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"if (not (isinteger (dt)))\n"
"{\n"
"http (\'\" datatype=\"\', ses);\n"
"http_escape (dt, 3, ses, 1, 1);\n"
"}\n"
"if (isstring (lang))\n"
"{\n"
"http (\'\" xml:lang=\"\', ses);\n"
"http_escape (lang, 3, ses, 1, 1);\n"
"}\n"
"http (\'\">\', ses);\n"
"if (__tag of datetime = __tag(sqlval))\n"
"__rdf_long_to_ttl (sqlval, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"http_value (charset_recode (sqlval, \'UTF-8\', \'_WIDE_\'), 0, ses);\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (sqlval))\n"
"sqlval := charset_recode (sqlval, \'UTF-8\', \'_WIDE_\');\n"
"http_value (sqlval, 0, ses);\n"
"}\n"
"http (\'</li>\', ses);\n"
"}\n"
"}\n"
"if (prev_subj is not null)\n"
"http (\'\\n        </ul></li></ul></li></ul>\', ses);\n"
"http (\'\\n</body></html>\\n\', ses);\n"
"}\n"
"--src sparql.sql:4302\n";

static const char *proc157 = 
"#line 4472 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_HTML_TR (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, prev_pred any;\n"
"declare can_pivot, ctr, len, tcount, tctr, status integer;\n"
"declare endpoint_fmt, subj_iri, pred_iri, subj_recod, pred_recod, subj_trtd, pred_tdtd varchar;\n"
"tcount := length (triples);\n"
"\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"<head><title>Empty HTML RDFa and Microdata document</title></head><body>\n"
"<p>This document is empty and basically useless. It is generated by a web service that can make some statements in HTML Microdata format.\n"
"This time the service made zero such statements, sorry.</p></body></html>\', ses);\n"
"return;\n"
"}\n"
"endpoint_fmt := DB.DBA.RDF_ENDPOINT_DESCRIBE_LINK_FMT (\'tr\');\n"
"can_pivot := case (isnull (DB.DBA.VAD_CHECK_VERSION (\'PivotViewer\'))) when 0 then 1 else 0 end;\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\"\', ses);\n"
"http (\'>\\n<head><title>HTML RDFa and Microdata document</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n"
"</head>\\n<body>\\n<table>\\n\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"prev_subj := prev_pred := null;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"declare trtd_ses any;\n"
"subj_iri := id_to_iri (subj);\n"
"\n"
"\n"
"\n"
"\n"
"trtd_ses := string_output ();\n"
"http (\'\\n<tr itemscope=\"itemscope\" about=\"\', trtd_ses);\n"
"http_escape (subj_iri, 3, trtd_ses, 1, 1);\n"
"http (\'\" itemid=\"\', trtd_ses);\n"
"http_escape (subj_iri, 3, trtd_ses, 1, 1);\n"
"http (\'\">\\n  <td><a href=\"\', trtd_ses);\n"
"http_escape (subj_iri, 3, trtd_ses, 1, 1);\n"
"http (sprintf (\'\">%V</a> (\' || endpoint_fmt || \'%s)</td>\', subj_iri, subj_iri,\n"
"case when (can_pivot) then DB.DBA.RDF_PIVOT_DESCRIBE_LINK (id_to_iri (subj)) else \'\' end ),\n"
"trtd_ses );\n"
"subj_trtd := string_output_string (trtd_ses);\n"
"prev_subj := subj;\n"
"}\n"
"if (prev_pred is null or (pred <> prev_pred))\n"
"{\n"
"declare tdtd_ses any;\n"
"pred_iri := id_to_iri (pred);\n"
"\n"
"\n"
"\n"
"\n"
"tdtd_ses := string_output ();\n"
"http (\'\\n  <td><a href=\"\', tdtd_ses);\n"
"http_escape (pred_iri, 3, tdtd_ses, 1, 1);\n"
"http (\'\">\', tdtd_ses);\n"
"http_escape (pred_iri, 1, tdtd_ses, 1, 1);\n"
"http (sprintf (\'</a> (\' || endpoint_fmt || \'%s)\\n  </td><td\', pred_iri,\n"
"case when (can_pivot) then DB.DBA.RDF_PIVOT_DESCRIBE_LINK (id_to_iri (pred)) else \'\' end ),\n"
"tdtd_ses );\n"
"pred_tdtd := string_output_string (tdtd_ses);\n"
"prev_pred := pred;\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_HTML_TR: object is NULL\');\n"
"http (subj_trtd, ses);\n"
"http (pred_tdtd, ses);\n"
"if (isiri_id (obj))\n"
"{\n"
"declare obj_iri varchar;\n"
"obj_iri := id_to_iri (obj);\n"
"http (\'><a rel=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" resource=\"\', ses);\n"
"http_escape (obj_iri, 3, ses, 1, 1);\n"
"http (\'\" itemprop=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" href=\"\', ses);\n"
"http_escape (obj_iri, 3, ses, 1, 1);\n"
"http (sprintf (\'\">%V</a> (\' || endpoint_fmt, obj_iri, obj_iri), ses);\n"
"if (can_pivot)\n"
"http (DB.DBA.RDF_PIVOT_DESCRIBE_LINK (obj_iri), ses);\n"
"http (\')</td></tr>\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"http (\' property=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"http (\'\" itemprop=\"\', ses);\n"
"http_escape (pred_iri, 3, ses, 1, 1);\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"else if (257 <> rdf_box_type (obj))\n"
"dt := coalesce ((select __bft (RDT_QNAME, 1) from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = rdf_box_type (obj)));\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"if (__tag of datetime = __tag (sqlval))\n"
"{\n"
"if (257 = rdf_box_type (obj))\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"dt := __xsd_type (sqlval);\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"if (not (isinteger (dt)))\n"
"{\n"
"http (\'\" datatype=\"\', ses);\n"
"http_escape (dt, 3, ses, 1, 1);\n"
"}\n"
"if (isstring (lang))\n"
"{\n"
"http (\'\" xml:lang=\"\', ses);\n"
"http_escape (lang, 3, ses, 1, 1);\n"
"}\n"
"http (\'\">\', ses);\n"
"if (__tag of datetime = __tag(sqlval))\n"
"__rdf_long_to_ttl (sqlval, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"http_value (charset_recode (sqlval, \'UTF-8\', \'_WIDE_\'), 0, ses);\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (sqlval))\n"
"sqlval := charset_recode (sqlval, \'UTF-8\', \'_WIDE_\');\n"
"http_value (sqlval, 0, ses);\n"
"}\n"
"http (\'</td></tr>\', ses);\n"
"}\n"
"}\n"
"http (\'\\n</table></body></html>\\n\', ses);\n"
"}\n"
"--src sparql.sql:4470\n";

static const char *proc158 = 
"#line 4632 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, prev_pred, nsdict, nslist any;\n"
"declare ctr, len, tcount, tctr, status, obj_needs_br integer;\n"
"tcount := length (triples);\n"
"\n"
"\n"
"if (0 = tcount)\n"
"{\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"<head><title>Empty HTML Microdata document</title></head><body>\n"
"<p>This document is empty and basically useless. It is generated by a web service that can make some statements in HTML Microdata format.\n"
"This time the service made zero such statements, sorry.</p></body></html>\', ses);\n"
"return;\n"
"}\n"
"nsdict := dict_new (10 + cast (sqrt(tcount) as integer));\n"
"dict_put (nsdict, \'http://www.w3.org/1999/02/22-rdf-syntax-ns#\', \'rdf\');\n"
"dict_put (nsdict, \'http://www.w3.org/2001/XMLSchema#\', \'xsdh\');\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"for (tctr := 0; (tctr < tcount) and (1000 > dict_size (nsdict)); tctr := tctr + 1)\n"
"{\n"
"sparql_iri_split_rdfa_qname (triples[tctr][0], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][1], nsdict, 1);\n"
"sparql_iri_split_rdfa_qname (triples[tctr][2], nsdict, 1);\n"
"}\n"
"http (\'<html xmlns=\"http://www.w3.org/1999/xhtml\"\', ses);\n"
"http (\'>\\n<head><title>HTML Microdata document</title></head><body>\\n\', ses);\n"
"http (sprintf (\'<p>This document contains %d facts in HTML Microdata format.</p>\',\n"
"tcount), ses);\n"
"http (\'<p>A generic web browser may not display them properly but the document can be saved on disk and used by some appropriate program or sent to a third party.\n"
"Use \"Save As\" or \"Send To\" menu item of the browser; choose \"HTML\" file type, not \"text file\" or \"web archive\".\n"
"</p><p>The rest of the document may look like garbage for humans or not displayed by the browser.</p>\', ses);\n"
"http (\'\\n<table><tr><th>Prefix</th><th>Namespace IRI</th></tr>\', ses);\n"
"nslist := dict_to_vector (nsdict, 0);\n"
"len := length (nslist);\n"
"for (ctr := len - 2; ctr >= 0; ctr := ctr-2)\n"
"{\n"
"http (sprintf (\'\\n<tr><td>%V</td><td>%V</td></tr>\', nslist[ctr+1], nslist[ctr]), ses);\n"
"}\n"
"http (\'</table>\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"prev_subj := prev_pred := null;\n"
"obj_needs_br := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"if (isstring (subj))\n"
"subj := iri_to_id (subj);\n"
"if (isstring (pred))\n"
"pred := iri_to_id (pred);\n"
"if (isstring (obj) and __box_flags (obj) = 1)\n"
"obj := iri_to_id (obj);\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"if (prev_subj is not null)\n"
"http (\'\\n</dd></dl>\', ses);\n"
"http (sprintf (\'\\n<dl itemscope itemid=\"%s\">\', replace (id_to_iri (subj), \'\"\', \'%22\')), ses);\n"
"split := sparql_iri_split_rdfa_qname (subj, nsdict, 2);\n"
"\n"
"if (\'\' = split[1])\n"
"http (sprintf (\'\\n<dt>Subject Item</dt><dd>%V</dd>\', split[2]), ses);\n"
"else if (isstring (split[0]))\n"
"http (sprintf (\'\\n<dt>Subject Item</dt><dd>%V:%V</dd>\', split[0], split[2]), ses);\n"
"else\n"
"http (sprintf (\'\\n<dt>Subject Item</dt><dd>%V%V</dd>\', split[1], split[2]), ses);\n"
"prev_subj := subj;\n"
"prev_pred := null;\n"
"}\n"
"if (prev_pred is null or (pred <> prev_pred))\n"
"{\n"
"if (prev_pred is not null)\n"
"http (\'\\n</dd>\', ses);\n"
"split := sparql_iri_split_rdfa_qname (pred, nsdict, 2);\n"
"\n"
"if (\'\' = split[1])\n"
"http (sprintf (\'\\n<dt>%V</dt><dd>\', split[2]), ses);\n"
"else if (isstring (split[0]))\n"
"http (sprintf (\'\\n<dt>%V:%V</dt><dd>\', split[0], split[2]), ses);\n"
"else\n"
"http (sprintf (\'\\n<dt>%V%V</dt><dd>\', split[1], split[2]), ses);\n"
"prev_pred := pred;\n"
"obj_needs_br := 0;\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_HTML_MICRODATA: object is NULL\');\n"
"if (obj_needs_br)\n"
"http (\'\\n\', ses);\n"
"else\n"
"obj_needs_br := 1;\n"
"obj_iri_split := sparql_iri_split_rdfa_qname (obj, nsdict, 2);\n"
"if (isvector (obj_iri_split))\n"
"{\n"
"http (sprintf (\'\\n<a itemprop=\"%s\" href=\"%s\">\', replace (id_to_iri (pred), \'\"\', \'%22\'), replace (id_to_iri (obj), \'\"\', \'%22\')), ses);\n"
"if (\'\' = obj_iri_split[1])\n"
"http (sprintf (\'%V</a>\', obj_iri_split[2]), ses);\n"
"else if (isstring (obj_iri_split[0]))\n"
"http (sprintf (\'%V:%V</a>\', obj_iri_split[0], obj_iri_split[2]), ses);\n"
"else\n"
"http (sprintf (\'%V%V</a>\', obj_iri_split[1], obj_iri_split[2]), ses);\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"http (sprintf (\'\\n<span itemprop=\"%s\"\', replace (id_to_iri (pred), \'\"\', \'%22\')), ses);\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"\n"
"\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (isstring (lang))\n"
"{\n"
"http (\' xml:lang=\"\', ses);\n"
"http_escape (lang, 3, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"http (\'>\', ses);\n"
"if (__tag of datetime = __tag(sqlval))\n"
"__rdf_long_to_ttl (sqlval, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"http_value (charset_recode (sqlval, \'UTF-8\', \'_WIDE_\'), 0, ses);\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (sqlval))\n"
"sqlval := charset_recode (sqlval, \'UTF-8\', \'_WIDE_\');\n"
"http_value (sqlval, 0, ses);\n"
"}\n"
"http (\'</span>\', ses);\n"
"}\n"
"}\n"
"if (prev_subj is not null)\n"
"http (\'\\n</dd></dl>\', ses);\n"
"http (\'\\n</body></html>\\n\', ses);\n"
"}\n"
"--src sparql.sql:4630\n";

static const char *proc159 = 
"#line 4819 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA (inout triples any, inout ses any)\n"
"{\n"
"declare env, prev_subj, prev_pred any;\n"
"declare ctr, len, tcount, tctr, status, obj_needs_comma integer;\n"
"tcount := length (triples);\n"
"\n"
"http (\'{ \"items\" : [\', ses);\n"
"env := vector (0, 0, 0, null);\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"prev_subj := prev_pred := null;\n"
"obj_needs_comma := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare subj, pred, obj, split, obj_iri_split any;\n"
"declare pred_tagname varchar;\n"
"declare res varchar;\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"\n"
"\n"
"\n"
"if (prev_subj is null or (subj <> prev_subj))\n"
"{\n"
"declare subj_iri varchar;\n"
"if (prev_subj is not null)\n"
"http (\' ] } },\\n\', ses);\n"
"if (isstring (subj))\n"
"subj_iri := subj;\n"
"else\n"
"subj_iri := id_to_iri (subj);\n"
"if (starts_with (subj_iri, \'nodeID://\'))\n"
"subj_iri := \'_:\' || subseq (subj_iri, 9);\n"
"http (\'\\n    { \"id\" : \"\', ses); http_escape (subj_iri, 14, ses, 1, 1); http (\'\"\\n      \"properties\" : {\', ses);\n"
"prev_subj := subj;\n"
"prev_pred := null;\n"
"}\n"
"if (prev_pred is null or (pred <> prev_pred))\n"
"{\n"
"if (prev_pred is not null)\n"
"http (\' ] ,\', ses);\n"
"http (\'\\n        \"\', ses); http_escape (case when isstring (pred) then pred else id_to_iri (pred) end, 14, ses, 1, 1); http (\'\" : [ \', ses);\n"
"prev_pred := pred;\n"
"obj_needs_comma := 0;\n"
"}\n"
"if (obj is null)\n"
"signal (\'RDFXX\', \'DB.DBA.TRIPLES_TO_JSON_MICRODATA: object is NULL\');\n"
"if (obj_needs_comma)\n"
"http (\',\\n          \', ses);\n"
"else\n"
"obj_needs_comma := 1;\n"
"if (isiri_id (obj))\n"
"{\n"
"declare obj_iri varchar;\n"
"obj_iri := id_to_iri (obj);\n"
"if (starts_with (obj_iri, \'nodeID://\'))\n"
"obj_iri := \'_:\' || subseq (obj_iri, 9);\n"
"http (\'{ \"id\" : \"\', ses); http_escape (obj_iri, 14, ses, 1, 1); http (\'\" }\', ses);\n"
"}\n"
"else\n"
"{\n"
"declare sqlval any;\n"
"declare dt, lang, strval any;\n"
"dt := 0; lang := 0;\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"if (257 <> rdf_box_lang (obj))\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (obj)));\n"
"\n"
"\n"
"sqlval := __rdf_sqlval_of_obj (obj, 1);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"else if (__tag (obj) not in (__tag of varchar, __tag of varbinary))\n"
"{\n"
"sqlval := obj;\n"
"\n"
"}\n"
"else\n"
"sqlval := obj;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (__tag (sqlval) in (__tag of integer, __tag of real, __tag of double precision, __tag of decimal))\n"
"http_value (sqlval, 0, ses);\n"
"else if (__tag (sqlval) in (__tag of varbinary, __tag of XML))\n"
"{\n"
"declare tmpses any;\n"
"tmpses := string_output();\n"
"http_value (sqlval, 0, tmpses);\n"
"http (\'\"\', ses); http_escape (string_output_string (tmpses), 14, ses, 1, 1); http (\'\"\', ses);\n"
"}\n"
"else if (__tag of varchar = __tag (sqlval))\n"
"{\n"
"http (\'\"\', ses); http_escape (sqlval, 14, ses, 1, 1); http (\'\"\', ses);\n"
"}\n"
"else\n"
"{\n"
"sqlval := __rdf_strsqlval (obj);\n"
"http (\'\"\', ses); http_escape (sqlval, 14, ses, 1, 1); http (\'\"\', ses);\n"
"}\n"
"}\n"
"}\n"
"if (prev_subj is not null)\n"
"http (\'] } }\', ses);\n"
"http (\' }\\n\', ses);\n"
"}\n"
"--src sparql.sql:4817\n";

static const char *proc160 = 
"#line 4961 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ATOM_XML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_ATOM_XML_TEXT (triples, 1, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:4959\n";

static const char *proc161 = 
"#line 4976 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.ODATA_EDM_TYPE (in obj any)\n"
"{\n"
"if (__tag of int = __tag (obj))\n"
"return \'Int32\';\n"
"else if (__tag of smallint  = __tag (obj))\n"
"return \'Int16\';\n"
"else if (__tag of bigint = __tag (obj))\n"
"return \'Int64\';\n"
"else if (__tag of numeric = __tag (obj))\n"
"return \'Decimal\';\n"
"else if (__tag of double precision = __tag (obj))\n"
"return \'Double\';\n"
"else if (__tag of real = __tag (obj))\n"
"return \'Double\';\n"
"else if (__tag of datetime = __tag (obj))\n"
"return \'DateTime\';\n"
"else if (__tag of date = __tag (obj))\n"
"return \'Date\';\n"
"else if (__tag of time = __tag (obj))\n"
"return \'Time\';\n"
"else if (__tag of varbinary = __tag (obj))\n"
"return \'Binary\';\n"
"return null;\n"
"}\n"
"--src sparql.sql:4974\n";

static const char *proc162 = 
"#line 5002 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ODATA_JSON (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_ODATA_JSON (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:5000\n";

static const char *proc163 = 
"#line 5017 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_ODATA_JSON (inout triples any, inout ses any)\n"
"{\n"
"declare tcount, tctr, ns_ctr integer;\n"
"declare dict, entries any;\n"
"declare subj, pred, obj any;\n"
"declare entry_dict, ns_dict, ns_arr any;\n"
"declare pred_tagname varchar;\n"
"declare p_ns_uri, p_ns_pref varchar;\n"
"\n"
"dict := dict_new ();\n"
"ns_dict := dict_new ();\n"
"ns_ctr := 0;\n"
"tcount := length (triples);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"http (\'{ \"d\" : { \\n  \"results\": [ \\n\', ses);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"entry_dict := dict_get (dict, subj);\n"
"if (entry_dict is null)\n"
"{\n"
"entry_dict := dict_new ();\n"
"dict_put (dict, subj, entry_dict);\n"
"}\n"
"dict_put (entry_dict, vector (pred, obj), 1);\n"
"}\n"
"entries := dict_list_keys (dict, 0);\n"
"tcount := length (entries);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare meta any;\n"
"declare has_meta, mcount int;\n"
"declare title, content varchar;\n"
"\n"
"has_meta := 0; title := null; content := null;\n"
"subj := entries[tctr];\n"
"entry_dict := dict_get (dict, subj);\n"
"meta := dict_list_keys (entry_dict, 1);\n"
"\n"
"if (isiri_id (subj)) subj := id_to_iri (subj);\n"
"http (\'    { \', ses);\n"
"http (sprintf (\'\"__metadata\": { \"uri\": \"%s\" }, \\n\', subj), ses);\n"
"for (declare i, l int, i := 0, l := length (meta); i < l; i := i + 1)\n"
"{\n"
"pred := meta[i][0];\n"
"obj := meta[i][1];\n"
"if (isiri_id (pred)) pred := id_to_iri (pred);\n"
"if (isiri_id (obj) or (isstring (obj) and __box_flags (obj) = 1))\n"
"{\n"
"\n"
"if (isiri_id (obj)) obj := id_to_iri (obj);\n"
"http (sprintf (\'      \"%s\": { \"__deferred\": { \"uri\": \"%s\" } }\', pred, obj), ses);\n"
"}\n"
"else\n"
"{\n"
"\n"
"declare tmp any;\n"
"http (sprintf (\'      \"%s\": \', pred), ses);\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"tmp := __rdf_strsqlval (obj);\n"
"if (__tag of varchar = __tag (tmp))\n"
"tmp := charset_recode (tmp, \'UTF-8\', \'_WIDE_\');\n"
"}\n"
"else\n"
"{\n"
"tmp := obj;\n"
"}\n"
"http (\'\"\', ses);\n"
"http_value (tmp, 0, ses);\n"
"http (\'\"\', ses);\n"
"}\n"
"if (i < l - 1)\n"
"http (\', \\n\', ses);\n"
"}\n"
"http (\'\\n     } \', ses);\n"
"if (tctr < tcount - 1)\n"
"http (\', \', ses);\n"
"}\n"
"http (sprintf (\'\\n ], \"__count\": \"%d\"\\n } }\', tcount), ses);\n"
"}\n"
"--src sparql.sql:5015\n";

static const char *proc164 = 
"#line 5102 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_ATOM_XML_TEXT (inout triples any, in print_top_level integer, inout ses any)\n"
"{\n"
"declare tcount, tctr, ns_ctr integer;\n"
"declare dict, entries any;\n"
"declare subj, pred, obj any;\n"
"declare entry_dict, ns_dict, ns_arr any;\n"
"declare pred_tagname varchar;\n"
"declare p_ns_uri, p_ns_pref, lang, range varchar;\n"
"declare pct integer;\n"
"declare twobyte integer;\n"
"\n"
"dict := dict_new ();\n"
"ns_dict := dict_new ();\n"
"ns_ctr := 0; pct := 0;\n"
"tcount := length (triples);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"if (print_top_level)\n"
"{\n"
"http (\'<?xml version=\"1.0\" encoding=\"utf-8\" ?>\\n<feed \\n\\t xmlns=\"http://www.w3.org/2005/Atom\" \\n\'||\n"
"\'\\t xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" \\n\'||\n"
"\'\\t xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" \\n\', ses);\n"
"}\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"subj := triples[tctr][0];\n"
"pred := triples[tctr][1];\n"
"obj := triples[tctr][2];\n"
"entry_dict := dict_get (dict, subj);\n"
"if (entry_dict is null)\n"
"{\n"
"entry_dict := dict_new ();\n"
"dict_put (dict, subj, entry_dict);\n"
"}\n"
"dict_put (entry_dict, vector (pred, obj), 1);\n"
"\n"
"if (isiri_id (obj) or (isstring (obj) and __box_flags (obj) = 1))\n"
"goto next;\n"
"if (isiri_id (pred)) pred := id_to_iri (pred);\n"
"\n"
"p_ns_uri := iri_split (pred, pred_tagname);\n"
"if (length (p_ns_uri) > 0 and dict_get (ns_dict, p_ns_uri) is null)\n"
"{\n"
"p_ns_pref := __xml_get_ns_prefix (p_ns_uri, 3);\n"
"if (p_ns_pref is null)\n"
"{\n"
"p_ns_pref := sprintf (\'ns%dpred\', ns_ctr);\n"
"ns_ctr := ns_ctr + 1;\n"
"}\n"
"dict_put (ns_dict, p_ns_uri, p_ns_pref);\n"
"}\n"
"next:;\n"
"}\n"
"ns_arr := dict_to_vector (ns_dict, 0);\n"
"for (declare i int, i := 0; i < length (ns_arr); i := i + 2)\n"
"{\n"
"http (sprintf (\'\\t xmlns:%s=\"%s\"\\n\', ns_arr[i+1], ns_arr[i]), ses);\n"
"}\n"
"http (\'>\\n\', ses);\n"
"if (is_http_ctx ())\n"
"{\n"
"declare q, u, h, id varchar;\n"
"declare lines any;\n"
"q := http_request_get (\'QUERY_STRING\');\n"
"if (length (q))\n"
"q := \'?\' || q;\n"
"else\n"
"q := \'\';\n"
"u := http_request_get (\'REQUEST_URI\');\n"
"h := WS.WS.PARSE_URI (http_requested_url () || q);\n"
"h [2] := u; h [4] := \'\';\n"
"id := WS.WS.VFS_URI_COMPOSE (h);\n"
"http (sprintf (\'\\t<id>%V</id>\\n\', id), ses);\n"
"lines := http_request_header ();\n"
"range := http_request_header_full (lines, \'Accept-Language\', \'en\');\n"
"}\n"
"else\n"
"{\n"
"http (\'\\t<id/>\\n\', ses);\n"
"range := \'en, */*;0.1\';\n"
"}\n"
"http (sprintf (\'\\t<updated>%s</updated>\\n\', date_iso8601 (dt_set_tz (now (), 0))), ses);\n"
"http (\'\\t<author><name /></author>\\n\', ses);\n"
"http (sprintf (\'\\t<title type=\"text\">OData Service and Descriptor Document</title>\\n\'), ses);\n"
"entries := dict_list_keys (dict, 0);\n"
"tcount := length (entries);\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare meta any;\n"
"declare has_meta int;\n"
"declare title, content varchar;\n"
"\n"
"pct := 0;\n"
"has_meta := 0; title := null; content := null;\n"
"subj := entries[tctr];\n"
"entry_dict := dict_get (dict, subj);\n"
"meta := dict_list_keys (entry_dict, 1);\n"
"http (\'\\t<entry>\\n\', ses);\n"
"if (isiri_id (subj)) subj := id_to_iri (subj);\n"
"http (sprintf (\'\\t\\t<id>%s</id>\\n\', subj), ses);\n"
"\n"
"for (declare i, l int, i := 0, l := length (meta); i < l; i := i + 1)\n"
"{\n"
"pred := meta[i][0];\n"
"obj := meta[i][1];\n"
"if (isiri_id (obj) or (isstring (obj) and __box_flags (obj) = 1))\n"
"{\n"
"if (isiri_id (obj)) obj := id_to_iri (obj);\n"
"if (isiri_id (pred)) pred := id_to_iri (pred);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"http (sprintf (\'\\t\\t<link rel=\"%s\" href=\"%s\"/>\\n\', pred, obj), ses);\n"
"}\n"
"else\n"
"{\n"
"if (title is null and\n"
"(\n"
"pred = iri_to_id (\'http://purl.org/dc/terms/title\') or\n"
"pred = iri_to_id (\'http://www.w3.org/2000/01/rdf-schema#label\'))\n"
")\n"
"{\n"
"declare rc int;\n"
"lang := \'en\';\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"twobyte := rdf_box_lang (obj);\n"
"if (twobyte <> 257)\n"
"{\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte), lang);\n"
"}\n"
"}\n"
"rc := langmatches_pct_http (lang, range);\n"
"if (pct < rc)\n"
"{\n"
"title := __rdf_strsqlval (obj);\n"
"pct := rc;\n"
"}\n"
"}\n"
"has_meta := 1;\n"
"}\n"
"}\n"
"if (title is not null)\n"
"http (sprintf (\'\\t\\t<title>%s</title>\\n\', title), ses);\n"
"http (sprintf (\'\\t\\t<updated>%s</updated>\\n\', date_iso8601 (dt_set_tz (now (), 0))), ses);\n"
"http (\'\\t\\t<author><name /></author>\\n\', ses);\n"
"if (has_meta)\n"
"http (\'\\t\\t<content type=\"application/xml\">\\n\\t\\t\\t<m:properties>\\n\', ses);\n"
"for (declare i, l int, i := 0, l := length (meta); i < l; i := i + 1)\n"
"{\n"
"pred := meta[i][0];\n"
"obj := meta[i][1];\n"
"if (isiri_id (pred)) pred := id_to_iri (pred);\n"
"if (not (isiri_id (obj) or (isstring (obj) and __box_flags (obj) = 1)))\n"
"{\n"
"\n"
"p_ns_uri := iri_split (pred, pred_tagname);\n"
"if (length (p_ns_uri) = 0)\n"
"{\n"
"http (\'<\', ses); http (pred_tagname, ses);\n"
"}\n"
"else\n"
"{\n"
"p_ns_pref := dict_get (ns_dict, p_ns_uri);\n"
"pred_tagname := p_ns_pref || \':\' || pred_tagname;\n"
"http (\'\\t\\t\\t\\t<\', ses); http (pred_tagname, ses);\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"declare tmp any;\n"
"tmp := __rdf_strsqlval (obj);\n"
"twobyte := rdf_box_lang (obj);\n"
"if (twobyte <> 257)\n"
"{\n"
"lang := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte), lang);\n"
"http (sprintf (\' xml:lang=\"%s\"\', lang), ses);\n"
"}\n"
"http (\'>\', ses);\n"
"if (__tag of varchar = __tag (tmp))\n"
"tmp := charset_recode (tmp, \'UTF-8\', \'_WIDE_\');\n"
"http_value (tmp, 0, ses);\n"
"}\n"
"else\n"
"{\n"
"declare tp varchar;\n"
"tp := ODATA_EDM_TYPE (obj);\n"
"if (tp is not null)\n"
"http (sprintf (\' m:type=\"Edm.%s\"\', tp), ses);\n"
"http (\'>\', ses);\n"
"if (__tag of varbinary = __tag (obj))\n"
"obj := encode_base64 (cast (obj as varchar));\n"
"http_value (obj, 0, ses);\n"
"}\n"
"http (\'</\', ses); http (pred_tagname, ses); http (\'>\\n\', ses);\n"
"}\n"
"}\n"
"}\n"
"if (has_meta)\n"
"http (\'\\t\\t\\t</m:properties>\\n\\t\\t</content>\\n\', ses);\n"
"http (\'\\t</entry>\\n\', ses);\n"
"}\n"
"if (print_top_level)\n"
"{\n"
"http (\'</feed>\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:5100\n";

static const char *proc165 = 
"#line 5316 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (inout _env any)\n"
"{\n"
"_env := string_output();\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"[ rdf:type rs:results ;\', _env);\n"
"}\n"
"--src sparql.sql:5314\n";

static const char *proc166 = 
"#line 5326 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (_env);\n"
"http (\'\\n  rs:result [\', _env);\n"
"col_count := length (colnames);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := colnames[col_ctr];\n"
"_val := colvalues[col_ctr];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (\'\\n      rs:binding [ rs:name \"\', _env);\n"
"http_value (colnames[col_ctr], 0, _env);\n"
"http (\'\" ; rs:value \', _env);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\'_:nodeID%d ] ;\', iri_id_num (_val)), _env);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'<bad://%d>\', iri_id_num (_val));\n"
"http (sprintf (\'<%V> ] ;\', res), _env);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.RDF_LONG_TO_TTL (_val, _env);\n"
"http (sprintf (\' ] ;\'), _env);\n"
"}\n"
"end_of_binding: ;\n"
"\n"
"}\n"
"http (\'\\n      ] ;\', _env);\n"
"}\n"
"--src sparql.sql:5324\n";

static const char *proc167 = 
"#line 5373 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT (_env);\n"
"\n"
"http (\'\\n    ] .\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:5371\n";

static const char *other16 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN\n"
"order\n";

static const char *proc168 = 
"#line 5389 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (inout _env any)\n"
"{\n"
"_env := vector (0, 0, string_output());\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"_:_ <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2005/sparql-results#results> .\\n\', _env[2]);\n"
"}\n"
"--src sparql.sql:5387\n";

static const char *proc169 = 
"#line 5399 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare col_ctr, col_count integer;\n"
"declare rowid varchar;\n"
"declare blank_ids any;\n"
"if (__tag of vector <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (_env);\n"
"if (isinteger (_env[1]))\n"
"{\n"
"declare col_buf any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (_env);\n"
"col_buf := make_array (col_count * 7, \'any\');\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"col_buf [col_ctr * 7] := colnames[col_ctr];\n"
"_env[1] := col_buf;\n"
"}\n"
"sparql_rset_nt_write_row (0, _env, colvalues);\n"
"}\n"
"--src sparql.sql:5397\n";

static const char *proc170 = 
"#line 5421 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (__tag of vector <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT (_env);\n"
"return string_output_string (_env[2]);\n"
"}\n"
"--src sparql.sql:5419\n";

static const char *other17 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN\n"
"order\n";

static const char *proc171 = 
"#line 5434 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (inout _env any)\n"
"{\n"
"_env := string_output();\n"
"http (\'<rdf:RDF\n"
"xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"xmlns:rs=\"http://www.w3.org/2005/sparql-results#\"\n"
"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" >\n"
"<rs:results rdf:nodeID=\"rset\">\', _env);\n"
"}\n"
"--src sparql.sql:5432\n";

static const char *proc172 = 
"#line 5445 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (_env);\n"
"sol_id := cast (length (_env) as varchar);\n"
"http (\'\\n  <rs:result rdf:nodeID=\"sol\' || sol_id || \'\">\', _env);\n"
"col_count := length (colnames);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := colnames[col_ctr];\n"
"_val := colvalues[col_ctr];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (\'\\n   <rs:binding rdf:nodeID=\"sol\' || sol_id || \'-\' || cast (col_ctr as varchar) || \'\" rs:name=\"\', _env);\n"
"http_value (colnames[col_ctr], 0, _env);\n"
"http (\'\"><rs:value\', _env);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\' rdf:nodeID=\"b%d\"/></rs:binding>\', iri_id_num (_val)), _env);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\' rdf:resource=\"%V\"/></rs:binding>\', res), _env);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' xml:lang=\"%V\" rdf:datatype=\"%V\">\',\n"
"cast (lang as varchar), cast (dt as varchar)), _env);\n"
"else\n"
"http (sprintf (\' xml:lang=\"%V\">\',\n"
"cast (lang as varchar)), _env);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' rdf:datatype=\"%V\">\',\n"
"cast (dt as varchar)), _env);\n"
"else\n"
"http (sprintf (\'>\'), _env);\n"
"}\n"
"http_value (__rdf_strsqlval (_val), 0, _env);\n"
"http (\'</rs:value></rs:binding>\', _env);\n"
"}\n"
"end_of_binding: ;\n"
"\n"
"}\n"
"http (\'\\n  </rs:result>\', _env);\n"
"}\n"
"--src sparql.sql:5443\n";

static const char *proc173 = 
"#line 5514 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT (_env);\n"
"\n"
"http (\'\\n </rs:results>\\n</rdf:RDF>\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:5512\n";

static const char *other18 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN\n"
"order\n";

static const char *proc174 = 
"#line 5529 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:5527\n";

static const char *proc175 = 
"#line 5535 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count, need_comma integer;\n"
"declare blank_ids any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [\', _env);\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"if (col_ctr > 0)\n"
"http(\', \"\', _env);\n"
"else\n"
"http(\'\"\', _env);\n"
"http_escape (colnames[col_ctr], 11, _env, 0, 1);\n"
"http(\'\"\', _env);\n"
"}\n"
"http (\'] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\\n    {\', _env);\n"
"}\n"
"else\n"
"http(\',\\n    {\', _env);\n"
"need_comma := 0;\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare val any;\n"
"val := colvalues[col_ctr];\n"
"if (val is null)\n"
"goto end_of_val_print;\n"
"if (need_comma)\n"
"http(\'\\t,\', _env);\n"
"else\n"
"need_comma := 1;\n"
"DB.DBA.SPARQL_RESULTS_JSON_WRITE_BINDING (_env, colnames[col_ctr], val);\n"
"end_of_val_print: ;\n"
"}\n"
"http(\'}\', _env);\n"
"}\n"
"--src sparql.sql:5533\n";

static const char *proc176 = 
"#line 5576 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', _env);\n"
"}\n"
"http (\' ] } }\', _env);\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:5574\n";

static const char *other19 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN\n"
"order\n";

static const char *proc177 = 
"#line 5595 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:5593\n";

static const char *proc178 = 
"#line 5601 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (inout _env any, in val any)\n"
"{\n"
"declare t integer;\n"
"t := __tag (val);\n"
"if (t = __tag of rdf_box)\n"
"{\n"
"val := rdf_box_data (val);\n"
"t := __tag (val);\n"
"}\n"
"if (t in (__tag of integer, __tag of numeric, __tag of double precision, __tag of float, __tag of date, __tag of time, __tag of datetime))\n"
"{\n"
"http_value (val, 0, _env);\n"
"return;\n"
"}\n"
"if (t = __tag of IRI_ID)\n"
"val := id_to_iri (val);\n"
"http (\'\"\', _env);\n"
"http (replace (cast (val as varchar), \'\"\', \'\"\"\'), _env);\n"
"http (\'\"\', _env);\n"
"}\n"
"--src sparql.sql:5599\n";

static const char *proc179 = 
"#line 5623 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"if (col_ctr > 0)\n"
"http(\',\', _env);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (_env, colnames[col_ctr]);\n"
"}\n"
"http (\'\\n\', _env);\n"
"}\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare val any;\n"
"val := colvalues[col_ctr];\n"
"if (col_ctr > 0)\n"
"http(\',\', _env);\n"
"if (val is not null)\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (_env, val);\n"
"}\n"
"http(\'\\n\', _env);\n"
"}\n"
"--src sparql.sql:5621\n";

static const char *proc180 = 
"#line 5653 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_FIN (inout _env any) returns long varchar\n"
"{\n"
"if (185 <> __tag(_env))\n"
"return \'\';\n"
"return string_output_string (_env);\n"
"}\n"
"--src sparql.sql:5651\n";

static const char *other20 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_FIN\n"
"order\n";

static const char *proc181 = 
"#line 5666 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_TSV_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare sol_id varchar;\n"
"declare col_ctr, col_count integer;\n"
"declare blank_ids any;\n"
"col_count := length (colnames);\n"
"if (185 <> __tag(_env))\n"
"{\n"
"_env := string_output ();\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"if (col_ctr > 0)\n"
"http(\'\\t\', _env);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (_env, colnames[col_ctr]);\n"
"}\n"
"http (\'\\n\', _env);\n"
"}\n"
"for (col_ctr := 0; col_ctr < col_count; col_ctr := col_ctr + 1)\n"
"{\n"
"declare val any;\n"
"val := colvalues[col_ctr];\n"
"if (col_ctr > 0)\n"
"http(\'\\t\', _env);\n"
"if (val is not null)\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (_env, val);\n"
"}\n"
"http(\'\\n\', _env);\n"
"}\n"
"--src sparql.sql:5664\n";

static const char *other21 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_TSV (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_TSV_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_FIN\n"
"order\n";

static const char *proc182 = 
"#line 5701 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:5699\n";

static const char *proc183 = 
"#line 5707 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare agg, colvalues_copy any;\n"
"colvalues_copy := colvalues;\n"
"if (isinteger (_env))\n"
"{\n"
"vectorbld_init (agg);\n"
"_env := vector (0, colnames);\n"
"}\n"
"else\n"
"{\n"
"agg := aref_set_0 (_env, 0);\n"
"}\n"
"vectorbld_acc (agg, colvalues_copy);\n"
"aset_zap_arg (_env, 0, agg);\n"
"}\n"
"--src sparql.sql:5705\n";

static const char *proc184 = 
"#line 5725 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses, metas, rset any;\n"
"declare accept varchar;\n"
"declare add_http_headers integer;\n"
"ses := string_output ();\n"
"if (isinteger (_env))\n"
"{\n"
"metas := vector (vector (vector (\'s\')), 1);\n"
"rset := vector ();\n"
"DB.DBA.SPARQL_RESULTS_CXML_WRITE (ses, metas, rset, accept, add_http_headers);\n"
"}\n"
"else\n"
"{\n"
"declare cols any;\n"
"declare colctr, colcount integer;\n"
"rset := aref_set_0 (_env, 0);\n"
"vectorbld_final (rset);\n"
"cols := aref_set_0 (_env, 1);\n"
"colcount := length (cols);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1) cols[colctr] := vector (cols[colctr]);\n"
"metas := vector (cols, vector ());\n"
"DB.DBA.SPARQL_RESULTS_CXML_WRITE (ses, metas, rset, accept, add_http_headers);\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src sparql.sql:5723\n";

static const char *other22 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_FIN\n"
"order\n";

static const char *proc185 = 
"#line 5758 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT (inout _env any)\n"
"{\n"
"_env := vector (0, 0, string_output());\n"
"}\n"
"--src sparql.sql:5756\n";

static const char *proc186 = 
"#line 5764 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_ACC (inout _env any, inout colvalues any, inout colnames any)\n"
"{\n"
"declare col_ctr, col_count integer;\n"
"declare ses any;\n"
"declare rowid varchar;\n"
"declare blank_ids any;\n"
"if (__tag of vector <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT (_env);\n"
"if (isinteger (_env[1]))\n"
"{\n"
"if (185 <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT (_env);\n"
"_env[1] := colnames;\n"
"ses := aref_set_0 (_env, 2);\n"
"http (\'BINDINGS\', ses);\n"
"foreach (varchar colname in colnames) do { http (\' ?\' || colname, ses); }\n"
"http (\' {\', ses);\n"
"}\n"
"else\n"
"ses := aref_set_0 (_env, 2);\n"
"http (\'\\n  (\', ses);\n"
"foreach (any val in colvalues) do\n"
"{\n"
"if (val is null)\n"
"http (\'\\tUNDEF\', ses);\n"
"else\n"
"{\n"
"http (\'\\t\', ses);\n"
"http_nt_object (val, ses);\n"
"}\n"
"}\n"
"http (\'\\t)\', ses);\n"
"aset_zap_arg (_env, 2, ses);\n"
"}\n"
"--src sparql.sql:5762\n";

static const char *proc187 = 
"#line 5800 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"if (__tag of vector <> __tag(_env))\n"
"DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT (_env);\n"
"if (isinteger (_env[1]))\n"
"return \'BINDINGS ?EmptyResultSetStub { }\';\n"
"ses := aref_set_0 (_env, 2);\n"
"if (not isinteger (_env[1]))\n"
"http (\'\\n}\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"--src sparql.sql:5798\n";

static const char *other23 = 
"create aggregate DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS (in colvalues any, in colnames any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT, DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_ACC, DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_FIN\n"
"order\n";

static const char *proc188 = 
"#line 5819 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:5817\n";

static const char *proc189 = 
"#line 5834 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NICE_TTL (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"if (2500 <= dict_size (triples_dict))\n"
"return DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL (triples_dict);\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"triples := vector ();\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_NICE_TTL (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:5832\n";

static const char *proc190 = 
"#line 5849 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLES_TO_NICE_TTL (inout triples any, inout ses any)\n"
"{\n"
"declare env, printed_triples_mask any;\n"
"declare rdf_first_iid, rdf_rest_iid, rdf_nil_iid IRI_ID;\n"
"declare bnode_usage_dict any;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare tail_to_head_dict any;\n"
"\n"
"declare all_bnodes any;\n"
"declare tcount, tctr, bnode_ctr integer;\n"
"declare tail_bnode, head_bnode IRI_ID;\n"
"declare prefixes_are_printed integer;\n"
"declare prev_s, prev_p varchar;\n"
"tcount := length (triples);\n"
"if (0 = tcount)\n"
"{\n"
"http (\'# Empty Turtle\\n\', ses);\n"
"return;\n"
"}\n"
"if (2500 <= tcount)\n"
"{\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"return;\n"
"}\n"
"rowvector_obj_sort (triples, 2, 1);\n"
"rowvector_subj_sort (triples, 1, 1);\n"
"rowvector_subj_sort (triples, 0, 1);\n"
"env := DB.DBA.RDF_TRIPLES_TO_TTL_ENV (tcount);\n"
"rdf_first_iid	:= iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#first\');\n"
"rdf_rest_iid	:= iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest\');\n"
"rdf_nil_iid	:= iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil\');\n"
"printed_triples_mask := space (tcount);\n"
"\n"
"bnode_usage_dict := dict_new (13 + (tcount / 100));\n"
"tail_to_head_dict := dict_new (13 + (tcount / 1000));\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare s_iid, o_iid IRI_ID;\n"
"\n"
"if (triples[tctr][0] is null or triples[tctr][1] is null or triples[tctr][2] is null)\n"
"{\n"
"printed_triples_mask[tctr] := ascii (\'N\');\n"
"goto triple_skipped;\n"
"}\n"
"s_iid := iri_to_id_nosignal (triples[tctr][0]);\n"
"o_iid := iri_to_id_nosignal (triples[tctr][2]);\n"
"if (is_bnode_iri_id (s_iid))\n"
"{\n"
"declare p_iid IRI_ID;\n"
"declare u any;\n"
"p_iid := iri_to_id_nosignal (triples[tctr][1]);\n"
"u := dict_get (bnode_usage_dict, s_iid, null);\n"
"if (u is null)\n"
"u := vector (null, null, null, null, tctr);\n"
"else if (u[4] is null)\n"
"u[4] := tctr;\n"
"if (rdf_first_iid = p_iid)\n"
"{\n"
"if (u[1] is null)\n"
"{\n"
"u[1] := tctr;\n"
"goto s_iid_done;\n"
"}\n"
"else\n"
"goto bad_for_list;\n"
"}\n"
"else if (rdf_rest_iid = p_iid)\n"
"{\n"
"if (u[2] is not null)\n"
"goto bad_for_list;\n"
"else if (rdf_nil_iid = o_iid)\n"
"{\n"
"dict_put (tail_to_head_dict, s_iid, s_iid);\n"
"u[2] := tctr;\n"
"goto s_iid_done;\n"
"}\n"
"else if (is_bnode_iri_id (o_iid))\n"
"{\n"
"u[2] := tctr;\n"
"goto s_iid_done;\n"
"}\n"
"else\n"
"goto bad_for_list;\n"
"}\n"
"bad_for_list:\n"
"u[1] := UNAME\'\';\n"
"u[2] := UNAME\'\';\n"
"if (dict_get (tail_to_head_dict, s_iid, null) is not null)\n"
"dict_put (tail_to_head_dict, s_iid, UNAME\'\');\n"
"s_iid_done:\n"
"dict_put (bnode_usage_dict, s_iid, u);\n"
"}\n"
"if (is_bnode_iri_id (o_iid))\n"
"{\n"
"declare u any;\n"
"u := dict_get (bnode_usage_dict, o_iid, null);\n"
"if (u is null)\n"
"dict_put (bnode_usage_dict, o_iid, vector (s_iid, null, null, null, null));\n"
"else\n"
"{\n"
"if (u[0] is null)\n"
"u[0] := s_iid;\n"
"else\n"
"u[0] := UNAME\'\';\n"
"dict_put (bnode_usage_dict, o_iid, u);\n"
"}\n"
"}\n"
"triple_skipped: ;\n"
"}\n"
"\n"
"all_bnodes := dict_list_keys (bnode_usage_dict, 0);\n"
"gvector_sort (all_bnodes, 1, 0, 1);\n"
"foreach (IRI_ID bn_iid in all_bnodes) do\n"
"{\n"
"declare top_bn_iid IRI_ID;\n"
"top_bn_iid := bn_iid;\n"
"while (is_bnode_iri_id (top_bn_iid))\n"
"{\n"
"declare u any;\n"
"u := dict_get (bnode_usage_dict, top_bn_iid, null);\n"
"if (u[0] = bn_iid)\n"
"{\n"
"u := dict_get (bnode_usage_dict, bn_iid, null);\n"
"u[0] := UNAME\'\';\n"
"dict_put (bnode_usage_dict, bn_iid, u);\n"
"goto bn_iid_done;\n"
"}\n"
"top_bn_iid := u[0];\n"
"}\n"
"bn_iid_done: ;\n"
"}\n"
"\n"
"dict_iter_rewind (tail_to_head_dict);\n"
"while (dict_iter_next (tail_to_head_dict, tail_bnode, head_bnode))\n"
"{\n"
"declare last_good_head_bnode IRI_ID;\n"
"declare len_ctr integer;\n"
"len_ctr := 0;\n"
"last_good_head_bnode := head_bnode;\n"
"\n"
"while (is_bnode_iri_id (head_bnode))\n"
"{\n"
"declare u any;\n"
"u := dict_get (bnode_usage_dict, head_bnode, null);\n"
"\n"
"if (isinteger (u[1]) and isinteger (u[2]) and u[3] is null and (u[0] is null or isiri_id (u[0])))\n"
"{\n"
"\n"
"last_good_head_bnode := head_bnode;\n"
"u[3] := len_ctr;\n"
"len_ctr := len_ctr + 1;\n"
"dict_put (bnode_usage_dict, head_bnode, u);\n"
"head_bnode := u[0];\n"
"}\n"
"else\n"
"{\n"
"u[3] := UNAME\'\';\n"
"dict_put (bnode_usage_dict, head_bnode, u);\n"
"head_bnode := null;\n"
"}\n"
"}\n"
"}\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"\n"
"prefixes_are_printed := 0;\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"prefixes_are_printed := prefixes_are_printed + http_ttl_prefixes (env, triples[tctr][0], triples[tctr][1], triples[tctr][2], ses);\n"
"if (prefixes_are_printed)\n"
"http (\'\\n\', ses);\n"
"prev_s := \'\';\n"
"prev_p := \'\';\n"
"\n"
"for (tctr := 0; tctr < tcount; tctr := tctr + 1)\n"
"{\n"
"declare s_iid, o_iid IRI_ID;\n"
"declare s, p, o any;\n"
"if (ascii (\' \') <> printed_triples_mask[tctr])\n"
"goto done_triple;\n"
"\n"
"s := triples[tctr][0];\n"
"p := triples[tctr][1];\n"
"o := triples[tctr][2];\n"
"s_iid := iri_to_id_nosignal (s);\n"
"o_iid := iri_to_id_nosignal (o);\n"
"if (is_bnode_iri_id (s_iid))\n"
"{\n"
"declare u any;\n"
"u := dict_get (bnode_usage_dict, s_iid, null);\n"
"if (isiri_id (u[0]))\n"
"goto done_triple;\n"
"}\n"
"if (s <> prev_s)\n"
"{\n"
"if (prev_s <> \'\')\n"
"http (\' .\\n\', ses);\n"
"http_ttl_value (env, s, 0, ses);\n"
"http (\'\\n\\t\', ses);\n"
"prev_s := s;\n"
"prev_p := \'\';\n"
"}\n"
"if (p <> prev_p)\n"
"{\n"
"if (prev_p <> \'\')\n"
"http (\' ;\\n\\t\', ses);\n"
"http_ttl_value (env, p, 1, ses);\n"
"http (\'\\t\', ses);\n"
"prev_p := p;\n"
"}\n"
"else\n"
"http (\' , \', ses);\n"
"printed_triples_mask[tctr] := ascii (\'p\');\n"
"if (is_bnode_iri_id (o_iid))\n"
"DB.DBA.RDF_TRIPLE_OBJ_BNODE_TO_NICE_TTL (triples, printed_triples_mask, o_iid, env, bnode_usage_dict, 2, ses);\n"
"else\n"
"http_ttl_value (env, o, 2, ses);\n"
"\n"
"done_triple: ;\n"
"}\n"
"done_data:\n"
"if (prev_s is not null)\n"
"http (\' .\\n\', ses);\n"
"else\n"
"http (\'# Empty Turtle (no valid data to print)\\n\', ses);\n"
"}\n"
"--src sparql.sql:5847\n";

static const char *proc191 = 
"#line 6081 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_TRIPLE_OBJ_BNODE_TO_NICE_TTL (inout triples any, inout printed_triples_mask any, in s_bnode_iid IRI_ID, inout env any, inout bnode_usage_dict any, in depth integer, inout ses any)\n"
"{\n"
"declare u, subj, prev_p any;\n"
"declare tctr, tcount integer;\n"
"u := dict_get (bnode_usage_dict, s_bnode_iid, null);\n"
"if (u[0] is not null and not isiri_id (u[0]))\n"
"{\n"
"\n"
"http_ttl_value (env, s_bnode_iid, 2, ses);\n"
"return;\n"
"}\n"
"if (isinteger (u[3]))\n"
"{\n"
"\n"
"http (\'(\', ses);\n"
"while (is_bnode_iri_id (s_bnode_iid))\n"
"{\n"
"declare itm any;\n"
"declare itm_iid IRI_ID;\n"
"itm := triples[u[1]][2];\n"
"itm_iid := iri_to_id_nosignal (itm);\n"
"if (ascii (\' \') <> printed_triples_mask[u[1]]) signal (\'OBLOM\', \'Corrupted CAR in list\');\n"
"if (ascii (\' \') <> printed_triples_mask[u[2]]) signal (\'OBLOM\', \'Corrupted CDR in list\');\n"
"printed_triples_mask[u[1]] := ascii (\'A\');\n"
"http (\' \', ses);\n"
"if (is_bnode_iri_id (itm_iid))\n"
"DB.DBA.RDF_TRIPLE_OBJ_BNODE_TO_NICE_TTL (triples, printed_triples_mask, itm_iid, env, bnode_usage_dict, depth + 1, ses);\n"
"else\n"
"http_ttl_value (env, itm, 2, ses);\n"
"printed_triples_mask[u[2]] := ascii (\'D\');\n"
"s_bnode_iid := iri_to_id_nosignal (triples[u[2]][2]);\n"
"u := dict_get (bnode_usage_dict, s_bnode_iid, null);\n"
"\n"
"}\n"
"http (\' )\', ses);\n"
"return;\n"
"}\n"
"tctr := u[4];\n"
"if (tctr is null)\n"
"{\n"
"\n"
"http (\'[ ]\', ses);\n"
"return;\n"
"}\n"
"tcount := length (triples);\n"
"subj := triples[tctr][0];\n"
"prev_p := \'\';\n"
"http (\'[\\t\', ses);\n"
"\n"
"while (1=1)\n"
"{\n"
"declare o_iid IRI_ID;\n"
"declare p, o any;\n"
"if (ascii (\' \') <> printed_triples_mask[tctr])\n"
"goto done_triple;\n"
"p := triples[tctr][1];\n"
"o := triples[tctr][2];\n"
"o_iid := iri_to_id_nosignal (o);\n"
"if (p <> prev_p)\n"
"{\n"
"if (prev_p <> \'\')\n"
"http (\' ;\\n\' || repeat (\'\\t\', depth+2), ses);\n"
"http_ttl_value (env, p, 2, ses);\n"
"http (\'\\t\', ses);\n"
"prev_p := p;\n"
"}\n"
"else\n"
"http (\' , \', ses);\n"
"printed_triples_mask[tctr] := ascii (\'[\');\n"
"if (is_bnode_iri_id (o_iid))\n"
"DB.DBA.RDF_TRIPLE_OBJ_BNODE_TO_NICE_TTL (triples, printed_triples_mask, o_iid, env, bnode_usage_dict, depth + 2, ses);\n"
"else\n"
"http_ttl_value (env, o, 2, ses);\n"
"done_triple:\n"
"tctr := tctr + 1;\n"
"if (not ((tctr < tcount) and (triples[tctr][0] = subj)))\n"
"{\n"
"http (\' ]\', ses);\n"
"return;\n"
"}\n"
"}\n"
"}\n"
"--src sparql.sql:6079\n";

static const char *proc192 = 
"#line 6167 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TRIG (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TRIG (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6165\n";

static const char *proc193 = 
"#line 6182 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6180\n";

static const char *proc194 = 
"#line 6197 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6195\n";

static const char *proc195 = 
"#line 6212 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TALIS_JSON (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6210\n";

static const char *proc196 = 
"#line 6227 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_LD (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_LD (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6225\n";

static const char *proc197 = 
"#line 6242 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_UL (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_UL (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6240\n";

static const char *proc198 = 
"#line 6257 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_TR (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_TR (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6255\n";

static const char *proc199 = 
"#line 6272 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_MICRODATA (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6270\n";

static const char *proc200 = 
"#line 6287 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_MICRODATA (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6285\n";

static const char *proc201 = 
"#line 6302 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CSV (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_CSV (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6300\n";

static const char *proc202 = 
"#line 6317 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TSV (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_TSV (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6315\n";

static const char *proc203 = 
"#line 6332 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDFA_XHTML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6330\n";

static const char *proc204 = 
"#line 6347 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"declare accept varchar;\n"
"declare add_http_headers integer;\n"
"add_http_headers := 0;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_CXML (triples, ses, accept, add_http_headers, 0);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6345\n";

static const char *proc205 = 
"#line 6365 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML_QRCODE (inout triples_dict any) returns long varchar\n"
"{\n"
"declare triples, ses any;\n"
"declare accept varchar;\n"
"declare add_http_headers integer;\n"
"add_http_headers := 0;\n"
"ses := string_output ();\n"
"if (214 <> __tag (triples_dict))\n"
"{\n"
"triples := vector ();\n"
"}\n"
"else\n"
"triples := dict_list_keys (triples_dict, 1);\n"
"DB.DBA.RDF_TRIPLES_TO_CXML (triples, ses, accept, add_http_headers, 1);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6363\n";

static const char *proc206 = 
"#line 6384 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:6382\n";

static const char *proc207 = 
"#line 6391 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:6389\n";

static const char *proc208 = 
"#line 6398 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'true\';\n"
"else\n"
"ans := \'false\';\n"
"http (\'<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd\">\n"
"<head></head>\n"
"<boolean>\' || ans || \'</boolean>\n"
"</sparql>\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6396\n";

static const char *other24 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN\n";

static const char *proc209 = 
"#line 6420 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:6418\n";

static const char *proc210 = 
"#line 6427 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:6425\n";

static const char *proc211 = 
"#line 6434 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'1\';\n"
"else\n"
"ans := \'0\';\n"
"http (\'<rdf:RDF\n"
"xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
"xmlns:rs=\"http://www.w3.org/2005/sparql-results#\"\n"
"xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\" >\n"
"<rs:results rdf:nodeID=\"rset\">\n"
"<rs:boolean rdf:datatype=\"http://www.w3.org/2001/XMLSchema#boolean\">\' || ans || \'</rs:boolean></rs:results></rdf:RDF>\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6432\n";

static const char *other25 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN\n";

static const char *proc212 = 
"#line 6458 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:6456\n";

static const char *proc213 = 
"#line 6465 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC (inout _env any, inout one any)\n"
"{\n"
"_env := 1;\n"
"}\n"
"--src sparql.sql:6463\n";

static const char *proc214 = 
"#line 6472 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'TRUE\';\n"
"else\n"
"ans := \'FALSE\';\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix rs: <http://www.w3.org/2005/sparql-results#> .\\n\', ses);\n"
"http (sprintf (\'[] rdf:type rs:results ; rs:boolean %s .\', ans), ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6470\n";

static const char *other26 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN\n";

static const char *proc215 = 
"#line 6493 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ses any;\n"
"declare ans varchar;\n"
"ses := string_output ();\n"
"if (isinteger (_env) and _env)\n"
"ans := \'true\';\n"
"else\n"
"ans := \'false\';\n"
"http (sprintf (\'_:_ <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/2005/sparql-results#results> .\\n_:_ <http://www.w3.org/2005/sparql-results#boolean> \"%s\"^^<http://www.w3.org/2001/XMLSchema#boolean> .\\n\', ans), ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:6491\n";

static const char *other27 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT,\n"
"DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC,\n"
"DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN\n";

static const char *other28 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC, DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN\n";

static const char *proc216 = 
"#line 6519 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_CSV_FIN (inout _env any) returns long varchar\n"
"{\n"
"declare ans varchar;\n"
"if (isinteger (_env) and _env)\n"
"return \'\"bool\"\\n1\\n\';\n"
"else\n"
"return \'\"bool\"\\n0\\n\';\n"
"}\n"
"--src sparql.sql:6517\n";

static const char *other29 = 
"create aggregate DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_CSV (inout one any) returns long varchar\n"
"from DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT,\n"
"DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC,\n"
"DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_CSV_FIN\n";

static const char *proc217 = 
"#line 6550 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_INSERT_TRIPLES_CL (inout graph_iri any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare is_text, ctr, old_log_enable, l integer;\n"
"declare ro_id_dict, dp any;\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"if (__rdf_obj_ft_rule_count_in_graph (graph_iri))\n"
"is_text := 1;\n"
"if (__rdf_graph_is_in_enabled_repl (graph_iri))\n"
"DB.DBA.RDF_REPL_INSERT_TRIPLES (id_to_iri (graph_iri), triples);\n"
"if (is_text)\n"
"ro_id_dict := dict_new (length (triples));\n"
"else\n"
"ro_id_dict := null;\n"
"connection_set (\'g_dict\', ro_id_dict);\n"
"connection_set (\'g_iid\', graph_iri);\n"
"dp := dpipe (0, \'IRI_TO_ID_1\', \'IRI_TO_ID_1\', \'IRI_TO_ID_1\', \'MAKE_RO_1\');\n"
"dpipe_set_rdf_load (dp);\n"
"l := length (triples);\n"
"for (ctr := 0; ctr < l; ctr := ctr + 1)\n"
"{\n"
"declare r, o_val any;\n"
"r := triples[ctr];\n"
"o_val := r[2];\n"
"if (__tag (o_val) in (__tag of varchar, __tag of XML))\n"
"{\n"
"if (is_text)\n"
"{\n"
"\n"
"declare o_val_2 any;\n"
"o_val_2 := rdf_box (o_val, 300, 257, 0, 1);\n"
"rdf_box_set_is_text (o_val_2, 1);\n"
"rdf_box_set_type (o_val_2, 257);\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val_2);\n"
"}\n"
"else\n"
"{\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val);\n"
"}\n"
"}\n"
"else if ((__tag (o_val) = __tag of rdf_box) and is_text and rdf_box_data_tag(o_val) in (__tag of varchar, __tag of XML))\n"
"{\n"
"rdf_box_set_is_text (o_val, 1);\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val);\n"
"}\n"
"else\n"
"{\n"
"\n"
"dpipe_input (dp, r[0], r[1], null, o_val);\n"
"}\n"
"if (mod (ctr + 1, 40000) = 0 and l > 60000)\n"
"{\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"dpipe_reuse (dp);\n"
"}\n"
"}\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"dpipe_reuse (dp);\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (graph_iri, ro_id_dict);\n"
"}\n"
"--src sparql.sql:6548\n";

static const char *proc218 = 
"#line 6618 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_INSERT_TRIPLES (in graph_iri any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable integer;\n"
"declare ro_id_dict any;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"return RDF_INSERT_TRIPLES_CL (graph_iri, triples, log_mode);\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"if (__rdf_graph_is_in_enabled_repl (graph_iri))\n"
"DB.DBA.RDF_REPL_INSERT_TRIPLES (id_to_iri (graph_iri), triples);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"ro_id_dict := null;\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare p_iid, o_orig, o_final any;\n"
"declare need_digest integer;\n"
"p_iid := triples[ctr][1];\n"
"o_final := o_orig := triples[ctr][2];\n"
"if (isiri_id (o_final))\n"
"goto do_insert;\n"
"if (ro_id_dict is null and __rdf_obj_ft_rule_check (graph_iri, p_iid))\n"
"ro_id_dict := dict_new ();\n"
"\n"
"need_digest := rdf_box_needs_digest (o_final, ro_id_dict);\n"
"if (1 < need_digest)\n"
"{\n"
"o_final := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_final, graph_iri, p_iid, ro_id_dict);\n"
"if (not rdf_box_is_storeable (o_final))\n"
"{\n"
"\n"
"signal (\'OBLOM\', \'Bad O after MAKE_OBJ_OF_SQLVAL_FT\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"o_final := DB.DBA.RDF_OBJ_ADD (257, o_final, 257);\n"
"if (not rdf_box_is_storeable (o_final))\n"
"{\n"
"\n"
"signal (\'OBLOM\', \'Bad O after DB.DBA.RDF_OBJ_ADD\');\n"
"}\n"
"}\n"
"do_insert:\n"
"\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (graph_iri, triples[ctr][0], p_iid, o_final);\n"
"}\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (graph_iri, ro_id_dict);\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:6616\n";

static const char *proc219 = 
"#line 6672 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_DELETE_TRIPLES (in graph_iri any, in triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable integer;\n"
"if (not isiri_id (graph_iri))\n"
"graph_iri := iri_to_id (graph_iri);\n"
"if (__rdf_graph_is_in_enabled_repl (graph_iri))\n"
"DB.DBA.RDF_REPL_DELETE_TRIPLES (id_to_iri (graph_iri), triples);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare o_short any;\n"
"o_short := DB.DBA.RDF_OBJ_OF_LONG (triples[ctr][2]);\n"
"\n"
"\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = graph_iri and S = triples[ctr][0] and P = triples[ctr][1] and O = o_short;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:6670\n";

static const char *proc220 = 
"#line 6704 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_DELETE_TRIPLES_AGG (in graph_iid any, inout triples any, in log_mode integer := null)\n"
"{\n"
"declare ctr, old_log_enable, l integer;\n"
"if (not isiri_id (graph_iid))\n"
"graph_iid := iri_to_id (graph_iid);\n"
"if (__rdf_graph_is_in_enabled_repl (graph_iid))\n"
"DB.DBA.RDF_REPL_DELETE_TRIPLES (id_to_iri (graph_iid), triples);\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare dp any;\n"
"log_enable (bit_and (coalesce (log_mode, old_log_enable), 1), 1);\n"
"dp := dpipe (0, \'__I2IDN\', \'__I2IDN\', \'O_LOOKN\');\n"
"dpipe_set_rdf_load (dp, 3);\n"
"connection_set (\'g_iid\', graph_iid);\n"
"l := length (triples);\n"
"for (ctr := 0; ctr < l; ctr := ctr + 1)\n"
"{\n"
"declare r any;\n"
"r := triples[ctr];\n"
"dpipe_input (dp, r[0], r[1], r[2]);\n"
"if (mod (ctr + 1, 40000) = 0 and l > 60000)\n"
"{\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"dpipe_reuse (dp);\n"
"if (bit_and (coalesce (log_mode, old_log_enable), 2))\n"
"commit work;\n"
"}\n"
"}\n"
"dpipe_next (dp, 0);\n"
"dpipe_next (dp, 1);\n"
"if (bit_and (coalesce (log_mode, old_log_enable), 2))\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"for (ctr := length (triples) - 1; ctr >= 0; ctr := ctr - 1)\n"
"{\n"
"declare o_short any;\n"
"o_short := DB.DBA.RDF_OBJ_OF_LONG (triples[ctr][2]);\n"
"\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = graph_iid and S = triples[ctr][0] and P = triples[ctr][1] and O = o_short;\n"
"}\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"}\n"
"--src sparql.sql:6702\n";

static const char *proc221 = 
"#line 6768 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_MODIFY_TRIPLES (in graph_iri any, in del_triples any, in ins_triples any, in log_mode integer := null)\n"
"{\n"
"DB.DBA.RDF_DELETE_TRIPLES (graph_iri, del_triples, log_mode);\n"
"DB.DBA.RDF_INSERT_TRIPLES (graph_iri, ins_triples, log_mode);\n"
"}\n"
"--src sparql.sql:6766\n";

static const char *proc222 = 
"#line 6776 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:6774\n";

static const char *proc223 = 
"#line 6783 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (inout _env any, in graph_iri any, in opcodes any, in vars any, in log_mode integer, in ctor_op integer)\n"
"{\n"
"declare triple_ctr, quads_found integer;\n"
"declare blank_ids any;\n"
"declare dict any;\n"
"declare action_ctr integer;\n"
"declare old_log_enable integer;\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"blank_ids := 0;\n"
"action_ctr := 0;\n"
"quads_found := _env[5 + ctor_op];\n"
"for (triple_ctr := length (opcodes) - 1; triple_ctr >= 0; triple_ctr := triple_ctr-1)\n"
"{\n"
"declare fld_ctr, fld_count integer;\n"
"declare triple_vec any;\n"
"declare g_opcode integer;\n"
"g_opcode := aref_or_default (opcodes, triple_ctr, 6, null);\n"
"if (g_opcode is null)\n"
"{\n"
"fld_count := 3;\n"
"triple_vec := vector (0,0,0);\n"
"}\n"
"else\n"
"{\n"
"fld_count := 4;\n"
"triple_vec := vector (0,0,0,0);\n"
"}\n"
"for (fld_ctr := fld_count - 1; fld_ctr >= 0; fld_ctr := fld_ctr - 1)\n"
"{\n"
"declare op integer;\n"
"declare arg any;\n"
"op := opcodes[triple_ctr][fld_ctr * 2];\n"
"arg := opcodes[triple_ctr][fld_ctr * 2 + 1];\n"
"if (1 = op)\n"
"{\n"
"declare i any;\n"
"i := vars[arg];\n"
"if (i is null)\n"
"goto end_of_adding_triple;\n"
"if (isiri_id (i))\n"
"{\n"
"if (fld_ctr in (1,3) and is_bnode_iri_id (i))\n"
"signal (\'RDF01\', \'Bad variable value in INSERT: blank node can not be used as predicate or graph\');\n"
"}\n"
"else if ((isstring (i) and (1 = __box_flags (i))) or (217 = __tag(i)))\n"
"{\n"
"if (fld_ctr in (1,3) and (i like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad variable value in INSERT: blank node can not be used as predicate or graph\');\n"
"i := iri_to_id (i);\n"
"}\n"
"else if (2 <> fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad variable value in INSERT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (i), __tag (i), __box_flags (i),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"triple_vec[fld_ctr] := i;\n"
"}\n"
"else if (2 = op)\n"
"{\n"
"if (isinteger (blank_ids))\n"
"blank_ids := vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\')));\n"
"while (arg >= length (blank_ids))\n"
"blank_ids := vector_concat (blank_ids, vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'))));\n"
"if (fld_ctr in (1,3))\n"
"signal (\'RDF01\', \'Bad triple for INSERT: blank node can not be used as predicate\');\n"
"triple_vec[fld_ctr] := blank_ids[arg];\n"
"}\n"
"else if (3 = op)\n"
"{\n"
"if (arg is null)\n"
"goto end_of_adding_triple;\n"
"if (isiri_id (arg))\n"
"{\n"
"if (fld_ctr in (1,3) and is_bnode_iri_id (arg))\n"
"signal (\'RDF01\', \'Bad const value in INSERT: blank node can not be used as predicate or graph\');\n"
"}\n"
"else if ((isstring (arg) and (1 = __box_flags (arg))) or (217 = __tag(arg)))\n"
"{\n"
"if (fld_ctr in (1,3) and (arg like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad const value in INSERT: blank node can not be used as predicate or graph\');\n"
"arg := iri_to_id (arg);\n"
"}\n"
"else if (2 <> fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad const value in INSERT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (arg), __tag (arg), __box_flags (arg),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"else if (__tag of vector = __tag (arg))\n"
"arg := DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (arg[0], arg[1], arg[2]);\n"
"triple_vec[fld_ctr] := arg;\n"
"}\n"
"else signal (\'RDFXX\', \'Bad opcode in DB.DBA.SPARQL_INSERT_CTOR()\');\n"
"}\n"
"\n"
"if (4 = fld_count)\n"
"quads_found := 1;\n"
"dict := _env [2 + ctor_op];\n"
"dict_put (dict, triple_vec, 1);\n"
"if (1 = ctor_op)\n"
"{\n"
"\n"
"\n"
"if (80000 <= dict_size (dict))\n"
"{\n"
"if (quads_found)\n"
"{\n"
"DB.DBA.RDF_DELETE_QUADS (_env[0], dict_list_keys (dict, 2), _env[8], _env[5]);\n"
"quads_found := 0;\n"
"}\n"
"else\n"
"DB.DBA.RDF_DELETE_TRIPLES_AGG (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"if (80000 <= dict_size (dict))\n"
"{\n"
"if (quads_found)\n"
"{\n"
"DB.DBA.RDF_INSERT_QUADS (_env[0], dict_list_keys (dict, 2), _env[8], _env[5]);\n"
"quads_found := 0;\n"
"}\n"
"else\n"
"DB.DBA.RDF_INSERT_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"}\n"
"action_ctr := action_ctr + 1;\n"
"end_of_adding_triple: ;\n"
"}\n"
"_env[ctor_op] := _env[ctor_op] + action_ctr;\n"
"_env[5 + ctor_op] := quads_found;\n"
"log_enable (old_log_enable, 1);\n"
"}\n"
"--src sparql.sql:6781\n";

static const char *proc224 = 
"#line 6923 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.SPARQL_DELETE_CTOR_ACC (inout _env any, in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"if (not (isarray (_env)))\n"
"\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, dict_new (80000), null, log_mode, 0, 0, uid);\n"
"if (not _env[1])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL DELETE\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, opcodes, vars, log_mode, 1);\n"
"}\n"
"--src sparql.sql:6921\n";

static const char *proc225 = 
"#line 6935 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_INSERT_CTOR_ACC (inout _env any, in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"\n"
"if (not (isarray (_env)))\n"
"\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, null, dict_new (80000), log_mode, 0, 0, uid);\n"
"if (not _env[2])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL INSERT\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, opcodes, vars, log_mode, 2);\n"
"}\n"
"--src sparql.sql:6933\n";

static const char *proc226 = 
"#line 6948 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_MODIFY_CTOR_ACC (inout _env any, in graph_iri any, in del_opcodes any, in ins_opcodes any, in vars any, in uid integer, in log_mode integer)\n"
"{\n"
"if (not (isarray (_env)))\n"
"\n"
"_env := vector (iri_to_id (graph_iri), 0, 0, dict_new (80000), dict_new (80000), log_mode, 0, 0, uid);\n"
"if (not _env[1] and not _env[2])\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL MODIFY\');\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, del_opcodes, vars, log_mode, 1);\n"
"DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL (_env, graph_iri, ins_opcodes, vars, log_mode, 2);\n"
"}\n"
"--src sparql.sql:6946\n";

static const char *proc227 = 
"#line 6961 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN (inout _env any)\n"
"{\n"
"if (isarray (_env))\n"
"{\n"
"declare dict any;\n"
"dict := _env[3];\n"
"if (dict is not null and (0 < dict_size (dict)))\n"
"{\n"
"_env[3] := null;\n"
"if (_env[6])\n"
"DB.DBA.RDF_DELETE_QUADS (_env[0], dict_list_keys (dict, 2), _env[8], _env[5]);\n"
"else\n"
"DB.DBA.RDF_DELETE_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"dict := _env[4];\n"
"if (dict is not null and (0 < dict_size (dict)))\n"
"{\n"
"_env[4] := null;\n"
"if (_env[7])\n"
"DB.DBA.RDF_INSERT_QUADS (_env[0], dict_list_keys (dict, 2), _env[8], _env[5]);\n"
"else\n"
"DB.DBA.RDF_INSERT_TRIPLES (_env[0], dict_list_keys (dict, 2), _env[5]);\n"
"}\n"
"}\n"
"return _env;\n"
"}\n"
"--src sparql.sql:6959\n";

static const char *other30 = 
" create aggregate DB.DBA.SPARQL_DELETE_CTOR (in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_DELETE_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *other31 = 
" create aggregate DB.DBA.SPARQL_INSERT_CTOR (in graph_iri any, in opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_INSERT_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *other32 = 
" create aggregate DB.DBA.SPARQL_MODIFY_CTOR (in graph_iri any, in del_opcodes any, in ins_opcodes any, in vars any, in uid integer, in log_mode integer) returns any\n"
"from DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT, DB.DBA.SPARQL_MODIFY_CTOR_ACC, DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN\n";

static const char *proc228 = 
"#line 7004 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_INSERT_DICT_CONTENT (in graph_iri any, in triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare triples any;\n"
"declare ins_count integer;\n"
"ins_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"ins_count := graph_iri[2];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL INSERT\');\n"
"while (dict_size (triples_dict) > 0)\n"
"{\n"
"triples := dict_destructive_list_rnd_keys (triples_dict, 80000);\n"
"DB.DBA.RDF_INSERT_TRIPLES (graph_iri, triples, log_mode);\n"
"ins_count := ins_count + length (triples);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (graph_iri is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (graph_iri)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"if (compose_report)\n"
"{\n"
"if (ins_count)\n"
"return sprintf (\'Insert into <%s>, %d (or less) triples -- done\', graph_iri, ins_count);\n"
"else\n"
"return sprintf (\'Insert into <%s>, 0 triples -- nothing to do\', graph_iri);\n"
"}\n"
"else\n"
"return ins_count;\n"
"}\n"
"--src sparql.sql:7002\n";

static const char *proc229 = 
"#line 7037 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_DELETE_DICT_CONTENT (in graph_iri any, in triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare triples any;\n"
"declare del_count integer;\n"
"del_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"del_count := graph_iri[1];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL DELETE\');\n"
"while (dict_size (triples_dict) > 0)\n"
"{\n"
"triples := dict_destructive_list_rnd_keys (triples_dict, 2000000);\n"
"DB.DBA.RDF_DELETE_TRIPLES_AGG (graph_iri, triples, log_mode);\n"
"del_count := del_count + length (triples);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (graph_iri is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (graph_iri)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"if (compose_report)\n"
"{\n"
"if (del_count)\n"
"return sprintf (\'Delete from <%s>, %d (or less) triples -- done\', graph_iri, del_count);\n"
"else\n"
"return sprintf (\'Delete from <%s>, 0 triples -- nothing to do\', graph_iri);\n"
"}\n"
"else\n"
"return del_count;\n"
"}\n"
"--src sparql.sql:7035\n";

static const char *proc230 = 
"#line 7070 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS (in graph_iri any, in del_triples_dict any, in ins_triples_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare del_count, ins_count integer;\n"
"del_count := 0;\n"
"ins_count := 0;\n"
"if (__tag of vector = __tag (graph_iri))\n"
"{\n"
"del_count := graph_iri[1];\n"
"ins_count := graph_iri[2];\n"
"graph_iri := graph_iri[0];\n"
"}\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL MODIFY\');\n"
"if (del_triples_dict is not null)\n"
"{\n"
"del_count := del_count + dict_size (del_triples_dict);\n"
"DB.DBA.SPARQL_DELETE_DICT_CONTENT (graph_iri, del_triples_dict, uid, log_mode);\n"
"}\n"
"if (ins_triples_dict is not null)\n"
"{\n"
"ins_count := ins_count + dict_size (ins_triples_dict);\n"
"DB.DBA.SPARQL_INSERT_DICT_CONTENT (graph_iri, ins_triples_dict, uid, log_mode);\n"
"}\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"if (graph_iri is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (graph_iri)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"if (compose_report)\n"
"return sprintf (\'Modify <%s>, delete %d (or less) and insert %d (or less) triples -- done\', graph_iri, del_count, ins_count);\n"
"else\n"
"return del_count + ins_count;\n"
"}\n"
"--src sparql.sql:7068\n";

static const char *proc231 = 
"#line 7104 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_REPL_DEL (inout rquads any)\n"
"{\n"
"declare rquads_ctr, rquads_count, opcode integer;\n"
"declare g_iri, prev_g_iri varchar;\n"
"declare g_iid varchar;\n"
"declare ro_id_dict, app_env any;\n"
"rquads_count := length (rquads);\n"
"prev_g_iri := \'\';\n"
"for (rquads_ctr := 0; rquads_ctr < rquads_count; rquads_ctr := rquads_ctr + 1)\n"
"{\n"
"\n"
"g_iri := rquads[rquads_ctr][1];\n"
"if (g_iri <> prev_g_iri)\n"
"{\n"
"g_iid := iri_to_id (g_iri);\n"
"\n"
"prev_g_iri := g_iri;\n"
"}\n"
"opcode := rquads[rquads_ctr][0];\n"
"if (0 = opcode)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = g_iid and S = iri_to_id_repl (rquads[rquads_ctr][2]) and P = iri_to_id_repl (rquads[rquads_ctr][3])\n"
"and O = DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (rquads[rquads_ctr][4]);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"__rdf_repl_quad (160 + opcode, g_iri, rquads[rquads_ctr][2], rquads[rquads_ctr][3], rquads[rquads_ctr][4]);\n"
"}\n"
"else if (1 = opcode)\n"
"{\n"
"declare obj any;\n"
"if (isgeometry (rquads[rquads_ctr][4]))\n"
"{\n"
"obj := rdf_box (rquads[rquads_ctr][4], 256, 257, 0, 1);\n"
"rdf_geo_set_id (obj);\n"
"}\n"
"else\n"
"obj := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (rquads[rquads_ctr][4], iri_to_id_repl (rquads[rquads_ctr][5]), null);\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = g_iid and S = iri_to_id_repl (rquads[rquads_ctr][2]) and P = iri_to_id_repl (rquads[rquads_ctr][3]) and O = obj;\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"__rdf_repl_quad (160 + opcode, g_iri, rquads[rquads_ctr][2], rquads[rquads_ctr][3], rquads[rquads_ctr][4], rquads[rquads_ctr][5], null);\n"
"}\n"
"else if (2 = opcode)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = g_iid and S = iri_to_id_repl (rquads[rquads_ctr][2]) and P = iri_to_id_repl (rquads[rquads_ctr][3])\n"
"and O = DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL (rquads[rquads_ctr][4], null, rquads[rquads_ctr][5]);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"__rdf_repl_quad (160 + opcode, g_iri, rquads[rquads_ctr][2], rquads[rquads_ctr][3], rquads[rquads_ctr][4], null, rquads[rquads_ctr][5]);\n"
"}\n"
"else if (4 = opcode)\n"
"{\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = g_iid and S = iri_to_id_repl (rquads[rquads_ctr][2]) and P = iri_to_id_repl (rquads[rquads_ctr][3])\n"
"and O = iri_to_id_repl (rquads[rquads_ctr][4]);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"__rdf_repl_quad (160 + opcode, g_iri, rquads[rquads_ctr][2], rquads[rquads_ctr][3], rquads[rquads_ctr][4]);\n"
"}\n"
"\n"
"\n"
"}\n"
"app_env := vector (1, null);\n"
"DB.DBA.TTLP_EV_COMMIT (g_iri, app_env);\n"
"\n"
"\n"
"connection_set (\'g_dict\', null);\n"
"commit work;\n"
"}\n"
"--src sparql.sql:7102\n";

static const char *proc232 = 
"#line 7177 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_CLEAR (in graph_iris any, in inside_sponge integer, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare g_iid IRI_ID;\n"
"declare old_log_enable integer;\n"
"declare txtreport varchar;\n"
"txtreport := \'\';\n"
"if (__tag of vector <> __tag (graph_iris))\n"
"graph_iris := vector (graph_iris);\n"
"foreach (any g_iri in graph_iris) do\n"
"{\n"
"if (isiri_id (g_iri))\n"
"g_iri := id_to_iri (g_iri);\n"
"g_iid := iri_to_id (g_iri);\n"
"__rgs_assert_cbk (g_iri, uid, 2, \'SPARUL CLEAR GRAPH\');\n"
"}\n"
"foreach (any g_iri in graph_iris) do\n"
"{\n"
"if (isiri_id (g_iri))\n"
"g_iri := id_to_iri (g_iri);\n"
"g_iid := iri_to_id (g_iri);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"{\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue()\');\n"
"repl_text (\'__rdf_repl\', \'sparql define input:storage \"\" clear graph iri ( ?? )\', g_iri);\n"
"}\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"exec (sprintf (\'\n"
"delete from DB.DBA.RDF_QUAD\n"
"where G = __i2id (\'\'%S\'\') \', g_iri));\n"
"DB.DBA.CL_EXEC (\'delete from DB.DBA.RDF_QUAD table option (index G, index_only, no cluster) where G = ? option (index G)\', vector (g_iid));\n"
"delete from DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\n"
"where VT_WORD = rdf_graph_keyword (g_iid);\n"
"if (not inside_sponge)\n"
"{\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = g_iri;\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI like concat (\'destMD5=\', md5 (g_iri), \'&graphMD5=%\');\n"
"}\n"
"if (compose_report)\n"
"{\n"
"if (txtreport <> \'\')\n"
"txtreport := txtreport || \'\\n\';\n"
"txtreport := txtreport || sprintf (\'Clear graph <%s> -- done\', g_iri);\n"
"}\n"
"}\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return txtreport;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7175\n";

static const char *proc233 = 
"#line 7230 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_LOAD (in graph_iri any, in resource varchar, in uid integer, in log_mode integer, in compose_report integer, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare old_log_enable integer;\n"
"declare grab_params any;\n"
"declare grabbed any;\n"
"declare res integer;\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL LOAD\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); if (silent) goto fail; resignal; };\n"
"grabbed := dict_new();\n"
"if (isiri_id (graph_iri))\n"
"graph_iri := id_to_iri (graph_iri);\n"
"grab_params := vector_concat (vector (\n"
"\'base_iri\', resource,\n"
"\'get:destination\', graph_iri,\n"
"\'get:soft\', get_keyword (\'get:soft\', options, \'replacing\'),\n"
"\'get:refresh\', get_keyword (\'get:refresh\', options, -1),\n"
"\'get:error-recovery\', get_keyword (\'get:error-recovery\', options, \'signal\'),\n"
"\n"
"\'get:strategy\', get_keyword (\'get:strategy\', options, \'rdfa-only\'),\n"
"\'get:private\', get_keyword (\'get:private\', options, null),\n"
"\'grabbed\', grabbed ),\n"
"options );\n"
"commit work;\n"
"res := DB.DBA.RDF_GRAB_SINGLE (resource, grabbed, grab_params);\n"
"commit work;\n"
"log_enable (old_log_enable, 1);\n"
"if (res)\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Load <%s> into graph <%s> -- done\', resource, graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Load <%s> into graph <%s> -- failed\', resource, graph_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"fail:\n"
"if (compose_report)\n"
"return sprintf (\'Load silent <%s> into graph <%s> -- failed: %s: %s\', resource, graph_iri, __SQL_STATE, __SQL_MESSAGE);\n"
"else\n"
"return 0;\n"
"}\n"
"--src sparql.sql:7228\n";

static const char *proc234 = 
"#line 7279 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_LOAD_SERVICE_DATA (in service_iri any, in proxy_iri varchar, in uid integer, in log_mode integer, in compose_report integer, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare old_log_enable integer;\n"
"declare mdta, rows any;\n"
"declare stat, msg varchar;\n"
"__rgs_assert_cbk (service_iri, uid, 2, \'SPARUL LOAD SERVICE DATA\');\n"
"\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"stat := \'00000\';\n"
"exec (\'DB.DBA.SPARQL_SD_PROBE (?, ?, 0, 0)\', stat, msg, vector (service_iri, proxy_iri), 10000, mdta, rows);\n"
"log_enable (old_log_enable, 1);\n"
"if (stat <> \'00000\')\n"
"{\n"
"if (not silent) signal (stat, msg);\n"
"if (compose_report)\n"
"return sprintf (\'Load service <%s> data failed: %s: %s\', service_iri, stat, msg);\n"
"else\n"
"return 0;\n"
"}\n"
"if (compose_report)\n"
"{\n"
"if (length (rows))\n"
"return sprintf (\'Load service <%s> data -- done. %s\', service_iri, rows[length(rows)-1][1]);\n"
"else\n"
"return sprintf (\'Load service <%s> data -- nothing done\', service_iri);\n"
"}\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7277\n";

static const char *proc235 = 
"#line 7310 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_CREATE (in graph_iri any, in silent1 integer, in uid integer, in log_mode integer, in compose_report integer, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare g_iid IRI_ID;\n"
"declare old_log_enable integer;\n"
"__rgs_assert_cbk (graph_iri, uid, 2, \'SPARUL CREATE GRAPH\');\n"
"g_iid := iri_to_id (graph_iri);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"repl_text (\'__rdf_repl\', \'sparql define input:storage \"\" create graph iri ( ?? )\', graph_iri);\n"
"if ((silent1 is not null) and silent1)\n"
"silent := 1;\n"
"if (exists (select top 1 1 from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = g_iid))\n"
"{\n"
"if (silent)\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'Create silent graph <%s> -- already exists\', graph_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> has been explicitly created before\');\n"
"}\n"
"if (silent)\n"
"{\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"insert soft DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH (REC_GRAPH_IID) values (iri_to_id (graph_iri));\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Create silent graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where G = iri_to_id (graph_iri)))\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> contains triples already\');\n"
"if (exists (sparql define input:storage \"\"\n"
"ask from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue `iri(?:graph_iri)` } ) )\n"
"signal (\'22023\', \'SPARUL_CREATE() failed: graph <\' || graph_iri || \'> is used for mapping relational data to RDF\');\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"insert soft DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH (REC_GRAPH_IID) values (iri_to_id (graph_iri));\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Create graph <%s> -- done\', graph_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7308\n";

static const char *proc236 = 
"#line 7362 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_DROP (in graph_iris any, in silent1 integer, in uid integer, in log_mode integer, in compose_report integer, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare g_iid IRI_ID;\n"
"declare old_log_enable integer;\n"
"declare txtreport varchar;\n"
"txtreport := \'\';\n"
"if ((silent1 is not null) and silent1)\n"
"silent := 1;\n"
"if (__tag of vector <> __tag (graph_iris))\n"
"graph_iris := vector (graph_iris);\n"
"foreach (any g_iri in graph_iris) do\n"
"{\n"
"if (isiri_id (g_iri))\n"
"g_iri := id_to_iri (g_iri);\n"
"g_iid := iri_to_id (g_iri);\n"
"__rgs_assert_cbk (g_iri, uid, 2, \'SPARUL DROP GRAPH\');\n"
"}\n"
"foreach (any g_iri in graph_iris) do\n"
"{\n"
"if (isiri_id (g_iri))\n"
"g_iri := id_to_iri (g_iri);\n"
"g_iid := iri_to_id (g_iri);\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"{\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue()\');\n"
"repl_text (\'__rdf_repl\', \'sparql define input:storage \"\" drop graph iri ( ?? )\', g_iri);\n"
"}\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = g_iid))\n"
"{\n"
"if (silent)\n"
"{\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD where G = g_iid))\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (g_iri, 0, uid);\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- graph has not been explicitly created before, triples were removed\', g_iri);\n"
"else\n"
"return 2;\n"
"}\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- nothing to do\', g_iri);\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"signal (\'22023\', \'SPARUL_DROP() failed: graph <\' || g_iri || \'> has not been explicitly created before\');\n"
"}\n"
"if (silent)\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (g_iri, 0, uid);\n"
"delete from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = g_iid;\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'Drop silent graph <%s> -- done\', g_iri);\n"
"else\n"
"return 1;\n"
"}\n"
"if (exists (sparql define input:storage \"\"\n"
"ask from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue `iri(?:g_iri)` } ) )\n"
"signal (\'22023\', \'SPARUL_DROP() failed: graph <\' || g_iri || \'> is used for mapping relational data to RDF\');\n"
"DB.DBA.SPARUL_CLEAR (g_iri, 0, uid);\n"
"delete from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH where REC_GRAPH_IID = g_iid;\n"
"if (compose_report)\n"
"{\n"
"if (txtreport <> \'\')\n"
"txtreport := txtreport || \'\\n\';\n"
"txtreport := txtreport || sprintf (\'Drop graph <%s> -- done\', g_iri);\n"
"}\n"
"}\n"
"log_enable (old_log_enable, 1);\n"
"/*091202 commit work; */\n"
"if (compose_report)\n"
"return txtreport;\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7360\n";

static const char *proc237 = 
"#line 7444 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_RUN (in results any, in compose_report integer := 0) returns any\n"
"{\n"
"\n"
"if (compose_report)\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"foreach (varchar r in results) do\n"
"{\n"
"http (cast (r as varchar) || \'\\n\', ses);\n"
"}\n"
"http (\'Commit -- done\\n\', ses);\n"
"return string_output_string (ses);\n"
"}\n"
"else\n"
"{\n"
"declare res integer;\n"
"res := 0;\n"
"foreach (integer c in results) do\n"
"{\n"
"res := res + c;\n"
"}\n"
"return res;\n"
"}\n"
"}\n"
"--src sparql.sql:7442\n";

static const char *proc238 = 
"#line 7474 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_BINDINGS_VIEW_IMP (in dta any)\n"
"{\n"
"declare rcount, rctr integer;\n"
"declare BND any;\n"
"result_names (BND);\n"
"rcount := length (dta);\n"
"for (rctr := 0; rctr < rcount; rctr := rctr+1)\n"
"result (dta[rctr]);\n"
"}\n"
"--src sparql.sql:7472\n";

static const char *view0 = 
"create procedure view DB.DBA.SPARQL_BINDINGS_VIEW as DB.DBA.SPARQL_BINDINGS_VIEW_IMP (dta) (BND any)\n";

static const char *other33 = 
"grant select on DB.DBA.SPARQL_BINDINGS_VIEW to public\n";
static const char *proc239 = 
"#line 7492 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_INSERT_QUADS (in dflt_graph_iri any, inout quads any, in uid integer, in log_mode integer := null) returns any\n"
"{\n"
"declare groups any;\n"
"declare group_ctr, group_count, g_ins_count integer;\n"
"rowvector_graph_sort (quads, 3, 1);\n"
"groups := rowvector_graph_partition (quads, 3);\n"
"group_count := length (groups);\n"
"for (group_ctr := 0; group_ctr < group_count; group_ctr := group_ctr+1)\n"
"{\n"
"declare g_group, g any;\n"
"g_group := aref_set_0 (groups, group_ctr);\n"
"g := aref_or_default (g_group, 0, 3, dflt_graph_iri);\n"
"__rgs_assert_cbk (g, uid, 2, \'SPARQL 1.1 INSERT\');\n"
"DB.DBA.RDF_INSERT_TRIPLES (g, g_group, log_mode);\n"
"if (isiri_id (g))\n"
"g := id_to_iri (g);\n"
"if (g is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (g)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"}\n"
"}\n"
"--src sparql.sql:7490\n";

static const char *proc240 = 
"#line 7514 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_DELETE_QUADS (in dflt_graph_iri any, inout quads any, in uid integer, in log_mode integer := null) returns any\n"
"{\n"
"declare groups any;\n"
"declare group_ctr, group_count, g_del_count integer;\n"
"rowvector_graph_sort (quads, 3, 1);\n"
"groups := rowvector_graph_partition (quads, 3);\n"
"group_count := length (groups);\n"
"for (group_ctr := 0; group_ctr < group_count; group_ctr := group_ctr+1)\n"
"{\n"
"declare g_group, g any;\n"
"g_group := aref_set_0 (groups, group_ctr);\n"
"g := aref_or_default (g_group, 0, 3, dflt_graph_iri);\n"
"__rgs_assert_cbk (g, uid, 2, \'SPARQL 1.1L DELETE\');\n"
"DB.DBA.RDF_DELETE_TRIPLES (g, g_group, log_mode);\n"
"if (isiri_id (g))\n"
"g := id_to_iri (g);\n"
"if (g is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (g)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"}\n"
"}\n"
"--src sparql.sql:7512\n";

static const char *proc241 = 
"#line 7537 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_INSERT_QUAD_DICT_CONTENT (in dflt_graph_iri any, in quads_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare ins_count, ins_grp_count integer;\n"
"declare res_ses any;\n"
"ins_count := 0;\n"
"ins_grp_count := 0;\n"
"if (__tag of vector = __tag (dflt_graph_iri))\n"
"{\n"
"ins_count := dflt_graph_iri[2];\n"
"dflt_graph_iri := dflt_graph_iri[0];\n"
"}\n"
"while (dict_size (quads_dict) > 0)\n"
"{\n"
"declare quads, groups any;\n"
"declare group_ctr, group_count, g_ins_count integer;\n"
"quads := dict_destructive_list_rnd_keys (quads_dict, 80000);\n"
"rowvector_graph_sort (quads, 3, 1);\n"
"groups := rowvector_graph_partition (quads, 3);\n"
"group_count := length (groups);\n"
"for (group_ctr := 0; group_ctr < group_count; group_ctr := group_ctr+1)\n"
"{\n"
"declare g_group, g any;\n"
"g_group := aref_set_0 (groups, group_ctr);\n"
"g := aref_or_default (g_group, 0, 3, dflt_graph_iri);\n"
"__rgs_assert_cbk (g, uid, 2, \'SPARQL 1.1 INSERT\');\n"
"DB.DBA.RDF_INSERT_TRIPLES (g, g_group, log_mode);\n"
"g_ins_count := length (g_group);\n"
"ins_count := ins_count + g_ins_count;\n"
"ins_grp_count := ins_grp_count + 1;\n"
"if (isiri_id (g))\n"
"g := id_to_iri (g);\n"
"if (g is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (g)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"if (compose_report and ins_grp_count < 1000)\n"
"{\n"
"if (group_ctr)\n"
"http (\'\\n\', res_ses);\n"
"else\n"
"res_ses := string_output();\n"
"http (sprintf (\'Insert into <%s>, %d (or less) quads -- done\', g, g_ins_count), res_ses);\n"
"}\n"
"}\n"
"}\n"
"if (compose_report)\n"
"{\n"
"if (ins_grp_count >= 1000)\n"
"return sprintf (\'Insert into %d (or more) graphs, total %d (or less) quads -- done\', ins_grp_count, ins_count);\n"
"if (ins_count)\n"
"return string_output_string (res_ses);\n"
"else\n"
"return sprintf (\'Insert into <%s>, 0 quads -- nothing to do\', dflt_graph_iri);\n"
"}\n"
"else\n"
"return ins_count;\n"
"}\n"
"--src sparql.sql:7535\n";

static const char *proc242 = 
"#line 7594 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_DELETE_QUAD_DICT_CONTENT (in dflt_graph_iri any, in quads_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare del_count, del_grp_count integer;\n"
"declare res_ses any;\n"
"del_count := 0;\n"
"del_grp_count := 0;\n"
"if (__tag of vector = __tag (dflt_graph_iri))\n"
"{\n"
"del_count := dflt_graph_iri[2];\n"
"dflt_graph_iri := dflt_graph_iri[0];\n"
"}\n"
"while (dict_size (quads_dict) > 0)\n"
"{\n"
"declare quads, groups any;\n"
"declare group_ctr, group_count, g_del_count integer;\n"
"quads := dict_destructive_list_rnd_keys (quads_dict, 80000);\n"
"rowvector_graph_sort (quads, 3, 1);\n"
"groups := rowvector_graph_partition (quads, 3);\n"
"group_count := length (groups);\n"
"for (group_ctr := 0; group_ctr < group_count; group_ctr := group_ctr+1)\n"
"{\n"
"declare g_group, g any;\n"
"g_group := aref_set_0 (groups, group_ctr);\n"
"g := aref_or_default (g_group, 0, 3, dflt_graph_iri);\n"
"__rgs_assert_cbk (g, uid, 2, \'SPARQL 1.1L DELETE\');\n"
"DB.DBA.RDF_DELETE_TRIPLES (g, g_group, log_mode);\n"
"g_del_count := length (g_group);\n"
"del_count := del_count + g_del_count;\n"
"del_grp_count := del_grp_count + 1;\n"
"if (isiri_id (g))\n"
"g := id_to_iri (g);\n"
"if (g is not null and __rdf_graph_is_in_enabled_repl (iri_to_id (g)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"if (compose_report and del_grp_count < 1000)\n"
"{\n"
"if (group_ctr)\n"
"http (\'\\n\', res_ses);\n"
"else\n"
"res_ses := string_output();\n"
"http (sprintf (\'Delete from <%s>, %d (or less) quads -- done\', g, g_del_count), res_ses);\n"
"}\n"
"}\n"
"}\n"
"if (compose_report)\n"
"{\n"
"if (del_grp_count >= 1000)\n"
"return sprintf (\'Delete from %d (or more) graphs, total %d (or less) quads -- done\', del_grp_count, del_count);\n"
"if (del_count)\n"
"return string_output_string (res_ses);\n"
"else\n"
"return sprintf (\'Delete from <%s>, 0 quads -- nothing to do\', dflt_graph_iri);\n"
"}\n"
"else\n"
"return del_count;\n"
"}\n"
"--src sparql.sql:7592\n";

static const char *proc243 = 
"#line 7651 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARQL_MODIFY_BY_QUAD_DICT_CONTENTS (in dflt_graph_iri any, in del_quads_dict any, in ins_quads_dict any, in uid integer, in log_mode integer := null, in compose_report integer := 0) returns any\n"
"{\n"
"declare del_count, ins_count integer;\n"
"declare del_rep, ins_rep any;\n"
"del_count := 0;\n"
"ins_count := 0;\n"
"if (__tag of vector = __tag (dflt_graph_iri))\n"
"{\n"
"del_count := dflt_graph_iri[1];\n"
"ins_count := dflt_graph_iri[2];\n"
"dflt_graph_iri := dflt_graph_iri[0];\n"
"}\n"
"if (del_quads_dict is not null)\n"
"{\n"
"del_count := del_count + dict_size (del_quads_dict);\n"
"del_rep := DB.DBA.SPARQL_DELETE_QUAD_DICT_CONTENT (dflt_graph_iri, del_quads_dict, uid, log_mode, compose_report);\n"
"}\n"
"else if (compose_report)\n"
"del_rep := \'\';\n"
"else\n"
"del_rep := 0;\n"
"if (ins_quads_dict is not null)\n"
"{\n"
"ins_count := ins_count + dict_size (ins_quads_dict);\n"
"ins_rep := DB.DBA.SPARQL_INSERT_QUAD_DICT_CONTENT (dflt_graph_iri, ins_quads_dict, uid, log_mode, compose_report);\n"
"}\n"
"else if (compose_report)\n"
"ins_rep := \'\';\n"
"else\n"
"ins_rep := 0;\n"
"if (compose_report)\n"
"return concat (del_rep, case when ins_rep <> \'\' and del_rep <> \'\' then \'\\n\' else \'\' end, ins_rep);\n"
"else\n"
"return del_count + ins_count;\n"
"}\n"
"--src sparql.sql:7649\n";

static const char *proc244 = 
"#line 7688 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_COPYMOVEADD_IMPL (in opname varchar, in src_g_iri any, in tgt_g_iri any, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"declare src_g_iid IRI_ID;\n"
"declare tgt_g_iid IRI_ID;\n"
"declare old_log_enable, src_repl, tgt_repl integer;\n"
"declare qry, stat, msg varchar;\n"
"if (isiri_id (src_g_iri))\n"
"src_g_iri := id_to_iri (src_g_iri);\n"
"src_g_iid := iri_to_id (src_g_iri);\n"
"if (isiri_id (tgt_g_iri))\n"
"tgt_g_iri := id_to_iri (tgt_g_iri);\n"
"tgt_g_iid := iri_to_id (tgt_g_iri);\n"
"__rgs_assert_cbk (tgt_g_iri, uid, 2, \'SPARQL 1.1 \' || opname);\n"
"__rgs_assert_cbk (src_g_iri, uid, case (opname) when \'MOVE\' then 2 else 1 end, \'SPARQL 1.1 \' || opname);\n"
"if (src_g_iid = tgt_g_iid)\n"
"{\n"
"if (compose_report)\n"
"return sprintf (\'%s <%s> to itself -- nothing to do\', opname, src_g_iri);\n"
"return 1;\n"
"}\n"
"src_repl := __rdf_graph_is_in_enabled_repl (src_g_iid);\n"
"tgt_repl := __rdf_graph_is_in_enabled_repl (tgt_g_iid);\n"
"if (src_repl and not tgt_repl)\n"
"signal (\'22023\', sprintf (\'SPARQL 1.1 can not %s replicated graph <%s> to non-replicated graph <%s>, both should be in same replication status\', src_g_iri, tgt_g_iri));\n"
"if (tgt_repl and not src_repl)\n"
"signal (\'22023\', sprintf (\'SPARQL 1.1 can not %s non-replicated graph <%s> to replicated graph <%s>, both should be in same replication status\', src_g_iri, tgt_g_iri));\n"
"if (\'ADD\' <> opname)\n"
"DB.DBA.SPARUL_CLEAR (tgt_g_iri, 0, uid, log_mode, 0, options, silent);\n"
"if (src_repl and tgt_repl)\n"
"{\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue()\');\n"
"repl_text (\'__rdf_repl\', \'sparql define input:storage \"\" add iri( ?? ) to iri( ?? )\', src_g_iri, tgt_g_iri);\n"
"}\n"
"old_log_enable := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' { log_enable (old_log_enable, 1); resignal; };\n"
"stat := \'00000\';\n"
"qry := sprintf (\'insert soft DB.DBA.RDF_QUAD (G,S,P,O) select __i2id (\'\'%S\'\'), t.S, t.P, t.O from DB.DBA.RDF_QUAD t where t.G = __i2id (\'\'%S\'\') \',\n"
"tgt_g_iri, src_g_iri );\n"
"exec (qry, stat, msg);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"if (\'MOVE\' = opname)\n"
"DB.DBA.SPARUL_CLEAR (src_g_iri, 0, uid, log_mode, 0, options, silent);\n"
"/*091202 commit work; */\n"
"log_enable (old_log_enable, 1);\n"
"if (compose_report)\n"
"return sprintf (\'%s <%s> to <%s> -- done\', opname, src_g_iri, tgt_g_iri);\n"
"return 1;\n"
"}\n"
"--src sparql.sql:7686\n";

static const char *proc245 = 
"#line 7739 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_COPY (in src_g_iri any, in tgt_g_iri any, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"return DB.DBA.SPARUL_COPYMOVEADD_IMPL (\'COPY\', src_g_iri, tgt_g_iri, uid, log_mode, compose_report, options, silent);\n"
"}\n"
"--src sparql.sql:7737\n";

static const char *proc246 = 
"#line 7745 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_MOVE (in src_g_iri any, in tgt_g_iri any, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"return DB.DBA.SPARUL_COPYMOVEADD_IMPL (\'MOVE\', src_g_iri, tgt_g_iri, uid, log_mode, compose_report, options, silent);\n"
"}\n"
"--src sparql.sql:7743\n";

static const char *proc247 = 
"#line 7751 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.SPARUL_ADD (in src_g_iri any, in tgt_g_iri any, in uid integer := 0, in log_mode integer := null, in compose_report integer := 0, in options any := null, in silent integer := 0) returns any\n"
"{\n"
"return DB.DBA.SPARUL_COPYMOVEADD_IMPL (\'ADD\', src_g_iri, tgt_g_iri, uid, log_mode, compose_report, options, silent);\n"
"}\n"
"--src sparql.sql:7749\n";

static const char *proc248 = 
"#line 7757 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS (in return_iris integer := 1, in lim integer := 2000000000)\n"
"{\n"
"declare specials, specials_vec any;\n"
"declare last_iri_id, cur_iri_id IRI_ID;\n"
"declare cr cursor for select G from DB.DBA.RDF_QUAD table option (index G) where G > last_iri_id and not (dict_get (specials, G, 0));\n"
"declare cr_cl cursor for select G from DB.DBA.RDF_QUAD table option (index G)  where G > last_iri_id and 0 >= position (G, specials_vec);\n"
"declare GRAPH_IRI varchar;\n"
"declare GRAPH_IID IRI_ID;\n"
"declare ctr, len integer;\n"
"if (lim is null)\n"
"lim := 2000000000;\n"
"if (return_iris)\n"
"result_names (GRAPH_IRI);\n"
"else\n"
"result_names (GRAPH_IID);\n"
"specials := dict_new (50);\n"
"set isolation = \'repeatable\';\n"
"for (sparql define input:storage \"\"\n"
"select distinct ?graph_rvr_fixed\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?qmv virtrdf:qmGraphRange-rvrFixedValue ?graph_rvr_fixed } ) do\n"
"{\n"
"dict_put (specials, iri_to_id (\"graph_rvr_fixed\"), 1);\n"
"}\n"
"if (dict_size (specials) >= lim)\n"
"goto done_all;\n"
"for (select REC_GRAPH_IID from DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH) do\n"
"{\n"
"dict_put (specials, REC_GRAPH_IID, 2);\n"
"}\n"
"len := dict_size (specials);\n"
"if (len >= lim)\n"
"goto done_all;\n"
"last_iri_id := #i0;\n"
"\n"
"\n"
"\n"
"specials_vec := dict_list_keys (specials, 0);\n"
"whenever not found goto done_rdf_quad_cl;\n"
"open cr_cl (prefetch 1);\n"
"\n"
"next_fetch_cr_cl:\n"
"fetch cr_cl into cur_iri_id;\n"
"if (return_iris)\n"
"result (id_to_iri (cur_iri_id));\n"
"else\n"
"result (cur_iri_id);\n"
"lim := lim - 1;\n"
"if (len >= lim)\n"
"goto done_rdf_quad_cl;\n"
"last_iri_id := cur_iri_id;\n"
"close cr_cl;\n"
"open cr_cl (prefetch 1);\n"
"goto next_fetch_cr_cl;\n"
"\n"
"done_rdf_quad_cl:\n"
"close cr_cl;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"done_all:\n"
"specials := dict_list_keys (specials, 1);\n"
"len := length (specials);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"if (return_iris)\n"
"result (id_to_iri (specials[ctr]));\n"
"else\n"
"result (specials[ctr]);\n"
"}\n"
"--src sparql.sql:7755\n";

static const char *proc249 = 
"#line 7851 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_REGEX (in s varchar, in p varchar, in coll varchar := null)\n"
"{\n"
"if (not iswidestring (s) and not isstring (s))\n"
"return 0;\n"
"if (regexp_match (p, s, 0, coalesce (coll, \'\'), 1) is not null)\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:7849\n";

static const char *proc250 = 
"#line 7862 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_LANGMATCHES (in r varchar, in t varchar)\n"
"{\n"
"if ((t is null) or (r is null))\n"
"return null;\n"
"if (\'*\' = t)\n"
"{\n"
"if (r <> \'\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"t := upper (t);\n"
"r := upper (r);\n"
"if (r = t)\n"
"return 1;\n"
"if (r like t || \'-%\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src sparql.sql:7860\n";

static const char *proc251 = 
"#line 7883 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.BEST_LANGMATCH_INIT (inout env any)\n"
"{\n"
"env := vector (0, -2);\n"
"}\n"
"--src sparql.sql:7881\n";

static const char *proc252 = 
"#line 7890 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.BEST_LANGMATCH_ACC (inout env any, inout obj any, in range varchar, in dflt_lang varchar)\n"
"{\n"
"declare lang varchar;\n"
"declare pct integer;\n"
"if (obj is null)\n"
"return;\n"
"if (__tag (env) <> __tag of vector)\n"
"env := vector (0, -2);\n"
"if (__tag of rdf_box = __tag (obj))\n"
"{\n"
"declare twobyte integer;\n"
"twobyte := rdf_box_lang (obj);\n"
"if (257 = twobyte)\n"
"lang := dflt_lang;\n"
"else\n"
"{\n"
"whenever not found goto badlang;\n"
"select lower (RL_ID) into lang from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = twobyte;\n"
"goto lang_ready;\n"
"badlang:\n"
"signal (\'RDFXX\', sprintf (\'Unknown language in DB.DBA.BEST_LANGMATCH_ACC, bad lang id %d\', twobyte));\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (obj))\n"
"lang := dflt_lang;\n"
"else\n"
"{\n"
"if (env[1] = -2)\n"
"env := vector (obj, -1);\n"
"return;\n"
"}\n"
"lang_ready:\n"
"pct := langmatches_pct_http (lang, range);\n"
"if (env[1] < pct)\n"
"env := vector (obj, pct);\n"
"}\n"
"--src sparql.sql:7888\n";

static const char *proc253 = 
"#line 7929 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.BEST_LANGMATCH_FINAL (inout env any) returns any\n"
"{\n"
"if (__tag (env) <> __tag of vector)\n"
"return null;\n"
"return env[0];\n"
"}\n"
"--src sparql.sql:7927\n";

static const char *other34 = 
" create aggregate DB.DBA.BEST_LANGMATCH (inout obj any, in range varchar, in dflt_lang varchar) from\n"
"DB.DBA.BEST_LANGMATCH_INIT,\n"
"DB.DBA.BEST_LANGMATCH_ACC,\n"
"DB.DBA.BEST_LANGMATCH_FINAL\n";

static const char *proc254 = 
"#line 7945 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_CONSTRUCT_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:7943\n";

static const char *proc255 = 
"#line 7952 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_CONSTRUCT_ACC (inout _env any, in opcodes any, in vars any, in stats any, in use_dict_limit integer)\n"
"{\n"
"declare triple_ctr integer;\n"
"declare blank_ids any;\n"
"if (214 <> __tag(_env))\n"
"{\n"
"if (use_dict_limit)\n"
"_env := dict_new (31, sys_stat (\'sparql_result_set_max_rows\'), sys_stat (\'sparql_max_mem_in_use\'));\n"
"else\n"
"_env := dict_new (31);\n"
"if (0 < length (stats))\n"
"DB.DBA.SPARQL_CONSTRUCT_ACC (_env, stats, vector(), vector(), use_dict_limit);\n"
"}\n"
"blank_ids := 0;\n"
"for (triple_ctr := length (opcodes) - 1; triple_ctr >= 0; triple_ctr := triple_ctr-1)\n"
"{\n"
"declare fld_ctr, fld_count integer;\n"
"declare triple_vec any;\n"
"declare g_opcode integer;\n"
"g_opcode := aref_or_default (opcodes, triple_ctr, 6, null);\n"
"if (g_opcode is null)\n"
"{\n"
"fld_count := 3;\n"
"triple_vec := vector (0,0,0);\n"
"}\n"
"else\n"
"{\n"
"fld_count := 4;\n"
"triple_vec := vector (0,0,0,0);\n"
"}\n"
"\n"
"for (fld_ctr := fld_count - 1; fld_ctr >= 0; fld_ctr := fld_ctr - 1)\n"
"{\n"
"declare op integer;\n"
"declare arg any;\n"
"op := opcodes[triple_ctr][fld_ctr * 2];\n"
"arg := opcodes[triple_ctr][fld_ctr * 2 + 1];\n"
"if (1 = op)\n"
"{\n"
"declare i any;\n"
"i := vars[arg];\n"
"if (i is null)\n"
"goto end_of_adding_triple;\n"
"if (isiri_id (i))\n"
"{\n"
"if (fld_ctr in (1,3) and is_bnode_iri_id (i))\n"
"signal (\'RDF01\', \'Bad variable value in CONSTRUCT: blank node can not be used as predicate or graph\');\n"
"}\n"
"else if ((isstring (i) and (1 = __box_flags (i))) or (217 = __tag(i)))\n"
"{\n"
"if (fld_ctr in (1,3) and (i like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad variable value in CONSTRUCT: blank node can not be used as predicate or graph\');\n"
"i := iri_to_id (i);\n"
"}\n"
"else if (2 <> fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad variable value in CONSTRUCT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (i), __tag (i), __box_flags (i),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"triple_vec[fld_ctr] := i;\n"
"}\n"
"else if (2 = op)\n"
"{\n"
"if (isinteger (blank_ids))\n"
"blank_ids := vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\')));\n"
"while (arg >= length (blank_ids))\n"
"blank_ids := vector_concat (blank_ids, vector (iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'))));\n"
"if (fld_ctr in (1,3))\n"
"signal (\'RDF01\', \'Bad triple for CONSTRUCT: blank node can not be used as predicate or graph\');\n"
"triple_vec[fld_ctr] := blank_ids[arg];\n"
"}\n"
"else if (3 = op)\n"
"{\n"
"if (arg is null)\n"
"goto end_of_adding_triple;\n"
"if (isiri_id (arg))\n"
"{\n"
"if (fld_ctr in (1,3) and is_bnode_iri_id (arg))\n"
"signal (\'RDF01\', \'Bad const value in CONSTRUCT: blank node can not be used as predicate or graph\');\n"
"}\n"
"else if ((isstring (arg) and (1 = __box_flags (arg))) or (217 = __tag(arg)))\n"
"{\n"
"if (fld_ctr in (1,3) and (arg like \'bnode://%\'))\n"
"signal (\'RDF01\', \'Bad const value in CONSTRUCT: blank node can not be used as predicate or graph\');\n"
"arg := iri_to_id (arg);\n"
"}\n"
"else if (2 <> fld_ctr)\n"
"signal (\'RDF01\',\n"
"sprintf (\'Bad const value in CONSTRUCT: \"%.100s\" (tag %d box flags %d) is not a valid %s, only object of a triple can be a literal\',\n"
"__rdf_strsqlval (arg), __tag (arg), __box_flags (arg),\n"
"case (fld_ctr) when 1 then \'predicate\' else \'subject\' end ) );\n"
"else if (__tag of vector = __tag (arg))\n"
"arg := DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (arg[0], arg[1], arg[2]);\n"
"triple_vec[fld_ctr] := arg;\n"
"}\n"
"else signal (\'RDFXX\', \'Bad opcode in DB.DBA.SPARQL_CONSTRUCT()\');\n"
"}\n"
"\n"
"dict_put (_env, triple_vec, 0);\n"
"end_of_adding_triple: ;\n"
"}\n"
"}\n"
"--src sparql.sql:7950\n";

static const char *proc256 = 
"#line 8057 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.SPARQL_CONSTRUCT_FIN (inout _env any)\n"
"{\n"
"if (214 <> __tag(_env))\n"
"_env := dict_new ();\n"
"return _env;\n"
"}\n"
"--src sparql.sql:8055\n";

static const char *other35 = 
" create aggregate DB.DBA.SPARQL_CONSTRUCT (in opcodes any, in vars any, in stats any, in use_dict_limit integer) returns any\n"
"from DB.DBA.SPARQL_CONSTRUCT_INIT, DB.DBA.SPARQL_CONSTRUCT_ACC, DB.DBA.SPARQL_CONSTRUCT_FIN\n";

static const char *proc257 = 
"#line 8070 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_AGG_INIT (inout _env any)\n"
"{\n"
"_env := 0;\n"
"}\n"
"--src sparql.sql:8068\n";

static const char *proc258 = 
"#line 8076 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_AGG_ACC (inout _env any, in vars any)\n"
"{\n"
"declare var_ctr integer;\n"
"declare blank_ids any;\n"
"if (214 <> __tag(_env))\n"
"{\n"
"_env := dict_new (31, sys_stat (\'sparql_result_set_max_rows\'), sys_stat (\'sparql_max_mem_in_use\'));\n"
"}\n"
"for (var_ctr := length (vars) - 1; var_ctr >= 0; var_ctr := var_ctr - 1)\n"
"{\n"
"declare i any;\n"
"i := vars[var_ctr];\n"
"if (isiri_id (i))\n"
"dict_put (_env, i, 0);\n"
"}\n"
"}\n"
"--src sparql.sql:8074\n";

static const char *proc259 = 
"#line 8094 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_AGG_FIN (inout _env any)\n"
"{\n"
"declare subjects, options, res any;\n"
"declare subj_ctr integer;\n"
"if (214 <> __tag(_env))\n"
"return dict_new ();\n"
"return _env;\n"
"}\n"
"--src sparql.sql:8092\n";

static const char *other36 = 
"create aggregate DB.DBA.SPARQL_DESC_AGG (in vars any) returns any\n"
"from DB.DBA.SPARQL_DESC_AGG_INIT, DB.DBA.SPARQL_DESC_AGG_ACC, DB.DBA.SPARQL_DESC_AGG_FIN\n";

static const char *proc260 = 
"#line 8108 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, g_dict, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid, inf_ruleset, sameas varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"inf_ruleset := get_keyword (\'inference\', options);\n"
"sameas := get_keyword (\'same-as\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (storage_name is null)\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if ((\'\' = storage_name) and (inf_ruleset is null) and (sameas is null))\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps_s, maps_o any;\n"
"declare maps_s_len, maps_o_len integer;\n"
"s := all_subj_descs [s_ctr];\n"
"maps_s := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"maps_o := sparql_quad_maps_for_quad (NULL, NULL, NULL, s, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_s_len := length (maps_s);\n"
"maps_o_len := length (maps_o);\n"
"if ((inf_ruleset is null) and (sameas is null))\n"
"{\n"
"declare phys_as_s, phys_as_o integer;\n"
"phys_as_s := case when ((maps_s_len > 0) and (maps_s[maps_s_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\')) then 1 else 0 end;\n"
"phys_as_o := case when ((maps_o_len > 0) and (maps_o[maps_o_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\')) then 1 else 0 end;\n"
"if (phys_as_s or phys_as_o)\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"if (phys_as_s)\n"
"{\n"
"maps_s := subseq (maps_s, 0, maps_s_len-1);\n"
"maps_s_len := maps_s_len - 1;\n"
"}\n"
"if (phys_as_o)\n"
"{\n"
"maps_o := subseq (maps_o, 0, maps_o_len-1);\n"
"maps_o_len := maps_o_len - 1;\n"
"}\n"
"}\n"
"}\n"
"if ((maps_s_len > 0) or (maps_o_len > 0))\n"
"all_subj_descs [s_ctr] := vector (s, maps_s, maps_o);\n"
"else\n"
"all_subj_descs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps_s, maps_o any;\n"
"declare map_ctr, maps_s_len, maps_o_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subj_descs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps_s := s_desc[1];\n"
"maps_o := s_desc[2];\n"
"maps_s_len := length (maps_s);\n"
"maps_o_len := length (maps_o);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_QMV1_%U\', md5 (storage_name || \' \' || inf_ruleset || \' \' || sameas || \' \' || cast (graphs_listed as varchar) || md5_box (maps_s) || md5_box (maps_o) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, in res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"if (inf_ruleset is not null)\n"
"http (\'  define input:inference <\' || inf_ruleset || \'>\\n\', ses);\n"
"if (sameas is not null)\n"
"http (\'  define input:same-as <\' || sameas || \'>\\n\', ses);\n"
"http (\'select ?g1 ?p1 ?o1\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_s_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps_s[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            } } ) do {\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g1\"), sorted_good_graphs))\\n\', ses);\n"
"http (\'      dict_bitor_or_put (res, vector (subj, \"p1\", \"o1\"), 1); }\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"if (inf_ruleset is not null)\n"
"http (\'  define input:inference <\' || inf_ruleset || \'>\\n\', ses);\n"
"if (sameas is not null)\n"
"http (\'  define input:same-as <\' || sameas || \'>\\n\', ses);\n"
"http (\'select ?g1 ?s1 ?p1\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_o_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps_o[map_ctr][0] || \'> { ?s1 ?p1 ?o1 . FILTER (?p1 != rdf:type) . FILTER(isREF (?o1)) . FILTER (?o1 = iri(?:subj_iri)) } }\\n\', ses);\n"
"}\n"
"http (\'            } } ) do {\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g1\"), sorted_good_graphs))\\n\', ses);\n"
"http (\'      dict_bitor_or_put (res, vector (\"s1\", \"p1\", subj), 4); }\\n\', ses);\n"
"http (\'  }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"}\n"
"for (select S as s1, P as p1 from DB.DBA.RDF_QUAD\n"
"where G = graph and O = subj and P <> rdf_type_iid\n"
"option (QUIETCAST)) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (s1, p1, subj), 4);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where O = subj and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"if (0 = length (sorted_good_graphs))\n"
"{\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where S = subj and P = rdf_type_iid and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"}\n"
"\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"good_g_count := length (sorted_good_graphs);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"for (select S as s1, P as p1 from DB.DBA.RDF_QUAD\n"
"where G = graph and O = subj and P <> rdf_type_iid\n"
"option (QUIETCAST)) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (s1, p1, subj), 4);\n"
"}\n"
"}\n"
"}\n"
"\n"
"return res;\n"
"}\n"
"--src sparql.sql:8106\n";

static const char *proc261 = 
"#line 8420 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_SPO (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid, inf_ruleset, sameas varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"inf_ruleset := get_keyword (\'inference\', options);\n"
"sameas := get_keyword (\'same-as\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (storage_name is null)\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if ((\'\' = storage_name) and (inf_ruleset is null) and (sameas is null))\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps any;\n"
"declare maps_len integer;\n"
"s := all_subj_descs [s_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (inf_ruleset is null) and (sameas is null) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_subj_descs [s_ctr] := vector (s, maps);\n"
"else\n"
"all_subj_descs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subj_descs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_QMV1_%U\', md5 (storage_name || \' \' || inf_ruleset || \' \' || sameas || \' \' || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, in res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"if (inf_ruleset is not null)\n"
"http (\'  define input:inference <\' || inf_ruleset || \'>\\n\', ses);\n"
"if (sameas is not null)\n"
"http (\'  define input:same-as <\' || sameas || \'>\\n\', ses);\n"
"http (\'select ?g1 ?p1 ?o1\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            } } ) do {\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g1\"), sorted_good_graphs))\\n\', ses);\n"
"http (\'      dict_bitor_or_put (res, vector (subj, \"p1\", \"o1\"), 1); } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"--src sparql.sql:8418\n";

static const char *proc262 = 
"#line 8635 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subj_descs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, g_dict, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subj_descs := dict_list_keys (subj_dict, 1);\n"
"all_s_count := length (all_subj_descs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"gvector_sort (all_subj_descs, 1, 0, 0);\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subj_descs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"}\n"
"}\n"
"}\n"
"return res;\n"
"}\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where O = subj and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"if (0 = length (sorted_good_graphs))\n"
"{\n"
"g_dict := dict_new ();\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj, graph any;\n"
"subj := phys_subjects [s_ctr];\n"
"graph := coalesce ((select top 1 G as g1 from DB.DBA.RDF_QUAD where S = subj and P = rdf_type_iid and\n"
"0 = position (G, sorted_bad_graphs) and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) );\n"
"if (graph is not null)\n"
"dict_put (g_dict, graph, 0);\n"
"}\n"
"sorted_good_graphs := dict_list_keys (g_dict, 1);\n"
"}\n"
"\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"good_g_count := length (sorted_good_graphs);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"}\n"
"}\n"
"\n"
"return res;\n"
"}\n"
"--src sparql.sql:8633\n";

static const char *proc263 = 
"#line 8796 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_CBD (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subjs, phys_subjects, sorted_good_graphs, sorted_bad_graphs, next_iter_subjs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count, phys_s_count integer;\n"
"declare gs_app_callback, gs_app_uid, inf_ruleset varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"inf_ruleset := get_keyword (\'inference\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subjs := dict_list_keys (subj_dict, 0);\n"
"next_iter_subjs := dict_new ();\n"
"all_s_count := length (all_subjs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_s_count := length (all_subjs);\n"
"gvector_sort (all_subjs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_subjects);\n"
"if (storage_name is null)\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if ((\'\' = storage_name) and (inf_ruleset is null))\n"
"{\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s any;\n"
"s := all_subjs [s_ctr];\n"
"if (isiri_id (s))\n"
"vectorbld_acc (phys_subjects, s);\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"goto describe_physical_subjects;\n"
"}\n"
"\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s, phys_s, maps any;\n"
"declare maps_len integer;\n"
"s := all_subjs [s_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, s, NULL, NULL, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (inf_ruleset is null) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (isiri_id (s))\n"
"{\n"
"phys_s := s;\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"else\n"
"{\n"
"phys_s := iri_to_id (s, 0, 0);\n"
"if (not isinteger (phys_s))\n"
"vectorbld_acc (phys_subjects, phys_s);\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_subjs [s_ctr] := vector (s, maps);\n"
"else\n"
"all_subjs [s_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_subjects);\n"
"for (s_ctr := 0; s_ctr < all_s_count; s_ctr := s_ctr + 1)\n"
"{\n"
"declare s_desc, s, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_subjs [s_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"s := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_CBD_QMV1_%U\', md5 (storage_name || inf_ruleset || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in subj any, in subj_dict any, in next_iter_subjs any, in res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare subj_iri varchar;\\n\', ses);\n"
"http (\'  subj_iri := id_to_iri_nosignal (subj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"if (inf_ruleset is not null)\n"
"http (\'  define input:inference <\' || inf_ruleset || \'>\\n\', ses);\n"
"http (\'select ?g1 ?p1 ?o1 ?g2 ?st2\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?:subj_iri ?p1 ?o1 } }\\n\', ses);\n"
"}\n"
"http (\'            }\\n\', ses);\n"
"http (\'          optional { graph ?g2 {\\n\', ses);\n"
"http (\'                  ?st2 a rdf:Statement ; rdf:subject ?:subj_iri ; rdf:predicate ?p1 ; rdf:object ?o1 } }\\n\', ses);\n"
"http (\'            } ) do {\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g1\"), sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      dict_bitor_or_put (res, vector (subj, \"p1\", \"o1\"), 1);\\n\', ses);\n"
"http (\'      if (isiri_id (\"o1\") and \"o1\" > min_bnode_iri_id() and dict_get (subj_dict, \"o1\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_subjs, \"o1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g2\"), sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      if (\"st2\" is not null and dict_get (subj_dict, \"st2\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_subjs, \"o1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'        } }\\n\', ses);\n"
"http (\'      } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, subj_dict, next_iter_subjs, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(s, subj_dict, next_iter_subjs, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_subjects:\n"
"gvector_sort (phys_subjects, 1, 0, 0);\n"
"phys_s_count := length (phys_subjects);\n"
"\n"
"if (0 = phys_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (subj_dict, \"st2\") is null)\n"
"dict_put (next_iter_subjs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (s_ctr := phys_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := phys_subjects [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (subj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_subjs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_subjs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_subjs := dict_list_keys (next_iter_subjs, 1);\n"
"foreach (IRI_ID s in all_subjs) do dict_put (subj_dict, s, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:8794\n";

static const char *proc264 = 
"#line 9058 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL (in subj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_subjs, sorted_good_graphs, sorted_bad_graphs, next_iter_subjs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, s_ctr, all_s_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (isiri_id (c))\n"
"dict_put (subj_dict, c, 0);\n"
"}\n"
"all_subjs := dict_list_keys (subj_dict, 0);\n"
"next_iter_subjs := dict_new ();\n"
"all_s_count := length (all_subjs);\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_s_count := length (all_subjs);\n"
"gvector_sort (all_subjs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id () and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isiri_id (g) and g < min_bnode_iri_id ())\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"\n"
"if (0 = all_s_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (s_ctr := all_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := all_subjs [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where G = graph and S = subj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (subj_dict, \"st2\") is null)\n"
"dict_put (next_iter_subjs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (s_ctr := all_s_count - 1; s_ctr >= 0; s_ctr := s_ctr - 1)\n"
"{\n"
"declare subj any;\n"
"subj := all_subjs [s_ctr];\n"
"for (select P as p1, O as obj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"S = subj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj, p1, __rdf_long_of_obj (obj1)), 1);\n"
"if (isiri_id (obj1) and obj1 > min_bnode_iri_id() and dict_get (subj_dict, obj1) is null)\n"
"dict_put (next_iter_subjs, obj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:subject ?:subj ; rdf:predicate ?:p1 ; rdf:object ?:obj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (subj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_subjs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_subjs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_subjs := dict_list_keys (next_iter_subjs, 1);\n"
"foreach (IRI_ID s in all_subjs) do dict_put (subj_dict, s, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:9056\n";

static const char *proc265 = 
"#line 9190 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_OBJCBD (in obj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_objs, phys_objects, sorted_good_graphs, sorted_bad_graphs, next_iter_objs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, obj_ctr, all_obj_count, phys_obj_count integer;\n"
"declare gs_app_callback, gs_app_uid, inf_ruleset varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"inf_ruleset := get_keyword (\'inference\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (not isnumeric (c))\n"
"dict_put (obj_dict, c, 0);\n"
"}\n"
"all_objs := dict_list_keys (obj_dict, 0);\n"
"next_iter_objs := dict_new ();\n"
"all_obj_count := length (all_objs);\n"
"if (0 = all_obj_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_obj_count := length (all_objs);\n"
"gvector_sort (all_objs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (is_named_iri_id (g) and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (is_named_iri_id (g))\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"vectorbld_init (phys_objects);\n"
"if (storage_name is null)\n"
"storage_name := \'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadStorage\';\n"
"else if ((\'\' = storage_name) and (inf_ruleset is null))\n"
"{\n"
"for (obj_ctr := 0; obj_ctr < all_obj_count; obj_ctr := obj_ctr + 1)\n"
"{\n"
"declare obj, phys_obj any;\n"
"obj := all_objs [obj_ctr];\n"
"if (not isnumeric (obj))\n"
"{\n"
"if (isiri_id (obj))\n"
"vectorbld_acc (phys_objects, obj);\n"
"else\n"
"{\n"
"phys_obj := iri_to_id (obj, 0, 0);\n"
"if (not isinteger (phys_obj))\n"
"vectorbld_acc (phys_objects, phys_obj);\n"
"}\n"
"}\n"
"}\n"
"vectorbld_final (phys_objects);\n"
"goto describe_physical_objects;\n"
"}\n"
"\n"
"for (obj_ctr := 0; obj_ctr < all_obj_count; obj_ctr := obj_ctr + 1)\n"
"{\n"
"declare obj, phys_obj, maps any;\n"
"declare maps_len integer;\n"
"obj := all_objs [obj_ctr];\n"
"maps := sparql_quad_maps_for_quad (NULL, NULL, NULL, obj, storage_name, case (graphs_listed) when 0 then vector() else sorted_good_graphs end, sorted_bad_graphs);\n"
"\n"
"maps_len := length (maps);\n"
"if ((maps_len > 0) and (inf_ruleset is null) and (maps[maps_len-1][0] = UNAME\'http://www.openlinksw.com/schemas/virtrdf#DefaultQuadMap\'))\n"
"{\n"
"if (not isnumeric (obj))\n"
"{\n"
"if (isiri_id (obj))\n"
"{\n"
"phys_obj := obj;\n"
"vectorbld_acc (phys_objects, phys_obj);\n"
"}\n"
"else\n"
"{\n"
"phys_obj := iri_to_id (obj, 0, 0);\n"
"if (not isinteger (phys_obj))\n"
"vectorbld_acc (phys_objects, phys_obj);\n"
"}\n"
"}\n"
"maps := subseq (maps, 0, maps_len-1);\n"
"maps_len := maps_len - 1;\n"
"}\n"
"if (maps_len > 0)\n"
"all_objs [obj_ctr] := vector (obj, maps);\n"
"else\n"
"all_objs [obj_ctr] := 0;\n"
"\n"
"\n"
"}\n"
"vectorbld_final (phys_objects);\n"
"for (obj_ctr := 0; obj_ctr < all_obj_count; obj_ctr := obj_ctr + 1)\n"
"{\n"
"declare s_desc, obj, maps any;\n"
"declare map_ctr, maps_len integer;\n"
"declare fname varchar;\n"
"s_desc := all_objs [obj_ctr];\n"
"if (isinteger (s_desc))\n"
"goto end_of_s;\n"
"obj := s_desc[0];\n"
"maps := s_desc[1];\n"
"maps_len := length (maps);\n"
"fname := sprintf (\'SPARQL_DESC_DICT_OBJCBD_QMV1_%U\', md5 (storage_name || inf_ruleset || cast (graphs_listed as varchar) || md5_box (maps) || md5_box (sorted_bad_graphs)));\n"
"if (not exists (select top 1 1 from Db.DBA.SYS_PROCEDURES where P_NAME = \'DB.DBA.\' || fname))\n"
"{\n"
"declare ses, txt, saved_user any;\n"
"ses := string_output ();\n"
"http (\'create procedure DB.DBA.\"\' || fname || \'\" (in obj any, in obj_dict any, in next_iter_objs any, in res any\', ses);\n"
"if (graphs_listed)\n"
"http (\', inout sorted_good_graphs any\', ses);\n"
"http (\')\\n\', ses);\n"
"http (\'{\\n\', ses);\n"
"http (\'  declare obj_iri varchar;\\n\', ses);\n"
"http (\'  obj_iri := id_to_iri_nosignal (obj);\\n\', ses);\n"
"http (\'  for (sparql define output:valmode \"LONG\" define input:storage <\' || storage_name || \'> \', ses);\n"
"foreach (any g in sorted_bad_graphs) do\n"
"{\n"
"http (\'  define input:named-graph-exclude <\' || id_to_iri_nosignal (g) || \'>\\n\', ses);\n"
"}\n"
"if (inf_ruleset is not null)\n"
"http (\'  define input:inference <\' || inf_ruleset || \'>\\n\', ses);\n"
"http (\'select ?g1 ?p1 ?s1 ?g2 ?st2\\n\', ses);\n"
"http (\'      where { graph ?g1 {\\n\', ses);\n"
"for (map_ctr := 0; map_ctr < maps_len; map_ctr := map_ctr + 1)\n"
"{\n"
"if (map_ctr > 0) http (\'              union\\n\', ses);\n"
"http (\'              { quad map <\' || maps[map_ctr][0] || \'> { ?s1 ?p1 ?:obj_iri } }\\n\', ses);\n"
"}\n"
"http (\'            }\\n\', ses);\n"
"http (\'          optional { graph ?g2 {\\n\', ses);\n"
"http (\'                  ?st2 a rdf:Statement ; rdf:object ?:obj_iri ; rdf:predicate ?p1 ; rdf:subject ?s1 } }\\n\', ses);\n"
"http (\'            } ) do {\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g1\"), sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      dict_bitor_or_put (res, vector (\"s1\", \"p1\", obj), 1);\\n\', ses);\n"
"http (\'      if (is_bnode_iri_id (\"s1\") and dict_get (obj_dict, \"s1\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_objs, \"s1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'      if (position (__i2idn (\"g2\"), sorted_good_graphs)) {\\n\', ses);\n"
"http (\'      if (\"st2\" is not null and dict_get (obj_dict, \"st2\") is null)\\n\', ses);\n"
"http (\'        dict_put (next_iter_objs, \"s1\", 1);\\n\', ses);\n"
"if (graphs_listed)\n"
"http (\'        } }\\n\', ses);\n"
"http (\'      } }\\n\', ses);\n"
"txt := string_output_string (ses);\n"
"\n"
"saved_user := user;\n"
"set_user_id (\'dba\', 1);\n"
"exec (txt);\n"
"set_user_id (saved_user);\n"
"}\n"
"if (graphs_listed)\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(obj, obj_dict, next_iter_objs, res, sorted_good_graphs);\n"
"}\n"
"else\n"
"{\n"
"\n"
"call (\'DB.DBA.\' || fname)(obj, obj_dict, next_iter_objs, res);\n"
"}\n"
"end_of_s: ;\n"
"}\n"
"\n"
"describe_physical_objects:\n"
"gvector_sort (phys_objects, 1, 0, 0);\n"
"phys_obj_count := length (phys_objects);\n"
"\n"
"if (0 = phys_obj_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (obj_ctr := phys_obj_count - 1; obj_ctr >= 0; obj_ctr := obj_ctr - 1)\n"
"{\n"
"declare obj any;\n"
"obj := phys_objects [obj_ctr];\n"
"for (select P as p1, S as subj1 from DB.DBA.RDF_QUAD where G = graph and O = obj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj1, p1, __rdf_long_of_obj (obj)), 1);\n"
"if (is_bnode_iri_id (subj1) and dict_get (obj_dict, subj1) is null)\n"
"dict_put (next_iter_objs, subj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:object ?:obj ; rdf:predicate ?:p1 ; rdf:subject ?:subj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (obj_dict, \"st2\") is null)\n"
"dict_put (next_iter_objs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (obj_ctr := phys_obj_count - 1; obj_ctr >= 0; obj_ctr := obj_ctr - 1)\n"
"{\n"
"declare obj any;\n"
"obj := phys_objects [obj_ctr];\n"
"for (select P as p1, S as subj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"O = obj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj1, p1, __rdf_long_of_obj (obj)), 1);\n"
"if (is_bnode_iri_id (subj1) and dict_get (obj_dict, subj1) is null)\n"
"dict_put (next_iter_objs, subj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:object ?:obj ; rdf:predicate ?:p1 ; rdf:subject ?:subj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (obj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_objs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_objs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_objs := dict_list_keys (next_iter_objs, 1);\n"
"foreach (IRI_ID obj in all_objs) do dict_put (obj_dict, obj, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:9188\n";

static const char *proc266 = 
"#line 9458 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_OBJCBD_PHYSICAL (in obj_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare all_objs, sorted_good_graphs, sorted_bad_graphs, next_iter_objs, res any;\n"
"declare uid, graphs_listed, g_ctr, good_g_count, bad_g_count, obj_ctr, all_obj_count integer;\n"
"declare gs_app_callback, gs_app_uid varchar;\n"
"declare rdf_type_iid IRI_ID;\n"
"uid := get_keyword (\'uid\', options, http_nobody_uid());\n"
"gs_app_callback := get_keyword (\'gs-app-callback\', options);\n"
"if (gs_app_callback is not null)\n"
"gs_app_uid := get_keyword (\'gs-app-uid\', options);\n"
"rdf_type_iid := iri_to_id (UNAME\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\');\n"
"res := dict_new ();\n"
"if (isinteger (consts))\n"
"return res;\n"
"foreach (any c in consts) do\n"
"{\n"
"if (not isnumeric (c))\n"
"dict_put (obj_dict, c, 0);\n"
"}\n"
"all_objs := dict_list_keys (obj_dict, 0);\n"
"next_iter_objs := dict_new ();\n"
"all_obj_count := length (all_objs);\n"
"if (0 = all_obj_count)\n"
"return res;\n"
"\n"
"next_iteration:\n"
"all_obj_count := length (all_objs);\n"
"gvector_sort (all_objs, 1, 0, 0);\n"
"\n"
"if (__tag of integer = __tag (good_graphs))\n"
"graphs_listed := 0;\n"
"else\n"
"{\n"
"vectorbld_init (sorted_good_graphs);\n"
"foreach (any g in good_graphs) do\n"
"{\n"
"if (is_named_iri_id (g) and\n"
"__rgs_ack_cbk (g, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (g, gs_app_uid))) )\n"
"vectorbld_acc (sorted_good_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_good_graphs);\n"
"good_g_count := length (sorted_good_graphs);\n"
"if (0 = good_g_count)\n"
"return res;\n"
"graphs_listed := 1;\n"
"}\n"
"vectorbld_init (sorted_bad_graphs);\n"
"foreach (any g in bad_graphs) do\n"
"{\n"
"if (isnamed_iri_id (g))\n"
"vectorbld_acc (sorted_bad_graphs, g);\n"
"}\n"
"vectorbld_final (sorted_bad_graphs);\n"
"bad_g_count := length (sorted_bad_graphs);\n"
"\n"
"if (0 = all_obj_count)\n"
"return res;\n"
"\n"
"if (graphs_listed)\n"
"{\n"
"gvector_sort (sorted_good_graphs, 1, 0, 0);\n"
"\n"
"for (g_ctr := good_g_count - 1; g_ctr >= 0; g_ctr := g_ctr - 1)\n"
"{\n"
"declare graph any;\n"
"graph := sorted_good_graphs [g_ctr];\n"
"for (obj_ctr := all_obj_count - 1; obj_ctr >= 0; obj_ctr := obj_ctr - 1)\n"
"{\n"
"declare obj any;\n"
"obj := all_objs [obj_ctr];\n"
"for (select P as p1, S as subj1 from DB.DBA.RDF_QUAD where G = graph and O = obj) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj1, p1, __rdf_long_of_obj (obj)), 1);\n"
"if (is_bnode_iri_id (subj1) and dict_get (obj_dict, subj1) is null)\n"
"dict_put (next_iter_objs, subj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:object ?:obj ; rdf:predicate ?:p1 ; rdf:subject ?:subj1 } } ) do\n"
"{\n"
"if (position (\"g2\", sorted_good_graphs) and dict_get (obj_dict, \"st2\") is null)\n"
"dict_put (next_iter_objs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"for (obj_ctr := all_obj_count - 1; obj_ctr >= 0; obj_ctr := obj_ctr - 1)\n"
"{\n"
"declare obj any;\n"
"obj := all_objs [obj_ctr];\n"
"for (select P as p1, S as subj1 from DB.DBA.RDF_QUAD where\n"
"0 = position (G, sorted_bad_graphs) and\n"
"O = obj and\n"
"__rgs_ack_cbk (G, uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (G, gs_app_uid))) ) do\n"
"{\n"
"\n"
"dict_bitor_or_put (res, vector (subj1, p1, __rdf_long_of_obj (obj)), 1);\n"
"if (is_bnode_iri_id (subj1) and dict_get (obj_dict, subj1) is null)\n"
"dict_put (next_iter_objs, subj1, 1);\n"
"for (sparql define output:valmode \"LONG\"\n"
"select ?g2 ?st2 where {\n"
"graph ?g2 {\n"
"?st2 a rdf:Statement ; rdf:object ?:obj ; rdf:predicate ?:p1 ; rdf:subject ?:subj1 } } ) do\n"
"{\n"
"if (0 = position (\"g2\", sorted_bad_graphs) and\n"
"dict_get (obj_dict, \"st2\") is null and\n"
"__rgs_ack_cbk (\"g2\", uid, 1) and\n"
"(gs_app_callback is null or bit_and (1, call (gs_app_callback) (\"g2\", gs_app_uid))) )\n"
"dict_put (next_iter_objs, \"st2\", 1);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"\n"
"ret_or_next_iter:\n"
"if (0 = dict_size (next_iter_objs))\n"
"{\n"
"\n"
"return res;\n"
"}\n"
"all_objs := dict_list_keys (next_iter_objs, 1);\n"
"foreach (IRI_ID obj in all_objs) do dict_put (obj_dict, obj, 1);\n"
"goto next_iteration;\n"
"}\n"
"--src sparql.sql:9456\n";

static const char *proc267 = 
"#line 9590 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_SCBD (in node_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare cbd_res, objcbd_res, triples any;\n"
"cbd_res := DB.DBA.SPARQL_DESC_DICT_CBD (node_dict, consts, good_graphs, bad_graphs, storage_name, options);\n"
"objcbd_res := DB.DBA.SPARQL_DESC_DICT_OBJCBD (node_dict, consts, good_graphs, bad_graphs, storage_name, options);\n"
"again:\n"
"triples := dict_destructive_list_rnd_keys (objcbd_res, 80000);\n"
"if (0 = length (triples))\n"
"return cbd_res;\n"
"foreach (any triple in triples) do { dict_put (cbd_res, triple, 1); }\n"
"goto again;\n"
"}\n"
"--src sparql.sql:9588\n";

static const char *proc268 = 
"#line 9604 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_DESC_DICT_SCBD_PHYSICAL (in node_dict any, in consts any, in good_graphs any, in bad_graphs any, in storage_name any, in options any)\n"
"{\n"
"declare cbd_res, objcbd_res, triples any;\n"
"cbd_res := DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL (node_dict, consts, good_graphs, bad_graphs, storage_name, options);\n"
"objcbd_res := DB.DBA.SPARQL_DESC_DICT_OBJCBD_PHYSICAL (node_dict, consts, good_graphs, bad_graphs, storage_name, options);\n"
"again:\n"
"triples := dict_destructive_list_rnd_keys (objcbd_res, 80000);\n"
"if (0 = length (triples))\n"
"return cbd_res;\n"
"foreach (any triple in triples) do { dict_put (cbd_res, triple, 1); }\n"
"goto again;\n"
"}\n"
"--src sparql.sql:9602\n";

static const char *proc269 = 
"#line 9619 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_DICT_OF_TRIPLES_TO_THREE_COLS (in dict any, in destructive integer := 0)\n"
"{\n"
"declare ctr, len, max_batch_sz integer;\n"
"declare editable_dict, triples, O any;\n"
"declare S, P, O_DT, O_LANG varchar;\n"
"declare O_IS_IRI, dt_twobyte, lang_twobyte integer;\n"
"result_names (S, P, O);\n"
"max_batch_sz := __min (sys_stat (\'dc_max_batch_sz\'), 1000000);\n"
"editable_dict := null;\n"
"if (not destructive and dict_size (dict) > max_batch_sz)\n"
"editable_dict := dict_duplicate (dict);\n"
"next_batch:\n"
"if (editable_dict is not null)\n"
"{\n"
"if (dict_size (editable_dict))\n"
"triples := dict_destructive_list_rnd_keys (editable_dict, max_batch_sz);\n"
"else\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"if (dict_size (dict))\n"
"{\n"
"if (dict_size (dict) > max_batch_sz)\n"
"triples := dict_destructive_list_rnd_keys (dict, max_batch_sz);\n"
"else\n"
"{\n"
"triples := dict_list_keys (dict, destructive);\n"
"dict := null;\n"
"}\n"
"}\n"
"else\n"
"return;\n"
"}\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"\n"
"len := length (triples);\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"if (isiri_id (triples[ctr][0]))\n"
"S := id_to_iri (triples[ctr][0]);\n"
"else\n"
"S := triples[ctr][0];\n"
"\n"
"if (isiri_id (triples[ctr][1]))\n"
"P := id_to_iri (triples[ctr][1]);\n"
"else\n"
"P := triples[ctr][1];\n"
"O := triples[ctr][2];\n"
"if (isiri_id (O))\n"
"{\n"
"result (S, P, id_to_iri (O)\n"
");\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"else if (S is not null and P is not null and O is not null)\n"
"result (S, P, O\n"
");\n"
"}\n"
"goto next_batch;\n"
"}\n"
"--src sparql.sql:9617\n";

static const char *proc270 = 
"#line 9692 \"[executable]/sparql.sql\"\n"
" create procedure DB.DBA.RDF_DICT_OF_TRIPLES_TO_FOUR_COLS (in dict any, in destructive integer := 0)\n"
"{\n"
"declare ctr, len integer;\n"
"declare triples, O any;\n"
"declare S, P, O_DT, O_LANG varchar;\n"
"declare O_IS_IRI, dt_twobyte, lang_twobyte integer;\n"
"triples := dict_list_keys (dict, destructive);\n"
"DB.DBA.RDF_TRIPLES_BATCH_COMPLETE (triples);\n"
"exec_result_names (vector (vector (\'S\', 182, 0, 4072, 1, 0, 1, 0, 0, 0, 0, 0), vector (\'P\', 182, 0, 4072, 1, 0, 1, 0, 0, 0, 0, 0), vector (\'O\', 182, 0, 2147483647, 1, 0, 0, 0, 0, 0, 0, 0), vector (\'O_TYPE\', 182, 0, 4072, 1, 0, 1, 0, 0, 0, 0, 0)));\n"
"len := length (triples);\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"if (isiri_id (triples[ctr][0]))\n"
"S := id_to_iri (triples[ctr][0]);\n"
"else\n"
"S := triples[ctr][0];\n"
"\n"
"if (isiri_id (triples[ctr][1]))\n"
"P := id_to_iri (triples[ctr][1]);\n"
"else\n"
"P := triples[ctr][1];\n"
"O := triples[ctr][2];\n"
"if (isiri_id (O))\n"
"{\n"
"result (S, P, id_to_iri (O), NULL);\n"
"}\n"
"else if (is_rdf_box (O))\n"
"{\n"
"dt_twobyte := rdf_box_type (O);\n"
"O_DT := case (dt_twobyte) when 257 then NULL else coalesce (\n"
"(select id_to_iri (RDT_IID) from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = dt_twobyte) ) end;\n"
"lang_twobyte := rdf_box_lang (O);\n"
"\n"
"\n"
"result (S, P, O, coalesce (O_DT, \'\'));\n"
"}\n"
"else if (S is not null and P is not null and O is not null)\n"
"result (S, P, O, coalesce (__xsd_type (O, NULL), \'\'));\n"
"}\n"
"}\n"
"--src sparql.sql:9690\n";

static const char *proc271 = 
"#line 9738 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TYPEMIN_OF_OBJ (in obj any) returns any\n"
"{\n"
"declare tag integer;\n"
"if (obj is null)\n"
"return NULL;\n"
"tag := __tag (obj);\n"
"if (tag in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"return -3.40282347e+38;\n"
"if (tag = __tag of datetime)\n"
"return cast (\'0101-01-01\' as datetime);\n"
"if (tag = __tag of rdf_box)\n"
"return rdf_box (\'\', rdf_box_type (obj), 257, 0, 1);\n"
"if (tag = (__tag of varchar))\n"
"return \'\';\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:9736\n";

static const char *proc272 = 
"#line 9756 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_TYPEMAX_OF_OBJ (in obj any) returns any\n"
"{\n"
"declare tag integer;\n"
"if (obj is null)\n"
"return NULL;\n"
"tag := __tag (obj);\n"
"if (tag in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"return 3.40282347e+38;\n"
"if (tag = __tag of datetime)\n"
"return cast (\'9999-12-30\' as datetime);\n"
"if (tag = __tag of rdf_box)\n"
"return rdf_box (\'\\377\\377\\377\\377\\377\\377\', rdf_box_type (obj), 257, 0, 1);\n"
"if (tag = (__tag of varchar))\n"
"return \'\\377\\377\\377\\377\\377\\377\';\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:9754\n";

static const char *proc273 = 
"#line 9774 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_IID_CMP (in obj1 any, in obj2 any) returns integer\n"
"{\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:9772\n";

static const char *proc274 = 
"#line 9780 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_CMP (in obj1 any, in obj2 any) returns integer\n"
"{\n"
"declare tag1, tag2 integer;\n"
"if (obj1 is null or obj2 is null)\n"
"return NULL;\n"
"tag1 := __tag (obj1);\n"
"tag2 := __tag (obj2);\n"
"if (tag1 = __tag of rdf_box)\n"
"{\n"
"if (tag2 = __tag of rdf_box)\n"
"{\n"
"if (obj1 = obj2)\n"
"return 0;\n"
"if (rdf_box_type (obj1) <> rdf_box_type (obj2))\n"
"return null;\n"
"if (not rdf_box_is_complete (obj1))\n"
"{\n"
"declare id1 integer;\n"
"declare full1 varchar;\n"
"id1 := rdf_box_ro_id (obj1);\n"
"if (__tag of XML = rdf_box_data_tag (obj1))\n"
"return null;\n"
"full1 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id1);\n"
"if (full1 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_OBJ_CMP, bad id %d\', id1));\n"
"rdf_box_set_data (obj1, full1, 1);\n"
"}\n"
"if (not rdf_box_is_complete (obj2))\n"
"{\n"
"declare id2 integer;\n"
"declare full2 varchar;\n"
"id2 := rdf_box_ro_id (obj2);\n"
"if (__tag of XML = rdf_box_data_tag (obj2))\n"
"return null;\n"
"full2 := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = id2);\n"
"if (full2 is null)\n"
"signal (\'RDFXX\', sprintf (\'Integrity violation in DB.DBA.RDF_OBJ_CMP, bad id %d\', id2));\n"
"rdf_box_set_data (obj2, full2, 1);\n"
"}\n"
"return rdf_box_strcmp (obj1, obj2);\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (tag2 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (obj1 <> obj2)\n"
"{\n"
"if (obj1 < obj2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 = __tag of datetime)\n"
"{\n"
"if (tag2 = __tag of datetime)\n"
"{\n"
"if (obj1 <> obj2)\n"
"{\n"
"if (obj1 < obj2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:9778\n";

static const char *proc275 = 
"#line 9855 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_LONG_CMP (in long1 any, in long2 any) returns integer\n"
"{\n"
"declare tag1, tag2 integer;\n"
"if (long1 is null or long2 is null)\n"
"return NULL;\n"
"tag1 := __tag (long1);\n"
"tag2 := __tag (long2);\n"
"if (tag1 = __tag of rdf_box)\n"
"{\n"
"if (tag2 = __tag of rdf_box)\n"
"return rdf_box_strcmp (long1, long2);\n"
"return null;\n"
"}\n"
"if (tag1 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (tag2 in (__tag of integer, __tag of double precision, __tag of numeric))\n"
"{\n"
"if (long1 <> long2)\n"
"{\n"
"if (long1 < long2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"if (tag1 = __tag of datetime)\n"
"{\n"
"if (tag2 = __tag of datetime)\n"
"{\n"
"if (long1 <> long2)\n"
"{\n"
"if (long1 < long2)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"return null;\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:9853\n";

static const char *proc276 = 
"#line 9902 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_DIST_SER_LONG (in val any) returns any\n"
"{\n"
"if (not (isstring (val)))\n"
"{\n"
"if (__tag of rdf_box = __tag (val))\n"
"{\n"
"if (rdf_box_is_storeable (val))\n"
"return serialize (val);\n"
"return serialize (vector (rdf_box_data (val), rdf_box_type (val), rdf_box_lang (val), rdf_box_is_complete (val)));\n"
"}\n"
"return serialize (val);\n"
"}\n"
"if (\'\' = val)\n"
"return val;\n"
"if (val[0] < 128)\n"
"return val;\n"
"return serialize (val);\n"
"}\n"
"--src sparql.sql:9900\n";

static const char *proc277 = 
"#line 9923 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_DIST_DESER_LONG (in strg any) returns any\n"
"{\n"
"if (not (isstring (strg)))\n"
"return strg;\n"
"if (\'\' = strg)\n"
"return strg;\n"
"if (strg[0] < 128)\n"
"return strg;\n"
"declare res any;\n"
"res := deserialize (strg);\n"
"if (__tag of vector <> __tag (res))\n"
"return res;\n"
"return rdf_box (res[0], res[1], res[2], 0, res[3]);\n"
"}\n"
"--src sparql.sql:9921\n";

static const char *proc278 = 
"#line 9942 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH (in graphiri varchar := null)\n"
"{\n"
"if (graphiri is null)\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH();\n"
"commit work;\n"
"DB.DBA.JSO_LOAD_GRAPH (graphiri, 0);\n"
"DB.DBA.JSO_PIN_GRAPH (graphiri);\n"
"for (select P_NAME from SYS_PROCEDURES\n"
"where (\n"
"(P_NAME > \'DB.DBA.SPARQL_DESC_DICT\') and\n"
"(P_NAME < \'DB.DBA.SPARQL_DESC_DICU\') and\n"
"(\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_QMV1_%\') or\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_CBD_QMV1_%\') or\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_OBJCBD_QMV1_%\') or\n"
"(P_NAME like \'DB.DBA.SPARQL_DESC_DICT_SCBD_QMV1_%\') ) )\n"
"for update) do\n"
"{\n"
"exec (\'drop procedure DB.DBA.\"\' || subseq (P_NAME, 7) || \'\"\');\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:9940\n";

static const char *proc279 = 
"#line 9966 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.JSO_DUMP_IRI (in v varchar, inout ses any)\n"
"{\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2000/01/rdf-schema#%\')\n"
"{ http (\'rdfs:\' || subseq (v, 37), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/1999/02/22-rdf-syntax-ns#%\')\n"
"{ http (\'rdf:\' || subseq (v, 43), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2002/07/owl#%\')\n"
"{ http (\'owl:\' || subseq (v, 30), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.w3.org/2001/XMLSchema#%\')\n"
"{ http (\'xsd:\' || subseq (v, 33), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.openlinksw.com/schemas/virtrdf#%\')\n"
"{ http (\'virtrdf:\' || subseq (v, 42), ses); return; }\n"
"\n"
"\n"
"if (v like \'http://www.openlinksw.com/virtrdf-data-formats#%\')\n"
"{ http (\'rdfdf:\' || subseq (v, 47), ses); return; }\n"
"http (\'<\', ses);\n"
"http_escape (v, 12, ses, 1, 1);\n"
"http (\'>\', ses);\n"
"}\n"
"--src sparql.sql:9964\n";

static const char *proc280 = 
"#line 9998 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.JSO_DUMP_FLD (in v any, inout ses any)\n"
"{\n"
"declare v_tag integer;\n"
"v_tag := __tag(v);\n"
"if (v_tag = 217)\n"
"DB.DBA.JSO_DUMP_IRI (cast (v as varchar), ses);\n"
"else if (v_tag = 243)\n"
"DB.DBA.JSO_DUMP_IRI (id_to_iri (v), ses);\n"
"else if (v_tag = 203)\n"
"http (jso_dbg_dump_rtti (v), ses);\n"
"else if (v_tag = __tag of varchar)\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (v, 11, ses, 1, 1);\n"
"http (\'\"\', ses);\n"
"}\n"
"else if (isinteger (v))\n"
"http_value (v, 0, ses);\n"
"else if (v_tag = __tag of rdf_box)\n"
"DB.DBA.RDF_LONG_TO_TTL (v, ses);\n"
"else\n"
"{\n"
"http (\'\"\', ses);\n"
"http_escape (__rdf_strsqlval (v), 11, ses, 1, 1);\n"
"http (\'\"^^<\', ses);\n"
"http_escape (cast (__xsd_type (v) as varchar), 12, ses, 1, 1);\n"
"http (\'>\', ses);\n"
"}\n"
"}\n"
"--src sparql.sql:9996\n";

static const char *proc281 = 
"#line 10029 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.JSO_VECTOR_TO_TTL (inout proplist any) returns any\n"
"{\n"
"declare prev_obj, ses any;\n"
"declare ctr, len integer;\n"
"ses := string_output ();\n"
"len := length (proplist);\n"
"gvector_sort (proplist, 1, 0, 1);\n"
"prev_obj := null;\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"declare obj, p, o any;\n"
"declare base IRI_ID;\n"
"obj := proplist[ctr][0];\n"
"p := proplist[ctr][1];\n"
"o := proplist[ctr][2];\n"
"if (obj = prev_obj)\n"
"http (\' ;\\n  \', ses);\n"
"else\n"
"{\n"
"if (prev_obj is null)\n"
"http (\n"
"\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"\', ses );\n"
"else\n"
"http (\' .\\n\', ses);\n"
"prev_obj := obj;\n"
"DB.DBA.JSO_DUMP_FLD (obj, ses);\n"
"http (\'\\n  \', ses);\n"
"}\n"
"DB.DBA.JSO_DUMP_FLD (p, ses);\n"
"http (\'\\t\', ses);\n"
"DB.DBA.JSO_DUMP_FLD (o, ses);\n"
"}\n"
"if (prev_obj is not null)\n"
"http (\' .\\n\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql.sql:10027\n";

static const char *proc282 = 
"#line 10073 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.JSO_FILTERED_PROPLIST (in only_custom integer := 0, in loading_status integer := 1, in long_valmode integer := 1) returns any\n"
"{\n"
"declare proplist, res any;\n"
"declare sys_dict, sys_inh any;\n"
"declare sys_txt, sys_vect any;\n"
"declare ctr, len integer;\n"
"declare inh_id IRI_ID;\n"
"if (loading_status = 0)\n"
"{\n"
"proplist := ((select DB.DBA.VECTOR_AGG (vector (\"sub\".\"s\", \"sub\".\"p\", \"sub\".\"o\")) from (\n"
"sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o } ) as \"sub\"));\n"
"}\n"
"else\n"
"{\n"
"proplist := vector_concat (jso_proplist (loading_status), jso_triple_list ());\n"
"}\n"
"gvector_sort (proplist, 1, 0, 1);\n"
"if (not only_custom and not long_valmode)\n"
"return proplist;\n"
"if (only_custom)\n"
"{\n"
"sys_txt := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"sys_dict := DB.DBA.RDF_TTL2HASH (sys_txt, \'\');\n"
"sys_vect := dict_list_keys (sys_dict, 0);\n"
"\n"
"inh_id := iri_ensure (\'http://www.openlinksw.com/schemas/virtrdf#inheritFrom\');\n"
"sys_inh := dict_new (127);\n"
"foreach (any triple in sys_vect) do\n"
"{\n"
"if (triple[1] = inh_id)\n"
"dict_put (sys_inh, triple[0], triple[2]);\n"
"}\n"
"}\n"
"len := length (proplist);\n"
"vectorbld_init (res);\n"
"for (ctr := 0; ctr < len; ctr := ctr+1)\n"
"{\n"
"declare obj, p, o any;\n"
"declare obj_long, p_long, o_long any;\n"
"declare base IRI_ID;\n"
"obj := proplist[ctr][0];\n"
"p := proplist[ctr][1];\n"
"o := proplist[ctr][2];\n"
"if (217 = __tag (obj))\n"
"obj_long := iri_ensure (obj);\n"
"else\n"
"obj_long := obj;\n"
"if (217 = __tag (p))\n"
"p_long := iri_ensure (p);\n"
"else\n"
"p_long := p;\n"
"if (217 = __tag (o))\n"
"o_long := iri_ensure (o);\n"
"else\n"
"o_long := __rdf_long_of_obj (DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL (o));\n"
"\n"
"if (only_custom)\n"
"{\n"
"if (dict_get (sys_dict, vector (obj_long, p_long, o_long)) is not null)\n"
"goto end_of_step;\n"
"base := dict_get (sys_inh, obj_long);\n"
"if (base is not null and dict_get (sys_dict, vector (base, p_long, o_long)) is not null)\n"
"goto end_of_step;\n"
"}\n"
"if (long_valmode)\n"
"vectorbld_acc (res, vector (obj_long, p_long, o_long));\n"
"else\n"
"vectorbld_acc (res, proplist[ctr]);\n"
"end_of_step: ;\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src sparql.sql:10071\n";

static const char *proc283 = 
"#line 10151 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.JSO_DUMP_ALL (in only_custom integer := 0, in loading_status integer := 1) returns any\n"
"{\n"
"declare proplist any;\n"
"proplist := DB.DBA.JSO_FILTERED_PROPLIST (only_custom, loading_status, 0);\n"
"return DB.DBA.JSO_VECTOR_TO_TTL (proplist);\n"
"}\n"
"--src sparql.sql:10149\n";

static const char *proc284 = 
"#line 10162 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_BACKUP_METADATA (in save_to_file integer := 0, in backup_name varchar := null) returns varchar\n"
"{\n"
"declare proplist any;\n"
"proplist := DB.DBA.JSO_FILTERED_PROPLIST (1, 0, 1);\n"
"if (backup_name is null)\n"
"backup_name := replace (cast (now() as varchar), \' \', \'T\');\n"
"if (save_to_file)\n"
"{\n"
"declare proplist_debug any;\n"
"proplist_debug := DB.DBA.JSO_FILTERED_PROPLIST (0, 0, 1);\n"
"string_to_file (backup_name || \'.ttl\', \'# RDF_BACKUP_METADATA #\\n\', -2);\n"
"string_to_file (backup_name || \'.ttl\', DB.DBA.JSO_VECTOR_TO_TTL (proplist), -1);\n"
"string_to_file (backup_name || \'-DEBUG.ttl\', \'# RDF_BACKUP_METADATA - DEBUG #\\n\', -2);\n"
"string_to_file (backup_name || \'-DEBUG.ttl\', DB.DBA.JSO_VECTOR_TO_TTL (proplist_debug), -1);\n"
"return backup_name || \'.ttl\';\n"
"}\n"
"else\n"
"{\n"
"if (exists (sparql define input:storage \"\" ask where { graph `iri(?:backup_name)` { ?s ?p ?o }}))\n"
"signal (\'22023\', sprintf (\'Can not backup RDF metadata into nonempty graph <%.300s>\', backup_name));\n"
"foreach (any triple in proplist) do\n"
"{\n"
"declare s,p,o any;\n"
"s := triple[0];\n"
"p := triple[1];\n"
"o := triple[2];\n"
"sparql insert into graph iri(?:backup_name) { ?:s ?:p ?:o };\n"
"}\n"
"commit work;\n"
"}\n"
"return backup_name;\n"
"}\n"
"--src sparql.sql:10160\n";

static const char *proc285 = 
"#line 10196 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_RESTORE_METADATA (in read_from_file integer, in backup_name varchar) returns any\n"
"{\n"
"declare graphiri_id IRI_ID;\n"
"declare proplist any;\n"
"if (read_from_file)\n"
"{\n"
"declare txt any;\n"
"txt := file_to_string (backup_name);\n"
"if (not (\"LEFT\" (txt, 23) = \'# RDF_BACKUP_METADATA #\'))\n"
"signal (\'22023\', sprintf (\'Can not restore RDF metadata from file %.300s: file does not start with signature \"# RDF_BACKUP_METADATA #\"\', backup_name));\n"
"proplist := dict_list_keys (DB.DBA.RDF_TTL2HASH (txt, \'\'), 1);\n"
"}\n"
"else\n"
"proplist := ((select DB.DBA.VECTOR_AGG (vector (\"sub\".\"s\", \"sub\".\"p\", \"sub\".\"o\")) from (\n"
"sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o where { graph `iri(?:backup_name)` { ?s ?p ?o } } ) as \"sub\"));\n"
"if (0 = length (proplist))\n"
"signal (\'22023\', sprintf (\'There are no metadata in %.200 to restore\', backup_name));\n"
"graphiri_id := iri_ensure (DB.DBA.JSO_SYS_GRAPH ());\n"
"sparql define input:storage \"\" clear graph ?:graphiri_id;\n"
"commit work;\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"commit work;\n"
"foreach (any triple in proplist) do\n"
"{\n"
"declare sl,pl,ol any;\n"
"sl := triple[0];\n"
"pl := triple[1];\n"
"ol := triple[2];\n"
"if (pl <> iri_ensure (\'http://www.openlinksw.com/schemas/virtrdf#status\'))\n"
"{\n"
"\n"
"sparql define input:storage \"\" insert into graph ?:graphiri_id { ?:sl ?:pl ?:ol };\n"
"}\n"
"}\n"
"commit work;\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"commit work;\n"
"return backup_name;\n"
"}\n"
"--src sparql.sql:10194\n";

static const char *proc286 = 
"#line 10238 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_AUDIT_METADATA (in fix_bugs integer := 0, in unlocker varchar := null, in graphiri varchar := null, in call_result_names integer := 1)\n"
"{\n"
"declare chksum varchar;\n"
"declare chksum_acc any;\n"
"declare STAT, MSG varchar;\n"
"declare graphiri_id IRI_ID;\n"
"declare all_lists, prev_list, prev_subj any;\n"
"if (call_result_names)\n"
"result_names (STAT, MSG);\n"
"if (graphiri is null)\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"else\n"
"{\n"
"if (graphiri <> DB.DBA.JSO_SYS_GRAPH ())\n"
"result (\'00000\', \'Note: non-default graph IRI <\' || graphiri || \'> is used\');\n"
"}\n"
"graphiri_id := iri_to_id (graphiri);\n"
"vectorbld_init (chksum_acc);\n"
"for (sparql define input:storage \"\"\n"
"select ?st ?trx where { graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx } } ) do\n"
"{\n"
"result (\'00000\', \'Quad storage <\' || \"st\" || \'> is flagged as being edited \' || cast (\"trx\" as varchar));\n"
"vectorbld_acc (chksum_acc, vector (\"st\", \"trx\"));\n"
"}\n"
"vectorbld_final (chksum_acc);\n"
"if (length (chksum_acc))\n"
"{\n"
"chksum := md5 (serialize (chksum_acc));\n"
"if ((fix_bugs = 0) or (unlocker is null) or ((chksum <> unlocker) and (unlocker <> \'*\')))\n"
"{\n"
"result (\'42000\', \'Can not process data that are being edited by someone else.\');\n"
"result (\'00000\', \'To force tests/bugfixing, pass 1 as first argument and either \'\'\' || chksum || \'\'\' or \'\'*\'\' as second argument of the DB.DBA.RDF_AUDIT_METADATA() call\');\n"
"return;\n"
"}\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx }\n"
"where { graph ?:graphiri_id {\n"
"?st virtrdf:qsAlterInProgress ?trx } };\n"
"}\n"
"if ((graphiri = DB.DBA.JSO_SYS_GRAPH ()) and fix_bugs)\n"
"{\n"
"declare txt1 varchar;\n"
"declare dict1, lst1 any;\n"
"result (\'00000\', \'Reloading built-in metadata, this might fix some errors without accurate reporting that they did exist\');\n"
"txt1 := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"dict1 := DB.DBA.RDF_TTL2HASH (txt1, \'\');\n"
"lst1 := dict_list_keys (dict1, 1);\n"
"foreach (any triple in lst1) do\n"
"{\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD) where G = graphiri_id and S = triple[0] and P = triple[1];\n"
"}\n"
"DB.DBA.RDF_INSERT_TRIPLES (graphiri_id, lst1);\n"
"commit work;\n"
"result (\'00000\', \'Built-in metadata were reloaded\');\n"
"if (fix_bugs > 1)\n"
"{\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:array-of-QuadMap } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 3) is null)\n"
"result (\'00000\', \'Quad map array <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMap } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (\"s\", 1) is null)\n"
"result (\'00000\', \'Quad map <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:array-of-QuadMapFormat } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 3) is null)\n"
"result (\'00000\', \'Quad map format array <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMapFormat } ) do\n"
"{\n"
"if (DB.DBA.RDF_QM_GC_SUBTREE (\"s\", 3) is null)\n"
"result (\'00000\', \'Quad map format <\' || \"s\" || \'> is not used, removed\');\n"
"}\n"
"}\n"
"}\n"
"for (select * from (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?lst ?p ?itm where { graph ?:graphiri_id {\n"
"?lst ?p ?itm .\n"
"optional { ?itm a ?t } .\n"
"filter (! bound (?t) && isiri (?itm) && str(?p) > str(rdf:_) && str(?p) < str(rdf:_A))\n"
"} } ) as sub for update) do\n"
"{\n"
"result (\'00000\', \'List <\' || id_to_iri(\"lst\") || \'> contains IRI <\' || id_to_iri(\"itm\") || \'> that has no type\');\n"
"if (fix_bugs)\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id { ?:\"lst\" ?:\"p\" ?:\"itm\" };\n"
"}\n"
"}\n"
"vectorbld_init (all_lists);\n"
"prev_subj := #i0;\n"
"for (\n"
"select \"sub\".\"lst\", cast (\"sub\".\"idx\" as integer) as \"idx\", serialize (\"sub\".\"itm\") as \"itmsz\", \"sub\".\"itmstr\", \"sub\".\"itmislit\", \"sub\".\"t\"\n"
"from (sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?lst\n"
"(bif:aref (bif:sprintf_inverse (str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"), 2 ),\n"
"0 ) ) as ?idx\n"
"?itm\n"
"(str(?itm)) as ?itmstr\n"
"(isliteral(?itm)) as ?itmislit\n"
"?t\n"
"where { graph ?:graphiri_id {\n"
"?lst ?p ?itm .\n"
"optional { ?itm a ?t } .\n"
"filter (\n"
"str(?p) > str(rdf:_) && str(?p) < str(rdf:_A))\n"
"} } ) as \"sub\"\n"
"order by 1, 2, 3, 4 ) do\n"
"{\n"
"if (prev_subj <> \"lst\")\n"
"{\n"
"if (prev_subj <> #i0)\n"
"{\n"
"vectorbld_final (prev_list);\n"
"vectorbld_acc (all_lists, vector (prev_subj, prev_list));\n"
"}\n"
"prev_subj := \"lst\";\n"
"vectorbld_init (prev_list);\n"
"}\n"
"vectorbld_acc (prev_list, vector (\"idx\", deserialize(\"itmsz\"), \"itmstr\", \"itmislit\", \"t\"));\n"
"}\n"
"if (prev_subj <> #i0)\n"
"{\n"
"vectorbld_final (prev_list);\n"
"vectorbld_acc (all_lists, vector (prev_subj, prev_list));\n"
"}\n"
"vectorbld_final (all_lists);\n"
"foreach (any pair in all_lists) do\n"
"{\n"
"declare subj, items any;\n"
"declare pos, len, last_idx, list_needs_rebuild integer;\n"
"list_needs_rebuild := 0;\n"
"last_idx := 0;\n"
"subj := pair[0];\n"
"items := pair[1];\n"
"len := length (items);\n"
"last_idx := 0;\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"curr_idx := items[pos][0];\n"
"if (curr_idx <= last_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Item rdf:_%d is out of order in list <%s>\', curr_idx, id_to_iri (subj)));\n"
"list_needs_rebuild := 1;\n"
"}\n"
"else if ((last_idx + 3) < curr_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Items rdf:_%d to rdf:_%d are not set in list <%s>\', last_idx + 1, curr_idx - 1, id_to_iri (subj)));\n"
"list_needs_rebuild := 1;\n"
"}\n"
"else\n"
"{\n"
"while ((last_idx + 1) < curr_idx)\n"
"{\n"
"result (\'42000\', sprintf (\'Item rdf:_%d is not set in list <%s>\', last_idx + 1, id_to_iri (subj)));\n"
"last_idx := last_idx + 1;\n"
"list_needs_rebuild := 1;\n"
"}\n"
"}\n"
"last_idx := curr_idx;\n"
"}\n"
"if (fix_bugs and list_needs_rebuild)\n"
"{\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"curr_idx := items[pos][0];\n"
"sparql define input:storage \"\"\n"
"delete from graph ?:graphiri_id {\n"
"`iri(?:subj)` ?p ?o }\n"
"where { graph ?:graphiri_id {\n"
"`iri(?:subj)` ?p ?o .\n"
"filter (?p = iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:curr_idx))) } };\n"
"}\n"
"for (pos := 0; pos < len; pos := pos+1)\n"
"{\n"
"declare curr_idx integer;\n"
"declare obj any;\n"
"declare objstr varchar;\n"
"declare objislit integer;\n"
"curr_idx := items[pos][0];\n"
"obj := items[pos][1];\n"
"objstr := items[pos][2];\n"
"objislit := items[pos][3];\n"
"if (objislit)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert into graph ?:graphiri_id {\n"
"`iri(?:subj)` `iri (bif:sprintf (\"%s%d\", str (rdf:_), 1 + ?:pos))` ?:obj };\n"
"}\n"
"else\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert into graph ?:graphiri_id {\n"
"`iri(?:subj)` `iri (bif:sprintf (\"%s%d\", str (rdf:_), 1 + ?:pos))` `iri(?:objstr)` };\n"
"}\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"if ((graphiri = DB.DBA.JSO_SYS_GRAPH ()) and fix_bugs)\n"
"{\n"
"whenever sqlstate \'*\' goto jso_load_failed;\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"result (\'00000\', \'Metadata from system graph are cached in memory-resident JSOs (JavaScript Objects)\');\n"
"return;\n"
"}\n"
"return;\n"
"\n"
"jso_load_failed:\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"result (\'42000\', \'The previous error can not be fixed automatically. Sorry.\');\n"
"return;\n"
"}\n"
"--src sparql.sql:10236\n";

static const char *proc287 = 
"#line 10477 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_CHANGE (in warninglist any)\n"
"{\n"
"declare STATE, MESSAGE varchar;\n"
"result_names (STATE, MESSAGE);\n"
"foreach (any warnings in warninglist) do\n"
"{\n"
"foreach (any warning in warnings) do\n"
"result (warning[0], warning[1]);\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:10475\n";

static const char *proc288 = 
"#line 10490 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_CHANGE_OPT (in cmdlist any)\n"
"{\n"
"declare cmdctr, cmdcount integer;\n"
"declare eaqs varchar;\n"
"declare STATE, MESSAGE varchar;\n"
"cmdcount := length (cmdlist);\n"
"result_names (STATE, MESSAGE);\n"
"eaqs := \'\';\n"
"for (cmdctr := 0; cmdctr < cmdcount; cmdctr := cmdctr + 1)\n"
"{\n"
"declare cmd, exectext, arglist, warnings,md,rs any;\n"
"declare argctr, argcount integer;\n"
"cmd := cmdlist[cmdctr];\n"
"exectext := string_output();\n"
"http (\'select \', exectext);\n"
"http_value (cmd[0], 0, exectext);\n"
"http (\' (\', exectext);\n"
"if (length (cmd) > 2)\n"
"arglist := vector_concat (cmd[1], vector (cmd[2]));\n"
"else\n"
"arglist := cmd[1];\n"
"argcount := length (arglist);\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"if (argctr > 0)\n"
"http (\',\', exectext);\n"
"http (\'?\', exectext);\n"
"}\n"
"http (\')\', exectext);\n"
"STATE := \'00000\';\n"
"warnings := exec (string_output_string (exectext), STATE, MESSAGE, arglist, 10000, md, rs);\n"
"\n"
"if (__tag of vector <> __tag (warnings) and __tag of vector = __tag (rs))\n"
"warnings := case (length (rs)) when 0 then null else rs[0][0] end;\n"
"\n"
"if (__tag of vector = __tag (warnings))\n"
"{\n"
"foreach (any warning in warnings) do\n"
"result (warning[0], warning[1]);\n"
"}\n"
"commit work;\n"
"if (STATE <> \'00000\')\n"
"{\n"
"result (STATE, MESSAGE);\n"
"if (\'\' <> eaqs)\n"
"exec (\'DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE (?)\', STATE, MESSAGE, vector (eaqs));\n"
"DB.DBA.RDF_AUDIT_METADATA (1, null, null, 0);\n"
"return;\n"
"}\n"
"if (UNAME\'DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE\' = cmd[0])\n"
"eaqs := arglist[0];\n"
"else if (UNAME\'DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE\' = cmd[0])\n"
"eaqs := \'\';\n"
"}\n"
"result (\'00000\', sprintf (\'%d RDF metadata manipulation operations done\', cmdcount));\n"
"}\n"
"--src sparql.sql:10488\n";

static const char *proc289 = 
"#line 10548 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_APPLY_CHANGES (in deleted any, in affected any) returns any\n"
"{\n"
"declare ctr, len integer;\n"
"commit work;\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"len := length (deleted);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"jso_delete (deleted [ctr], deleted [ctr+1], 1);\n"
"log_text (\'jso_delete (?,?,1)\', deleted [ctr], deleted [ctr+1]);\n"
"}\n"
"len := length (affected);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 1)\n"
"{\n"
"jso_mark_affected (affected [ctr]);\n"
"log_text (\'jso_mark_affected (?)\', affected [ctr]);\n"
"}\n"
"return vector (vector (\'00000\', \'Transaction committed, SPARQL compiler re-configured\'));\n"
"}\n"
"--src sparql.sql:10546\n";

static const char *proc290 = 
"#line 10569 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_ASSERT_JSO_TYPE (in inst varchar, in expected varchar, in allow_missing integer := 0) returns integer\n"
"{\n"
"declare actual varchar;\n"
"if (expected is null)\n"
"{\n"
"actual := coalesce ((sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:inst)` rdf:type ?t } } ));\n"
"if (actual is not null)\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> already exists, type <\' || cast (actual as varchar) || \'>\');\n"
"}\n"
"else\n"
"{\n"
"declare hit integer;\n"
"hit := 0;\n"
"for (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:inst)` rdf:type ?t } } ) do\n"
"{\n"
"if (\"t\" <> expected)\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> has type <\' || cast (actual as varchar) || \'>, cannot use same identifier for <\' || expected || \'>\');\n"
"hit := 1;\n"
"}\n"
"if (not hit)\n"
"{\n"
"if (allow_missing)\n"
"return 0;\n"
"signal (\'22023\', \'The RDF QM schema object <\' || inst || \'> does not exist, should be of type <\' || expected || \'>\');\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:10567\n";

static const char *proc291 = 
"#line 10607 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (in storage varchar, in req_flag integer)\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, \'http://www.openlinksw.com/schemas/virtrdf#QuadStorage\');\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?startdt where {\n"
"graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?startdt .\n"
"} } ) do\n"
"{\n"
"if (req_flag)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" is edited by other client, started \' || cast (\"startdt\" as varchar));\n"
"}\n"
"if (not req_flag)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" is not flagged as being edited, cannot change it\' );\n"
"}\n"
"--src sparql.sql:10605\n";

static const char *proc292 = 
"#line 10629 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (in storage varchar, in qmid varchar, in must_contain integer)\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (exists (sparql define input:storage \"\"\n"
"ask where {\n"
"graph ?:graphiri {\n"
"{ `iri(?:storage)` virtrdf:qsDefaultMap `iri(?:qmid)` }\n"
"union\n"
"{ `iri(?:storage)` virtrdf:qsUserMaps ?qmlist .\n"
"?qmlist ?p `iri(?:qmid)` .\n"
"} } } ) )\n"
"{\n"
"if (must_contain)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" contains quad map \' || qmid );\n"
"}\n"
"if (not must_contain)\n"
"return;\n"
"signal (\'22023\', \'The quad storage \"\' || storage || \'\" does not contains quad map \' || qmid );\n"
"}\n"
"--src sparql.sql:10627\n";

static const char *proc293 = 
"#line 10652 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_GC_SUBTREE (in seed any, in gc_flags integer := 0) returns integer\n"
"{\n"
"declare graphiri varchar;\n"
"declare seed_id, graphiri_id, subjs, objs any;\n"
"declare o_to_s, s_to_o any;\n"
"declare subjs_of_o, objs_of_s any;\n"
"set isolation = \'serializable\';\n"
"\n"
"o_to_s := dict_new ();\n"
"s_to_o := dict_new ();\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"graphiri_id := iri_to_id (graphiri);\n"
"seed_id := iri_to_id (seed);\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?s\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s virtrdf:item ?:seed_id } ) do\n"
"{\n"
"\n"
"return \"s\";\n"
"}\n"
"if (not bit_and (gc_flags, 2))\n"
"{\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?t ?n\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?:seed_id a ?t . ?t virtrdf:isGcResistantType ?n } ) do\n"
"{\n"
"\n"
"return \"t\";\n"
"}\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"select ?s\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s a [] ; ?p ?:seed_id } ) do\n"
"{\n"
"\n"
"if (bit_and (gc_flags, 1))\n"
"return \"s\";\n"
"goto do_full_gc;\n"
"}\n"
"vectorbld_init (objs_of_s);\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"define sql:table-option \"LOOP\"\n"
"select ?o\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?:seed_id a [] ; ?p ?o . ?o a [] } ) do\n"
"{\n"
"vectorbld_acc (objs_of_s, \"o\");\n"
"}\n"
"vectorbld_final (objs_of_s);\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = graphiri_id and S = seed_id;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s virtrdf:isSubClassOf ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s virtrdf:isSubClassOf ?o . filter (?o = iri(?:seed_id)) };\n"
"\n"
"commit work;\n"
"foreach (IRI_ID descendant in objs_of_s) do\n"
"{\n"
"DB.DBA.RDF_QM_GC_SUBTREE (descendant, 1);\n"
"}\n"
"\n"
"return null;\n"
"\n"
"do_full_gc:\n"
"for (sparql define input:storage \"\"\n"
"define output:valmode \"LONG\"\n"
"define sql:table-option \"LOOP\"\n"
"select ?s ?o\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s a [] ; ?p ?o . ?o a [] } ) do\n"
"{\n"
"\n"
"subjs_of_o := dict_get (o_to_s, \"o\", NULL);\n"
"if (subjs_of_o is null)\n"
"dict_put (o_to_s, \"o\", vector (\"s\"));\n"
"else if (0 >= position (\"s\", subjs_of_o))\n"
"dict_put (o_to_s, \"o\", vector_concat (vector (\"s\"), subjs_of_o));\n"
"objs_of_s := dict_get (s_to_o, \"s\", NULL);\n"
"if (objs_of_s is null)\n"
"dict_put (s_to_o, \"s\", vector (\"o\"));\n"
"else if (0 >= position (\"o\", objs_of_s))\n"
"dict_put (s_to_o, \"s\", vector_concat (vector (\"o\"), objs_of_s));\n"
"}\n"
"subjs := vector (seed_id);\n"
"again:\n"
"vectorbld_init (objs);\n"
"foreach (IRI_ID nod in subjs) do\n"
"{\n"
"\n"
"declare subjs_of_nod, objs_of_nod any;\n"
"subjs_of_nod := dict_get (o_to_s, nod, NULL);\n"
"if (subjs_of_nod is not null)\n"
"{\n"
"\n"
"if (nod = seed_id)\n"
"return subjs_of_nod[0];\n"
"goto nop_nod;\n"
"}\n"
"\n"
"\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = graphiri_id and S = nod;\n"
"objs_of_nod := dict_get (s_to_o, nod, NULL);\n"
"dict_remove (s_to_o, nod);\n"
"foreach (IRI_ID sub in objs_of_nod) do\n"
"{\n"
"declare subjs_of_sub any;\n"
"declare nod_pos integer;\n"
"subjs_of_sub := dict_get (o_to_s, sub, NULL);\n"
"nod_pos := position (nod, subjs_of_sub);\n"
"if (0 < nod_pos)\n"
"subjs_of_sub := vector_concat (subseq (subjs_of_sub, 0, nod_pos - 1), subseq (subjs_of_sub, nod_pos));\n"
"if (0 = length (subjs_of_sub))\n"
"{\n"
"\n"
"dict_remove (o_to_s, sub);\n"
"vectorbld_acc (objs, sub);\n"
"}\n"
"else\n"
"{\n"
"dict_put (o_to_s, sub, subjs_of_sub);\n"
"\n"
"}\n"
"}\n"
"nop_nod: ;\n"
"}\n"
"vectorbld_final (objs);\n"
"if (0 < length (objs))\n"
"{\n"
"\n"
"subjs := objs;\n"
"goto again;\n"
"}\n"
"\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:10650\n";

static const char *proc294 = 
"#line 10799 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (in mapname any, in gc_flags integer) returns any\n"
"{\n"
"declare gc_res, submaps any;\n"
"submaps := (select DB.DBA.VECTOR_AGG (s1.\"subm\") from (\n"
"sparql define input:storage \"\"\n"
"select ?subm where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:mapname)` virtrdf:qmUserSubMaps ?submlist .\n"
"?submlist ?p ?subm . filter (?p != rdf:type) . ?subm a [] } } ) as s1 );\n"
"gc_res := DB.DBA.RDF_QM_GC_SUBTREE (mapname, gc_flags);\n"
"if (gc_res is not null)\n"
"return gc_res;\n"
"commit work;\n"
"foreach (any submapname in submaps) do\n"
"{\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (submapname, gc_flags);\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:10797\n";

static const char *proc295 = 
"#line 10820 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DROP_MAPPING (in storage varchar, in mapname any) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare qmid, qmgraph varchar;\n"
"declare silent integer;\n"
"qmid := get_keyword_ucase (\'ID\', mapname, NULL);\n"
"qmgraph := get_keyword_ucase (\'GRAPH\', mapname, NULL);\n"
"silent := get_keyword_ucase (\'SILENT\', mapname, 0);\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmid is null)\n"
"{\n"
"qmid := coalesce ((sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s from <http://www.openlinksw.com/schemas/virtrdf#> where {\n"
"?s rdf:type virtrdf:QuadMap .\n"
"?s virtrdf:qmGraphRange-rvrFixedValue `iri(?:qmgraph)` .\n"
"?s virtrdf:qmTableName \"\" .\n"
"} ));\n"
"if (qmid is null)\n"
"return vector (vector (\'00100\', \'Quad map for graph <\' || qmgraph || \'> is not found\'));\n"
"}\n"
"else\n"
"{\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:qmid)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"}\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"if (storage is null)\n"
"{\n"
"declare report, storages any;\n"
"vectorbld_init (storages);\n"
"for (sparql\n"
"define input:storage \"\"\n"
"select ?st where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"{ ?st virtrdf:qsUserMaps ?subm .\n"
"?subm ?p `iri(?:qmid)` }\n"
"union\n"
"{ ?st virtrdf:qsDefaultMap `iri(?:qmid)` }\n"
"} } ) do\n"
"{\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (\"st\", 0);\n"
"vectorbld_acc (storages, cast (\"st\" as varchar));\n"
"}\n"
"vectorbld_final (storages);\n"
"vectorbld_init (report);\n"
"foreach (varchar alt_st in storages) do\n"
"{\n"
"\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (alt_st, NULL, qmid);\n"
"vectorbld_acc (report, vector (\'00000\', \'Quad map <\' || qmid || \'> is no longer used in storage <\' || alt_st || \'>\'));\n"
"}\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (qmid, 0);\n"
"vectorbld_acc (report, vector (\'00000\', \'Quad map <\' || qmid || \'> is deleted\'));\n"
"vectorbld_final (report);\n"
"if (length (storages))\n"
"report := vector_concat (report, DB.DBA.RDF_QM_APPLY_CHANGES (null, storages));\n"
"return report;\n"
"}\n"
"else\n"
"{\n"
"if (not exists (sparql\n"
"define input:storage \"\"\n"
"select ?st where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"{ ?st virtrdf:qsUserMaps ?subm .\n"
"?subm ?p `iri(?:qmid)` }\n"
"union\n"
"{ ?st virtrdf:qsDefaultMap `iri(?:qmid)` }\n"
"filter (?st = iri(?:storage))\n"
"} } ) )\n"
"{\n"
"if (silent)\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is not used in storage <\' || storage || \'>, the DROP statement is ignored due to SILENT option\'));\n"
"signal (\'22023\', \'Quad map <\' || qmid || \'> is not used in storage <\' || storage || \'>\');\n"
"}\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (storage, NULL, qmid);\n"
"DB.DBA.RDF_QM_GC_MAPPING_SUBTREE (qmid, 1);\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is no longer used in storage <\' || storage || \'>\'));\n"
"}\n"
"}\n"
"--src sparql.sql:10818\n";

static const char *proc296 = 
"#line 10908 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (in iritmpl varchar) returns varchar\n"
"{\n"
"declare pos integer;\n"
"pos := strstr (iritmpl, \'^{URIQADefaultHost}^\');\n"
"if (pos is not null)\n"
"{\n"
"declare host varchar;\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"if (not isstring (host))\n"
"signal (\'22023\', \'Can not use ^{URIQADefaultHost}^ in IRI template if there is no DefaultHost parameter in [URIQA] section of Virtuoso configuration file\');\n"
"iritmpl := replace (iritmpl, \'^{URIQADefaultHost}^\', host);\n"
"}\n"
"pos := strstr (iritmpl, \'^{DynamicLocalFormat}^\');\n"
"if (pos is not null)\n"
"{\n"
"declare host varchar;\n"
"host := registry_get (\'URIQADefaultHost\');\n"
"if (not isstring (host))\n"
"signal (\'22023\', \'Can not use ^{DynamicLocalFormat}^ in IRI template if there is no DefaultHost parameter in [URIQA] section of Virtuoso configuration file\');\n"
"\n"
"\n"
"if ((pos > 0) and (pos < 10) and strchr (subseq (iritmpl, 0, pos), \':\') is not null)\n"
"signal (\'22023\', \'Misplaced ^{DynamicLocalFormat}^: its expansion will contain protocol prefix but the template contains one already\');\n"
"if (strchr (host, \':\') is not null)\n"
"iritmpl := replace (iritmpl, \'^{DynamicLocalFormat}^\', \'http://%{WSHostName}U:%{WSHostPort}U\');\n"
"else\n"
"iritmpl := replace (iritmpl, \'^{DynamicLocalFormat}^\', \'http://%{WSHost}U\');\n"
"}\n"
"pos := strstr (iritmpl, \'^{\');\n"
"if (pos is not null)\n"
"{\n"
"declare pos2 integer;\n"
"pos2 := strstr (subseq (iritmpl, pos), \'^}\');\n"
"if (pos2 is not null)\n"
"signal (\'22023\', \'The macro \' || subseq (iritmpl, pos, pos + pos2 + 2) || \' is not known, supported names are ^{URIQADefaultHost}^ and ^{DynamicLocalFormat}^\');\n"
"}\n"
"return iritmpl;\n"
"}\n"
"--src sparql.sql:10906\n";

static const char *proc297 = 
"#line 10948 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_CBD_OF_IRI_CLASS (in classiri varchar) returns any\n"
"{\n"
"declare descr any;\n"
"descr := ((sparql define input:storage \"\"\n"
"construct {\n"
"<class> ?cp ?co .\n"
"<class> virtrdf:qmfValRange-rvrSprintffs <sprintffs> .\n"
"<sprintffs> ?sffp ?sffo .\n"
"<class> virtrdf:qmfSuperFormats <sups> .\n"
"<sups> ?supp ?supo . }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where {\n"
"{\n"
"`iri(?:classiri)` ?cp ?co .\n"
"filter (!(?cp in (virtrdf:qmfValRange-rvrSprintffs, virtrdf:qmfSuperFormats)))\n"
"} union {\n"
"`iri(?:classiri)` virtrdf:qmfValRange-rvrSprintffs ?sffs .\n"
"optional { ?sffs ?sffp ?sffo . }\n"
"} union {\n"
"`iri(?:classiri)` virtrdf:qmfSuperFormats ?sups .\n"
"optional { ?sups ?supp ?supo . FILTER (str(?supo) != bif:concat (str(?:classiri), \'-nullable\')) }\n"
"} } ) );\n"
"descr := dict_list_keys (descr, 2);\n"
"rowvector_digit_sort (descr, 0, 1);\n"
"rowvector_digit_sort (descr, 1, 1);\n"
"return descr;\n"
"}\n"
"--src sparql.sql:10946\n";

static const char *proc298 = 
"#line 10977 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (in classiri varchar, in iritmpl varchar, in arglist any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare sprintffsid, superformatsid, nullablesuperformatid varchar;\n"
"declare basetype, basetypeiri varchar;\n"
"declare bij, deref integer;\n"
"declare sffs, res any;\n"
"declare argctr, arglist_len, isnotnull, sff_ctr, sff_count, bij_sff_count integer;\n"
"declare needs_arg_dtps integer;\n"
"declare arg_dtps varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (get_keyword_ucase (\'DATATYPE\', options) is not null or get_keyword_ucase (\'LANG\', options) is not null)\n"
"signal (\'22023\', \'IRI class <\' || classiri || \'> can not have DATATYPE or LANG options specified\');\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"sffs := get_keyword_ucase (\'RETURNS\', options);\n"
"if (sffs is null)\n"
"sffs := vector (iritmpl);\n"
"sff_count := length (sffs);\n"
"iritmpl := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (iritmpl);\n"
"sprintffsid := classiri || \'--Sprintffs\';\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"nullablesuperformatid := null;\n"
"res := vector ();\n"
"foreach (any arg in arglist) do\n"
"if (UNAME\'in\' <> arg[0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of class formats, \"\' || arg[0] || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'>\' );\n"
"arglist_len := length (arglist);\n"
"isnotnull := 1;\n"
"needs_arg_dtps := 0;\n"
"arg_dtps := \'\';\n"
"if (arglist_len <> 1)\n"
"{\n"
"declare type_name varchar;\n"
"declare dtp integer;\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-uri\';\n"
"else\n"
"basetype := \'multipart-uri\';\n"
"for (argctr := 0; (argctr < arglist_len) and isnotnull; argctr := argctr + 1)\n"
"{\n"
"if (not (coalesce (arglist[argctr][3], 0)))\n"
"isnotnull := 0;\n"
"type_name := lower (arglist[argctr][2]);\n"
"dtp := case (type_name)\n"
"when \'integer\' then __tag of integer\n"
"when \'varchar\' then __tag of varchar\n"
"when \'date\' then __tag of date\n"
"when \'datetime\' then __tag of datetime\n"
"when \'double precision\' then __tag of double precision\n"
"when \'numeric\' then __tag of numeric\n"
"when \'nvarchar\' then __tag of nvarchar\n"
"else 255 end;\n"
"if (type_name = \'nvarchar\')\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := arg_dtps || chr (bit_and (127, dtp));\n"
"}\n"
"}\n"
"else /* arglist is 1 item long */\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\', \'date\', /* \'datetime\', \'double precision\',*/ \'numeric\', \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'>\' );\n"
"basetype := \'sql-\' || replace (basetype, \' \', \'\') || \'-uri\';\n"
"if (not (coalesce (arglist[0][3], 0)))\n"
"isnotnull := 0;\n"
"if (basetype = \'nvarchar\')\n"
"{\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := chr (bit_and (127, __tag of nvarchar));\n"
"}\n"
"}\n"
"if (not isnotnull)\n"
"basetype := basetype || \'-nullable\';\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (origclassiri is null)\n"
"{\n"
"if (isnotnull and (arglist_len > 0))\n"
"{\n"
"declare arglist_copy any;\n"
"if (classiri like \'%-nullable\')\n"
"signal (\'22023\', \'The name of non-nullable IRI class in CREATE IRI CLASS <\' || classiri || \'> is misleading\' );\n"
"arglist_copy := arglist;\n"
"for (argctr := 0; (argctr < arglist_len); argctr := argctr + 1)\n"
"arglist_copy[argctr][3] := 0;\n"
"nullablesuperformatid := classiri || \'-nullable\';\n"
"res := vector_concat (res,\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (nullablesuperformatid, iritmpl, arglist_copy, options, NULL) );\n"
"}\n"
"origclassiri := classiri;\n"
"}\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri, 2);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (tmpname, iritmpl, arglist, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"\n"
"\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector_concat (res, vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> has been dropped\')));\n"
"}\n"
"else\n"
"res := vector ();\n"
"if (bij)\n"
"{\n"
"if (__sprintff_is_proven_unparseable (iritmpl))\n"
"signal (\'22023\', \'IRI class <\' || classiri || \'> has OPTION (BIJECTION) but its format string can not be unambiguously parsed by sprintf_inverse()\');\n"
"}\n"
"else\n"
"{\n"
"if (__sprintff_is_proven_bijection (iritmpl))\n"
"bij := 1;\n"
"}\n"
"bij_sff_count := 0;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:sprintffsid)) };\n"
"for (sff_ctr := 0; sff_ctr < sff_count; sff_ctr := sff_ctr + 1)\n"
"{\n"
"declare sff varchar;\n"
"sff := sffs [sff_ctr];\n"
"sff := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (sff);\n"
"if ((not bij) and __sprintff_is_proven_bijection (sff))\n"
"bij_sff_count := bij_sff_count + 1;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:sprintffsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:sff_ctr+1))` ?:sff };\n"
"}\n"
"if ((not bij) and (bij_sff_count = sff_count) and (bij_sff_count > 0))\n"
"bij := 1;\n"
"if (not needs_arg_dtps)\n"
"arg_dtps := NULL;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#>\n"
"{\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat ;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)`;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfCustomString1 ?:iritmpl ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfArgDtps ?:arg_dtps ;\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_IS_REF ,\n"
"virtrdf:SPART_VARR_IS_IRI ,\n"
"virtrdf:SPART_VARR_SPRINTFF ;\n"
"virtrdf:qmfValRange-rvrSprintffs `iri(?:sprintffsid)` ;\n"
"virtrdf:qmfValRange-rvrSprintffCount ?:sff_count .\n"
"`iri(?:sprintffsid)`\n"
"rdf:type virtrdf:array-of-string .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (isnotnull and (arglist_len > 0))\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_NOT_NULL .\n"
"`iri(?:superformatsid)`\n"
"rdf:_1 `iri(?:nullablesuperformatid)` };\n"
"}\n"
"commit work;\n"
"return vector_concat (res, vector_concat (res, vector (vector (\'00000\', \'IRI class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \')\'))));\n"
"}\n"
"--src sparql.sql:10975\n";

static const char *proc299 = 
"#line 11183 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS (in classiri varchar, in fheaders any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"/*\n"
"fheaders is, say,\n"
"vector ( \'\n"
"vector ( \'DB.DBA.RDF_DF_GRANTEE_ID_URI\' ,\n"
"vector (\n"
"vector ( 306,  \'id\' ,  \'integer\' ,  NULL ) ),  \'varchar\' ,  NULL ),\n"
"vector ( \'DB.DBA.RDF_DF_GRANTEE_ID_URI_INVERSE\' ,\n"
"vector (\n"
"vector ( 306,  \'id_iri\' ,  \'varchar\' ,  NULL ) ),  \'integer\' ,  NULL ) ) )\n"
"*/\n"
"declare uriprint any;\n"
"declare uriprintname, uriparsename varchar;\n"
"declare arglist_len, isnotnull integer;\n"
"declare graphiri varchar;\n"
"declare superformatsid, nullablesuperformatid varchar;\n"
"declare bij, deref integer;\n"
"declare sffs any;\n"
"declare res any;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"nullablesuperformatid := null;\n"
"if (get_keyword_ucase (\'DATATYPE\', options) is not null or get_keyword_ucase (\'LANG\', options) is not null)\n"
"signal (\'22023\', \'IRI class <\' || classiri || \'> can not have DATATYPE or LANG options specified\');\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"sffs := get_keyword_ucase (\'RETURNS\', options);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, NULL);\n"
"DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (fheaders, 1, 0, \'IRI composing\', \'IRI parsing\', bij, deref);\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"declare arglist, basetype, basetypeiri varchar;\n"
"arglist := uriprint[1];\n"
"arglist_len := length (arglist);\n"
"if (arglist_len <> 1)\n"
"{\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-uri-fn-nullable\';\n"
"else\n"
"basetype := \'multipart-uri-fn-nullable\';\n"
"isnotnull := 0;\n"
"}\n"
"else\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\', \'date\', \'datetime\', \'double precision\', \'numeric\', \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'> USING FUNCTION\' );\n"
"basetype := \'sql-\' || replace (basetype, \' \', \'\') || \'-uri-fn\';\n"
"if (coalesce (arglist[0][3], 0))\n"
"isnotnull := 1;\n"
"else\n"
"{\n"
"basetype := basetype || \'-nullable\';\n"
"isnotnull := 0;\n"
"}\n"
"}\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (origclassiri is null)\n"
"origclassiri := classiri;\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri, 2);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS (tmpname, fheaders, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"else\n"
"res := vector ();\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)`;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfCustomString1 ?:uriprintname ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_IS_REF ,\n"
"virtrdf:SPART_VARR_IS_IRI ,\n"
"virtrdf:SPART_VARR_IRI_CALC .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (isnotnull)\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_NOT_NULL };\n"
"}\n"
"if (sffs is not null)\n"
"{\n"
"declare sff_count, sff_ctr integer;\n"
"declare sffsid varchar;\n"
"sffsid := classiri || \'--Sprintffs\';\n"
"sff_count := length (sffs);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:sffsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions\n"
"virtrdf:SPART_VARR_SPRINTFF ;\n"
"virtrdf:qmfValRange-rvrSprintffs `iri(?:sffsid)` ;\n"
"virtrdf:qmfValRange-rvrSprintffCount ?:sff_count .\n"
"`iri(?:sffsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"for (sff_ctr := 0; sff_ctr < sff_count; sff_ctr := sff_ctr + 1)\n"
"{\n"
"declare sff varchar;\n"
"sff := sffs [sff_ctr];\n"
"sff := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (sff);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:sffsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:sff_ctr+1))` ?:sff };\n"
"}\n"
"}\n"
"commit work;\n"
"return vector_concat (res, vector (vector (\'00000\', \'IRI class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \') using \' || uriprintname)));\n"
"}\n"
"--src sparql.sql:11181\n";

static const char *proc300 = 
"#line 11348 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FORMAT (in classiri varchar, in iritmpl varchar, in arglist any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare sprintffsid, superformatsid, nullablesuperformatid varchar;\n"
"declare basetype, basetypeiri varchar;\n"
"declare const_dt, dt_expn, const_lang varchar;\n"
"declare bij, deref integer;\n"
"declare sffs, res any;\n"
"declare argctr, arglist_len, isnotnull, sff_ctr, sff_count, bij_sff_count integer;\n"
"declare needs_arg_dtps integer;\n"
"declare arg_dtps varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"const_dt := get_keyword_ucase (\'DATATYPE\', options);\n"
"const_lang := get_keyword_ucase (\'LANG\', options);\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"sffs := get_keyword_ucase (\'RETURNS\', options);\n"
"if (sffs is null)\n"
"sffs := vector (iritmpl);\n"
"sff_count := length (sffs);\n"
"iritmpl := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (iritmpl);\n"
"sprintffsid := classiri || \'--Sprintffs\';\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"nullablesuperformatid := null;\n"
"res := vector ();\n"
"foreach (any arg in arglist) do\n"
"if (UNAME\'in\' <> arg[0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of class formats, \"\' || arg[0] || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'>\' );\n"
"arglist_len := length (arglist);\n"
"isnotnull := 1;\n"
"needs_arg_dtps := 0;\n"
"arg_dtps := \'\';\n"
"if (arglist_len <> 1)\n"
"{\n"
"declare type_name varchar;\n"
"declare dtp integer;\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-literal\';\n"
"else\n"
"basetype := \'multipart-literal\';\n"
"for (argctr := 0; (argctr < arglist_len) and isnotnull; argctr := argctr + 1)\n"
"{\n"
"if (not (coalesce (arglist[argctr][3], 0)))\n"
"isnotnull := 0;\n"
"type_name := lower (arglist[argctr][2]);\n"
"dtp := case (type_name)\n"
"when \'integer\' then __tag of integer\n"
"when \'varchar\' then __tag of varchar\n"
"when \'date\' then __tag of date\n"
"when \'datetime\' then __tag of datetime\n"
"when \'double precision\' then __tag of double precision\n"
"when \'numeric\' then __tag of numeric\n"
"when \'nvarchar\' then __tag of nvarchar\n"
"else 255 end;\n"
"if (type_name = \'nvarchar\')\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := arg_dtps || chr (bit_and (127, dtp));\n"
"}\n"
"}\n"
"else /* arglist is 1 item long */\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\', \'date\', \'datetime\', \'double precision\', \'numeric\', \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE LITERAL CLASS <\' || classiri || \'>\' );\n"
"basetype := \'sql-\' || replace (basetype, \' \', \'\') || \'-literal\';\n"
"if (not (coalesce (arglist[0][3], 0)))\n"
"isnotnull := 0;\n"
"if (basetype = \'nvarchar\')\n"
"{\n"
"needs_arg_dtps := 1;\n"
"arg_dtps := chr (bit_and (127, __tag of nvarchar));\n"
"}\n"
"}\n"
"if (not isnotnull)\n"
"basetype := basetype || \'-nullable\';\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (const_dt is not null)\n"
"dt_expn := \' \' || WS.WS.STR_SQL_APOS (const_dt);\n"
"else\n"
"dt_expn := NULL;\n"
"if (origclassiri is null)\n"
"{\n"
"if (isnotnull and (arglist_len > 0))\n"
"{\n"
"declare arglist_copy any;\n"
"if (classiri like \'%-nullable\')\n"
"signal (\'22023\', \'The name of non-nullable literal class in CREATE LITERAL CLASS <\' || classiri || \'> is misleading\' );\n"
"arglist_copy := arglist;\n"
"for (argctr := 0; (argctr < arglist_len); argctr := argctr + 1)\n"
"arglist_copy[argctr][3] := 0;\n"
"nullablesuperformatid := classiri || \'-nullable\';\n"
"res := vector_concat (res,\n"
"DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT (nullablesuperformatid, iritmpl, arglist_copy, options, NULL) );\n"
"}\n"
"origclassiri := classiri;\n"
"}\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri, 2);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change literal class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FORMAT (tmpname, iritmpl, arglist, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of literal class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector_concat (res, vector (vector (\'00000\', \'Previous definition of IRI class <\' || classiri || \'> has been dropped\')));\n"
"}\n"
"else\n"
"res := vector ();\n"
"if (bij)\n"
"{\n"
"if (__sprintff_is_proven_unparseable (iritmpl))\n"
"signal (\'22023\', \'Literal class <\' || classiri || \'> has OPTION (BIJECTION) but its format string can not be unambiguously parsed by sprintf_inverse()\');\n"
"}\n"
"else\n"
"{\n"
"if (__sprintff_is_proven_bijection (iritmpl))\n"
"bij := 1;\n"
"}\n"
"bij_sff_count := 0;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:sprintffsid)) };\n"
"for (sff_ctr := 0; sff_ctr < sff_count; sff_ctr := sff_ctr + 1)\n"
"{\n"
"declare sff varchar;\n"
"sff := sffs [sff_ctr];\n"
"sff := DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE (sff);\n"
"if ((not bij) and __sprintff_is_proven_bijection (sff))\n"
"bij_sff_count := bij_sff_count + 1;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:sprintffsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:sff_ctr+1))` ?:sff };\n"
"}\n"
"if ((not bij) and (bij_sff_count = sff_count) and (bij_sff_count > 0))\n"
"bij := 1;\n"
"if (not needs_arg_dtps)\n"
"arg_dtps := NULL;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#>\n"
"{\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat ;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)`;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfCustomString1 ?:iritmpl ;\n"
"virtrdf:qmfDatatypeOfShortTmpl ?:dt_expn ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfArgDtps ?:arg_dtps ;\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_IS_LIT, virtrdf:SPART_VARR_IRI_CALC;\n"
"virtrdf:qmfValRange-rvrDatatype ?:const_dt ;\n"
"virtrdf:qmfValRange-rvrLanguage ?:const_lang ;\n"
"virtrdf:qmfValRange-rvrSprintffs `iri(?:sprintffsid)` ;\n"
"virtrdf:qmfValRange-rvrSprintffCount ?:sff_count .\n"
"`iri(?:sprintffsid)`\n"
"rdf:type virtrdf:array-of-string .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (const_dt is not null)\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_TYPED };\n"
"}\n"
"commit work;\n"
"return vector_concat (res, vector_concat (res, vector (vector (\'00000\', \'Literal class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \')\'))));\n"
"}\n"
"--src sparql.sql:11346\n";

static const char *proc301 = 
"#line 11554 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS (in classiri varchar, in fheaders any, in options any, in origclassiri varchar := null) returns any\n"
"{\n"
"/*\n"
"fheaders is identical to DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS\n"
"*/\n"
"declare uriprint any;\n"
"declare uriprintname, uriparsename varchar;\n"
"declare arglist_len integer;\n"
"declare superformatsid, nullablesuperformatid varchar;\n"
"declare res any;\n"
"declare const_dt, dt_expn, const_lang varchar;\n"
"declare bij, deref integer;\n"
"superformatsid := classiri || \'--SuperFormats\';\n"
"nullablesuperformatid := null;\n"
"const_dt := get_keyword_ucase (\'DATATYPE\', options);\n"
"const_lang := get_keyword_ucase (\'LANG\', options);\n"
"bij := get_keyword_ucase (\'BIJECTION\', options, 0);\n"
"deref := get_keyword_ucase (\'DEREF\', options, 0);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, NULL);\n"
"DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (fheaders, 0, 0, \'LITERAL composing\', \'LITERAL parsing\', bij, deref);\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"declare arglist, basetype, basetypeiri varchar;\n"
"arglist := uriprint[1];\n"
"arglist_len := length (arglist);\n"
"if (arglist_len <> 1)\n"
"{\n"
"if (arglist_len = 0)\n"
"basetype := \'zeropart-literal-fn-nullable\';\n"
"else\n"
"basetype := \'multipart-literal-fn-nullable\';\n"
"}\n"
"else\n"
"{\n"
"basetype := lower (arglist[0][2]);\n"
"if (not (basetype in (\'integer\', \'varchar\' /*, \'date\', \'double precision\'*/, \'nvarchar\')))\n"
"signal (\'22023\', \'The datatype \"\' || basetype || \'\" is not supported in CREATE IRI CLASS <\' || classiri || \'> USING FUNCTION\' );\n"
"basetype := \'sql-\' || replace (basetype, \' \', \'\') || \'-literal-fn\';\n"
"if (not (coalesce (arglist[0][3], 0)))\n"
"basetype := basetype || \'-nullable\';\n"
"}\n"
"basetypeiri := \'http://www.openlinksw.com/virtrdf-data-formats#\' || basetype;\n"
"if (const_dt is not null)\n"
"dt_expn := \' \' || WS.WS.STR_SQL_APOS (const_dt);\n"
"else\n"
"dt_expn := NULL;\n"
"if (origclassiri is null)\n"
"origclassiri := classiri;\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri, 2);\n"
"if (side_s is not null)\n"
"{\n"
"declare tmpname varchar;\n"
"declare old_descr, new_descr any;\n"
"tmpname := uuid();\n"
"{ declare exit handler for sqlstate \'*\' {\n"
"signal (\'22023\', \'Can not change IRI class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>; moreover, the new declaration may be invalid.\'); };\n"
"DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS (tmpname, fheaders, options, classiri);\n"
"}\n"
"old_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(classiri);\n"
"new_descr := DB.DBA.RDF_QM_CBD_OF_IRI_CLASS(tmpname);\n"
"if (md5 (serialize (old_descr)) = md5 (serialize (new_descr)))\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#>  { `iri(?:tmpname)` ?p ?o }\n"
"where { `iri(?:tmpname)` ?p ?o };\n"
"return vector (vector (\'00000\', \'Previous definition of literal class <\' || classiri || \'> is identical to the new one, not touched\'));\n"
"}\n"
"signal (\'22023\', \'Can not change class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"res := vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"else\n"
"res := vector ();\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:classiri)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:superformatsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"rdf:type virtrdf:QuadMapFormat ;\n"
"virtrdf:inheritFrom `iri(?:basetypeiri)` ;\n"
"virtrdf:noInherit virtrdf:qmfName ;\n"
"virtrdf:noInherit virtrdf:qmfCustomString1 ;\n"
"virtrdf:qmfName `bif:concat (?:basetype, \'-user-\', ?:origclassiri)` ;\n"
"virtrdf:qmfColumnCount ?:arglist_len ;\n"
"virtrdf:qmfCustomString1 ?:uriprintname ;\n"
"virtrdf:qmfDatatypeOfShortTmpl ?:dt_expn ;\n"
"virtrdf:qmfIsBijection ?:bij ;\n"
"virtrdf:qmfDerefFlags ?:deref ;\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_IS_LIT ;\n"
"virtrdf:qmfValRange-rvrDatatype ?:const_dt ;\n"
"virtrdf:qmfValRange-rvrLanguage ?:const_lang ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat };\n"
"if (const_dt is not null)\n"
"{\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:classiri)`\n"
"virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_TYPED };\n"
"}\n"
"commit work;\n"
"return vector_concat (res, vector (vector (\'00000\', \'LITERAL class <\' || classiri || \'> has been defined (inherited from rdfdf:\' || basetype || \') using \' || uriprintname)));\n"
"}\n"
"--src sparql.sql:11552\n";

static const char *proc302 = 
"#line 11673 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_LANG (in coltype varchar, in o_lang varchar, in is_nullable integer := 0) returns any\n"
"{\n"
"declare src_lname, res_lname, src_fmtid, res_fmtid, src_baseid, res_baseid, superformatsid, nullablesuperformatid, o_lang_str varchar;\n"
"nullablesuperformatid := null;\n"
"if (not is_nullable)\n"
"nullablesuperformatid := DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_LANG (coltype, o_lang, 1);\n"
"src_baseid := \'http://www.openlinksw.com/virtrdf-data-formats#\' || \'sql-\' || replace (coltype, \' \', \'\') || \'-fixedlang-x-any\' ;\n"
"res_baseid := \'http://www.openlinksw.com/virtrdf-data-formats#\' || \'sql-\' || replace (coltype, \' \', \'\') || \'-fixedlang-\' || o_lang ;\n"
"src_lname := \'sql-\' || replace (coltype, \' \', \'\') || \'-fixedlang-x-any\' || case when is_nullable then \'-nullable\' else \'\' end;\n"
"res_lname := \'sql-\' || replace (coltype, \' \', \'\') || \'-fixedlang-\' || o_lang || case when is_nullable then \'-nullable\' else \'\' end ;\n"
"src_fmtid := \'http://www.openlinksw.com/virtrdf-data-formats#\' || src_lname;\n"
"res_fmtid := \'http://www.openlinksw.com/virtrdf-data-formats#\' || res_lname;\n"
"superformatsid := res_fmtid || \'--SuperFormats\';\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where { graph virtrdf: { `iri(?:res_fmtid)` a virtrdf:QuadMapFormat } } ) )\n"
"{\n"
"\n"
"return res_fmtid;\n"
"}\n"
"if (not exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"ask where { graph virtrdf: { `iri(?:src_fmtid)` a virtrdf:QuadMapFormat } } ) )\n"
"{\n"
"\n"
"signal (\'22023\', \'Unable to find appropriate quad map format to make its analog for a fixed language\');\n"
"}\n"
"\n"
"o_lang_str := WS.WS.STR_SQL_APOS (o_lang);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix xsd: <http://www.w3.org/2001/XMLSchema#>\n"
"with virtrdf:\n"
"delete { `iri(?:res_fmtid)` ?p ?o }\n"
"where  { `iri(?:res_fmtid)` ?p ?o };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix xsd: <http://www.w3.org/2001/XMLSchema#>\n"
"with virtrdf:\n"
"delete { `iri(?:superformatsid)` ?p ?o }\n"
"where  { `iri(?:superformatsid)` ?p ?o };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix xsd: <http://www.w3.org/2001/XMLSchema#>\n"
"insert in virtrdf:\n"
"{\n"
"`iri(?:res_fmtid)` ?p\n"
"`if (isref (?o) || isnumeric (?o) || datatype(?o) != xsd:string,\n"
"if (isref (?o) && (?o = iri(?:src_baseid)), iri(?:res_baseid), ?o),\n"
"bif:replace (?o, \"\'x-any\'\", ?:o_lang_str) ) ` ;\n"
"virtrdf:qmfSuperFormats `iri(?:superformatsid)` .\n"
"`iri(?:superformatsid)`\n"
"rdf:type virtrdf:array-of-QuadMapFormat ;\n"
"rdf:_1 `iri(?:nullablesuperformatid)` .\n"
"}\n"
"from virtrdf:\n"
"where\n"
"{\n"
"`iri(?:src_fmtid)` ?p ?o .\n"
"filter (?p != virtrdf:qmfSuperFormats ) };\n"
"commit work;\n"
"return res_fmtid;\n"
"}\n"
"--src sparql.sql:11671\n";

static const char *proc303 = 
"#line 11744 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_BAD_CLASS_INV_FUNCTION (inout val any) returns any\n"
"{\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:11742\n";

static const char *proc304 = 
"#line 11751 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.SQLNAME_NOTATION_TO_NAME (in str varchar) returns varchar\n"
"{\n"
"if (\'\' = str)\n"
"return NULL;\n"
"if (34 = str[0])\n"
"return subseq (str, 1, length (str) - 1);\n"
"return fix_identifier_case (str);\n"
"}\n"
"--src sparql.sql:11749\n";

static const char *proc305 = 
"#line 11762 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.SQLQNAME_NOTATION_TO_QNAME (in str varchar, in expected_part_count integer) returns varchar\n"
"{\n"
"declare part_ctr, dot_pos integer;\n"
"declare name, res varchar;\n"
"res := \'\';\n"
"part_ctr := 1;\n"
"next_dot:\n"
"dot_pos := strchr (str, \'.\');\n"
"if (dot_pos is not null)\n"
"{\n"
"if (0 = dot_pos)\n"
"{\n"
"if (2 = part_ctr)\n"
"res := res || USER || \'.\';\n"
"else\n"
"return NULL;\n"
"}\n"
"else\n"
"{\n"
"name := DB.DBA.SQLNAME_NOTATION_TO_NAME(subseq (str, 0, dot_pos));\n"
"if (name is null)\n"
"return NULL;\n"
"res := res || name  || \'.\';\n"
"}\n"
"str := subseq (str, dot_pos + 1);\n"
"part_ctr := part_ctr + 1;\n"
"goto next_dot;\n"
"}\n"
"if (expected_part_count <> part_ctr)\n"
"return NULL;\n"
"name := DB.DBA.SQLNAME_NOTATION_TO_NAME (str);\n"
"if (name is null)\n"
"return NULL;\n"
"return res || name;\n"
"}\n"
"--src sparql.sql:11760\n";

static const char *proc306 = 
"#line 11799 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS (inout fheaders any, in is_iri_decl integer, in only_one_arg integer, in pdesc varchar, in invdesc varchar, in bij integer, in deref integer)\n"
"{\n"
"declare uriprint any;\n"
"declare uriprintname varchar;\n"
"declare argctr, argcount integer;\n"
"uriprint := fheaders[0];\n"
"uriprintname := uriprint[0];\n"
"argcount := length (uriprint[1]);\n"
"if (only_one_arg and (1 <> length (uriprint[1])))\n"
"signal (\'22023\', pdesc || \' function \"\' || uriprintname || \'\" should have exactly one argument\');\n"
"if (1 = length (fheaders))\n"
"{\n"
"if (bij or deref)\n"
"{\n"
"if (0 = argcount)\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" can not be used in a class with OPTION (BIJECTION) or OPTION (DEREF), because it has no arguments.\',\n"
"pdesc, uriprintname ) );\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" can not be used in a class with OPTION (BIJECTION) or OPTION (DEREF) without related %d inverse functions\',\n"
"pdesc, uriprintname, argcount ) );\n"
"}\n"
"}\n"
"if (is_iri_decl and (uriprint[2] <> \'varchar\'))\n"
"signal (\'22023\', pdesc || \' function \"\' || uriprintname || \'\" should return varchar, not \' || uriprint[2]);\n"
"foreach (any arg in uriprint[1]) do\n"
"if (UNAME\'in\' <> arg[0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of \' || pdesc || \' functions, not \"\' || arg[0] || \'\"\');\n"
"if (argcount <> (length (fheaders) - 1))\n"
"{\n"
"if ((1 <> length (fheaders)) or (0 = argcount))\n"
"signal (\'22023\',\n"
"sprintf (\'%s function \"%s\" has %d arguments but %d inverse functions\',\n"
"pdesc, uriprintname, argcount, (length (fheaders) - 1)\n"
") );\n"
"declare inv any;\n"
"inv := vector (\'DB.DBA.RDF_BAD_CLASS_INV_FUNCTION\', vector (vector (\'in\', \'val\', \'any\', 0)), \'any\', 0);\n"
"fheaders := make_array (1 + argcount, \'any\');\n"
"fheaders[0] := uriprint;\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"inv[2] := uriprint[1][argctr][2];\n"
"fheaders[argctr+1] := inv;\n"
"}\n"
"}\n"
"else if (1 = argcount)\n"
"{\n"
"declare uriparsename varchar;\n"
"if (uriprintname like \'%\"\')\n"
"uriparsename := subseq (uriprintname, 0, length (uriprintname)-1) || \'_INVERSE\"\';\n"
"else\n"
"uriparsename := uriprintname || \'_INVERSE\';\n"
"if (fheaders[1][0] <> uriparsename)\n"
"signal (\'22023\', \'Name of \' || invdesc || \' function should be \' || uriparsename || \', not \' || fheaders[1][0] || \', other variants are not supported by the current version\' );\n"
"}\n"
"else\n"
"{\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"declare uriparsename varchar;\n"
"if (uriprintname like \'%\"\')\n"
"uriparsename := sprintf (\'%s_INV_%d\"\', subseq (uriprintname, 0, length (uriprintname)-1), argctr+1);\n"
"else\n"
"uriparsename := sprintf (\'%s_INV_%d\', uriprintname, argctr+1);\n"
"if (fheaders[argctr + 1][0] <> uriparsename)\n"
"signal (\'22023\', \'Name of inverse function should be \' || uriparsename || \', not \' || fheaders[argctr + 1][0] || \', other variants are not supported by the current version\' );\n"
"}\n"
"}\n"
"for (argctr := 0; argctr < argcount; argctr := argctr + 1)\n"
"{\n"
"declare uriparse any;\n"
"uriparse := fheaders [argctr + 1];\n"
"if (1 <> length (uriparse[1]))\n"
"signal (\'22023\', invdesc || \' function \' || uriparse[0] || \' should have only one argument\');\n"
"if (UNAME\'in\' <> uriparse[1][0][0])\n"
"signal (\'22023\', \'Only \"in\" parameters are now supported in argument lists of \' || invdesc || \' functions, not \"\' || uriparse[1][0][0] || \'\"\');\n"
"if ((uriparse[1][0][2] <> uriprint[2]) and (uriparse[1][0][2] <> \'any\'))\n"
"signal (\'22023\', invdesc || \' function \"\' || uriparse[0] || \'\" should have argument of type \' || uriprint[2] || \', not \' || uriparse[1][0][2]);\n"
"if ((uriparse[2] <> uriprint[1][argctr][2]) and (uriprint[1][argctr][2] <> \'any\'))\n"
"signal (\'22023\', \'The return value of \"\' || uriparse[0] || \'\" and the argument #\' || cast (argctr+1 as varchar) || \' of \"\' || uriprintname || \'\" should be of the same data type\');\n"
"if (coalesce (uriparse[1][0][3], 0))\n"
"signal (\'22023\', invdesc || \' function \' || uriparse[0] || \' should have nullable argument\');\n"
"}\n"
"}\n"
"--src sparql.sql:11797\n";

static const char *proc307 = 
"#line 11885 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_SUBCLASS (in subclassiri varchar, in superclassiri varchar) returns any\n"
"{\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (subclassiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (superclassiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:subclassiri)` virtrdf:isSubclassOf `iri(?:superclassiri)` };\n"
"commit work;\n"
"return vector (vector (\'00000\', \'IRI class <\' || subclassiri || \'> is now known as a subclass of <\' || superclassiri || \'>\'));\n"
"}\n"
"--src sparql.sql:11883\n";

static const char *proc308 = 
"#line 11898 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DROP_CLASS (in classiri varchar, in silent integer := 0) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:classiri)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Class <\' || classiri || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"if (DB.DBA.RDF_QM_ASSERT_JSO_TYPE (classiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\', 1))\n"
"{\n"
"declare side_s IRI_ID;\n"
"side_s := DB.DBA.RDF_QM_GC_SUBTREE (classiri, 2);\n"
"if (side_s is not null)\n"
"signal (\'22023\', \'Can not drop class <\' || classiri || \'> because it is used by other quad map objects, e.g., <\' || id_to_iri_nosignal (side_s) || \'>\');\n"
"}\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Previous definition of class <\' || classiri || \'> has been dropped\'));\n"
"}\n"
"--src sparql.sql:11896\n";

static const char *proc309 = 
"#line 11920 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DROP_QUAD_STORAGE (in storage varchar, in silent integer := 0) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (silent and not exists ((sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select (1) where {\n"
"graph ?:graphiri {\n"
"`iri(?:storage)` a ?t } } ) ) )\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> does not exist, the DROP statement is ignored due to SILENT option\'));\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 0);\n"
"DB.DBA.RDF_QM_GC_SUBTREE (storage);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` ?p ?o\n"
"}\n"
"where { graph ?:graphiri { `iri(?:storage)` ?p ?o } };\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is removed from the quad mapping schema\'));\n"
"}\n"
"--src sparql.sql:11918\n";

static const char *proc310 = 
"#line 11943 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri, qsusermaps varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, NULL);\n"
"qsusermaps := storage || \'--UserMaps\';\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:storage)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qsusermaps)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)`\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps `iri(?:qsusermaps)` .\n"
"`iri(?:qsusermaps)`\n"
"rdf:type virtrdf:array-of-QuadMap };\n"
"commit work;\n"
"return vector (vector (\'00000\', \'A new empty quad storage <\' || storage || \'> is added to the quad mapping schema\'));\n"
"}\n"
"--src sparql.sql:11941\n";

static const char *proc311 = 
"#line 11972 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 0);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress `bif:now NIL` };\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is flagged as being edited\'));\n"
"}\n"
"--src sparql.sql:11970\n";

static const char *proc312 = 
"#line 11986 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE (in storage varchar) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storage, \'http://www.openlinksw.com/schemas/virtrdf#QuadStorage\');\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?dtstart }\n"
"where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsAlterInProgress ?dtstart } };\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Quad storage <\' || storage || \'> is unflagged and can be edited by other transactions\'));\n"
"}\n"
"--src sparql.sql:11984\n";

static const char *proc313 = 
"#line 12002 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_STORE_ATABLES (in qmvid varchar, in atablesid varchar, inout atables any)\n"
"{\n"
"declare atablectr, atablecount integer;\n"
"atablecount := length (atables);\n"
"for (atablectr := 0; atablectr < atablecount; atablectr := atablectr + 1)\n"
"{\n"
"declare pair any;\n"
"declare qtable, alias, inner_id varchar;\n"
"pair := atables [atablectr];\n"
"alias := pair[0];\n"
"qtable := pair[1];\n"
"if (starts_with (qtable, \'/*[sqlquery[*/\'))\n"
"{\n"
"qtable := \'(\' || qtable || \')\';\n"
"inner_id := qmvid || \'-atable-\' || alias || \'-sql-query\';\n"
"}\n"
"else\n"
"inner_id := qmvid || \'-atable-\' || alias || \'-\' || qtable;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:inner_id)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:atablectr+1))` `iri(?:inner_id)` .\n"
"`iri(?:inner_id)`\n"
"rdf:type virtrdf:QuadMapATable ;\n"
"virtrdf:qmvaAlias ?:alias ;\n"
"virtrdf:qmvaTableName ?:qtable };\n"
"}\n"
"}\n"
"--src sparql.sql:12000\n";

static const char *proc314 = 
"#line 12038 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_FT_USAGE (in ft_type varchar, in ft_alias varchar, in ft_aliased_col any, in sqlcols any, in conds any, in options any := null)\n"
"{\n"
"declare ft_tbl, ft_col, ftid, ftcondsid varchar;\n"
"declare condctr, condcount, ft_isxml integer;\n"
"ft_tbl := ft_aliased_col[0];\n"
"ft_col := ft_aliased_col[2];\n"
"ft_isxml := case (isnull (ft_type)) when 0 then 1 else null end;\n"
"if (ft_alias <> ft_aliased_col[1])\n"
"signal (\'22023\', sprintf (\'\"TEXT LITERAL %I.%I\" should be at the end of \"FROM ... AS %I\" declaration\', ft_aliased_col[1], ft_aliased_col, ft_alias));\n"
"condcount := length (conds);\n"
"ftid := \'sys:ft-\' || md5 (serialize (vector (ft_alias, ft_tbl, ft_col, conds, options)));\n"
"if (condcount > 0)\n"
"ftcondsid := ftid || \'-conds\';\n"
"else\n"
"ftcondsid := NULL;\n"
"/* Trick to avoid repeating re-declarations */\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?:ftid\n"
"rdf:type virtrdf:QuadMapFText ;\n"
"virtrdf:qmvftAlias ?:ft_alias ;\n"
"virtrdf:qmvftTableName ?:ft_tbl ;\n"
"virtrdf:qmvftColumnName ?:ft_col ;\n"
"virtrdf:qmvftConds `iri(?:ftcondsid)` } } ) )\n"
"return ftid;\n"
"if (ftcondsid is not null)\n"
"DB.DBA.RDF_QM_GC_SUBTREE (ftcondsid);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:ftid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:ftcondsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:ftid)`\n"
"rdf:type virtrdf:QuadMapFText ;\n"
"virtrdf:qmvftAlias ?:ft_alias ;\n"
"virtrdf:qmvftTableName ?:ft_tbl ;\n"
"virtrdf:qmvftColumnName ?:ft_col ;\n"
"virtrdf:qmvftXmlIndex ?:ft_isxml ;\n"
"virtrdf:qmvftConds `iri(?:ftcondsid)` .\n"
"`iri(?:ftcondsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:ftcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"return ftid;\n"
"}\n"
"--src sparql.sql:12036\n";

static const char *proc315 = 
"#line 12103 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY (in sqlcols any) returns integer\n"
"{\n"
"declare alias, tbl varchar;\n"
"declare colctr, colcount integer;\n"
"colcount := length (sqlcols);\n"
"if (0 = colcount)\n"
"return 0;\n"
"tbl := sqlcols[0][0];\n"
"alias := sqlcols[0][1];\n"
"for (colctr := 1; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"if ((sqlcols[colctr][0] <> tbl) or (sqlcols[colctr][1] <> alias))\n"
"return 0;\n"
"}\n"
"for (select KEY_ID, KEY_N_SIGNIFICANT from DB.DBA.SYS_KEYS where (KEY_TABLE = tbl) and KEY_IS_UNIQUE) do\n"
"{\n"
"declare keycolnames any;\n"
"if (KEY_N_SIGNIFICANT > colcount)\n"
"goto no_match;\n"
"for (select \"COLUMN\" as COL\n"
"from DB.DBA.SYS_KEY_PARTS join DB.DBA.SYS_COLS on (KP_COL = COL_ID)\n"
"where KP_KEY_ID = KEY_ID and KP_NTH < KEY_N_SIGNIFICANT ) do\n"
"{\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"if (sqlcols[colctr][2] = COL)\n"
"goto col_ok;\n"
"}\n"
"goto no_match;\n"
"col_ok: ;\n"
"}\n"
"return 1;\n"
"\n"
"no_match: ;\n"
"}\n"
"return 0;\n"
"}\n"
"--src sparql.sql:12101\n";

static const char *other37 = 
"registry_set (\'DB.DBA.RDF_QM_PEDANTIC_GC\', \'\')\n";
static const char *proc316 = 
"#line 12145 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_MAP_VALUE (in qmv any, in fldname varchar, inout tablename varchar, in o_dt any := null, in o_lang any := null) returns varchar\n"
"{\n"
"/* iqi qmv: vector ( UNAME\'http://www.openlinksw.com/schemas/oplsioc#user_iri\' ,\n"
"vector ( vector (\'alias1\', \'DB.DBA.SYS_USERS\')),\n"
"vector ( vector (\'DB.DBA.SYS_USERS\', \'alias1\', \'U_ID\') ),\n"
"vector (\'^{alias1.}^.U+IS_ROLE = 0\'),\n"
"NULL\n"
") */\n"
"declare atables, sqlcols, conds, items_for_pedantic_gc any;\n"
"declare ftextid varchar;\n"
"declare qry_metas any;\n"
"declare atablectr, atablecount integer;\n"
"declare colctr, colcount, fmtcolcount integer;\n"
"declare condctr, condcount integer;\n"
"declare columnsformkey integer;\n"
"declare fmtid, iriclassid, qmvid, qmvatablesid, qmvcolsid, qmvcondsid varchar;\n"
"\n"
"fmtid := qmv[0];\n"
"atables := qmv[1];\n"
"sqlcols := qmv[2];\n"
"conds := qmv[3];\n"
"ftextid := qmv[4];\n"
"qry_metas := null;\n"
"atablecount := length (atables);\n"
"colcount := length (sqlcols);\n"
"condcount := length (conds);\n"
"items_for_pedantic_gc := NULL;\n"
"if (fmtid <> UNAME\'literal\')\n"
"{\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (fmtid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\');\n"
"if (o_dt is not null)\n"
"signal (\'22023\', \'Only default literal class can have DATATYPE clause in the mapping, <\' || fmtid || \'> can not\');\n"
"if (o_lang is not null)\n"
"signal (\'22023\', \'Only default literal class can have LANG clause in the mapping, <\' || fmtid || \'> can not\');\n"
"fmtcolcount := ((sparql define input:storage \"\"\n"
"select ?cc from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { `iri(?:fmtid)` virtrdf:qmfColumnCount ?cc } ) );\n"
"if (fmtcolcount <> colcount)\n"
"signal (\'22023\', \'Number of columns of quad map value does not match number of arguments of format <\' || fmtid || \'>\');\n"
"}\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare sqlcol any;\n"
"declare alias_msg_txt, final_tblname, final_colname varchar;\n"
"sqlcol := sqlcols [colctr];\n"
"final_colname := DB.DBA.SQLNAME_NOTATION_TO_NAME (sqlcol[2]);\n"
"if (sqlcol[1] is not null)\n"
"alias_msg_txt := \' (alias \' || sqlcol[1] || \')\';\n"
"else\n"
"alias_msg_txt := \' (without alias)\';\n"
"if (starts_with (sqlcol[0], \'/*[sqlquery[*/\'))\n"
"{\n"
"declare qry varchar;\n"
"declare qry_colcount, qry_colctr integer;\n"
"declare qry_mdata any;\n"
"qry := sqlcol[0];\n"
"if (qry_metas is null)\n"
"qry_metas := dict_new (5);\n"
"qry_mdata := dict_get (qry_metas, qry, null);\n"
"if (qry_mdata is null)\n"
"{\n"
"declare stat, msg varchar;\n"
"declare exec_metas any;\n"
"stat := \'00000\';\n"
"exec_metadata (sqlcol[0], stat, msg, exec_metas);\n"
"if (stat <> \'00000\')\n"
"signal (\'22023\', \'The compilation of SQLQUERY\' || alias_msg_txt || \' results in Error \' || stat || \': \' || msg);\n"
"if (exec_metas[1] <> 1)\n"
"signal (\'R2RML\', \'Dangerous DML in SQLQUERY\' || alias_msg_txt);\n"
"exec_metas := exec_metas[0];\n"
"qry_colcount := length (exec_metas);\n"
"qry_mdata := make_array (qry_colcount*2, \'any\');\n"
"for (qry_colctr := 0; qry_colctr < qry_colcount; qry_colctr := qry_colctr + 1)\n"
"{\n"
"qry_mdata[qry_colctr*2] := exec_metas[qry_colctr][0];\n"
"qry_mdata[qry_colctr*2+1] := exec_metas[qry_colctr];\n"
"}\n"
"dict_put (qry_metas, qry, qry_mdata);\n"
"\n"
"}\n"
"\n"
"if (get_keyword (final_colname, qry_mdata) is null)\n"
"signal (\'22023\', \'The result of SQLQUERY\' || alias_msg_txt || \' does not contain column \' || sqlcol[2] || \', please check spelling and character case\');\n"
"}\n"
"else\n"
"{\n"
"final_tblname := DB.DBA.SQLQNAME_NOTATION_TO_QNAME (sqlcol[0], 3);\n"
"if (not exists (select top 1 1 from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname))\n"
"signal (\'22023\', \'No table \' || sqlcol[0] || alias_msg_txt || \' in database, please check spelling and character case\');\n"
"if (not exists (select top 1 1 from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname and \"COLUMN\" = final_colname))\n"
"signal (\'22023\', \'No column \' || sqlcol[2] || \' in table \' || sqlcol[0] || alias_msg_txt || \' in database, please check spelling and character case\');\n"
"}\n"
"if (tablename is null)\n"
"tablename := sqlcol[0];\n"
"else if (tablename <> sqlcol[0])\n"
"tablename := \'\';\n"
"}\n"
"if (tablename is null)\n"
"tablename := \'\';\n"
"if (fmtid = UNAME\'literal\')\n"
"{\n"
"declare sqlcol any;\n"
"declare final_tblname, final_colname varchar;\n"
"declare coldtp, colnullable integer;\n"
"declare coltype varchar;\n"
"sqlcol := sqlcols [0];\n"
"final_colname := DB.DBA.SQLNAME_NOTATION_TO_NAME (sqlcol[2]);\n"
"if (starts_with (sqlcol[0], \'/*[sqlquery[*/\'))\n"
"{\n"
"declare col_mdata any;\n"
"col_mdata := get_keyword (final_colname, dict_get (qry_metas, sqlcol[0], null));\n"
"coldtp := col_mdata[1];\n"
"colnullable := col_mdata[4];\n"
"}\n"
"else\n"
"{\n"
"final_tblname := DB.DBA.SQLQNAME_NOTATION_TO_QNAME (sqlcol[0], 3);\n"
"select COL_DTP, coalesce (COL_NULLABLE, 1) into coldtp, colnullable\n"
"from DB.DBA.TABLE_COLS where \"TABLE\" = final_tblname and \"COLUMN\" = final_colname;\n"
"}\n"
"coltype := case (coldtp)\n"
"when __tag of long varchar then \'longvarchar\'\n"
"when __tag of timestamp then \'datetime\'\n"
"when __tag of date then \'date\'\n"
"when __tag of time then \'time\'\n"
"when __tag of long varbinary then \'longvarbinary\'\n"
"when 188 then \'integer\'\n"
"when __tag of integer then \'integer\'\n"
"when __tag of varchar then \'varchar\'\n"
"when __tag of real then \'double precision\'\n"
"when __tag of double precision then \'double precision\'\n"
"when 192 then \'varchar\'\n"
"when __tag of datetime then \'datetime\'\n"
"when __tag of numeric then \'numeric\'\n"
"when __tag of nvarchar then \'nvarchar\'\n"
"when __tag of long nvarchar then \'longnvarchar\'\n"
"when __tag of bigint then \'integer\'\n"
"else NULL end;\n"
"if (coltype is null)\n"
"signal (\'22023\', \'The datatype of column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" (COL_DTP=\' || cast (coldtp as varchar) ||\n"
"\') can not be mapped to an RDF literal in current version of Virtuoso\' );\n"
"if (o_lang is not null and not (coltype in (\'varchar\', \'long varchar\', \'nvarchar\', \'long nvarchar\')))\n"
"signal (\'22023\', \'The datatype of column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" (COL_DTP=\' || cast (coldtp as varchar) ||\n"
"\') conflicts with LANG clause, only strings may have language\' );\n"
"if (o_dt is not null and not (coltype in (\'varchar\', \'long varchar\', \'nvarchar\', \'long nvarchar\')))\n"
"signal (\'22023\', \'Current version of Virtuoso does not support DATATYPE clause for columns other than varchar/nvarchar; the column \"\' || sqlcols[0][2] ||\n"
"\'\" of table \"\' || sqlcols[0][0] || \'\" has COL_DTP=\' || cast (coldtp as varchar) );\n"
"fmtid := \'http://www.openlinksw.com/virtrdf-data-formats#sql-\' || replace (coltype, \' \', \'\');\n"
"if (o_dt is not null)\n"
"{\n"
"if (__tag (o_dt) = __tag of vector)\n"
"{\n"
"if (o_dt[1] <> sqlcols[0][1])\n"
"signal (\'22023\', \'The alias in DATATYPE clause and the alias in object column should be the same\');\n"
"fmtid := fmtid || \'-dt\';\n"
"sqlcols := vector_concat (sqlcols, vector (o_dt));\n"
"colcount := colcount + 1;\n"
"}\n"
"else\n"
"fmtid := DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_DT (coltype, o_dt);\n"
"}\n"
"if (o_lang is not null)\n"
"{\n"
"if (__tag (o_lang) = __tag of vector)\n"
"{\n"
"if (o_lang[1] <> sqlcols[0][1])\n"
"signal (\'22023\', \'The alias in LANG clause and the alias in object column should be the same\');\n"
"fmtid := fmtid || \'-lang\';\n"
"sqlcols := vector_concat (sqlcols, vector (o_lang));\n"
"colcount := colcount + 1;\n"
"}\n"
"else\n"
"fmtid := DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_LANG (coltype, o_lang);\n"
"}\n"
"if (colnullable)\n"
"fmtid := fmtid || \'-nullable\';\n"
"iriclassid := null;\n"
"}\n"
"else\n"
"{\n"
"if (exists (sparql define input:storage \"\"\n"
"ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri (?:fmtid)` virtrdf:qmfValRange-rvrRestrictions virtrdf:SPART_VARR_IS_REF } } ) )\n"
"iriclassid := fmtid;\n"
"else\n"
"iriclassid := null;\n"
"}\n"
"qmvid := \'sys:qmv-\' || md5 (serialize (vector (fmtid, sqlcols)));\n"
"qmvatablesid := qmvid || \'-atables\';\n"
"qmvcolsid := qmvid || \'-cols\';\n"
"qmvcondsid := qmvid || \'-conds\';\n"
"/* Trick to avoid repeating re-declarations */\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?:qmvid\n"
"rdf:type virtrdf:QuadMapValue ;\n"
"virtrdf:qmvATables `iri(?:qmvatablesid)` ;\n"
"virtrdf:qmvColumns `iri(?:qmvcolsid)` ;\n"
"virtrdf:qmvConds `iri(?:qmvcondsid)` ;\n"
"virtrdf:qmvFormat `iri(?:fmtid)` . } } ) )\n"
"return qmvid;\n"
"/* Create everything if qmv has not been found */\n"
"if (registry_get (\'DB.DBA.RDF_QM_PEDANTIC_GC\') <> \'\')\n"
"{\n"
"vectorbld_init (items_for_pedantic_gc);\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?atable where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?atable . filter (?p != rdf:type) } } ) do {\n"
"vectorbld_acc (items_for_pedantic_gc, \"atable\");\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"select ?col where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?col . filter (?p != rdf:type) } } ) do {\n"
"vectorbld_acc (items_for_pedantic_gc, \"col\");\n"
"}\n"
"vectorbld_final (items_for_pedantic_gc);\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)` ?p ?o . }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvatablesid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)` ?p ?o .\n"
"} };\n"
"if (items_for_pedantic_gc is not null)\n"
"{\n"
"foreach (any i in items_for_pedantic_gc) do\n"
"{\n"
"DB.DBA.RDF_QM_GC_SUBTREE (i);\n"
"}\n"
"}\n"
"if (0 = atablecount)\n"
"qmvatablesid := NULL;\n"
"if (0 = condcount)\n"
"qmvcondsid := NULL;\n"
"columnsformkey := DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY (sqlcols);\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvid)`\n"
"rdf:type virtrdf:QuadMapValue ;\n"
"virtrdf:qmvTableName ?:tablename ;\n"
"virtrdf:qmvATables `iri(?:qmvatablesid)` ;\n"
"virtrdf:qmvColumns `iri(?:qmvcolsid)` ;\n"
"virtrdf:qmvConds `iri(?:qmvcondsid)` ;\n"
"virtrdf:qmvFormat `iri(?:fmtid)` ;\n"
"virtrdf:qmvFText `iri(?:ftextid)` ;\n"
"virtrdf:qmvIriClass `iri(?:iriclassid)` ;\n"
"virtrdf:qmvColumnsFormKey ?:columnsformkey .\n"
"`iri(?:qmvatablesid)`\n"
"rdf:type virtrdf:array-of-QuadMapATable .\n"
"`iri(?:qmvcolsid)`\n"
"rdf:type virtrdf:array-of-QuadMapColumn .\n"
"`iri(?:qmvcondsid)`\n"
"rdf:type virtrdf:array-of-string };\n"
"DB.DBA.RDF_QM_STORE_ATABLES (qmvid, qmvatablesid, atables);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare sqlcol any;\n"
"declare qtable, alias, colname, inner_id varchar;\n"
"sqlcol := sqlcols [colctr];\n"
"alias := sqlcol[1];\n"
"colname := sqlcol[2];\n"
"inner_id := qmvid || \'-col-\' || alias || \'-\' || colname;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:inner_id)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcolsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:colctr+1))` `iri(?:inner_id)` .\n"
"`iri(?:inner_id)`\n"
"rdf:type virtrdf:QuadMapColumn ;\n"
"virtrdf:qmvcAlias ?:alias ;\n"
"virtrdf:qmvcColumnName ?:colname };\n"
"}\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmvcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"return qmvid;\n"
"}\n"
"--src sparql.sql:12143\n";

static const char *proc317 = 
"#line 12465 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_NORMALIZE_QMV (\n"
"inout qmv any, inout qmvfix any, inout qmvid any,\n"
"in can_be_literal integer, in fldname varchar, inout tablename varchar, in o_dt any := null, in o_lang any := null )\n"
"{\n"
"\n"
"qmvid := qmvfix := NULL;\n"
"if ((__tag of vector = __tag (qmv)) and (5 = length (qmv)))\n"
"qmvid := DB.DBA.RDF_QM_DEFINE_MAP_VALUE (qmv, fldname, tablename, o_dt, o_lang);\n"
"else if (217 = __tag (qmv))\n"
"qmvfix := iri_to_id (qmv);\n"
"else if (qmv is not null and not can_be_literal)\n"
"signal (\'22023\', sprintf (\'Quad map declaration can not specify a literal (non-IRI) constant for its %s (tag %d, length %d)\',\n"
"fldname, __tag (qmv), length (qmv) ) );\n"
"else if (__tag of vector = __tag (qmv))\n"
"signal (\'22023\', sprintf (\'Quad map declaration contains constant %s of unsupported type (tag %d, length %d)\',\n"
"fldname, __tag (qmv), length (qmv) ) );\n"
"else\n"
"qmvfix := qmv;\n"
"\n"
"}\n"
"--src sparql.sql:12463\n";

static const char *proc318 = 
"#line 12487 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DEFINE_MAPPING (in storage varchar,\n"
"in qmrawid varchar, in qmid varchar, in qmparentid varchar,\n"
"in qmv_g any, in qmv_s any, in qmv_p any, in qmv_o any, in o_dt any, in o_lang any,\n"
"in is_real integer, in atables any, in conds any, in opts any ) returns any\n"
"{\n"
"declare old_actual_type varchar;\n"
"declare tablename, qmvid_g, qmvid_s, qmvid_p, qmvid_o varchar;\n"
"declare qmvfix_g, qmvfix_s, qmvfix_p, qmvfix_o, qmvfix_o_typed, qmvfix_o_dt any;\n"
"declare qm_exclusive, qm_soft_exclusive, qm_empty, qm_is_default, qmusersubmapsid, atablesid, qmcondsid varchar;\n"
"declare qm_order, atablectr, atablecount, condctr, condcount integer;\n"
"\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 1);\n"
"\n"
"old_actual_type := coalesce ((sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?t where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmid)` rdf:type ?t } } ));\n"
"if (old_actual_type is not null)\n"
"{\n"
"declare old_lstiri, old_side_use varchar;\n"
"if (old_actual_type <> \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\')\n"
"signal (\'22023\', \'The RDF QM schema object <\' || qmid || \'> already exists, type <\' || old_actual_type || \'>\');\n"
"old_lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"old_side_use := coalesce ((sparql define input:storage \"\"\n"
"select ?s where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"?s ?p `iri(?:qmid)` filter ((?s != iri(?:storage)) && (?s != iri(?:old_lstiri))) } } ) );\n"
"if (old_side_use is not null)\n"
"signal (\'22023\', \'Can not re-create the RDF Quad Mapping <\' || qmid || \'> because it is referenced by <\' || old_side_use || \'>\');\n"
"DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (storage, NULL, qmid);\n"
"DB.DBA.RDF_QM_GC_SUBTREE (qmid);\n"
"}\n"
"if (qmparentid is not null)\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmparentid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (storage, qmid, 0);\n"
"tablename := NULL;\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_g, qmvfix_g, qmvid_g, 0, \'graph\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_s, qmvfix_s, qmvid_s, 0, \'subject\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_p, qmvfix_p, qmvid_p, 0, \'predicate\', tablename);\n"
"DB.DBA.RDF_QM_NORMALIZE_QMV (qmv_o, qmvfix_o, qmvid_o, 1, \'object\', tablename, o_dt, o_lang);\n"
"if (get_keyword_ucase (\'EXCLUSIVE\', opts))\n"
"qm_exclusive := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_EXCLUSIVE\';\n"
"else\n"
"qm_exclusive := NULL;\n"
"if (get_keyword_ucase (\'OK_FOR_ANY_QUAD\', opts))\n"
"qm_is_default := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_OK_FOR_ANY_QUAD\';\n"
"else\n"
"qm_is_default := NULL;\n"
"if (get_keyword_ucase (\'SOFT_EXCLUSIVE\', opts))\n"
"qm_soft_exclusive := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_SOFT_EXCLUSIVE\';\n"
"else\n"
"qm_soft_exclusive := NULL;\n"
"if (not is_real)\n"
"{\n"
"qm_empty := \'http://www.openlinksw.com/schemas/virtrdf#SPART_QM_EMPTY\';\n"
"}\n"
"else\n"
"{\n"
"qm_empty := NULL;\n"
"if (tablename is null)\n"
"{\n"
"tablename := \'DB.DBA.SYS_IDONLY_ONE\';\n"
"if (0 < length (conds))\n"
"signal (\'22023\', \'Quad Mapping <\' || qmid || \'> has four constants and no one quad map value; it does not access tables so it can not have WHERE conditions\');\n"
"}\n"
"}\n"
"if (\'\' = tablename)\n"
"tablename := NULL;\n"
"qm_order := get_keyword_ucase (\'ORDER\', opts);\n"
"if (not is_real)\n"
"{\n"
"qmusersubmapsid := qmid || \'--UserSubMaps\';\n"
"atablesid := NULL;\n"
"qmcondsid := NULL;\n"
"}\n"
"else\n"
"{\n"
"qmusersubmapsid := NULL;\n"
"atablesid := qmid || \'--ATables\';\n"
"qmcondsid := qmid || \'--Conds\';\n"
"}\n"
"if (qm_is_default is not null)\n"
"{\n"
"if (qm_order is not null)\n"
"signal (\'22023\', \'ORDER option is not applicable to default quad map\');\n"
"if (qmparentid is not null)\n"
"signal (\'22023\', \'A default quad map can not be a sub-map of other quad map\');\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:atablesid)` ?p ?o .\n"
"} };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)` ?p ?o }\n"
"where { graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)` ?p ?o .\n"
"} };\n"
"atablecount := length (atables);\n"
"condcount := length (conds);\n"
"if (0 = atablecount)\n"
"atablesid := NULL;\n"
"if (0 = condcount)\n"
"qmcondsid := NULL;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:atablesid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmcondsid)) };\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> { ?s ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { ?s ?p ?o . filter (?s = iri(?:qmusersubmapsid)) };\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"qmvfix_o_typed := 0;\n"
"if (o_dt is not null)\n"
"{\n"
"qmvfix_o_typed := 1;\n"
"qmvfix_o_dt := o_dt;\n"
"}\n"
"else if (isstring (qmvfix_o) || iswidestring (qmvfix_o))\n"
"{\n"
"qmvfix_o_typed := 0;\n"
"qmvfix_o_dt := NULL;\n"
"}\n"
"else\n"
"{\n"
"qmvfix_o_typed := 1;\n"
"qmvfix_o_dt := __xsd_type (qmvfix_o);\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmid)`\n"
"rdf:type virtrdf:QuadMap ;\n"
"virtrdf:qmGraphRange-rvrFixedValue ?:qmvfix_g ;\n"
"virtrdf:qmGraphRange-rvrRestrictions\n"
"`if (bound(?:qmvfix_g), virtrdf:SPART_VARR_NOT_NULL, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_g), virtrdf:SPART_VARR_FIXED, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_g), virtrdf:SPART_VARR_IS_REF, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_g), virtrdf:SPART_VARR_IS_IRI, ?:NULL)` ;\n"
"virtrdf:qmGraphMap `iri(?:qmvid_g)` ;\n"
"virtrdf:qmSubjectRange-rvrFixedValue ?:qmvfix_s ;\n"
"virtrdf:qmSubjectRange-rvrRestrictions\n"
"`if (bound(?:qmvfix_s), virtrdf:SPART_VARR_NOT_NULL, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_s), virtrdf:SPART_VARR_FIXED, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_s), virtrdf:SPART_VARR_IS_REF, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_s), virtrdf:SPART_VARR_IS_IRI, ?:NULL)` ;\n"
"virtrdf:qmSubjectMap `iri(?:qmvid_s)` ;\n"
"virtrdf:qmPredicateRange-rvrFixedValue ?:qmvfix_p ;\n"
"virtrdf:qmPredicateRange-rvrRestrictions\n"
"`if (bound(?:qmvfix_p), virtrdf:SPART_VARR_NOT_NULL, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_p), virtrdf:SPART_VARR_FIXED, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_p), virtrdf:SPART_VARR_IS_REF, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_p), virtrdf:SPART_VARR_IS_IRI, ?:NULL)` ;\n"
"virtrdf:qmPredicateMap `iri(?:qmvid_p)` ;\n"
"virtrdf:qmObjectRange-rvrFixedValue ?:qmvfix_o ;\n"
"virtrdf:qmObjectRange-rvrRestrictions\n"
"`if (bound(?:qmvfix_o), virtrdf:SPART_VARR_NOT_NULL, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_o), virtrdf:SPART_VARR_FIXED, ?:NULL)` ,\n"
"`if (bound(?:qmvfix_o), if (isREF(?:qmvfix_o), virtrdf:SPART_VARR_IS_REF, virtrdf:SPART_VARR_IS_LIT), ?:NULL)` ,\n"
"`if (isIRI(?:qmvfix_o), virtrdf:SPART_VARR_IS_IRI, ?:NULL)` ,\n"
"`if (?:qmvfix_o_typed, virtrdf:SPART_VARR_TYPED, ?:NULL)` ;\n"
"virtrdf:qmObjectRange-rvrDatatype ?:qmvfix_o_dt ;\n"
"virtrdf:qmObjectRange-rvrLanguage `if (<bif:length> (lang (?:qmvfix_o)), lang (?:qmvfix_o), ?:NULL)` ;\n"
"virtrdf:qmObjectMap `iri(?:qmvid_o)` ;\n"
"virtrdf:qmTableName ?:tablename ;\n"
"virtrdf:qmATables `iri(?:atablesid)` ;\n"
"virtrdf:qmConds `iri(?:qmcondsid)` ;\n"
"virtrdf:qmUserSubMaps `iri(?:qmusersubmapsid)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_exclusive)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_empty)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_is_default)` ;\n"
"virtrdf:qmMatchingFlags `iri(?:qm_soft_exclusive)` ;\n"
"virtrdf:qmPriorityOrder ?:qm_order .\n"
"`iri(?:atablesid)`\n"
"rdf:type virtrdf:array-of-QuadMapATable .\n"
"`iri(?:qmcondsid)`\n"
"rdf:type virtrdf:array-of-string .\n"
"`iri(?:qmusersubmapsid)`\n"
"rdf:type virtrdf:array-of-QuadMap };\n"
"DB.DBA.RDF_QM_STORE_ATABLES (qmid, atablesid, atables);\n"
"for (condctr := 0; condctr < condcount; condctr := condctr + 1)\n"
"{\n"
"declare sqlcond varchar;\n"
"sqlcond := conds [condctr];\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:qmcondsid)`\n"
"`iri (bif:sprintf (\"%s%d\", str (rdf:_), ?:condctr+1))` ?:sqlcond };\n"
"}\n"
"DB.DBA.RDF_ADD_qmAliasesKeyrefdByQuad (qmid);\n"
"commit work;\n"
"if (qm_is_default is not null)\n"
"DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (storage, qmid);\n"
"else\n"
"DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (storage, qmparentid, qmid, qm_order);\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> has been created and added to the <\' || storage || \'>\'));\n"
"}\n"
"--src sparql.sql:12485\n";

static const char *proc319 = 
"#line 12714 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_ATTACH_MAPPING (in storage varchar, in source varchar, in opts any) returns any\n"
"{\n"
"declare graphiri varchar;\n"
"declare qmid, qmgraph varchar;\n"
"declare qm_order, qm_is_default integer;\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"qmid := get_keyword_ucase (\'ID\', opts, NULL);\n"
"qmgraph := get_keyword_ucase (\'GRAPH\', opts, NULL);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (storage, 1);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG (source, 0);\n"
"if (qmid is null)\n"
"{\n"
"qmid := coalesce ((sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select ?s where {\n"
"graph ?:graphiri {\n"
"?s rdf:type virtrdf:QuadMap .\n"
"?s virtrdf:qmGraphRange-rvrFixedValue `iri(?:qmgraph)` .\n"
"?s virtrdf:qmMatchingFlags virtrdf:SPART_QM_EMPTY .\n"
"} } ));\n"
"if (qmid is null)\n"
"return vector (vector (\'00100\', \'Quad map for graph <\' || qmgraph || \'> is not found\'));\n"
"}\n"
"qm_order := coalesce ((sparql define input:storage \"\"\n"
"select ?o where { graph ?:graphiri {\n"
"`iri(?:qmid)` virtrdf:qmPriorityOrder ?o } } ) );\n"
"if (exists (sparql define input:storage \"\"\n"
"ask where { graph ?:graphiri {\n"
"`iri(?:qmid)` virtrdf:qmMatchingFlags virtrdf:SPART_QM_OK_FOR_ANY_QUAD } } ) )\n"
"qm_is_default := 1;\n"
"else\n"
"qm_is_default := 0;\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (storage, qmid, 0);\n"
"DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING (source, qmid, 1);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (qmid, \'http://www.openlinksw.com/schemas/virtrdf#QuadMap\');\n"
"if (qm_is_default)\n"
"DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (storage, qmid);\n"
"else\n"
"DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (storage, NULL, qmid, NULL /* !!!TBD: place real value instead of constant NULL */);\n"
"commit work;\n"
"return vector (vector (\'00000\', \'Quad map <\' || qmid || \'> is added to the storage <\' || storage || \'>\'));\n"
"}\n"
"--src sparql.sql:12712\n";

static const char *proc320 = 
"#line 12758 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE (in storage varchar, in qmparent varchar, in qmid varchar, in qmorder integer)\n"
"{\n"
"declare graphiri, lstiri varchar;\n"
"declare iris_and_orders any;\n"
"declare ctr, qmid_is_printed integer;\n"
"\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmparent is not null)\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:qmparent)` virtrdf:qmUserSubMaps ?lst } } );\n"
"else\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"\n"
"if (qmorder is null)\n"
"qmorder := 1999;\n"
"iris_and_orders := (\n"
"select DB.DBA.VECTOR_AGG (vector (sub.\"id\", sub.\"p\", sub.\"ord1\"))\n"
"from (\n"
"select sp.\"id\", sp.\"p\", sp.\"ord1\"\n"
"from (\n"
"sparql define input:storage \"\"\n"
"select ?id ?p\n"
"(bif:coalesce (?ord,\n"
"1000 + bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) as ?ord1\n"
"where { graph ?:graphiri {\n"
"`iri(?:lstiri)` ?p ?id .\n"
"filter (! bif:isnull (bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) .\n"
"optional {?id virtrdf:qmPriorityOrder ?ord} } } ) as sp\n"
"order by 3, 2, 1 ) as sub );\n"
"\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id, p varchar;\n"
"id := itm[0];\n"
"p := itm[1];\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)` `iri(?:p)` `iri(?:id)` };\n"
"}\n"
"ctr := 1;\n"
"qmid_is_printed := 0;\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id varchar;\n"
"declare ord integer;\n"
"id := itm[0];\n"
"ord := itm[2];\n"
"if (ord > qmorder)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:qmid)` };\n"
"\n"
"ctr := ctr + 1;\n"
"qmid_is_printed := 1;\n"
"}\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:id)` };\n"
"ctr := ctr + 1;\n"
"}\n"
"if (not qmid_is_printed)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:qmid)` };\n"
"\n"
"ctr := ctr + 1;\n"
"}\n"
"}\n"
"--src sparql.sql:12756\n";

static const char *proc321 = 
"#line 12849 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE (in storage varchar, in qmparent varchar, in qmid varchar)\n"
"{\n"
"declare graphiri, lstiri varchar;\n"
"declare iris_and_orders any;\n"
"declare ctr integer;\n"
"\n"
"qmid := iri_to_id (qmid, 0, NULL);\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"if (qmparent is not null)\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:qmparent)` virtrdf:qmUserSubMaps ?lst } } );\n"
"else\n"
"lstiri := (sparql define input:storage \"\"\n"
"select ?lst where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsUserMaps ?lst } } );\n"
"\n"
"iris_and_orders := (\n"
"select DB.DBA.VECTOR_AGG (vector (sub.\"id\", sub.\"p\", sub.\"ord1\"))\n"
"from (\n"
"select sp.\"id\", sp.\"p\", sp.\"ord1\"\n"
"from (\n"
"sparql define input:storage \"\"\n"
"select ?id ?p\n"
"(bif:coalesce (?ord,\n"
"1000 + bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) as ?ord1\n"
"where { graph ?:graphiri {\n"
"`iri(?:lstiri)` ?p ?id .\n"
"filter (! bif:isnull (bif:aref (\n"
"bif:sprintf_inverse (\n"
"str(?p),\n"
"bif:concat (str (rdf:_), \"%d\"),\n"
"2),\n"
"0 ) ) ) .\n"
"optional {?id virtrdf:qmPriorityOrder ?ord} } } ) as sp\n"
"order by 3, 2, 1 ) as sub );\n"
"\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id, p varchar;\n"
"id := itm[0];\n"
"p := itm[1];\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)` `iri(?:p)` `iri(?:id)` . };\n"
"}\n"
"ctr := 1;\n"
"foreach (any itm in iris_and_orders) do\n"
"{\n"
"declare id varchar;\n"
"declare ord integer;\n"
"id := itm[0];\n"
"ord := itm[2];\n"
"if (iri_to_id (id) <> qmid)\n"
"{\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:lstiri)`\n"
"`iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:ctr))`\n"
"`iri(?:id)` . };\n"
"\n"
"ctr := ctr + 1;\n"
"}\n"
"else\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"}\n"
"--src sparql.sql:12847\n";

static const char *proc322 = 
"#line 12926 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QM_SET_DEFAULT_MAPPING (in storage varchar, in qmid varchar)\n"
"{\n"
"declare graphiri, old_qmid varchar;\n"
"\n"
"graphiri := DB.DBA.JSO_SYS_GRAPH ();\n"
"old_qmid := coalesce ((sparql define input:storage \"\"\n"
"select ?qm where { graph ?:graphiri {\n"
"`iri(?:storage)` virtrdf:qsDefaultMap ?qm } } ) );\n"
"if (old_qmid is not null)\n"
"{\n"
"if (cast (old_qmid as varchar) = cast (qmid as varchar))\n"
"return;\n"
"signal (\'22023\', \'Quad map storage <\' || storage || \'> has set a default quad map <\' || old_qmid || \'>, drop it before adding <\' || qmid || \'>\');\n"
"}\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> { `iri(?:storage)` virtrdf:qsDefaultMap `iri(?:qmid)` . };\n"
"commit work;\n"
"}\n"
"--src sparql.sql:12924\n";

static const char *proc323 = 
"#line 12946 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_SML_DROP (in smliri varchar, in silent integer, in compose_report integer := 1) returns any\n"
"{\n"
"declare report, affected any;\n"
"report := \'\';\n"
"vectorbld_init (affected);\n"
"for (sparql define input:storage \"\"\n"
"select ?storageiri\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary `iri(?:smliri)` } ) do\n"
"{\n"
"report := report || \'SPARQL macro library <\' || smliri || \'> has been detached from quad storage <\' || \"storageiri\" || \'>\\n\';\n"
"vectorbld_acc (affected, \"storageiri\");\n"
"}\n"
"vectorbld_final (affected);\n"
"sparql define input:storage \"\"\n"
"delete from virtrdf:\n"
"{ ?storageiri virtrdf:qsMacroLibrary `iri(?:smliri)` }\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary `iri(?:smliri)` };\n"
"commit work;\n"
"if (not exists (\n"
"sparql define input:storage \"\"\n"
"select 1 from virtrdf: where { `iri(?:smliri)` ?p ?o } ) )\n"
"{\n"
"DB.DBA.RDF_QM_APPLY_CHANGES (null, affected);\n"
"if (silent)\n"
"{\n"
"if (compose_report)\n"
"return report || \'SPARQL macro library <\' || smliri || \'> does not exists, nothing to delete\';\n"
"else\n"
"return 0;\n"
"}\n"
"else\n"
"signal (\'22023\', \'SPARQL macro library <\' || smliri || \'> does not exists, nothing to delete\');\n"
"}\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (smliri, \'http://www.openlinksw.com/schemas/virtrdf#SparqlMacroLibrary\');\n"
"sparql define input:storage \"\"\n"
"delete from graph virtrdf: {\n"
"`iri(?:smliri)` ?p ?o }\n"
"from virtrdf:\n"
"where { `iri(?:smliri)` ?p ?o };\n"
"DB.DBA.RDF_QM_APPLY_CHANGES (vector (\'http://www.openlinksw.com/schemas/virtrdf#SparqlMacroLibrary\', smliri), affected);\n"
"if (compose_report)\n"
"return report || \'SPARQL macro library <\' || smliri || \'> has been deleted\';\n"
"else\n"
"return 1;\n"
"}\n"
"--src sparql.sql:12944\n";

static const char *proc324 = 
"#line 12995 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_SML_CREATE (in smliri varchar, in txt varchar) returns any\n"
"{\n"
"declare stat, msg, smliri_copy varchar;\n"
"declare mdata, rset, affected any;\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (smliri, \'http://www.openlinksw.com/schemas/virtrdf#SparqlMacroLibrary\', 1);\n"
"stat := \'00000\';\n"
"if (__tag (txt) = __tag of nvarchar)\n"
"txt := charset_recode (txt, \'_WIDE_\', \'UTF-8\');\n"
"exec (\'sparql define input:macro-lib-ignore-create \"yes\" define input:disable-storage-macro-lib \"yes\" \' || txt, stat, msg, null, 1, mdata, rset);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"if (length (rset))\n"
"signal (\'SPAR0\', \'Assertion failed: the validation query of macro library should return nothing\');\n"
"vectorbld_init (affected);\n"
"for (sparql define input:storage \"\"\n"
"select ?storageiri\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary `iri(?:smliri)` } ) do\n"
"{\n"
"vectorbld_acc (affected, \"storageiri\");\n"
"}\n"
"smliri_copy := smliri;\n"
"vectorbld_acc (affected, smliri_copy);\n"
"vectorbld_final (affected);\n"
"sparql define input:storage \"\"\n"
"delete from graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:smliri)` ?p ?o }\n"
"from <http://www.openlinksw.com/schemas/virtrdf#>\n"
"where { `iri(?:smliri)` ?p ?o };\n"
"commit work;\n"
"sparql define input:storage \"\"\n"
"insert in graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"`iri(?:smliri)` a virtrdf:SparqlMacroLibrary ; virtrdf:smlSourceText ?:txt };\n"
"DB.DBA.RDF_QM_APPLY_CHANGES (null, affected);\n"
"return \'SPARQL macro library <\' || smliri || \'> has been (re)created\';\n"
"}\n"
"--src sparql.sql:12993\n";

static const char *proc325 = 
"#line 13033 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_DETACH_MACRO_LIBRARY (in storageiri varchar, in args any) returns any\n"
"{\n"
"declare expected_smliri varchar;\n"
"declare old_ctr, expected_found integer;\n"
"declare silent, report any;\n"
"expected_smliri := get_keyword_ucase (\'ID\', args, NULL);\n"
"silent := get_keyword_ucase (\'SILENT\', args, 0);\n"
"expected_found := 0;\n"
"old_ctr := 0;\n"
"vectorbld_init (report);\n"
"for (sparql define input:storage \"\"\n"
"select ?oldsmliri\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary ?oldsmliri } ) do\n"
"{\n"
"if (expected_smliri is not null and cast (expected_smliri as nvarchar) <> cast (\"oldsmliri\" as nvarchar))\n"
"{\n"
"if (silent)\n"
"vectorbld_acc (report, vector (\'00100\', \'The SPARQL macro library to detach from <\' || storageiri || \'> is <\' || expected_smliri || \'> but actually attached one is <\' || \"oldsmliri\" || \'>, nothing to do\'));\n"
"else\n"
"signal (\'22023\', \'The SPARQL macro library to detach from <\' || storageiri || \'> is <\' || expected_smliri || \'> but actually attached one is <\' || \"oldsmliri\" || \'>\');\n"
"}\n"
"else\n"
"{\n"
"if (expected_smliri is not null)\n"
"expected_found := 1;\n"
"vectorbld_acc (report, vector (\'00000\', \'SPARQL macro library <\' || \"oldsmliri\" || \'> has been detached from quad storage <\' || storageiri || \'>\'));\n"
"}\n"
"old_ctr := old_ctr + 1;\n"
"}\n"
"if (expected_smliri is not null)\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from virtrdf:\n"
"{ ?storageiri virtrdf:qsMacroLibrary ?smliri }\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary ?smliri };\n"
"}\n"
"else\n"
"{\n"
"sparql define input:storage \"\"\n"
"delete from virtrdf:\n"
"{ ?storageiri virtrdf:qsMacroLibrary ?smliri }\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary ?smliri };\n"
"}\n"
"commit work;\n"
"if (old_ctr > 1)\n"
"vectorbld_acc (report, vector (\'00100\', \'Note that there was a configuration error: more than one macro library was attached to the quad storage <\' || storageiri || \'>\'));\n"
"else if (old_ctr = 0)\n"
"{\n"
"if (silent)\n"
"vectorbld_acc (report, vector (\'00100\', \'No one SPARQL macro library is attached to the quad storage <\' || storageiri || \'>, nothing to detach\'));\n"
"else\n"
"signal (\'22023\', \'No one SPARQL macro library is attached to the quad storage <\' || storageiri || \'>, nothing to detach\');\n"
"}\n"
"vectorbld_final (report);\n"
"\n"
"return report;\n"
"}\n"
"--src sparql.sql:13031\n";

static const char *proc326 = 
"#line 13095 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_QM_ATTACH_MACRO_LIBRARY (in storageiri varchar, in args any) returns any\n"
"{\n"
"declare smliri varchar;\n"
"smliri := get_keyword_ucase (\'ID\', args, NULL);\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (storageiri, \'http://www.openlinksw.com/schemas/virtrdf#QuadStorage\');\n"
"DB.DBA.RDF_QM_ASSERT_JSO_TYPE (smliri, \'http://www.openlinksw.com/schemas/virtrdf#SparqlMacroLibrary\');\n"
"declare report any;\n"
"vectorbld_init (report);\n"
"for (sparql define input:storage \"\"\n"
"select ?oldsmliri\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary ?oldsmliri } ) do\n"
"{\n"
"vectorbld_acc (report, vector (\'00000\', \'SPARQL macro library <\' || \"oldsmliri\" || \'> has been detached from quad storage <\' || storageiri || \'>\'));\n"
"}\n"
"sparql define input:storage \"\"\n"
"delete from virtrdf:\n"
"{ ?storageiri virtrdf:qsMacroLibrary ?oldsmliri }\n"
"from virtrdf:\n"
"where { ?storageiri virtrdf:qsMacroLibrary ?oldsmliri };\n"
"commit work;\n"
"sparql define input:storage \"\"\n"
"prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#>\n"
"insert in graph virtrdf: {\n"
"`iri(?:storageiri)` virtrdf:qsMacroLibrary `iri(?:smliri)` };\n"
"vectorbld_acc (report, vector (\'00000\', \'SPARQL macro library <\' || smliri || \'> has been attached to quad storage <\' || storageiri || \'>\'));\n"
"vectorbld_final (report);\n"
"return report;\n"
"}\n"
"--src sparql.sql:13093\n";

static const char *proc327 = 
"#line 13126 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_ADD_qmAliasesKeyrefdByQuad (in qm_iri varchar)\n"
"{\n"
"declare kr_iri varchar;\n"
"declare good_ctr, all_ctr integer;\n"
"kr_iri := qm_iri || \'--qmAliasesKeyrefdByQuad\';\n"
"sparql define input:storage \"\" delete from virtrdf: { `iri(?:kr_iri)` ?p ?o } from virtrdf: where { `iri(?:kr_iri)` ?p ?o };\n"
"sparql define input:storage \"\" insert in virtrdf: { `iri(?:qm_iri)` virtrdf:qmAliasesKeyrefdByQuad `iri(?:kr_iri)` . `iri(?:kr_iri)` a virtrdf:array-of-string };\n"
"good_ctr := 0;\n"
"all_ctr := 0;\n"
"for ( sparql define input:storage \"\"\n"
"select ?alias ?tbl (sql:VECTOR_AGG (str(?col))) as ?cols\n"
"from virtrdf:\n"
"where {\n"
"`iri(?:qm_iri)` a virtrdf:QuadMap ;\n"
"?fld_p ?qmv .\n"
"filter (?fld_p in (virtrdf:qmGraphMap , virtrdf:qmSubjectMap , virtrdf:qmPredicateMap , virtrdf:qmObjectMap))\n"
"?qmv a virtrdf:QuadMapValue ;\n"
"virtrdf:qmvATables [\n"
"?qmvat_p [ a virtrdf:QuadMapATable ;\n"
"virtrdf:qmvaAlias ?alias ;\n"
"virtrdf:qmvaTableName ?tbl ] ] ;\n"
"virtrdf:qmvColumns [\n"
"?qmvc_p [ a virtrdf:QuadMapColumn ;\n"
"virtrdf:qmvcAlias ?alias ;\n"
"virtrdf:qmvcColumnName ?col ] ] ;\n"
"virtrdf:qmvFormat [ a virtrdf:QuadMapFormat ;\n"
"virtrdf:qmfIsBijection ?bij ] .\n"
"filter (?bij != 0)\n"
"} ) do\n"
"{\n"
"\n"
"all_ctr := all_ctr + 1;\n"
"for (select KEY_ID, KEY_N_SIGNIFICANT from DB.DBA.SYS_KEYS where KEY_TABLE = \"tbl\" and KEY_IS_UNIQUE) do\n"
"{\n"
"for (select \"COLUMN\" from DB.DBA.SYS_KEY_PARTS, DB.DBA.SYS_COLS\n"
"where  KP_KEY_ID = KEY_ID and KP_NTH < KEY_N_SIGNIFICANT and COL_ID = KP_COL ) do\n"
"{\n"
"if (not position (\"COLUMN\", \"cols\"))\n"
"{\n"
"\n"
"goto wrong_key;\n"
"}\n"
"}\n"
"good_ctr := good_ctr + 1;\n"
"\n"
"sparql define input:storage \"\" insert in virtrdf: { `iri(?:kr_iri)` `iri(bif:sprintf(\"%s%d\", str(rdf:_), ?:good_ctr))` ?:\"alias\" };\n"
"goto right_key;\n"
"wrong_key: ;\n"
"}\n"
"right_key: ;\n"
"}\n"
"\n"
"}\n"
"--src sparql.sql:13124\n";

static const char *proc328 = 
"#line 13181 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_UPGRADE_QUAD_MAP (in qm_iri varchar)\n"
"{\n"
"declare keyrefd any;\n"
"if (not exists (sparql define input:storage \"\" select (1) from virtrdf: where { `iri(?:qm_iri)` a virtrdf:QuadMap }))\n"
"signal (\'RDFxx\', sprintf (\'Quad map <%s> does not exist, nothing to upgrade\', qm_iri));\n"
"if (not exists (sparql define input:storage \"\" select (1) from virtrdf: where { `iri(?:qm_iri)` virtrdf:qmAliasesKeyrefdByQuad ?keyrefs }))\n"
"DB.DBA.RDF_ADD_qmAliasesKeyrefdByQuad (qm_iri);\n"
"}\n"
"--src sparql.sql:13179\n";

static const char *proc329 = 
"#line 13191 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_UPGRADE_METADATA ()\n"
"{\n"
"for (sparql define input:storage \"\" select ?qm_iri from virtrdf: where { ?qm_iri a virtrdf:QuadMap }) do\n"
"{\n"
"DB.DBA.RDF_UPGRADE_QUAD_MAP (\"qm_iri\");\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:13189\n";

static const char *proc330 = 
"#line 13205 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_W (\n"
"in g_iid IRI_ID, in s_uri varchar, in p_uri varchar,\n"
"in o_uri varchar, in env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare s_iid, p_iid, o_iid IRI_ID;\n"
"log_mode := env[0];\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')))\n"
"repl_publish (\'__rdf_repl\', \'__rdf_repl.log\');\n"
"\n"
"if (log_mode = 1)\n"
"{\n"
"whenever sqlstate \'40001\' goto deadlock_1;\n"
"again_1:\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"log_enable (0, 1);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"if (log_mode = 0)\n"
"{\n"
"whenever sqlstate \'40001\' goto deadlock_0;\n"
"again_0:\n"
"log_enable (0, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"whenever sqlstate \'40001\' goto deadlock_2;\n"
"again_2:\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"o_iid := iri_to_id (o_uri);\n"
"commit work;\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O) values (g_iid, s_iid, p_iid, o_iid);\n"
"commit work;\n"
"\n"
"return;\n"
"deadlock_0:\n"
"rollback work;\n"
"goto again_0;\n"
"deadlock_1:\n"
"rollback work;\n"
"goto again_1;\n"
"deadlock_2:\n"
"rollback work;\n"
"goto again_2;\n"
"}\n"
"--src sparql.sql:13203\n";

static const char *proc331 = 
"#line 13270 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_W (\n"
"in g_iid IRI_ID, in s_uri varchar, in p_uri varchar,\n"
"in o_val any, in o_type any, in o_lang any, in env any )\n"
"{\n"
"\n"
"declare log_mode integer;\n"
"declare ro_id_dict any;\n"
"log_mode := env[0];\n"
"ro_id_dict := env[1];\n"
"declare s_iid, p_iid IRI_ID;\n"
"if (isstring (o_type))\n"
"{\n"
"declare parsed any;\n"
"parsed := __xqf_str_parse_to_rdf_box (o_val, o_type, isstring (o_val));\n"
"if (parsed is not null)\n"
"{\n"
"if (__tag of rdf_box = __tag (parsed))\n"
"{\n"
"if (256 = rdf_box_type (parsed))\n"
"db..rdf_geo_add (parsed);\n"
"else\n"
"rdf_box_set_type (parsed,\n"
"DB.DBA.RDF_TWOBYTE_OF_DATATYPE (iri_to_id (o_type)));\n"
"parsed := DB.DBA.RDF_OBJ_ADD (257, parsed, 257, ro_id_dict);\n"
"\n"
"}\n"
"o_val := parsed;\n"
"}\n"
"}\n"
"whenever sqlstate \'40001\' goto deadlck;\n"
"again:\n"
"if (log_mode = 0)\n"
"log_enable (0, 1);\n"
"else\n"
"log_enable (1, 1);\n"
"s_iid := iri_to_id (s_uri);\n"
"p_iid := iri_to_id (p_uri);\n"
"if (isstring (o_val) or (__tag of XML = __tag (o_val)))\n"
"{\n"
"if (isstring (o_type) or isstring (o_lang))\n"
"{\n"
"if (not isstring (o_type))\n"
"o_type := null;\n"
"if (not isstring (o_lang))\n"
"o_lang := null;\n"
"o_val := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT (o_val,\n"
"iri_to_id (o_type),\n"
"o_lang, g_iid, p_iid, ro_id_dict );\n"
"}\n"
"else\n"
"o_val := DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT (o_val, g_iid, p_iid, ro_id_dict);\n"
"}\n"
"else if (__tag of rdf_box = __tag (o_val))\n"
"{\n"
"if (__tag of varchar = rdf_box_data_tag (o_val) and __rdf_obj_ft_rule_check (g_iid, p_iid))\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257, ro_id_dict);\n"
"else if (0 < rdf_box_needs_digest (o_val))\n"
"o_val := DB.DBA.RDF_OBJ_ADD (257, o_val, 257);\n"
"}\n"
"\n"
"if (log_mode <= 1)\n"
"log_enable (0, 1);\n"
"insert soft DB.DBA.RDF_QUAD (G,S,P,O)\n"
"values (g_iid, s_iid, p_iid, o_val);\n"
"\n"
"commit work;\n"
"return;\n"
"deadlck:\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:13268\n";

static const char *proc332 = 
"#line 13343 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_NEW_GRAPH_A (inout g varchar, inout g_iid IRI_ID, inout app_env any) {\n"
"\n"
"if (__rdf_obj_ft_rule_count_in_graph (g_iid))\n"
"app_env[2][1] := dict_new (app_env[3]);\n"
"else\n"
"app_env[2][1] := null;\n"
"if (__rdf_graph_is_in_enabled_repl (g_iid))\n"
"app_env[4] := g;\n"
"else\n"
"app_env[4] := null;\n"
"}\n"
"--src sparql.sql:13341\n";

static const char *proc333 = 
"#line 13356 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_A (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (app_env[4] is not null)\n"
"__rdf_repl_quad (84, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), iri_canonicalize (o_uri));\n"
"app_env[1] := aq_request (\n"
"app_env[0], \'DB.DBA.TTLP_EV_TRIPLE_W\',\n"
"vector (g_iid, s_uri, p_uri, o_uri, app_env[2]) );\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"}\n"
"}\n"
"--src sparql.sql:13354\n";

static const char *proc334 = 
"#line 13379 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_A (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (app_env[4] is not null)\n"
"{\n"
"if (isstring (o_type))\n"
"__rdf_repl_quad (81, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, iri_canonicalize (o_type), NULL);\n"
"else if (isstring (o_lang))\n"
"__rdf_repl_quad (82, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, null, o_lang);\n"
"else\n"
"__rdf_repl_quad (80, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val);\n"
"}\n"
"if (__tag of XML = __tag (o_val))\n"
"{\n"
"DB.DBA.TTLP_EV_TRIPLE_L_W (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]);\n"
"return;\n"
"}\n"
"app_env[1] := aq_request (\n"
"app_env[0], \'DB.DBA.TTLP_EV_TRIPLE_L_W\',\n"
"vector (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]) );\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"}\n"
"}\n"
"--src sparql.sql:13377\n";

static const char *proc335 = 
"#line 13414 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_COMMIT_A (\n"
"inout graph_iri varchar, inout app_env any )\n"
"{\n"
"\n"
"commit work;\n"
"aq_wait_all (app_env[0]);\n"
"commit work;\n"
"DB.DBA.TTLP_EV_COMMIT (graph_iri, app_env[2]);\n"
"commit work;\n"
"}\n"
"--src sparql.sql:13412\n";

static const char *proc336 = 
"#line 13427 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_R (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (app_env[4] is not null)\n"
"__rdf_repl_quad (84, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), iri_canonicalize (o_uri));\n"
"commit work;\n"
"app_env[1] := coalesce (app_env[1], 0) + 1;\n"
"DB.DBA.TTLP_EV_TRIPLE_W (g_iid, s_uri, p_uri, o_uri, app_env[2]);\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"}\n"
"}\n"
"--src sparql.sql:13425\n";

static const char *proc337 = 
"#line 13448 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_TRIPLE_L_R (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"\n"
"if (app_env[4] is not null)\n"
"{\n"
"if (isstring (o_type))\n"
"__rdf_repl_quad (81, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, iri_canonicalize (o_type), NULL);\n"
"else if (isstring (o_lang))\n"
"__rdf_repl_quad (82, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val, null, o_lang);\n"
"else\n"
"__rdf_repl_quad (80, app_env[4], iri_canonicalize (s_uri), iri_canonicalize (p_uri), o_val);\n"
"}\n"
"commit work;\n"
"if (__tag of XML = __tag (o_val))\n"
"{\n"
"DB.DBA.TTLP_EV_TRIPLE_L_W (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]);\n"
"return;\n"
"}\n"
"app_env[1] := coalesce (app_env[1], 0) + 1;\n"
"DB.DBA.TTLP_EV_TRIPLE_L_W (g_iid, s_uri, p_uri, o_val, o_type, o_lang, app_env[2]);\n"
"if (mod (app_env[1], 100000) = 0)\n"
"{\n"
"declare ro_id_dict any;\n"
"ro_id_dict := app_env[2][1];\n"
"if (ro_id_dict is not null)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (g_iid, ro_id_dict);\n"
"}\n"
"}\n"
"--src sparql.sql:13446\n";

static const char *proc338 = 
"#line 13481 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.TTLP_EV_COMMIT_R (\n"
"inout graph_iri varchar, inout app_env any )\n"
"{\n"
"\n"
"DB.DBA.TTLP_EV_COMMIT (graph_iri, app_env[2]);\n"
"}\n"
"--src sparql.sql:13479\n";

static const char *proc339 = 
"#line 13489 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.TTLP_MT (in strg varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP_MT()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP_MT() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (strg, 0, base, graph, flags);\n"
"return;\n"
"}\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector ( async_queue (threads),\n"
"0,\n"
"vector (log_mode, null),\n"
"__max (length (strg) / 100, 100000),\n"
"null );\n"
"rdf_load_turtle (strg, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return graph;\n"
"}\n"
"--src sparql.sql:13487\n";

static const char *proc340 = 
"#line 13534 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.TTLP_MT_LOCAL_FILE (in filename varchar, in base varchar, in graph varchar := null, in flags integer := 0,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.TTLP_MT_LOCAL_FILE()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.TTLP_MT_LOCAL_FILE() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.TTLP_CL (filename, 1, base, graph, flags);\n"
"return;\n"
"}\n"
"app_env := vector (\n"
"async_queue (threads),\n"
"0,\n"
"vector (log_mode, null),\n"
"1000000,\n"
"null );\n"
"rdf_load_turtle_local_file (filename, base, graph, flags,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env);\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return graph;\n"
"}\n"
"--src sparql.sql:13532\n";

static const char *proc341 = 
"#line 13578 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_LOAD_RDFXML_MT (in strg varchar, in base varchar, in graph varchar,\n"
"in log_mode integer := 2, in threads integer := 3, in transactional int := 0)\n"
"{\n"
"declare ro_id_dict, app_env any;\n"
"if (graph = \'\')\n"
"signal (\'22023\', \'Empty string is not a valid graph IRI in DB.DBA.RDFL_LOAD_RDFXML_MT()\');\n"
"else if (graph is null)\n"
"{\n"
"graph := base;\n"
"if ((graph is null) or (graph = \'\'))\n"
"signal (\'22023\', \'DB.DBA.RDF_LOAD_RDFXML_MT() requires a valid IRI as a base argument if graph is not specified\');\n"
"}\n"
"if (transactional = 0)\n"
"{\n"
"if (log_mode = 1 or log_mode = 0)\n"
"log_mode := log_mode + 2;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return DB.DBA.RDF_LOAD_RDFXML_CL (strg, base, graph, 0);\n"
"if (__rdf_obj_ft_rule_count_in_graph (iri_to_id (graph)))\n"
"ro_id_dict := dict_new ();\n"
"else\n"
"ro_id_dict := null;\n"
"app_env := vector (\n"
"async_queue (threads),\n"
"0,\n"
"vector (log_mode, ro_id_dict),\n"
"__max (length (strg) / 100, 100000),\n"
"null );\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph,\n"
"vector (\n"
"\'DB.DBA.TTLP_EV_NEW_GRAPH_A\',\n"
"\'DB.DBA.TTLP_EV_NEW_BLANK\',\n"
"\'!iri_to_id\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_A\',\n"
"\'DB.DBA.TTLP_EV_TRIPLE_L_A\',\n"
"\'DB.DBA.TTLP_EV_COMMIT_A\',\n"
"\'DB.DBA.TTLP_EV_REPORT_DEFAULT\' ),\n"
"app_env,\n"
"base );\n"
"if (__rdf_graph_is_in_enabled_repl (iri_to_id (graph)))\n"
"repl_text (\'__rdf_repl\', \'__rdf_repl_flush_queue ()\');\n"
"return graph;\n"
"}\n"
"--src sparql.sql:13576\n";

static const char *proc342 = 
"#line 13629 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.VT_DECODE_KEYWORD_ITM (inout vtdata varchar, inout ofs integer)\n"
"{\n"
"declare res integer;\n"
"if ((5 <> vtdata[ofs]) or (0 <> vtdata[ofs+5]))\n"
"signal (\'23023\', \'Invalid VT_WORD data in DB.DBA.VT_DECODE_KEYWORD_ITM\');\n"
"res := (((vtdata[ofs+1] * 256) + vtdata[ofs+2]) * 256 + vtdata[ofs+3]) * 256 + vtdata[ofs+4];\n"
"ofs := ofs + 6;\n"
"return res;\n"
"}\n"
"--src sparql.sql:13627\n";

static const char *proc343 = 
"#line 13640 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.VT_ENCODE_KEYWORD_ITM (in id integer, inout ses any)\n"
"{\n"
"declare strg varchar;\n"
"strg := \'012345\';\n"
"strg[5] := 0;\n"
"strg[4] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[3] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[2] := bit_and (id, 255); id := bit_shift (id, -8);\n"
"strg[1] := bit_and (id, 255); if (id > 255) signal (\'22023\', \'Abnormally big document id in DB.DBA.VT_ENCODE_KEYWORD_ITM\');\n"
"strg[0] := 5;\n"
"http (strg, ses);\n"
"}\n"
"--src sparql.sql:13638\n";

static const char *proc344 = 
"#line 13654 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (\n"
"inout carry_d_id integer,\n"
"inout carry_d_id_2 integer,\n"
"inout carry_data varchar,\n"
"in old_d_id integer,\n"
"in old_d_id_2 integer,\n"
"in old_data varchar,\n"
"inout ro_id_offset integer,\n"
"inout new_ro_ids any )\n"
"returns any\n"
"{\n"
"declare res_acc, mix_ses any;\n"
"declare old_data_ofs, old_data_len, old_curr_id, mix_id integer;\n"
"declare new_ro_id_idx, new_ro_ids_count, mix_d_id, mix_d_id_2, mix_count integer;\n"
"\n"
"vectorbld_init (res_acc);\n"
"mix_ses := string_output();\n"
"if (carry_data <> \'\')\n"
"{\n"
"mix_d_id := carry_d_id;\n"
"mix_d_id_2 := carry_d_id_2;\n"
"http (carry_data, mix_ses);\n"
"mix_count := length (carry_data) / 6;\n"
"}\n"
"else\n"
"{\n"
"mix_d_id := null;\n"
"mix_d_id_2 := null;\n"
"mix_count := 0;\n"
"}\n"
"old_data_ofs := 0;\n"
"if (old_data is null)\n"
"old_curr_id := null;\n"
"else\n"
"old_curr_id := DB.DBA.VT_DECODE_KEYWORD_ITM (old_data, old_data_ofs);\n"
"old_data_len := length (old_data);\n"
"new_ro_ids_count := length (new_ro_ids);\n"
"new_ro_id_idx := ro_id_offset;\n"
"if (new_ro_id_idx < new_ro_ids_count)\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"else\n"
"mix_id := null;\n"
"\n"
"mix_d_id := __min_notnull (mix_d_id, old_curr_id, mix_id);\n"
"\n"
"\n"
"next_mix:\n"
"if (old_curr_id is null)\n"
"{\n"
"if ((new_ro_id_idx >= new_ro_ids_count) or (new_ro_ids [new_ro_id_idx] > old_d_id_2))\n"
"goto complete;\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"}\n"
"else\n"
"{\n"
"if ((new_ro_id_idx >= new_ro_ids_count) or (new_ro_ids [new_ro_id_idx] >= old_curr_id))\n"
"{\n"
"if ((new_ro_id_idx < new_ro_ids_count) and (new_ro_ids [new_ro_id_idx] = old_curr_id))\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"mix_id := old_curr_id;\n"
"if (old_data_ofs >= old_data_len)\n"
"old_curr_id := null;\n"
"else\n"
"old_curr_id := DB.DBA.VT_DECODE_KEYWORD_ITM (old_data, old_data_ofs);\n"
"}\n"
"else\n"
"{\n"
"mix_id := new_ro_ids [new_ro_id_idx];\n"
"new_ro_id_idx := new_ro_id_idx + 1;\n"
"}\n"
"}\n"
"if ((mix_count > 180) or ((mix_d_id_2 / 10000) <> (mix_id  / 10000)))\n"
"{\n"
"\n"
"vectorbld_acc (res_acc, vector (mix_d_id, mix_d_id_2, string_output_string (mix_ses)));\n"
"mix_ses := string_output ();\n"
"mix_d_id := mix_id;\n"
"mix_count := 0;\n"
"}\n"
"DB.DBA.VT_ENCODE_KEYWORD_ITM (mix_id, mix_ses);\n"
"mix_d_id_2 := mix_id;\n"
"mix_count := mix_count + 1;\n"
"goto next_mix;\n"
"\n"
"complete:\n"
"ro_id_offset := new_ro_id_idx;\n"
"if (mix_count > 150)\n"
"{\n"
"\n"
"vectorbld_acc (res_acc, vector (mix_d_id, mix_d_id_2, string_output_string (mix_ses)));\n"
"carry_data := \'\';\n"
"carry_d_id := carry_d_id_2 := null;\n"
"}\n"
"else\n"
"{\n"
"carry_data := string_output_string (mix_ses);\n"
"carry_d_id := mix_d_id;\n"
"carry_d_id_2 := mix_d_id_2;\n"
"}\n"
"vectorbld_final (res_acc);\n"
"\n"
"return res_acc;\n"
"}\n"
"--src sparql.sql:13652\n";

static const char *proc345 = 
"#line 13761 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_GRAPH (in phrase varchar, in graph_iri varchar)\n"
"{\n"
"declare graph_keyword any;\n"
"whenever sqlstate \'*\' goto err;\n"
"graph_keyword := iri_to_id (graph_iri, 0, 0);\n"
"if (isinteger (graph_keyword))\n"
"goto err;\n"
"graph_keyword := WS.WS.STR_SQL_APOS (rdf_graph_keyword  (graph_keyword));\n"
"return sprintf (\'[__enc \"UTF-8\"] ^%s AND (%s)\', graph_keyword, phrase);\n"
"err:\n"
"return \'^\"#nosuch\"\';\n"
"}\n"
"--src sparql.sql:13759\n";

static const char *proc346 = 
"#line 13776 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_MANY_GRAPHS (in phrase varchar, in graph_iris any)\n"
"{\n"
"declare isfirst, gctr, gcount integer;\n"
"declare ses, graph_keyword any;\n"
"whenever sqlstate \'*\' goto err;\n"
"gcount := length (graph_iris);\n"
"ses := string_output ();\n"
"isfirst := 1;\n"
"for (gctr := 0; gctr < gcount; gctr := gctr + 1)\n"
"{\n"
"graph_keyword := iri_to_id (graph_iris[gctr], 0, 0);\n"
"if (not isinteger (graph_keyword))\n"
"{\n"
"if (isfirst)\n"
"{\n"
"http (\'^\', ses);\n"
"isfirst := 0;\n"
"}\n"
"else\n"
"http (\' OR ^\', ses);\n"
"http (WS.WS.STR_SQL_APOS (rdf_graph_keyword (graph_keyword)), ses);\n"
"}\n"
"}\n"
"if (not isfirst)\n"
"return sprintf (\'[__enc \"UTF-8\"] (%s) AND (%s)\', string_output_string (ses), phrase);\n"
"err:\n"
"return \'^\"#nosuch\"\';\n"
"}\n"
"--src sparql.sql:13774\n";

static const char *proc347 = 
"#line 13806 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (in graph_iid IRI_ID, inout ro_id_dict any, in daq any := 0)\n"
"{\n"
"declare ro_id_offset, ro_ids_count integer;\n"
"declare new_ro_ids, vtb any;\n"
"declare gwordump varchar;\n"
"declare n_w, n_ins, n_upd, n_next integer;\n"
"next_batch:\n"
"new_ro_ids := dict_destructive_list_rnd_keys (ro_id_dict, 500000);\n"
"ro_ids_count := length (new_ro_ids);\n"
"if (0 = ro_ids_count)\n"
"return;\n"
"gwordump := \' \' || rdf_graph_keyword (graph_iid);\n"
"gwordump[0] := length (gwordump) - 1;\n"
"gvector_digit_sort (new_ro_ids, 1, 0, 1);\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"commit work;\n"
"cl_g_words (new_ro_ids, gwordump, daq);\n"
"goto next_batch;\n"
"}\n"
"vtb := vt_batch (__min (__max (ro_ids_count, 31), 500000));\n"
"commit work;\n"
"whenever sqlstate \'40001\' goto retry_add;\n"
"again:\n"
"for (ro_id_offset := 0; ro_id_offset < ro_ids_count; ro_id_offset := ro_id_offset + 1)\n"
"{\n"
"vt_batch_d_id (vtb, new_ro_ids[ro_id_offset]);\n"
"vt_batch_feed_wordump (vtb, gwordump, 0);\n"
"}\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"declare is_local_daq int;\n"
"if (0 = daq)\n"
"{\n"
"daq := daq (1);\n"
"is_local_daq := 1;\n"
"}\n"
"cl_g_text_index (vtb, daq);\n"
"if (is_local_daq)\n"
"{\n"
"while (daq_next (daq));\n"
"commit work;\n"
"goto next_batch;\n"
"}\n"
"}\n"
"else\n"
"\"DB\".\"DBA\".\"VT_BATCH_PROCESS_DB_DBA_RDF_OBJ\" (vtb, null);\n"
"commit work;\n"
"goto next_batch;\n"
"retry_add:\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:13804\n";

static const char *proc348 = 
"#line 13861 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH_OLD (in graph_iid IRI_ID, inout ro_id_dict any)\n"
"{\n"
"declare start_vt_d_id, aligned_start_vt_d_id, uncommited_ro_id_offset, ro_id_offset, ro_ids_count integer;\n"
"declare old_d_id, old_d_id_2, carry_d_id, carry_d_id_2 integer;\n"
"declare old_data, carry_data varchar;\n"
"declare split_ctr, split_len integer;\n"
"declare dbg_smallest_d_id, dbg_largest_d_id, dbg_prev_d_id, dbg_prev_d_id_2 integer;\n"
"declare split any;\n"
"declare cr cursor for (\n"
"select VT_D_ID, VT_D_ID_2, coalesce (VT_DATA, cast (VT_LONG_DATA as varchar)) from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= aligned_start_vt_d_id) and VT_D_ID_2 >= start_vt_d_id for update);\n"
"declare new_ro_ids any;\n"
"\n"
"new_ro_ids := dict_list_keys (ro_id_dict, 2);\n"
"ro_ids_count := length (new_ro_ids);\n"
"if (0 = ro_ids_count)\n"
"return;\n"
"gvector_digit_sort (new_ro_ids, 1, 0, 1);\n"
"\n"
"dbg_smallest_d_id := new_ro_ids[0];\n"
"dbg_largest_d_id := new_ro_ids[length (new_ro_ids) - 1];\n"
"dbg_prev_d_id := 0;\n"
"dbg_prev_d_id_2 := 0;\n"
"\n"
"commit work;\n"
"whenever sqlstate \'40001\' goto retry_add;\n"
"uncommited_ro_id_offset := 0;\n"
"again:\n"
"ro_id_offset := uncommited_ro_id_offset;\n"
"start_vt_d_id := new_ro_ids[ro_id_offset];\n"
"aligned_start_vt_d_id := ((start_vt_d_id / 10000) * 10000);\n"
"carry_d_id := 0;\n"
"carry_d_id_2 := 0;\n"
"carry_data := \'\';\n"
"set isolation = \'serializable\';\n"
"whenever not found goto no_more_olds;\n"
"open cr (prefetch 1);\n"
"\n"
"next_split:\n"
"fetch cr into old_d_id, old_d_id_2, old_data;\n"
"split := DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (carry_d_id, carry_d_id_2, carry_data, old_d_id, old_d_id_2, old_data, ro_id_offset, new_ro_ids);\n"
"split_len := length (split);\n"
"split_ctr := 0;\n"
"if ((split_len > 0) and (split[split_len-1][0] = old_d_id))\n"
"{\n"
"if ((old_d_id_2 = split[split_len-1][1]) and (old_data = split[split_len-1][2]))\n"
"{ ; }\n"
"else\n"
"update RDF_OBJ_RO_FLAGS_WORDS set VT_D_ID_2 = split[split_len-1][1], VT_DATA = split[split_len-1][2], VT_LONG_DATA = null\n"
"where current of cr;\n"
"split_len := split_len - 1;\n"
"}\n"
"if (split_len > 0)\n"
"{\n"
"delete from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= split[0][0]) and (VT_D_ID_2 <= split[split_len-1][1]);\n"
"}\n"
"for (split_ctr := 0; split_ctr < split_len; split_ctr := split_ctr+1)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), split[split_ctr][0], split[split_ctr][1], split[split_ctr][2]);\n"
"}\n"
"if (carry_data = \'\')\n"
"{\n"
"commit work;\n"
"uncommited_ro_id_offset := ro_id_offset;\n"
"if (ro_id_offset >= ro_ids_count)\n"
"{\n"
"start_vt_d_id := 1024 * 65536 * 65536 * 65536;\n"
"goto no_more_olds;\n"
"}\n"
"start_vt_d_id := new_ro_ids[uncommited_ro_id_offset];\n"
"aligned_start_vt_d_id := ((start_vt_d_id / 10000) * 10000);\n"
"close cr;\n"
"open cr (prefetch 1);\n"
"}\n"
"goto next_split;\n"
"\n"
"no_more_olds:\n"
"split := DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES (carry_d_id, carry_d_id_2, carry_data, null, null, null, ro_id_offset, new_ro_ids);\n"
"split_len := length (split);\n"
"split_ctr := 0;\n"
"if (split_len > 0)\n"
"{\n"
"delete from RDF_OBJ_RO_FLAGS_WORDS\n"
"where (VT_WORD = cast (graph_iid as varchar)) and (VT_D_ID >= split[0][0]) and (VT_D_ID_2 <= split[split_len-1][1]);\n"
"}\n"
"for (split_ctr := 0; split_ctr < split_len; split_ctr := split_ctr+1)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), split[split_ctr][0], split[split_ctr][1], split[split_ctr][2]);\n"
"}\n"
"if (length (carry_data)  <> 0)\n"
"{\n"
"insert replacing RDF_OBJ_RO_FLAGS_WORDS (VT_WORD, VT_D_ID, VT_D_ID_2, VT_DATA)\n"
"values (cast (graph_iid as varchar), carry_d_id, carry_d_id_2, carry_data);\n"
"}\n"
"commit work;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return;\n"
"retry_add:\n"
"close cr;\n"
"rollback work;\n"
"goto again;\n"
"}\n"
"--src sparql.sql:13859\n";

static const char *proc349 = 
"#line 13988 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_FT_RULE_ADD (in rule_g varchar, in rule_p varchar, in reason varchar) returns integer\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"declare ro_id_dict any;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"signal (\'42000\', \'rdf_obj_ft_rule_add not available in cluster.  Do cl_text_index (1) to enable text index on all future rdf loads on cluster.\');\n"
"if (rule_g is null)\n"
"rule_g := \'\';\n"
"if (rule_p is null)\n"
"rule_p := \'\';\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"if (reason is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_OBJ_FT_RULE_ADD() expects string as argument 3\');\n"
"if (exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason))\n"
"return 0;\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where (ROFR_G = rule_g or ROFR_G = \'\') and (ROFR_P = rule_p or ROFR_P = \'\') ) )\n"
"{\n"
"\n"
"commit work;\n"
"exec (\'checkpoint\');\n"
"__atomic (1);\n"
"declare exit handler for sqlstate \'*\' {\n"
"__atomic (0);\n"
"signal (__SQL_STATE, __SQL_MESSAGE); };\n"
"if ((rule_g <> \'\') and (rule_p <> \'\'))\n"
"{\n"
"ro_id_dict := dict_new (100000);\n"
"for (select O as obj from DB.DBA.RDF_QUAD where G=rule_g_iid and P=rule_p_iid and not isiri_id (O)) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"else if (rule_g <> \'\')\n"
"{\n"
"ro_id_dict := dict_new (100000);\n"
"for (select O as obj from DB.DBA.RDF_QUAD where G=rule_g_iid and not isiri_id (O)) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"}\n"
"commit work;\n"
"}\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (iri_to_id (rule_g), ro_id_dict);\n"
"}\n"
"else\n"
"{\n"
"declare old_g IRI_ID;\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := #i0;\n"
"for (select O as obj, G as curr_g from DB.DBA.RDF_QUAD where ((rule_p = \'\') or equ (P,rule_p_iid)) and not isiri_id (O) ) do\n"
"{\n"
"if (isstring (obj))\n"
"{\n"
"if (curr_g <> old_g)\n"
"{\n"
"if (old_g <> #i0)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := curr_g;\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD (257, obj, 257, ro_id_dict);\n"
"commit work;\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (curr_g, ro_id_dict);\n"
"}\n"
"else\n"
"{\n"
"declare id integer;\n"
"id := rdf_box_ro_id (obj);\n"
"if (0 <> id)\n"
"{\n"
"if (curr_g <> old_g)\n"
"{\n"
"if (old_g <> #i0)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"ro_id_dict := dict_new (100000);\n"
"old_g := curr_g;\n"
"}\n"
"update DB.DBA.RDF_OBJ set RO_FLAGS = bit_or (RO_FLAGS, 1) where RO_ID = id and not (bit_and (RO_FLAGS, 1));\n"
"\n"
"dict_put (ro_id_dict, id, 1);\n"
"commit work;\n"
"if (dict_size (ro_id_dict) > 100000)\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (curr_g, ro_id_dict);\n"
"}\n"
"}\n"
"}\n"
"DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH (old_g, ro_id_dict);\n"
"commit work;\n"
"}\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"insert into DB.DBA.RDF_OBJ_FT_RULES (ROFR_G, ROFR_P, ROFR_REASON) values (rule_g, rule_p, reason);\n"
"commit work;\n"
"__rdf_obj_ft_rule_add (rule_g_iid, rule_p_iid, reason);\n"
"return 1;\n"
"}\n"
"--src sparql.sql:13986\n";

static const char *proc350 = 
"#line 14127 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_OBJ_FT_RULE_DEL (in rule_g varchar, in rule_p varchar, in reason varchar) returns integer\n"
"{\n"
"declare rule_g_iid, rule_p_iid IRI_ID;\n"
"if (rule_g is null)\n"
"rule_g := \'\';\n"
"if (rule_p is null)\n"
"rule_p := \'\';\n"
"rule_g_iid := case (rule_g) when \'\' then null else iri_to_id (rule_g) end;\n"
"rule_p_iid := case (rule_p) when \'\' then null else iri_to_id (rule_p) end;\n"
"if (reason is null)\n"
"signal (\'RDFXX\', \'DB.DBA.RDF_OBJ_FT_RULE_DEL() expects string as argument 3\');\n"
"if (not exists (\n"
"select top 1 1 from DB.DBA.RDF_OBJ_FT_RULES\n"
"where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason))\n"
"return 0;\n"
"delete from DB.DBA.RDF_OBJ_FT_RULES where ROFR_G = rule_g and ROFR_P = rule_p and ROFR_REASON = reason;\n"
"commit work;\n"
"__rdf_obj_ft_rule_del (rule_g_iid, rule_p_iid, reason);\n"
"return 1;\n"
"}\n"
"--src sparql.sql:14125\n";

static const char *proc351 = 
"#line 14149 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_OBJ_FT_RECOVER ()\n"
"{\n"
"declare stat, msg, STRG varchar;\n"
"declare metas, rset any;\n"
"result_names (STRG);\n"
"exec (\'\n"
"select ROFR_G, ROFR_P, MAX (ROFR_REASON), COUNT (1), MIN (ROFR_REASON)\n"
"from DB.DBA.RDF_OBJ_FT_RULES\n"
"group by ROFR_G, ROFR_P\n"
"order by (1024 * length (ROFR_G) + 1024 * length (ROFR_P))\',\n"
"stat, msg, vector (), 100000, metas, rset);\n"
"foreach (any ftrule in rset) do\n"
"{\n"
"result (sprintf (\'Temporary drop of rule \"%s\" for graph <%s> predicate <%s>...\', ftrule[2], ftrule[0], ftrule[1]));\n"
"{ whenever sqlstate \'*\' goto add_back;\n"
"DB.DBA.RDF_OBJ_FT_RULE_DEL (ftrule[0], ftrule[1], ftrule[2]);\n"
"result (\'... done\'); }\n"
"add_back:\n"
"result (sprintf (\'Restoring rule \"%s\" for graph <%s> predicate <%s>...\', ftrule[2], ftrule[0], ftrule[1]));\n"
"{ whenever sqlstate \'*\' goto restored;\n"
"DB.DBA.RDF_OBJ_FT_RULE_ADD (ftrule[0], ftrule[1], ftrule[2]);\n"
"result (\'... done\'); }\n"
"restored:\n"
"if (ftrule[3] > 1)\n"
"result (sprintf (\'No need to re-apply additional %d rules for this graph and predicate, e.g., rule \"%s\"\', ftrule[4]));\n"
"}\n"
"result (\'Now starting incremental update of free-text index...\');\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"result (\'... done\');\n"
"}\n"
"--src sparql.sql:14147\n";

static const char *tbl16 = 
"create table DB.DBA.RDF_GRAPH_GROUP (\n"
"RGG_IID IRI_ID not null primary key,\n"
"RGG_IRI varchar not null,\n"
"RGG_MEMBER_PATTERN varchar,\n"
"RGG_COMMENT varchar\n"
")\n"
"alter index RDF_GRAPH_GROUP on DB.DBA.RDF_GRAPH_GROUP partition cluster replicated\n"
"create index RDF_GRAPH_GROUP_IRI on DB.DBA.RDF_GRAPH_GROUP (RGG_IRI) partition cluster replicated\n";

static const char *tbl17 = 
"create table DB.DBA.RDF_GRAPH_GROUP_MEMBER (\n"
"RGGM_GROUP_IID IRI_ID not null,\n"
"RGGM_MEMBER_IID IRI_ID not null,\n"
"primary key (RGGM_GROUP_IID, RGGM_MEMBER_IID)\n"
")\n"
"alter index RDF_GRAPH_GROUP_MEMBER on DB.DBA.RDF_GRAPH_GROUP_MEMBER partition cluster replicated\n";

static const char *tbl18 = 
"create table DB.DBA.RDF_GRAPH_USER (\n"
"RGU_GRAPH_IID IRI_ID not null,\n"
"RGU_USER_ID integer not null,\n"
"RGU_PERMISSIONS integer not null,\n"
"primary key (RGU_GRAPH_IID, RGU_USER_ID)\n"
")\n"
"alter index RDF_GRAPH_USER on DB.DBA.RDF_GRAPH_USER partition cluster replicated\n"
"create index RDF_GRAPH_USER_USER_ID on DB.DBA.RDF_GRAPH_USER (RGU_USER_ID, RGU_GRAPH_IID, RGU_PERMISSIONS) partition cluster replicated\n";

static const char *proc352 = 
"#line 14212 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_CACHE_IID (in iid IRI_ID)\n"
"{\n"
"declare iri any;\n"
"iri := __uname (id_to_canonicalized_iri (iid));\n"
"dict_put (__rdf_graph_iri2id_dict(), iri, iid);\n"
"dict_put (__rdf_graph_id2iri_dict(), iid, iri);\n"
"}\n"
"--src sparql.sql:14210\n";

static const char *proc353 = 
"#line 14221 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_CREATE_MEMONLY (in group_iri varchar, in group_iid IRI_ID)\n"
"{\n"
"group_iri := cast (group_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (group_iid);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector ());\n"
"jso_mark_affected (group_iri);\n"
"log_text (\'jso_mark_affected (?)\', group_iri);\n"
"__rdf_cli_mark_qr_to_recompile ();\n"
"}\n"
"--src sparql.sql:14219\n";

static const char *proc354 = 
"#line 14232 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK (in group_iri varchar, in fname varchar) returns IRI_ID\n"
"{\n"
"declare group_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"if (group_iri <> id_to_canonicalized_iri (group_iid))\n"
"signal (\'RDF99\', sprintf (\'Group IRI should be canonical, but the specified group IRI <%s> differs from its canonical form <%s>\', group_iri, id_to_canonicalized_iri (group_iid)));\n"
"for (select RGG_IID from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri) do\n"
"{\n"
"if (RGG_IID = group_iid)\n"
"return RGG_IID;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IID = group_iid))\n"
"signal (\'RDF99\', sprintf (\'Integrity violation in DB.DBA.RDF_GRAPH_GROUP table (found group IRI <%s>, not found group IRI ID %s)\', group_iri, cast (group_iid as varchar)));\n"
"}\n"
"for (select RGG_IRI from DB.DBA.RDF_GRAPH_GROUP where RGG_IID = group_iid) do\n"
"{\n"
"if (RGG_IRI = id_to_canonicalized_iri (group_iid))\n"
"signal (\'RDF99\', sprintf (\'Table DB.DBA.RDF_GRAPH_GROUP contains group with IRI <%s>, not IRI <%s>, for group IRI ID %s\', RGG_IRI, group_iri, cast (group_iid as varchar)));\n"
"signal (\'RDF99\', sprintf (\'Integrity violation in DB.DBA.RDF_GRAPH_GROUP table (not found group IRI <%s>, found group IRI ID %s)\', group_iri, cast (group_iid as varchar)));\n"
"}\n"
"return NULL;\n"
"}\n"
"--src sparql.sql:14230\n";

static const char *proc355 = 
"#line 14256 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_CREATE (in group_iri varchar, in quiet integer, in member_pattern varchar := null, in comment varchar := null)\n"
"{\n"
"declare group_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK (group_iri, \'DB.DBA.RDF_GRAPH_GROUP_CREATE\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"{\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> already exists (%s)\', group_iri, coalesce (\n"
"(select top 1 RGG_COMMENT from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri), \'group has no comment\' ) ) );\n"
"}\n"
"insert into DB.DBA.RDF_GRAPH_GROUP (\n"
"RGG_IID, RGG_IRI, RGG_MEMBER_PATTERN, RGG_COMMENT )\n"
"values (group_iid, group_iri, member_pattern, comment);\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_CREATE_MEMONLY (?, ?)\', vector (group_iri, group_iid));\n"
"}\n"
"--src sparql.sql:14254\n";

static const char *proc356 = 
"#line 14277 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_DROP_MEMONLY (in group_iri varchar, in group_iid IRI_ID)\n"
"{\n"
"group_iri := cast (group_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (group_iid);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector ());\n"
"dict_remove (__rdf_graph_group_dict(), group_iid);\n"
"jso_mark_affected (group_iri);\n"
"log_text (\'jso_mark_affected (?)\', group_iri);\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"declare privates any;\n"
"privates := dict_list_keys (__rdf_graph_group_of_privates_dict(), 2);\n"
"foreach (IRI_ID iid in privates) do\n"
"{\n"
"jso_mark_affected (id_to_iri (iid));\n"
"log_text (\'jso_mark_affected (?)\', id_to_iri (iid));\n"
"}\n"
"}\n"
"__rdf_cli_mark_qr_to_recompile ();\n"
"}\n"
"--src sparql.sql:14275\n";

static const char *proc357 = 
"#line 14299 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_DROP (in group_iri varchar, in quiet integer)\n"
"{\n"
"declare group_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK (group_iri, \'DB.DBA.RDF_GRAPH_GROUP_DROP\');\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"{\n"
"if (quiet)\n"
"return;\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> does not exist (%s)\', group_iri, coalesce (\n"
"(select top 1 RGG_COMMENT from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri), \'group has no comment\' ) ) );\n"
"}\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"signal (\'RDF99\', sprintf (\'The graph group <%s> is a special one and used to control security, can not drop it\' ) );\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = group_iid;\n"
"delete from DB.DBA.RDF_GRAPH_GROUP where RGG_IID = group_iid;\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_DROP_MEMONLY (?, ?)\', vector (group_iri, group_iid));\n"
"}\n"
"--src sparql.sql:14297\n";

static const char *proc358 = 
"#line 14321 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (in memb_iri varchar, in special_iid IRI_ID)\n"
"{\n"
"declare memb_iid IRI_ID;\n"
"memb_iid := iri_to_id (memb_iri);\n"
"declare new_default_perms integer;\n"
"new_default_perms := (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid());\n"
"for (select g.RGU_PERMISSIONS as g_perms, s.RGU_PERMISSIONS as s_perms, g.RGU_USER_ID as uid\n"
"from DB.DBA.RDF_GRAPH_USER as g left outer join DB.DBA.RDF_GRAPH_USER as s on (g.RGU_USER_ID = s.RGU_USER_ID and s.RGU_GRAPH_IID = special_iid)\n"
"where g.RGU_GRAPH_IID = memb_iid ) do\n"
"{\n"
"if (s_perms is not null and bit_and (s_perms, bit_not (g_perms)))\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of user \"%s\" (UID %d) on RDF store can not be broader than permissions on specific graph <%s> so the graph can not be %s now\',\n"
"case (equ (special_iid, #i8192)) when 0 then \'\"world\"\' else \'\"private area\"\' end,\n"
"(select U_NAME from DB.DBA.SYS_USERS where U_ID = uid),\n"
"uid,\n"
"memb_iri,\n"
"case (equ (special_iid, #i8192)) when 0 then \'removed from the \"private area\"\' else \'added to the \"private area\"\' end ) );\n"
"if (new_default_perms is not null and bit_and (new_default_perms, bit_not (g_perms)))\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of unauthenticated user on RDF store can not be broader than permissions of user \"%s\" (UID %d)  on specific graph <%s> so the graph can not be %s now\',\n"
"case (equ (special_iid, #i8192)) when 0 then \'\"world\"\' else \'\"private area\"\' end,\n"
"(select U_NAME from DB.DBA.SYS_USERS where U_ID = uid),\n"
"uid,\n"
"memb_iri,\n"
"case (equ (special_iid, #i8192)) when 0 then \'removed from the \"private area\"\' else \'added to the \"private area\"\' end ) );\n"
"}\n"
"}\n"
"--src sparql.sql:14319\n";

static const char *proc359 = 
"#line 14349 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY (in group_iri varchar, in group_iid IRI_ID, in memb_iri varchar, in memb_iid IRI_ID)\n"
"{\n"
"declare membs any;\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (group_iid);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (memb_iid);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"membs := dict_get (__rdf_graph_group_dict(), group_iid, null);\n"
"if (membs is null)\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector (memb_iid));\n"
"else if (isvector (membs))\n"
"{\n"
"if (0 >= position (memb_iid, membs))\n"
"{\n"
"if (length (membs) < 1000)\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector_concat (membs, vector (memb_iid)));\n"
"else\n"
"{\n"
"declare new_membs any;\n"
"new_membs := dict_new (1000);\n"
"foreach (IRI_ID m in membs) do dict_put (new_membs, m, 1);\n"
"dict_put (new_membs, memb_iid, 1);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, new_membs);\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"dict_put (membs, memb_iid, 1);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, membs);\n"
"}\n"
"jso_mark_affected (group_iri);\n"
"log_text (\'jso_mark_affected (?)\', group_iri);\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"dict_put (__rdf_graph_group_of_privates_dict(), memb_iid, 1);\n"
"jso_mark_affected (memb_iri);\n"
"log_text (\'jso_mark_affected (?)\', memb_iri);\n"
"}\n"
"}\n"
"--src sparql.sql:14347\n";

static const char *proc360 = 
"#line 14396 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_INS (in group_iri varchar, in memb_iri varchar)\n"
"{\n"
"declare group_iid, memb_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK (group_iri, \'DB.DBA.RDF_GRAPH_GROUP_INS\');\n"
"memb_iri := cast (memb_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"memb_iid := iri_to_id (memb_iri);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"signal (\'RDF99\', sprintf (\'Graph group <%s> does not exist\', group_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (memb_iri, #i8192);\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\'))\n"
"and exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\') and RGGM_MEMBER_IID = memb_iid)\n"
"and not exists (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID = memb_iid and RGU_USER_ID = http_nobody_uid() and bit_and (RGU_PERMISSIONS, 1) )\n"
"and not exists (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = http_nobody_uid() and bit_and (RGU_PERMISSIONS, 1) )\n"
"and not exists (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID = memb_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1) )\n"
"and not exists (select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1) ) )\n"
"signal (\'RDF99\', \'Can not add graph <\' || memb_iri || \'> to group of private graphs <\' || group_iri || \'>; either stop the RDF replication of this graph or grant an explicit read permission to __rdf_repl account\');\n"
"}\n"
"else if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\')\n"
"{\n"
"if (memb_iri = DB.DBA.JSO_SYS_GRAPH())\n"
"signal (\'RDF99\', \'Graph group <\' || group_iri || \'> is for RDF replication; can not enable RDF replication of <\' || memb_iri || \'> (the system metadata graph)\');\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')) and not __rgs_ack_cbk (memb_iid, __rdf_repl_uid(), 1))\n"
"signal (\'RDF99\', \'Graph group <\' || group_iri || \'> is for RDF replication; can not enable RDF replication of graph <\' || memb_iri || \'> because it is not readable by __rdf_repl account\');\n"
"}\n"
"insert soft DB.DBA.RDF_GRAPH_GROUP_MEMBER (RGGM_GROUP_IID, RGGM_MEMBER_IID)\n"
"values (group_iid, memb_iid);\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY (?, ?, ?, ?)\', vector (group_iri, group_iid, memb_iri, memb_iid));\n"
"}\n"
"--src sparql.sql:14394\n";

static const char *proc361 = 
"#line 14438 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY (in group_iri varchar, in group_iid IRI_ID, in memb_iri varchar, in memb_iid IRI_ID)\n"
"{\n"
"declare membs any;\n"
"group_iri := cast (group_iri as varchar);\n"
"memb_iri := cast (memb_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (group_iid);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (memb_iid);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"membs := dict_get (__rdf_graph_group_dict(), group_iid, null);\n"
"if (membs is null)\n"
"dict_put (__rdf_graph_group_dict(), group_iid, vector ());\n"
"else if (isvector (membs))\n"
"{\n"
"declare p integer;\n"
"again:\n"
"p := position (memb_iid, membs);\n"
"if (p > 0)\n"
"{\n"
"membs := vector_concat (subseq (membs, 0, p-1), subseq (membs, p));\n"
"goto again;\n"
"}\n"
"dict_put (__rdf_graph_group_dict(), group_iid, membs);\n"
"}\n"
"else\n"
"{\n"
"dict_remove (membs, memb_iid);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, membs);\n"
"}\n"
"jso_mark_affected (group_iri);\n"
"log_text (\'jso_mark_affected (?)\', group_iri);\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"{\n"
"dict_remove (__rdf_graph_group_of_privates_dict(), memb_iid);\n"
"jso_mark_affected (memb_iri);\n"
"log_text (\'jso_mark_affected (?)\', memb_iri);\n"
"}\n"
"}\n"
"--src sparql.sql:14436\n";

static const char *proc362 = 
"#line 14481 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_GROUP_DEL (in group_iri varchar, in memb_iri varchar)\n"
"{\n"
"declare group_iid, memb_iid IRI_ID;\n"
"group_iri := cast (group_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK (group_iri, \'DB.DBA.RDF_GRAPH_GROUP_DEL\');\n"
"memb_iri := cast (memb_iri as varchar);\n"
"group_iid := iri_to_id (group_iri);\n"
"memb_iid := iri_to_id (memb_iri);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = group_iri))\n"
"signal (\'RDF99\', sprintf (\'Graph group <%s> does not exist\', group_iri));\n"
"if (group_iri = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE (memb_iri, #i0);\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = group_iid and RGGM_MEMBER_IID = memb_iid;\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY (?, ?, ?, ?)\', vector (group_iri, group_iid, memb_iri, memb_iid));\n"
"}\n"
"--src sparql.sql:14479\n";

static const char *proc363 = 
"#line 14502 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_GRAPH_USER_PERMS_GET (in graph_iri varchar, in uid any) returns integer\n"
"{\n"
"declare graph_iid IRI_ID;\n"
"declare res integer;\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"return 0;\n"
"if (uid = 0)\n"
"return 1023;\n"
"res := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid),\n"
"__rdf_graph_approx_perms (graph_iid, uid) );\n"
"return res;\n"
"}\n"
"--src sparql.sql:14500\n";

static const char *proc364 = 
"#line 14520 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_GRAPH_USER_PERMS_ACK (in graph_iri any, in uid any, in req_perms integer) returns integer\n"
"{\n"
"declare app_cbk, app_uid varchar;\n"
"declare graph_iid IRI_ID;\n"
"declare perms integer;\n"
"\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (__tag (uid) = __tag of vector)\n"
"{\n"
"app_cbk := uid[1];\n"
"app_uid := uid[2];\n"
"uid := uid[0];\n"
"}\n"
"else\n"
"app_cbk := NULL;\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"perms := 0;\n"
"else if (uid = 0)\n"
"perms := 1023;\n"
"else\n"
"{\n"
"perms := __rdf_graph_approx_perms (graph_iid, uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"perms := coalesce ((select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid), perms);\n"
"}\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"return 0;\n"
"if (app_cbk is not null)\n"
"{\n"
"perms := call (app_cbk)(graph_iid, app_uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"return 0;\n"
"}\n"
"return 1;\n"
"}\n"
"--src sparql.sql:14518\n";

static const char *proc365 = 
"#line 14560 \"[executable]/sparql.sql\"\n"
" create function DB.DBA.RDF_GRAPH_USER_PERM_TITLE (in perms integer) returns varchar\n"
"{\n"
"if (bit_and (perms, 1))\n"
"return \'read\';\n"
"if (bit_and (perms, 2))\n"
"return \'write\';\n"
"if (bit_and (perms, 4))\n"
"return \'sponge\';\n"
"if (bit_and (perms, 8))\n"
"return \'get-group-list\';\n"
"return sprintf (\'\"%d\"\', perms);\n"
"}\n"
"--src sparql.sql:14558\n";

static const char *proc366 = 
"#line 14574 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT (in graph_iri varchar, in uid any, in req_perms integer, in opname varchar) returns varchar\n"
"{\n"
"declare app_cbk, app_uid varchar;\n"
"declare graph_iid IRI_ID;\n"
"declare perms integer;\n"
"\n"
"return __rgs_assert_cbk (graph_iri, uid, req_perms, opname);\n"
"graph_iid := iri_to_id (graph_iri);\n"
"if (__tag (uid) = __tag of vector)\n"
"{\n"
"app_cbk := uid[1];\n"
"app_uid := uid[2];\n"
"uid := uid[0];\n"
"}\n"
"else\n"
"app_cbk := NULL;\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"perms := 0;\n"
"else if (uid = 0)\n"
"perms := 1023;\n"
"else\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = http_nobody_uid()),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"signal (\'RDF02\', sprintf (\'%s access denied: database user %s (%s) has no %s permission on graph %s\',\n"
"opname, cast (uid as varchar), coalesce ((select top 1 U_NAME from DB.DBA.SYS_USERS where U_ID=uid)),\n"
"DB.DBA.RDF_GRAPH_USER_PERM_TITLE (bit_and (bit_not (perms), req_perms)),\n"
"graph_iri ) );\n"
"if (app_cbk is not null)\n"
"{\n"
"perms := call (app_cbk)(graph_iid, app_uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"signal (\'RDF02\', sprintf (\'%s access denied: application user %s has no %s permission on graph %s\',\n"
"opname, cast (uid as varchar), coalesce ((select top 1 U_NAME from DB.DBA.SYS_USERS where U_ID=uid)),\n"
"DB.DBA.RDF_GRAPH_USER_PERM_TITLE (bit_and (bit_not (perms), req_perms)),\n"
"graph_iri ) );\n"
"}\n"
"return graph_iri;\n"
"}\n"
"--src sparql.sql:14572\n";

static const char *proc367 = 
"#line 14621 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (in uname varchar, in uid integer, in perms integer, in special_iid IRI_ID, in set_private integer, in affected_jso any)\n"
"{\n"
"if (perms is null)\n"
"dict_remove (__rdf_graph_default_perms_of_user_dict (set_private), uid);\n"
"else\n"
"dict_put (__rdf_graph_default_perms_of_user_dict (set_private), uid, perms);\n"
"if (uid = http_nobody_uid())\n"
"{\n"
"if (perms is null)\n"
"dict_remove (__rdf_graph_public_perms_dict(), special_iid);\n"
"else\n"
"dict_put (__rdf_graph_public_perms_dict(), special_iid, perms);\n"
"}\n"
"foreach (varchar jso_key in affected_jso) do\n"
"{\n"
"jso_mark_affected (jso_key);\n"
"log_text (\'jso_mark_affected (?)\', jso_key);\n"
"}\n"
"}\n"
"--src sparql.sql:14619\n";

static const char *proc368 = 
"#line 14642 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_DEFAULT_USER_PERMS_SET (in uname varchar, in perms integer, in set_private integer := 0)\n"
"{\n"
"declare uid integer;\n"
"declare special_iid IRI_ID;\n"
"declare affected_jso any;\n"
"\n"
"if (perms is null)\n"
"{\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_DEL (uname, set_private);\n"
"return;\n"
"}\n"
"uid := (select U_ID from DB.DBA.SYS_USERS where U_NAME = uname and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED)));\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No active SQL user \"%s\" found, can not set its default permissions on RDF quad storage\', uname));\n"
"if (set_private)\n"
"{\n"
"special_iid := #i8192;\n"
"for (select RGU_GRAPH_IID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID <> #i0 and RGU_GRAPH_IID <> #i8192 and\n"
"RGU_USER_ID = uid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 and\n"
"exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = RGU_GRAPH_IID ) ) do\n"
"signal (\'RDF99\', sprintf (\'Default \"private area\" permissions of user \"%s\" on RDF quad store can not become broader than permissions on specific \"private\" graph <%s>\',\n"
"uname, id_to_iri (RGU_GRAPH_IID) ) );\n"
"}\n"
"else\n"
"{\n"
"special_iid := #i0;\n"
"for (select RGU_GRAPH_IID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_GRAPH_IID <> #i0 and RGU_GRAPH_IID <> #i8192 and\n"
"RGU_USER_ID = uid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 and\n"
"not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = RGU_GRAPH_IID ) ) do\n"
"signal (\'RDF99\', sprintf (\'Default \"world\" permissions of user \"%s\" on RDF quad store can not become broader than permissions on specific \"world\" graph <%s>\',\n"
"uname, id_to_iri (RGU_GRAPH_IID) ) );\n"
"}\n"
"if (uname=\'nobody\')\n"
"{\n"
"for (select RGU_USER_ID, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER\n"
"where RGU_USER_ID <> uid and RGU_GRAPH_IID = special_iid and bit_and (bit_not (RGU_PERMISSIONS), perms) <> 0 ) do\n"
"signal (\'RDF99\', sprintf (\'Default %s permissions of unauthenticated user (\"nobody\") on RDF quad store can not become broader than permissions of user %s (UID %d)\',\n"
"(case (set_private) when 0 then \'\"world\"\' else \'\"private area\"\' end),\n"
"(select top 1 U_NAME from Db.DBA.SYS_USERS where U_ID = RGU_USER_ID), RGU_USER_ID) );\n"
"\n"
"\n"
"\n"
"\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')) and not (bit_and (perms, 1))\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1)))\n"
"{\n"
"if (set_private)\n"
"{\n"
"for (select RGGM_MEMBER_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER repl\n"
"where repl.RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\')\n"
"and exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER priv\n"
"where priv.RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"and priv.RGGM_MEMBER_IID = repl.RGGM_MEMBER_IID )\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = repl.RGGM_MEMBER_IID and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1))\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1)) ) do\n"
"signal (\'RDF99\', \'Can not disable public read on private area while RDF replication is enabled and the replication account will loose its read permission on, e.g., <\' || id_to_iri(RGGM_MEMBER_IID) || \'>\');\n"
"}\n"
"else\n"
"{\n"
"for (select RGGM_MEMBER_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER repl\n"
"where repl.RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\')\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER priv\n"
"where priv.RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"and priv.RGGM_MEMBER_IID = repl.RGGM_MEMBER_IID )\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = repl.RGGM_MEMBER_IID and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1))\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1)) ) do\n"
"signal (\'RDF99\', \'Can not disable public read on \"world\" area while RDF replication is enabled and the replication account will loose its read permission on, e.g., <\' || id_to_iri(RGGM_MEMBER_IID) || \'>\');\n"
"}\n"
"}\n"
"}\n"
"if (uname <> \'dba\')\n"
"{\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023);\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023, 1);\n"
"}\n"
"insert replacing DB.DBA.RDF_GRAPH_USER (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS)\n"
"values (special_iid, uid, perms);\n"
"\n"
"commit work;\n"
"if (uname = \'nobody\')\n"
"affected_jso := ((select DB.DBA.VECTOR_AGG (sub.\"jso_key\")\n"
"from (sparql\n"
"define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"select (str(?s)) as ?jso_key where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> { { ?s a virtrdf:QuadMap } union { ?s a virtrdf:QuadMap } } } ) sub\n"
"option (QUIETCAST) ));\n"
"else\n"
"affected_jso := vector (uname);\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (?,?,?,?,?,?)\', vector (uname, uid, perms, special_iid, set_private, affected_jso));\n"
"}\n"
"--src sparql.sql:14640\n";

static const char *proc369 = 
"#line 14746 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_DEFAULT_USER_PERMS_DEL (in uname varchar, in set_private integer := 0)\n"
"{\n"
"declare uid integer;\n"
"declare special_iid IRI_ID;\n"
"declare affected_jso any;\n"
"\n"
"if (uname in (\'nobody\', \'dba\'))\n"
"signal (\'RDF99\', sprintf (\'Default permissions of \"%s\" can be changed but can not be deleted\', uname));\n"
"uid := (select U_ID from DB.DBA.SYS_USERS where U_NAME = uname);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No user \"%s\" found, can not delete its default permissions on RDF quad storage\', uname));\n"
"if (set_private)\n"
"special_iid := #i8192;\n"
"else\n"
"special_iid := #i0;\n"
"delete from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = uid;\n"
"\n"
"commit work;\n"
"affected_jso := vector (uname);\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (?,?,null,?,?,?)\', vector (uname, uid, special_iid, set_private, affected_jso));\n"
"}\n"
"--src sparql.sql:14744\n";

static const char *proc370 = 
"#line 14772 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY (in graph_iri varchar, in graph_iid IRI_ID, in uid integer, in perms integer)\n"
"{\n"
"graph_iri := cast (graph_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (graph_iid);\n"
"if (uid = http_nobody_uid())\n"
"dict_put (__rdf_graph_public_perms_dict(), graph_iid, perms);\n"
"else\n"
"__rdf_graph_specific_perms_of_user (graph_iid, uid, perms);\n"
"jso_mark_affected (graph_iri);\n"
"log_text (\'jso_mark_affected (?)\', graph_iri);\n"
"}\n"
"--src sparql.sql:14770\n";

static const char *proc371 = 
"#line 14785 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_SET (in graph_iri varchar, in uname varchar, in perms integer)\n"
"{\n"
"declare graph_iid IRI_ID;\n"
"declare uid, graph_is_private, common_perms integer;\n"
"declare special_iid IRI_ID;\n"
"\n"
"if (perms is null)\n"
"{\n"
"RDF_GRAPH_USER_PERMS_DEL (graph_iri, uname);\n"
"return;\n"
"}\n"
"graph_iid := iri_to_id (graph_iri);\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uname and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No active SQL user \"%s\" found, can not set its permissions on graph <%s>\', uname, graph_iri));\n"
"graph_is_private := (select count (1) from DB.DBA.RDF_GRAPH_GROUP_MEMBER where\n"
"RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') and\n"
"RGGM_MEMBER_IID = graph_iid );\n"
"if (graph_is_private)\n"
"special_iid := #i8192;\n"
"else\n"
"special_iid := #i0;\n"
"common_perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = uid),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (bit_not (perms), common_perms))\n"
"signal (\'RDF99\', sprintf (\'Default permissions of user \"%s\" on RDF quad store are broader than new permissions on specific graph <%s>\', uname, graph_iri));\n"
"if (uname = \'nobody\')\n"
"{\n"
"if (isstring (registry_get (\'DB.DBA.RDF_REPL\')) and not (bit_and (perms, 1))\n"
"and exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\') and RGGM_MEMBER_IID = graph_iid)\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1))\n"
"and not exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = __rdf_repl_uid() and bit_and (RGU_PERMISSIONS, 1)) )\n"
"signal (\'RDF99\', \'Can not disable public read access to <\' || id_to_iri (graph_iid) || \'> while it is included in RDF replication and the replication is enabled and the replication account will loose its read permission\');\n"
"jso_mark_affected (graph_iri);\n"
"log_text (\'jso_mark_affected (?)\', graph_iri);\n"
"}\n"
"else\n"
"{\n"
"common_perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = http_nobody_uid()),\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = special_iid and RGU_USER_ID = http_nobody_uid()),\n"
"15 );\n"
"if (bit_and (bit_not (perms), common_perms))\n"
"signal (\'RDF99\', sprintf (\'Permissions of unauthenticated user are broader than new permissions of user \"%s\" on specific graph <%s>\', uname, graph_iri));\n"
"if ((uname = \'__rdf_repl\') and isstring (registry_get (\'DB.DBA.RDF_REPL\')) and not (bit_and (perms, 1)) and\n"
"exists (select top 1 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\') and RGGM_MEMBER_IID = graph_iid) )\n"
"signal (\'RDF99\', \'Can not disable read access of __rdf_repl account to <\' || id_to_iri (graph_iid) || \'> while it is included in RDF replication and the replication is enabled\');\n"
"}\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023);\n"
"if (not (exists (select top 1 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 and RGU_USER_ID = 0)))\n"
"DB.DBA.RDF_DEFAULT_USER_PERMS_SET (\'dba\', 1023, 1);\n"
"insert replacing DB.DBA.RDF_GRAPH_USER (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS)\n"
"values (graph_iid, uid, perms);\n"
"\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY (?,?,?,?)\', vector (graph_iri, graph_iid, uid, perms));\n"
"}\n"
"--src sparql.sql:14783\n";

static const char *proc372 = 
"#line 14851 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_DEL_MEMONLY (in graph_iri varchar, in graph_iid IRI_ID, in uid integer)\n"
"{\n"
"graph_iri := cast (graph_iri as varchar);\n"
"DB.DBA.RDF_GRAPH_CACHE_IID (graph_iid);\n"
"if (uid = http_nobody_uid())\n"
"dict_remove (__rdf_graph_public_perms_dict(), graph_iid);\n"
"else\n"
"__rdf_graph_specific_perms_of_user (graph_iid, uid, -1);\n"
"jso_mark_affected (graph_iri);\n"
"log_text (\'jso_mark_affected (?)\', graph_iri);\n"
"}\n"
"--src sparql.sql:14849\n";

static const char *proc373 = 
"#line 14864 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_USER_PERMS_DEL (in graph_iri varchar, in uname varchar)\n"
"{\n"
"declare graph_iid IRI_ID;\n"
"declare uid integer;\n"
"declare special_iid IRI_ID;\n"
"\n"
"graph_iid := iri_to_id (graph_iri);\n"
"uid := (select U_ID from DB.DBA.SYS_USERS where U_NAME = uname);\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No user \"%s\" found, can not change its permissions on graph <%s>\', uname, graph_iri));\n"
"delete from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = graph_iid and RGU_USER_ID = uid;\n"
"\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_USER_PERMS_DEL_MEMONLY (?,?,?)\', vector (graph_iri, graph_iid, uid));\n"
"}\n"
"--src sparql.sql:14862\n";

static const char *proc374 = 
"#line 14883 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_ALL_USER_PERMS_DEL (in uname varchar, in uid integer := null)\n"
"{\n"
"declare special_iid IRI_ID;\n"
"declare graphs any;\n"
"declare graphs_count, graphs_ctr integer;\n"
"\n"
"set isolation = \'serializable\';\n"
"commit work;\n"
"if (uid is null)\n"
"{\n"
"uid := (select U_ID from DB.DBA.SYS_USERS where U_NAME = uname);\n"
"if (uid is null)\n"
"signal (\'RDF99\', sprintf (\'No user \"%s\" found, can not change its permissions on RDF graphs\', uname));\n"
"}\n"
"if (uname is null)\n"
"uname := (select U_NAME from DB.DBA.SYS_USERS where U_ID = uid);\n"
"if (uid = http_nobody_uid() or uid = 0)\n"
"{\n"
"graphs := (select DB.DBA.VECTOR_AGG (RGU_GRAPH_IID) from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = uid and not (RGU_GRAPH_IID in (#i0, #i8192)));\n"
"delete from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = uid and not (RGU_GRAPH_IID in (#i0, #i8192));\n"
"}\n"
"else\n"
"{\n"
"graphs := (select DB.DBA.VECTOR_AGG (RGU_GRAPH_IID) from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = uid);\n"
"delete from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = uid;\n"
"}\n"
"gvector_digit_sort (graphs, 1, 0, 1);\n"
"\n"
"graphs_count := length (graphs);\n"
"for (graphs_ctr := graphs_count-1; graphs_ctr >= 0; graphs_ctr := graphs_ctr-1)\n"
"{\n"
"declare g_iid IR_ID;\n"
"g_iid := graphs [graphs_ctr];\n"
"if (g_iid = #i0 or g_iid = #i8192)\n"
"{\n"
"declare affected_jso any;\n"
"if (uname is null)\n"
"affected_jso := vector ();\n"
"else\n"
"affected_jso := vector (uname);\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY (?,?,null,?,?,?)\',\n"
"vector (uname, uid, g_iid, case (g_iid) when #i8192 then 1 else 0 end, affected_jso));\n"
"}\n"
"else\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.RDF_GRAPH_USER_PERMS_DEL_MEMONLY (?,?,?)\', vector (id_to_iri_nosignal (g_iid), g_iid, uid));\n"
"}\n"
"commit work;\n"
"}\n"
"--src sparql.sql:14881\n";

static const char *proc375 = 
"#line 14933 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_GRAPH_GROUP_LIST_GET (in group_iri any, in extra_graphs any, in uid any, in gs_app_cbk varchar, in gs_app_uid varchar, in req_perms integer) returns any\n"
"{\n"
"declare group_iid IRI_ID;\n"
"declare world_perms, private_perms, common_perms, perms integer;\n"
"declare perms_dict, full_list, filtered_list any;\n"
"\n"
"if (isstring (uid))\n"
"uid := ((select U_ID from DB.DBA.SYS_USERS where U_NAME = uid and (U_NAME=\'nobody\' or (U_SQL_ENABLE and not U_ACCOUNT_DISABLED))));\n"
"if (uid is null)\n"
"return vector ();\n"
"perms_dict := __rdf_graph_default_perms_of_user_dict(0);\n"
"world_perms := coalesce (\n"
"dict_get (perms_dict, uid, NULL),\n"
"dict_get (perms_dict, http_nobody_uid(), NULL),\n"
"15 );\n"
"perms_dict := __rdf_graph_default_perms_of_user_dict(1);\n"
"private_perms := coalesce (\n"
"dict_get (perms_dict, uid, NULL),\n"
"dict_get (perms_dict, http_nobody_uid(), NULL),\n"
"15 );\n"
"if (gs_app_cbk is not null)\n"
"{\n"
"world_perms := bit_and (world_perms, call (gs_app_cbk)(#i0, gs_app_uid));\n"
"private_perms := bit_and (private_perms, call (gs_app_cbk)(#i8192, gs_app_uid));\n"
"}\n"
"common_perms := bit_and (world_perms, private_perms);\n"
"\n"
"if (__tag (group_iri) = __tag of vector)\n"
"{\n"
"vectorbld_init (full_list);\n"
"foreach (any g_iri in group_iri) do\n"
"{\n"
"group_iid := iri_to_id (g_iri);\n"
"if (not bit_and (common_perms, 8))\n"
"{\n"
"perms := __rdf_graph_approx_perms (group_iid, uid);\n"
"if (not bit_and (perms, 8))\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = group_iid and RGU_USER_ID = uid),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, 8))\n"
"perms := bit_and (perms, call (gs_app_cbk)(group_iid, gs_app_uid));\n"
"\n"
"}\n"
"else\n"
"perms := common_perms;\n"
"if (bit_and (perms, 8))\n"
"{\n"
"declare membs any;\n"
"membs := dict_get (__rdf_graph_group_dict(), group_iid, null);\n"
"if (membs is not null)\n"
"{\n"
"if (isvector (membs))\n"
"vectorbld_concat_acc (full_list, membs);\n"
"else\n"
"vectorbld_concat_acc (full_list, dict_list_keys (membs, 0));\n"
"}\n"
"}\n"
"}\n"
"vectorbld_final (full_list);\n"
"}\n"
"else\n"
"{\n"
"group_iid := iri_to_id (group_iri);\n"
"if (not bit_and (common_perms, 8))\n"
"{\n"
"perms := __rdf_graph_approx_perms (group_iid, uid);\n"
"if (not bit_and (perms, 8))\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = group_iid and RGU_USER_ID = uid),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, 8))\n"
"perms := bit_and (perms, call (gs_app_cbk)(group_iid, gs_app_uid));\n"
"\n"
"}\n"
"else\n"
"perms := common_perms;\n"
"if (bit_and (perms, 8))\n"
"{\n"
"full_list := dict_get (__rdf_graph_group_dict(), group_iid, null);\n"
"if (full_list is null)\n"
"full_list := vector ();\n"
"else if (not isvector (full_list))\n"
"full_list := dict_list_keys (full_list, 0);\n"
"}\n"
"else\n"
"full_list := vector ();\n"
"}\n"
"if (bit_and (common_perms, req_perms) = req_perms)\n"
"{\n"
"declare ctr integer;\n"
"if (extra_graphs is null)\n"
"return full_list;\n"
"ctr := length (extra_graphs);\n"
"while (ctr > 0)\n"
"{\n"
"ctr := ctr - 1;\n"
"extra_graphs [ctr] := iri_to_id (extra_graphs[ctr]);\n"
"}\n"
"return vector_concat (full_list, extra_graphs);\n"
"}\n"
"vectorbld_init (filtered_list);\n"
"foreach (IRI_ID member_iid in full_list) do\n"
"{\n"
"perms := __rdf_graph_approx_perms (member_iid, uid);\n"
"if (bit_and (perms, req_perms) <> req_perms)\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = member_iid and RGU_USER_ID = uid),\n"
"dict_get (__rdf_graph_public_perms_dict(), member_iid, NULL),\n"
"perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, req_perms) = req_perms)\n"
"perms := bit_and (perms, call (gs_app_cbk)(member_iid, gs_app_uid));\n"
"\n"
"if (bit_and (perms, req_perms) = req_perms)\n"
"vectorbld_acc (filtered_list, member_iid);\n"
"}\n"
"foreach (any g in extra_graphs) do\n"
"{\n"
"declare g_iid IRI_ID;\n"
"g_iid := iri_to_id (g);\n"
"perms := coalesce (\n"
"(select RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = g_iid and RGU_USER_ID = uid),\n"
"dict_get (__rdf_graph_public_perms_dict(), g_iid, NULL),\n"
"common_perms );\n"
"if (gs_app_cbk is not null and bit_and (perms, req_perms) = req_perms)\n"
"perms := bit_and (perms, call (gs_app_cbk)(g_iid, gs_app_uid));\n"
"\n"
"if (bit_and (perms, req_perms) = req_perms)\n"
"vectorbld_acc (filtered_list, g_iid);\n"
"}\n"
"vectorbld_final (filtered_list);\n"
"return filtered_list;\n"
"}\n"
"--src sparql.sql:14931\n";

static const char *proc376 = 
"#line 15068 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_GRAPH_SECURITY_AUDIT (in recovery integer)\n"
"{\n"
"declare SEVERITY, GRAPH_IRI, USER_NAME, MESSAGE varchar;\n"
"declare GRAPH_IID IRI_ID;\n"
"declare USER_ID integer;\n"
"result_names (SEVERITY, GRAPH_IID, GRAPH_IRI, USER_ID, USER_NAME, MESSAGE);\n"
"declare mem_dict, mem_dict_inv, pg_mem_dict, mem_vec, mem_vec_inv, fake any;\n"
"declare mem_ctr, mem_count, pg_count, err_bad_count, err_recoverable_count, err_recoverable_count_total, err_count_total integer;\n"
"declare sparql_u_id integer;\n"
"declare user_sparql_half_protects_from_extra_access integer;\n"
"err_recoverable_count_total := 0; err_count_total := 0;\n"
"sparql_u_id := (select U_ID from DB.DBA.SYS_USERS where U_NAME=\'SPARQL\');\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting caches of IRI_IDs of IRIs mentioned in security data...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"mem_dict := __rdf_graph_iri2id_dict();\n"
"mem_dict_inv := __rdf_graph_id2iri_dict();\n"
"if (dict_size (mem_dict_inv) <> dict_size (mem_dict))\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Cache of IRI_IDs of IRIs contains %d items, but cache of IRIs of IRI_IDs contains %d items, mismatch\',\n"
"dict_size (mem_dict_inv), dict_size (mem_dict) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"}\n"
"mem_vec := dict_to_vector (mem_dict, 0);\n"
"mem_vec_inv := dict_to_vector (mem_dict_inv, 0);\n"
"mem_count := length (mem_vec);\n"
"\n"
"for (mem_ctr := 0; mem_ctr < mem_count; mem_ctr := mem_ctr + 2)\n"
"{\n"
"declare iri varchar;\n"
"declare iid IRI_ID;\n"
"iri := mem_vec[mem_ctr];\n"
"iid := mem_vec[mem_ctr+1];\n"
"if ((__tag (iri) <> 217 /* __tag of UNAME */) or (__tag (iid) <> __tag of IRI_ID))\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Unexpected datatypes: tag of IRI \"%.300s\" is %d, tag of IRI_ID \"%.300s\" is %d; should be %d and %d\',\n"
"cast (iri as varchar), __tag (iri),\n"
"cast (iid as varchar), __tag (iid),\n"
"217 /* __tag of UNAME */, __tag of IRI_ID ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"dict_remove (mem_dict, iri);\n"
"}\n"
"else if (iri_to_id (iri) <> iid)\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Cached IRI_IDs of IRI <%.300s> is %s, actual is %s, mismatch\',\n"
"cast (iri as varchar), cast (iid as varchar), cast (iri_to_id (iri) as varchar) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"iid := iri_to_id_nosignal (iri);\n"
"if (iid is not null)\n"
"{\n"
"dict_put (mem_dict, iri, iid);\n"
"dict_put (mem_dict_inv, iid, iri);\n"
"}\n"
"else\n"
"dict_remove (mem_dict, iri);\n"
"}\n"
"}\n"
"if (0 = mod (mem_ctr, 100000))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"mem_count := length (mem_vec_inv);\n"
"\n"
"for (mem_ctr := 0; mem_ctr < mem_count; mem_ctr := mem_ctr + 2)\n"
"{\n"
"declare iid IRI_ID;\n"
"declare iri varchar;\n"
"iid := mem_vec_inv[mem_ctr];\n"
"iri := mem_vec_inv[mem_ctr+1];\n"
"if ((__tag (iid) <> __tag of IRI_ID) or (__tag (iri) <> 217 /* __tag of UNAME */))\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Unexpected datatypes: tag of IRI_ID \"%.300s\" is %d, tag of IRI \"%.300s\" is %d; should be %d and %d\',\n"
"cast (iid as varchar), __tag (iid),\n"
"cast (iri as varchar), __tag (iri),\n"
"__tag of IRI_ID, 217 /* __tag of UNAME */ ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"dict_remove (mem_dict_inv, iid);\n"
"}\n"
"else if (__uname (id_to_iri (iid)) <> iri)\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Cached IRI of IRI_ID %s is <%.300s>, actual is <%.300s>, mismatch\',\n"
"cast (iid as varchar), cast (iri as varchar), cast (id_to_iri (iid) as varchar) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"iri := id_to_iri_nosignal (iid);\n"
"if (iri is not null)\n"
"{\n"
"iri := __uname (iri);\n"
"dict_put (mem_dict_inv, iid, iri);\n"
"dict_put (mem_dict, iri, iid);\n"
"}\n"
"else\n"
"dict_remove (mem_dict_inv, iid);\n"
"}\n"
"}\n"
"if (0 = mod (mem_ctr, 100000))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"if (err_recoverable_count)\n"
"{\n"
"if (not recovery)\n"
"{\n"
"result (\'FATAL\', null, null, null, null,\n"
"sprintf (\'%d errors need urgent recovery, the rest of security audit has little sence while these errors persist\',\n"
"err_recoverable_count ) );\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"if (dict_size (mem_dict_inv) <> dict_size (mem_dict))\n"
"{\n"
"result (\'FATAL\', null, null, null, null,\n"
"sprintf (\'Cache of IRI_IDs of IRIs contains %d items, but cache of IRIs of IRI_IDs contains %d items, mismatch even after recovery\',\n"
"dict_size (mem_dict_inv), dict_size (mem_dict) ) );\n"
"err_bad_count := err_bad_count + 1;\n"
"}\n"
"}\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting completeness of IRI cache for graph groups...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"for (select RGG_IID from DB.DBA.RDF_GRAPH_GROUP where dict_get (__rdf_graph_id2iri_dict(), RGG_IID, null) is null\n"
"union select RGGM_GROUP_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER where dict_get (__rdf_graph_id2iri_dict(), RGGM_GROUP_IID, null) is null\n"
"for update ) do\n"
"{\n"
"if (id_to_iri_nosignal (RGG_IID) is null)\n"
"result (\'ERROR\', RGG_IID, null, null, null,\n"
"sprintf (\'The IRI_ID %s of a graph group does not correspond to any IRI\',\n"
"RGG_IID ) );\n"
"else\n"
"result (\'ERROR\', RGG_IID, id_to_iri_nosignal (RGG_IID), null, null,\n"
"sprintf (\'The IRI <%.300s> of graph group IRI_ID %s is not cached\',\n"
"id_to_iri_nosignal (RGG_IID), RGG_IID ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"}\n"
"if (err_recoverable_count and recovery)\n"
"{\n"
"\n"
"delete from DB.DBA.RDF_GRAPH_GROUP where id_to_iri_nosignal (RGG_IID) is null;\n"
"\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where id_to_iri_nosignal (RGGM_GROUP_IID) is null;\n"
"commit work;\n"
"\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_canonicalized_iri (RGG_IID)), RGG_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGG_IID, __uname (id_to_canonicalized_iri (RGG_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP );\n"
"\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_canonicalized_iri (RGGM_GROUP_IID)), RGGM_GROUP_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_GROUP_IID, __uname (id_to_canonicalized_iri (RGGM_GROUP_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_canonicalized_iri (RGGM_MEMBER_IID)), RGGM_MEMBER_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_MEMBER_IID, __uname (id_to_canonicalized_iri (RGGM_MEMBER_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting completeness of IRI cache for graph group members...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"for (select RGGM_MEMBER_IID, min (RGGM_GROUP_IID) as SAMPLE_GROUP_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER where dict_get (__rdf_graph_id2iri_dict(), RGGM_MEMBER_IID, null) is null group by RGGM_MEMBER_IID for update) do\n"
"{\n"
"if (id_to_iri_nosignal (RGGM_MEMBER_IID) is null)\n"
"result (\'ERROR\', RGGM_MEMBER_IID, null, null, null,\n"
"sprintf (\'The IRI_ID %s of a member of a graph group <%.300s> does not correspond to any IRI\',\n"
"RGGM_MEMBER_IID, id_to_iri_nosignal (SAMPLE_GROUP_IID) ) );\n"
"else\n"
"result (\'ERROR\', RGGM_MEMBER_IID, id_to_iri_nosignal (RGGM_MEMBER_IID), null, null,\n"
"sprintf (\'The IRI <%.300s> of IRI_ID %s of the member of a graph group <%.300s> is not cached\',\n"
"id_to_iri_nosignal (RGGM_MEMBER_IID), RGGM_MEMBER_IID, id_to_iri_nosignal (SAMPLE_GROUP_IID) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"}\n"
"if (err_recoverable_count and recovery)\n"
"{\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where id_to_iri_nosignal (RGGM_MEMBER_IID) is null;\n"
"commit work;\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGGM_MEMBER_IID)), RGGM_MEMBER_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_MEMBER_IID, __uname (id_to_iri (RGGM_MEMBER_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"\n"
"result (\'\', null, null, null, null, \'Check for mismatches between graph group IRIs and graph group IRI_IDs...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"for (select RGG_IID, id_to_iri_nosignal (RGG_IID) as actual_iri, RGG_IRI from DB.DBA.RDF_GRAPH_GROUP where id_to_iri_nosignal (RGG_IID) <> RGG_IRI) do\n"
"{\n"
"if (actual_iri is not null)\n"
"{\n"
"result (\'ERROR\', RGG_IID, actual_iri, null, null,\n"
"sprintf (\'The IRI_ID %s of a graph group is the IRI_ID of <%.300s> IRI whereas the group declaration states it is supposed to be <%.300s>\',\n"
"RGG_IID, actual_iri, RGG_IRI ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"}\n"
"}\n"
"for (select RGG_IID, id_to_iri_nosignal (RGG_IID) as actual_iri, RGG_IRI from DB.DBA.RDF_GRAPH_GROUP\n"
"where (id_to_iri_nosignal (RGG_IID) <> RGG_IRI)\n"
"and (id_to_iri_nosignal (RGG_IID) = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\' or RGG_IRI = \'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') ) do\n"
"{\n"
"result (\'FATAL\', RGG_IID, actual_iri, null, null,\n"
"sprintf (\'The IRI_ID and IRI of a virtrdf:PrivateGraphs graph group does not match to each other, it means that some application has made a security hole. You may wish to disable any access to the database while the error is not fixed.\',\n"
"RGG_IID, actual_iri, RGG_IRI ) );\n"
"return;\n"
"}\n"
"\n"
"for (select distinct RGGM_GROUP_IID as new_group_iid, iri_to_id_nosignal (RGGM_GROUP_IID) as new_group_iri from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where not exists (select 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IID = RGGM_GROUP_IID) for update) do\n"
"{\n"
"if (new_group_iri is null)\n"
"{\n"
"result (\'ERROR\', new_group_iid, new_group_iri, null, null,\n"
"sprintf (\'Garbage in list of members of all groups: the group does not exists and group IRI ID is invalid\') );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = new_group_iid;\n"
"commit work;\n"
"}\n"
"}\n"
"else if (exists (select 1 from DB.DBA.RDF_GRAPH_GROUP where RGG_IRI = new_group_iri))\n"
"{\n"
"result (\'ERROR\', new_group_iid, new_group_iri, null, null,\n"
"sprintf (\'Conflicting data in list of groups: the group does not exists, the group IRI is used in a corrupted group record\') );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"delete from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = new_group_iid;\n"
"commit work;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"result (\'ERROR\', new_group_iid, new_group_iri, null, null,\n"
"sprintf (\'The record about graph group does not exist but there exists a list of members\') );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"insert soft DB.DBA.RDF_GRAPH_GROUP (RGG_IID, RGG_IRI, RGG_MEMBER_PATTERN, RGG_COMMENT)\n"
"values (new_group_iid, new_group_iri, NULL, sprintf (\'Group created %s by DB.DBA.RDF_GRAPH_SECURITY_AUDIT()\', cast (now() as varchar)));\n"
"commit work;\n"
"}\n"
"}\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting caching of list of private graphs...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"\n"
"pg_mem_dict := mem_dict := __rdf_graph_group_of_privates_dict();\n"
"pg_count := (select count (1) from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\'));\n"
"\n"
"if (dict_size (mem_dict) <> pg_count)\n"
"{\n"
"result (\'ERROR\', null, null, null, null,\n"
"sprintf (\'Cache of list of private graphs contains %d items, but virtrdf:PrivateGraphs group contains %d members, mismatch\',\n"
"dict_size (mem_dict), pg_count ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"}\n"
"mem_vec := dict_list_keys (mem_dict, 0);\n"
"mem_count := length (mem_vec);\n"
"for (mem_ctr := 0; mem_ctr < mem_count; mem_ctr := mem_ctr + 1)\n"
"{\n"
"declare mem_iid IRI_ID;\n"
"mem_iid := mem_vec[mem_ctr];\n"
"if (not exists (select 1 from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\')\n"
"and RGGM_MEMBER_IID = mem_iid ) )\n"
"{\n"
"result (\'ERROR\', mem_iid, id_to_iri_nosignal (mem_iid), null, null,\n"
"sprintf (\'Cache of list of private graphs contains IRI_ID %s for graph IRI <%.300s> but virtrdf:PrivateGraphs group does not contain it\',\n"
"cast (mem_iid as varchar), id_to_iri_nosignal (mem_iid) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"insert soft DB.DBA.RDF_GRAPH_GROUP_MEMBER (RGGM_GROUP_IID, RGGM_MEMBER_IID)\n"
"values (iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\'), mem_iid);\n"
"commit work;\n"
"}\n"
"}\n"
"if (0 = mod (mem_ctr, 100000))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"}\n"
"\n"
"for (select RGGM_MEMBER_IID from DB.DBA.RDF_GRAPH_GROUP_MEMBER\n"
"where RGGM_GROUP_IID = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\') ) do\n"
"{\n"
"if (not dict_get (mem_dict, RGGM_MEMBER_IID, 0))\n"
"{\n"
"result (\'ERROR\', RGGM_MEMBER_IID, id_to_iri_nosignal (RGGM_MEMBER_IID), null, null,\n"
"sprintf (\'Cache of list of private graphs does not contain IRI_ID %s of graph IRI <%.300s> but virtrdf:PrivateGraphs group contains it\',\n"
"cast (RGGM_MEMBER_IID as varchar), id_to_iri_nosignal (RGGM_MEMBER_IID) ) );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"dict_put (mem_dict, RGGM_MEMBER_IID, 1);\n"
"}\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting permissions of users...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"\n"
"for (select RGU_USER_ID\n"
"from (select distinct RGU_USER_ID from DB.DBA.RDF_GRAPH_USER rgu) dist_rgu\n"
"where not exists (select 1 from DB.DBA.SYS_USERS where U_ID = RGU_USER_ID) ) do\n"
"{\n"
"result (\'ERROR\', NULL, NULL, RGU_USER_ID, null,\n"
"sprintf (\'Garbage in table DB.DBA.RDF_GRAPH_USER: permissions are specified for nonexisting user ID\') );\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"DB.DBA.RDF_ALL_USER_PERMS_DEL (null, RGU_USER_ID);\n"
"}\n"
"for (select special.RGU_GRAPH_IID as s_g_iid, special.RGU_USER_ID as s_userid, special.RGU_PERMISSIONS as s_perms,\n"
"common.RGU_GRAPH_IID as c_g_iid, common.RGU_USER_ID as c_userid, common.RGU_PERMISSIONS as c_p\n"
"from DB.DBA.RDF_GRAPH_USER special, DB.DBA.RDF_GRAPH_USER common\n"
"where (common.RGU_GRAPH_IID = special.RGU_GRAPH_IID\n"
"and common.RGU_USER_ID = http_nobody_uid() and special.RGU_USER_ID <> http_nobody_uid()\n"
"and bit_and (common.RGU_PERMISSIONS, special.RGU_PERMISSIONS) < common.RGU_PERMISSIONS )\n"
"union select special.RGU_GRAPH_IID, special.RGU_USER_ID, special.RGU_PERMISSIONS,\n"
"common.RGU_GRAPH_IID, common.RGU_USER_ID, common.RGU_PERMISSIONS\n"
"from DB.DBA.RDF_GRAPH_USER special, DB.DBA.RDF_GRAPH_USER common\n"
"where (common.RGU_GRAPH_IID = #i8192 and dict_get (pg_mem_dict, special.RGU_GRAPH_IID, 0)\n"
"and common.RGU_USER_ID = http_nobody_uid() and special.RGU_USER_ID <> http_nobody_uid()\n"
"and bit_and (common.RGU_PERMISSIONS, special.RGU_PERMISSIONS) < common.RGU_PERMISSIONS )\n"
"union select special.RGU_GRAPH_IID, special.RGU_USER_ID, special.RGU_PERMISSIONS,\n"
"common.RGU_GRAPH_IID, common.RGU_USER_ID, common.RGU_PERMISSIONS\n"
"from DB.DBA.RDF_GRAPH_USER special, DB.DBA.RDF_GRAPH_USER common\n"
"where (common.RGU_GRAPH_IID = #i0 and special.RGU_GRAPH_IID <> #i8192 and not dict_get (pg_mem_dict, special.RGU_GRAPH_IID, 0)\n"
"and common.RGU_USER_ID = http_nobody_uid() and special.RGU_USER_ID <> http_nobody_uid()\n"
"and bit_and (common.RGU_PERMISSIONS, special.RGU_PERMISSIONS) < common.RGU_PERMISSIONS )\n"
"union select special.RGU_GRAPH_IID, special.RGU_USER_ID, special.RGU_PERMISSIONS,\n"
"common.RGU_GRAPH_IID, common.RGU_USER_ID, common.RGU_PERMISSIONS\n"
"from DB.DBA.RDF_GRAPH_USER special, DB.DBA.RDF_GRAPH_USER common\n"
"where (common.RGU_GRAPH_IID = #i8192 and dict_get (pg_mem_dict, special.RGU_GRAPH_IID, 0)\n"
"and common.RGU_USER_ID = special.RGU_USER_ID\n"
"and bit_and (common.RGU_PERMISSIONS, special.RGU_PERMISSIONS) < common.RGU_PERMISSIONS )\n"
"union select special.RGU_GRAPH_IID, special.RGU_USER_ID, special.RGU_PERMISSIONS,\n"
"common.RGU_GRAPH_IID, common.RGU_USER_ID, common.RGU_PERMISSIONS\n"
"from DB.DBA.RDF_GRAPH_USER special, DB.DBA.RDF_GRAPH_USER common\n"
"where (common.RGU_GRAPH_IID = #i0 and special.RGU_GRAPH_IID <> #i8192 and not dict_get (pg_mem_dict, special.RGU_GRAPH_IID, 0)\n"
"and common.RGU_USER_ID = special.RGU_USER_ID\n"
"and bit_and (common.RGU_PERMISSIONS, special.RGU_PERMISSIONS) < common.RGU_PERMISSIONS )\n"
"order by c_userid, c_g_iid ) do\n"
"{\n"
"declare c_g_iri_txt varchar;\n"
"c_g_iri_txt := case (c_g_iid) when #i0 then \'default public graph\' when #i8192 then \'default private graph\' else sprintf (\'graph <%.300s>\', id_to_iri_nosignal (c_g_iid)) end;\n"
"result (\'ERROR\', s_g_iid, id_to_iri_nosignal (s_g_iid), s_userid, (select U_NAME from DB.DBA.SYS_USERS where U_ID = s_userid),\n"
"sprintf (\'Specific permissions %x are smaller than %s permissions %x of user %s\',\n"
"s_perms, c_g_iri_txt, c_p, (select U_NAME from DB.DBA.SYS_USERS where U_ID = c_userid) ) );\n"
"err_bad_count := err_bad_count + 1;\n"
"if (s_g_iid = sparql_u_id)\n"
"{\n"
"user_sparql_half_protects_from_extra_access := 1;\n"
"result (\'ERROR\', s_g_iid, id_to_iri_nosignal (s_g_iid), s_userid, (select U_NAME from DB.DBA.SYS_USERS where U_ID = s_userid),\n"
"\'Note that The fix of above error by removal of all SPARQL\'\'s permissions can give more access rights to users of ill applications that re-used \"SPARQL\" account\' );\n"
"}\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"result (\'\', null, null, null, null, \'Inspecting SPARQL user...\');\n"
"err_bad_count := 0;\n"
"err_recoverable_count := 0;\n"
"if (sparql_u_id is null)\n"
"{\n"
"result (\'WARNING\', null, null, sparql_u_id, \'SPARQL\', \'The \"SPARQL\" user does not exist. It is not a security issue (no account --- no related leaks), just unusual\');\n"
"}\n"
"else\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME=\'SPARQL\' and not U_ACCOUNT_DISABLED))\n"
"{\n"
"result (\'ERROR\', null, null, sparql_u_id, \'SPARQL\', \'The \"SPARQL\" user should be disabled. Applications should create separate accounts and grant SPARQL_SELECT etc., the account \"SPARQL\" is for system purposes only\');\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"if (recovery)\n"
"{\n"
"update DB.DBA.SYS_USERS set U_ACCOUNT_DISABLED = 1 where U_NAME=\'SPARQL\';\n"
"commit work;\n"
"}\n"
"}\n"
"if (not user_sparql_half_protects_from_extra_access)\n"
"{\n"
"declare user_sparql_has_perms integer;\n"
"user_sparql_has_perms := 0;\n"
"for (select RGU_GRAPH_IID from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = sparql_u_id) do\n"
"{\n"
"result (\'ERROR\', RGU_GRAPH_IID, id_to_iri_nosignal (RGU_GRAPH_IID), sparql_u_id, \'SPARQL\', \'The \"SPARQL\" user has got some specific permissions. That\'\'s strange and redundand, at best, it may also mislead somebody\');\n"
"err_recoverable_count := err_recoverable_count + 1;\n"
"user_sparql_has_perms := 1;\n"
"}\n"
"if (user_sparql_has_perms and recovery)\n"
"DB.DBA.RDF_ALL_USER_PERMS_DEL (\'SPARQL\');\n"
"}\n"
"}\n"
"err_count_total := err_count_total + err_recoverable_count + err_bad_count;\n"
"err_recoverable_count_total := err_recoverable_count_total + err_recoverable_count;\n"
"\n"
"if (0 = err_count_total)\n"
"result (\'\', null, null, null, null,\n"
"sprintf (\'No errors found in RDF security\', err_count_total) );\n"
"else if (recovery)\n"
"result (\'\', null, null, null, null,\n"
"sprintf (\'%d security errors were found, DB.DBA.RDF_GRAPH_SECURITY_AUDIT (0) will list errors that may remain unfixed\', err_count_total) );\n"
"else if (err_recoverable_count_total)\n"
"result (\'\', null, null, null, null,\n"
"sprintf (\'%d security errors found, you may wish to run DB.DBA.RDF_GRAPH_SECURITY_AUDIT (1) to repair\', err_count_total) );\n"
"else\n"
"result (\'\', null, null, null, null,\n"
"sprintf (\'%d security errors found and none of them can be repaired by DB.DBA.RDF_GRAPH_SECURITY_AUDIT (1)\', err_count_total) );\n"
"\n"
"}\n"
"--src sparql.sql:15066\n";

static const char *proc377 = 
"#line 15516 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.SPARQL_RELOAD_QM_GRAPH ()\n"
"{\n"
"declare ver varchar;\n"
"declare inx int;\n"
"ver := \'2013-06-10 0001v6g\';\n"
"if (USER <> \'dba\')\n"
"signal (\'RDFXX\', \'Only DBA can reload quad map metadata\');\n"
"if (not exists (sparql define input:storage \"\" ask where {\n"
"graph <http://www.openlinksw.com/schemas/virtrdf#> {\n"
"<http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl>\n"
"virtrdf:version ?:ver\n"
"} } ) )\n"
"{\n"
"declare txt1, txt2 varchar;\n"
"declare jso_sys_g_iid IRI_ID;\n"
"declare dict1, lst1, dict2, lst2, sum_lst any;\n"
"txt1 := cast ( DB.DBA.XML_URI_GET (\n"
"\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\', \'\' ) as varchar );\n"
"txt2 := \'\n"
"@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"@prefix owl: <http://www.w3.org/2002/07/owl#> .\n"
"@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n"
"@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\n"
"@prefix rdfdf: <http://www.openlinksw.com/virtrdf-data-formats#> .\n"
"\n"
"virtrdf:DefaultQuadStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultQuadStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultQuadMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultQuadStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\n"
"virtrdf:DefaultServiceStorage\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:DefaultServiceStorage-UserMaps ;\n"
"virtrdf:qsDefaultMap virtrdf:DefaultServiceMap ;\n"
"virtrdf:qsMatchingFlags virtrdf:SPART_QS_NO_IMPLICIT_USER_QM .\n"
"virtrdf:DefaultServiceStorage-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\n"
"virtrdf:SyncToQuads\n"
"rdf:type virtrdf:QuadStorage ;\n"
"virtrdf:qsUserMaps virtrdf:SyncToQuads-UserMaps .\n"
"virtrdf:SyncToQuads-UserMaps\n"
"rdf:type virtrdf:array-of-QuadMap .\n"
"\';\n"
"jso_sys_g_iid := iri_to_id (JSO_SYS_GRAPH ());\n"
"dict1 := DB.DBA.RDF_TTL2HASH (txt1, \'\');\n"
"dict2 := DB.DBA.RDF_TTL2HASH (txt2, \'\');\n"
"lst1 := dict_list_keys (dict1, 1);\n"
"lst2 := dict_list_keys (dict2, 1);\n"
"sum_lst := vector_concat (lst1, lst2);\n"
"inx := 0;\n"
"foreach (any triple in sum_lst) do\n"
"{\n"
"if ((triple[1] = iri_to_id (\'http://www.w3.org/1999/02/22-rdf-syntax-ns#type\')) and\n"
"isiri_id (triple[2]) and (triple[2] = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#QuadMapFormat\')))\n"
"{\n"
"\n"
"delete from DB.DBA.RDF_QUAD where G = jso_sys_g_iid and S = triple[0];\n"
"}\n"
"else\n"
"delete from DB.DBA.RDF_QUAD where G = jso_sys_g_iid and S = triple[0] and P = triple[1];\n"
"if (\n"
"triple[0] = iri_to_id (\'http://www.openlinksw.com/sparql/virtrdf-data-formats.ttl\')\n"
"and\n"
"triple[1] = iri_to_id (\'http://www.openlinksw.com/schemas/virtrdf#version\')\n"
"and\n"
"triple[2] <> ver\n"
")\n"
"{\n"
"log_message (sprintf (\'RDF metadata version: %s\', ver));\n"
"triple[2] := ver;\n"
"sum_lst[inx] := triple;\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"DB.DBA.RDF_INSERT_TRIPLES (jso_sys_g_iid, sum_lst);\n"
"commit work;\n"
"}\n"
"DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH ();\n"
"sequence_set (\'RDF_URL_IID_NAMED\', 1010000, 1);\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_URL_IID_NAMED_BLANK\', iri_id_num (min_named_bnode_iri_id ()) + 10000, 1);\n"
"sequence_set (\'RDF_PREF_SEQ\', 101, 1);\n"
"sequence_set (\'RDF_RO_ID\', 1001, 1);\n"
"}\n"
"--src sparql.sql:15514\n";

static const char *proc378 = 
"#line 15607 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_CREATE_SPARQL_ROLES ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'create role SPARQL_SELECT\',\n"
"\'create role SPARQL_SPONGE\',\n"
"\'create role SPARQL_UPDATE\',\n"
"\'grant SPARQL_SELECT to SPARQL_UPDATE\',\n"
"\'grant SPARQL_SELECT to SPARQL_SPONGE\',\n"
"\'grant SPARQL_SPONGE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_QUAD to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_QUAD to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_PREFIX to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_PREFIX to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_IRI to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_IRI to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_OBJ to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_OBJ to SPARQL_UPDATE\',\n"
"\n"
"\n"
"\'grant select on DB.DBA.RDF_DATATYPE to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_DATATYPE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_LANGUAGE to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_LANGUAGE to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.SYS_SPARQL_HOST to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.SYS_SPARQL_HOST to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH to SPARQL_SELECT\',\n"
"\'grant all on DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH to SPARQL_UPDATE\',\n"
"\'grant select on DB.DBA.SYS_IDONLY_EMPTY to SPARQL_SELECT\',\n"
"\'grant select on DB.DBA.SYS_IDONLY_ONE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_GLOBAL_RESET to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_QNAME to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_IID_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_IID to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TWOBYTE_OF_DATATYPE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TWOBYTE_OF_LANGUAGE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_LONG_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_SQLVAL_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_IID_OF_O to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RQ_O_IS_LIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_ADD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_FIND_EXISTING to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LANGUAGE_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SQLVAL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_STRSQLVAL_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QNAME_OF_LONG_SAFE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_BOOL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_DATATYPE_IRI_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LANGUAGE_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_STRSQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_OF_SQLVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.rdf_strdt_impl to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.rdf_strlang_impl to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.rdf_uuid_impl to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI_L to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_QUAD_URI_L_TYPED to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_GRAPH to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_BLANK to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_GET_IID to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_XLAT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_XLAT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_WITH_IRI_TRANSLATION to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_GET_IID to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TTL2HASH to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFXML to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_RDFA11_FETCH_PROFILES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFA to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_XHTML_MICRODATA to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_RDFXML_TO_DICT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LONG_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TRIG to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_NT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_TO_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TALIS_JSON to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_JSON_LD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_CSV to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_TSV to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_HTML_UL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_HTML_TR to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_ATOM_XML_TEXT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TRIPLES_TO_ODATA_JSON to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_TSV_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ATOM_XML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ODATA_JSON to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NICE_TTL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TALIS_JSON to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_LD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_MICRODATA to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_MICRODATA to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CSV to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TSV to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDFA_XHTML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML_QRCODE to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_INSERT_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_DELETE_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_DELETE_TRIPLES_AGG to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_MODIFY_TRIPLES to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_INSERT_QUADS to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_DELETE_QUADS to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_INSERT_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_INSERT_QUAD_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_DELETE_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_DELETE_QUAD_DICT_CONTENT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_MODIFY_BY_QUAD_DICT_CONTENTS to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_ADD to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_CLEAR to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_COPY to SPARQL_UPDATE\',\n"
"\'grant execute on SPARUL_LOAD_SERVICE_DATA to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.SPARUL_CREATE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_DROP to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_LOAD to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_LOAD_SERVICE_DATA to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_MOVE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARUL_RUN to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_AGG_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SPO to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_CBD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_OBJCBD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_OBJCBD_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SCBD to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_DESC_DICT_SCBD_PHYSICAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_INIT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_ACC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_CONSTRUCT_FIN to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TYPEMIN_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_TYPEMAX_OF_OBJ to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_IID_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_LONG_CMP to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.TTLP_MT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_MT_LOCAL_FILE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_W to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_W to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_NEW_GRAPH_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_TRIPLE_L_A to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_REPORT_DEFAULT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_RDFXML_MT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_LOAD_HTTP_RESPONSE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_FORGET_HTTP_RESPONSE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.TTLP_EV_COMMIT to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_PROC_COLS to \"SPARQL\"\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_USER_PERMS_ACK to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_GRAPH_GROUP_LIST_GET to SPARQL_SELECT\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src sparql.sql:15605\n";

static const char *proc379 = 
"#line 15824 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_AUDIT ()\n"
"{\n"
"declare stat, msg varchar;\n"
"declare err_dict any;\n"
"result_names (stat, msg);\n"
"if (exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\')\n"
"and \"COLUMN\" = fix_identifier_case (\'VT_WORD\') )\n"
"and exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ\')\n"
"and \"COLUMN\" = fix_identifier_case (\'RO_FLAGS\')\n"
"and COL_DTP = 188 ) )\n"
"goto check_new_style;\n"
"err_dict := dict_new ();\n"
"if (isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')))\n"
"{\n"
"result (\'ERRol\', \'old layout but isstring (registry_get (\'\'DB.DBA.RDF_QUAD_FT_UPGRADE\'\'))\');\n"
"return;\n"
"}\n"
"for (select O as o_old from DB.DBA.RDF_QUAD where isstring (O)) do\n"
"{\n"
"declare o_old_len integer;\n"
"declare o_long any;\n"
"declare o_strval varchar;\n"
"declare val_len, o_id integeR;\n"
"declare o_dt, o_lang integeR;\n"
"o_old_len := length (o_old);\n"
"if (dict_size (err_dict) > 10000)\n"
"{\n"
"result (\'ERRxx\', \'Too many errors, bye\');\n"
"return;\n"
"}\n"
"if (dict_get (err_dict, o_old, 0))\n"
"goto known_bug;\n"
"if (o_old_len = 29)\n"
"{\n"
"if (o_old [22] <> 0)\n"
"{ result (\'ERRol\', sprintf (\'ill literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"else\n"
"{\n"
"o_long := jso_parse_digest (o_old);\n"
"o_strval := (select case (isnull (RO_LONG)) when 0 then blob_to_string (RO_LONG) else RO_VAL end from DB.DBA.RDF_OBJ where RO_ID = o_long[3]);\n"
"if (o_strval is null)\n"
"{ result (\'ERRol\', sprintf (\'Non-existing RO_ID %d in literal |%U| (escaped like URL)\', o_long[3], o_old)); dict_put (err_dict, o_old, 1); }\n"
"else if (\"LEFT\" (o_strval, 20) <> o_long[1])\n"
"{ result (\'ERRol\', sprintf (\'Full value of RO_ID %d starts with |%U|, does not match to literal |%U| (escaped like URL)\', o_long[3], \"LEFT\" (o_strval, 20), o_old)); dict_put (err_dict, o_old, 1); }\n"
"o_dt := o_long[0];\n"
"o_lang := o_long[2];\n"
"}\n"
"}\n"
"else if (o_old_len < 5)\n"
"{ result (\'ERRot\', sprintf (\'ill literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"else if (o_old_len < 29)\n"
"{\n"
"val_len := length (o_old) - 5;\n"
"o_dt := o_old[0] + o_old[1]*256;\n"
"o_lang := o_old[val_len+3] + o_old[val_len+4]*256;\n"
"if ((o_old [val_len+2] <> 0) or 0 = o_old[0] or 0 = o_old[1] or 0 = o_old[val_len+3] or 0 = o_old[val_len+4])\n"
"{ result (\'ERRos\', sprintf (\'ill short literal |%U| (escaped like URL)\', o_old)); dict_put (err_dict, o_old, 1); }\n"
"}\n"
"else\n"
"{ result (\'ERRoh\', sprintf (\'Too long literal |%U| (truncated, escaped like URL)\', \"LEFT\" (o_old, 100))); dict_put (err_dict, o_old, 1); }\n"
"known_bug: ;\n"
"}\n"
"return;\n"
"\n"
"check_new_style:\n"
"if (not isstring (registry_get (\'DB.DBA.RDF_QUAD_FT_UPGRADE\')))\n"
"result (\'ERRft\', \'new layout but not isstring (registry_get (\'\'DB.DBA.RDF_QUAD_FT_UPGRADE\'\'))\');\n"
"}\n"
"--src sparql.sql:15822\n";

static const char *proc380 = 
"#line 15896 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_OUTLINE_ALL (in force integer := 0)\n"
"{\n"
"declare c_main, c_pogs, c_op integer;\n"
"declare c_main_tmp, c_pogs_tmp, c_op_tmp integer;\n"
"declare c_main_fixed, c_pogs_fixed, c_op_fixed integer;\n"
"declare old_mode integer;\n"
"declare c_check char;\n"
"\n"
"if ((registry_get (\'__rb_id_only_for_plain_ro_obj\') = \'1\') and not force)\n"
"return;\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD))\n"
"{\n"
"registry_set (\'__rb_id_only_for_plain_ro_obj\', \'1\');\n"
"return;\n"
"}\n"
"if (0 = sys_stat (\'db_exists\'))\n"
"{\n"
"registry_set (\'__rb_id_only_for_plain_ro_obj\', \'1\');\n"
"return;\n"
"}\n"
"log_message (\'This database may contain RDF data that could cause indexing problems on previous versions of the server.\');\n"
"log_message (\'The content of the DB.DBA.RDF_QUAD table will be checked and an update may automatically be performed if\');\n"
"log_message (\'such data is found.\');\n"
"log_message (\'This check will take some time but is made only once.\');\n"
"\n"
"if (not exists (select top 1 1 from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only) where rdf_box_migrate_after_06_02_3129 (O)))\n"
"{\n"
"log_message (\'No need to update DB.DBA.RDF_QUAD.\');\n"
"registry_set (\'__rb_id_only_for_plain_ro_obj\', \'1\');\n"
"exec (\'checkpoint\');\n"
"return;\n"
"}\n"
"\n"
"log_message (\'\');\n"
"log_message (\'An update is required.\');\n"
"c_check := coalesce (virtuoso_ini_item_value (\'Parameters\', \'AnalyzeFixQuadStore\'), \'0\');\n"
"if (coalesce (virtuoso_ini_item_value (\'Parameters\', \'LiteMode\'), \'0\') <> \'0\') c_check := \'1\';\n"
"if (c_check <> \'1\')\n"
"{\n"
"log_message (\'\');\n"
"log_message (\'NOTICE: Before Virtuoso can continue fixing the DB.DBA.RDF_QUAD table and its indexes\');\n"
"log_message (\'        the DB Administrator should check make sure that:\');\n"
"log_message (\'\');\n"
"log_message (\'         * there is a recent backup of the database\');\n"
"log_message (\'         * there is enough free disk space available to complete this conversion\');\n"
"log_message (\'         * the database can be offline for the duration of this conversion\');\n"
"log_message (\'\');\n"
"log_message (\'        Since the update can take a considerable amount of time on large databases\');\n"
"log_message (\'        it is advisable to schedule this at an appropriate time.\');\n"
"log_message (\'\');\n"
"log_message (\'To continue the DBA must change the virtuoso.ini file and add the following flag:\');\n"
"log_message (\'\');\n"
"log_message (\'    [Parameters]\');\n"
"log_message (\'    AnalyzeFixQuadStore = 1\');\n"
"log_message (\'\');\n"
"log_message (\'For additional information please contact OpenLink Support <support@openlinksw.com>\');\n"
"log_message (\'This process will now exit.\');\n"
"raw_exit();\n"
"}\n"
"\n"
"log_message (\'Please be patient.\');\n"
"log_message (\'The table DB.DBA.RDF_QUAD and two of its additional indexes will now be patched.\');\n"
"log_message (\'In case of an error during the operation, delete the transaction log before restarting the server.\');\n"
"exec (\'checkpoint\');\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_message (sprintf (\'Error %s: %s\', __SQL_STATE, __SQL_MESSAGE));\n"
"log_message (\'Do not forget to delete the transaction log before restarting the server.\');\n"
"raw_exit ();\n"
"};\n"
"\n"
"\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"cl_inx_recov (force);\n"
"return;\n"
"}\n"
"\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"log_message (\'Cluster must be online in order to perform upgrade\');\n"
"return;\n"
"}\n"
"\n"
"old_mode := log_enable (2, 1);\n"
"log_message (\'Phase 1 of 9: Gathering statistics ...\');\n"
"c_main := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD) option (no cluster));\n"
"c_pogs := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS) option (no cluster));\n"
"if (c_main <> c_pogs)\n"
"log_message (\'* Existing indexes are damaged, will try to recover...\');\n"
"c_op := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only) option (no cluster));\n"
"log_message (sprintf (\' * Index sizes before the processing: %09d RDF_QUAD, %09d POGS, %09d OP\', c_main, c_pogs, c_op));\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP, no cluster) option (index RDF_QUAD_RECOV_TMP, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster) option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_OP, index_only, no cluster) option (index RDF_QUAD_RECOV_TMP_OP, no cluster);\n"
"\n"
"log_message (\'Phase 2 of 9: Copying all quads to a temporary table ...\');\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP index RDF_QUAD_RECOV_TMP option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD, no cluster);\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP index RDF_QUAD_RECOV_TMP_POGS option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS, no cluster);\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP index RDF_QUAD_RECOV_TMP_OP option (index_only, no cluster) (P1,O1) select P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only, no cluster);\n"
"if (c_main <> c_pogs)\n"
"{\n"
"log_message (\'* Recovering additional data from existing indexes\');\n"
"if (c_main < c_pogs)\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS) option (no cluster);\n"
"if (c_pogs < c_main)\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD) option (no cluster);\n"
"}\n"
"c_op_tmp := (select count (1) from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_OP, index_only) option (no cluster));\n"
"log_message (sprintf (\'* Index sizes of temporary table: %09d OP\', c_op_tmp));\n"
"if (c_op_tmp < c_op)\n"
"log_message (\'** Some data are lost or the corruption was strong before the processing.\');\n"
"\n"
"log_message (\'Phase 3 of 9: Cleaning the quad storage ...\');\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD, no cluster) option (index RDF_QUAD, no cluster);\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS, no cluster) option (index RDF_QUAD_POGS, no cluster);\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only, no cluster) option (index RDF_QUAD_OP, no cluster);\n"
"\n"
"log_message (\'Phase 4 of 9: Refilling the quad storage from the temporary table...\');\n"
"insert soft DB.DBA.RDF_QUAD index RDF_QUAD option (no cluster) (G,S,P,O) select G1,S1,P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP, no cluster);\n"
"insert soft DB.DBA.RDF_QUAD index RDF_QUAD_POGS option (no cluster) (G,S,P,O) select G1,S1,P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"insert soft DB.DBA.RDF_QUAD index RDF_QUAD_OP option (index_only, no cluster) (P,O) select P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_OP, index_only, no cluster);\n"
"\n"
"log_message (\'Phase 5 of 9: Cleaning the temporary table ...\');\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP, no cluster) option (index RDF_QUAD_RECOV_TMP, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster) option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_OP, index_only, no cluster) option (index RDF_QUAD_RECOV_TMP_OP, no cluster);\n"
"\n"
"log_message (\'Phase 6 of 9: Gathering statistics again ...\');\n"
"c_main_fixed := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD) option (no cluster));\n"
"c_pogs_fixed := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS) option (no cluster));\n"
"c_op_fixed := (select count (1) from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only) option (no cluster));\n"
"log_message (sprintf (\'* Index sizes after the processing: %09d RDF_QUAD, %09d POGS, %09d OP\', c_main_fixed, c_pogs_fixed, c_op_fixed));\n"
"if ((__min (c_main_fixed, c_pogs_fixed) < __max (c_main, c_pogs)) or (c_op_fixed < c_op))\n"
"log_message (\'** Some data are lost or the corruption was strong before the processing.\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"log_message (\'Phase 7 of 9: integrity check (completeness of index RDF_QUAD_POGS of DB.DBA.RDF_QUAD) ...\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD a table option (index RDF_QUAD) where not exists (select 1 from DB.DBA.RDF_QUAD b table option (loop, index RDF_QUAD_POGS) where a.g = b.g and a.p = b.p and a.o = b.o and a.s = b.s)))\n"
"log_message (\'** IMPORTANT WARNING: not all rows of DB.DBA.RDF_QUAD are found in RDF_QUAD_POGS, data reloading is strictly recommended.\');\n"
"\n"
"log_message (\'Phase 8 of 9: integrity check (completeness of primary key of DB.DBA.RDF_QUAD) ...\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD a table option (index RDF_QUAD_POGS) where not exists (select 1 from DB.DBA.RDF_QUAD b table option (loop, index primary key) where a.g = b.g and a.p = b.p and a.o = b.o and a.s = b.s)))\n"
"log_message (\'** IMPORTANT WARNING: not all rows of DB.DBA.RDF_QUAD are found in RDF_QUAD_POGS, data reloading is strictly recommended.\');\n"
"\n"
"log_message (\'Phase 9 of 9: final checkpoint...\');\n"
"registry_set (\'__rb_id_only_for_plain_ro_obj\', \'1\');\n"
"exec (\'checkpoint\');\n"
"log_enable (old_mode, 1);\n"
"log_message (\'Update complete.\');\n"
"}\n"
"--src sparql.sql:15894\n";


static const char *other38 = 
" DB.DBA.RDF_QUAD_OUTLINE_ALL ()\n";
static const char *proc381 = 
"#line 16061 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_LOAD_CACHE ()\n"
"{\n"
"declare fake integer;\n"
"fake := (select count (rdf_cache_id (\'t\', RDT_QNAME, RDT_TWOBYTE)) from DB.DBA.RDF_DATATYPE);\n"
"fake := (select count (rdf_cache_id (\'l\', RL_ID, RL_TWOBYTE)) from DB.DBA.RDF_LANGUAGE);\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGG_IID)), RGG_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGG_IID, __uname (id_to_iri (RGG_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP );\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGGM_GROUP_IID)), RGGM_GROUP_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_GROUP_IID, __uname (id_to_iri (RGGM_GROUP_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGGM_MEMBER_IID)), RGGM_MEMBER_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGGM_MEMBER_IID, __uname (id_to_iri (RGGM_MEMBER_IID))))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER );\n"
"fake := (select\n"
"count (dict_put (__rdf_graph_iri2id_dict(), __uname (id_to_iri (RGU_GRAPH_IID)), RGU_GRAPH_IID)) +\n"
"count (dict_put (__rdf_graph_id2iri_dict(), RGU_GRAPH_IID, __uname (id_to_iri (RGU_GRAPH_IID))))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID <> #i8192 and RGU_GRAPH_IID <> #i0 );\n"
"for (select\n"
"g.RGG_IID as group_iid,\n"
"(select DB.DBA.VECTOR_AGG (RGGM_MEMBER_IID) from DB.DBA.RDF_GRAPH_GROUP_MEMBER as gm\n"
"where gm.RGGM_GROUP_IID = g.RGG_IID order by gm.RGGM_MEMBER_IID ) as membs\n"
"from DB.DBA.RDF_GRAPH_GROUP as g ) do\n"
"{\n"
"if (length (membs) < 1000)\n"
"dict_put (__rdf_graph_group_dict(), group_iid, membs);\n"
"else\n"
"{\n"
"declare new_membs any;\n"
"new_membs := dict_new (length (membs));\n"
"foreach (IRI_ID m in membs) do dict_put (new_membs, m, 1);\n"
"dict_put (__rdf_graph_group_dict(), group_iid, new_membs);\n"
"}\n"
"}\n"
"fake := (select count (dict_put (__rdf_graph_group_of_privates_dict(), RGGM_MEMBER_IID, 1))\n"
"from DB.DBA.RDF_GRAPH_GROUP_MEMBER where RGGM_GROUP_IID = iri_to_id(\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\'));\n"
"fake := (select count (dict_put (__rdf_graph_default_perms_of_user_dict(0), RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i0 );\n"
"fake := (select count (dict_put (__rdf_graph_default_perms_of_user_dict(1), RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = #i8192 );\n"
"fake := (select count (dict_put (__rdf_graph_public_perms_dict(), RGU_GRAPH_IID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID = http_nobody_uid () );\n"
"}\n"
"--src sparql.sql:16059\n";

static const char *proc382 = 
"#line 16109 \"[executable]/sparql.sql\"\n"
"create procedure DB.DBA.RDF_QUAD_FT_UPGRADE ()\n"
"{\n"
"declare stat, msg varchar;\n"
"declare fake integer;\n"
"if (USER <> \'dba\')\n"
"signal (\'RDFXX\', \'Only DBA can alter DB.DBA.RDF_QUAD schema or initialize RDF storage\');\n"
"RDF_QUAD_FT_INIT ();\n"
"DB.DBA.RDF_QUAD_LOAD_CACHE ();\n"
"delete from DB.DBA.RDF_GRAPH_USER where not exists (select 1 from DB.DBA.SYS_USERS where RGU_USER_ID = U_ID);\n"
"if (row_count ())\n"
"log_message (\'Non-existing users are removed from graph security list\');\n"
"fake := (select count (__rdf_graph_specific_perms_of_user (RGU_GRAPH_IID, RGU_USER_ID, RGU_PERMISSIONS))\n"
"from DB.DBA.RDF_GRAPH_USER where RGU_USER_ID <> http_nobody_uid () and not (RGU_GRAPH_IID in (#i0, #i8192)) );\n"
"if (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'RecoveryMode\'), \'0\') > \'0\')\n"
"{\n"
"log_message (\'Switching to RecoveryMode as set in [SPARQL] section of the configuration.\');\n"
"log_message (\'For safety, the use of SPARQL_UPDATE role is restricted.\');\n"
"exec (\'revoke \"SPARQL_UPDATE\" from \"SPARQL\"\', stat, msg);\n"
"return;\n"
"}\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"goto final_qm_reload;\n"
"if (244 = coalesce ((select COL_DTP from SYS_COLS where \"TABLE\" = \'DB.DBA.RDF_QUAD\' and \"COLUMN\"=\'G\'), 0))\n"
"{\n"
"__set_64bit_min_bnode_iri_id();\n"
"sequence_set (\'RDF_URL_IID_BLANK\', iri_id_num (min_bnode_iri_id ()), 1);\n"
"}\n"
"\n"
"if (exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\')\n"
"and \"COLUMN\" = fix_identifier_case (\'VT_WORD\') )\n"
"and exists (select top 1 1 from DB.DBA.SYS_COLS\n"
"where \"TABLE\" = fix_identifier_case (\'DB.DBA.RDF_OBJ\')\n"
"and \"COLUMN\" = fix_identifier_case (\'RO_FLAGS\')\n"
"and COL_DTP = 188 ) )\n"
"goto final_qm_reload;\n"
"exec (\'DB.DBA.vt_create_text_index (\n"
"fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'),\n"
"fix_identifier_case (\'\'RO_FLAGS\'\'),\n"
"fix_identifier_case (\'\'RO_ID\'\'),\n"
"0, 0, vector (), 1, \'\'*ini*\'\', \'\'UTF-8-QR\'\')\', stat, msg);\n"
"__vt_index (\'DB.DBA.RDF_QUAD\', \'RDF_QUAD_OP\', \'O\', \'O\', \'DB.DBA.RDF_OBJ_RO_FLAGS_WORDS\');\n"
"exec (\'DB.DBA.vt_batch_update (fix_identifier_case (\'\'DB.DBA.RDF_OBJ\'\'), \'\'ON\'\', 1)\', stat, msg);\n"
"\n"
"final_qm_reload:\n"
"DB.DBA.SPARQL_RELOAD_QM_GRAPH ();\n"
"\n"
"\n"
"\n"
"return;\n"
"}\n"
"--src sparql.sql:16107\n";


static const char *other39 = 
" DB.DBA.RDF_QUAD_FT_UPGRADE ()\n";
static const char *other40 = 
"DB.DBA.RDF_CREATE_SPARQL_ROLES ()\n";
static const char *proc383 = 
"#line 16175 \"[executable]/sparql.sql\"\n"
"create procedure rdfs_pn (in is_class int)\n"
"{\n"
"return case when is_class = 1 then iri_to_id (\'http://www.w3.org/2000/01/rdf-schema#subClassOf\')\n"
"else  iri_to_id (\'http://www.w3.org/2000/01/rdf-schema#subPropertyOf\') end;\n"
"}\n"
"--src sparql.sql:16173\n";

static const char *proc384 = 
"#line 16183 \"[executable]/sparql.sql\"\n"
"create procedure rdf_owl_sas_p (in gr iri_id, in name varchar, in super_c iri_id, in c iri_id, in visited any, inout supers any, in pos int)\n"
"{\n"
"declare txt varchar;\n"
"declare meta, cc, res any;\n"
"txt := sprintf (\'sparql define output:valmode \"LONG\"  define input:storage \"\"select ?o from <%s> where { <%s> <http://www.w3.org/2002/07/owl#sameAs> ?o }\',\n"
"id_to_iri(gr), id_to_iri(c) );\n"
"exec (txt, null, null,  vector (), 0, meta, null, cc);\n"
"while (0 = exec_next (cc, null, null, res))\n"
"{\n"
"rdfs_closure_1 (gr, name, super_c, res[0], 0, visited, supers, pos);\n"
"}\n"
"exec_close (cc);\n"
"txt := sprintf (\'sparql define output:valmode \"LONG\" define input:storage \"\" select ?s from <%s> where { ?s <http://www.w3.org/2002/07/owl#sameAs> <%s> }\',\n"
"id_to_iri(gr), id_to_iri(c) );\n"
"exec (txt, null, null,  vector (), 0, meta, null, cc);\n"
"while (0 = exec_next (cc, null, null, res))\n"
"{\n"
"rdfs_closure_1 (gr, name, super_c, res[0], 0, visited, supers, pos);\n"
"}\n"
"exec_close (cc);\n"
"}\n"
"--src sparql.sql:16181\n";

static const char *tbl19 = 
"create table DB.DBA.SYS_RDF_SCHEMA (RS_NAME VARCHAR , RS_URI VARCHAR, RS_G IRI_ID,\n"
"PRIMARY KEY (RS_NAME, RS_URI))\n"
"alter index SYS_RDF_SCHEMA on DB.DBA.SYS_RDF_SCHEMA partition cluster replicated\n";

static const char *proc385 = 
"#line 16212 \"[executable]/sparql.sql\"\n"
"create function rdfs_load_schema (in ri_name varchar, in gn varchar := null) returns integer\n"
"{\n"
"declare gr iri_id;\n"
"declare visited any;\n"
"declare supers any;\n"
"declare eq_c, eq_p iri_id;\n"
"declare txt varchar;\n"
"declare idx integer;\n"
"declare cc, res, st, msg, meta  any;\n"
"declare v any;\n"
"declare inx int;\n"
"declare from_text varchar;\n"
"declare rules_count integer;\n"
"from_text := \'\';\n"
"res := 0;\n"
"if (gn is null)\n"
"{\n"
"for (select RS_URI from DB.DBA.SYS_RDF_SCHEMA where RS_NAME=ri_name) do\n"
"{\n"
"from_text := from_text || sprintf (\' from <%s>\', RS_URI);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (isiri_id (gn))\n"
"from_text := from_text || sprintf (\' from <%s>\', id_to_iri (gn));\n"
"else\n"
"from_text := from_text || sprintf (\' from <%s>\', gn);\n"
"}\n"
"if (\'\' = from_text)\n"
"return 0;\n"
"\n"
"for (idx := 0; idx <= 4; idx := idx + 1)\n"
"{\n"
"txt := sprintf (\'sparql define output:valmode \"LONG\" define input:storage \"\" select ?s ?o %s where { ?s <%s> ?o . filter (!isLITERAL (?o)) }\',\n"
"from_text, id_to_iri (case (idx) when 4 then rdf_sas_iri () else rdf_owl_iri (idx) end) );\n"
"exec (txt, null, null, vector (), 0, meta, null, cc);\n"
"while (0 = exec_next (cc, null, null, res))\n"
"{\n"
"declare s, o any;\n"
"s := res[0]; o := res[1];\n"
"if (idx = 4)\n"
"{\n"
"rdf_inf_dir (ri_name, s, o, 2);\n"
"rdf_inf_dir (ri_name, s, o, 3);\n"
"rules_count := rules_count + 2;\n"
"}\n"
"else\n"
"{\n"
"rdf_inf_dir (ri_name, o, s, idx);\n"
"rules_count := rules_count + 1;\n"
"}\n"
"}\n"
"}\n"
"exec_close (cc);\n"
"\n"
"txt := sprintf (\'select DB.DBA.VECTOR_AGG (sub.\"s\") from\n"
"(sparql define output:valmode \"LONG\" define input:storage \"\"\n"
"select distinct ?s %s\n"
"where {\n"
"{ ?s a <http://www.w3.org/2002/07/owl#InverseFunctionalProperty> }\n"
"union\n"
"{ ?s a <http://www.w3.org/2002/07/owl#FunctionalProperty> , <http://www.w3.org/2002/07/owl#SymmetricProperty> }\n"
"union\n"
"{ ?s1 a <http://www.w3.org/2002/07/owl#FunctionalProperty> .\n"
"?s <http://www.w3.org/2002/07/owl#inverseOf> ?s1 }\n"
"union\n"
"{ ?s1 a <http://www.w3.org/2002/07/owl#FunctionalProperty> .\n"
"?s1 <http://www.w3.org/2002/07/owl#inverseOf> ?s }\n"
"}\n"
") sub option (QUIETCAST)\',\n"
"from_text );\n"
"exec (txt, null, null, vector (), 0, meta, res);\n"
"v := res[0][0];\n"
"if (0 < length (v))\n"
"{\n"
"txt := sprintf (\'select DB.DBA.VECTOR_AGG (sub.\"s\") from\n"
"(sparql define output:valmode \"LONG\" define input:storage \"\"\n"
"select ?s %s\n"
"where {\n"
"?s <http://www.w3.org/2000/01/rdf-schema#subPropertyOf> ?sp option (TRANSITIVE, T_MIN 1) .\n"
"filter (?sp = iri (?::0)) } ) sub option (QUIETCAST)\',\n"
"from_text );\n"
"for (inx := length (v) - 1; 0 <= inx; inx := inx - 1)\n"
"{\n"
"declare meta1, res1 any;\n"
"declare subprops any;\n"
"exec (txt, null, null, vector (v[inx]), 0, meta1, res1);\n"
"subprops := res1[0][0];\n"
"foreach (IRI_ID subp in subprops) do\n"
"{\n"
"\n"
"if (0 >= position (subp, v))\n"
"v := vector_concat (v, vector (subp));\n"
"}\n"
"}\n"
"\n"
"gvector_digit_sort (v, 1, 0, 1);\n"
"rdf_inf_set_ifp_list (ri_name, v);\n"
"rules_count := rules_count + length (v);\n"
"txt := sprintf (\'\n"
"select vector_agg (sub.\"o\") from\n"
"(sparql define output:valmode \"LONG\" define input:storage \"\"\n"
"select distinct ?o %s where {\n"
"{ ?::0 <http://www.openlinksw.com/schemas/virtrdf#nullIFPValue> ?o .\n"
"filter (isREF (?o)) }\n"
"union\n"
"{\n"
"?subp <http://www.w3.org/2000/01/rdf-schema#subPropertyOf> ?superp option (TRANSITIVE, T_MIN 1) .\n"
"?subp <http://www.openlinksw.com/schemas/virtrdf#nullIFPValue> ?o .\n"
"filter (?superp = ?::0)\n"
"filter (isREF (?o)) } } ) sub option (QUIETCAST)\',\n"
"from_text );\n"
"for (inx := 0; inx < length (v); inx := inx + 1)\n"
"{\n"
"declare meta1, res1 any;\n"
"declare excl any;\n"
"exec (txt, null, null, vector (v[inx]), 0, meta1, res1);\n"
"excl := meta1[0][0];\n"
"if (length (excl) > 0)\n"
"rdf_inf_set_ifp_exclude_list (ri_name, v[inx], excl);\n"
"}\n"
"}\n"
"\n"
"txt := sprintf (\'select DB.DBA.VECTOR_CONCAT_AGG (vector (sub.\"s\", sub.\"o\", sub.\"o\", sub.\"s\")) from\n"
"(sparql define input:storage \"\" select ?s ?o %s where {\n"
"?s <http://www.w3.org/2002/07/owl#inverseOf> ?o .\n"
"optional { ?o <http://www.w3.org/2002/07/owl#inverseOf> ?s2 . filter (?s2 = ?s ) }\n"
"filter ((str (?s) <= str (?o)) || !BOUND(?s2)) }) sub option (QUIETCAST)\',\n"
"from_text );\n"
"exec (txt, null, null, vector (), 0, meta, res);\n"
"v := res[0][0];\n"
"txt := sprintf (\'select DB.DBA.VECTOR_CONCAT_AGG (vector (sub.\"s\", sub.\"s\")) from\n"
"(sparql define input:storage \"\" select ?s %s where {\n"
"?s a <http://www.w3.org/2002/07/owl#SymmetricProperty> }) sub option (QUIETCAST)\',\n"
"from_text );\n"
"exec (txt, null, null, vector (), 0, meta, res);\n"
"v := vector_concat (v, res[0][0]);\n"
"if (0 < length (v))\n"
"{\n"
"gvector_sort (v, 2, 0, 1);\n"
"rdf_inf_set_inverses (ri_name, v);\n"
"rules_count := rules_count + length (v);\n"
"}\n"
"\n"
"txt := sprintf (\'select DB.DBA.VECTOR_CONCAT_AGG (vector (sub.\"s\", 1)) from\n"
"(sparql define input:storage \"\" select ?s %s where {\n"
"{ ?s a <http://www.w3.org/2002/07/owl#TransitiveProperty> }\n"
"union\n"
"{ ?s <http://www.w3.org/2002/07/owl#inverseOf> [ a <http://www.w3.org/2002/07/owl#TransitiveProperty> ] }\n"
"union\n"
"{ [ a <http://www.w3.org/2002/07/owl#TransitiveProperty> ] <http://www.w3.org/2002/07/owl#inverseOf> ?s }\n"
"} ) sub option (QUIETCAST)\',\n"
"from_text );\n"
"exec (txt, null, null, vector (), 0, meta, res);\n"
"v := res[0][0];\n"
"if (0 < length (v))\n"
"{\n"
"gvector_sort (v, 2, 0, 1);\n"
"rdf_inf_set_prop_props (ri_name, v);\n"
"rules_count := rules_count + length (v);\n"
"}\n"
"jso_mark_affected (ri_name);\n"
"log_text (\'jso_mark_affected (?)\', ri_name);\n"
"\n"
"rdf_inf_dir (ri_name, null, null, 0);\n"
"return rules_count + 1;\n"
"}\n"
"--src sparql.sql:16210\n";

static const char *proc386 = 
"#line 16382 \"[executable]/sparql.sql\"\n"
"create procedure rdf_schema_ld ()\n"
"{\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"return 0;\n"
"return (select count (*) from (select distinct s.RS_NAME from DB.DBA.SYS_RDF_SCHEMA s) sub where 0 = rdfs_load_schema (sub.RS_NAME));\n"
"}\n"
"--src sparql.sql:16380\n";

static const char *other41 = 
"rdf_schema_ld ()\n";
static const char *proc387 = 
"#line 16394 \"[executable]/sparql.sql\"\n"
"create function CL_RDF_INF_CHANGED_SRV (in name varchar) returns integer\n"
"{\n"
"declare res integer;\n"
"set isolation = \'committed\';\n"
"rdf_inf_clear (name);\n"
"return case (rdfs_load_schema (name)) when 0 then 1 else 0 end;\n"
"return res;\n"
"}\n"
"--src sparql.sql:16392\n";

static const char *proc388 = 
"#line 16404 \"[executable]/sparql.sql\"\n"
"create procedure CL_RDF_INF_CHANGED (in name varchar)\n"
"{\n"
"declare aq any;\n"
"if (2 = sys_stat (\'cl_run_local_only\'))\n"
"return;\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.CL_RDF_INF_CHANGED_SRV\', vector (name));\n"
"aq_wait_all (aq);\n"
"}\n"
"--src sparql.sql:16402\n";

static const char *proc389 = 
"#line 16415 \"[executable]/sparql.sql\"\n"
"create function rdfs_rule_set (in name varchar, in gn varchar, in remove int := 0) returns integer\n"
"{\n"
"delete from DB.DBA.SYS_RDF_SCHEMA where RS_NAME = name and RS_URI = gn;\n"
"if (not remove)\n"
"{\n"
"insert into DB.DBA.SYS_RDF_SCHEMA (RS_NAME, RS_URI) values (name, gn);\n"
"}\n"
"commit work;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'DB.DBA.CL_RDF_INF_CHANGED (?)\', vector (name));\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"declare res integer;\n"
"rdf_inf_clear (name);\n"
"res := rdfs_load_schema (name);\n"
"log_text (\'db.dba.rdfs_load_schema (?)\', name);\n"
"return res;\n"
"}\n"
"}\n"
"--src sparql.sql:16413\n";

static const char *proc390 = 
"#line 16439 \"[executable]/sparql.sql\"\n"
"create function DB.DBA.RDF_IID_OF_QNAME (in qname varchar) returns IRI_ID\n"
"{\n"
"whenever sqlstate \'*\' goto retnull;\n"
"return iri_to_id (qname, 0, null);\n"
"retnull:\n"
"return null;\n"
"}\n"
"--src sparql.sql:16437\n";

static const char *proc391 = 
"#line 16448 \"[executable]/sparql.sql\"\n"
"create procedure SPARQL_INI_PARAMS (inout metas any, inout dta any)\n"
"{\n"
"declare item_cnt int;\n"
"declare items any;\n"
"declare item_name, item_value varchar;\n"
"declare res_dict any;\n"
"declare tmp any;\n"
"\n"
"item_cnt := cfg_item_count (virtuoso_ini_path (), \'SPARQL\');\n"
"tmp := string_output ();\n"
"\n"
"for (declare i int, i := 0; i < item_cnt; i := i + 1)\n"
"{\n"
"item_name := cfg_item_name (virtuoso_ini_path (), \'SPARQL\', i);\n"
"item_value := virtuoso_ini_item_value (\'SPARQL\', item_name);\n"
"http (sprintf (\'<http://www.openlinksw.com/schemas/virtini#SPARQL> <http://www.openlinksw.com/schemas/virtini#%U> \"%s\" .\\r\\n\',\n"
"item_name, item_value), tmp);\n"
"}\n"
"tmp := string_output_string (tmp);\n"
"res_dict := DB.DBA.RDF_TTL2HASH (tmp, \'\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"dta := vector (vector (res_dict));\n"
"}\n"
"--src sparql.sql:16446\n";

static const char *proc392 = 
"#line 16473 \"[executable]/sparql.sql\"\n"
"create procedure cl_tmp_inx_recov_fill ()\n"
"{\n"
"if (registry_get (\'__rb_id_only_for_plain_ro_obj\') = \'1\')\n"
"return;\n"
"log_enable (2,1);\n"
"log_message (\'Cleaning the temporary table ...\');\n"
"again:\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP, no cluster) option (index RDF_QUAD_RECOV_TMP, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster) option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"delete from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_OP, index_only, no cluster) option (index RDF_QUAD_RECOV_TMP_OP, no cluster);\n"
"\n"
"if (exists (select 1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster)))\n"
"goto again;\n"
"\n"
"log_message (\'Copying all quads to a temporary table ...\');\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP index RDF_QUAD_RECOV_TMP option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD, no cluster);\n"
"insert soft DB.DBA.RDF_QUAD_RECOV_TMP index RDF_QUAD_RECOV_TMP_POGS option (no cluster) (G1,S1,P1,O1) select G,S,P,O from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS, no cluster);\n"
"}\n"
"--src sparql.sql:16471\n";

static const char *proc393 = 
"#line 16493 \"[executable]/sparql.sql\"\n"
"create procedure cl_inx_recov_clean ()\n"
"{\n"
"if (registry_get (\'__rb_id_only_for_plain_ro_obj\') = \'1\')\n"
"return;\n"
"log_enable (2,1);\n"
"log_message (\'Cleaning the quad storage ...\');\n"
"again:\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD, no cluster) option (index RDF_QUAD, no cluster);\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS, no cluster) option (index RDF_QUAD_POGS, no cluster);\n"
"delete from DB.DBA.RDF_QUAD table option (index RDF_QUAD_OP, index_only, no cluster) option (index RDF_QUAD_OP, no cluster);\n"
"if (exists (select 1 from DB.DBA.RDF_QUAD table option (index RDF_QUAD_POGS, no cluster)))\n"
"goto again;\n"
"\n"
"}\n"
"--src sparql.sql:16491\n";

static const char *proc394 = 
"#line 16509 \"[executable]/sparql.sql\"\n"
"create procedure cl_inx_recov_fill_1 ()\n"
"{\n"
"if (registry_get (\'__rb_id_only_for_plain_ro_obj\') = \'1\')\n"
"return;\n"
"log_enable (2,1);\n"
"log_message (\'Refilling the quad storage (PK) from the temporary table...\');\n"
"insert into DB.DBA.RDF_QUAD index RDF_QUAD option (no cluster) (G,S,P,O) select G1,S1,P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP, no cluster);\n"
"log_message (\'Refilling the quad storage (POGS) from the temporary table...\');\n"
"insert into DB.DBA.RDF_QUAD index RDF_QUAD_POGS option (no cluster) (G,S,P,O) select G1,S1,P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"log_message (\'Refilling the quad storage (OP) from the temporary table...\');\n"
"insert soft DB.DBA.RDF_QUAD index RDF_QUAD_OP option (index_only, no cluster) (P,O) select P1,O1 from DB.DBA.RDF_QUAD_RECOV_TMP table option (index RDF_QUAD_RECOV_TMP_POGS, no cluster);\n"
"log_message (\'Done.\');\n"
"}\n"
"--src sparql.sql:16507\n";

static const char *proc395 = 
"#line 16535 \"[executable]/sparql.sql\"\n"
"create procedure exec_from_daq (in cmd varchar)\n"
"{\n"
"declare aq any;\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.AQ_EXEC_SRV\', vector (cmd));\n"
"aq_wait_all (aq);\n"
"}\n"
"--src sparql.sql:16533\n";

static const char *proc396 = 
"#line 16544 \"[executable]/sparql.sql\"\n"
"create procedure cl_inx_recov (in force int := 0)\n"
"{\n"
"declare old_mode, tries int;\n"
"if (force)\n"
"DB.DBA.CL_EXEC (\'registry_remove (\'\'__rb_id_only_for_plain_ro_obj\'\')\');\n"
"if (registry_get (\'__rb_id_only_for_plain_ro_obj\') = \'1\')\n"
"return;\n"
"DB.DBA.CL_EXEC (\'checkpoint_interval (0)\');\n"
"log_message (\'Automatic checkpoint is stopped, must enable manually once upgrade finished.\');\n"
"DB.DBA.CL_EXEC (\'__dbf_set (\'\'cl_max_keep_alives_missed\'\', 10000)\');\n"
"DB.DBA.CL_EXEC (\'__dbf_set (\'\'cl_non_logged_write_mode\'\', 1)\');\n"
"DB.DBA.CL_EXEC (\'checkpoint\');\n"
"old_mode := log_enable (2,1);\n"
"DB.DBA.CL_EXEC (\'exec_from_daq (\'\'cl_tmp_inx_recov_fill ()\'\')\');\n"
"clear_retry:\n"
"DB.DBA.CL_EXEC (\'exec_from_daq (\'\'cl_inx_recov_clean ()\'\')\');\n"
"if (\n"
"exists (select 1 from rdf_quad table option (index rdf_quad)) or\n"
"exists (select 1 from rdf_quad table option (index rdf_quad_pogs)) or\n"
"exists (select 1 from rdf_quad table option (index rdf_quad_op, index_only))\n"
")\n"
"{\n"
"tries := tries + 1;\n"
"if (tries > 100)\n"
"{\n"
"log_message (\'Quad store can not be cleaned, data reloading is strictly recommended.\');\n"
"DB.DBA.CL_EXEC (\'raw_exit ()\');\n"
"}\n"
"log_message (sprintf (\'Quad store is not fully cleaned, will try again [%d]\', tries));\n"
"goto clear_retry;\n"
"}\n"
"DB.DBA.CL_EXEC (\'exec_from_daq (\'\'cl_inx_recov_fill_1 ()\'\')\');\n"
"DB.DBA.CL_EXEC (\'registry_set (\'\'__rb_id_only_for_plain_ro_obj\'\', \'\'1\'\')\');\n"
"if (not force)\n"
"DB.DBA.CL_EXEC (\'checkpoint\');\n"
"log_message (\'integrity check (completeness of index RDF_QUAD_POGS of DB.DBA.RDF_QUAD) ...\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD a table option (index RDF_QUAD) where not exists (select 1 from DB.DBA.RDF_QUAD b table option (loop, index RDF_QUAD_POGS)\n"
"where a.g = b.g and a.p = b.p and a.o = b.o and a.s = b.s)))\n"
"log_message (\'** IMPORTANT WARNING: not all rows of DB.DBA.RDF_QUAD are found in RDF_QUAD_POGS, data reloading is strictly recommended.\');\n"
"\n"
"log_message (\'integrity check (completeness of primary key of DB.DBA.RDF_QUAD) ...\');\n"
"if (exists (select top 1 1 from DB.DBA.RDF_QUAD a table option (index RDF_QUAD_POGS) where not exists (select 1 from DB.DBA.RDF_QUAD b table option (loop, index RDF_QUAD)\n"
"where a.g = b.g and a.p = b.p and a.o = b.o and a.s = b.s)))\n"
"log_message (\'** IMPORTANT WARNING: not all rows of DB.DBA.RDF_QUAD are found in RDF_QUAD_POGS, data reloading is strictly recommended.\');\n"
"log_enable (old_mode, 1);\n"
"DB.DBA.CL_EXEC (\'__dbf_set (\'\'cl_non_logged_write_mode\'\', 0)\');\n"
"log_message (\'Update complete.\');\n"
"if (force)\n"
"log_message (\'Must do checkpoint to persist the db state.\');\n"
"}\n"
"--src sparql.sql:16542\n";

/* sparql_io.sql */

static const char *proc397 = 
"#line 25 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_XML_WRITE_NS (inout ses any)\n"
"{\n"
"\n"
"http (\'<sparql xmlns=\"http://www.w3.org/2005/sparql-results#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2.xsd\">\', ses);\n"
"}\n"
"--src sparql_io.sql:23\n";

static const char *proc398 = 
"#line 34 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_XML_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"http (\'\\n <head>\', ses);\n"
"i := 0; col_count := length (colnames);\n"
"while (i < col_count)\n"
"{\n"
"http (sprintf (\'\\n  <variable name=\"%s\"/>\', colnames[i]), ses);\n"
"i := i + 1;\n"
"}\n"
"http (\'\\n </head>\', ses);\n"
"}\n"
"--src sparql_io.sql:32\n";

static const char *proc399 = 
"#line 49 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_RSET_XML_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses integer;\n"
"ses := 0;\n"
"\n"
"if (strchr (accept, \' \') is not null)\n"
"accept := subseq (accept, strchr (accept, \' \')+1);\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_NS (ses);\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_HEAD (ses, colnames);\n"
"http (\'\\n <results>\');\n"
"return colnames;\n"
"}\n"
"--src sparql_io.sql:47\n";

static const char *proc400 = 
"#line 66 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_XML_HTTP_INIT (inout env any)\n"
"{\n"
"env := 0;\n"
"}\n"
"--src sparql_io.sql:64\n";

static const char *proc401 = 
"#line 73 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_RSET_XML_HTTP_FINAL (inout env any)\n"
"{\n"
"http (\'\\n </results>\');\n"
"http (\'\\n</sparql>\');\n"
"}\n"
"--src sparql_io.sql:71\n";

static const char *other42 = 
" create aggregate DB.DBA.SPARQL_RSET_XML_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_INIT,\n"
"sparql_rset_xml_write_row,\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_FINAL\n"
"order\n";

static const char *proc402 = 
"#line 90 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_DICT_XML_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses integer;\n"
"\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_XML_WRITE_NS (ses);\n"
"http (\'\\n <head><variable name=\"S\"/><variable name=\"P\"/><variable name=\"O\"/></head>\');\n"
"http (\'\\n <results distinct=\"false\" ordered=\"true\">\');\n"
"return colnames;\n"
"}\n"
"--src sparql_io.sql:88\n";

static const char *other43 = 
" create aggregate DB.DBA.SPARQL_DICT_XML_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_INIT,\n"
"sparql_dict_xml_write_row,\n"
"DB.DBA.SPARQL_RSET_XML_HTTP_FINAL\n";

static const char *proc403 = 
"#line 113 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_TTL_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'@prefix res: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"_:_ a res:ResultSet .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:111\n";

static const char *proc404 = 
"#line 122 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"col_count := length (colnames);\n"
"if (0 = col_count)\n"
"return;\n"
"http (\'_:_ res:resultVariable \"\', ses);\n"
"for (i := 0; i < col_count; i := i + 1)\n"
"{\n"
"if (i > 0)\n"
"http (\'\" , \"\', ses);\n"
"http_escape (colnames[i], 11, ses, 0, 1);\n"
"}\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:120\n";

static const char *proc405 = 
"#line 140 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_RSET_TTL_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses, colctr, colcount integer;\n"
"declare res any;\n"
"\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_TTL_WRITE_NS (ses);\n"
"DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD (ses, colnames);\n"
"colcount := length (colnames);\n"
"res := make_array (colcount * 7, \'any\');\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"res [colctr * 7] := colnames [colctr];\n"
"}\n"
"return vector (dict_new (16000), 0, \'\', \'\', \'\', 0, 0, res, 0);\n"
"}\n"
"--src sparql_io.sql:138\n";

static const char *proc406 = 
"#line 161 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_TTL_HTTP_INIT (inout env any)\n"
"{\n"
"env := 0;\n"
"}\n"
"--src sparql_io.sql:159\n";

static const char *proc407 = 
"#line 168 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL (inout env any)\n"
"{\n"
" ;\n"
"}\n"
"--src sparql_io.sql:166\n";

static const char *other44 = 
" create aggregate DB.DBA.SPARQL_RSET_TTL_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_INIT,\n"
"sparql_rset_ttl_write_row,\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL\n"
"order\n";

static const char *proc408 = 
"#line 183 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_NT_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'_:ResultSet2053 <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://www.w3.org/1999/02/22-rdf-syntax-ns#ResultSet> .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:181\n";

static const char *proc409 = 
"#line 190 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_RSET_NT_WRITE_HEAD (inout ses any, in colnames any)\n"
"{\n"
"declare i, col_count integer;\n"
"col_count := length (colnames);\n"
"for (i := 0; i < col_count; i := i + 1)\n"
"{\n"
"http (\'_:ResultSet2053 <http://www.w3.org/2005/sparql-results#resultVariable> \"\', ses);\n"
"http_escape (colnames[i], 11, ses, 0, 1);\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:188\n";

static const char *proc410 = 
"#line 204 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_RSET_NT_HTTP_PRE (in colnames any, in accept varchar)\n"
"{\n"
"declare ses, colctr, colcount integer;\n"
"declare res any;\n"
"\n"
"http_header (\'Content-Type: \' || accept || \'; charset=UTF-8\\r\\n\');\n"
"http_flush (1);\n"
"ses := 0;\n"
"DB.DBA.SPARQL_RSET_NT_WRITE_NS (ses);\n"
"DB.DBA.SPARQL_RSET_NT_WRITE_HEAD (ses, colnames);\n"
"colcount := length (colnames);\n"
"res := make_array (colcount * 7, \'any\');\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"res [colctr * 7] := colnames [colctr];\n"
"}\n"
"return vector (0, res, 0);\n"
"}\n"
"--src sparql_io.sql:202\n";

static const char *other45 = 
" create aggregate DB.DBA.SPARQL_RSET_NT_HTTP (inout colnames any, inout row any) from\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_INIT,\n"
"sparql_rset_nt_write_row,\n"
"DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL\n"
"order\n";

static const char *proc411 = 
"#line 235 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_REXEC_INT (\n"
"in res_mode integer,\n"
"in res_make_obj integer,\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"inout named_graphs any,\n"
"inout req_hdr any,\n"
"in maxrows integer,\n"
"inout metas any,\n"
"inout bnode_dict any,\n"
"in expected_var_list any := null,\n"
"in options any := null\n"
")\n"
"{\n"
"declare quest_pos integer;\n"
"declare req_uri, req_method, req_body, local_req_hdr, ret_body, ret_hdr any;\n"
"declare ret_content_type, ret_known_content_type, ret_format varchar;\n"
"\n"
"quest_pos := strchr (service, \'?\');\n"
"req_body := string_output();\n"
"if (quest_pos is not null)\n"
"{\n"
"http (subseq (service, quest_pos+1), req_body);\n"
"http (\'&\', req_body);\n"
"service := subseq (service, 0, quest_pos);\n"
"}\n"
"http (\'query=\', req_body);\n"
"http_url (query, 0, req_body);\n"
"if (dflt_graph is not null and dflt_graph <> \'\')\n"
"{\n"
"http (\'&default-graph-uri=\', req_body);\n"
"http_url (dflt_graph, 0, req_body);\n"
"}\n"
"foreach (varchar uri in named_graphs) do\n"
"{\n"
"http (\'&named-graph-uri=\', req_body);\n"
"http_url (uri, 0, req_body);\n"
"}\n"
"if (maxrows is not null)\n"
"http (sprintf (\'&maxrows=%d\', maxrows), req_body);\n"
"req_body := string_output_string (req_body);\n"
"local_req_hdr := \'Accept: application/sparql-results+xml, text/rdf+n3, text/rdf+ttl, text/rdf+turtle, text/turtle, application/turtle, application/x-turtle, application/rdf+xml, application/xml\';\n"
"req_method := coalesce (\n"
"get_keyword (\'req_method\', options, null),\n"
"(sparql define input:storage \"\" select ?mtd from virtrdf: where { `iri(?:service)` virtrdf:bestRequestMethod ?mtd }),\n"
"case when (length (req_body) + length (service) >= 1900) then \'POST\' else \'GET\' end );\n"
"if (\'POST\' = req_method)\n"
"{\n"
"req_uri := service;\n"
"local_req_hdr := local_req_hdr || \'\\r\\nContent-Type: application/x-www-form-urlencoded\';\n"
"}\n"
"else\n"
"{\n"
"req_method := \'GET\';\n"
"req_uri := service || \'?\' || req_body;\n"
"req_body := \'\';\n"
"}\n"
"if (length (req_hdr) > 0)\n"
"req_hdr := concat (req_hdr, \'\\r\\n\', local_req_hdr );\n"
"else\n"
"req_hdr := local_req_hdr;\n"
"\n"
"\n"
"\n"
"ret_body := http_get (req_uri, ret_hdr, req_method, req_hdr, req_body);\n"
"\n"
"\n"
"ret_content_type := http_request_header (ret_hdr, \'Content-Type\', null, null);\n"
"ret_known_content_type := http_sys_find_best_sparql_accept (ret_content_type, 0, ret_format);\n"
"\n"
"if (ret_format is null or not (ret_format in (\'XML\', \'RDFXML\', \'TTL\')))\n"
"{\n"
"declare ret_begin, ret_html any;\n"
"ret_begin := \"LEFT\" (ret_body, 1024);\n"
"ret_html := xtree_doc (ret_begin, 2);\n"
"\n"
"if (xpath_eval (\'/html|/xhtml\', ret_html) is not null)\n"
"ret_format := \'HTML\';\n"
"else if (xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] /rset:sparql\', ret_html) is not null\n"
"or xpath_eval (\'[xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"] /rset2:sparql\', ret_html) is not null)\n"
"ret_format := \'XML\';\n"
"else if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] /rdf:rdf\', ret_html) is not null)\n"
"ret_format := \'RDFXML\';\n"
"else if (strstr (ret_begin, \'<html>\') is not null or\n"
"strstr (ret_begin, \'<xhtml>\') is not null )\n"
"ret_format := \'HTML\';\n"
"}\n"
"if (ret_format = \'XML\')\n"
"{\n"
"declare ret_xml, var_list, var_metas, ret_row, out_nulls any;\n"
"declare var_ctr, var_count integer;\n"
"declare vect_acc any;\n"
"declare row_inx integer;\n"
"\n"
"ret_xml := xtree_doc (ret_body, 0);\n"
"var_list := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:head/rset:variable/@name | /rset2:sparql/rset2:head/rset2:variable/@name\', ret_xml, 0);\n"
"if (0 = length (var_list))\n"
"{\n"
"declare bool_ret any;\n"
"bool_ret := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:boolean | /rset2:sparql/rset2:boolean\', ret_xml);\n"
"if (bool_ret is not null)\n"
"{\n"
"bool_ret := cast (bool_ret as varchar);\n"
"if (\'true\' = bool_ret)\n"
"bool_ret := 1;\n"
"else if (\'false\' = bool_ret)\n"
"bool_ret := 0;\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) has received invalid boolean value \'\'%.300s\'\'\',\n"
"service, bool_ret ) );\n"
"metas :=\n"
"vector (\n"
"vector (\n"
"vector (\'__ask_retval\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0) ),\n"
"1 );\n"
"if (0 = res_mode)\n"
"{\n"
"declare __ask_retval integer;\n"
"result_names (__ask_retval);\n"
"result (bool_ret);\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (bool_ret));\n"
"return;\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) has received result with no variables\',\n"
"service ) );\n"
"}\n"
"var_count := length (var_list);\n"
"if (expected_var_list is not null)\n"
"{\n"
"for (var_ctr := var_count - 1; var_ctr >= 0; var_ctr := var_ctr - 1)\n"
"{\n"
"declare var_name varchar;\n"
"var_name := cast (var_list[var_ctr] as varchar);\n"
"if (0 >= position (var_name, expected_var_list))\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) has received result with unexpected variable name \'\'%.300s\'\'\',\n"
"service, var_name ) );\n"
"}\n"
"var_list := expected_var_list;\n"
"var_count := length (var_list);\n"
"}\n"
"var_metas := make_array (var_count, \'any\');\n"
"out_nulls := make_array (var_count, \'any\');\n"
"for (var_ctr := var_count - 1; var_ctr >= 0; var_ctr := var_ctr - 1)\n"
"{\n"
"declare var_name varchar;\n"
"var_name := cast (var_list[var_ctr] as varchar);\n"
"var_list [var_ctr] := var_name;\n"
"var_metas [var_ctr] := vector (var_name, 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0);\n"
"out_nulls [var_ctr] := null;\n"
"}\n"
"\n"
"if (0 = res_mode)\n"
"exec_result_names (var_metas);\n"
"else if (1 = res_mode)\n"
"vectorbld_init (vect_acc);\n"
"row_inx := 0;\n"
"for (ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"/rset:sparql/rset:results/rset:result | /rset2:sparql/rset2:results/rset2:result\', ret_xml);\n"
"ret_row is not null;\n"
"ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"following-sibling::rset:result | following-sibling::rset2:result\', ret_row) )\n"
"{\n"
"declare out_fields, ret_cols any;\n"
"declare col_ctr, col_count integer;\n"
"out_fields := out_nulls;\n"
"ret_cols := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"rset:binding | rset2:binding\', ret_row, 0);\n"
"col_count := length (ret_cols);\n"
"for (col_ctr := col_count - 1; col_ctr >= 0; col_ctr := col_ctr - 1)\n"
"{\n"
"declare ret_col any;\n"
"declare var_name, var_type, var_strval varchar;\n"
"declare var_pos integer;\n"
"ret_col := ret_cols[col_ctr];\n"
"var_name := cast (xpath_eval (\'string(@name)\', ret_col) as varchar);\n"
"\n"
"var_pos := position (var_name, var_list) - 1;\n"
"if (var_pos >= 0)\n"
"{\n"
"var_type := cast (xpath_eval (\'local-name(*)\', ret_col) as varchar);\n"
"var_strval := charset_recode (xpath_eval (\'string(*)\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"\n"
"if (\'uri\' = var_type)\n"
"out_fields [var_pos] := iri_to_id (var_strval);\n"
"else if (\'bnode\' = var_type)\n"
"{\n"
"declare local_iid IRI_ID;\n"
"if (bnode_dict is null)\n"
"{\n"
"bnode_dict := dict_new ();\n"
"local_iid := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"dict_put (bnode_dict, var_strval, local_iid);\n"
"}\n"
"else\n"
"{\n"
"local_iid := dict_get (bnode_dict, var_strval, null);\n"
"if (local_iid is null)\n"
"{\n"
"local_iid := iri_id_from_num (sequence_next (\'RDF_URL_IID_BLANK\'));\n"
"dict_put (bnode_dict, var_strval, local_iid);\n"
"}\n"
"}\n"
"out_fields [var_pos] := local_iid;\n"
"}\n"
"else if (\'literal\' = var_type)\n"
"{\n"
"declare lang, dt varchar;\n"
"lang := charset_recode (xpath_eval (\'*/@xml:lang\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"dt := charset_recode (xpath_eval (\'*/@datatype\', ret_col), \'_WIDE_\', \'UTF-8\');\n"
"if (res_make_obj)\n"
"out_fields [var_pos] := DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS (\n"
"var_strval, dt, lang );\n"
"else\n"
"out_fields [var_pos] := DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS (\n"
"var_strval, dt, lang );\n"
"}\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) contains unsupported type of bound value \'\'%.300s\'\'\',\n"
"service, var_type ) );\n"
"}\n"
"}\n"
"if (0 = res_mode)\n"
"exec_result (out_fields);\n"
"else if (1 = res_mode)\n"
"vectorbld_acc (vect_acc, out_fields);\n"
"row_inx := row_inx + 1;\n"
"if (maxrows is not null and maxrows > 0 and row_inx >= maxrows)\n"
"ret_row := xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] [xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"]\n"
"../rset:result[position() = last()] | ../rset2:result[position() = last()]\', ret_row);\n"
"}\n"
"metas := vector (var_metas, 1);\n"
"if (0 = res_mode)\n"
"{\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"{\n"
"vectorbld_final (vect_acc);\n"
"return vect_acc;\n"
"}\n"
"}\n"
"if (ret_format = \'RDFXML\')\n"
"{\n"
"declare res_dict any;\n"
"res_dict := DB.DBA.RDF_RDFXML_TO_DICT (ret_body,\'http://local.virt/tmp\',\'http://local.virt/tmp\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"if (0 = res_mode)\n"
"{\n"
"result_names (res_dict);\n"
"result (res_dict);\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (res_dict));\n"
"}\n"
"if (ret_format = \'TTL\')\n"
"{\n"
"declare res_dict any;\n"
"res_dict := DB.DBA.RDF_TTL2HASH (ret_body, \'\');\n"
"metas := vector (vector (vector (\'res_dict\', 242, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0)), 1);\n"
"if (0 = res_mode)\n"
"{\n"
"result_names (res_dict);\n"
"result (res_dict);\n"
"return;\n"
"}\n"
"else if (1 = res_mode)\n"
"return vector (vector (res_dict));\n"
"}\n"
"if (strstr (ret_content_type, \'text/plain\') is not null)\n"
"{\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.1000s\',\n"
"service, ret_content_type, ret_hdr[0], \"LEFT\" (ret_body, 1024) ) );\n"
"}\n"
"if (strstr (ret_content_type, \'text/html\') is not null)\n"
"{\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.1000s\',\n"
"service, ret_content_type, ret_hdr[0],\n"
"\"LEFT\" (cast (xtree_doc (ret_body, 2) as varchar), 1024) ) );\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'DB.DBA.SPARQL_REXEC(\'\'%.300s\'\', ...) returned unsupported Content-Type \'\'%.300s\'\'\',\n"
"service, ret_content_type ) );\n"
"}\n"
"--src sparql_io.sql:233\n";

static const char *proc412 = 
"#line 532 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_REXEC (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any,\n"
"in options any := null\n"
")\n"
"{\n"
"declare metas any;\n"
"DB.DBA.SPARQL_REXEC_INT (0, 0, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metas, bnode_dict, options);\n"
"}\n"
"--src sparql_io.sql:530\n";

static const char *proc413 = 
"#line 548 \"[executable]/sparql_io.sql\"\n"
"create function DB.DBA.SPARQL_REXEC_TO_ARRAY (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any,\n"
"in expected_var_list any := null,\n"
"in options any := null\n"
") returns any\n"
"{\n"
"declare metas any;\n"
"return DB.DBA.SPARQL_REXEC_INT (1, 0, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metas, bnode_dict, expected_var_list, options);\n"
"}\n"
"--src sparql_io.sql:546\n";

static const char *proc414 = 
"#line 565 \"[executable]/sparql_io.sql\"\n"
"create function DB.DBA.SPARQL_REXEC_TO_ARRAY_OF_OBJ (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any,\n"
"in expected_var_list any := null,\n"
"in options any := null\n"
") returns any\n"
"{\n"
"declare metas any;\n"
"return DB.DBA.SPARQL_REXEC_INT (1, 1, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metas, bnode_dict, expected_var_list, options);\n"
"}\n"
"--src sparql_io.sql:563\n";

static const char *proc415 = 
"#line 582 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_REXEC_WITH_META (\n"
"in service varchar,\n"
"in query varchar,\n"
"in dflt_graph varchar,\n"
"in named_graphs any,\n"
"in req_hdr any,\n"
"in maxrows integer,\n"
"in bnode_dict any,\n"
"out metadata any,\n"
"out resultset any,\n"
"in options any := null\n"
")\n"
"{\n"
"resultset := DB.DBA.SPARQL_REXEC_INT (1, 0, service, query, dflt_graph, named_graphs, req_hdr, maxrows, metadata, bnode_dict, options);\n"
"\n"
"}\n"
"--src sparql_io.sql:580\n";

static const char *proc416 = 
"#line 600 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SD_PROBE (in service_iri varchar, in proxy_iri varchar := null, in verbose integer := 0, in inside_resultset integer := 0)\n"
"{\n"
"declare STAT, MSG varchar;\n"
"declare g_iri, lang_bits_hex varchar;\n"
"declare guess_bits, lang_bits, get_is_ok, post_is_ok integer;\n"
"if (not inside_resultset)\n"
"result_names (STAT, MSG);\n"
"lang_bits := 0;\n"
"g_iri := null;\n"
"get_is_ok := null;\n"
"post_is_ok := null;\n"
"if (isstring (registry_get (\'URIQADefaultHost\')) and strstr (service_iri, registry_get (\'URIQADefaultHost\')) is not null)\n"
"signal (\'22023\', \'Can not load own service description\');\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask { graph `iri (?:service_iri)` { { ?s a sd:Service } union { ?s sd:endpoint ?ep } } } ) )\n"
"{\n"
"result (\'00000\', \'The graph <\' || service_iri || \'> contains old service description data, the graph will be erased first\');\n"
"sparql define input:storage \"\" clear graph iri (?:service_iri);\n"
"commit work;\n"
"}\n"
"if (proxy_iri is not null)\n"
"{\n"
"sparql load iri (?:proxy_iri);\n"
"if (not exists (sparql define input:storage \"\" ask where { graph `iri(?:proxy_iri)` { ?s ?p ?o }}))\n"
"signal (\'22023\', \'The resource <\' || proxy_iri || \'> exists but does not contain any RDF data\');\n"
"if (not exists (sparql define input:storage \"\"\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask where { graph `iri(?:proxy_iri)` { ?s sd:endpoint ?o }}))\n"
"signal (\'22023\', \'The resource <\' || proxy_iri || \'> exists but does not contain service description data\');\n"
"if (not exists (sparql define input:storage \"\"\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask where { graph `iri(?:proxy_iri)` { ?s sd:endpoint ?o }}))\n"
"{\n"
"result (\'0000\', \'The resource <\' || proxy_iri || \'> exists and describes some services but not the desired service <\' || service_iri || \'>\');\n"
"goto g_done;\n"
"}\n"
"g_iri := proxy_iri;\n"
"goto g_done;\n"
"}\n"
"if (not (ends_with (service_iri, \'-sd\')))\n"
"{\n"
"declare sd_iri varchar;\n"
"sd_iri := service_iri || \'-sd\';\n"
"if (exists (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask { graph `iri (?:sd_iri)` { { ?s a sd:Service } union { ?s sd:endpoint ?ep } } }))\n"
"{\n"
"result (\'00000\', \'The graph <\' || sd_iri || \'> contains old service description data, the graph will be erased first\');\n"
"sparql define input:storage \"\" clear graph iri (?:sd_iri);\n"
"commit work;\n"
"}\n"
"whenever sqlstate \'*\' goto no_sd;\n"
"result (\'00000\', \'Trying to load <\' || sd_iri || \'> as a standalone service description...\');\n"
"sparql load iri (?:sd_iri);\n"
"if (not exists (sparql define input:storage \"\" ask where { graph `iri(?:sd_iri)` { ?s ?p ?o }}))\n"
"{\n"
"result (\'00000\', \'The resource <\' || sd_iri || \'> does not contain any RDF data, ignored\');\n"
"goto no_sd;\n"
"}\n"
"if (not exists (sparql define input:storage \"\"\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask where { graph `iri(?:sd_iri)` { ?s sd:endpoint ?o }}))\n"
"{\n"
"result (\'00000\', \'The resource <\' || sd_iri || \'> exists but does not contain service description data, ignored\');\n"
"goto no_sd;\n"
"}\n"
"g_iri := sd_iri;\n"
"result (\'00000\', \'The resource <\' || sd_iri || \'> contains service description data and is used as an authoritative source\');\n"
"goto g_done;\n"
"}\n"
"no_sd:\n"
"if (verbose)\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"{\n"
"whenever sqlstate \'*\' goto g_done;\n"
"result (\'00000\', \'Trying to load <\' || service_iri || \'> as self-description of the service...\');\n"
"sparql load iri (?:service_iri);\n"
"if (not exists (sparql define input:storage \"\" ask where { graph `iri(?:service_iri)` { ?s ?p ?o }}))\n"
"{\n"
"result (\'00000\', \'The resource <\' || service_iri || \'> exists but does not contain any RDF data, ignored\');\n"
"goto g_done;\n"
"}\n"
"if (not exists (sparql define input:storage \"\"\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"ask where { graph `iri(?:service_iri)` { ?s sd:endpoint ?o }}))\n"
"{\n"
"result (\'00000\', \'The resource <\' || service_iri || \'> exists but does not contain service description data, ignored\');\n"
"goto g_done;\n"
"}\n"
"g_iri := service_iri;\n"
"goto g_done;\n"
"}\n"
"if (verbose)\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"g_done:\n"
"if (g_iri is not null)\n"
"{\n"
"declare srv_iri varchar;\n"
"srv_iri := (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"select ?srv where { graph `iri(?:g_iri)` { ?srv sd:endpoint `iri (?:service_iri)` } }\n"
"order by desc (str (?srv)) limit 1 );\n"
"if (srv_iri is null)\n"
"{\n"
"result (\'22023\', \'The resource <\' || g_iri || \'> is loaded but it does not contain metadata related to <\' || service_iri || \'> as a SPARQL web service endpoint\');\n"
"goto get_and_post_checks;\n"
"}\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"select ?endpoint\n"
"where { graph `iri(?:g_iri)` { `iri(?:srv_iri)` sd:endpoint ?endpoint } } ) do\n"
"{\n"
"sparql\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"insert in virtrdf: { `iri(?:endpoint)` virtrdf:isEndpointOfService `iri(?:srv_iri)` };\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'jso_triple_add (?,?,?)\', vector (\"endpoint\", UNAME\'http://www.openlinksw.com/schemas/virtrdf#isEndpointOfService\', srv_iri));\n"
"result (\'00000\', \'The IRI <\' || endpoint || \'> is registered as an web service endpoint of SPARQL service <\' || service_iri || \'>\');\n"
"}\n"
"declare feats any;\n"
"feats := vector (\n"
"\'QUAD_MAP\'		, 0hex0001,\n"
"\'OPTION\'		, 0hex0002,\n"
"\'BREAKUP\'		, 0hex0004,\n"
"\'PKSELFJOIN\'		, 0hex0008,\n"
"\'RVR\'			, 0hex0010,\n"
"\'IN\'			, 0hex0020,\n"
"\'LIKE\'			, 0hex0040,\n"
"\'GLOBALS\'		, 0hex0080,\n"
"\'BI\'			, 0hex0100,\n"
"\'VIRTSPECIFIC\'		, 0hex0200,\n"
"\'VOS_509\'		, 0hex03FF,\n"
"\'SERVICE\'		, 0hex0400,\n"
"\'VOS_5_LATEST\'		, 0hex0FFF,\n"
"\'TRANSIT\'		, 0hex1000,\n"
"\'VOS_6\'			, 0hex1FFF,\n"
"\'SPARQL11_DRAFT\'	, 0hex2000,\n"
"\'SPARQL11_FULL\'		, 0hex4000,\n"
"\'SPARQL11\'		, 0hex6000 );\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"select (bif:subseq (str(?le), bif:length (str(virtrdf:SSG_SD_)))) as ?feat\n"
"where { graph `iri (?:g_iri)` { { `iri(?:srv_iri)` sd:languageExtension ?le } union { `iri(?:service_iri)` sd:languageExtension ?le } } } ) do\n"
"{\n"
"declare bits integer;\n"
"bits := get_keyword (\"feat\", feats, 0);\n"
"lang_bits := bit_or (lang_bits, bits);\n"
"}\n"
"if (lang_bits = 0)\n"
"result (\'00000\', \'The service metadata does not contain enough data about language capabilities, they will be probed by sample requests\');\n"
"else\n"
"result (\'00000\', sprintf (\'The service metadata contains data about language capabilities: equivalent of define lang:dialect %d (hex %8x)\', lang_bits, lang_bits));\n"
"for (sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"select ?mtd\n"
"where { graph `iri (?:g_iri)` { `iri(?:srv_iri)` virtrdf:requestMethod ?mtd } } ) do\n"
"{\n"
"if (\'POST\' = mtd) post_is_ok := 1;\n"
"else if (\'GET\' = mtd) get_is_ok := 1;\n"
"}\n"
"}\n"
"get_and_post_checks:\n"
"if (get_is_ok is null and post_is_ok is null)\n"
"{\n"
"{\n"
"whenever sqlstate \'*\' goto bad_get_endpoint;\n"
"result (\'00000\', \'Trying to query <\' || service_iri || \'> as SPARQL web service endpoint, GET mode...\');\n"
"DB.DBA.SPARQL_REXEC_TO_ARRAY (service_iri, \'select ?s where { ?s ?p ?o } limit 1\', null, null, null, 1, null, null, vector (\'req_method\', \'GET\'));\n"
"}\n"
"get_is_ok := 1;\n"
"goto get_done;\n"
"bad_get_endpoint:\n"
"if (verbose)\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"get_is_ok := 0;\n"
"get_done: ;\n"
"{\n"
"whenever sqlstate \'*\' goto bad_post_endpoint;\n"
"result (\'00000\', \'Trying to query <\' || service_iri || \'> as SPARQL web service endpoint, POST mode...\');\n"
"DB.DBA.SPARQL_REXEC_TO_ARRAY (service_iri, \'select ?s where { ?s ?p ?o } limit 1\', null, null, null, 1, null, null, vector (\'req_method\', \'POST\'));\n"
"}\n"
"post_is_ok := 1;\n"
"goto post_done;\n"
"bad_post_endpoint:\n"
"if (verbose)\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"post_is_ok := 0;\n"
"post_done: ;\n"
"}\n"
"if (get_is_ok or post_is_ok)\n"
"{\n"
"declare req_method varchar;\n"
"req_method := case when (get_is_ok and post_is_ok) then null when (get_is_ok) then \'GET\' when (post_is_ok) then \'POST\' else null end;\n"
"sparql\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"delete from virtrdf: { `iri(?:service_iri)` virtrdf:bestRequestMethod ?o }\n"
"from virtrdf: where { `iri(?:service_iri)` virtrdf:bestRequestMethod ?o };\n"
"sparql\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"insert in virtrdf: { `iri(?:service_iri)` virtrdf:bestRequestMethod `(?:req_method)` };\n"
"commit work;\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'jso_triples_del (?,?,null)\', vector (service_iri, UNAME\'http://www.openlinksw.com/schemas/virtrdf#bestRequestMethod\'));\n"
"if (req_method is not null)\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'jso_triple_add (?,?,?)\', vector (service_iri, UNAME\'http://www.openlinksw.com/schemas/virtrdf#bestRequestMethod\', req_method));\n"
"}\n"
"else\n"
"signal (\'22023\', \'The service <\' || service_iri || \'> has no description and the site is not responding as a SPARQL endpoint\');\n"
"if (lang_bits = 0)\n"
"{\n"
"declare feats any;\n"
"declare ctr, len integer;\n"
"feats := vector (\n"
"\'prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> select ?s where { quad map virtrdf:DefaultQuadMap { ?s ?p ?o } } limit 1\'	, 0hex0001,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o OPTION (TABLE_OPTION \"ORDER\") } } limit 1\'		, 0hex0002,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o OPTION (BREAKUP) } } limit 1\'		, 0hex0004,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o OPTION (PKSELFJOIN) } } limit 1\'		, 0hex0008,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o OPTION (RVR) } } limit 1\'			, 0hex0010,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o . filter (?o in ( 1, 2, 3)) } } limit 1\'	, 0hex0020,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o . filter (?o like \"%qaz%\") } } limit 1\'	, 0hex0040,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?:oglobal } } limit 1\'				, 0hex0080,\n"
"\'select (str(?s) as ?str) where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o } } group by ?s limit 1\'	, 0hex0100,\n"
"\'define input:storage \"\" select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o } } limit 1\'	, 0hex0200,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> ?o } . service <http://dbpedia.org/sparql> { ?s <no-such-p-qazxswedc> ?t } } limit 1\'		, 0hex0400,\n"
"\'select ?s where { graph <no-such-g-qazxswedc> { ?s <no-such-p-qazxswedc> <no-such-o-qazxswedc> OPTION (TRANSITIVE) } } limit 1\'		, 0hex1000,\n"
"\'select (strdt (group_concat (?o), datatype (max(?o)) as ?gc) where { graph <no-such-g-qazxswedc> { { ?s <no-such-p-qazxswedc> ?o } MINUS { ?s <no-such-p-qazxswedc> <no-such-o-qazxswedc> } } group by ?s having ?o > 1 } limit 1\'		, 0hex2000 );\n"
"len := length (feats);\n"
"for (ctr := 0; ctr < len; ctr := ctr + 2)\n"
"{\n"
"whenever sqlstate \'*\' goto no_such_feat;\n"
"result (\'00000\', sprintf (\'Test query %d/%d: define lang:dialect %d (hex %08x)...\', ctr/2, len/2, feats[ctr+1], feats[ctr+1]));\n"
"DB.DBA.SPARQL_REXEC_TO_ARRAY (service_iri, feats[ctr], null, null, null, 1, null);\n"
"lang_bits := bit_or (lang_bits, feats[ctr+1]);\n"
"result (\'00000\', sprintf (\'Test query %d/%d has found support for define lang:dialect %d (hex %08x)\', ctr/2, len/2, feats[ctr+1], feats[ctr+1]));\n"
"goto probe_done;\n"
"no_such_feat:\n"
"if (verbose)\n"
"result (__SQL_STATE, __SQL_MESSAGE);\n"
"probe_done:;\n"
"}\n"
"result (\'00000\', sprintf (\'The endpoint <\' || service_iri || \'> has support for define lang:dialect %d (hex %08x)\', lang_bits, lang_bits));\n"
"}\n"
"sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"delete from virtrdf: { `iri(?:service_iri)` virtrdf:dialect ?lb } from virtrdf: { `iri(?:service_iri)` virtrdf:dialect ?lb };\n"
"lang_bits_hex := sprintf (\'%08x\', lang_bits);\n"
"sparql define input:storage \"\"\n"
"prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"prefix sd: <http://www.w3.org/ns/sparql-service-description#>\n"
"insert in virtrdf: { `iri(?:service_iri)` virtrdf:dialect ?:lang_bits_hex };\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'jso_triples_del (?,?,null)\', vector (service_iri, UNAME\'http://www.openlinksw.com/schemas/virtrdf#dialect\'));\n"
"DB.DBA.SECURITY_CL_EXEC_AND_LOG (\'jso_triple_add (?,?,?)\', vector (service_iri, UNAME\'http://www.openlinksw.com/schemas/virtrdf#dialect\', lang_bits_hex));\n"
"}\n"
"--src sparql_io.sql:598\n";

static const char *proc417 = 
"#line 862 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SINV_IMP (in ws_endpoint varchar, in ws_params any, in qtext_template varchar, in qtext_posmap nvarchar, in param_row any, in expected_vars any)\n"
"{\n"
"declare RSET, retarray any;\n"
"result_names (RSET);\n"
"\n"
"if (N\'\' <> qtext_posmap)\n"
"{\n"
"declare qtext_ses any;\n"
"declare prev_pos, qctr, qcount integer;\n"
"qtext_ses := string_output ();\n"
"prev_pos := 0;\n"
"qcount := length (qtext_posmap)-1;\n"
"for (qctr := 0; qctr < qcount; qctr := qctr+2)\n"
"{\n"
"declare qpos integer;\n"
"qpos := qtext_posmap[qctr];\n"
"http (subseq (qtext_template, prev_pos, qpos), qtext_ses);\n"
"http_nt_object (param_row[qtext_posmap[qctr+1]-1], qtext_ses);\n"
"prev_pos := qpos+8;\n"
"}\n"
"http (subseq (qtext_template, prev_pos), qtext_ses);\n"
"qtext_template := string_output_string (qtext_ses);\n"
"}\n"
"retarray := DB.DBA.SPARQL_REXEC_TO_ARRAY_OF_OBJ (\n"
"ws_endpoint,\n"
"qtext_template,\n"
"NULL,\n"
"NULL,\n"
"NULL,\n"
"10000000,\n"
"NULL,\n"
"expected_vars );\n"
"foreach (any retrow in retarray) do\n"
"{\n"
"\n"
"result (retrow);\n"
"}\n"
"}\n"
"--src sparql_io.sql:860\n";

static const char *view1 = 
"create procedure view DB.DBA.SPARQL_SINV_2 as DB.DBA.SPARQL_SINV_IMP (ws_endpoint, ws_params, qtext_template, qtext_posmap, param_row, expected_vars)(RSET any)\n";

static const char *proc418 = 
"#line 908 \"[executable]/sparql_io.sql\"\n"
"create procedure \"querySoap\"  (in  \"Command\" varchar\n"
", in  \"Properties\" any\n"
", out \"Error\" any __soap_fault \'__XML__\'\n"
", out \"ws_sparql_xsd\" any\n"
")\n"
"__soap_options ( __soap_type:=\'__ANY__\',\n"
"\"soapAction\":=\'urn:FIXME:querySoap\',\n"
"\"RequestNamespace\":=\'urn:http://www.w3.org/2005/08/sparql-protocol-query/#\',\n"
"\"ResponseNamespace\":=\'urn:http://www.w3.org/2005/08/sparql-protocol-query/#\',\n"
"\"PartName\":=\'return\'\n"
")\n"
"{\n"
"declare stmt, state, msg, mdta, dta, res, ses any;\n"
"stmt := get_keyword (\'Statement\', \"Command\");\n"
"ses := string_output ();\n"
"\n"
"\n"
"res := exec (stmt, state, msg, vector (), 0, mdta, dta);\n"
"\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, mdta);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, mdta, dta);\n"
"\n"
"\n"
"http (\'</sparql>\', ses);\n"
"\n"
"ses := string_output_string (ses);\n"
"string_to_file (\'out.xml\', ses, -2);\n"
"res := xml_tree_doc (ses);\n"
"return res;\n"
"}\n"
"--src sparql_io.sql:906\n";

static const char *proc419 = 
"#line 942 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_WRITE_EXEC_STATUS (inout ses any, in line_format varchar, inout status any)\n"
"{\n"
"declare lctr, lcount integer;\n"
"declare lines any;\n"
"if (status is null)\n"
"return;\n"
"http (sprintf (line_format, \'SQL State\', status[0]), ses);\n"
"lines := split_and_decode (status[1], 0, \'\\0\\0\\n\');\n"
"lcount := length (lines);\n"
"for (lctr := 0; lctr < lcount; lctr := lctr + 1)\n"
"{\n"
"http (sprintf (line_format, case (lctr) when 0 then \'SQL Message\' else \'\' end, lines[lctr]), ses);\n"
"}\n"
"http (sprintf (line_format, \'Exec Time\', cast (status[2] as varchar) || \' ms\'), ses);\n"
"http (sprintf (line_format, \'DB Activity\', cast (status[3] as varchar)), ses);\n"
"}\n"
"--src sparql_io.sql:940\n";

static const char *proc420 = 
"#line 961 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_XML_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"\n"
"http (\'\\n <head>\', ses);\n"
"\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (sprintf (\'\\n  <variable name=\"%s\"/>\', _name), ses);\n"
"i := i + 1;\n"
"}\n"
"\n"
"http (\'\\n </head>\', ses);\n"
"}\n"
"--src sparql_io.sql:959\n";

static const char *proc421 = 
"#line 987 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_XML_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"http (\'\\n <results distinct=\"false\" ordered=\"true\">\', ses);\n"
"\n"
"for (declare ctr integer, ctr := 0; ctr < length (dta); ctr := ctr + 1)\n"
"SPARQL_RESULTS_XML_WRITE_ROW (ses, mdta, dta[ctr]);\n"
"\n"
"http (\'\\n </results>\', ses);\n"
"}\n"
"--src sparql_io.sql:985\n";

static const char *proc422 = 
"#line 998 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_XML_WRITE_ROW (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"\n"
"http (\'\\n  <result>\', ses);\n"
"mdta := mdta[0];\n"
"for (declare x any, x := 0; x < length (mdta); x := x + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := mdta[x][0];\n"
"_val := dta[x];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><bnode>%s</bnode></binding>\', _name, id_to_iri (_val)), ses);\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><uri>\', _name), ses);\n"
"res := charset_recode (res, \'UTF-8\', \'_WIDE_\');\n"
"http_value (res, 0, ses);\n"
"http (\'</uri></binding>\', ses);\n"
"}\n"
"}\n"
"else if (isstring (_val) and (bit_and (1, __box_flags (_val))))\n"
"{\n"
"if (_val like \'nodeID://%\')\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><bnode>%s</bnode></binding>\', _name, _val), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><uri>%V</uri></binding>\', _name, charset_recode (_val, \'UTF-8\', \'_WIDE_\')), ses);\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"declare is_xml_lit int;\n"
"declare sql_val any;\n"
"if (__tag (_val) = 185)\n"
"{\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal>\', _name), ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</literal></binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"if (__tag (_val) = 230)\n"
"{\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal datatype=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral\">\', _name), ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</literal></binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (dt = \'http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral\')\n"
"is_xml_lit := 1;\n"
"else\n"
"is_xml_lit := 0;\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal xml:lang=\"%V\" datatype=\"%V\">\',\n"
"_name, cast (lang as varchar), cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal xml:lang=\"%V\">\',\n"
"_name, cast (lang as varchar)), ses);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal datatype=\"%V\">\',\n"
"_name, cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\'\\n   <binding name=\"%s\"><literal>\',\n"
"_name), ses);\n"
"}\n"
"sql_val := __rdf_sqlval_of_obj (_val, 1);\n"
"if (isentity (sql_val))\n"
"is_xml_lit := 1;\n"
"if (__tag (sql_val) = __tag of varchar)\n"
"sql_val := charset_recode (sql_val, \'UTF-8\', \'_WIDE_\');\n"
"if (is_xml_lit) http (\'<![CDATA[\', ses);\n"
"http_value (__rdf_strsqlval (sql_val), 0, ses);\n"
"if (is_xml_lit) http (\']]>\', ses);\n"
"http (\'</literal></binding>\', ses);\n"
"}\n"
"end_of_binding: ;\n"
"}\n"
"\n"
"http (\'\\n  </result>\', ses);\n"
"}\n"
"--src sparql_io.sql:996\n";

static const char *proc423 = 
"#line 1096 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'<rdf:RDF xmlns:res=\"http://www.w3.org/2005/sparql-results#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n"
"<rdf:Description rdf:nodeID=\"rset\">\n"
"<rdf:type rdf:resource=\"http://www.w3.org/2005/sparql-results#ResultSet\" />\', ses);\n"
"}\n"
"--src sparql_io.sql:1094\n";

static const char *proc424 = 
"#line 1104 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (sprintf (\'\\n    <res:resultVariable>%V</res:resultVariable>\', _name), ses);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:1102\n";

static const char *proc425 = 
"#line 1125 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"for (declare ctr integer, ctr := 0; ctr < length (dta); ctr := ctr + 1)\n"
"{\n"
"http ( sprintf (\'\\n    <res:solution rdf:nodeID=\"r%d\">\', ctr), ses);\n"
"SPARQL_RESULTS_RDFXML_WRITE_ROW (ses, mdta, dta, ctr);\n"
"http (\'\\n    </res:solution>\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:1123\n";

static const char *proc426 = 
"#line 1136 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_ROW (inout ses any, in mdta any, inout dta any, in rowno integer)\n"
"{\n"
"\n"
"mdta := mdta[0];\n"
"for (declare x any, x := 0; x < length (mdta); x := x + 1)\n"
"{\n"
"declare _name varchar;\n"
"declare _val any;\n"
"_name := mdta[x][0];\n"
"_val := dta[rowno][x];\n"
"if (_val is null)\n"
"goto end_of_binding;\n"
"http (sprintf (\'\\n      <res:binding rdf:nodeID=\"r%dc%d\"><res:variable>%V</res:variable><res:value\', rowno, x, _name), ses);\n"
"if (isiri_id (_val))\n"
"{\n"
"if (_val >= min_bnode_iri_id ())\n"
"{\n"
"http (sprintf (\' rdf:nodeID=\"b%s\"/></res:binding>\', id_to_iri (_val)), ses);\n"
"}\n"
"else\n"
"{\n"
"declare res varchar;\n"
"res := id_to_iri (_val);\n"
"\n"
"if (res is null)\n"
"res := sprintf (\'bad://%d\', iri_id_num (_val));\n"
"http (sprintf (\' rdf:resource=\"%V\"/></res:binding>\', charset_recode (res, \'UTF-8\', \'_WIDE_\')), ses);\n"
"}\n"
"}\n"
"else if (isstring (_val) and (1 = __box_flags (_val)))\n"
"{\n"
"if (_val like \'nodeID://%\')\n"
"http (sprintf (\' rdf:nodeID=\"b%s\"/></res:binding>\', subseq(_val, 9)), ses);\n"
"else\n"
"http (sprintf (\' rdf:resource=\"%V\"/></res:binding>\', charset_recode (_val, \'UTF-8\', \'_WIDE_\')), ses);\n"
"}\n"
"else\n"
"{\n"
"declare lang, dt varchar;\n"
"declare val_tag integer;\n"
"val_tag := __tag (_val);\n"
"if (val_tag = 185)\n"
"{\n"
"http (\'>\', ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</res:value></res:binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"if (val_tag = 230)\n"
"{\n"
"http (\' rdf:parseType=\"Literal\">\', ses);\n"
"http_value (_val, 0, ses);\n"
"http (\'</res:value></res:binding>\', ses);\n"
"goto end_of_binding;\n"
"}\n"
"lang := DB.DBA.RDF_LANGUAGE_OF_LONG (_val, null);\n"
"dt := DB.DBA.RDF_DATATYPE_IRI_OF_LONG (_val, null);\n"
"if (lang is not null)\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' xml:lang=\"%V\" datatype=\"%V\">\', cast (lang as varchar), cast (dt as varchar)), ses);\n"
"else\n"
"http (sprintf (\' xml:lang=\"%V\">\', cast (lang as varchar)), ses);\n"
"}\n"
"else\n"
"{\n"
"if (dt is not null)\n"
"http (sprintf (\' datatype=\"%V\">\', cast (dt as varchar)), ses);\n"
"else\n"
"http (\'>\', ses);\n"
"}\n"
"if (__tag of datetime = rdf_box_data_tag (_val))\n"
"__rdf_long_to_ttl (_val, ses);\n"
"else\n"
"{\n"
"_val := __rdf_sqlval_of_obj (_val, 1);\n"
"if (__tag (_val) = __tag of varchar)\n"
"_val := charset_recode (_val, \'UTF-8\', \'_WIDE_\');\n"
"http_value (__rdf_strsqlval (_val), 0, ses);\n"
"}\n"
"http (\'</res:value></res:binding>\', ses);\n"
"}\n"
"end_of_binding: ;\n"
"}\n"
"}\n"
"--src sparql_io.sql:1134\n";

static const char *proc427 = 
"#line 1223 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_TTL_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'@prefix res: <http://www.w3.org/2005/sparql-results#> .\n"
"@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n"
"_:_ a res:ResultSet .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:1221\n";

static const char *proc428 = 
"#line 1231 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_TTL_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"if (0 = col_count)\n"
"return;\n"
"http (\'_:_ res:resultVariable \"\', ses);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http_escape (_name, 11, ses, 0, 1);\n"
"i := i + 1;\n"
"if (i < col_count)\n"
"http (\'\" , \"\', ses);\n"
"}\n"
"http (\'\" .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:1229\n";

static const char *proc429 = 
"#line 1258 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_TTL_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"declare colctr, colcount, rowctr, len, fake_agg_ctx integer;\n"
"declare cols, colbuf, env any;\n"
"cols := mdta[0];\n"
"colcount := length (cols);\n"
"colbuf := make_array (colcount * 7, \'any\');\n"
"len := length (dta);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"colbuf [colctr * 7] := cols[colctr][0];\n"
"}\n"
"env := vector (dict_new (__min (len * 3, 16000)), 0, \'\', \'\', \'\', 0, 0, colbuf, ses);\n"
"rowctr := 0;\n"
"while (rowctr < len)\n"
"{\n"
"declare r any;\n"
"r := aref_set_0 (dta, rowctr);\n"
"sparql_rset_ttl_write_row (fake_agg_ctx, env, r);\n"
"aset_zap_arg (dta, rowctr, r);\n"
"rowctr := rowctr + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:1256\n";

static const char *proc430 = 
"#line 1283 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_NT_WRITE_NS (inout ses any)\n"
"{\n"
"http (\'_:ResultSet2053 rdf:type <http://www.w3.org/1999/02/22-rdf-syntax-ns#res:ResultSet> .\\n\', ses);\n"
"}\n"
"--src sparql_io.sql:1281\n";

static const char *proc431 = 
"#line 1289 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_NT_WRITE_HEAD (inout ses any, in mdta any)\n"
"{\n"
"declare i, col_count integer;\n"
"mdta := mdta[0];\n"
"i := 0; col_count := length (mdta);\n"
"while (i < col_count)\n"
"{\n"
"declare _name varchar;\n"
"declare _type, _type_name, nill int;\n"
"_name := mdta[i][0];\n"
"_type := mdta[i][1];\n"
"if (length (mdta[i]) > 4)\n"
"nill := mdta[i][4];\n"
"else\n"
"nill := 0;\n"
"http (\'_:ResultSet2053 <http://www.w3.org/2005/sparql-results#resultVariable> \"\', ses);\n"
"http_escape (_name, 11, ses, 0, 1);\n"
"http (\'\" .\\n\', ses);\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:1287\n";

static const char *proc432 = 
"#line 1312 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_NT_WRITE_RES (inout ses any, in mdta any, inout dta any)\n"
"{\n"
"declare colctr, colcount, rowctr, len, fake_agg_ctx integer;\n"
"declare cols, colbuf, env any;\n"
"cols := mdta[0];\n"
"colcount := length (cols);\n"
"colbuf := make_array (colcount * 7, \'any\');\n"
"len := length (dta);\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"colbuf [colctr * 7] := cols[colctr][0];\n"
"}\n"
"env := vector (0, colbuf, ses);\n"
"rowctr := 0;\n"
"while (rowctr < len)\n"
"{\n"
"declare r any;\n"
"r := aref_set_0 (dta, rowctr);\n"
"sparql_rset_nt_write_row (fake_agg_ctx, env, r);\n"
"aset_zap_arg (dta, rowctr, r);\n"
"rowctr := rowctr + 1;\n"
"}\n"
"}\n"
"--src sparql_io.sql:1310\n";

static const char *proc433 = 
"#line 1337 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE (inout ses any, inout metas any, inout rset any, in is_js integer := 0, in esc_mode integer := 1, in pure_html integer := 0)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"declare trnewline, newline varchar;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"if (esc_mode = 13)\n"
"{\n"
"newline := \'\';\n"
"trnewline := \'\'\');\\ndocument.writeln(\'\'\';\n"
"}\n"
"else\n"
"newline := trnewline := \'\\n\';\n"
"if (is_js)\n"
"{\n"
"http (\'document.writeln(\'\'\', ses);\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses,metas,rset,0,13);\n"
"http (\'\'\');\', ses);\n"
"return;\n"
"}\n"
"http (\'<table class=\"sparql\" border=\"1\">\', ses);\n"
"http (trnewline || \'  <tr>\', ses);\n"
"\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"http(newline || \'    <th>\', ses);\n"
"http_escape (metas[0][varctr][0], esc_mode, ses, 0, 1);\n"
"http(\'</th>\', ses);\n"
"}\n"
"http (newline || \'  </tr>\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"http(trnewline || \'  <tr>\', ses);\n"
"\n"
"\n"
"\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (val is null)\n"
"{\n"
"http(newline || \'    <td></td>\', ses);\n"
"goto end_of_val_print;\n"
"}\n"
"http(newline || \'    <td>\', ses);\n"
"if (isiri_id (val))\n"
"{\n"
"if (is_js or is_bnode_iri_id (val))\n"
"http_escape (id_to_iri (val), esc_mode, ses, 1, 1);\n"
"else\n"
"{\n"
"http (\'<a href=\"\', ses);\n"
"http_escape (id_to_iri (val), 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"http_escape (id_to_iri (val), esc_mode, ses, 1, 1);\n"
"http (\'</a>\', ses);\n"
"}\n"
"}\n"
"else if (isstring (val) and (1 = __box_flags (val)))\n"
"{\n"
"if (is_js or val=\'\' or (val[0]=95) or (val like \'nodeID://%\'))\n"
"http_escape (val, esc_mode, ses, 1, 1);\n"
"else\n"
"{\n"
"http (\'<a href=\"\', ses);\n"
"http_escape (val, 3, ses, 1, 1);\n"
"http (\'\">\', ses);\n"
"http_escape (val, esc_mode, ses, 1, 1);\n"
"http (\'</a>\', ses);\n"
"}\n"
"}\n"
"else if (__tag of varchar = __tag (val))\n"
"{\n"
"http_escape (val, esc_mode, ses, 1, 1);\n"
"}\n"
"else if (185 = __tag (val))\n"
"{\n"
"http_escape (cast (val as varchar), esc_mode, ses, 1, 1);\n"
"}\n"
"else if (__tag of XML = rdf_box_data_tag (val))\n"
"{\n"
"\n"
"\n"
"declare tmpses any;\n"
"tmpses := string_output();\n"
"http_value (val, 0, tmpses);\n"
"http_escape (cast (tmpses as varchar), esc_mode, ses, 1, 1);\n"
"\n"
"\n"
"\n"
"}\n"
"else if (pure_html and __tag of rdf_box = __tag (val))\n"
"http_rdf_object (val, ses, 1);\n"
"else\n"
"{\n"
"http_escape (__rdf_strsqlval (val), esc_mode, ses, 1, 1);\n"
"}\n"
"http (\'</td>\', ses);\n"
"end_of_val_print: ;\n"
"}\n"
"http(newline || \'  </tr>\', ses);\n"
"}\n"
"http (trnewline || \'</table>\', ses);\n"
"}\n"
"--src sparql_io.sql:1335\n";

static const char *proc434 = 
"#line 1444 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_JSON_WRITE_BINDING (inout ses any, in colname varchar, inout val any)\n"
"{\n"
"http(\' \"\', ses);\n"
"http_escape (colname, 11, ses, 0, 1);\n"
"http(\'\": { \', ses);\n"
"if (isiri_id (val))\n"
"{\n"
"if (val > min_bnode_iri_id ())\n"
"http (sprintf (\'\"type\": \"bnode\", \"value\": \"%s\', id_to_iri (val)), ses);\n"
"else\n"
"{\n"
"http (\'\"type\": \"uri\", \"value\": \"\', ses);\n"
"http_escape (id_to_iri (val), 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else if (__tag of rdf_box = __tag (val))\n"
"{\n"
"declare res varchar;\n"
"declare dat, typ any;\n"
"dat := __rdf_sqlval_of_obj (val, 1);\n"
"typ := rdf_box_type (val);\n"
"if (not isstring (dat))\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"if (257 <> typ)\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = typ));\n"
"else\n"
"res := cast (__xsd_type (dat) as varchar);\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"dat := __rdf_strsqlval (dat);\n"
"}\n"
"else if (257 <> typ)\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"res := coalesce ((select RDT_QNAME from DB.DBA.RDF_DATATYPE where RDT_TWOBYTE = typ));\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"}\n"
"else if (257 <> rdf_box_lang (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"xml:lang\": \"\', ses);\n"
"res := coalesce ((select lower (RL_ID) from DB.DBA.RDF_LANGUAGE where RL_TWOBYTE = rdf_box_lang (val)));\n"
"http_escape (res, 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"}\n"
"else\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (dat, 11, ses, 1, 1);\n"
"}\n"
"else if (__tag of varchar = __tag (val))\n"
"{\n"
"if (1 = __box_flags (val))\n"
"{\n"
"if (val like \'nodeID://%\')\n"
"http (sprintf (\'\"type\": \"bnode\", \"value\": \"%s\', val), ses);\n"
"else\n"
"{\n"
"http (\'\"type\": \"uri\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 1, 1);\n"
"}\n"
"}\n"
"else if (__tag of varbinary = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (val, 11, ses, 0, 0);\n"
"}\n"
"else if (185 = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (cast (val as varchar), 11, ses, 1, 1);\n"
"}\n"
"else if (230 = __tag (val))\n"
"{\n"
"http (\'\"type\": \"literal\", \"value\": \"\', ses);\n"
"http_escape (serialize_to_UTF8_xml (val), 11, ses, 1, 1);\n"
"}\n"
"else\n"
"{\n"
"http (\'\"type\": \"typed-literal\", \"datatype\": \"\', ses);\n"
"http_escape (cast (__xsd_type (val) as varchar), 11, ses, 1, 1);\n"
"http (\'\", \"value\": \"\', ses);\n"
"http_escape (__rdf_strsqlval (val), 11, ses, 1, 1);\n"
"}\n"
"http (\'\" }\', ses);\n"
"}\n"
"--src sparql_io.sql:1442\n";

static const char *proc435 = 
"#line 1538 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_JSON_WRITE (inout ses any, inout metas any, inout rset any)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"http (\'\\n{ \"head\": { \"link\": [], \"vars\": [\', ses);\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"if (varctr > 0)\n"
"http(\', \"\', ses);\n"
"else\n"
"http(\'\"\', ses);\n"
"http_escape (metas[0][varctr][0], 11, ses, 0, 1);\n"
"http(\'\"\', ses);\n"
"}\n"
"http (\'] },\\n  \"results\": { \"distinct\": false, \"ordered\": true, \"bindings\": [\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"declare need_comma integer;\n"
"if (resctr > 0)\n"
"http(\',\\n    {\', ses);\n"
"else\n"
"http(\'\\n    {\', ses);\n"
"need_comma := 0;\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (val is null)\n"
"goto end_of_val_print;\n"
"if (need_comma)\n"
"http(\'\\t,\', ses);\n"
"else\n"
"need_comma := 1;\n"
"SPARQL_RESULTS_JSON_WRITE_BINDING (ses, metas[0][varctr][0], val);\n"
"end_of_val_print: ;\n"
"}\n"
"http(\'}\', ses);\n"
"}\n"
"http (\' ] } }\', ses);\n"
"}\n"
"--src sparql_io.sql:1536\n";

static const char *proc436 = 
"#line 1581 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_CSV_WRITE (inout ses any, inout metas any, inout rset any)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"if (varctr > 0)\n"
"http(\',\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, metas[0][varctr][0]);\n"
"}\n"
"http (\'\\n\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (varctr > 0)\n"
"http(\',\', ses);\n"
"if (val is not null)\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, val);\n"
"}\n"
"http(\'\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:1579\n";

static const char *proc437 = 
"#line 1609 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_RESULTS_TSV_WRITE (inout ses any, inout metas any, inout rset any)\n"
"{\n"
"declare varctr, varcount, resctr, rescount integer;\n"
"varcount := length (metas[0]);\n"
"rescount := length (rset);\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"if (varctr > 0)\n"
"http(\'\\t\', ses);\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, metas[0][varctr][0]);\n"
"}\n"
"http (\'\\n\', ses);\n"
"for (resctr := 0; resctr < rescount; resctr := resctr + 1)\n"
"{\n"
"for (varctr := 0; varctr < varcount; varctr := varctr + 1)\n"
"{\n"
"declare val any;\n"
"val := rset[resctr][varctr];\n"
"if (varctr > 0)\n"
"http(\'\\t\', ses);\n"
"if (val is not null)\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE (ses, val);\n"
"}\n"
"http(\'\\n\', ses);\n"
"}\n"
"}\n"
"--src sparql_io.sql:1607\n";

static const char *proc438 = 
"#line 1638 \"[executable]/sparql_io.sql\"\n"
"create function DB.DBA.SPARQL_RESULTS_WRITE (inout ses any, inout metas any, inout rset any, in accept varchar, in add_http_headers integer, in status any := null) returns varchar\n"
"{\n"
"declare singlefield varchar;\n"
"declare ret_mime, ret_format varchar;\n"
"if (status is not null)\n"
"{\n"
"http_header (concat (coalesce (http_header_get (), \'\'),\n"
"\'X-SQL-State: \', status[0], \'\\r\\nX-SQL-Message: \', status[1],\n"
"\'\\r\\nX-Exec-Milliseconds: \', cast (status[2] as varchar), \'\\r\\nX-Exec-DB-Activity: \', cast (status[3] as varchar),\n"
"\'\\r\\n\' ) );\n"
"}\n"
"if ((1 >= length (rset)) and (1 = length (metas[0])))\n"
"singlefield := metas[0][0][0];\n"
"else\n"
"singlefield := NULL;\n"
"\n"
"if (\'__ask_retval\' = singlefield)\n"
"{\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 0, ret_format);\n"
"if (ret_format in (\'JSON\', \'JSON;RES\'))\n"
"{\n"
"http (\n"
"concat (\n"
"\'{  \"head\": { \"link\": [] }, \"boolean\": \',\n"
"case (length (rset)) when 0 then \'false\' else \'true\' end,\n"
"\'}\'),\n"
"ses );\n"
"}\n"
"else if (ret_format = \'XML\')\n"
"{\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"http (\n"
"concat (\n"
"\'\\n <head></head>\\n <boolean>\',\n"
"case (length (rset)) when 0 then \'false\' else \'true\' end,\n"
"\'</boolean>\\n</sparql>\'),\n"
"ses );\n"
"}\n"
"else if (ret_format = \'TTL\')\n"
"{\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n@prefix rs: <http://www.w3.org/2005/sparql-results#> .\\n\', ses);\n"
"http (sprintf (\'[] rdf:type rs:results ; rs:boolean %s .\', case (length (rset)) when 0 then \'false\' else \'true\' end), ses);\n"
"}\n"
"else if (ret_format = \'CSV\' or ret_format = \'TSV\')\n"
"{\n"
"http (sprintf (\'\"bool\"\\n%d\\n\', case (length (rset)) when 0 then 0 else 1 end), ses);\n"
"}\n"
"else\n"
"{\n"
"ret_mime := \'text/html\';\n"
"http (case (length (rset)) when 0 then \'false\' else \'true\' end, ses);\n"
"}\n"
"goto body_complete;\n"
"}\n"
"if ((1 = length (rset)) and\n"
"(1 = length (rset[0])) and\n"
"(214 = __tag (rset[0][0])) )\n"
"{\n"
"declare triples any;\n"
"triples := dict_list_keys (rset[0][0], 1);\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 1, ret_format);\n"
"if ((ret_format is null) or (ret_format = \'TTL\'))\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/turtle\';\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, ses);\n"
"if (status is not null)\n"
"SPARQL_WRITE_EXEC_STATUS (ses, \'#%015s: %s\\n\', status);\n"
"}\n"
"else if (ret_format = \'TRIG\')\n"
"DB.DBA.RDF_TRIPLES_TO_TRIG (triples, ses);\n"
"else if (ret_format = \'NT\')\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, ses);\n"
"else if (ret_format in (\'JSON\', \'JSON;TALIS\'))\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, ses);\n"
"else if (ret_format = \'JSON;LD\')\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_LD (triples, ses);\n"
"else if (ret_format = \'JSON;RES\')\n"
"DB.DBA.RDF_TRIPLES_TO_JSON (triples, ses);\n"
"else if (ret_format = \'RDFA;XHTML\')\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, ses);\n"
"else if (ret_format = \'HTML;UL\')\n"
"{\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_UL (triples, ses);\n"
"ret_mime := \'text/html\';\n"
"}\n"
"else if (ret_format = \'HTML;TR\')\n"
"{\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_TR (triples, ses);\n"
"ret_mime := \'text/html\';\n"
"}\n"
"else if (ret_format = \'HTML;MICRODATA\')\n"
"{\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA (triples, ses);\n"
"ret_mime := \'text/html\';\n"
"}\n"
"else if (ret_format = \'JSON;MICRODATA\')\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA (triples, ses);\n"
"else if (ret_format = \'ATOM;XML\')\n"
"DB.DBA.RDF_TRIPLES_TO_ATOM_XML_TEXT (triples, 1, ses);\n"
"else if (ret_format = \'JSON;ODATA\')\n"
"DB.DBA.RDF_TRIPLES_TO_ODATA_JSON (triples, ses);\n"
"else if (ret_format = \'CXML\')\n"
"DB.DBA.RDF_TRIPLES_TO_CXML (triples, ses, accept, add_http_headers, 0, status);\n"
"else if (ret_format = \'CXML;QRCODE\')\n"
"DB.DBA.RDF_TRIPLES_TO_CXML (triples, ses, accept, add_http_headers, 1, status);\n"
"else if (ret_format = \'CSV\')\n"
"DB.DBA.RDF_TRIPLES_TO_CSV (triples, ses);\n"
"else if (ret_format = \'TSV\')\n"
"DB.DBA.RDF_TRIPLES_TO_TSV (triples, ses);\n"
"else if (ret_format = \'NICE_TTL\')\n"
"{\n"
"DB.DBA.RDF_TRIPLES_TO_NICE_TTL (triples, ses);\n"
"ret_mime := \'text/turtle\';\n"
"}\n"
"else if (ret_format = \'SOAP\')\n"
"{\n"
"declare soap_ns, spt_ns varchar;\n"
"declare soap_ver int;\n"
"\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"soap_ver := 11;\n"
"else\n"
"soap_ver := 12;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"if (soap_ver = 12)\n"
"ret_mime := \'application/soap+xml\';\n"
"else\n"
"ret_mime := \'text/xml\';\n"
"http (\'<soapenv:Envelope xmlns:soapenv=\"\'||soap_ns||\'\"><soapenv:Body><query-result xmlns=\"\'||spt_ns||\'\">\', ses);\n"
"http (\'<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" \'||\n"
"\'xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">\', ses);\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 0, ses);\n"
"http (\'</rdf:RDF>\', ses);\n"
"http (\'</query-result></soapenv:Body></soapenv:Envelope>\', ses);\n"
"}\n"
"else\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, ses);\n"
"}\n"
"goto body_complete;\n"
"}\n"
"ret_mime := http_sys_find_best_sparql_accept (accept, 0, ret_format);\n"
"if (ret_format in (\'JSON\', \'JSON;RES\'))\n"
"{\n"
"if ((singlefield like \'fmtaggret-HTTP+RDF/XML%\') or (singlefield like \'fmtaggret-HTTP+TURTLE-0%\') or (singlefield like \'fmtaggret-HTTP+TTL-0%\'))\n"
"{\n"
"http(\'\"\', ses);\n"
"http_escape (cast (rset[0][0] as varchar), 11, ses, 1, 1);\n"
"http(\'\"\', ses);\n"
"}\n"
"else\n"
"SPARQL_RESULTS_JSON_WRITE (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if ((singlefield like \'fmtaggret-HTTP+RDF/XML%\') and (\'auto\' = accept))\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"http (rset[0][0], ses);\n"
"goto body_complete;\n"
"}\n"
"if ((singlefield like \'fmtaggret-HTTP+TURTLE%\') or (singlefield like \'fmtaggret-HTTP+TTL%\'))\n"
"{\n"
"if ((ret_format = \'TTL\') or (ret_format is null))\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/turtle\';\n"
"}\n"
"http (rset[0][0], ses);\n"
"if (status is not null)\n"
"SPARQL_WRITE_EXEC_STATUS (ses, \'#%015s: %s\\n\', status);\n"
"goto body_complete;\n"
"}\n"
"if (singlefield like \'fmtaggret-%\')\n"
"{\n"
"declare ws_pos integer;\n"
"ws_pos := strchr (singlefield, \' \');\n"
"if (ws_pos is not null)\n"
"ret_mime := subseq (singlefield, ws_pos + 1);\n"
"\n"
"\n"
"http (rset[0][0], ses);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'HTML\')\n"
"{\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses, metas, rset, 0, 1, case when ret_mime = \'text/html\' then 1 else 0 end);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'JS\')\n"
"{\n"
"SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE(ses, metas, rset, 1);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'SOAP\')\n"
"{\n"
"declare soap_ns, spt_ns varchar;\n"
"declare soap_ver int;\n"
"\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"soap_ver := 11;\n"
"else\n"
"soap_ver := 12;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"if (soap_ver = 12)\n"
"ret_mime := \'application/soap+xml\';\n"
"else\n"
"ret_mime := \'text/xml\';\n"
"http (\'<soapenv:Envelope xmlns:soapenv=\"\'||soap_ns||\'\"><soapenv:Body><query-result xmlns=\"\'||spt_ns||\'\">\', ses);\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n</sparql>\', ses);\n"
"http (\'</query-result></soapenv:Body></soapenv:Envelope>\', ses);\n"
"goto body_complete;\n"
"}\n"
"if ((ret_format = \'TTL\') or (ret_format = \'NICE_TTL\'))\n"
"{\n"
"if (ret_format is null)\n"
"ret_mime := \'text/turtle\';\n"
"SPARQL_RESULTS_TTL_WRITE_NS (ses);\n"
"SPARQL_RESULTS_TTL_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_TTL_WRITE_RES (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'NT\')\n"
"{\n"
"SPARQL_RESULTS_NT_WRITE_NS (ses);\n"
"SPARQL_RESULTS_NT_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_NT_WRITE_RES (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'RDFXML\')\n"
"{\n"
"ret_mime := \'application/rdf+xml\';\n"
"SPARQL_RESULTS_RDFXML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_RDFXML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_RDFXML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n  </rdf:Description>\', ses);\n"
"http (\'\\n</rdf:RDF>\', ses);\n"
"goto body_complete;\n"
"}\n"
"if ((ret_format = \'CXML\') or (ret_format = \'CXML;QRCODE\'))\n"
"{\n"
"DB.DBA.SPARQL_RESULTS_CXML_WRITE(ses, metas, rset, accept, add_http_headers, status);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'CSV\')\n"
"{\n"
"ret_mime := \'text/csv\';\n"
"DB.DBA.SPARQL_RESULTS_CSV_WRITE (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"if (ret_format = \'TSV\')\n"
"{\n"
"ret_mime := \'text/tab-separated-values\';\n"
"DB.DBA.SPARQL_RESULTS_TSV_WRITE (ses, metas, rset);\n"
"goto body_complete;\n"
"}\n"
"ret_mime := \'application/sparql-results+xml\';\n"
"SPARQL_RSET_XML_WRITE_NS (ses);\n"
"SPARQL_RESULTS_XML_WRITE_HEAD (ses, metas);\n"
"SPARQL_RESULTS_XML_WRITE_RES (ses, metas, rset);\n"
"http (\'\\n</sparql>\', ses);\n"
"\n"
"body_complete:\n"
"if (add_http_headers and strcasestr (http_header_get (), \'Content-Type:\') is null)\n"
"http_header (coalesce (http_header_get (), \'\') || \'Content-Type: \' || ret_mime || case when strstr (ret_mime, \'json\') is null then \'; charset=UTF-8\' else \'\' end || \'\\r\\n\');\n"
"return ret_mime;\n"
"}\n"
"--src sparql_io.sql:1636\n";

static const char *proc439 = 
"#line 1916 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_SVC_DESC ()\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http (\'    <div xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\\n\', ses);\n"
"http (\'         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\\n\', ses);\n"
"http (\'         xmlns=\"http://www.w3.org/1999/xhtml\"\\n\', ses);\n"
"http (\'         xmlns:sd=\"http://www.w3.org/ns/sparql-service-description#\"\\n\', ses);\n"
"http (\'         xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\\n\', ses);\n"
"http (\'         style=\"display:none\">\\n\', ses);\n"
"http (\'       <div class=\"description\" about=\"\" typeof=\"sd:Service\">\\n\', ses);\n"
"http (sprintf (\'          <div rel=\"sd:endpoint\" resource=\"http://%{WSHost}s/sparql\"/>\\n\', ses), ses);\n"
"http (\'          <div rel=\"sd:feature\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/sparql-service-description#UnionDefaultGraph\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:feature\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/sparql-service-description#DereferencesURIs\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\" resource=\"http://www.w3.org/ns/formats/RDF_XML\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\" resource=\"http://www.w3.org/ns/formats/Turtle\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/formats/SPARQL_Results_CSV\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\" resource=\"http://www.w3.org/ns/formats/N-Triples\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\" resource=\"http://www.w3.org/ns/formats/N3\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/formats/SPARQL_Results_JSON\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\" resource=\"http://www.w3.org/ns/formats/RDFa\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:resultFormat\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/formats/SPARQL_Results_XML\"/>\\n\', ses);\n"
"http (\'          <div rel=\"sd:supportedLanguage\"\\n\', ses);\n"
"http (\'               resource=\"http://www.w3.org/ns/sparql-service-description#SPARQL10Query\"/>\\n\', ses);\n"
"http (sprintf (\'          <div rel=\"sd:url\" resource=\"http://%{WSHost}s/sparql\"/>\\n\', ses), ses);\n"
"http (\'       </div>\\n\', ses);\n"
"http (\'    </div>\\n\', ses);\n"
"return ses;\n"
"}\n"
"--src sparql_io.sql:1914\n";

static const char *proc440 = 
"#line 1953 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_VHOST_RESET ()\n"
"{\n"
"declare gr varchar;\n"
"declare oopts any;\n"
"oopts := null;\n"
"if (not exists (select 1 from \"DB\".\"DBA\".\"SYS_USERS\" where U_NAME = \'SPARQL\'))\n"
"{\n"
"DB.DBA.USER_CREATE (\'SPARQL\', uuid(), vector (\'DISABLED\', 1, \'LOGIN_QUALIFIER\', \'SPARQL\'));\n"
"DB.DBA.EXEC_STMT (\'grant SPARQL_SELECT to \"SPARQL\"\', 0);\n"
"}\n"
"if (registry_get (\'__SPARQL_VHOST_RESET\') >= \'20120519\')\n"
"return;\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/SPARQL\');\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/services/sparql-query\');\n"
"oopts := (select deserialize (HP_OPTIONS) from HTTP_PATH\n"
"where HP_PPATH = \'/!sparql/\' and HP_LPATH = \'/sparql\' and HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\');\n"
"if (oopts is null) oopts := vector (\'noinherit\', 1);\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql/\', ppath => \'/!sparql/\', is_dav => 1, vsp_user => \'dba\', opts => oopts);\n"
"oopts := (select deserialize (HP_OPTIONS) from HTTP_PATH\n"
"where HP_PPATH = \'/!sparql-graph-crud/\' and HP_LPATH = \'/sparql-graph-crud\' and HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\');\n"
"if (oopts is null) oopts := vector (\'noinherit\', 1, \'exec_as_get\', 1);\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql-graph-crud\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql-graph-crud/\', ppath => \'/!sparql-graph-crud/\', is_dav => 1, vsp_user => \'dba\', opts => oopts);\n"
"oopts := (select deserialize (HP_OPTIONS) from HTTP_PATH\n"
"where HP_PPATH = \'/!sparql/\' and HP_LPATH = \'/sparql-auth\' and HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\');\n"
"if (oopts is null) oopts := vector (\'noinherit\', 1);\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql-auth\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql-auth\',\n"
"ppath => \'/!sparql/\',\n"
"is_dav => 1,\n"
"vsp_user => \'dba\',\n"
"opts => oopts,\n"
"auth_fn=>\'DB.DBA.HP_AUTH_SPARQL_USER\',\n"
"realm=>\'SPARQL\',\n"
"sec=>\'digest\');\n"
"oopts := (select deserialize (HP_OPTIONS) from HTTP_PATH\n"
"where HP_PPATH = \'/!sparql-graph-crud/\' and HP_LPATH = \'/sparql-graph-crud-auth\' and HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\');\n"
"if (oopts is null) oopts := vector (\'noinherit\', 1, \'exec_as_get\', 1);\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql-graph-crud-auth\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql-graph-crud-auth\',\n"
"ppath => \'/!sparql-graph-crud/\',\n"
"is_dav => 1,\n"
"vsp_user => \'dba\',\n"
"opts => oopts,\n"
"auth_fn=>\'DB.DBA.HP_AUTH_SPARQL_USER\',\n"
"realm=>\'SPARQL\',\n"
"sec=>\'digest\');\n"
"\n"
"\n"
"\n"
"DB.DBA.VHOST_REMOVE (lpath=>\'/sparql-sd\');\n"
"DB.DBA.VHOST_DEFINE (lpath=>\'/sparql-sd/\', ppath => \'/!sparql-sd/\', is_dav => 1, vsp_user => \'dba\', opts => vector(\'noinherit\', 1));\n"
"gr := concat (\'http://\', registry_get (\'URIQADefaultHost\'), \'/sparql\');\n"
"DB.DBA.RDF_LOAD_RDFA (WS.WS.SPARQL_ENDPOINT_SVC_DESC (), gr, gr);\n"
"registry_set (\'__SPARQL_VHOST_RESET\', \'20120519\');\n"
"}\n"
"--src sparql_io.sql:1951\n";

static const char *proc441 = 
"#line 2015 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (\n"
"inout path varchar, inout params any, inout lines any,\n"
"in httpcode varchar, in httpstatus varchar,\n"
"in query varchar, in state varchar, in msg varchar, in accept varchar := null)\n"
"{\n"
"\n"
"\n"
"if (httpstatus is null)\n"
"{\n"
"declare errtitle varchar;\n"
"declare delim varchar;\n"
"delim := strchr (msg, \'\\n\');\n"
"if (delim is null)\n"
"errtitle := msg;\n"
"else\n"
"errtitle := subseq (msg, 0, delim);\n"
"httpstatus := sprintf (\'Error %s %s\', state, errtitle);\n"
"}\n"
"if (accept is not null and strstr (accept, \'application/soap+xml\') is not null)\n"
"{\n"
"declare err_str any;\n"
"declare soap_ver int;\n"
"if (strstr (accept, \'application/soap+xml;11\') is not null)\n"
"{\n"
"soap_ver := 11;\n"
"http_header (\'Content-Type: text/xml; charset=UTF-8\\r\\n\');\n"
"}\n"
"else\n"
"{\n"
"soap_ver := 12;\n"
"http_header (\'Content-Type: application/soap+xml; charset=UTF-8\\r\\n\');\n"
"}\n"
"http_request_status (sprintf (\'HTTP/1.1 500 %s\', httpstatus));\n"
"err_str := soap_make_error (\'320\', state, msg, soap_ver);\n"
"http (err_str);\n"
"return;\n"
"}\n"
"http_request_status (sprintf (\'HTTP/1.1 %s %s\', httpcode, httpstatus));\n"
"http_header (\'Content-Type: text/plain\\r\\n\');\n"
"http (concat (\'Virtuoso \', state, \' Error \', msg));\n"
"if (query is not null)\n"
"{\n"
"http (\'\\n\\nSPARQL query:\\n\');\n"
"http (query);\n"
"}\n"
"}\n"
"--src sparql_io.sql:2013\n";

static const char *proc442 = 
"#line 2063 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_WSDL11 (in lines any)\n"
"{\n"
"declare host any;\n"
"host := http_request_header (lines, \'Host\', null, null);\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\"\n"
"xmlns:tns=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"targetNamespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\">\n"
"<import namespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"location=\"http://www.w3.org/TR/sprot11/sparql-protocol-query-11.wsdl\"/>\n"
"<service name=\"SparqlService\">\n"
"<port name=\"SparqlServicePort\" binding=\"tns:QuerySoapBinding\">\n"
"<address location=\"http://%s/sparql\"/>\n"
"</port>\n"
"</service>\n"
"</definitions>\', host));\n"
"}\n"
"--src sparql_io.sql:2061\n";

static const char *proc443 = 
"#line 2082 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_WSDL (in lines any)\n"
"{\n"
"declare host any;\n"
"host := http_request_header (lines, \'Host\', null, null);\n"
"http (sprintf (\'<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
"<description xmlns=\"http://www.w3.org/2006/01/wsdl\"\n"
"xmlns:tns=\"http://www.w3.org/2005/08/sparql-protocol-query/#\"\n"
"targetNamespace=\"http://www.w3.org/2005/08/sparql-protocol-query/#\">\n"
"<include location=\"http://www.w3.org/TR/rdf-sparql-protocol/sparql-protocol-query.wsdl\" />\n"
"<service name=\"SparqlService\" interface=\"tns:SparqlQuery\">\n"
"<endpoint name=\"SparqlEndpoint\" binding=\"tns:querySoap\" address=\"http://%s/sparql\"/>\n"
"</service>\n"
"</description>\', host));\n"
"}\n"
"--src sparql_io.sql:2080\n";

static const char *proc444 = 
"#line 2098 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SOAP_NS (in ver int)\n"
"{\n"
"if (ver = 11)\n"
"return \'http://schemas.xmlsoap.org/soap/envelope/\';\n"
"else if (ver = 12)\n"
"return \'http://www.w3.org/2003/05/soap-envelope\';\n"
"else\n"
"signal (\'42000\', \'Un-supported SOAP version\');\n"
"}\n"
"--src sparql_io.sql:2096\n";

static const char *proc445 = 
"#line 2109 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_PT_NS ()\n"
"{\n"
"return \'http://www.w3.org/2005/09/sparql-protocol-types/#\';\n"
"}\n"
"--src sparql_io.sql:2107\n";

static const char *proc446 = 
"#line 2116 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.PARSE_SPARQL_WS_PARAMS (in lst any) returns any\n"
"{\n"
"declare pval, parse, res any;\n"
"declare lst_len, ctr integer;\n"
"declare pname, ttl_txt varchar;\n"
"lst_len := length (lst);\n"
"ttl_txt := \'\';\n"
"vectorbld_init (res);\n"
"for (ctr := 0; ctr < lst_len; ctr := ctr+2)\n"
"{\n"
"pname := lst[ctr];\n"
"pval := lst[ctr+1];\n"
"if (regexp_like (pval, \'^((\"[^\"\\\\\\\\]\")|(\\\'[^\\\'\\\\\\\\]\\\'))\\044\'))\n"
"parse := subseq (pval, 1, length (pval)-1);\n"
"else if (regexp_like (pval, \'^((\"\"\"[^\"\\\\\\\\]\"\"\")|(\\\'\\\'\\\'[^\\\'\\\\\\\\]\\\'\\\'\\\'))\\044\'))\n"
"parse := subseq (pval, 3, length (pval)-3);\n"
"else if (regexp_like (\'^<.+>\\044\', pval))\n"
"{\n"
"parse := (subseq (pval, 1, length (pval)-1));\n"
"__box_flags_set (parse, 1);\n"
"}\n"
"else if (regexp_like (pval, \'^([+-]?[0-9]+)\\044\'))\n"
"parse := cast (pval as integer);\n"
"else if (regexp_like (pval, \'^([+-]?[0-9]+\\.[0-9]+([eE][+-]?[0-9]+)?)\\044\'))\n"
"parse := cast (pval as double precision);\n"
"else\n"
"{\n"
"parse := null;\n"
"ttl_txt := concat (ttl_txt, \'<\', pname, \'> <p> \', pval, \' .\\n\');\n"
"}\n"
"if (parse is not null)\n"
"\n"
"vectorbld_acc (res, \':\' || pname, parse);\n"
"}\n"
"if (ttl_txt <> \'\')\n"
"{\n"
"declare triples any;\n"
"triples := DB.DBA.RDF_TTL2SQLHASH (ttl_txt, \'\', \'!sparql\', 0);\n"
"triples := dict_list_keys (triples, 1);\n"
"foreach (any t in triples) do\n"
"{\n"
"vectorbld_acc (res, \':\' || t[0], t[2]);\n"
"}\n"
"}\n"
"vectorbld_final (res);\n"
"return res;\n"
"}\n"
"--src sparql_io.sql:2114\n";

static const char *proc447 = 
"#line 2165 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.rdf_find_str (in x any)\n"
"{\n"
"return cast (x as varchar);\n"
"}\n"
"--src sparql_io.sql:2163\n";

static const char *other46 = 
"grant execute on DB.DBA.rdf_find_str to public\n";
static const char *proc448 = 
"#line 2175 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE()\n"
"{\n"
"http(\'<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\\n\');\n"
"http(\'<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\\n\');\n"
"http(\'<html version=\"-//W3C//DTD XHTML 1.1//EN\"\\n\');\n"
"http(\'    xmlns=\"http://www.w3.org/1999/xhtml\"\\n\');\n"
"http(\'    xml:lang=\"en\"\\n\');\n"
"http(\'>\\n\');\n"
"}\n"
"--src sparql_io.sql:2173\n";

static const char *proc449 = 
"#line 2187 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_HTML_HEAD(in title varchar)\n"
"{\n"
"http(\'    <title>\' || title || \'</title>\\n\');\n"
"http(sprintf(\'    <meta name=\"Copyright\" content=\"Copyright &copy; %d OpenLink Software\" />\\n\', year(now())));\n"
"http(\'    <meta name=\"Keywords\" content=\"OpenLink Virtuoso Sparql\" />\\n\');\n"
"http(\'    <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\\n\');\n"
"}\n"
"--src sparql_io.sql:2185\n";

static const char *proc450 = 
"#line 2197 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_STYLE ()\n"
"{\n"
"http(\'\\n\');\n"
"http(\'\n"
"<style type=\"text/css\">\n"
"/*<![CDATA[*/\n"
"html { padding: 0; }\n"
"body {\n"
"padding: 0;\n"
"margin: 0;\n"
"font-family:Gill Sans, Arial, Helvetica, sans-serif;\n"
"font-size: 9pt;\n"
"color: #333;\n"
"background-color: #FDFDFD;\n"
"}\n"
"#header {\n"
"padding: 0;\n"
"margin: 0;\n"
"background-color: #86B9D9;\n"
"color: #FFFFFF;\n"
"border-bottom: 1px solid #AAA;\n"
"}\n"
"#header h1 {\n"
"font-size: 16pt;\n"
"font-weight: normal;\n"
"text-align: left;\n"
"vertical-align: middle;\n"
"padding: 4px 8px 4px 8px;\n"
"margin: 0px 0px 0px 0px;\n"
"}\n"
"#menu {\n"
"margin-left: 8px;\n"
"margin-right: 8px;\n"
"margin-top: 0px;\n"
"clear: right;\n"
"float: right;\n"
"}\n"
"#intro,#main {\n"
"margin-left: 8px;\n"
"margin-right: 8px;\n"
"}\n"
"#help {\n"
"margin-left: 8px;\n"
"margin-right: 8px;\n"
"width: 80%\n"
"}\n"
"#footer {\n"
"width: 100%;\n"
"float: left;\n"
"clear: left;\n"
"margin: 2em 0 0;\n"
"padding-top: 0.7ex;\n"
"border-top: 1px solid #AAA;\n"
"font-size: 8pt;\n"
"text-align: center;\n"
"}\n"
"fieldset {\n"
"border: 0;\n"
"padding: 0;\n"
"margin: 0;\n"
"}\n"
"fieldset label {\n"
"font-weight: normal;\n"
"white-space: nowrap;\n"
"font-size: 11pt;\n"
"color: #000;\n"
"}\n"
"fieldset label.n {\n"
"display: block;\n"
"vertical-align: bottom;\n"
"margin-top:5px;\n"
"width: 160px;\n"
"float:left;\n"
"white-space: nowrap;\n"
"}\n"
"fieldset label.n:after { content: \":\"; }\n"
"fieldset label.n1 {\n"
"display: block;\n"
"vertical-align: bottom;\n"
"margin-top:5px;\n"
"width: 160px;\n"
"float:left;\n"
"white-space: nowrap;\n"
"}\n"
"fieldset label.ckb {\n"
"width: 160px;\n"
"font-weight: normal;\n"
"font-size: 10pt;\n"
"}\n"
"fieldset label.ckb:after { content: \"\"; }\n"
"fieldset textarea {\n"
"width: 99%;\n"
"font-family: monospace;\n"
"font-size: 10pt;\n"
"}\n"
"#cxml {\n"
"clear: both;\n"
"display: block;\n"
"}\n"
"#savefs {\n"
"clear: both;\n"
"display: block;\n"
"}\n"
"span.info {\n"
"font-size: 9pt;\n"
"white-space: nowrap;\n"
"height: 2em;\n"
"}\n"
"br { clear: both; }\n"
"/*]]>*/\n"
"</style>\n"
"\');\n"
"}\n"
"--src sparql_io.sql:2195\n";

static const char *proc451 = 
"#line 2313 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_JAVASCRIPT (in can_cxml integer, in can_qrcode integer)\n"
"{\n"
"http(\'\\n\');\n"
"http(\'    <script type=\"text/javascript\">\\n\');\n"
"http(\'    /*<![CDATA[*/\\n\');\n"
"http(\'	var last_format = 1;\\n\');\n"
"http(\'	function format_select(query_obg)\\n\');\n"
"http(\'	{\\n\');\n"
"http(\'		var query = query_obg.value; \\n\');\n"
"http(\'		var format = query_obg.form.format;\\n\');\n"
"http(\'\\n\');\n"
"http(\'		if ((query.match(/\\\\bconstruct\\\\b/i) || query.match(/\\\\bdescribe\\\\b/i)) && last_format == 1) {\\n\');\n"
"http(\'			for(var i = format.options.length; i > 0; i--)\\n\');\n"
"http(\'				format.options[i] = null;\\n\');\n"
"http(\'			format.options[1] = new Option(\\\'Turtle\\\',\\\'text/turtle\\\');\\n\');\n"
"http(\'			format.options[2] = new Option(\\\'RDF/JSON\\\',\\\'application/rdf+json\\\');\\n\');\n"
"http(\'			format.options[3] = new Option(\\\'RDF/XML\\\',\\\'application/rdf+xml\\\');\\n\');\n"
"http(\'			format.options[4] = new Option(\\\'N-Triples\\\',\\\'text/plain\\\');\\n\');\n"
"http(\'			format.options[5] = new Option(\\\'XHTML+RDFa\\\',\\\'application/xhtml+xml\\\');\\n\');\n"
"http(\'			format.options[6] = new Option(\\\'ATOM+XML\\\',\\\'application/atom+xml\\\');\\n\');\n"
"http(\'			format.options[7] = new Option(\\\'ODATA/JSON\\\',\\\'application/odata+json\\\');\\n\');\n"
"http(\'			format.options[8] = new Option(\\\'JSON-LD\\\',\\\'application/x-json+ld\\\');\\n\');\n"
"http(\'			format.options[9] = new Option(\\\'HTML (list)\\\',\\\'text/x-html+ul\\\');\\n\');\n"
"http(\'			format.options[10] = new Option(\\\'HTML (table)\\\',\\\'text/x-html+tr\\\');\\n\');\n"
"http(\'			format.options[11] = new Option(\\\'HTML+Microdata\\\',\\\'text/html\\\');\\n\');\n"
"http(\'			format.options[12] = new Option(\\\'Microdata/JSON\\\',\\\'application/microdata+json\\\');\\n\');\n"
"http(\'			format.options[13] = new Option(\\\'CSV\\\',\\\'text/csv\\\');\\n\');\n"
"http(\'			format.options[14] = new Option(\\\'TSV\\\',\\\'text/tab-separated-values\\\');\\n\');\n"
"http(\'			format.options[15] = new Option(\\\'TriG\\\',\\\'application/x-trig\\\');\\n\');\n"
"http(\'			format.options[16] = new Option(\\\'Pretty-printed Turtle (slow!)\\\',\\\'application/x-nice-turtle\\\');\\n\');\n"
"\n"
"if (can_cxml)\n"
"{\n"
"http(\'			format.options[17] = new Option(\\\'CXML (Pivot Collection)\\\',\\\'text/cxml\\\');\\n\');\n"
"if (can_qrcode)\n"
"http(\'		format.options[18] = new Option(\\\'CXML (Pivot Collection with QRcodes)\\\',\\\'text/cxml+qrcode\\\');\\n\');\n"
"}\n"
"http(\'			format.selectedIndex = 1;\\n\');\n"
"http(\'			last_format = 2;\\n\');\n"
"http(\'		}\\n\');\n"
"http(\'\\n\');\n"
"http(\'		if (!(query.match(/\\\\bconstruct\\\\b/i) || query.match(/\\\\bdescribe\\\\b/i)) && last_format == 2) {\\n\');\n"
"http(\'			for(var i = format.options.length; i > 0; i--)\\n\');\n"
"http(\'				format.options[i] = null;\\n\');\n"
"http(\'			format.options[1] = new Option(\\\'HTML\\\',\\\'text/html\\\');\\n\');\n"
"http(\'			format.options[2] = new Option(\\\'Spreadsheet\\\',\\\'application/vnd.ms-excel\\\');\\n\');\n"
"http(\'			format.options[3] = new Option(\\\'XML\\\',\\\'application/sparql-results+xml\\\');\\n\');\n"
"http(\'			format.options[4] = new Option(\\\'JSON\\\',\\\'application/sparql-results+json\\\');\\n\');\n"
"http(\'			format.options[5] = new Option(\\\'Javascript\\\',\\\'application/javascript\\\');\\n\');\n"
"http(\'			format.options[6] = new Option(\\\'Turtle\\\',\\\'text/turtle\\\');\\n\');\n"
"http(\'			format.options[7] = new Option(\\\'RDF/XML\\\',\\\'application/rdf+xml\\\');\\n\');\n"
"http(\'			format.options[8] = new Option(\\\'N-Triples\\\',\\\'text/plain\\\');\\n\');\n"
"http(\'			format.options[9] = new Option(\\\'CSV\\\',\\\'text/csv\\\');\\n\');\n"
"http(\'			format.options[10] = new Option(\\\'TSV\\\',\\\'text/tab-separated-values\\\');\\n\');\n"
"if (can_cxml)\n"
"http(\'			format.options[11] = new Option(\\\'CXML (Pivot Collection)\\\',\\\'text/cxml\\\');\\n\');\n"
"http(\'			format.selectedIndex = 1;\\n\');\n"
"http(\'			last_format = 1;\\n\');\n"
"http(\'		}\\n\');\n"
"http(\'	}\\n\');\n"
"http(\'\n"
"function format_change(e)\n"
"{\n"
"var format = e.value;\n"
"var cxml = document.getElementById(\"cxml\");\n"
"if (!cxml) return;\n"
"if ((format.match (/\\\\bCXML\\\\b/i)))\n"
"{\n"
"cxml.style.display=\"block\";\n"
"} else {\n"
"cxml.style.display=\"none\";\n"
"}\n"
"}\n"
"function savedav_change(e)\n"
"{\n"
"var savefs = document.getElementById(\"savefs\");\n"
"if (!savefs) return;\n"
"if (e.checked)\n"
"{\n"
"savefs.style.display = \"block\";\n"
"}\n"
"else\n"
"{\n"
"savefs.style.display = \"none\";\n"
"}\n"
"}\n"
"function sparql_endpoint_init()\n"
"{\n"
"var cxml = document.getElementById(\"cxml\");\n"
"if (cxml) cxml.style.display=\"none\";\n"
"var savefs = document.getElementById(\"savefs\");\n"
"if (savefs) savefs.style.display=\"none\";\n"
"}\n"
"\');\n"
"http(\'    /*]]>*/\\n\');\n"
"http(\'    </script>\\n\');\n"
"}\n"
"--src sparql_io.sql:2311\n";

static const char *proc452 = 
"#line 2413 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_FOOTER()\n"
"{\n"
"http(\'    <div id=\"footer\">\\n\');\n"
"http(sprintf(\'	Copyright &copy; %d <a href=\"http://www.openlinksw.com/virtuoso\">OpenLink Software</a>\', year(now())));\n"
"http(sprintf(\'<br />Virtuoso version %s on %s (%s), \', sys_stat(\'st_dbms_ver\'), sys_stat(\'st_build_opsys_id\'), host_id()));\n"
"if (1 = sys_stat(\'cl_run_local_only\'))\n"
"http(\'Single Server Edition\\n\');\n"
"else\n"
"http(sprintf(\'Cluster Edition (%d server processes)\\n\', sys_stat(\'cl_n_hosts\')));\n"
"http(\'    </div>\\n\');\n"
"}\n"
"--src sparql_io.sql:2411\n";

static const char *proc453 = 
"#line 2427 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_FORMAT_OPTS (in can_cxml integer, in can_qrcode integer, in params varchar, in qr varchar)\n"
"{\n"
"declare opts any;\n"
"declare format varchar;\n"
"format := get_keyword (\'format\', params, get_keyword (\'output\', params, \'\'));\n"
"qr := lower (qr);\n"
"if (format <> \'\')\n"
"{\n"
"format := (\n"
"case lower(format)\n"
"when \'csv\'		then \'text/csv\'\n"
"when \'cxml\'		then \'text/cxml\'\n"
"when \'cxml+qrcode\'	then \'text/cxml+qrcode\'\n"
"when \'html\'		then \'text/html\'\n"
"when \'js\'		then \'application/javascript\'\n"
"when \'json\'		then \'application/sparql-results+json\'\n"
"when \'json-ld\'		then \'application/ld+json\'\n"
"when \'n3\'		then \'text/rdf+n3\'\n"
"when \'ttl\'		then \'text/turtle\'\n"
"when \'turtle\'		then \'text/turtle\'\n"
"when \'rdf\'		then \'application/rdf+xml\'\n"
"when \'sparql\'		then \'application/sparql-results+xml\'\n"
"when \'xml\'		then \'application/sparql-results+xml\'\n"
"else format\n"
"end);\n"
"}\n"
"if (\n"
"regexp_match (\'\\\\bconstruct\\\\b\', qr) is not null\n"
"or\n"
"regexp_match (\'\\\\bdescribe\\\\b\', qr) is not null\n"
")\n"
"{\n"
"opts := vector (\n"
"vector (\'text/turtle\'			, \'Turtle\'				),\n"
"vector (\'application/rdf+json\'		, \'RDF/JSON\'		),\n"
"vector (\'application/rdf+xml\'			, \'RDF/XML\'		),\n"
"vector (\'text/plain\'				, \'N-Triples\'		),\n"
"vector (\'application/xhtml+xml\'		, \'XHTML+RDFa\'		),\n"
"vector (\'application/atom+xml\'		, \'ATOM+XML\'		),\n"
"vector (\'application/odata+json\'		, \'ODATA/JSON\'		),\n"
"vector (\'application/x-json+ld\'		, \'JSON-LD\'		),\n"
"vector (\'text/x-html+ul\'			, \'HTML (list)\'		),\n"
"vector (\'text/x-html+tr\'			, \'HTML (table)\'	),\n"
"vector (\'text/html\'				, \'HTML+Microdata\'	),\n"
"vector (\'application/microdata+json\'		, \'Microdata/JSON\'	),\n"
"vector (\'text/csv\'				, \'CSV\'			),\n"
"vector (\'text/tab-separated-values\'			, \'TSV\'			),\n"
"vector (\'application/x-trig\'		, \'TriG\'				),\n"
"vector (\'application/x-nice-turtle\'	, \'Pretty-printed Turtle (slow!)\'	) );\n"
"}\n"
"else\n"
"{\n"
"if (not length (format)) format := \'text/html\';\n"
"opts := vector (\n"
"vector (\'auto\'				, \'Auto\'		),\n"
"vector (\'text/html\'				, \'HTML\'		),\n"
"vector (\'application/vnd.ms-excel\'		, \'Spreadsheet\'		),\n"
"vector (\'application/sparql-results+xml\'	, \'XML\'			),\n"
"vector (\'application/sparql-results+json\'	, \'JSON\'		),\n"
"vector (\'application/javascript\'		, \'Javascript\'		),\n"
"vector (\'text/plain\'				, \'NTriples\'		),\n"
"vector (\'application/rdf+xml\',		\'RDF/XML\') );\n"
"}\n"
"foreach (any x in opts) do\n"
"{\n"
"http(sprintf (\'			<option value=\"%V\" %s>%V</option>\\n\',\n"
"x[0], case when format = x[0] then \'selected=\"selected\"\' else \'\' end , x[1]));\n"
"}\n"
"http(\'			<option value=\"text/csv\">CSV</option>\\n\');\n"
"http(\'			<option value=\"text/tab-separated-values\">TSV</option>\\n\');\n"
"if (can_cxml)\n"
"{\n"
"http(\'			<option value=\"text/cxml\">CXML (Pivot Collection)</option>\\n\');\n"
"if (can_qrcode)\n"
"http(\'			<option value=\"text/cxml+qrcode\">CXML (Pivot Collection with QRcode)</option>\\n\');\n"
"}\n"
"}\n"
"--src sparql_io.sql:2425\n";

static const char *proc454 = 
"#line 2506 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_SPONGE_OPTS (in params varchar)\n"
"{\n"
"declare s_param varchar;\n"
"declare opts any;\n"
"\n"
"s_param := get_keyword (\'should-sponge\', params, \'\');\n"
"opts := vector (\n"
"vector (\'\', 		  \'Use only local data (including data retrieved before), but do not retrieve more\'),\n"
"vector (\'soft\', 		  \'Retrieve remote RDF data for all missing source graphs\'),\n"
"vector (\'grab-all\',	  \'Retrieve all missing remote RDF data that might be useful\'),\n"
"vector (\'grab-all-seealso\', \'Retrieve all missing remote RDF data that might be useful, including seeAlso references\'),\n"
"vector (\'grab-everything\',  \'Try to download all referenced resources (this may be very slow and inefficient)\')\n"
");\n"
"\n"
"foreach (any x in opts) do\n"
"{\n"
"http(sprintf (\'			<option value=\"%V\" %s>%V</option>\\n\',\n"
"x[0], case when s_param = x[0] then \'selected=\"selected\"\' else \'\' end , x[1]));\n"
"}\n"
"}\n"
"--src sparql_io.sql:2504\n";

static const char *proc455 = 
"#line 2529 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_CXML_OPTION (in can_pivot integer, in params varchar, in lbl varchar)\n"
"{\n"
"declare val varchar;\n"
"declare opts varchar;\n"
"\n"
"if (\'CXML_redir_for_subjs\' = lbl)\n"
"{\n"
"val := get_keyword (lbl, params, \'121\');\n"
"http (\'		<label for=\"CXML_redir_for_subjs\" class=\"n\">External resource link</label>\\n\');\n"
"http (\'		<select name=\"CXML_redir_for_subjs\" id=\"CXML_redir_for_subjs\">\\n\');\n"
"opts := vector (\n"
"vector (\'\',			\'No link out\'),\n"
"vector (\'121\',		\'External resource link\'),\n"
"vector (\'LOCAL_TTL\', 		\'External description resource (TTL)\'),\n"
"vector (\'LOCAL_NTRIPLES\', 	\'External description resource (NTRIPLES)\'),\n"
"vector (\'LOCAL_JSON\', 	\'External description resource (JSON)\'),\n"
"vector (\'LOCAL_XML\', 		\'External description resource (RDF/XML)\')\n"
");\n"
"} else {\n"
"val := get_keyword (lbl, params, \'\');\n"
"http (\'		<label for=\"CXML_redir_for_hrefs\" class=\"n\">Facet link behavior</label>\\n\');\n"
"http (\'		<select name=\"CXML_redir_for_hrefs\" id=\"CXML_redir_for_hrefs\">\\n\');\n"
"opts := vector (\n"
"vector (\'\',			\'Local faceted navigation link\'),\n"
"vector (\'121\',		\'External resource link\'),\n"
"vector (\'LOCAL_PIVOT\',	\'External faceted navigation link\'),\n"
"vector (\'LOCAL_TTL\', 		\'External description resource (TTL)\'),\n"
"vector (\'LOCAL_CXML\',		\'External description resource (CXML)\'),\n"
"vector (\'LOCAL_NTRIPLES\', 	\'External description resource (NTRIPLES)\'),\n"
"vector (\'LOCAL_JSON\', 	\'External description resource (JSON)\'),\n"
"vector (\'LOCAL_XML\', 		\'External description resource (RDFXML)\')\n"
");\n"
"}\n"
"\n"
"foreach (any x in opts) do\n"
"{\n"
"if (\'LOCAL_PIVOT\' <> x[0] or can_pivot)\n"
"http(sprintf (\'			<option value=\"%V\" %s>%V</option>\\n\',\n"
"x[0], case when val = x[0] then \'selected=\"selected\"\' else \'\' end , x[1]));\n"
"}\n"
"\n"
"http (\'		</select><br />\\n\');\n"
"}\n"
"--src sparql_io.sql:2527\n";

static const char *proc456 = 
"#line 2575 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.sparql_predefined_nsdecl ()\n"
"{\n"
"declare label varchar;\n"
"label := \'Predefined Namespace Prefixes\';\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"\n"
"http(\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(label);\n"
"WS.WS.SPARQL_ENDPOINT_STYLE();\n"
"http(\'</head>\\n\');\n"
"\n"
"http (\'<body>\\n\');\n"
"http (\'    <div id=\"header\">\\n\');\n"
"http (\'	<h1 id=\"title\">\'); http (sprintf (\'%s\', label)); http (\'</h1>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"http (\'    <div id=\"main\">\\n\');\n"
"http (\'    <br />\\n\');\n"
"http (\'    <table class=\"tableresult\" border=\"1\">\\n\');\n"
"http (sprintf (\'	<tr><th>Prefix</th><th>URI</th></tr>\\n\'));\n"
"for select NS_PREFIX, NS_URL from SYS_XML_PERSISTENT_NS_DECL order by 1 do\n"
"{\n"
"http (sprintf (\'	<tr><td>%V</td><td>%V</td></tr>\\n\', NS_PREFIX, NS_URL));\n"
"}\n"
"http (\'    </table>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"\n"
"http(\'<p>\');\n"
"http (\'<button type=\"button\" name=\"back\" value=\"Back\" onclick=\"javascript:history.go(-1);\">Back</button>\\n\');\n"
"http(\'</p>\\n\');\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_FOOTER();\n"
"http(\'</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"}\n"
"--src sparql_io.sql:2573\n";

static const char *proc457 = 
"#line 2613 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.sparql_predefined_rdfinf ()\n"
"{\n"
"declare label varchar;\n"
"label := \'Predefined Inference Rules\';\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"\n"
"http(\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(label);\n"
"WS.WS.SPARQL_ENDPOINT_STYLE();\n"
"http(\'</head>\\n\');\n"
"\n"
"http (\'<body>\\n\');\n"
"http (\'    <div id=\"header\">\\n\');\n"
"http (\'	<h1 id=\"title\">\'); http (sprintf (\'%s\', label)); http (\'</h1>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"http (\'    <div id=\"main\">\\n\');\n"
"http (\'    <br />\\n\');\n"
"http (\'    <table class=\"tableresult\" border=\"1\">\\n\');\n"
"http (sprintf (\'	<tr><th>Name</th><th>URI</th></tr>\\n\'));\n"
"for select * from SYS_RDF_SCHEMA order by 1 do\n"
"{\n"
"http (sprintf (\'	<tr><td>%V</td><td>%V</td></tr>\\n\', RS_NAME, RS_URI));\n"
"}\n"
"http (\'    </table>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"\n"
"http(\'<p>\');\n"
"http (\'<button type=\"button\" name=\"back\" value=\"Back\" onclick=\"javascript:history.go(-1);\">Back</button>\\n\');\n"
"http(\'</p>\\n\');\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_FOOTER();\n"
"http(\'</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"}\n"
"--src sparql_io.sql:2611\n";

static const char *proc458 = 
"#line 2650 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.SPARQL_ENDPOINT_GENERATE_FORM(\n"
"in params any,\n"
"in ini_dflt_graph varchar,\n"
"in def_qry varchar,\n"
"in timeout integer,\n"
"in debug integer,\n"
"in save_mode integer,\n"
"in dav_refresh varchar)\n"
"{\n"
"declare can_cxml, can_pivot, can_qrcode, can_sponge integer;\n"
"can_cxml := case (isnull (DB.DBA.VAD_CHECK_VERSION (\'sparql_cxml\'))) when 0 then 1 else 0 end;\n"
"can_pivot := case (isnull (DB.DBA.VAD_CHECK_VERSION (\'PivotViewer\'))) when 0 then 1 else 0 end;\n"
"can_qrcode := isstring (__proc_exists (\'QRcode encodeString8bit\', 2));\n"
"can_sponge := coalesce ((select top 1 1\n"
"from DB.DBA.SYS_USERS as sup\n"
"join DB.DBA.SYS_ROLE_GRANTS as g on (sup.U_ID = g.GI_SUPER)\n"
"join DB.DBA.SYS_USERS as sub on (g.GI_SUB = sub.U_ID)\n"
"where sup.U_NAME = \'SPARQL\' and sub.U_NAME = \'SPARQL_SPONGE\' ), 0);\n"
"\n"
"declare endpoint_xsl any;\n"
"endpoint_xsl := registry_get (\'sparql_endpoint_xsl\');\n"
"if (0 = endpoint_xsl) endpoint_xsl := \'\';\n"
"if (\'\' <> endpoint_xsl) http_xslt(endpoint_xsl);\n"
"\n"
"declare user_id varchar;\n"
"user_id := connection_get (\'SPARQLUserId\', \'SPARQL\');\n"
"\n"
"declare path, save_dir varchar;\n"
"declare parts any;\n"
"save_dir := null;\n"
"for (select COL_ID from WS.WS.SYS_DAV_COL where COL_DET = \'DynaRes\' and WS.WS.COL_PATH (COL_PARENT) like sprintf (\'/DAV/home/%s%%\', user_id)) do\n"
"{\n"
"path := WS.WS.COL_PATH (COL_ID);\n"
"parts := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = parts[3] and U_DAV_ENABLE));\n"
"save_dir := path;\n"
"}\n"
"\n"
"http_header (\'Content-Type: text/html; charset=UTF-8\\r\\n\');\n"
"if (http_request_get (\'REQUEST_METHOD\') = \'OPTIONS\')\n"
"http_header (http_header_get () || \'MS-Author-Via: SPARQL\\r\\n\');\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"\n"
"http(\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(\'Virtuoso SPARQL Query Editor\');\n"
"WS.WS.SPARQL_ENDPOINT_STYLE ();\n"
"WS.WS.SPARQL_ENDPOINT_JAVASCRIPT(can_cxml, can_qrcode);\n"
"http(\'</head>\\n\');\n"
"\n"
"http(\'<body onload=\"sparql_endpoint_init()\">\\n\');\n"
"\n"
"http(\'    <div id=\"header\">\\n\');\n"
"http(\'	<h1>Virtuoso SPARQL Query Editor</h1>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"\n"
"http(\'    <div id=\"menu\">\\n\');\n"
"http(\'	  <a href=\"/sparql?help=intro\">About</a>\\n\');\n"
"http(\'	| <a href=\"/sparql?nsdecl\">Namespace Prefixes</a>\\n\');\n"
"http(\'	| <a href=\"/sparql?rdfinf\">Inference rules</a>\\n\');\n"
"if (DB.DBA.VAD_CHECK_VERSION(\'iSPARQL\') is not null)\n"
"http(\'	| <a href=\"/isparql\">iSPARQL</a>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"\n"
"http(\'    <div id=\"main\">\\n\');\n"
"http(\'    <br />\\n\');\n"
"http(\'	<form action=\"\" method=\"get\">\\n\');\n"
"http(\'	<fieldset>\\n\');\n"
"http(\'		<label for=\"default-graph-uri\">Default Data Set Name (Graph IRI)</label><br />\\n\');\n"
"http(\'		<input type=\"text\" name=\"default-graph-uri\" id=\"default-graph-uri\"\');\n"
"http(sprintf (\' value=\"%s\" size=\"80\"/>\\n\', coalesce (ini_dflt_graph, \'\') ));\n"
"http(\'		<br /><br />\\n\');\n"
"\n"
"http(\'		<label for=\"query\">Query Text</label><br />\\n\');\n"
"http(\'		<textarea rows=\"18\" cols=\"80\" name=\"query\" id=\"query\" onchange=\"format_select(this)\" onkeyup=\"format_select(this)\">\'|| def_qry ||\'</textarea>\\n\');\n"
"\n"
"http(\'		<br /><br />\\n\');\n"
"if (can_sponge)\n"
"{\n"
"http(\'		<label for=\"should-sponge\" class=\"n\">Sponging</label>\\n\');\n"
"http(\'		<select name=\"should-sponge\" id=\"should-sponge\">\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_SPONGE_OPTS (params);\n"
"http(\'		</select>\\n\');\n"
"}\n"
"else\n"
"{\n"
"http(\'		<span class=\"info\"><i>(Security restrictions of this server do not allow you to retrieve remote RDF data, see <a href=\"/sparql?help=enable_sponge\">details</a>.)</i></span>\\n\');\n"
"}\n"
"\n"
"http(\'		<br />\\n\');\n"
"http(\'		<label for=\"format\" class=\"n\">Results Format</label>\\n\');\n"
"http(\'		<select name=\"format\" id=\"format\" onchange=\"format_change(this)\">\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_FORMAT_OPTS (can_cxml, can_qrcode, params, def_qry);\n"
"http(\'		</select>\\n\');\n"
"if (sys_stat(\'st_has_vdb\'))\n"
"{\n"
"if (not can_cxml)\n"
"http(\'		<span class=\"info\"><i>(The CXML output is disabled, see <a href=\"/sparql?help=enable_cxml\">details</a>)</i></span>\\n\');\n"
"else if (not can_qrcode)\n"
"http(\'		<span class=\"info\"><i>(The QRCODE output is disabled, see <a href=\"/sparql?help=enable_cxml\">details</a>)</i></span>\\n\');\n"
"}\n"
"http(\'		<br />\\n\');\n"
"\n"
"if (can_cxml)\n"
"{\n"
"http (\'		<fieldset id=\"cxml\">\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_CXML_OPTION (can_pivot, params, \'CXML_redir_for_subjs\');\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_CXML_OPTION (can_pivot, params, \'CXML_redir_for_hrefs\');\n"
"http (\'		</fieldset>\\n\');\n"
"}\n"
"\n"
"http(\'		<label for=\"timeout\" class=\"n\">Execution timeout</label>\\n\');\n"
"http(\'		<input name=\"timeout\" id=\"timeout\" type=\"text\" value=\"\' || coalesce (cast (timeout as varchar), \'\') || \'\" /> milliseconds\\n\');\n"
"http(\'		<span class=\"info\"><i>(values less than 1000 are ignored)</i></span>\');\n"
"http(\'		<br />\\n\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"http(\'		<label class=\"n\" for=\"options\">Options</label>\\n\');\n"
"http(\'		<fieldset id=\"options\">\\n\');\n"
"http(\'		<input name=\"debug\" id=\"debug\" type=\"checkbox\"\' || case (debug) when \'\' then \'\' else \' checked=\"checked\"\' end || \'/>\\n\');\n"
"http(\'		<label for=\"debug\" class=\"ckb\">Strict checking of void variables</label>\\n\');\n"
"\n"
"\n"
"if (save_dir is not null)\n"
"{\n"
"http(\'		<br />\\n\');\n"
"http(\'		<input name=\"save\" id=\"save\" onclick=\"savedav_change(this)\" type=\"checkbox\"\' || case when (save_mode is null) then \'\' else \' checked=\"checked\"\' end || \' />\\n\');\n"
"http(\'		<label for=\"save\" class=\"ckb\">Save resultset to WebDAV folder on the server</label>\\n\');\n"
"http(\'		<span id=\"savefs\">\\n\');\n"
"http(\'		  <label for=\"dname\">Dynamic resource collection:</label>\\n\');\n"
"http(\'		  <select id=\"dname\" name=\"dname\" >\\n\');\n"
"for (select COL_ID from WS.WS.SYS_DAV_COL where COL_DET = \'DynaRes\' and WS.WS.COL_PATH (COL_PARENT) like \'/DAV/home/%\') do\n"
"{\n"
"path := WS.WS.COL_PATH (COL_ID);\n"
"parts := split_and_decode (path, 0, \'\\0\\0/\');\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = parts[3] and U_DAV_ENABLE));\n"
"http(sprintf(\'<option>%s</option>\\n\', path));\n"
"}\n"
"http(\'		  </select>\\n\');\n"
"http(\'		  <br />\\n\');\n"
"http(\'		  <label for=\"fname\">File name:</label>\\n\');\n"
"http(\'		  <input type=\"text\" id=\"fname\" name=\"fname\" />\\n\');\n"
"http(\'		  <br />\\n\');\n"
"http(\'		  <input type=\"checkbox\" name=\"dav_refresh\" id=\"dav_refresh\"\' || case when (dav_refresh is null) then \'\' else \' checked=\"checked\"\' end || \' />\\n\');\n"
"http(\'		  <label class=\"ckb\" for=\"dav_refresh\">Refresh periodically</label>\\n\');\n"
"http(\'		</span>\\n\');\n"
"}\n"
"\n"
"http(\'		</fieldset>\\n\');\n"
"http(\'		<br />\\n\');\n"
"\n"
"if (save_dir is null)\n"
"{\n"
"http(\'		<span class=\"info\"><i>(The result can only be sent back to browser, not saved on the server, see <a href=\"/sparql?help=enable_det\">details</a>)</i></span>\\n\');\n"
"http(\'		<br />\\n\');\n"
"}\n"
"\n"
"http(\'		<br />\\n\');\n"
"http(\'		<input type=\"submit\" value=\"Run Query\"/>\\n\');\n"
"http(\'		<input type=\"reset\" value=\"Reset\"/>\\n\');\n"
"http(\'	</fieldset>\\n\');\n"
"http(\'	</form>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_FOOTER();\n"
"http (WS.WS.SPARQL_ENDPOINT_SVC_DESC ());\n"
"http(\'</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"\n"
"return;\n"
"}\n"
"--src sparql_io.sql:2648\n";

static const char *proc459 = 
"#line 2830 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.\"/!sparql/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare query, full_query, format, should_sponge, debug, def_qry varchar;\n"
"declare dflt_graphs, named_graphs, using_graphs, using_named_graphs any;\n"
"declare paramctr, paramcount, qry_params, maxrows, can_sponge,  start_time integer;\n"
"declare ses, content any;\n"
"declare def_max, add_http_headers, hard_timeout, timeout, client_supports_partial_res, sp_ini, soap_ver int;\n"
"declare http_meth, content_type, ini_dflt_graph, get_user, jsonp_callback varchar;\n"
"declare state, msg varchar;\n"
"declare metas, rset any;\n"
"declare accept, soap_action, user_id varchar;\n"
"declare exec_time, exec_db_activity any;\n"
"declare __debug_mode integer;\n"
"declare qtxt, deadl integer;\n"
"declare save_mode, save_dir, dav_refresh, fname varchar;\n"
"declare save_dir_id any;\n"
"declare help_topic varchar;\n"
"\n"
"\n"
"\n"
"\n"
"for (declare i int, i := 0; i < length (params); i := i + 2)\n"
"{\n"
"declare vn, vv varchar;\n"
"vn := params[i];\n"
"vv := params[i+1];\n"
"if (not (isstring (vv)) or (vv <> \'\'))\n"
"connection_set (\'SPARQL_\' || vn, vv);\n"
"}\n"
"if (registry_get (\'__sparql_endpoint_debug\') = \'1\')\n"
"{\n"
"__debug_mode := 1;\n"
"for (declare i int, i := 0; i < length (params); i := i + 2)\n"
"{\n"
"if (isstring (params[i+1]))\n"
"dbg_printf (\'%s=%s\',params[i],params[i+1]);\n"
"else if (__tag (params[i+1]) = 185)\n"
"dbg_printf (\'%s=%s\',params[i],\'<strses>\');\n"
"else\n"
"dbg_printf (\'%s=%s\',params[i],\'<box>\');\n"
"}\n"
"}\n"
"\n"
"set http_charset=\'utf-8\';\n"
"http_methods_set (\'OPTIONS\', \'GET\', \'HEAD\', \'POST\', \'TRACE\');\n"
"ses := 0;\n"
"debug := \'\';\n"
"query := null;\n"
"format := \'\';\n"
"should_sponge := \'\';\n"
"add_http_headers := 1;\n"
"sp_ini := 0;\n"
"dflt_graphs := vector ();\n"
"named_graphs := vector ();\n"
"using_graphs := vector ();\n"
"using_named_graphs := vector ();\n"
"maxrows := 1024*1024;\n"
"deadl := 0;\n"
"http_meth := http_request_get (\'REQUEST_METHOD\');\n"
"ini_dflt_graph := virtuoso_ini_item_value (\'SPARQL\', \'DefaultGraph\');\n"
"hard_timeout := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxQueryExecutionTime\'), \'0\')) * 1000;\n"
"timeout := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'ExecutionTimeout\'), \'0\')) * 1000;\n"
"client_supports_partial_res := 0;\n"
"\n"
"user_id := connection_get (\'SPARQLUserId\', \'SPARQL\');\n"
"help_topic := get_keyword (\'help\', params, null);\n"
"if (help_topic is not null)\n"
"goto brief_help;\n"
"\n"
"def_qry := get_keyword(\'qtxt\', params, \'\');\n"
"ini_dflt_graph := get_keyword (\'default-graph-uri\', params, ini_dflt_graph);\n"
"timeout := atoi (get_keyword (\'timeout\', params, cast (timeout as varchar)));\n"
"\n"
"if (\'\' <> def_qry)\n"
"qtxt := 1;\n"
"def_max := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'ResultSetMaxRows\'), \'-1\'));\n"
"\n"
"\n"
"save_dir := trim (get_keyword (\'dname\', params, \'\'));\n"
"save_dir_id := DAV_SEARCH_ID (save_dir, \'C\');\n"
"if (DAV_HIDE_ERROR (save_dir_id) is null)\n"
"save_dir := null;\n"
"\n"
"fname := trim (get_keyword (\'fname\', params, \'\'));\n"
"if (fname = \'\')\n"
"fname := null;\n"
"\n"
"dav_refresh := get_keyword (\'dav_refresh\', params, \'\');\n"
"if (dav_refresh = \'\')\n"
"dav_refresh := null;\n"
"\n"
"save_mode := get_keyword (\'save\', params, \'\');\n"
"\n"
"if (save_mode = \'\' OR save_mode = \'display\') {\n"
"save_mode := null;\n"
"dav_refresh := null;\n"
"fname := null;\n"
"} else if (save_mode = \'dynamic\' OR dav_refresh is not null) {\n"
"save_mode := \'dynamic\';\n"
"dav_refresh := \'1\';\n"
"} else {\n"
"save_mode := \'tmpstatic\';\n"
"dav_refresh := null;\n"
"}\n"
"\n"
"get_user := \'\';\n"
"soap_ver := 0;\n"
"soap_action := http_request_header (lines, \'SOAPAction\', null, null);\n"
"content_type := http_request_header (lines, \'Content-Type\', null, \'\');\n"
"\n"
"if (content_type = \'application/soap+xml\')\n"
"soap_ver := 12;\n"
"else if (soap_action is not null)\n"
"soap_ver := 11;\n"
"\n"
"content := null;\n"
"declare exit handler for sqlstate \'*\' {\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"query, __SQL_STATE, __SQL_MESSAGE, format);\n"
"return;\n"
"};\n"
"\n"
"\n"
"if (http_path () = \'/sparql/services.wsdl\')\n"
"{\n"
"http_header (\'Content-Type: application/wsdl+xml\\r\\n\');\n"
"\n"
"DB.DBA.SPARQL_WSDL (lines);\n"
"return;\n"
"}\n"
"else if (http_path () = \'/sparql/services11.wsdl\')\n"
"{\n"
"http_header (\'Content-Type: text/xml\\r\\n\');\n"
"DB.DBA.SPARQL_WSDL11 (lines);\n"
"return;\n"
"}\n"
"\n"
"if (__debug_mode) dbg_printf (\'%d\', soap_ver);\n"
"\n"
"if (get_keyword (\'nsdecl\', params) is not null)\n"
"{\n"
"WS.WS.sparql_predefined_nsdecl ();\n"
"return;\n"
"}\n"
"if (get_keyword (\'rdfinf\', params) is not null)\n"
"{\n"
"WS.WS.sparql_predefined_rdfinf ();\n"
"return;\n"
"}\n"
"\n"
"can_sponge := coalesce ((select top 1 1\n"
"from DB.DBA.SYS_USERS as sup\n"
"join DB.DBA.SYS_ROLE_GRANTS as g on (sup.U_ID = g.GI_SUPER)\n"
"join DB.DBA.SYS_USERS as sub on (g.GI_SUB = sub.U_ID)\n"
"where sup.U_NAME = \'SPARQL\' and sub.U_NAME = \'SPARQL_SPONGE\' ), 0);\n"
"\n"
"paramcount := length (params);\n"
"\n"
"if ((0 = paramcount) or\n"
"(((2 = paramcount) and (\'Content\' = params[0])) and soap_ver = 0) or\n"
"qtxt = 1)\n"
"{\n"
"declare redir, acc varchar;\n"
"redir := registry_get (\'WS.WS.SPARQL_DEFAULT_REDIRECT\');\n"
"if (isstring (redir))\n"
"{\n"
"http_request_status (\'HTTP/1.1 301 Moved Permanently\');\n"
"http_header (sprintf (\'Location: %s\\r\\n\', redir));\n"
"return;\n"
"}\n"
"if (not qtxt)\n"
"{\n"
"def_qry := virtuoso_ini_item_value (\'SPARQL\', \'DefaultQuery\');\n"
"if (def_qry is null)\n"
"def_qry := \'SELECT * WHERE {?s ?p ?o}\';\n"
"}\n"
"\n"
"if (qtxt <> 1)\n"
"{\n"
"acc := DB.DBA.HTTP_RDF_GET_ACCEPT_BY_Q (http_request_header_full (lines, \'Accept\', \'*/*\'));\n"
"if (strstr (acc, \'/rdf+xml\') is not null or strstr (acc, \'text/n3\') is not null or strstr (acc, \'text/turtle\') is not null)\n"
"{\n"
"query := sprintf (\'construct { ?s ?p ?o } from <http://%s/sparql> { ?s ?p ?o }\', registry_get (\'URIQADefaultHost\'));\n"
"accept := acc;\n"
"goto execute_query;\n"
"}\n"
"}\n"
"debug := get_keyword (\'debug\', params, \'1\');\n"
"WS.WS.SPARQL_ENDPOINT_GENERATE_FORM(params, ini_dflt_graph, def_qry, timeout, debug, save_mode, dav_refresh);\n"
"\n"
"return;\n"
"}\n"
"execute_query:\n"
"qry_params := dict_new (7);\n"
"for (paramctr := 0; paramctr < paramcount; paramctr := paramctr + 2)\n"
"{\n"
"declare pname, pvalue varchar;\n"
"pname := params [paramctr];\n"
"pvalue := params [paramctr+1];\n"
"if (pname in (\'query\', \'update\'))\n"
"query := pvalue;\n"
"else if (\'find\' = pname)\n"
"{\n"
"declare cls, words, ft, vec, cond varchar;\n"
"cls := get_keyword (\'class\', params);\n"
"maxrows := atoi (get_keyword (\'maxrows\', params, cast (maxrows as varchar)));\n"
"if (def_max > 0 and def_max < maxrows)\n"
"maxrows := def_max;\n"
"if (cls is not null)\n"
"cond := sprintf (\' ?s a %s . \', cls);\n"
"else\n"
"cond := \'\';\n"
"ft := trim (DB.DBA.FTI_MAKE_SEARCH_STRING_INNER (pvalue, words), \'()\');\n"
"if (ft is null or length (words) = 0)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'The value of \"find\" parameter of web service endpoint is not a valid search string\' );\n"
"return;\n"
"}\n"
"vec := DB.DBA.SYS_SQL_VECTOR_PRINT (words);\n"
"if (get_keyword (\'format\', params, \'\') like \'%/rdf+%\' or http_request_header (lines, \'Accept\', null, \'\') like \'%/rdf+%\')\n"
"query := sprintf (\'construct { ?s ?p `bif:search_excerpt (bif:vector (%s), sql:rdf_find_str(?o))` } \' ||\n"
"\'where { ?s ?p ?o . %s filter (bif:contains (?o, \'\'%s\'\')) } limit %d\', vec, cond, ft, maxrows);\n"
"else\n"
"query := sprintf (\'select ?s ?p (bif:search_excerpt (bif:vector (%s), sql:rdf_find_str(?o))) \' ||\n"
"\'where { ?s ?p ?o . %s filter (bif:contains (?o, \'\'%s\'\')) } limit %d\', vec, cond, ft, maxrows);\n"
"}\n"
"else if (\'default-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, dflt_graphs) <= 0)\n"
"dflt_graphs := vector_concat (dflt_graphs, vector (pvalue));\n"
"}\n"
"else if (\'named-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, named_graphs) <= 0)\n"
"named_graphs := vector_concat (named_graphs, vector (pvalue));\n"
"}\n"
"else if (\'using-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, using_graphs) <= 0)\n"
"using_graphs := vector_concat (using_graphs, vector (pvalue));\n"
"}\n"
"else if (\'using-named-graph-uri\' = pname and length (pvalue))\n"
"{\n"
"if (position (pvalue, using_named_graphs) <= 0)\n"
"using_named_graphs := vector_concat (using_named_graphs, vector (pvalue));\n"
"}\n"
"else if (\'maxrows\' = pname)\n"
"{\n"
"maxrows := cast (pvalue as integer);\n"
"}\n"
"else if (\'should-sponge\' = pname)\n"
"{\n"
"if (can_sponge)\n"
"should_sponge := trim(pvalue);\n"
"}\n"
"else if (\'format\' = pname or \'output\' = pname)\n"
"{\n"
"format := pvalue;\n"
"}\n"
"else if (\'timeout\' = pname and length (pvalue))\n"
"{\n"
"declare t integer;\n"
"t := cast (pvalue as integer);\n"
"if (t is not null and t >= 1000)\n"
"{\n"
"if (hard_timeout >= 1000)\n"
"timeout := __min (t, hard_timeout);\n"
"else\n"
"timeout := t;\n"
"}\n"
"client_supports_partial_res := 1;\n"
"}\n"
"else if (\'ini\' = pname)\n"
"{\n"
"sp_ini := 1;\n"
"}\n"
"else if (query is null and \'query-uri\' = pname and length (pvalue))\n"
"{\n"
"if (virtuoso_ini_item_value (\'SPARQL\', \'ExternalQuerySource\') = \'1\')\n"
"{\n"
"declare uri varchar;\n"
"declare hf, hdr, charset any;\n"
"uri := pvalue;\n"
"if (uri like \'http://%\' and uri not like \'http://localdav.virt/%\' and uri not like \'http://local.virt/dav/%\')\n"
"{\n"
"query := http_get (uri, hdr);\n"
"if (hdr[0] not like \'% 200%\')\n"
"signal (\'22023\', concat (\'HTTP request failed: \', hdr[0], \'for URI \', uri));\n"
"charset := http_request_header (hdr, \'Content-Type\', \'charset\', \'\');\n"
"if (charset <> \'\')\n"
"{\n"
"query := charset_recode (query, charset, \'UTF-8\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"query := DB.DBA.XML_URI_GET (\'\', pvalue);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'403\', \'Prohibited\', query, \'22023\', \'The external query sources are prohibited.\');\n"
"return;\n"
"}\n"
"}\n"
"else if (\'xslt-uri\' = pname and length (pvalue))\n"
"{\n"
"if (virtuoso_ini_item_value (\'SPARQL\', \'ExternalXsltSource\') = \'1\')\n"
"{\n"
"add_http_headers := 0;\n"
"http_xslt (pvalue);\n"
"}\n"
"else\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'403\', \'Prohibited\', query, \'22023\', \'The XSL-T transformation is prohibited\');\n"
"return;\n"
"}\n"
"}\n"
"else if (\'get-login\' = pname)\n"
"{\n"
"get_user := pvalue;\n"
"}\n"
"else if (\'callback\' = pname)\n"
"{\n"
"jsonp_callback := pvalue;\n"
"}\n"
"else if (pname[0] = \'?\'[0])\n"
"{\n"
"dict_put (qry_params, subseq (pname, 1), pvalue);\n"
"}\n"
"else if (\'debug\' = pname)\n"
"{\n"
"debug := pvalue;\n"
"}\n"
"}\n"
"if (format <> \'\')\n"
"{\n"
"format := (\n"
"case lower(format)\n"
"when \'json\' then \'application/sparql-results+json\'\n"
"when \'js\' then \'application/javascript\'\n"
"when \'html\' then \'text/html\'\n"
"when \'sparql\' then \'application/sparql-results+xml\'\n"
"when \'xml\' then \'application/sparql-results+xml\'\n"
"when \'rdf\' then \'application/rdf+xml\'\n"
"when \'n3\' then \'text/rdf+n3\'\n"
"when \'ttl\' then \'text/turtle\'\n"
"when \'turtle\' then \'text/turtle\'\n"
"when \'cxml\' then \'text/cxml\'\n"
"when \'cxml+qrcode\' then \'text/cxml+qrcode\'\n"
"when \'csv\' then \'text/csv\'\n"
"else format\n"
"end);\n"
"}\n"
"\n"
"if (def_max > 0 and def_max < maxrows)\n"
"maxrows := def_max;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (http_meth = \'POST\' and soap_ver > 0)\n"
"{\n"
"declare xt, dgs, ngs any;\n"
"declare soap_ns, spt_ns, ns_decl varchar;\n"
"soap_ns := DB.DBA.SPARQL_SOAP_NS (soap_ver);\n"
"spt_ns := DB.DBA.SPARQL_PT_NS ();\n"
"ns_decl := \'[ xmlns:soap=\"\'||soap_ns||\'\" xmlns:sp=\"\'||spt_ns||\'\" ] \';\n"
"content := http_body_read ();\n"
"if (__debug_mode)\n"
"dbg_printf (\'content=[%s]\', string_output_string (content));\n"
"xt := xtree_doc (content);\n"
"query := charset_recode (xpath_eval (ns_decl||\'string (/soap:Envelope/soap:Body/sp:query-request/query)\', xt), \'_WIDE_\', \'UTF-8\');\n"
"dgs := xpath_eval (ns_decl||\'/soap:Envelope/soap:Body/sp:query-request/default-graph-uri\', xt, 0);\n"
"ngs := xpath_eval (ns_decl||\'/soap:Envelope/soap:Body/sp:query-request/named-graph-uri\', xt, 0);\n"
"foreach (any frag in dgs) do\n"
"{\n"
"declare pvalue varchar;\n"
"pvalue := charset_recode (xpath_eval (\'string(.)\', frag), \'_WIDE_\', \'UTF-8\');\n"
"if (position (pvalue, dflt_graphs) <= 0)\n"
"dflt_graphs := vector_concat (dflt_graphs, vector (pvalue));\n"
"}\n"
"foreach (any frag in ngs) do\n"
"{\n"
"declare pvalue varchar;\n"
"pvalue := charset_recode (xpath_eval (\'string(.)\', frag), \'_WIDE_\', \'UTF-8\');\n"
"if (position (pvalue, named_graphs) <= 0)\n"
"named_graphs := vector_concat (named_graphs, vector (pvalue));\n"
"}\n"
"format := sprintf(\'application/soap+xml;%d\', soap_ver);\n"
"}\n"
"if (format <> \'\')\n"
"accept := format;\n"
"else\n"
"accept := http_request_header (lines, \'Accept\', null, \'\');\n"
"if (sp_ini)\n"
"{\n"
"SPARQL_INI_PARAMS (metas, rset);\n"
"goto write_results;\n"
"}\n"
"\n"
"if (query is null)\n"
"{\n"
"if (strstr (content_type, \'application/xml\') is not null)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'XML notation of SPARQL queries is not supported\' );\n"
"return;\n"
"}\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"query, \'22023\', \'The request does not contain text of SPARQL query\', format);\n"
"return;\n"
"}\n"
"\n"
"full_query := query;\n"
"\n"
"declare req_hosts varchar;\n"
"declare req_hosts_split any;\n"
"declare hctr integer;\n"
"req_hosts := http_request_header (lines, \'Host\', null, null);\n"
"req_hosts := replace (req_hosts, \', \', \',\');\n"
"req_hosts_split := split_and_decode (req_hosts, 0, \'\\0\\0,\');\n"
"for (hctr := length (req_hosts_split) - 1; hctr >= 0; hctr := hctr - 1)\n"
"{\n"
"for (select top 1 SH_GRAPH_URI, SH_DEFINES from DB.DBA.SYS_SPARQL_HOST\n"
"where req_hosts_split [hctr] like SH_HOST) do\n"
"{\n"
"if (length (dflt_graphs) = 0 and length (SH_GRAPH_URI))\n"
"dflt_graphs := vector (SH_GRAPH_URI);\n"
"if (SH_DEFINES is not null)\n"
"full_query := concat (SH_DEFINES, \' \', full_query);\n"
"goto host_found;\n"
"}\n"
"}\n"
"host_found:\n"
"\n"
"foreach (varchar dg in dflt_graphs) do\n"
"{\n"
"full_query := concat (\'define input:default-graph-uri <\', dg, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-default-graph: %s\\r\\n\', dg));\n"
"}\n"
"foreach (varchar ng in named_graphs) do\n"
"{\n"
"full_query := concat (\'define input:named-graph-uri <\', ng, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-named-graph: %s\\r\\n\', ng));\n"
"}\n"
"foreach (varchar dg in using_graphs) do\n"
"{\n"
"full_query := concat (\'define input:using-graph-uri <\', dg, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-using-graph: %s\\r\\n\', dg));\n"
"}\n"
"foreach (varchar ng in using_named_graphs) do\n"
"{\n"
"full_query := concat (\'define input:using-named-graph-uri <\', ng, \'> \', full_query);\n"
"http_header (http_header_get () || sprintf (\'X-SPARQL-using-named-graph: %s\\r\\n\', ng));\n"
"}\n"
"if ((should_sponge = \'soft\') or (should_sponge = \'replacing\'))\n"
"full_query := concat (sprintf(\'define get:soft \"%s\" \',should_sponge), full_query);\n"
"else if (should_sponge = \'grab-all\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-depth 5 define input:grab-limit 100 \', full_query);\n"
"else if (should_sponge = \'grab-all-seealso\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-depth 5 define input:grab-limit 200 define input:grab-seealso <http://www.w3.org/2000/01/rdf-schema#seeAlso> define input:grab-seealso <http://xmlns.com/foaf/0.1/seeAlso> \', full_query);\n"
"else if (should_sponge = \'grab-everything\')\n"
"full_query := concat (\'define input:grab-all \"yes\" define input:grab-intermediate \"yes\" define input:grab-depth 5 define input:grab-limit 500 define input:grab-seealso <http://www.w3.org/2000/01/rdf-schema#seeAlso> define input:grab-seealso <http://xmlns.com/foaf/0.1/seeAlso> \', full_query);\n"
"\n"
"if (debug <> \'\')\n"
"full_query := concat (\'define sql:signal-void-variables 1 \', full_query);\n"
"if (get_user <> \'\')\n"
"full_query := concat (\'define get:login \"\', get_user, \'\" \', full_query);\n"
"if (dict_size (qry_params) > 0)\n"
"{\n"
"declare pnames any;\n"
"pnames := dict_list_keys (qry_params, 0);\n"
"foreach (varchar pname in pnames) do\n"
"{\n"
"full_query := concat (\'define sql:param \"\', pname, \'\" \', full_query);\n"
"}\n"
"qry_params := DB.DBA.PARSE_SPARQL_WS_PARAMS (dict_to_vector (qry_params, 1));\n"
"}\n"
"else\n"
"qry_params := vector ();\n"
"if (save_mode is not null and save_mode <> \'display\')\n"
"client_supports_partial_res := 0;\n"
"\n"
"if (format <> \'\')\n"
"{\n"
"full_query := \'\\n#output-format:\' || format || \'\\n\' || full_query;\n"
"}\n"
"if (not client_supports_partial_res)\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare fmtxml, fmtttl varchar;\n"
"if (strstr (accept, \'application/sparql-results+xml\') is not null)\n"
"fmtxml := \'\"HTTP+XML application/sparql-results+xml\" \';\n"
"if (strstr (accept, \'text/rdf+n3\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+n3\" \';\n"
"else if (strstr (accept, \'text/rdf+ttl\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+ttl\" \';\n"
"else if (strstr (accept, \'text/rdf+turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/rdf+turtle\" \';\n"
"else if (strstr (accept, \'text/turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL text/turtle\" \';\n"
"else if (strstr (accept, \'application/turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL application/turtle\" \';\n"
"else if (strstr (accept, \'application/x-turtle\') is not null)\n"
"fmtttl := \'\"HTTP+TTL application/x-turtle\" \';\n"
"if (isstring (fmtttl))\n"
"{\n"
"if (isstring (fmtxml))\n"
"full_query := \'define output:format \' || fmtxml || \'define output:dict-format \' || fmtttl || full_query;\n"
"else\n"
"full_query := \'define output:format \' || fmtttl || full_query;\n"
"}\n"
"\n"
" ;\n"
"}\n"
"\n"
"if (accept = \'application/atom+xml\' or accept = \'application/odata+json\')\n"
"{\n"
"full_query := \'define sql:describe-mode \"CBD\" \' || full_query;\n"
"}\n"
"\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"if (__debug_mode)\n"
"dbg_printf (\'query=[%s]\', full_query);\n"
"\n"
"declare sc_max int;\n"
"declare sc decimal;\n"
"sc_max := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxQueryCostEstimationTime\'), \'-1\'));\n"
"if (sc_max < 0)\n"
"sc_max := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxExecutionTime\'), \'-1\'));\n"
"if (sc_max > 0)\n"
"{\n"
"state := \'00000\';\n"
"full_query := concat (\'define sql:big-data-const 0 \', full_query);\n"
"sc := exec_score (concat (\'sparql { \', full_query, \'\\n}\'), state, msg);\n"
"if ((sc/1000) > sc_max)\n"
"{\n"
"signal (\'42000\', sprintf (\'The estimated execution time %d (sec) exceeds the limit of %d (sec).\', sc/1000, sc_max));\n"
"}\n"
"}\n"
"\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"commit work;\n"
"if (client_supports_partial_res and (timeout > 0))\n"
"{\n"
"set RESULT_TIMEOUT = timeout;\n"
"\n"
"set TRANSACTION_TIMEOUT=timeout + 10000;\n"
"}\n"
"else if (hard_timeout >= 1000)\n"
"{\n"
"set TRANSACTION_TIMEOUT=hard_timeout;\n"
"}\n"
"set_user_id (user_id, 1);\n"
"again:\n"
"state := \'00000\';\n"
"start_time := msec_time();\n"
"exec ( concat (\'sparql {\', full_query, \'\\n}\'), state, msg, qry_params, vector (\'max_rows\', maxrows, \'use_cache\', 1), metas, rset);\n"
"commit work;\n"
"\n"
"if (state = \'00000\')\n"
"goto write_results;\n"
"if (state = \'S1TAT\')\n"
"{\n"
"exec_time := msec_time () - start_time;\n"
"exec_db_activity := db_activity ();\n"
"\n"
"\n"
"\n"
"}\n"
"else if ((not http_is_flushed ()) and state = \'40001\' and deadl < 6)\n"
"{\n"
"declare dt int;\n"
"rollback work;\n"
"deadl := deadl + 1;\n"
"dt := ((rnd (5) + 1) / 10.0) * (2 * deadl);\n"
"delay (dt);\n"
"goto again;\n"
"}\n"
"else\n"
"{\n"
"declare state2, msg2 varchar;\n"
"state2 := \'00000\';\n"
"exec (\'isnull (sparql_to_sql_text (\'\'{ define sql:big-data-const 0 \'\' || ? || \'\'\\\\n}\'\'))\', state2, msg2, vector (full_query));\n"
"if (state2 <> \'00000\')\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'400\', \'Bad Request\',\n"
"full_query, state2, msg2, format);\n"
"return;\n"
"}\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, state, msg, format);\n"
"return;\n"
"}\n"
"\n"
"write_results:\n"
"if (save_mode is not null)\n"
"{\n"
"declare status any;\n"
"if ((1 = length (metas[0])) and (\'aggret-0\' = metas[0][0][0]))\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, \'00000\', \'The result of the query can not be saved to a DAV resource\', format);\n"
"return;\n"
"}\n"
"}\n"
"if ((1 <> length (metas[0])) or (\'aggret-0\' <> metas[0][0][0]))\n"
"{\n"
"declare status any;\n"
"if (isinteger (msg))\n"
"status := NULL;\n"
"else\n"
"status := vector (state, msg, exec_time, exec_db_activity);\n"
"if (save_mode is not null)\n"
"{\n"
"if ((not isinteger (save_dir_id)) or not exists (select top 1 1 from WS.WS.SYS_DAV_COL where COL_ID = save_dir_id and COL_DET=\'DynaRes\'))\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, \'00000\', sprintf (\'To keep saved SPARQL results, the DAV directory \"%.200s\" should be of DAV extension type \"DynaRes\"\', save_dir), format);\n"
"return;\n"
"}\n"
"if (fname is not null)\n"
"{\n"
"if (strchr (fname, \'/\') is not null)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, \'00000\', sprintf (\'The specified resource name \"%.200s\" contains illegal characters\', fname), format);\n"
"return;\n"
"}\n"
"}\n"
"ses := string_output ();\n"
"add_http_headers := 0;\n"
"}\n"
"if (isstring (jsonp_callback))\n"
"http (jsonp_callback || \'(\\n\', ses);\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, metas, rset, accept, add_http_headers, status);\n"
"if (isstring (jsonp_callback))\n"
"http (\')\', ses);\n"
"if (save_mode is not null)\n"
"{\n"
"declare sparql_uid integer;\n"
"declare refresh_sec, ttl_sec integer;\n"
"declare full_uri varchar;\n"
"sparql_uid := (SELECT COL_OWNER from WS.WS.SYS_DAV_COL where COL_ID = save_dir_id);\n"
"if (fname is null)\n"
"{\n"
"if (save_mode = \'tmpstatic\')\n"
"fname := sprintf (\'%.100s - SPARQL result - made by %.100s\', cast (now() as varchar), user_id);\n"
"else\n"
"fname := sprintf (\'%.100s - cached and renewable SPARQL result - made by %.100s\', cast (now() as varchar), user_id);\n"
"}\n"
"refresh_sec := case (save_mode) when \'tmpstatic\' then null else __max (600, coalesce (hard_timeout, 1000)/100) end;\n"
"ttl_sec := 172800;\n"
"full_uri := concat (\'http://\', registry_get (\'URIQADefaultHost\'), DAV_SEARCH_PATH (save_dir_id, \'C\'), fname);\n"
"\"DynaRes_INSERT_RESOURCE\" (\n"
"detcol_id => save_dir_id,\n"
"fname => fname,\n"
"owner_uid => sparql_uid,\n"
"refresh_seconds => refresh_sec,\n"
"ttl_seconds => ttl_sec,\n"
"mime => accept,\n"
"exec_stmt => \'DB.DBA.SPARQL_REFRESH_DYNARES_RESULTS (?, ?, ?, ?, ?, ?, ?)\',\n"
"exec_params => vector (full_query, qry_params, maxrows, accept, user_id, hard_timeout, jsonp_callback),\n"
"exec_uname => user_id,\n"
"content => ses\n"
");\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"http (\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(\'Virtuoso SPARQL Query Editor | Save to DAV\');\n"
"WS.WS.SPARQL_ENDPOINT_STYLE();\n"
"http (\'</head>\\n\');\n"
"http (\'<body>\\n\');\n"
"http (\'    <div id=\"header\">\\n\');\n"
"http (\'	<h1 id=\"title\">Virtuoso SPARQL Query Editor</h1>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"http (\'<h3>Saved to DAV</h3>\');\n"
"http (\'<p>The SPARQL result is successfully saved in DAV storage as <a href=\"\');\n"
"http_value (full_uri);\n"
"http (\'\">\');\n"
"http_value (full_uri);\n"
"http (\'</a></p>\');\n"
"if (refresh_sec is not null)\n"
"http (sprintf (\'<p>The content of the linked resource will be re-calculated on demand, and the result will be cached for %d minutes.</p>\', refresh_sec/60));\n"
"if (ttl_sec is not null)\n"
"http (sprintf (\'<p>The link will stay valid for %d days. To preserve the referenced document for future use, copy it to some other location before expiration.</p>\', ttl_sec/(60*60*24)));\n"
"if (accept <> \'text/html\')\n"
"http (sprintf (\'<p>The resource MIME type is \"%s\". This type will be reported to the browser when you click on the link.\n"
"If the browser is unable to open the link itself it can prompt for action like launching an additional program.\n"
"The program may let you edit the loaded resource, in this case save the changed version should be saved to a different place, so use \"Save As\" command, not plain \"Save\".</p>\', accept));\n"
"http (\'</body></html>\');\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (save_mode is not null)\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'SPARQL Request Failed\',\n"
"full_query, \'00000\', \'The result of the query can not be saved to a DAV resource\', format);\n"
"return;\n"
"}\n"
"}\n"
"return;\n"
"\n"
"brief_help:\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"\n"
"http(\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(\'Virtuoso SPARQL Query Editor | About\');\n"
"WS.WS.SPARQL_ENDPOINT_STYLE ();\n"
"http(\'</head>\\n\');\n"
"\n"
"http(\'<body>\\n\');\n"
"http (\'    <div id=\"header\">\\n\');\n"
"http(\'	<h1 id=\"title\">Virtuoso SPARQL Query Editor | About</h1>\\n\');\n"
"http (\'    </div>\\n\\n\');\n"
"\n"
"http (\'    <div id=\"help\">\\n\');\n"
"if (help_topic=\'intro\')\n"
"{\n"
"http(\'<h3>Intro</h3>\');\n"
"http(\'	<p>This page is designed to help you test the OpenLink Virtuoso SPARQL protocol endpoint.<br/>\\n\');\n"
"http(\'	Consult the <a href=\"http://virtuoso.openlinksw.com/wiki/main/Main/VOSSparqlProtocol\">Virtuoso Wiki page</a> describing the service \\n\');\n"
"http(\'	or the <a href=\"http://docs.openlinksw.com/virtuoso/\">Online Virtuoso Documentation</a> section <a href=\"http://docs.openlinksw.com/virtuoso/rdfandsparql.html\">RDF Database and SPARQL</a>.</p>\\n\');\n"
"http(\'	<p>There is also a rich Web based user interface with sample queries. \\n\');\n"
"if (DB.DBA.VAD_CHECK_VERSION(\'iSPARQL\') is null)\n"
"http(\'	In order to use it you must install the iSPARQL package (isparql_dav.vad).</p>\\n\');\n"
"else\n"
"http(\'	You can access it at: <a href=\"/isparql\">/isparql</a>.</p>\\n\');\n"
"http(\'	<p>For your convenience we have a set of <a href=\"/sparql?nsdecl\">predefined name space prefixes</a> and <a href=\"/sparql?rdfinf\">inference rules</a></p>\\n\');\n"
"\n"
"http(\'	<h3>What is SPARQL?</h3>\\n\');\n"
"http(\'	<p>SPARQL is the W3C\'\'s declaritive query-language for Graph Model Databases and Stores.</p>\\n\');\n"
"http(\'    <p>As is the case with regards to SQL for relational databases and XQUERY for XML databases, \');\n"
"http(\'    SPARQL is database and host operating system independent.<p>\\n\');\n"
"http(\'	<p>The development and evolution of this standard is overseen by the\\n\');\n"
"http(\'	<a href=\"http://www.w3.org/2009/sparql/wiki/Main_Page\">SPARQL Working Group</a> within W3C and\\n\');\n"
"http(\'	while parts of the language are still in active <a href=\"http://www.w3.org/TR/2011/WD-sparql11-query-20110512/\">development</a>, it is fully <a href=\"http://www.w3.org/TR/rdf-sparql-query/\">documented</a> and <a href=\"http://www.w3.org/2009/05/sparql-phase-II-charter\">publicly</a> available.</p>\\n\');\n"
"}\n"
"else if (help_topic=\'enable_sponge\')\n"
"{\n"
"declare host_ur varchar;\n"
"host_ur := registry_get (\'URIQADefaultHost\');\n"
"host_ur := http_request_header (lines, \'Host\', null, host_ur);\n"
"http(\'<h3>How To Enable Sponge?</h3>\n"
"<p>When a new Virtuoso server is installed, the default security restrictions do not allow SPARQL endpoint users to retrieve remote RDF data.\n"
"To remove this restriction, the DBA should grant \"SPARQL_SPONGE\" privilege to \"SPARQL\" account.\n"
"If you are the Database Administrator and want to enable this feature, you can perform the following steps:</p>\\n\');\n"
"http(\'<ol>\\n\');\n"
"http(\'<li>Go to the Virtuoso Administration Conductor i.e. \\n\');\n"
"if (not isstring (host_ur))\n"
"http(\'http://host:port/conductor .\');\n"
"else\n"
"http( sprintf(\'<a href=\"http://%s/conductor\">http://%s/conductor</a>.\', host_ur, host_ur));\n"
"http(\'</li>\\n\');\n"
"http(\'<li>Login as dba user.</li>\\n\');\n"
"http(\'<li>Go to System Admin->User Accounts->Roles</li>\\n\');\n"
"http(\'<li>Click the link \"Edit\" for \"SPARQL_SPONGE\"</li>\\n\');\n"
"http(\'<li>Select from the list of available user/groups \"SPARQL\" and click the \">>\" button so to add it to the right-positioned list.\\n</li>\');\n"
"http(\'<li>Click the button \"Update\"</li>\\n\');\n"
"http(\'<li>Access again the sparql endpoint in order to be able to retrieve remote data.</li>\\n\');\n"
"http(\'</ol>\\n\');\n"
"}\n"
"else if (help_topic=\'enable_cxml\')\n"
"{\n"
"http(\'<h3>How To Enable CXML Support</h3>\');\n"
"http(\'<p>CXML is data exchange format for so-called \"faceted view\". It can be displayed by programs like Microsoft Pivot.</p>\');\n"
"http(\'<p>For best results, the result of the query should contain links to images associated with described data and follow some rules, described in the User&apos;s Guide.</p>\');\n"
"http(\'<p>This feature is supported by combination of four components:</p>\\n\');\n"
"http(\'<ol>\\n\');\n"
"http(\'<li>The Virtuoso Universal Server (Virtuoso Open Source does not contain some required functions)</li>\\n\');\n"
"http(\'<li>The ImageMagick plugin (version 0.6 or newer) and optionally the QRcode plugin</li>\\n\');\n"
"http(\'<li>The QRcode plugin (version 0.1 or newer)</li>\\n\');\n"
"http(\'<li>The sparql_cxml VAD package (which in turn requires the &quot;RDF mappers&quot; package)</li>\\n\');\n"
"http(\'</ol>\\n\');\n"
"http(\'<p>As soon as all these components are installed, the SPARQL web service endpoint will add the &quot;CXML&quot; option to the list of available formats.</p>\\n\');\n"
"}\n"
"else if (help_topic=\'enable_det\')\n"
"{\n"
"http(\'<h3>How To Let the SPARQL Endpoint Save Results In WebDAV?</h3>\');\n"
"http(\'<p>By default, the SPARQL endpoint can only sent the result back to the client. This can be inconvenient if the result should be accessible for programs like file managers and archivers.</p>\');\n"
"http(\'<p>The solution is to let the endpoint create &quot;dynamic&quot;resources in a WebDAV folder on the Virtuoso server. A WebDAV client, e.g. the built-in client of Windows Explorer, can connect to that storage and access these resources as if they are plain local files.</p>\');\n"
"http(\'<p>If you are the Database Administrator and want to enable this feature, you can perform the following steps:</p>\\n\');\n"
"http(\'<ol>\\n\');\n"
"http( sprintf(\'<li>This web service endpoint runs under the &quot;%.100s&quot; account. This user should have an access to WebDAV (U_DAV_ENABLE=1 in DB.DBA.SYS_USERS)</li>\\n\', user_id));\n"
"http( sprintf(\'<li>A WebDAV home directory (e.g. <a href=\"/DAV/home/%.100s/\">/DAV/home/%.100s/</a>) should be created and the path to it should be remembered in DB.DBA.SYS_USERS (U_HOME) field;<br />(do not forget the leading and the trailing slash chars).</li>\\n\', user_id, user_id));\n"
"http( sprintf(\'<li>This home directory should contain a subdirectory named &quot;saved-sparql-results&quot;, and the subdirectory should be of &quot;DynaRes&quot; DAV Extension Type.</li>\\n\'));\n"
"http(\'</ol>\\n\');\n"
"http(\'<p>As soon as the appropriate directory exists, the SPARQL web service endpoint will show additional controls to choose how to save results.</p>\\n\');\n"
"}\n"
"else if (help_topic=\'enable_det\')\n"
"{\n"
"DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT (path, params, lines,\n"
"\'500\', \'Request Failed\',\n"
"\'Invalid help topic\', format);\n"
"}\n"
"http(\'\');\n"
"http(\'<p>To close this help, press \');\n"
"http (\'<button type=\"button\" name=\"back\" value=\"Back\" onclick=\"javascript:history.go(-1);\">Back</button>\\n\');\n"
"http(\' or use the &quot;back&quot; button of the browser.</p>\\n\');\n"
"http(\'</div>\\n\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_FOOTER();\n"
"http(\'</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"}\n"
"--src sparql_io.sql:2828\n";

static const char *other47 = 
"registry_set (\'/!sparql/\', \'no_vsp_recompile\')\n";
static const char *proc460 = 
"#line 3679 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BLANK (inout g_iid IRI_ID, inout app_env any, inout res IRI_ID)\n"
"{\n"
"res := min_bnode_iri_id ();\n"
"}\n"
"--src sparql_io.sql:3677\n";

static const char *proc461 = 
"#line 3686 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"signal (\'22023\', \'The graph URI is relative and can not be resolved using the submitted resource (base should be declared before data for the first triple)\');\n"
"}\n"
"--src sparql_io.sql:3684\n";

static const char *proc462 = 
"#line 3696 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE_L (\n"
"inout g_iid IRI_ID, inout s_uri varchar, inout p_uri varchar,\n"
"inout o_val any, inout o_type varchar, inout o_lang varchar,\n"
"inout app_env any )\n"
"{\n"
"signal (\'22023\', \'The graph URI is relative and can not be resolved using the submitted resource (base should be declared before data for the first triple)\');\n"
"}\n"
"--src sparql_io.sql:3694\n";

static const char *proc463 = 
"#line 3706 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BASE (\n"
"inout base_uri varchar,\n"
"inout graph_uri varchar,\n"
"inout app_env any )\n"
"{\n"
"app_env[0] := DB.DBA.XML_URI_RESOLVE_LIKE_GET (base_uri, graph_uri);\n"
"signal (\'ok001\', \'\');\n"
"}\n"
"--src sparql_io.sql:3704\n";

static const char *proc464 = 
"#line 3717 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_TTL (inout strg any, in graph_uri varchar, in flags integer := 255)\n"
"{\n"
"declare app_env any;\n"
"if (126 = __tag (strg))\n"
"strg := cast (strg as varchar);\n"
"app_env := vector (null);\n"
"whenever sqlstate \'ok001\' goto done;\n"
"rdf_load_turtle (strg, \'\', graph_uri, flags,\n"
"vector (\n"
"\'\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE_L\',\n"
"\'\',\n"
"\'\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BASE\' ),\n"
"app_env);\n"
"done:\n"
"return app_env[0];\n"
"}\n"
"--src sparql_io.sql:3715\n";

static const char *proc465 = 
"#line 3741 \"[executable]/sparql_io.sql\"\n"
" create procedure DB.DBA.SPARQL_CRUD_BASE_RDFXML (in strg any, in graph_uri varchar)\n"
"{\n"
"declare app_env any;\n"
"app_env := vector (null);\n"
"whenever sqlstate \'ok001\' goto done;\n"
"rdf_load_rdfxml (strg, 0,\n"
"graph_uri,\n"
"vector (\n"
"\'\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BLANK\',\n"
"\'DB.DBA.TTLP_EV_GET_IID\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE_L\',\n"
"\'\',\n"
"\'\',\n"
"\'DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BASE\' ),\n"
"app_env );\n"
"done:\n"
"return app_env[0];\n"
"}\n"
"--src sparql_io.sql:3739\n";

static const char *proc466 = 
"#line 3763 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.\"/!sparql-graph-crud/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare user_id varchar;\n"
"declare reqbegin varchar;\n"
"declare graph_uri varchar;\n"
"declare graph_uri_is_relative integer;\n"
"\n"
"\n"
"\n"
"\n"
"set http_charset=\'utf-8\';\n"
"user_id := connection_get (\'SPARQLUserId\', \'SPARQL\');\n"
"reqbegin := lines[0];\n"
"graph_uri := trim(coalesce (get_keyword (\'graph\', params, null), get_keyword (\'graph-uri\', params, null), \'\'));\n"
"if (isstring (get_keyword (\'default\', params)))\n"
"{\n"
"declare req_hosts varchar;\n"
"declare req_hosts_split any;\n"
"declare hctr integer;\n"
"if (graph_uri <> \'\')\n"
"signal (\'22023\', \'The request to SPARQL 1.1 Graph Store endpoint contains both \"graph\" and \"default\" params\');\n"
"req_hosts := http_request_header (lines, \'Host\', null, null);\n"
"req_hosts := replace (req_hosts, \', \', \',\');\n"
"req_hosts_split := split_and_decode (req_hosts, 0, \'\\0\\0,\');\n"
"for (hctr := length (req_hosts_split) - 1; hctr >= 0; hctr := hctr - 1)\n"
"{\n"
"for (select top 1 SH_GRAPH_URI, SH_DEFINES from DB.DBA.SYS_SPARQL_HOST\n"
"where req_hosts_split [hctr] like SH_HOST) do\n"
"{\n"
"if (length (SH_GRAPH_URI))\n"
"{\n"
"graph_uri := SH_GRAPH_URI;\n"
"goto good_host_found;\n"
"}\n"
"goto bad_host_found;\n"
"}\n"
"}\n"
"bad_host_found:\n"
"signal (\'22023\', \'The request to SPARQL 1.1 Graph Store endpoint contains \"default\" param but the endpoint is not configured to have default graph\');\n"
"good_host_found:\n"
" ;\n"
"}\n"
"if (graph_uri <> \'\')\n"
"goto graph_processing;\n"
"http_methods_set (\'GET\', \'HEAD\', \'POST\', \'PUT\', \'DELETE\', \'PATCH\');\n"
"\n"
"WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE();\n"
"\n"
"http(\'<head>\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_HTML_HEAD(\'Virtuoso SPARQL 1.1 Uniform RDF Graph Query Form\');\n"
"WS.WS.SPARQL_ENDPOINT_STYLE ();\n"
"http(\'</head>\\n\');\n"
"\n"
"http(\'<body>\\n\');\n"
"http(\'    <div id=\"header\">\\n\');\n"
"http(\'	<h1>Virtuoso SPARQL 1.1 Uniform RDF Graph Query Form</h1>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"http(\'    <div id=\"intro\">\\n\');\n"
"http(\'	<p>This page is designed to help you test support for <a href=\"http://www.w3.org/TR/sparql11-http-rdf-update\">SPARQL 1.1 Graph Store HTTP Protocol</a> in OpenLink Virtuoso.</p>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"http(\'    <div id=\"main\">\\n\');\n"
"http(\'	<form action=\"\" method=\"post\" enctype=\"multipart/form-data\">\\n\');\n"
"http(\'	<fieldset>\\n\');\n"
"http(\'		<label for=\"graph-uri\">Graph URI</label>\\n\');\n"
"http(\'		<br />\\n\');\n"
"http(\'		<input type=\"text\" name=\"graph-uri\" id=\"graph-uri\" \');\n"
"http(sprintf (\'value=\"%s\" size=\"80\"/>\\n\', coalesce (\'\')));\n"
"http(\'		<br /><br />\\n\');\n"
"http(\'		<label for=\"res-file\">File to upload</label>\\n\');\n"
"http(\'		<br />\\n\');\n"
"http(\'		<input type=\"file\" name=\"res-file\" id=\"res-file\"/>\\n\');\n"
"http(\'		<br /><br />\\n\');\n"
"http(\'		<input type=\"submit\" value=\"Upload the resource\"/>\');\n"
"http(\'	</fieldset>\\n\');\n"
"http(\'	</form>\\n\');\n"
"http(\'    </div>\\n\\n\');\n"
"WS.WS.SPARQL_ENDPOINT_FOOTER();\n"
"http(\'</body>\\n\');\n"
"http(\'</html>\\n\');\n"
"return;\n"
"graph_processing:\n"
"commit work;\n"
"graph_uri_is_relative := neq (graph_uri, DB.DBA.XML_URI_RESOLVE_LIKE_GET (\'zZz://example.com/\', graph_uri));\n"
"if (graph_uri_is_relative)\n"
"{\n"
"if (not (reqbegin like \'PUT%\') and not (reqbegin like \'POST%\'))\n"
"signal (\'22023\', \'The graph URI <\' || graph_uri || \'> is relative and can be passed to SPARQL 1.1 Graph Store endpoint only in some PUT or POST requests\');\n"
"}\n"
"if ((reqbegin like \'PUT%\') or (reqbegin like \'POST%\'))\n"
"{\n"
"declare res_file, res_content_type varchar;\n"
"declare full_graph_uri varchar;\n"
"declare graph_exists integer;\n"
"set_user_id (user_id, 1);\n"
"res_file := get_keyword (\'res-file\', params, \'\');\n"
"\n"
"if (0 = length (res_file))\n"
"res_file := get_keyword (\'Content\', params, \'\');\n"
"\n"
"if (0 = length (res_file))\n"
"res_file := http_body_read();\n"
"\n"
"if (0 = length (res_file))\n"
"res_file := http_body_read(1);\n"
"\n"
"res_content_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (null, null, res_file);\n"
"\n"
"if (graph_uri_is_relative)\n"
"{\n"
"full_graph_uri := null;\n"
"if (res_content_type in (\'text/rdf+n3\', \'text/turtle\'))\n"
"full_graph_uri := DB.DBA.SPARQL_CRUD_BASE_TTL (res_file, graph_uri, 255);\n"
"else if (res_content_type = \'application/rdf+xml\')\n"
"full_graph_uri := DB.DBA.SPARQL_CRUD_BASE_RDFXML (res_file, graph_uri);\n"
"else\n"
"signal (\'22023\', \'The graph URI <\' || graph_uri || \'> is relative and can not be resolved using the submitted resource of unsupported type \' || coalesce (res_content_type, \'\'));\n"
"if (full_graph_uri is null)\n"
"signal (\'22023\', \'The graph URI <\' || graph_uri || \'> is relative and can not be resolved using the submitted resource (resource does not contain any base)\');\n"
"}\n"
"else\n"
"full_graph_uri := graph_uri;\n"
"commit work;\n"
"graph_exists := (sparql define input:storage \"\" ask where { graph `iri(?:full_graph_uri)` { ?s ?p ?o }});\n"
"if (res_content_type in (\'text/rdf+n3\', \'text/turtle\'))\n"
"{\n"
"if (reqbegin like \'PUT%\')\n"
"{\n"
"sparql clear graph ?:full_graph_uri;\n"
"commit work;\n"
"}\n"
"DB.DBA.TTLP (res_file, full_graph_uri, full_graph_uri);\n"
"}\n"
"else if (res_content_type = \'application/rdf+xml\')\n"
"{\n"
"if (reqbegin like \'PUT%\')\n"
"{\n"
"sparql clear graph ?:full_graph_uri;\n"
"commit work;\n"
"}\n"
"DB.DBA.RDF_LOAD_RDFXML (res_file, full_graph_uri, full_graph_uri);\n"
"}\n"
"else if (res_content_type = \'text/microdata+html\')\n"
"{\n"
"if (reqbegin like \'PUT%\')\n"
"{\n"
"sparql clear graph ?:full_graph_uri;\n"
"commit work;\n"
"}\n"
"DB.DBA.RDF_LOAD_XHTML_MICRODATA (res_file, full_graph_uri /* base */, full_graph_uri /* dest graph */);\n"
"}\n"
"else if (res_content_type = \'application/xhtml+xml\')\n"
"{\n"
"if (reqbegin like \'PUT%\')\n"
"{\n"
"sparql clear graph ?:full_graph_uri;\n"
"commit work;\n"
"}\n"
"DB.DBA.RDF_LOAD_RDFA (res_file, full_graph_uri /* base */, full_graph_uri /* dest graph */);\n"
"}\n"
"else\n"
"signal (\'22023\', \'The PUT request for graph <\' || full_graph_uri || \'> is rejected: the submitted resource is of unsupported type \' || coalesce (res_content_type, \'\'));\n"
"if (graph_exists is null)\n"
"http_request_status (\'HTTP/1.1 201 Created\');\n"
"else if (length (res_file) <= 2)\n"
"http_request_status (\'HTTP/1.1 204 No Content\');\n"
"return;\n"
"}\n"
"else if (reqbegin like \'DELETE%\')\n"
"{\n"
"set_user_id (user_id, 1);\n"
"if (not (exists (sparql define input:storage \"\" select (1) where { graph `iri(?:graph_uri)` { ?s ?p ?o }})))\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"sparql clear graph ?:graph_uri;\n"
"commit work;\n"
"return;\n"
"}\n"
"else if (reqbegin like \'GET%\')\n"
"{\n"
"if (not (exists (sparql define input:storage \"\" select (1) where { graph `iri(?:graph_uri)` { ?s ?p ?o }})))\n"
"{\n"
"http_request_status (\'HTTP/1.1 404 Not Found\');\n"
"return;\n"
"}\n"
"connection_set (\'SPARQL_crud_graph\', graph_uri);\n"
"WS.WS.\"/!sparql/\" (path,\n"
"vector_concat (\n"
"vector (\'query\', \'define input:storage \"\" construct { ?s ?p ?o } where { graph `iri(bif:connection_get(\"SPARQL_crud_graph\"))` { ?s ?p ?o }}\'),\n"
"params ), lines);\n"
"return;\n"
"}\n"
"else\n"
"{\n"
"http_request_status (\'HTTP/1.1 501 Method Not Implemented\');\n"
"return;\n"
"}\n"
"}\n"
"--src sparql_io.sql:3761\n";

static const char *other48 = 
"registry_set (\'/!sparql-graph-crud/\', \'no_vsp_recompile\')\n";
static const char *proc467 = 
"#line 3968 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_REFRESH_DYNARES_RESULTS (in full_query varchar, in qry_params any, in maxrows integer, in accept varchar, in user_id varchar, in hard_timeout integer, in jsonp_callback any)\n"
"{\n"
"\n"
"declare state, msg varchar;\n"
"declare metas, rset any;\n"
"declare RES any;\n"
"declare ses any;\n"
"result_names (RES);\n"
"set_user_id (user_id, 1);\n"
"if (hard_timeout >= 1000)\n"
"set TRANSACTION_TIMEOUT = hard_timeout;\n"
"set_user_id (user_id);\n"
"state := \'00000\';\n"
"exec ( concat (\'sparql \', full_query), state, msg, qry_params, vector (\'max_rows\', maxrows, \'use_cache\', 1), metas, rset);\n"
"commit work;\n"
"\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"ses := string_output ();\n"
"if (isstring (jsonp_callback))\n"
"http (jsonp_callback || \'(\\n\', ses);\n"
"DB.DBA.SPARQL_RESULTS_WRITE (ses, metas, rset, accept, 0, null);\n"
"if (isstring (jsonp_callback))\n"
"http (\')\', ses);\n"
"result (ses);\n"
"}\n"
"--src sparql_io.sql:3966\n";

static const char *proc468 = 
"#line 3999 \"[executable]/sparql_io.sql\"\n"
" create function DB.DBA.SPARQL_ROUTE_IF_DAV (in graph_iri varchar, in output_format_name varchar)\n"
"{\n"
"\n"
"\n"
"if (graph_iri like \'http://local.virt/DAV/%\')\n"
"return subseq (graph_iri, 17);\n"
"return NULL;\n"
"}\n"
"--src sparql_io.sql:3997\n";

static const char *proc469 = 
"#line 4009 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV (\n"
"in graph_iri varchar,\n"
"in opname varchar,\n"
"in storage_name varchar,\n"
"in output_storage_name varchar,\n"
"in output_format_name varchar,\n"
"in del_dict any,\n"
"in ins_dict any,\n"
"in env any,\n"
"in uid varchar,\n"
"in log_mode integer,\n"
"in compose_report integer )\n"
"{\n"
"declare split, in_mime, mime, perr, fake_content varchar;\n"
"declare final_res, triples, out_ses, rc any;\n"
"declare old_perms, pwd varchar;\n"
"declare old_gid, old_uid any;\n"
"declare dir any;\n"
"split := DB.DBA.SPARQL_ROUTE_IF_DAV (graph_iri, output_format_name);\n"
"\n"
"if (\'dba\' = uid)\n"
"uid := \'dav\';\n"
"pwd := (select pwd_magic_calc (U_NAME, U_PASSWORD, 1) from SYS_USERS where U_NAME=uid);\n"
"\n"
"if (split is not null)\n"
"{\n"
"dir := DAV_DIR_LIST (split, 0, uid, pwd);\n"
"if (isinteger (dir) and (0 > dir))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not get DAV directory info about \"%.200s\": %s\', opname, split, DB.DBA.DAV_PERROR (dir)));\n"
"if (1 = length (dir))\n"
"{\n"
"if (\'c\' = dir[0][1])\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not edit \"%.200s\": it is collection, not a resource\', opname, split));\n"
"old_perms := dir[0][5];\n"
"old_gid := dir[0][6];\n"
"old_uid := dir[0][7];\n"
"in_mime := dir[0][9];\n"
"}\n"
"else\n"
"signal (\'RDFXX\', sprintf (\'SPARUL %s can not edit \"%.200s\": can not get directory listing with it\', opname, split));\n"
"fake_content := null;\n"
"mime := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (graph_iri, in_mime, fake_content);\n"
"if (\'application/rdf+xml\' = mime)\n"
"{\n"
"if ((output_format_name is not null) and (output_format_name <> \'AUTO\') and (output_format_name <> \'RDF/XML\'))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" because its MIME type \"%s\" conflicts with directive output:format \"%s\"\', graph_iri, coalesce (in_mime, mime), output_format_name));\n"
"}\n"
"else if (mime in (\'text/rdf+n3\', \'text/turtle\'))\n"
"{\n"
"if ((output_format_name is not null) and (output_format_name <> \'AUTO\') and (output_format_name <> \'TURTLE\') and (output_format_name <> \'TTL\'))\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" because its MIME type \"%s\" conflicts with directive output:format \"%s\"\', graph_iri, coalesce (in_mime, mime), output_format_name));\n"
"}\n"
"else\n"
"signal (\'RDFXX\', sprintf (\'SPARUL can not update resource \"%.200s\" of MIME type \"%s\" because only \"application/rdf+xml\", \"text/rdf+n3\" and  \"text/turtle\" are supported\', graph_iri, coalesce (in_mime, mime)));\n"
"}\n"
"if (\'INSERT\' = opname)\n"
"final_res := DB.DBA.SPARQL_INSERT_DICT_CONTENT (graph_iri, ins_dict, uid, log_mode, compose_report);\n"
"else if (\'DELETE\' = opname)\n"
"final_res := DB.DBA.SPARQL_DELETE_DICT_CONTENT (graph_iri, del_dict, uid, log_mode, compose_report);\n"
"else if (\'MODIFY\' = opname)\n"
"final_res := DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS (graph_iri, del_dict, ins_dict, uid, log_mode, compose_report);\n"
"if (split is not null)\n"
"{\n"
"out_ses := string_output();\n"
"triples := (select VECTOR_AGG (vector (\"s\", \"p\", \"o\")) from\n"
"(sparql define input:storage \"\" define output:valmode \"LONG\"\n"
"select ?s ?p ?o where {\n"
"graph `iri(?:graph_iri)` { ?s ?p ?o } }\n"
"order by (str(?s)) (str(?p)) ) as sub );\n"
"if (\'application/rdf+xml\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT (triples, 1, out_ses);\n"
"else if ((\'text/rdf+n3\' = mime) or (\'text/rdf+ttl\' = mime) or (\'text/rdf+turtle\' = mime) or (\'text/turtle\' = mime) or (\'text/n3\' = mime) or (\'text/x-nquads\' = mime))\n"
"DB.DBA.RDF_TRIPLES_TO_TTL (triples, out_ses);\n"
"else if (\'application/x-trig\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_TRIG (triples, out_ses);\n"
"else if (\'text/plain\' = mime or \'text/ntriples\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_NT (triples, out_ses);\n"
"else if ((\'application/json\' = mime) or (\'application/rdf+json\' = mime) or (\'application/x-rdf+json\' = mime))\n"
"DB.DBA.RDF_TRIPLES_TO_TALIS_JSON (triples, out_ses);\n"
"else if (\'application/x-json+ld\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_LD (triples, out_ses);\n"
"else if (\'application/ld+json\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_LD (triples, out_ses);\n"
"else if (\'application/xhtml+xml\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML (triples, out_ses);\n"
"else if ((\'text/html\' = mime) or (\'text/microdata+html\' = mime) or (\'text/md+html\' = mime))\n"
"DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA (triples, out_ses);\n"
"else if (\'application/microdata+json\' = mime)\n"
"DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA (triples, out_ses);\n"
"rc := DB.DBA.DAV_RES_UPLOAD (split, out_ses, mime, old_perms, old_uid, old_gid, uid, pwd);\n"
"if (isinteger (rc) and rc < 0)\n"
"signal (\'RDFXX\', sprintf (\'Unable to change \"%.200s\" in DAV: %s\', split, DB.DBA.DAV_PERROR (rc)));\n"
"}\n"
"if (not isinteger (final_res))\n"
"return final_res;\n"
"}\n"
"--src sparql_io.sql:4007\n";

static const char *proc470 = 
"#line 4108 \"[executable]/sparql_io.sql\"\n"
"create procedure\n"
"WS.WS.__http_handler_rq (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"return DB.DBA.http_rq_file_handler(content, params, lines, ipath_ostat);\n"
"}\n"
"--src sparql_io.sql:4106\n";

static const char *proc471 = 
"#line 4115 \"[executable]/sparql_io.sql\"\n"
"create procedure\n"
"WS.WS.__http_handler_head_rq (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"return DB.DBA.http_rq_file_handler(content, params, lines, ipath_ostat);\n"
"}\n"
"--src sparql_io.sql:4113\n";

static const char *proc472 = 
"#line 4122 \"[executable]/sparql_io.sql\"\n"
"create procedure\n"
"DB.DBA.http_rq_file_handler (in content any, in params any, in lines any, inout ipath_ostat any)\n"
"{\n"
"declare accept varchar;\n"
"declare _format varchar;\n"
"\n"
"accept := http_request_header (lines, \'Accept\', null, \'\');\n"
"\n"
"_format := get_keyword(\'format\', params, \'\');\n"
"if (_format <> \'\')\n"
"{\n"
"_format := (\n"
"case lower(_format)\n"
"when \'json\' then \'application/sparql-results+json\'\n"
"when \'js\' then \'application/javascript\'\n"
"when \'html\' then \'text/html\'\n"
"when \'spreadsheet\' then \'application/vnd.ms-excel\'\n"
"when \'sparql\' then \'application/sparql-results+xml\'\n"
"when \'xml\' then \'application/sparql-results+xml\'\n"
"when \'rdf\' then \'application/rdf+xml\'\n"
"when \'n3\' then \'text/rdf+n3\'\n"
"when \'ttl\' then \'text/turtle\'\n"
"when \'turtle\' then \'text/turtle\'\n"
"when \'cxml\' then \'text/cxml\'\n"
"when \'cxml+qrcode\' then \'text/cxml+qrcode\'\n"
"when \'csv\' then \'text/csv\'\n"
"else _format\n"
"end);\n"
"}\n"
"\n"
"if (_format <> \'\' or\n"
"strcasestr (accept, \'application/sparql-results+json\') is not null or\n"
"strcasestr (accept, \'application/json\') is not null or\n"
"strcasestr (accept, \'application/sparql-results+xml\') is not null or\n"
"strcasestr (accept, \'text/rdf+n3\') is not null or\n"
"strcasestr (accept, \'text/rdf+ttl\') is not null or\n"
"strcasestr (accept, \'text/rdf+turtle\') is not null or\n"
"strcasestr (accept, \'text/turtle\') is not null or\n"
"strcasestr (accept, \'application/x-nquads\') is not null or\n"
"strcasestr (accept, \'application/x-trig\') is not null or\n"
"strcasestr (accept, \'application/rdf+xml\') is not null or\n"
"strcasestr (accept, \'application/javascript\') is not null or\n"
"strcasestr (accept, \'application/soap+xml\') is not null or\n"
"strcasestr (accept, \'application/rdf+turtle\') is not null or\n"
"strcasestr (accept, \'text/cxml\') is not null or\n"
"strcasestr (accept, \'text/cxml+qrcode\') is not null or\n"
"strcasestr (accept, \'text/csv\') is not null or\n"
"strcasestr (accept, \'application/x-nice-turtle\') is not null\n"
")\n"
"{\n"
"http_request_status (\'HTTP/1.1 303 See Other\');\n"
"http_header (sprintf(\'Location: /sparql?query=%U&format=%U\\r\\n\', content, accept));\n"
"return \'\';\n"
"}\n"
"if (strcasestr (accept, \'application/sparql-query\') is not null)\n"
"http_header (\'Content-Type: application/sparql-query\\r\\n\');\n"
"else\n"
"http_header (\'Content-Type: text/plain\\r\\n\');\n"
"http (content);\n"
"return \'\';\n"
"}\n"
"--src sparql_io.sql:4120\n";

static const char *proc473 = 
"#line 4185 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SD_TRIPLE (inout sd any, in s varchar, in p varchar, in o varchar)\n"
"{\n"
"if (starts_with (s, \'!\')) s := __xml_nsexpand_iristr (subseq (s, 1)); else s := __box_flags_tweak (s, 1);\n"
"if (starts_with (p, \'!\')) p := __xml_nsexpand_iristr (subseq (p, 1)); else p := __box_flags_tweak (p, 1);\n"
"if (starts_with (o, \'!\')) o := __xml_nsexpand_iristr (subseq (o, 1)); else o := __box_flags_tweak (o, 1);\n"
"vectorbld_acc (sd, vector (s, p, o));\n"
"}\n"
"--src sparql_io.sql:4183\n";

static const char *proc474 = 
"#line 4194 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SD_TRIPLE_L (inout sd any, in s varchar, in p varchar, in o any)\n"
"{\n"
"if (starts_with (s, \'!\')) s := __xml_nsexpand_iristr (subseq (s, 1)); else s := __box_flags_tweak (s, 1);\n"
"if (starts_with (p, \'!\')) p := __xml_nsexpand_iristr (subseq (p, 1)); else p := __box_flags_tweak (p, 1);\n"
"vectorbld_acc (sd, vector (s, p, o));\n"
"}\n"
"--src sparql_io.sql:4192\n";

static const char *proc475 = 
"#line 4202 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.SPARQL_SD_COMPOSE (inout sd any, in host varchar, in complete integer)\n"
"{\n"
"declare service_iri varchar;\n"
"service_iri := \'http://\' || host || \'/sparql-sd\';\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!rdf:type\', \'!sd:Service\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:endpoint\', \'http://\' || host || \'/sparql\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:endpoint\', \'http://\' || host || \'/sparql-auth\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!virtrdf:graph-crud-endpoint\', \'http://\' || host || \'/sparql-graph-crud\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!virtrdf:graph-crud-endpoint\', \'http://\' || host || \'/sparql-graph-crud-auth\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:feature\', \'!sd:UnionDefaultGraph\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:feature\', \'!sd:RequiresDataset\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:feature\', \'!sd:EmptyGraphs\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:feature\', \'!sd:BasicFederatedQuery\');\n"
"\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/N3\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/N-triples\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/RDFa\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/RDF_XML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/SPARQL_Results_XML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/SPARQL_Results_JSON\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/SPARQL_Results_CSV\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'http://www.w3.org/ns/formats/Turtle\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_SPARQL_Results_HTML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_SPARQL_Results_Spreadsheet\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_SPARQL_Results_Javascript\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_SPARQL_Results_CXML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_SPARQL_Results_CXML_QR\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_RDF_JSON\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_XHTML_RDFa\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_ATOM_XML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_ODATA_JSON\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_HTML_list\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_HTML_table\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_HTML_Microdata\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_Microdata_JSON\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_CSV\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_CXML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Triples_CXML_QR\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:resultFormat\', \'!virtrdf:FileFormat_Quads_TriG\');\n"
"\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'http://www.w3.org/ns/formats/N3\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'http://www.w3.org/ns/formats/N-triples\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'http://www.w3.org/ns/formats/RDFa\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'http://www.w3.org/ns/formats/RDF_XML\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'!virtrdf:FileFormat_Triples_XHTML_RDFa\');\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'!virtrdf:FileFormat_Triples_CSV\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'!virtrdf:FileFormat_Triples_CXML\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'!virtrdf:FileFormat_Triples_CXML_QR\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:inputFormat\', \'!virtrdf:FileFormat_Quads_TriG\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:supportedLanguage\', \'!sd:SPARQL10Query\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:supportedLanguage\', \'!sd:SPARQL11Query\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:supportedLanguage\', \'!sd:SPARQL11Update\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_QUAD_MAP\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_OPTION\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_BREAKUP\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_PKSELFJOIN\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_RVR\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_IN\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_LIKE\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_GLOBALS\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_BI\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_VIRTSPECIFIC\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_SERVICE\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_TRANSIT\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:languageExtension\', \'!virtrdf:SSG_SD_SPARQL11_DRAFT\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:propertyFeature\', \'!bif:contains\');\n"
"if (complete)\n"
"{\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:extensionFunction\', \'!bif:abs\');\n"
"DB.DBA.SPARQL_SD_TRIPLE (sd, service_iri, \'!sd:extensionAggregate\', \'!sql:STDDEV\');\n"
"}\n"
"}\n"
"--src sparql_io.sql:4200\n";

static const char *proc476 = 
"#line 4292 \"[executable]/sparql_io.sql\"\n"
"create procedure WS.WS.\"/!sparql-sd/\" (inout path varchar, inout params any, inout lines any)\n"
"{\n"
"declare sd, ses any;\n"
"declare service_iri varchar;\n"
"declare host, accept, formatter varchar;\n"
"host := http_request_header (lines, \'Host\', null, \'\');\n"
"accept := http_request_header (lines, \'Accept\', null, \'\');\n"
"\n"
"if ((2 < length (params)) or (params[0] <> \'Content\'))\n"
"{\n"
"WS.WS.\"/!sparql/\" (path, params, lines);\n"
"return;\n"
"}\n"
"vectorbld_init (sd);\n"
"if (host is not null and host <> \'\')\n"
"DB.DBA.SPARQL_SD_COMPOSE (sd, host, 1);\n"
"if (isstring (registry_get (\'URIQADefaultHost\')))\n"
"DB.DBA.SPARQL_SD_COMPOSE (sd, registry_get (\'URIQADefaultHost\'), 1);\n"
"vectorbld_final (sd);\n"
"ses := null;\n"
"if (strstr (accept, \'text/rdf+n3\') is not null)\n"
"{ http_header (\'Content-Type: text/rdf+n3; charset=UTF-8\\r\\n\');		DB.DBA.RDF_TRIPLES_TO_NT (sd, ses);	}\n"
"else if (strstr (accept, \'text/turtle\') is not null)\n"
"{ http_header (\'Content-Type: text/turtle; charset=UTF-8\\r\\n\');		DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"else if (strstr (accept, \'text/rdf+ttl\') is not null)\n"
"{ http_header (\'Content-Type: text/rdf+ttl; charset=UTF-8\\r\\n\');		DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"else if (strstr (accept, \'text/rdf+turtle\') is not null)\n"
"{ http_header (\'Content-Type: text/rdf+turtle; charset=UTF-8\\r\\n\');		DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"else if (strstr (accept, \'application/turtle\') is not null)\n"
"{ http_header (\'Content-Type: application/turtle; charset=UTF-8\\r\\n\');	DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"else if (strstr (accept, \'application/turtle\') is not null)\n"
"{ http_header (\'Content-Type: application/x-turtle; charset=UTF-8\\r\\n\');	DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"else\n"
"{ http_header (\'Content-Type: text/turtle; charset=UTF-8\\r\\n\');		DB.DBA.RDF_TRIPLES_TO_TTL (sd, ses);	}\n"
"}\n"
"--src sparql_io.sql:4290\n";

static const char *other49 = 
"registry_set (\'/!sparql-sd/\', \'no_vsp_recompile\')\n";
static const char *proc477 = 
"#line 4332 \"[executable]/sparql_io.sql\"\n"
"create procedure DB.DBA.RDF_GRANT_SPARQL_IO ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'grant execute on DB.DBA.SPARQL_REXEC to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_REXEC_TO_ARRAY to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_REXEC_WITH_META to SPARQL_SELECT\',\n"
"\'grant execute on WS.WS.\"/!sparql/\" to \"SPARQL\"\',\n"
"\'grant execute on WS.WS.\"/!sparql-graph-crud/\" to \"SPARQL\"\',\n"
"\'grant execute on WS.WS.\"/!sparql-sd/\" to \"SPARQL\"\',\n"
"\'grant execute on DB.DBA.SPARQL_REFRESH_DYNARES_RESULTS to \"SPARQL\"\',\n"
"\'grant execute on DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.SPARQL_SD_PROBE to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.SPARQL_SINV_IMP to SPARQL_SPONGE\',\n"
"\'grant select on DB.DBA.SPARQL_SINV_2 to SPARQL_SPONGE\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src sparql_io.sql:4330\n";


static const char *other50 = 
" DB.DBA.RDF_GRANT_SPARQL_IO ()\n";
/* rdf_sponge.sql */

static const char *proc478 = 
"#line 51 \"[executable]/rdf_sponge.sql\"\n"
" create procedure DB.DBA.RDF_FT_INDEX_GRABBED (inout grabbed any, inout options any)\n"
"{\n"
"declare grabbed_list any;\n"
"declare grab_ctr, grab_count integer;\n"
"declare g_iri varchar;\n"
"if (not coalesce (get_keyword (\'refresh_free_text\', options), 0))\n"
"return;\n"
"g_iri := get_keyword (\'get:group-destination\', options);\n"
"\n"
"if (isstring (g_iri) and __rdf_obj_ft_rule_count_in_graph (iri_to_id (g_iri)))\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"grabbed_list := dict_to_vector (grabbed, 0);\n"
"grab_count := length (grabbed_list);\n"
"\n"
"for (grab_ctr := 1; grab_ctr < grab_count; grab_ctr := grab_ctr + 2)\n"
"{\n"
"g_iri := grabbed_list[grab_ctr];\n"
"if (isstring (g_iri) and __rdf_obj_ft_rule_count_in_graph (iri_to_id (g_iri)))\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"commit work;\n"
"\n"
"return;\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src rdf_sponge.sql:49\n";

static const char *proc479 = 
"#line 85 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_GRAB_PREPARE_PRIVATE (in graph_iri varchar, in group_iri varchar, in uname varchar, inout options any)\n"
"{\n"
"declare uid, graph_public_perms integer;\n"
"declare g_iid, group_iid IRI_ID;\n"
"declare g_is_private integer;\n"
"#pragma prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#>\n"
"g_iid := iri_to_id (graph_iri);\n"
"uid := (select U_ID from DB.DBA.SYS_USERS where U_NAME = uname);\n"
"\n"
"if (uid is null)\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private has failed to get data about user \"%s\"\', uname));\n"
"if (uid = http_nobody_uid())\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private is used by user \"nobody\", that is prohibited\'));\n"
"\n"
"if (graph_iri = \'http://www.openlinksw.com/schemas/virtrdf#\')\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private tries to change access permissions of system metadata graph <%.500s>\', graph_iri));\n"
"if (group_iri in (UNAME\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\', UNAME\'http://www.openlinksw.com/schemas/virtrdf#rdf_repl_graph_group\'))\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private tries to add graph <%.500s> to special graph group <%.500s>\', graph_iri, group_iri));\n"
"\n"
"if (exists (sparql define input:storage \"\" ask from virtrdf:\n"
"where { `iri(?:graph_iri)` virtrdf:dialect|virtrdf:isEndpointOfService|^virtrdf:isEndpointOfService ?o } ) )\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private tries to change access permissions of graph <%.500s> but the graph is a known web service endpoint\', graph_iri));\n"
"\n"
"graph_public_perms := DB.DBA.RDF_GRAPH_USER_PERMS_GET (graph_iri, http_nobody_uid());\n"
"if (bit_and (15, graph_public_perms)\n"
"and (bit_and (15, dict_get (__rdf_graph_default_perms_of_user_dict(1), http_nobody_uid(), 15))\n"
"or exists (select 1 from DB.DBA.RDF_GRAPH_USER where RGU_GRAPH_IID = g_iid and RGU_USER_ID = http_nobody_uid()) ) )\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private tries to change access permissions of publicly accessible graph <%.500s>\', graph_iri));\n"
"if (group_iri <> \'\' and 11 <> bit_and (11, DB.DBA.RDF_GRAPH_USER_PERMS_GET (group_iri, uid)))\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query with get:private tries to change graph group <%.500s> and add <%.500s> there but user \"%s\" has not enough rights on that group\', group_iri, graph_iri, uname));\n"
"\n"
"if (uid <> 0)\n"
"{\n"
"declare other_reader varchar;\n"
"other_reader := (select U_NAME from DB.DBA.RDF_GRAPH_USER join DB.DBA.SYS_USERS on (RGU_USER_ID=U_ID)\n"
"where RGU_GRAPH_IID = g_iid and RGU_USER_ID <> uid and RGU_USER_ID <> 0 and RGU_PERMISSIONS <> 0 );\n"
"if ((other_reader is not null) and not bit_and (32, DB.DBA.RDF_GRAPH_USER_PERMS_GET (graph_iri, uid)))\n"
"signal (\'RDFGS\', sprintf (\'A SPARQL query of user \"%.500s\" with get:private tries to change access permissions of graph <%.500s> privately used by user \"%.500s\"\', uname, graph_iri, other_reader));\n"
"}\n"
"g_is_private := 0;\n"
"\n"
"if (bit_and (15, dict_get (__rdf_graph_default_perms_of_user_dict(0), http_nobody_uid(), 15)))\n"
"{\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (UNAME\'http://www.openlinksw.com/schemas/virtrdf#PrivateGraphs\', graph_iri);\n"
"g_is_private := 1;\n"
"}\n"
"\n"
"if (uid <> 0)\n"
"{\n"
"\n"
"DB.DBA.RDF_GRAPH_USER_PERMS_SET (graph_iri, uname, 15+32);\n"
"}\n"
"\n"
"if (group_iri <> \'\')\n"
"{\n"
"group_iid := iri_to_id (group_iri);\n"
"\n"
"\n"
"\n"
"DB.DBA.RDF_GRAPH_GROUP_INS (group_iri, graph_iri);\n"
"for (\n"
"select sub.U_NAME as fellow_name, bit_or (MAX (RGU_PERMISSIONS), graph_public_perms, 1) as max_perms from\n"
"(\n"
"select U_NAME, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER join DB.DBA.SYS_USERS on (RGU_USER_ID=U_ID)\n"
"where RGU_USER_ID <> uid and RGU_USER_ID <> http_nobody_uid() and RGU_USER_ID <> 0 and RGU_GRAPH_IID = group_iid and bit_and (RGU_PERMISSIONS, 8)\n"
"union select U_NAME, RGU_PERMISSIONS from DB.DBA.RDF_GRAPH_USER join DB.DBA.SYS_USERS on (RGU_USER_ID=U_ID)\n"
"where RGU_USER_ID <> uid and RGU_USER_ID <> http_nobody_uid() and RGU_USER_ID <> 0 and RGU_GRAPH_IID = case when (g_is_private) then #i8192 else #i0 end and bit_and (RGU_PERMISSIONS, 8) ) sub\n"
"group by sub.U_NAME ) do\n"
"{\n"
"\n"
"\n"
"DB.DBA.RDF_GRAPH_USER_PERMS_SET (graph_iri, fellow_name, max_perms);\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src rdf_sponge.sql:83\n";

static const char *proc480 = 
"#line 164 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_GRAB_SINGLE (in val any, inout grabbed any, inout env any) returns integer\n"
"{\n"
"declare url, get_method, recov varchar;\n"
"declare dest varchar;\n"
"declare opts, err any;\n"
"\n"
"{\n"
"whenever sqlstate \'*\' goto end_of_sponge;\n"
"if (val is null)\n"
"return 0;\n"
"if (isiri_id (val))\n"
"{\n"
"if (is_bnode_iri_id (val))\n"
"return 0;\n"
"val := id_to_iri (val);\n"
"}\n"
"if (217 = __tag (val))\n"
"val := cast (val as varchar);\n"
"dest := null;\n"
"call (get_keyword_ucase (\'resolver\', env, \'DB.DBA.RDF_GRAB_RESOLVER_DEFAULT\')) (get_keyword_ucase (\'base_iri\', env), val, url, dest, get_method);\n"
"\n"
"\n"
"if (url is not null and not dict_get (grabbed, url, 0))\n"
"{\n"
"declare final_dest, final_gdest, get_private varchar;\n"
"final_dest := get_keyword (\'get:destination\', env, dest);\n"
"final_gdest := get_keyword (\'get:group-destination\', env);\n"
"opts := vector (\n"
"\'get:soft\', get_keyword_ucase (\'get:soft\', env, \'soft\'),\n"
"\'get:refresh\', get_keyword_ucase (\'get:refresh\', env),\n"
"\'get:method\', get_method,\n"
"\'get:destination\', final_dest,\n"
"\'get:group-destination\', final_gdest,\n"
"\'get:strategy\', get_keyword_ucase (\'get:strategy\', env),\n"
"\'get:private\', get_keyword_ucase (\'get:private\', env),\n"
"\'get:error-recovery\', get_keyword_ucase (\'get:error-recovery\', env),\n"
"\'get:note\', get_keyword_ucase (\'get:note\', env) );\n"
"dict_put (grabbed, url, 1);\n"
"get_private := get_keyword_ucase (\'get:private\', env, null);\n"
"if (get_private is not null)\n"
"DB.DBA.RDF_GRAB_PREPARE_PRIVATE (final_dest, get_private, user, env);\n"
"call (get_keyword (\'loader\', env, \'DB.DBA.RDF_SPONGE_UP\'))(url, opts, user);\n"
"commit work;\n"
"dict_put (grabbed, url, coalesce (final_dest, dest));\n"
"\n"
"if (coalesce (get_keyword_ucase (\'refresh_free_text\', env), 0) and\n"
"(__rdf_obj_ft_rule_count_in_graph (iri_to_id (final_dest)) or\n"
"__rdf_obj_ft_rule_count_in_graph (iri_to_id (final_gdest)) ) )\n"
"{\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"\n"
"commit work;\n"
"}\n"
"return 1;\n"
"}\n"
"return 0;\n"
"}\n"
"end_of_sponge:\n"
"commit work;\n"
"\n"
"recov := get_keyword_ucase (\'get:error-recovery\', env);\n"
"if (recov is not null)\n"
"{\n"
"if (recov = \'signal\')\n"
"signal (__SQL_STATE, __SQL_MESSAGE);\n"
"whenever sqlstate \'*\' goto end_of_recov;\n"
"call (recov) (__SQL_STATE, __SQL_MESSAGE, val, grabbed, env);\n"
"commit work;\n"
"return 0;\n"
"end_of_recov:\n"
"rollback work;\n"
"}\n"
"return 0;\n"
"}\n"
"--src rdf_sponge.sql:162\n";

static const char *proc481 = 
"#line 240 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_GRAB_SINGLE_ASYNC (in val any, in grabbed any, in env any, in counter_limit integer := 1)\n"
"{\n"
"\n"
"if (dict_size (grabbed) <= counter_limit)\n"
"DB.DBA.RDF_GRAB_SINGLE (val, grabbed, vector_concat (vector (\'refresh_free_text\', 0), env));\n"
"}\n"
"--src rdf_sponge.sql:238\n";

static const char *proc482 = 
"#line 248 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_GRAB_SEEALSO (in subj varchar, in opt_g varchar, inout env any) returns integer\n"
"{\n"
"declare grabbed, aq any;\n"
"declare sa_graphs, sa_preds any;\n"
"declare doc_limit integer;\n"
"if (not isiri_id (subj))\n"
"return 1;\n"
"aq := async_queue (8);\n"
"grabbed := get_keyword (\'grabbed\', env);\n"
"doc_limit := get_keyword (\'doc_limit\', env, 0hex1000000);\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"sa_preds := get_keyword (\'sa_preds\', env);\n"
"sa_graphs := get_keyword (\'sa_graphs\', env);\n"
"\n"
"if (sa_graphs is null)\n"
"{\n"
"foreach (varchar pred in sa_preds) do\n"
"{\n"
"for (sparql define input:storage \"\" select ?val where { ?:subj ?:pred ?val . filter (isIRI(?val)) } ) do\n"
"{\n"
"\n"
"if (\"val\" like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (\"val\", grabbed, env, doc_limit));\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"else\n"
"{\n"
"foreach (varchar pred in sa_preds) do\n"
"{\n"
"foreach (varchar graph in sa_graphs) do\n"
"{\n"
"for (sparql define input:storage \"\" select ?val where { graph ?:graph { ?:subj ?:pred ?val . filter (isIRI(?val)) } } ) do\n"
"{\n"
"\n"
"if (\"val\" like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (\"val\", grabbed, env, doc_limit));\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (opt_g is not null)\n"
"{\n"
"foreach (varchar pred in sa_preds) do\n"
"{\n"
"for (sparql define input:storage \"\" select ?val where { graph ?:opt_g { ?:subj ?:pred ?val . filter (isIRI(?val)) } } ) do\n"
"{\n"
"\n"
"if (\"val\" like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (\"val\", grabbed, env, doc_limit));\n"
"if (dict_size (grabbed) > doc_limit)\n"
"goto out_of_limit;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (bit_and (1, get_keyword (\'flags\', env, 0)))\n"
"{\n"
"declare subj_iri varchar;\n"
"subj_iri := id_to_iri (subj);\n"
"if (subj_iri like \'http://%\')\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (subj_iri, grabbed, env, doc_limit));\n"
"}\n"
"}\n"
"out_of_limit:\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, env);\n"
"if (dict_size (grabbed) > doc_limit)\n"
"return 4;\n"
"return 2;\n"
"}\n"
"--src rdf_sponge.sql:246\n";

static const char *proc483 = 
"#line 341 \"[executable]/rdf_sponge.sql\"\n"
"create procedure\n"
"DB.DBA.RDF_GRAB (\n"
"in app_params any, in grab_params any, in seed varchar, in iter varchar, in final varchar, in ret_limit integer,\n"
"in const_iris any, in depth integer, in plain_ret integer, in uid any )\n"
"{\n"
"declare rctr, rcount, colcount, iter_ctr, doc_limit integer;\n"
"declare stat, msg varchar;\n"
"declare sa_graphs, sa_preds, all_params any;\n"
"declare grabbed, metas, rset, aq any;\n"
"\n"
"sa_preds := get_keyword (\'sa_preds\', grab_params);\n"
"doc_limit := get_keyword (\'doc_limit\', grab_params, 0hex1000000);\n"
"grab_params := vector_concat (grab_params, vector (\'grabbed\', dict_new()));\n"
"all_params := vector_concat (vector (grab_params), app_params);\n"
"aq := async_queue (8);\n"
"grabbed := dict_new ();\n"
"foreach (any val in const_iris) do\n"
"{\n"
"\n"
"if (val is not null and __rgs_ack_cbk (val, uid, 4))\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (val, grabbed, grab_params, doc_limit));\n"
"if (sa_preds is not null)\n"
"{\n"
"\n"
"DB.DBA.RDF_GRAB_SEEALSO (val, null, grab_params);\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"commit work;\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, grab_params);\n"
"commit work;\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"for (iter_ctr := 0; iter_ctr <= depth; iter_ctr := iter_ctr + 1)\n"
"{\n"
"declare old_doc_count integer;\n"
"old_doc_count := dict_size (grabbed);\n"
"stat := \'00000\';\n"
"\n"
"exec (case (iter_ctr) when 0 then seed else iter end, stat, msg, all_params,\n"
"case (isnull (ret_limit)) when 0 then __max (ret_limit, doc_limit, 1000) else null end,\n"
"metas, rset);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"rcount := length (rset);\n"
"colcount := length (metas[0]);\n"
"\n"
"for (rctr := 0; rctr < rcount; rctr := rctr + 1)\n"
"{\n"
"declare colctr integer;\n"
"for (colctr := 0; colctr < colcount; colctr := colctr + 1)\n"
"{\n"
"declare val any;\n"
"declare dest varchar;\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"val := rset[rctr][colctr];\n"
"if (is_named_iri_id (val) and __rgs_ack_cbk (val, uid, 4))\n"
"{\n"
"\n"
"\n"
"aq_request (aq, \'DB.DBA.RDF_GRAB_SINGLE_ASYNC\', vector (val, grabbed, grab_params, doc_limit));\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"if (sa_preds is not null)\n"
"{\n"
"\n"
"DB.DBA.RDF_GRAB_SEEALSO (val, null, grab_params);\n"
"}\n"
"if (dict_size (grabbed) >= doc_limit)\n"
"goto final_exec;\n"
"}\n"
"}\n"
"}\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"commit work;\n"
"DB.DBA.RDF_FT_INDEX_GRABBED (grabbed, grab_params);\n"
"commit work;\n"
"if (old_doc_count = dict_size (grabbed))\n"
"{\n"
"\n"
"goto final_exec;\n"
"}\n"
"}\n"
"\n"
"final_exec:\n"
"stat := \'00000\';\n"
"exec (final, stat, msg, app_params, ret_limit, metas, rset);\n"
"if (stat <> \'00000\')\n"
"signal (stat, msg);\n"
"if (plain_ret)\n"
"return rset[0][0];\n"
"rcount := length (rset);\n"
"result_names (rset);\n"
"for (rctr := 0; rctr < rcount; rctr := rctr + 1)\n"
"result (rset[rctr]);\n"
"}\n"
"--src rdf_sponge.sql:339\n";

static const char *proc484 = 
"#line 446 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_GRAB_RESOLVER_DEFAULT (in base varchar, in rel_uri varchar, out abs_uri varchar, out dest_uri varchar, out get_method varchar)\n"
"{\n"
"declare rel_lattice_pos, base_lattice_pos integer;\n"
"declare lattice_tail varchar;\n"
"if (217 = __tag (rel_uri))\n"
"rel_uri := cast (rel_uri as varchar);\n"
"if (217 = __tag (base))\n"
"base := cast (base as varchar);\n"
"rel_lattice_pos := strrchr (rel_uri, \'#\');\n"
"lattice_tail := \'\';\n"
"if (rel_lattice_pos is not null)\n"
"{\n"
"lattice_tail := subseq (rel_uri, rel_lattice_pos);\n"
"rel_uri := subseq (rel_uri, 0, rel_lattice_pos);\n"
"}\n"
"if ((base is not null) and (base <> \'\'))\n"
"{\n"
"base_lattice_pos := strrchr (cast (base as varchar), \'#\');\n"
"if (base_lattice_pos is not null)\n"
"{\n"
"if (\'\' = lattice_tail)\n"
"lattice_tail := subseq (base, base_lattice_pos);\n"
"base := subseq (base, 0, base_lattice_pos);\n"
"}\n"
"}\n"
"else\n"
"base := \'\';\n"
"if (base = \'\')\n"
"abs_uri := rel_uri;\n"
"else\n"
"abs_uri := XML_URI_RESOLVE_LIKE_GET (base, rel_uri);\n"
"dest_uri := abs_uri;\n"
"if (abs_uri like \'%/\')\n"
"get_method := \'GET+MGET\';\n"
"else\n"
"get_method := \'GET\';\n"
"\n"
"}\n"
"--src rdf_sponge.sql:444\n";

static const char *proc485 = 
"#line 491 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.SPARQL_EVAL_TO_ARRAY (in query varchar, in dflt_graph varchar, in maxrows integer)\n"
"{\n"
"declare state, msg varchar;\n"
"declare metas, rset any;\n"
"if (dflt_graph is not null)\n"
"query := concat (\'sparql { define input:default-graph-uri <\', dflt_graph, \'> \', query, \'\\n}\');\n"
"else\n"
"query := concat (\'sparql { \', query, \'\\n}\');\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"exec (query, state, msg, vector(), maxrows, metas, rset);\n"
"\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"return rset;\n"
"}\n"
"--src rdf_sponge.sql:489\n";

static const char *proc486 = 
"#line 510 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.SPARQL_EVAL (in query varchar, in dflt_graph varchar, in maxrows integer)\n"
"{\n"
"declare sqltext, state, msg varchar;\n"
"declare metas, rset any;\n"
"if (dflt_graph is not null)\n"
"query := concat (\'sparql { define input:default-graph-uri <\', dflt_graph, \'> \', query, \'\\n}\');\n"
"else\n"
"query := concat (\'sparql { \', query, \'\\n}\');\n"
"state := \'00000\';\n"
"metas := null;\n"
"rset := null;\n"
"exec (query, state, msg, vector(), maxrows, metas, rset);\n"
"if (state <> \'00000\')\n"
"signal (state, msg);\n"
"\n"
"if (metas is not null)\n"
"{\n"
"exec_result_names (metas[0]);\n"
"foreach (any row in rset) do\n"
"{\n"
"exec_result (row);\n"
"}\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:508\n";

static const char *tbl20 = 
"create table DB.DBA.SYS_HTTP_SPONGE (\n"
"HS_LOCAL_IRI varchar not null,\n"
"HS_PARSER varchar not null,\n"
"HS_ORIGIN_URI varchar not null,\n"
"HS_ORIGIN_LOGIN varchar,\n"
"HS_LAST_LOAD datetime,\n"
"HS_LAST_ETAG varchar,\n"
"HS_LAST_READ datetime,\n"
"HS_EXP_IS_TRUE integer,\n"
"HS_EXPIRATION datetime,\n"
"HS_LAST_MODIFIED datetime,\n"
"HS_DOWNLOAD_SIZE integer,\n"
"HS_DOWNLOAD_MSEC_TIME integer,\n"
"HS_READ_COUNT integer,\n"
"HS_SQL_STATE varchar,\n"
"HS_SQL_MESSAGE varchar,\n"
"HS_FROM_IRI varchar,\n"
"HS_QUALITY double precision,\n"
"HS_NOTE varchar,\n"
"primary key (HS_LOCAL_IRI, HS_PARSER)\n"
")\n"
"alter index SYS_HTTP_SPONGE on DB.DBA.SYS_HTTP_SPONGE partition (HS_LOCAL_IRI varchar)\n"
"create index SYS_HTTP_SPONGE_EXPIRATION on DB.DBA.SYS_HTTP_SPONGE (HS_EXPIRATION desc) partition (HS_LOCAL_IRI varchar)\n"
"create index SYS_HTTP_SPONGE_FROM_IRI on DB.DBA.SYS_HTTP_SPONGE (HS_FROM_IRI, HS_PARSER) partition (HS_FROM_IRI varchar)\n"
"create index SYS_HTTP_SPONGE_ORIGIN_URI on DB.DBA.SYS_HTTP_SPONGE (HS_ORIGIN_URI) partition (HS_ORIGIN_URI varchar)\n";

static const char *alter1 = 
"alter table DB.DBA.SYS_HTTP_SPONGE add HS_NOTE varchar\n";

static const char *tbl21 = 
"create table DB.DBA.SYS_HTTP_SPONGE_REFRESH_DEFAULTS (\n"
"HSRD_DATA_SOURCE_URI_PATTERN varchar not null,\n"
"HSRD_DEFAULT_REFRESH_INTERVAL_SECS integer,\n"
"primary key (HSRD_DATA_SOURCE_URI_PATTERN)\n"
")\n";

static const char *alter2 = 
"alter table DB.DBA.SYS_HTTP_SPONGE add HS_NOTE varchar\n";

static const char *tbl22 = 
"create table DB.DBA.SYS_HTTP_SPONGE_REFRESH_DEFAULTS (\n"
"HSRD_DATA_SOURCE_URI_PATTERN varchar not null,\n"
"HSRD_DEFAULT_REFRESH_INTERVAL_SECS integer,\n"
"primary key (HSRD_DATA_SOURCE_URI_PATTERN)\n"
")\n";

static const char *tbl23 = 
"create table RDF_WEBID_ACL_GROUPS (\n"
"AG_WEBID varchar,\n"
"AG_GROUP varchar,\n"
"primary key (AG_WEBID, AG_GROUP)\n"
")\n";

static const char *proc487 = 
"#line 600 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS\n"
"(\n"
"in explicit_refresh any,\n"
"in old_last_modified any,\n"
"inout ret_hdr any,\n"
"inout new_expiration any,\n"
"out ret_content_type any,\n"
"out ret_etag any,\n"
"out ret_date any,\n"
"out ret_expires any,\n"
"out ret_last_modif any,\n"
"out ret_dt_date any,\n"
"out ret_dt_expires any,\n"
"out ret_dt_last_modified any\n"
")\n"
"{\n"
"declare ret_304_not_modified int;\n"
"\n"
"ret_304_not_modified := 0;\n"
"if (ret_hdr[0] like \'HTTP%304%\')\n"
"{\n"
"ret_304_not_modified := 1;\n"
"}\n"
"\n"
"ret_content_type := http_request_header (ret_hdr, \'Content-Type\', null, null);\n"
"ret_etag := http_request_header (ret_hdr, \'ETag\', null, null);\n"
"ret_date := http_request_header (ret_hdr, \'Date\', null, null);\n"
"ret_expires := http_request_header (ret_hdr, \'Expires\', null, null);\n"
"ret_last_modif := http_request_header (ret_hdr, \'Last-Modified\', null, null);\n"
"ret_dt_date := http_string_date (ret_date, NULL, NULL);\n"
"ret_dt_expires := http_string_date (ret_expires, NULL, now());\n"
"ret_dt_last_modified := http_string_date (ret_last_modif, NULL, now());\n"
"\n"
"if (http_request_header (ret_hdr, \'Pragma\', null, null) = \'no-cache\' or http_request_header (ret_hdr, \'Cache-Control\', null, null) like \'no-cache%\' )\n"
"{\n"
"ret_dt_expires := now ();\n"
"ret_etag := null;\n"
"}\n"
"\n"
"if (ret_304_not_modified and ret_dt_last_modified is null)\n"
"ret_dt_last_modified := old_last_modified;\n"
"\n"
"if (ret_dt_date is not null)\n"
"{\n"
"\n"
"if (ret_dt_expires is not null)\n"
"ret_dt_expires := dateadd (\'second\', datediff (\'second\', ret_dt_date, now()), ret_dt_expires);\n"
"\n"
"if (ret_dt_last_modified is not null)\n"
"ret_dt_last_modified := dateadd (\'second\', datediff (\'second\', ret_dt_date, now()), ret_dt_last_modified);\n"
"}\n"
"\n"
"if (ret_dt_expires is not null and\n"
"(ret_dt_expires < coalesce (ret_dt_date, ret_dt_last_modified, now ())) )\n"
"ret_dt_expires := NULL;\n"
"\n"
"if (ret_dt_expires is not null)\n"
"new_expiration := ret_dt_expires;\n"
"else\n"
"{\n"
"\n"
"if (ret_dt_date is not null and ret_dt_last_modified is not null and (ret_dt_date >= ret_dt_last_modified))\n"
"new_expiration := dateadd (\'second\',\n"
"__min (\n"
"3600 * 24 * 7,\n"
"0.7 * datediff (\'second\', ret_dt_last_modified, ret_dt_date)\n"
"),\n"
"now());\n"
"}\n"
"if (ret_304_not_modified)\n"
"{\n"
"\n"
"if (new_expiration is null and explicit_refresh is not null)\n"
"new_expiration := dateadd (\'second\', 0.7 * explicit_refresh, now());\n"
"\n"
"\n"
"if (ret_dt_expires is null and new_expiration is not null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', explicit_refresh, now()));\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:598\n";

static const char *proc488 = 
"#line 685 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.SYS_HTTP_SPONGE_DEP_URL_NOT_CHANGED (in local_iri varchar, in parser varchar, in explicit_refresh int)\n"
"{\n"
"\n"
"for select\n"
"HS_LOCAL_IRI as old_local_iri,\n"
"HS_LAST_LOAD as old_last_load,\n"
"HS_READ_COUNT as old_read_count,\n"
"HS_EXP_IS_TRUE as old_exp_is_true,\n"
"HS_EXPIRATION as old_expiration,\n"
"HS_LAST_MODIFIED as old_last_modified\n"
"from DB.DBA.SYS_HTTP_SPONGE where HS_FROM_IRI = local_iri and HS_PARSER = parser\n"
"do\n"
"{\n"
"\n"
"\n"
"if (old_expiration is not null)\n"
"{\n"
"if ((old_expiration >= now()) and (\n"
"explicit_refresh is null or\n"
"old_exp_is_true or\n"
"(dateadd (\'second\', explicit_refresh, old_last_load) >= now()) ) )\n"
"{\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_READ = now(), HS_READ_COUNT = old_read_count + 1\n"
"where HS_LOCAL_IRI = old_local_iri and HS_LAST_READ < now();\n"
"commit work;\n"
"}\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (old_last_load >= now() and old_expiration is null)\n"
"{\n"
"\n"
"return 0;\n"
"}\n"
"}\n"
"}\n"
"return 1;\n"
"}\n"
"--src rdf_sponge.sql:683\n";

static const char *proc489 = 
"#line 731 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_HTTP_MAKE_HTTP_REQ (in url varchar, in meth varchar, in req varchar)\n"
"{\n"
"declare hf any;\n"
"declare str any;\n"
"\n"
"hf := rfc1808_parse_uri (url);\n"
"str := meth || \' \' || hf[2] || case when hf[4] <> \'\' then \'?\' else \'\' end || hf[4] || \' HTTP/1.1\\r\\n\' ||\n"
"\'Host: \' || hf[1] || \'\\r\\n\' || req;\n"
"str := replace (str, \'\\r\', \'\\n\');\n"
"str := replace (str, \'\\n\\n\', \'\\n\');\n"
"return split_and_decode (str, 0, \'\\0\\0\\n\');\n"
"}\n"
"--src rdf_sponge.sql:729\n";

static const char *proc490 = 
"#line 745 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.SYS_HTTP_SPONGE_UP (in local_iri varchar, in get_uri varchar, in parser varchar, in eraser varchar, in options any)\n"
"{\n"
"declare new_origin_uri, new_origin_login, new_last_etag varchar;\n"
"declare old_origin_uri, old_origin_login, old_last_etag varchar;\n"
"declare new_last_load, new_expiration datetime;\n"
"declare old_last_load, old_expiration, old_last_modified datetime;\n"
"declare load_begin_msec, load_end_msec, old_exp_is_true,\n"
"old_download_size, old_download_msec_time, old_read_count,\n"
"new_download_size, explicit_refresh, max_sz integer;\n"
"declare get_method varchar;\n"
"declare get_soft varchar;\n"
"declare get_note varchar;\n"
"declare ret_hdr, immg, req_hdr_arr any;\n"
"declare req_hdr varchar;\n"
"declare ret_body, ret_content_type, ret_etag, ret_last_modified, ret_date, ret_last_modif, ret_expires varchar;\n"
"declare get_proxy varchar;\n"
"declare ret_dt_date, ret_dt_last_modified, ret_dt_expires, expiration, min_expiration datetime;\n"
"declare ret_304_not_modified integer;\n"
"declare parser_rc, max_refresh, default_refresh int;\n"
"declare stat, msg varchar;\n"
"\n"
"\n"
"new_origin_uri := cast (get_keyword_ucase (\'get:uri\', options, get_uri) as varchar);\n"
"new_origin_login := cast (get_keyword_ucase (\'get:login\', options) as varchar);\n"
"explicit_refresh := get_keyword_ucase (\'get:refresh\', options);\n"
"get_soft := get_keyword_ucase (\'get:soft\', options, \'\');\n"
"get_note := get_keyword_ucase (\'get:note\', options);\n"
"if (explicit_refresh is null)\n"
"{\n"
"max_refresh := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxCacheExpiration\'), \'-1\'));\n"
"default_refresh := (select HSRD_DEFAULT_REFRESH_INTERVAL_SECS from DB.DBA.SYS_HTTP_SPONGE_REFRESH_DEFAULTS where regexp_match (HSRD_DATA_SOURCE_URI_PATTERN, local_iri) is not null);\n"
"if (default_refresh is not null)\n"
"{\n"
"if (default_refresh >= 0)\n"
"{\n"
"if (max_refresh >= 0)\n"
"explicit_refresh := __min (default_refresh, max_refresh);\n"
"else\n"
"explicit_refresh := default_refresh;\n"
"}\n"
"else if (max_refresh >= 0)\n"
"explicit_refresh := max_refresh;\n"
"}\n"
"else if (max_refresh >= 0)\n"
"explicit_refresh := max_refresh;\n"
"}\n"
"else if (isstring (explicit_refresh))\n"
"explicit_refresh := atoi (explicit_refresh);\n"
"min_expiration := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MinExpiration\'), \'-1\'));\n"
"if (min_expiration < 0)\n"
"min_expiration := null;\n"
"set isolation=\'serializable\';\n"
"whenever not found goto add_new_origin;\n"
"select HS_ORIGIN_URI, HS_ORIGIN_LOGIN, HS_LAST_LOAD, HS_LAST_ETAG,\n"
"HS_EXP_IS_TRUE, HS_EXPIRATION, HS_LAST_MODIFIED,\n"
"HS_DOWNLOAD_SIZE, HS_DOWNLOAD_MSEC_TIME, HS_READ_COUNT\n"
"into old_origin_uri, old_origin_login, old_last_load, old_last_etag,\n"
"old_exp_is_true, old_expiration, old_last_modified,\n"
"old_download_size, old_download_msec_time, old_read_count\n"
"from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser for update;\n"
"\n"
"if ((new_origin_uri <> old_origin_uri) and (eraser is not null))\n"
"signal (\'RDFXX\',\n"
"sprintf (\'Can not get-and-cache RDF graph <%.500s> from <%.500s> because is has been loaded from <%.500s>\',\n"
"local_iri, new_origin_uri, old_origin_uri) );\n"
"\n"
"if (coalesce (new_origin_login, \'\') <> coalesce (old_origin_login, \'\') and\n"
"old_expiration is not null )\n"
"signal (\'RDFXX\',\n"
"sprintf (\'Can not get-and-cache RDF graph <%.500s> from <%.500s> using %s because is has been loaded using %s\',\n"
"local_iri, new_origin_uri,\n"
"case (isnull (new_origin_login)) when 0 then sprintf (\'login \"%.100s\"\', new_origin_login) else \'anonymous access\' end,\n"
"case (isnull (old_origin_login)) when 0 then sprintf (\'login \"%.100s\"\', old_origin_login) else \'anonymous access\' end ) );\n"
"\n"
"\n"
"\n"
"if (eraser is null)\n"
"{\n"
"\n"
"goto perform_actual_load;\n"
"}\n"
"if (old_expiration is not null)\n"
"{\n"
"if ((old_expiration >= now() and (old_exp_is_true or old_last_etag is null) and explicit_refresh is null) or\n"
"(explicit_refresh is not null and dateadd (\'second\', explicit_refresh, old_last_load) >= now()))\n"
"{\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_READ = now(), HS_READ_COUNT = old_read_count + 1, HS_NOTE = get_note\n"
"where HS_LOCAL_IRI = local_iri and HS_LAST_READ < now();\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (datediff (\'hour\', old_last_load, now()) >= 1)\n"
"{\n"
"\n"
" ;\n"
"}\n"
"else\n"
"{\n"
"\n"
"return local_iri;\n"
"}\n"
"}\n"
"\n"
"update_old_origin:\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = NULL, HS_LAST_READ = NULL,\n"
"HS_EXP_IS_TRUE = 0, HS_EXPIRATION = NULL, HS_LAST_MODIFIED = NULL,\n"
"HS_DOWNLOAD_SIZE = NULL, HS_DOWNLOAD_MSEC_TIME = NULL,\n"
"HS_READ_COUNT = 0,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL, HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"goto perform_actual_load;\n"
"\n"
"add_new_origin:\n"
"\n"
"old_origin_uri := NULL; old_origin_login := NULL; old_last_load := NULL; old_last_etag := NULL;\n"
"old_expiration := NULL; old_download_size := NULL; old_download_msec_time := NULL;\n"
"old_exp_is_true := 0; old_read_count := 0; old_last_modified := null;\n"
"insert into DB.DBA.SYS_HTTP_SPONGE (HS_LOCAL_IRI, HS_PARSER, HS_ORIGIN_URI, HS_ORIGIN_LOGIN, HS_LAST_LOAD, HS_NOTE)\n"
"values (local_iri, parser, new_origin_uri, new_origin_login, now(), get_note);\n"
"commit work;\n"
"goto perform_actual_load;\n"
"\n"
"perform_actual_load:\n"
"\n"
"new_expiration := NULL;\n"
"new_last_etag := NULL;\n"
"ret_304_not_modified := 0;\n"
"load_begin_msec := msec_time();\n"
"set isolation=\'committed\';\n"
"commit work;\n"
"get_method := cast (get_keyword_ucase (\'get:method\', options, \'GET\') as varchar);\n"
"\n"
"if (get_method in (\'POST\', \'GET\', \'GET+MGET\'))\n"
"{\n"
"declare acc_hdr varchar; \n"
"req_hdr := NULL;\n"
"get_proxy := get_keyword_ucase (\'get:proxy\', options);\n"
"acc_hdr := trim (get_keyword_ucase (\'get:accept\', options));\n"
"if (not length (acc_hdr))\n"
"acc_hdr := \'application/rdf+xml; q=1.0, text/rdf+n3; q=0.9, application/rdf+turtle; q=0.5, application/x-turtle; q=0.6, application/turtle; q=0.5, text/turtle; q=1.0, application/xml; q=0.2, */*; q=0.1\';\n"
"connection_set (\'sparql-get:proxy\', get_proxy);\n"
"\n"
"\n"
"\n"
"if (old_last_etag is not null and explicit_refresh is null)\n"
"req_hdr := \'If-None-Match: \' || old_last_etag;\n"
"else if (old_last_load is not null and explicit_refresh is null)\n"
"req_hdr := \'If-Modified-Since: \' || DB.DBA.date_rfc1123 (old_last_load);\n"
"\n"
"\n"
"\n"
"req_hdr := req_hdr || case when length (req_hdr) > 0 then \'\\r\\n\' else \'\' end\n"
"|| \'User-Agent: OpenLink Virtuoso RDF crawler\\r\\n\'\n"
"|| \'Accept: \' || acc_hdr;\n"
"\n"
"\n"
"{\n"
"declare mtd, new_origin_uri_save varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"resignal;\n"
"};\n"
"new_origin_uri_save := new_origin_uri;\n"
"if (get_method = \'GET+MGET\')\n"
"mtd := \'GET\';\n"
"else\n"
"mtd := get_method;\n"
"ret_body := DB.DBA.RDF_HTTP_URL_GET (new_origin_uri, \'\', ret_hdr, mtd, req_hdr, NULL, get_proxy, 0);\n"
"\n"
"if (new_origin_uri <> new_origin_uri_save)\n"
"{\n"
"declare pos int;\n"
"pos := position (\'http-redirect-to\', options);\n"
"if (pos > 0)\n"
"options[pos-1] := new_origin_uri;\n"
"else\n"
"options := vector_concat (options, vector (\'http-redirect-to\', new_origin_uri));\n"
"}\n"
"new_origin_uri := new_origin_uri_save;\n"
"}\n"
"if (ret_hdr[0] like \'HTTP%404%\')\n"
"{\n"
"delete from DB.DBA.SYS_HTTP_SPONGE where HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'HT404\', sprintf (\'Resource \"%.1000s\" not found\', new_origin_uri));\n"
"}\n"
"if (ret_hdr[0] like \'HTTP%304%\')\n"
"{\n"
"ret_304_not_modified := 1;\n"
"goto resp_received;\n"
"}\n"
"if (ret_hdr[0] like \'HTTP/1._ 5__ %\' or ret_hdr[0] like \'HTTP/1._ 4__ %\')\n"
"{\n"
"rollback work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = \'RDFXX\',\n"
"HS_SQL_MESSAGE = sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]),\n"
"HS_EXPIRATION = now (),\n"
"HS_EXP_IS_TRUE = 0,\n"
"HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'RDFXX\', sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]));\n"
"}\n"
"goto resp_received;\n"
"}\n"
"if (eraser is not null and (get_soft <> \'add\'))\n"
"{\n"
"\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"}\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to get data from \"%.1000s\": This version of Virtuoso does not support OPTION (get:method \"%.100s\")\',\n"
"new_origin_uri, get_method ) );\n"
"\n"
"resp_received:\n"
"\n"
"DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS (explicit_refresh, old_last_modified, ret_hdr, new_expiration,\n"
"ret_content_type, ret_etag, ret_date, ret_expires, ret_last_modif,\n"
"ret_dt_date, ret_dt_expires, ret_dt_last_modified);\n"
"\n"
"if (ret_304_not_modified)\n"
"{\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = old_last_etag, HS_LAST_READ = now(),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end,\n"
"HS_EXPIRATION = coalesce (ret_dt_expires, new_expiration, now()),\n"
"HS_LAST_MODIFIED = coalesce (old_last_modified, ret_dt_last_modified),\n"
"HS_DOWNLOAD_SIZE = old_download_size,\n"
"HS_DOWNLOAD_MSEC_TIME = old_download_msec_time,\n"
"HS_READ_COUNT = old_read_count + 1,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL, HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri;\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"if (ret_body is null)\n"
"{\n"
"rollback work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = \'RDFXX\',\n"
"HS_SQL_MESSAGE = sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]),\n"
"HS_EXPIRATION = now (),\n"
"HS_EXP_IS_TRUE = 0, HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'RDFXX\', sprintf (\'Unable to retrieve RDF data from \"%.500s\": %.500s\', new_origin_uri, ret_hdr[0]));\n"
"}\n"
"\n"
"new_download_size := length (ret_body);\n"
"\n"
"max_sz := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxDataSourceSize\'), \'20971520\'));\n"
"\n"
"if (max_sz < new_download_size)\n"
"{\n"
"rollback work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = \'RDFXX\',\n"
"HS_SQL_MESSAGE = sprintf (\'Content length %d is over the limit %d\', new_download_size, max_sz),\n"
"HS_EXPIRATION = now (),\n"
"HS_EXP_IS_TRUE = 0, HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"signal (\'RDFXX\', sprintf (\'Content length %d is over the limit %d\', new_download_size, max_sz));\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"{\n"
"whenever sqlstate \'*\' goto error_during_load;\n"
"parser_rc := 0;\n"
"req_hdr_arr := DB.DBA.RDF_HTTP_MAKE_HTTP_REQ (new_origin_uri, get_method, req_hdr);\n"
"if (eraser is not null and (get_soft <> \'add\'))\n"
"{\n"
"\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"}\n"
"parser_rc := call (parser) (local_iri, new_origin_uri, ret_content_type, ret_hdr, ret_body, options, req_hdr_arr);\n"
"\n"
"if (parser_rc is not null)\n"
"{\n"
"new_last_etag := ret_etag;\n"
"if (__tag (parser_rc) = 193 and eraser is not null and ret_content_type like \'%html\')\n"
"{\n"
"declare sa any;\n"
"sa := get_keyword (\'seeAlso\', parser_rc);\n"
"foreach (varchar dep in sa) do\n"
"{\n"
"DB.DBA.SYS_HTTP_SPONGE_UP (local_iri, dep, parser, NULL, options);\n"
"}\n"
"}\n"
"}\n"
"else\n"
"new_last_etag := null;\n"
"\n"
"load_end_msec := msec_time();\n"
"if (new_expiration is null)\n"
"new_expiration := dateadd (\'second\', load_end_msec - load_begin_msec, now());\n"
"if (ret_dt_expires is null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', 0.7 * explicit_refresh, now()));\n"
"expiration := coalesce (ret_dt_expires, new_expiration, now());\n"
"if (explicit_refresh is null and min_expiration is not null)\n"
"expiration := __max (dateadd (\'second\', min_expiration, now()), expiration);\n"
"commit work;\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_LAST_LOAD = now(), HS_LAST_ETAG = new_last_etag, HS_LAST_READ = now(),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end,\n"
"HS_EXPIRATION = expiration,\n"
"HS_LAST_MODIFIED = ret_dt_last_modified,\n"
"HS_DOWNLOAD_SIZE = new_download_size,\n"
"HS_DOWNLOAD_MSEC_TIME = load_end_msec - load_begin_msec,\n"
"HS_READ_COUNT = 1,\n"
"HS_SQL_STATE = NULL, HS_SQL_MESSAGE = NULL, HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"return local_iri;\n"
"}\n"
"\n"
"error_during_load:\n"
"rollback work;\n"
"\n"
"stat := __SQL_STATE;\n"
"msg := __SQL_MESSAGE;\n"
"load_end_msec := msec_time();\n"
"if (new_expiration is null)\n"
"new_expiration := dateadd (\'second\', load_end_msec - load_begin_msec, now());\n"
"if (ret_dt_expires is null and explicit_refresh is not null)\n"
"new_expiration := __min (new_expiration, dateadd (\'second\', 0.7 * explicit_refresh, now()));\n"
"\n"
"update DB.DBA.SYS_HTTP_SPONGE\n"
"set HS_SQL_STATE = stat,\n"
"HS_SQL_MESSAGE = msg,\n"
"HS_EXPIRATION = coalesce (ret_dt_expires, new_expiration, now()),\n"
"HS_EXP_IS_TRUE = case (isnull (ret_dt_expires)) when 1 then 0 else 1 end,\n"
"HS_NOTE = get_note\n"
"where\n"
"HS_LOCAL_IRI = local_iri and HS_PARSER = parser;\n"
"commit work;\n"
"\n"
"if (get_keyword_ucase (\'get:error-recovery\', options) is not null)\n"
"signal (stat, msg);\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:743\n";

static const char *proc491 = 
"#line 1109 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.SYS_FILE_SPONGE_UP (in local_iri varchar, in get_uri varchar, in parser varchar, in eraser varchar, in options any)\n"
"{\n"
"declare new_origin_uri, str, base_uri, mime_type, dummy, tmp any;\n"
"declare inx int;\n"
"declare get_soft varchar;\n"
"new_origin_uri := cast (get_keyword_ucase (\'get:uri\', options, get_uri) as varchar);\n"
"get_soft := get_keyword_ucase (\'get:soft\', options, \'\');\n"
"inx := 5;\n"
"base_uri := new_origin_uri;\n"
"base_uri := charset_recode (base_uri, \'UTF-8\', NULL);\n"
"while (length (base_uri) > inx + 1 and aref (base_uri, inx) = ascii (\'/\'))\n"
"inx := inx + 1;\n"
"if (inx = 8)\n"
"str := file_to_string (subseq (base_uri, inx-1));\n"
"else\n"
"str := file_to_string (concat (http_root(), \'/\' , subseq (base_uri, inx)));\n"
"dummy := vector ();\n"
"tmp := vector (\'OK\');\n"
"mime_type := null;\n"
"if (eraser is not null and (get_soft <> \'add\'))\n"
"call (eraser) (local_iri, new_origin_uri, options);\n"
"DB.DBA.RDF_LOAD_HTTP_RESPONSE (local_iri, new_origin_uri, mime_type, tmp, str, options, dummy);\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:1107\n";

static const char *proc492 = 
"#line 1135 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_TRY_TTL (in mode integer, inout txt varchar) returns varchar\n"
"{\n"
"declare msg varchar;\n"
"declare app_env any;\n"
"declare cr_pos integer;\n"
"\n"
"whenever sqlstate \'*\' goto err;\n"
"DB.DBA.TTLP_VALIDATE (txt, \'\', \'dummy\', mode);\n"
"\n"
"return \'\';\n"
"err:\n"
"msg := __SQL_STATE || __SQL_MESSAGE;\n"
"\n"
"cr_pos := strchr (msg, \'\\n\');\n"
"if (cr_pos is null)\n"
"return msg;\n"
"return subseq (msg, 0, cr_pos);\n"
"}\n"
"--src rdf_sponge.sql:1133\n";

static const char *proc493 = 
"#line 1155 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_GUESS_TTL_CONTENT_TYPE (in origin_uri varchar, in ret_content_type varchar, inout ret_body any, inout ret_begin any) returns varchar\n"
"{\n"
"declare shorter_ret_begin varchar;\n"
"declare last_cr_pos integer;\n"
"declare ctr integer;\n"
"declare msg, s_msg varchar;\n"
"shorter_ret_begin := ret_begin;\n"
"for (ctr := 0; ctr < 3; ctr := ctr+1)\n"
"{\n"
"last_cr_pos := strrchr (shorter_ret_begin, 0hexA);\n"
"if (last_cr_pos is null)\n"
"goto no_cr;\n"
"shorter_ret_begin := subseq (shorter_ret_begin, 0, last_cr_pos);\n"
"}\n"
"no_cr:\n"
"\n"
"msg := DB.DBA.RDF_SPONGE_TRY_TTL (0, ret_begin);\n"
"if (\'\' = msg)\n"
"return \'text/turtle\';\n"
"if (last_cr_pos is not null and DB.DBA.RDF_SPONGE_TRY_TTL (0, shorter_ret_begin) <> msg)\n"
"return \'text/turtle\';\n"
"msg := DB.DBA.RDF_SPONGE_TRY_TTL (512, ret_begin);\n"
"if (\'\' = msg)\n"
"return \'text/x-nquads\';\n"
"if (last_cr_pos is not null and DB.DBA.RDF_SPONGE_TRY_TTL (512, shorter_ret_begin) <> msg)\n"
"return \'text/x-nquads\';\n"
"msg := DB.DBA.RDF_SPONGE_TRY_TTL (256, ret_begin);\n"
"if (\'\' = msg)\n"
"return \'application/x-trig\';\n"
"if (last_cr_pos is not null and DB.DBA.RDF_SPONGE_TRY_TTL (256, shorter_ret_begin) <> msg)\n"
"return \'application/x-trig\';\n"
"if (ret_content_type is null or\n"
"strstr (ret_content_type, \'text/plain\') is not null or\n"
"strstr (ret_content_type, \'application/octet-stream\') is not null )\n"
"{\n"
"declare ret_lines any;\n"
"declare ret_lcount, ret_lctr integer;\n"
"ret_lines := split_and_decode (ret_begin, 0, \'\\0\\t\\n\');\n"
"ret_lcount := length (ret_lines);\n"
"for (ret_lctr := 0; ret_lctr < ret_lcount; ret_lctr := ret_lctr + 1)\n"
"{\n"
"declare l varchar;\n"
"l := rtrim (replace (ret_lines [ret_lctr], \'\\r\', \'\'));\n"
"\n"
"if ((\"LEFT\" (l, 7) = \'@prefix\') or (\"LEFT\" (l, 5) = \'@base\') or (\"LEFT\" (l, 8) = \'@keyword\'))\n"
"return \'text/turtle\';\n"
"if (((\"LEFT\" (l, 1) = \'<\') or (\"LEFT\" (l, 1) = \'[\')) and \n"
"(\n"
"\"RIGHT\" (origin_uri, 4) in (\'.ttl\', \'.TTL\')\n"
"))\n"
"return \'text/turtle\';\n"
"if (((\"LEFT\" (l, 1) = \'<\') or (\"LEFT\" (l, 1) = \'[\')) and \n"
"(\n"
"\"RIGHT\" (origin_uri, 3) in (\'.n3\', \'.N3\', \'.nt\', \'.NT\')\n"
"))\n"
"return \'text/rdf+n3\';\n"
"if (not ((l like \'#%\') or (l=\'\')))\n"
"return \'text/plain\';\n"
"}\n"
"}\n"
"return null;\n"
"}\n"
"--src rdf_sponge.sql:1153\n";

static const char *proc494 = 
"#line 1221 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (in origin_uri varchar, in ret_content_type varchar, inout ret_body any) returns varchar\n"
"{\n"
"declare guessed_ret_type varchar;\n"
"\n"
"if (ret_content_type is not null)\n"
"{\n"
"if (strstr (ret_content_type, \'application/sparql-results+xml\') is not null)\n"
"return \'application/sparql-results+xml\';\n"
"if (strstr (ret_content_type, \'application/rdf+xml\') is not null)\n"
"return \'application/rdf+xml\';\n"
"if (strstr (ret_content_type, \'text/rdf+ttl\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'text/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/x-turtle\') is not null or\n"
"strstr (ret_content_type, \'application/turtle\') is not null )\n"
"return \'text/turtle\';\n"
"if (strstr (ret_content_type, \'text/n3\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+n3\') is not null )\n"
"return \'text/rdf+n3\';\n"
"if (strstr (ret_content_type, \'application/x-trig\') is not null)\n"
"return \'application/x-trig\';\n"
"if (strstr (ret_content_type, \'text/x-nquads\') is not null)\n"
"return \'text/x-nquads\';\n"
"}\n"
"declare ret_begin, ret_html any;\n"
"ret_begin := subseq (ret_body, 0, 65535);\n"
"if (isstring_session (ret_begin))\n"
"ret_begin := string_output_string (ret_begin);\n"
"\n"
"ret_html := xtree_doc (ret_begin, 2);\n"
"\n"
"if (xpath_eval (\'[xmlns:xh=\"http://www.w3.org/1999/xhtml\"] /html|/xhtml|/xh:html|/xh:xhtml\', ret_html) is not null)\n"
"{\n"
"if (xpath_eval (\'[xmlns:grddl=\"http://www.w3.org/2003/g/data-view#\"] /*/@grddl:transformation\', ret_html) is not null)\n"
"return \'text/html\';\n"
"if (xpath_eval (\'/*/head/@profile\', ret_html) is not null)\n"
"return \'text/html\';\n"
"if (xpath_eval (\'//*[exists(@itemscope) or exists(@itemprop) or exists(@itemid) or exists(@itemtype)]\', ret_html) is not null)\n"
"return \'text/microdata+html\';\n"
"\n"
"if (xpath_eval (\'//*[exists(@typeof) or exists(@about)]\', ret_html) is not null)\n"
"return \'application/xhtml+xml\';\n"
"return \'text/html\';\n"
"}\n"
"if (xpath_eval (\'[xmlns:rset=\"http://www.w3.org/2005/sparql-results#\"] /rset:sparql\', ret_html) is not null\n"
"or xpath_eval (\'[xmlns:rset2=\"http://www.w3.org/2001/sw/DataAccess/rf1/result2\"] /rset2:sparql\', ret_html) is not null)\n"
"return \'application/sparql-results+xml\';\n"
"if (xpath_eval (\'[xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"] /rdf:rdf\', ret_html) is not null)\n"
"return \'application/rdf+xml\';\n"
"if (strstr (ret_begin, \'<html>\') is not null or\n"
"strstr (ret_begin, \'<xhtml>\') is not null )\n"
"return \'text/html\';\n"
"guessed_ret_type := DB.DBA.RDF_SPONGE_GUESS_TTL_CONTENT_TYPE (origin_uri, ret_content_type, ret_body, ret_begin);\n"
"if (guessed_ret_type is not null)\n"
"return guessed_ret_type;\n"
"return ret_content_type;\n"
"}\n"
"--src rdf_sponge.sql:1219\n";

static const char *tbl24 = 
"create table DB.DBA.SYS_RDF_MAPPERS (\n"
"RM_ID integer identity,\n"
"RM_PATTERN varchar,\n"
"RM_TYPE varchar default \'MIME\',\n"
"RM_HOOK varchar,\n"
"RM_KEY  long varchar,\n"
"RM_DESCRIPTION long varchar,\n"
"RM_ENABLED integer default 1,\n"
"RM_OPTIONS any,\n"
"RM_PID integer identity,\n"
"primary key (RM_HOOK))\n"
"alter index SYS_RDF_MAPPERS on DB.DBA.SYS_RDF_MAPPERS partition cluster replicated\n"
"create index SYS_RDF_MAPPERS_I1 on DB.DBA.SYS_RDF_MAPPERS (RM_ID) partition cluster replicated\n"
"create index SYS_RDF_MAPPERS_I2 on DB.DBA.SYS_RDF_MAPPERS (RM_PID) partition cluster replicated\n";

static const char *proc495 = 
"#line 1331 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_HTTP_URL_GET (inout url any, in base any, inout hdr any,\n"
"in meth any := \'GET\', in req_hdr varchar := null, in cnt any := null, in proxy any := null, in sig int := 1)\n"
"{\n"
"declare content varchar;\n"
"declare olduri, req_hdr_orig varchar;\n"
"\n"
"declare redirects, is_https int;\n"
"\n"
"\n"
"req_hdr_orig := req_hdr;\n"
"hdr := null;\n"
"redirects := 15;\n"
"url := WS.WS.EXPAND_URL (base, url);\n"
"again:\n"
"olduri := url;\n"
"if (redirects <= 0)\n"
"signal (\'22023\', \'Too many HTTP redirects\', \'RDFXX\');\n"
"\n"
"if (lower (url) like \'https://%\' and proxy is not null)\n"
"signal (\'22023\', \'The HTTPS retrieval is not supported via proxy\', \'RDFXX\');\n"
"is_https := 0;\n"
"if (lower (url) like \'https://%\')\n"
"is_https := 1;\n"
"\n"
"if (proxy is null)\n"
"content := http_client_ext (url=>url, headers=>hdr, http_method=>meth, http_headers=>req_hdr, body=>cnt);\n"
"else\n"
"content := http_get (url, hdr, meth, req_hdr, cnt, proxy);\n"
"redirects := redirects - 1;\n"
"\n"
"if (hdr[0] not like \'HTTP/1._ 200 %\')\n"
"{\n"
"if (hdr[0] like \'HTTP/1._ 30_ %\' and hdr[0] not like \'HTTP/1._ 304 %\')\n"
"{\n"
"url := http_request_header (hdr, \'Location\');\n"
"if (isstring (url))\n"
"{\n"
"declare cookie_hdr varchar;\n"
"url := WS.WS.EXPAND_URL (olduri, url);\n"
"req_hdr := req_hdr_orig;\n"
"cookie_hdr := DB.DBA.COOKIE_HDR (olduri, hdr, url);\n"
"if (length (cookie_hdr))\n"
"req_hdr := req_hdr || \'\\r\\n\' || cookie_hdr;\n"
"goto again;\n"
"}\n"
"}\n"
"if (sig)\n"
"signal (\'22023\', trim(hdr[0], \'\\r\\n\'), \'RDFXX\');\n"
"\n"
"return NULL;\n"
"}\n"
"\n"
"return content;\n"
"}\n"
"--src rdf_sponge.sql:1329\n";

static const char *proc496 = 
"#line 1389 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.COOKIE_HDR (in src_url any, in resp_hdrs any, in dest_url any)\n"
"{\n"
"declare ua_src, ua_dest, cookies, resp_cookie, cookie_attrs any;\n"
"declare ua_src_domain, ua_src_path, ua_dest_domain, ua_dest_path, req_cookie_hdr, cookie_domain, cookie_path varchar;\n"
"declare valid integer;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return null;\n"
"};\n"
"\n"
"ua_src := rfc1808_parse_uri (src_url);\n"
"ua_src_domain := ua_src[1];\n"
"if (strcontains (ua_src_domain, \':\'))\n"
"ua_src_domain := subseq (ua_src_domain, 0, strchr (ua_src_domain, \':\'));\n"
"ua_src_path := ua_src[2];\n"
"\n"
"ua_dest := rfc1808_parse_uri (dest_url);\n"
"ua_dest_domain := ua_dest[1];\n"
"if (strcontains (ua_dest_domain, \':\'))\n"
"ua_dest_domain := subseq (ua_dest_domain, 0, strchr (ua_dest_domain, \':\'));\n"
"ua_dest_path := ua_dest[2];\n"
"\n"
"req_cookie_hdr := null;\n"
"if (length (resp_hdrs) = 0)\n"
"goto done;\n"
"\n"
"cookies := vector();\n"
"foreach (varchar hdr in resp_hdrs) do\n"
"{\n"
"if (starts_with (hdr, \'Set-Cookie: \'))\n"
"{\n"
"resp_cookie := regexp_replace (hdr, \'Set-Cookie: (.+)\\r\\n\', \'\\\\1\');\n"
"resp_cookie := regexp_replace (resp_cookie, \'; \', \';\');\n"
"cookie_attrs := split_and_decode (resp_cookie, 0, \'\\0\\0;=\');\n"
"cookies := vector_concat (cookies, vector(cookie_attrs));\n"
"}\n"
"}\n"
"\n"
"if (length (cookies) = 0)\n"
"goto done;\n"
"\n"
"req_cookie_hdr := \'\';\n"
"foreach (any cookie in cookies) do\n"
"{\n"
"\n"
"\n"
"valid := 1;\n"
"cookie_domain := get_keyword (\'domain\', cookie, ua_src_domain);\n"
"cookie_path :=  get_keyword (\'path\', cookie, ua_src_path);\n"
"if (length (cookie_domain) and not ends_with (ua_dest_domain, cookie_domain))\n"
"valid := 0;\n"
"if (length (cookie_path) and not starts_with (ua_dest_path, cookie_path))\n"
"valid := 0;\n"
"if (valid)\n"
"req_cookie_hdr := sprintf (\'%s %s=%s;\', req_cookie_hdr, cookie[0], cookie[1]);\n"
"}\n"
"\n"
"if (length (req_cookie_hdr))\n"
"{\n"
"req_cookie_hdr := \'Cookie:\' || req_cookie_hdr;\n"
"req_cookie_hdr := rtrim (req_cookie_hdr, \';\');\n"
"}\n"
"\n"
"done:\n"
"return req_cookie_hdr;\n"
"}\n"
"--src rdf_sponge.sql:1387\n";

static const char *proc497 = 
"#line 1459 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_SW_PING (in endp varchar, in url varchar)\n"
"{\n"
"declare rc any;\n"
"declare err, msg any;\n"
"declare xt any;\n"
"commit work;\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"insert into DB.DBA.SYS_SPARQL_SW_LOG (PL_SERVER, PL_URI, PL_RC, PL_MSG)\n"
"values (endp, url, __SQL_STATE, __SQL_MESSAGE);\n"
"commit work;\n"
"return;\n"
"};\n"
"\n"
"err := \'\';\n"
"msg := \'n/a\';\n"
"xt := null;\n"
"if (virtuoso_ini_item_value (\'SPARQL\', \'RestPingService\') = \'1\')\n"
"{\n"
"rc := http_client (url=>endp||sprintf (\'?url=%U\', url), timeout=>10);\n"
"xt := xtree_doc (rc);\n"
"}\n"
"else\n"
"{\n"
"rc := DB.DBA.XMLRPC_CALL (endp, \'weblogUpdates.ping\', vector (\'\', url));\n"
"if (isarray (rc))\n"
"xt := xml_tree_doc (rc);\n"
"}\n"
"if (xt is not null)\n"
"{\n"
"err := cast (xpath_eval (\'//flerror/text()\', xml_cut(xt), 1) as varchar);\n"
"msg := cast (xpath_eval (\'//message/text()\', xml_cut(xt), 1) as varchar);\n"
"}\n"
"insert into DB.DBA.SYS_SPARQL_SW_LOG (PL_SERVER, PL_URI, PL_RC, PL_MSG)\n"
"values (endp, url, err, msg);\n"
"\n"
"commit work;\n"
"return;\n"
"}\n"
"--src rdf_sponge.sql:1457\n";

static const char *proc498 = 
"#line 1500 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_PROC_COLS (in pname varchar)\n"
"{\n"
"set_user_id (\'dba\', 1);\n"
"return procedure_cols (pname);\n"
"}\n"
"--src rdf_sponge.sql:1498\n";

static const char *proc499 = 
"#line 1507 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_PROXY_GET_HTTP_HOST ()\n"
"{\n"
"declare default_host, cname, xhost varchar;\n"
"xhost := connection_get (\'http_host\');\n"
"if (isstring (xhost))\n"
"return xhost;\n"
"if (is_http_ctx ())\n"
"default_host := http_request_header(http_request_header (), \'Host\', null, null);\n"
"else if (connection_get (\'__http_host\') is not null)\n"
"default_host := connection_get (\'__http_host\');\n"
"else\n"
"default_host := cfg_item_value (virtuoso_ini_path (), \'URIQA\', \'DefaultHost\');\n"
"if (default_host is not null)\n"
"cname := default_host;\n"
"else\n"
"{\n"
"cname := sys_stat (\'st_host_name\');\n"
"if (server_http_port () <> \'80\')\n"
"cname := cname ||\':\'|| server_http_port ();\n"
"}\n"
"return cname;\n"
"}\n"
"--src rdf_sponge.sql:1505\n";

static const char *proc500 = 
"#line 1531 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_SPONGE_IRI_SCH ()\n"
"{\n"
"declare xproto any;\n"
"xproto := connection_get (\'http_proto\');\n"
"if (isstring (xproto))\n"
"return xproto;\n"
"if (is_https_ctx ())\n"
"return \'https\';\n"
"return \'http\';\n"
"}\n"
"--src rdf_sponge.sql:1529\n";

static const char *proc501 = 
"#line 1547 \"[executable]/rdf_sponge.sql\"\n"
" create procedure DB.DBA.RDF_PROXY_ENTITY_IRI (in uri varchar := \'\', in login varchar := \'\', in frag varchar := \'this\')\n"
"{\n"
"declare cname any;\n"
"declare ret any;\n"
"declare url_sch, local_prx varchar;\n"
"declare ua any;\n"
"cname := DB.DBA.RDF_PROXY_GET_HTTP_HOST ();\n"
"if (frag = \'this\' or frag = \'#this\')\n"
"frag := \'\';\n"
"if (length (frag) and frag[0] <> \'#\'[0])\n"
"{\n"
"frag := \'#\' || sprintf (\'%U\', frag);\n"
"}\n"
"if (strchr (uri, \'#\') is not null)\n"
"frag := \'\';\n"
"\n"
"\n"
"local_prx := sprintf (\'%s://%s/about/id/entity/\', RDF_SPONGE_IRI_SCH (), cname);\n"
"if (starts_with (uri, local_prx))\n"
"return uri;\n"
"ua := rfc1808_parse_uri (uri);\n"
"url_sch := ua[0];\n"
"ua [0] := \'\';\n"
"uri := vspx_uri_compose (ua);\n"
"uri := ltrim (uri, \'/\');\n"
"ret := sprintf (\'%s://%s/about/id/entity/%s/%s%s\', RDF_SPONGE_IRI_SCH (), cname, url_sch, uri, frag);\n"
"return ret;\n"
"}\n"
"--src rdf_sponge.sql:1545\n";

static const char *proc502 = 
"#line 1582 \"[executable]/rdf_sponge.sql\"\n"
" create procedure DB.DBA.RDF_SPONGE_PROXY_IRI(in uri varchar := \'\', in login varchar := \'\', in frag varchar := \'this\')\n"
"{\n"
"declare cname any;\n"
"declare ret any;\n"
"declare url_sch varchar;\n"
"declare ua any;\n"
"cname := DB.DBA.RDF_PROXY_GET_HTTP_HOST ();\n"
"if (frag = \'this\' or frag = \'#this\')\n"
"frag := \'\';\n"
"if (length (frag) and frag[0] <> \'#\'[0])\n"
"frag := \'#\' || sprintf (\'%U\', frag);\n"
"if (strchr (uri, \'#\') is not null)\n"
"frag := \'\';\n"
"\n"
"\n"
"ua := rfc1808_parse_uri (uri);\n"
"url_sch := ua[0];\n"
"ua [0] := \'\';\n"
"uri := vspx_uri_compose (ua);\n"
"uri := ltrim (uri, \'/\');\n"
"if (length (login))\n"
"ret := sprintf (\'%s://%s/about/rdf/%s/%U/%s%s\', RDF_SPONGE_IRI_SCH (), cname, url_sch, login, uri, frag);\n"
"else\n"
"ret := sprintf (\'%s://%s/about/id/%s/%s%s\', RDF_SPONGE_IRI_SCH (), cname, url_sch, uri, frag);\n"
"return ret;\n"
"}\n"
"--src rdf_sponge.sql:1580\n";

static const char *proc503 = 
"#line 1611 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC (in contents varchar, in base varchar, in graph varchar, in mimetype varchar :=\'text/html\')\n"
"{\n"
"declare proxyiri, docproxyiri, dociri varchar;\n"
"proxyiri := DB.DBA.RDF_PROXY_ENTITY_IRI (graph);\n"
"docproxyiri := DB.DBA.RDF_SPONGE_PROXY_IRI (graph);\n"
"dociri:=DB.DBA.RM_SPONGE_DOC_IRI(graph);\n"
"\n"
"sparql define input:storage \"\" \n"
"insert in iri(?:graph) { \n"
"`iri(?:graph)` <http://xmlns.com/foaf/0.1/topic> `iri(sql:XML_URI_RESOLVE_LIKE_GET(?:base, ?s))` .\n"
"`iri(sql:XML_URI_RESOLVE_LIKE_GET(?:base, ?s))` <http://www.w3.org/2007/05/powder-s#describedby> `iri(?:proxyiri)` \n"
"}\n"
"where { { select distinct ?s \n"
"where { graph `iri(?:graph)` { ?s ?p ?o .\n"
"filter (iri(sql:XML_URI_RESOLVE_LIKE_GET(?:base, ?s)) != iri(?:graph) && !(regex (?s, \'/about/id/http\') || regex (?s, \'/about/id/entity/http\')))\n"
"}\n"
"}\n"
"}\n"
"};\n"
"sparql define input:storage \"\" \n"
"insert in graph iri(?:graph) { \n"
"`iri(?:docproxyiri)` a <http://purl.org/ontology/bibo/Document> ;\n"
"<http://www.w3.org/ns/formats/media_type> `?:mimetype` ;\n"
"<http://vocab.deri.ie/void#inDataset> `iri(?:graph)` ; \n"
"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <http://rdfs.org/sioc/ns#Container> , <http://purl.org/ontology/bibo/Document> ;\n"
"<http://rdfs.org/sioc/ns#container_of> `iri(?:proxyiri)` .\n"
"`iri(?:dociri)` <http://www.w3.org/2002/07/owl#sameAs> `iri(?:proxyiri)` . \n"
"};\n"
"if (registry_get (\'__rdf_cartridges_add_spongetime__\') = \'1\') {\n"
"sparql define input:storage \"\" \n"
"insert in graph iri(?:graph) { \n"
"`iri(?:graph)` <http://www.openlinksw.com/schema/attribution#sponge_time> `bif:now()` . \n"
"};\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:1609\n";

static const char *proc504 = 
"#line 1650 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_LOAD_HTTP_RESPONSE (in graph_iri varchar, in new_origin_uri varchar, inout ret_content_type varchar, inout ret_hdr any, inout ret_body any, inout options any, inout req_hdr_arr any)\n"
"{\n"
"declare dest, extra, groupdest, get_soft, cset, base, first_stat, first_msg varchar;\n"
"declare rc any;\n"
"declare aq, ps any;\n"
"declare xd, xt any;\n"
"declare saved_log_mode, ttl_mode, only_rdfa, retr_count, rdf_fmt integer;\n"
"aq := null;\n"
"rdf_fmt := 0;\n"
"ps := virtuoso_ini_item_value (\'SPARQL\', \'PingService\');\n"
"if (length (ps))\n"
"{\n"
"aq := async_queue (1);\n"
"}\n"
"\n"
"\n"
"declare l any;\n"
"l := ret_body;\n"
"if (length (l) > 3 and l[0] = 0hexEF and l[1] = 0hexBB and l[2] = 0hexBF)\n"
"ret_body := subseq (ret_body, 3);\n"
"ret_content_type := DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE (new_origin_uri, ret_content_type, ret_body);\n"
"\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"groupdest := get_keyword_ucase (\'get:group-destination\', options);\n"
"extra := get_keyword_ucase (\'get:extra\', options, \'0\');\n"
"base := get_keyword (\'http-redirect-to\', options, new_origin_uri);\n"
"get_soft := get_keyword_ucase (\'get:soft\', options);\n"
"if (get_keyword_ucase (\'get:strategy\', options, \'default\') = \'rdfa-only\' or get_soft = \'no-sponge\')\n"
"only_rdfa := 1;\n"
"else\n"
"only_rdfa := 0;\n"
"if (strstr (ret_content_type, \'application/sparql-results+xml\') is not null)\n"
"signal (\'RDFXX\', sprintf (\'Unable to load RDF graph <%.500s> from <%.500s>: the sparql-results XML answer does not contain triples\', graph_iri, new_origin_uri));\n"
"if (get_keyword (\'http-headers\', options) is null)\n"
"options := vector_concat (options, vector (\'http-headers\', vector (req_hdr_arr, ret_hdr)));\n"
"retry_after_deadlock:\n"
"if (strstr (ret_content_type, \'application/rdf+xml\') is not null)\n"
"{\n"
"\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_printf (\'%s: SQL_MESSAGE: %s\', current_proc_name(), __SQL_MESSAGE);\n"
"goto load_grddl_after_error;\n"
"};\n"
"\n"
"xt := xtree_doc (ret_body);\n"
"\n"
"if (xpath_eval (\'[ xmlns:dv=\"http://www.w3.org/2003/g/data-view#\" ] /*[1]/@dv:transformation\', xt) is not null)\n"
"goto load_grddl;\n"
"DB.DBA.RDF_LOAD_RDFXML (ret_body, base, coalesce (dest, graph_iri));\n"
"if (extra <> \'0\')\n"
"DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC(ret_body, base, coalesce (dest, graph_iri), ret_content_type);\n"
"rdf_fmt := 1;\n"
"if (groupdest is not null)\n"
"{\n"
"DB.DBA.RDF_LOAD_RDFXML (ret_body, base, groupdest);\n"
"if (extra <> \'0\')\n"
"DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC(ret_body, base, groupdest, ret_content_type);\n"
"}\n"
"goto load_grddl;\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\') and only_rdfa = 0)\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"ttl_mode := null;\n"
"if (\n"
"strstr (ret_content_type, \'text/rdf+n3\') is not null or\n"
"strstr (ret_content_type, \'text/n3\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+ttl\') is not null or\n"
"strstr (ret_content_type, \'text/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'text/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/rdf+n3\') is not null or\n"
"strstr (ret_content_type, \'application/rdf+turtle\') is not null or\n"
"strstr (ret_content_type, \'application/turtle\') is not null or\n"
"strstr (ret_content_type, \'application/n-triples\') is not null or\n"
"strstr (ret_content_type, \'application/x-turtle\') is not null )\n"
"ttl_mode := 255;\n"
"else if (\n"
"strstr (ret_content_type, \'application/x-trig\') is not null)\n"
"ttl_mode := 256+255;\n"
"else if (\n"
"strstr (ret_content_type, \'text/x-nquads\') is not null)\n"
"ttl_mode := 512+255;\n"
"if (ttl_mode is not null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_printf (\'%s: SQL_MESSAGE: %s\', current_proc_name(), __SQL_MESSAGE);\n"
"goto load_grddl_after_error;\n"
"};\n"
"\n"
"\n"
"\n"
"DB.DBA.TTLP (ret_body, base, coalesce (dest, graph_iri), ttl_mode);\n"
"if(extra<>\'0\')\n"
"DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC(ret_body, base, coalesce (dest, graph_iri), ret_content_type);\n"
"rdf_fmt := 1;\n"
"if (groupdest is not null)\n"
"{\n"
"DB.DBA.TTLP (ret_body, base, groupdest);\n"
"if(extra<>\'0\')\n"
"DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC(ret_body, base, groupdest, ret_content_type);\n"
"}\n"
"if (exists (select 1 from DB.DBA.SYS_RDF_MAPPERS where RM_TYPE = \'URL\' and regexp_match (RM_PATTERN, new_origin_uri) and RM_ENABLED = 1))\n"
"goto load_grddl;\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\') and only_rdfa = 0)\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"else if (strstr (ret_content_type, \'text/microdata+html\') is not null)\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_printf (\'%s: SQL_MESSAGE: %s\', current_proc_name(), __SQL_MESSAGE);\n"
"goto load_grddl_after_error;\n"
"};\n"
"\n"
"\n"
"rdf_fmt := 1;\n"
"if (groupdest is not null and groupdest <> coalesce (dest, graph_iri))\n"
"DB.DBA.RDF_LOAD_XHTML_MICRODATA (ret_body, base, groupdest);\n"
"if (exists (select 1 from DB.DBA.SYS_RDF_MAPPERS where (RM_TYPE = \'URL\' and regexp_match (RM_PATTERN, new_origin_uri) or\n"
"RM_TYPE=\'MIME\' and regexp_match(RM_PATTERN, ret_content_type)) and RM_ENABLED = 1))\n"
"goto load_grddl;\n"
"if (__proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\') and only_rdfa = 0)\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"else if (only_rdfa = 1 and (strstr (ret_content_type, \'text/html\') is not null or strstr (ret_content_type, \'application/xhtml+xml\') is not null))\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_printf (\'%s: SQL_MESSAGE: %s\', current_proc_name(), __SQL_MESSAGE);\n"
"goto load_grddl_after_error;\n"
"};\n"
"\n"
"DB.DBA.RDF_LOAD_RDFA (ret_body, base, coalesce (dest, graph_iri));\n"
"rdf_fmt := 1;\n"
"if (groupdest is not null and groupdest <> coalesce (dest, graph_iri))\n"
"DB.DBA.RDF_LOAD_RDFA (ret_body, base, groupdest);\n"
"\n"
"if (aq is not null)\n"
"aq_request (aq, \'DB.DBA.RDF_SW_PING\', vector (ps, new_origin_uri));\n"
"return 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"load_grddl:;\n"
"\n"
"if (get_soft = \'no-sponge\')\n"
"goto no_cart;\n"
"\n"
"if ((\'40001\' = __SQL_STATE) and (retr_count < 10))\n"
"{\n"
"rollback work;\n"
"retr_count := retr_count + 1;\n"
"goto retry_after_deadlock;\n"
"}\n"
"if (__proc_exists (\'DB.DBA.RDF_RUN_CARTRIDGES\') is not null)\n"
"{\n"
"rc := DB.DBA.RDF_RUN_CARTRIDGES (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options, ret_hdr, ps, aq, req_hdr_arr);\n"
"if (rc)\n"
"return rc;\n"
"}\n"
"else\n"
"{\n"
"cset := http_request_header (ret_hdr, \'Content-Type\', \'charset\', null);\n"
"for select RM_PATTERN, RM_TYPE, RM_HOOK, RM_KEY, RM_OPTIONS, RM_DESCRIPTION from DB.DBA.SYS_RDF_MAPPERS where RM_ENABLED = 1 order by RM_ID do\n"
"{\n"
"declare val_match, pcols, new_opts any;\n"
"declare npars int;\n"
"\n"
"if (RM_TYPE = \'MIME\')\n"
"{\n"
"val_match := ret_content_type;\n"
"}\n"
"else if (RM_TYPE = \'URL\' or RM_TYPE = \'HTTP\')\n"
"{\n"
"val_match := new_origin_uri;\n"
"}\n"
"else\n"
"val_match := null;\n"
"\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_obj_prin1 (\'Trying \', RM_HOOK);\n"
"if (isstring (val_match) and regexp_match (RM_PATTERN, val_match) is not null)\n"
"{\n"
"if (__proc_exists (RM_HOOK) is null)\n"
"goto try_next_mapper;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"goto try_next_mapper;\n"
"};\n"
"pcols := DB.DBA.RDF_PROC_COLS (RM_HOOK);\n"
"npars := 8;\n"
"if (isarray (pcols))\n"
"npars := length (pcols);\n"
"\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"dbg_obj_prin1 (\'Match \', RM_HOOK);\n"
"new_opts := vector_concat (options, RM_OPTIONS, vector (\'content-type\', ret_content_type, \'charset\', cset));\n"
"if (__proc_exists (\'DB.DBA.RDF_SPONGER_STATUS\'))\n"
"call (\'DB.DBA.RDF_SPONGER_STATUS\') (graph_iri, new_origin_uri, dest, RM_DESCRIPTION, options);\n"
"if (RM_TYPE <> \'HTTP\')\n"
"{\n"
"if (npars = 7)\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, RM_KEY);\n"
"else\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, RM_KEY, new_opts);\n"
"}\n"
"else\n"
"{\n"
"if (npars = 7)\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, vector (req_hdr_arr, ret_hdr));\n"
"else\n"
"rc := call (RM_HOOK) (graph_iri, new_origin_uri, dest, ret_body, aq, ps, vector (req_hdr_arr, ret_hdr), new_opts);\n"
"}\n"
"if (registry_get (\'__sparql_mappers_debug\') = \'1\')\n"
"{\n"
"dbg_obj_prin1 (\'Return \', rc, RM_HOOK);\n"
"if (__tag(rc) = 193 or rc < 0 or rc > 0)\n"
"dbg_obj_prin1 (\'END of mappings\');\n"
"}\n"
"if (__tag(rc) = 193 or rc < 0 or rc > 0)\n"
"{\n"
"if (rc > 0 and __proc_exists (\'DB.DBA.RDF_LOAD_POST_PROCESS\'))\n"
"call (\'DB.DBA.RDF_LOAD_POST_PROCESS\') (graph_iri, new_origin_uri, dest, ret_body, ret_content_type, options);\n"
"if (__tag(rc) = 193)\n"
"return rc;\n"
"return (case when rc < 0 then 0 else 1 end);\n"
"}\n"
"}\n"
"try_next_mapper:;\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"no_cart:\n"
"\n"
"if (rdf_fmt)\n"
"return 1; \n"
"\n"
"if ((dest is null) and (get_soft is null or (get_soft <> \'add\')))\n"
"{\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 1, 0);\n"
"commit work;\n"
"}\n"
"if (strstr (ret_content_type, \'text/plain\') is not null)\n"
"{\n"
"\n"
"signal (\'RDFXX\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\' body %.300s\',\n"
"graph_iri, new_origin_uri, ret_content_type, ret_hdr[0], subseq (ret_body, 0, 300) ) );\n"
"}\n"
"if (strstr (ret_content_type, \'text/html\') is not null)\n"
"{\n"
"\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned Content-Type \'\'%.300s\'\' status \'\'%.300s\'\'\\n%.300s\',\n"
"graph_iri, new_origin_uri, ret_content_type, ret_hdr[0],\n"
"\n"
"subseq (ret_body, 0, 300) ) );\n"
"}\n"
"if (isstring (first_stat))\n"
"{\n"
"\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to load RDF graph <%.200s> from <%.200s> with Content-Type \'\'%.50s\'\': %.6s: %.1000s\',\n"
"graph_iri, new_origin_uri, ret_content_type, first_stat, first_msg ) );\n"
"}\n"
"\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'Unable to load RDF graph <%.500s> from <%.500s>: returned unsupported Content-Type \'\'%.300s\'\'\',\n"
"graph_iri, new_origin_uri, ret_content_type ) );\n"
"resignal_parse_error:\n"
"\n"
"\n"
"resignal;\n"
"\n"
"load_grddl_after_error:\n"
"first_stat := __SQL_STATE;\n"
"first_msg := __SQL_MESSAGE;\n"
"if ((\'40001\' = first_stat) and (retr_count < 10))\n"
"{\n"
"rollback work;\n"
"retr_count := retr_count + 1;\n"
"goto retry_after_deadlock;\n"
"}\n"
"goto load_grddl;\n"
"}\n"
"--src rdf_sponge.sql:1648\n";

static const char *proc505 = 
"#line 1972 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_FORGET_HTTP_RESPONSE (in graph_iri varchar, in new_origin_uri varchar, inout options any)\n"
"{\n"
"declare dest varchar;\n"
"declare deadl int;\n"
"deadl := atoi (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'MaxDeadlockRetries\'), \'5\'));\n"
"declare exit handler for sqlstate \'40001\'\n"
"{\n"
"deadl := deadl - 1;\n"
"rollback work;\n"
"if (deadl > 0)\n"
"{\n"
"delay (0.2);\n"
"goto again;\n"
"}\n"
"resignal;\n"
"};\n"
"again:\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is null)\n"
"DB.DBA.SPARUL_CLEAR (graph_iri, 1, 0);\n"
"commit work;\n"
"}\n"
"--src rdf_sponge.sql:1970\n";

static const char *proc506 = 
"#line 1996 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_UP (in graph_iri varchar, in options any, in uid integer := -1)\n"
"{\n"
"declare aq, cookie varchar;\n"
"declare dest, local_iri varchar;\n"
"\n"
"if (coalesce (virtuoso_ini_item_value (\'SPARQL\', \'AsyncQueue\'), \'0\') = \'0\' or get_keyword (\'__rdf_sponge_queue\', options) = 1)\n"
"{\n"
"return DB.DBA.RDF_SPONGE_UP_1 (graph_iri, options, uid);\n"
"}\n"
"commit work;\n"
"\n"
"cookie := connection_get (\'__rdf_sponge_sid\');\n"
"if (cookie is not null)\n"
"options := vector_concat (options, vector (\'rdf_sponge_sid\', cookie));\n"
"if (connection_get (\'__rdf_sponge_debug\') is not null)\n"
"options := vector_concat (options, vector (\'rdf_sponge_debug\', connection_get (\'__rdf_sponge_debug\')));\n"
"if (is_http_ctx ())\n"
"options := vector_concat (options, vector (\'http_host\', http_request_header(http_request_header (), \'Host\', null, null)));\n"
"options := vector_concat (options, vector (\'__rdf_sponge_log_mode\', log_enable (null, 1)));\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.RDF_SPONGE_UP_1\', vector (graph_iri, options, uid));\n"
"commit work;\n"
"aq_wait_all (aq);\n"
"\n"
"graph_iri := cast (graph_iri as varchar);\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is not null)\n"
"local_iri := \'destMD5=\' || md5(dest) || \'&graphMD5=\' || md5(graph_iri);\n"
"else\n"
"local_iri := graph_iri;\n"
"return local_iri;\n"
"}\n"
"--src rdf_sponge.sql:1994\n";

static const char *proc507 = 
"#line 2030 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_UP_1 (in graph_iri varchar, in options any, in uid integer := -1)\n"
"{\n"
"declare dest, get_soft, local_iri, immg, res_graph_iri, cookie, get_private varchar;\n"
"declare perms, log_mode integer;\n"
"\n"
"graph_iri := cast (graph_iri as varchar);\n"
"\n"
"dest := get_keyword_ucase (\'get:destination\', options);\n"
"if (dest is not null)\n"
"local_iri := \'destMD5=\' || md5(dest) || \'&graphMD5=\' || md5(graph_iri);\n"
"else\n"
"dest := local_iri := graph_iri;\n"
"cookie := get_keyword (\'rdf_sponge_sid\', options);\n"
"if (cookie is not null)\n"
"connection_set (\'__rdf_sponge_sid\', cookie);\n"
"if (get_keyword (\'rdf_sponge_debug\', options) is not null)\n"
"connection_set (\'__rdf_sponge_debug\', get_keyword (\'rdf_sponge_debug\', options));\n"
"if (get_keyword (\'http_host\', options) is not null)\n"
"connection_set (\'__http_host\', get_keyword (\'http_host\', options));\n"
"log_mode := get_keyword (\'__rdf_sponge_log_mode\', options);\n"
"if (log_mode is not null)\n"
"log_enable (log_mode, 1);\n"
"\n"
"get_soft := get_keyword_ucase (\'get:soft\', options);\n"
"if (isstring  (uid))\n"
"uid := get_user_id_by_name (uid);\n"
"if (\'soft\' = get_soft)\n"
"{\n"
"if ((dest = graph_iri) and exists (select 1 from DB.DBA.RDF_QUAD table option (index G) where G = iri_to_id (graph_iri, 0) ) and\n"
"not exists (select 1 from DB.DBA.SYS_HTTP_SPONGE\n"
"where HS_LOCAL_IRI = local_iri and HS_PARSER = \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\' and\n"
"HS_EXPIRATION is not null))\n"
"{\n"
"\n"
"perms := DB.DBA.RDF_GRAPH_USER_PERMS_GET (dest, case (uid) when -1 then http_nobody_uid() else uid end);\n"
"if (not bit_and (perms, 1))\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"res_graph_iri := local_iri;\n"
"goto graph_is_ready;\n"
"}\n"
"\n"
"}\n"
"else\n"
"if ((\'replacing\' = get_soft) or (\'replace\' = get_soft) or (\'add\' = get_soft) or (\'no-sponge\' = get_soft))\n"
"{\n"
"\n"
" ;\n"
"}\n"
"else\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'This version of Virtuoso supports only \"soft\", \"replacing\" and \"add\" values of \"define get:soft ...\", not \"%.500s\"\',\n"
"get_soft ) );\n"
"get_private := get_keyword_ucase (\'get:private\', options, null);\n"
"if (get_private is not null)\n"
"DB.DBA.RDF_GRAB_PREPARE_PRIVATE (graph_iri, get_private, user, options);\n"
"else\n"
"{\n"
"perms := DB.DBA.RDF_GRAPH_USER_PERMS_GET (dest, case (uid) when -1 then http_nobody_uid() else uid end);\n"
"if (not bit_and (perms, 4))\n"
"{\n"
"if (get_keyword_ucase (\'get:error-recovery\', options, \'signal\') = \'signal\')\n"
"signal (\'RDFZZ\', sprintf (\n"
"\'The graph <%.500s> is not sponged by RDF_SPONGE_UP_1 due to lack of sponge permission for user %d\', dest, case (uid) when -1 then http_nobody_uid() else uid end ) );\n"
"\n"
"return null;\n"
"}\n"
"}\n"
"\n"
"\n"
"immg := virtuoso_ini_item_value (\'SPARQL\', \'ImmutableGraphs\');\n"
"if (immg is not null and user <> \'dba\')\n"
"{\n"
"immg := split_and_decode (immg, 0, \'\\0\\0,\');\n"
"foreach (any imm in immg) do\n"
"{\n"
"imm := trim (imm);\n"
"if (imm = dest)\n"
"{\n"
"res_graph_iri := dest;\n"
"\n"
"goto graph_is_ready;\n"
"}\n"
"if (imm = \'inference-graphs\' and exists (select 1 from DB.DBA.SYS_RDF_SCHEMA where RS_URI = dest))\n"
"{\n"
"res_graph_iri := dest;\n"
"\n"
"goto graph_is_ready;\n"
"}\n"
"\n"
"if (dest like imm)\n"
"{\n"
"res_graph_iri := local_iri;\n"
"goto graph_is_ready;\n"
"}\n"
"}\n"
"}\n"
"\n"
"set_user_id (\'dba\', 1);\n"
"if (lower (graph_iri) like \'file:%\')\n"
"{\n"
"res_graph_iri := DB.DBA.SYS_FILE_SPONGE_UP (local_iri, graph_iri, null, \'DB.DBA.RDF_FORGET_HTTP_RESPONSE\', options);\n"
"goto graph_is_ready;\n"
"}\n"
"else if (lower (graph_iri) like \'http:%\' or lower (graph_iri) like \'https:%\')\n"
"{\n"
"res_graph_iri := DB.DBA.SYS_HTTP_SPONGE_UP (local_iri, graph_iri, \'DB.DBA.RDF_LOAD_HTTP_RESPONSE\', \'DB.DBA.RDF_FORGET_HTTP_RESPONSE\', options);\n"
"goto graph_is_ready;\n"
"}\n"
"else\n"
"{\n"
"declare sch any;\n"
"sch := rfc1808_parse_uri (graph_iri);\n"
"sch := upper (sch[0]);\n"
"\n"
"if (__proc_exists (\'DB.DBA.SYS_\'||sch||\'_SPONGE_UP\') is not null)\n"
"{\n"
"res_graph_iri := call (\'DB.DBA.SYS_\'||sch||\'_SPONGE_UP\') (local_iri, graph_iri, options);\n"
"goto graph_is_ready;\n"
"}\n"
"else\n"
"{\n"
"\n"
"return null;\n"
"}\n"
"}\n"
"graph_is_ready:\n"
"\n"
"if (__rdf_obj_ft_rule_check (iri_to_id (res_graph_iri), null) and\n"
"coalesce (get_keyword (\'refresh_free_text\', options), 0) )\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"return res_graph_iri;\n"
"}\n"
"--src rdf_sponge.sql:2028\n";

static const char *proc508 = 
"#line 2167 \"[executable]/rdf_sponge.sql\"\n"
"create function DB.DBA.RDF_SPONGE_UP_LIST (in sources any)\n"
"{\n"
"declare need_reindex integer;\n"
"declare aq any;\n"
"need_reindex := 0;\n"
"aq := async_queue (8);\n"
"foreach (any src in sources) do\n"
"{\n"
"declare res_graph_iri any;\n"
"res_graph_iri := DB.DBA.RDF_SPONGE_UP (src[0], vector_concat (vector (\'refresh_free_text\', 0), src[1]));\n"
"if (__rdf_obj_ft_rule_check (iri_to_id (res_graph_iri), null) and\n"
"coalesce (get_keyword (\'refresh_free_text\', src[1]), 0) )\n"
"need_reindex := 1;\n"
"}\n"
"if (need_reindex)\n"
"VT_INC_INDEX_DB_DBA_RDF_OBJ();\n"
"return 1;\n"
"}\n"
"--src rdf_sponge.sql:2165\n";

static const char *proc509 = 
"#line 2188 \"[executable]/rdf_sponge.sql\"\n"
"create procedure DB.DBA.RDF_GRANT_SPONGE ()\n"
"{\n"
"declare state, msg varchar;\n"
"declare cmds any;\n"
"cmds := vector (\n"
"\'create role SPARQL_SPONGE\',\n"
"\'grant SPARQL_SELECT to SPARQL_SPONGE\',\n"
"\'grant SPARQL_SPONGE to SPARQL_UPDATE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SINGLE to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SINGLE_ASYNC to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB_SEEALSO to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_GRAB to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.SPARQL_EVAL_TO_ARRAY to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.SPARQL_EVAL to SPARQL_SELECT\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP_1 to SPARQL_SPONGE\',\n"
"\'grant execute on DB.DBA.RDF_SPONGE_UP_LIST to SPARQL_SPONGE\' );\n"
"foreach (varchar cmd in cmds) do\n"
"{\n"
"exec (cmd, state, msg);\n"
"}\n"
"}\n"
"--src rdf_sponge.sql:2186\n";


static const char *other51 = 
" DB.DBA.RDF_GRANT_SPONGE ()\n";
static const char *other52 = 
"insert soft DB.DBA.SYS_XPF_EXTENSIONS (XPE_NAME, XPE_PNAME) values (\'http://www.openlinksw.com/virtuoso/xslt/:docproxyIRI\',\'DB.DBA.RDF_SPONGE_PROXY_IRI\')\n";
static const char *other53 = 
"xpf_extension (\'http://www.openlinksw.com/virtuoso/xslt/:docproxyIRI\', \'DB.DBA.RDF_SPONGE_PROXY_IRI\', 0)\n";
/* rdf_schema_objects.sql */

static const char *proc510 = 
"#line 31 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_tbl_opts (in tbls any, in cols any)\n"
"{\n"
"declare res any;\n"
"declare inx, len int;\n"
"len := length (tbls);\n"
"if (not isarray (cols) or length (cols) <> len)\n"
"cols := make_array (len, \'any\');\n"
"res := make_array (len * 2, \'any\');\n"
"inx := 0;\n"
"foreach (varchar t in tbls) do\n"
"{\n"
"declare col_cnt int;\n"
"col_cnt := (select count(*) from TABLE_COLS where \"TABLE\" = t and \"COLUMN\" <> \'_IDN\');\n"
"res [inx * 2] := t;\n"
"if (isarray (cols[inx]) and length (cols[inx]) = 2 and isarray (cols[inx][1]) and length (cols[inx][1]) = col_cnt)\n"
"res [(inx * 2) + 1] := cols [inx];\n"
"else\n"
"{\n"
"declare newcols, i any;\n"
"newcols := make_array (col_cnt, \'any\');\n"
"i := 0;\n"
"for select \"COLUMN\", COL_DTP from TABLE_COLS where \"TABLE\" = t and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"if (COL_DTP <> 131)\n"
"newcols [i] := vector (0, null);\n"
"else\n"
"newcols [i] := vector (\'application/octet-stream\', null);\n"
"i := i + 1;\n"
"}\n"
"res [(inx * 2) + 1] := vector (null, newcols);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src rdf_schema_objects.sql:29\n";

static const char *proc511 = 
"#line 68 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_tbl_pk_cols (inout tbls any, out pkcols any)\n"
"{\n"
"declare i, l, mixed int;\n"
"i := 0;\n"
"mixed := 0;\n"
"l := length (tbls);\n"
"if (mod (l, 2) = 0)\n"
"{\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"if (__tag (tbls[i+1]) = 193)\n"
"mixed := 1;\n"
"}\n"
"}\n"
"if (mixed)\n"
"{\n"
"declare newtb any;\n"
"newtb := make_array (l/2, \'any\');\n"
"pkcols := make_array (l, \'any\');\n"
"for (i := 0; i < l; i := i + 2)\n"
"{\n"
"declare cols any;\n"
"declare j int;\n"
"newtb[i/2] := tbls[i];\n"
"if (__tag (tbls [i + 1]) = 193)\n"
"{\n"
"cols := make_array (length (tbls [i + 1]), \'any\');\n"
"j := 0;\n"
"foreach (varchar c in tbls [i + 1]) do\n"
"{\n"
"cols[j] := (select vector (sc.\"COLUMN\", sc.\"COL_DTP\", sc.\"COL_SCALE\", sc.\"COL_PREC\")\n"
"from DB.DBA.TABLE_COLS sc where upper (sc.\"COLUMN\") = upper (c) and upper (\"TABLE\") = upper (tbls[i]) and \"COLUMN\" <> \'_IDN\');\n"
"if (length (cols[j]) = 0)\n"
"signal (\'22023\', sprintf (\'Non existing column %s for table %s\', c, tbls[i]));\n"
"j := j + 1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"cols := rdf_view_get_primary_key (tbls[i]);\n"
"}\n"
"pkcols[i] := tbls[i];\n"
"pkcols[i+1] := cols;\n"
"}\n"
"tbls := newtb;\n"
"}\n"
"else\n"
"{\n"
"pkcols := make_array (l*2, \'any\');\n"
"for (i := 0; i < l; i := i + 1)\n"
"{\n"
"pkcols[i*2] := tbls[i];\n"
"pkcols[(i*2)+1] := rdf_view_get_primary_key (tbls[i]);\n"
"}\n"
"}\n"
"foreach (varchar t in tbls) do\n"
"{\n"
"if (not exists (select 1 from SYS_KEYS where KEY_TABLE = t))\n"
"signal (\'22023\', sprintf (\'Non existing table %s\', t));\n"
"}\n"
"}\n"
"--src rdf_schema_objects.sql:66\n";

static const char *proc512 = 
"#line 131 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_ns_get (in cols any, in f int)\n"
"{\n"
"declare ses, dict, nss any;\n"
"declare i int;\n"
"ses := string_output ();\n"
"dict := dict_new ();\n"
"for (i := 0; i < length (cols); i := i + 2)\n"
"rdf_view_ns_get_1 (cols[i+1], dict);\n"
"nss := dict_to_vector (dict, 1);\n"
"for (declare i int, i := 0; i < length (nss); i := i + 2)\n"
"{\n"
"if (nss [i] not in (\'rdf\', \'rdfs\', \'scovo\', \'sioc\', \'aowl\', \'xsd\', \'virtrdf\'))\n"
"{\n"
"if (f)\n"
"http (sprintf (\'@prefix %s: <%s> . \\n\', nss[i], nss[i+1]), ses);\n"
"else\n"
"http (sprintf (\'prefix %s: <%s>  \\n\', nss[i], nss[i+1]), ses);\n"
"}\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src rdf_schema_objects.sql:129\n";

static const char *proc513 = 
"#line 154 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_ns_get_1 (in cols any, inout dict any)\n"
"{\n"
"declare class any;\n"
"declare ns, uri any;\n"
"\n"
"\n"
"class := cols[0];\n"
"cols := cols[1];\n"
"ns := rdf_view_get_ns (class, uri);\n"
"if (length (ns))\n"
"dict_put (dict, ns, uri);\n"
"foreach (any p in cols) do\n"
"{\n"
"ns := null;\n"
"\n"
"if (length (p[1]))\n"
"ns := rdf_view_get_ns (p[1], uri);\n"
"if (length (ns))\n"
"dict_put (dict, ns, uri);\n"
"}\n"
"}\n"
"--src rdf_schema_objects.sql:152\n";

static const char *proc514 = 
"#line 177 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_DROP_STMT_BY_GRAPH (in gr varchar)\n"
"{\n"
"declare drop_map any;\n"
"\n"
"drop_map := \'\';\n"
"for select \"s\" from (sparql define input:storage \"\"\n"
"select ?s from virtrdf:\n"
"{\n"
"?s virtrdf:qmGraphRange-rvrFixedValue `iri(?:gr)` ; virtrdf:qmUserSubMaps ?t\n"
"}) x do\n"
"{\n"
"drop_map := drop_map || sprintf (\'SPARQL drop silent quad map <%s> .;\\n\', \"s\");\n"
"}\n"
"return drop_map;\n"
"}\n"
"--src rdf_schema_objects.sql:175\n";

static const char *proc515 = 
"#line 195 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_DROP_STMT (in qualifier varchar)\n"
"{\n"
"declare drop_map any;\n"
"declare gr varchar;\n"
"\n"
"drop_map := \'\';\n"
"gr := sprintf (\'http://%s/%s#\', virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qualifier);\n"
"return RDF_VIEW_DROP_STMT_BY_GRAPH (gr);\n"
"}\n"
"--src rdf_schema_objects.sql:193\n";

static const char *proc516 = 
"#line 207 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_FROM_TBL (in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any := null)\n"
"{\n"
"declare create_count_count, create_class_stmt, create_view_stmt, sparql_pref, ns, sns, uriqa_str, ret, drop_map any;\n"
"declare total_select, total_tb, total, qual, pkcols any;\n"
"declare vname, mask varchar;\n"
"\n"
"ret := make_array (2, \'any\');\n"
"rdf_view_tbl_pk_cols (_tbls, pkcols);\n"
"cols := rdf_view_tbl_opts (_tbls, cols);\n"
"sparql_pref := \'SPARQL\\n\';\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"sns := ns := sprintf (\'prefix %s: <http://%s/schemas/%s/> \\n\', qualifier, virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qualifier);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (gen_stat)\n"
"{\n"
"ns := ns || sprintf (\'prefix %s-stat: <http://%s/%s/stat#> \\n\', lcase (qualifier), virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'),\n"
"qualifier);\n"
"ns := ns || \'prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \\n\';\n"
"ns := ns || \'prefix void: <http://rdfs.org/ns/void#> \\n\';\n"
"ns := ns || \'prefix scovo: <http://purl.org/NET/scovo#> \\n\';\n"
"}\n"
"\n"
"ns := ns || \'prefix aowl: <http://bblfish.net/work/atom-owl/2006-06-06/> \\n\';\n"
"ns := ns || rdf_view_ns_get (cols, 0);\n"
"create_class_stmt := \'\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"create_class_stmt := create_class_stmt || rdf_view_create_class (sparql_pref || sns, _tbls[xx], uriqa_str, qualifier, cols, pkcols);\n"
"\n"
"\n"
"create_count_count := \'\';\n"
"total_select := \'\';\n"
"total_tb := \'\';\n"
"for (declare xx any, xx := 0; gen_stat and xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"vname := _tbls[xx]||\'Count\';\n"
"total_select := total_select || sprintf (\'(cnt%d*cnt%d)+\', xx*2, (xx*2)+1);\n"
"total_tb := total_tb ||\n"
"sprintf (\'\\n (select count(*) cnt%d from \"%I\".\"%I\".\"%I\") tb%d, \\n (select count(*)+1 as cnt%d from DB.DBA.TABLE_COLS where \"TABLE\" = \'\'%S\'\'  and \"COLUMN\" <> \'\'_IDN\'\') tb%d,\',\n"
"xx*2, name_part (_tbls[xx], 0), name_part (_tbls[xx], 1), name_part (_tbls[xx], 2), xx*2, (xx*2)+1, _tbls[xx], (xx*2)+1);\n"
"if (not exists (select 1 from SYS_VIEWS where V_NAME = vname))\n"
"{\n"
"create_count_count := create_count_count || sprintf (\'create view \"%I\".\"%I\".\"%ICount\" as select count (*) as cnt from \"%I\".\"%I\".\"%I\"; \\n\',\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2),\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2));\n"
"create_count_count := create_count_count || sprintf (\'grant select on \"%I\".\"%I\".\"%ICount\" to SPARQL_SELECT; \\n\',\n"
"name_part (_tbls[xx], 0),\n"
"name_part (_tbls[xx], 1),\n"
"name_part (_tbls[xx], 2));\n"
"}\n"
"}\n"
"\n"
"if (gen_stat and length (_tbls))\n"
"{\n"
"declare own any;\n"
"own := name_part (_tbls[0], 1);\n"
"qual := name_part (_tbls[0], 0);\n"
"vname := qual||\'.\'||own||\'.\'||qualifier||\'__Total\';\n"
"total_select := rtrim (total_select, \'+\') || \' AS cnt\';\n"
"total_tb := rtrim (total_tb, \',\');\n"
"total := sprintf (\'drop view \"%I\".\"%I\".\"%I__Total\"; \\n\', qual, own, qualifier);\n"
"\n"
"total := total || sprintf (\'create view \"%I\".\"%I\".\"%I__Total\" as select \' || total_select || \' from \' || total_tb || \'\\n\',\n"
"qual, own, qualifier);\n"
"create_count_count := create_count_count || total || \'; \\n\';\n"
"create_count_count := create_count_count || sprintf (\'grant select on \"%I\".\"%I\".\"%I__Total\" to SPARQL_SELECT; \\n\',\n"
"qual, own, qualifier);\n"
"\n"
"}\n"
"\n"
"if (create_count_count <> \'\')\n"
"create_count_count := create_count_count || \'\\n\\n\';\n"
"\n"
"create_view_stmt := \'\';\n"
"for (declare inx int, inx := 0; inx < length (_tbls) ; inx := inx + 1)\n"
"create_view_stmt := create_view_stmt || sparql_pref || ns || rdf_view_create_view (inx, qualifier, _tbls, gen_stat, cols, pkcols) || \'\\n;\\n\\n\';\n"
"\n"
"if (gen_stat)\n"
"create_view_stmt := create_view_stmt || sparql_pref || ns || rdf_view_create_void_view (qualifier, _tbls, gen_stat, cols, pkcols) || \'\\n;\\n\\n\';\n"
"\n"
"return create_class_stmt || \'\\n\\n\' || create_count_count || create_view_stmt;\n"
"}\n"
"--src rdf_schema_objects.sql:205\n";

static const char *proc517 = 
"#line 302 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_sp (in i int)\n"
"{\n"
"return repeat (\' \', i);\n"
"}\n"
"--src rdf_schema_objects.sql:300\n";

static const char *proc518 = 
"#line 309 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_sql_tb (in tb varchar)\n"
"{\n"
"declare q, o, n varchar;\n"
"q := name_part (tb, 0);\n"
"o := name_part (tb, 1);\n"
"n := name_part (tb, 2);\n"
"return sprintf (\'\"%I\".\"%I\".\"%I\"\', q, o, n);\n"
"}\n"
"--src rdf_schema_objects.sql:307\n";

static const char *proc519 = 
"#line 319 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_tb (in tb varchar)\n"
"{\n"
"declare r varchar;\n"
"r := DB.DBA.SYS_ALFANUM_NAME (tb);\n"
"r := lower (r);\n"
"return r;\n"
"}\n"
"--src rdf_schema_objects.sql:317\n";

static const char *proc520 = 
"#line 328 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_sql_col (in col varchar)\n"
"{\n"
"return sprintf (\'\"%I\"\', col);\n"
"}\n"
"--src rdf_schema_objects.sql:326\n";

static const char *proc521 = 
"#line 334 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_col (in col varchar)\n"
"{\n"
"declare r varchar;\n"
"r := DB.DBA.SYS_ALFANUM_NAME (col);\n"
"r := lower (r);\n"
"return r;\n"
"}\n"
"--src rdf_schema_objects.sql:332\n";

static const char *proc522 = 
"#line 343 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_cls_name (in nam varchar)\n"
"{\n"
"\n"
"return SYS_ALFANUM_NAME (nam);\n"
"}\n"
"--src rdf_schema_objects.sql:341\n";

static const char *proc523 = 
"#line 350 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_get_ns (in uri varchar, out uriSearch varchar)\n"
"{\n"
"declare delim integer;\n"
"declare nsPrefix varchar;\n"
"\n"
"delim := -1;\n"
"uriSearch := uri;\n"
"nsPrefix := null;\n"
"if (length (uri) = 0)\n"
"return null;\n"
"while (nsPrefix is null and delim <> 0)\n"
"{\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"nsPrefix := coalesce (__xml_get_ns_prefix (subseq (uriSearch, 0, delim + 1), 2),\n"
"__xml_get_ns_prefix (subseq (uriSearch, 0, delim),     2));\n"
"uriSearch := subseq (uriSearch, 0, delim + 1);\n"
"}\n"
"if (nsPrefix is null)\n"
"{\n"
"declare cnt int;\n"
"uriSearch := uri;\n"
"delim := -1;\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"if (delim > 0)\n"
"uriSearch := subseq (uriSearch, 0, delim + 1);\n"
"cnt := 0;\n"
"while (__xml_get_ns_uri (sprintf (\'rv%d\', cnt), 2) is not null)\n"
"{\n"
"cnt := cnt + 1;\n"
"}\n"
"nsPrefix := sprintf (\'rv%d\', cnt);\n"
"if (uri = \'\')\n"
"signal (\'.....\', \'Empty IRI is not allowed here\');\n"
"DB.DBA.XML_SET_NS_DECL (nsPrefix, uriSearch, 2);\n"
"}\n"
"return nsPrefix;\n"
"}\n"
"--src rdf_schema_objects.sql:348\n";

static const char *proc524 = 
"#line 393 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_uri_curie (in uri varchar)\n"
"{\n"
"declare delim integer;\n"
"declare uriSearch, nsPrefix varchar;\n"
"\n"
"delim := -1;\n"
"uriSearch := uri;\n"
"nsPrefix := null;\n"
"while (nsPrefix is null and delim <> 0)\n"
"{\n"
"delim := coalesce (strrchr (uriSearch, \'/\'), 0);\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \'#\'), 0));\n"
"delim := __max (delim, coalesce (strrchr (uriSearch, \':\'), 0));\n"
"nsPrefix := coalesce (__xml_get_ns_prefix (subseq (uriSearch, 0, delim + 1), 2),\n"
"__xml_get_ns_prefix (subseq (uriSearch, 0, delim),     2));\n"
"uriSearch := subseq (uriSearch, 0, delim);\n"
"}\n"
"if (nsPrefix is not null)\n"
"{\n"
"declare rhs varchar;\n"
"rhs := subseq(uri, length (uriSearch) + 1, null);\n"
"if (not length (rhs))\n"
"return uri;\n"
"else\n"
"return nsPrefix || \':\' || rhs;\n"
"}\n"
"return uri;\n"
"}\n"
"--src rdf_schema_objects.sql:391\n";

static const char *proc525 = 
"#line 423 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure rdf_view_col_type (in qual varchar, in col varchar, in opts any)\n"
"{\n"
"if (not length (opts))\n"
"return sprintf (\'%s:%s\', qual, col);\n"
"else\n"
"return rdf_view_uri_curie (opts);\n"
"}\n"
"--src rdf_schema_objects.sql:421\n";

static const char *proc526 = 
"#line 432 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_create_view (in nth int, in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str any;\n"
"declare suffix, tname, tbl, own, pref_l any;\n"
"declare cols_arr, inx, col_name, owner, owner_l any;\n"
"\n"
"ret := \'alter quad storage virtrdf:DefaultQuadStorage \\n\';\n"
"suffix := \'_s\';\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"qual := name_part (_tbls[nth], 0);\n"
"own := name_part (_tbls[nth], 1);\n"
"qual_l := lcase (qual);\n"
"pref_l := lcase (qualifier);\n"
"tbl := _tbls[nth];\n"
"cols_arr := get_keyword (tbl, cols);\n"
"tbl_name := name_part (tbl, 2);\n"
"owner := name_part (tbl, 1);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"owner_l := rdf_view_tb (owner);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"\n"
"ret := ret || \' from \' || rdf_view_sql_tb (tbl) || \' as \' || rdf_view_tb (name_part (tbl, 3) || suffix) || \'\\n\';\n"
"\n"
"ret := ret || rdf_view_get_relations (tbl, _tbls, suffix);\n"
"\n"
"ret := ret || sprintf (\' { \\n   create %s:qm-%s\', qualifier, tbl_name_l) ||\n"
"\' as graph iri (\"http://\' || uriqa_str || \'/\' || qualifier || \'#\") \';\n"
"\n"
"if (gen_stat = 0 and nth = (length (_tbls) - 1))\n"
"ret := ret || \'option (exclusive)\' ;\n"
"ret := ret ||\' \\n    { \\n\';\n"
"\n"
"\n"
"ret := ret || rdf_view_sp (6) || \'# Maps from columns of \"\' || tbl || \'\"\\n\';\n"
"ret := ret || rdf_view_sp (6) || rdf_view_get_pk_rel (qualifier, suffix, tbl, 0, pkcols);\n"
"ret := ret || sprintf (\' a %s:%s ;\\n\', qualifier, rdf_view_cls_name (tbl_name));\n"
"if (length (cols_arr[0]))\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' a %s ;\\n\', rdf_view_uri_curie (cols_arr[0]));\n"
"\n"
"inx := 0;\n"
"for select \"COLUMN\" from TABLE_COLS where \"TABLE\" = tbl and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"col_name := lower (\"COLUMN\");\n"
"if (cols_arr[1][inx][0] = 0 or cols_arr[1][inx][0] = 4)\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s %s.%s as %s:%s-%s-%s ;\\n\',\n"
"rdf_view_col_type (qualifier, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][1]),\n"
"tname, rdf_view_sql_col (\"COLUMN\"), qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\") );\n"
"}\n"
"else if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s %s as %s:%s-%s-%s ;\\n\',\n"
"rdf_view_col_type (qualifier, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][1]),\n"
"rdf_view_get_bin_rel (qualifier, suffix, tbl, col_name, pkcols),\n"
"qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\"));\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"if (exists (select top 1 1 from SYS_FOREIGN_KEYS where PK_TABLE = tbl and FK_TABLE <> tbl and 0 < position (FK_TABLE, _tbls))\n"
"or\n"
"exists (select top 1 1 from SYS_FOREIGN_KEYS where FK_TABLE = tbl and PK_TABLE <> tbl and 0 < position (PK_TABLE, _tbls)))\n"
"ret := ret || rdf_view_sp (6) || \'# Maps from foreign-key relations of \"\' || tbl || \'\"\\n\';\n"
"ret := ret || rdf_view_get_fk_pk_rel (qualifier, suffix, tbl, _tbls, pkcols);\n"
"ret := ret || rdf_view_get_pk_fk_rel (qualifier, suffix, tbl, _tbls, pkcols);\n"
"\n"
"ret := trim (ret, \'\\n\');\n"
"ret := trim (ret, \';\');\n"
"ret := ret || \'.\\n\';\n"
"inx := 0;\n"
"for select \"COLUMN\" from TABLE_COLS where \"TABLE\" = tbl and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"col_name := lower (\"COLUMN\");\n"
"if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s a aowl:Content ; aowl:body %s.%s as %s:%s-%s-%s-content ; aowl:type \"%s\" .\\n\',\n"
"rdf_view_get_bin_rel (qualifier, suffix, tbl, col_name, pkcols),\n"
"tname, rdf_view_sql_col (\"COLUMN\"),\n"
"qualifier, owner_l, tbl_name_l, rdf_view_col(\"COLUMN\"), cols_arr[1][inx][0]);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"ret := ret || \'\\n\';\n"
"\n"
"ret := ret || \'    }\\n }\\n\';\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:430\n";

static const char *proc527 = 
"#line 522 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_create_void_view (in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str any;\n"
"declare suffix, tname, tbl, own, pref_l any;\n"
"\n"
"uriqa_str := \'^{URIQADefaultHost}^\';\n"
"qual := name_part (_tbls[0], 0);\n"
"own := name_part (_tbls[0], 1);\n"
"qual_l := lcase (qual);\n"
"pref_l := lcase (qualifier);\n"
"\n"
"ret := \'alter quad storage virtrdf:DefaultQuadStorage \\n\';\n"
"suffix := \'_s\';\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"ret := ret || \' from \' || rdf_view_sql_tb (_tbls[xx]||\'Count\') || \' as \' || rdf_view_tb (name_part (_tbls[xx]||\'Count\', 3) || suffix) || \'\\n\';\n"
"}\n"
"ret := ret || \' from \' || rdf_view_sql_tb (qual||\'.\'||own||\'.\'||qualifier||\'__Total\') || \' as \' ||\n"
"rdf_view_tb (qualifier||\'__Total\'||suffix) || \'\\n\';\n"
"\n"
"ret := ret || sprintf (\' { \\n   create %s:qm-VoidStatistics\', qualifier) ||\n"
"\' as graph iri (\"http://\' || uriqa_str || \'/\' || qualifier || \'#\") option (exclusive) \\n    { \\n\';\n"
"\n"
"ret := ret || rdf_view_sp (6) || \'# voID Statistics \\n\';\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat: a void:Dataset as %s:dataset-%s ; \\n\', pref_l, qualifier, qual_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' void:sparqlEndpoint <http://%s/sparql> as %s:dataset-sparql-%s ; \\n\',\n"
"virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qualifier, qual_l);\n"
"\n"
"ret := ret || rdf_view_sp (6) ||	sprintf (\'void:statItem %s-stat:Stat . \\n\', pref_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat:Stat a scovo:Item ; \\n\', pref_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' rdf:value %s.cnt as %s:stat-decl-%s ; \\n\', rdf_view_tb (qualifier||\'__Total\'||suffix), qualifier, qual_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\' scovo:dimension void:numOfTriples . \\n\\n\');\n"
"\n"
"for (declare xx any, xx := 0; xx < length (_tbls) ; xx := xx + 1)\n"
"{\n"
"tbl := _tbls[xx];\n"
"tbl_name := name_part (tbl, 2);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat: void:statItem %s-stat:%sStat as %s:statitem-%s-%s . \\n\',\n"
"pref_l, pref_l, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'%s-stat:%sStat a scovo:Item as %s:statitem-decl-%s-%s ; \\n\',\n"
"pref_l, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'rdf:value %s.cnt as %s:statitem-cnt-%s-%s ; \\n\',\n"
"rdf_view_tb (tbl_name||\'Count\') || suffix, qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'scovo:dimension void:numberOfResources as %s:statitem-type-1-%s-%s ; \\n\',\n"
"qualifier, qual_l, tbl_name_l);\n"
"ret := ret || rdf_view_sp (6) || sprintf (\'scovo:dimension %s:%s as %s:statitem-type-2-%s-%s .\\n\\n\',\n"
"qualifier, rdf_view_cls_name (tbl_name), qualifier, qual_l, tbl_name_l);\n"
"}\n"
"\n"
"ret := ret || \'    }\\n }\';\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:520\n";

static const char *proc528 = 
"#line 580 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_pk_rel (in pref varchar, in suffix varchar, inout tbl varchar, in set_tb int, in  pkcols any)\n"
"{\n"
"declare pks any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text, ret varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := get_keyword (tbl, pkcols);\n"
"tname := tbl_name_l || suffix;\n"
"pk_text := \'\';\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"pk_text := pk_text || rdf_view_tb (tname) || \'.\' || rdf_view_sql_col (pks[i][0]) || \',\';\n"
"pk_text := trim (pk_text, \',\');\n"
"ret := sprintf (\'%s:%s (%s) \', pref, rdf_view_tb (tbl_name_l), pk_text);\n"
"if (set_tb)\n"
"tbl := tbl_name_l;\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:578\n";

static const char *proc529 = 
"#line 602 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_bin_rel (in pref varchar, in suffix varchar, in tbl varchar, in col_name varchar, in pkcols any)\n"
"{\n"
"declare pks any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text, ret varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := lcase (tbl_name);\n"
"pks := get_keyword (tbl, pkcols);\n"
"tname := tbl_name_l || suffix;\n"
"pk_text := \'\';\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"pk_text := pk_text || rdf_view_tb (tname) || \'.\' || rdf_view_sql_col (pks[i][0]) || \',\';\n"
"pk_text := trim (pk_text, \',\');\n"
"ret := sprintf (\'%s:%s_%s (%s) \', pref, rdf_view_tb (tbl_name_l), col_name, pk_text);\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:600\n";

static const char *proc530 = 
"#line 622 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_fk_pk_rel (in pref varchar, in suffix varchar, in tbl varchar, in tbls any, in pkcols any)\n"
"{\n"
"declare ret any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"ret := string_output ();\n"
"for select distinct PK_TABLE as pkt from SYS_FOREIGN_KEYS where FK_TABLE = tbl and PK_TABLE <> tbl and 0 < position (PK_TABLE, tbls) do\n"
"{\n"
"declare fk_rel  any;\n"
"pk_text := rdf_view_get_pk_rel (pref, suffix, pkt, 1, pkcols);\n"
"fk_rel := rdf_view_sp (6) || sprintf (\'%s:has_%s %s as %s:%s_has_%s ;\\n\', pref, rdf_view_tb (pkt), pk_text, pref, tbl_name_l, rdf_view_tb (pkt));\n"
"http (fk_rel, ret);\n"
"}\n"
"return string_output_string (ret);\n"
"}\n"
"--src rdf_schema_objects.sql:620\n";

static const char *proc531 = 
"#line 644 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_pk_fk_rel (in pref varchar, in suffix varchar, in tbl varchar, in tbls any, in pkcols any)\n"
"{\n"
"declare ret any;\n"
"declare tbl_name, tbl_name_l, tname, pk_text varchar;\n"
"\n"
"tbl_name := name_part (tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"tname := tbl_name_l || suffix;\n"
"\n"
"ret := string_output ();\n"
"for select distinct FK_TABLE as pkt from SYS_FOREIGN_KEYS where PK_TABLE = tbl and FK_TABLE <> tbl and 0 < position (FK_TABLE, tbls) do\n"
"{\n"
"declare fk_rel  any;\n"
"pk_text := rdf_view_get_pk_rel (pref, suffix, pkt, 1, pkcols);\n"
"fk_rel := rdf_view_sp (6) || sprintf (\'%s:%s_of %s as %s:%s_%s_of ;\\n\', pref, tbl_name_l, pk_text, pref, tbl_name_l, rdf_view_tb (pkt));\n"
"http (fk_rel, ret);\n"
"}\n"
"return string_output_string (ret);\n"
"}\n"
"--src rdf_schema_objects.sql:642\n";

static const char *proc532 = 
"#line 666 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_dv_to_printf_str_type (in _dv varchar, in sc int)\n"
"{\n"
"if (_dv = 189 or _dv = 188) return \'%d\';\n"
"else if (_dv = 247) return \'%ld\';\n"
"else if (_dv in (__tag of double precision, __tag of numeric) and sc = 0) return \'%d\';\n"
"else if (_dv = 182 or _dv = 225) return \'%U\';\n"
"else if (__tag of double precision = _dv) return \'%g\';\n"
"else if (__tag of real = _dv) return \'%f\';\n"
"else if (__tag of numeric = _dv) return \'%g\';\n"
"else if (__tag of date = _dv) return \'%1D\';\n"
"else if (__tag of time = _dv) return \'%1D\';\n"
"else if (__tag of datetime = _dv or __tag of timestamp = _dv) return \'%1D\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:664\n";

static const char *proc533 = 
"#line 683 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_dv_to_sql_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188 or _dv = 247) return \'integer\';\n"
"else if (_dv = 182 or _dv = 125 or _dv = 131) return \'varchar\';\n"
"else if (__tag of double precision = _dv) return \'numeric\';\n"
"else if (__tag of real = _dv) return \'float\';\n"
"else if (__tag of numeric = _dv) return \'numeric\';\n"
"else if (__tag of date = _dv) return \'date\';\n"
"else if (__tag of time = _dv) return \'time\';\n"
"else if (__tag of datetime = _dv) return \'datetime\';\n"
"else if (__tag of timestamp = _dv) return \'timestamp\';\n"
"else if (__tag of nvarchar = _dv) return \'nvarchar\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:681\n";

static const char *proc534 = 
"#line 700 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_dv_to_xsd_str_type (in _dv varchar)\n"
"{\n"
"if (_dv = 189 or _dv = 188 or _dv = 247) return \'int\';\n"
"else if (_dv = 182 or _dv = 125 or _dv = 131 or _dv = 132) return \'string\';\n"
"else if (__tag of double precision = _dv) return \'numeric\';\n"
"else if (__tag of real = _dv) return \'float\';\n"
"else if (__tag of numeric = _dv) return \'numeric\';\n"
"else if (__tag of date = _dv) return \'date\';\n"
"else if (__tag of time = _dv) return \'time\';\n"
"else if (__tag of datetime = _dv) return \'dateTime\';\n"
"else if (__tag of timestamp = _dv) return \'dateTime\';\n"
"else if (__tag of nvarchar = _dv) return \'string\';\n"
"signal (\'42000\', sprintf (\'The current implementation do no supports data type %s (%i) for IRI classes\', dv_type_title (_dv), _dv));\n"
"}\n"
"--src rdf_schema_objects.sql:698\n";

static const char *proc535 = 
"#line 717 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_create_class (in decl varchar, in _tbl varchar, in _host varchar, in qualifier varchar, in cols any, in pkcols any)\n"
"{\n"
"declare ret, qual, tbl_name, tbl_name_l, pks, pk_text, sk_str any;\n"
"declare cols_arr, inx, col_name any;\n"
"\n"
"qual := name_part (_tbl, 0);\n"
"tbl_name := name_part (_tbl, 3);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"pks := get_keyword (_tbl, pkcols);\n"
"pk_text := \'\';\n"
"sk_str := \'\';\n"
"\n"
"if (length (pks) = 0)\n"
"signal (\'22023\', sprintf (\'This version do not support tables without primary key, please remove table %s from set\', _tbl));\n"
"\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"{\n"
"pk_text := pk_text || \'in \' || \'_\' || rdf_view_cls_name (pks[i][0]) || \' \' || rdf_view_dv_to_sql_str_type(pks[i][1]) || \' not null,\';\n"
"sk_str := sk_str || \'/\' || rdf_view_cls_name (pks[i][0]) || \'/\' || rdf_view_dv_to_printf_str_type (pks[i][1], pks[i][2]);\n"
"}\n"
"pk_text := trim (pk_text, \',\');\n"
"sk_str  := trim (sk_str , \'/\');\n"
"ret := decl || sprintf (\'create iri class %s:%s \"http://%s/%s/%s/%s#this\" (%s) . ;\\n\',\n"
"qualifier, tbl_name_l, _host, qualifier, tbl_name_l, sk_str, pk_text);\n"
"cols_arr := get_keyword (_tbl, cols);\n"
"inx := 0;\n"
"for select \"COLUMN\" as col from TABLE_COLS where \"TABLE\" = _tbl and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"declare ext varchar;\n"
"col_name := lower (col);\n"
"ext := (select top 1 T_EXT from WS.WS.SYS_DAV_RES_TYPES where T_TYPE = cols_arr[1][inx][0]);\n"
"if (length (ext) > 0)\n"
"ext := \'.\' || ext;\n"
"else\n"
"ext := \'\';\n"
"ret := ret || decl || sprintf (\'create iri class %s:%s_%s \"http://%s/%s/objects/%s/%s/%s%s\" (%s) . ;\\n\',\n"
"qualifier, tbl_name_l, col_name, _host, qualifier, tbl_name_l, sk_str, col, ext, pk_text);\n"
"}\n"
"inx := inx + 1;\n"
"}\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:715\n";

static const char *proc536 = 
"#line 764 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_primary_key (in _tbl varchar)\n"
"{\n"
"return DB.DBA.REPL_PK_COLS (_tbl);\n"
"}\n"
"--src rdf_schema_objects.sql:762\n";

static const char *proc537 = 
"#line 771 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"rdf_view_get_relations (in _tbl varchar, in _tbls varchar, in _suff varchar)\n"
"{\n"
"declare ret, aliases any;\n"
"\n"
"ret := \'\';\n"
"aliases := dict_new (10);\n"
"dict_put (aliases, _tbl, 1);\n"
"foreach (any tbl in _tbls) do\n"
"for (SELECT name_part (PK_TABLE, 1) as PK_TABLE_SCHEMA,\n"
"PK_TABLE,\n"
"name_part (PK_TABLE, 2) as PK_TABLE_NAME,\n"
"PKCOLUMN_NAME as PK_COLUMN_NAME,\n"
"name_part (FK_TABLE, 1) as FK_TABLE_SCHEMA,\n"
"name_part (FK_TABLE, 2) as FK_TABLE_NAME,\n"
"FKCOLUMN_NAME AS FK_COLUMN_NAME,\n"
"KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME\n"
"FROM DB.DBA.SYS_FOREIGN_KEYS WHERE FK_TABLE = tbl and PK_TABLE <> tbl) do\n"
"\n"
"{\n"
"if (position (PK_TABLE, _tbls) <> 0 and (tbl = _tbl or PK_TABLE = _tbl))\n"
"{\n"
"declare alias any;\n"
"if (tbl = _tbl)\n"
"alias := PK_TABLE;\n"
"else\n"
"alias := tbl;\n"
"\n"
"if (dict_get (aliases, alias) is null)\n"
"{\n"
"ret := ret || \' from \' || rdf_view_sql_tb (alias) || \' as \' || rdf_view_tb (name_part (alias, 3) || _suff) || \'\\n\';\n"
"dict_put (aliases, alias, 1);\n"
"}\n"
"ret := ret || sprintf (\' where (^{%s%s.}^.\"%I\" = ^{%s%s.}^.\"%I\") \\n\',\n"
"rdf_view_tb (FK_TABLE_NAME), _suff, FK_COLUMN_NAME,\n"
"rdf_view_tb (PK_TABLE_NAME), _suff, PK_COLUMN_NAME);\n"
"}\n"
"}\n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:769\n";

static const char *proc538 = 
"#line 813 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_OWL_FROM_TBL (in qual varchar, in _tbls any, in cols any := null)\n"
"{\n"
"declare ses, cols_arr, pkcols any;\n"
"declare ns varchar;\n"
"declare inx int;\n"
"\n"
"rdf_view_tbl_pk_cols (_tbls, pkcols);\n"
"cols := rdf_view_tbl_opts (_tbls, cols);\n"
"ns := sprintf (\'@prefix %s: <http://%s/schemas/%s/> .\\n\', qual, virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qual);\n"
"ses := string_output ();\n"
"http (\'@prefix owl: <http://www.w3.org/2002/07/owl#> .\\n\', ses);\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n\', ses);\n"
"http (\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\\n\', ses);\n"
"http (\'@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\\n\', ses);\n"
"http (\'@prefix aowl: <http://bblfish.net/work/atom-owl/2006-06-06/> .\\n\', ses);\n"
"http (\'@prefix virtrdf: <http://www.openlinksw.com/schemas/virtrdf#> .\\n\', ses);\n"
"http (ns, ses);\n"
"http (rdf_view_ns_get (cols, 1), ses);\n"
"http (sprintf (\'\\n%s: a owl:Ontology .\\n\', qual), ses);\n"
"foreach (varchar tbl in _tbls) do\n"
"{\n"
"declare cls, ltb varchar;\n"
"cls := rdf_view_cls_name (name_part (tbl, 2));\n"
"ltb := rdf_view_tb (name_part (tbl, 2));\n"
"\n"
"http (sprintf (\'\\n# %s\\n\', tbl), ses);\n"
"http (sprintf (\'%s:%s a rdfs:Class .\\n\', qual, cls), ses);\n"
"http (sprintf (\'%s:%s rdfs:isDefinedBy %s: .\\n\', qual, cls, qual), ses);\n"
"http (sprintf (\'%s:%s rdfs:label \"%s\" .\\n\', qual, cls, tbl), ses);\n"
"inx := 0;\n"
"cols_arr := get_keyword (tbl, cols);\n"
"if (length (cols_arr[0]))\n"
"http (sprintf (\'%s:%s rdfs:subClassOf %s .\\n\', qual, cls, rdf_view_uri_curie (cols_arr[0])), ses);\n"
"for select \"COLUMN\" as col, COL_DTP as dtp from TABLE_COLS where \"TABLE\" = tbl and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"declare xsd, label varchar;\n"
"label := col;\n"
"col := rdf_view_col (col);\n"
"xsd := rdf_view_dv_to_xsd_str_type (dtp);\n"
"if (cols_arr[1][inx][0] = 1 or length (cols_arr[1][inx][1]) > 0)\n"
"goto skip_this;\n"
"else if (isstring (cols_arr[1][inx][0]))\n"
"{\n"
"http (sprintf (\'%s:%s a owl:ObjectProperty .\\n\', qual, col), ses);\n"
"\n"
"\n"
"http (sprintf (\'%s:%s rdfs:range aowl:Content .\\n\', qual, col), ses);\n"
"}\n"
"else if (cols_arr[1][inx][0] = 4)\n"
"{\n"
"http (sprintf (\'%s:%s rdfs:subPropertyOf virtrdf:label . \\n\', qual, col), ses);\n"
"http (sprintf (\'%s:%s rdfs:range xsd:%s .\\n\', qual, col, xsd), ses);\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'%s:%s a owl:DatatypeProperty .\\n\', qual, col), ses);\n"
"http (sprintf (\'%s:%s rdfs:range xsd:%s .\\n\', qual, col, xsd), ses);\n"
"}\n"
"\n"
"http (sprintf (\'%s:%s rdfs:domain %s:%s .\\n\', qual, col, qual, cls), ses);\n"
"http (sprintf (\'%s:%s rdfs:isDefinedBy %s: .\\n\', qual, col, qual), ses);\n"
"http (sprintf (\'%s:%s rdfs:label \"%S\" .\\n\', qual, col, label), ses);\n"
"skip_this:\n"
"inx := inx + 1;\n"
"}\n"
"for select distinct PK_TABLE as pkt from SYS_FOREIGN_KEYS where FK_TABLE = tbl and 0 < position (PK_TABLE, _tbls) do\n"
"{\n"
"declare pkcls, lpkt varchar;\n"
"pkcls := rdf_view_cls_name (name_part (pkt, 2));\n"
"lpkt := rdf_view_tb (name_part (pkt, 2));\n"
"\n"
"http (sprintf (\'%s:has_%s a owl:ObjectProperty .\\n\', qual, lpkt), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:domain %s:%s .\\n\', qual, lpkt, qual, cls), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:range %s:%s .\\n\', qual, lpkt, qual, pkcls), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:label \"Relation to %s\" .\\n\', qual, lpkt, pkt), ses);\n"
"http (sprintf (\'%s:has_%s rdfs:isDefinedBy %s: .\\n\', qual, lpkt, qual), ses);\n"
"}\n"
"for select distinct FK_TABLE as pkt from SYS_FOREIGN_KEYS where PK_TABLE = tbl and 0 < position (FK_TABLE, _tbls) do\n"
"{\n"
"declare pkcls varchar;\n"
"pkcls := rdf_view_cls_name (name_part (pkt, 2));\n"
"\n"
"http (sprintf (\'%s:%s_of a owl:ObjectProperty .\\n\', qual, ltb), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:domain %s:%s .\\n\', qual, ltb, qual, cls), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:range %s:%s .\\n\', qual, ltb, qual, pkcls), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:label \"Relation to %s\" .\\n\', qual, ltb, pkt), ses);\n"
"http (sprintf (\'%s:%s_of rdfs:isDefinedBy %s: .\\n\', qual, ltb, qual), ses);\n"
"}\n"
"}\n"
"return string_output_string (ses);\n"
"}\n"
"--src rdf_schema_objects.sql:811\n";

static const char *proc539 = 
"#line 907 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure RDF_VIEW_GEN_VD (in qual varchar)\n"
"{\n"
"declare ses, pref any;\n"
"declare fct_installed int;\n"
"ses := string_output ();\n"
"pref := lower (qual);\n"
"\n"
"if (0 and (\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule1\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule2\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule3\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_rule4\') or\n"
"exists (select 1 from URL_REWRITE_RULE_LIST where URRL_LIST = pref || \'_rule_list1\') or\n"
"exists (select 1 from HTTP_PATH where HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\' and HP_LPATH = \'/\'||qual)\n"
") )\n"
"return \'\\n-- WARNING: there are already created virtual directory \"/\'||qual||\'\", skipping virtual directory generation\\n\'||\n"
"\'-- WARNING: To avoid this message chose different base URL or drop existing virtual directory and its rewrite rules.\\n\';\n"
"\n"
"if (exists (select 1 from VAD.DBA.VAD_REGISTRY where R_KEY like \'/VAD/fct/%/resources/dav/%\'))\n"
"fct_installed := 1;\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule2\'\',\n"
"1,\n"
"\'\'(/[^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^%U%%23this%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)|(text/n3)|(application/json)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule4\'\',\n"
"1,\n"
"\'\'/<qual>/stat([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/stat%%23%%3E+%%3Fo+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E+WHERE+{+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/stat%%23%%3E+%%3Fp+%%3Fo+}&format=%U\'\',\n"
"vector(\'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)|(text/n3)|(application/json)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule6\'\',\n"
"1,\n"
"\'\'/<qual>/objects/([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>/objects/%U%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)|(text/n3)|(application/json)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (concat (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule1\'\',\n"
"1,\n"
"\'\'([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\\n\',\n"
"\n"
"case when fct_installed\n"
"then\n"
"\'\'\'/describe/?url=http%%3A//^{URIQADefaultHost}^%U%%23this&graph=http%%3A//^{URIQADefaultHost}^/<qual>%%23\'\',\'\n"
"else\n"
"\'\'\'/about/html/http://^{URIQADefaultHost}^%s\'\',\'\n"
"end\n"
"\n"
",\'\\nvector(\'\'path\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"303\n"
");\'), ses);\n"
"http (\'\\n\', ses);\n"
"\n"
"http (concat (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule7\'\',\n"
"1,\n"
"\'\'/<qual>/stat([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\\n\',\n"
"\n"
"case when fct_installed\n"
"then\n"
"\'\'\'/describe/?url=http%%3A//^{URIQADefaultHost}^/<qual>/stat%%23&graph=http%%3A//^{URIQADefaultHost}^/<qual>%%23\'\',\'\n"
"else\n"
"\'\'\'/about/html/http://^{URIQADefaultHost}^/<qual>/stat%%01\'\',\'\n"
"end\n"
"\n"
",\'\\nvector(\'\'path\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"303\n"
");\'), ses);\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_rule5\'\',\n"
"1,\n"
"\'\'/<qual>/objects/(.*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/services/rdf/object.binary?path=%%2F<qual>%%2Fobjects%%2F%U&accept=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \'\'<pref>_rule_list1\'\', 1, vector ( \'\'<pref>_rule1\'\', \'\'<pref>_rule7\'\', \'\'<pref>_rule5\'\', \'\'<pref>_rule2\'\', \'\'<pref>_rule4\'\', \'\'<pref>_rule6\'\'));\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.VHOST_REMOVE (lpath=>\'\'/<qual>\'\');\', ses);\n"
"http (\'\\n\', ses);\n"
"http(\'DB.DBA.VHOST_DEFINE (lpath=>\'\'/<qual>\'\', ppath=>\'\'/\'\', vsp_user=>\'\'dba\'\', is_dav=>0,\n"
"is_brws=>0, opts=>vector (\'\'url_rewrite\'\', \'\'<pref>_rule_list1\'\')\n"
");\',ses);\n"
"ses := string_output_string (ses);\n"
"ses := replace (ses, \'<pref>\', pref);\n"
"ses := replace (ses, \'<qual>\', qual);\n"
"return ses;\n"
"}\n"
"--src rdf_schema_objects.sql:905\n";

static const char *proc540 = 
"#line 1054 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure RDF_OWL_GEN_VD (in qual varchar)\n"
"{\n"
"declare fct_installed int;\n"
"declare ses, pref any;\n"
"ses := string_output ();\n"
"pref := lower (qual);\n"
"\n"
"if ( 0 and (\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_owl_rule1\') or\n"
"exists (select 1 from URL_REWRITE_RULE where URR_RULE = pref || \'_owl_rule2\') or\n"
"exists (select 1 from URL_REWRITE_RULE_LIST where URRL_LIST = pref || \'_owl_rule_list1\') or\n"
"exists (select 1 from HTTP_PATH where HP_HOST = \'*ini*\' and HP_LISTEN_HOST = \'*ini*\' and HP_LPATH = \'/schemas/\'||qual)\n"
") )\n"
"return \'\\n-- WARNING: there are already created virtual directory \"/schemas/\'||qual||\'\", skipping virtual directory generation\\n\'||\n"
"\'-- WARNING: To avoid this message chose different base URL or drop existing virtual directory and its rewrite rules.\\n\';\n"
"\n"
"if (exists (select 1 from VAD.DBA.VAD_REGISTRY where R_KEY like \'/VAD/fct/%/resources/dav/%\'))\n"
"fct_installed := 1;\n"
"\n"
"http (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_owl_rule2\'\',\n"
"1,\n"
"\'\'(/[^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\n"
"\'\'/sparql?query=DESCRIBE+%%3Chttp%%3A//^{URIQADefaultHost}^%U%%3E+FROM+%%3Chttp%%3A//^{URIQADefaultHost}^/schemas/<qual>%%23%%3E&format=%U\'\',\n"
"vector(\'\'path\'\', \'\'*accept*\'\'),\n"
"null,\n"
"\'\'(text/rdf.n3)|(application/rdf.xml)|(text/n3)|(application/json)\'\',\n"
"2,\n"
"null\n"
");\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\n"
"concat (\n"
"\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE (\n"
"\'\'<pref>_owl_rule1\'\',\n"
"1,\n"
"\'\'([^#]*)\'\',\n"
"vector(\'\'path\'\'),\n"
"1,\\n\',\n"
"case when fct_installed\n"
"then\n"
"\'\'\'/describe/?url=http://^{URIQADefaultHost}^%U\'\',\'\n"
"else\n"
"\'\'\'/about/html/http://^{URIQADefaultHost}^%s\'\',\'\n"
"end,\n"
"\'\\nvector(\'\'path\'\'),\n"
"null,\n"
"null,\n"
"2,\n"
"303\n"
");\'), ses);\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \'\'<pref>_owl_rule_list1\'\', 1, vector ( \'\'<pref>_owl_rule1\'\', \'\'<pref>_owl_rule2\'\'));\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"http (\'DB.DBA.VHOST_REMOVE (lpath=>\'\'/schemas/<qual>\'\');\', ses);\n"
"http (\'\\n\', ses);\n"
"http(\'DB.DBA.VHOST_DEFINE (lpath=>\'\'/schemas/<qual>\'\', ppath=>\'\'/\'\', vsp_user=>\'\'dba\'\', is_dav=>0,\n"
"is_brws=>0, opts=>vector (\'\'url_rewrite\'\', \'\'<pref>_owl_rule_list1\'\')\n"
");\',ses);\n"
"ses := string_output_string (ses);\n"
"ses := replace (ses, \'<pref>\', pref);\n"
"ses := replace (ses, \'<qual>\', qual);\n"
"return ses;\n"
"}\n"
"--src rdf_schema_objects.sql:1052\n";

static const char *proc541 = 
"#line 1125 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_CHECK_SYNC_TB (in tb varchar)\n"
"{\n"
"declare tree, tbname any;\n"
"tree := sql_parse (sprintf (\'SELECT 1 from %s\', tb));\n"
"tbname := tree [4][1][0][1][1];\n"
"tbname := complete_table_name (tbname, 1);\n"
"if (exists (select 1 from SYS_VIEWS where V_NAME = tbname))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src rdf_schema_objects.sql:1123\n";

static const char *proc542 = 
"#line 1138 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_DO_SYNC (in qualifier varchar, in load_data int := 0, in pgraph varchar := null, in log_mode int := 1, in load_atomic int := 1)\n"
"{\n"
"declare gr varchar;\n"
"gr := sprintf (\'http://%s/%s#\', virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qualifier);\n"
"return RDF_VIEW_SYNC_TO_PHYSICAL (gr, load_data, pgraph, log_mode, load_atomic);\n"
"}\n"
"--src rdf_schema_objects.sql:1136\n";

static const char *proc543 = 
"#line 1147 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"RDF_VIEW_SYNC_TO_PHYSICAL (in vgraph varchar, in load_data int := 0, in pgraph varchar := null, in log_mode int := 1, in load_atomic int := 1)\n"
"{\n"
"declare mask varchar;\n"
"declare txt, tbls, err_ret, opt any;\n"
"declare stat, msg, gr varchar;\n"
"declare old_mode int;\n"
"\n"
"old_mode := log_enable (log_mode, 1);\n"
"declare exit handler for sqlstate \'*\' {\n"
"log_enable (old_mode, 1);\n"
"if (load_atomic)\n"
"__atomic (0);\n"
"};\n"
"\n"
"if (load_atomic)\n"
"__atomic (1);\n"
"tbls := vector ();\n"
"err_ret := vector ();\n"
"opt := vector ();\n"
"gr := vgraph;\n"
"if (length (pgraph))\n"
"opt := vector (gr, pgraph);\n"
"for select \"o\" from\n"
"(sparql define input:storage \"\" select ?o from virtrdf:\n"
"{\n"
"virtrdf:DefaultQuadStorage-UserMaps ?p ?o .\n"
"?o a virtrdf:QuadMap  .\n"
"?o virtrdf:qmGraphRange-rvrFixedValue `iri(?:gr)` .\n"
"}\n"
"order by asc (bif:sprintf_inverse (bif:concat (str(rdf:_), \"%d\"), str (?p), 1))) x do\n"
"{\n"
"declare qm varchar;\n"
"if (\"o\" not like \'%/qm-VoidStatistics\')\n"
"{\n"
"exec (sprintf (\'sparql alter quad storage virtrdf:SyncToQuads { drop quad map <%s> }\', \"o\"), stat, msg);\n"
"stat := \'00000\';\n"
"exec (sprintf (\'sparql alter quad storage virtrdf:SyncToQuads { create <%s> using storage virtrdf:DefaultQuadStorage }\', \"o\"), stat, msg);\n"
"if (stat <> \'00000\')\n"
"err_ret := vector_concat (err_ret, vector (vector (stat, msg)));\n"
"\n"
"qm := \"o\";\n"
"for select \"tb\" from (sparql define input:storage \"\"\n"
"select distinct ?tb from virtrdf:\n"
"{\n"
"?:qm virtrdf:qmUserSubMaps ?sm .\n"
"?sm ?inx ?q .\n"
"?q virtrdf:qmTableName ?tb  .\n"
"}) xx do\n"
"{\n"
"if (RDF_VIEW_CHECK_SYNC_TB (\"tb\"))\n"
"tbls := vector_concat (tbls, vector (\"tb\"));\n"
"else\n"
"err_ret := vector_concat (err_ret, vector (vector (\'42000\', sprintf (\'Reference to VIEW %s cannot be added automatically\', \"tb\"))));\n"
"}\n"
"}\n"
"}\n"
"foreach (varchar tb in tbls) do\n"
"{\n"
"for (declare ctr int, ctr := 1; ctr <= 4; ctr := ctr + 1)\n"
"{\n"
"if (ctr > 1 and exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = replace (tb, \'\"\', \'\')))\n"
"goto nextp;\n"
"txt := sparql_rdb2rdf_codegen (tb, ctr, opt);\n"
"stat := \'00000\';\n"
"if (isvector (txt))\n"
"{\n"
"exec (cast (txt[0] as varchar), stat, msg);\n"
"if (stat <> \'00000\')\n"
"{\n"
"err_ret := vector_concat (err_ret, vector (vector (stat, msg)));\n"
"stat := \'00000\';\n"
"}\n"
"exec (cast (txt[1] as varchar), stat, msg);\n"
"if (stat <> \'00000\')\n"
"err_ret := vector_concat (err_ret, vector (vector (stat, msg)));\n"
"}\n"
"else\n"
"{\n"
"exec (cast (txt as varchar), stat, msg);\n"
"if (stat <> \'00000\')\n"
"err_ret := vector_concat (err_ret, vector (vector (stat, msg)));\n"
"}\n"
"}\n"
"nextp:;\n"
"}\n"
"if (load_data)\n"
"{\n"
"declare aq, n any;\n"
"n := atoi (coalesce (virtuoso_ini_item_value (\'Parameters\',\'AsyncQueueMaxThreads\'), \'10\')) / 2;\n"
"aq := async_queue (n);\n"
"foreach (varchar tb in tbls) do\n"
"{\n"
"declare pname varchar;\n"
"pname := sprintf (\'DB.DBA.RDB2RDF_FILL__%s\', replace (replace (tb, \'\"\', \'`\'), \'.\', \'~\'));\n"
"aq_request (aq, pname, vector ());\n"
"}\n"
"aq_wait_all (aq);\n"
"}\n"
"log_enable (old_mode, 1);\n"
"if (load_atomic)\n"
"{\n"
"__atomic (0);\n"
"exec (\'checkpoint\');\n"
"}\n"
"return err_ret;\n"
"}\n"
"--src rdf_schema_objects.sql:1145\n";

static const char *proc544 = 
"#line 1259 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"DB.DBA.R2RML_FROM_TBL (in qualifier varchar, in _tbls any, in gen_stat int := 0, in cols any := null, in qual_ns varchar := null)\n"
"{\n"
"declare create_view_stmt, ns, sns any;\n"
"declare total_select, total_tb, total, qual, pkcols any;\n"
"declare vname, mask, graph, uriqa_str varchar;\n"
"\n"
"rdf_view_tbl_pk_cols (_tbls, pkcols);\n"
"cols := rdf_view_tbl_opts (_tbls, cols);\n"
"if (qual_ns is null)\n"
"qual_ns := sprintf (\'http://%s/schemas/%s/\', virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'), qualifier);\n"
"sns := ns := sprintf (\'@prefix rr: <http://www.w3.org/ns/r2rml#> .\\n@prefix %s: <%s> .\\n\', qualifier, qual_ns);\n"
"if (gen_stat)\n"
"{\n"
"ns := ns || sprintf (\'@prefix %s-stat: <http://%s/%s/stat#> .\\n\', lcase (qualifier), virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\'),\n"
"qualifier);\n"
"ns := ns || \'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n\';\n"
"ns := ns || \'@prefix void: <http://rdfs.org/ns/void#> .\\n\';\n"
"ns := ns || \'@prefix scovo: <http://purl.org/NET/scovo#> .\\n\';\n"
"}\n"
"ns := ns || \'@prefix aowl: <http://bblfish.net/work/atom-owl/2006-06-06/> .\\n\';\n"
"ns := ns || rdf_view_ns_get (cols, 1);\n"
"ns := ns || \'\\n\';\n"
"\n"
"uriqa_str := registry_get (\'URIQADefaultHost\');\n"
"graph := \'http://\' || uriqa_str || \'/\' || qualifier || \'#\';\n"
"create_view_stmt := ns;\n"
"for (declare inx int, inx := 0; inx < length (_tbls) ; inx := inx + 1)\n"
"create_view_stmt := create_view_stmt || \'\\n\' || DB.DBA.R2RML_CREATE_DATASET (inx, qualifier, qual_ns, _tbls, gen_stat, cols, pkcols, graph) || \'\';\n"
"\n"
"return create_view_stmt;\n"
"}\n"
"--src rdf_schema_objects.sql:1257\n";

static const char *proc545 = 
"#line 1293 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"DB.DBA.R2RML_QUAL_NOTATION (in qualifier varchar, in qual_ns varchar, in loc varchar)\n"
"{\n"
"if (sprintf (\'%U\', loc) = loc)\n"
"return concat (qualifier, \':\', loc);\n"
"return sprintf (\'<%s:%U>\', qual_ns, loc);\n"
"}\n"
"--src rdf_schema_objects.sql:1291\n";

static const char *proc546 = 
"#line 1302 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"DB.DBA.R2RML_CREATE_DATASET (in nth int, in qualifier varchar, in qual_ns varchar, in _tbls any, in gen_stat int := 0, in cols any, in pkcols any, in graph varchar := null)\n"
"{\n"
"declare ret, qual, qual_l, tbl_name, tbl_name_l, pks, pk_text, uriqa_str, graph_def any;\n"
"declare suffix, tname, tbl, own, pref_l any;\n"
"declare cols_arr, inx, col_name, owner, owner_l any;\n"
"\n"
"ret := \'\';\n"
"suffix := \'_s\';\n"
"uriqa_str := registry_get (\'URIQADefaultHost\');\n"
"qual := name_part (_tbls[nth], 0);\n"
"own := name_part (_tbls[nth], 1);\n"
"qual_l := lcase (qual);\n"
"pref_l := lcase (qualifier);\n"
"tbl := _tbls[nth];\n"
"cols_arr := get_keyword (tbl, cols);\n"
"tbl_name := name_part (tbl, 2);\n"
"owner := name_part (tbl, 1);\n"
"tbl_name_l := rdf_view_tb (tbl_name);\n"
"owner_l := rdf_view_tb (owner);\n"
"tname := tbl_name_l || suffix;\n"
"pks := get_keyword (tbl, pkcols); \n"
"\n"
"pk_text := \'\';\n"
"for (declare i any, i := 0; i < length (pks) ; i := i + 1)\n"
"pk_text := pk_text || sprintf (\'/%U={%s}\', pks[i][0], pks[i][0]);\n"
"\n"
"if (graph is not null)   \n"
"graph_def := sprintf (\'rr:graph <%s> \', graph);  \n"
"else \n"
"graph_def := \'\';  \n"
"ret := ret || sprintf (\'<#TriplesMap%U> a rr:TriplesMap; rr:logicalTable [ rr:tableSchema \"%s\" ; rr:tableOwner \"%s\" ; rr:tableName \"%s\" ]; \\n\',\n"
"tbl_name, qual, own, tbl_name );\n"
"ret := ret || sprintf (\'rr:subjectMap [ rr:termtype \"IRI\"  ; rr:template \"http://%s/%s/%s%s\"; rr:class %s; %s];\\n\',\n"
"uriqa_str, qual, tbl_name_l, pk_text, DB.DBA.R2RML_QUAL_NOTATION (qualifier, qual_ns, rdf_view_cls_name (tbl_name)), graph_def );\n"
"\n"
"inx := 0;\n"
"for select \"COLUMN\", COL_DTP from TABLE_COLS where \"TABLE\" = tbl and \"COLUMN\" <> \'_IDN\' order by COL_ID do\n"
"{\n"
"col_name := \"COLUMN\";\n"
"if (not exists (select 1 from SYS_FOREIGN_KEYS where FK_TABLE = tbl and FKCOLUMN_NAME = col_name))\n"
"ret := ret || sprintf (\'rr:predicateObjectMap [ rr:predicateMap [ rr:constant %s ] ; rr:objectMap [ rr:column \"%s\" ]; ] ;\\n\',\n"
"DB.DBA.R2RML_QUAL_NOTATION (qualifier, qual_ns, lower (col_name)), col_name );\n"
"inx := inx + 1;\n"
"}\n"
"for select distinct PK_TABLE as pkt from SYS_FOREIGN_KEYS where FK_TABLE = tbl and PK_TABLE <> tbl do\n"
"{\n"
"pk_text := \'\';\n"
"for select FKCOLUMN_NAME from SYS_FOREIGN_KEYS where FK_TABLE = tbl and PK_TABLE = pkt order by KEY_SEQ do\n"
"pk_text := pk_text || sprintf (\'/%U={%s}\', FKCOLUMN_NAME, FKCOLUMN_NAME);\n"
"ret := ret || sprintf (\'rr:predicateObjectMap [ rr:predicateMap [ rr:constant %s ] ; rr:objectMap [ rr:termtype \"IRI\" ; rr:template \"http://%s/%s/%s%s\" ]; ] ;\\n\',\n"
"DB.DBA.R2RML_QUAL_NOTATION (qualifier, qual_ns, concat (tbl_name_l, \'_has_\', lower (name_part (pkt, 3)))),\n"
"uriqa_str, qual, lower (name_part (pkt, 3)), pk_text );\n"
"}\n"
"for select distinct FK_TABLE as fkt from SYS_FOREIGN_KEYS where PK_TABLE = tbl and position (FK_TABLE, _tbls)  do\n"
"{\n"
"declare jc varchar;\n"
"jc := \'\';\n"
"pk_text := \'\';\n"
"for select FKCOLUMN_NAME, PKCOLUMN_NAME from SYS_FOREIGN_KEYS where FK_TABLE = fkt and PK_TABLE = tbl order by KEY_SEQ do\n"
"{\n"
"jc := jc || sprintf (\' rr:joinCondition [ rr:child \"%s\" ; rr:parent \"%s\" ] ;\', PKCOLUMN_NAME, FKCOLUMN_NAME);\n"
"pk_text := pk_text || sprintf (\'/%U={%s}\', FKCOLUMN_NAME, FKCOLUMN_NAME);\n"
"}\n"
"if (tbl <> fkt)\n"
"{ \n"
"ret := ret || sprintf (\'rr:predicateObjectMap [ rr:predicateMap [ rr:constant %s ] ; rr:objectMap [ rr:parentTriplesMap <#TriplesMap%U>; %s ]; ] ;\\n\',\n"
"DB.DBA.R2RML_QUAL_NOTATION (qualifier, qual_ns, concat (tbl_name_l, \'_of_\', lower (name_part (fkt, 3)))),\n"
"name_part (fkt, 3), jc );\n"
"}\n"
"else\n"
"{\n"
"ret := ret || sprintf (\'rr:predicateObjectMap [ rr:predicateMap [ rr:constant %s ] ; rr:objectMap [ rr:termtype \"IRI\" ; rr:template \"http://%s/%s/%s%s\" ]; ] ;\\n\',\n"
"DB.DBA.R2RML_QUAL_NOTATION (qualifier, qual_ns, concat (tbl_name_l, \'_has_\', lower (name_part (fkt, 3)))),\n"
"uriqa_str, qual, lower (name_part (fkt, 3)), pk_text );\n"
"}\n"
"}\n"
"\n"
"ret := rtrim (ret, \';\\n\') || \'.\\n\'; \n"
"return ret;\n"
"}\n"
"--src rdf_schema_objects.sql:1300\n";

static const char *proc547 = 
"#line 1385 \"[executable]/rdf_schema_objects.sql\"\n"
"create procedure\n"
"TBOX_URL_REWRITE (in prefix varchar, in graph varchar, in url_pattern varchar)\n"
"{\n"
"declare h, ses, accept_pattern_regex, vector_1, vector_2, graph_path, graph_uri, elm, iri_path, iri_regex, iri_spf, iri_tcn, url_spf, url_regex, sprintf_pattern, url_tcn, iri_param, url_param, iri_vd, iri_st, url_vd any;\n"
"declare v, vec, rule_1_prop, rule_2_prop, rule_3_prop, rule_4_prop, rule_5_prop, rule_6_prop, rule_7_prop, rule_8_prop any;\n"
"declare i, pos, nth, fct int;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if(regexp_match (\'#\\x24\', graph) is null)\n"
"{\n"
"graph_uri := graph;\n"
"graph_path := concat (graph, \'/\');        \n"
"}\n"
"\n"
"else \n"
"{        \n"
"graph_uri := regexp_replace(graph, \'#\\x24\', \'\', 1, null);\n"
"graph_path := concat(graph_uri, \'%23\');\n"
"}        \n"
"\n"
"\n"
"h := rfc1808_parse_uri (url_pattern);\n"
"if(regexp_match (\'/\\x24\', h[2]) is not null)\n"
"h[2] := regexp_replace(h[2], \'/\\x24\', \'\', 1, null);\n"
"\n"
"iri_vd := h[2];\n"
"if(regexp_match (\'(/.+)+/\', h[2]) is not null)\n"
"iri_st := concat(\'/\', regexp_replace(h[2], \'(/.+)+/\', \'\', 1, null));        \n"
"\n"
"dbg_obj_print (\'---\');\n"
"dbg_obj_print_vars (url_pattern);\n"
"dbg_obj_print_vars (h);\n"
"dbg_obj_print_vars (iri_vd);\n"
"dbg_obj_print_vars (iri_st);\n"
"dbg_obj_print (\'---\');\n"
"\n"
"ses := string_output ();\n"
"\n"
"http (\'-- Virtual Directories \\n\', ses);\n"
"http (sprintf (\'DB.DBA.VHOST_REMOVE (lpath=>\\\'%s\\\');\\n\', iri_vd), ses);\n"
"http (sprintf (\'DB.DBA.VHOST_DEFINE (lpath=>\\\'%s\\\', ppath=>\\\'/\\\', is_dav=>0, opts=>vector (\\\'url_rewrite\\\', \\\'%s_url_rewrite_rule_list\\\'));\\n\', iri_vd, prefix), ses);\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\'-- Delete Old Rules \\n\', ses);\n"
"\n"
"http (sprintf (\'delete from DB.DBA.URL_REWRITE_RULE_LIST where urrl_list like \\\'%s_url_rewrite_rule_list\\\'\\; \\n\', prefix), ses);\n"
"http (concat (\'delete from DB.DBA.URL_REWRITE_RULE where urr_rule like \\\'\', prefix, \'_url_rewrite_rule_%\\\'\\; \\n\'), ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"\n"
"http (\'-- Rules List \\n\', ses);\n"
"\n"
"http (sprintf (\'DB.DBA.URLREWRITE_CREATE_RULELIST ( \\\'%s_url_rewrite_rule_list\\\', 1, vector (\', prefix), ses);\n"
"i := 1;\n"
"while (i <= 8)\n"
"{\n"
"if (i > 1) http (\',\', ses);\n"
"http (sprintf (\'\\\'%s_url_rewrite_rule_%d\\\'\', prefix, i), ses);\n"
"i := i + 1;\n"
"}\n"
"http (\'));\\n\', ses);\n"
"\n"
"http (\'\\n\', ses);\n"
"\n"
"\n"
"rule_1_prop := vector(\n"
"concat(iri_st, \'/.*/classes/([^/]+)/superclasses\'),\n"
"\'vector(\\\'class\\\')\',        \n"
"\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+select+distinct+%%3Ftype+%%7B+pr%%3A%U+rdf%%3Atype%%2Frdfs%%3AsubClassOf*+%%3Ftype+%%7D+order+by+asc+%%28%%3Ftype%%29&format=%U\'),\n"
"\'vector(\\\'class\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_2_prop := vector(\n"
"concat(iri_st, \'/.*/classes/([^/]+)/subclasses\'),\n"
"\'vector(\\\'class\\\')\',        \n"
"\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+select+distinct+%%3Ftype+%%7B+pr%%3A%U+rdf%%3Atype%%2F%%5Erdfs%%3AsubClassOf*+%%3Ftype+%%7D+order+by+asc+%%28%%3Ftype%%29&format=%U\'),\n"
"\'vector(\\\'class\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_3_prop := vector(\n"
"concat(iri_st, \'/.*/properties/([^/]+)/superproperties\'),\n"
"\'vector(\\\'property\\\')\',\n"
"\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+select+distinct+%%3FpropType+%%7B+pr%%3A%U+rdf%%3Atype%%2Frdfs%%3AsubPropertyOf*+%%3FpropType+%%7D+order+by+asc+%%28%%3FpropType%%29&format=%U\'),\n"
"\'vector(\\\'property\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_4_prop := vector(\n"
"concat(iri_st, \'/.*/properties/([^/]+)/subproperties\'),\n"
"\'vector(\\\'property\\\')\',\n"
"\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+select+distinct+%%3FpropType+%%7B+pr%%3A%U+rdf%%3Atype%%2F%%5Erdfs%%3AsubPropertyOf*+%%3FpropType+%%7D+order+by+asc+%%28%%3FpropType%%29&format=%U\'),\n"
"\'vector(\\\'property\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_5_prop := vector(\n"
"concat(iri_st, \'/.*/classes/([^/]+)\'),\n"
"\'vector(\\\'class\\\')\',\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+describe+pr%%3A%U&format=%U\'),\n"
"\'vector(\\\'class\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_6_prop := vector(\n"
"concat(iri_st, \'/.*/properties/([^/]+)\'),\n"
"\'vector(\\\'property\\\')\',\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=prefix+pr%%3A+<\', graph_path, \'>+describe+pr%%3A%U&format=%U\'),\n"
"\'vector(\\\'property\\\', \\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_7_prop := vector(\n"
"concat(iri_st, \'/.*/classes\'),\n"
"\'vector()\',\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=select+distinct+%%3Fclasses+%%7B+%%7B+%%3Fclasses+a+owl%%3AClass+%%7D+union+%%7B+%%3Fclasses+a+rdfs%%3AClass+%%7D+%%7D+order+by+asc+%%28%%3Fclasses%%29&format=%U\'),\n"
"\'vector(\\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"rule_8_prop := vector(\n"
"concat(iri_st, \'/.*/properties\'),\n"
"\'vector()\',\n"
"concat (\'/sparql?default-graph-uri=\', graph_uri, \'&query=select+distinct+%%3Fproperties%%0D%%0A%%7B%%0D%%0A++%%7B+%%3Fproperties+a+rdf%%3AProperty+%%7D+union%%0D%%0A++%%7B+%%3Fproperties+a+owl%%3AObjectProperty+%%7D+union%%0D%%0A++%%7B+%%3Fproperties+a+owl%%3ADatatypeProperty+%%7D+union%%0D%%0A++%%7B+%%3Fproperties+a+owl%%3AFunctionalProperty+%%7D+union%%0D%%0A++%%7B+%%3Fproperties+a+owl%%3AInverseFunctionalProperty+%%7D+union%%0D%%0A++%%7B+%%3Fproperties+a+owl%%3ATransitiveProperty+%%7D%%0D%%0A%%7D%%0D%%0Aorder+by+asc+%%28%%3Fproperties%%29&format=%U\'),\n"
"\'vector(\\\'\\*accept\\*\\\')\',\n"
"\'(text/html)|(\\\\\\\\*/\\\\\\\\*)\'\n"
");\n"
"\n"
"\n"
"vec := vector(rule_1_prop, rule_2_prop, rule_3_prop, rule_4_prop, rule_5_prop, rule_6_prop, rule_7_prop, rule_8_prop);\n"
"\n"
"\n"
"http (\'-- Rewrite Rules \\n\', ses);\n"
"\n"
"i := 0;\n"
"while(i < 8)\n"
"{\n"
"v := vec[i];\n"
"http (sprintf (\'DB.DBA.URLREWRITE_CREATE_REGEX_RULE ( \\\'%s_url_rewrite_rule_%d\\\', 1, \\\'%s\\\', %s, 1, \\\'%s\\\', %s, null, \\\'%s\\\', 1, null); \\n\',\n"
"prefix, i + 1, v[0], v[1], v[2], v[3], v[4]), ses);\n"
"i := i + 1;\n"
"}\n"
"\n"
"return string_output_string (ses);\n"
"}\n"
"--src rdf_schema_objects.sql:1383\n";

/* rdf_void.sql */

static const char *tbl25 = 
"create table DB.DBA.RDF_VOID_GRAPH (\n"
"RVG_IID IRI_ID not null primary key,\n"
"RVG_IRI varchar not null,\n"
"RVG_COMMENT varchar\n"
")\n"
"alter index RDF_VOID_GRAPH on DB.DBA.RDF_VOID_GRAPH partition cluster replicated\n"
"create index RDF_VOID_GRAPH_IRI on DB.DBA.RDF_VOID_GRAPH (RVG_IRI) partition cluster replicated\n";

static const char *tbl26 = 
"create table DB.DBA.RDF_VOID_GRAPH_MEMBER (\n"
"RVGM_GROUP_IID IRI_ID not null,\n"
"RVGM_MEMBER_IID IRI_ID not null,\n"
"primary key (RVGM_GROUP_IID, RVGM_MEMBER_IID)\n"
")\n"
"alter index RDF_VOID_GRAPH_MEMBER on DB.DBA.RDF_VOID_GRAPH_MEMBER partition cluster replicated\n";

static const char *proc548 = 
"#line 43 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_INIT ()\n"
"{\n"
"XML_REMOVE_NS_BY_PREFIX (\'scovo\', 2);\n"
"XML_REMOVE_NS_BY_PREFIX (\'void\', 2);\n"
"XML_SET_NS_DECL (\'scovo\', \'http://purl.org/NET/scovo#\', 2);\n"
"XML_SET_NS_DECL (\'void\', \'http://rdfs.org/ns/void#\', 2);\n"
"}\n"
"--src rdf_void.sql:41\n";

static const char *other54 = 
"RDF_VOID_INIT ()\n";
static const char *proc549 = 
"#line 55 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_SPLIT_IRI (in rel varchar, out pref varchar, out name varchar)\n"
"{\n"
"declare delim1, delim2, delim3, pos int;\n"
"delim1 := coalesce (strrchr (rel, \'/\'), -1);\n"
"delim2 := coalesce (strrchr (rel, \'#\'), -1);\n"
"delim3 := coalesce (strrchr (rel, \':\'), -1);\n"
"pos := __max (delim1, delim2, delim3);\n"
"\n"
"name := subseq (rel, pos + 1);\n"
"pref := subseq (rel, 0, pos);\n"
"}\n"
"--src rdf_void.sql:53\n";

static const char *proc550 = 
"#line 68 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_STORE (in graph varchar, in to_graph_name varchar := null, in src varchar := null)\n"
"{\n"
"declare ses any;\n"
"declare host varchar;\n"
"\n"
"if (src is null)\n"
"ses := RDF_VOID_GEN (graph);\n"
"else\n"
"ses := src;\n"
"if (to_graph_name is null)\n"
"{\n"
"host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"to_graph_name := \'http://\' || host || \'/stats/void#\';\n"
"}\n"
"exec (sprintf (\'sparql delete from <%s> { ?s1 ?p1 ?s2 } from <%s> where { <%s#Dataset> void:statItem ?s1 . ?s1 ?p1 ?s2 }\',\n"
"to_graph_name, to_graph_name, graph));\n"
"TTLP (ses, graph, to_graph_name, 185);\n"
"return;\n"
"}\n"
"--src rdf_void.sql:66\n";

static const char *proc551 = 
"#line 89 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_ALL_GEN (in target_graph varchar, in details int := 0)\n"
"{\n"
"declare total, subset, ns_ctr int;\n"
"declare ses, hf any;\n"
"declare host varchar;\n"
"\n"
"ses := string_output (http_strses_memory_size ());\n"
"\n"
"host := null;\n"
"\n"
"if (is_http_ctx ())\n"
"host := http_request_header(http_request_header (), \'Host\', null, null);\n"
"if (host is null)\n"
"host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"if (host is null)\n"
"{\n"
"hf := WS.WS.PARSE_URI (target_graph);\n"
"host := hf[1];\n"
"}\n"
"\n"
"\n"
"ns_ctr := 1;\n"
"total := 0;\n"
"target_graph := rtrim (target_graph, \'/#\') || \'/\';\n"
"RDF_VOID_NS (ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"http (sprintf (\'@prefix ns%d: <%s> .\\n\', ns_ctr, target_graph), ses);\n"
"http (sprintf (\'ns%d:Dataset a void:Dataset ; \\n\', ns_ctr), ses);\n"
"http (sprintf (\' void:sparqlEndpoint <http://%s/sparql> . \\n\', host), ses);\n"
"for select RVG_IID, RVG_IRI, RVG_COMMENT from RDF_VOID_GRAPH where RVG_IRI like target_graph || \'%\' do\n"
"{\n"
"\n"
"declare gr_pref_ctr, grp_cnt int;\n"
"ns_ctr := ns_ctr + 1;\n"
"grp_cnt := 0;\n"
"RVG_IRI := rtrim (RVG_IRI, \'/#\') || \'/\';\n"
"http (sprintf (\'@prefix ns%d: <%s> .\\n\', ns_ctr, RVG_IRI), ses);\n"
"http (sprintf (\'ns%d:Dataset a void:Dataset . \\n\', ns_ctr), ses);\n"
"http (sprintf (\'ns1:Dataset void:subset ns%d:Dataset . \\n\', ns_ctr), ses);\n"
"gr_pref_ctr := ns_ctr;\n"
"for select RVGM_MEMBER_IID from RDF_VOID_GRAPH_MEMBER where RVGM_GROUP_IID = RVG_IID do\n"
"{\n"
"\n"
"ns_ctr := ns_ctr + 1;\n"
"RDF_VOID_GEN_1 (id_to_iri (RVGM_MEMBER_IID), null, sprintf (\'ns%d\', ns_ctr),\n"
"target_graph || rtrim (id_to_iri (RVGM_MEMBER_IID), \'/#\') || \'/\',\n"
"ses, grp_cnt, 1, details);\n"
"http (sprintf (\'ns%d:Dataset void:subset ns%d:Dataset . \\n\', gr_pref_ctr, ns_ctr), ses);\n"
"}\n"
"http (sprintf (\'ns%d:Dataset void:statItem ns%d:Stat . \\n\', gr_pref_ctr, gr_pref_ctr), ses);\n"
"http (sprintf (\'ns%d:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', gr_pref_ctr, grp_cnt), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"total := total + grp_cnt;\n"
"}\n"
"http (sprintf (\'ns1:Dataset void:statItem ns1:Stat . \\n\'), ses);\n"
"http (sprintf (\'ns1:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', total), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:87\n";

static const char *proc552 = 
"#line 152 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_NS (inout ses any)\n"
"{\n"
"http (\'@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\\n\', ses);\n"
"http (\'@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\\n\', ses);\n"
"http (\'@prefix owl: <http://www.w3.org/2002/07/owl#> .\\n\', ses);\n"
"http (\'@prefix dc: <http://purl.org/dc/elements/1.1/> .\\n\', ses);\n"
"http (\'@prefix scovo: <http://purl.org/NET/scovo#> .\\n\', ses);\n"
"http (\'@prefix void: <http://rdfs.org/ns/void#> .\\n\', ses);\n"
"}\n"
"--src rdf_void.sql:150\n";

static const char *proc553 = 
"#line 163 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_GEN (in graph varchar, in gr_name varchar := null)\n"
"{\n"
"declare ses any;\n"
"declare dummy int;\n"
"dummy := 0;\n"
"ses := string_output (http_strses_memory_size ());\n"
"RDF_VOID_NS (ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"RDF_VOID_GEN_1 (graph, gr_name, \'this\', \'\', ses, dummy, 1, 1);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:161\n";

static const char *proc554 = 
"#line 176 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_DIST_O_SRV (in graph any)\n"
"{\n"
"declare cnt int;\n"
"cnt := (select count(distinct O) from DB.DBA.RDF_QUAD table option (no cluster) where G = graph);\n"
"return cnt;\n"
"}\n"
"--src rdf_void.sql:174\n";

static const char *proc555 = 
"#line 184 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_DIST_O (in graph varchar)\n"
"{\n"
"declare daq, r any;\n"
"declare s int;\n"
"daq := daq (0);\n"
"daq_call (daq, \'DB.DBA.SYS_COLS\', \'SYS_COLS_BY_NAME\', \'DB.DBA.RDF_VOID_DIST_O_SRV\', vector (iri_to_id (graph)), 1);\n"
"while (r:= daq_next (daq))\n"
"{\n"
"if (length (r) >2 and isarray (r[2]) and r[2][0] = 3)\n"
"{\n"
"declare err any;\n"
"err := r[2][1];\n"
"if (isarray (err))\n"
"signal (err[2], err[2]);\n"
"}\n"
"s := s + r[2][1];\n"
"}\n"
"return s;\n"
"}\n"
"--src rdf_void.sql:182\n";

static const char *proc556 = 
"#line 205 \"[executable]/rdf_void.sql\"\n"
"create procedure RDF_VOID_GEN_1 (in graph varchar, in gr_name varchar := null,\n"
"in ns_pref varchar := \'this\', in this_ns varchar := \'\',\n"
"inout ses any, inout total int, in ep int := 1, in details int := 1)\n"
"{\n"
"declare _cnt, _cnt_subj, _cnt_obj, has_links int;\n"
"declare preds, dict any;\n"
"declare pref, name, pred, host varchar;\n"
"declare nam, inx any;\n"
"\n"
"preds := vector (\'owl:sameAs\', \'rdfs:seeAlso\');\n"
"host := null;\n"
"if (is_http_ctx ())\n"
"host := http_request_header(http_request_header (), \'Host\', null, null);\n"
"if (host is null)\n"
"host := virtuoso_ini_item_value (\'URIQA\',\'DefaultHost\');\n"
"\n"
"\n"
"\n"
"_cnt := (sparql define input:storage \"\" select count(*) where { graph `iri (?:graph)` { ?s ?p ?o . } });\n"
"total := total + _cnt;\n"
"\n"
"http (sprintf (\'@prefix %s: <%s> .\\n\', ns_pref, this_ns), ses);\n"
"\n"
"http (sprintf (\'\\n\'), ses);\n"
"\n"
"http (sprintf (\'%s:Dataset a void:Dataset ; \\n\', ns_pref), ses);\n"
"http (sprintf (\' rdfs:seeAlso <%s> ; \\n\', graph), ses);\n"
"if (gr_name is not null)\n"
"http (sprintf (\' rdfs:label \"%s\" ; \\n\', gr_name), ses);\n"
"if (ep)\n"
"http (sprintf (\' void:sparqlEndpoint <http://%s/sparql> ; \\n\', host), ses);\n"
"http (sprintf (\' void:statItem %s:Stat ; \\n\', ns_pref), ses);\n"
"\n"
"http (sprintf (\' void:statItem %s:DistinctSubjectsStat ; \\n\', ns_pref), ses);\n"
"http (sprintf (\' void:statItem %s:DistinctObjectsStat . \\n\', ns_pref), ses);\n"
"\n"
"http (sprintf (\'%s:Stat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt), ses);\n"
"http (sprintf (\' scovo:dimension void:numOfTriples . \\n\'), ses);\n"
"\n"
"if (details)\n"
"{\n"
"declare exit handler for sqlstate \'*\' { goto end1; };\n"
"_cnt_subj := (select count(distinct S) from DB.DBA.RDF_QUAD where G = iri_to_id (graph));\n"
"http (sprintf (\'%s:DistinctSubjectsStat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt_subj), ses);\n"
"http (sprintf (\' scovo:dimension void:numberOfDistinctSubjects . \\n\'), ses);\n"
"end1:;\n"
"}\n"
"if (details)\n"
"{\n"
"declare exit handler for sqlstate \'*\' { goto end2; };\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"_cnt_obj  := RDF_VOID_DIST_O (graph);\n"
"}\n"
"else\n"
"{\n"
"_cnt_obj  := (sparql define input:storage \"\" select count(distinct (?o)) where { graph `iri (?:graph)` { ?s ?p ?o . filter (isIRI (?o)) } });\n"
"}\n"
"http (sprintf (\'%s:DistinctObjectsStat a scovo:Item ; \\n rdf:value %d ; \\n\', ns_pref, _cnt_obj), ses);\n"
"http (sprintf (\' scovo:dimension void:numberOfDistinctObjects . \\n\'), ses);\n"
"end2:;\n"
"}\n"
"\n"
"http (sprintf (\'\\n\'), ses);\n"
"\n"
"has_links := 0;\n"
"dict := dict_new ();\n"
"foreach (any rel in preds) do\n"
"{\n"
"RDF_VOID_SPLIT_IRI (rel, pref, name);\n"
"pred := __xml_get_ns_uri (pref, 2) || name;\n"
"\n"
"_cnt := (sparql define input:storage \"\" select count(*)\n"
"where { graph `iri (?:graph)` { ?s `iri (?:pred)` ?o . filter (?o != iri (?:graph)) } });\n"
"if (_cnt)\n"
"{\n"
"nam := name;\n"
"inx := 1;\n"
"while (dict_get (dict, nam, 0))\n"
"{\n"
"nam := name||cast (inx as varchar);\n"
"inx := inx + 1;\n"
"}\n"
"name := nam;\n"
"dict_put (dict, nam, 1);\n"
"http (sprintf (\'%s:Dataset void:containsLinks %s:%sLinks .\\n\', ns_pref, ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sLinks a void:Linkset ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' void:statItem %s:%sStat . \\n\', ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sStat a  scovo:Item ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' rdf:value %d ; \\n\', _cnt), ses);\n"
"http (sprintf (\' scovo:dimension %s:%sType .\\n\', ns_pref, name), ses);\n"
"\n"
"http (sprintf (\'%s:%sType rdf:type %s:TypeOfLink ;\\n\', ns_pref, name, ns_pref), ses);\n"
"http (sprintf (\' void:linkPredicate %s .\\n\', rel), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"has_links := has_links + 1;\n"
"}\n"
"}\n"
"\n"
"for select \"class\", \"cnt\" from (sparql define input:storage \"\" select ?class (count(*)) as ?cnt\n"
"where { graph `iri (?:graph)` { [] a ?class . filter (!isLiteral (?class)) } } group by ?class order by desc 2) s do\n"
"{\n"
"if (\"class\" like \'http://rdfs.org/ns/void#%\' or \"class\" like \'http://purl.org/NET/scovo#%\'\n"
"or \"class\" = graph || \'#TypeOfLink\' or \"class\" like graph || \'#%Links\')\n"
"goto skip;\n"
"RDF_VOID_SPLIT_IRI (\"class\", pref, name);\n"
"if (name is null)\n"
"goto skip;\n"
"nam := sprintf (\'%U\', name);\n"
"inx := 1;\n"
"while (dict_get (dict, nam, 0))\n"
"{\n"
"nam := name||cast (inx as varchar);\n"
"nam := sprintf (\'%U\', nam);\n"
"inx := inx + 1;\n"
"}\n"
"name := nam;\n"
"dict_put (dict, nam, 1);\n"
"http (sprintf (\'%s:Dataset void:statItem %s:%sStat .\\n\', ns_pref, ns_pref, name), ses);\n"
"http (sprintf (\'%s:%sStat a  scovo:Item ; \\n\', ns_pref, name), ses);\n"
"http (sprintf (\' rdf:value %d ; \\n\', \"cnt\"), ses);\n"
"http (sprintf (\' scovo:dimension <%s> ; \\n\', \"class\"), ses);\n"
"http (sprintf (\' scovo:dimension void:numberOfResources . \\n\'), ses);\n"
"http (sprintf (\'\\n\'), ses);\n"
"skip:;\n"
"}\n"
"\n"
"if (has_links)\n"
"http (sprintf (\'%s:TypeOfLink rdfs:subClassOf scovo:Dimension . \\n\', ns_pref), ses);\n"
"return ses;\n"
"}\n"
"--src rdf_void.sql:203\n";

/* rdflddir2.sql */

static const char *tbl27 = 
"create table DB.DBA.LOAD_LIST (\n"
"ll_file varchar,\n"
"ll_graph varchar,\n"
"ll_state int default 0,\n"
"ll_started datetime,\n"
"ll_done datetime,\n"
"ll_host int,\n"
"ll_work_time integer,\n"
"ll_error varchar,\n"
"primary key (ll_file))\n"
"alter index LOAD_LIST on DB.DBA.LOAD_LIST partition (ll_file varchar)\n"
"create index LL_STATE on DB.DBA.LOAD_LIST (ll_state, ll_file, ll_graph) partition (ll_state int)\n";

static const char *tbl28 = 
"create table LDLOCK (id int primary key)\n"
"alter index LDLOCK on LDLOCK partition (id int)\n";

static const char *other55 = 
"insert soft DB.DBA.LDLOCK values (0)\n";
static const char *proc557 = 
"#line 47 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"ld_dir (in path varchar, in mask varchar, in graph varchar)\n"
"{\n"
"declare ls any;\n"
"declare inx int;\n"
"ls := sys_dirlist (path, 1);\n"
"for (inx := 0; inx < length (ls); inx := inx + 1)\n"
"{\n"
"if (ls[inx] like mask)\n"
"{\n"
"set isolation = \'serializable\';\n"
"\n"
"if (not (exists (select 1 from DB.DBA.LOAD_LIST where LL_FILE = path || \'/\' || ls[inx] for update)))\n"
"{\n"
"declare gfile, cgfile, ngraph varchar;\n"
"gfile := path || \'/\' || replace (ls[inx], \'.gz\', \'\') || \'.graph\';\n"
"cgfile := path || \'/\' || regexp_replace (replace (ls[inx], \'.gz\', \'\'), \'\\\\-[0-9]+\\\\.n\', \'.n\') || \'.graph\';\n"
"if (file_stat (gfile) <> 0)\n"
"ngraph := trim (file_to_string (gfile), \' \\r\\n\');\n"
"else if (file_stat (cgfile) <> 0)\n"
"ngraph := trim (file_to_string (cgfile), \' \\r\\n\');\n"
"else if (file_stat (path || \'/\' || \'global.graph\') <> 0)\n"
"ngraph := trim (file_to_string (path || \'/\' || \'global.graph\'), \' \\r\\n\');\n"
"else\n"
"ngraph := graph;\n"
"if (ngraph is not null)\n"
"{\n"
"insert into DB.DBA.LOAD_LIST (ll_file, ll_graph) values (path || \'/\' || ls[inx], ngraph);\n"
"}\n"
"}\n"
"\n"
"commit work;\n"
"}\n"
"}\n"
"}\n"
"--src rdflddir2.sql:45\n";

static const char *proc558 = 
"#line 85 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"rdf_read_dir (in path varchar, in mask varchar, in graph varchar)\n"
"{\n"
"ld_dir (path, mask, graph);\n"
"}\n"
"--src rdflddir2.sql:83\n";

static const char *proc559 = 
"#line 93 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"ld_dir_all (in path varchar, in mask varchar, in graph varchar)\n"
"{\n"
"declare ls, ngraph any;\n"
"declare inx int;\n"
"ls := sys_dirlist (path, 0);\n"
"if (file_stat (path || \'/\' || \'global.graph\') <> 0)\n"
"{\n"
"ngraph := trim (file_to_string (path || \'/\' || \'global.graph\'), \' \\r\\n\');\n"
"if (length (ngraph))\n"
"graph := ngraph;\n"
"}\n"
"ld_dir (path, mask, graph);\n"
"for (inx := 0; inx < length (ls); inx := inx + 1)\n"
"{\n"
"if (ls[inx] <> \'.\' and ls[inx] <> \'..\')\n"
"{\n"
"ld_dir_all (path||\'/\'||ls[inx], mask, graph);\n"
"}\n"
"}\n"
"}\n"
"--src rdflddir2.sql:91\n";

static const char *proc560 = 
"#line 116 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"ld_add (in _fname varchar, in _graph varchar)\n"
"{\n"
"\n"
"\n"
"set isolation = \'serializable\';\n"
"\n"
"if (not (exists (select 1 from DB.DBA.LOAD_LIST where LL_FILE = _fname for update)))\n"
"{\n"
"insert into DB.DBA.LOAD_LIST (LL_FILE, LL_GRAPH) values (_fname, _graph);\n"
"}\n"
"commit work;\n"
"}\n"
"--src rdflddir2.sql:114\n";

static const char *proc561 = 
"#line 131 \"[executable]/rdflddir2.sql\"\n"
"create procedure ld_ttlp_flags (in fname varchar, in opt varchar)\n"
"{\n"
"if (fname like \'%/btc-20%\' or fname like \'%.nq%\' or fname like \'%.n4\')\n"
"{\n"
"if (lower (opt) = \'with_delete\')\n"
"return 255 + 512 + 2048;\n"
"return 255 + 512;\n"
"}\n"
"if (fname like \'%.trig\' or fname like \'%.trig.gz\')\n"
"return 255 + 256;\n"
"return 255;\n"
"}\n"
"--src rdflddir2.sql:129\n";

static const char *proc562 = 
"#line 145 \"[executable]/rdflddir2.sql\"\n"
"create procedure ld_is_rdfxml (in f any)\n"
"{\n"
"if (f like \'%.xml\' or f like \'%.owl\' or f like \'%.rdf\' or f like \'%.rdfs\')\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src rdflddir2.sql:143\n";

static const char *proc563 = 
"#line 153 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"ld_file (in f varchar, in graph varchar)\n"
"{\n"
"declare gzip_name varchar;\n"
"declare exit handler for sqlstate \'*\' {\n"
"rollback work;\n"
"update DB.DBA.LOAD_LIST\n"
"set LL_STATE = 2,\n"
"LL_DONE = curdatetime (),\n"
"LL_ERROR = __sql_state || \' \' || __sql_message\n"
"where LL_FILE = f;\n"
"commit work;\n"
"\n"
"log_message (sprintf (\' File %s error %s %s\', f, __sql_state, __sql_message));\n"
"return;\n"
"};\n"
"\n"
"connection_set (\'ld_file\', f);\n"
"if (graph like \'sql:%\')\n"
"{\n"
"exec (subseq (graph, 4), null, null, vector (f), vector (\'max_rows\', 0, \'use_cache\', 1));\n"
"return;\n"
"}\n"
"\n"
"if (f like \'%.grdf\' or f like \'%.grdf.gz\')\n"
"{\n"
"load_grdf (f);\n"
"}\n"
"else if (f like \'%.gz\')\n"
"{\n"
"gzip_name := regexp_replace (f, \'\\.gz\\x24\', \'\');\n"
"if (ld_is_rdfxml (gzip_name))\n"
"DB.DBA.RDF_LOAD_RDFXML (gz_file_open (f), graph, graph);\n"
"else\n"
"TTLP (gz_file_open (f), graph, graph, ld_ttlp_flags (gzip_name, graph));\n"
"}\n"
"else\n"
"{\n"
"if (ld_is_rdfxml (f))\n"
"DB.DBA.RDF_LOAD_RDFXML (file_open (f), graph, graph);\n"
"else\n"
"TTLP (file_open (f), graph, graph, ld_ttlp_flags (f, graph));\n"
"}\n"
"\n"
"\n"
"}\n"
"--src rdflddir2.sql:151\n";

static const char *proc564 = 
"#line 201 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"rdf_load_dir (in path varchar,\n"
"in mask varchar := \'%.nt\',\n"
"in graph varchar := \'http://dbpedia.org\')\n"
"{\n"
"\n"
"delete from DB.DBA.LOAD_LIST where LL_FILE = \'##stop\';\n"
"commit work;\n"
"\n"
"ld_dir (path, mask, graph);\n"
"\n"
"rdf_loader_run ();\n"
"}\n"
"--src rdflddir2.sql:199\n";

static const char *proc565 = 
"#line 217 \"[executable]/rdflddir2.sql\"\n"
"create procedure ld_array ()\n"
"{\n"
"declare arr, fs, len, local any;\n"
"declare cr cursor for\n"
"select LL_FILE, LL_GRAPH\n"
"from DB.DBA.LOAD_LIST table option (index ll_state)\n"
"where LL_STATE = 0\n"
"for update;\n"
"declare fill int;\n"
"declare f, g varchar;\n"
"declare r any;\n"
"whenever not found goto done;\n"
"arr := make_array (100, \'any\');\n"
"fs  := make_array (100, \'any\');\n"
"fill := 0;\n"
"len := 0;\n"
"open cr;\n"
"for (;;)\n"
"{\n"
"fetch cr into f, g;\n"
"if (file_stat (f, 1) = 0)\n"
"goto next;\n"
"arr[fill] := vector (f, g);\n"
"fs[fill] := f;\n"
"len := len + cast (file_stat (f, 1) as int);\n"
"fill := fill + 1;\n"
"if (len > 2000000 or fill >= 100)\n"
"goto done;\n"
"next:;\n"
"}\n"
"done:\n"
"if (0 = fill)\n"
"return 0;\n"
"if (1 <> sys_stat (\'cl_run_local_only\'))\n"
"local := sys_stat (\'cl_this_host\');\n"
"update load_list set ll_state = 1, ll_started = curdatetime (), LL_HOST = local where ll_file in (fs);\n"
"close cr;\n"
"return arr;\n"
"}\n"
"--src rdflddir2.sql:215\n";

static const char *proc566 = 
"#line 258 \"[executable]/rdflddir2.sql\"\n"
"create procedure\n"
"rdf_loader_run (in max_files integer := null, in log_enable int := 2)\n"
"{\n"
"declare sec_delay float;\n"
"declare _f, _graph varchar;\n"
"declare arr any;\n"
"declare xx, inx, tx_mode, ld_mode int;\n"
"ld_mode := log_enable;\n"
"if (0 = sys_stat (\'cl_run_local_only\'))\n"
"{\n"
"if (log_enable = 2 and cl_this_host () = 1)\n"
"{\n"
"cl_exec (\'checkpoint_interval (0)\');\n"
"cl_exec (\'__dbf_set (\'\'cl_non_logged_write_mode\'\', 1)\');\n"
"}\n"
"if (cl_this_host () = 1)\n"
"cl_exec(\'__dbf_set(\'\'cl_max_keep_alives_missed\'\',3000)\');\n"
"}\n"
"tx_mode := bit_and (1, log_enable);\n"
"log_message (\'Loader started\');\n"
"\n"
"delete from DB.DBA.LOAD_LIST where LL_FILE = \'##stop\';\n"
"commit work;\n"
"\n"
"while (1)\n"
"{\n"
"set isolation = \'repeatable\';\n"
"declare exit handler for sqlstate \'40001\' {\n"
"rollback work;\n"
"sec_delay := rnd(1000)*0.001;\n"
"log_message(sprintf(\'deadlock in loader, waiting %d milliseconds\', cast (sec_delay * 1000 as integer)));\n"
"delay(sec_delay);\n"
"goto again;\n"
"};\n"
"\n"
"again:;\n"
"\n"
"if (exists (select 1 from DB.DBA.LOAD_LIST where LL_FILE = \'##stop\'))\n"
"{\n"
"log_message (\'File load stopped by rdf_load_stop.\');\n"
"return;\n"
"}\n"
"\n"
"log_enable (tx_mode, 1);\n"
"\n"
"if (max_files is not null and max_files <= 0)\n"
"{\n"
"commit work;\n"
"log_message (\'Max_files reached. Finishing.\');\n"
"return;\n"
"}\n"
"\n"
"whenever not found goto looks_empty;\n"
"\n"
"\n"
"set isolation = \'serializable\';\n"
"select id into xx from ldlock where id = 0 for update;\n"
"arr := ld_array ();\n"
"commit work;\n"
"if (0 = arr)\n"
"goto looks_empty;\n"
"log_enable (ld_mode, 1);\n"
"set isolation = \'committed\';\n"
"\n"
"for (inx := 0; inx < 100; inx := inx + 1)\n"
"{\n"
"if (0 = arr[inx])\n"
"goto arr_done;\n"
"ld_file (arr[inx][0], arr[inx][1]);\n"
"update DB.DBA.LOAD_LIST set LL_STATE = 2, LL_DONE = curdatetime () where LL_FILE = arr[inx][0];\n"
"if (max_files is not null) max_files := max_files - 1;\n"
"}\n"
"arr_done:\n"
"log_enable (tx_mode, 1);\n"
"\n"
"commit work;\n"
"}\n"
"\n"
"looks_empty:\n"
"commit work;\n"
"log_message (\'No more files to load. Loader has finished,\');\n"
"return;\n"
"\n"
"}\n"
"--src rdflddir2.sql:256\n";

static const char *proc567 = 
"#line 344 \"[executable]/rdflddir2.sql\"\n"
"create procedure rdf_load_stop (in force int := 0)\n"
"{\n"
"insert into DB.DBA.LOAD_LIST (LL_FILE) values (\'##stop\');\n"
"commit work;\n"
"if (force)\n"
"cl_exec (\'txn_killall (1)\');\n"
"}\n"
"--src rdflddir2.sql:342\n";

static const char *proc568 = 
"#line 354 \"[executable]/rdflddir2.sql\"\n"
"create procedure RDF_LOADER_RUN_1 (in x int, in y int)\n"
"{\n"
"rdf_loader_run (x, y);\n"
"}\n"
"--src rdflddir2.sql:352\n";

static const char *proc569 = 
"#line 360 \"[executable]/rdflddir2.sql\"\n"
"create procedure rdf_ld_srv (in log_enable int := 2)\n"
"{\n"
"declare aq any;\n"
"aq := async_queue (1);\n"
"aq_request (aq, \'DB.DBA.RDF_LOADER_RUN_1\', vector (null, log_enable));\n"
"aq_wait_all (aq);\n"
"}\n"
"--src rdflddir2.sql:358\n";

static const char *proc570 = 
"#line 370 \"[executable]/rdflddir2.sql\"\n"
"create procedure load_grdf (in f varchar)\n"
"{\n"
"declare line any;\n"
"declare inx int;\n"
"declare ses any;\n"
"declare gr varchar;\n"
"\n"
"if (f like \'%.gz\')\n"
"ses := gz_file_open (f);\n"
"else\n"
"ses := file_open (f);\n"
"inx := 0;\n"
"line := \'\';\n"
"while (line <> 0)\n"
"{\n"
"gr := ses_read_line (ses, 0, 0, 1);\n"
"if (gr = 0) return;\n"
"line := ses_read_line (ses, 0, 0, 1);\n"
"if (line = 0) return;\n"
"DB.DBA.RDF_LOAD_RDFXML (line, gr, gr);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src rdflddir2.sql:368\n";

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_sparql (void)
{
  /* sparql.sql */

  ddl_ensure_table ("DB.DBA.RDF_QUAD", tbl0);
  ddl_ensure_table ("DB.DBA.RDF_QUAD_RECOV_TMP", tbl1);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME_SAFE", proc0);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME_COMP", proc1);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_IID", proc2);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("do this always", other1);
  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("DB.DBA.RDF_OBJ", tbl2);
  ddl_ensure_table ("DB.DBA.RO_START", tbl3);
  ddl_ensure_table ("DB.DBA.RDF_DATATYPE", tbl4);
  ddl_ensure_table ("DB.DBA.RDF_LANGUAGE", tbl5);
  ddl_ensure_table ("DB.DBA.SYS_SPARQL_HOST", tbl6);
  ddl_ensure_column ("DB.DBA.SYS_SPARQL_HOST", "SH_BASE_URI", alter0, 0);
  ddl_ensure_table ("DB.DBA.RDF_OBJ_FT_RULES", tbl7);
  ddl_ensure_table ("DB.DBA.SYS_SPARQL_SW_LOG", tbl8);
  ddl_ensure_table ("DB.DBA.SYS_XML_PERSISTENT_NS_DECL", tbl9);
  ddl_ensure_table ("DB.DBA.RDF_EXPLICITLY_CREATED_GRAPH", tbl10);
  ddl_ensure_table ("DB.DBA.RDF_GEO", tbl11);
  ddl_ensure_table ("DB.DBA.RDF_LABEL", tbl12);
  ddl_ensure_table ("DB.DBA.RDF_QUAD_DELETE_QUEUE", tbl13);
  ddl_ensure_table ("DB.DBA.SYS_IDONLY_EMPTY", tbl14);
  ddl_ensure_table ("DB.DBA.SYS_IDONLY_ONE", tbl15);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  ddl_ensure_table ("do this always", other5);
  ddl_ensure_table ("do this always", other6);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  ddl_ensure_table ("do this always", other9);
  ddl_ensure_table ("do this always", other10);
  DEFINE_PROC ("RDF_QUAD_FT_INIT", proc3);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_RO_FLAGS_INDEX_HOOK", proc4);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_RO_FLAGS_UNINDEX_HOOK", proc5);
  DEFINE_PROC ("sparql_exec_quiet", proc6);
  ddl_ensure_table ("do this always", other11);
  ddl_ensure_table ("do this always", other12); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_SET_NS_DECL", proc7); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_REMOVE_NS_BY_PREFIX", proc8); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_CLEAR_ALL_NS_DECLS", proc9); 
  DEFINE_PUBLIC_PROC ("DB.DBA.XML_SELECT_ALL_NS_DECLS", proc10);
  DEFINE_PROC ("DB.DBA.XML_LOAD_ALL_NS_DECLS", proc11);
  ddl_ensure_table ("do this always", other13);
  ddl_ensure_table ("do this always", other14);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_ALL_FT_RULES", proc12);
  ddl_ensure_table ("do this always", other15);
  DEFINE_PROC ("DB.DBA.RDF_REPL_START", proc13);
  DEFINE_PROC ("DB.DBA.RDF_REPL_STOP", proc14);
  DEFINE_PROC ("DB.DBA.RDF_REPL_GRAPH_INS", proc15);
  DEFINE_PROC ("DB.DBA.RDF_REPL_GRAPH_DEL", proc16);
  DEFINE_PROC ("DB.DBA.RDF_REPL_SYNC", proc17);
  DEFINE_PROC ("DB.DBA.RDF_REPL_INSERT_TRIPLES", proc18);
  DEFINE_PROC ("DB.DBA.RDF_REPL_DELETE_TRIPLES", proc19);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_QNAME", proc21);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_IID_OF_LONG", proc22);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_GRAPH_IIDS_OF_QNAMES", proc23);
  DEFINE_PROC ("DB.DBA.RDF_TWOBYTE_OF_DATATYPE", proc24);
  DEFINE_PROC ("DB.DBA.RDF_TWOBYTE_OF_LANGUAGE", proc25);
  DEFINE_PROC ("DB.DBA.RQ_LONG_OF_O", proc26);
  DEFINE_PROC ("DB.DBA.RDF_BOX_COMPLETE", proc27);
  DEFINE_PROC ("DB.DBA.RQ_SQLVAL_OF_O", proc28);
  DEFINE_PROC ("DB.DBA.RQ_BOOL_OF_O", proc29);
  DEFINE_PROC ("DB.DBA.RQ_IID_OF_O", proc30);
  DEFINE_PROC ("DB.DBA.RQ_O_IS_LIT", proc31);
  DEFINE_PROC ("RDF_G_INS", proc32);
  DEFINE_PROC ("cl_rdf_geo_insert", proc33);
  DEFINE_PROC ("rdf_geo_add", proc34);
  DEFINE_PROC ("rdf_geo_set_id", proc35);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD", proc36);
  DEFINE_PROC ("DB.DBA.RDF_FIND_RO_DIGEST", proc37);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL", proc38);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_SQLVAL_FT", proc39);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL", proc40);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_FT", proc41);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_OBJ_OF_TYPEDSQLVAL_STRINGS", proc42);
  DEFINE_PROC ("DB.DBA.RDF_LONG_OF_OBJ", proc43);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_OF_OBJ", proc44);
  DEFINE_PROC ("DB.DBA.RDF_LANGUAGE_OF_OBJ", proc45);
  DEFINE_PROC ("DB.DBA.RDF_SQLVAL_OF_OBJ", proc46);
  DEFINE_PROC ("DB.DBA.RDF_BOOL_OF_OBJ", proc47);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_OBJ", proc48);
  DEFINE_PROC ("DB.DBA.RDF_STRSQLVAL_OF_OBJ", proc49);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_OF_LONG", proc50);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_OF_SQLVAL", proc51);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_SQLVAL", proc52);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL", proc53);
  DEFINE_PROC ("DB.DBA.RDF_MAKE_LONG_OF_TYPEDSQLVAL_STRINGS", proc54);
  DEFINE_PROC ("DB.DBA.RDF_QNAME_OF_LONG_SAFE", proc55);
  DEFINE_PROC ("DB.DBA.RDF_SQLVAL_OF_LONG", proc56);
  DEFINE_PROC ("DB.DBA.RDF_BOOL_OF_LONG", proc57);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_OF_LONG", proc58);
  DEFINE_PROC ("DB.DBA.RDF_DATATYPE_IRI_OF_LONG", proc59);
  DEFINE_PROC ("DB.DBA.RDF_STRSQLVAL_OF_LONG", proc60);
  DEFINE_PROC ("DB.DBA.RDF_WIDESTRSQLVAL_OF_LONG", proc61); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DATATYPE_OF_SQLVAL", proc62);
  DEFINE_PROC ("DB.DBA.RDF_LONG_OF_SQLVAL", proc63); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_STRSQLVAL_OF_SQLVAL", proc64); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_LANGUAGE_OF_SQLVAL", proc65); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_BLANK_REF", proc66); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_URI_REF", proc67); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_REF", proc68); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_IS_LITERAL", proc69); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#boolean", proc70); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#date", proc71); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#dateTime", proc72); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#double", proc73); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#float", proc74); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#integer", proc75); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#int", proc76); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#time", proc77); 
  DEFINE_PUBLIC_PROC ("DB.DBA.http://www.w3.org/2001/XMLSchema#string", proc78); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__and", proc79); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__or", proc80); 
  DEFINE_PUBLIC_PROC ("DB.DBA.__not", proc81);
  DEFINE_PROC ("DB.DBA.rdf_strdt_impl", proc82);
  DEFINE_PROC ("DB.DBA.rdf_strlang_impl", proc83); 
  DEFINE_PUBLIC_PROC ("DB.DBA.rdf_replace_impl", proc84); 
  DEFINE_PUBLIC_PROC ("DB.DBA.regexp_xfn_replace", proc85);
  DEFINE_PROC ("DB.DBA.rdf_uuid_impl", proc86); 
  DEFINE_PUBLIC_PROC ("DB.DBA.rdf_timezone_impl", proc87); 
  DEFINE_PUBLIC_PROC ("DB.DBA.rdf_tz_impl", proc88);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI", proc89);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI_L", proc90);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_URI_L_TYPED", proc91);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_L_RDB2RDF", proc92);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_GRAPH", proc93);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_BLANK", proc94);
  DEFINE_PROC ("DB.DBA.TTLP_EV_GET_IID", proc95);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE", proc96);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L", proc97);
  DEFINE_PROC ("DB.DBA.TTLP_EV_COMMIT", proc98);
  DEFINE_PROC ("DB.DBA.TTLP_EV_REPORT_DEFAULT", proc99);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_XLAT", proc100);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_XLAT", proc101); 
  DEFINE_PUBLIC_PROC ("DB.DBA.TTLP_XLAT_CONCAT", proc102);
  DEFINE_PROC ("DB.DBA.TTLP", proc103);
  DEFINE_PROC ("DB.DBA.TTLP_WITH_IRI_TRANSLATION", proc104);
  DEFINE_PROC ("DB.DBA.TTLP_VALIDATE", proc105);
  DEFINE_PROC ("DB.DBA.TTLP_VALIDATE_LOCAL_FILE", proc106);
  DEFINE_PROC ("DB.DBA.RDF_VALIDATE_RDFXML", proc107);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_NEW_GRAPH", proc108);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_NEW_BLANK", proc109);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_GET_IID", proc110);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE", proc111);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L", proc112);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_XLAT", proc113);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH_EXEC_TRIPLE_L_XLAT", proc114);
  DEFINE_PROC ("DB.DBA.RDF_TTL2HASH", proc115);
  DEFINE_PROC ("DB.DBA.RDF_TTL_LOAD_DICT", proc116);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_GET_IID", proc117);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE", proc118);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH_EXEC_TRIPLE_L", proc119);
  DEFINE_PROC ("DB.DBA.RDF_TTL2SQLHASH", proc120);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML_IMPL", proc121);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML", proc122);
  DEFINE_PROC ("DB.DBA.RDF_RDFXML_TO_DICT", proc123);
  DEFINE_PROC ("DB.DBA.RDF_RDFXML_LOAD_DICT", proc124);
  DEFINE_PROC ("DB.DBA.RDFA_LOAD_DICT", proc125);
  DEFINE_PROC ("DB.DBA.RDFA_LOAD_DICT_XLAT", proc126);
  DEFINE_PROC ("DB.DBA.RDF_RDFA11_FETCH_PROFILES", proc127);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFA", proc128);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFA_WITH_IRI_TRANSLATION", proc129);
  DEFINE_PROC ("DB.DBA.RDF_RDFA_TO_DICT", proc130);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_XHTML_MICRODATA", proc131); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_XML_IRI_TO_TTL", proc132); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_XML_OBJ_TO_TTL", proc133); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_NEW_BLANK", proc134); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE", proc135); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL_EV_TRIPLE_L", proc136); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_TO_TTL", proc137); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_CONVERT_RDFXML_FILE_TO_TTL_FILE", proc138);
  DEFINE_PROC ("DB.DBA.RDF_LONG_TO_TTL", proc139);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_BATCH_COMPLETE", proc140);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_VERBOSE_TTL", proc141);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TTL_ENV", proc142);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TTL", proc143);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TRIG", proc144);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_NT", proc145);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_TO_TTL", proc146);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_RDF_XML_TEXT", proc147);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TALIS_JSON", proc148);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_JSON_LD", proc149);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_JSON", proc150);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_CSV", proc151);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_TSV", proc152);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_RDFA_XHTML", proc153);
  DEFINE_PROC ("DB.DBA.RDF_ENDPOINT_DESCRIBE_LINK_FMT", proc154);
  DEFINE_PROC ("DB.DBA.RDF_PIVOT_DESCRIBE_LINK", proc155);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_HTML_UL", proc156);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_HTML_TR", proc157);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_HTML_MICRODATA", proc158);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_JSON_MICRODATA", proc159);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ATOM_XML", proc160);
  DEFINE_PROC ("DB.DBA.ODATA_EDM_TYPE", proc161);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_ODATA_JSON", proc162);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_ODATA_JSON", proc163);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_ATOM_XML_TEXT", proc164);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_INIT", proc165);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_ACC", proc166);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TTL_FIN", proc167);
  ddl_ensure_table ("do this always", other16);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_INIT", proc168);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_ACC", proc169);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_NT_FIN", proc170);
  ddl_ensure_table ("do this always", other17);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_INIT", proc171);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_ACC", proc172);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_RDF_XML_FIN", proc173);
  ddl_ensure_table ("do this always", other18);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_INIT", proc174);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_ACC", proc175);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_JSON_FIN", proc176);
  ddl_ensure_table ("do this always", other19);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_INIT", proc177);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_CSV_WRITE_VALUE", proc178);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_ACC", proc179);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CSV_FIN", proc180);
  ddl_ensure_table ("do this always", other20);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_TSV_ACC", proc181);
  ddl_ensure_table ("do this always", other21);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_INIT", proc182);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_ACC", proc183);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_CXML_FIN", proc184);
  ddl_ensure_table ("do this always", other22);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_INIT", proc185);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_ACC", proc186);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_RESULT_SET_AS_BINDINGS_FIN", proc187);
  ddl_ensure_table ("do this always", other23);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TTL", proc188);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NICE_TTL", proc189);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLES_TO_NICE_TTL", proc190);
  DEFINE_PROC ("DB.DBA.RDF_TRIPLE_OBJ_BNODE_TO_NICE_TTL", proc191);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TRIG", proc192);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_NT", proc193);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDF_XML", proc194);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TALIS_JSON", proc195);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_LD", proc196);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_UL", proc197);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_TR", proc198);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_HTML_MICRODATA", proc199);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_JSON_MICRODATA", proc200);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CSV", proc201);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_TSV", proc202);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_RDFA_XHTML", proc203);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML", proc204);
  DEFINE_PROC ("DB.DBA.RDF_FORMAT_TRIPLE_DICT_AS_CXML_QRCODE", proc205); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_INIT", proc206); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_ACC", proc207); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_XML_FIN", proc208);
  ddl_ensure_table ("do this always", other24); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_INIT", proc209); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_ACC", proc210); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_RDF_XML_FIN", proc211);
  ddl_ensure_table ("do this always", other25); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_INIT", proc212); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_ACC", proc213); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_TTL_FIN", proc214);
  ddl_ensure_table ("do this always", other26); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_NT_FIN", proc215);
  ddl_ensure_table ("do this always", other27);
  ddl_ensure_table ("do this always", other28); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FORMAT_BOOL_RESULT_AS_CSV_FIN", proc216);
  ddl_ensure_table ("do this always", other29);
  DEFINE_PROC ("DB.DBA.RDF_INSERT_TRIPLES_CL", proc217);
  DEFINE_PROC ("DB.DBA.RDF_INSERT_TRIPLES", proc218);
  DEFINE_PROC ("DB.DBA.RDF_DELETE_TRIPLES", proc219);
  DEFINE_PROC ("DB.DBA.RDF_DELETE_TRIPLES_AGG", proc220);
  DEFINE_PROC ("DB.DBA.RDF_MODIFY_TRIPLES", proc221); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_INIT", proc222); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_CTOR_IMPL", proc223); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_DELETE_CTOR_ACC", proc224); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INSERT_CTOR_ACC", proc225); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_MODIFY_CTOR_ACC", proc226); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_INS_OR_DEL_OR_MODIFY_CTOR_FIN", proc227); 
  ddl_ensure_table ("do this always", other30); 
  ddl_ensure_table ("do this always", other31); 
  ddl_ensure_table ("do this always", other32);
  DEFINE_PROC ("DB.DBA.SPARQL_INSERT_DICT_CONTENT", proc228);
  DEFINE_PROC ("DB.DBA.SPARQL_DELETE_DICT_CONTENT", proc229);
  DEFINE_PROC ("DB.DBA.SPARQL_MODIFY_BY_DICT_CONTENTS", proc230);
  DEFINE_PROC ("DB.DBA.RDF_REPL_DEL", proc231);
  DEFINE_PROC ("DB.DBA.SPARUL_CLEAR", proc232);
  DEFINE_PROC ("DB.DBA.SPARUL_LOAD", proc233);
  DEFINE_PROC ("DB.DBA.SPARUL_LOAD_SERVICE_DATA", proc234);
  DEFINE_PROC ("DB.DBA.SPARUL_CREATE", proc235);
  DEFINE_PROC ("DB.DBA.SPARUL_DROP", proc236);
  DEFINE_PROC ("DB.DBA.SPARUL_RUN", proc237); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_BINDINGS_VIEW_IMP", proc238);
  ddl_ensure_table ("DB.DBA.SPARQL_BINDINGS_VIEW", view0);
  ddl_ensure_table ("do this always", other33);
  DEFINE_PROC ("DB.DBA.RDF_INSERT_QUADS", proc239);
  DEFINE_PROC ("DB.DBA.RDF_DELETE_QUADS", proc240);
  DEFINE_PROC ("DB.DBA.SPARQL_INSERT_QUAD_DICT_CONTENT", proc241);
  DEFINE_PROC ("DB.DBA.SPARQL_DELETE_QUAD_DICT_CONTENT", proc242);
  DEFINE_PROC ("DB.DBA.SPARQL_MODIFY_BY_QUAD_DICT_CONTENTS", proc243);
  DEFINE_PROC ("DB.DBA.SPARUL_COPYMOVEADD_IMPL", proc244);
  DEFINE_PROC ("DB.DBA.SPARUL_COPY", proc245);
  DEFINE_PROC ("DB.DBA.SPARUL_MOVE", proc246);
  DEFINE_PROC ("DB.DBA.SPARUL_ADD", proc247);
  DEFINE_PROC ("DB.DBA.SPARQL_SELECT_KNOWN_GRAPHS", proc248); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_REGEX", proc249); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_LANGMATCHES", proc250); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_INIT", proc251); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_ACC", proc252); 
  DEFINE_PUBLIC_PROC ("DB.DBA.BEST_LANGMATCH_FINAL", proc253); 
  ddl_ensure_table ("do this always", other34); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_INIT", proc254); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_ACC", proc255); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CONSTRUCT_FIN", proc256); 
  ddl_ensure_table ("do this always", other35);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_INIT", proc257);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_ACC", proc258);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_AGG_FIN", proc259);
  ddl_ensure_table ("do this always", other36);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT", proc260);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SPO", proc261);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SPO_PHYSICAL", proc262);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_CBD", proc263);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_CBD_PHYSICAL", proc264);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_OBJCBD", proc265);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_OBJCBD_PHYSICAL", proc266);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SCBD", proc267);
  DEFINE_PROC ("DB.DBA.SPARQL_DESC_DICT_SCBD_PHYSICAL", proc268); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DICT_OF_TRIPLES_TO_THREE_COLS", proc269); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DICT_OF_TRIPLES_TO_FOUR_COLS", proc270);
  DEFINE_PROC ("DB.DBA.RDF_TYPEMIN_OF_OBJ", proc271);
  DEFINE_PROC ("DB.DBA.RDF_TYPEMAX_OF_OBJ", proc272);
  DEFINE_PROC ("DB.DBA.RDF_IID_CMP", proc273);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_CMP", proc274);
  DEFINE_PROC ("DB.DBA.RDF_LONG_CMP", proc275); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DIST_SER_LONG", proc276); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_DIST_DESER_LONG", proc277);
  DEFINE_PROC ("DB.DBA.JSO_LOAD_AND_PIN_SYS_GRAPH", proc278);
  DEFINE_PROC ("DB.DBA.JSO_DUMP_IRI", proc279);
  DEFINE_PROC ("DB.DBA.JSO_DUMP_FLD", proc280);
  DEFINE_PROC ("DB.DBA.JSO_VECTOR_TO_TTL", proc281);
  DEFINE_PROC ("DB.DBA.JSO_FILTERED_PROPLIST", proc282);
  DEFINE_PROC ("DB.DBA.JSO_DUMP_ALL", proc283);
  DEFINE_PROC ("DB.DBA.RDF_BACKUP_METADATA", proc284);
  DEFINE_PROC ("DB.DBA.RDF_RESTORE_METADATA", proc285);
  DEFINE_PROC ("DB.DBA.RDF_AUDIT_METADATA", proc286);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHANGE", proc287);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHANGE_OPT", proc288);
  DEFINE_PROC ("DB.DBA.RDF_QM_APPLY_CHANGES", proc289);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_JSO_TYPE", proc290);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_STORAGE_FLAG", proc291);
  DEFINE_PROC ("DB.DBA.RDF_QM_ASSERT_STORAGE_CONTAINS_MAPPING", proc292);
  DEFINE_PROC ("DB.DBA.RDF_QM_GC_SUBTREE", proc293);
  DEFINE_PROC ("DB.DBA.RDF_QM_GC_MAPPING_SUBTREE", proc294);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_MAPPING", proc295);
  DEFINE_PROC ("DB.DBA.RDF_QM_MACROEXPAND_TEMPLATE", proc296);
  DEFINE_PROC ("DB.DBA.RDF_QM_CBD_OF_IRI_CLASS", proc297);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FORMAT", proc298);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_IRI_CLASS_FUNCTIONS", proc299);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FORMAT", proc300);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_FUNCTIONS", proc301);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_LITERAL_CLASS_WITH_FIXED_LANG", proc302); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_BAD_CLASS_INV_FUNCTION", proc303); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SQLNAME_NOTATION_TO_NAME", proc304); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SQLQNAME_NOTATION_TO_QNAME", proc305);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHECK_CLASS_FUNCTION_HEADERS", proc306);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_SUBCLASS", proc307);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_CLASS", proc308);
  DEFINE_PROC ("DB.DBA.RDF_QM_DROP_QUAD_STORAGE", proc309);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_QUAD_STORAGE", proc310);
  DEFINE_PROC ("DB.DBA.RDF_QM_BEGIN_ALTER_QUAD_STORAGE", proc311);
  DEFINE_PROC ("DB.DBA.RDF_QM_END_ALTER_QUAD_STORAGE", proc312);
  DEFINE_PROC ("DB.DBA.RDF_QM_STORE_ATABLES", proc313);
  DEFINE_PROC ("DB.DBA.RDF_QM_FT_USAGE", proc314);
  DEFINE_PROC ("DB.DBA.RDF_QM_CHECK_COLUMNS_FORM_KEY", proc315);
  ddl_ensure_table ("do this always", other37);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_MAP_VALUE", proc316);
  DEFINE_PROC ("DB.DBA.RDF_QM_NORMALIZE_QMV", proc317);
  DEFINE_PROC ("DB.DBA.RDF_QM_DEFINE_MAPPING", proc318);
  DEFINE_PROC ("DB.DBA.RDF_QM_ATTACH_MAPPING", proc319);
  DEFINE_PROC ("DB.DBA.RDF_QM_ADD_MAPPING_TO_STORAGE", proc320);
  DEFINE_PROC ("DB.DBA.RDF_QM_DELETE_MAPPING_FROM_STORAGE", proc321);
  DEFINE_PROC ("DB.DBA.RDF_QM_SET_DEFAULT_MAPPING", proc322);
  DEFINE_PROC ("DB.DBA.RDF_SML_DROP", proc323);
  DEFINE_PROC ("DB.DBA.RDF_SML_CREATE", proc324);
  DEFINE_PROC ("DB.DBA.RDF_QM_DETACH_MACRO_LIBRARY", proc325);
  DEFINE_PROC ("DB.DBA.RDF_QM_ATTACH_MACRO_LIBRARY", proc326);
  DEFINE_PROC ("DB.DBA.RDF_ADD_qmAliasesKeyrefdByQuad", proc327);
  DEFINE_PROC ("DB.DBA.RDF_UPGRADE_QUAD_MAP", proc328);
  DEFINE_PROC ("DB.DBA.RDF_UPGRADE_METADATA", proc329);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_W", proc330);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_W", proc331);
  DEFINE_PROC ("DB.DBA.TTLP_EV_NEW_GRAPH_A", proc332);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_A", proc333);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_A", proc334);
  DEFINE_PROC ("DB.DBA.TTLP_EV_COMMIT_A", proc335);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_R", proc336);
  DEFINE_PROC ("DB.DBA.TTLP_EV_TRIPLE_L_R", proc337);
  DEFINE_PROC ("DB.DBA.TTLP_EV_COMMIT_R", proc338);
  DEFINE_PROC ("DB.DBA.TTLP_MT", proc339);
  DEFINE_PROC ("DB.DBA.TTLP_MT_LOCAL_FILE", proc340);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML_MT", proc341);
  DEFINE_PROC ("DB.DBA.VT_DECODE_KEYWORD_ITM", proc342);
  DEFINE_PROC ("DB.DBA.VT_ENCODE_KEYWORD_ITM", proc343);
  DEFINE_PROC ("DB.DBA.VT_COMPOSE_KEYWORD_INDEX_LINES", proc344); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_GRAPH", proc345); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_OBJ_PATCH_CONTAINS_BY_MANY_GRAPHS", proc346);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH", proc347);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_ADD_KEYWORD_FOR_GRAPH_OLD", proc348);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RULE_ADD", proc349);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RULE_DEL", proc350);
  DEFINE_PROC ("DB.DBA.RDF_OBJ_FT_RECOVER", proc351);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_GROUP", tbl16);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_GROUP_MEMBER", tbl17);
  ddl_ensure_table ("DB.DBA.RDF_GRAPH_USER", tbl18);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_CACHE_IID", proc352);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_CREATE_MEMONLY", proc353);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_IRI_CHECK", proc354);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_CREATE", proc355);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DROP_MEMONLY", proc356);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DROP", proc357);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_CHECK_VISIBILITY_CHANGE", proc358);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_INS_MEMONLY", proc359);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_INS", proc360);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DEL_MEMONLY", proc361);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_DEL", proc362);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_GET", proc363);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_ACK", proc364); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_GRAPH_USER_PERM_TITLE", proc365);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_ASSERT", proc366);
  DEFINE_PROC ("DB.DBA.RDF_DEFAULT_USER_PERMS_SET_MEMONLY", proc367);
  DEFINE_PROC ("DB.DBA.RDF_DEFAULT_USER_PERMS_SET", proc368);
  DEFINE_PROC ("DB.DBA.RDF_DEFAULT_USER_PERMS_DEL", proc369);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_SET_MEMONLY", proc370);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_SET", proc371);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_DEL_MEMONLY", proc372);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_USER_PERMS_DEL", proc373);
  DEFINE_PROC ("DB.DBA.RDF_ALL_USER_PERMS_DEL", proc374);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_GROUP_LIST_GET", proc375);
  DEFINE_PROC ("DB.DBA.RDF_GRAPH_SECURITY_AUDIT", proc376);
  DEFINE_PROC ("DB.DBA.SPARQL_RELOAD_QM_GRAPH", proc377);
  DEFINE_PROC ("DB.DBA.RDF_CREATE_SPARQL_ROLES", proc378);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_AUDIT", proc379);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_OUTLINE_ALL", proc380);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_LOAD_CACHE", proc381);
  DEFINE_PROC ("DB.DBA.RDF_QUAD_FT_UPGRADE", proc382);
  ddl_ensure_table ("do this always", other40);
  DEFINE_PROC ("rdfs_pn", proc383);
  DEFINE_PROC ("rdf_owl_sas_p", proc384);
  ddl_ensure_table ("DB.DBA.SYS_RDF_SCHEMA", tbl19);
  DEFINE_PROC ("rdfs_load_schema", proc385);
  DEFINE_PROC ("rdf_schema_ld", proc386);
  ddl_ensure_table ("do this always", other41);
  DEFINE_PROC ("CL_RDF_INF_CHANGED_SRV", proc387);
  DEFINE_PROC ("CL_RDF_INF_CHANGED", proc388);
  DEFINE_PROC ("rdfs_rule_set", proc389);
  DEFINE_PROC ("DB.DBA.RDF_IID_OF_QNAME", proc390);
  DEFINE_PROC ("SPARQL_INI_PARAMS", proc391);
  DEFINE_PROC ("cl_tmp_inx_recov_fill", proc392);
  DEFINE_PROC ("cl_inx_recov_clean", proc393);
  DEFINE_PROC ("cl_inx_recov_fill_1", proc394);
  DEFINE_PROC ("exec_from_daq", proc395);
  DEFINE_PROC ("cl_inx_recov", proc396);

  /* sparql_io.sql */
 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_WRITE_NS", proc397); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_WRITE_HEAD", proc398); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_PRE", proc399); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_INIT", proc400); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_XML_HTTP_FINAL", proc401); 
  ddl_ensure_table ("do this always", other42); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_DICT_XML_HTTP_PRE", proc402); 
  ddl_ensure_table ("do this always", other43); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_WRITE_NS", proc403); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_WRITE_HEAD", proc404); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_PRE", proc405); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_INIT", proc406); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_TTL_HTTP_FINAL", proc407); 
  ddl_ensure_table ("do this always", other44); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_NT_WRITE_NS", proc408); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_NT_WRITE_HEAD", proc409); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_RSET_NT_HTTP_PRE", proc410); 
  ddl_ensure_table ("do this always", other45);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_INT", proc411);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC", proc412);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_TO_ARRAY", proc413);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_TO_ARRAY_OF_OBJ", proc414);
  DEFINE_PROC ("DB.DBA.SPARQL_REXEC_WITH_META", proc415);
  DEFINE_PROC ("DB.DBA.SPARQL_SD_PROBE", proc416);
  DEFINE_PROC ("DB.DBA.SPARQL_SINV_IMP", proc417);
  ddl_ensure_table ("DB.DBA.SPARQL_SINV_2", view1);
  DEFINE_PROC ("querySoap", proc418); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_WRITE_EXEC_STATUS", proc419);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_XML_WRITE_HEAD", proc420);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_XML_WRITE_RES", proc421);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_XML_WRITE_ROW", proc422);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_NS", proc423);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_HEAD", proc424);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_RES", proc425);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_RDFXML_WRITE_ROW", proc426);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_TTL_WRITE_NS", proc427);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_TTL_WRITE_HEAD", proc428);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_TTL_WRITE_RES", proc429);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_NT_WRITE_NS", proc430);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_NT_WRITE_HEAD", proc431);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_NT_WRITE_RES", proc432);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_JAVASCRIPT_HTML_WRITE", proc433);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_JSON_WRITE_BINDING", proc434);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_JSON_WRITE", proc435);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_CSV_WRITE", proc436);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_TSV_WRITE", proc437);
  DEFINE_PROC ("DB.DBA.SPARQL_RESULTS_WRITE", proc438);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_SVC_DESC", proc439);
  DEFINE_PROC ("WS.WS.SPARQL_VHOST_RESET", proc440);
  DEFINE_PROC ("DB.DBA.SPARQL_PROTOCOL_ERROR_REPORT", proc441);
  DEFINE_PROC ("DB.DBA.SPARQL_WSDL11", proc442);
  DEFINE_PROC ("DB.DBA.SPARQL_WSDL", proc443);
  DEFINE_PROC ("DB.DBA.SPARQL_SOAP_NS", proc444);
  DEFINE_PROC ("DB.DBA.SPARQL_PT_NS", proc445); 
  DEFINE_PUBLIC_PROC ("DB.DBA.PARSE_SPARQL_WS_PARAMS", proc446);
  DEFINE_PROC ("DB.DBA.rdf_find_str", proc447);
  ddl_ensure_table ("do this always", other46);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_HTML_DOCTYPE", proc448);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_HTML_HEAD", proc449);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_STYLE", proc450);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_JAVASCRIPT", proc451);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_FOOTER", proc452);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_FORMAT_OPTS", proc453);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_SPONGE_OPTS", proc454);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_CXML_OPTION", proc455);
  DEFINE_PROC ("WS.WS.sparql_predefined_nsdecl", proc456);
  DEFINE_PROC ("WS.WS.sparql_predefined_rdfinf", proc457);
  DEFINE_PROC ("WS.WS.SPARQL_ENDPOINT_GENERATE_FORM", proc458);
  DEFINE_PROC ("WS.WS./!sparql/", proc459);
  ddl_ensure_table ("do this always", other47); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BLANK", proc460); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE", proc461); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_EV_TRIPLE_L", proc462); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_EV_NEW_BASE", proc463); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_TTL", proc464); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_CRUD_BASE_RDFXML", proc465);
  DEFINE_PROC ("WS.WS./!sparql-graph-crud/", proc466);
  ddl_ensure_table ("do this always", other48);
  DEFINE_PROC ("DB.DBA.SPARQL_REFRESH_DYNARES_RESULTS", proc467); 
  DEFINE_PUBLIC_PROC ("DB.DBA.SPARQL_ROUTE_IF_DAV", proc468);
  DEFINE_PROC ("DB.DBA.SPARQL_ROUTE_DICT_CONTENT_DAV", proc469);
  DEFINE_PROC ("WS.WS.__http_handler_rq", proc470);
  DEFINE_PROC ("WS.WS.__http_handler_head_rq", proc471);
  DEFINE_PROC ("DB.DBA.http_rq_file_handler", proc472);
  DEFINE_PROC ("DB.DBA.SPARQL_SD_TRIPLE", proc473);
  DEFINE_PROC ("DB.DBA.SPARQL_SD_TRIPLE_L", proc474);
  DEFINE_PROC ("DB.DBA.SPARQL_SD_COMPOSE", proc475);
  DEFINE_PROC ("WS.WS./!sparql-sd/", proc476);
  ddl_ensure_table ("do this always", other49);
  DEFINE_PROC ("DB.DBA.RDF_GRANT_SPARQL_IO", proc477);

  /* rdf_sponge.sql */
 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_FT_INDEX_GRABBED", proc478);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_PREPARE_PRIVATE", proc479);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SINGLE", proc480);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SINGLE_ASYNC", proc481);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_SEEALSO", proc482);
  DEFINE_PROC ("DB.DBA.RDF_GRAB", proc483);
  DEFINE_PROC ("DB.DBA.RDF_GRAB_RESOLVER_DEFAULT", proc484);
  DEFINE_PROC ("DB.DBA.SPARQL_EVAL_TO_ARRAY", proc485);
  DEFINE_PROC ("DB.DBA.SPARQL_EVAL", proc486);
  ddl_ensure_table ("DB.DBA.SYS_HTTP_SPONGE", tbl20);
  ddl_ensure_column ("DB.DBA.SYS_HTTP_SPONGE", "HS_NOTE", alter1, 0);
  ddl_ensure_table ("DB.DBA.SYS_HTTP_SPONGE_REFRESH_DEFAULTS", tbl21);
  ddl_ensure_column ("DB.DBA.SYS_HTTP_SPONGE", "HS_NOTE", alter2, 0);
  ddl_ensure_table ("DB.DBA.SYS_HTTP_SPONGE_REFRESH_DEFAULTS", tbl22);
  ddl_ensure_table ("DB.DBA.RDF_WEBID_ACL_GROUPS", tbl23);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_GET_CACHE_PARAMS", proc487);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_DEP_URL_NOT_CHANGED", proc488);
  DEFINE_PROC ("DB.DBA.RDF_HTTP_MAKE_HTTP_REQ", proc489);
  DEFINE_PROC ("DB.DBA.SYS_HTTP_SPONGE_UP", proc490);
  DEFINE_PROC ("DB.DBA.SYS_FILE_SPONGE_UP", proc491);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_TRY_TTL", proc492);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_GUESS_TTL_CONTENT_TYPE", proc493);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_GUESS_CONTENT_TYPE", proc494);
  ddl_ensure_table ("DB.DBA.SYS_RDF_MAPPERS", tbl24);
  DEFINE_PROC ("DB.DBA.RDF_HTTP_URL_GET", proc495);
  DEFINE_PROC ("DB.DBA.COOKIE_HDR", proc496);
  DEFINE_PROC ("DB.DBA.RDF_SW_PING", proc497);
  DEFINE_PROC ("DB.DBA.RDF_PROC_COLS", proc498);
  DEFINE_PROC ("DB.DBA.RDF_PROXY_GET_HTTP_HOST", proc499);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_IRI_SCH", proc500); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_PROXY_ENTITY_IRI", proc501); 
  DEFINE_PUBLIC_PROC ("DB.DBA.RDF_SPONGE_PROXY_IRI(in", proc502);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_RDFXML_PP_GENERIC", proc503);
  DEFINE_PROC ("DB.DBA.RDF_LOAD_HTTP_RESPONSE", proc504);
  DEFINE_PROC ("DB.DBA.RDF_FORGET_HTTP_RESPONSE", proc505);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP", proc506);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP_1", proc507);
  DEFINE_PROC ("DB.DBA.RDF_SPONGE_UP_LIST", proc508);
  DEFINE_PROC ("DB.DBA.RDF_GRANT_SPONGE", proc509);
  ddl_ensure_table ("do this always", other52);
  ddl_ensure_table ("do this always", other53);

  /* rdf_schema_objects.sql */

  DEFINE_PROC ("rdf_view_tbl_opts", proc510);
  DEFINE_PROC ("rdf_view_tbl_pk_cols", proc511);
  DEFINE_PROC ("rdf_view_ns_get", proc512);
  DEFINE_PROC ("rdf_view_ns_get_1", proc513);
  DEFINE_PROC ("RDF_VIEW_DROP_STMT_BY_GRAPH", proc514);
  DEFINE_PROC ("RDF_VIEW_DROP_STMT", proc515);
  DEFINE_PROC ("RDF_VIEW_FROM_TBL", proc516);
  DEFINE_PROC ("rdf_view_sp", proc517);
  DEFINE_PROC ("rdf_view_sql_tb", proc518);
  DEFINE_PROC ("rdf_view_tb", proc519);
  DEFINE_PROC ("rdf_view_sql_col", proc520);
  DEFINE_PROC ("rdf_view_col", proc521);
  DEFINE_PROC ("rdf_view_cls_name", proc522);
  DEFINE_PROC ("rdf_view_get_ns", proc523);
  DEFINE_PROC ("rdf_view_uri_curie", proc524);
  DEFINE_PROC ("rdf_view_col_type", proc525);
  DEFINE_PROC ("rdf_view_create_view", proc526);
  DEFINE_PROC ("rdf_view_create_void_view", proc527);
  DEFINE_PROC ("rdf_view_get_pk_rel", proc528);
  DEFINE_PROC ("rdf_view_get_bin_rel", proc529);
  DEFINE_PROC ("rdf_view_get_fk_pk_rel", proc530);
  DEFINE_PROC ("rdf_view_get_pk_fk_rel", proc531);
  DEFINE_PROC ("rdf_view_dv_to_printf_str_type", proc532);
  DEFINE_PROC ("rdf_view_dv_to_sql_str_type", proc533);
  DEFINE_PROC ("rdf_view_dv_to_xsd_str_type", proc534);
  DEFINE_PROC ("rdf_view_create_class", proc535);
  DEFINE_PROC ("rdf_view_get_primary_key", proc536);
  DEFINE_PROC ("rdf_view_get_relations", proc537);
  DEFINE_PROC ("RDF_OWL_FROM_TBL", proc538);
  DEFINE_PROC ("RDF_VIEW_GEN_VD", proc539);
  DEFINE_PROC ("RDF_OWL_GEN_VD", proc540);
  DEFINE_PROC ("RDF_VIEW_CHECK_SYNC_TB", proc541);
  DEFINE_PROC ("RDF_VIEW_DO_SYNC", proc542);
  DEFINE_PROC ("RDF_VIEW_SYNC_TO_PHYSICAL", proc543);
  DEFINE_PROC ("DB.DBA.R2RML_FROM_TBL", proc544);
  DEFINE_PROC ("DB.DBA.R2RML_QUAL_NOTATION", proc545);
  DEFINE_PROC ("DB.DBA.R2RML_CREATE_DATASET", proc546);
  DEFINE_PROC ("TBOX_URL_REWRITE", proc547);

  /* rdf_void.sql */

  ddl_ensure_table ("DB.DBA.RDF_VOID_GRAPH", tbl25);
  ddl_ensure_table ("DB.DBA.RDF_VOID_GRAPH_MEMBER", tbl26);
  DEFINE_PROC ("RDF_VOID_INIT", proc548);
  ddl_ensure_table ("do this always", other54);
  DEFINE_PROC ("RDF_VOID_SPLIT_IRI", proc549);
  DEFINE_PROC ("RDF_VOID_STORE", proc550);
  DEFINE_PROC ("RDF_VOID_ALL_GEN", proc551);
  DEFINE_PROC ("RDF_VOID_NS", proc552);
  DEFINE_PROC ("RDF_VOID_GEN", proc553);
  DEFINE_PROC ("RDF_VOID_DIST_O_SRV", proc554);
  DEFINE_PROC ("RDF_VOID_DIST_O", proc555);
  DEFINE_PROC ("RDF_VOID_GEN_1", proc556);

  /* rdflddir2.sql */

  ddl_ensure_table ("DB.DBA.LOAD_LIST", tbl27);
  ddl_ensure_table ("DB.DBA.LDLOCK", tbl28);
  ddl_ensure_table ("do this always", other55);
  DEFINE_PROC ("ld_dir", proc557);
  DEFINE_PROC ("rdf_read_dir", proc558);
  DEFINE_PROC ("ld_dir_all", proc559);
  DEFINE_PROC ("ld_add", proc560);
  DEFINE_PROC ("ld_ttlp_flags", proc561);
  DEFINE_PROC ("ld_is_rdfxml", proc562);
  DEFINE_PROC ("ld_file", proc563);
  DEFINE_PROC ("rdf_load_dir", proc564);
  DEFINE_PROC ("ld_array", proc565);
  DEFINE_PROC ("rdf_loader_run", proc566);
  DEFINE_PROC ("rdf_load_stop", proc567);
  DEFINE_PROC ("RDF_LOADER_RUN_1", proc568);
  DEFINE_PROC ("rdf_ld_srv", proc569);
  DEFINE_PROC ("load_grdf", proc570);
}


void
sqls_arfw_define_sparql (void)
{
  /* sparql.sql */

  DEFINE_PROC ("DB.DBA.RDF_GLOBAL_RESET", proc20);
  ddl_ensure_table ("do this always", other38);
  ddl_ensure_table ("do this always", other39);

  /* sparql_io.sql */

 if (sch_proc_def_exists (bootstrap_cli, "DB.DBA.USER_CREATE", 0))
  ddl_ensure_table ("do this always", other50);

  /* rdf_sponge.sql */

 if (sch_proc_def_exists (bootstrap_cli, "DB.DBA.USER_CREATE", 0))
  ddl_ensure_table ("do this always", other51);

}
