//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief A class which provides customized text decorations.
    ///  The Attribute class extends QTextCharFormat, the class which Qt
    ///  uses internally to provide formatting information to characters
    ///  in a text document.
    ///  In addition to its inherited properties, it provides support for:
    ///  <li>several</li> customized text formatting properties
    ///  <li>dynamic</li> highlighting of associated ranges of text
    ///  <li>binding</li> of actions with associated ranges of text (note: not currently implemented)
    ///  Implementations are not required to support all properties.
    ///  In particular, several properties are not supported for dynamic
    ///  highlighting (notably: font() and fontBold()).
    ///  Unfortunately, as QTextFormat's setProperty() is not virtual,
    ///  changes that are made to this attribute cannot automatically be
    ///  redrawn.  Once you have finished changing properties, you should
    ///  call changed() to force redrawing of affected ranges of text.
    ///  \sa SmartInterface
    ///  \author Hamish Rodda \<rodda@kde.org\>
    ///  </remarks>        <short>    \brief A class which provides customized text decorations.</short>
    [SmokeClass("KTextEditor::Attribute")]
    public class Attribute : QTextCharFormat, IDisposable {
        protected Attribute(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Attribute), this);
        }
        /// <remarks>
        ///  Custom property types, which may or may not be supported by implementations.
        ///      </remarks>        <short>    Custom property types, which may or may not be supported by implementations.</short>
        public enum CustomProperties {
            Outline = QTextFormat.Property.UserProperty,
            SelectedForeground = 0,
            SelectedBackground = 1,
            BackgroundFillWhitespace = 2,
            AttributeDynamicEffect = 0x10A00,
            AttributeInternalProperty = 0x10E00,
            AttributeUserProperty = 0x110000,
        }
        /// <remarks>
        ///  Several automatic activation mechanisms exist for associated attributes.
        ///  Using this you can conveniently have your ranges highlighted when either
        ///  the mouse or cursor enter the range.
        ///      </remarks>        <short>    Several automatic activation mechanisms exist for associated attributes.</short>
        public enum ActivationType {
            ActivateMouseIn = 0,
            ActivateCaretIn = 1,
        }
        /// <remarks>
        ///  Dynamic effects for display.
        ///  \todo Pulse and CycleGradient are unclear.
        ///      </remarks>        <short>    Dynamic effects for display.</short>
        public enum Effect {
            EffectNone = 0x0,
            EffectFadeIn = 0x1,
            EffectFadeOut = 0x2,
            EffectPulse = 0x4,
            EffectCycleGradient = 0x8,
        }
        /// <remarks>
        ///  Default constructor.  The resulting Attribute has no properties set to begin with.
        ///      </remarks>        <short>    Default constructor.</short>
        public Attribute() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Attribute", "Attribute()", typeof(void));
        }
        /// <remarks>
        ///  Copy constructor.
        ///      </remarks>        <short>    Copy constructor.</short>
        public Attribute(KTextEditor.Attribute a) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Attribute#", "Attribute(const KTextEditor::Attribute&)", typeof(void), typeof(KTextEditor.Attribute), a);
        }
        /// <remarks>
        ///  Notify the editor implementation that a property of this attribute
        ///  has been changed.
        ///  This is used to re-render any text which has this attribute assigned
        ///  to it.
        ///      </remarks>        <short>    Notify the editor implementation that a property of this attribute  has been changed.</short>
        public void Changed() {
            interceptor.Invoke("changed", "changed() const", typeof(void));
        }
        /// <remarks>
        ///  \overload fontWeight()
        ///  Find out if the font weight is set to QFont.Bold.
        ///  \return \e true if the font weight is exactly QFont.Bold, otherwise \e false
        ///      </remarks>        <short>    \overload fontWeight() </short>
        public bool FontBold() {
            return (bool) interceptor.Invoke("fontBold", "fontBold() const", typeof(bool));
        }
        /// <remarks>
        ///  \overload setFontWeight()
        ///  Set the font weight to QFont.Bold.  If \a bold is <pre>false</pre>, the weight will be set to 0 (normal).
        ///  \param bold whether the font weight should be bold or not.
        ///      </remarks>        <short>    \overload setFontWeight() </short>
        public void SetFontBold(bool bold) {
            interceptor.Invoke("setFontBold$", "setFontBold(bool)", typeof(void), typeof(bool), bold);
        }
        public void SetFontBold() {
            interceptor.Invoke("setFontBold", "setFontBold()", typeof(void));
        }
        /// <remarks>
        ///  Get the brush used to draw an outline around text, if any.
        ///  \return brush to be used to draw an outline, or Qt.NoBrush if no outline is set.
        ///      </remarks>        <short>    Get the brush used to draw an outline around text, if any.</short>
        public QBrush Outline() {
            return (QBrush) interceptor.Invoke("outline", "outline() const", typeof(QBrush));
        }
        /// <remarks>
        ///  Set a brush to be used to draw an outline around text.
        ///  Use <pre>clearProperty</pre>(Outline) to clear.
        ///  \param brush brush to be used to draw an outline.
        ///      </remarks>        <short>    Set a brush to be used to draw an outline around text.</short>
        public void SetOutline(QBrush brush) {
            interceptor.Invoke("setOutline#", "setOutline(const QBrush&)", typeof(void), typeof(QBrush), brush);
        }
        /// <remarks>
        ///  Get the brush used to draw text when it is selected, if any.
        ///  \return brush to be used to draw selected text, or Qt.NoBrush if not set
        ///      </remarks>        <short>    Get the brush used to draw text when it is selected, if any.</short>
        public QBrush SelectedForeground() {
            return (QBrush) interceptor.Invoke("selectedForeground", "selectedForeground() const", typeof(QBrush));
        }
        /// <remarks>
        ///  Set a brush to be used to draw selected text.
        ///  Use <pre>clearProperty</pre>(SelectedForeground) to clear.
        ///  \param foreground brush to be used to draw selected text.
        ///      </remarks>        <short>    Set a brush to be used to draw selected text.</short>
        public void SetSelectedForeground(QBrush foreground) {
            interceptor.Invoke("setSelectedForeground#", "setSelectedForeground(const QBrush&)", typeof(void), typeof(QBrush), foreground);
        }
        /// <remarks>
        ///  Get the brush used to draw the background of selected text, if any.
        ///  \return brush to be used to draw the background of selected text, or Qt.NoBrush if not set
        ///      </remarks>        <short>    Get the brush used to draw the background of selected text, if any.</short>
        public QBrush SelectedBackground() {
            return (QBrush) interceptor.Invoke("selectedBackground", "selectedBackground() const", typeof(QBrush));
        }
        /// <remarks>
        ///  Set a brush to be used to draw the background of selected text, if any.
        ///  Use <pre>clearProperty</pre>(SelectedBackground) to clear.
        ///  \param brush brush to be used to draw the background of selected text
        ///      </remarks>        <short>    Set a brush to be used to draw the background of selected text, if any.</short>
        public void SetSelectedBackground(QBrush brush) {
            interceptor.Invoke("setSelectedBackground#", "setSelectedBackground(const QBrush&)", typeof(void), typeof(QBrush), brush);
        }
        /// <remarks>
        ///  Determine whether background color is drawn over whitespace. Defaults to true if not set.
        ///  \return whether the background color should be drawn over whitespace
        ///      </remarks>        <short>    Determine whether background color is drawn over whitespace.</short>
        public bool BackgroundFillWhitespace() {
            return (bool) interceptor.Invoke("backgroundFillWhitespace", "backgroundFillWhitespace() const", typeof(bool));
        }
        /// <remarks>
        ///  Set whether background color is drawn over whitespace. Defaults to true if not set.
        ///  Use <pre>clearProperty</pre>(BackgroundFillWhitespace) to clear.
        ///  \param fillWhitespace whether the background should be drawn over whitespace.
        ///      </remarks>        <short>    Set whether background color is drawn over whitespace.</short>
        public void SetBackgroundFillWhitespace(bool fillWhitespace) {
            interceptor.Invoke("setBackgroundFillWhitespace$", "setBackgroundFillWhitespace(bool)", typeof(void), typeof(bool), fillWhitespace);
        }
        /// <remarks>
        ///  Clear all set properties.
        ///      </remarks>        <short>    Clear all set properties.</short>
        public void Clear() {
            interceptor.Invoke("clear", "clear()", typeof(void));
        }
        /// <remarks>
        ///  Determine if any properties are set.
        ///  \return \e true if any properties are set, otherwise \e false
        ///      </remarks>        <short>    Determine if any properties are set.</short>
        public bool HasAnyProperty() {
            return (bool) interceptor.Invoke("hasAnyProperty", "hasAnyProperty() const", typeof(bool));
        }
        /// <remarks>
        ///  Associate an action with this attribute.  When assigned to a range, this attribute
        ///  will enable the associated action(s) when the caret enters the range, and
        ///  disable them on exit.  The action is also added to the context menu when
        ///  the caret is within an associated range.
        ///  \param action KAction to associate with this Attribute
        ///      </remarks>        <short>    Associate an action with this attribute.</short>
        public void AssociateAction(KAction action) {
            interceptor.Invoke("associateAction#", "associateAction(KAction*)", typeof(void), typeof(KAction), action);
        }
        /// <remarks>
        ///  Remove the association with an action from this attribute; it will no
        ///  longer be managed by associated ranges.
        ///  \param action KAction to dissociate from this Attribute
        ///      </remarks>        <short>    Remove the association with an action from this attribute; it will no  longer be managed by associated ranges.</short>
        public void DissociateAction(KAction action) {
            interceptor.Invoke("dissociateAction#", "dissociateAction(KAction*)", typeof(void), typeof(KAction), action);
        }
        /// <remarks>
        ///  Returns a list of currently associated KAction%s.
        ///      </remarks>        <short>    Returns a list of currently associated KAction%s.</short>
        public List<KAction> AssociatedActions() {
            return (List<KAction>) interceptor.Invoke("associatedActions", "associatedActions() const", typeof(List<KAction>));
        }
        /// <remarks>
        ///  Clears all associations between KAction%s and this attribute.
        ///      </remarks>        <short>    Clears all associations between KAction%s and this attribute.</short>
        public void ClearAssociatedActions() {
            interceptor.Invoke("clearAssociatedActions", "clearAssociatedActions()", typeof(void));
        }
        /// <remarks>
        ///  Return the attribute to use when the event referred to by \a type occurs.
        ///  \param type the activation type for which to return the Attribute.
        ///  \returns the attribute to be used for events specified by \a type, or null if none is set.
        ///      </remarks>        <short>    Return the attribute to use when the event referred to by \a type occurs.</short>
        public KTextEditor.Attribute DynamicAttribute(KTextEditor.Attribute.ActivationType type) {
            return (KTextEditor.Attribute) interceptor.Invoke("dynamicAttribute$", "dynamicAttribute(KTextEditor::Attribute::ActivationType) const", typeof(KTextEditor.Attribute), typeof(KTextEditor.Attribute.ActivationType), type);
        }
        /// <remarks>
        ///  Set the attribute to use when the event referred to by \a type occurs.
        ///  <b>Note:<> Nested dynamic attributes are ignored.
        ///  \param type the activation type to set the attribute for
        ///  \param attribute the attribute to assign. As attribute is refcounted, ownership is not an issue.
        ///      </remarks>        <short>    Set the attribute to use when the event referred to by \a type occurs.</short>
        public void SetDynamicAttribute(KTextEditor.Attribute.ActivationType type, KTextEditor.Attribute attribute) {
            interceptor.Invoke("setDynamicAttribute$?", "setDynamicAttribute(KTextEditor::Attribute::ActivationType, KSharedPtr<KTextEditor::Attribute>)", typeof(void), typeof(KTextEditor.Attribute.ActivationType), type, typeof(KTextEditor.Attribute), attribute);
        }
        public uint Effects() {
            return (uint) interceptor.Invoke("effects", "effects() const", typeof(uint));
        }
        public void SetEffects(uint effects) {
            interceptor.Invoke("setEffects$", "setEffects(KTextEditor::Attribute::Effects)", typeof(void), typeof(uint), effects);
        }
        ~Attribute() {
            interceptor.Invoke("~Attribute", "~Attribute()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Attribute", "~Attribute()", typeof(void));
        }
    }
}
