/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import virtuoso.jdbc4.ConnectionWrapper;
import virtuoso.jdbc4.ParameterMetaDataWrapper;
import virtuoso.jdbc4.ResultSetMetaDataWrapper;
import virtuoso.jdbc4.ResultSetWrapper;
import virtuoso.jdbc4.StatementWrapper;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement,
Cloneable {
    protected String stmtKey;
    protected int hashStmtKey;

    protected PreparedStatementWrapper(ConnectionWrapper connectionWrapper, PreparedStatement preparedStatement, String string) {
        super(connectionWrapper, preparedStatement);
        this.stmtKey = string;
        this.hashStmtKey = this.stmtKey.hashCode();
    }

    @Override
    protected void addLink() {
        if (this.wconn != null) {
            this.wconn.pStmtPool.addToUsed(this);
        }
    }

    @Override
    protected void removeLink() {
        try {
            if (this.wconn != null) {
                this.wconn.pStmtPool.reuse(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void closeAll() {
        this.wconn = null;
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized Object clone() {
        try {
            PreparedStatementWrapper preparedStatementWrapper = (PreparedStatementWrapper)super.clone();
            preparedStatementWrapper.isClosed = false;
            return preparedStatementWrapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    protected PreparedStatementWrapper reuse() throws SQLException {
        this.reset();
        PreparedStatementWrapper preparedStatementWrapper = (PreparedStatementWrapper)this.clone();
        this.stmt = null;
        this.objsToClose = null;
        return preparedStatementWrapper;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = ((PreparedStatement)this.stmt).executeQuery();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, this, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.check_close();
        try {
            return ((PreparedStatement)this.stmt).executeUpdate();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setString(n, string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).clearParameters();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.check_close();
        try {
            return ((PreparedStatement)this.stmt).execute();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).addBatch();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.check_close();
        try {
            return ((PreparedStatement)this.stmt).executeBatch();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.check_close();
        try {
            ResultSetMetaData resultSetMetaData = ((PreparedStatement)this.stmt).getMetaData();
            if (resultSetMetaData != null) {
                return new ResultSetMetaDataWrapper(resultSetMetaData, this.wconn);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.check_close();
        try {
            ParameterMetaData parameterMetaData = ((PreparedStatement)this.stmt).getParameterMetaData();
            if (parameterMetaData != null) {
                return new ParameterMetaDataWrapper(parameterMetaData, this.wconn);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNString(n, string);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.check_close();
        try {
            ((PreparedStatement)this.stmt).setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }
}

