/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRectElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGRectElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGRectElement);

/* Hash table */

static const HashTableValue JSSVGRectElementTableValues[18] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementHeight, (intptr_t)0 },
    { "rx", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRx, (intptr_t)0 },
    { "ry", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRy, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGRectElementXmllang, (intptr_t)setJSSVGRectElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGRectElementXmlspace, (intptr_t)setJSSVGRectElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGRectElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSSVGRectElementTableValues, 0 };
#else
    { 69, 63, JSSVGRectElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGRectElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGRectElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGRectElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGRectElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGRectElementPrototype::s_info = { "SVGRectElementPrototype", 0, &JSSVGRectElementPrototypeTable, 0 };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRectElement>(exec, globalObject);
}

bool JSSVGRectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGRectElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGRectElement::s_info = { "SVGRectElement", &JSSVGElement::s_info, &JSSVGRectElementTable, 0 };

JSSVGRectElement::JSSVGRectElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGRectElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGRectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGRectElementPrototype(JSSVGRectElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGRectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, this, propertyName, slot);
}

bool JSSVGRectElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, this, propertyName, descriptor);
}

JSValue jsSVGRectElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementRx(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementRy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGRectElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGRectElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGRectElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGRectElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGRectElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGRectElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGRectElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
}

JSValue jsSVGRectElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGRectElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGRectElement, Base>(exec, propertyName, value, &JSSVGRectElementTable, this, slot);
}

void setJSSVGRectElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGRectElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
