//  (C) Copyright John Maddock 2006.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 7>, 500> ibeta_small_data = { {
      { SC_(0.011510574258863925933837890625), SC_(2.726669788360595703125), SC_(0.913345992565155029296875), SC_(85.50804647765112454526520766832090120908), SC_(0.0004969774007283958673037601318581948437309), SC_(0.9999941879795790272650838125485136788379), SC_(0.5812020420972734916187451486321162137375e-5) }, 
      { SC_(0.0463422574102878570556640625), SC_(0.34317314624786376953125), SC_(0.24176712334156036376953125), SC_(20.36367089471426800179696837574809289039), SC_(3.630773740238788693031723031598949317136), SC_(0.8486827348798151491124959025982318049325), SC_(0.1513172651201848508875040974017681950675) }, 
      { SC_(0.06715317070484161376953125), SC_(2.30631923675537109375), SC_(0.908442795276641845703125), SC_(13.78727207173260438424514878253152024011), SC_(0.001859217475218142037637565734833320618317), SC_(0.9998651679038930266805148691555636600556), SC_(0.0001348320961069733194851308444363399443688) }, 
      { SC_(0.1190207004547119140625), SC_(7.26954746246337890625), SC_(0.19963125884532928466796875), SC_(6.225047194692518378537141946282961080975), SC_(0.08420413075357450486624447742592649170405), SC_(0.9866538632858121421788318729611834919717), SC_(0.01334613671418785782116812703881650802825) }, 
      { SC_(0.1540344059467315673828125), SC_(4.049813747406005859375), SC_(0.3462987840175628662109375), SC_(4.872033861103043731550905432482222659763), SC_(0.08561968850485947325255754361164029251743), SC_(0.9827297959310547093553196782752749843992), SC_(0.01727020406894529064468032172472501560077) }, 
      { SC_(0.15487124025821685791015625), SC_(8.16117000579833984375), SC_(0.678767263889312744140625), SC_(4.38038087876606402301557100951561214911), SC_(0.1540537895441550779731794373253219559374e-4), SC_(0.999996483108386751271915947803000461492), SC_(0.3516891613248728084052196999538507955892e-5) }, 
      { SC_(0.2251259386539459228515625), SC_(0.4898320138454437255859375), SC_(0.79967319965362548828125), SC_(4.764013990849157580013322088552892632018), SC_(0.9820281524501242644370508756885101403883), SC_(0.8290948573018540323461920074910160298235), SC_(0.1709051426981459676538079925089839701765) }, 
      { SC_(0.2867415249347686767578125), SC_(5.96057987213134765625), SC_(0.575251102447509765625), SC_(1.911839728052784613470170990261300207059), SC_(0.001412230939458232329324385634994224021816), SC_(0.9992618688130328170087283879882410324961), SC_(0.0007381311869671829912716120117589675039269) }, 
      { SC_(0.2922028005123138427734375), SC_(2.659206867218017578125), SC_(0.4733414947986602783203125), SC_(2.306780982820498015018593188560459962841), SC_(0.09785807660771959252183084474688989446611), SC_(0.9593044635018992897241131636398162350677), SC_(0.04069553649810071027588683636018376493234) }, 
      { SC_(0.30540943145751953125), SC_(4.23978328704833984375), SC_(0.546926796436309814453125), SC_(1.925766552541500211935789109529683925689), SC_(0.01136621113828240461645649770280082638802), SC_(0.9941324563027414190664847981329029657831), SC_(0.005867543697258580933515201867097034216903) }, 
      { SC_(0.318328440189361572265625), SC_(3.1655042171478271484375), SC_(0.077649272978305816650390625), SC_(1.337499870967964297403057650377070193563), SC_(0.6794195418585711764434318012650276929832), SC_(0.6631399660602084538462156083737590843824), SC_(0.3368600339397915461537843916262409156176) }, 
      { SC_(0.326008260250091552734375), SC_(0.625432431697845458984375), SC_(0.743158161640167236328125), SC_(3.078454179457483361692247221422692039972), SC_(0.7360974885092882497469458885357603771633), SC_(0.8070290947450602569822924525981547293294), SC_(0.1929709052549397430177075474018452706706) }, 
      { SC_(0.3360383510589599609375), SC_(5.28920650482177734375), SC_(0.81474220752716064453125), SC_(1.550409503660757234080944256429985207784), SC_(0.2836427788609597588510100729645041742761e-4), SC_(0.9999817056339550018928818220116909157891), SC_(0.1829436604499810711817798830908421094105e-4) }, 
      { SC_(0.344460785388946533203125), SC_(6.63605499267578125), SC_(0.096544884145259857177734375), SC_(1.138099220831291561221229605806786314538), SC_(0.2341007981779031558780678617792900307434), SC_(0.8293974676177770014617748040947131716032), SC_(0.1706025323822229985382251959052868283968) }, 
      { SC_(0.3571167886257171630859375), SC_(3.6129398345947265625), SC_(0.046266771852970123291015625), SC_(0.9053135817270937856051949826437502245961), SC_(0.7221758562362922538389449085733137575244), SC_(0.5562638752728180895224241888333329380732), SC_(0.4437361247271819104775758111666670619268) }, 
      { SC_(0.357627332210540771484375), SC_(8.064510345458984375), SC_(0.92886126041412353515625), SC_(1.197177044295353240338824861021333896969), SC_(0.7152754878374974083055684082879234042397e-10), SC_(0.9999999999402531571079558956505173243843), SC_(0.597468428920441043494826756157346017527e-10) }, 
      { SC_(0.377388656139373779296875), SC_(8.8396854400634765625), SC_(0.50323975086212158203125), SC_(1.048244561726343473675201855489355128708), SC_(0.0003378999437661089518583588179790252882915), SC_(0.999677755487891791262427317664954237941), SC_(0.0003222445121082087375726823350457620590389) }, 
      { SC_(0.424311339855194091796875), SC_(8.71805095672607421875), SC_(0.594544112682342529296875), SC_(0.8450634150576302527396320143587314116559), SC_(0.5692485563137910015348490929019764830298e-4), SC_(0.9999326428995458545641785392037209582211), SC_(0.6735710045414543582146079627904177891161e-4) }, 
      { SC_(0.4302380084991455078125), SC_(9.08433628082275390625), SC_(0.3500487506389617919921875), SC_(0.8041671576172428143402874467426430937693), SC_(0.003657242502533209987243300892131746946366), SC_(0.995472725877070621917637160657188675184), SC_(0.004527274122929378082362839342811324816028) }, 
      { SC_(0.4617138803005218505859375), SC_(1.49113976955413818359375), SC_(0.081217654049396514892578125), SC_(0.6708426431384324314892486199862307536228), SC_(1.06148098502757264044386168615001572695), SC_(0.3872501836441769856742304061740122471689), SC_(0.6127498163558230143257695938259877528311) }, 
      { SC_(0.4965442717075347900390625), SC_(8.234554290771484375), SC_(0.3013162314891815185546875), SC_(0.6255445999459755311064947246119255484269), SC_(0.01047121638037352884799746710410909796172), SC_(0.9835362327294694289867309219284499434766), SC_(0.01646376727053057101326907807155005652337) }, 
      { SC_(0.526769936084747314453125), SC_(9.4657726287841796875), SC_(0.695263326168060302734375), SC_(0.5223867123087661970619213259031225900887), SC_(0.1604184643861934563272584858102025314868e-5), SC_(0.9999969291337627338160603638685334704082), SC_(0.3070866237266183939636131466529591820232e-5) }, 
      { SC_(0.539501190185546875), SC_(3.5276241302490234375), SC_(0.184897840023040771484375), SC_(0.6337086405553985369329386662133114583969), SC_(0.2298885748176341425212030686754049306522), SC_(0.7338011624802040649313396945278096189402), SC_(0.2661988375197959350686603054721903810598) }, 
      { SC_(0.596188604831695556640625), SC_(9.52472019195556640625), SC_(0.587086021900177001953125), SC_(0.3957027656575689988900171488472459553927), SC_(0.2784518837222712883966491998692226153708e-4), SC_(0.9999296360008322244237915105214427770265), SC_(0.7036399916777557620848947855722297349452e-4) }, 
      { SC_(0.597795426845550537109375), SC_(4.3524570465087890625), SC_(0.3404516875743865966796875), SC_(0.5857283108172326731547619033650850279516), SC_(0.05176933170314495414753269319008084049281), SC_(0.9187929048671107105645293523464974421304), SC_(0.08120709513288928943547064765350255786955) }, 
      { SC_(0.604711830615997314453125), SC_(2.7766406536102294921875), SC_(0.65411365032196044921875), SC_(0.8104703643388840470345296228912560465778), SC_(0.02126375318260348616345995572262831556693), SC_(0.9744344343526894636219031995625457203905), SC_(0.02556556564731053637809680043745427960951) }, 
      { SC_(0.679927647113800048828125), SC_(9.0447483062744140625), SC_(0.887737333774566650390625), SC_(0.3013615312130418242114530511558325766293), SC_(0.2937963547130558679504530467684762405074e-9), SC_(0.999999999025103326081320534896178383616), SC_(0.9748966739186794651038216163839749164796e-9) }, 
      { SC_(0.688061058521270751953125), SC_(2.9616763591766357421875), SC_(0.815787494182586669921875), SC_(0.6441996486596996003790817490051121624011), SC_(0.0023593844359375506996753278475536050391), SC_(0.9963508599908640401822148000540199843775), SC_(0.003649140009135959817785199945980015622505) }, 
      { SC_(0.71445453166961669921875), SC_(9.34602642059326171875), SC_(0.5949366092681884765625), SC_(0.2611868075149835081076007360078062823636), SC_(0.2618210260815823472350439860777132136683e-4), SC_(0.9998997672257934489288388082946320821168), SC_(0.0001002327742065510711611917053679178831703) }, 
      { SC_(0.75854289531707763671875), SC_(4.042085170745849609375), SC_(0.18398940563201904296875), SC_(0.2869641794222026502350604842071731344923), SC_(0.1433368221355461874324336015227538920014), SC_(0.6668917301687721681209003462437186369765), SC_(0.3331082698312278318790996537562813630235) }, 
      { SC_(0.759666860103607177734375), SC_(7.62421321868896484375), SC_(0.285910427570343017578125), SC_(0.2494067464807902016116972999567207456019), SC_(0.01285822954049965889923791220383840028034), SC_(0.9509723725387721326945071222846981919121), SC_(0.04902762746122786730549287771530180808794) }, 
      { SC_(0.78175532817840576171875), SC_(8.5445098876953125), SC_(0.2395785152912139892578125), SC_(0.2092181979177349561806385620026173078435), SC_(0.01454489283267034607676299413579126814072), SC_(0.9349986953438432477441465286773755595707), SC_(0.06500130465615675225585347132262444042931) }, 
      { SC_(0.811257660388946533203125), SC_(3.7941887378692626953125), SC_(0.379480898380279541015625), SC_(0.3489982897256404699956459179424488728876), SC_(0.04918171477157487449577833255024935191165), SC_(0.876483715364670390428440227316937452589), SC_(0.123516284635329609571559772683062547411) }, 
      { SC_(0.834698200225830078125), SC_(9.0694408416748046875), SC_(0.644353687763214111328125), SC_(0.1803151611837914682987734789219117172738), SC_(0.9959010328687650223890520801118033780347e-5), SC_(0.9999447719190872199805310662295119611992), SC_(0.5522808091278001946893377048803880084592e-4) }, 
      { SC_(0.83821380138397216796875), SC_(9.12577533721923828125), SC_(0.22599919140338897705078125), SC_(0.1645323980962702319386216945486588491031), SC_(0.01289064037523516697593443936007900173636), SC_(0.9273451718204823928666892977505184246911), SC_(0.07265482817951760713331070224948157530893) }, 
      { SC_(0.84435856342315673828125), SC_(3.462334156036376953125), SC_(0.2511587440967559814453125), SC_(0.2764659412617420491570801392360458860717), SC_(0.1225038182191884368747109382285656512776), SC_(0.6929496150821833440766199995023216044932), SC_(0.3070503849178166559233800004976783955068) }, 
      { SC_(0.8551578521728515625), SC_(9.93534755706787109375), SC_(0.47097623348236083984375), SC_(0.156230204191103226500775887222958181338), SC_(0.0001981074086433488391675923367618586808585), SC_(0.9987335578411774548179603749802068600465), SC_(0.001266442158822545182039625019793139953536) }, 
      { SC_(0.908232867717742919921875), SC_(0.678848326206207275390625), SC_(0.84073317050933837890625), SC_(1.160861004416774987619512191580855025408), SC_(0.4258943431472485997275346962213866620687), SC_(0.7315941970505542617319292810425302688679), SC_(0.2684058029494457382680707189574697311321) }, 
      { SC_(0.9111347198486328125), SC_(0.862172305583953857421875), SC_(0.95751106739044189453125), SC_(1.185899552667666342813996371641383797478), SC_(0.07629806988531935777484778370164513501807), SC_(0.9395514073850060300319313133177312277542), SC_(0.06044859261499396996806868668226877224576) }, 
      { SC_(0.942293345928192138671875), SC_(7.764537811279296875), SC_(0.808194696903228759765625), SC_(0.1508102710294228670066826109456423951132), SC_(0.3518058068135974193879013653354450359381e-6), SC_(0.9999976672345740659931913764741265832628), SC_(0.2332765425934006808623525873416737195291e-5) }, 
      { SC_(0.96454536914825439453125), SC_(2.23419952392578125), SC_(0.3250310420989990234375), SC_(0.2834732098610328524396528653108034866255), SC_(0.190436076037379824356986932760536605902), SC_(0.5981592222309782861598154404834535951026), SC_(0.4018407777690217138401845595165464048974) }, 
      { SC_(0.96730029582977294921875), SC_(2.896893978118896484375), SC_(0.602882802486419677734375), SC_(0.3423822991371558430034363809431602080871), SC_(0.02405649095246888986382317565418043208486), SC_(0.9343505884118188500531298388527642525024), SC_(0.06564941158818114994687016114723574749757) }, 
      { SC_(0.971317768096923828125), SC_(9.940685272216796875), SC_(0.0839129984378814697265625), SC_(0.06504707109648754329244702454735921458691), SC_(0.04441883725199691091650283777368267306258), SC_(0.5942221836721104979700277018504213130339), SC_(0.4057778163278895020299722981495786869661) }, 
      { SC_(0.975403964519500732421875), SC_(5.472205638885498046875), SC_(0.01363777182996273040771484375), SC_(0.01507880323004283665619215274236779141942), SC_(0.1786982587181325975438620221056624556374), SC_(0.07781521238089354585457864638797415249968), SC_(0.9221847876191064541454213536120258475003) }, 
      { SC_(0.987122833728790283203125), SC_(7.66854095458984375), SC_(0.5060064792633056640625), SC_(0.1344070858100725893412090975881710295211), SC_(0.0005885866608641503352046318734400675414602), SC_(0.9956399590439399652567966381947768119441), SC_(0.004360040956060034743203361805223188055887) }, 
      { SC_(1.056292057037353515625), SC_(6.812713623046875), SC_(0.82583439350128173828125), SC_(0.1273249881224593174456085109406883283434), SC_(0.9807107058749212025388445092701407127597e-6), SC_(0.9999922976379849114418469705444366389974), SC_(0.7702362015088558153029455563361002570531e-5) }, 
      { SC_(1.06216347217559814453125), SC_(4.927896022796630859375), SC_(0.6798517704010009765625), SC_(0.1759733200157519723090855217275085438428), SC_(0.0007267069978173745862790504472453784438198), SC_(0.9958873407655927042588117240610652033503), SC_(0.004112659234407295741188275938934796649655) }, 
      { SC_(1.06652772426605224609375), SC_(4.98544216156005859375), SC_(0.2400285303592681884765625), SC_(0.1252391805582437348633070224949739746442), SC_(0.04764650371569540044683293003295292656369), SC_(0.7244045745268357332739928141189512595386), SC_(0.2755954254731642667260071858810487404614) }, 
      { SC_(1.0676186084747314453125), SC_(5.01974391937255859375), SC_(0.52858030796051025390625), SC_(0.1668068455926113267781850863056374191068), SC_(0.004416624961366326396236713719703100132342), SC_(0.9742054932826863858080468818188426955095), SC_(0.02579450671731361419195311818115730449051) }, 
      { SC_(1.07769012451171875), SC_(3.7481257915496826171875), SC_(0.79485189914703369140625), SC_(0.2281820698359616001756803065117048698312), SC_(0.0006946101723822465464098854082125524812235), SC_(0.9969651334842985135690500741329898736386), SC_(0.003034866515701486430949925867010126361423) }, 
      { SC_(1.111192226409912109375), SC_(7.073215484619140625), SC_(0.4427340030670166015625), SC_(0.1046968991557454481312637878403829272066), SC_(0.002096999016419663891877647532306680630051), SC_(0.9803640558841757103622473467279519746618), SC_(0.0196359441158242896377526532720480253382) }, 
      { SC_(1.11202752590179443359375), SC_(1.6287212371826171875), SC_(0.3125767409801483154296875), SC_(0.220086487142446497373642338798966428899), SC_(0.3118964792364739989196755511537386999812), SC_(0.4137096505937436937582806779155007896774), SC_(0.5862903494062563062417193220844992103226) }, 
      { SC_(1.17417657375335693359375), SC_(3.249635219573974609375), SC_(0.4580433666706085205078125), SC_(0.1869937983311457206778828953905356137432), SC_(0.03822122339653544808212099322227995529118), SC_(0.8302900796610687219671714278868655607164), SC_(0.1697099203389312780328285721131344392836) }, 
      { SC_(1.18997681140899658203125), SC_(4.56032848358154296875), SC_(0.12527024745941162109375), SC_(0.05555200964120607625418119326261288194569), SC_(0.09228270880340905015103067984913154599131), SC_(0.3757710653199377466092636271155968947165), SC_(0.6242289346800622533907363728844031052835) }, 
      { SC_(1.19396245479583740234375), SC_(1.11079370975494384765625), SC_(0.97992765903472900390625), SC_(0.7328225851446332702348997680527066247573), SC_(0.0116951961415409062229029366185122042514), SC_(0.9842915825041315396299884467742185229104), SC_(0.01570841749586846037001155322578147708963) }, 
      { SC_(1.206116199493408203125), SC_(7.07159709930419921875), SC_(0.76554024219512939453125), SC_(0.08514084012066408850849087391686636969038), SC_(0.4734137820898855125073110752727038395695e-5), SC_(0.9999443994845048909226930655462551207409), SC_(0.5560051549510907730693445374487925914636e-4) }, 
      { SC_(1.2331893444061279296875), SC_(2.529559612274169921875), SC_(0.2963911592960357666015625), SC_(0.1382405154740039729873240314162563958491), SC_(0.1368890069023594204450209190811258786034), SC_(0.5024561314975783597879652382184428890429), SC_(0.4975438685024216402120347617815571109571) }, 
      { SC_(1.2698681354522705078125), SC_(9.68867778778076171875), SC_(0.0048830057494342327117919921875), SC_(0.0008930645663219436259375029549427392107573), SC_(0.0487150324805827097640187868435164513456), SC_(0.01800239516298211400104303995525449332312), SC_(0.9819976048370178859989569600447455066769) }, 
      { SC_(1.2801439762115478515625), SC_(8.8172550201416015625), SC_(0.731749236583709716796875), SC_(0.05442873325213669923239713181090416341988), SC_(0.9602487242698262216547978489257610558994e-6), SC_(0.9999823579986858710309586582398411826723), SC_(0.1764200131412896904134176015881732771565e-4) }, 
      { SC_(1.2990620136260986328125), SC_(1.5443842411041259765625), SC_(0.1945759356021881103515625), SC_(0.08612429254157958319406624556530210771471), SC_(0.3723309647381705279199457097687991375742), SC_(0.1878575742649329156233069646006092390117), SC_(0.8121424257350670843766930353993907609883) }, 
      { SC_(1.3197329044342041015625), SC_(4.903014659881591796875), SC_(0.3325150310993194580078125), SC_(0.08377044198614509980249471998638733724805), SC_(0.02160479444130212505727929870781375087409), SC_(0.7949727547593459429261215463860200453147), SC_(0.2050272452406540570738784536139799546853) }, 
      { SC_(1.3317101001739501953125), SC_(0.76503980159759521484375), SC_(0.644586086273193359375), SC_(0.4714479913648758636806160397928378378945), SC_(0.5594135526519237359231008536763548833904), SC_(0.4573339592510716805631615045309103737982), SC_(0.5426660407489283194368384954690896262018) }, 
      { SC_(1.3606855869293212890625), SC_(8.021114349365234375), SC_(0.2625559866428375244140625), SC_(0.04350323940002429317527227412108086401286), SC_(0.007341099233094427676263507625510870409001), SC_(0.8556161918819291979201905701673750189882), SC_(0.1443838081180708020798094298326249810118) }, 
      { SC_(1.36553132534027099609375), SC_(8.47109699249267578125), SC_(0.513298213481903076171875), SC_(0.04653027405530776618082713028079532619046), SC_(0.0002146805681266171440572997059318298984956), SC_(0.9954074066419353726177520982380355211169), SC_(0.004592593358064627382247901761964478883115) }, 
      { SC_(1.3862445354461669921875), SC_(7.617311954498291015625), SC_(0.1419721543788909912109375), SC_(0.02815216256571207514729830838921778816916), SC_(0.0232965505412737702410472186055010619599), SC_(0.5471888579053593157366281752785095354745), SC_(0.4528111420946406842633718247214904645255) }, 
      { SC_(1.41886341571807861328125), SC_(0.0478348396718502044677734375), SC_(0.035808108747005462646484375), SC_(0.006385177295013314977813904391150944527719), SC_(20.38502744980592013209006044838022953662), SC_(0.0003131306992693179449805401756033695664675), SC_(0.9996868693007306820550194598243966304335) }, 
      { SC_(1.4495480060577392578125), SC_(6.80287075042724609375), SC_(0.2728257477283477783203125), SC_(0.04187355433425784530323106377350995243025), SC_(0.01065109583367346217044837056635847338681), SC_(0.7972171961237270351667809026964387766247), SC_(0.2027828038762729648332190973035612233753) }, 
      { SC_(1.45538985729217529296875), SC_(2.826733112335205078125), SC_(0.262285530567169189453125), SC_(0.07232058763326474392191561398326810563023), SC_(0.1033248666967808362840677124824034278074), SC_(0.4117418689206221067293489816223537385391), SC_(0.5882581310793778932706510183776462614609) }, 
      { SC_(1.49294006824493408203125), SC_(2.3015606403350830078125), SC_(0.1450403034687042236328125), SC_(0.03333458104843787972518598613540475659445), SC_(0.1885428279185112804119711040348267326268), SC_(0.1502387340993485103618628891402245148079), SC_(0.8497612659006514896381371108597754851921) }, 
      { SC_(1.49865448474884033203125), SC_(1.95107400417327880859375), SC_(0.622092902660369873046875), SC_(0.2097910160492195599895120138889891219984), SC_(0.06639747044671675317657978901845091118846), SC_(0.7595936337205219111767086073336295525451), SC_(0.2404063662794780888232913926663704474549) }, 
      { SC_(1.52378022670745849609375), SC_(5.0319004058837890625), SC_(0.2302330434322357177734375), SC_(0.03944697844936922101076279620193394427818), SC_(0.03077530768376556951978932836749402274838), SC_(0.5617444350157084507793309583166417746211), SC_(0.4382555649842915492206690416833582253789) }, 
      { SC_(1.5272119045257568359375), SC_(5.402520656585693359375), SC_(0.93401730060577392578125), SC_(0.06292799976574904503574315046515802626382), SC_(0.7520189348487403543193828926006356662266e-7), SC_(0.9999988049548071581297454946461948144423), SC_(0.1195045192841870254505353805185557658584e-5) }, 
      { SC_(1.536567211151123046875), SC_(5.270428180694580078125), SC_(0.848482906818389892578125), SC_(0.06416111972175887791075879414924363756558), SC_(0.8453999274000799820481114978549430163278e-5), SC_(0.9998682553306220603711336554634655860262), SC_(0.0001317446693779396288663445365344139738098) }, 
      { SC_(1.5640494823455810546875), SC_(3.357979297637939453125), SC_(0.757224500179290771484375), SC_(0.1165334744710663931921022639371476757104), SC_(0.002283311766235317659937887474997012830956), SC_(0.9807829193286286035456321573422049721223), SC_(0.01921708067137139645436784265779502787774) }, 
      { SC_(1.57613086700439453125), SC_(7.25838947296142578125), SC_(0.02931735850870609283447265625), SC_(0.002175832563436668262503742006836792009797), SC_(0.03473959762182573632923311429644612349176), SC_(0.0589410052251081974514741138762064373162), SC_(0.9410589947748918025485258861237935626838) }, 
      { SC_(1.61484754085540771484375), SC_(4.881840229034423828125), SC_(0.801034510135650634765625), SC_(0.06286912265537787014466760187902705453397), SC_(0.6916835856354903326087903310255709631148e-4), SC_(0.9989010130804437064243723367522201778165), SC_(0.001098986919556293575627663247779822183549) }, 
      { SC_(1.62182295322418212890625), SC_(9.27492809295654296875), SC_(0.2078215181827545166015625), SC_(0.01729959995949158252186804671703892754059), SC_(0.005655299730024484267354449657801376771362), SC_(0.7536343087307253309388864098822535694515), SC_(0.2463656912692746690611135901177464305485) }, 
      { SC_(1.62611734867095947265625), SC_(6.439609527587890625), SC_(0.12340660393238067626953125), SC_(0.01347775221452777563026524001918629280781), SC_(0.02678423825261055703945294116256349202236), SC_(0.3347512643600733132669432669978196722756), SC_(0.6652487356399266867330567330021803277244) }, 
      { SC_(1.6564872264862060546875), SC_(1.19547176361083984375), SC_(0.2120031416416168212890625), SC_(0.04495109930684485694092120684406707050249), SC_(0.4278285627404570747669200296255427214368), SC_(0.09507832699949658242764093757178886586108), SC_(0.9049216730005034175723590624282111341389) }, 
      { SC_(1.6716840267181396484375), SC_(1.7211780548095703125), SC_(0.679734706878662109375), SC_(0.2085503334381458289511405610582403910942), SC_(0.07023616746131068843926100688690333052689), SC_(0.7480646758910283704247396809228029270409), SC_(0.2519353241089716295752603190771970729591) }, 
      { SC_(1.6792714595794677734375), SC_(9.62997531890869140625), SC_(0.57974660396575927734375), SC_(0.01904093620424363737349206735274579142167), SC_(0.1775327579500677501722344807657484477681e-4), SC_(0.999068494409670670715138094223313796706), SC_(0.0009315055903293292848619057766862032940245) }, 
      { SC_(1.68990039825439453125), SC_(8.0913715362548828125), SC_(0.35079205036163330078125), SC_(0.0226645038568415316808113621350425402819), SC_(0.002063289976923312081215239992056262871864), SC_(0.9165598843635630117044444052531000073656), SC_(0.08344011563643698829555559474689999263438) }, 
      { SC_(1.70708048343658447265625), SC_(2.395024776458740234375), SC_(0.4302643835544586181640625), SC_(0.08980982864608822287125309866743205173528), SC_(0.07512991845489259258305942961070344815958), SC_(0.5445008266631091981683775360195067301959), SC_(0.4554991733368908018316224639804932698041) }, 
      { SC_(1.71121060848236083984375), SC_(7.39297580718994140625), SC_(0.74067318439483642578125), SC_(0.02745961434730233864091228915779711798502), SC_(0.521932550899130264941753340104365418125e-5), SC_(0.9998099633308845359240379298808498667044), SC_(0.000190036669115464075962070119150133295605) }, 
      { SC_(1.71186673641204833984375), SC_(3.019131183624267578125), SC_(0.075946711003780364990234375), SC_(0.006415168420450487439488225205616221210345), SC_(0.1085093328343223297856917522112878608521), SC_(0.05582072012850319282927455370962255476197), SC_(0.944179279871496807170725446290377445238) }, 
      { SC_(1.73388612270355224609375), SC_(7.13903903961181640625), SC_(0.64634835720062255859375), SC_(0.02779209557143454660932449320582002039229), SC_(0.6384659511433801914272585076289501120182e-4), SC_(0.9977079721542856695385991411307131189941), SC_(0.002292027845714330461400858869286881005873) }, 
      { SC_(1.7587440013885498046875), SC_(4.86371135711669921875), SC_(0.92927074432373046875), SC_(0.05025191840214798474124953026366617205682), SC_(0.4987552472712844347736408922558307205113e-6), SC_(0.999990074999861018893940091331229481378), SC_(0.9925000138981106059908668770518622038381e-5) }, 
      { SC_(1.7813246250152587890625), SC_(3.126769542694091796875), SC_(0.730357825756072998046875), SC_(0.09545821128378472160497353516621871629293), SC_(0.004440290020519288406957293282559364396215), SC_(0.9555519856399689180508128977174066161112), SC_(0.04444801436003108194918710228259338388884) }, 
      { SC_(1.78766191005706787109375), SC_(4.2912654876708984375), SC_(0.802131235599517822265625), SC_(0.05894209199151744466815827080858829517), SC_(0.0001941328291968485680136018217849712475069), SC_(0.9967171927226432023534820892453162354078), SC_(0.003282807277356797646517910754683764592234) }, 
      { SC_(1.8184702396392822265625), SC_(9.82360553741455078125), SC_(0.2583700716495513916015625), SC_(0.01150542763210423380031442787839814236668), SC_(0.002157585461743354603071510579258404082646), SC_(0.8420856770813673219220170443209588103815), SC_(0.1579143229186326780779829556790411896185) }, 
      { SC_(1.82922458648681640625), SC_(2.45019245147705078125), SC_(0.567864835262298583984375), SC_(0.1015574002095356972230631741834666798307), SC_(0.038499201818446849634633242147509717005), SC_(0.7251168366147072550366996049010239306432), SC_(0.2748831633852927449633003950989760693568) }, 
      { SC_(1.8351116180419921875), SC_(3.857105255126953125), SC_(0.368547737598419189453125), SC_(0.04155951745596927946215901707287771729026), SC_(0.02454273931015210370518643775523748349486), SC_(0.6287155611496352580669363490252911738482), SC_(0.3712844388503647419330636509747088261518) }, 
      { SC_(1.83907794952392578125), SC_(5.047709941864013671875), SC_(0.296746194362640380859375), SC_(0.02579169304403219804746995259767624043878), SC_(0.0159002711761807336423937515085986731722), SC_(0.6186250402548309865228146225679030871793), SC_(0.3813749597451690134771853774320969128207) }, 
      { SC_(1.84816324710845947265625), SC_(5.843822479248046875), SC_(0.43872296810150146484375), SC_(0.02857508051036345809288545530305301162369), SC_(0.00336274723249159424945139991989809357113), SC_(0.8947095820177097431183829291878943644054), SC_(0.1052904179822902568816170708121056355946) }, 
      { SC_(1.8687260150909423828125), SC_(4.08731174468994140625), SC_(0.1081511080265045166015625), SC_(0.006706342628693429961771802325800518408771), SC_(0.05056579168641678576595382294827721958649), SC_(0.1170960836171262239382831369798635517739), SC_(0.8829039163828737760617168630201364482261) }, 
      { SC_(1.8866198062896728515625), SC_(8.84942626953125), SC_(0.95613896846771240234375), SC_(0.01430607123942810598918544544219325051127), SC_(0.1049011090946787241087043402801168037132e-12), SC_(0.99999999999266737126229332200080945968), SC_(0.7332628737706677999190540319984210356766e-11) }, 
      { SC_(1.8895499706268310546875), SC_(8.118740081787109375), SC_(0.361357867717742919921875), SC_(0.01508190132054844229537957185306981540468), SC_(0.00152836136276176340065976004671286775027), SC_(0.9079869239938364904681894159382946476945), SC_(0.09201307600616350953181058406170535230548) }, 
      { SC_(1.90433275699615478515625), SC_(4.56510448455810546875), SC_(0.751291930675506591796875), SC_(0.04471181800599787865845203148864731643557), SC_(0.000310565931308944037699355534374688189697), SC_(0.993101966085549718980986260141770170934), SC_(0.006898033914450281019013739858229829066022) }, 
      { SC_(1.909236907958984375), SC_(5.959809780120849609375), SC_(0.76244509220123291015625), SC_(0.02787899558703375276148176622369828569901), SC_(0.2597816441771601802888334328943164404273e-4), SC_(0.999069048957038894485440165620053720275), SC_(0.0009309510429611055145598343799462797249997) }, 
      { SC_(1.91745245456695556640625), SC_(5.4286212921142578125), SC_(0.942056357860565185546875), SC_(0.03252496420742097323876038760702826888359), SC_(0.3389589872121281319769403390228950032624e-7), SC_(0.9999989578508624800443420116036908883539), SC_(0.104214913751995565798839630911164608131e-5) }, 
      { SC_(1.94764292240142822265625), SC_(4.412234783172607421875), SC_(0.4232228100299835205078125), SC_(0.03404294731016211601916587129163631194493), SC_(0.01094253526676329062034068220776034644763), SC_(0.7567540762055514460904069602101669619769), SC_(0.2432459237944485539095930397898330380231) }, 
      { SC_(1.96595251560211181640625), SC_(8.4846782684326171875), SC_(0.15814177691936492919921875), SC_(0.006178826720288681314639338500283954981263), SC_(0.007072511346663628976181676855625587905717), SC_(0.4662794571438895014002411553158874055633), SC_(0.5337205428561104985997588446841125944367) }, 
      { SC_(1.97809827327728271484375), SC_(5.138592243194580078125), SC_(0.5466372966766357421875), SC_(0.03064984996767048867472200510308322337168), SC_(0.002094115042786527269319403425923906039518), SC_(0.9360457708124914965241152502793549820897), SC_(0.06395422918750850347588474972064501791034) }, 
      { SC_(1.9811840057373046875), SC_(8.64307498931884765625), SC_(0.680438578128814697265625), SC_(0.01243046417524263780921041523257298614424), SC_(0.4338600873108075430951736121152781456702e-5), SC_(0.9996510921040548001066360297740227834163), SC_(0.0003489078959451998933639702259772165836662) }, 
      { SC_(2.0774228572845458984375), SC_(5.401380062103271484375), SC_(0.412725269794464111328125), SC_(0.02076658118097194757979789708961463443791), SC_(0.005002206744587147413941043807074326193006), SC_(0.8058811784614189783383721077565365498755), SC_(0.1941188215385810216616278922434634501245) }, 
      { SC_(2.089349269866943359375), SC_(5.878770351409912109375), SC_(0.97059571743011474609375), SC_(0.02152232093009464317137315591896358498015), SC_(0.1639874663880437661193464960597376071962e-9), SC_(0.9999999923805863841918694764206460649879), SC_(0.7619413615808130523579353935012050371324e-8) }, 
      { SC_(2.21746730804443359375), SC_(8.3121433258056640625), SC_(0.4560872018337249755859375), SC_(0.008384993652043540584455387781579393117567), SC_(0.0003397527240445651863152161573652289492738), SC_(0.9610587277384102797777624641121524160602), SC_(0.03894127226158972022223753588784758393977) }, 
      { SC_(2.2381193637847900390625), SC_(0.177738964557647705078125), SC_(0.13206009566783905029296875), SC_(0.005209771959313113454156095010183150821445), SC_(4.657735963469510071723215852920223540659), SC_(0.001117270552760143140935910426828666711891), SC_(0.9988827294472398568590640895731713332881) }, 
      { SC_(2.2404003143310546875), SC_(9.182765960693359375), SC_(0.90006387233734130859375), SC_(0.006800124336193836183243959038486158685185), SC_(0.632180944223619799040497547154171330212e-10), SC_(0.9999999907033914809221680053702364328526), SC_(0.9296608519077831994629763567147435701488e-8) }, 
      { SC_(2.259217739105224609375), SC_(1.478290081024169921875), SC_(0.4242243468761444091796875), SC_(0.05387884094306878290852148745829185536173), SC_(0.1776046464082098048732217716337800996524), SC_(0.232754575972441110502123645783449010399), SC_(0.767245424027558889497876354216550989601) }, 
      { SC_(2.261876583099365234375), SC_(4.77995777130126953125), SC_(0.77493298053741455078125), SC_(0.02524715435856237905152641856691930638279), SC_(0.0001293902349124570100351392791975445797971), SC_(0.9949011878100327498698942676637562700405), SC_(0.005098812189967250130105732336243729959542) }, 
      { SC_(2.2766430377960205078125), SC_(7.99653148651123046875), SC_(0.431470692157745361328125), SC_(0.007987508692621355683212365675481666556691), SC_(0.0005580630251206706480819249991980235639121), SC_(0.9346956478099599688598811020565836284233), SC_(0.06530435219004003114011889794341637157665) }, 
      { SC_(2.289769649505615234375), SC_(5.054985523223876953125), SC_(0.22774152457714080810546875), SC_(0.00749639580197247968175994472318403697698), SC_(0.01433097419475378413625762391229404805409), SC_(0.3434401763976517653560353790675928681916), SC_(0.6565598236023482346439646209324071318084) }, 
      { SC_(2.304881572723388671875), SC_(1.9449536800384521484375), SC_(0.42181909084320068359375), SC_(0.04267162400975918545826194943964070440366), SC_(0.09548077954407752679296781148677056807397), SC_(0.308873554944199351252811779930663876864), SC_(0.691126445055800648747188220069336123136) }, 
      { SC_(2.3159439563751220703125), SC_(4.0157146453857421875), SC_(0.490352451801300048828125), SC_(0.02541298338391240785107976280668506617912), SC_(0.008371281410002501983425734786020182027124), SC_(0.7522135982219064130698833038843461965181), SC_(0.2477864017780935869301166961156538034819) }, 
      { SC_(2.3477990627288818359375), SC_(5.52881145477294921875), SC_(0.343905150890350341796875), SC_(0.01079728282872497101363208004072559319048), SC_(0.005947448660171923509803022530041944230881), SC_(0.6448167195684468911342719578217201877707), SC_(0.3551832804315531088657280421782798122293) }, 
      { SC_(2.3623058795928955078125), SC_(3.2823646068572998046875), SC_(0.9797503948211669921875), SC_(0.04824544979919274796977124655379965154987), SC_(0.8233822237290439183113528469792192047384e-6), SC_(0.9999829337652540964618174565824128065135), SC_(0.1706623474590353818254341758719348646456e-4) }, 
      { SC_(2.372835636138916015625), SC_(9.6864032745361328125), SC_(0.4876201450824737548828125), SC_(0.004695248674983470498753303222856166955214), SC_(0.6749254421293494045930234039400373407471e-4), SC_(0.9858290549272541339457914436234219974619), SC_(0.0141709450727458660542085563765780025381) }, 
      { SC_(2.3991615772247314453125), SC_(0.4047110974788665771484375), SC_(0.2878762185573577880859375), SC_(0.02412302770311051754901087149774643174004), SC_(1.593636191456647185062747776787849400842), SC_(0.01491138323763637240023825639403957854382), SC_(0.9850886167623636275997617436059604214562) }, 
      { SC_(2.399320125579833984375), SC_(3.3300526142120361328125), SC_(0.568866729736328125), SC_(0.03473633260470810902843102858029769862335), SC_(0.0104144135351114712946220423304125969993), SC_(0.7693412750508958329417687386843199446809), SC_(0.2306587249491041670582312613156800553191) }, 
      { SC_(2.399525165557861328125), SC_(8.2260494232177734375), SC_(0.2970997393131256103515625), SC_(0.004840106989165902755828959293971159201399), SC_(0.001699391069586811276887849252510747594209), SC_(0.7401343261640270162811166652769833281185), SC_(0.2598656738359729837188833347230166718815) }, 
      { SC_(2.4070703983306884765625), SC_(4.1576251983642578125), SC_(0.87595522403717041015625), SC_(0.02828475060029540041650736705230406362128), SC_(0.353405620582920860693824570530241063763e-4), SC_(0.9987521028143697924516293113756989791619), SC_(0.001247897185630207548370688624301020838072) }, 
      { SC_(2.4169127941131591796875), SC_(2.7275302410125732421875), SC_(0.3188464343547821044921875), SC_(0.01687875418932128752269745303288676836213), SC_(0.04945963164608714577434813724671861227809), SC_(0.2544342009044207266720405327338421344471), SC_(0.7455657990955792733279594672661578655529) }, 
      { SC_(2.428495883941650390625), SC_(3.3197727203369140625), SC_(0.948930203914642333984375), SC_(0.04411863009618537848130361956723465780333), SC_(0.1463737981882456849557537148925407150513e-4), SC_(0.9996683368203638425183455410152360080705), SC_(0.0003316631796361574816544589847639919294894) }, 
      { SC_(2.435249805450439453125), SC_(0.1353912651538848876953125), SC_(0.152462780475616455078125), SC_(0.004652331909113610201627081878075279800379), SC_(6.293325635628749681923748568709664485731), SC_(0.000738702474523326520995878238099811740878), SC_(0.9992612975254766734790041217619001882591) }, 
      { SC_(2.51083850860595703125), SC_(9.55017566680908203125), SC_(0.162266075611114501953125), SC_(0.001518864049622635513260335844822865771674), SC_(0.002332115770134649484292517375014216340894), SC_(0.3944097660107615626463647442480296351729), SC_(0.6055902339892384373536352557519703648271) }, 
      { SC_(2.518061161041259765625), SC_(6.547235965728759765625), SC_(0.779189288616180419921875), SC_(0.009092111878733893942041778479741627113901), SC_(0.561133501100370189571927000944368204187e-5), SC_(0.9993832154618063053896953383494710530946), SC_(0.0006167845381936946103046616505289469053556) }, 
      { SC_(2.5428216457366943359375), SC_(3.3244826793670654296875), SC_(0.149199068546295166015625), SC_(0.002399995515538567054182028873516302592247), SC_(0.03696306529137549247262832010542598071658), SC_(0.06097075446726977157225506370016367613526), SC_(0.9390292455327302284277449362998363238647) }, 
      { SC_(2.547901630401611328125), SC_(9.35214328765869140625), SC_(0.890914142131805419921875), SC_(0.003795040550828905594502219820069819256081), SC_(0.9129301329125373708690029615928052970483e-10), SC_(0.9999999759441276391155781638731269822464), SC_(0.2405587236088442183612687301775362991379e-7) }, 
      { SC_(2.5509512424468994140625), SC_(8.20840740203857421875), SC_(0.1338230073451995849609375), SC_(0.001144148488050650941236217367686827273247), SC_(0.003989090164218154776531410056936839620455), SC_(0.2228901801682172766380751406864276830656), SC_(0.7771098198317827233619248593135723169344) }, 
      { SC_(2.5644099712371826171875), SC_(3.430617809295654296875), SC_(0.996135056018829345703125), SC_(0.03605190961219250138710975965713452793869), SC_(0.153109444626530014093759122701506431833e-8), SC_(0.9999999575308382354537715812255358287304), SC_(0.4246916176454622841877446417126962132257e-7) }, 
      { SC_(2.575082302093505859375), SC_(8.0973453521728515625), SC_(0.1456244289875030517578125), SC_(0.001271337242296358388326731804163374322607), SC_(0.003829466829320152856984746506737389358397), SC_(0.2492425163653570912031525844886745893989), SC_(0.7507574836346429087968474155113254106011) }, 
      { SC_(2.580646991729736328125), SC_(1.6232850551605224609375), SC_(0.44564163684844970703125), SC_(0.0377249456934484343910391063994086011081), SC_(0.1242724939494340917109686980126619998491), SC_(0.2328737156378008655991719004924116644353), SC_(0.7671262843621991344008280995075883355647) }, 
      { SC_(2.5987040996551513671875), SC_(0.450595438480377197265625), SC_(0.25435674190521240234375), SC_(0.01228415692678274516836296624561764955031), SC_(1.328266257117124041622388146825369565435), SC_(0.009163517312061644380267909038777200104402), SC_(0.9908364826879383556197320909612227998956) }, 
      { SC_(2.6072800159454345703125), SC_(6.592105865478515625), SC_(0.7979488372802734375), SC_(0.007884838346507539476900184692061855773416), SC_(0.2937782577676189091319476101695193820282e-5), SC_(0.9996275524901317276307400161571077657795), SC_(0.0003724475098682723692599838428922342204645) }, 
      { SC_(2.618711948394775390625), SC_(3.2779777050018310546875), SC_(0.50790750980377197265625), SC_(0.023750351150236109270050432819465041679), SC_(0.01401877012948928122183870391771191247343), SC_(0.6288298574472101652212289824463236915355), SC_(0.3711701425527898347787710175536763084645) }, 
      { SC_(2.622117519378662109375), SC_(0.420541226863861083984375), SC_(0.449611127376556396484375), SC_(0.05939167504979013561568807306246474008024), SC_(1.412902245650176811448220194005078158683), SC_(0.0403395505576452992252545026365654187569), SC_(0.9596604494423547007747454973634345812431) }, 
      { SC_(2.624822139739990234375), SC_(1.81572973728179931640625), SC_(0.472009599208831787109375), SC_(0.03768860759801834256872385684383238338531), SC_(0.08952029547236269953542673443903381549088), SC_(0.2962733479209887974142744336390002731336), SC_(0.7037266520790112025857255663609997268664) }, 
      { SC_(2.6297128200531005859375), SC_(3.4021968841552734375), SC_(0.2173161208629608154296875), SC_(0.0045730987768145964998707813463808901918), SC_(0.02990559142258419351014993337885054145869), SC_(0.1326355134248788341608130493252147390037), SC_(0.8673644865751211658391869506747852609963) }, 
      { SC_(2.6380290985107421875), SC_(0.953551769256591796875), SC_(0.2599444091320037841796875), SC_(0.01095005985612260389209574837477314758979), SC_(0.4003480518823815872467548079876060089014), SC_(0.02662317074551621443047859631250405387502), SC_(0.973376829254483785569521403687495946125) }, 
      { SC_(2.6528089046478271484375), SC_(9.9647502899169921875), SC_(0.78027403354644775390625), SC_(0.002720755708289861191716679022785944840217), SC_(0.1922096147955325473810365921892668497513e-7), SC_(0.9999929354827285025847486328201872478872), SC_(0.7064517271497415251367179812752112809541e-5) }, 
      { SC_(2.6647150516510009765625), SC_(0.6914005279541015625), SC_(0.8443243503570556640625), SC_(0.3338388990912521097149652457882997226136), SC_(0.3587830340198169044726444527920341939433), SC_(0.4819929648946269021179782174331735323932), SC_(0.5180070351053730978820217825668264676068) }, 
      { SC_(2.690616130828857421875), SC_(8.5707244873046875), SC_(0.954947888851165771484375), SC_(0.003704566410662790071456740953562211095793), SC_(0.3148578557357761795055596035830456645775e-12), SC_(0.9999999999150081761787922438355088794653), SC_(0.8499182382120775616449112053473741679287e-10) }, 
      { SC_(2.691194057464599609375), SC_(9.71877384185791015625), SC_(0.705803692340850830078125), SC_(0.002710844747188206389928947601937055242347), SC_(0.4174483979257276290967368009774575243537e-6), SC_(0.9998460317122389257264163077317288544378), SC_(0.0001539682877610742735836922682711455622217) }, 
      { SC_(2.7602508068084716796875), SC_(7.05774211883544921875), SC_(0.117505915462970733642578125), SC_(0.000574766465256828612079626877160217999309), SC_(0.004819230030395527988337044870779590745593), SC_(0.1065566997902388599258529505134237279123), SC_(0.8934433002097611400741470494865762720877) }, 
      { SC_(2.7692296504974365234375), SC_(8.72428798675537109375), SC_(0.078267715871334075927734375), SC_(0.0001987484786553745542542012110923732592629), SC_(0.002931960363049194638969543764821190961544), SC_(0.06348353957666739408926113566240774668759), SC_(0.9365164604233326059107388643375922533124) }, 
      { SC_(2.784982204437255859375), SC_(1.8838198184967041015625), SC_(0.015501900576055049896240234375), SC_(0.3243607632796906054136076476148372299958e-5), SC_(0.1072883437222704505886445142612816912895), SC_(0.3023170514593439976976130859174697645705e-4), SC_(0.9999697682948540656002302386914082530235) }, 
      { SC_(2.8100528717041015625), SC_(2.62048816680908203125), SC_(0.849144399166107177734375), SC_(0.0502472027112171152391889093367380663655), SC_(0.002180478270593930517838741239781208789305), SC_(0.9584097898331529684191233768379440909759), SC_(0.04159021016684703158087662316205590902405) }, 
      { SC_(2.858390331268310546875), SC_(6.79819774627685546875), SC_(0.1712695658206939697265625), SC_(0.001050184749972493355186107000835243886465), SC_(0.004125204275420250058294841847220296596725), SC_(0.2029189969719809141603999311713129545789), SC_(0.7970810030280190858396000688286870454211) }, 
      { SC_(2.8749816417694091796875), SC_(5.930869579315185546875), SC_(0.957171261310577392578125), SC_(0.007152239662524918565106768420040748709892), SC_(0.1206393724925854448038606724130636701132e-8), SC_(0.9999998313264685801541427753935794813286), SC_(0.1686735314198458572246064205186713615043e-6) }, 
      { SC_(2.8906457424163818359375), SC_(0.554414272308349609375), SC_(0.87737619876861572265625), SC_(0.4104172931136211264648003088647864717129), SC_(0.5184153535807367870702296242575624745465), SC_(0.441863552680091384254248392993168644891), SC_(0.558136447319908615745751607006831355109) }, 
      { SC_(2.9044067859649658203125), SC_(0.7806694507598876953125), SC_(0.779711425304412841796875), SC_(0.2055850032161848069379814782539558806517), SC_(0.3255297758972347657116559730242711422621), SC_(0.3870820607917636670069741339443865739959), SC_(0.6129179392082363329930258660556134260041) }, 
      { SC_(2.91984081268310546875), SC_(8.2463169097900390625), SC_(0.663639128208160400390625), SC_(0.002871135378215250110511669328800495605487), SC_(0.7675244790074839837094968193316868064319e-5), SC_(0.9973338834000611359774823654811631729554), SC_(0.002666116599938864022517634518836827044588) }, 
      { SC_(2.9632079601287841796875), SC_(2.8780498504638671875), SC_(0.3564095199108123779296875), SC_(0.008933043563400443343164238497992499761011), SC_(0.02884968873172709619337346261385956882195), SC_(0.2364319100488253592284011357633582306721), SC_(0.7635680899511746407715988642366417693279) }, 
      { SC_(2.9667584896087646484375), SC_(6.557798862457275390625), SC_(0.45855104923248291015625), SC_(0.004127498628102374784013444962557551518574), SC_(0.0007938201947575470783084765241152787338545), SC_(0.8386976696022642529872677056250476163165), SC_(0.1613023303977357470127322943749523836835) }, 
      { SC_(3.0124633312225341796875), SC_(0.18450842797756195068359375), SC_(0.417325317859649658203125), SC_(0.03273624317172758052863465356510716397569), SC_(4.152711639725853649633019588051145023338), SC_(0.007821443269068808311001274622174009634926), SC_(0.9921785567309311916889987253778259903651) }, 
      { SC_(3.014549732208251953125), SC_(3.1048996448516845703125), SC_(0.7161290645599365234375), SC_(0.02639699138454097442882667741858511042723), SC_(0.003986227235504262264034042068536250337501), SC_(0.8688016801197500225229996790635078757689), SC_(0.1311983198802499774770003209364921242311) }, 
      { SC_(3.0634949207305908203125), SC_(1.0806190967559814453125), SC_(0.3886309564113616943359375), SC_(0.01753974376689889118941219097759183807165), SC_(0.2648262685187510209830954637905505617245), SC_(0.0621170502247103353512264670283469381013), SC_(0.9378829497752896646487735329716530618987) }, 
      { SC_(3.11102294921875), SC_(0.89823162555694580078125), SC_(0.4357551038265228271484375), SC_(0.02528170364324787969185521763047124442766), SC_(0.3662514023616783202792127472238438956332), SC_(0.06457104969031607199197851349933700870917), SC_(0.9354289503096839280080214865006629912908) }, 
      { SC_(3.1121504306793212890625), SC_(8.626781463623046875), SC_(0.21028804779052734375), SC_(0.0007104652853608580262042451868831532457621), SC_(0.001211277951360573517581804347092906482725), SC_(0.3696983404364359015379132224531359392858), SC_(0.6303016595635640984620867775468640607142) }, 
      { SC_(3.127189159393310546875), SC_(4.91752147674560546875), SC_(0.800300419330596923828125), SC_(0.008626021941275769482906968021517443576593), SC_(0.5021204238918015541387788377816565263232e-4), SC_(0.9942126915337096566702439345043125984516), SC_(0.005787308466290343329756065495687401548407) }, 
      { SC_(3.17099475860595703125), SC_(7.63749980926513671875), SC_(0.0899141728878021240234375), SC_(0.9550422207939347013615664029270850590691e-4), SC_(0.002393619425794835493665836526998416474008), SC_(0.03836861305020196825391331840930113370494), SC_(0.9616313869497980317460866815906988662951) }, 
      { SC_(3.1877830028533935546875), SC_(4.20189952850341796875), SC_(0.45890295505523681640625), SC_(0.00704186067780141233363288553853170980989), SC_(0.005282236270111228562607370010898396014828), SC_(0.571389588021222730804833098256358551602), SC_(0.428610411978777269195166901743641448398) }, 
      { SC_(3.1959974765777587890625), SC_(3.2532787322998046875), SC_(0.8173215389251708984375), SC_(0.02261037305616861802405065933992409367642), SC_(0.0008771689075638317917629248021845505695829), SC_(0.9626538652312666600586238289909526469751), SC_(0.03734613476873333994137617100904735302488) }, 
      { SC_(3.2247180938720703125), SC_(3.046635150909423828125), SC_(0.920882701873779296875), SC_(0.02692022140498910244580165186851523254319), SC_(0.0001260179022383322391490758442199226459111), SC_(0.9953406497366657149466795065471257745502), SC_(0.004659350263334285053320493452874225449821) }, 
      { SC_(3.251456737518310546875), SC_(6.829664707183837890625), SC_(0.82347548007965087890625), SC_(0.003072413217043238435586366088141114641613), SC_(0.7217225736871591548793163517788923122308e-6), SC_(0.9997651510305053107156452668329136836925), SC_(0.0002348489694946892843547331670863163075266) }, 
      { SC_(3.341630458831787109375), SC_(7.199709415435791015625), SC_(0.543851077556610107421875), SC_(0.002211092828440249015185077033714369015069), SC_(0.000148803480263564200603960902867601262049), SC_(0.9369449074034547821701533612210988436642), SC_(0.06305509259654521782984663877890115633581) }, 
      { SC_(3.3535683155059814453125), SC_(1.29066169261932373046875), SC_(0.508557856082916259765625), SC_(0.02666555765253891929560130152425942239313), SC_(0.1523792615145851333665426314584849331614), SC_(0.1489323051992291878515112468071005639974), SC_(0.8510676948007708121484887531928994360026) }, 
      { SC_(3.3712265491485595703125), SC_(3.885697841644287109375), SC_(0.19995288550853729248046875), SC_(0.0008086714614512974049214002590705149492911), SC_(0.01205090945524301781354154966642099121593), SC_(0.0628847445877088930901049863593150226734), SC_(0.9371152554122911069098950136406849773266) }, 
      { SC_(3.3771941661834716796875), SC_(8.87726116180419921875), SC_(0.3082362115383148193359375), SC_(0.0007675852185268053563112476726240395605536), SC_(0.000443944169925614056391310270079986897049), SC_(0.6335671473122922542070315829787835850029), SC_(0.3664328526877077457929684170212164149971) }, 
      { SC_(3.394934177398681640625), SC_(6.16272258758544921875), SC_(0.68680679798126220703125), SC_(0.00341612545067499739532823189209030444151), SC_(0.6004246521395373073900716227994039951573e-4), SC_(0.9827273979086251270287764218567886199783), SC_(0.01727260209137487297122357814321138002167) }, 
      { SC_(3.4038574695587158203125), SC_(8.767574310302734375), SC_(0.12993355095386505126953125), SC_(0.0001265599990061511079472533509698684696025), SC_(0.001085291714122214276635480771217256262071), SC_(0.1044352189587945409799702481375273255486), SC_(0.8955647810412054590200297518624726744514) }, 
      { SC_(3.4112460613250732421875), SC_(7.230242252349853515625), SC_(0.93900763988494873046875), SC_(0.00213642299598618217609312456804844157662), SC_(0.1997379046394552152960612082822913744712e-9), SC_(0.9999999065082681000572618925659394938792), SC_(0.9349173189994273810743406050612079220705e-7) }, 
      { SC_(3.438770294189453125), SC_(2.037597179412841796875), SC_(0.7939956188201904296875), SC_(0.04896851324710769560853528658685599913346), SC_(0.01373131053597841043136711804351216596933), SC_(0.7809992164653807773340193178169519137939), SC_(0.2190007835346192226659806821830480862061) }, 
      { SC_(3.444624423980712890625), SC_(2.2622740268707275390625), SC_(0.904890477657318115234375), SC_(0.04682650450606622225676225402991465214856), SC_(0.001827573877341612166691972016401816163686), SC_(0.962437396040269933237949745827329477572), SC_(0.03756260395973006676205025417267052242804) }, 
      { SC_(3.499837398529052734375), SC_(9.07364749908447265625), SC_(0.15769731998443603515625), SC_(0.0001595676014392862943646232346637282648971), SC_(0.0007954044601255210393761215597156122794561), SC_(0.1670913818963671822695130478083958726536), SC_(0.8329086181036328177304869521916041273464) }, 
      { SC_(3.5021800994873046875), SC_(0.6873857975006103515625), SC_(0.988522708415985107421875), SC_(0.5073660342424767846839047605210881249186), SC_(0.06669260635138630073271025616499775701394), SC_(0.8838226591583172293252640451723733711315), SC_(0.1161773408416827706747359548276266288685) }, 
      { SC_(3.507271289825439453125), SC_(9.90110015869140625), SC_(0.4018678367137908935546875), SC_(0.0006303375202500836777029647923567590031211), SC_(0.893415450734820498924837265842568051911e-4), SC_(0.8758591858812589788924012123963645202476), SC_(0.1241408141187410211075987876036354797524) }, 
      { SC_(3.509523868560791015625), SC_(1.9955120086669921875), SC_(0.2785703837871551513671875), SC_(0.002518168664557284054635975386953824482137), SC_(0.06100657246447784953562131084727446764158), SC_(0.03964075444939215114060950283596675958899), SC_(0.960359245550607848859390497164033240411) }, 
      { SC_(3.5165951251983642578125), SC_(0.67595374584197998046875), SC_(0.16295583546161651611328125), SC_(0.0005037787744294979435424091499216027477279), SC_(0.5890276587815100401046801862379880253751), SC_(0.0008545409834597587778080052231511605543407), SC_(0.9991454590165402412221919947768488394457) }, 
      { SC_(3.531585693359375), SC_(0.53152573108673095703125), SC_(0.3439953327178955078125), SC_(0.007582184914246779034529741378085707778332), SC_(0.8768734775589902175371326044812673096379), SC_(0.008572713405491041890176212533880101987811), SC_(0.9914272865945089581098237874661198980122) }, 
      { SC_(3.674366474151611328125), SC_(1.5157415866851806640625), SC_(0.498414218425750732421875), SC_(0.01626513473616858113656075588891836370069), SC_(0.0956337109094846385186640122504500168283), SC_(0.1453556973024985841272291527358008650346), SC_(0.8546443026975014158727708472641991349654) }, 
      { SC_(3.6848456859588623046875), SC_(3.4392974376678466796875), SC_(0.369309842586517333984375), SC_(0.003034418852919506203403439253998317470373), SC_(0.0109770680323691467025482811847071089959), SC_(0.2165665127307431833757078076730444355636), SC_(0.7834334872692568166242921923269555644364) }, 
      { SC_(3.689165592193603515625), SC_(6.343033313751220703125), SC_(0.753753721714019775390625), SC_(0.002286485687952490352199724116467186529223), SC_(0.1146042802415995661185446288837819384688e-4), SC_(0.995012751628734706448963807994251665798), SC_(0.004987248371265293551036192005748334201973) }, 
      { SC_(3.6924679279327392578125), SC_(0.332685649394989013671875), SC_(0.3112839162349700927734375), SC_(0.004403067325320050811341626534627106880183), SC_(1.787532718402722553681756796726057156333), SC_(0.002457156869341239214405399462686750970898), SC_(0.9975428431306587607855946005373132490291) }, 
      { SC_(3.7240974903106689453125), SC_(1.95324766635894775390625), SC_(0.680319011211395263671875), SC_(0.03070754463474470509489852074407147827997), SC_(0.02953364960519138166479753966735371292935), SC_(0.5097432914832148659671128156250804657633), SC_(0.4902567085167851340328871843749195342367) }, 
      { SC_(3.762722015380859375), SC_(1.7316303253173828125), SC_(0.761755049228668212890625), SC_(0.04819870316749823556815112747531236095765), SC_(0.03101140726001127715477086541673927818416), SC_(0.6084918062525377124364310570386615728699), SC_(0.3915081937474622875635689429613384271301) }, 
      { SC_(3.7860939502716064453125), SC_(1.4014384746551513671875), SC_(0.3949687182903289794921875), SC_(0.006738681221878219586257799208954857661079), SC_(0.1214383490093244204509172871531264012822), SC_(0.0525732357016163402814641163958969070086), SC_(0.9474267642983836597185358836041030929914) }, 
      { SC_(3.804458141326904296875), SC_(2.0806806087493896484375), SC_(0.1819288432598114013671875), SC_(0.000339663825744559203667503296831169048772), SC_(0.04920455418500763874393422890478378400164), SC_(0.006855771256109937874856175412338436576411), SC_(0.9931442287438900621251438245876615634236) }, 
      { SC_(3.815584659576416015625), SC_(2.1020905971527099609375), SC_(0.0976306498050689697265625), SC_(0.3346503003511307025994365425596946350141e-4), SC_(0.04798471509940414812131393471654899623967), SC_(0.0006969241638251121010389345381483734912583), SC_(0.9993030758361748878989610654618516265087) }, 
      { SC_(3.846190929412841796875), SC_(0.18211762607097625732421875), SC_(0.775735080242156982421875), SC_(0.2305236204942783996346011481007016559976), SC_(3.815090868013124139424764239059567326492), SC_(0.05698111403079542207160108451162265577819), SC_(0.9430188859692045779283989154883773442218) }, 
      { SC_(3.8677120208740234375), SC_(9.8445262908935546875), SC_(0.910656511783599853515625), SC_(0.0004415987203700542331960592324491142784921), SC_(0.3760552084345910234203225117480150225887e-11), SC_(0.9999999914842324516460849337297567421705), SC_(0.8515767548353915066270243257829503241677e-8) }, 
      { SC_(3.897388458251953125), SC_(2.10301876068115234375), SC_(0.317167758941650390625), SC_(0.00211995915782613286649077826233994974427), SC_(0.04398177189361145708293661128942341147588), SC_(0.0459843721586247507130171123335138093625), SC_(0.9540156278413752492869828876664861906375) }, 
      { SC_(3.9093780517578125), SC_(6.172049045562744140625), SC_(0.647781193256378173828125), SC_(0.001892431230992244536103849138578750819333), SC_(0.9136737720090860826601151827042570517444e-4), SC_(0.9539432194258235933399966227832436131393), SC_(0.04605678057417640666000337721675638686074) }, 
      { SC_(3.922270298004150390625), SC_(4.2208766937255859375), SC_(0.05987356603145599365234375), SC_(0.3485261164462027350126100419607149182019e-5), SC_(0.006443943947570980055585930868032630154809), SC_(0.000540566022770741579637538880453495215718), SC_(0.9994594339772292584203624611195465047843) }, 
      { SC_(3.955152034759521484375), SC_(6.36468601226806640625), SC_(0.493377506732940673828125), SC_(0.00132096005133563113867213648962620481785), SC_(0.0003909565446960733947620235350881702597231), SC_(0.7716264065654090332018153544028481103726), SC_(0.2283735934345909667981846455971518896274) }, 
      { SC_(3.9925777912139892578125), SC_(8.58099269866943359375), SC_(0.6551325321197509765625), SC_(0.00059687247521963783109417389221041362613), SC_(0.4186275658160856881103523204909974622039e-5), SC_(0.9930351639468735245403112532730405823494), SC_(0.006964836053126475459688746726959417650638) }, 
      { SC_(3.9978263378143310546875), SC_(8.5587520599365234375), SC_(0.2530306875705718994140625), SC_(0.0002000342445191602250991895557390544408533), SC_(0.0004024991800349779513010748374275834394527), SC_(0.3319886272984461897376859048400700505655), SC_(0.6680113727015538102623140951599299494345) }, 
      { SC_(4.018080234527587890625), SC_(3.823329448699951171875), SC_(0.2827450335025787353515625), SC_(0.0007601447127604919068109672519485030363815), SC_(0.00732017134542074002847796227631289188979), SC_(0.09407363614086031579750027558139831732109), SC_(0.9059263638591396842024997244186016826789) }, 
      { SC_(4.039121150970458984375), SC_(4.924419879913330078125), SC_(0.322578489780426025390625), SC_(0.0008165978619909246999400404020562364744431), SC_(0.00280564472240535747675278521265628616294), SC_(0.2254398602425537884432852190281784932106), SC_(0.7745601397574462115567147809718215067894) }, 
      { SC_(4.07619190216064453125), SC_(5.160478115081787109375), SC_(0.82121193408966064453125), SC_(0.003000217804080632625650897723212864585433), SC_(0.1634719567696898287973096826539913560409e-4), SC_(0.9945808574725614815820228211556819509052), SC_(0.005419142527438518417977178844318049094759) }, 
      { SC_(4.0871982574462890625), SC_(1.3373639583587646484375), SC_(0.4468390643596649169921875), SC_(0.007815051877947138848886749252571214308732), SC_(0.1211517004676313751464524014370263674099), SC_(0.06059741550291949701446852158409554478327), SC_(0.9394025844970805029855314784159044552167) }, 
      { SC_(4.16158580780029296875), SC_(4.334296703338623046875), SC_(0.9928820133209228515625), SC_(0.004915977639327343176813956171124129607676), SC_(0.111326273595334058479857113143408645365e-9), SC_(0.9999999773541949858230378475985897252633), SC_(0.2264580501417696215240141027473673643647e-7) }, 
      { SC_(4.16799449920654296875), SC_(6.17279148101806640625), SC_(0.655775129795074462890625), SC_(0.001453834981663703224201116746393444570994), SC_(0.7456889254363368424142544897214738315206e-4), SC_(0.9512112643771550799991205368248023521183), SC_(0.04878873562284492000087946317519764788174) }, 
      { SC_(4.1726703643798828125), SC_(9.81723117828369140625), SC_(0.2999017238616943359375), SC_(0.0001595726362735232103091708394959724349356), SC_(0.0001376529394698152122204501560228893629794), SC_(0.5368738402623807079559457167606133580281), SC_(0.4631261597376192920440542832393866419719) }, 
      { SC_(4.177441120147705078125), SC_(5.667774200439453125), SC_(0.710732758045196533203125), SC_(0.001955842728313271240461714679655013009371), SC_(0.642197499106641079211196036594811466788e-4), SC_(0.9682090278875300284124753336426606374581), SC_(0.03179097211246997158752466635733936254185) }, 
      { SC_(4.217612743377685546875), SC_(1.12464511394500732421875), SC_(0.0365376062691211700439453125), SC_(0.20488203214435709486578084489485509793e-6), SC_(0.1837138480169170254057649584408135530396), SC_(0.1115222428068968937946350222553614039584e-5), SC_(0.999998884777571931031062053649777446386) }, 
      { SC_(4.22835636138916015625), SC_(5.63964939117431640625), SC_(0.706075489521026611328125), SC_(0.001888734028667347821779058752147186501344), SC_(0.7098706947284053362226644050757628201671e-4), SC_(0.9637769529857036400422998604666430889328), SC_(0.03622304701429635995770013953335691106718) }, 
      { SC_(4.2288570404052734375), SC_(3.947277069091796875), SC_(0.807550251483917236328125), SC_(0.006061291656177201742722114760473465318425), SC_(0.0002224131471504115649228682715632446570155), SC_(0.9646047747130594132571357327170893886648), SC_(0.03539522528694058674286426728291061133519) }, 
      { SC_(4.234529018402099609375), SC_(6.98146915435791015625), SC_(0.8350250720977783203125), SC_(0.0009337114805446995691056713848520742605454), SC_(0.2980464818946349573530523199543153357105e-6), SC_(0.9996808956726132530854226125950651408583), SC_(0.0003191043273867469145773874049348591416735) }, 
      { SC_(4.24166774749755859375), SC_(7.819091796875), SC_(0.4625279605388641357421875), SC_(0.0004933174328214183747087477640676701073185), SC_(0.0001273328163186150567482042129753385526036), SC_(0.7948396597035994256120514978087655306256), SC_(0.2051603402964005743879485021912344693744) }, 
      { SC_(4.2434902191162109375), SC_(0.03001205064356327056884765625), SC_(0.91574394702911376953125), SC_(0.7913118669578982010057645632445222616139), SC_(30.70086471660855969709438760268700586521), SC_(0.02512725231481230674371021454267426341113), SC_(0.9748727476851876932562897854573257365889) }, 
      { SC_(4.25259304046630859375), SC_(7.69965648651123046875), SC_(0.800088465213775634765625), SC_(0.000647459387938309640207339154469609485359), SC_(0.2858671995876147011552133505101127691791e-6), SC_(0.9995586734177979320327844004192514883373), SC_(0.0004413265822020679672155995807485116626982) }, 
      { SC_(4.257288455963134765625), SC_(9.00022125244140625), SC_(0.9619019031524658203125), SC_(0.0003666435683632549874185282786292281191341), SC_(0.1675816850101715394970763133208675211631e-13), SC_(0.9999999999542930247622729275804929675019), SC_(0.4570697523772707241950703249807441224536e-10) }, 
      { SC_(4.2825298309326171875), SC_(7.26893138885498046875), SC_(0.762955129146575927734375), SC_(0.0007678999559307638251236970534436173693689), SC_(0.1831468126780327434607538402149569904173e-5), SC_(0.9976206400446457423279817764123196742157), SC_(0.002379359955354257672018223587680325784283) }, 
      { SC_(4.302073955535888671875), SC_(6.330636501312255859375), SC_(0.4361739456653594970703125), SC_(0.0007323890497460165920865639771603831807549), SC_(0.0004960371243454562744368325883204754637519), SC_(0.5962011109765562252185491992036464270708), SC_(0.4037988890234437747814508007963535729292) }, 
      { SC_(4.3141384124755859375), SC_(7.499410152435302734375), SC_(0.257582485675811767578125), SC_(0.0001523524314670596952859386396182223010862), SC_(0.00051298876570815563125771301650668420985), SC_(0.2289839139886271073985185628556134414714), SC_(0.7710160860113728926014814371443865585286) }, 
      { SC_(4.31651210784912109375), SC_(3.593244075775146484375), SC_(0.66931819915771484375), SC_(0.005962783355305816920422168541076375755496), SC_(0.001980719830818929872695793117050213868802), SC_(0.7506490795800602143785187162493448549819), SC_(0.2493509204199397856214812837506551450181) }, 
      { SC_(4.323915004730224609375), SC_(2.4431965351104736328125), SC_(0.6397993564605712890625), SC_(0.01179352463873967035321228543041242241238), SC_(0.01321132025387695410494016305688434155583), SC_(0.4716495818865101754914612013681178719455), SC_(0.5283504181134898245085387986318821280545) }, 
      { SC_(4.35698699951171875), SC_(4.730150699615478515625), SC_(0.4353021681308746337890625), SC_(0.001270595459129720618447321421967813299846), SC_(0.001899346260206705004200144865581969908912), SC_(0.4008261260385880423883646928419693290388), SC_(0.5991738739614119576116353071580306709612) }, 
      { SC_(4.358585834503173828125), SC_(4.88617706298828125), SC_(0.385771930217742919921875), SC_(0.000873444821049616508120588729906931218686), SC_(0.001966066589777316856366801722914081278398), SC_(0.3076039130250399555159053975412494098092), SC_(0.6923960869749600444840946024587505901908) }, 
      { SC_(4.38744354248046875), SC_(1.25896632671356201171875), SC_(0.0972220599651336669921875), SC_(0.8079338763992022673426412364828437244812e-5), SC_(0.1357239448119721714929359565157081047217), SC_(0.5952418977425382436263032468692206509502e-4), SC_(0.9999404758102257461756373696753130779349) }, 
      { SC_(4.38869953155517578125), SC_(6.80406665802001953125), SC_(0.441279351711273193359375), SC_(0.0005625161947369272680055511361920511152622), SC_(0.0003105393995597920009107785226144372460028), SC_(0.6443074168604993123923960868020104779396), SC_(0.3556925831395006876076039131979895220604) }, 
      { SC_(4.40085124969482421875), SC_(4.833751678466796875), SC_(0.85304582118988037109375), SC_(0.002833024912591884527246949566995738205669), SC_(0.1257055868290681442472551954320936548115e-4), SC_(0.9955824505591881053120414314258630456422), SC_(0.004417549440811894687958568574136954357805) }, 
      { SC_(4.4267826080322265625), SC_(6.042315006256103515625), SC_(0.2399921715259552001953125), SC_(0.0001389011455829871630376160257617134120336), SC_(0.001146172954177140036185869871464208744483), SC_(0.1080880438014543634757913324639884753479), SC_(0.8919119561985456365242086675360115246521) }, 
      { SC_(4.4558620452880859375), SC_(4.87568950653076171875), SC_(0.111208103597164154052734375), SC_(0.8737041037785171974163307774126204250124e-5), SC_(0.002635213041449158075813184554804281086475), SC_(0.003304540844268499363827724559721339421078), SC_(0.9966954591557315006361722754402786605789) }, 
      { SC_(4.46783733367919921875), SC_(7.55789852142333984375), SC_(0.387357175350189208984375), SC_(0.0003095008850999087524788129936783954754585), SC_(0.0002387992000988523661335067068728399564781), SC_(0.5644735309273449447753561304968009317269), SC_(0.4355264690726550552246438695031990682731) }, 
      { SC_(4.501377105712890625), SC_(9.73915004730224609375), SC_(0.9817249774932861328125), SC_(0.0002021203841721295438561479180561355795204), SC_(0.1142994500838962175228667868690677069228e-17), SC_(0.9999999999999943449815538369451844227015), SC_(0.5655018446163054815577298543453841986834e-14) }, 
      { SC_(4.50541591644287109375), SC_(7.204934597015380859375), SC_(0.2238895595073699951171875), SC_(0.7677865135582137496042118502912680267248e-4), SC_(0.0005524815694234338122096947721653437890131), SC_(0.1220141506175953966762814987386765667457), SC_(0.8779858493824046033237185012613234332543) }, 
      { SC_(4.5092372894287109375), SC_(3.7850043773651123046875), SC_(0.3532232344150543212890625), SC_(0.0007968680936695002518585727802563476288224), SC_(0.005125824028528572515404795689671693648465), SC_(0.1345449125546915552987201345041763077545), SC_(0.8654550874453084447012798654958236922455) }, 
      { SC_(4.537976741790771484375), SC_(4.369328975677490234375), SC_(0.63310039043426513671875), SC_(0.002762624915706083383253982471768001842809), SC_(0.0008416809728271810048334780109156618416524), SC_(0.766479039555187555502980928180056018741), SC_(0.233520960444812444497019071819943981259) }, 
      { SC_(4.5742435455322265625), SC_(0.944407641887664794921875), SC_(0.8558895587921142578125), SC_(0.1153225004287323657315193236681473951993), SC_(0.1323463706705529555673381822924659652411), SC_(0.465631792630499630263333244029486499679), SC_(0.534368207369500369736666755970513500321) }, 
      { SC_(4.58725452423095703125), SC_(5.332294940948486328125), SC_(0.982362329959869384765625), SC_(0.001738570953008792154519728834911620451865), SC_(0.7930354071259105373355931983243022755784e-10), SC_(0.9999999543857919873910349588790741402221), SC_(0.4561420801260896504112092585977792265085e-7) }, 
      { SC_(4.58848857879638671875), SC_(2.137727260589599609375), SC_(0.4886601269245147705078125), SC_(0.00455430106153504018813078846284619613673), SC_(0.0278141825077712670505896683515525386871), SC_(0.1407017122622851357576518311915633940965), SC_(0.8592982877377148642423481688084366059035) }, 
      { SC_(4.607259273529052734375), SC_(5.297629833221435546875), SC_(0.754711210727691650390625), SC_(0.001701733513898066203341389589425216735055), SC_(0.4833571921485870611611141300227154031345e-4), SC_(0.9723806816894427415508916411884759589432), SC_(0.02761931831055725844910835881152404105676) }, 
      { SC_(4.609163761138916015625), SC_(4.464239597320556640625), SC_(0.917126178741455078125), SC_(0.003177016906036128958035803489443204712842), SC_(0.2584011233363429895212256270643711409595e-5), SC_(0.9991873158611419479264171634299491469647), SC_(0.0008126841388580520735828365700508530352858) }, 
      { SC_(4.62449169158935546875), SC_(4.69015598297119140625), SC_(0.913384497165679931640625), SC_(0.002648599834731963898416891188016814860933), SC_(0.1697340977886516276421807912591963390796e-5), SC_(0.9993595657900394117927935760301221664377), SC_(0.0006404342099605882072064239698778335622501) }, 
      { SC_(4.693906307220458984375), SC_(3.872959136962890625), SC_(0.196675598621368408203125), SC_(0.6224237026848410457525560691244094625343e-4), SC_(0.004798899005565194840196862622125358148202), SC_(0.01280406502429887161160881425215428199059), SC_(0.9871959349757011283883911857478457180094) }, 
      { SC_(4.70923328399658203125), SC_(9.00183200836181640625), SC_(0.4202479422092437744140625), SC_(0.000158225208277054586885876378105519932316), SC_(0.5674929033569588555189634312012598987484e-4), SC_(0.7360185012552461107213884928708813355786), SC_(0.2639814987447538892786115071291186644214) }, 
      { SC_(4.70924282073974609375), SC_(7.485051631927490234375), SC_(0.80975353717803955078125), SC_(0.0004420124670015826250696273308415092735237), SC_(0.2733893716591851934792090767797141273164e-6), SC_(0.9993818717742841998195431289280619690091), SC_(0.000618128225715800180456871071938030990896) }, 
      { SC_(4.710883617401123046875), SC_(3.1823215484619140625), SC_(0.585309207439422607421875), SC_(0.004182974042531005969813386052752853862515), SC_(0.004996399700123027483777650816833831243609), SC_(0.4556927476537829881389520071075269108672), SC_(0.5443072523462170118610479928924730891328) }, 
      { SC_(4.7135715484619140625), SC_(2.475850582122802734375), SC_(0.92750012874603271484375), SC_(0.01948069384902283527167207628290575644802), SC_(0.0005008590400585332359448614151044972222606), SC_(0.9749339281667031776467067211271153110098), SC_(0.02506607183329682235329327887288468899022) }, 
      { SC_(4.73288822174072265625), SC_(9.87459564208984375), SC_(0.16269548237323760986328125), SC_(0.1118768224668481038708684146831473990511e-4), SC_(0.0001332344114234768481115225936213370067112), SC_(0.07746517144555315795939763197808416266876), SC_(0.9225348285544468420406023680219158373312) }, 
      { SC_(4.73486042022705078125), SC_(2.15629291534423828125), SC_(0.933999836444854736328125), SC_(0.02860622310415008153968542990686413539652), SC_(0.001113277625266835850317121039576934930407), SC_(0.9625405004140970361077506667187941519677), SC_(0.03745949958590296389224933328120584803232) }, 
      { SC_(4.799221515655517578125), SC_(4.0151958465576171875), SC_(0.54726588726043701171875), SC_(0.001999651543873986595861462311584078056876), SC_(0.002012974352945711886168733276820735381988), SC_(0.4983398889636977374834803331212879357163), SC_(0.5016601110363022625165196668787120642837) }, 
      { SC_(4.820220470428466796875), SC_(8.77573108673095703125), SC_(0.763773620128631591796875), SC_(0.0002099075745047356172104463746743265243803), SC_(0.1457556832397700656046572424828174287601e-6), SC_(0.9993061015356941295191725636277212117678), SC_(0.0006938984643058704808274363722787882321867) }, 
      { SC_(4.853756427764892578125), SC_(7.981058597564697265625), SC_(0.034413881599903106689453125), SC_(0.1330606079887088311888331240622674173747e-7), SC_(0.000296368754703383214672803066578790720065), SC_(0.448949601219552858966483125924356828299e-4), SC_(0.9999551050398780447141033516874075643172) }, 
      { SC_(4.867916584014892578125), SC_(9.1056499481201171875), SC_(0.382394731044769287109375), SC_(0.0001070071844954597067478229004231133639916), SC_(0.6449739231166213850504564681821726203361e-4), SC_(0.6239319468179706325730212547544151647585), SC_(0.3760680531820293674269787452455848352415) }, 
      { SC_(4.886089801788330078125), SC_(3.443279266357421875), SC_(0.4854271113872528076171875), SC_(0.001740082091073594896392627511450985505252), SC_(0.004673780812586334347431924608314054473085), SC_(0.2713001692132607750680896169104317445914), SC_(0.7286998307867392249319103830895682554086) }, 
      { SC_(4.888977527618408203125), SC_(4.132906436920166015625), SC_(0.490639984607696533203125), SC_(0.001282629392445456323088776120600072948622), SC_(0.002137492964505009326693445752288995023308), SC_(0.3750244168425325474087628198299124215964), SC_(0.6249755831574674525912371801700875784036) }, 
      { SC_(4.892526149749755859375), SC_(5.4405612945556640625), SC_(0.3064188659191131591796875), SC_(0.0001750006837586270127060720379861705322616), SC_(0.001083612434044039366262807505580660281492), SC_(0.1390424756291669032954627615219234579883), SC_(0.8609575243708330967045372384780765420117) }, 
      { SC_(4.89687633514404296875), SC_(2.041971683502197265625), SC_(0.681391417980194091796875), SC_(0.01309589833101834225694626978740545490209), SC_(0.01952561425847975496928904324750867640749), SC_(0.401449757888735318264951982905586832392), SC_(0.598550242111264681735048017094413167608) }, 
      { SC_(4.89764404296875), SC_(4.579891681671142578125), SC_(0.10995076596736907958984375), SC_(0.2923382009052537620649843740171322447237e-5), SC_(0.002356248625825790462906051645685364623159), SC_(0.001239155940874147951370627704432701171814), SC_(0.9987608440591258520486293722955672988282) }, 
      { SC_(4.899013996124267578125), SC_(3.1015598773956298828125), SC_(0.578567206859588623046875), SC_(0.003635589426478967329720721328543678930707), SC_(0.005366049114582910897340907941531805572118), SC_(0.4038808501246590877493959811314823147957), SC_(0.5961191498753409122506040188685176852043) }, 
      { SC_(4.90864086151123046875), SC_(2.478476047515869140625), SC_(0.3036836087703704833984375), SC_(0.0003821737361871374517777584507451110720499), SC_(0.01785171255178272346813885338585777591958), SC_(0.02095953271570436113782500619928277365348), SC_(0.9790404672842956388621749938007172263465) }, 
      { SC_(4.94173908233642578125), SC_(0.12538804113864898681640625), SC_(0.5308444499969482421875), SC_(0.01492948057009154527183257309643154815528), SC_(6.201527219590741009169134628902905833635), SC_(0.002401606138381899904785873465221076733673), SC_(0.9975983938616181000952141265347789232663) }, 
      { SC_(4.9836406707763671875), SC_(7.739171504974365234375), SC_(0.1259840428829193115234375), SC_(0.3145876450024686392057513024759489209729e-5), SC_(0.0002906330583805864561539634522930981994032), SC_(0.0107083118530556151076914507277685061066), SC_(0.9892916881469443848923085492722314938934) }, 
      { SC_(5.00022411346435546875), SC_(2.539431095123291015625), SC_(0.547260820865631103515625), SC_(0.00387577213149792780492671679142202310754), SC_(0.01236068808392329287151124939469189793584), SC_(0.238707949890257473266799884331193225485), SC_(0.761292050109742526733200115668806774515) }, 
      { SC_(5.004716396331787109375), SC_(3.2253296375274658203125), SC_(0.58530557155609130859375), SC_(0.003199153121285395041323999219470534761141), SC_(0.004274605467562257145999410481647695879053), SC_(0.4280514393466191930034151674960010431186), SC_(0.5719485606533808069965848325039989568814) }, 
      { SC_(5.059570789337158203125), SC_(9.4007396697998046875), SC_(0.1355634629726409912109375), SC_(0.2972426923355312132499585156253792190284e-5), SC_(0.0001182151213827356807877479690485562247179), SC_(0.02452749449017375110317770117245616057168), SC_(0.9754725055098262488968222988275438394283) }, 
      { SC_(5.078582763671875), SC_(1.1319253444671630859375), SC_(0.46944367885589599609375), SC_(0.003958839558831331147976816806712789679753), SC_(0.1432058291068932670953440825693930210443), SC_(0.02690074726987351324908476447976775755346), SC_(0.9730992527301264867509152355202322424465) }, 
      { SC_(5.085086822509765625), SC_(3.9358985424041748046875), SC_(0.38867628574371337890625), SC_(0.000517646995240780501212394876616493117754), SC_(0.003068334921029526075145749494458953664571), SC_(0.1443529296375182710248807630742079806522), SC_(0.8556470703624817289751192369257920193478) }, 
      { SC_(5.107715606689453125), SC_(8.7018680572509765625), SC_(0.3897998631000518798828125), SC_(0.9218588368860460759683712151435435564958e-4), SC_(0.6713017455612673998584769761083444564826e-4), SC_(0.5786352280132014594935071226518029158726), SC_(0.4213647719867985405064928773481970841274) }, 
      { SC_(5.13249492645263671875), SC_(1.3800132274627685546875), SC_(0.2816991508007049560546875), SC_(0.0002637511732004907339307444471080299268032), SC_(0.08833387736634904356179444308425685398841), SC_(0.00297695522496692494612400102673211127697), SC_(0.997023044775033075053875998973267888723) }, 
      { SC_(5.1805210113525390625), SC_(9.69837188720703125), SC_(0.868707835674285888671875), SC_(0.926318376181302429834247672939276804215e-4), SC_(0.1706292084281352993358122005421870955537e-9), SC_(0.9999981579886730671468813824843217941114), SC_(0.1842011326932853118617515678205888557373e-5) }, 
      { SC_(5.1859493255615234375), SC_(9.36055088043212890625), SC_(0.623473227024078369140625), SC_(0.0001052760167786781399442600576284740646208), SC_(0.2039921915033466113410785777258940648188e-5), SC_(0.9809914357562899512367280196583250896585), SC_(0.01900856424371004876327198034167491034153) }, 
      { SC_(5.21135807037353515625), SC_(1.89905488491058349609375), SC_(0.489815413951873779296875), SC_(0.002889360219014527630566174449643210190743), SC_(0.0330820878668231263711781123891459547675), SC_(0.08032371152030712449913414467785786201517), SC_(0.9196762884796928755008658553221421379848) }, 
      { SC_(5.21649837493896484375), SC_(6.671141147613525390625), SC_(0.602021753787994384765625), SC_(0.0003764771489573151345431013489377676301121), SC_(0.5540749567173549744564527264029312981928e-4), SC_(0.8717076507331593987860837715768414409239), SC_(0.1282923492668406012139162284231585590761) }, 
      { SC_(5.268758296966552734375), SC_(9.0893650054931640625), SC_(0.655512332916259765625), SC_(0.0001100239318159776588155468262423778775298), SC_(0.1419685433442957690687557012390447182423e-5), SC_(0.9872609533997305845345390194748066911436), SC_(0.0127390466002694154654609805251933088564) }, 
      { SC_(5.271427631378173828125), SC_(1.3080546855926513671875), SC_(0.854465544223785400390625), SC_(0.05514970289536350676256168696413389645059), SC_(0.04310029547328752947291890805548064993811), SC_(0.5613201405707128389083811171576100155359), SC_(0.4386798594292871610916188828423899844641) }, 
      { SC_(5.28533172607421875), SC_(6.203600406646728515625), SC_(0.210380852222442626953125), SC_(0.1839698575307785445002600821210795991046e-4), SC_(0.0005290370735063514917604581303002113260556), SC_(0.03360584794078278437896715845336512100514), SC_(0.9663941520592172156210328415466348789949) }, 
      { SC_(5.307975292205810546875), SC_(5.92823886871337890625), SC_(0.18695391714572906494140625), SC_(0.1114332013728617204236630580207160646186e-4), SC_(0.0006347538077471138366727979497502318665891), SC_(0.01725246894003925235208158836667843051158), SC_(0.9827475310599607476479184116333215694884) }, 
      { SC_(5.308642864227294921875), SC_(6.311199188232421875), SC_(0.817645967006683349609375), SC_(0.0004989085753468472436234941242641877367728), SC_(0.1648123386794987008467992488436743477428e-5), SC_(0.9967074191775585616689599560992871603391), SC_(0.003292580822441438331040043900712839660916) }, 
      { SC_(5.3133392333984375), SC_(7.48609161376953125), SC_(0.823473036289215087890625), SC_(0.0002448421887799069164783058119388673365113), SC_(0.1484989909904823805105688478038566749789e-6), SC_(0.9993938586305396597567283373799999220442), SC_(0.000606141369460340243271662620000077955776) }, 
      { SC_(5.32825565338134765625), SC_(9.48925113677978515625), SC_(0.399842679500579833984375), SC_(0.5558334880486632092145077500670499378253e-4), SC_(0.3099026708833177991802733018278187205757e-4), SC_(0.6420356621518148088910575702085008420194), SC_(0.3579643378481851911089424297914991579806) }, 
      { SC_(5.38342380523681640625), SC_(5.46591949462890625), SC_(0.234856426715850830078125), SC_(0.2876982963882477178219291418965025467942e-4), SC_(0.000815698436194295078436142561453029825515), SC_(0.03406857403983270642026461168940508102528), SC_(0.9659314259601672935797353883105949189747) }, 
      { SC_(5.39126491546630859375), SC_(2.4272365570068359375), SC_(0.725866377353668212890625), SC_(0.008683720041014507910551871470199769065214), SC_(0.007193257330485942051311909270426548331568), SC_(0.5469378608929676277565394286002881432929), SC_(0.4530621391070323722434605713997118567071) }, 
      { SC_(5.465931415557861328125), SC_(9.807567596435546875), SC_(0.9597480297088623046875), SC_(0.6431648001014576477154896197695193473587e-4), SC_(0.1789219496036074391589648704691992369815e-14), SC_(0.9999999999721810102837708906490786751809), SC_(0.2781898971622910935092132481910150311693e-10) }, 
      { SC_(5.468057155609130859375), SC_(2.2655131816864013671875), SC_(0.48930370807647705078125), SC_(0.001871642938552319299674466742226126502582), SC_(0.01733223127527205609508609633223755438495), SC_(0.09746173702830086547691505798040182038061), SC_(0.9025382629716991345230849420195981796194) }, 
      { SC_(5.468814849853515625), SC_(9.92881298065185546875), SC_(0.01661893166601657867431640625), SC_(0.2993116261844011871464007898536706379411e-10), SC_(0.6064040790357035223955910662525402005269e-4), SC_(0.4935842102593868940001099585992427277558e-6), SC_(0.9999995064157897406131059998900414007573) }, 
      { SC_(5.470088481903076171875), SC_(7.18470001220703125), SC_(0.354702651500701904296875), SC_(0.7522943494979851248771899989221510419832e-4), SC_(0.0001776599340377416880875196678636773778406), SC_(0.2974796261740249308890494795027918261323), SC_(0.7025203738259750691109505204972081738677) }, 
      { SC_(5.47215557098388671875), SC_(1.58057582378387451171875), SC_(0.14022982120513916015625), SC_(0.3642299055273451763822101284502197068957e-5), SC_(0.05612749713893154315877918909803149124144), SC_(0.648890988449901564972340804647948039446e-4), SC_(0.9999351109011550098435027659195352051961) }, 
      { SC_(5.478708744049072265625), SC_(5.983688831329345703125), SC_(0.707350790500640869140625), SC_(0.0005129051868782907461348257012199154669064), SC_(0.2996461749785069619780759850324969431113e-4), SC_(0.94480330779810893150911396240921123086), SC_(0.05519669220189106849088603759078876914003) }, 
      { SC_(5.4972362518310546875), SC_(7.32798671722412109375), SC_(0.1690731346607208251953125), SC_(0.395646175722789032773731717782935160579e-5), SC_(0.0002227238071593519307759729943398251386571), SC_(0.01745393093160613978491169649203658135884), SC_(0.9825460690683938602150883035079634186412) }, 
      { SC_(5.4986019134521484375), SC_(0.080939121544361114501953125), SC_(0.26599407196044921875), SC_(0.0001584399812540482827902354543983044775523), SC_(10.3966374077173660500706378630201086814), SC_(0.1523930868461937929770993344486012250574e-4), SC_(0.9999847606913153806207022900665551398775) }, 
      { SC_(5.501563549041748046875), SC_(3.8861515522003173828125), SC_(0.4050408899784088134765625), SC_(0.0003819857495720349371521898040355488820372), SC_(0.002549287934146625034175916683548045521723), SC_(0.1303139149693595986058107451337090073624), SC_(0.8696860850306404013941892548662909926376) }, 
      { SC_(5.611998081207275390625), SC_(1.31561565399169921875), SC_(0.7447183132171630859375), SC_(0.02469078365129627649518641084457527045565), SC_(0.06465188932241603191786464431699747678648), SC_(0.2763604762369394909566384799216558036677), SC_(0.7236395237630605090433615200783441963323) }, 
      { SC_(5.67821598052978515625), SC_(5.27371501922607421875), SC_(0.18359279632568359375), SC_(0.5665388729232756936555168900417273709892e-5), SC_(0.000783147701984843744884229617492987761363), SC_(0.007182168749385407638845694447598451682276), SC_(0.9928178312506145923611543055524015483177) }, 
      { SC_(5.688236236572265625), SC_(3.9490821361541748046875), SC_(0.1948448121547698974609375), SC_(0.9412317037793486494300223033774957695536e-5), SC_(0.002470764033778216404698262558206944877859), SC_(0.003795019267358433296434500940481918167281), SC_(0.9962049807326415667035654990595180818327) }, 
      { SC_(5.75208568572998046875), SC_(7.575036525726318359375), SC_(0.3402856886386871337890625), SC_(0.4004022292041907268055108169083497632045e-4), SC_(0.0001157898384556698686233847711972296434424), SC_(0.2569480019890627562696190305054358636918), SC_(0.7430519980109372437303809694945641363082) }, 
      { SC_(5.76209354400634765625), SC_(9.24875926971435546875), SC_(0.959295451641082763671875), SC_(0.6173008350602500429968540750924588254443e-4), SC_(0.1251681535683934257773386938777515922263e-13), SC_(0.9999999997972331375012691181445907177689), SC_(0.2027668624987308818554092822311101719629e-9) }, 
      { SC_(5.76721477508544921875), SC_(5.14519596099853515625), SC_(0.561601340770721435546875), SC_(0.0004768679019348165820520953691572702957474), SC_(0.0003445900117969779947317874243624370759775), SC_(0.5805141005562381277085180498032127707226), SC_(0.4194858994437618722914819501967872292774) }, 
      { SC_(5.78525066375732421875), SC_(2.816273212432861328125), SC_(0.4868429601192474365234375), SC_(0.001022514127460012365575554588442412942307), SC_(0.007163659735130946197916752551403139506269), SC_(0.1249074530572433176288387129976543595438), SC_(0.8750925469427566823711612870023456404562) }, 
      { SC_(5.79704570770263671875), SC_(6.2738437652587890625), SC_(0.2638765275478363037109375), SC_(0.2033669687571857443469676318644859402734e-4), SC_(0.0003255894164846468170839711889697829680688), SC_(0.05878913470326249955669540175038685846538), SC_(0.9412108652967375004433045982496131415346) }, 
      { SC_(5.82986354827880859375), SC_(7.4733123779296875), SC_(0.77891981601715087890625), SC_(0.0001540516476369544702283461639644614078878), SC_(0.5978413252112784799537532127201433213468e-6), SC_(0.9961342172597961996784500158889499031102), SC_(0.003865782740203800321549984111050096889845) }, 
      { SC_(5.84069347381591796875), SC_(9.07108592987060546875), SC_(0.7943050861358642578125), SC_(0.6246793719256288926463575846509533464182e-4), SC_(0.2420570419142975289039450578361782348328e-7), SC_(0.9996126600390160898957505241077794745772), SC_(0.00038733996098391010424947589222052542284) }, 
      { SC_(5.85264110565185546875), SC_(5.9450359344482421875), SC_(0.16763903200626373291015625), SC_(0.2312011535213500519062391082195887032089e-5), SC_(0.0004166071694196365658388405580102548290108), SC_(0.005518991825448743617573046688848076390891), SC_(0.9944810081745512563824269533111519236091) }, 
      { SC_(5.85267734527587890625), SC_(8.0817546844482421875), SC_(0.12999321520328521728515625), SC_(0.4875941763569227102281811521953287916227e-6), SC_(0.0001053997303659329519571990989460864237583), SC_(0.004604839894336782569599343666449126194324), SC_(0.9953951601056632174304006563335508738057) }, 
      { SC_(5.8704471588134765625), SC_(4.766380786895751953125), SC_(0.408790290355682373046875), SC_(0.000183039336583886722552829935280521570549), SC_(0.0008697245838107142113948850238435599109866), SC_(0.1738655106220578205986291433696595623871), SC_(0.8261344893779421794013708566303404376129) }, 
      { SC_(5.895074367523193359375), SC_(2.3476560115814208984375), SC_(0.77393972873687744140625), SC_(0.008849809390509587104924332452299627938885), SC_(0.005769344900257303225415604228365707035702), SC_(0.6053571372523864764521348654725133998354), SC_(0.3946428627476135235478651345274866001646) }, 
      { SC_(5.94356250762939453125), SC_(5.86765003204345703125), SC_(0.798126041889190673828125), SC_(0.0004090612339484864563523227712661362776423), SC_(0.5644823023473088776454989574739408604243e-5), SC_(0.9863883757457278592097319147584814159604), SC_(0.01361162425427214079026808524151858403958) }, 
      { SC_(5.948960781097412109375), SC_(4.49556064605712890625), SC_(0.447639644145965576171875), SC_(0.0002700341864380981596254012520017276513658), SC_(0.00100499145035928803923405937885184819063), SC_(0.211787260306679764015818383607533634228), SC_(0.788212739693320235984181616392466365772) }, 
      { SC_(5.985236644744873046875), SC_(9.74754428863525390625), SC_(0.80915629863739013671875), SC_(0.3829568632937395517134588176621945016114e-4), SC_(0.3887729017336306001575351727343233323962e-8), SC_(0.9998984915860576125829581768310884813618), SC_(0.000101508413942387417041823168911518638216) }, 
      { SC_(6.0198192596435546875), SC_(4.719567775726318359375), SC_(0.2138513624668121337890625), SC_(0.7292791414814475580097339471646734414244e-5), SC_(0.000991607830004140358102294810108412761471), SC_(0.007300817777503176346887108734097373900272), SC_(0.9926991822224968236531128912659026260997) }, 
      { SC_(6.02170467376708984375), SC_(7.11880779266357421875), SC_(0.910573899745941162109375), SC_(0.0001640139041987004037611939267964047747315), SC_(0.320391004175329477850959734858286068738e-8), SC_(0.999980466000902606296528959726366294364), SC_(0.195339990973937034710402736337056359538e-4) }, 
      { SC_(6.028430938720703125), SC_(7.97364139556884765625), SC_(0.4505965411663055419921875), SC_(0.547118533860476854624248713660720342841e-4), SC_(0.4145666247650757664958164568564105015634e-4), SC_(0.5689164784890957631967505991947509935058), SC_(0.4310835215109042368032494008052490064942) }, 
      { SC_(6.07303905487060546875), SC_(1.2427265644073486328125), SC_(0.981111586093902587890625), SC_(0.08871800724726935136519838420485648794577), SC_(0.005499846280965325535303750423501902782025), SC_(0.9416262833952467139629001957305482173574), SC_(0.05837371660475328603709980426945178264255) }, 
      { SC_(6.073892116546630859375), SC_(2.8369390964508056640625), SC_(0.94008004665374755859375), SC_(0.006973056362982721812118452411551167256756), SC_(0.9551041995592583549966627651468540190036e-4), SC_(0.9864880076981859042283383286945326202714), SC_(0.01351199230181409577166167130546737972862) }, 
      { SC_(6.09866619110107421875), SC_(9.34250545501708984375), SC_(0.54990518093109130859375), SC_(0.37521707652660633893856479905611605112e-4), SC_(0.4538128701712859882289953397507614692072e-5), SC_(0.8921030347460927965239954559546194255979), SC_(0.1078969652539072034760045440453805744021) }, 
      { SC_(6.109586238861083984375), SC_(0.788423717021942138671875), SC_(0.830845534801483154296875), SC_(0.06971309332227915384675522485815847011363), SC_(0.2167567222575425930236365461510368903611), SC_(0.2433523168267420719328373329538551507109), SC_(0.7566476831732579280671626670461448492891) }, 
      { SC_(6.1346073150634765625), SC_(3.122300624847412109375), SC_(0.996461689472198486328125), SC_(0.00484066794663223826927430657090373872699), SC_(0.7016931325081611131180507061929345622755e-8), SC_(0.9999985504229517786190114582490284162053), SC_(0.1449577048221380988541750971583794707043e-5) }, 
      { SC_(6.16044712066650390625), SC_(7.788977146148681640625), SC_(0.16241228580474853515625), SC_(0.8097773820784406784677397135052446377968e-6), SC_(0.9489314774293313389967285889931780653399e-4), SC_(0.008461365010742065776928850715146086380278), SC_(0.9915386349892579342230711492848539136197) }, 
      { SC_(6.17090892791748046875), SC_(4.727691173553466796875), SC_(0.780249416828155517578125), SC_(0.0008450307020461161334076423047134661126446), SC_(0.5919429472835175851780120360961862333289e-4), SC_(0.9345358788581289135029569061840505916932), SC_(0.0654641211418710864970430938159494083068) }, 
      { SC_(6.17666339874267578125), SC_(4.725252628326416015625), SC_(0.550201356410980224609375), SC_(0.0004034965830925189786684776780896894155788), SC_(0.0004995620465338476110441859828918623934526), SC_(0.4468110594983877387705804134754255636294), SC_(0.5531889405016122612294195865245744363706) }, 
      { SC_(6.22055149078369140625), SC_(4.38666820526123046875), SC_(0.2769952714443206787109375), SC_(0.2190221160746947912789537394610699543336e-4), SC_(0.00118216792487464235893625755235932603352), SC_(0.01819014602543036113713545063775616622186), SC_(0.9818098539745696388628645493622438337781) }, 
      { SC_(6.224750995635986328125), SC_(7.796894073486328125), SC_(0.408778965473175048828125), SC_(0.3644746408101077539285537284719144866657e-4), SC_(0.5365927483039532213731433121978635884094e-4), SC_(0.4044921003838160105214325212152689949831), SC_(0.5955078996161839894785674787847310050169) }, 
      { SC_(6.240601062774658203125), SC_(1.7015228271484375), SC_(0.490915000438690185546875), SC_(0.001283549666248419861847987302315514477005), SC_(0.03556063909387691471617600415284765169506), SC_(0.03483723510931370963061038472122987816086), SC_(0.9651627648906862903693896152787701218391) }, 
      { SC_(6.256186008453369140625), SC_(8.1576900482177734375), SC_(0.37856256961822509765625), SC_(0.2428460755640741037984643404295494849243e-4), SC_(0.4616313110406550024912798168543388234751e-4), SC_(0.3447180565077969182172822581746660399627), SC_(0.6552819434922030817827177418253339600373) }, 
      { SC_(6.2797336578369140625), SC_(5.15023708343505859375), SC_(0.660153448581695556640625), SC_(0.0004493896893273164589467537807214707448801), SC_(0.0001345284914090084936750442425624176990581), SC_(0.7696107162832862726456555531981460239943), SC_(0.2303892837167137273543444468018539760057) }, 
      { SC_(6.323592662811279296875), SC_(3.081670284271240234375), SC_(0.01200087927281856536865234375), SC_(0.1104958718826698957670958487109201575358e-12), SC_(0.004687203315970652428363513949580494631475), SC_(0.235739447238343160070121438963334399884e-10), SC_(0.9999999999764260552761656839929878561037) }, 
      { SC_(6.35786724090576171875), SC_(7.777940273284912109375), SC_(0.96864354610443115234375), SC_(0.8140834911944604444150515499266719071543e-4), SC_(0.2229178111222996398351353580134891251161e-12), SC_(0.9999999972617328207354268936434040788255), SC_(0.2738267179264573106356595921174518341383e-8) }, 
      { SC_(6.377090930938720703125), SC_(2.6817638874053955078125), SC_(0.870199739933013916015625), SC_(0.006771554999682028045883911653423472108222), SC_(0.0009251226670092557743136738332322580855926), SC_(0.879802337180770137921327972238168347567), SC_(0.120197662819229862078672027761831652433) }, 
      { SC_(6.38530731201171875), SC_(6.333632946014404296875), SC_(0.81430339813232421875), SC_(0.0002112091858735835713096682335307382005792), SC_(0.1452345889466053880044225642172814843068e-5), SC_(0.9931706224561371191063201020763636759324), SC_(0.006829377543862880893679897923636324067582) }, 
      { SC_(6.44318103790283203125), SC_(5.438054561614990234375), SC_(0.3936505019664764404296875), SC_(0.6255819501168566846253981209421629941384e-4), SC_(0.0003498637933802053330113093394545046457263), SC_(0.1516849168387251809041138617445120585855), SC_(0.8483150831612748190958861382554879414145) }, 
      { SC_(6.44442844390869140625), SC_(9.49714565277099609375), SC_(0.96489202976226806640625), SC_(0.2773016038921772405670621796834280328608e-4), SC_(0.1354073952548909618029962033853510940567e-14), SC_(0.9999999999511696314237947142834072258091), SC_(0.4883036857620528571659277419090857535681e-10) }, 
      { SC_(6.447645664215087890625), SC_(2.336754322052001953125), SC_(0.757764339447021484375), SC_(0.006316421227802708782594495130002396224912), SC_(0.005957192492726239455331830246391959110865), SC_(0.5146341877484550602109306173242190533733), SC_(0.4853658122515449397890693826757809466267) }, 
      { SC_(6.46312999725341796875), SC_(7.93974971771240234375), SC_(0.11129163205623626708984375), SC_(0.5286811198169437627825863273658875167104e-7), SC_(0.6725419606003588170913281043273418460222e-4), SC_(0.000785476422602219374625891610916647657133), SC_(0.9992145235773977806253741083890833523429) }, 
      { SC_(6.47617626190185546875), SC_(9.34521961212158203125), SC_(0.9649698734283447265625), SC_(0.29229025740055908947093280782409066835e-4), SC_(0.2241186087767477278866206572701576853352e-14), SC_(0.9999999999233232709318711782271520796889), SC_(0.7667672906812882177284792031105463912527e-10) }, 
      { SC_(6.47745990753173828125), SC_(4.93326854705810546875), SC_(0.352827131748199462890625), SC_(0.4406191810159834484838479340184519644862e-4), SC_(0.00058076658157011072496223240072883653155), SC_(0.07051841925384149778813434548370668741733), SC_(0.9294815807461585022118656545162933125827) }, 
      { SC_(6.48991489410400390625), SC_(6.431809902191162109375), SC_(0.6274216175079345703125), SC_(0.0001493888854694277755554725824694740537974), SC_(0.3387984056691845892340179572218397177203e-4), SC_(0.8151357228281308696468735407018457497519), SC_(0.1848642771718691303531264592981542502481) }, 
      { SC_(6.491155147552490234375), SC_(2.5829589366912841796875), SC_(0.351017296314239501953125), SC_(0.972122655873300236099137013818846101213e-4), SC_(0.00836466235469617489128093277611446656977), SC_(0.011488265892560937491862742626593692258), SC_(0.988511734107439062508137257373406307742) }, 
      { SC_(6.537573337554931640625), SC_(0.0159790404140949249267578125), SC_(0.52988898754119873046875), SC_(0.004459901273624707455701078000286294950602), SC_(60.25700323858915194984149591110216676652), SC_(0.7400917669844123274167021004481073457942e-4), SC_(0.9999259908233015587672583297899551892654) }, 
      { SC_(6.540790557861328125), SC_(5.298419475555419921875), SC_(0.221111953258514404296875), SC_(0.3186484915952283068018806438262978737879e-5), SC_(0.0004328900544161854711639615214862671448564), SC_(0.007307168876437299938314495480737198026881), SC_(0.9926928311235627000616855045192628019731) }, 
      { SC_(6.54445743560791015625), SC_(9.94505405426025390625), SC_(0.8208587169647216796875), SC_(0.1983522929068780213943657876335029984179e-4), SC_(0.1410534037286516407874567086705542615503e-8), SC_(0.9999288924913821151829756397807491401843), SC_(0.7110750861788481702436021925085981570528e-4) }, 
      { SC_(6.55098056793212890625), SC_(7.107038974761962890625), SC_(0.11963522434234619140625), SC_(0.7141550171429301646252068655795948161696e-7), SC_(0.0001081192884300751036332330933497820745751), SC_(0.0006600890752990949255087244370377626157914), SC_(0.9993399109247009050744912755629622373842) }, 
      { SC_(6.554779052734375), SC_(1.73865163326263427734375), SC_(0.067688621580600738525390625), SC_(0.3150010434333768992043610637861470883639e-8), SC_(0.03179626425619222630425761057957681604674), SC_(0.9906856028388037561619010168933596001114e-7), SC_(0.999999900931439716119624383809898310664) }, 
      { SC_(6.55740642547607421875), SC_(7.97928619384765625), SC_(0.0451550371944904327392578125), SC_(0.1740824245850233906723349767386861568819e-9), SC_(0.6064579297251721062070065593814518991212e-4), SC_(0.2870469926340107967556142305108257777667e-5), SC_(0.9999971295300736598920324438576948917422) }, 
      { SC_(6.56859874725341796875), SC_(1.80818712711334228515625), SC_(0.655814349651336669921875), SC_(0.00481410590769769513641878998826079156272), SC_(0.02315357021106995427223910620346657575409), SC_(0.1721310661369966178498875061515334984965), SC_(0.8278689338630033821501124938484665015035) }, 
      { SC_(6.596052646636962890625), SC_(4.22218418121337890625), SC_(0.6225128173828125), SC_(0.0005942540918445236446174054583428412190632), SC_(0.0005588702834024244109266467857983517564144), SC_(0.5153425810786982941722724618736814055441), SC_(0.4846574189213017058277275381263185944559) }, 
      { SC_(6.619447231292724609375), SC_(6.623002529144287109375), SC_(0.9874608516693115234375), SC_(0.0001448613606327680771293057707253813498468), SC_(0.3606187298415906314212951222085277816987e-13), SC_(0.9999999997510594073004689522058484504929), SC_(0.2489405926995310477941515495071343340136e-9) }, 
      { SC_(6.620095729827880859375), SC_(2.0595557689666748046875), SC_(0.99011099338531494140625), SC_(0.01792585392986322191907612725451484921732), SC_(0.3474239219214770349170475434407381096773e-4), SC_(0.9980656325898553537849344504305791816327), SC_(0.001934367410144646215065549569420818367322) }, 
      { SC_(6.663388729095458984375), SC_(7.377908229827880859375), SC_(0.720521390438079833984375), SC_(0.8007169645812952274590828328872821635845e-4), SC_(0.2300230779607556044469375366787239511613e-5), SC_(0.9720750642027742851927199900455611967021), SC_(0.02792493579722571480728000995443880329787) }, 
      { SC_(6.665279388427734375), SC_(1.85475981235504150390625), SC_(0.72698199748992919921875), SC_(0.007597803257792932044560028750339725170657), SC_(0.01751899307082825490193223630968329387232), SC_(0.3024988998750232520748970909758637325599), SC_(0.6975011001249767479251029090241362674401) }, 
      { SC_(6.678327083587646484375), SC_(3.0382525920867919921875), SC_(0.900193154811859130859375), SC_(0.004084563173283332876904098344086828950967), SC_(0.0001934659010534569614190167282520399168104), SC_(0.9547768615659889112905635474068568681788), SC_(0.04522313843401108870943645259314313182122) }, 
      { SC_(6.691753387451171875), SC_(0.0831444561481475830078125), SC_(0.74996602535247802734375), SC_(0.06002877611484809279352962363437042288415), SC_(9.83879569516026976341611721919094487651), SC_(0.006064232807546235967998234374563736799127), SC_(0.9939357671924537640320017656254362632009) }, 
      { SC_(6.71808147430419921875), SC_(6.137441158294677734375), SC_(0.878442823886871337890625), SC_(0.0001948989890721855758415393352238714792343), SC_(0.2100782171962141141351857465287490862373e-6), SC_(0.9989232780407656278409277498198737768904), SC_(0.001076721959234372159072250180126223109638) }, 
      { SC_(6.753320217132568359375), SC_(5.10108852386474609375), SC_(0.907373964786529541015625), SC_(0.0004548121022163218323715604931871662213393), SC_(0.6627065335161819350147039109358210509099e-6), SC_(0.9985450204472665742770642914409434544401), SC_(0.001454979552733425722935708559056545559927) }, 
      { SC_(6.76122283935546875), SC_(4.74718379974365234375), SC_(0.8767697811126708984375), SC_(0.0006236255605425981702466465338452764240241), SC_(0.5506674880390253785461272704975379427893e-5), SC_(0.9912471900653955261005337777697249528805), SC_(0.008752809934604473899466222230275047119451) }, 
      { SC_(6.787351131439208984375), SC_(3.987385272979736328125), SC_(0.051311306655406951904296875), SC_(0.2263341470343213042556050514890389746087e-9), SC_(0.001337934496954320151253061343925177856992), SC_(0.1691668084359316169220118295376123033183e-6), SC_(0.9999998308331915640683830779881704623877) }, 
      { SC_(6.79016780853271484375), SC_(0.083242706954479217529296875), SC_(0.967698156833648681640625), SC_(0.9694353899530785108950378096838519784051), SC_(8.90263069332296250189285125624440893603), SC_(0.09819984811440522499244705602865577719655), SC_(0.9018001518855947750075529439713442228035) }, 
      { SC_(6.79135608673095703125), SC_(2.990518093109130859375), SC_(0.492492735385894775390625), SC_(0.0003964694805387206342822820417806719744121), SC_(0.003956558292917519710400484501858392983759), SC_(0.09107901469324411618571807069331236646202), SC_(0.908920985306755883814281929306687633538) }, 
      { SC_(6.79702663421630859375), SC_(0.0281843245029449462890625), SC_(0.119085781276226043701171875), SC_(0.8563027964350100746120589029270175690302e-7), SC_(33.16223528650126684883691411032176222281), SC_(0.258216247133514655175625573951610590202e-8), SC_(0.9999999974178375286648534482437442604839) }, 
      { SC_(6.79727935791015625), SC_(2.919607639312744140625), SC_(0.51082050800323486328125), SC_(0.0004982662578613548749609028981125925701161), SC_(0.004271086637028338485563831779540183163461), SC_(0.1044725078731836819179107920520890604277), SC_(0.8955274921268163180820892079479109395723) }, 
      { SC_(6.819718837738037109375), SC_(5.347210407257080078125), SC_(0.592864573001861572265625), SC_(0.0002037294837004967262131999503684229870496), SC_(0.0001478354617267542408437841367325097504356), SC_(0.5794931671953462542349712831375968740182), SC_(0.4205068328046537457650287168624031259818) }, 
      { SC_(6.83363246917724609375), SC_(9.137195587158203125), SC_(0.95949649810791015625), SC_(0.2369788592965004149002448285217976576245e-4), SC_(0.1665088327143394154765268068373658698223e-13), SC_(0.9999999992973684104495815306100862840383), SC_(0.7026315895504184693899137159617450099411e-9) }, 
      { SC_(6.867754459381103515625), SC_(3.1250798702239990234375), SC_(0.36325013637542724609375), SC_(0.6203661198694198574126164898253317891701e-4), SC_(0.00348674837643487206359831708722239906418), SC_(0.01748108498805682461808251945878710508387), SC_(0.9825189150119431753819174805412128949161) }, 
      { SC_(6.892145633697509765625), SC_(7.161006927490234375), SC_(0.2218245565891265869140625), SC_(0.1216112669859512228309639649876978991575e-5), SC_(0.7908698885556172917686681824361475363894e-4), SC_(0.01514403113651260601610566559104294775594), SC_(0.9848559688634873939838943344089570522441) }, 
      { SC_(6.948286533355712890625), SC_(1.25182759761810302734375), SC_(0.085607238113880157470703125), SC_(0.5399926549050818832745335399732396448216e-8), SC_(0.07829755864506759027751142878742868719519), SC_(0.689667247623147050880298500600686619879e-7), SC_(0.9999999310332752376852949119701499399313) }, 
      { SC_(6.951404571533203125), SC_(4.90619182586669921875), SC_(0.886009514331817626953125), SC_(0.0004833875818969477330119739806402819194932), SC_(0.2673469825328588143007370610100345324391e-5), SC_(0.9944997242304118105632550893536691644309), SC_(0.005500275769588189436744910646330835569098) }, 
      { SC_(6.959493160247802734375), SC_(6.345019817352294921875), SC_(0.811599314212799072265625), SC_(0.0001391719799822673160192635734978564137402), SC_(0.1389908703110252311310439635391308662022e-5), SC_(0.990111767022273639082379461480065148548), SC_(0.009888232977726360917620538519934851451978) }, 
      { SC_(6.98105525970458984375), SC_(8.2285919189453125), SC_(0.726681768894195556640625), SC_(0.358860120292934012210787874245941276435e-4), SC_(0.539750025054115336809104017474000228888e-6), SC_(0.9851821898949209585026201430427462828854), SC_(0.01481781010507904149737985695725371711456) }, 
      { SC_(6.987458705902099609375), SC_(0.6544506549835205078125), SC_(0.544101715087890625), SC_(0.00255236796826421389829333101784568275645), SC_(0.3893302582596082421233475394052227948305), SC_(0.006513092945284232663466408184842247487152), SC_(0.9934869070547157673365335918151577525128) }, 
      { SC_(6.990767002105712890625), SC_(4.1266651153564453125), SC_(0.136154949665069580078125), SC_(0.8509570094592051632120030799055586044614e-7), SC_(0.001042392270700033540215299867916109587881), SC_(0.8162834387445993433108651261407316802189e-4), SC_(0.999918371656125540065668913487385926832) }, 
      { SC_(6.99887847900390625), SC_(0.72180259227752685546875), SC_(0.811892807483673095703125), SC_(0.04759409109197475420284257208053802740416), SC_(0.26735872603501418455415718530948691939), SC_(0.1511149877182550244731556545144739197359), SC_(0.8488850122817449755268443454855260802641) }, 
      { SC_(7.01098728179931640625), SC_(1.2064893245697021484375), SC_(0.71849811077117919921875), SC_(0.01141051807569613948274387844171372601625), SC_(0.07453681229604968222966128715013259531798), SC_(0.1327617510205670526079801939669259556534), SC_(0.8672382489794329473920198060330740443466) }, 
      { SC_(7.060461521148681640625), SC_(7.972798824310302734375), SC_(0.07605908811092376708984375), SC_(0.1105417045582768436543516139755080655616e-8), SC_(0.4038342593406057222322411969713463794255e-4), SC_(0.2737228856197907674660948881008162338742e-4), SC_(0.9999726277114380209232533905111899183766) }, 
      { SC_(7.092816829681396484375), SC_(6.49780750274658203125), SC_(0.977004349231719970703125), SC_(0.0001138654107702286025902918767506243865619), SC_(0.3078277092499097921568278954410634084274e-11), SC_(0.9999999729656531473670529426938203015809), SC_(0.270343468526329470573061796984191399153e-7) }, 
      { SC_(7.093648433685302734375), SC_(9.20874786376953125), SC_(0.1125532686710357666015625), SC_(0.1127247874682365774618362041688104065838e-7), SC_(0.1804943361730357390176930848936304945356e-4), SC_(0.0006241438561080830523830691629056853098608), SC_(0.9993758561438919169476169308370943146901) }, 
      { SC_(7.112158298492431640625), SC_(1.6755578517913818359375), SC_(0.4509786069393157958984375), SC_(0.0003470370726970068963129446114038543725303), SC_(0.03098054975934099904554832275111389222169), SC_(0.01107768289200303248371804203486482210548), SC_(0.9889223171079969675162819579651351778945) }, 
      { SC_(7.12694454193115234375), SC_(7.469042301177978515625), SC_(0.5844237804412841796875), SC_(0.4155551272115984710091336234787355102348e-4), SC_(0.1257874028868045725875405045741392266017e-4), SC_(0.7676380555875788106999147989085951911092), SC_(0.2323619444124211893000852010914048088908) }, 
      { SC_(7.15037059783935546875), SC_(0.986990451812744140625), SC_(0.533979713916778564453125), SC_(0.00158845372948739077560242701045589083769), SC_(0.14311838754292304807602821209827057194), SC_(0.01097704652744875215516137390918187297088), SC_(0.9890229534725512478448386260908181270291) }, 
      { SC_(7.18358898162841796875), SC_(2.4557473659515380859375), SC_(0.8219211101531982421875), SC_(0.005461496517838803358026008965609409147495), SC_(0.002629990237438906047998584387626745539065), SC_(0.6749682330353586954545154159520809871145), SC_(0.3250317669646413045454845840479190128855) }, 
      { SC_(7.212275028228759765625), SC_(2.307643890380859375), SC_(0.52741873264312744140625), SC_(0.000610495533847542669250561106808892299211), SC_(0.009500609068047214932311072783920041330384), SC_(0.06037871804166081263451450329915941002008), SC_(0.9396212819583391873654854967008405899799) }, 
      { SC_(7.217580318450927734375), SC_(4.07501888275146484375), SC_(0.929392993450164794921875), SC_(0.0009848793708889196757885499297219982034819), SC_(0.3486171102111599712165976265452471839705e-5), SC_(0.9964727917415161826116273919413857295011), SC_(0.003527208258483817388372608058614270498922) }, 
      { SC_(7.224395751953125), SC_(7.047237396240234375), SC_(0.620397984981536865234375), SC_(0.5501531517876683386487294859612119878539e-4), SC_(0.1334553533493679945702771069903591171214e-4), SC_(0.8047780968982890275696870894916419064565), SC_(0.1952219031017109724303129105083580935435) }, 
      { SC_(7.302487850189208984375), SC_(7.729009151458740234375), SC_(0.79361820220947265625), SC_(0.3932560973357712255209426383757206173476e-4), SC_(0.1852201520392421050499364132242393277856e-6), SC_(0.9953121675101370073187828064993184060536), SC_(0.004687832489862992681217193500681593946427) }, 
      { SC_(7.303308963775634765625), SC_(1.00738489627838134765625), SC_(0.47669041156768798828125), SC_(0.0006092379525709470223255393358168500863711), SC_(0.1336843847084377055200319084010300747278), SC_(0.004536611199392684235640118777031068776871), SC_(0.9954633888006073157643598812229689312231) }, 
      { SC_(7.317224025726318359375), SC_(1.298465251922607421875), SC_(0.351724326610565185546875), SC_(0.5847821529837166579038500339420843139136e-4), SC_(0.06596731334899948271834055400647868266238), SC_(0.0008856874550519225926372267469926344767322), SC_(0.9991143125449480774073627732530073655233) }, 
      { SC_(7.37858104705810546875), SC_(1.6669826507568359375), SC_(0.69910681247711181640625), SC_(0.005085602442056688978479741210636033233161), SC_(0.02494707592816126113859634111533237524111), SC_(0.1693356276575002743788461229236055191358), SC_(0.8306643723424997256211538770763944808642) }, 
      { SC_(7.38426876068115234375), SC_(7.55924701690673828125), SC_(0.94479274749755859375), SC_(0.418970033279825102364181380181290383302e-4), SC_(0.2976051424501981941337694743479462779697e-10), SC_(0.9999992896748993620060678317223502134124), SC_(0.7103251006379939321682776497865875988898e-6) }, 
      { SC_(7.43132495880126953125), SC_(4.747586727142333984375), SC_(0.0540447235107421875), SC_(0.4288015661720002501156848942265856450785e-10), SC_(0.0004374143764045996688086115094156086568374), SC_(0.980309626905213935390739909023425106585e-7), SC_(0.9999999019690373094786064609260090976575) }, 
      { SC_(7.44074249267578125), SC_(6.898012638092041015625), SC_(0.54705417156219482421875), SC_(0.3816298085985872855213856251096939919413e-4), SC_(0.2757590502463681974259864686378649243485e-4), SC_(0.5805236937983980973793258337317417787563), SC_(0.4194763062016019026206741662682582212437) }, 
      { SC_(7.446928501129150390625), SC_(6.234355449676513671875), SC_(0.3609246313571929931640625), SC_(0.9493874615036504272226332847105584077804e-5), SC_(0.0001018514586158487090275577552188613159799), SC_(0.08526513271418431088151211558569820541137), SC_(0.9147348672858156891184878844143017945886) }, 
      { SC_(7.481516361236572265625), SC_(9.8837947845458984375), SC_(0.22349761426448822021484375), SC_(0.2657679285737144644540268207309200379989e-6), SC_(0.836007787899585947471855194405070745678e-5), SC_(0.03081065144249285794629007416976906125847), SC_(0.9691893485575071420537099258302309387415) }, 
      { SC_(7.512670993804931640625), SC_(8.212459564208984375), SC_(0.13308273255825042724609375), SC_(0.1429458681024921308105585489081111732153e-7), SC_(0.2409585135313748006047620884055888318854e-4), SC_(0.0005928867807707763590494897734381225740102), SC_(0.999407113219229223640950510226561877426) }, 
      { SC_(7.537291049957275390625), SC_(5.61557483673095703125), SC_(0.18165481090545654296875), SC_(0.155240769626332981220316326664090076153e-6), SC_(0.0001799649023801918793973626399476027866552), SC_(0.0008618734524167496429462706830962244276752), SC_(0.9991381265475832503570537293169037755723) }, 
      { SC_(7.54686641693115234375), SC_(8.07530975341796875), SC_(0.1132812201976776123046875), SC_(0.4590899486883971268598641770957837870915e-8), SC_(0.2579378130440652604543914048256413093774e-4), SC_(0.0001779530681471107316829395126774399397122), SC_(0.9998220469318528892683170604873225600603) }, 
      { SC_(7.572002410888671875), SC_(3.9232044219970703125), SC_(0.1739477813243865966796875), SC_(0.1438815704806215113502545781833438315414e-6), SC_(0.0009981486208601692648075276147256265037424), SC_(0.0001441276681236186901235618332383071838242), SC_(0.9998558723318763813098764381667616928162) }, 
      { SC_(7.577401638031005859375), SC_(7.406472682952880859375), SC_(0.0532472543418407440185546875), SC_(0.2164321928037203308205113091366658152472e-10), SC_(0.406823122402614949714684413864444310794e-4), SC_(0.5320053500952252146658006615926664354521e-6), SC_(0.9999994679946499047747853341993384073336) }, 
      { SC_(7.655000209808349609375), SC_(0.1489169895648956298828125), SC_(0.955022037029266357421875), SC_(0.5903782952990584609175728796486190829028), SC_(4.077695895701669853525299927156058653355), SC_(0.1264714893429092780897647915199114482137), SC_(0.8735285106570907219102352084800885517863) }, 
      { SC_(7.655168056488037109375), SC_(0.51216423511505126953125), SC_(0.100828416645526885986328125), SC_(0.3221925205686958103897523865572258647332e-8), SC_(0.6204502530913738177128258100721243579337), SC_(0.5192882383241426407918256310444293265891e-8), SC_(0.9999999948071176167585735920817436895557) }, 
      { SC_(7.701597690582275390625), SC_(9.70944118499755859375), SC_(0.917201936244964599609375), SC_(0.7908703470851791586035857921502665905879e-5), SC_(0.1908803050632652959735883130660938397483e-11), SC_(0.9999997586453206939466993579886747171231), SC_(0.2413546793060533006420113252828768765451e-6) }, 
      { SC_(7.70285511016845703125), SC_(7.08257579803466796875), SC_(0.98838055133819580078125), SC_(0.4761397331451929725160505325773403281115e-4), SC_(0.2609521141069224555931607374250599751344e-14), SC_(0.9999999999451942159145440140475797331097), SC_(0.5480578408545598595242026689028528201668e-10) }, 
      { SC_(7.74910449981689453125), SC_(9.77002048492431640625), SC_(0.24360062181949615478515625), SC_(0.2809748748030878906134807236932900984484e-6), SC_(0.7039352803907688750989827476102766088975e-5), SC_(0.03838282753656349006974099376567772899157), SC_(0.9616171724634365099302590062343222710084) }, 
      { SC_(7.75712680816650390625), SC_(3.0361397266387939453125), SC_(0.38162028789520263671875), SC_(0.3174856064718994407322410576666859162998e-4), SC_(0.002836840704035496000125267546774354047992), SC_(0.01106765650909659492445444599671164724355), SC_(0.9889323434909034050755455540032883527564) }, 
      { SC_(7.78802204132080078125), SC_(4.589362621307373046875), SC_(0.831231176853179931640625), SC_(0.0004076191410116316877557812655012123322209), SC_(0.2290485203376599265477374882456806019621e-4), SC_(0.9467977339154922936386684541896058168939), SC_(0.05320226608450770636133154581039418310613) }, 
      { SC_(7.790517330169677734375), SC_(2.8658659458160400390625), SC_(0.53287231922149658203125), SC_(0.0002913507224419806408489878011213008592937), SC_(0.003321939283667330011209971439421244388538), SC_(0.08063308562262316945119654229806988727357), SC_(0.9193669143773768305488034577019301127264) }, 
      { SC_(7.79167270660400390625), SC_(3.563451290130615234375), SC_(0.18846313655376434326171875), SC_(0.1812064714686872881339510507069901994504e-6), SC_(0.00140763489898018370210968172475096931195), SC_(0.000128714589048228736124566940218461829085), SC_(0.9998712854109517712638754330597815381709) }, 
      { SC_(7.802274227142333984375), SC_(6.69285106658935546875), SC_(0.37867152690887451171875), SC_(0.6718585690226231195208825063099527425458e-5), SC_(0.5399933622825403546984905024026310319021e-4), SC_(0.1106524314064402252818337094384830270572), SC_(0.8893475685935597747181662905615169729428) }, 
      { SC_(7.802520751953125), SC_(8.77363872528076171875), SC_(0.3166187703609466552734375), SC_(0.1330342679961968055180712116906051557944e-5), SC_(0.1185649402350161416162403803303276288593e-4), SC_(0.1008841399857895822709543601350802069795), SC_(0.8991158600142104177290456398649197930205) }, 
      { SC_(7.805196285247802734375), SC_(4.489518642425537109375), SC_(0.905801355838775634765625), SC_(0.0004720268163961014124683042728426255969617), SC_(0.3213119926449902588446593212677240927796e-5), SC_(0.9932389521989391107715054281995243030034), SC_(0.006761047801060889228494571800475696996639) }, 
      { SC_(7.847393035888671875), SC_(2.1510903835296630859375), SC_(0.923387348651885986328125), SC_(0.009727310156023874504587039016931198473501), SC_(0.001290156224281512158060237873112935820442), SC_(0.8828990096500071119414151034196163945274), SC_(0.1171009903499928880585848965803836054726) }, 
      { SC_(7.9220733642578125), SC_(8.78430652618408203125), SC_(0.0421499200165271759033203125), SC_(0.1196659474916657441174232181172664977994e-11), SC_(0.1192125777470518177390527779850518935842e-4), SC_(0.1003802935403954907955230666168972539042e-6), SC_(0.9999998996197064596045092044769333831027) }, 
      { SC_(7.94284534454345703125), SC_(4.361175537109375), SC_(0.2081472575664520263671875), SC_(0.2447381840672728038845348751061544873532e-6), SC_(0.0005126801341235705432586525020297940373363), SC_(0.0004771423599838335979702373300859710852801), SC_(0.9995228576400161664020297626699140289147) }, 
      { SC_(7.94831371307373046875), SC_(9.1711788177490234375), SC_(0.3923812210559844970703125), SC_(0.2530260105355719165217670313076155257935e-5), SC_(0.6513945294708124573511723982377535946318e-5), SC_(0.279765882510569459790162118110313334035), SC_(0.720234117489430540209837881889686665965) }, 
      { SC_(7.951999664306640625), SC_(0.3644125163555145263671875), SC_(0.106742106378078460693359375), SC_(0.2514079809927098914743930066084480272919e-8), SC_(1.163872553827728040365603576864556041866), SC_(0.2160098883875358049792204171256175595443e-8), SC_(0.9999999978399011161246419502077958287438) }, 
      { SC_(7.96183872222900390625), SC_(5.828464031219482421875), SC_(0.505548000335693359375), SC_(0.3364063863780908268518215154033498267906e-4), SC_(0.8233741668099748129123207978729267108772e-4), SC_(0.2900603786236622956858055857862913448877), SC_(0.7099396213763377043141944142137086551123) }, 
      { SC_(8.0006847381591796875), SC_(6.601194858551025390625), SC_(0.2551696002483367919921875), SC_(0.5391071527078812155948221415853302646129e-6), SC_(0.5713861900140097483894570988207271285832e-4), SC_(0.009346886374602272786085468624166592310538), SC_(0.9906531136253977272139145313758334076895) }, 
      { SC_(8.00280475616455078125), SC_(2.970294475555419921875), SC_(0.03454263508319854736328125), SC_(0.2359504169396444613199059471054209015455e-12), SC_(0.002895905304882178682123245455032331606492), SC_(0.8147725566945623124011520221149926885917e-10), SC_(0.9999999999185227443305437687598847977885) }, 
      { SC_(8.0033054351806640625), SC_(4.727321147918701171875), SC_(0.632396042346954345703125), SC_(0.0001642708396456245002155889414278627744641), SC_(0.0001704845640035053813916014623246376461063), SC_(0.4907190081322873482172873252919517435757), SC_(0.5092809918677126517827126747080482564243) }, 
      { SC_(8.01014614105224609375), SC_(7.629314422607421875), SC_(0.473067760467529296875), SC_(0.9605457087484872556590712611960947795121e-5), SC_(0.1575447390683832403245260104323175510831e-4), SC_(0.3787651113733332962454132963174755174803), SC_(0.6212348886266667037545867036825244825197) }, 
      { SC_(8.0336437225341796875), SC_(3.969818115234375), SC_(0.652003467082977294921875), SC_(0.0003277010658982649912256687095595909171749), SC_(0.0004464549978352561288330040582897651460958), SC_(0.4233010387051179617160616217704047132117), SC_(0.5766989612948820382839383782295952867883) }, 
      { SC_(8.05489444732666015625), SC_(4.88401889801025390625), SC_(0.558312952518463134765625), SC_(0.8478675415917430662836332254098759449376e-4), SC_(0.0001920240588286705516762681867659938930953), SC_(0.3062985627042589881021782956541815347691), SC_(0.6937014372957410118978217043458184652309) }, 
      { SC_(8.1158046722412109375), SC_(1.99872875213623046875), SC_(0.398798644542694091796875), SC_(0.4573303308288477016458861099969373925785e-4), SC_(0.01350273035959787859233312717595515878367), SC_(0.003375514385460934169484510552831678035167), SC_(0.9966244856145390658305154894471683219648) }, 
      { SC_(8.14284801483154296875), SC_(2.998317241668701171875), SC_(0.149379074573516845703125), SC_(0.1745082435162042904917792022990606418957e-7), SC_(0.002654995292260473100026431771730405625634), SC_(0.65727836512545486164342292030456932044e-5), SC_(0.9999934272163487454513835657707969543068) }, 
      { SC_(8.14723682403564453125), SC_(1.35477006435394287109375), SC_(0.00291815050877630710601806640625), SC_(0.2730364832830778198135106898054911002111e-21), SC_(0.05048169106541300113169964851536344768866), SC_(0.5408623949013187678564421910413338717616e-20), SC_(0.9999999999999999999945913760509868123214) }, 
      { SC_(8.1730327606201171875), SC_(3.6318645477294921875), SC_(0.24421386420726776123046875), SC_(0.6371630232310130007593547981622454875113e-6), SC_(0.001110670951089779762717954365668587412204), SC_(0.0005733450652788258416132631006181126500942), SC_(0.9994266549347211741583867368993818873499) }, 
      { SC_(8.1754703521728515625), SC_(2.318886280059814453125), SC_(0.616083085536956787109375), SC_(0.0008188991309622442567476639566012279127539), SC_(0.006769526355441144134067326378549557222926), SC_(0.1079142349660693376621594572683118548668), SC_(0.8920857650339306623378405427316881451332) }, 
      { SC_(8.17627716064453125), SC_(3.6086070537567138671875), SC_(0.392287790775299072265625), SC_(0.1908175164083617809262499426787568832925e-4), SC_(0.001124442022622292383524761827210664484964), SC_(0.01668679923435103380027505666462901952011), SC_(0.9833132007656489661997249433353709804799) }, 
      { SC_(8.1776065826416015625), SC_(3.2673664093017578125), SC_(0.79738438129425048828125), SC_(0.001278705464795437314310908634751591927025), SC_(0.0005186898632948047998567438481753444885048), SC_(0.7114213800444668480364643362476249381052), SC_(0.2885786199555331519635356637523750618948) }, 
      { SC_(8.1814861297607421875), SC_(0.6552445888519287109375), SC_(0.60427105426788330078125), SC_(0.002597528906581071567322607066609879154373), SC_(0.3490514568713914629739506840284338318669), SC_(0.007386709507591538902867860528160113422691), SC_(0.9926132904924084610971321394718398865773) }, 
      { SC_(8.1998119354248046875), SC_(7.244538784027099609375), SC_(0.821263849735260009765625), SC_(0.2985298911713392575174019527954184317682e-4), SC_(0.1561941714934421885441864008488829609166e-6), SC_(0.9947951208804594371055070396859819090642), SC_(0.005204879119540562894492960314018090935792) }, 
      { SC_(8.211940765380859375), SC_(3.225107669830322265625), SC_(0.3443934917449951171875), SC_(0.852844984673369769908777640181362966199e-5), SC_(0.001873718524272210291255858851020160339178), SC_(0.004530994053384390348578716656051600553495), SC_(0.9954690059466156096514212833439483994465) }, 
      { SC_(8.2345790863037109375), SC_(8.21903324127197265625), SC_(0.0845274031162261962890625), SC_(0.1008622175396472072189867111908510286653e-9), SC_(0.1398148936129306045868087863797307013603e-4), SC_(0.7213930313165907010663134767586999314868e-5), SC_(0.9999927860696868340929893368652324130007) }, 
      { SC_(8.243762969970703125), SC_(5.32097530364990234375), SC_(0.781930983066558837890625), SC_(0.0001476361600562963831271417149507871345626), SC_(0.134988074988824637031716072218692261504e-4), SC_(0.9162267029702292906851795078487210570433), SC_(0.08377329702977070931482049215127894295673) }, 
      { SC_(8.2531375885009765625), SC_(5.05919361114501953125), SC_(0.643996536731719970703125), SC_(0.0001156121681748133340562841302486599120247), SC_(0.934617967278239692642012219689531511718e-4), SC_(0.5529725723078539926575013759042181494905), SC_(0.4470274276921460073424986240957818505095) }, 
      { SC_(8.2581691741943359375), SC_(4.624742031097412109375), SC_(0.23056511580944061279296875), SC_(0.2885178866685566279222747450093997726505e-6), SC_(0.0003307846740693321687142872629895457180421), SC_(0.0008714625456805344354901735652253818459257), SC_(0.9991285374543194655645098264347746181541) }, 
      { SC_(8.3082866668701171875), SC_(7.935975551605224609375), SC_(0.16573216021060943603515625), SC_(0.1306674927092766877335736422593833174746e-7), SC_(0.1633292411579459902650362319345265220809e-4), SC_(0.0007993855728167438736983893999915298251205), SC_(0.9992006144271832561263016106000084701749) }, 
      { SC_(8.31379795074462890625), SC_(1.89084184169769287109375), SC_(0.6491506099700927734375), SC_(0.00152938869562792073830729361868671957134), SC_(0.01434738071982103868557500806716407977261), SC_(0.09632870866914162189209256813799656490434), SC_(0.9036712913308583781079074318620034350957) }, 
      { SC_(8.3291683197021484375), SC_(0.6926252841949462890625), SC_(0.99406909942626953125), SC_(0.2648851559066134819887470428388781209687), SC_(0.04068237317509910353891278363474631331365), SC_(0.8668629049121900407498928546676857220008), SC_(0.1331370950878099592501071453323142779992) }, 
      { SC_(8.40717220306396484375), SC_(9.88521575927734375), SC_(0.147914230823516845703125), SC_(0.3586078744100753721545697156816073105493e-8), SC_(0.3939131223271255197901991732000987884728e-5), SC_(0.0009095449836760289218364398259850287547721), SC_(0.9990904550163239710781635601740149712452) }, 
      { SC_(8.41929149627685546875), SC_(0.111925862729549407958984375), SC_(0.99353539943695068359375), SC_(1.645995991321326036514439745545309818658), SC_(5.057472894853114447674130226847323961783), SC_(0.2455439145419333624057322196281698208938), SC_(0.7544560854580666375942677803718301791062) }, 
      { SC_(8.44308757781982421875), SC_(8.859981536865234375), SC_(0.4221454560756683349609375), SC_(0.2240872469627985359637256547159033519869e-5), SC_(0.5360625095689384132199776709279547262501e-5), SC_(0.2947935522405744373563884081068702206181), SC_(0.7052064477594255626436115918931297793819) }, 
      { SC_(8.4439220428466796875), SC_(7.901017665863037109375), SC_(0.90272581577301025390625), SC_(0.1527203827280396800125190640941128339653e-4), SC_(0.6542641466998938462121110048430365228876e-9), SC_(0.9999571611786777628904322744984882805837), SC_(0.428388213222371095677255015117194163251e-4) }, 
      { SC_(8.4912929534912109375), SC_(2.119243144989013671875), SC_(0.0480394922196865081787109375), SC_(0.7157142147553125039175936804727278815863e-12), SC_(0.009954321181750057141950443749065211225333), SC_(0.7189985149525021750897615243564171353529e-10), SC_(0.9999999999281001485047497824910238475644) }, 
      { SC_(8.53031063079833984375), SC_(5.339331150054931640625), SC_(0.276097476482391357421875), SC_(0.5889653642558661031599582491484625914899e-6), SC_(0.0001358616846656139519705775658570233039026), SC_(0.004316325089891021097941304667679358517042), SC_(0.995683674910108978902058695332320641483) }, 
      { SC_(8.55522823333740234375), SC_(2.52823352813720703125), SC_(0.757527887821197509765625), SC_(0.001956965380163300681265071978023040691615), SC_(0.002877631169435066553121584441411874492939), SC_(0.4047835967462217786717225566374351817667), SC_(0.5952164032537782213282774433625648182333) }, 
      { SC_(8.5944232940673828125), SC_(6.10916233062744140625), SC_(0.552925884723663330078125), SC_(0.2459051028813306432219867948151387203488e-4), SC_(0.3789872456769951346177490394023341925445e-4), SC_(0.3935159447041597432117993081110122220279), SC_(0.6064840552958402567882006918889877779721) }, 
      { SC_(8.686946868896484375), SC_(6.79519748687744140625), SC_(0.24792282283306121826171875), SC_(0.1487041346125827612364843192443702135301e-6), SC_(0.318660172226345553550016834442726284975e-4), SC_(0.004644867370645434834303464311170577390815), SC_(0.9953551326293545651656965356888294226092) }, 
      { SC_(8.6929225921630859375), SC_(0.77557027339935302734375), SC_(0.2630449831485748291015625), SC_(0.1110413697041890110939831316289488662224e-5), SC_(0.2251589252039880477403834356256277431233), SC_(0.4931664244925502164651547266278223302986e-5), SC_(0.9999950683357550744978353484527337217767) }, 
      { SC_(8.75371551513671875), SC_(1.20381677150726318359375), SC_(0.8626918792724609375), SC_(0.02295037230959824552015708044758745486436), SC_(0.04346884344455042458185902599008890979751), SC_(0.3455381405668693365636596049497825880116), SC_(0.6544618594331306634363403950502174119884) }, 
      { SC_(8.7594280242919921875), SC_(0.16520583629608154296875), SC_(0.404268085956573486328125), SC_(0.5979371340845381734687485767368175656545e-4), SC_(3.956897688076528295602296902536363584881), SC_(0.1511103257581782880763761615428321282318e-4), SC_(0.9999848889674241821711923623838457167872) }, 
      { SC_(8.7965373992919921875), SC_(3.2669925689697265625), SC_(0.797300159931182861328125), SC_(0.0009821984406753187938975914310180591063764), SC_(0.000472414096118496878112443956565851441922), SC_(0.6752302869877854606024469612984144998982), SC_(0.3247697130122145393975530387015855001018) }, 
      { SC_(8.81866550445556640625), SC_(0.89952909946441650390625), SC_(0.7481768131256103515625), SC_(0.009841011013929298549991722992186043695856), SC_(0.1417785855511473166136148267616265808647), SC_(0.06490593061105686481483430996789811545703), SC_(0.935094069388943135185165690032101884543) }, 
      { SC_(8.85167980194091796875), SC_(9.59221553802490234375), SC_(0.503712356090545654296875), SC_(0.1962936685938295661716831165955279050466e-5), SC_(0.1407862370418447309984561631639054499991e-5), SC_(0.5823357171755869530075454221503859302484), SC_(0.4176642828244130469924545778496140697516) }, 
      { SC_(8.86511898040771484375), SC_(5.02362346649169921875), SC_(0.573797285556793212890625), SC_(0.479058564212294760196882751111272421507e-4), SC_(0.0001133709722320212357715978716874399419542), SC_(0.2970411609731506263421030381130500110703), SC_(0.7029588390268493736578969618869499889297) }, 
      { SC_(8.9090328216552734375), SC_(4.23165130615234375), SC_(0.13808752596378326416015625), SC_(0.1599754832011563696994151500156252846786e-8), SC_(0.0003925619773926243337355475073108451411185), SC_(0.407514839669054984147468977780209687185e-5), SC_(0.9999959248516033094501585253102221979031) }, 
      { SC_(8.90922451019287109375), SC_(3.5534870624542236328125), SC_(0.54018402099609375), SC_(0.8669579639514216658467840622195540533204e-4), SC_(0.0008524710656804250564420104372583339429561), SC_(0.09231138777995603017390887220177639050053), SC_(0.9076886122200439698260911277982236094995) }, 
      { SC_(9.00053882598876953125), SC_(3.4383952617645263671875), SC_(0.3111712038516998291015625), SC_(0.1366668328180889698134295596539624266627e-5), SC_(0.001065167580362544530988892118992082926571), SC_(0.00128141063435947609498941949223591584803), SC_(0.998718589365640523905010580507764084152) }, 
      { SC_(9.02716064453125), SC_(3.0182731151580810546875), SC_(0.3018971383571624755859375), SC_(0.1179434773470281040987572941938752406077e-5), SC_(0.001947673697451668353210754240517537282717), SC_(0.0006051942827131564610485847407840905447697), SC_(0.9993948057172868435389514152592159094552) }, 
      { SC_(9.03720569610595703125), SC_(3.8475520610809326171875), SC_(0.53838860988616943359375), SC_(0.6370692065720327915386325974115606499101e-4), SC_(0.0005422484128740900164043781808599950704704), SC_(0.1051346809441248502677918033994902997408), SC_(0.8948653190558751497322081966005097002592) }, 
      { SC_(9.047222137451171875), SC_(2.644765377044677734375), SC_(0.549768626689910888671875), SC_(0.000161036141689452201793507692816913329241), SC_(0.0033327146520256412104459894219158429189), SC_(0.04609262400144281556295987549971263982398), SC_(0.953907375998557184437040124500287360176) }, 
      { SC_(9.048809051513671875), SC_(7.266544342041015625), SC_(0.4388004839420318603515625), SC_(0.2967806514752360440349527153749822237173e-5), SC_(0.1417715111536709165227714341739243569789e-4), SC_(0.1731008369212098882943614829500956308811), SC_(0.8268991630787901117056385170499043691189) }, 
      { SC_(9.05791950225830078125), SC_(8.35008525848388671875), SC_(0.0047337622381746768951416015625), SC_(0.9365761772242787374397164497153399708116e-22), SC_(0.71165912390234408468010205769228210554e-5), SC_(0.1316046047563634421262479801585926425442e-16), SC_(0.9999999999999999868395395243636557873752) }, 
      { SC_(9.0630817413330078125), SC_(8.48088836669921875), SC_(0.795220434665679931640625), SC_(0.6384512221387030519498645334941176886653e-5), SC_(0.338533433867839228125288826530779441978e-7), SC_(0.9947255507581894913373029108744520500915), SC_(0.00527444924181050866269708912554794990851) }, 
      { SC_(9.106475830078125), SC_(1.329960346221923828125), SC_(0.2581388950347900390625), SC_(0.4433298808071366938193620343309059171981e-6), SC_(0.04623599172337855208980015405504157053995), SC_(0.9588323154595910055544475932445339524054e-5), SC_(0.9999904116768454040899444555240675546605) }, 
      { SC_(9.1328678131103515625), SC_(0.18066270649433135986328125), SC_(0.504820525646209716796875), SC_(0.0003517078618334413592993322273482889139855), SC_(3.455845872386505033724751385383559724429), SC_(0.0001017615034057659581838153696350851986908), SC_(0.9998982384965942340418161846303649148013) }, 
      { SC_(9.133373260498046875), SC_(5.582687854766845703125), SC_(0.2290540635585784912109375), SC_(0.5440901342682134994316831399531247846047e-7), SC_(0.7849279102014276390788707715375524780519e-4), SC_(0.0006926919534186828856466794729038889562952), SC_(0.9993073080465813171143533205270961110437) }, 
      { SC_(9.133758544921875), SC_(2.2103404998779296875), SC_(0.008193102665245532989501953125), SC_(0.9492834082422093442181503717609790399606e-20), SC_(0.007265356531940199386598309751486426259219), SC_(0.130658888393011188931163148349050117368e-17), SC_(0.9999999999999999986934111160698881106884) }, 
      { SC_(9.15735530853271484375), SC_(6.39763355255126953125), SC_(0.040567062795162200927734375), SC_(0.1605141350622832333810860148924021882822e-13), SC_(0.3489582306305591687831832384426268132857e-4), SC_(0.4599809401211273663713909442483438812396e-9), SC_(0.9999999995400190598788726336286090557517) }, 
      { SC_(9.159912109375), SC_(6.55213260650634765625), SC_(0.912586271762847900390625), SC_(0.3018047697522979751555243567930781951144e-4), SC_(0.9349325473628660484916460449184096071461e-8), SC_(0.9996903153605288937948213436999850747588), SC_(0.0003096846394711062051786563000149252411828) }, 
      { SC_(9.17193698883056640625), SC_(6.95232868194580078125), SC_(0.170790970325469970703125), SC_(0.3694701174094692419832407269723819395738e-8), SC_(0.2089445121238316230691957995447673285082e-4), SC_(0.0001767956444259406013614873885791193701386), SC_(0.9998232043555740593986385126114208806299) }, 
      { SC_(9.17424297332763671875), SC_(8.0176296234130859375), SC_(0.950227081775665283203125), SC_(0.8539523754449092949267812263946732907335e-5), SC_(0.3080273781266635091557520938089589603712e-11), SC_(0.9999996392922183063089445295584381333051), SC_(0.3607077816936910554704415618666949469689e-6) }, 
      { SC_(9.20332050323486328125), SC_(3.924690723419189453125), SC_(0.69485914707183837890625), SC_(0.0002310503112810029066611893416788379084469), SC_(0.0002841260239293677938812757004432580527586), SC_(0.4484878195863833882626599955886481131739), SC_(0.5515121804136166117373400044113518868261) }, 
      { SC_(9.2337970733642578125), SC_(6.445505619049072265625), SC_(0.4359149932861328125), SC_(0.3518617297258378498751803839224728042655e-5), SC_(0.2846752000482794851986542503386822247384e-4), SC_(0.1100044454892298999779387975978826443182), SC_(0.8899955545107701000220612024021173556818) }, 
      { SC_(9.2885417938232421875), SC_(2.441382884979248046875), SC_(0.47481119632720947265625), SC_(0.4761255483176591056175849284001070081479e-4), SC_(0.004586185824940369681133540819136408293863), SC_(0.01027505966586902534866379616980543048538), SC_(0.9897249403341309746513362038301945695146) }, 
      { SC_(9.292636871337890625), SC_(2.1723785400390625), SC_(0.15452297031879425048828125), SC_(0.2624075056699678414562124647032627161364e-8), SC_(0.007521320523051118214918717491848671514352), SC_(0.3488847647374800274842030525271354542582e-6), SC_(0.9999996511152352625199725157969474728645) }, 
      { SC_(9.2938594818115234375), SC_(4.584969043731689453125), SC_(0.3805077970027923583984375), SC_(0.3033084082238698622351283936762757320358e-5), SC_(0.0002160623300405638004025369269425911334952), SC_(0.01384366758374349929295072479433910689838), SC_(0.9861563324162565007070492752056608931016) }, 
      { SC_(9.33993244171142578125), SC_(6.81359577178955078125), SC_(0.0497494600713253021240234375), SC_(0.5518070299877559210026646747715538340941e-13), SC_(0.2146633044365963053975520213612198005479e-4), SC_(0.2570569897903910302588882280913495968099e-8), SC_(0.9999999974294301020960896974111177190865) }, 
      { SC_(9.340106964111328125), SC_(9.6496639251708984375), SC_(0.18903611600399017333984375), SC_(0.3760693208748964009075562773732041031133e-8), SC_(0.2241360584188258329348724623108553890864e-5), SC_(0.001675051252959087450179950156748128851185), SC_(0.9983249487470409125498200498432518711488) }, 
      { SC_(9.39001560211181640625), SC_(2.4007594585418701171875), SC_(0.403971731662750244140625), SC_(0.1134959668917263176160589414159781875943e-4), SC_(0.004844797940116370573271103607794275185958), SC_(0.002337160599663038722280937028362435559564), SC_(0.9976628394003369612777190629716375644404) }, 
      { SC_(9.420505523681640625), SC_(9.54943370819091796875), SC_(0.3371889293193817138671875), SC_(0.1805691602626601023406871171319958471924e-6), SC_(0.2091846165246050032401702854147298202011e-5), SC_(0.07946133712253384615168111931846197902557), SC_(0.9205386628774661538483188806815380209744) }, 
      { SC_(9.4273700714111328125), SC_(1.3122184276580810546875), SC_(0.709393918514251708984375), SC_(0.003017013444722590640311000913969701534262), SC_(0.04315436163162597522990240737111380539958), SC_(0.06534380749400867203205742252815333005062), SC_(0.9346561925059913279679425774718466699494) }, 
      { SC_(9.43622684478759765625), SC_(7.562816619873046875), SC_(0.86930525302886962890625), SC_(0.1050377778686616769098759960271509592204e-4), SC_(0.9810847461408665570279905884259728037155e-8), SC_(0.9990668412278015532617620281113608196916), SC_(0.0009331587721984467382379718886391803084328) }, 
      { SC_(9.447872161865234375), SC_(0.4794428348541259765625), SC_(0.3019829094409942626953125), SC_(0.1527301820162022411297571755969196094484e-5), SC_(0.6378057092170519230917855314560001309605), SC_(0.2394613501875548352256068326033443059895e-5), SC_(0.9999976053864981244516477439316739665569) }, 
      { SC_(9.45174121856689453125), SC_(0.259588778018951416015625), SC_(0.9688708782196044921875), SC_(0.4793292977141484299090680804809562384231), SC_(1.485529678525234390368678419714687359757), SC_(0.2439509926720312131315430238386720081336), SC_(0.7560490073279687868684569761613279918664) }, 
      { SC_(9.50222110748291015625), SC_(4.90589046478271484375), SC_(0.095445640385150909423828125), SC_(0.1494828487479906048651881175052573767788e-10), SC_(0.0001378928182363681434821788452535606188609), SC_(0.1084050891519629129496674016152519495829e-6), SC_(0.9999998915949108480370870503325983847481) }, 
      { SC_(9.51630496978759765625), SC_(8.78050518035888671875), SC_(0.68924558162689208984375), SC_(0.3487950539831946130214243133355575362614e-5), SC_(0.2597595086647305428948201602139996658804e-6), SC_(0.9306884723462189452892185573366006247018), SC_(0.06931152765378105471078144266339937529823) }, 
      { SC_(9.5613460540771484375), SC_(6.51968669891357421875), SC_(0.3377856314182281494140625), SC_(0.4444839214175533505542773743694858127194e-6), SC_(0.2448798812291126478463498053849728750408e-4), SC_(0.01782751107179748780824836030020235500629), SC_(0.9821724889282025121917516396997976449937) }, 
      { SC_(9.57166957855224609375), SC_(1.0986175537109375), SC_(0.0333652384579181671142578125), SC_(0.7641149432459472271709082287842355172746e-15), SC_(0.07915132376380966467712577074419741010585), SC_(0.9653849195574867821285790668820816696202e-14), SC_(0.9999999999999903461508044251321787142093) }, 
      { SC_(9.57506847381591796875), SC_(9.9646129608154296875), SC_(0.01787211932241916656494140625), SC_(0.1658996384153681417135737467814313678843e-17), SC_(0.1513424851355072886884114448435894461463e-5), SC_(0.1096186825970546076551374980438478385039e-11), SC_(0.9999999999989038131740294539234486250196) }, 
      { SC_(9.57693958282470703125), SC_(7.249060153961181640625), SC_(0.872441589832305908203125), SC_(0.1265918745248280535982657188870855265927e-4), SC_(0.1650447533802566668031298868233442384058e-7), SC_(0.9986979428474589734503870049545106253976), SC_(0.001302057152541026549612995045489374602406) }, 
      { SC_(9.59291362762451171875), SC_(5.809566974639892578125), SC_(0.1387105882167816162109375), SC_(0.3226608546341382422172814363970325173078e-9), SC_(0.4951645101829454492779247772056654797778e-4), SC_(0.6516193012187428032807345415266845925099e-5), SC_(0.9999934838069878125719671926545847331541) }, 
      { SC_(9.59492397308349609375), SC_(5.036627292633056640625), SC_(0.043119497597217559814453125), SC_(0.70463813192480350035637684220091276433e-14), SC_(0.0001140624644588322714943677495101932553999), SC_(0.6177651300315304735247529704567042174447e-10), SC_(0.9999999999382234869968469526475247029543) }, 
      { SC_(9.59743976593017578125), SC_(5.737546443939208984375), SC_(0.12707412242889404296875), SC_(0.1472749033768804794567481194100647733112e-9), SC_(0.5323124639940113790246026061688731976865e-4), SC_(0.276669260771152772688627996297166358751e-5), SC_(0.9999972333073922884722731137200370283364) }, 
      { SC_(9.61898136138916015625), SC_(9.79925632476806640625), SC_(0.240151941776275634765625), SC_(0.1353843923794317977412052106059477829317e-7), SC_(0.1632783113888411433729758988565696586839e-5), SC_(0.008223447729414564260765034318619123062768), SC_(0.9917765522705854357392349656813808769372) }, 
      { SC_(9.63088512420654296875), SC_(6.059281826019287109375), SC_(0.488668859004974365234375), SC_(0.581055997045127220418244921269735439886e-5), SC_(0.3187439986268775277133352875803521062324e-4), SC_(0.1541877713596934710853644077040271007484), SC_(0.8458122286403065289146355922959728992516) }, 
      { SC_(9.6488857269287109375), SC_(9.67694950103759765625), SC_(0.0185489989817142486572265625), SC_(0.1749481595836606883382303122964370689815e-17), SC_(0.1758002864820450185505025032329301561348e-5), SC_(0.995152869681782569163934165768269529895e-12), SC_(0.9999999999990048471303182174308360658342) }, 
      { SC_(9.686492919921875), SC_(3.323390960693359375), SC_(0.822622716426849365234375), SC_(0.0007256304807823739090101393096545824752395), SC_(0.0002824860673401657300814152223119963953949), SC_(0.7197882845329221918507242489433549020479), SC_(0.2802117154670778081492757510566450979521) }, 
      { SC_(9.70592784881591796875), SC_(9.81109714508056640625), SC_(0.0319296605885028839111328125), SC_(0.2412648809123635167598641163183182877987e-15), SC_(0.153247481975863672328821013292784593199e-5), SC_(0.1574348092142740770669069066716607378887e-9), SC_(0.9999999998425651907857259229330930933283) }, 
      { SC_(9.7297458648681640625), SC_(1.422172069549560546875), SC_(0.62565600872039794921875), SC_(0.0007515285211317483408827317273891061880333), SC_(0.03308064211512736093153684853289103287133), SC_(0.02221342902327139455287559010633701337676), SC_(0.9777865709767286054471244098936629866232) }, 
      { SC_(9.7868061065673828125), SC_(2.324003696441650390625), SC_(0.580998599529266357421875), SC_(0.0001869421048606273257218647038338269425064), SC_(0.004902502132333050539451707571566560474365), SC_(0.03673133964106605423746931249168049356184), SC_(0.9632686603589339457625306875083195064382) }, 
      { SC_(9.7974834442138671875), SC_(3.546381473541259765625), SC_(0.43892610073089599609375), SC_(0.8846383934988994958104111659144072787642e-5), SC_(0.0006942444162306305791078085627402992944978), SC_(0.01258213581077315616174240184063815608328), SC_(0.9874178641892268438382575981593618439167) }, 
      { SC_(9.816379547119140625), SC_(4.97869396209716796875), SC_(0.7558143138885498046875), SC_(0.8471586497414725426535462974925383298225e-4), SC_(0.2600787706776670771042095868990896095329e-4), SC_(0.7651102050188879474911089577484436075733), SC_(0.2348897949811120525088910422515563924267) }, 
      { SC_(9.82663440704345703125), SC_(8.9943599700927734375), SC_(0.79222810268402099609375), SC_(0.2564909668495030018187514949876471506381e-5), SC_(0.1328272157019951695723866392922830834089e-7), SC_(0.9948480487253848974511529374575346247921), SC_(0.005151951274615102548847062542465375207862) }, 
      { SC_(9.83052539825439453125), SC_(5.54380321502685546875), SC_(0.711244642734527587890625), SC_(0.4142099063694028106257790388260333526588e-4), SC_(0.1706128131291109079313412403482492307802e-4), SC_(0.7082657573983930918019463517369821910095), SC_(0.2917342426016069081980536482630178089905) }, 
      { SC_(9.84063720703125), SC_(2.9338824748992919921875), SC_(0.679551780223846435546875), SC_(0.0003620677940926280979183654032292271566579), SC_(0.001398063860838349825529157603027032578726), SC_(0.2057049500122911434857054575556857430709), SC_(0.7942950499877088565142945424443142569291) }, 
      { SC_(9.8798198699951171875), SC_(7.69243144989013671875), SC_(0.498594343662261962890625), SC_(0.2102276377997196459781769309658523199559e-5), SC_(0.5090672027747954852585150635916233053816e-5), SC_(0.2922690751289229878585770869253518082993), SC_(0.7077309248710770121414229130746481917007) }, 
      { SC_(9.9613475799560546875), SC_(4.475843906402587890625), SC_(0.2373598515987396240234375), SC_(0.2596148971864002645551220232138375643592e-7), SC_(0.0001912089032647389537199491735362492125718), SC_(0.0001357570950881480228485230092737049890207), SC_(0.999864242904911851977151476990726295011) }, 
      { SC_(9.9908046722412109375), SC_(6.74212932586669921875), SC_(0.73282539844512939453125), SC_(0.1400972426630799368521044086815964034595e-4), SC_(0.1993917002921952527694349144803786583093e-5), SC_(0.8754085417575787330833090864097798601476), SC_(0.1245914582424212669166909135902201398524) }
   } };
#undef SC_



