/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.base;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryConnectionWrapper;
import org.openrdf.repository.event.InterceptingRepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionInterceptor;

public class InterceptingRepositoryConnectionWrapper
extends RepositoryConnectionWrapper
implements InterceptingRepositoryConnection {
    private boolean activated;
    private Set<RepositoryConnectionInterceptor> interceptors = new CopyOnWriteArraySet<RepositoryConnectionInterceptor>();

    public InterceptingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    public void addRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.activated = true;
    }

    public void removeRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.activated = !this.interceptors.isEmpty();
    }

    protected boolean isDelegatingAdd() {
        return !this.activated;
    }

    protected boolean isDelegatingRemove() {
        return !this.activated;
    }

    public void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (!this.getDelegate().hasStatement(subject, predicate, object, false, contexts)) {
            boolean denied = false;
            if (this.activated) {
                RepositoryConnectionInterceptor interceptor;
                Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
                while (i$.hasNext() && !(denied = (interceptor = i$.next()).add(this, subject, predicate, object, contexts))) {
                }
            }
            if (!denied) {
                this.getDelegate().add(subject, predicate, object, contexts);
            }
        }
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).clear(this, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().clear(contexts);
        }
    }

    public void close() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).close(this))) {
            }
        }
        if (!denied) {
            super.close();
        }
    }

    public void commit() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).commit(this))) {
            }
        }
        if (!denied) {
            this.getDelegate().commit();
        }
    }

    public void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).remove(this, subject, predicate, object, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().remove(subject, predicate, object, contexts);
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).removeNamespace(this, prefix))) {
            }
        }
        if (!denied) {
            this.getDelegate().removeNamespace(prefix);
        }
    }

    public void clearNamespaces() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).clearNamespaces(this))) {
            }
        }
        if (!denied) {
            this.getDelegate().clearNamespaces();
        }
    }

    public void rollback() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).rollback(this))) {
            }
        }
        if (!denied) {
            this.getDelegate().rollback();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        boolean denied = false;
        boolean wasAutoCommit = this.isAutoCommit();
        if (this.activated && wasAutoCommit != autoCommit) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).setAutoCommit(this, autoCommit))) {
            }
        }
        if (!denied) {
            this.getDelegate().setAutoCommit(autoCommit);
        }
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).setNamespace(this, prefix, name))) {
            }
        }
        if (!denied) {
            this.getDelegate().setNamespace(prefix, name);
        }
    }
}

