//---------------------------------------------------------------------------
//
//             kPPP: A pppd front end for the KDE project
//
//---------------------------------------------------------------------------
//
// (c) 1997-1998 Bernd Johannes Wuebben <wuebben@kde.org>
// (c) 1997-1999 Mario Weilguni <mweilguni@kde.org>
// (c) 1998-1999 Harri Porten <porten@kde.org>
//
// derived from Jay Painters "ezppp"
//
//---------------------------------------------------------------------------
//
//  $Id: modemdb.h 212185 2003-03-07 22:11:39Z waba $
//
//---------------------------------------------------------------------------
//
//  This program is free software; you can redistribute it and-or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this program; if not, write to the Free
//  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//---------------------------------------------------------------------------

#ifndef __MODEMDB__H__
#define __MODEMDB__H__

#include <qdialog.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qptrlist.h>
class KConfig;
class QListBox;

typedef QDict<QString> CharDict;

class ModemDatabase {
public:
  ModemDatabase();
  ~ModemDatabase();

  const QStringList *vendors();
  QStringList *models(QString vendor);

  void save(KConfig *);

private:
  void load();
  void loadModem(const QString & key, CharDict &dict);
  QPtrList<CharDict> modems;

  QStringList *lvendors;

  KConfig *modemDB;
};


class ModemSelector : public QDialog {
  Q_OBJECT
public:
  ModemSelector(QWidget *parent = 0);
  ~ModemSelector();

private slots:
  void vendorSelected(int idx);
  void modelSelected(int idx);
  void selected(int idx);

private:
  QPushButton *ok, *cancel;
  QListBox *vendor, *model;
  ModemDatabase *db;
};

#endif
