/* 
 * strsignal.c --
 *
 *	Map signal names to strings
 *
 * Copyright 1988-1991 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /usr/src/local/icsi/pmake/lib/sprite/RCS/strsignal.c,v 1.2 1994/04/14 21:03:58 stolcke Exp $ SPRITE (Berkeley)";
#endif /* not lint */

#include <stdio.h>
#include <signal.h>
#include "sprite.h"

#ifndef _sys_siglist	/* SVR4 has strsignal() */

#ifndef hpux
extern char *sys_siglist[];
#endif /* hpux */

/*
 *----------------------------------------------------------------------
 *
 * strsignal --
 *
 *	Map an integer signal number into a printable string.
 *
 * Results:
 *	The return value is a pointer to a string describing the
 *	signal.
 *
 * Side effects:
 *	Each call to this procedure may overwrite the value returned
 *	by the previous call.
 *
 *----------------------------------------------------------------------
 */

char *
strsignal(signo)
    int signo;			/* Integer identifying signal */
{
    static char msg[25];

#ifndef hpux
    if ((signo < NSIG) && (signo > 0)) {
	return sys_siglist[signo];
    }
#endif /* hpux */
    sprintf(msg, "Signal %d", signo);
    return msg;
}

#endif /* ! _sys_siglist */
