/*-
 * xlog.h --
 *	Flexible error logging facility.
 *
 * Copyright (c) 1992 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  Andreas Stolcke makes no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 *	"$Id: xlog.h,v 1.2 1995/12/31 04:32:43 stolcke Exp $ ICSI (Berkeley)"
 */
#ifndef _XLOG_H_
#define _XLOG_H_

#include <stdio.h>
#include <syslog.h>

/*
 * Log targets
 */
#define XLOG_NONE	((FILE *)0)		/* no logging */
#define XLOG_SYSLOG	((FILE *)1)		/* to syslog */
#define XLOG_PREVIOUS	((FILE *)2)		/* previous log */
			
/*
 * Log facilities -- so 4.2BSD systems can use dummy facility names
 */
#ifndef LOG_DAEMON
#define LOG_USER	0
#define LOG_DAEMON	0
#define LOG_AUTH	0
#define LOG_AUTH	0
#define LOG_LOCAL0	0
#define LOG_LOCAL1	0
#define LOG_LOCAL2	0
#define LOG_LOCAL3	0
#define LOG_LOCAL4	0
#define LOG_LOCAL5	0
#define LOG_LOCAL6	0
#define LOG_LOCAL7	0
#endif

/*
 * Log levels -- similar to amd
 */
#define XLOG_FATAL		0
#define XLOG_ERROR		1
#define XLOG_WARNING		2
#define XLOG_INFO		3
#define XLOG_DEBUG		4

extern void xlog_set();				/* redirect logging */
#ifdef HAVE_VSYSLOG
extern void xlog(int, char *, ...);		/* log message */
#else
extern void xlog();				/* log message */
#endif
extern void xlog_perror();			/* perror (3) replacement */

#define perror(str)	xlog_perror(str)

#endif /* _XLOG_H_ */
