/*
 * Copyright (C) 2001-2004 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtkvideo.h,v 1.5 2004/12/15 23:59:58 dsalt Exp $
 *
 * a gtk xine video widget
 */

#ifndef HAVE_GTK_VIDEO_H
#define HAVE_GTK_VIDEO_H

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include <xine.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Signals */
enum {
  GTK_VIDEO_KEYPRESS,	/* caught keypress in fullscreen mode */
  GTK_VIDEO_KEYRELEASE,	/* caught keyrelease in fullscreen mode */
  LAST_SIGNAL
};


#define GTK_VIDEO(obj)             (GTK_CHECK_CAST ((obj), gtk_video_get_type (), GtkVideo))
#define GTK_VIDEO_CLASS(klass)     (GTK_CHECK_CLASS_CAST ((klass), gtk_video_get_type (), GtkVideoClass))
#define GTK_IS_VIDEO(obj)          (GTK_CHECK_TYPE (obj, gtk_video_get_type ()))
#define GTK_IS_VIDEO_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((klass), gtk_video_get_type ()))

  typedef struct _GtkVideo      GtkVideo;
  typedef struct _GtkVideoClass GtkVideoClass;

  typedef struct gtk_video_private_s gtk_video_private_t;

  
  struct _GtkVideo
  {
    GtkWidget                widget;
    gtk_video_private_t     *priv; /* private data */
  };

  struct _GtkVideoClass
  {
    GtkWidgetClass parent_class;
    void (*keypress) (GtkWidget *gtv);
    void (*keyrelease) (GtkWidget *gtv);
  };

  GtkType    gtk_video_get_type          (void);
  GtkWidget* gtk_video_new               (xine_t *xine, xine_stream_t *stream, 
      					  xine_post_out_t *post_out, /* will be rewired */
      					  const gchar *video_driver_id,
					  int default_width, int default_height,
					  int button_press_mask,
					  int button_release_mask);
  void       gtk_video_set_visibility    (GtkVideo *gtv,
					  GdkVisibilityState state);
  void       gtk_video_resize            (GtkVideo *gtv,
		 			  gint x, gint y,
		 			  gint width,
					  gint height);
  void       gtk_video_rescale           (GtkVideo *gtv, float scale);
  xine_video_port_t *gtk_video_get_port  (GtkVideo *gtv);
  gboolean gtk_video_is_fullscreen (GtkVideo *gtv) ;
  void gtk_video_set_fullscreen (GtkVideo *gtv, gboolean fullscreen);
  gboolean gtk_video_get_auto_resize (GtkVideo *gtv) ;
  void gtk_video_set_auto_resize (GtkVideo *gtv, gboolean resize);

  gboolean gtk_video_set_vis (GtkVideo *, const char *id,
			      xine_audio_port_t **);
  gboolean gtk_video_show_vis (GtkVideo *, xine_audio_port_t **);
  void gtk_video_hide_vis (GtkVideo *, xine_audio_port_t *);

#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif /* HAVE_GTK_VIDEO_H */

