#!/bin/sh
#
# @(#) $Id: kill_all.sh,v 1.5 2001/04/26 20:46:30 ivm Exp $
#
# $Log: kill_all.sh,v $
# Revision 1.5  2001/04/26 20:46:30  ivm
# Fixed some bugs
#
# Revision 1.4  2000/11/16 19:17:32  ivm
# Added another instance check to fbs_run
# Fixed kill_all.sh
#
# Revision 1.3  2000/09/20 14:02:45  ivm
# Fixed minor bugs
#
# Revision 1.2  2000/07/03 22:40:19  ivm
# Fix typo in Scheduler
# Fix kill_all.sh
#
# Revision 1.1  2000/07/03 19:30:59  ivm
# Added kill_all.sh kill_bmgr.sh shutdown_bmgr.sh shutdown_lch.sh
#
# Revision 1.3  1999/04/28 19:21:30  ivm
# Fixed for IRIX, IRIX64
#
# Revision 1.2  1999/04/19 21:01:39  ivm
# Make it work on SunOS, Linux, IRIX and OSF1
#
# Revision 1.1  1999/04/02 17:23:34  ivm
# Rewrote kill_all, kill_farmd, shutdown_farmd into sh
# kill_farmd.sh uses /tmp/farmd.pid now
#
#
# kill_all.sh will kill all processes running under root with command
# line (including arguments) having given string as a substring.
#
# Usage:
#
#       kill_all.sh [-signal] string
#
#       Note that string may be grep-compatible regular expression
#

if [ "${#}" = "2" ] ;then
        sig="$1"
        ptrn="$2"
elif [ "${#}" = "1" ] ;then
		sig=""
		ptrn="$1"
else
        echo "Usage: kill_all [-sig] pattern"
        exit 1
fi

os=`uname`
case $os in
"IRIX"|"SunOS")
	pids=`ps -ef | grep -e "$ptrn" | grep -v grep | grep -v kill_all | cut -c 9-14`
	;;

"IRIX64")
	pids=`ps -ef | grep -e "$ptrn" | grep -v grep | grep -v kill_all | cut -c 9-19`
	;;

"Linux")
	pids=`ps axw | grep -e "$ptrn" | grep -v grep | grep -v kill_all | cut -c 1-5`
	;;

"OSF1")
	pids=`ps axw | grep -e "$ptrn" | grep -v grep | grep -v kill_all | cut -c 9-15`
	;;
esac

if [ ! -z "$pids" ]; then
	kill $sig $pids
fi

