#!/bin/sh -f
#
# @(#) $Id: fbs_run.sh,v 1.11 2001/06/20 18:26:33 ivm Exp $
#
# $Log: fbs_run.sh,v $
# Revision 1.11  2001/06/20 18:26:33  ivm
# Fixed minor bugs
#
# Revision 1.10  2001/02/09 17:28:36  ivm
# If -q local_python is declared, use it.
#
# Revision 1.9  2001/01/03 15:47:14  ivm
# Made queue status (locked/held) persistent
#
# Revision 1.8  2000/12/18 17:48:09  ivm
# Improved format of history output
# Cleaned-up Scheduler code
#
# Revision 1.7  2000/12/05 21:42:31  ivm
# Fixed syntax error in fbs_run.sh
#
# Revision 1.5  2000/11/30 20:23:18  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.4  2000/11/16 19:17:32  ivm
# Added another instance check to fbs_run
# Fixed kill_all.sh
#
# Revision 1.3  2000/09/20 14:02:45  ivm
# Fixed minor bugs
#
# Revision 1.2  2000/06/30 15:33:20  ivm
# Added start_bmgr and start_logd.sh
# Added non-FUE comments to start_*.sh
#
# Revision 1.1  2000/06/30 15:03:55  ivm
# Renamed run.sh to fbs_run.sh
#
# Revision 1.1  2000/05/22 14:43:11  ivm
# Added kill_lch.sh run.sh
#
#

#--------------------------------------------------------------------
# For non-FUE environment, comment-out from #+FUE to #-FUE, see below
#--------------------------------------------------------------------

#+FUE

# Edit the following line if your UPS installation uses different
# directory for setups.sh script
ups_dir=/fnal/ups/etc

# check if another instance of this script is already running
lst=""
mypid=$$
case `uname` in
IRIX*|SunOS|SUN*)
	ps -ejf | grep fbs_run.sh | grep $1 | grep -v $mypid > /dev/null
	not_found=$?
	if [ "$not_found" = "0" ] ; then
		echo "Another instance is already running:"
		ps -ejf | grep fbs_run.sh | grep $1 | grep -v $mypid
		exit 1
	fi
	;;
Linux*|OSF*)
	ps axjw | grep fbs_run.sh | grep $1 | grep -v $mypid > /dev/null
	not_found=$?
	if [ "$not_found" = "0" ] ; then
		echo "Another instance is already running:"
		ps axjw | grep fbs_run.sh | grep $1 | grep -v $mypid
		exit 1
	fi
	;;
esac	

if [ -r ${ups_dir}/setups.sh ] ;then
	. ${ups_dir}/setups.sh
	while true ;do
		(	
			if ( ups exist kerberos ) ;then
				setup kerberos
			fi
			if ( ups exist -q local_python fbsng ) ;then
				setup -q local_python fbsng
			else
				setup fbsng
			fi
			fbs $*
		)
	    sleep 60
	done
else
	echo "$0: can not find ${ups_dir}/setups.sh"
	echo "$0: exiting"
fi

#-FUE

#-------------------------------------------------------------------------
# For non-FUE environment, uncomment lines between #+NON_FUE and #-NON_FUE
#-------------------------------------------------------------------------

#+NON_FUE

## Edit the following line to reflect your installation
#fbs_dir=/the/directory/where/fbs_env.sh/is/located
#
#if [ -r ${fbs_dir}/fbs_env.sh ] ;then
#	while true ;do
#		(. ${fbs_dir}/fbs_env.sh; fbs $*)
#		sleep 20
#	done
#else
#	echo "can not find ${fbs_dir}/fbs_env.sh"
#	echo "exiting"
#fi

#-NON_FUE
