#
# @(#) $Id: lchstatif.py,v 1.7 2001/12/26 16:26:07 ivm Exp $
#
# $Log: lchstatif.py,v $
# Revision 1.7  2001/12/26 16:26:07  ivm
# Catch exceptions and take "domain" into account in lchstatif
#
# Revision 1.6  2000/05/12 21:18:54  ivm
# Fixed passing message from batch process to API
#
# Revision 1.4  2000/04/17 15:43:44  ivm
# Do not query Launcher about non-running processes
#
# Revision 1.3  2000/04/03 19:45:52  ivm
# Increased launcher responce wait time
#
#

from socket import *
from FBSProcessInfo import *
from FBSSubProcessInfo import *
import string
import Parser
import time
import select
import sys

class _StatClient:
	def __init__(self):
		pass

	def getStat(self, host, port, bpid, retry, tmo):
		req = 'STAT %s' % bpid
		done = 0
		tmax = time.time() + tmo
		while time.time() < tmax:
			sock = socket(AF_INET, SOCK_DGRAM)
			#print 'sendto("%s",%s)' % (req, (host, port))
			try:	sock.sendto(req, (host, port))
			except:
				return None, '%s %s' % (sys.exc_type, sys.exc_value)
			#print 'Sent: <%s> to %s' % (req, host)
			lst, dummy, dummy = select.select([sock], [], [], retry)
			if sock in lst:
				answ, addr = sock.recvfrom(10000)
				#print 'Rcvd: <%s> from %s' % (answ, addr)
				sock.close()
				pi, text = self.parseStat(answ, bpid)
				#print pi, text
				if pi == None and text == 'RETRY':
					continue
				return pi, text
			sock.close()
		return None, 'Time-out'	# timed-out

	def parseStat(self, txt, bpid):
		procs = {}
		lines = string.splitfields(txt, '\n')
		if len(lines) < 1:
			return None, 'Format error (no lines)'
		lst, rest = Parser.parseWords(lines[0], maxWords = 5)
		if not lst:
			return None, 'Bad header: <%s>' % lines[0]
		# Verify header
		if lst[0] == 'NF':
			raise KeyError, 'Process %s does not exist' % bpid
		if lst[0] != 'PROC':
			return None, 'Bad header: <%s>' % lines[0]
		if len(lst) < 2:
			return None, 'Bad header: <%s>' % lines[0]
		if lst[1] != bpid:
			return None, 'RETRY'
		if lines[-1] != '.':
			return None, 'Bad trailer: <%s>' % lines[-1]
		lines = lines[:-1]
		pi = FBSProcessInfo(bpid)
		if len(lst) >= 5:
			pi.UPID = lst[2]
			pi.CPUTime = lst[3]
			pi.ACPUTime = lst[4]
			i1 = string.find(rest, '[')
			i2 = string.find(rest, ']', i1+1)
			if i1 >= 0 and i2 >= 0:
				pi.Message = rest[i1+1:i2]
				pi.Command = string.strip(rest[i2+1:])
			else:
				pi.Command = rest
		procs = [pi]
		root = pi
		for l in lines[1:]:
			words, rest = Parser.parseWords(l, maxWords = 4)
			if len(words) < 4:	continue
			lvl = words[0]
			spi = FBSSubProcessInfo()
			spi.UPID = words[1]
			spi.CPUTime = words[2]
			spi.ACPUTime = words[3]
			spi.Command = rest
			procs = procs[:lvl] + [spi]
			procs[lvl-1].Subprocesses.append(spi)
		return pi, 'OK'

class	LauncherStatIF:
	def __init__(self, cfg):
		self.Cfg = cfg
		
	def getProcInfo(self, bpid, node):
		host = node
		domain = self.Cfg.getValue('global','*','domain')
		if domain:
			host = node + '.' + domain
		port = self.Cfg.getValue('launcher',node,"stat_port")
		if port == None:
			raise ValueError, 'Can not get launcher port number from configuration'
		sc = _StatClient()
		return sc.getStat(host, port, bpid, 5, 10)


if __name__ == '__main__':
	def printTree(pi):
		print '%s %d %d %s' % (pi.BPID, pi.UPID, pi.ACPUTime, pi.Command)
		for spi in pi.Subprocesses:
			printTreeRec(1, spi)

	def printTreeRec(lvl, spi):
		print '%s%d %d %s' % (lvl*'  ', spi.UPID, spi.CPUTime, spi.Command)
		for sspi in spi.Subprocesses:
			printTreeRec(lvl+1, sspi)
	
	import sys
	from config import *
	print 'Usage: lchstatif.py <cfg_file> <bpid> <node>'
	bpid = sys.argv[2]
	js = LauncherStatIF(ConfigFile(sys.argv[1]))
	stat, text = js.getProcInfo(bpid, sys.argv[3])
	if stat == None:
		print 'Error: ', text
	else:
		printTree(stat)
