#
# @(#) $Id: LogClient.py,v 1.6 2001/06/12 19:47:53 ivm Exp $
#
# $Author: ivm $
#
# $Log: LogClient.py,v $
# Revision 1.6  2001/06/12 19:47:53  ivm
# Updated for Python v2.1
#
# Revision 1.5  2001/04/26 20:46:30  ivm
# Fixed some bugs
#
# Revision 1.4  2000/11/30 20:23:17  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.3  2000/04/20 21:18:43  ivm
# Fixed inter-queue scheduling
#
# Revision 1.2  2000/04/12 16:00:04  ivm
# Works with Launcher
#
#
#
# --------------- transferred from FBS v 1.28 ------------------

from socket import *
from config import *
import time
import os
import string
import select

###########################################################################
#   Mark Breitung  
#	Rewritten by Igor Mandrichenko from RCS revision 1.24
#   LogFile Class:  logs messages to a file
#   Use:  __init__(host machine name,
#                  what process is running, 
#                  what severity codes to ignor - as a string of chars
#                           (note: each severity code is 1 char long)
#
#         log(severity code, unique message code number,message string)
#
#   This class needs for LogServer.py to be running on machine 
#      specified in $FARMS_ROOT/config/farms.cfg
#       
#   See logd.py for file placement and other info.
#      
###########################################################################


class	LogClient:
	def __init__(self, cfg, typ, id, ignore = ''):
		if type(cfg) == type(''):
			cfg = ConfigFile(cfg)
		#
		# Get configuration
		#
		self.Port = cfg.getValue('logd','*','server_port')
		self.Host = cfg.getValue('logd','*','host')
		self.Addr = (self.Host, self.Port)
		self.Silent = (self.Host == None)
		#
		# Initialize
		#
		self.Type = typ
		self.Id = id
		self.Ignore = ignore
		self.MinInx = 0
		self.MaxInx = 0
		self.Buf = []
		self.ResendAfter = 60	# seconds
		self.MaxToSend = 10
		if not self.Silent:
			self.Sock = socket(AF_INET, SOCK_DGRAM)
			self.sendHello()
				
	def sendHello(self):	
		self.send('@ %d %s %s' % (self.MinInx, self.Type, self.Id))

	def log(self, level, code, text):
		if self.Silent: return
		if level in self.Ignore:	return
		inx = self.MaxInx
		self.MaxInx = self.MaxInx + 1
		msg = '%s, %s, %s, %s, %s, %s, %s' % (inx, time.ctime(time.time()),
			self.Type, self.Id, level, code, text)
		self.Buf.append((0, msg))
		self.sendRecv()

	def sendRecv(self):
		#
		# Get acknowledgements
		#
		#print 'sendRecv: imin/imax = %d/%d (%d)' % (self.MinInx, self.MaxInx,
		#	self.MaxInx - self.MinInx)
		nrcvd = 0
		nsent = 0
		while 1:
			r, w, x = select.select([self.Sock],[],[],0)
			#print r,w,x
			if not self.Sock in r:	break
			try:	msg, addr = self.Sock.recvfrom(4096)
			except: break
			#print 'Recvd <%s>' % msg
			if msg:
				if msg[0] == '?':
					# who are you ?
					self.sendHello()
				else:
					try:	inx = string.atoi(msg)
					except:
						continue
					if inx < self.MinInx or \
						inx >= self.MaxInx:	continue
					self.Buf = self.Buf[inx-self.MinInx+1:]
					self.MinInx = inx + 1
					if self.MaxInx < self.MinInx:
						self.MaxInx = self.MinInx
					nrcvd = nrcvd + 1
		#
		# Send buffered messages
		#
		tnow = time.time()
		tcut = tnow - self.ResendAfter
		for i in range(len(self.Buf)):
			t, msg = self.Buf[i]
			if t > tcut:	break
			self.send(msg)
			self.Buf[i] = (tnow, msg)
			nsent = nsent + 1
			if nsent > self.MaxToSend:	break			
		return nsent, nrcvd

	def idle(self):
		nr = 1
		while self.Buf and nr > 0:
			ns, nr = self.sendRecv()

	def send(self, msg):
		try:	self.Sock.sendto(msg, self.Addr)
		except: pass

	def __del__(self):
		for t, msg in self.Buf:
			self.send(msg)
		self.send('$')
		self.send('$')
		self.send('$')
		self.Sock.close()
		
if __name__ == '__main__':
	import sys
	import os
	
	cfg = sys.argv[1]
	id = '%d' % os.getpid()
	lc = LogClient(cfg, sys.argv[2], id)
	nc = string.atoi(sys.argv[3])
	
	i = 0
	while i < 1000:
		for j in range(nc):
			lc.log('D', i, 'Message #%d' % i)
			i = i + 1
		time.sleep(1)
		
