#
# @(#) $Id: JobDB.py,v 1.13 2000/11/03 22:32:34 ivm Exp $
#
# $Author: ivm $
#
# $Log: JobDB.py,v $
# Revision 1.13  2000/11/03 22:32:34  ivm
# Fixed bugs
#
# Revision 1.12  2000/10/05 22:53:33  ivm
# Fixed and tested upgrade scripts
#
# Revision 1.11  2000/06/16 16:24:43  ivm
# Set QPDec default to 1
# Remove debug output from JobDB
# Randomize queue list in Scheduler
# Fix templates directories making
# Ignore key errors in Launcher.idle()
#
# Revision 1.10  2000/06/09 16:41:54  ivm
# Fix use of Sections in JobInfo
# Delete corrupted sections
#
# Revision 1.9  2000/06/08 21:33:53  ivm
# In case when section can not be restored, write log record
# and do not attempt to go further with the section.
#
# Revision 1.8  2000/06/05 20:45:24  ivm
# Mase sure numeric section names come out as strings
# Restore signals in JobDB
# Fixed pid file name in Launcher
# Fixed memory leak in NetIF
#
# Revision 1.7  2000/06/01 14:06:42  ivm
# Catch SIGINT in JobDB
# Return 'false' if section not found in DepExpression
#
# Revision 1.5  2000/05/30 17:01:46  ivm
# Implemented checksums
#
# Revision 1.4  2000/05/23 22:02:16  ivm
# Check for non-existing job db root specification
#
# Revision 1.3  2000/04/27 13:52:32  ivm
# Added SectParam.complete() method
#
# Revision 1.2  2000/04/07 21:14:48  ivm
# Fixed bugs
#
# Revision 1.1  2000/04/06 21:05:58  ivm
# Added JobDB.py ff_db.py
#

import shelve
import bmgr_global
import fbs_misc
from JobSection import *
from ff_db import FF_DB
import sys
import signal

try:
    from cPickle import Pickler, Unpickler
except ImportError:
    from pickle import Pickler, Unpickler

try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO



class	DBSection:
	def __init__(self):
		pass

class	FBSDB(FF_DB):
	def __init__(self, cfg, create = 0):
		self.Root = cfg.getValue('jobdb','*','root')
		if self.Root == None:
			raise IOError, 'Job DB directory is not configured'
		FF_DB.__init__(self, self.Root, create)
		if	create:
			try:	id = self['NextJobID']
			except: self['NextJobID'] = 1

	def toPickle(self, obj):
		f = StringIO()
		p = Pickler(f)
		p.dump(obj)
		return f.getvalue()
		
	def fromPickle(self, data):
		f = StringIO(data)
		return Unpickler(f).load()
			
	def nextJobID(self):
		i = self['NextJobID']
		i1 = i + 1
		if i1 >= 100000:
			i1 = 1
		self['NextJobID'] = i1
		return '%d' % i

	def saveDBSection(self, jid, sname, dbs):
		pckl = self.toPickle(dbs)
		self.saveData(jid, sname, pckl)	
	
	def saveSection(self, sect):
		# ignore SIGINT
		oldsig = signal.signal(signal.SIGINT, signal.SIG_IGN)
		jid = sect.JID
		name = sect.Name
		sdb = sect.toDB()
		#if not sdb.Procs:
		#	print 'JDB.save(): Empty process dictionary for section <%s.%s>' % (jid, name)
		try:	self.saveDBSection(jid, name, sdb)
		except:
			et, ev = sys.exc_type, sys.exc_value
			# restore old signal handlers
			signal.signal(signal.SIGINT, oldsig)
			# re-throw exception
			raise et, ev
		signal.signal(signal.SIGINT, oldsig)

	def jobs(self):
		return self.dirs()
	
	def snames(self, jid):
		return self.files(jid)
		
	def restoreSection(self, jid, sname):
		dbs = None
		sid = fbs_misc.encodeSectionID(jid, sname)
		try:	dbs = self.fromPickle(self.restoreData(jid, sname))
		except: dbs = None
		else:
			#if not dbs.Procs:
			#	print 'JDB.restore(): Empty process dictionary for section <%s.%s>' % (jid, sname)
			#	#print dbs.__dict__
			dbs.SectParam.complete()
		if dbs == None:
			bmgr_global.G_LogClient.log('E',1,'JDB: section %s is corrupted' % 
				sid)
			self.deleteSection(sid)
			return None	
		sect = Section(sid)
		sect.fromDB(dbs)
		return sect

	def getDBSection(self, jid, sname):
		try:	dbs = self.fromPickle(self.restoreData(jid, sname))
		except: dbs = None
		return dbs

	def restore(self):
		for jid in self.dirs():
			for sname in self.files(jid):
				sect = self.restoreSection(jid, sname)
				if sect != None:
					sect.startRecovery()

	def deleteSection(self, sid):
		jid, sname = fbs_misc.decodeDotID(sid)
		self.delFile(jid, sname)
		try:	self.deleteJob(jid)
		except: pass
		
	def deleteJob(self, jid):
		self.delDir(jid)

if __name__ == '__main__':
	from config import *
	import os
	
	def dump(x, name, indent = ''):
		print '%s%-15s = ' % (indent, name),
		if type(x) == type({}):
			# dictionary
			print 'Dictionary:'
			for k,v in x.items():
				dump(v,k,indent + ' ')
		elif type(x) == type([]) or type(x) == type(()):
			print '%s' % x
		elif type(x) == type(1) or type(x) == type(None) or \
					type(x) == type(1.1) or type(x) == type(''):
			print '%s' % x
		else:
			print 'Object %s:' % type(x)
			dump(x.__dict__, '', indent + ' ')
	
	cfg = ConfigFile(os.environ['FBS_CONFIG'])
	db = FBSDB(cfg)
	for jid in db.jobs():
		for sn in db.snames(jid):
			sid = fbs_misc.encodeSectionID(jid, sn)
			print 'Section %s:' % sid
			dbs = db.getDBSection(jid, sn)
			dump(dbs,'')
