#
# @(#) $Id: status.py,v 1.33 2003/08/25 19:16:49 ivm Exp $
#
# $Log: status.py,v $
# Revision 1.33  2003/08/25 19:16:49  ivm
# In ststus, ls and lj, do not convert the username specified with -u
# to numeric UID. Instead, compare text Username directly
#
# Revision 1.32  2002/06/19 16:52:53  ivm
# Fixed some bugs
#
# Revision 1.31  2001/08/28 22:28:39  ivm
# Added Real/CPU time limits
#
# Revision 1.30  2001/08/27 18:28:42  ivm
# Fixed status.py
# Use PType.wouldExceedQuota() in RM
#
# Revision 1.29  2001/08/23 19:05:54  ivm
# Implemented search with feedback RM algorithm
# Added -v option to status.py
# Fixed handling of time limits in FBSSectionInfo
#
# Revision 1.28  2001/02/06 18:25:25  ivm
# Fixed yet another memory mishadnling in farm_history, simplified syntax
# Added canceled() dependency type
# Added job ranges in kill.py
# Show processes for just ended sections
# Fixed decoding of status/signal/core in Section
#
# Revision 1.27  2000/12/05 21:42:12  ivm
# Attempt to re-connect in FBSClient
# Fixed username -> uid mapping in status.py
# v1_2a_1
#
# Revision 1.26  2000/11/30 20:23:19  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.25  2000/11/08 20:27:03  ivm
# Implemented FBSClient.getServerOptions()
# Fixed bugs
#
# Revision 1.24  2000/11/04 17:45:31  ivm
# Receive command line as list
#
# Revision 1.23  2000/10/23 19:43:00  ivm
# Use pwd module to translate username -> uid
# Print process exit status
# Do not attempt to print details on exited process
# If details time-out, print only short info
# Print time in ..h..m or ..m..s format, not just plain seconds
# Clean-up usage information
# Import modules without '*'
# Optimized getJobList call
# Extended EXEC field in section header
# Cut long EXEC lines with '*'
# Others
#
# Revision 1.22  2000/10/02 20:26:26  fromm
# Added resource pool info.
#
# Revision 1.21  2000/09/07 18:57:56  fromm
# added status
#
# Revision 1.20  2000/07/13 14:46:24  fromm
# .
#
# Revision 1.19  2000/06/15 19:14:16  fromm
# .
#
# Revision 1.16  2000/06/12 21:25:51  fromm
# .
#
# Revision 1.15  2000/06/12 14:04:08  fromm
# .
#
# Revision 1.10  2000/05/31 19:33:16  fromm
# .
#
# Revision 1.9  2000/05/24 15:58:38  fromm
# .
#
# Revision 1.4  2000/04/18 13:19:54  fromm
# cuz
#
# Revision 1.3  2000/04/06 21:36:54  fromm
# cuz
#
# Revision 1.1  2000/04/04 19:56:53  fromm
# New version.
#
#
# submit.py
# usage:
# setenv FBS_CONFIG ...
# submit.py file.jdf

from FBS_API import *
import string
import time
import sys
import getopt

queue_flag = 'off'
queue_arg = ''
need_job_line = 'yes'
verbose = 0
fbs_client = FBSClient()
usage="""
USAGE: python status.py [-u (<user>|all)][-r][-v]
    [-q queue] [--help] [(<jobid>|<sectid>) ...]
"""

def dict2str(dct, none = 'None'):
        str = ''
        for k, v in dct.items():
                if v == None:   v = none
                str = str + '%s:%s ' % (k,v)
        return str

def atime2str(t):
	t = int(t)
	if not t:	return '0'
	if t > 60*60:
		# hours + minutes
		return '%dh%02dm' % (t/60/60, ((t % (60*60)) + 30)/60)
	else:
		# minutes + seconds
		return '%dm%02ds' % (t/60, t % 60)

##############################################################################
#                                                                               #
# print_subprocess()                                                            #
#    Print out the subprocess info.                                             #
#                                                                             #
##############################################################################

def print_subprocess(subp,pad = ''):
	subcmd = subp.Command
	if type(subcmd) == type([]):
		subcmd = string.join(subcmd)
	cmd = pad + subcmd
	if not verbose and len(cmd) > 45:
	   cmd = cmd[:44] + '*'
	print '  %-10s %6s %6s %-45s' % \
    	  (subp.UPID,
		  atime2str(subp.CPUTime),atime2str(subp.ACPUTime),cmd)
	for subsubp in subp.Subprocesses:
    	   print_subprocess(subsubp,pad + ' ')
    

###############################################################################
#                                                                             #
# print_sectionInfo()                                                         #
#    Print out the section specific info.                                     #
#                                                                             #
###############################################################################

def print_sectionInfo(sectionInfo):

    if raw_flag == 'on':
       print sectionInfo.__dict__
       return

    if queue_flag == 'on':
       if sectionInfo.Queue != queue_arg:
           return
    
    print '  Section ID: %s   Name: %s' % (sectionInfo.ID, sectionInfo.Name)
    print '  User:       %s' % sectionInfo.Username
    print '  Process resources: %s' % dict2str(sectionInfo.PerProcRsrc)
    print '  Section resources: %s' % dict2str(sectionInfo.PerSectRsrc)
    if sectionInfo.RsrcPoolDict:
    	print '  Allocated from pools: %s' % dict2str(sectionInfo.RsrcPoolDict)
    if sectionInfo.StartTime != None:
        startTime = time.ctime(int(sectionInfo.StartTime))
    else:
        startTime = 'Not Started'
 
    if sectionInfo.HoldTime != None:
        if sectionInfo.HoldTime == -1:
           holdTime = 'Forever'
        else:
           holdTime = time.ctime(int(sectionInfo.HoldTime)) 
    else:
        holdTime = ''

    if sectionInfo.EndTime != None:
        endTime = time.ctime(int(sectionInfo.EndTime))
    else:
        endTime = 'Not Finished'

    #
    # Kludge cuz hold state is represented not in state, but
    # as a -1 in hold time.
    #
    state = sectionInfo.State
  
    if sectionInfo.State != 'canceled':
       if sectionInfo.HoldTime != None:
          state = 'Held'
       elif sectionInfo.State == None:
          state = 'Held'
    else:
        state = sectionInfo.State
 
    print '  Start Time: %-25s   End Time: %-25s' % \
          (startTime,endTime)
    
    print '  Hold Time:  %-25s   Prio: %s' % \
          (holdTime, sectionInfo.Prio)

    cmd = sectionInfo.Exec
    if not verbose and len(cmd) > 60:	cmd = cmd[:59] + '*'
    print '  Exec:       %-25s' % cmd
    print '  State:      %-25s   Depend: %s' % (state,
                                                sectionInfo.Depend)
    print '  ProcType:   %-25s   Queue: %s' % (sectionInfo.ProcType,
                                               sectionInfo.Queue)
    print '  NumProc:    %-25s   Nice: %d'  % (sectionInfo.NProc,
                                               sectionInfo.Nice)
    rtlstr = 'None'
    ctlstr = 'None'
    if sectionInfo.RealTimeLimit > 0:
        rtlstr = atime2str(sectionInfo.RealTimeLimit)
    if sectionInfo.CPUTimeLimit > 0:
        ctlstr = atime2str(sectionInfo.CPUTimeLimit)
    print '  Time Limit: %-25s   CPU Time Limit: %s' % (rtlstr, ctlstr)
        
    if sectionInfo.State in ['running','failed','done']:
       for x in range(sectionInfo.NProc):
			id = x + 1
			sts = sectionInfo.ProcStats[id]
			print ''
			if sts == 'running':
				try:
				  processInfo = sectionInfo.getProcess(id)
				except FBSError,reason:
					processInfo = sectionInfo.getProcess(id, local_details=0)
			else:
				processInfo = sectionInfo.getProcess(id, local_details=0)
			if sts == 'exited':
				sts = sts + ':%d' % processInfo.ExitCode
				if processInfo.Signal:
					sts = sts + ' sig:%s' % processInfo.Signal
			bpid = '(%s)' % processInfo.BPID
			node = 'on %s' % processInfo.Node
			print '  Process #%-2d %-20s %10s Status: %s' % \
				(id, bpid, node, sts)
			if processInfo.Status == 'running':
				if processInfo.Message:
					print '  Msg:    ' + processInfo.Message
				if processInfo.RsrcPoolDict:
					print '  Allocated pools: ' + dict2str(processInfo.RsrcPoolDict)
				print '  %-10s %6s %6s %-40s' % ('PID','CPU','ACPU','Command')
				print '  %-10s %6s %6s %-40s' % (10*'-',6*'-',6*'-',40*'-')
				print_subprocess(processInfo)
    print '  %s' % (72 * '-')
    print ''

try:
    optlist,args = getopt.getopt(sys.argv[1:],"u:q:rv")
except getopt.error,error_msg:
    print error_msg
    print "Try \'fbs status help\' for more information."
    sys.exit(1)

user = None
raw_flag = 'off'

for opt in optlist:
	if opt[0] == '-u':
		user = opt[1]
	elif opt[0] == '-r':
		raw_flag  = 'on'
	elif opt[0] == '-q':
		queue_arg = opt[1]
		queue_flag = 'on'
	elif opt[0] == '-v':
		verbose = 1
	elif opt[0] == '--help':
		print usage
		sys.exit(0)
	
if not args:
	try:	args = fbs_client.getJobList(username=user)
	except:
		print sys.exc_type, sys.exc_value
		print 'Can not connect to BMGR. Try again later'
		sys.exit(1)
	args.sort()

for xid in args:
	tup = fbs_misc.decodeDotID(xid)
	if len(tup) == 2:
		# section id
		try:	si = fbs_client.getSection(xid)
		except KeyError:
			continue
		print_sectionInfo(si)
	else:
		# job id
		try:	ji = fbs_client.getJob(xid)
		except KeyError:
			continue
		#print 'Job ID: ', xid
		for sn in ji.sections():
			try:	si = ji.getSection(sn)
			except KeyError:
				continue
			print_sectionInfo(si)
