#
# @(#) $Id: spawner.py,v 1.6 2002/06/26 20:06:14 ivm Exp $
#

import pty
from SockStream import *
from socket import *
import select
import sys
import string
import os
import time
from Systat import Systat
import signal




host, port = sys.argv[1], string.atoi(sys.argv[2])
s = socket(AF_INET, SOCK_STREAM)
str = SockStream(s)
#time.sleep(60)
s.connect((host, port))
sys.stdout.flush()
sfd = s.fileno()
procno = os.environ['FBS_PROC_NO']
cmdstr = str.sendAndRecv('HELLO %s' % procno)
if not cmdstr:
	sys.exit(1)
cmd = eval(cmdstr)
str.send('OK')

print 'Running as interactive batch job: ', string.join(list(cmd))

pid, mfd = pty.fork()
if not pid:
	# child
	# close all file descriptors except stdin,out,err
	for i in range(3,1024):
		try:	os.close(i)	
		except: pass
	cmdpath = cmd[0]
	cmdargv = list(cmd)
	env = {}
	for k, v in os.environ.items():
		if k[:4] == 'FBS_':
			env[k] = v
	if os.environ.has_key('HOME'):
		env['HOME'] = os.environ['HOME']
	if os.environ.has_key('KRB5CCNAME'):
		env['KRB5CCNAME'] = os.environ['KRB5CCNAME']
	os.execve(cmdpath, cmdargv, env)
# print "Forked. pid = %d, fd = %d" % (pid, mfd)
sys.stdout.flush()
lst = [sfd, mfd]
sys.stdout.flush()
eof = 0
exited = 0
sts = 0
	
while not eof and not exited:
	r, w, x = select.select(lst, [], [], 10)
	# print r, w, x
	sys.stdout.flush()
	if sfd in r:
		data = s.recv(1024)
		# print 's->c: <%s>' % data
		if not data:	
			print 'Socket closed on read'
			print '----------- remainder of process stdout follows -----------'
			lst.remove(sfd)
			s.close()
			s = None
		else:
			while data:
				n = os.write(mfd, data)
				data = data[n:]
	if mfd in r:
		try:	data = os.read(mfd,1024)
		except:	
			print 'EOF on child'
			eof = 1
		else:
			# print 'c->s: <%s>' % data
			if not data:	
				eof = 1
				print 'EOF on child'
			else:
				while data:
					if s:
						n = s.send(data)
						if n <= 0:
							# eof = 1
							if s:
								print 'Socket closed on write'
								s.close()
								s = None
					else:
						n = sys.stdout.write(data)
					# print 'sent: [%s]' % data[:n]
					data = data[n:]
	
	sys.stdout.flush()
	x, sts = os.waitpid(pid,os.WNOHANG)
	if x == pid:
		exited = 1

if not exited:
	pid, sts = os.waitpid(pid,0)

s = Systat()
s.update()
s.killSessionAndTree(pid, signal.SIGKILL)

print '---------------------------------------------'
print 'Process exit status = ',sts
sys.exit(sts >> 8)
