# @(#) $Id: sect_output.py,v 1.3 2000/06/21 19:21:12 fromm Exp $

from FBS_API import *
from string import *
from time import *
import sys
import getopt

fbs_client = FBSClient()


def convert_time(tm_secs):

   if type(tm_secs) != type(1.0):
      ret_time = 'Unknown'
      return ret_time

   t = localtime(tm_secs)
   ret_time = ''

   # MM
   if t[1] < 10:
      ret_time = ret_time + '0' + str(t[1])
   else:
      ret_time = ret_time + str(t[1])

   ret_time = ret_time + '/'

   # DD
   if t[2] < 10:
      ret_time = ret_time + '0' + str(t[2])
   else:
      ret_time = ret_time + str(t[2])

   ret_time = ret_time + ' '

   # HH
   if t[3] < 10:
      ret_time = ret_time + '0' + str(t[3])
   else:
      ret_time = ret_time + str(t[3])

   ret_time = ret_time + ':'

   #MM
   if t[4] < 10:
      ret_time = ret_time + '0' + str(t[4])
   else:
      ret_time = ret_time + str(t[4])
   ret_time = ret_time + ':'

   #SS
   if t[5] < 10:
      ret_time = ret_time + '0' + str(t[5])
   else:
      ret_time = ret_time + str(t[5])

   return ret_time

########################################################################

if len(sys.argv) != 2:
   print 'Must supply one section id to command...'
   sys.exit(-1)

sect_id = sys.argv[1]

try:
   so = fbs_client.getSectionOutput(sect_id)
except KeyError:
   print 'Section id not found...'
   sys.exit(-1)

for so_line in so:
    so_time = convert_time(so_line[0])
    so_data = so_line[1]
    print so_time + ' ' + so_data

