#
# @(#) $Id: queues.py,v 1.19 2004/04/05 19:05:10 ivm Exp $
#
# $Log: queues.py,v $
# Revision 1.19  2004/04/05 19:05:10  ivm
# .
#
# Revision 1.18  2001/12/13 18:13:28  ivm
# Implemented positional arguments in "submit" command
# Added "blocked" status to "queues"
# Updates Users Guide with new "exec" args and positional args of "submit"
# Implemented process start time comparison in launcher
#
# Revision 1.16  2001/08/28 21:01:10  ivm
# Fixed RM.setRsrcPool()
# Added time limits to queue display in queues.py and "fbs config"
# Print correct error messages in submit
#
# Revision 1.15  2001/03/19 16:22:12  ivm
# Added new fields to "show ptype" and "show queue" in farm_config
#
# Revision 1.12  2000/11/10 15:41:43  ivm
# Fixed Stats.so building
# Fixed bug in RM with nullifying usage
# Print exception information in submit
# Improved queues print-out
#
# Revision 1.11  2000/11/08 20:27:02  ivm
# Implemented FBSClient.getServerOptions()
# Fixed bugs
#
# Revision 1.10  2000/11/01 19:23:04  ivm
# Fixed minor bugs
# Updated Users Guide
#
# Revision 1.9  2000/10/23 17:27:27  ivm
# Added section state codes
#
# Revision 1.7  2000/10/23 17:21:20  ivm
# Cleaned-out references to "farms"
# Corrected usage
# Added npending/nrunning/ntotal
# Beautified section list print-out
#
# Revision 1.6  2000/09/07 13:28:52  fromm
# .dded ;oked
#
# Revision 1.3  2000/07/06 19:25:11  fromm
# cosmetic
#
# Revision 1.2  2000/06/28 21:16:07  fromm
# .
#
# Revision 1.1  2000/03/14 22:15:28  fromm
# Initial
#

from FBS_API import *
import string
import sys
import getopt

usage = "USAGE: python queues.py [-l] [<queue name> ...]"

SectStateCodes = {
        'running':'*',
        'done':'d',
        'zombie':'z',
        'ready':'r',
        'failed':'f',
        'canceled':'c',
        'waiting':'w',
        'held':'h',
        'unknown':'?'
        }

def dt2str(t):
        if type(t) != type(1) and type(t) != type(1.0):
                return '%s' % t
        if t < 0:
                return 'N/A'
        t0 = int(t)
        t = t0
        d = t/(24*3600)
        t = t % (24*3600)
        h = t/3600
        t = t % 3600
        m = t/60
        s = t % 60
        if d > 0:
                return '%d seconds (%d days, %d hours, %d minutes)' % (t0,d,h,m)
        else:
                return '%d seconds (%d hours, %d minutes, %d seconds)' % (t0,h,m,s)
        

def print_queueinfo(queuename_list):
    qdict = {}
    minprio = None
    for queue in queuename_list:
        try:
            queueinfo = fbs_client.getQueue(queue)
            qdict[queue] = queueinfo
        except:
            print 'Queue ' + queue + ' invalid'
            continue
        if not queueinfo.IsHeld and queueinfo.NPending:
            pblock = queueinfo.Prio - queueinfo.QPGap
            if minprio == None or pblock > minprio:
                minprio = pblock
    
    explain_blocked = 0

    for queue in queuename_list:
        try:    queueinfo = qdict[queue]        
        except: continue
        if queueinfo.IsHeld:
            queueState = 'Hld'
        else:
            queueState = 'OK'
        if queueinfo.IsLocked:
            if queueState == 'OK':
                queueState = 'Lck'              
            else:
                queueState = queueState + "+Lck"
    
        if minprio != None and queueinfo.Prio < minprio and queueState in ['OK','Lck']:
            queueState = queueState + "*"
            explain_blocked = 1
            
        if long_flag == 'off':
            print '%-15.15s %-7s %-20.20s %5d %6d %6d %6d' % \
                        (queueinfo.Name,queueState,queueinfo.DefProcType, queueinfo.Prio,
                        queueinfo.NPending, queueinfo.NRunning, len(queueinfo.Sections))
        else:
                print 'Queue: %-20s Status: %-10s Def Proc Type: %-15s' % \
                  (queueinfo.Name,queueState,queueinfo.DefProcType)
                str = string.join(queueinfo.ProcTypes)
                if not str: str = '(none)'
                print 'Allowed Proc Types: %s' % str
                print 'MaxSPrio: %-6s SPGap: %-6s MaxQPrio: %-6s' % \
                  (queueinfo.MaxSPrio, queueinfo.SPGap, queueinfo.MaxQPrio)

                print 'Prio: %-4d MinQPrio: %-6s QPDec: %-6s QPInc: %-6s QPGap: %-6s' % \
                        (queueinfo.Prio, queueinfo.MinQPrio, queueinfo.QPDec,
                        queueinfo.QPInc, queueinfo.QPGap)
                print 'Real Time Limit: %s' % dt2str(queueinfo.RealTimeLimit)
                print 'CPU Time Limit:  %s' % dt2str(queueinfo.CPUTimeLimit)
                str = string.join(queueinfo.Users)
                if not str: str = '(none)'
                print 'Authorized users: %s' % str
                print 'Sections: Pending: %d  Running: %d  Total: %d' % \
                        (queueinfo.NPending, queueinfo.NRunning, 
                len(queueinfo.Sections))
                line = '  '
                queueinfo.Sections.sort()
                for sid in queueinfo.Sections:
                        try:    scode = SectStateCodes[queueinfo.SectState[sid]]
                        except:
                                scode = SectStateCodes['unknown']
                        if len(line) + len(sid) > 72:
                                print line
                                line = '  '
                        line = line + (' %s:%s' % (sid, scode))
                print line    
                print '------------------------------------------------------------------------'
        
    print '-----------------------------------------------------------------------'
    if explain_blocked:
        print '* = temporarily blocked by higher priority queue'

try:
    optlist,args = getopt.getopt(sys.argv[1:],"l",['help'])
except getopt.error,error_msg:
    print error_msg
    print "Try \'fbs queues help\' for more information."
    sys.exit(1)

long_flag = 'off'
for opt_element in optlist:
    if opt_element[0] == '--help':
        print usage
        sys.exit(0)
    elif opt_element[0] == '-l':
        long_flag = 'on'
        
    
fbs_client = FBSClient()

if long_flag == 'off':
    print '%-15s %-7s %-20s %5s %6s %6s %6s' % \
          ('Name','State','Def Proc Type','Prio','NPend','NRun','NTotal')
    print '%-15s %-7s %-20s %4s %-6s %-6s %-6s' % \
          ('---------------','-----','--------------------',5*'-',6*'-',6*'-',6*'-')
if len(args) == 0:
    try:
       queue_list = fbs_client.getQueueList()
    except:
       print "Can not get queue list"
       sys.exit(1)
    queue_list.sort()
    print_queueinfo(queue_list)
else:
    print_queueinfo(args)


