#
# @(#) $Id: queueadmin.py,v 1.7 2001/12/18 17:48:47 ivm Exp $
#
# $Log: queueadmin.py,v $
# Revision 1.7  2001/12/18 17:48:47  ivm
# Close the process-launcher pipe in launcher
# Print more accurate error message in queueadmin
#
# Revision 1.6  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.5  2000/11/14 19:09:47  ivm
# Fixed syntax errors
# Recover Username from UID in SectParam
#
# Revision 1.4  2000/11/14 17:35:01  ivm
# New build rules for SunOS
# Fixed queueadmin.py
#
# Revision 1.3  2000/09/29 19:54:51  fromm
# add lock/unlock
#
# Revision 1.2  2000/04/25 18:31:31  fromm
# .
#
# Revision 1.1  2000/04/05 19:41:08  fromm
# renamed
#
# Revision 1.1  2000/04/03 15:54:29  fromm
# Misc.
#

from FBS_API import *
from string import *
import sys
import getopt

usage = 'Usage: python queueadmin.py (-r|-h|-l|-u)  (all|<queue> ...)'

fbs_client = FBSClient()

try:
    optlist,args = getopt.getopt(sys.argv[1:],"rhlu",['help'])
except getopt.error,error_msg:
    print error_msg
    print "Try \'fbs hold/release help\' for more information"
    sys.exit(1)

hold_flag = 'off'
rel_flag = 'off'
lock_flag = 'off'
unlock_flag = 'off'
nopt = 0

for opt in optlist:
    if (opt[0] == '-r'):
        rel_flag = 'on'
        nopt = nopt + 1
    elif (opt[0] == '-l'):
        lock_flag = 'on'
        nopt = nopt + 1
    elif (opt[0] == '-u'):
        unlock_flag = 'on'
        nopt = nopt + 1
    elif (opt[0] == '-h'):
        hold_flag = 'on'
        nopt = nopt + 1

if nopt != 1:
        print 'Conflicting options specified.'
        sys.exit(1)

if len(args) == 0:
    print "No queues specified to take action on, exiting..."
    sys.exit(-1)

if args[0] == 'all':
        args = fbs_client.getQueueList()

if (rel_flag == 'on'):
    for queuename in args:
        try:
           sts, reason = fbs_client.releaseQueue(queuename)
        except:   
           print "Queue not released, bmgr not running?"
           sys.exit(1)
        if not sts:
            print '%s: %s' % (queuename, reason)
elif (hold_flag == 'on'):
    for queuename in args:
        try:
           sts, reason = fbs_client.holdQueue(queuename)
        except KeyError,arg:   
           print arg
           sys.exit(1)
        except FBSError,arg:
           print arg
           sys.exit(1)
        except:
           print "Unknown error"
           sys.exit(1)
        if not sts:
            print '%s: %s' % (queuename, reason)
elif (lock_flag == 'on'):
    for queuename in args:
        try:
           sts, reason = fbs_client.lockQueue(queuename)
        except KeyError,arg:   
           print arg
           sys.exit(1)
        except FBSError,arg:
           print arg
           sys.exit(1)
        except:
           print "Unknown error"
           sys.exit(1)
        if not sts:
            print '%s: %s' % (queuename, reason)
elif (unlock_flag == 'on'):
    for queuename in args:
        try:
           sts, reason = fbs_client.unlockQueue(queuename)
        except KeyError,arg:   
           print arg
           sys.exit(1)
        except FBSError,arg:
           print arg
           sys.exit(1)
        except:
           print "Unknown error"
           sys.exit(1)
        if not sts:
            print '%s: %s' % (queuename, reason)
else:
    print "No action specified, no action taken..."
    sys.exit(-1)

sys.exit(0)
