#
# @(#) $Id: ptnodes.py,v 1.1 2001/04/11 16:38:28 ivm Exp $
#
# $Log: ptnodes.py,v $
# Revision 1.1  2001/04/11 16:38:28  ivm
# Added ptnodes.py
#
#

from FBS_API import FBSClient, FBSError
import sys

Usage = """
Usage: python ptnodes.py (allow|disallow) <ptype> ("*"|-|<node> ...)
"""

if len(sys.argv) < 3:
	print Usage
	sys.exit(2)

cmd = sys.argv[1]
ptype = sys.argv[2]
lst = sys.argv[3:]
if lst[0] == '-':
	lst = []
elif '*' in lst:
	lst = ['*']

fc = FBSClient()
try:	pti = fc.getProcessType(ptype)
except KeyError, msg:
	print msg
	sys.exit(1)
except FBSError, msg:
	print msg
	sys.exit(1)

if cmd == 'allow':
	try:	pti.allowNodes(lst)
	except FBSError, msg:
		print msg
		sys.exit(1)
elif cmd == 'disallow':
	try:	pti.disallowNodes(lst)
	except FBSError, msg:
		print msg
		sys.exit(1)
else:
	print Usage
	sys.exit(2)



