#
# @(#) $Id: nodeadmin.py,v 1.7 2001/05/25 21:39:37 ivm Exp $
#
# $Log: nodeadmin.py,v $
# Revision 1.7  2001/05/25 21:39:37  ivm
# Implemented hold node and disconnect
#
# Revision 1.6  2000/12/18 22:32:29  ivm
# Fixed syntax error in nodeadmin.py
# v1_2a_2
#
# Revision 1.5  2000/12/12 19:22:12  ivm
# Removed debug print-out
# Fixed numerous errors in man pages
#
#

from FBS_API import *
from string import *
import sys
import getopt

usage = 'USAGE: python nodeadmin.py (-R|-H [-d] [-r <reason>]) <node> ...'

fbs_client = FBSClient()

try:
    optlist,args = getopt.getopt(sys.argv[1:],"RHr:d",['help'])
except getopt.error,error_msg:
    print error_msg
    print "Try \'fbs hold help\' for more information"
    sys.exit(1)

hold_flag = 'off'
held_reason = 'Unknown'
rel_flag = 'off'
disconnect = 0

for opt in optlist:
    if (opt[0] == '-R'):
        rel_flag = 'on'
    elif (opt[0] == '-H'):
        hold_flag = 'on'
    elif (opt[0] == '-r'):
		held_reason = opt[1]
    elif opt[0] == '-d':
		disconnect = 1

if (rel_flag == 'on' and hold_flag == 'on'):
    print "Make up your mind, I can't do both..."

if len(args) == 0:
    print "No nodes specified to take action on, exiting..."
    sys.exit(-1)

if (rel_flag == 'on'):
    for nodename in args:
        try:
           fbs_client.releaseNode(nodename)
        except KeyError:
           print "Node specified is invalid..."
           sys.exit(1)
        except FBSError, txt:
			print txt
			sys.exit(1)

elif (hold_flag == 'on'):
    for nodename in args:
        try:
           fbs_client.holdNode(nodename, held_reason, disconnect)
        except KeyError:
           print "Node specified is invalid..."
           sys.exit(1)
        except FBSError, txt:
			print txt
			sys.exit(1)

else:
    print "No action specified, no action taken..."
    sys.exit(-1)

sys.exit(0)
