#
# @(#) $Id: jobs.py,v 1.7 2003/08/25 19:16:49 ivm Exp $
#
# $Log: jobs.py,v $
# Revision 1.7  2003/08/25 19:16:49  ivm
# In ststus, ls and lj, do not convert the username specified with -u
# to numeric UID. Instead, compare text Username directly
#
# Revision 1.6  2000/10/13 20:40:20  ivm
# Implemented -r <repeat time> option
#
# Revision 1.5  2000/10/13 20:00:04  ivm
# Cache uid->username translation
# Add section status to jobs.py output
#
# Revision 1.4  2000/07/06 19:20:59  fromm
# fix bug
#
# Revision 1.3  2000/07/03 21:30:09  fromm
# .
#
# Revision 1.2  2000/06/09 15:37:57  ivm
# Added RCS log records
# Added cprio.py to Makefile
# Replaces FBSJobInfo.Sections with sections()
#
#
from FBS_API import *
import string
import time
import sys
import getopt


SectStateCodes = {
	'running':'*',
	'done':'d',
	'zombie':'z',
	'ready':'r',
	'failed':'f',
	'canceled':'c',
	'waiting':'w',
	'held':'h',
	'unknown':'?'
	}

def decodeSectionState(si):
# returns state including "held" and state code
	state = si.State
	if state == 'waiting' and si.HoldTime:
		state = 'held'
	try:	code = SectStateCodes[state]
	except KeyError:
		code = SectStateCodes['unknown']
	return state, code


fbs_client = FBSClient()
usage="USAGE: python jobs.py [-u (<user>|all)] [--help] [<jobid> ...]"

def printJobs(args, user, print_time):
	job_list = []
	if args:
		job_list = args
	else:
		try:	job_list = fbs_client.getJobList(username = user)
		except:
			print 'Error communicating with BMGR'
			sys.exit(1)

	if print_time:
		print ''
		print time.ctime(time.time())

	if job_list:
		print '%-6s %-10s %-8s %s' % \
    		  ('JobID','State','User','Sections')
		print '%-6s %-10s %-8s %s' % \
    		  ('------','----------','--------','----------------------')

		job_list.sort()

		for jid in job_list:
			try:	jobInfo = fbs_client.getJob(jid)
			except KeyError:
				continue
			user = jobInfo.Username
			sects = jobInfo.sections()
			sects.sort()
			stxt = ''
			for sn in sects:
				try:	si = jobInfo.getSection(sn)
				except KeyError:
					continue
				state, scode = decodeSectionState(si)			
				#print state, scode
				stxt = stxt + ('%s:%s ' % (sn, scode))
			if len(stxt) > 50:
				stxt = stxt[:47] + '...'
			print '%-6s %-10s %-8s %-50s' % (jid,jobInfo.State,user, stxt)


try:
    opts,args = getopt.getopt(sys.argv[1:],"u:r:",['help'])
except getopt.error,error_msg:
    print error_msg
    print "Try \'fbs lj help\' for more information."
    sys.exit(1)

user = None
repeat = -1
for opt, val in opts:
	if opt == '-u':
		user = val
	elif opt == '--help':
		print usage
		sys.exit(0)
	elif opt == '-r':
		repeat = string.atoi(val)

while 1:
	printJobs(args, user, repeat > 0)
	if repeat < 0:
		break
	time.sleep(repeat)
