from FBS_API import *
from httpd_limited import HTTPServer, HTTPClientHandler
from Selector import Selector
import cgi
from config import ConfigFile
import glob
import time
import sys
import os
import string
import stat
from LogClient import LogClient
from fbs_misc import printTraceback

Version = "0.1"

MyPath = '/fbswww'
MyURL = MyPath
MyTop = string.join(string.split(MyURL, '/')[:-1],'/')
MyCookiePath = string.join(string.split(MyPath, '/')[:-1],'/')
#MyFullURL = "http://%s%s" % (os.environ['HTTP_HOST'], os.environ['REQUEST_URI'])
GetGraphURL = "%s/getgraph" % MyTop




Style = """
<STYLE TYPE="text/css">
<!-- /* Hide from browsers that do not understand CSS */
BODY {
  font-family : Tahoma;
  color : black;
}
TD {
  font-family : Tahoma, Verdana, Arial;
  font-size: 11px;
  color : black;
}
TH {
  font-family : Verdana, Tahoma;
  font-size: 10px;
  font-weight: bold;
  color : black;
}
-->
</STYLE>
"""

SectionStateColors = {
	    'running':'bgcolor="#AAFFAA"',
        'ready':'bgcolor="#DDFF88"',
        'waiting':'bgcolor="#FFDD88"',
        'held':'bgcolor="#88EEEE"',
        'failed':'bgcolor="#BBAA88"',
        'canceled':'bgcolor="#AABBAA"',
        'done':'bgcolor="#AABBAA"',
        'zombie':'bgcolor="#AABBAA"',
        'deleted':'bgcolor="#AABBAA"',
        'unknown':''
}

JobStateColors = {
	    'running':'bgcolor="#AAFFAA"',
        'done':'bgcolor="#777788"',
        'ended':'bgcolor="#AABBAA"',
        'pending':'bgcolor="#EEEE88"',
        'unknown':''
}

ProcessStateColors = {
	    'running':'bgcolor="#AAFFAA"',
        'pending':'bgcolor="#DDFF88"',
        'exited':'bgcolor="#FFDD88"',
}

NodeStateColors = {
	'OK':	"#77FF77",
	'held': "#FFFF77",
	'down': "#FF7777"
}

LineBgColors = ['#eeeecc','#eeeecc','#eeeecc','#ffffdd','#ffffdd','#ffffdd']

THBgCol = '#80cBdD'

class	MyCGI:
	def __init__(self):
		self.CGI = cgi.FieldStorage()
		self.Cookies = {}
		try:	cval=os.environ['HTTP_COOKIE']
		except: pass
		else:
			pairs=string.split(cval)
			for kv in pairs:
				while kv and kv[-1] == ';':
					kv = kv[:-1]
				try:	k, v = tuple(string.split(kv,'='))
				except: continue
				try:	v=string.atoi(v)
				except: pass
				#sys.stderr.write('Cookie: %s=%s\n' % (k, v))
				#sys.stderr.flush()
				self.Cookies[k] = v
	
	def has_key(self, k):
		return self.CGI.has_key(k) or self.Cookies.has_key(k)
		
	def __getitem__(self, k):
		if self.CGI.has_key(k):
			return self.CGI[k].value
		if self.Cookies.has_key(k):
			return self.Cookies[k]

CgiEnv = MyCGI()

def dict2str(dct, none = None):
	str = ''
	keys = dct.keys()
	keys.sort()
	for k in keys:
		v = dct[k]
		if v == None:
			if none == None:
				str = str + '%s ' % k
				continue
			v = none
		str = str + '%s:%s ' % (k,v)
	return str

def dtime(t):
	if t < 0 or t == None:
		return '(none)'
	t = int(t)
	if not t:	return '0'
	d = t / (24*3600)
	t = t % (24*3600)
	h = t / 3600
	t = t % 3600
	m = t / 60
	s = t % 60
	if d > 0:
		return '%dd%dh' % (d, h)
	elif h > 0:
		return '%dh%02dm' % (h, m)
	else:
		# minutes + seconds
		return '%dm%02ds' % (m, s)

def atime(t):
	if not t:
		return '(none)'
	else:
		tm = time.localtime(t)
		return '%02d/%02d %02d:%02d:%02d' % tm[1:6]

def sectState(s):
		state = s.State
		if state == 'waiting':
			if s.HoldTime and (s.HoldTime > time.time() or s.HoldTime == -1):
				state = 'held'
		return state

def path2fn(str):
	lst = string.split(str,'/')
	if lst: return lst[-1]
	else:	return str

def fmtCommand(cmd, pad=''):
	if type(cmd) != type([]):
		saved = cmd
		cmd = string.split(cmd)
	else:
		saved = string.join(cmd)
	#return saved
	if cmd:
		cmd[0] = path2fn(cmd[0])
		if cmd[0] in ['sh','tcsh','zsh','csh','bash']:
			cmd = cmd[1:]
			while cmd and cmd[0][0] == '-':
				cmd = cmd[1:]
			if cmd:
				cmd[0] = path2fn(cmd[0])
	if cmd:
		cmd = string.join(cmd)
	else:
		cmd = saved
	cmd = string.replace(cmd, '<', '&lt;')
	cmd = string.replace(cmd, '>', '&gt;')
	return '<nobr>%s%s</nobr>' % (pad, cmd)

class	FBSWWW(HTTPServer):
	def __init__(self, cfg, port = None):
		if port == None:
			port = cfg.getValue('fbswww','*','port',8080)
		self.Cfg = cfg
		log_ignore = cfg.getValue('fbswww','*','log_ignore','')
		HTTPServer.__init__(self, port, Selector())
		self.MyID = '%s.%s' % (os.getpid(), port)
		self.LogClient = LogClient(cfg, 'fbswww', self.getID(), log_ignore)

	def getID(self):
		return self.MyID
		
	def createClientHandler(self, sock, peer):
		self.Cfg.reReadConfig()
		return FBSWWWClientHandler(self, sock, peer, self.Cfg)

	def log(self, level, msg):
		self.LogClient.log(level, 0, msg)

class	FBSWWWClientHandler(HTTPClientHandler):
	_PersistentOptions = ['refresh']

	def __init__(self, srv, sock, peer, cfg):
		HTTPClientHandler.__init__(self, sock, peer)
		self.Cfg = cfg
		self.MyFarm = cfg.getValue('global', '*', 'farm_name', 'UnknownFarm')
		self.GraphsDir = cfg.getValue('fbswww','*','graphs_dir')
		self.Server = srv
		log_ignore = cfg.getValue('fbswww','*','log_ignore','D')
		self.LogClient = LogClient(cfg, 'fbswww', 
				self.Server.getID(), log_ignore)

	def log(self, level, msg):
		self.LogClient.log(level, 0, '%s(%s): %s' % (self.address_string(), 
				self.requestline, msg))

	def log_message(self, format, *args):	# override from HTTPClientHandler
		self.LogClient.log('I', 0, '%s: %s' % (self.address_string(), format % args))

	def mimeHead(self, headers = {}, **cookies):
		if len(headers) == 0:
			headers = {	'Content-type':'text/html',
						'Cache-Control':'no-cache'
			}
		for h, v in headers.items():
			self.send_header(h,v)
		if cookies:
			str = ''
			for k, v in cookies.items():
				str = str + (' %s=%s' % (k,v))
			if str:
				expt = int(time.time()) + 7*24*3600
				expt = time.gmtime(expt)
				expt = time.strftime('%a, %d-%b-%Y %H:%M:%S GMT', expt)
				self.send_header('Set-Cookie','%s; path=%s; domain=%s; expires=%s' % \
					(str, MyCookiePath, MyHost, expt))
		self.end_headers()
		#self.send('')

	def send(self, str):
		self.wfile.write(str + '\n')

	def htmlHead(self, title, refresh):
		self.send('<html><head>')
		self.send('<title>%s</title>' % title)
		if refresh != None:
			self.send('<meta http-equiv="refresh" content="%d">' % refresh)
		self.send('%s' % Style)
		self.send('</head><body bgcolor="#80DDCB" alink="#000000" vlink="#000000" link="#000000">')

	def htmlTail(self):
		self.send('<hr><font size="-2"><center>')
		self.send('<a href="http://www-isd.fnal.gov/fbsng/">FBSNG</a>')
		self.send('</center>')
		self.send('<p align="right"><i>FBSNG httpd version %s</i>' % Version)
		self.send('</body></html>')

	def makeActionURL(self, request, action, **args):
		url = "%s?action=%s" %(MyURL, action)
		for arg, val in args.items():
			url = url + ('&%s=%s' % (arg, val))
		for opt in FBSWWWClientHandler._PersistentOptions:
			if request.has_key(opt) and not args.has_key(opt):
				url = url + ('&%s=%s' % (opt, request[opt]))
		return url

	def makeURL(self, request, **args):
		url = MyURL
		firstarg = 1
		for arg, val in args.items():
			if firstarg:
				url = url + ("?%s=%s" % (arg, val))
				firstarg = 0
			else:
				url = url + ("&%s=%s" % (arg, val))
		for arg, val in request.items():
			if args.has_key(arg):	continue
			if firstarg:
				url = url + ("?%s=%s" % (arg, val))
				firstarg = 0
			else:
				url = url + ("&%s=%s" % (arg, val))
		return url

	def pageHead(self, request, report='Select farm'):
		farm = self.MyFarm
		self.send('<table  width="100%" border=0 bgcolor="#80DDCB" cellspacing=5 cellpadding="0"><tr>',)
		self.send('  <td width="15%" align="center" bgcolor="#70CCBA">',)
		self.send('    <a href="http://www-isd.fnal.gov/fbsng/"><img src="http://www-isd.fnal.gov/fbsng/fbsng_logo.gif" border=0></a>')

		self.send('  </td>')
		self.send('  <td>')
		self.send('    <table border=0 cellpadding=0 cellspacing=0>')
		self.send('      <tr><td colspan=2><font size=+2><b>FBSNG on the web</b></font></td></tr>')
		self.send('      <tr><td>Farm:</td><td>%s</td></tr>' % farm)
		self.send('      <tr><td>Time:</td><td>%s</td></tr>' % time.ctime(time.time()))
		self.send('      <tr><td>Report:</td><td>%s</td>' % report,)
		#self.send('          <td bgcolor="#EEFFDD"><a href="%s"><img src="/fbsng/refresh.gif" border=0></a></td>' %\)
		#		MyFullURL
		self.send('      </tr>')
		""" comment
		self.send('      <tr>')
		self.send('          <td colspan=2>')

		self.send('             <table border=0 cellpadding=2 cellspacing=3>')
		self.send('               <tr>')
		act = ''
		if request.has_key('action'):	act = request['action'] 
		for action, label in [('listQueues','Queues'),
				('listJobs','Jobs'),
				('listNodes','Nodes'),
				('listPTypes','Process Types')]:
			self.send('                      <td bgcolor="#EEFFDD">',)
			if act == 'listJobs' and request.has_key('user'):
				act = 'listJobsByUser'
			if act == 'listNodes' and request.has_key('state'):
				act = 'listNodesInState'
			if act == action:
				self.send('<b>%s</b> ' % label,)
			else:
				self.send('<a href="%s?action=%s">%s</a>' %\
					(MyURL, action, label))
			self.send('</td>')
		try:	os.stat('graphs/%s/display' % farm)
		except: pass
		else:
			self.send('                      <td bgcolor="#EEFFDD">',)
			if act == 'graphs':
				self.send('<b>graphs</b>')
			else:
				self.send('<a href="%s?action=%s&farm=%s">%s</a>' %
					(MyURL, 'graphs', farm, 'Graphs'))
			self.send('</td>')
		self.send('</tr></table>')
		self.send('</td></tr>')
		"""
		self.send('</table>')
		self.send('</td></tr><tr>')


	def navBox(self, request, act='', **opts):
		self.send('<td valign="top">')
		self.send('   <table border=0 cellpadding=2 cellspacing=3 width=100%>')
		act = ''
		if request.has_key('action'):	act = request['action'] 
		for action, label in [
				('listQueues','All queues'),
				('listActiveQueues','Active queues'),
				('listJobs','Jobs'),
				('listNodes','Nodes'),
				('listPTypes','Process Types')]:
			self.send('   <tr><td bgcolor="#EEFFDD">',)
			if act == 'listJobs' and request.has_key('user'):
				act = 'listJobsByUser'
			if act == 'listNodes' and request.has_key('state'):
				act = 'listNodesInState'
			if act == action:
				self.send('      <b>%s</b> ' % label,)
			else:
				self.send('      <a href="%s">%s</a>' %\
					(self.makeActionURL(request, action), label))
			self.send('   </td></tr>')
		if self.GraphsDir:
			try:	os.stat('%s/display' % self.GraphsDir)
			except: pass
			else:
				self.send('    <tr><td bgcolor="#EEFFDD">',)
				if act == 'graphs':
					self.send('      <b>Graphs</b>')
				else:
					self.send('      <a href="%s">%s</a>' %
						(self.makeActionURL(request, 'graphs'), 'Graphs'))
				self.send('    </td></tr>')
		self.send('    <tr><td><hr></td></tr>')
		self.send('    <tr><td bgcolor="#EEFFDD">')
		if request.has_key("refresh") and request["refresh"] == "auto":
			self.send('      Refresh:<br>&nbsp;[<b>auto</b>|<a href="%s">manual</a>]' %
				self.makeURL(request, refresh="manual"))
		else:
			self.send('      Refresh:<br>&nbsp;[<a href="%s">auto</a>|<b>manual</b>]' %
				self.makeURL(request, refresh="auto"))
		self.send('    </td></tr>')
		links = self.Cfg.getValueList('fbswww','*','links', [])
		if len(links) > 2:
			self.send('    <tr><td><hr></td></tr>')
			i = 0
			while i < len(links) - 1:
				if links[i+1] == '-':
					self.send('    <tr><td bgcolor="#EEFFDD">%s</td></tr>' % 
						(links[i],))
				else:
					self.send('    <tr><td bgcolor="#EEFFDD"><a href="%s">%s</a></td></tr>' % 
						(links[i+1], links[i]))
				i = i + 2
		self.send('</table>')			
		self.send('</td>')
		

	def mainHead(self):
		self.send('<td valign="top" bgcolor="#EEFFDD">')
		#self.send('<td valign="top">')

	def mainTail(self):
		self.send('</td>')

	def pageTail(self):
		self.send('</tr></table>')

	def doListQueues(self, request, fc, activeOnly = 0):
		refresh = 60
		farm = self.MyFarm
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		self.htmlHead('FBSWWW - queues @ %s' % farm, refresh)
		self.pageHead(request, 'List of queues')
		self.navBox(request)
		self.mainHead()
		self.send('<table cellpadding=2 width="100%">')
		self.send('<tr bgcolor="%s"><th>Name</th><th>Status</th><th>Default Process Type</th><th>Share</th><th>Prio</th><th>Waiting</th>' % THBgCol)
		self.send('<th>Ready</th><th>Running</th><th>Total</th></tr>')
		qnlst = fc.getQueueList()
		qnlst.sort()
		qlst = []
		for qn in qnlst:
			try:	q = fc.getQueue(qn)
			except: continue
			qlst.append(q)

		maxdec = 0
		for q in qlst:
			if q.QPDec > maxdec:
				maxdec = q.QPDec

		ibg = -1
		for q in qlst:
			if activeOnly and not q.Sections:	continue
			qn = q.Name
			ibg = (ibg + 1) % len(LineBgColors)
			nrd = nwt = nrn = ntot = 0
			for sn in q.Sections:
				st = q.SectState[sn]
				if st == 'ready':		nrd = nrd + 1
				elif st == 'waiting':	nwt = nwt + 1
				elif st == 'running':	nrn = nrn + 1
				ntot = ntot + 1
			sts = ''
			bg = "#77FF77"
			if q.IsHeld:
				sts = 'Held'
				bg = "#FFFF77"
			if q.IsLocked:
				bg = "#FF7777"
				if sts:
					sts = sts + '+Locked'
				else:
					sts = sts + 'Locked'
			if not sts: 	sts = 'OK'
			self.send('<tr bgcolor="%s"><td><a href="%s">%s</a></td>' %
				(LineBgColors[ibg],
				self.makeActionURL(request, 'showQueue', qname=qn), qn))
			share = '(inf)'
			if maxdec > 0 and q.QPDec > 0:
				share = float(maxdec)/float(q.QPDec)
				share = '%.2f' % share
			self.send('  <td bgcolor="%s" align="center">%s</td><td>%s</td><td align="right">%s</td><td align="right">%s</td>' %
				(bg, sts, q.DefProcType, share, q.Prio))
			bgwt = ''
			if nwt > 0:
				bgwt = SectionStateColors['waiting']
			self.send('  <td %s align="right">%s</td>' % (bgwt, nwt))
			bgrd = ''
			if nrd > 0:
				bgrd = SectionStateColors['ready']
			self.send('  <td %s align="right">%s</td>' % (bgrd, nrd))
			bgrn = ''
			if nrn > 0:
				bgrn = SectionStateColors['running']
			self.send('  <td %s align="right">%s</td>' % (bgrn, nrn)		)
			self.send('  <td align="right">%s</td>' % (ntot,)		)
			self.send('</tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()

	def pageIndex(self, request, ntot, entriesPerPage, window):
		npages = ntot/entriesPerPage + 1
		thispage = 1
		if request.has_key('page'):
			thispage = request['page']
			thispage = min(npages, thispage)
		firstpage = 1
		lastpage = npages
		pagestoshow = {firstpage:1, lastpage:1}
		
		for i in range(window):
			for ipage in (thispage - i, thispage + i):
				if ipage >= firstpage and ipage <= lastpage:
					pagestoshow[ipage] = 1
		pagestoshow = pagestoshow.keys()
		pagestoshow.sort()
		if len(pagestoshow) >= 2 and pagestoshow[0] < pagestoshow[1] - 1:
			pagestoshow = [pagestoshow[0], None] + pagestoshow[1:]
		if len(pagestoshow) >= 2 and pagestoshow[-2] < pagestoshow[-1] - 1:
			pagestoshow = pagestoshow[:-1] + [None, pagestoshow[-1]]
		return (thispage-1)*entriesPerPage, thispage, pagestoshow


	def doShowQueue(self, request, fc):
		farm = self.MyFarm
		qname = request['qname'] 
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None

		self.htmlHead('FBSWWW - queue %s@%s' % (qname, farm), refresh)
		self.pageHead(request, 'Queue %s' % qname)
		self.navBox(request)
		self.mainHead()
		ptype = None
		if request.has_key('ptype'):
			ptype = request['ptype'] 
		q = fc.getQueue(qname)
		self.send('<table cellpadding=2 border=0> <!-- Queue stats -->')
		sts = ''
		bg = "#77FF77"
		if q.IsHeld:
			sts = 'Held'
			bg = "#FFFF77"
		if q.IsLocked:
			bg = "#FF7777"
			if sts:
				sts = sts + '+Locked'
			else:
				sts = sts + 'Locked'
		if not sts: 	sts = 'OK'

		self.send('<tr><td align="right">Status:</td><td align="center" bgcolor="%s">%s</td>' % 
			(bg, sts))
		self.send('<td align="right">Running:</td><td %s>%s</td>' % 
					(SectionStateColors['running'], q.NRunning))
		self.send('    <td align="right">Pending:</td><td %s>%s</td><td></td>' % 
					(SectionStateColors['ready'], q.NPending))
		if request.has_key('showqpar') and request['showqpar']=='yes':
			self.send('<td><a href="%s">hide queue parameters</a></td>' %
					self.makeActionURL(request, 'showQueue', 
						qname=qname, showqpar='no'))
		else:
			self.send('<td><a href="%s">show queue parameters</a></td>' %
					self.makeActionURL(request, 'showQueue', 
						qname=qname, showqpar='yes'))
		self.send('</tr></table> <!-- End of queue stats -->')

		self.send('<table cellpadding=3 border=0 cellspacing=2> <!-- Queue pars -->')

		if request.has_key('showqpar') and request['showqpar']=='yes':
			self.send('<tr><td align="right">Def. Proc. Type:</td><td colspan=3>%s</td>' % 
						q.DefProcType)
			self.send('</tr>')
			self.send('<tr><td align="right">Allowed. Proc. Types:</td><td colspan=3>%s</td>' % 
						string.join(q.ProcTypes))
			self.send('</tr>'		)
			self.send('<tr><td align="right">Authorized Users:</td><td colspan=3>%s</td>' % 
						string.join(q.Users))
			self.send('</tr>'		)
			self.send('<tr><td align="right">Queue priority:</td><td>%s</td>' % q.Prio)
			self.send('    <td align="right">Min..max:</td><td>%s..%s</td><td></td></tr>' % 
						(q.MinQPrio, q.MaxQPrio))
			self.send('<tr><td align="right">Queue priority decrement:</td><td>%s</td>' % 
						q.QPDec)
			self.send('    <td align="right">gap:</td><td>%s</td><td></td></tr>' % 
						q.QPGap)
			self.send('<tr><td align="right">Section priority max:</td><td>%s</td>' % 
						q.MaxSPrio)
			self.send('    <td align="right">gap:</td><td>%s</td><td></td></tr>' % 
						q.SPGap)
			self.send('<tr><td align="right">Real time limit:</td><td>%s</td>' % 
						dtime(q.RealTimeLimit))
			self.send('    <td align="right">CPU time limit:</td><td>%s</td><td></td></tr>' % 
						dtime(q.CPUTimeLimit))

		istart = 0
		nsect = len(q.Sections)
		pageIndexStr = ''
		if nsect > 50:
			istart, thispage, pagestoshow = self.pageIndex(request, nsect, 50, 3)
			str = '<tr>\n  <td>Jump to page:</td> <td>'
			for ip in pagestoshow:
				if ip == thispage:
					str = str + ' [<b>%d</b>]' % ip
				elif ip == None:
					str = str + ' ... '
				else:
					str = str + ' [<a href="%s">%d</a>] ' % \
						(self.makeActionURL(request, 'showQueue', 
							qname=qname, page=ip), ip)
			str = str + '</td></tr>'
			self.send(str)
			pageIndexStr = str

		self.send('</table> <!-- End of queue pars -->')
			
		self.send('<table  width="100%" cellpadding=2>')
		self.send('<tr bgcolor="%s"><th>SectID</th><th>User</th><th>ProcType</th><th>Status</th><th>Prio</th><th>NProc</th><th>Date/Time</th></tr>' %
			THBgCol)
		ibgcol = -1
		for sid in q.Sections[istart:istart+50]:
			ibgcol = (ibgcol + 1) % len(LineBgColors)
			self.send('<tr bgcolor="%s">' % LineBgColors[ibgcol])

			try:	s = fc.getSection(sid)
			except KeyError:
				self.send('<td>%s</td><td colspan="6">-- deleted --</td>' % sid)
			else:

				if ptype != None and s.ProcType != ptype:
					continue
				nrun = 0
				for i in range(s.NProc):
					if s.ProcStats[i+1] == 'running':
						nrun = nrun + 1
				nprocstr = '%s/%s' % (nrun, s.NProc)
				self.send('  <td><a href="%s">%s</a></td>' %
					(self.makeActionURL(request, 'showSection', sid=sid), sid))
				state = sectState(s)
				try:	color = SectionStateColors[state]
				except: color = SectionStateColors['unknown']
				self.send('  <td>%s</td>' % s.Username)
				self.send('  <td><a href="%s">%s</a></td>' %
					(self.makeActionURL(request, 'showQueue', qname=qname, 
						ptype=s.ProcType), s.ProcType))
				self.send('  <td %s>%s</td><td>%s</td><td>%s</td>' % 
					(color, state, s.Prio,nprocstr))
				if state == 'running':
					self.send('  <td>Started at %s</td>' % atime(s.StartTime))
				elif state in ['ready','waiting']:
					self.send('  <td>Submitted at %s</td>' % atime(s.SubTime))
				elif state in ['done','failed','zombie','canceled']:
					self.send('  <td>Ended at %s</td>' % atime(s.EndTime))
				elif state == 'held':
					if s.HoldTime == -1:
						self.send('  <td>Held</td>')
					else:
						self.send('  <td>Held until %s</td>' % atime(s.HoldTime))
				else:	# ['ready','waiting']
					self.send('  <td>Submitted at %s</td>' % atime(s.SubTime))

			self.send('</tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()

	def recordRsrc(self, tup, rsrcs):
		rnlst, rmap = tup
		rmap.append(rsrcs[:])
		for rn in rsrcs:
			rnlst[rn] = 1

	def arrangeColumns(self, tup):
		rnlst, rmap = tup
		#sys.stderr.write('rnlst=%s\nrmap=%s\n' % tup)
		dct = {}
		rnlst = rnlst.keys()
		imax = -1
		for rn in rnlst:
			ic = 0
			conflict = 1
			while conflict:
				dct[rn] = ic
				conflict = 0
				for rsrc in rmap:
					tmp = {}
					for rr in rsrc:
						if not dct.has_key(rr): continue
						ii = dct[rr]
						if tmp.has_key(ii):
							conflict = 1
							break
						tmp[ii] = 1
					if conflict:	break
				if conflict:	ic = ic + 1
			if imax < ic:	imax = ic
		#sys.stderr.write('return imax=%s, dict=%s\n' % (imax,dct))
		return imax+1, dct

	def rsrcSubTable(self, inxdct, ncols, rsrc):
		cols = {}
		for i in range(ncols):
			cols[i] = ''
		for rn in inxdct.keys():
			if rsrc.has_key(rn):
				inx = inxdct[rn]
				val = rsrc[rn]
				if val == None:
					cols[inx] = rn
				else:
					cols[inx] = '%s:%s' % (rn, val)
		str = ''				
		for i in range(len(cols)):
			str = str + '<td>%s</td>' % cols[i]
		return str

	def doListPTypes(self, request, fc, cfg):
		farm = self.MyFarm
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		self.htmlHead('FBSWWW - Process types @ %s' % farm, refresh)
		self.pageHead(request, 'Process types')
		self.navBox(request)
		self.mainHead()
		ptnlst = fc.getProcessTypeList()
		ptnlst.sort()
		ptlst = []
		uinx = ({},[])
		qinx = ({},[])
		pinx = ({},[])
		sinx = ({},[])
		for ptn in ptnlst:
			try:	pt = fc.getProcessType(ptn)
			except: continue
			ptlst.append(pt)
			self.recordRsrc(uinx, pt.RsrcUsage.keys())
			self.recordRsrc(qinx, pt.RsrcQuota.keys())
			self.recordRsrc(pinx, pt.ProcRsrcDefaults.keys())
			self.recordRsrc(sinx, pt.SectRsrcDefaults.keys())

		nusg, ucols = self.arrangeColumns(uinx)
		nqta, qcols = self.arrangeColumns(qinx)
		npdef, pcols = self.arrangeColumns(pinx)
		nsdef, scols = self.arrangeColumns(sinx)

		nusg = max(nusg,1)
		nqta = max(nqta,1)
		npdef = max(npdef,1)
		nsdef = max(nsdef,1)

		self.send('<table cellpadding=2 border=0 width="100%">')
		self.send('<tr bgcolor="%s"><th rowspan=3>Process Type</th><th colspan=%d>Resources</th></tr>' %
			(THBgCol, nusg+nqta+npdef+nsdef))
		self.send('<tr bgcolor="%s">   <th rowspan=2 colspan=%d>Current Usage</th><th rowspan=2 colspan=%d>Quota</th><th colspan=%d>Defaults</th></tr>' %
			(THBgCol, nusg, nqta, npdef+nsdef))
		self.send('<tr bgcolor="%s">     <th colspan=%d>Per Process</th><th colspan=%d>Per Section</th></tr>' %
			(THBgCol, npdef, nsdef))
		ibg = -1
		for pt in ptlst:
			ptn = pt.Name
			ibg = (ibg + 1) % len(LineBgColors)
			self.send('<tr bgcolor="%s"><td>%s</td>' % (LineBgColors[ibg], ptn))
			self.send('   %s' % self.rsrcSubTable(ucols, nusg, pt.RsrcUsage))
			self.send('   %s' % self.rsrcSubTable(qcols, nqta, pt.RsrcQuota))
			self.send('   %s' % self.rsrcSubTable(pcols, npdef, pt.ProcRsrcDefaults))
			self.send('   %s' % self.rsrcSubTable(scols, nsdef, pt.SectRsrcDefaults))
			self.send('</tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()

	def doShowGraphs(self, request, fc, cfg):
		farm = self.MyFarm
		period = 'day'
		if request.has_key('period'):
			period = request['period']
		refresh = 180
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		self.htmlHead('FBSWWW - graphs for %s' % farm, refresh)
		self.pageHead(request, 'Graphs for <b>%s</b>' % farm)
		self.navBox(request)
		self.mainHead()
		self.send('<table width="100%%" cellpadding="1" bgcolor="#103D3B" border=0 cellspacing=0>')
		self.send('  <tr><td>')
		self.send('  <table cellpadding=3 cellspacing=3><tr>')
		self.send('    <td bgcolor="#80DDCB">Period:</td>')
		for x in ['day','week','2weeks','month','3months','year']:
			self.send('   <td bgcolor="#80DDCB">',)
			if x == period:
				self.send('<b>%s</b>' % period)
			else:
				self.send('<a href="%s">%s</a>' %
					(self.makeActionURL(request, 'graphs', period=x), x))
			self.send('</td>')
		self.send('   </tr></table>')
		self.send('  </td></tr>')
		lst = glob.glob1('%s/display' % self.GraphsDir,'*_%s.gif' % period)
		lst.sort()
		t = int(time.time())/180
		if lst:
			for gn in lst:
				self.send('<tr><td align="center">')
				fn_dpy = 'display/%s' % gn
				fn_print = 'print/%s' % gn
				url_dpy = '%s?graph=%s&t=%s' % (GetGraphURL, fn_dpy, t)
				url_print = '%s?graph=%s&t=%s' % (GetGraphURL, fn_print, t)
				self.send('<a href="%s"><IMG SRC="%s" border=0 alt="printable version"></a>' % 
					(url_print, url_dpy))
				self.send('</td></tr>')
			self.send('<tr><td bgcolor="#80DDCB" align="center">Built using <a href="http://people.ee.ethz.ch/~oetiker/webtools/rrdtool/" target="_blank">RRDTool</a></td></tr>')
		else:
			self.send('<tr><td bgcolor="#EEFFDD"><b><i>No graphs available for this farm/period</i></b></td></tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()


	def doShowSection(self, request, fc, cfg):
		sid = request['sid'] 
		farm = self.MyFarm
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		self.htmlHead('FBSWWW - section %s @ %s' % (sid,farm), refresh)
		self.pageHead(request, 'Section <b>%s</b> status' % sid)
		self.navBox(request)
		self.mainHead()
		try:	s = fc.getSection(sid)
		except:
			self.send('Section not found')
		else:
			state = sectState(s)
			self.send('<table cellpadding=2 border=0>')
			self.send('<tr><td align="right"><b>ID:</b></td><td>%s (Job: <a href="%s">%s</a>)</td>' % 
				(sid, 
				self.makeActionURL(request, 'showJob', jid = s.JobID),
				s.JobID)
			)
			self.send('    <td align="right"><b>User:</b></td><td>%s</td><td></td></tr>' % s.Username)
			self.send('<tr><td align="right"><b>Queue:</b></td><td><a href="%s">%s</a></td>' % 
				(self.makeActionURL(request, 'showQueue', qname = s.Queue),
				s.Queue)
			)
			self.send('    <td align="right"><b>Process Type:</b></td><td>%s</td></tr>' % 
					s.ProcType)
			#self.send('<tr><td align="right" valign="top">Command:</td><td colspan=10>%s</td></tr>' % s.Exec)
			self.send('<tr><td align="right"><b>NProc:</b></td><td>%s</td>' % s.NProc)
			self.send('    <td align="right"><b>Status:</b></td><td %s>%s</td></tr>' % 
				(SectionStateColors[state],state))
			self.send('<tr><td align="right"><b>Need:</b></td><td>%s</td>' % s.Need)
			self.send('    <td align="right"><b>Depends:</b></td><td>%s</td></tr>' % s.Depend)
			self.send('<tr><td align="right"><b>Submitted:</b></td><td>%s</td>' % 
					atime(s.SubTime))
			self.send('    <td align="right"><b>Started:</b></td><td>%s</td></tr>' %
					atime(s.StartTime))
			if s.HoldTime:
				self.send('<tr><td align="right"><b>Hold time:</b></td><td>%s</td></tr>' %
						atime(s.HoldTime))
			if s.RealTimeLimit > 0:
				self.send('<tr><td align="right"><b>Real time limit:</b></td><td>%s</td></tr>' %
						dtime(s.RealTimeLimit))
			if s.CPUTimeLimit > 0:
				self.send('<tr><td align="right"><b>CPU time limit:</b></td><td>%s</td></tr>' %
						dtime(s.CPUTimeLimit))

			self.send('<tr><td align="right"><b>Proc Rsrc:</b></td><td>%s</td>' %
				dict2str(s.PerProcRsrc))
			self.send('    <td align="right"><b>Sect Rsrc:</b></td><td>%s</td></tr>' %
				dict2str(s.PerSectRsrc))
			#self.send('<tr><td align="right"> </td><td>%s</td></tr>')
			self.send('</table>')
			self.send('<table><tr><td><b>Command:</b></td><td>%s</td></tr></table>' % s.Exec)
			try:	j = fc.getJob(s.JobID)
			except: pass
			else:
				seclst = j.sections()
				i = seclst.index(s.Name)
				if i > 5:
					seclst = ['...'] + seclst[i-5:]
				i = seclst.index(s.Name)
				if seclst[i+5:]:
					seclst = seclst[:i+5] + ['...']
				if len(seclst) > 1:
					self.send('<table><tr><td><b>Other sections:</b></td>')
					for sn in seclst:
						if sn == '...':
							self.send('   <td>...</td>')
						else:
							try:	s1 = j.getSection(sn)
							except: continue
							state = sectState(s1)
							color = SectionStateColors[state]
							if sn == s.Name:
								self.send('   <td %s><b>%s (%s)</b></td>' %
									(color, sn, state))
							else:
								self.send('   <td %s><a href="%s">%s</a> (%s)</td>' %
									(color, 
										self.makeActionURL(request, 'showSection', 
											sid=s1.ID), 
									sn, state))
					self.send('</tr></table>')

			if s.State in ['running','done','failed']:
				self.send('<hr>')
				self.send('Processes')
				self.send('<table cellpadding=2 cellspacing=2 border=0>')
				self.send('<tr bgcolor="%s"><th>Process #</th><th>Node</th><th>Status</th><th>CPU Time</th><th>PID</th><th>Command</th></tr>' %
					THBgCol)
				ibg = -1
				for i in range(s.NProc):
					ibg = (ibg + 1) % len(LineBgColors)
					ip = i + 1
					try:	pi = s.getProcess(ip)
					except:
						pi = s.getProcess(ip, local_details=0)
					sts = pi.Status
					if  sts == 'exited':
						sts = 'exited, code:%s core:%s' % \
							(pi.ExitCode, pi.Core)

					self.showProc(ip, ibg, pi, sts)
				self.send('</table>'	)
		self.mainTail()
		self.pageTail()

	def showProc(self, ip, ibg, pi, sts):
		self.send('<tr bgcolor="%s"><td>%s</td><td>%s</td><td %s>%s</td><td>%s</td><td>%s</td>' % 
						(LineBgColors[ibg], ip, pi.Node, ProcessStateColors[pi.Status],
						sts, dtime(pi.ACPUTime), pi.UPID))
		cmd = pi.Command
		self.send('<td>%s</td></tr>' % fmtCommand(cmd))
		if sts == 'running':
			pad = '&nbsp;&nbsp;'
			for spi in pi.Subprocesses:
				self.showSubProcess(ibg, pad, spi)

	def showSubProcess(self, ibg, pad, pi):
		self.send('<tr bgcolor="%s">' % LineBgColors[ibg])
		self.send('<td></td>' * 3)	# ip, node, sts
		self.send('<td>%s</td><td>%s</td>' % (dtime(pi.ACPUTime), pi.UPID))
		#self.send(pad, )
		cmd = pi.Command
		self.send('<td>%s</td>' % fmtCommand(cmd, pad))
		self.send('</tr>')
		for spi in pi.Subprocesses:
			self.showSubProcess(ibg, pad + '&nbsp;&nbsp;', spi)

	def doShowJob(self, request, fc, cfg):
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		jid = request['jid']
		self.htmlHead('FBSWWW - job %s' % (jid,), refresh)
		self.pageHead(request, 'Job %s' % (jid,))
		self.navBox(request)
		self.mainHead()
		try:	ji = fc.getJob(jid)
		except:
			self.send('Job not found')
		else:
			self.send('<table cellpadding=2 border=0>')
			self.send('<tr><td align="right"><b>ID:</b></td><td>%s</td></tr>' % jid)
			self.send('<tr><td align="right"><b>User:</b></td><td>%s</td><td></td></tr>' % ji.Username)
			state = ji.State
			try:	color = JobStateColors[state]
			except: color = JobStateColors['unknown']
			self.send('<tr><td align="right"><b>State:</b></td><td %s>%s</td></tr>' % 
				(color,state))
			self.send('<tr bgcolor="%s">' % (THBgCol,))
			self.send('  <th align="center"><b>Section</b></td>')
			self.send('  <th align="center"><b>State</b></td>')
			self.send('  <th align="center"><b>Procs</b></td>')
			self.send('  <th align="center"><b>Depends</b></td>')
			self.send('</tr>')
			sectnames = ji.sections()
			for sn in sectnames:
				si = ji.getSection(sn)
				sstate = si.State
				color = SectionStateColors[sstate]
				dep = si.Depend
				self.send('<tr %s>' % (color,))
				self.send('  <td><a href="%s">%s</td>' % 
					(self.makeActionURL(request, 'showSection', 
						sid=si.ID), sn,))
				self.send('  <td>%s</td>' % (sstate,))
				nrun = 0
				for i in range(si.NProc):
					if si.ProcStats[i+1] == 'running':
						nrun = nrun + 1
				nprocstr = '%s/%s' % (nrun, si.NProc)
				self.send('  <td>%s</td>' % (nprocstr,))
				self.send('  <td>%s</td>' % (dep,))
				self.send('</tr>')
			self.send('</table>')
		self.mainTail()
		self.pageTail()
		
				



	def doListJobs(self, request, fc, cfg):
		farm = self.MyFarm
		user = None
		if request.has_key('user'):
			user = request['user']
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
		self.htmlHead('FBSWWW - jobs @ %s' % farm, refresh)
		self.pageHead(request, 'List of jobs')
		self.navBox(request)
		self.mainHead()
		jobs = fc.getJobList(username=user)
		jobs.sort()
		self.send('<table  cellpadding=2 width="100%">')
		self.send('<tr bgcolor="%s"><th>Job ID</th><th>User</th><th>Status</th><th colspan=10>Sections</th></tr>' %
			THBgCol)
		ibg = -1
		for jid in jobs:
			ibg = (ibg + 1) % len(LineBgColors)
			try:	j = fc.getJob(jid)
			except: continue
			try:	color = JobStateColors[j.State]
			except: color = JobStateColors['unknown']
			self.send('<tr bgcolor="%s">' % (LineBgColors[ibg],))
			self.send('  <td><a href="%s">%s</a></td>' % 
					(self.makeActionURL(request, 'showJob', jid=jid), jid))
			self.send('  <td><a href="%s">%s</a></td><td %s>%s</td>' %
					(self.makeActionURL(request, 'listJobs', user=j.Username), 
					j.Username, color, j.State))
			for sn in j.sections():
				try:	s = j.getSection(sn)
				except: continue
				state = sectState(s)
				try:	color = SectionStateColors[state]
				except: color = SectionStateColors['unknown']
				self.send('<td %s><a href="%s">%s</a>:%s</td>' % 
					(color, 
					self.makeActionURL(request, 'showSection', sid=s.ID), 
					sn, state))
			self.send('</tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()

	def cmpNodes(self, x, y):
		ix = len(x)
		while ix > 0:
			if x[ix-1] in '0123456789':
				ix = ix -1
			else:
				break
		px = x[:ix]
		try:	nx = int(x[ix:])
		except: nx = 0
		iy = len(y)
		while iy > 0:
			if y[iy-1] in '0123456789':
				iy = iy -1
			else:
				break
		py = y[:iy]
		try:	ny = int(y[iy:])
		except: ny = 0
		return cmp(px, py) or cmp(nx, ny)

	def doListNodes(self, request, fc, cfg):
		farm = self.MyFarm
		state = None
		if request.has_key('state'):
			state = request['state']
		refresh = 60
		if request.has_key("refresh") and request["refresh"] == "manual":
			refresh = None
 
		self.htmlHead('FBSWWW - nodes @ %s' % (farm,), refresh)
		self.pageHead(request, 'List of farm nodes')
		self.navBox(request)
		self.mainHead()
		nnlst = fc.getNodeList()
		nnlst.sort(self.cmpNodes)
		nlst = []
		ndown = 0
		nheld = 0
		for nn in nnlst:
			try:	n = fc.getNode(nn)
			except: continue
			if n.IsHeld:	nheld = nheld + 1
			if not n.IsUp:	ndown = ndown + 1
			if state == None or \
						state == 'held' and n.IsHeld or \
						state == 'down' and not n.IsUp:
				nlst.append(n)
		if ndown or nheld:
			self.send('<table cellpadding=2 cellspacing=5><tr>')
			if ndown:
				self.send('  <td bgcolor="%s">%d <a href="%s">down</a></td>' % 
					(NodeStateColors['down'], ndown, 
					self.makeActionURL(request, 'listNodes', state='down'))
				)
			if nheld:
				self.send('  <td bgcolor="%s">%d <a href="%s">held</a></td>' % 
					(NodeStateColors['held'], nheld, 
					self.makeActionURL(request, 'listNodes', state='held'))
				)
			self.send('</tr></table>'				)

		self.send('<table cellpadding=2 width="100%">')
		self.send('<tr bgcolor="%s"><th>Node&nbsp;name</th><th>Class</th><th>Status</th><th colspan=10>Processes</th></tr>' %
			THBgCol)
		ibg = -1
		for n in nlst:
			ibg = (ibg + 1) % len(LineBgColors)
			self.send('<tr bgcolor="%s">' % LineBgColors[ibg])
			self.send('<td>%s</td><td>%s</td>' % (n.Name, n.Class))
			bg = NodeStateColors['OK']
			sts = 'OK'
			if n.IsHeld:
				bg = NodeStateColors['held']
				sts = 'Held'
			if not n.IsUp:
				bg = NodeStateColors['down']
				if sts == 'OK':
					sts = 'Down'
				else:
					sts = 'Down+' + sts
			self.send('<td bgcolor="%s" align="center">%s</td>' %
					(bg, sts))
			for pid in n.Processes:
				sid = '%s.%s' % tuple(string.split(pid, '.')[:2])
				self.send('<td><a href="%s">%s</a></td>' %
					(self.makeActionURL(request, 'showSection', sid=sid), pid)
				)
			self.send('</tr>')
			if n.IsHeld:
				r = n.HoldReason
				r = string.replace(r, '<','(')
				r = string.replace(r, '>',')')
				self.send('<tr bgcolor="%s"><td></td><td></td>' % LineBgColors[ibg],)
				self.send('<td bgcolor="#FFFF77">Hold Reason:</td><td bgcolor="#FFFF77" colspan=100>%s</td>' % r,)
				self.send('</tr>')
		self.send('</table>')
		self.mainTail()
		self.pageTail()



	def parseRequest(self, path):
		try:
			words = string.split(path, '?', 1)
			if not words:
				return None, None, None
			if len(words) == 1:
				words.append('')
			path, args = tuple(words)
			cmd = string.split(path, '/')[-1]
			argdict = {}
			args = string.split(args, '&')
			for arg in args:
				halves = string.split(arg, '=')
				if len(halves) < 2:
					halves = [halves[0],1]
				try:	halves[1] = int(halves[1])
				except: pass
				argdict[halves[0]] = halves[1]
			return path, cmd, argdict
		except:
			return None, None, None
			

	def do_GET(self):
		path, cmd, request = self.parseRequest(self.path)
		self.log('D', 'GET <%s> -> (<%s>, <%s>, <%s>)' % (self.path, path, cmd, request))
		if cmd == 'getgraph':
			try:	self.getGraphCommand(path, request)
			except:	
				print 'Error in getGraphCommand:'
				print sys.exc_type, sys.exc_value
				printTraceback()
		elif cmd == 'fbswww':
			try:	self.fbswwwCommand(path, request)
			except:	
				print 'Error in fbswwwCommand:'
				print sys.exc_type, sys.exc_value
				printTraceback()
		else:
			self.send_response(400)
			self.log('I', 'sent 400 response')
		self.disconnect()
		self.log('D', 'disconnected')
		return

	def getGraphCommand(self, path, request):
		if not request.has_key('graph'):
			self.send_response(400)
			return
		graph = request['graph']
		if not self.GraphsDir:
			self.send_response(400)
			return
		fn = '%s/%s' % (self.GraphsDir, graph)
		typ = string.split(graph, '.')[-1]

		try:	st = os.stat(fn)
		except:
			self.send_response(400)
			printTraceback()
			return
		mt = st[stat.ST_MTIME]
		et = mt + 120
		gmt = time.gmtime(mt)
		tstr = time.asctime(gmt)

		self.send_response(200)
		mime_type = 'application/octet-stream'
		if typ == 'gif':
			mime_type = 'image/gif'
		elif typ == 'png':
			mime_type = 'image/png'
		elif typ == 'jpg' or typ == 'jpeg':
			mime_type = 'image/jpeg'

		self.send_header('Last-modified', '%s GMT' % tstr)
		self.send_header('Expires', '%s GMT' % time.asctime(time.gmtime(et)))
		self.send_header('Content-type', '%s' % mime_type)
		self.end_headers()
		f = open(fn, 'r')
		eof = 0
		while not eof:
			data = f.read(100000)
			if data:
				try:	self.wfile.write(data)
				except: eof = 1
			else:
				eof = 1

	def fbswwwCommand(self, path, request):
		self.send_response(200)
		self.mimeHead()
		
		# apply defaults
		if not request.has_key('action'):
			request['action'] = 'listQueues'
		action = request['action']

		if not request.has_key('refresh'):
			request['refresh'] = 'auto'

		self.Cfg = ConfigFile(os.environ['FBS_CONFIG'])
		self.MyFarm = '(unknown)'
		farm = cfg.getValue('global', '*', 'farm_name')
		if farm:
			self.MyFarm = farm

		fc = FBSClient('FBSWWWd', cfg)
		if action == 'listQueues':
			self.doListQueues(request, fc)
		elif action == 'listActiveQueues':
			self.doListQueues(request, fc, activeOnly = 1)
		elif action == 'showQueue':
			self.doShowQueue(request, fc)
		elif action == 'selectFarm':
			self.doSelectFarm()
		elif action == 'showSection':
			self.doShowSection(request, fc, cfg)
		elif action == 'showJob':
			self.doShowJob(request, fc, cfg)
		elif action == 'listJobs':
			self.doListJobs(request, fc, cfg)
		elif action == 'listNodes':
			self.doListNodes(request, fc, cfg)
		elif action == 'listPTypes':
			self.doListPTypes(request, fc, cfg)
		elif action == 'graphs':
			self.doShowGraphs(request, fc, cfg)
		#print 'htmlTail...'
		self.htmlTail()
		#print 'end of get'

if __name__ == '__main__':
	import sys
	import getopt
	
	opts, args = getopt.getopt(sys.argv[1:], 'p:')
	port = None
	for opt, val in opts:
		if opt == '-p': port = int(val)
	cfg = ConfigFile(os.environ['FBS_CONFIG'])
	fbswww = FBSWWW(cfg, port = port)
	fbswww.run()
