#
# @(#) $Id: farmcfg.py,v 1.6 2001/03/13 15:59:01 ivm Exp $
#
# $Log: farmcfg.py,v $
# Revision 1.6  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.5  2000/10/04 15:02:15  ivm
# Moved farm_name to fbs.cfg/global
# Added missing fields to fbs.cfg example
# Copy global set in splitcfg
#
# Revision 1.4  2000/09/15 16:39:32  ivm
# Cosmetics
#
# Revision 1.1  2000/08/18 21:15:41  ivm
# Implemented dynamic re-configuration
#
#

from config import *
import os
import bmgr_global
import sys
import time
import string

class	FarmCfg(ConfigFile):
	def __init__(self, filename, max_versions=20):
		self.FileName = filename
		ConfigFile.__init__(self, filename)
		self.MaxVersions = max_versions
		self.MaxHistLen = 100
		self.HistPrefix = '##'
		self.HdrPrefix = '#-'
		
	def save(self, hist_record = '', make_backup = 1):
		# make backup copy
		for j in range(1, self.MaxVersions):
			i = self.MaxVersions - j
			fn1 = '%s.%d' % (self.FileName, i)
			fn2 = '%s.%d' % (self.FileName, i+1)
			try:	os.rename(fn1, fn2)
			except: pass
		try:	os.rename(self.FileName, '%s.1' % self.FileName)
		except: pass
		
		cfg_dict = {}
		#if self.getValue('global','*','farm_name'):
		#	cfg_dict['global'] = {'':{'farm_name':
		#		self.getValue('global','*','farm_name')}}
		cfg_dict = bmgr_global.G_ResourceManager.currentConfig(cfg_dict)
		cfg_dict = bmgr_global.G_QueueFinder.currentConfig(cfg_dict)
		cfg_dict = bmgr_global.G_ProcTypeFinder.currentConfig(cfg_dict)
		
		oldf = open('%s.1' % self.FileName, 'r')
		newf = open(self.FileName, 'w')

		# copy header
		l = oldf.readline()
		while l and l[:len(self.HdrPrefix)] == self.HdrPrefix:
			newf.write(l)
			l = oldf.readline()

		# skip blank lines
		while l and not string.strip(l):
			l = oldf.readline()

		# write new history record
		newf.write('\n')
		nhist = 0
		if hist_record:
			newf.write('%s %s: %s\n' % (self.HistPrefix,
				time.ctime(time.time()), hist_record))
			newf.write('%s\n' % self.HistPrefix)
			nhist = 2

		# copy old history records
		while l and nhist < self.MaxHistLen and \
					l[:len(self.HistPrefix)] == self.HistPrefix:
			newf.write(l)
			nhist = nhist + 1
			l = oldf.readline()
		newf.write('\n')
		
		oldf.close()
		
		try:	writeConfigFile(cfg_dict, newf)
		except:
			newf.close()
			print 'Can not write farm configuration: ', sys.exc_type,\
				sys.exc_value
		newf.close()
