#
# @(#) $Id: farm_config.py,v 1.31 2003/08/22 17:25:09 ivm Exp $
#
# $Log: farm_config.py,v $
# Revision 1.31  2003/08/22 17:25:09  ivm
# Tested min. nice for proctype
#
# Revision 1.30  2003/08/20 18:58:58  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.29  2001/11/20 19:42:15  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.28  2001/10/11 16:29:28  ivm
# Use raw_input and readline module to make ineractive mode
# smarter.
#
# Revision 1.27  2001/08/28 21:01:10  ivm
# Fixed RM.setRsrcPool()
# Added time limits to queue display in queues.py and "fbs config"
# Print correct error messages in submit
#
# Revision 1.26  2001/06/20 18:26:34  ivm
# Fixed minor bugs
#
# Revision 1.25  2001/06/12 19:47:53  ivm
# Updated for Python v2.1
#
# Revision 1.24  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.23  2001/03/19 16:22:12  ivm
# Added new fields to "show ptype" and "show queue" in farm_config
#
# Revision 1.22  2001/02/05 20:17:28  ivm
# Allow queues without default process type
#
# Revision 1.21  2000/11/30 20:23:18  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.20  2000/11/14 19:09:47  ivm
# Fixed syntax errors
# Recover Username from UID in SectParam
#
# Revision 1.19  2000/11/08 20:27:02  ivm
# Implemented FBSClient.getServerOptions()
# Fixed bugs
#
# Revision 1.18  2000/11/03 19:24:22  ivm
# Implemented Placement in RM and JDF
# Renamed tar files in clean-up scripts
# Added RPC library for Stats.so
#
# Revision 1.16  2000/10/26 17:03:26  ivm
# Added additional checks for resources and ptypes before removal
# Added "remove" functions to farm_config
#
# Revision 1.14  2000/10/23 15:48:05  ivm
# Added "copy" as a command
#
# Revision 1.13  2000/10/23 15:46:55  ivm
# Added copy nclass/ptype/queue functions
#
# Revision 1.12  2000/09/20 14:02:46  ivm
# Fixed minor bugs
#
# Revision 1.11  2000/09/15 16:39:32  ivm
# Cosmetics
#
# Revision 1.8  2000/09/12 15:00:01  ivm
# Implemented createLocalResource method and all related changes
#
# Revision 1.7  2000/09/07 17:54:55  ivm
# Implemented dynamic modification of local scratch disk mapping
#
# Revision 1.6  2000/09/05 16:12:14  ivm
# Fixed bug in farm_config
# Use serialize module to send node info
#
# Revision 1.5  2000/08/30 19:52:42  ivm
# Disconnect node on removal
# Fixed Usage printing in config
#
# Revision 1.4  2000/08/24 14:23:19  ivm
# Fixed bugs
# Shift queue priorities back to minimum
#
# Revision 1.3  2000/08/22 17:28:16  ivm
# Fixed bug in RM.getLocalRsrc with attributes on down nodes
# Added "show" functionality to config
#
# Revision 1.2  2000/08/21 21:09:53  ivm
# Fixed some bugs
#
# Revision 1.1  2000/08/21 20:34:34  ivm
# Renamed config.py -> farm_config.py
#
# Revision 1.1  2000/08/21 20:27:09  ivm
# Added config.py as "fbs config"
#
#

from FBS_API import FBSClient, FBSError
import Parser
import sys
import string

def dt2str(t, default='N/A'):
	if type(t) != type(1) and type(t) != type(1.0):
		return '%s' % t
	if t < 0:
		return default
	t0 = int(t)
	t = t0
	d = t/(24*3600)
	t = t % (24*3600)
	h = t/3600
	t = t % 3600
	m = t/60
	s = t % 60
	if d > 0:
		return '%d seconds (%d days, %d hours, %d minutes)' % (t0,d,h,m)
	else:
		return '%d seconds (%d hours, %d minutes, %d seconds)' % (t0,h,m,s)


def lst2str(lst, empty = '(none)'):
	if not lst: return empty
	else:		return string.join(lst)

def parseTime(str):
	orig_str = str
	mult = 1
	if str[-1] == 'd' or str[-1] == 'D':
		mult = 24*3600
		str = str[:-1]
	elif str[-1] == 'h' or str[-1] == 'H':
		mult = 3600
		str = str[:-1]
	elif str[-1] == 'm' or str[-1] == 'M':
		mult = 60
		str = str[:-1]
	elif str[-1] == 's' or str[-1] == 'S':
		mult = 1
		str = str[:-1]
	try:
		t = int(str) * mult
	except:
		print ValueError, 'Invalid time specification: <%s>' % orig_str
	return t

# 'copy' functions

CopyHelp = """
Usage:
copy	(ptype|nclass|queue) <existing object name> <new object name>
"""

def doCopyQueue(args):
	if len(args) != 2:
		print CopyHelp
		return 2
	oldn = args[0]
	newn = args[1]
	fc=FBSClient()
	try:	oldq = fc.getQueue(oldn)
	except	KeyError, val:
		print val
		return 1
	try:	newq = fc.createQueue(newn, oldq.DefProcType)
	except ValueError, txt:
		print txt
		return 1
	except KeyError, txt:
		print txt
		return 1
	for k in ['QPGap', 'QPInc', 'QPDec', 'MaxQPrio', 'MinQPrio',
				'MaxSPrio',
				'RealTimeLimit', 'CPUTimeLimit', 'SPGap']:
		newq.__dict__[k] = oldq.__dict__[k]
	sts, reason = newq.update()
	if not sts:
		print reason
		return 1
	return 0

def doCopyNClass(args):
	if len(args) != 2:
		print CopyHelp
		return 2
	oldn = args[0]
	newn = args[1]
	fc=FBSClient()
	try:	oldc = fc.getNodeClass(oldn)
	except	KeyError, val:
		print val
		return 1
	try:	newc = fc.createNodeClass(newn)
	except ValueError, txt:
		print txt
		return 1
	except KeyError, txt:
		print txt
		return 1
	sts, reason = newc.setRsrcCap(oldc.ResourceCap)
	if not sts:
		print reason
		return 1
	sts, reason = newc.setLocalDisks(oldc.LocalDisks)
	if not sts:
		print reason
		return 1
	return 0
	
def doCopyPType(args):
	if len(args) != 2:
		print CopyHelp
		return 2
	oldn = args[0]
	newn = args[1]
	fc=FBSClient()
	try:	oldpt = fc.getProcessType(oldn)
	except	KeyError, val:
		print val
		return 1
	try:	newpt = fc.createProcessType(newn)
	except ValueError, txt:
		print txt
		return 1
	except KeyError, txt:
		print txt
		return 1
	sts, reason = newpt.setSectRsrcDefs(oldpt.SectRsrcDefaults)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setProcRsrcDefs(oldpt.ProcRsrcDefaults)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setMaxPrioInc(oldpt.MaxPrioInc)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setRsrcQuota(oldpt.RsrcQuota)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setMaxNodeCount(oldpt.MaxNodeCount)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setCPUTimeLimit(oldpt.CPUTimeLimit)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setRealTimeLimit(oldpt.RealTimeLimit)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.setUsers(oldpt.Users)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.allowNodes(oldpt.NodesAllow)
	if not sts:
		print reason
		return 1
	sts, reason = newpt.disallowNodes(oldpt.NodesDisallow)
	if not sts:
		print reason
		return 1
	return 0

def doCopy(args):
	if len(args) != 3:
		print CopyHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'queue':
		return doCopyQueue(args)
	elif what == 'ptype':
		return doCopyPType(args)
	elif what == 'nclass':
		return doCopyNClass(args)
	else:
		print CopyHelp
		return 2


# "create" functions

def doCreQueue(args):
	if len(args) < 1:
		print CreateHelp
		return 2
	opts = args[1:]
	dpt = None
	if opts and string.find(opts[0], ':') < 0:
		dpt = opts[0]
		opts = opts[1:]
	fc=FBSClient()
	try:	q = fc.createQueue(args[0], dpt)
	except ValueError, txt:
		print 'Can not create queue <%s>: %s' % (args[0], txt)
		return 1
	except KeyError, txt:
		print 'Can not create queue <%s>: %s' % (args[0], txt)
		return 1
	if opts:
		return doSetQueue(opts, q)
	return 0

def doCrePType(args):
	if not args:
		print CreateHelp
		return 2
	fc=FBSClient()
	try:	pti = fc.createProcessType(args[0])
	except ValueError, txt:
		print 'Can not create process type <%s>: %s' % (args[0], txt)
		return 1
	except KeyError, txt:
		print 'Can not create process type <%s>: %s' % (args[0], txt)
		return 1
	if args[1:]:
		return doSetPType(args[1:], pti)
	return 0

def doCreNClass(args):
	if not args:
		print CreateHelp
		return 2
	fc=FBSClient()
	try:	nci = fc.createNodeClass(args[0])
	except ValueError, txt:
		print 'Can not create node class <%s>: %s' % (args[0], txt)
		return 1
	except KeyError, txt:
		print 'Can not create node class <%s>: %s' % (args[0], txt)
		return 1
	return 0

def doCrePool(args):
	if not args:
		print CreateHelp
		return 2
	fc=FBSClient()
	try:	sts, reason = fc.createRsrcPool(args[0], args[1:])
	except KeyError, txt:
		print txt
		return 1
	except:
		print sys.exc_type, sys.exc_value
		return 1
	if not sts:
		print 'Can not create pool <%s>: %s' % (args[0], reason)
		return 1
	return 0

def doCreGR(args):
	if not args:
		print CreateHelp
		return 2
	dct = Parser.wordsToDict(args, defValue=None)
	if not dct:
		print CreateHelp
		return 2
	fc=FBSClient()
	for k, v in dct.items():
		if type(k) != type('') or type(v) != type(1) or v < 0:
			print 'Invalid parameter type or value'
			print CreateHelp
			return 2
		sts, reason = fc.createGlobalResource(k, v)
		if not sts:
			print 'Can not create global resource <%s>: %s' % (k, reason)
			return 1
	return 0
		
def doCreLR(args):
	if not args:
		print CreateHelp
		return 2
	fc=FBSClient()
	for rn in args:
		sts, reason = fc.createLocalResource(rn)
		if not sts:
			print 'Can not create local resource <%s>: %s' % (rn, reason)
			return 1
	return 0

CreateHelp = """
Usage:
create  queue   <queue name> [<def.proc.type>] [<parameters>]
create  nclass  <node class name>
create  ptype   <proc type name> [<parameters>]
create  pool    <pool name> <resource name> ...
create  gr      <global resource name>:<capacity> ...
create  lr      <local resource name> ...

Type "set <keyword>" for details on parameters.
"""

def doCreate(args):
	if len(args) < 1:
		print CreateHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'queue':
		return doCreQueue(args)
	elif what == 'ptype':
		return doCrePType(args)
	elif what == 'nclass':
		return doCreNClass(args)
	elif what == 'pool':
		return doCrePool(args)
	elif what == 'gr':
		return doCreGR(args)
	elif what == 'lr':
		return doCreLR(args)
	else:
		print CreateHelp
		return 2

def promptDict(dict):
	for k, v in dict.items():
		sys.stdout.write('%s [%s]: ' % (k,v))
		sys.stdout.flush()
		ln = sys.stdout.readline()
		if not ln:	return 1
		val = string.strip(ln)
		if not val: 	continue
		if val == 'None':	val = None
		else:
			try:	val = string.atoi(val)
			except: pass
		dict[k] = val
	return 0


		
# "set" functions

SetQueueHelp = """
Usage:  set queue   <queue name> <parameter>[:<value>] ...
            Parameters: Prio, MaxQPrio, MinQPrio,
                QPGap, QPInc, QPDec,
                MaxSPrio, SPGap,
                DefProcType, RealTimeLimit, CPUTimeLimit
        set queue <queue name> users (-|*|<user> ...)
        set queue <queue name> ptypes (-|*|<ptype> ...)
"""


def doSetQueue(args, qi=None):
	if qi:
		if not args:
			print SetQueueHelp
			return 2
	else:
		if len(args) < 2:
			print SetQueueHelp
			return 2
		name = args[0]
		args = args[1:]
		fc=FBSClient()
		try:	qi = fc.getQueue(name)
		except KeyError, txt:
			print txt
			return 1
		except:
			print sys.exc_type, sys.exc_value
			return 1
            
	if args[0] == 'users':
		ulst = args[1:]
		if ulst[0] == '-':  ulst = []
		if '*' in ulst:     ulst = ['*']
		qi.Users = ulst
	elif args[0] == 'ptypes':
		plst = args[1:]
		if plst[0] == '-':  plst = []
		if '*' in plst:     plst = ['*']
		qi.ProcTypes = plst
	else:
		dict = Parser.wordsToDict(args,defValue=None)
		if not dict:
			for k in ['QPGap', 'QPInc', 'QPDec', 'MaxQPrio', 'MinQPrio',
					'MaxSPrio', 'Prio', 'DefProcType',
					'RealTimeLimit', 'CPUTimeLimit', 'SPGap']:
				dict[k] = qi.__dict__[k]
				if promptDict(dict):
					return 0		# EOF
		for k, v in dict.items():
			if v == None:
				print 'Invalid value for parameter <%s>' % k
				print SetQueueHelp
				return 2
		for k, v in dict.items():
			if k not in ['QPGap', 'QPInc', 'QPDec', 'MaxQPrio', 'MinQPrio',
					'MaxSPrio', 'Prio', 'DefProcType',
					'RealTimeLimit', 'CPUTimeLimit', 'SPGap']:
				print 'Unknown parameter <%s>' % k
				print SetQueueHelp
				return 2
			if v == None:
				if k in ['RealTimeLimit', 'CPUTimeLimit']:
					v = -1
				else:
					print 'Invalid value for parameter <%s>' % k
					print SetQueueHelp
					return 2
			qi.__dict__[k] = v
	sts, reason = qi.update()
	if not sts: print reason
	return sts == 0

SetNClassHelp = """
Usage:  set nclass <node class name> rsrcs <resource>:<capacity> ...
        set nclass <node class name> disks <disk name>:<root directory> ...
        set nclass <node class name> power <relative power>
"""

def doSetNClass(args, nci = None):
	if nci:
		if len(args) < 2:
			print SetNClassHelp
			return 2
	else:
		if len(args) < 3:
			print SetNClassHelp
			return 2
		nc = args[0]
		args = args[1:]
		fc=FBSClient()	
		try:	nci = fc.getNodeClass(nc)
		except KeyError, txt:
			print txt
			return 1
		except:
			print sys.exc_type, sys.exc_value
			return 1

	if args[0] == 'rsrcs':
		rdict = Parser.wordsToDict(args[1:],defValue=None)
		sts, reason = nci.setRsrcCap(rdict)
		if not sts:
			print reason
			return 1

	elif args[0] == 'power':
		try:	value = string.atof(args[1])
		except:
			print 'Invalid relative power value. Must be positive numeric.'
			print SetNClassHelp
			sys.exit(2)
		if type(value) != type(1) and type(value) != type(1.0):
			print 'Invalid relative power value. Must be positive numeric.'
			print SetNClassHelp
			sys.exit(2)
		value = float(value)
		if value <= 0.0:
			print 'Invalid relative power value. Must be positive numeric.'
			print SetNClassHelp
			sys.exit(2)
		sts, reason = nci.setPower(value)
		if not sts:
			print reason
			return 1
		
						
	elif args[0] == 'disks':
		dict = Parser.wordsToDict(args[1:],defValue=None)
		for k, v in dict.items():
			if type(k) != type('') or type(v) != type(''):
				print SetNClassHelp
				return 2
		sts, reason = nci.setLocalDisks(dict)
		if not sts:
			print reason
			return 1
	else:
		print SetNClassHelp
		return 2
	return 0
	
SetPTypeHelp = """
Usage:  set ptype   <proc type name>    <parameter> <value>
Parameters and values:
srdef    (-|<resource>:[<amount>] ...)  - dflt. section resources req.
prdef    (-|<resource>:[<amount>] ...)  - dflt. process resources req.
rquota   (-|<resource>:<amount> ...)    - resource allocation quota
maxpinc  (-|<value>)                    - max. section priority increment
maxnodes (-|<value>)                    - max number of nodes to run on
realtime (-|<n>[d|h|m|s])               - process real time limit
cputime  (-|<n>[d|h|m|s])               - process CPU time limit
nice     <value>                        - minimal NICE value
users    (-|*|<user> ...)               - authorized users
+nodes   (-|*|<node> ...)               - nodes allowed to run on
-nodes	 (-|*|<node> ...)               - nodes disallowed to run on
"""

def doSetPType(args, pti = None):
	if pti:
		if len(args) < 2:
			print SetPTypeHelp
			return 2
		what = args[0]
		args = args[1:]
	else:
		if len(args) < 3:
			print SetPTypeHelp
			return 2 
		name = args[0]
		what = args[1]
		args = args[2:]
		fc=FBSClient()
		try:	pti = fc.getProcessType(name)
		except KeyError, txt:
			print txt
			return 1
		except:
			print sys.exc_type, sys.exc_value
			return 1

	if what == 'users':
		ulst = args[:]
		if '*' in ulst: ulst = ['*']
		if ulst[0] == '-':	ulst = []
		sts, reason = pti.setUsers(ulst)
		if not sts:
			print reason
			return 1
	elif what == '+nodes':
		nlst = args[:]
		if '*' in nlst: nlst = ['*']
		if nlst[0] == '-':	nlst = []
		sts, reason = pti.allowNodes(nlst)
		if not sts:
			print reason
			return 1
	elif what == '-nodes':
		nlst = args[:]
		if '*' in nlst: nlst = ['*']
		if nlst[0] == '-':	nlst = []
		sts, reason = pti.disallowNodes(nlst)
		if not sts:
			print reason
			return 1
	elif what == 'realtime':
		if args[0] == '-':
			t = -1
		else:
			t = parseTime(args[0])
		sts, reason = pti.setRealTimeLimit(t)
		if not sts:
			print reason
			return 1
	elif what == 'cputime':
		if args[0] == '-':
			t = -1
		else:
			t = parseTime(args[0])
		sts, reason = pti.setCPUTimeLimit(t)
		if not sts:
			print reason
			return 1
	elif what == 'maxnodes':
		if args[0] == '-':
			n = None
		else:
			n = int(args[0])
		sts, reason = pti.setMaxNodeCount(n)
		if not sts:
			print reason
			return 1
	elif what == 'nice':
		n = int(args[0])
		sts, reason = pti.setMinNice(n)
		if not sts:
			print reason
			return 1
	else:
		if args[0] == '-':
			dict = {}
		else:
			dict = Parser.wordsToDict(args, defValue = None)
		if what == 'srdef':
			sts, reason = pti.setSectRsrcDefs(dict)
			if not sts:
				print reason
				return 1
		elif what == 'prdef':
			sts, reason = pti.setProcRsrcDefs(dict)
			if not sts:
				print reason
				return 1
		elif what == 'rquota':
			sts, reason = pti.setRsrcQuota(dict)
			if not sts:
				print reason
				return 1
		elif what == 'maxpinc':
			val = None
			if args and args[0] != '-':
				try:	val = string.atoi(args[0])
				except:
					print SetPTypeHelp
					return 2
			sts, reason = pti.setMaxPrioInc(val)
			if not sts:
				print reason
				return 1
		else:
			print SetPTypeHelp		
			return 2
	return 0
	
SetPoolHelp = """
Usage: set pool <name> <resource> ...
"""

def doSetPool(args):
	if len(args) < 2:
		print SetPoolHelp
		return 2
	name = args[0]
	args = args[1:]
	fc=FBSClient()
	try:	sts, reason = fc.setRsrcPool(name, args)
	except KeyError, txt:
		print txt
		return 1
	if not sts: print reason
	return not sts

SetGRHelp = """
Usage:  set gr      <global rsrc name>  <capacity>
"""
	
def doSetGR(args):
	if len(args) < 2:
		print SetGRHelp
		return 2
	name = args[0]
	args = args[1:]
	fc=FBSClient()
	try:	cap = string.atoi(args[0])
	except:
		print SetGRHelp
		return 2
	try:	sts, reason = fc.setGlobalResource(name, cap)
	except KeyError, txt:
		print txt
		return 1
	if not sts: print reason
	return not sts

SetHelp = """
Usage:

set queue   <queue name>        <parameter>:<value> ...
set nclass  <node class name>   rsrcs   <resource>:<capacity> ...
set nclass  <node class name>   disks   <disk name>:<root directory> ...
set ptype   <proc type name>    <parameter> <value>
set pool    <pool name>         <resource> ...
set gr      <global rsrc name>  <capacity>
"""

def doSet(args):
	if len(args) < 1:
		print SetHelp
		return 2
	what = args[0]
	if what == 'queue':
		return doSetQueue(args[1:])
	elif what == 'nclass':
		return doSetNClass(args[1:])
	elif what == 'ptype':
		return doSetPType(args[1:])
	elif what == 'pool':
		return doSetPool(args[1:])
	elif what == 'gr':
		return doSetGR(args[1:])
	else:
		print SetHelp
		return 2

# "add" functions

AddNodeHelp = """
Usage:  add node <node class name> <node name> ...
"""

def doAddNode(args):
	if len(args) < 2:
		print AddNodeHelp
		return 2
	ncn = args[0]
	nlst = args[1:]
	try:	nci = FBSClient().getNodeClass(ncn)
	except KeyError, txt:
		print txt
		return 1
	for nn in nlst:
		sts, reason = nci.addNode(nn)
		if not sts:
			print 'Can not add node <%s>: %s' %(nn, reason)
			return 1
	return 0

AddHelp = """
Usage:  add node <node class name> <node name> ...
"""
	
def doAdd(args):
	if len(args) < 2:
		print AddHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'node':
		return doAddNode(args)
	else:
		print AddHelp
		return 2
		
# remove functions

RemoveHelp = """
Usage: 
remove node <name> ...
remove queue <name> ...
remove ptype <name> ...
remove nclass <name> ...
remove pool <name> ...
remove lr <name> ...
remove gr <name> ...
"""

def doRemoveQueue(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	qlst = args
	fc = FBSClient()
	for qn in qlst:
		sts, reason = fc.removeQueue(qn)
		if not sts:
			print reason
			return 1
	return 0

def doRemovePType(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	lst = args
	fc = FBSClient()
	for n in lst:
		sts, reason = fc.removeProcessType(n)
		if not sts:
			print reason
			return 1
	return 0

def doRemoveNClass(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	lst = args
	fc = FBSClient()
	for n in lst:
		sts, reason = fc.removeNodeClass(n)
		if not sts:
			print reason
			return 1
	return 0

def doRemoveLR(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	lst = args
	fc = FBSClient()
	for n in lst:
		sts, reason = fc.removeLocalResource(n)
		if not sts:
			print reason
			return 1
	return 0

def doRemoveGR(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	lst = args
	fc = FBSClient()
	for n in lst:
		sts, reason = fc.removeGlobalResource(n)
		if not sts:
			print reason
			return 1
	return 0

def doRemovePool(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	lst = args
	fc = FBSClient()
	for n in lst:
		sts, reason = fc.removeRsrcPool(n)
		if not sts:
			print reason
			return 1
	return 0

def doRemoveNode(args):
	if len(args) < 1:
		print RemoveHelp
		return 2
	nlst = args
	fc = FBSClient()
	for nn in nlst:
		try:	ni = fc.getNode(nn)
		except KeyError, txt:
			print txt
			continue
		ncn = ni.Class
		try:	nc = fc.getNodeClass(ncn)
		except KeyError, txt:
			print txt
			continue
		sts, reason = nc.removeNode(nn)
		if not sts:
			print 'Can not remove node <%s>: %s' %(nn, reason)
			return 1
	return 0
	
def doRemove(args):
	if len(args) < 2:
		print RemoveHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'node':
		return doRemoveNode(args)
	elif what == 'pool':
		return doRemovePool(args)
	elif what == 'nclass':
		return doRemoveNClass(args)
	elif what == 'queue':
		return doRemoveQueue(args)
	elif what == 'ptype':
		return doRemovePType(args)
	elif what == 'lr':
		return doRemoveLR(args)
	elif what == 'gr':
		return doRemoveGR(args)
	else:
		print RemoveHelp
		return 0

CommandHelp = """

Commands:

create  queue   <queue name> [<parameters>]
create  nclass  <node class name> [<parameters>]
create  ptype   <proc type name> [<parameters>]
create  pool    <pool name> <resource name> ...
create  gr      <global resource name> <capacity>
create  lr      <local resource or attribute name>

set     queue   <queue name> [<parameters>]
set     nclass  <node class name> [<parameters>]
set     pool    <pool name> <resource> ...
set     ptype   <proc type name> [<parameters>]
set     gr      <global resource name> <capacity>

copy	(ptype|nclass|queue) <existing object name> <new object name>

show	(queue|nclass|pool|ptype|rsrc) [<name> ...]

remove  (node|pool|gr|lr|ptype|nclass|queue) <name> ...

add     node    <node class name> <node name> ...

lock    queue   (all|<name> ...)
unlock  queue   (all|<name> ...)

For more details, type first one or two words of the
command, e.g. "create gr".
"""


def doShowQueue(args):
	fc=FBSClient()
	short = 0
	if not args:
		args = fc.getQueueList()
		args.sort()
		short = 1
	print '%-16s %16s %5.5s %9.9s %9.9s %5.5s %5.5s %5.5s' % ('Name', 
				'ProcType', 'QPrio',
				'Inc/Dec ', 'Min-Max ', 'Gap', 'MaxSP', 'SPGap')
	for qn in args:
		try:	q = fc.getQueue(qn)
		except KeyError: 
			print '%10s -- not found' % qn
			continue
		except:
			print sys.exc_type, sys.exc_value
			continue
		incstr = '+%d' % q.QPInc
		decstr = '-%d' % q.QPDec
		idstr = '%4s/%-4s' % (incstr, decstr)
		sts = ''
		if q.IsHeld:	sts = sts + 'h'
		if q.IsLocked:	sts = sts + 'l'
		print '%-16s %16s %5d %9s %4d-%-4d %5d %5d %5d %s' % (qn,
				q.DefProcType, q.Prio, idstr,
				q.MinQPrio, q.MaxQPrio, q.QPGap,
				q.MaxSPrio, q.SPGap,
				sts)
		if not short:
			print '    Real Time Limit: %s' % dt2str(q.RealTimeLimit, '(none)')
			print '    CPU Time Limit:  %s' % dt2str(q.CPUTimeLimit, '(none)')
			print '    Users:           %s' % lst2str(q.Users, '(all)')
			print '    Process Types:   %s' % lst2str(q.ProcTypes, '(all)')
	return 0
		
def doShowPType(args):
	fc=FBSClient()
	if not args:
		args = fc.getProcessTypeList()
		args.sort()
	for pt in args:
		try:	pti = fc.getProcessType(pt)
		except KeyError: 
			print '%10s -- not found' % pt
			continue
		except:
			print sys.exc_type, sys.exc_value
			continue
		print '%-12s               Quota:' % ('%s:' % pt),
		for k, v in pti.RsrcQuota.items():
			print '%s:%s ' % (k, v),
		print ''
		print '                      MaxPrioInc: %s' % pti.MaxPrioInc
		print '       Default process resources:',
		for k, v in pti.ProcRsrcDefaults.items():
			if v:
				print '%s:%s ' % (k, v),
			else:
				print '%s ' % k,
		print ''
		print '       Default section resources:',
		for k, v in pti.SectRsrcDefaults.items():
			if v:
				print '%s:%s ' % (k, v),
			else:
				print '%s ' % k,
		print ''
		print '                Authorized users:', lst2str(pti.Users,'-')
		print '                Allowed on nodes:', lst2str(pti.NodesAllow,'-')
		print '             Disallowed on nodes:', lst2str(pti.NodesDisallow,'-')
		print '         Maximum number of nodes:', pti.MaxNodeCount
		print '              Minimal NICE level:', pti.MinNice
		print '          Process CPU time limit:', dt2str(pti.CPUTimeLimit,'(no limit)')
		print '         Process real time limit:', dt2str(pti.RealTimeLimit,'(no limit)')
		print ''
	return 0
	
def doShowNClass(args):
	fc=FBSClient()
	if not args:
		args = fc.getNodeClassList()
		args.sort()
	for ncn in args:
		try:	nci = fc.getNodeClass(ncn)
		except KeyError:
			print 'Node class %s: -- not found' % ncn
			continue
		print 'Node class %s:' % ncn
		print 'Relative power: ', nci.Power
		print '      Resources:',
		for k, v in nci.ResourceCap.items():
			if v != None:
				print '%s:%s' % (k,v),
			else:
				print '%s' % k,
		print ''
		print '    Local disks:',
		for k, v in nci.LocalDisks.items():
			print '%s:%s ' % (k,v),
		print ''
		nci.Nodes.sort()
		line = '    %4d node(s): ' % len(nci.Nodes)
		for nn in nci.Nodes:
			line = line + ('%s ' % nn)
			if len(line) + len(nn) > 60:
				print line
				line = '        '
		print line
		print ''
	return 0

def doShowPool(args):
	fc=FBSClient()
	lplst = fc.getLocalPoolList()
	lplst.sort()
	#print lplst
	gplst = fc.getGlobalPoolList()
	gplst.sort()
	#print gplst
	if not args:
		args = lplst + gplst
	for rp in args:
		tp = 'L'
		if rp in gplst: tp = 'G'
		print '%10s (%s): %s' % (rp, tp, string.join(fc.getResourcePool(rp)))
	return 0
		
def doShowRsrc(args):
	fc=FBSClient()
	lrlst = fc.getLocalRsrcList()
	lrlst.sort()
	grlst = fc.getGlobalRsrcList()
	grlst.sort()

	if not args:
		args = lrlst + grlst
	print '%10s %4s %10s %10s' % ('Name','Type','Used','Capacity')
	for rn in args:
		if rn in grlst:
			tp = 'G'
			usg, cap = fc.getGblRsrcUsage(rn)
			print '%10s %4s %10d %10d' % (rn, tp, usg, cap)
		else:
			tp = 'L'
			usg, cap = fc.getLclRsrcUsage(rn, None)
			if cap != None:
				print '%10s %4s %10d %10d' % (rn, tp, usg, cap)
			else:			
				print '%10s %4s %10d %10s' % (rn, tp, usg, '(attr)')
	return 0

ShowHelp = """
Usage:

show queue [<queue> ...]
show ptype [<ptype> ...]
show nclass [<nclass> ...]
show pool [<pool> ...]
show rsrc [<rsrc> ...]
"""

def doShow(args):
	if not args:
		print ShowHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'queue':
		return doShowQueue(args)
	elif what == 'ptype':
		return doShowPType(args)
	elif what == 'nclass':
		return doShowNClass(args)
	elif what == 'pool':
		return doShowPool(args)
	elif what == 'rsrc':
		return doShowRsrc(args)
	else:
		print ShowHelp
		return 2
		
def doUnockQueue(args):
	if not args:
		print LockHelp
		return 2
	fc=FBSClient()
	if args[0] == 'all':
		args = fc.getQueueList()
	for qn in args:
		sts, reason = fc.unlockQueue(qn)
		if not sts:
			print reason
			return 1
	return 0
			
def doUnlock(args):
	if len(args) < 2:
		print LockHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'queue':
		return doUnockQueue(args)
	else:
		print LockHelp
		return 2
		
def doLockQueue(args):
	if not args:
		print LockHelp
		return 2
	fc=FBSClient()
	if args[0] == 'all':
		args = fc.getQueueList()
	for qn in args:
		sts, reason = fc.lockQueue(qn)
		if not sts: 
			print reason
			return 1
	return 0
		

LockHelp = """
Usage:

lock queue (all|<name> ...)
unlock queue (all|<name> ...)
"""
	
def doLock(args):
	if len(args) < 2:
		print LockHelp
		return 2
	what = args[0]
	args = args[1:]
	if what == 'queue':
		return doLockQueue(args)
	else:
		print LockHelp
		return 2

def doCmd(args):
	if not args:
		print CommandHelp
		return 2
	cmd = args[0]
	args = args[1:]
	if cmd == 'create':
		return doCreate(args)
	elif cmd == 'set':
		return doSet(args)
	elif cmd == 'remove':
		return doRemove(args)
	elif cmd == 'show':
		return doShow(args)
	elif cmd == 'add':
		return doAdd(args)
	elif cmd == 'lock':
		return doLock(args)
	elif cmd == 'unlock':
		return doUnlock(args)
	elif cmd == 'copy':
		return doCopy(args)
	else:
		print CommandHelp
		return 2

def main(args):
	try:	import readline
	except: pass
	if args:
		return doCmd(args)
	else:
		while 1:
			try:	cmd = raw_input('fbscfg> ')
			except	EOFError:
				print ''
				break
			cmd = string.strip(cmd)
			if not cmd:
				continue
			if cmd in ['help','?']: 		print CommandHelp
			elif cmd in ['exit','quit']:	return 0
			else:
				words = string.split(cmd)
				try:	doCmd(words)
				except KeyError, txt:
					print txt
				except FBSError, txt:
					print txt
				except:
					print sys.exc_type, sys.exc_value
				print ''
	sys.exit(0)

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
