#
# @(#) $Id: Timer.py,v 1.2 2001/01/31 20:44:43 ivm Exp $
#
# $Log: Timer.py,v $
# Revision 1.2  2001/01/31 20:44:43  ivm
# Make Timer more tolerant to system clock shifts
#
# Revision 1.1  2000/04/18 17:58:24  ivm
# Added Timer.py
#
#

import time

class	Timer:
	def __init__(self):
		self.Schedule = []
		self.LastRun = time.time()
				
	def add(self, fcn, next, interval, repeat = 1):
		self.Schedule.append((fcn, next, interval, repeat))
		
	def run(self):
		t = time.time()
		if t < self.LastRun:
			s = []
			# somebody re-adjusted system clock
			delta = self.LastRun - t
			for fcn, next, interval, repeat in self.Schedule:
				if next > self.LastRun:
					next = next - delta
				s.append((fcn, next, interval, repeat))
			self.Schedule = s

		s = []
			
		#print 'Timer.run() at %s' % t
		for fcn, next, interval, repeat in self.Schedule:
			#print 'Timer: t = %s, next = %s' % (t, next)
			if next == 0:	next = t
			if t >= next:
				fcn()
				next = next + interval
				if repeat:
					s.append((fcn, next, interval, repeat))
			else:
				s.append((fcn, next, interval, repeat))
		self.Schedule = s
		self.LastRun = t
