#
# @(#) $Id: SectParam.py,v 1.50 2003/08/20 18:58:57 ivm Exp $
#
# $Author: ivm $
#
# $Log: SectParam.py,v $
# Revision 1.50  2003/08/20 18:58:57  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.49  2001/11/26 17:56:37  ivm
# Implemented ptype.timelimits, ptype.maxnodes in API, NetIF, SectParam, UI
# Other minor improvements
#
# Revision 1.48  2001/11/20 19:42:14  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.47  2001/04/20 17:41:25  ivm
# Fixed numerous bugs
#
# Revision 1.46  2001/03/16 17:46:58  ivm
# Fixed some bugs
# Made v1_3_2
#
# Revision 1.45  2001/03/15 21:47:54  ivm
# Implemented "on nodes"
# Fixed protocol version handling in lch, lchif
#
# Revision 1.44  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.43  2001/03/12 19:28:38  ivm
# Added "object ownersip" feature
#
# Revision 1.42  2001/02/05 20:09:09  ivm
# Check more accurately whether queue name is specified
# Allow queues without default process type
#
# Revision 1.41  2000/12/21 18:25:22  ivm
# Removed debug print-out
#
# Revision 1.40  2000/11/14 19:09:46  ivm
# Fixed syntax errors
# Recover Username from UID in SectParam
#
# Revision 1.39  2000/11/03 22:32:34  ivm
# Fixed bugs
#
# Revision 1.38  2000/11/01 16:06:06  ivm
# Made compile for SunOS
# Introduced "placement" parameter to allocateLocal methods
#
# Revision 1.36  2000/10/24 16:05:13  ivm
# Send Exec to BMGR as serialized list, not string
# Call killJob, not killSection, killSection, ... in kill.py
#
# Revision 1.35  2000/10/11 19:36:58  ivm
# Added FBSNodeInfo.holdNode()
# Implemented credentials creation by Launcher
#
# Revision 1.34  2000/09/27 20:18:36  ivm
# Renamed Scheduler.canRun() to trigger()
#
# Revision 1.33  2000/08/18 21:15:40  ivm
# Implemented dynamic re-configuration
#
# Revision 1.32  2000/08/14 14:39:55  ivm
# *** empty log message ***
#
# Revision 1.31  2000/08/08 16:19:46  ivm
# Fixed user message sending from batch process to API
#
# Revision 1.30  2000/08/03 16:00:20  ivm
# Recognize pools too in filling PerProc and PerSect fields
#
# Revision 1.29  2000/06/27 19:42:02  ivm
# Send hold time as string, not floating point number
#
# Revision 1.28  2000/06/02 19:38:46  ivm
# Added and removed debug output
#
# Revision 1.27  2000/05/23 22:41:49  ivm
# Fixed SECT_RESOURCES
#
# Revision 1.26  2000/05/12 20:09:24  ivm
# Implemented SectResources and ProcResources
#
# Revision 1.25  2000/05/11 17:22:01  ivm
# Added r2shm and related code.
# Added SectOutput related code
#
# Revision 1.24  2000/04/28 20:49:35  ivm
# Fixed bug
#
# Revision 1.22  2000/04/27 13:52:09  ivm
# Added complete() method
#
# Revision 1.21  2000/04/26 17:03:27  ivm
# Added JDFSeq field to SectParam
#
# Revision 1.20  2000/04/19 14:41:46  ivm
# Use -1 not -1.0 for "hold forever"
#
# Revision 1.19  2000/03/29 22:59:04  ivm
# Added Tracer code
#
# Revision 1.18  2000/03/24 17:51:54  ivm
# Use new cfg field names
#
# Revision 1.17  2000/03/17 16:24:02  ivm
# Fixed and tested DepParser
#
# Revision 1.16  2000/03/14 16:37:56  ivm
# Fixed FBSNodeInfo.py
# Added HOLD_TIME to SectParam
#
# Revision 1.15  2000/02/29 22:38:03  ivm
# Added MailTo
#
# Revision 1.14  2000/02/25 18:51:08  ivm
# Fixed some bugs
#
# Revision 1.13  2000/02/25 18:17:50  ivm
# Added NetIF commands
#
# Revision 1.12  2000/02/17 21:05:11  ivm
# Fixed some bugs
#
# Revision 1.11  2000/02/10 21:30:59  tlevshin
# change Depend form () to list
#
# Revision 1.10  2000/02/09 21:01:35  tlevshin
# change name for StdOut,StdErr (Stdout,Stderr)
#
# Revision 1.9  2000/02/01 16:01:16  ivm
# Fixed some bugs
# Added GETJOB command
#
# Revision 1.8  2000/01/31 21:39:24  ivm
# Fixed more trivial bugs
#
# Revision 1.7  2000/01/27 19:54:52  tlevshin
# fixed syntax
#
# Revision 1.6  2000/01/27 19:42:26  ivm
# Added PrioInc
#
# Revision 1.4  2000/01/26 17:10:43  ivm
# *** empty log message ***
#
# Revision 1.2  2000/01/24 17:13:56  ivm
# Added parseLine, renamed fields
#
#

import string
import Parser
import bmgr_global
import fbs_misc
import serialize
import pwd

from Tracer import *

class	SectParam:

	NewFields = {
		'Username':'unknown',
		'Placement':'round-robin'
		}	# will be added to previously stored
								# in job db objects

	def __init__(self):
		self.ProcType = ''
		self.NProc = 0
		self.Depend = ''
		self.Exec = '/bin/sleep 1'
		self.Need = 0
		self.Stdout = '.'
		self.Stderr = '.'
		self.LeaderOnly = 0
		self.HoldTime = None
		self.Nice = 0
		self.Queue = ''
		self.PerProcLocal = {}
		self.PerProcGlobal = {}
		self.PerSectGlobal = {}
		self.UID = -1	# UID and GID will be added by NetIF
		self.GID = -1		
		self.Username = 'unknown'
		self.CPUTimeLimit = -1
		self.RealTimeLimit = -1
		self.PrioInc = 0
		self.JDFSeq = 0
		self.SectOutput = None
		self.SectResources = {}
		self.ProcResources = {}
		self.Placement = 'round-robin'
		self.OnNodes = None 	# None = anywhere
				
	def complete(self):
		if not self.__dict__.has_key('Username'):
			try:	self.Username = pwd.getpwuid(self.UID)[0]
			except: self.Username = 'unknown'
		if not self.__dict__.has_key('Placement'):
			self.Placement = 'round-robin'
		if not self.__dict__.has_key('OnNodes'):
			self.OnNodes = None

	def dumpDict(self, dict):
		str = ''
		for k, v in dict.items():
			if type(v) == type(()) or type(v) == type([]):
				v = v[0]
			str = str + ' %s:%s'	% (k, v)
		return str

	def dump(self):
		# this is sent to API.getSection()
		#T.trace('SectParam.dump(): start')
		lst = []
		lst.append('PROC_TYPE = %s' % self.ProcType)
		lst.append('NUMPROC = %d' % self.NProc)
		lst.append('QUEUE = %s' % self.Queue)
		lst.append('EXEC = %s' % string.join(self.Exec))
		lst.append('UID = %d' % self.UID)
		lst.append('GID = %d' % self.GID)
		lst.append('USERNAME = %s' % self.Username)
		if self.Depend:		
			lst.append('DEPEND = %s' % self.Depend)
		if self.Need:			lst.append('NEED = %d' % self.Need)
		if self.Stdout != '.':	lst.append('STDOUT = %s' % self.Stdout)
		if self.Stderr != '.':	lst.append('STDERR = %s' % self.Stderr)
		if self.LeaderOnly:		lst.append('LEADER_ONLY = %d' % self.LeaderOnly)
		if self.Nice:			lst.append('NICE = %d' % self.Nice)
		if self.PerProcLocal or self.PerProcGlobal:
			lst.append('PROC_RESOURCES = %s %s' % (
				self.dumpDict(self.PerProcLocal), self.dumpDict(self.PerProcGlobal)))
		if self.PerSectGlobal:
			lst.append('SECT_RESOURCES = %s' % self.dumpDict(self.PerSectGlobal))
		if self.CPUTimeLimit > 0:	lst.append('CPU_LIMIT = %d' % self.CPUTimeLimit)
		if self.RealTimeLimit > 0:	lst.append('REAL_LIMIT = %d' % self.RealTimeLimit)
		if self.PrioInc:		lst.append('PRIO_INC = %d' % self.PrioInc)
		if self.HoldTime:		
				lst.append('HOLD_TIME = %s' % fbs_misc.encodeTime(self.HoldTime))
		if self.JDFSeq: 		lst.append('JDF_SEQ = %s' % self.JDFSeq)
		if self.__dict__.has_key('SectOutput') and self.SectOutput: 	
			lst.append('SECT_OUT = %s' % self.SectOutput)
		if self.OnNodes:
			lst.append('ON_NODES = %s' % string.join(self.OnNodes))
		if self.Placement != 'round-robin':
			lst.append('PLACEMENT = %s' % self.Placement)
		#T.trace('SectParam.dump(): finish')
		return lst
		
	def parseLine(self, line):
		# this comes from API during submit
		kw, args = Parser.parseLine(line)
		inx = string.find(line, '=')
		rest = string.strip(line[inx+1:])
		if kw == 'PROC_TYPE':	self.ProcType = args[0]
		elif kw == 'NUMPROC':	self.NProc = args[0]
		elif kw == 'EXEC':
			try:	lst, rst = serialize.deserialize(rest)
			except SyntaxError, val:
				raise ValueError, 'Error parsing EXEC parameter: %s' % val
			if not lst:
				raise ValueError, 'Empty EXEC parameter'
			self.Exec = lst
		elif kw == 'NEED':		self.Need = args[0]
		elif kw == 'PLACEMENT':		self.Placement = args[0]
		elif kw == 'STDOUT':	self.Stdout = args[0]
		elif kw == 'STDERR':	self.Stderr = args[0]
		elif kw == 'LEADER_ONLY':		self.LeaderOnly = args[0]
		elif kw == 'HOLD_TIME':			
			try:	self.HoldTime = fbs_misc.decodeTime(args[0])
			except: 
				raise ValueError, 'Invalid hold time <%s>' % args[0]
		elif kw == 'QUEUE':
			if not args:
				raise ValueError, 'Queue name must be specified'
			self.Queue = args[0]
		elif kw == 'NICE':		self.Nice = max(0, args[0])
		elif kw == 'PRIO_INC':	self.PrioInc = args[0]
		elif kw == 'MAILTO':	self.MailTo = rest
		elif kw == 'DEPEND':	self.Depend = rest
		elif kw == 'SECT_OUT':	self.SectOutput = args[0]
		elif kw == '_JDF_SEQ':	self.JDFSeq = args[0]
		elif kw == 'PROC_RESOURCES':
			g = {}
			l = {}
			# Use 1 for attributes
			d = Parser.wordsToDict(args, defValue = 1)
			for rn, qty in d.items():
				rt = bmgr_global.G_ResourceManager.resourceType(rn)
				#print rn, rt
				if rt == 'g' or rt == 'gp':	g[rn] = qty
				elif rt == 'l' or rt == 'lp': l[rn] = qty
				else:
					raise ValueError, 'Unknown resource %s' % rn
			self.PerProcLocal = l
			self.PerProcGlobal = g
			self.ProcResources = d
		elif kw == 'SECT_RESOURCES':
			g = {}
			d = Parser.wordsToDict(args, defValue = 0)
			for rn, qty in d.items():
				rt = bmgr_global.G_ResourceManager.resourceType(rn)
				if rt == 'g' or rt == 'gp':	g[rn] = qty
				else:
					raise ValueError, 'Unknown global resource %s' % rn
			self.SectResources = d
			self.PerSectGlobal = g
		elif kw == 'ON_NODES':
			# remove duplicates
			dct = {}
			for n in args:
				dct[n] = 1
			self.OnNodes = dct.keys()
			if not self.OnNodes:	self.OnNodes = None
		else:
			raise ValueError, 'Invalid keyword %s' % kw
	
	def addDefaults(self):
		# adds default ProcType, if not specified
		# merges rsrc reqs with predefined for the ProcType
		
		if not self.Queue:
			raise ValueError,'Unspecified queue name'
		try:
			q = bmgr_global.G_QueueFinder[self.Queue]
		except KeyError:
			raise ValueError,'Queue <%s> does not exist' % self.Queue
		if not self.ProcType:
			self.ProcType = q.DefProcType
		if not self.ProcType:
			raise ValueError, 'Unspecified process type'
		PTLocalProcRsrc = {}
		PTGlobalProcRsrc = {}
		PTGlobalSectRsrc = {}
		
		try:	ptype = bmgr_global.G_ProcTypeFinder[self.ProcType]
		except KeyError:
			#print 'ptypes: ', bmgr_global.G_ProcTypeFinder.keys()
			raise ValueError, 'SectParam(1): Process type <%s> not found' % self.ProcType
		sd, pd = ptype.SDefs, ptype.PDefs
		for rn, qty in pd.items():
			rt = bmgr_global.G_ResourceManager.resourceType(rn)
			#print 'proc_def: ', rn, qty, rt
			if rt == 'g' or rt == 'gp':	PTGlobalProcRsrc[rn] = qty
			elif rt == 'l' or rt == 'lp': 
				if qty == None: qty = 1
				PTLocalProcRsrc[rn] = qty
			else:
				continue	# error - chkcfg should point out

		for rn, qty in sd.items():
			rt = bmgr_global.G_ResourceManager.resourceType(rn)
			#print 'sect_def: ', rn, qty, rt
			if rt == 'g' or rt == 'gp':	PTGlobalSectRsrc[rn] = qty
			else:
				continue	# error - chkcfg should point out
	
		self.PerProcLocal = fbs_misc.mergeDict(PTLocalProcRsrc,
			self.PerProcLocal)
		self.PerProcGlobal = fbs_misc.mergeDict(PTGlobalProcRsrc,
			self.PerProcGlobal)
		self.PerSectGlobal = fbs_misc.mergeDict(PTGlobalSectRsrc,
			self.PerSectGlobal)
		#print 'Merged ppl:', self.PerProcLocal			
		#print 'Merged ppg:', self.PerProcGlobal			
		#print 'Merged psg:', self.PerSectGlobal		

		# get Nice
		self.Nice = self.Nice + ptype.MinNice
		
		# get time limits
		self.CPUTimeLimit = q.CPUTimeLimit
		if self.CPUTimeLimit < 0:
			self.CPUTimeLimit = ptype.CPUTimeLimit
		else:
			if ptype.CPUTimeLimit > 0:
				self.CPUTimeLimit = min(ptype.CPUTimeLimit,
					self.CPUTimeLimit)
					
		self.RealTimeLimit = q.RealTimeLimit
		if self.RealTimeLimit < 0:
			self.RealTimeLimit = ptype.RealTimeLimit
		else:
			if ptype.RealTimeLimit > 0:
				self.RealTimeLimit = min(ptype.RealTimeLimit,
					self.RealTimeLimit)

	def validatePermissions(self, admin):
		ptf = bmgr_global.G_ProcTypeFinder
		qf = bmgr_global.G_QueueFinder

		try:	q = qf[self.Queue]
		except:
			return 'NF', 'Queue <%s> not found' % self.Queue

		qok, reason = q.submitAllowed(admin, self.Username, self.ProcType)
		if not qok:
			return 'PERM', reason

		try:	pt = ptf[self.ProcType]
		except KeyError: 
			return 'NF', 'SactParam: Process type <%s> not found' % self.ProcType
		ptok, reason = pt.submitAllowed(admin, self.Username)
		if not ptok:
			return 'PERM', reason

		return 'OK',''
		
