#
# @(#) $Id: RM.py,v 1.53 2003/08/20 18:58:57 ivm Exp $
#
# $Log: RM.py,v $
# Revision 1.53  2003/08/20 18:58:57  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.52  2003/01/14 22:05:03  ivm
# Implemented node class power
#
# Revision 1.51  2002/06/21 17:03:29  ivm
# Implemented persistent node hold/release
#
# Revision 1.50  2002/03/04 16:12:47  ivm
# Fixed the bug with node attribute/counted mismatch for
# new attributes
#
# Revision 1.48  2001/11/06 20:12:02  ivm
# Gradully reduce priorities of inactive queues
# Corrected calculations in RM.Node.canAllocateResources
#
# Revision 1.45  2001/10/24 18:34:37  ivm
# Implemented ProcType.max_nodes
# Fixed section priority incrementing
#
# Revision 1.44  2001/09/17 17:28:36  ivm
# Fixes for NProc = 0
#
# Revision 1.43  2001/09/15 00:48:40  ivm
# Fixed the bug with empty list returned from allocateLocal()
#
# Revision 1.42  2001/09/12 16:43:57  ivm
# Fixed onNodes
#
# Revision 1.40  2001/08/28 21:01:10  ivm
# Fixed RM.setRsrcPool()
# Added time limits to queue display in queues.py and "fbs config"
# Print correct error messages in submit
#
# Revision 1.39  2001/08/27 18:28:42  ivm
# Fixed status.py
# Use PType.wouldExceedQuota() in RM
#
# Revision 1.38  2001/08/23 19:05:54  ivm
# Implemented search with feedback RM algorithm
# Added -v option to status.py
# Fixed handling of time limits in FBSSectionInfo
#
# Revision 1.37  2001/05/11 13:46:20  ivm
# Fixed bugs with PT and Queue creation
#
# Revision 1.36  2001/03/16 17:46:58  ivm
# Fixed some bugs
# Made v1_3_2
#
# Revision 1.35  2001/03/15 21:47:54  ivm
# Implemented "on nodes"
# Fixed protocol version handling in lch, lchif
#
# Revision 1.34  2001/03/13 15:59:01  ivm
# Fixed bugs in object ownership
#
# Revision 1.33  2001/03/12 19:29:04  ivm
# Removed PTypes, RMPType
#
# Revision 1.32  2000/11/14 17:35:00  ivm
# New build rules for SunOS
# Fixed queueadmin.py
#
# Revision 1.30  2000/11/03 21:16:44  ivm
# Tested RM pack, spread features
# Print detailed error message on ValueError in submit.py
# Fixed getJob w.r.t. Username
#
# Revision 1.29  2000/11/03 19:24:20  ivm
# Implemented Placement in RM and JDF
# Renamed tar files in clean-up scripts
# Added RPC library for Stats.so
#
# Revision 1.28  2000/11/01 16:06:07  ivm
# Made compile for SunOS
# Introduced "placement" parameter to allocateLocal methods
#
# Revision 1.26  2000/10/24 20:16:11  ivm
# Added "remove" functionality
# Made building of Kerberos module optional
# Included kerberos as optional dependency to UPS table
# v1_2_1
# Fixed exec.py to send command as list
#
# Revision 1.25  2000/10/02 19:23:17  ivm
# Return 1 from can*AllocateGlobal if no resources requested
#
# Revision 1.23  2000/10/02 14:59:37  ivm
# Re-wrote canAllocate methods
#
# Revision 1.21  2000/09/28 14:24:47  ivm
# Cosmetics
#
# Revision 1.19  2000/09/14 21:48:19  ivm
# Fixed usage information printing in farm_config
#
# Revision 1.18  2000/09/12 15:00:01  ivm
# Implemented createLocalResource method and all related changes
#
# Revision 1.17  2000/09/07 17:54:54  ivm
# Implemented dynamic modification of local scratch disk mapping
#
# Revision 1.16  2000/08/24 20:09:21  ivm
# Fixed chkcfg
# Implemented RM.addLocalResource
#
# Revision 1.15  2000/08/22 18:53:12  ivm
# Removed debug print-outs
#
# Revision 1.12  2000/08/21 21:09:52  ivm
# Fixed some bugs
#
# Revision 1.11  2000/08/21 17:12:47  ivm
# Create new nodes in held/down state
#
# Revision 1.10  2000/08/18 21:15:42  ivm
# Implemented dynamic re-configuration
#
# Revision 1.9  2000/08/08 16:19:47  ivm
# Fixed user message sending from batch process to API
#
# Revision 1.8  2000/08/07 14:40:33  ivm
# Added extra parameter to RM.can*AllocateGlobal()
#
# Revision 1.7  2000/08/03 21:17:47  ivm
# Fixed bugs, added traceback print-out in NetIF
#
# Revision 1.6  2000/08/03 15:39:34  ivm
# Fixed some bugs
#
# Revision 1.5  2000/08/02 16:36:06  ivm
# Fixed numerous bugs
#
# Revision 1.4  2000/08/02 15:01:07  ivm
# Use new RM
#
# Revision 1.1  2000/08/01 21:48:48  ivm
# Added RM.py
#
#
# ---------------- re-written based on ResourceManager v1.31 by J.Fromm ------------

# define exceptions
Unknown_Host = 'RM: unknown node'
Invalid_Resource = 'RM: unknown resource'
Invalid_ProcType = 'RM: unknown process type'
Unknown_NodeClass = 'RM: unknown node class'

import string
import bmgr_global
from MiscClasses import *

class	_Big:
	def __init__(self, sign=1):
		self.Sign = sign
		
	def __add__(self, x):
		return self
		
	def __radd__(self, x):
		return self
		
	# Big is bigger than anything
	def __sub__(self, x):
		return self
		
	def __rsub__(self, x):
		return -self

	def __neg__(self):
		return Big(-self.Sign)

	def __div__(self, x):
		if x < 0:
			return -self
		else:
			return self

	def __cmp__(self, x):
		return self.Sign
		
	def __rcmp__(self, x):
		return -self.Sign

	def __repr__(self):
		if self.Sign > 0:
			return 'Big'
		else:
			return '-Big'

Big = _Big()

class	RMNClass:
	def __init__(self, name, lrdict):
		self.Name = name
		self.Nodes = {} 			# node name -> RMNode
		self.LRCap = {} 			# rsrc name -> capacity or Big
		self.LDisks = {}			# rsrc name -> root directory
		self.setLRCap(lrdict)
		self.Power = 1.0

	def setPower(self, pwr):
		if type(pwr) == type(1):
			pwr = float(pwr)
		if type(pwr) != type(1.0):
			raise ValueError, 'Invalid type of power value (%s) for class <%s>' % \
				(pwr, self.Name)
		if pwr <= 0.0:
			raise ValueError, 'Invalid value for node class power (%s), must be > 0' % (pwr,)
		self.Power = pwr
		
	def getPower(self):
		return self.Power
		
	def addNode(self, node):
		self.Nodes[node.Name] = node
		node.zeroUsage(self.LRCap.keys())

	def removeNode(self, nname):
		# Do not bother doing anything else. This will
		# really remove the node.
		try:	del self.Nodes[nname]
		except KeyError:
			pass

	def nodeNames(self):
		return self.Nodes.keys()

	def setLRCap(self, dict):
		self.LRCap = {}
		for k, v in dict.items():
			if v == None:	v = Big
			self.LRCap[k] = v
		#for nn, n in self.Nodes.items():
		#	n.updateUsage(dict.keys())

	def rsrcUsage(self, rn):
		if not self.LRCap.has_key(rn):
			return 0
		else:
			usg = 0
			for nn, node in self.Nodes.items():
				usg = usg + node.LRUsage[rn]
			return usg
			
	def getLDisks(self):
		return self.LDisks

	def setLDisks(self, dict):
		d = {}
		for rn, root in dict.items():
			if not self.LRCap.has_key(rn):
				raise ValueError, 'The node class does not have the resource <%s>' % rn
			if self.LRCap[rn] is Big:
				raise ValueError, 'Resource <%s> is an attribute' % rn
			d[rn] = root
		self.LDisks = d

	def hasCapacity(self, rsrc, rpools):
		for rn, req in rsrc.items():
			has_cap = 0
			if rpools.has_key(rn):
				# this is pool
				for ur in rpools[rn]:
					if self.LRCap.has_key(ur):
						if self.LRCap[ur] >= req:
							has_cap = 1
							break
			else:
				# real reasource
				if self.LRCap.has_key(rn) and \
					self.LRCap[rn] >= req:
						has_cap = 1
			if not has_cap:
				return 0
		return 1

	def isAttr(self, rn):
		return self.LRCap.has_key(rn) and self.LRCap[rn] is Big					
		
class	RMNode:
	def __init__(self, name, nclass):
		self.Name = name
		self.Class = nclass	# contains resource capacities
		self.Down = 1
		self.Held = 0
		self.HoldReason = ''
		self.LRUsage = RV()			# local resources used, rsrc -> int
		self.PTUsage = {}			# {pt -> {rn -> usage}
		self.Class.addNode(self)
		self.RPInx = 0

	def nextRPInx(self, modulo = 1):
		i = self.RPInx % modulo
		next = self.RPInx + 1
		if next > 10000:
			next = i + 1
		self.RPInx = next
		return i

	def addResources(self, rnames):
		# called by NodeClass when resource capacity changes
		#for rn in rnames:
		#	if not self.LRUsage.has_key(rn):
		#		self.LRUsage[rn] = 0
		pass		# done by RV
		
	def inUse(self):
		for rn in self.Class.LRCap.keys():
			if self.LRUsage[rn]:	return 1

	def totalUse(self, inclPT = None):
		dict = RV()
		if inclPT == None:
			for pt, usg in self.PTUsage.items():
				dict.add(self.PTUsage[pt])
		elif self.PTUsage.has_key(inclPT):
			dict = self.PTUsage[inclPT]
		return dict

	def zeroUsage(self, rnames):
		for ptn, usg in self.PTUsage.items():
			for rn in rnames:
				usg[rn] = 0

	def addUsage(self, ptn, deltas, n = 1):
		try:	dict = self.PTUsage[ptn]
		except KeyError: dict = RV()
		for rn, usg in deltas.items():
			dict[rn] = dict[rn] + usg * n
			self.LRUsage[rn] = self.LRUsage[rn] + usg * n
			if self.LRUsage[rn] < 0:
				self.LRUsage[rn] = 0
		self.PTUsage[ptn] = dict

	def canAllocateResources(self, nmax, rsrc, usg):
		# this works only for URs and does not check any quota
		# rscr is resource request dictionary with suggested
		# RP -> UR translation applied. No RP's here !
		# Just check usage against capacity
		if nmax == 0:
			return 0		# we can always add 0 more processes
		cap = self.Class.LRCap
		np = None
		for rn, req in rsrc.items():
			try:	c = cap[rn]
			except KeyError:
				return 0
			if c is Big or c is None or req is None or req == 0:	continue
			u = usg[rn]
			if u + req > c:
				np = 0
				break
			else:
				n = (c - u) / req
				if np == None or np > n:	np = n
		#print 'canAllocateResources(%s, %s) = %s' % (
		#	rsrc, usg, nmax)
		if np == None:	np = nmax
		return np

	def getPower(self):
		return self.Class.getPower()		
				
class	ResourceManager:
	def __init__(self, cfg):
		self.GRCap = RV() 		# rsrc -> int
		self.GRUsage = RV()		# rsrc -> int, excl. pools
		self.LRUsage = RV()		# rsrc -> int, excl. pools
		self.Attribute = {}		# rsrc -> 1(attr), 0(counted)
		self.NodeNames = [] 	# Node names ordered by node class
		self.Nodes = {} 		# node name -> RMNode
		self.Classes = {}		# class name -> RMNClass
		self.GRP = {}			# pool name -> [ rsrc ]
		self.LRP = {}			# pool name -> [ rsrc ]
		self.NextNodeInx = 0	# for round robin
		self.MaxInx = 1000001
		self.readConfig(cfg)
		
	def createNodeNameList(self):
		# create sorted node name list
		self.NodeNames = []
		for cn, c in self.Classes.items():
			self.NodeNames = self.NodeNames + c.nodeNames()
			
	def readConfig(self, cfg):

		# read global resources
		dct = cfg.getValueDict('resources','*','global', defValue = None)
		if not dct: dct = {}
		for k, v in dct.items():
			if v == None:
				raise ValueError, 'Unspecified capacity for global resource <%s>' % k
			if type(v) != type(1):
				raise ValueError, 'Invalid capacity for global resource <%s>' % k
			self.addGlobalResource(k, v)

		# read local resources
		lst = cfg.getValueList('resources','*','local')
		if not lst: lst = []
		for rn in lst:
			self.addLocalResource(rn)

		# read pools
		for rp in cfg.names('resource_pools', '*'):
			urlst = cfg.getValueList('resource_pools', '*', rp)
			#print 'cfg: rp %s: %s' % (rp, urlst)
			if not urlst:	continue
			self.addRsrcPool(rp, urlst)
		
		# read node classes
		for cn in cfg.ids('node_class'):
			self.addNodeClass(cn)
			# create new node class
			lrdict = cfg.getValueDict('node_class',cn,'resources',
					defValue=Big)	# use Big for attributes
			#print cn, lrdict
			if lrdict == None:
				lrdict = {}
			self.setNodeClassRsrc(cn, lrdict)
			ldsks = cfg.getValueDict('node_class', cn, 'local_disks',
				defValue = None)
			if ldsks == None:	ldsks = {}
			for k, v in ldsks.items():
				if type(k) != type('') or type(v) != type(''):
					raise ValueError, 'Invalid local disk specification for node class <%s>' % cn
			self.setNodeClassLDisks(cn, ldsks)
			power = cfg.getValue('node_class', cn, 'power', 1.0)
			if power == None or power == []:
				power = 1.0
			if type(power) == type(''): 
				try:	power = float(power)
				except:
					raise ValueError, 'Invalid configuration value for node class power <%s>' % (power,)
			self.setNodeClassPower(cn, power)
			
		#print self.Classes
			
		for nn in cfg.names('node_list','*'):
			lst = cfg.getValueList('node_list','*',nn)
			lst = map(lambda x: '%s' % (x,), lst)
			self.addNode(lst[0], nn, newNode = 0)
			if len(lst) > 1 and lst[1] == 'held':
				if len(lst) > 2:	
					self.holdNode(nn, string.join(lst[2:]), saveCfg = 0)
				else:				
					self.holdNode(nn, saveCfg = 0)
			#else:
			#	self.releaseNode(nn)

		self.createNodeNameList()

	def updateLRTypes(self):
		attr_dict = {}
		for ncn, nc in self.Classes.items():
			for rn, cap in nc.LRCap.items():
				isattr = cap is Big
				if attr_dict.has_key(rn) and attr_dict[rn] != isattr:
					raise ValueError, 'Local resource type (attr./counted) mismatch for resource <%s>' % rn
				attr_dict[rn] = isattr
				self.Attribute[rn] = isattr
				
	def	validateLRType(self, rn, cap):
		isattr = cap is Big or cap == None
		return not self.Attribute.has_key(rn) or self.Attribute[rn] == isattr

	def isAttribute(self, rn):
		return self.Attribute.has_key(rn) and self.Attribute[rn]
				
	def getLocalList(self):
		return self.LRUsage.keys()
		
	def getGlobalList(self):
		return self.GRCap.keys()
		
	def getLocalPoolList(self):
		return self.LRP.keys()
		
	def getGlobalPoolList(self):
		return self.GRP.keys()

	def getRsrcPool(self, rp):
		if self.LRP.has_key(rp):
			return self.LRP[rp]
		elif self.GRP.has_key(rp):
			return self.GRP[rp]
		else:
			raise KeyError, 'Resource pool <%s> not found' % rp
		
	def getNodeList(self, nclass = None):
		if nclass == None:
			return self.NodeNames
		else:
			try:	nc = self.Classes[nclass]
			except: 
				raise KeyError, 'Node class <%s> not found' % nclass
			return nc.nodeNames()

	def getNodeClassList(self):
		return self.Classes.keys()

	def resourceType(self, rn):
		if self.LRP.has_key(rn):
			return 'lp'
		elif self.LRUsage.has_key(rn):
			return 'l'
		elif self.GRP.has_key(rn):
			return 'gp'
		elif self.GRCap.has_key(rn):
			return 'g'
		else:
			return ''	# unknown

	def rp2ur(self, rsrc, rp2ur):
		ret = RV()
		for rn, amt in rsrc.items():
			if rp2ur.has_key(rn):
				rn = rp2ur[rn]
			ret[rn] = ret[rn] + amt
		return ret

	def expandUsage(self, usg, rpdict):
		ret = RV(usg)
		for rpn, urlst in rpdict.items():
			for rn, amt in usg.items():
				if rn in urlst:
					ret[rpn] = ret[rpn] + amt
		return ret
			

	def _placeNextProc(self, nproc, nnodes, inode_min, inode_last,
			node_list, npallocated, extra_node_usg, next_rpinx,
			max_new_nodes,
			placement,
			ptype, extra_pt_usage, acct, extra_acct_usage, prefix=''):
		#print '%s_placeNextProc(nproc=%s, inode=%s) called' % (prefix, nproc, inode0)
		if nproc <= 0:
			#print '_placeNextProc(nproc=%s...) returns %s' % (nproc, [])
			return []

		nodes_left = nnodes - inode_min
		if nodes_left <= 0:
			return None

		inode_start = inode_last
		if placement == 'spread' or placement == 'round-robin':
			inode_start = inode_last + 1

		inode_start = max(inode_start, inode_min)
		
		result = None
		#print '%s%d: inode(min, last, start) = (%d, %d, %d)' % (
		#				prefix, nproc, inode_min, inode_last, inode_start)
		for i in range(nodes_left):
			# 1. find node placement taking into account only UR capacity
			inode = inode_min + (inode_start - inode_min + i) % nodes_left
			node, npmax, base_node_usg, \
				rpurlst, base_procs_on_node = node_list[inode]
			nphere = npallocated[inode]
			#print '%s%d: i(node),left:nhere/nmax = %d(%d,%s)%d:%d/%d' % (
			#			prefix, nproc, i, inode, node.Name, nodes_left, nphere, npmax)
			if nphere >= npmax:
				#print '_placeNextProc: node = %s, npallocated = %s, npmax = %s' % (
				#	node.Name, npallocated[inode], npmax)
				continue

			this_is_new_node = 0
			if not max_new_nodes is Big:
				if base_procs_on_node + nphere == 0:
					this_is_new_node = 1	# MUST be either 1 or 0, not
											# necessarily boolean
					if max_new_nodes <= 0:
						continue

			this_node_extra_usg = extra_node_usg[inode]
			usghere = base_node_usg + this_node_extra_usg
			next_node_min = inode_min
			if placement == 'spread':
				next_node_min = inode + 1
			elif placement == 'pack':
				next_node_min = inode
			# 2. find a RP->UR mapping
			j = -1
			saved_next_rpinx = next_rpinx[inode]
			placed = 0
			node_full = 0
			for rpurmap, procusg, expusg in rpurlst:
				j = j + 1
				if j < saved_next_rpinx:	continue

				#print '%s%d: j = %d' % (prefix, nproc, j),
				if not node.canAllocateResources(1, procusg, usghere):
					#print ' -- rsrc'
					continue

				totptusg = extra_pt_usage + expusg
				if ptype.wouldExceedQuota(totptusg):
					#print ' -- ptq'
					continue

				totacctusg = extra_acct_usage + expusg
				#if acct and acct.wouldExceedQuota(totacctusg):	
				#	#print ' -- acctq'
				#	continue

				node_full = 0
				#print ' -- OK'
				next_rpinx[inode] = j
				extra_node_usg[inode] = this_node_extra_usg + procusg
				npallocated[inode] = nphere + 1
				placements = self._placeNextProc(nproc-1, nnodes,
					next_node_min, inode,
					node_list, 
					npallocated,
					extra_node_usg,
					next_rpinx,
					max_new_nodes - this_is_new_node,
					placement,
					ptype, totptusg, acct, totacctusg,
					prefix + '  ')
				npallocated[inode] = nphere
				next_rpinx[inode] = saved_next_rpinx
				extra_node_usg[inode] = this_node_extra_usg
				if placements != None:
					result = [(node.Name, rpurmap, procusg)] + placements
				placed = 1
				break
			if node_full:
				node_list[inode] = (node, nphere, base_node_usg, rpurlst)
				#print '%s%d: inode %s full at %d' % (prefix, nproc,
				#	node.Name, nphere)
			if placed:
				break
		#print '_placeNextProc(nproc=%s...) returns %s' % (nproc, result)
		return result

	def _allocateLocal(self, np, rsrc, ptname, placement, eventually = 0,
					onNodes = None):

		#print '_allocateLocal(%s, %s, %s, event=%s, nodes=%s)...' % (
		#	np, ptname, placement, eventually, onNodes)
			
		if np == 0:
			return [], 'OK'

		pt = bmgr_global.G_ProcTypeFinder[ptname]
		if pt.nodeLimitExceeded():
			return None, 'Node limit exceeded'
		#acct = bmgr_global.G_AccountFinder['']
		acct = None 	# dummy
		acctq = RV(default = Big)
		acctu = RV()

		# 0. Check quotas and unknown resources
		# 0a. Separate RPs from URs		
		rpreq = RV()
		urreq = RV()

		if pt.wouldExceedQuota(RV(rsrc), np):
			return None, 'Would exceed process type quota'		# insufficient quota
				
		for rn, req in rsrc.items():
			rt = self.resourceType(rn)
			if rt != 'l' and rt != 'lp':
				return None, 'Unknown or non-local resource <%s>' % rn		# unknown resource
			if rt == 'l':
				urreq[rn] = req
			else:
				rpreq[rn] = req

		#print '_allocateLocal: urreq=%s, rpreq=%s' % (urreq, rpreq)

		# 1. Create node list
		node_list = []
		node_name_list = self.NodeNames
		if type(onNodes) == type([]):
			node_name_list = onNodes
		skip_class = None
		last_class = None
		inx0 = self.NextNodeInx
		exprsrc = self.expandUsage(rsrc, self.LRP)
		for i in range(len(node_name_list)):
			inx = (inx0 + i) % len(node_name_list)
			nn = node_name_list[inx]
			try:	node = self.Nodes[nn]
			except KeyError:
				continue
			if skip_class and node.Class.Name == skip_class:
				continue
			skip_class = None
			if node.Held or node.Down or not pt.nodeAllowed(node.Name):
				continue
			if not node.Class.hasCapacity(rsrc, self.LRP):
				skip_class = node.Class.Name
				continue
			if node.Class.Name != last_class:
				last_class = node.Class.Name
				cl = node.Class
			node.ListIndex = inx
			node_list.append(node)			
		tmp = node_list
		node_list = []
		extra_node_usage = []
		extra_max_proc_here = []
		
		# Pre-generate all rp->ur combinations
		combs = [[]]
		rps = rpreq.keys()
		for rpn in rps:
			urs = self.LRP[rpn]
			#print 'rpn=%s, urs=%s, combs=%s' % (rpn, urs, combs)
			new_combs = []
			for urn in urs:
				for lst in combs:
					new_combs.append(lst + [urn])
			combs = new_combs
		#print 'combs: %s' % combs
		pregen_rpur_maps = []
		for lst in combs:
			rpurmap = {}
			usg = RV(urreq)
			for i in range(len(rps)):
				rpn = rps[i]
				urn = lst[i]
				rpurmap[rpn] = urn
				usg[urn] = usg[urn] + rpreq[rpn]
			pregen_rpur_maps.append((rpurmap, usg))

		#print 'pregen_rpur_maps: %s' % pregen_rpur_maps
		# 1.1. Filter out down, held, too busy nodes
		# node_list will contain tuples:
		# (node object, max processes here, base resource usage, rp inx)
		nallocatable = 0
		for node in tmp:
			if not rpreq:
				# Optimization. We may not need any more nodes.
				if (placement == 'round-robin' or placement == 'spread') \
							and len(node_list) >= np \
						or\
						(placement == 'pack' and nallocatable >= np):
					break
			if eventually:
				base_usg = node.totalUse(ptname)
			else:
				base_usg = node.totalUse()
			# check if real resources can be allocated
			nhere = node.canAllocateResources(np, urreq, base_usg)
			if nhere > 0:
				if placement == 'spread':	nhere = 1
				nallocatable = nallocatable + nhere
				# choose valid combinations of rp->ur
				rpurlst = []
				for rpurmap, procusg in pregen_rpur_maps:
					# check this usg against node capacity.
					if node.canAllocateResources(1, procusg, base_usg) > 0:
						rpurlst.append((rpurmap, procusg, 
							self.expandUsage(procusg, self.LRP)))

				if rpreq and not rpurlst:
					#print 'empty rpurlst for node %s' % node.Name
					continue
						
				if rpurlst:
					inx = node.RPInx % len(rpurlst)
					rpurlst = rpurlst[inx:] + rpurlst[:inx]
				node_list.append((node, nhere, base_usg, rpurlst,
					pt.procsOnNode(node.Name)))
				#print '%s: nmax=%d, base=%s' % (node.Name, nhere, base_usg)
				#for rmap, usg, expusg in rpurlst:
				#	print '  %s: %s' % (rmap, expusg)
				extra_node_usage.append(RV())
				extra_max_proc_here.append(0)
		#print 'nallocatable=', nallocatable
		if nallocatable < np:
			return None, 'Not enough resources'
			
		nnodes = len(node_list)
		if nnodes <= 0 or placement == 'spread' and nnodes < np:
			return None, 'Not enough resources or nodes'
		
		if pt.MaxNodes != None:
			#sort by availability then by procsOnNode 
			node_list.sort(lambda x,y: cmp(y[1],x[1]) or cmp(y[4],x[4]))
		elif placement == 'pack':
			# sort by UR capacity
			node_list.sort(lambda x,y: y[1] - x[1])

		# 4. Run the combinatorics
		extra_pt_usage = RV()
		max_new_nodes = None
		if not pt.MaxNodes is None:
			max_new_nodes = pt.MaxNodes - pt.currentNodeCount()
		else:
			max_new_nodes = Big
		#print 'max_new_nodes = %s' % max_new_nodes
		placements = self._placeNextProc(np, nnodes, 0, -1, node_list, 
					extra_max_proc_here, extra_node_usage, [0] * nnodes,
					max_new_nodes,
					placement,
					pt, extra_pt_usage, acct, RV())

		if placements == None:
			return None, 'Not enough resources or nodes'

		return placements, 'OK'

	def allocateLocal(self, np, rsrc, ptname, 
					placement='round-robin', onNodes = None):
		if np == 0:
			return []
		#print 'allocateLocal(%d, %s, %s, %s, %s) ' % (
		#	np, rsrc, ptname, placement, onNodes)
		lst, sts = self._allocateLocal(np, rsrc, ptname, 
					placement, onNodes = onNodes)
		#print '_allocateLocal returned %s, %s' % (lst, sts)
		if not lst:
			return None
		retlst = []
		for nname, rpur, procusg in lst:
			node = self.Nodes[nname]
			self.forceAllocateLocal(nname, procusg, ptname)
			retlst.append((nname, rpur))
			self.NextNodeInx = node.ListIndex + 1
			node.nextRPInx()
		return retlst
		
	def forceAllocateLocal(self, nname, rsrc, pt, rp2ur = {}, mult=1):
		try:	node = self.Nodes[nname]
		except: raise Unknown_Host, nname
		try:	ptype = bmgr_global.G_ProcTypeFinder[pt]
		except: raise Invalid_ProcType, pt
		acctusage = RV()
		urusg = self.rp2ur(rsrc, rp2ur)
		self.LRUsage.add(urusg, mult)
		expusg = self.expandUsage(urusg, self.LRP)
		ptype.allocateResources(expusg, mult, nname)
		acctusage.add(expusg, mult)
		node.addUsage(pt, urusg, mult)
		#print 'addedUsage(%s, %s, %s, %s): %s' % (
		#	node.Name, pt, urusg, mult, node.PTUsage)


	def canAllocateLocal(self, np, rsrc, ptname, 
					placement='round-robin', onNodes = None):
		lst, sts = self._allocateLocal(np, rsrc, ptname, 
					placement, onNodes = onNodes)
		return lst != None

	def canEventuallyAllocateLocal(self, np, rsrc, ptname, 
					placement='round-robin', onNodes = None):
		lst, sts = self._allocateLocal(np, rsrc, ptname, placement,
					eventually = 1, onNodes = onNodes)
		#print 'canEventuallyAllocateLocal(%d, %s, %s, pl=%s, on=%s) = %s' % (
		#	np, rsrc, ptname, placement, onNodes, lst)
		return lst != None

	def deallocateLocal(self, nname, rsrc, pt, rp2ur={}):
		self.forceAllocateLocal(nname, rsrc, pt, rp2ur, -1)

	def _allocateGlobal(self, np, rsrc, pt, eventually):
		#print '_allocateGlobal(%d, %s, %s, event=%s) ...' % (
		#	np, rsrc, pt, eventually)
		try:	ptype = bmgr_global.G_ProcTypeFinder[pt]
		except:
			return None, 'Unknown process type <%s>' % pt

		if np <= 0: 	return [], 'OK'
		if not rsrc:	return [{}]*np, 'OK'	# done

		
		acctUsage = RV()
		acctQuota = RV(default = Big)
		
		baseUsage = self.GRUsage
		if eventually:
			baseUsage = RV()
			for rn, amt in ptype.Usage.items():
				if amt > 0 and self.resourceType(rn) == 'g':
					baseUsage[rn] = amt

		# generate rp->ur combinations
		pregen = [([],RV())]
		rp_req = []
		for rn in rsrc.keys():
			amt = rsrc[rn]
			if not amt or amt < 0: amt = 0
			pregen_new = []
			rt = self.resourceType(rn)
			if rt != 'g' and rt != 'gp':
				return None, 'Unknown or non-global resource <%s>' % rn		# unknown resource
			if rt == 'gp':
				rp_req.append(rn)
				for urn in self.GRP[rn]:
					if self.GRUsage[urn] + amt > self.GRCap[urn]:
						continue
					for rpurmap, usg in pregen:
						pregen_new.append((rpurmap+[urn], usg + RV({urn:amt})))
			elif baseUsage[rn] + amt * np <= self.GRCap[rn]:
				for rpurmap, usg in pregen:
					pregen_new.append((rpurmap, usg + RV({rn:amt})))
			if not pregen_new:
					return None, 'Insufficient global resources'
			pregen = pregen_new

		pregen_combs = []
		for rpurmap, usg in pregen:
			rpur = {}
			i = 0
			for rpn in rp_req:
				rpur[rpn] = rpurmap[i]
				i = i + 1
			pregen_combs.append((rpur, usg))

		if not pregen_combs:
			return None, 'Would exceed global resource quota'
			
		ncombs = len(pregen_combs)
		ip = 0
		extra_usg_lst = [RV()]
		comb_lst = [0]
		rpur_lst = []
		while ip >= 0 and ip < np:
			found = 0
			for i in range(ncombs):
				icomb = (comb_lst[ip] + i) % ncombs
				extra_usg = extra_usg_lst[ip]
				this_rpur, this_usg = pregen_combs[icomb]
				tot_usg = extra_usg + this_usg
				if (baseUsage + tot_usg).fitsInto(self.GRCap):
					exp_usg = self.expandUsage(tot_usg, self.GRP)
					if not ptype.wouldExceedQuota(exp_usg) and \
							(acctUsage + exp_usg).fitsInto(acctQuota):
						extra_usg_lst = extra_usg_lst[:ip+1] + [tot_usg]
						comb_lst = comb_lst[:ip] + [icomb, icomb+1]
						rpur_lst = rpur_lst[:ip] + [this_rpur]
						ip = ip + 1
						found = 1
						break
			if not found:
				ip = ip - 1
		if ip < 0:
			return None, 'Not enough global resources'

		return rpur_lst, 'OK'


	def forceAllocateGlobal(self, rsrc, pt, rpur = {}, mult=1):
		# grusage dictionary, if passed will be used to substitute
		# real usage. This trick is used by canEventuallyAllocateGlobal
		grusage = self.GRUsage
		try:	ptype = bmgr_global.G_ProcTypeFinder[pt]
		except KeyError:
			raise Invalid_ProcType, pt
		acctusage = RV()
		urusg = self.rp2ur(rsrc, rpur)
		grusage.add(urusg, mult)
		expusg = self.expandUsage(urusg, self.GRP)
		ptype.allocateResources(expusg, mult)
		acctusage.add(expusg, mult)
						
	def deallocateGlobal(self, rsrc, pt, rp2ur={}):
		self.forceAllocateGlobal(rsrc, pt, rp2ur, -1)


	def canAllocateGlobal(self, np, rsrc, pt, sectrsrc, eventually=0):
		#print 'canAllocateGlobal(%d, %s, %s, sect=%s, event=%s)...' % (
		#	np, rsrc, pt, sectrsrc, eventually)
		if (np <= 0 or not rsrc) and not sectrsrc:	return 1
		lst, reason = self._allocateGlobal(1, sectrsrc, pt, eventually)
		#print '_allocateGlobal(1, %s, %s, %s) returned %s, %s' % (
		#	sectrsrc, pt, eventually, lst, reason)
		if lst == None: return 0
		sectrpur = lst[0]
		self.forceAllocateGlobal(sectrsrc, pt, sectrpur)
		lst, reason = self._allocateGlobal(np, rsrc, pt, eventually)
		ok = (lst != None)
		self.deallocateGlobal(sectrsrc, pt, sectrpur)
		#print 'canAllocateGlobal(%d, %s, %s, %s, event=%s) = %s' % (
		#	np, rsrc, pt, sectrsrc, eventually, ok)
		return ok
		
	def canEventuallyAllocateGlobal(self, np, rsrc, pt, sectrsrc):
		return self.canAllocateGlobal(np, rsrc, pt, sectrsrc, 1)

	def allocateGlobal(self, np, rsrc, pt, sectrsrc):
		lst, reason = self._allocateGlobal(1, sectrsrc, pt, 0)
		if lst == None:
			return None, None
		sectrpur = lst[0]
		self.forceAllocateGlobal(sectrsrc, pt, sectrpur)
		lst, reason = self._allocateGlobal(np, rsrc, pt, 0)
		if lst == None:
			self.deallocateGlobal(sectrsrc, pt, sectrpur)
			return None, None
		for rpur in lst:
			self.forceAllocateGlobal(rsrc, pt, rpur)
		return sectrpur, lst
		
	def setNodeStatus(self, nn, up):
		node = self.Nodes[nn]
		if up == 'up':
			up = 1
		elif up == 'down':
			up = 0
		node.Down = not up
		
	def nodeIsUp(self, nn):
		try:	node = self.Nodes[nn]
		except KeyError:
			raise Unknown_Host, nn
		return not node.Down			

	def holdNode(self, nn, reason='unknown', saveCfg = 1):
		try:	node = self.Nodes[nn]
		except KeyError:
			raise Unknown_Host, nn
		node.Held = 1
		node.HoldReason = reason
		if saveCfg:
			bmgr_global.G_FarmCfg.save('Node <%s> held: %s' % (nn, reason))

	def releaseNode(self, nn):
		try:	node = self.Nodes[nn]
		except KeyError:
			raise Unknown_Host, nn
		node.Held = 0
		node.HoldReason = ''
		bmgr_global.G_FarmCfg.save('Node <%s> released' % nn)
	
	def nodeIsHeld(self, nn):
		try:	node = self.Nodes[nn]
		except KeyError:
			raise Unknown_Host, nn
		return node.Held, node.HoldReason
			
	def getLocalResource(self, nname, rname, pt=None):
		rt = self.resourceType(rname)
		if not (rt in ['l','lp']):
			raise KeyError, 'Resource <%s> is not local' % rname
		isAPool = (rt == 'lp')
		if pt != None:
			# get usage, quota for process type
			try:	ptype = bmgr_global.G_ProcTypeFinder[pt]
			except:
				raise Invalid_ProcType, pt

			ptud = ptype.Usage
			#print ptud
			ptu = ptud[rname]

			qtd = ptype.Quota
			try:	qta = qtd[rname]
			except: qta = Big
			
			if qta is Big:	qta = None
			return ptu, qta
		elif nname:
			# get utilization on individual node
			try:	node = self.Nodes[nname]
			except: raise Unknown_Host, nname
			nusage = node.totalUse()
			#print '%s.totalUse() = %s' % (node.Name, nusage)
			expusg = self.expandUsage(nusage, self.LRP)
			#print 'expanded = %s' % expusg
			usg = expusg[rname]
			ncap = node.Class.LRCap
			expcap = self.expandUsage(ncap, self.LRP)
			cap = expcap[rname]
			if cap is Big:
				cap = None
			return usg, cap
		else:
			# Get numbers for whole farm. Count only up nodes.
			usg, cap = 0, 0
			for ncn, nc in self.Classes.items():
				nccapd = nc.LRCap
				if not isAPool and not nccapd.has_key(rname): continue
				for nn in nc.nodeNames():
					u, c = self.getLocalResource(nn, rname)
					if c == None:	c = Big
					node = self.Nodes[nn]
					#print 'getLocalResource(node=%s, rname=%s, pt=%s): node=%s, c=%s, cap=%s' % (
					#	nname, rname, pt, node.Name, c, cap)
					if not node.Down:	cap = cap + c
					usg = usg + u
			if cap is Big:	cap = None
			return usg, cap
				
			
	def getGlobalResource(self, rname, pt = None):
		if pt:
			# get usage, quota for the process type
			try:
				ptusg = bmgr_global.G_ProcTypeFinder[pt].Usage
				ptqta = bmgr_global.G_ProcTypeFinder[pt].Quota
			except KeyError:
				raise Invalid_ProcType, pt

			try:	qta = ptqta[rname]
			except: qta = Big

			try:	usg = ptusg[rname]
			except KeyError:
				raise Invalid_Resource, rname

			if qta is Big:	qta = None
			return usg, qta
		else:
			usg = self.expandUsage(self.GRUsage, self.GRP)
			cap = self.expandUsage(self.GRCap, self.GRP)
			try:
				return usg[rname], cap[rname]
			except:
				raise Invalid_Resource, rname
				
	#
	# Configuration modification methods
	#
	
	# resource pools
	def addRsrcPool(self, rp, lst):
		#print 'addRsrcPool(%s, %s)' % (rp, lst)
		if self.resourceType(rp):
			raise ValueError, 'Resource <%s> already exists' % rp
		rptp = None
		for ur in lst:
			t = self.resourceType(ur)
			#print ur, t, self.LRP.keys(), self.GRP.keys()
			if t == 'lp' or t == 'gp':
				raise ValueError, 'Resource <%s> is a pool' % ur
			if not t:
				raise KeyError, 'Resource <%s> not found' % ur
			if rptp == None:
				rptp = t
			elif t != rptp:
				raise ValueError, 'Mixing resources of different types in a pool'
		#print 'Adding rp %s(%s): %s' % (rp, rptp, lst)
		if rptp == 'g':
			self.GRP[rp] = lst[:]
		elif rptp == 'l':
			self.LRP[rp] = lst[:]
		else:
			raise ValueError, 'Unknown resource pool type <%s>' % rptp
		# add to PTUsage
		for pt, ptype in bmgr_global.G_ProcTypeFinder.items():
			ptu = ptype.Usage
			usg = 0
			for ur in lst:
				usg = usg + ptu[ur]
			ptu[rp] = usg

	def setRsrcPool(self, rp, lst):
		rptp = self.resourceType(rp)
		if rptp != 'gp' and rptp != 'lp':
			raise KeyError, 'Resource pool <%s> not found' % rp
		urtp = rptp[0]
		for ur in lst:
			t = self.resourceType(ur)
			if t != urtp:
				raise ValueError, 'Invalid type of underlying resource <%s>' % ur
		if rptp == 'gp':
			self.GRP[rp] = lst[:]
		elif rptp == 'lp':
			self.LRP[rp] = lst[:]
		# recalc PTUsage
		for pt, ptype in bmgr_global.G_ProcTypeFinder.items():
			ptu = ptype.Usage
			usg = 0
			for ur in lst:
				usg = usg + ptu[ur]
			ptu[rp] = usg

	def removeRsrcPool(self, rp):
		rptp = self.resourceType(rp)
		if rptp != 'gp' and rptp != 'lp':
			raise KeyError, 'Resource pool <%s> not found' % rp
		# remove from PTUsage dictionaries
		# ptype will check for non-zero usage
		for ptn, pt in bmgr_global.G_ProcTypeFinder.items():
			if pt.Quota.has_key(rp):
				raise ValueError, 'Process type <%s> has quota entry for pool <%s>' % (ptn, rp)
			if pt.PDefs.has_key(rp):
				raise ValueError, 'Pool <%s> is process default for process type <%s>' % (rp, ptn)
			if pt.SDefs.has_key(rp):
				raise ValueError, 'Pool <%s> is section default for process type <%s>' % (rp, ptn)
		for pt, ptype in bmgr_global.G_ProcTypeFinder.items():
			ptype.removeResource(rp)
		if rptp	== 'lp':	del self.LRP[rp]
		else:				del self.GRP[rp]	

	# global resource configuration
	def addGlobalResource(self, gr, cap):
		if self.resourceType(gr):
			raise ValueError, 'Resource <%s> already exists' % gr
		if type(cap) != type(1):
			raise ValueError, 'Invalid resource capacity <%s>' % cap
		self.GRCap[gr] = cap
		self.GRUsage[gr] = 0
		# add to PTUsage
		for pt, ptype in bmgr_global.G_ProcTypeFinder.items():
			ptype.addResource(gr)

	def setGlobalResource(self, gr, cap):
		if self.resourceType(gr) != 'g':
			raise KeyError, 'Resource <%s> not found' % gr
		if type(cap) != type(1):
			raise ValueError, 'Invalid resource capacity <%s>' % cap
		self.GRCap[gr] = cap

	def removeGlobalResource(self, rn):
		if self.resourceType(rn) != 'g':
			raise KeyError, 'Resource <%s> not found' % rn
		if self.GRUsage[rn]:
			raise ValueError, 'Resource <%s> is in use' % rn
		for rpn, lst in self.GRP.items():
			if rn in lst:
				raise ValueError, 'Resource <%s> is in pool <%s>' % (rn, rpn)
		for ptn, pt in bmgr_global.G_ProcTypeFinder.items():
			if pt.Quota.has_key(rn):
				raise ValueError, 'Process type <%s> has quota entry for resource <%s>' % (ptn, rn)
			if pt.PDefs.has_key(rn):
				raise ValueError, 'Resource <%s> is process default for process type <%s>' % (rn, ptn)
			if pt.SDefs.has_key(rn):
				raise ValueError, 'Resource <%s> is section default for process type <%s>' % (rn, ptn)
		for pt in bmgr_global.G_ProcTypeFinder.values():
			pt.removeResource(rn)
		if self.GRCap.has_key(rn):		del self.GRCap[rn]
		if self.GRUsage.has_key(rn):	del self.GRUsage[rn]

	# local resource configuration
	
	def addLocalResource(self, rn):
		if self.resourceType(rn) != '':
			raise ValueError, 'Resource <%s> already exists' % rn
		self.LRUsage[rn] = 0
		for ptn, pt in bmgr_global.G_ProcTypeFinder.items():
			pt.addResource(rn)

	def removeLocalResource(self, rn):
		if self.resourceType(rn) != 'l':
			raise KeyError, 'Local resource <%s> not found' % rn
		for ncn, nc in self.Classes.items():
			if nc.LRCap.has_key(rn):
				raise ValueError, 'Resource <%s> is available on nodes of class <%s>' % (rn, ncn)
		if self.LRUsage[rn]:
			raise ValueError, 'Resource <%s> is in use' % rn
		for rpn, lst in self.LRP.items():
			if rn in lst:
				raise ValueError, 'Resource <%s> is in pool <%s>' % (rn, rpn)
		for ptn, pt in bmgr_global.G_ProcTypeFinder.items():
			if pt.Quota.has_key(rn):
				raise ValueError, 'Process type <%s> has quota entry for resource <%s>' % (ptn, rn)
			if pt.PDefs.has_key(rn):
				raise ValueError, 'Resource <%s> is process default for process type <%s>' % (rn, ptn)
		for pt in bmgr_global.G_ProcTypeFinder.values():
			pt.removeResource(rn)
		if self.LRUsage.has_key(rn):	del self.LRUsage[rn]
		self.updateLRTypes()

	# process type configuration
	def initProcType(self, ptype):
		for k, v in self.LRUsage.items():
			ptype.addResource(k)
		for k in self.LRP.keys():
			ptype.addResource(k)
		for k in self.GRCap.keys():
			ptype.addResource(k)
		for k in self.GRP.keys():
			ptype.addResource(k)

	#
	# node class configuration
	def addNodeClass(self, nc):
		if self.Classes.has_key(nc):
			raise ValueError, 'Node class <%s> already exists' % nc
		lr = {}
		self.Classes[nc] = RMNClass(nc, lr)
	
	def setNodeClassRsrc(self, nc, lr):
		if not self.Classes.has_key(nc):
			raise KeyError, 'Node class <%s> not found' % nc

		nc = self.Classes[nc]
		# check for removal of resources in use
		for rn in nc.LRCap.keys():
			if not lr.has_key(rn) and nc.rsrcUsage(rn):
				raise ValueError, 'Resource <%s> is in use' % rn

		# check if any resource does not exist
		# check for attribute/counted mismatch
		for rn, cap in lr.items():
			if self.resourceType(rn) != 'l':
				raise ValueError, 'Resource <%s> is not local' % rn
			if not self.validateLRType(rn, cap):
				raise ValueError, 'Local resource type (attr./counted) mismatch for resource <%s>' % rn
				
		# set new capacities
		nc.setLRCap(lr)
		self.updateLRTypes()

	def setNodeClassLDisks(self, nc, ldsks):
		if not self.Classes.has_key(nc):
			raise KeyError, 'Node class <%s> not found' % nc
		self.Classes[nc].setLDisks(ldsks)

	def setNodeClassPower(self, nc, pwr):
		if not self.Classes.has_key(nc):
			raise KeyError, 'Node class <%s> not found' % nc
		self.Classes[nc].setPower(pwr)
		
	def addNode(self, cn, nn, newNode = 1):
		if self.Nodes.has_key(nn):
			raise ValueError, 'Node <%s> already exists' % nn
		if not self.Classes.has_key(cn):
			raise KeyError, 'Node class <%s> not found' % cn
		nc = self.Classes[cn]
		node = RMNode(nn, nc)
		self.Nodes[nn] = node
		# put on hold unless we are reading the configuration on start
		if newNode: 	self.holdNode(nn, 'new node')
		self.setNodeStatus(nn, 0)
		self.createNodeNameList()
		
	def removeNode(self, nn):
		if not self.Nodes.has_key(nn):
			raise KeyError, 'Node <%s> not found' % nn
		node = self.Nodes[nn]
		if node.inUse():
			raise ValueError, 'Node <%s> is in use' % nn
		del self.Nodes[nn]
		node.Class.removeNode(nn)
		self.createNodeNameList()

	def getClassOfNode(self, nn):
		if not self.Nodes.has_key(nn):
			raise KeyError, 'Node <%s> not found' % nn
		return self.Nodes[nn].Class.Name

	def getNodeClass(self, ncn):
		if not self.Classes.has_key(ncn):
			raise KeyError, 'Node class <%s> not found' % ncn
		nc = self.Classes[ncn]
		cap = {}
		#print ncn, nc.LRCap
		for rn, c in nc.LRCap.items():
			if c is Big:	c = None
			cap[rn] = c
		return cap, nc.nodeNames(), nc.getLDisks(), nc.Power
		
	def removeNodeClass(self, ncn):
		if not self.Classes.has_key(ncn):
			raise KeyError, 'Node class <%s> not found' % ncn
		nc = self.Classes[ncn]
		if nc.nodeNames():
			raise ValueError, 'Node class <%s> is not empty' % ncn
		del self.Classes[ncn]

	#
	# configuration saving
	def currentConfig(self, add_to = None):
		# returns a dictionary:
		# set_type -> 
		#	{ set_id or '' ->
		#		{ field -> value or [values] or dict }
		
		if add_to == None:
			cfg_dict = {}
		else:
			cfg_dict = add_to

		# resource lists
		rdict = {}
		# local resources
		lrlst = self.LRUsage.keys()
		if lrlst:
			lrlst.sort()
			rdict['local'] = lrlst
				
		# global resources
		grcap = {}
		for k, v in self.GRCap.items():
			grcap[k] = v
		if grcap:
			rdict['global'] = grcap
		if rdict:
			cfg_dict['resources'] = {'':rdict}
		
		# pools
		pools = {}
		for k, lst in self.LRP.items():
			pools[k] = lst
		for k, lst in self.GRP.items():
			pools[k] = lst
		if pools:
			cfg_dict['resource_pools'] = {'':pools}
		
		# node classes and node list
		nodes = {}
		classes = {}
		for cn, c in self.Classes.items():
			cldict = {}
			rsrc = {}
			for k, v in c.LRCap.items():
				if v is Big or v == None:
					v = ''
				rsrc[k] = v
			cldict['resources'] = rsrc
			cldict['local_disks'] = c.getLDisks()
			cldict['power'] = c.getPower()
			classes[cn] = cldict
			
			for nn in c.nodeNames():
				held, reason = self.nodeIsHeld(nn)
				if held:
					nodes[nn] = [cn, 'held', reason]
				else:
					nodes[nn] = [cn]
				
		if nodes:
			cfg_dict['node_list'] = {'':nodes}
		if classes:
			cfg_dict['node_class'] = classes
			
		return cfg_dict

if __name__ == '__main__':
	from config import *
	cf=ConfigFile('farm.cfg')
	rm=ResourceManager(cf)
