#
# @(#) $Id: Queue.py,v 1.9 2003/01/14 22:07:10 ivm Exp $
#
# $Author: ivm $
#
# $Log: Queue.py,v $
# Revision 1.9  2003/01/14 22:07:10  ivm
# Implemented round-robin over users
#
# Revision 1.8  2001/11/20 19:42:15  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.7  2001/11/05 19:22:03  ivm
# Fixed some bugs
# Made inetractive spawner independent of UPS
#
# Revision 1.6  2001/10/27 18:00:15  ivm
# Implemented non-blocking process start
# Fixed some bugs
#
# Revision 1.5  2001/10/24 18:34:37  ivm
# Implemented ProcType.max_nodes
# Fixed section priority incrementing
#
# Revision 1.4  2001/10/18 02:58:23  ivm
# Fixed bug in handling of new scratch disks in launcher.py
# Implemented runable/non-runable cache in Scheduler, Queue
#
# Revision 1.2  2001/08/23 19:05:54  ivm
# Implemented search with feedback RM algorithm
# Added -v option to status.py
# Fixed handling of time limits in FBSSectionInfo
#
# Revision 1.1  2001/07/03 15:01:43  ivm
# Moved Queue.py to scd
#
# Revision 1.44  2001/06/01 14:45:38  ivm
# Fixed some bugs
#
# Revision 1.43  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.42  2001/03/19 16:22:12  ivm
# Added new fields to "show ptype" and "show queue" in farm_config
#
# Revision 1.41  2001/03/15 21:47:54  ivm
# Implemented "on nodes"
# Fixed protocol version handling in lch, lchif
#
# Revision 1.39  2001/03/12 19:28:37  ivm
# Added "object ownersip" feature
#
# Revision 1.38  2001/02/06 18:25:25  ivm
# Fixed yet another memory mishadnling in farm_history, simplified syntax
# Added canceled() dependency type
# Added job ranges in kill.py
# Show processes for just ended sections
# Fixed decoding of status/signal/core in Section
#
# Revision 1.37  2001/01/03 15:47:14  ivm
# Made queue status (locked/held) persistent
#
# Revision 1.36  2000/11/30 20:23:16  ivm
# Fixed bugs
# Made Scheduler more conservative about unknown queues/ptypes
# Use /tmp/launcher.pid for launcher inter-locking
#
# Revision 1.35  2000/11/13 21:44:49  ivm
# Implemented invariance on elapsed time and section size
#
# Revision 1.34  2000/11/06 17:06:55  ivm
# Added nrunning/ntotal to sections.py
#
# Revision 1.32  2000/11/01 16:06:05  ivm
# Made compile for SunOS
# Introduced "placement" parameter to allocateLocal methods
#
# Revision 1.31  2000/10/24 20:16:09  ivm
# Added "remove" functionality
# Made building of Kerberos module optional
# Included kerberos as optional dependency to UPS table
# v1_2_1
# Fixed exec.py to send command as list
#
# Revision 1.30  2000/10/02 19:20:26  ivm
# Removed debug print-out from RM
# Do not call canEventually... from Queue if no resources required
#
# Revision 1.29  2000/09/27 20:38:00  ivm
# Inmplemented modifications suggested during the code review
#
# Revision 1.28  2000/09/22 18:32:17  ivm
# Fixed bugs found during code review
#
# Revision 1.27  2000/08/22 18:53:11  ivm
# Removed debug print-outs
#
# Revision 1.26  2000/08/18 21:15:40  ivm
# Implemented dynamic re-configuration
#
# Revision 1.25  2000/08/07 14:40:32  ivm
# Added extra parameter to RM.can*AllocateGlobal()
#
# Revision 1.24  2000/08/02 16:36:05  ivm
# Fixed numerous bugs
#
# Revision 1.23  2000/07/17 17:25:10  ivm
# Added queue locking/unlocking
# Generate KeyError if queue not found in hold/releaseQueue
#
# Revision 1.22  2000/06/21 19:26:32  ivm
# Scheduler runs not more often than 2/minute
#
# Revision 1.21  2000/06/19 16:53:55  ivm
# Increment priority of all queues, not only higher priority
#
# Revision 1.18  2000/05/31 15:13:08  ivm
# Removed debug messages from NetIF, fixed Queue.
# Implemented probing in LaucherIF
#
# Revision 1.17  2000/05/30 16:14:13  ivm
# Removed some config parameters
#
# Revision 1.16  2000/04/20 21:18:42  ivm
# Fixed inter-queue scheduling
#
# Revision 1.15  2000/04/06 15:14:36  ivm
# *** empty log message ***
#
# Revision 1.14  2000/03/30 20:44:47  ivm
# Removed and added some printouts
#
# Revision 1.12  2000/03/09 20:19:23  ivm
# *** empty log message ***
#
# Revision 1.10  2000/03/06 21:15:30  ivm
# Added queue held/released status
#
# Revision 1.9  2000/02/25 18:18:08  ivm
# Added sections()
#
# Revision 1.6  2000/02/23 18:10:16  ivm
# Implemented shifts
#
# Revision 1.3  2000/02/15 16:44:29  ivm
# Added import time
#
# Revision 1.2  2000/01/31 21:39:23  ivm
# Fixed more trivial bugs
#
# Revision 1.1  2000/01/28 20:10:07  ivm
# Added Queue.py
#
#

import time
import bmgr_global

class	Queue:
	# See FBSNG Scheduler for algorithms description.
	# See also Scheduler.py

	# attributes an authorized user from self.Users can modify
	UserAttrs = ['MaxSPrio','MinSPrio','SPGap']

	def __init__(self, name, cfg = None):
		self.Name = name
		self.MasterList = {}
		self.UserRanks = {}
		self.MaxSPrio = 100
		self.MinSPrio = 0
		self.InitPrio = self.MinSPrio
		self.SPGap = 1000
		self.MaxQPrio = 100
		self.MinQPrio = 0
		self.Prio = 0
		self.QPGap = 1000
		self.SPInc = 1
		self.SPDec = 0
		self.QPInc = 0
		self.QPDec = 1
		self.CPUTimeLimit = -1
		self.RealTimeLimit = -1
		self.IsHeld = 0
		self.IsLocked = 0
		self.DefProcType = None
		self.Users = ['*']
		self.ProcTypes = ['*']
		self.AvgTime = {}
		self.PrioAdj = 0
		if cfg:
			self.configure(cfg)
		self.Prio = self.MinQPrio
		self.RealPrio = float(self.Prio)
		
	def configure(self, cfg):
		name = self.Name
		self.MaxSPrio = cfg.getValue('queue',name,'s_prio_max',self.MaxSPrio)
		self.SPGap = cfg.getValue('queue',name,'s_prio_gap',self.SPGap)
		self.MaxQPrio = cfg.getValue('queue',name,'q_prio_max',self.MaxQPrio)
		self.MinQPrio = cfg.getValue('queue',name,'q_prio_min',self.MinQPrio)
		self.QPGap = cfg.getValue('queue',name,'q_prio_gap',self.QPGap)
		self.QPInc = cfg.getValue('queue',name,'q_prio_inc',self.QPInc)
		self.QPDec = cfg.getValue('queue',name,'q_prio_dec',self.QPDec)
		self.CPUTimeLimit = cfg.getValue('queue',name,'cputime',self.CPUTimeLimit)
		self.RealTimeLimit = cfg.getValue('queue',name,'realtime',self.RealTimeLimit)
		self.DefProcType = cfg.getValue('queue',name,'proc_type')
		self.InitPrio = self.MinSPrio
		stslst = cfg.getValueList('queue',name,'status')
		if stslst:
			if 'locked' in stslst:
				self.IsLocked = 1
			if 'held' in stslst:
				self.IsHeld = 1
		self.Users = cfg.getValueList('queue', name, 'users', self.Users)
		self.Users.sort()
		self.ProcTypes = cfg.getValueList('queue', name, 'ptypes', self.Users)
		self.ProcTypes.sort()

	def configDict(self):
		qdct = {}
		qdct['s_prio_max'] = self.MaxSPrio
		qdct['s_prio_gap'] = self.SPGap
		qdct['q_prio_max'] = self.MaxQPrio
		if self.MinQPrio:
			qdct['q_prio_min'] = self.MinQPrio
		qdct['q_prio_gap'] = self.QPGap
		if self.QPInc != 1:
			qdct['q_prio_inc'] = self.QPInc
		if self.QPDec != 1:
			qdct['q_prio_dec'] = self.QPDec
		if self.DefProcType:
			qdct['proc_type'] = self.DefProcType
		if self.CPUTimeLimit and self.CPUTimeLimit > 0:
			qdct['cputime'] = self.CPUTimeLimit
		if self.RealTimeLimit and self.RealTimeLimit > 0:
			qdct['realtime'] = self.RealTimeLimit
		sts = []
		if self.IsHeld:
			sts = ['held']
		if self.IsLocked:
			sts.append('locked')
		if sts:
			qdct['status'] = sts
		if not self.Users:
			qdct['users'] = '-'
		else:
			qdct['users'] = self.Users
		if not self.ProcTypes:
			qdct['ptypes'] = '-'
		else:
			qdct['ptypes'] = self.ProcTypes
		return qdct


	def setParams(self, dict, admin, username):
		vals = {}
		# validate parameter values
		for k in ['QPGap', 'QPInc', 'QPDec', 'MaxQPrio', 'MinQPrio',
				'MaxSPrio','MinSPrio','Prio','SPGap','CPUTimeLimit',
				'RealTimeLimit']:
			if dict.has_key(k):
				v = dict[k]
				if type(v) != type(1):
					return 'ERR', 'Invalid value of %s' % k
				vals[k] = v
		if dict.has_key('DefProcType'):
			pt = dict['DefProcType']
			if pt and not bmgr_global.G_ProcTypeFinder.has_key(pt):
				return 'ERR', 'Unknown process type <%s>' % pt
			vals['DefProcType'] = pt

		if dict.has_key('Users'):
			ul = dict['Users']
			if type(ul) == type(''):
				ul = [ul]
			if type(ul) != type([]):
				return 'ERR', 'Invalid value of Users'
			ul.sort()
			vals['Users'] = ul

		if dict.has_key('ProcTypes'):
			ptl = dict['ProcTypes']
			if type(ptl) == type(''):
				ptl = [ptl]
			if type(ptl) != type([]):
				return 'ERR', 'Invalid value of Users'
			ptl = ptl[:]
			ptl.sort()
			vals['ProcTypes'] = ptl
			
		# validate permissions
		authorized = '*' in self.Users or username in self.Users

		for k, v in vals.items():
			if self.__dict__[k] == v:	continue
			if admin or k in self.UserAttrs and authorized:
				continue
			return 'PERM','User not authorized to modify <%s>' % k
			
		for k, v in vals.items():
			self.__dict__[k] = v
		self.putQPInRange()
		return 'OK',''

	def submitAllowed(self, admin, user, ptype):
		if admin:	return 1,''
		if not '*' in self.Users and not user in self.Users:
			return 0,'User <%s> is not allowed to use queue <%s>' % \
				(user, self.Name)
		if not '*' in self.ProcTypes and not ptype in self.ProcTypes:
			return 0,'Queue <%s> does not accept sections if type <%s>' % \
				(self.Name, ptype)
		return 1, ''
		
	def hold(self, admin, user):
		if admin or '*' in self.Users or user in self.Users:
			self.IsHeld = 1
			return 1,''
		else:
			return 0,'PERM Permission denied'
		
	def release(self, admin, user):
		if admin or '*' in self.Users or user in self.Users:
			self.IsHeld = 0
			return 1,''
		else:
			return 0,'PERM Permission denied'

	def isHeld(self):
		return self.IsHeld
		
	def lock(self):
		self.IsLocked = 1
	
	def unlock(self):
		self.IsLocked = 0
	
	def isLocked(self):
		return self.IsLocked

	def addSection(self, sect):
		self.MasterList[sect.ID] = sect
		sect.TimeEstimate = None
		if not self.UserRanks.has_key(sect.Username):
			if len(self.UserRanks) == 0:
				self.UserRanks[sect.Username] = 0
			else:
				self.UserRanks[sect.Username] = \
						max(self.UserRanks.values()) + 1
				
	def remSection(self, sectid):
		#print 'Queue <%s>: remSection(%s)' % (self.Name, sectid)
		try:	
			del self.MasterList[sectid]
			#self.decQuePrio()
		except: pass
		
	def prioInRange(self, x):
		return min(max(x, self.MinSPrio), self.MaxSPrio)

	def submitSection(self, sect):
		# permissions were validated by SectParam.validatePermissions
		sect.Prio = self.prioInRange(self.InitPrio + sect.PrioInc)
		sect.SubTime = time.time()
		sect.PGap = self.SPGap
		sect.QIndex = 0
		self.addSection(sect)

	def resetRunableCache(self):
		self.RunableCache = {}
		
	def runableSection(self, s):
		greq = s.PerProcGlobal
		lreq = s.PerProcLocal
		gsreq = s.PerSectGlobal
		np = s.NProc
		pt = s.ProcType
		placement = s.Placement
		onNodes = s.OnNodes
		if not onNodes: onNodes = None
		key = repr((pt, np, lreq, greq, gsreq, placement, onNodes))
		runable = 1
		if self.RunableCache.has_key(key):
			runable = self.RunableCache[key]
		else:
			runable = 1
			if (gsreq or greq) and \
				not bmgr_global.G_ResourceManager.canEventuallyAllocateGlobal(
						np, greq, pt, gsreq):
				runable = 0
			elif lreq and	\
				not bmgr_global.G_ResourceManager.canEventuallyAllocateLocal(
						np, lreq, pt, placement, onNodes):
				runable = 0
			self.RunableCache[key] = runable
		#if not runable:
		#	print 'Queue: not runable: %s' % s.ID
		return runable
				
	def schedList(self, getAll = 0):
		lst = self.MasterList.values()
		for s in lst:	s.UserRank = self.UserRanks[s.Username]
		lst.sort(lambda s1, s2: 
			cmp(s2.Prio, s1.Prio) or 
			cmp(s1.UserRank, s2.UserRank) or
			cmp(s1.SubTime, s2.SubTime))
		if not getAll:
			if lst:
				# remove not-ready sections
				lst = filter(lambda s: s.state() == 'ready', lst)
			if lst:
				# cut out low-priority sections
				minp = lst[0].Prio - self.SPGap
				lst1 = []
				for s in lst:
					if s.Prio >= minp:
						lst1.append(s)
					else:
						break
				lst = lst1
			if lst:
				# remove non-runable sections
				self.resetRunableCache()
				lst1 = []
				for s in lst:
					if s.state() == 'ready' and self.runableSection(s):
						lst1.append(s)
				lst = lst1
		return lst

	def rotateUsers(self, username):
		r0 = self.UserRanks[username]
		rmax = 0
		for u, r in self.UserRanks.items():
			if r > r0:
				r = r - 1
				self.UserRanks[u] = r
			if u != username:	rmax = max(r, rmax)
		self.UserRanks[username] = rmax + 1
			
	def incSectPrio(self, sect, delta = None):
		old_prio = sect.Prio
		if delta == None:
			delta = self.SPInc
		#print 'Queue: incrementing %s prio from %d by %s' %\
		#	(sect.ID, sect.Prio, delta)
		sect.Prio = self.prioInRange(sect.Prio + delta)
		if sect.Prio != old_prio:
			bmgr_global.G_JobDB.saveSection(sect)

	def decSectPrio(self, sect):
		old_prio = sect.Prio
		sect.Prio = self.prioInRange(sect.Prio - self.SPDec)
		if sect.Prio != old_prio:
			bmgr_global.G_JobDB.saveSection(sect)

	def incPrio(self, incr):
		oldp = self.Prio
		self.Prio = self.Prio + incr
		self.putQPInRange()
		return self.Prio - oldp
		
	def putQPInRange(self):
		self.Prio = max(min(self.Prio, self.MaxQPrio), self.MinQPrio)

	def sections(self):
		lst = self.schedList(getAll = 1)
		ids = []
		for s in lst:
			ids.append(s.ID)
		return ids
		
	def isEmpty(self):
		return not self.MasterList

	def updateAvgTime(self, ptn, t):
		if not self.AvgTime.has_key(ptn):
			self.AvgTime[ptn] = t
		self.AvgTime[ptn] = self.AvgTime[ptn] * 0.9 + t * 0.1
		
	def getAvgTime(self, ptn):
		try:	return self.AvgTime[ptn]
		except: return None
