#
# @(#) $Id: MiscClasses.py,v 1.2 2001/10/24 18:34:37 ivm Exp $
#
# $Log: MiscClasses.py,v $
# Revision 1.2  2001/10/24 18:34:37  ivm
# Implemented ProcType.max_nodes
# Fixed section priority incrementing
#
# Revision 1.1  2001/09/20 21:14:07  ivm
# Initial deposition
#
#

class	RV: 	# Resource vector
	def __init__(self, src = None, default = 0):
		self.Dict = {}
		self.Default = default
		try:	
			for k, v in src.items():
				self.Dict[k] = v
		except: pass

	def __repr__(self):
		return '<RV %s>' % self.Dict
	
	def __getitem__(self, k):
		try:	return self.Dict[k]
		except KeyError:
			return self.Default
	
	def __setitem__(self, k, v):
		self.Dict[k] = v
		
	def __delitem__(self, k):
		try:	del self.Dict[k]
		except KeyError:
			pass			

	def keys(self):
		return self.Dict.keys()
		
	def items(self):
		return self.Dict.items()

	def has_key(self, k):
		return self.Dict.has_key(k)

	def values(self):
		return self.Dict.values()

	def dict(self):
		d = {}
		for k, v in self.Dict.items():
			d[k] = v
		return d

	def add(self, another, mult=1):
		for k, v in another.items():
			self[k] = self[k] + v*mult
			if self[k] < 0:
				self[k] = 0
		return self

	def __add__(self, another):
		result = RV()
		for k, v in another.items() + self.items():
			result[k] = result[k] + v
		return result
		
	def __sub__(self, another):
		result = RV(self)
		for k, v in another.items():
			result[k] = result[k] - v
			if result[k] < 0:
				result[k] = 0
		return result

	def sub(self, another, mult=1):
		for k, v in another.items():
			self[k] = self[k] - v*mult
			if self[k] < 0:
				self[k] = 0
		return self

	def fitsInto(self, limits):
		for k, v in self.items():
			if limits.has_key(k) and v > limits[k]:
				return 0
		return 1
				
	def filter(self, fcn):
		rv = RV(self.Default)
		for k, v in self.Dict.items():
			if fcn(k, v):
				rv[k] = v
