#@(#)$Id: History.py,v 1.11 2001/02/02 20:43:51 tlevshin Exp $
#$Author: tlevshin $
#$Log: History.py,v $
#Revision 1.11  2001/02/02 20:43:51  tlevshin
#create archive log file in HistArch
#
#Revision 1.10  2000/09/06 14:58:27  tlevshin
#fixed bug #89190 - put actual end time of the process
#
#Revision 1.9  2000/08/21 15:35:36  tlevshin
#use G_HistoryDB from bmgr_global, instantiate this just once
#
#Revision 1.8  2000/08/17 16:43:10  tlevshin
#"zombie" process is stored in History
#
#Revision 1.7  2000/08/09 19:57:45  tlevshin
#added cvs tags
#

import time
import sys
import os
import bmgr_global
global lastArchiveTime
lastArchiveTime=0

class History:
    def __init__(self,cfg):
	self.hfile=cfg.getValue('history','*','hist_dir','.')+'/'+\
		    cfg.getValue('history','*','hist_file','hist.log')
	self.logDir=cfg.getValue('logd','*','log_dir','.')+'/histArch'
	try:
		os.stat(self.logDir)
	except OSError:
		try:
			os.mkdir(self.logDir)
		except:
	         	print "Failed to create archive directory %s:%s,%s" %\
		   (self.logDir,sys.exc_type,sys.exc_value)

	except:
		print "Failed to verify stat of archive directory %s:%s,%s" %\
                   (self.logDir,sys.exc_type,sys.exc_value)
	self.archivePeriod=cfg.getValue('history','*','archive_period',1)*60*60*24
	self.afile=cfg.getValue('history','*','hist_dir','.')+'/'+\
		    cfg.getValue('history','*','archive_file','archive.log')

    def openHistFile(self):
	try:
	    self.hfp=open(self.hfile,'a')
	    return 0,""
	except:
	    return 1,"Failed to open history file %s:%s,%s" %\
		   (self.hfile,sys.exc_type,sys.exc_value)

    def archive(self):
	global lastArchiveTime
	if (lastArchiveTime+self.archivePeriod) > time.time():
		return 0,""
        try:
		stamp=time.strftime("%Y%m%d%H%M",time.localtime(time.time()))
		cmd='mv %s %s/archive.%s.log' % (self.afile, self.logDir,stamp)
		os.system(cmd)
	except:
		pass
			
        try:
            afp=open(self.afile,'a')
	    if not os.system('cat %s >> %s' % (self.hfile,self.afile)):
		lastArchiveTime=time.time()
		os.system('rm %s' % self.hfile)
		return 0,""
	    else:
		return 1,"Failed to append archive file %s " % self.afile
        except:
	    return 1,"Failed to archive: %s,%s" %(sys.exc_type, sys.exc_value)


    def store(self,sec):
	retVal,reason=self.openHistFile()
	if retVal:
	    return retVal,reason

	#changing all unset to None
	if len(sec.PerSectGlobal): psg=sec.PerSectGlobal
	else:	    psg=None
	if len(sec.PerProcLocal):  ppl=sec.PerProcLocal
	else:	    ppl=None
	if len(sec.PerProcGlobal): ppg=sec.PerProcGlobal
	else:	    ppg=None
	if len(sec.Depend):	   dep=sec.Depend
	else:	    dep=None	
	if sec.ExitCode:
	    state=sec.State
	else:
	    state="Done"
	base="%s|%s|%s|%s" % (repr(sec.StartTime),repr(sec.EndTime),\
					  sec.JID,sec.Name)
	record="|0|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|\n"% \
		(repr(sec.UID),repr(sec.GID),\
		 sec.Queue,sec.ProcType,\
		 sec.SectParam.Exec,repr(sec.SubTime),\
		 psg,ppl,ppg,dep,\
		 repr(sec.Prio),repr(sec.Need),repr(sec.SectParam.Nice),\
		 repr(sec.SectParam.LeaderOnly),repr(sec.NProc),\
		 sec.ExitCode,state,repr(sec.SectParam.JDFSeq))
	try:
	    self.hfp.write(base+record)
	    self.hfp.flush()
	except:
	    return 1,"Failed to write to history file %s:%s,%s"\
		   %(sef.hfile,sys.exc_type, sys.exc_value)

	for key,proc in sec.Procs.items():
	    base="%s|%s|%s|%s" % (repr(proc.StartTime),repr(proc.EndTime),\
					  sec.JID,sec.Name)
	    record="|%s|%s|%s|%s|%s|%s|\n"% (key,proc.Node,repr(proc.CPUTime),repr(proc.Signal),repr(proc.Core),repr(proc.ExitCode))
	    try:
		self.hfp.write(base+record)
		self.hfp.flush()
	    except:
		return 1,"Failed to write to history file %s:%s,%s"\
		       %(self.hfile,sys.exc_type, sys.exc_value)
	try:
	    self.hfp.close()
	    return 0,""
	except:
	    return 1,"Failed to close history file %s:%s,%s" \
		   %(self.hfile,sys.exc_type, sys.exc_value)
