#@(#)$Id: GuiRstat.py,v 1.15 2001/09/20 19:05:33 tlevshin Exp $
#@(#)$Author: tlevshin $
#@(#)$Log: GuiRstat.py,v $
#@(#)Revision 1.15  2001/09/20 19:05:33  tlevshin
#@(#)fixed the name display
#@(#)
#@(#)Revision 1.14  2000/12/21 18:03:52  tlevshin
#@(#)fix scroll bar when xscrol > inRow
#@(#)
#@(#)Revision 1.13  2000/12/18 21:47:44  tlevshin
#@(#)fix available
#@(#)
#@(#)Revision 1.12  2000/12/06 22:28:18  tlevshin
#@(#)fix scrolling problem and text display
#@(#)
#@(#)Revision 1.11  2000/11/16 06:00:26  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.10  2000/11/15 21:01:29  tlevshin
#@(#)bug fixes for graph monitoring
#@(#)
#@(#)Revision 1.9  2000/11/10 23:01:03  tlevshin
#@(#)implemented new graphics for resources
#@(#)
#@(#)Revision 1.8  2000/11/01 22:40:02  tlevshin
#@(#)add monitor for resources, thread in GuiRstat
#@(#)
#@(#)Revision 1.7  2000/10/04 14:32:19  tlevshin
#@(#)change cluster_name to farm_name in fbs.cfg
#@(#)
#@(#)Revision 1.6  2000/10/03 14:09:37  tlevshin
#@(#)calculate true scroll region
#@(#)
#@(#)Revision 1.5  2000/10/03 13:34:11  tlevshin
#@(#)implemeted configuration options
#@(#)
#@(#)Revision 1.4  2000/10/02 19:18:18  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.3  2000/10/02 14:45:18  tlevshin
#@(#)fixed multiple bugs related to -j options
#@(#)
#@(#)Revision 1.2  2000/06/14 22:13:22  tlevshin
#@(#)fixed usage message
#@(#)
#@(#)Revision 1.1  2000/03/22 21:54:16  tlevshin
#@(#)modified Gui version using new Api
#@(#)

#***************************************************************
#*      Farms Batch Gui
#*      Monitor Rstatd statistics
#***************************************************************
from GuiBase import *
import GuiMetrics
import time
import signal
from threading import Condition,Lock,Thread

import sys
maxval=[]
RESET_FLAG=0
killSignal=0
def handleSig(signo, env):
    global killSignal
    killSignal = signo
    setSig()
def setSig():
    signal.signal(signal.SIGINT, handleSig)
    signal.signal(signal.SIGHUP, handleSig)



#************************************************************************
class Buffer:
    def __init__(self):
	self.condition=Condition(Lock())
	self.metricsBuf={}
	self.metricsStatus={}
	self.maxDict={}
    def setMax(self,name,max):
	self.maxDict[name]=max
    def getMax(self,name):
	return self.maxDict[name]
    def acquire(self):
	self.condition.acquire()
    def release(self):
	self.condition.release()
    def notify(self):
	self.condition.notify()
    def notifyAll(self):
	 self.condition.notifyAll()
    def wait(self,timeout=None):
	self.condition.wait(timeout)
    def setStatus(self,name,status):
	self.metricsStatus[name]=status
    def addStat(self,name,buf):
	self.metricsBuf[name]=buf
    def getStat(self,name):
	return 	self.metricsBuf[name]
    def getStatus(self,name):
	return 	self.metricsStatus[name]
class Provider(Thread):
    def __init__(self,buf,metName,list,max,update):
	global maxval
	Thread.__init__(self,None,self.rcvMetrics)
	self.buffer=buf	
	self.metName=metName
	self.list=list
	self.update=update
	self.work=1
	self.max=max
	self.metrics={}
	self.buffer.acquire()
	for name in self.list:
	    ind=string.find(self.metName,'.')
	    if ind <0:
		self.metrics[name]=eval("GuiMetrics.%s('%s',%s)" % (self.metName,\
						       name,self.update))
		

	    else:
		self.metrics[name]=eval("GuiMetrics.%s('%s',%s,'%s')" % (self.metName[:ind],\
								    name,self.update,self.metName[ind+1:]))

			   
	    if self.metrics[name].maxval!=None:
		maxval=self.metrics[name].maxval
	    self.buffer.setMax(name,self.metrics[name].max)
	    self.buffer.setStatus(name,self.metrics[name].status)
	self.buffer.release()
	self.start()
    def rcvMetrics(self):
	while 1:
	    if not self.work:
		return
	    self.buffer.acquire()
	    for name in self.list:
		if self.metrics[name].status:
		    self.metrics[name].reconnect()
		self.metrics[name].getStat()
		self.buffer.addStat(name,self.metrics[name].stat)
		self.buffer.setStatus(name,self.metrics[name].status)
	    self.buffer.release()
	    time.sleep(self.update)

	    
#*************************************************************************
class ButtonEnd(ButtonBase):
    def __init__(self,frame,top,name,side="left",anchor='nw',fill='x'):
        ButtonBase.__init__(self,frame,name,side,anchor,fill)
        self.top=top

    def action(self):
        self.top.updt=1
        self.top.end()
#**************************************************************************

#**************************************************************************
class InfoLabel:
    def __init__(self,top):
	self.l1=Label(top)
        self.l1.pack()
        self.l2=Label(top)
        self.l2.pack()
        self.l3=Label(top)
        self.l3.pack()
        self.l4=Label(top)
        self.l4.pack()

    def update(self,old,update,span,name):
	new=time.time()
	if new >= (old+update*span):
		old=new-update*span
	self.l1.configure(text="Polling Interval: "+repr(update)+"sec")
	self.l2.configure(text="Max Display Interval: "+repr(update*span)+"sec")
	self.l3.configure(text=name+" displayed from:")
	self.l4.configure(text=time.ctime(old)+" - "+\
			  time.ctime(new))
    def destroyAll(self):
	self.l1.destroy()
	self.l2.destroy()
	self.l3.destroy()
	self.l4.destroy()
#********************************************************************************
class ButtonCfg(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.master=top
	self.cancel=1
    def action(self):
	global s
	global RESET_FLAGS
	s=[StringVar(),StringVar(),StringVar(),StringVar()]
	s[0].set(repr(self.master.xscrol))
	s[1].set(repr(self.master.yscrol))
	s[2].set(repr(self.master.inRow))
	s[3].set(self.master.fill)
	self.setCnfg(s)
	if self.cancel:
	    self.master.xscrol=string.atoi(s[0].get())
	    self.master.yscrol=string.atoi(s[1].get())
	    self.master.inRow=string.atoi(s[2].get())
	    self.master.fill=s[3].get()
	    RESET_FLAG=1
	    self.master.run()
    def setCnfg(self,s):
	self.top=Toplevel()
	self.top.title("Configuration Options")
	self.frame=Frame(self.top)
	self.frame.pack(side=TOP,expand=YES,fill=BOTH)
	f1=Frame(self.frame)
	f1.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f1,text='Number of visible icons per row?',relief=RIDGE,width=50,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	e1=Entry(f1,textvariable=s[0],relief=SUNKEN,background='pink',width=10)
	e1.pack(side=RIGHT,expand=YES,fill=X)
	f2=Frame(self.frame)
	f2.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f2,text='Number of visible icons per column?',relief=RIDGE,width=50,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	e2=Entry(f2,textvariable=s[1],relief=SUNKEN,background='pink',width=10)
	e2.pack(side=RIGHT,expand=YES,fill=X)
	f3=Frame(self.frame)
	f3.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f3,text='Max number of icons per row?',relief=RIDGE,width=50,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	e3=Entry(f3,textvariable=s[2],relief=SUNKEN,background='pink',width=10)
	e3.pack(side=RIGHT,expand=YES,fill=X)
	f4=Frame(self.frame)
	f4.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f4,text='Fill Graph?',relief=RIDGE,width=20,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	r=Radiobutton(f4,text="yes",variable=s[3],value="yes",\
			      anchor=W,command=self.getFill)

	r.pack(fill=X,side=LEFT)
	r=Radiobutton(f4,text="no",variable=s[3],value="no",\
			      anchor=W,command=self.getFill)

	r.pack(fill=X,side=LEFT)
	ButtonCheck(self.top,self,0,'OK','left')
	ButtonCheck(self.top,self,1,'Cancel','right')   
	e1['textvariable']=s[0]
	e2['textvariable']=s[1]
	e3['textvariable']=s[2]
	try:
		self.top.grab_set()
		self.top.focus_set()
		self.top.wait_window()
	except:
	    #print "cnfg",sys.exc_type,sys.exc_value
	    self.top.destroy()
    def getFill(self):
	self.master.fill=s[3].get()

    def check(self):
	self.cancel=1
	try:
	    xscrol=string.atoi(s[0].get())
	    if xscrol < 1:
		tkMessageBox.showwarning('Invalid number','Number of icons '+\
					 repr(xscrol)+' is not valid')
		return 1
	except:
	    tkMessageBox.showwarning('Wrong entry','Number of icons should integer')	    
	    return 1
		
	try:
	    yscrol=string.atoi(s[1].get())
	    if yscrol < 1:
		tkMessageBox.showwarning('Invalid number','Number of icons '+\
					 repr(yscrol)+' is not valid')
		return 1
	except:
	    tkMessageBox.showwarning('Wrong entry','Number of icons should integer')	    
	    return 1
	try:
	    inRow=string.atoi(s[1].get())
	    if inRow < 1:
		tkMessageBox.showwarning('Invalid number','Number of icons per row'+\
					 repr(yscrol)+' is not valid')
		return 1
	except:
	    tkMessageBox.showwarning('Wrong entry','Number of icons should integer')	    
	    return 1
	self.cancel=1
	return 0

#********************************************************************************
class ButtonPol(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.master=top
	self.cancel=1

    def action(self):
	global s1,s2
	global RESET_FLAG
	s1=StringVar()
	s2=StringVar()
	s1.set(repr(self.master.update))
	s2.set(repr(self.master.span*self.master.update))
	self.setPol(s1,s2)
	if self.cancel:
	    self.master.update=string.atoi(s1.get())
	    self.master.span=string.atoi(s2.get())/self.master.update
	    RESET_FLAG=1
	    self.master.run()
	else:
	    self.master.draw()

    def setPol(self,timer,span):
	self.top=Toplevel()
	self.top.title("Display Interval")
	self.frame=Frame(self.top)
	self.frame.pack(side=TOP,expand=YES,fill=BOTH)
	f1=Frame(self.frame)
	f1.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f1,text='Polling Interval(in sec)?',relief=RIDGE,width=25,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	e1=Entry(f1,textvariable=timer,relief=SUNKEN,background='pink',width=20)
	e1.pack(side=RIGHT,expand=YES,fill=X)
	f2=Frame(self.frame)
	f2.pack(side=TOP,anchor=W,expand=YES,fill=X)
	Label(f2,text='Display Interval(in sec)?',relief=RIDGE,width=25,background='white',foreground='black').pack(side=LEFT,padx=2,pady=1,ipadx=2,ipady=2)
	e2=Entry(f2,textvariable=span,relief=SUNKEN,background='pink',width=20)
	e2.pack(side=RIGHT,expand=YES,fill=X)
	ButtonCheck(self.top,self,0,'OK','left')
	ButtonCheck(self.top,self,1,'Cancel','right')   
	e1['textvariable']=timer
	e2['textvariable']=span
	try:
	    self.top.grab_set()
	    self.top.focus_set()
	    self.top.wait_window()
	except:
	    #print "set pol",sys.exc_type,sys.exc_value
	    self.top.destroy()

    def check(self):
	self.cancel=1
	try:
	    timer=string.atoi(s1.get())
	    if timer < 5:
		tkMessageBox.showwarning('Invalid time','Polling Interval '+\
			   repr(timer)+' is not valid (>=5 sec)')
		return 1
	except:
	    tkMessageBox.showwarning('Wrong entry','Polling interval should be time in'+\
		       ' seconds')
	    return 1
		
	try:
	    span=string.atoi(s2.get())
	    if span/timer < 100:
		tkMessageBox.showwarning('Poor Resolution','Display interval '+\
			   ' should be >= '+repr(100*timer)+'  sec'+\
			   ' when Polling interval is '+repr(timer))

		return 1
	    if span/timer >1000:
	        tkMessageBox.showwarning('Too wide','The Max Display interval '+\
			   ' should be < '+repr(1000*timer)+' sec'+\
			   ' when Polling interval is '+repr(timer))
                return 1
	except:
	    tkMessageBox.showwarning('Wrong entry','Display interval should be time in seconds')
	    return 1
	self.cancel=1
	return 0
#*********************************************************************


class Graph:
    def	__init__(self,tk,c,num,buffer,name,span,inRow=5,fill='no',opt=0):
	global maxval
	self.tk=tk
	self.fill=fill
        self.canvas = c
	self.opt=opt
	self.pieces={}
	self.num=num
	self.name=name
	self.buffer=buffer
	self.text=0
	self.value=0
	self.grid=[0,0,0]
	self.span=span
	self.inRow=inRow
	self.bad=0
	self.message=None
	self.reset()

    def reset(self):
	num=self.num
	c=self.canvas
	numPic=self.inRow
	n=num%numPic
	if n==0:
	    n=numPic
	m=num/numPic+1
	if num%numPic==0:
	    m=num/numPic
	    
	x1=n*25+self.span*(n-1)
	x2=x1+self.span
	y1=m*20+100*(m-1)
	y2=y1+100
	self.width, self.height=x2,y2
	self.destroy()
	self.text=c.create_text(x1+30,y1-10,text=self.name,fill="red",\
				width=self.width-x1-50)
	self.min=c.create_text(x1-12,y2-5,text="0",fill="black",width=10)
	self.r=c.create_rectangle(x1,y1,x2,y2,width=2,outline="blue",\
				  fill="white")
	for i in range(3):
		self.grid[i]=c.create_line(self.width-self.span,self.height-25*(i+1),self.width,self.height-25*(i+1),width=1,fill='green')
	if maxval[self.opt]!=None:
	    self.max=c.create_text(x1-12,y1+5,text=repr(maxval[self.opt]),fill="black")
	else:
	    self.max=c.create_text(x1-12,y1+5,text=repr(self.buffer.getMax(self.name)),fill="black")
	p=c.create_line(self.width-1,self.height,self.width,self.height,width=1,fill='blue')
	self.pieces[0] = p
	self.k=1
	self.old=self.height
	self.reset_flag=0
    def isBadStatus(self):
	if self.bad:
	    self.buffer.acquire()
	    status=self.buffer.getStatus(self.name)
	    self.buffer.release()
	    if not status:
		self.bad=0
		self.canvas.delete(self.message)
		self.message=None
	else:
	    self.buffer.acquire()
	    status=self.buffer.getStatus(self.name)
	    self.buffer.release()
	    if status:
		self.bad=1
	return self.bad
    def notAvail(self):
	if self.message==None:
	    c=self.canvas
	    text="Not available"
	    self.message=c.create_text(self.width-50,self.height-50,\
				   text=text,fill="darkgreen")
	
    def get(self):
	global RESET_FLAG
	global maxval
	self.buffer.acquire()
	stat=self.buffer.getStat(self.name)
	self.buffer.release()
	try:
		y=float(stat[self.opt])
	except:
		y=0.0
	self.writeValue(y)
	if maxval[self.opt]!=None:	    
	    if y > maxval[self.opt]:
		maxval[self.opt]=int(y)*2
		RESET_FLAG=1

	if maxval[self.opt]!=None:  
	    y=y*100/maxval[self.opt]
	else:
	    y=y*100/self.buffer.getMax(self.name)
	v=self.height-y
	return v

    def draw(self,item):
	try:
	    c=self.canvas
	    k=0
	    if item>=self.span:   
		k=item-self.span
		c.delete(self.pieces[k])
		del self.pieces[k]
		k=k+1
	    for i in range(k,item):
		p=self.pieces[i]
		c.move(p,-1,0)
	    y=self.get()
	    if self.fill=="no":
		p=c.create_line(self.width-1,self.old,self.width,y,width=1,\
				fill='red')
	    else:
		
		p=c.create_polygon(self.width-1,self.height,self.width-1,self.old,self.width,y,width=1,\
			    fill='red')
	    self.pieces[self.k]=p
	    self.k=self.k+1
	    self.old=y
	    return 0
	except:
	    #print "draw",sys.exc_type,sys.exc_value
	    return 1

    def writeValue(self,y):
	c=self.canvas
	if self.value:
		c.delete(self.value)
	idx=string.find(repr(y),'.')
	yInt=repr(y)[:idx]
	yFloat=repr(y)[idx+1:]
	if len(yInt) > 7:
	    curVal=yInt[0]+'.'+yInt[1]+"e+"+repr(len(yInt)-2)
	else:
	    if len(yFloat)<=2:
		curVal=yInt+"."+yFloat
	    else:
		curVal=yInt+"."+yFloat[0:2]
	self.value=c.create_text(self.width-20,self.height-110,\
	        text=":"+curVal,fill="darkgreen")

    def destroy(self):
	c=self.canvas
	try:
	    c.delete(self.text)
	    c.delete(self.value)
	    for i in range(3):
		c.delete(self.grid[i])
	    c.delete(self.min)
	    c.delete(self.max)
	    c.delete(self.r)
	    c.delete(self.message)
	except:
	    #print "destroy 1",sys.exc_type,sys.exc_value
	    pass
	for i in range(0,len(self.pieces)):
	    try:
		c.delete(self.pieces[i])
	    except:
		#print "destory 2",sys.exc_type,sys.exc_value
		pass
#****************************************************************

#****************************************************************

class HostMonitor:
    def __init__(self,hostlist,metName="Rstat",update=5,span=100,xscrol=5,yscrol=5,fill='no',inRow=5):
	global maxval
	if not len(hostlist):
	    return
	self.hostlist=hostlist
	self.update=update
	self.span=span
	self.fill=fill
	self.inRow=inRow
	self.xscrol=xscrol
	self.yscrol=yscrol
	self.opt=0
	self.optname=GuiMetrics.getOpt(metName)
	maxval=GuiMetrics.getMaxVal(metName)
	self.top=Tk()
	self.menubar()
	self.old=time.time()
	self.canvas=None
	self.metName=metName
	self.buffer=Buffer()
	self.provider=Provider(self.buffer,metName,hostlist,span,update)
	self.run()

    def run(self):
	self.reconfig()
	self.infoLabel=InfoLabel(self.top)
	self.graph=[]
	try:
	    self.draw()
	except:
	    #print "run",sys.exc_type,sys.exc_value
	    pass
    def reconfig(self):
	if self.canvas:
	    self.canvas.destroy()
	    self.frame.destroy()
	    self.infoLabel.destroyAll()
	if self.span>=1000:
	    self.xscrol=1
	if self.inRow<self.xscrol:
		self.xscrol=self.inRow
	width=(self.span+25)*self.xscrol
	height=(120)*self.yscrol
	self.frame=Frame(self.top)
	self.frame.pack(expand=YES,fill=BOTH)
	numPic=len(self.hostlist)
	if (self.xscrol*self.yscrol)>=numPic and \
	   (self.xscrol>=self.inRow):
	    self.canvas = c = Canvas(self.frame,width=width, height=height,\
				     highlightbackground='black')
	else:
	    
	    self.canvas = c = Canvas(self.frame,width=width,height=height,\
	       scrollregion=(0, 0,self.inRow*(self.span+25),\
			     ((numPic/self.inRow)+1)*120),\
				     highlightbackground='black')
	    if self.xscrol<self.inRow:
		c.scrollX=Scrollbar(self.frame,orient=HORIZONTAL)
		c['xscrollcommand'] = c.scrollX.set
		c.scrollX['command'] = c.xview
		c.scrollX.config(relief=SUNKEN)
		c.scrollX.pack(side=BOTTOM, fill=X)
	    if self.yscrol*self.inRow<numPic:
		c.scrollY=Scrollbar(self.frame,orient=VERTICAL)
		c['yscrollcommand'] = c.scrollY.set
		c.scrollY['command'] = c.yview
		c.scrollY.pack(side=RIGHT, fill=Y)
	c.pack(expand=YES,fill=BOTH)
	


    def menubar(self):
	self.bar=Frame(self.top)
	self.bar.pack(side=TOP,fill=X)
	self.h=MenubuttonBase(self.bar,'Options')
	i=0
	for name in self.optname:
	    self.h.menu.add_command(label=name,command=(lambda self=self,x=i:\
							self.changeOpt(x)))
	    i=i+1
	ButtonPol(self.bar,self,'Disp. Interval')
	ButtonCfg(self.bar,self,'Configuration')
	ButtonPrint(self.bar,self,'Print')
	ButtonSave(self.bar,self,'Save')
	ButtonEnd(self.bar,self,'Quit')	

    def changeOpt(self,i):
	global RESET_FLAG
	RESET_FLAG=1
        self.opt=i
        self.draw()
	
    def draw(self):
	global RESET_FLAG
	try:
	    self.top.title(self.optname[self.opt]+getCluster())
	    c=self.canvas
	    for i in range(0,len(self.graph)):
		self.graph[i].destroy()
	    del self.graph
	    self.graph=[]
	    g=self.graph
	    for i in range(0,len(self.hostlist)):
		gr=Graph(self.frame,c,i+1,self.buffer,self.hostlist[i],\
			 self.span,self.inRow,self.fill,self.opt)
		g.append(gr)
	    self.frame.update()
	    i=1
	    while 1:
		if killSignal:
		    self.end()
		told=time.time()
		for k in range(0,len(g)):
		    if g[k].isBadStatus():
			g[k].notAvail()
		    if g[k].draw(i):
			return

		if RESET_FLAG:
		    self.old=time.time()
		    for k in range(0,len(g)):
			g[k].reset()
		    i=0
		RESET_FLAG=0
		self.infoLabel.update(self.old,self.update,self.span,self.optname[self.opt])
		tcur=time.time()
		slp=self.update-tcur+told
		told=tcur
		while (slp>=1):       #update could take some time, so will sleep less
		    self.bar.update()  #in order to react to menubutton
		    tcur=time.time()
		    slp=slp-tcur+told
		    if slp<=0:
			break
		    if slp<=0:
			break
		    if slp>1:
			told=tcur
			time.sleep(1)
			continue
		    time.sleep(slp)


		i=i+1
	except:
	    try:
		self.end()
	    except:
		pass
		
    def end(self):
	self.provider.work=0
	self.buffer.acquire()
	self.buffer.notifyAll()
	self.buffer.release()
	self.provider.join()
	try:
	    self.top.destroy()
	except:
	    pass
	sys.exit(0)
    def print_window(self):
	import time
	title=self.optname[self.opt]+getCluster()
	l=[]
	queue=None
	message=""
	date=time.ctime(time.time())
	try:
	    l=open(os.environ["HOME"]+'/.flprrc','r').readlines()
	    for line in l:
		idx=string.find(line,'queue')
		if idx >= 0:
		    s=string.split(line[:-1])
		    queue=s[1]
		    message="print request for above sent to "+queue
		    break
	except:
	    fileName=os.environ["HOME"]+"/"+string.joinfields(string.split(title),"")+".ps"
            message="User printer default file .flprrc doesn't exist.\nDo you want to save the window into the file ?"
            if tkMessageBox.askokcancel('Saving the file',message):
                fileName=tkFileDialog.asksaveasfilename(defaultextension=["*"],\
                        filetypes=[("postscript","*.ps")],parent=self.top)
            else:
                return
            if not len(fileName):
                tkMessageBox.showwarning('Fail to save the file',"No File Name provided, will not save")
                return
	message="Window "+title+" has been saved into file "+fileName
	if os.uname()[0]=='Linux':
	    if queue:
		cmd="/usr/bin/X11/xwd -name "+repr(title)+\
                 "| convert -comment "+repr(title)+\
                 " - ps:- |flpr -q"+queue+">/dev/null 2>&1"
	    else:
		cmd="/usr/bin/X11/xwd -name "+repr(title)+\
		     "|convert -comment "+repr(title)+\
		     " - ps:"+fileName
	else:
	    if queue:
		cmd="/usr/bin/X11/xwd -name "+repr(title)+\
		     "| /usr/bin/X11/xpr -device ps -gray 3 -header "+repr(title)+" -trailer "+\
		     repr(date)+"|flpr -q"+queue+">/dev/null 2>&1"
	    else:
		cmd="/usr/bin/X11/xwd -name "+repr(title)+\
		     "| /usr/bin/X11/xpr -device ps -gray 3 -header "+repr(title)+" -trailer "+\
		     repr(date)+" > "+fileName
	l=os.popen(cmd,'r').readlines()
	tkMessageBox.showwarning('Printing the file',message)
def usage():
    usage= "USAGE: fbs xsysmon[(<host>...|<host_prefix> <start> <end>|-j (<jobid>|<sectionid>))]" 
    print usage
    return

if __name__=="__main__": 
    import sys
    import os
    import getopt
    import string
    import pwd
    from FBS_API import FBSClient
    import config
    import socket
    setSig()
    list=[]
    try:
	optlist,args = getopt.getopt(sys.argv[1:],"m:j:",['help'])
    except getopt.error,error_msg:
	print "fbs xsysmon: " + error_msg
	print "Try \'fbs xsysmon help\' for more information."	
	sys.exit(1)
    if not len(optlist) and not len(args): #either jobId or hostname
	print "fbs xsysmon:  either jobId or hosts list could be supplied" 
	print "Try \'fbs xsysmon help\' for more information."	
	sys.exit(1)
    try:
	config_file=os.environ['FBS_CONFIG']
	open(config_file,'r')
	cfg=config.ConfigFile(config_file)
	clstName=cfg[('global',1,'farm_name')]
	if clstName:
	    setCluster(clstName)
	    domName=config.ConfigFile(os.environ['FBS_CONFIG'])[('global',1,'DOMAIN_NAME')]
	else:
	    domName=None
    except:
	cfg=None
	domName=None
    jobId=None
    section=None
    if len(optlist):
	for opt in optlist:
	    if opt[0]=="--help":
		usage()
		sys.exit(1)
	    elif opt[0]=="-j":
		try:
		    fc=FBSClient(whoAmI=pwd.getpwuid(os.getuid())[0],cfg=config_file)
		except:
		    fc=None
		idx=string.rfind(opt[1],'.')
		if idx <0:
		    id=opt[1]
		else:
		    id=opt[1][:idx]
		    section=opt[1][idx+1:]
		try:
		    jobId=string.atoi(id)
		except:
		    if section:
			print "Wrong section id"
		    else:
			print "Wrong job Id"
		    usage()
		    sys.exit(1)
		if cfg==None:
		    print "Could not find configuration file ",config_file
		    sys.exit(1)
		    if fc==None:
			print "Could not connect to bmgr"
			sys.exit(1)
		try:
		    idL=fc.getJobList()
		    if repr(jobId) not in idL:
			raise "NotRunning"
			
		    job=fc.getJob(jobId)
		    sl=job.sections()
		    if section:
			if section not in sl:
			    raise "NotRunning"
		    for sec in sl:
			secId=repr(jobId)+"."+sec
			s=fc.getSection(secId)
			for itr in range(s.NProc):
			    pId=secId+'.'+repr(itr+1)
			    proc=fc.getProcess(pId)
			    if proc.Status!="running":
				continue
			    node=proc.Node
			    if node not in list:
				list.append(node)


		except "NotRunning":
		    if section:
			print "The section ",opt[1]," is not running"
		    else:
			print "The job ",jobId," is  not running"
		    sys.exit(1)
		except KeyError:
                    if section:
                        print "The section ",opt[1]," is not running"
                    else:
                        print "The job ",jobId," is  not running"
                    sys.exit(1)


		except socket.error:
		    print "Could not connect to bmgr"
		    sys.exit(1)
	        except:
			print "Error:",sys.exc_type,sys.exc_value
			sys.exit(1)
	    elif opt[0]=="-m":
		found=0
		for key in GuiMetrics.optDict.keys():
		    if string.find(opt[1],key)>=0:
			metName=opt[1]
			found=1
			break
		    else:
			continue
		if not found:
		    print "Error: %s not a valid option" % (opt[1],)
		    print "Valid option are:%s" % (GuiMetrics.optDict.keys(),)
		    sys.exit(1)
		metName=opt[1]
		skip=3
    if not len(list):
	if not len(args):
	    try:
		for name in open (".hostname",'r').readlines():
		    list.append(name[:-1])
	    except:
		print ".hostname file doesn't exist"
		usage()
		sys.exit(1)
	else:
	    name=sys.argv[skip]
	    if len(sys.argv)==skip:
		list.append(name)
	    elif len(sys.argv)==skip+3:
		try:
		    id1=string.atoi(sys.argv[skip+1])
		    id2=string.atoi(sys.argv[skip+2])
		    for i in range(id1,id2+1):
			list.append(name+repr(i))
		except:
		    list=sys.argv[skip:]
	    else:
		list=sys.argv[skip:]

    if domName:
        tmp=[]
        for node in list:
	    idx=string.find(node,domName)
	    if idx >0:
		tmp.append(node[:idx])
	    else:
		tmp.append(node)
        list=tmp
  
    try:
	GuiMetrics.createDict(metName)
    except socket.error:
	tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
    except:
	tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))
			      
    HostMonitor(list,metName,5,100,3,2,'no',5)










