#@(#)$Id: GuiMetrics.py,v 1.7 2001/06/11 22:09:18 tlevshin Exp $
#@(#)$Author: tlevshin $
#@(#)$Log: GuiMetrics.py,v $
#@(#)Revision 1.7  2001/06/11 22:09:18  tlevshin
#@(#)fixed append((tup1,tup2..)) in order to work in python2.1
#@(#)fixed history option
#@(#)
#@(#)Revision 1.6  2000/12/18 21:47:43  tlevshin
#@(#)fix available
#@(#)
#@(#)Revision 1.5  2000/11/16 14:46:21  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.4  2000/11/16 05:59:21  tlevshin
#@(#)shows "not availbale" if rstatd is not running
#@(#)
#@(#)Revision 1.3  2000/11/15 21:01:29  tlevshin
#@(#)bug fixes for graph monitoring
#@(#)
#@(#)Revision 1.2  2000/11/10 23:01:02  tlevshin
#@(#)implemented new graphics for resources
#@(#)


import Stats
import string
import FBS_API
import socket


optDict={'Rstat':[],"LclRsrcUsageNodeClass":[],'LclRsrcPerNode':[],\
	 'GlblRsrcUsageProcType':[],'LclRsrcUsagePerNode':[],\
	 "LclRsrcUsagePerNodeNC":[],"LclRsrcUsageProcType":[],\
	 "LclRsrcUsageForType":[],'RsrcPerType':[],\
	 'GlblRsrcUsage':[],'GlblRsrcUsageForType':[],\
	 'AllRsrcProcType':[]}
fc=None


#Function to create option dictionary and maximum value
def createDict(name):
    if name!="Rstat":
	cntToClient()
    ind=string.find(name,'.')
    if ind >0:
	return eval("create%s('%s')" % (name[:ind],name[ind+1:]))
    else:
	return eval("create%s()" % (name,))
def createRstat():
    global optDict
    optDict['Rstat']=[('CPU',100),('PAGE',1),('SWAP',1),('INTR',1),('DISK',1),\
		  ('CNTXT',1),('LOAD',1),('TPKTS',1),('IPKTS',1),('OPKTS',1),\
		  ('COLLS',1),('ERRS',1)]
def  createGlblRsrcUsageProcType():
    global optDict
    llst=fc.getGlobalRsrcList()
    for rn in llst:
	tup=(rn,fc.getGblRsrcUsage(rn)[1])
	optDict['GlblRsrcUsageProcType'].append(tup)

def createAllRsrcProcType(name):
    global optDict
    optDict['AllRsrcProcType'+"."+name]=[('%s Resources' %(name,),None)]




def  createLclRsrcUsageProcType():
    global optDict
    llst=fc.getLocalRsrcList()
    plist=fc.getProcessTypeList()
    nclist=fc.getNodeClassList()
    for rn in llst:
	max=0
	for ncn in nclist:
	    nc=fc.getNodeClass(ncn)
	    if nc.ResourceCap.has_key(rn):
		
		cap=nc.ResourceCap[rn]
		if cap:
		    cap=cap*len(fc.getNodeList(ncn))
		    if cap > max:
			max=cap
			    
			
	if not max:
	    max=1
	tup=(rn,max)
	optDict['LclRsrcUsageProcType'].append(tup)


def createLclRsrcUsageNodeClass():
    global optDict
    llst=fc.getLocalRsrcList()
    nlst=fc.getNodeClassList()
    for rn in llst:
	max=0
	for nc in  nlst:
	    nclass=fc.getNodeClass(nc)
	    if nclass.ResourceCap.has_key(rn):
		cap=nclass.ResourceCap[rn]
		if cap:
		    sum=nclass.ResourceCap[rn]*len(fc.getNodeList(nc))
		else:
		    sum=0
		if max<sum:
		    max=sum
	if max==0:
	    max=1
	optDict['LclRsrcUsageNodeClass'].append((rn,max))

def createLclRsrcUsagePerNode():
    global optDict
    llst=fc.getLocalRsrcList()
    nlst=fc.getNodeClassList()
    for rn in llst:
	max=0
	for nc in  nlst:
	    nclass=fc.getNodeClass(nc)
	    if nclass.ResourceCap.has_key(rn):
		if max<nclass.ResourceCap[rn]:
		    max=nclass.ResourceCap[rn]
	if not max:
	    max=1
	optDict['LclRsrcUsagePerNode'].append((rn,max))
def createLclRsrcUsagePerNodeNC(name):
    global optDict
    llist=fc.getLocalRsrcList()
    nclist=fc.getNodeClassList()
    optDict['LclRsrcUsagePerNodeNC'+"."+name]=[]
    for rn in llist:
	max=0
	for ncn in nclist:
	    nc=fc.getNodeClass(ncn)
	    if nc.ResourceCap.has_key(rn):
		cap=nc.ResourceCap[rn]
		if cap >max:
		    max=cap
	if not max:
	    max=1
	optDict['LclRsrcUsagePerNodeNC'+"."+name].append(('%s %s' %(name,rn),max))


def createGlblRsrcUsage():
    global optDict
    optDict['GlblRsrcUsage']=[('Global Resources',None)]


def createGlblRsrcUsageForType():
    global optDict
    ptList=fc.getProcessTypeList()
    for name in ptList:
	optDict['GlblRsrcUsageForType'].append((name,None))



def createLclRsrcPerNode():
     global optDict
     llst=fc.getLocalRsrcList()
     for rn in llst:
	 tup=(rn,fc.getLclRsrcUsage(rn)[1])
	 if not tup[1]:
	     tup=(rn,100)
	 optDict['LclRsrcPerNode'].append(tup)

def createGlobalRsrc():
    global optDict
    llst=fc.getGlobalRsrcList()
    for rn in llst:
	tup=(rn,fc.getGblRsrcUsage(rn)[1])
	optDict['GlobalRsrc'].append(tup)

def createRsrcPerType():
    global optDict
    lst=fc.getGlobalRsrcList()+fc.getGlobalPoolList()+fc.getLocalRsrcList()+\
	 fc.getLocalPoolList()
  
    for rn in lst:
	try:
	    tup=(rn,fc.getLclRsrcUsage(rn)[1])
	except:
	    tup=(rn,fc.getGblRsrcUsage(rn)[1])
	    
	if not tup[1]:
	     tup=(rn,1)
	optDict['RsrcPerType'].append(tup)

def getOpt(name):
    return _getItem(0,name)
def getMaxVal(name):
    return _getItem(1,name)
def _getItem(i,name):
    list=optDict[name]
    l=[]
    for tup in list:
	l.append(tup[i])
    return l

def cntToClient():
    global fc
    fc=FBS_API.FBSClient()
    fc.setTimeOut(5)

#******************************************************    
class Metrics:
    def __init__(self,name,update):
	self.name=name
	self.update=update
	self.max=None
	self.maxval=None
	self.stat=[]
	self.status=1
    def getStat(self):
	pass
    
class Resource(Metrics):
    def __init__(self,name,update=20):
	Metrics.__init__(self,name,update)
	self.fc=fc
	if not self.fc:
	    self.status=1
	else:
	    self.status=0
    def reconnect(self):
	cntToClient()
	self.fc=fc

	if not self.fc:
            self.status=1
        else:
            self.status=0

    def getStat(self):
	pass

class RsrcPerType(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
           try:
                pt = fc.getProcessType(self.name)
                lst=fc.getGlobalRsrcList()+fc.getGlobalPoolList()+\
                     fc.getLocalRsrcList()+\
                     fc.getLocalPoolList()
                for rn in lst:
		    if pt.RsrcUsage.has_key(rn):
                        self.stat.append(pt.RsrcUsage[rn])
                    else:
			self.stat.append(0)
	   except:
		self.status=1
	return



class GlobalRsrc(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		lst=fc.getGlobalPoolList()+	fc.getLocalPoolList()
		for rn in lst:
		    try:
			self.stat.append(fc.getLclRsrcUsage(rn)[0])
		    except KeyError:
			self.stat.append(0)
	    except:
		self.status=1
	return






class GlblRsrcUsageForType(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
	self.max=fc.getGblRsrcUsage(self.name)[1]
	if not self.max:
	    self.max=1

    def getStat(self):
	self.stat=[]
	if not self.status:
	    ptList=fc.getProcessTypeList()
	    for name in ptList:
		pt=fc.getProcessType(name)
		if pt.RsrcUsage.has_key(self.name):
		    use=pt.RsrcUsage[self.name]
		else:
		    use=0
		self.stat.append(use)
	return




class LclRsrcPerNode(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		llst=self.fc.getLocalRsrcList()
		for rn in llst:
		    try:
			self.stat.append(self.fc.getLclRsrcUsage(rn,self.name)[0])
		    except KeyError:
			self.stat.append(0)
	    except:
		self.status=1
	return




class GlblRsrcUsage(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
	self.max=fc.getGblRsrcUsage(self.name)[1]
	if not self.max:
	    self.max=1
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
	        use=fc.getGblRsrcUsage(self.name)[0]
		self.stat.append(use)
	    except socket.error:
		self.status=1
	    except:
		self.stat.append(0)
	return

class GlblRsrcUsageProcType(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		gList=fc.getGlobalRsrcList()
		pt=fc.getProcessType(self.name)
		for rn in gList:
		    if pt.RsrcUsage.has_key(rn):
			use=pt.RsrcUsage[rn]
		    else:
			use=0
		    self.stat.append(use)
	    except:
		self.status=1
	return

class LclRsrcUsageNodeClass(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		llist=fc.getLocalRsrcList()
		ncl=fc.getNodeList(self.name)
		for rn in llist:
		    use=0
		    for node in ncl:
			ni=fc.getNode(node)
			if ni.Resources.has_key(rn):
			    use=use+ni.Resources[rn][0]
			else:
			    use=use+0
		    self.stat.append(use)
	    except:
		self.status=1
	return
class LclRsrcUsagePerNode(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		llist=fc.getLocalRsrcList()
		ni=fc.getNode(self.name)
		for rn in llist:
		    if ni.Resources.has_key(rn):
			use=ni.Resources[rn][0]
		    else:
			use=0
		    self.stat.append(use)
	    except:
		self.status=1
	return
class LclRsrcUsagePerNodeNC(LclRsrcUsagePerNode):
    def __init__(self,name,update=20,spec=None):
	LclRsrcUsagePerNode.__init__(self,name,update)
class LclRsrcUsageProcType(Resource):
    def __init__(self,name,update=20):
	Resource.__init__(self,name,update)
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		llst=fc.getLocalRsrcList()
		pt=fc.getProcessType(self.name)
		for rn in llst:
		    if pt.RsrcUsage.has_key(rn):
			use= pt.RsrcUsage[rn]
		    else:
			use= 0
		    self.stat.append(use)
	    except:
		self.status=1
	return    
class AllRsrcProcType(Resource):
    def __init__(self,name,update=20,spec=None):
	Resource.__init__(self,name,update)
	self.ptn=spec
	max=0
	try:
	    max=self.fc.getGblRsrcUsage(self.name)[1]
	except:
	    for ncn in fc.getNodeClassList():
		nc=fc.getNodeClass(ncn)
		if nc.ResourceCap.has_key(self.name):
		    cap=nc.ResourceCap[self.name]
		    if cap:
			cap=cap*len(fc.getNodeList(ncn))
		    if cap > max:
			max=cap		    
	if not max:
	    max=1
	self.max=max
	
    def getStat(self):
	self.stat=[]
	if not self.status:
	    try:
		pt=fc.getProcessType(self.ptn)
		if pt.RsrcUsage.has_key(self.name):
		    use=pt.RsrcUsage[self.name]
		else:
		    use=0
		self.stat.append(use)
	    except:
		self.status=1
	return    
class Rstat(Metrics):
    def __init__(self,name,update=20):
	Metrics.__init__(self,name,update)
	self.reconnect()
    def reconnect(self):
	import sys
	self.status=Stats.connect(self.name)
	self.getStat()
    def getStat(self):
	if self.status:
	    stat="0 0 0 0 0 0 0 0 0 0 0 0"
	else:
	    try:
	    	stat=Stats.getStat(self.name,self.update)
	    except:
		self.status=2
		stat=None
	if stat==None:
	    stat="0 0 0 0 0 0 0 0 0 0 0 0"
	self.stat=string.split(stat)
