#@(#)$Id: GuiJobs.py,v 1.47 2001/12/06 16:31:14 tlevshin Exp $
#@(#)$Author: tlevshin $
#@(#)$Log: GuiJobs.py,v $
#@(#)Revision 1.47  2001/12/06 16:31:14  tlevshin
#@(#)added MaxNodeCount, CPU and Real Time Limit for Process Type
#@(#)
#@(#)Revision 1.46  2001/09/13 17:26:38  tlevshin
#@(#)fixed "all" preference for Job
#@(#)
#@(#)Revision 1.45  2001/06/11 22:09:18  tlevshin
#@(#)fixed append((tup1,tup2..)) in order to work in python2.1
#@(#)fixed history option
#@(#)
#@(#)Revision 1.44  2001/03/18 20:22:56  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.43  2001/03/18 19:58:47  tlevshin
#@(#)add authorized users, allow/disallow nodes to process type and queue
#@(#)
#@(#)Revision 1.42  2000/11/16 14:43:21  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.41  2000/11/15 21:01:28  tlevshin
#@(#)bug fixes for graph monitoring
#@(#)
#@(#)Revision 1.40  2000/11/10 23:01:02  tlevshin
#@(#)implemented new graphics for resources
#@(#)
#@(#)Revision 1.39  2000/11/01 22:40:02  tlevshin
#@(#)add monitor for resources, thread in GuiRstat
#@(#)
#@(#)Revision 1.38  2000/10/25 21:17:45  tlevshin
#@(#)added removing resources to GuiAdmin
#@(#)implemented frozen screen and refresh button
#@(#)
#@(#)Revision 1.37  2000/10/03 16:44:05  tlevshin
#@(#)fixed sequence display in history
#@(#)
#@(#)Revision 1.36  2000/10/02 16:29:33  tlevshin
#@(#) added global resources and used resources for ProcType Resource display
#@(#)
#@(#)Revision 1.35  2000/09/21 23:28:36  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.34  2000/09/14 22:09:51  tlevshin
#@(#)added Lock,Unlock for Queue and put everything under actions.
#@(#)
#@(#)Revision 1.33  2000/08/21 14:58:38  tlevshin
#@(#)added resource pool
#@(#)
#@(#)Revision 1.32  2000/07/05 14:26:47  tlevshin
#@(#)fixed env for gui help display
#@(#)
#@(#)Revision 1.31  2000/06/15 18:35:20  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.30  2000/06/15 16:27:53  tlevshin
#@(#)fixed resource usage
#@(#)
#@(#)Revision 1.29  2000/06/12 17:48:54  tlevshin
#@(#)implement message (#17862)
#@(#)
#@(#)Revision 1.28  2000/06/12 16:38:11  tlevshin
#@(#)fixed bugs #56724 and #75391
#@(#)
#@(#)Revision 1.27  2000/06/05 15:51:32  tlevshin
#@(#)replace FBSError to socket.error
#@(#)
#@(#)Revision 1.26  2000/05/22 16:54:30  tlevshin
#@(#)fixed KeyError for resourceType
#@(#)
#@(#)Revision 1.25  2000/05/22 15:29:46  tlevshin
#@(#)formated log output
#@(#)
#@(#)Revision 1.24  2000/05/22 15:07:00  tlevshin
#@(#)changed history and logfile
#@(#)
#@(#)Revision 1.23  2000/05/05 21:56:35  tlevshin
#@(#)added dependecy to details; fixed endTime
#@(#)
#@(#)Revision 1.22  2000/05/03 18:59:26  tlevshin
#@(#)bug fixes
#@(#)
#@(#)Revision 1.21  2000/04/28 17:02:59  tlevshin
#@(#)added some exception checking
#@(#)
#@(#)Revision 1.20  2000/04/28 15:12:12  tlevshin
#@(#)add JDFSeq to history
#@(#)
#@(#)Revision 1.19  2000/04/27 23:11:37  tlevshin
#@(#)implemented JDFSeq ordering
#@(#)
#@(#)Revision 1.18  2000/04/27 19:03:28  tlevshin
#@(#)read from history file directly
#@(#)
#@(#)Revision 1.17  2000/04/27 16:23:12  tlevshin
#@(#)added new function "analyzeReply"
#@(#)
#@(#)Revision 1.16  2000/04/27 15:25:25  tlevshin
#@(#)fixed hostlist for rstatd monitoring
#@(#)
#@(#)Revision 1.15  2000/04/26 22:44:27  tlevshin
#@(#)fixed import
#@(#)
#@(#)Revision 1.14  2000/04/26 20:16:37  tlevshin
#@(#)implemented history display using farm_history command
#@(#)
#@(#)Revision 1.13  2000/04/26 15:08:22  tlevshin
#@(#)Changed "RsrcAvailable" to "RsrcQuota"
#@(#)
#@(#)Revision 1.12  2000/04/25 22:13:34  tlevshin
#@(#)improve statistics display
#@(#)
#@(#)Revision 1.11  2000/04/25 21:40:13  tlevshin
#@(#)added Subprocesses display in Statistics
#@(#)
#@(#)Revision 1.10  2000/04/18 17:50:40  tlevshin
#@(#)added dropped down menu
#@(#)
#@(#)Revision 1.8  2000/04/10 16:03:16  tlevshin
#@(#)added process info
#@(#)
#@(#)Revision 1.7  2000/04/10 15:18:11  tlevshin
#@(#)bug fixing for change priority
#@(#)
#@(#)Revision 1.6  2000/04/10 14:21:27  tlevshin
#@(#)add Change Priority for Section
#@(#)
#@(#)Revision 1.5  2000/04/03 19:11:41  tlevshin
#@(#)bug fixing
#@(#)
#@(#)Revision 1.4  2000/03/24 22:27:34  tlevshin
#@(#)*** empty log message ***
#@(#)
#@(#)Revision 1.2  2000/03/24 20:29:15  tlevshin
#@(#)added Hold , release for Jobs, Sections and Queues
#@(#)
#@(#)Revision 1.1  2000/03/22 21:54:15  tlevshin
#@(#)modified Gui version using new Api
#@(#)
#***********************************************
#*   Farms Batch Gui                            *
#*   Job History Class                          *
#*   Job Status Class                           *
#***********************************************    
from GuiBase import *
#from FBSQueueInfo import FBSQueueInfo
#from FBSSectionInfo import FBSSectionInfo
from FBS_API import FBSClient, FBSError
import pwd
import time
import cvtime
import fbs_misc
RUN=0
PEND=1
FINISHED=2
TRUE=1
FALSE=0

#************************************************
# print out user processes and cpu utilization  #
# on worker node as a tree                      #
# Author : Jim Fromm                            #
# Modified by IM                                #
#************************************************
def print_tree(tree, indent = ''):
    info_tree=[]
    if tree == None:
	return info_tree
    cmd = ''
    for w in tree.Command:
        cmd = cmd + ('%s' % w)

    printline = '%-10s %-10s %-10s %s %s' % (tree.UPID,tree.CPUTime,tree.ACPUTime,indent,cmd)

    info_tree.append(printline)
    
    for child in tree.Subprocesses:
        info_tree = info_tree + print_tree(child,indent + '  ')
    return info_tree




#****************************************
class ButtonHist(ButtonBase):
    def __init__(self,frame,top,name,status=RUN):
	ButtonBase.__init__(self,frame,name)
	self.top=top
	self.status=status

    def action(self):
	self.top.history(self.status)
#****************************************

#****************************************
class ButtonLog(ButtonBase):
    def __init__(self,frame,top,name,status=RUN):
	ButtonBase.__init__(self,frame,name)
	self.top=top
	self.status=status

    def action(self):
	self.top.logfile(self.status)
#****************************************

#****************************************
class ButtonUpdate(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.top=top

    def action(self):
	self.top.updateStat()
#****************************************
class ButtonStat(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.top=top

    def action(self):
	self.top.stat()
#****************************************

#****************************************
class ButtonDisp(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.top=top

    def action(self):
	self.top.detail()
#****************************************

#****************************************
class ButtonAction(ButtonBase):
    def __init__(self,frame,top,name):
	ButtonBase.__init__(self,frame,name)
	self.top=top
	self.act=string.upper(name)
    def action(self):
	self.top.doAction(self.act)
#******************************************************************
class Resources(Screen):
    def __init__(self,master,fc,pref,type):
	self.fc=fc
	self.master=master
	self.pref=pref
	self.type=type
	self.Monitor=Monitor()
	self.title=type+" RESOURCES"
	self.rsrcGraphDict={'GLOBAL':[("Usage on Farm","GlblRsrcUsage",\
				       'Selected'),\
				      ("Usage per Process Type",\
				       'GlblRsrcUsageProcType','ProcessType'),\
				      ("Usage for Process Type",\
				       'GlblRsrcUsageForType',\
				       'Selected')],\
			    'LOCAL':[("Usage per NodeClass","LclRsrcUsageNodeClass",\
				      "NodeClass"),\
				     ("Usage per Node",'LclRsrcUsagePerNode','Node'),\
				     ("Usage per Node for NodeClass",\
				      "LclRsrcUsagePerNodeNC",'Node'),\
				     ("Usage per Process Type",\
				      "LclRsrcUsageProcType",'ProcessType')],\
			    'ProcType':[("Resource Usage per Type",'RsrcPerType',\
					 'Selected'),\
					("Resource Usage for Type",'AllRsrcProcType',\
					 'Selected')]}
	Screen.__init__(self,master,self.title,None,None,'bottom',pref)
    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	if self.type!="POOL":
	    b=MenubuttonBase(f1,'Monitor')
	    for key,list in self.rsrcGraphDict.items():
		if key==self.type:
		    for tup in list:
			name=tup[0]
			b.menu.add_command(label=name,command=(lambda self=self,\
							       x=name:\
							       self.startMonitor(x)))
	    if self.type=='ProcType':
		ButtonDisp(f1,self,'Details')
	    ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonQuit(f1,self,'Quit')
    def startMonitor(self,name):
	for key,list in self.rsrcGraphDict.items():
	    if key!=self.type:
		continue
	    for tup in list:
		if name==tup[0]:
		    if tup[1]=="LclRsrcUsagePerNodeNC":
			for nc in self.fc.getNodeClassList():
			    list=self.fc.getNodeList(nc)
			    if len(list):
				self.Monitor.startChild(list,tup[1]+"."+nc)
		    elif tup[1]=='AllRsrcProcType':
			list=eval("self.get%sList()" % (tup[2],))
			for pt in list: 
			    ll=self.fc.getLocalRsrcList()+self.fc.getGlobalRsrcList()
			    self.Monitor.startChild(ll,tup[1]+"."+pt)
		    else:
			if tup[2]=="Selected":
			    list=eval("self.get%sList()" % (tup[2],))
			else:
			    list=eval("self.fc.get%sList()" % (tup[2],))
			self.Monitor.startChild(list,tup[1])
		    break
    def getSelectedList(self):
	repList=[]
	if self.list.reply==None:
	    tkMessageBox.showinfo('Not selected'+getCluster(),"You did not select the line")
	else:
	    
	    for reply in self.list.reply:
		first=string.splitfields(string.strip(reply))[0]
		if first in repList:
		    continue
		repList.append(first)
	return repList

    def get_info(self):
	self.Monitor.checkChild()
	info=[]
	if self.type=="GLOBAL":
	    try:
		idL=self.fc.getGlobalRsrcList()
		poolL=self.fc.getGlobalPoolList()
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []
	    label=("Name","Capacity","Used","Pool")
	    for id in idL+poolL:
		try:
		    used,cap=self.fc.getGblRsrcUsage(id)
		    if id in poolL:
			pool=repr(self.fc.getResourcePool(id))
		    else:
			pool="-"
		except KeyError:
		    continue
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		    return []
		s=(id,repr(cap),repr(used),pool)
		info.append(s)
	elif self.type=="LOCAL":
	    label=("Name","Capacity","Used","Pool")
	    try:
		idL=self.fc.getLocalRsrcList()
		poolL=self.fc.getLocalPoolList()
	
		for id in  idL+poolL:
		     used,cap = self.fc.getLclRsrcUsage(id)
		     if id in poolL:
			 pool=repr(self.fc.getResourcePool(id))
		     else:
			 pool="-"
		     if cap==None:
			 s=(id,"attr",repr(used),pool)
		     else:
			 s=(id,repr(cap),repr(used),pool) 
			    
		     info.append(s)

	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []
	   
	    
		
	elif self.type=="ProcType":
	    try:
		idL=self.fc.getProcessTypeList()
		rpL=self.fc.getGlobalPoolList()+self.fc.getLocalPoolList()
	    except socket.error: 
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []	
	    label=("Type","RsrcName","ProcDefault","SectDefault","Quota","Used")
	    for id in idL:
		try:
		    procInfo=self.fc.getProcessType(id)
		    
		except socket.error: 
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		    return []
		rdl=procInfo.ProcRsrcDefaults.keys()+\
		     procInfo.SectRsrcDefaults.keys()
		for key in rdl:
		    try:
			quota=repr(procInfo.RsrcQuota[key])
		    except KeyError:
			quota='-'
		    except socket.error: 
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []
		    try:
			procDefault=repr(procInfo.ProcRsrcDefaults[key])
		    except KeyError:
			procDefault='-'
		    except socket.error: 
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []
		    try:
			sectDefault=repr(procInfo.SectRsrcDefaults[key])
		    except KeyError:
			sectDefault='-'
		    except socket.error: 
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []
		    try:
			usage=repr(procInfo.RsrcUsage[key])
		    except KeyError:
			usage='-'
		    except socket.error: 
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []
		    if key in rpL:
			try:
			    pool=self.fc.getResourcePool(key)
			except socket.error: 
			    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			    return []    
			name=key+repr(pool)
		    else:
			name=key
		    info.append((id,name,procDefault,sectDefault,quota,usage))
		for rn,ru  in procInfo.RsrcUsage.items():
		    if rn not in rdl:
			info.append((id,rn,'-','-','-',repr(ru)))
	elif self.type=="POOL":
	    label=("Pool_Name","Type","Resource_List")
	    try:
		localList=self.fc.getLocalPoolList()
		for pool in localList:
		    rsrcList=self.fc.getResourcePool(pool)
		    info.append((pool,"local",rsrcList))
		globalList=self.fc.getGlobalPoolList()
		for pool in globalList:
		    rsrcList=self.fc.getResourcePool(pool)
		    info.append((pool,"global",rsrcList))
	    except socket.error: 
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []	
	self.info,self.label=infoFormat(info,label)
	self.info.sort()
    def detail(self):
	if self.list.reply==None:
	    tkMessageBox.showinfo('Not selected'+getCluster(),"You did not select the line")
	    return	
	for reply in self.list.reply:
	    pt=string.split(reply)[0]
	    info=[]
	    try:
		p=self.fc.getProcessType(pt)
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return
	    info=[]
	    lbl=['Authorized Users:','Nodes allowed for submission:','Nodes disallowed for submission:','Process CPU time limit:','Process Real time limit:','Node count (current/max):']
	    if p.CPUTimeLimit==-1:
		cpuLim="(no limit)"
	    else:
		cpuLim=repr(p.CPUTimeLimit)
	    if p.RealTimeLimit==-1:
		realLim="(no limit)"
	    else:
		realLim=repr(p.RealTimeLimit)
	    cl=[p.Users,p.NodesAllow,p.NodesDisallow,cpuLim,realLim,"%s/%s" % (p.CurrentNodeCount,p.MaxNodeCount)]
	    for i in range(0,len(lbl)):
		if type(cl[i])!=type([]):
		    info.append('%s %s' % (lbl[i],cl[i]))
		elif not len(cl[i]):
		    info.append('%s -' % (lbl[i],))
		elif len(cl[i])==1:
			 info.append('%s %s' % (lbl[i],cl[i][0]))
		else:
		    info.append('%s' % (lbl[i],))
		    for n in cl[i]:
			info.append('%15s%s' % (' ',n))
	    
	    DisplayTmp("",info,"Process Type "+pt ,self.top,self.pref)
    def destroy(self):
	self.destroyAll()
    def destroyAll(self):
	self.Monitor.killChild()
	self.updt=1
	self.top.destroy()
#******************************************************************
class Help(Screen):
    def __init__(self,master,pref):
	self.dir=os.environ["FBSNG_DIR"]+"/man/cat1/"
	Screen.__init__(self,master,"HELP",None,None,'bottom',pref)

    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	ButtonDisp(f1,self,'Display')
	ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonQuit(f1,self.top,'Quit')

    def get_info(self):
	line=open(self.dir+'index','r').readlines()
	self.label="            Index              "
	self.info=[]
	for text in line:
		self.info.append(text[:-1])

    def detail(self):
	info=[]
	if self.list.reply==None:
	    tkMessageBox.showinfo('Not selected'+getCluster(),"You did not select the line")
	    return
	for reply in self.list.reply:
	    helpid=string.strip(reply)
	    try:
		open(self.dir+helpid+'.1')
	    except:
		tkMessageBox.showinfo('Not ready'+getCluster(),\
				      "Sorry, man pages are not ready for "+helpid)
		return
	    cmd='xterm -T  '+helpid+' -fn '+repr(self.pref.font)+' -e less '+self.dir+helpid+'.1'
	    os.system(cmd)

#******************************************************************

#******************************************************************
class Queues(Screen):
    def __init__(self,master,fc,pref):
	self.fc=fc
	Screen.__init__(self,master,"QUEUES LIST",None,None,'bottom',pref)

    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	ButtonDisp(f1,self,'Details')
	ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonQuit(f1,self.top,'Quit')
    def get_info(self):
	try:
	    self.qL=self.fc.getQueueList()
	except:
	    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
	    return []
	info=[]
	for name in self.qL:
	    try:
		queue=self.fc.getQueue(name)
	    except KeyError:
		continue
	    except socket.error:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return []
	    except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))
		    return [] 
	    prio=queue.Prio
	    status="Active"
	    if queue.IsHeld:
		status="Held"
	    if queue.IsLocked == 1:
		status = status + ":Locked"

	    procType=queue.DefProcType
	    njob=len(queue.Sections)
	    nrun=0
	    for id in queue.Sections:
		try:
		    sec=self.fc.getSection(id)
		except KeyError:
		    continue
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))
		    return []
		if sec.State=="running":
		    nrun=nrun+1
		if sec.State=="done":
		    njob=njob-1
	    npend=njob-nrun
	    s=(name,repr(prio),status,procType,repr(njob),repr(nrun),repr(npend))
	    info.append(s)
		
	label=("Name","Prio","Status","DefProcType","NSEC","NRUN","NPEND")
	self.info,self.label=infoFormat(info,label)
	self.info.sort()
	
    def detail(self):
	if self.list.reply==None:
	    tkMessageBox.showinfo('Not selected'+getCluster(),"You did not select the line")
	    return	
	for reply in self.list.reply:
	    qid=string.split(reply)[0]
	    info=[]
	    try:
		q=self.fc.getQueue(qid)
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		return
	    ptStr=""
	    if q.ProcTypes[0]=="*":
		ptStr="*"
	    else:
		ptStr="%s" % (q.ProcTypes[0],)
	    if ptStr!="*":
		for pt in q.ProcTypes[1:]:
		    if pt=='*': 
			ptStr=pt
			break
		    else:
			ptStr="%s,%s" %(ptStr,pt)
	    info.append('Acceptable Process Type: %s' % (ptStr))
	    usrStr=""
	    if q.Users[0]=="*":
		usrStr="*"
	    else:
		usrStr="%s" % (q.Users[0],)
	    if usrStr!="8":
		for u in q.Users[1:]:
		    if u=='*': 
			u="*"
			break
		    else:
			usrStr="%s,%s" % (usrStr,u)
	    info.append('Authorized Users: %s' % (usrStr))	    
	    info.append('Queue Priority = %d' % q.Prio)
	    info.append("Section Priority: Min=%d Max %d Increment=%d Decrement=%d" % \
			(q.MinSPrio, q.MaxSPrio, q.SPInc, q.SPDec))
	    info.append("Section in this queue:")
	    tmp_l=('Name','State','Type','#Proc','Priority','Inx')
	    tmp_in=[]
	    for sid in q.Sections:
		try:
		    s = self.fc.getSection(sid)
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return
		tmp_in.append((sid, s.State, s.ProcType, repr(s.NProc), repr(s.Prio), repr(s.QIndex)))
	    tmp_in,tmp_l=infoFormat(tmp_in,tmp_l)
	    info.append(tmp_l)
	    info=info+tmp_in
	    DisplayTmp("",info,"Queue "+qid ,self.top,self.pref)
 

	
#******************************************************************

#************************************************************
class Job(Screen):
    def __init__(self,master,title,action,span,message,fc,pref):
	self.user=os.getuid()
	self.action=action
	self.span=span
	self.message=message
	self.noinfo=0
	self.fc=fc
	self.labelT=("JOB_ID","SECTION_NAME","USER","QUEUE","STATUS","START","FINISHED")
	Screen.__init__(self,master,title,None,None,'bottom',pref)

    def get_info(self):
	user=self.getUser()
	self.info=[]
	info=[]
	tmp_info=self.getInfo(user,self.action)
	if len(tmp_info)==0:
	    self.info.append(self.message)
	    self.noinfo=1
	    return
	self.noinfo=0
	for line in tmp_info:
	    l=string.split(line)
	    del l[1]
	    if len(l)>2:
		info.append((l[0],l[1],l[2],l[3],l[4],l[5],l[6]))
	    else:
		info.append((l[0],l[1],"","","","",""))
	self.info,self.label=infoFormat(info,self.labelT)

    def menubar(self):
	pass

    def getUser(self):
	user=[]
	if self.pref==None:
	    if self.user==0:
		user=[-1]
	    else:
		user=[self.user]
	else:	
	    if self.pref.userL=='all':
		user=[-1]
	    else:	
		for uname in string.split(self.pref.userL):
		    user.append(pwd.getpwnam(uname)[2])
	return user

    def getInfo(self,user=[],status=RUN):
	#self.span for current all old info
	jobIdL=[]
	if status==FINISHED:
	    try:
		
		self.hc=HistoryClient()
		self.hc.refresh()
		for uid in user:
		    jobIdL=jobIdL+self.hc.getJobList(uid)
	    except FBSError,reason:
		tkMessageBox.showinfo('Failure'+getCluster(),reason)
		return []
	    except:
		tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		return []	
	else:
	    for uid in user:
		if uid !=-1:
		    pw=pwd.getpwuid(uid)
		    cmd="self.fc.getJobList('%s',%s,%s)" % (pw[0],uid,pw[3])
		else:
		    cmd="self.fc.getJobList()"
		try:
		    jobIdL=jobIdL+eval(cmd)
		except KeyError:
		    continue
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		    return []		
	jDict={}
	jStatus={}
	for jid in jobIdL:
	    if status==FINISHED:
		j=self.hc.getJob(jid)
	    else:
		try:
		    j=self.fc.getJob(jid)
		    sectList=j.sections()
		except KeyError:
		    continue
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		    return []		
	    if not j:
		return []
	    if status==FINISHED:
		if j.State=="done":
		    jStatus[jid]=FINISHED
	    else:
		if j.State=="done":
		    jStatus[jid]=FINISHED
		    continue
		flag=1
		for sid in sectList:
		    try:
			s=self.fc.getSection(jid+"."+sid)
		    except KeyError:
			continue

		    except socket.error:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []		
		    if s.State=="running":
			jStatus[jid]=RUN#job is running
			flag=0
			break
		if  flag:
		    jStatus[jid]=PEND #job is pending
	    if jStatus[jid]==status:
		jDict[jid]=j	

	tmpl=[]
	for key in jDict.keys():
		tmpl.append(string.atoi(key))
	tmpl.sort()
	if self.pref.numJob:
	    if len(jDict) > self.pref.numJob:
		tmpl=tmpl[(len(tmpl)-self.pref.numJob):]
	jobIdL=[]
	for item in tmpl:
		jobIdL.append(repr(item))
  	info=[]
  	for jid in jobIdL:
	    j=jDict[jid]
	    sectList=j.sections()
	    str="%s %s *job*" %(jid,repr(0))
	    info.append(strFormat(str))
	    user=pwd.getpwuid(j.UID)[0]
	    for sid in sectList:
	    	startTime="-"
	    	endTime="-"
		if status==FINISHED:
		    s=self.hc.getSection(jid+'.'+sid)
		else:
		    try:
			s=self.fc.getSection(jid+'.'+sid)
		    except KeyError:
			continue
		    except socket.error:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
			return []
		    except:
			tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			return []		
		if s.StartTime:
		    startTime=string.replace(time.ctime(s.StartTime)," ","_")
		if s.EndTime:
		    endTime=string.replace(time.ctime(s.EndTime)," ","_")
		queue=s.Queue
		l="%s %s %s %s %s %s %s %s " % (jid,repr(s.JDFSeq),\
			s.Name,user,queue,s.State,startTime,endTime)
		info.append(l)
	info.sort()
	self.jobList=jDict
	return info

    def history(self,status=RUN):
	if self.noinfo:
	    return
	secList=self._analyzeReply(status)
	for s in secList:
	    info=self.detail(s)
	    DisplayTmp(s.Name+"("+s.JobID+")",info,"Job History",self.top,self.pref)
	
    def detail(self,s):
	info=[]
	info.append("Job: %-22s  Section: %s" % (s.JobID,s.Name))
	if s.HoldTime==None:
	    hold="-"

	elif s.HoldTime==-1:
	    hold="forever"
	else:
	    hold=time.ctime(s.HoldTime)
	info.append("Submit: %-19s   Hold: %s" % \
		    (time.ctime(s.SubTime),hold))
	if s.StartTime!="-":
	    try: start=time.ctime(s.StartTime)
	    except:  start="-"
	if s.EndTime!="-":
	    try: end=time.ctime(s.EndTime)
	    except:  end="-"
	info.append("Begin: %-19s   End: %s" % \
		    (start,end))
	info.append("User: %-22s Queue: %-22s Proc Type: %s" % \
		    (pwd.getpwuid(s.UID)[0],s.Queue,s.ProcType))
	info.append("Global Resources per Section: %s" % (s.PerSectRsrc))
	info.append("Resources per Process %s" % (s.PerProcRsrc))
	info.append("Exec: %s" % (s.Exec))
	info.append("Num of Processes: %d, Need Flag: %d, Nice: %d, Priority %d" %\
		    (s.NProc,s.Need,s.Nice,s.Prio))
	info.append("Stdout: %s, Stderr: %s" % (s.Stdout,s.Stderr))
	info.append("Dependency: %s" % s.Depend)
	try:
	    repr(s.exitCode)
	except:
	    s.exitCode="-"
	    
	info.append("Exit Code: %s" % (s.exitCode))
	if s.State!='running':
	    return info
	info.append("Proc","Begin","End","Host","RunTime","CPU","State","Signal","Core","Exit");
	for i in range(1,s.NProc+1):
	    p=s.getProcess(i)
	    try:
		end=time.ctime(p.EndTime)
	    except:
		end='-'
	    try:
		run=repr(p.EndTime-p.StartTime)
	    except:
		run='-'
	    info.append((i,time.ctime(p.StartTime),end,p.Node,\
			 run,repr(p.CPUTime),p.Status,repr(p.Signal),repr(p.Core),repr(p.ExitCode)))
	return info
    def logfile(self,status=RUN):
	if self.noinfo:
	    return
	secList=self._analyzeReply(status)
	for s in secList:
	    info=[]
	    if s.State!="waiting":
		try:
		    l=self.fc.getSectionOutput(s.JobID+'.'+s.Name)
		except KeyError:
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Logfile for "+s.Name+"("+s.JobID+")"+\
					  " is already deleted from archive")
		    continue
		except socket.error:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")
		    return []
		except:
		    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
		    return []
		if not len(l):
		    return []
		ll=string.splitfields(l[0][1],'\n')
		info.append(time.ctime(l[0][0])+" "+ll[0] )
		for jdfRec in ll[1:]:
		    info.append(jdfRec)
		for line in l[1:]:
		    info.append(time.ctime(line[0])+" "+line[1])
		DisplayTmp(s.Name+"("+s.JobID+")",info,"JM Log",self.top,self.pref)
 
    def kill(self):
	self.doAction("KILL");
    def hardKill(self):
	self.doAction("HARDKILL");
    def hold(self):
	self.doAction("HOLD");
    def release(self):
	self.doAction("RELEASE");
    def changePriority(self):
	self.doAction("CHANGEPRIORITY");		

    def doAction(self,action="KILL"):
	if self.noinfo:
	    return
	jobL=[]
	id_string=""
	for reply in self.list.reply:
	    id=string.split(reply)[0]
	    name=string.split(reply)[1]
	    if id not in jobL:
		jobL.append(id)
	    if name=="*job*":
		id_string=id_string+id+', '
		type='job'
	    else:
		id_string=id_string+name+"."+id+', '
		type='section'
	if action in ['KILL','HARDKILL']:
	    if not tkMessageBox.askokcancel(string.capitalize(action)+\
					    " "+type+getCluster(),\
					    "Do you really want to %s these %ss:%s" % \
					    (string.lower(action),type,id_string[:-2])):
		return
	secList=self._analyzeReply()
	
	for s in secList:
	    info=[]
	    retVal=1
	    if action=="KILL":
		if s.State in ['done','canceled','exited']:
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Could not %s section %s  of job %s: job is in %s state" %\
					  (string.lower(action),s.Name,s.ID,s.State))
		else:
		    retVal,reason=self.fc.killSection(s.ID)
	    elif action=="HOLD":
		if s.State not in ['waiting','ready']:
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Could not %s section %s  of job %s: job is in %s state" %\
					  (string.lower(action),s.Name,s.ID,s.State))
		else:
		    t=HoldTime(self.frame,"Hold Time",s.ID,self.pref)
		    retVal,reason=self.fc.holdSection(s.ID,t.holdTime)
	    elif action=="RELEASE":
		if s.State not in ['waiting','ready']:
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Could not %s section %s  of job %s: job is in %s state" %\
					  (string.lower(action),s.Name,s.ID,s.State))
		else:
		    retVal,reason=self.fc.releaseSection(s.ID)
	    elif action=="HARDKILL":
		if s.State!='running':
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Could not %s section %s  of job %s: job is in %s state" %\
					  (string.lower(action),s.Name,s.ID,s.State))
		else:			    
		    retVal,reason=self.fc.killSection(s.ID,1)
	    elif action=="CHANGEPRIORITY":
		if s.State not in ['waiting','ready']:
		    tkMessageBox.showinfo('Failure'+getCluster(),\
					  "Could not %s section %s  of job %s: job is in %s state" %\
					  (string.lower(action),s.Name,s.ID,s.State))
		else:
		    max=self.fc.getProcessType(s.ProcType).MaxPrioInc,
		    p=ChangePrio(self.frame,"Change Priority",s.ID,s.PrioInc,max,self.pref)
		    retVal,reason=self.fc.incSectPrio(s.ID,p.PrioInc)
	    else:
			    return
	    if not retVal:
		tkMessageBox.showinfo('Failure'+getCluster(),\
				      "Could not %s section %s  of job %s: %s" %\
				      (string.lower(action),s.Name,s.ID,reason))



    def _analyzeReply(self,status=RUN):
	jobL=[]
	sec=[]
	for reply in self.list.reply:	
	    id=string.split(reply)[0]
	    lj=self.jobList[id]
	    sectList=lj.sections()
	    if string.split(reply)[1]!="*job*":
		sname=string.split(reply)[1]
		if id in jobL:
		    continue
		for sid in sectList:
		    if status==FINISHED:
			s=self.hc.getSection(id+'.'+sid)
		    else:
			try:
			    s=self.fc.getSection(id+'.'+sid)
			except KeyError:
			    continue
			except socket.error:
			    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")	   
			    return sec
			except:
			    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			    return sec		
		    if s.Name==sname:
			sec.append(s)
	    else:
		jobL.append(id)
		for sid in sectList:
		    if status==FINISHED:
			s=self.hc.getSection(id+'.'+sid)
		    else:
			try:
			    s=self.fc.getSection(id+'.'+sid)
			except KeyError:
			    continue
			except socket.error:
			    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Lost connection with Batch Manager")	   
			    return sec
			except:
			    tkMessageBox.showinfo('FBS_BATCH'+getCluster(),"Unexpected Error: %s, %s" % (sys.exc_type, sys.exc_value))	
			    return sec		
		    sec.append(s)
	return sec
		
#******************************************************************

#******************************************************************
class HistoryClient:
    def __init__(self):
	cfg=config.ConfigFile(os.environ['FBS_CONFIG'])
	self.hfile=cfg.getValue('history','*', 'hist_dir','.')+'/'\
		    +cfg.getValue('history','*', 'hist_file','hist.log')
	try:
	    fd=open(self.hfile)
	    fd.close()
	except:
	    pass
	    #raise FBSError,"Failed to read from history file %s" % self.hfile
    def refresh(self):
	try:
	    p=os.popen("cat %s 2>/dev/null" % (self.hfile,))
	except:
	    return
	self.jobDict={}
	self.sectionDict={}
	l = p.readline()
	while l:
	    words=string.splitfields(l,'|')
	    if words[4]=='0':
		try:
		    start=string.atof(words[0])
		except:
		    start=None
		end=string.atof(words[1])
		jid=words[2]
		sname=words[3]
		user=string.atoi(words[5])
		queue=words[7]
		state=words[21]
		seq=words[22]
		if jid not in self.jobDict.keys():
		    job=HistJobInfo(jid,user)
		    self.jobDict[jid]=job
		sid=jid+'.'+sname
		s=HistSectionInfo(sid,queue,state,start,end,seq)
		self.jobDict[jid].Sections.append(s.Name)
		self.sectionDict[sid]=s
	    l=p.readline()
	try:
	    p.close()
	except:
	    return
    def getJobList(self,uid):
	if uid==-1:
	    return self.jobDict.keys()
	jobL=[]
	for id,job in self.jobDict.items():
	    if job.UID==uid:
		jobL.append(id)
	return jobL
    def getJob(self,id):
	return self.jobDict[id]
    def getSection(self,sid):
	return self.sectionDict[sid]
    def dumpSectionInfo(self,jid,sname):
	p=os.popen("fbs history -u all -j %s -s %s" % (jid,sname))
	info=[]
	for l in p.readlines():
	    info.append(l[:-1])
	return info
 

class HistJobInfo:
    def __init__(self,jid,uid):
	self.UID=uid
	self.ID=jid
	self.State="done"
	self.Sections=[]
    def sections(self):
	return  self.Sections
class HistSectionInfo:
    def __init__(self,sid,queue,state,start,end,num):
	self.ID=sid
	self.JobID, self.Name = fbs_misc.decodeDotID(sid)
	self.State=state
	self.StartTime=start
	self.EndTime=end
	self.JDFSeq=num
	self.Queue=queue

class JobsHist(Job):
    def __init__(self,master,fc,pref):
	action=FINISHED
	message="No information is available"
	Job.__init__(self,master,"FINISHED JOBS",action,"old",message,fc,pref) 

    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	ButtonHist(f1,self,'Details',FINISHED)
	ButtonLog(f1,self,'Log',FINISHED)
	ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonQuit(f1,self.top,'Quit')
    def doAction(self):
	pass
    def detail(self,s):
	return self.hc.dumpSectionInfo(s.JobID,s.Name)
	

#*******************************************************************************

#******************************************************************************
class JobsRun(Job):
    def __init__(self,master,fc,pref):
	action=RUN
	message="No jobs are currently running"
	self.Monitor=Monitor()
	Job.__init__(self,master,"CURRENT JOBS",action,"current",message,fc,pref) 

    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	a=MenubuttonBase(f1,'Actions')
	a.menu.add_command(label="Kill",command=self.kill)
	a.menu.add_command(label="HardKill",command=self.hardKill)
	a.menu.add_command(label="Hold",command=self.hold)
	a.menu.add_command(label="Release",command=self.release)
	a.menu.add_command(label="ChangePriority",command=self.changePriority)	
	ButtonHist(f1,self,'Status',RUN)
	ButtonMonitor(f1,self,'Monitor')
	ButtonStat(f1,self,'Statistics')
	ButtonLog(f1,self,'Log',RUN)
	ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonDestroy(f1,self.top,'Quit',self.Monitor)

    def destroyAll(self):
	self.Monitor.killChild()
	self.updt=1
	self.top.destroy()
    
    def get_info(self):
	self.Monitor.checkChild()
	Job.get_info(self)
  
    
    def hostlist(self):
	if self.noinfo:
	    return
	secList=self._analyzeReply()
	for s in secList:
	    host=[]
	    if s.State!="running":
		tkMessageBox.showinfo('Failure'+getCluster(),\
				      "section %s  of job %s: is not running" %\
				      (s.Name,s.JobID))
		continue
	    for i in range(1,s.NProc+1):
		proc=s.getProcess(i)
		if proc:
		    if proc.Node in host:
			pass
		    else:
			host.append(proc.Node)
	if len(host):
	    host.sort()
	    self.Monitor.startChild(host)
#******************************Jim Fromm*****************************
    def stat(self): 
	if self.noinfo:
	    return
	secList=self._analyzeReply()
	for s in secList:
	    info=[]
	    if s.State!="running":
		tkMessageBox.showinfo('Failure'+getCluster(),\
				      "section %s  of job %s: is not running" %\
				      (s.Name,s.JobID))
		continue
			
	    for i in range(1,s.NProc+1):
		p=s.getProcess(i)
		info.append("Host: %s" %  p.Node)
		info.append("Process Number %d:" % i)
		info.append("Message: %s" % p.Message)
		info.append( '%-10s %-10s %-10s %s' % ("UNIX_ID","CPU_TIME","ACPU_TIME","COMMAND"))
		info.append( '%-10s %-10s %-10s %s' % (p.UPID,p.CPUTime,p.ACPUTime,p.Command))
		for sub in p.Subprocesses:
		    info=info+print_tree(sub,' ')
		    info.append("_______________________________________________")
	    DisplayTmp("Section "+s.ID,info,"Job Statistics",self.top,self.pref)	
#*****************************************************************************

#*****************************************************************************
class JobsPend(Job):
    def __init__(self,master,fc,pref):
	action=PEND
	message="No jobs are currently pending"
	Job.__init__(self,master,"PENDING JOBS",action,"current",message,fc,pref) 

    def menubar(self):
	f1=Frame(self.top)
	f1.pack(side=TOP,fill=X)
	a=MenubuttonBase(f1,'Actions')
	a.menu.add_command(label="Kill",command=self.kill)
	a.menu.add_command(label="Hold",command=self.hold)
	a.menu.add_command(label="Release",command=self.release)
	a.menu.add_command(label="ChangePriority",command=self.changePriority)	
	ButtonHist(f1,self,'Status',PEND)
	ButtonRefresh(f1,self,'Refresh')
	ButtonPref(f1,self,'Preference')
	ButtonPrint(f1,self,'Print')
	ButtonSave(f1,self,'Save')
	ButtonQuit(f1,self.top,'Quit')
#*****************************************************************************
class HoldTime:
    def __init__(self,master,title,name,pref):
	self.name=name
	self.title=title
	self.master=master
	self.cancel=1
	self.holdTime="forever"
	self.getTime()
    def setTime(self,holdTime):
	self.top = Toplevel(self.master)
	self.top.title(self.title+getCluster())
	self.frame=Frame(self.top)
	self.frame.pack(side='left',expand=YES,fill=BOTH)
	f0=Frame(self.top)
	f0.pack(anchor=W,expand=YES,fill=X)
	Label(f0,text='Name:',width=15,\
	      background='white',foreground='black').pack(side=LEFT)
	Label(f0,text=self.name,relief=RIDGE,width=15,\
	      background='white',foreground='red').pack(side=RIGHT,padx=2,pady=1,\
							ipadx=2,ipady=2)

	f1=Frame(self.top)
	f1.pack(anchor=E,expand=YES,fill=X)
	Label(f1,text='Hold Until (mm/dd/yyyy-HH:MM:SS or +HH:MM:SS)',background='white',foreground='black').pack\
			    (side=TOP,anchor=W)
	e1=Entry(f1,textvariable=holdTime, relief=SUNKEN,
		 background='pink',width=20)
	e1.pack(side=RIGHT,expand=YES,fill=X)

	ButtonCheck(self.top,self,0,'OK','left')
	ButtonCheck(self.top,self,1,'Cancel','right')    
	e1['textvariable']=holdTime

	self.top.grab_set()
	self.top.focus_set()
	self.top.wait_window()

    def getTime(self):
	global s1
	s1=StringVar()
	s1.set(self.holdTime)
	self.setTime(s1)
	if self.cancel:
	    if s1.get()=="forever":
		self.holdTime=-1
	    else:
		self.holdTime=cvtime.parseDateTime(s1.get())

    def check(self):
	if s1.get()=="forever":
	    return 0
	try:
	    holdTime=cvtime.parseDateTime(s1.get())
	except:
	    tkMessageBox.showwarning('Wrong Date'+getCluster(),'Please, re-enter the date')
	    return 1
	if holdTime < time.time():
	    tkMessageBox.showwarning('Wrong Date'+getCluster(),'Please, re-enter the date: '+time.ctime(holdTime))
	    return 1
	return 0

class ChangePrio:
    def __init__(self,master,title,name,prio,max,pref):
	self.name=name
	self.title=title
	self.master=master
	self.cancel=1
	self.PrioInc=0
	self.max=max
	self.getPrio()
    def setPrio(self,prio):
	self.top = Toplevel(self.master)
	self.top.title(self.title+getCluster())
	self.frame=Frame(self.top)
	self.frame.pack(side='left',expand=YES,fill=BOTH)
	f0=Frame(self.top)
	f0.pack(anchor=W,expand=YES,fill=X)
	Label(f0,text='Name:',width=15,\
	      background='white',foreground='black').pack(side=LEFT)
	Label(f0,text=self.name,relief=RIDGE,width=15,\
	      background='white',foreground='red').pack(side=RIGHT,padx=2,pady=1,\
							ipadx=2,ipady=2)
	f2=Frame(self.top)
	f2.pack(anchor=W,expand=YES,fill=X)
	Label(f2,text='Max Priority Inc:',width=20,\
	      background='white',foreground='black').pack(side=LEFT)
	Label(f2,text=repr(self.max),relief=RIDGE,width=4,\
	      background='white',foreground='red').pack(side=RIGHT,padx=2,pady=1,\
							ipadx=2,ipady=2)
	f1=Frame(self.top)
	f1.pack(anchor=W,expand=YES,fill=X)
	Label(f1,text='Change Priority (+INT or -INT):',background='white',foreground='black').pack\
			    (side=LEFT)
	e1=Entry(f1,textvariable=prio, relief=SUNKEN,
		 background='pink',width=4)
	e1.pack(side=RIGHT,expand=YES,fill=X)

	ButtonCheck(self.top,self,0,'OK','left')
	ButtonCheck(self.top,self,1,'Cancel','right')    
	e1['textvariable']=prio

	self.top.grab_set()
	self.top.focus_set()
	self.top.wait_window()

    def getPrio(self):
	global s1
	s1=StringVar()
	s1.set(self.PrioInc)
	self.setPrio(s1)
	if self.cancel:
	    self.PrioInc=string.atoi(s1.get())
    def check(self):
	try:
	    prio=string.atoi(s1.get())
	    if prio > self.max:
		tkMessageBox.showwarning('Wrong Data'+getCluster(),'Please, re-enter priority increment, should be less then %d' % self.max)
		return 1
	except:
	    tkMessageBox.showwarning('Wrong Data'+getCluster(),'Please, re-enter priority increment as an integer')
	    return 1
	return 0
