# @(#) $Id: GuiFarmsMenu.py,v 1.15 2001/12/06 16:31:13 tlevshin Exp $
# $Log: GuiFarmsMenu.py,v $
# Revision 1.15  2001/12/06 16:31:13  tlevshin
# added MaxNodeCount, CPU and Real Time Limit for Process Type
#
# Revision 1.14  2001/05/03 19:09:15  tlevshin
#  fixed bugs in admin, change GuiBase to handle None in infoFormat
#
# Revision 1.13  2001/03/18 19:58:47  tlevshin
# add authorized users, allow/disallow nodes to process type and queue
#
# Revision 1.12  2000/11/10 23:01:02  tlevshin
# implemented new graphics for resources
#
# Revision 1.11  2000/10/25 21:17:45  tlevshin
# added removing resources to GuiAdmin
# implemented frozen screen and refresh button
#
# Revision 1.10  2000/10/06 20:03:50  tlevshin
# add call to FBSClient timeout
#
# Revision 1.9  2000/10/04 14:32:18  tlevshin
# change cluster_name to farm_name in fbs.cfg
#
# Revision 1.8  2000/09/21 23:28:36  tlevshin
# *** empty log message ***
#
# Revision 1.7  2000/09/13 17:10:17  tlevshin
# modified gui according changes in api
#
# Revision 1.6  2000/09/11 17:31:58  tlevshin
# implemented setLocalDisks, fixed several bugs
#
# Revision 1.5  2000/08/31 22:29:27  tlevshin
# some changes in Admin
#
# Revision 1.4  2000/08/24 22:13:32  tlevshin
#  changes for dynamic configuration
#
# Revision 1.3  2000/08/21 14:58:38  tlevshin
# added resource pool
#
# Revision 1.2  2000/03/24 20:28:32  tlevshin
# change FARMS_ROOT to FBS_CONFIG
#
# Revision 1.1  2000/03/22 21:54:15  tlevshin
# modified Gui version using new Api
#
#***********************************************
#*   Farms Batch Gui                           *
#*   Main Screen                               *
#***********************************************                                        
from GuiBase import *
from GuiCpu import CpuConfig,CpuStatus
from GuiJobs import JobsRun,JobsPend,JobsHist,Queues,Help,Resources
from GuiAdmin import Administrator
from FBS_API import FBSClient
#****************************************
class ButtonQue(ButtonBase):
    def __init__(self,frame,name):
	ButtonBase.__init__(self,frame,name)
	self.frame=frame

    def action(self):
	Queues(self.frame,self.frame.fc,self.frame.pref)
#****************************************

#****************************************
class ButtonHelp(ButtonBase):
    def __init__(self,frame,name):
	ButtonBase.__init__(self,frame,name)
	self.frame=frame

    def action(self):
	Help(self.frame,self.frame.pref)
#****************************************

#****************************************
class ButtonExit(ButtonBase):
    def __init__(self,frame,name):
	ButtonBase.__init__(self,frame,name)
	self.frame=frame

    def action(self):
        self.frame.destroyAll()	
#****************************************

class ButtonGlobPref(ButtonBase):
    def __init__(self,frame,name):
        ButtonBase.__init__(self,frame,name)
        self.frame=frame

    def action(self):
	self.frame.pref.getPref()
#****************************************

#****************************************
#****************************************

class MainMenu(Frame):
    def __init__(self,master):
	import pwd
	if self.config():
	    sys.exit(1)
	Frame.__init__(self,master)
	self.root=master
	self.pack()
	self.winfo_toplevel().title("FARMS BATCH"+getCluster())
	self.pref=Preference(self,pwd.getpwuid(os.getuid())[0])
	self.dropmenu()
	self.root.protocol("WM_DELETE_WINDOW", self.destroyAll) # delete all the Monitor windows if
                                                                #delete window "x" button is pressed 
	self.cpuSt=[]
	self.jobRun=[]
	self.rsrc=[]
	self.admin=None

    def destroyAll(self):
	for cpu in self.cpuSt:
		cpu.destroyAll()
	for job in self.jobRun:
		job.destroyAll()
	for rsrc in self.rsrc:
	    rsrc.destroyAll()
	self.root.destroy()

    def config(self):
	import sys
	import pwd
	try:
	    config_file=os.environ['FBS_CONFIG']
	except:
	    tkMessageBox.showwarning('Not defined','Environmental variable FBS_CONFIG is'+\
		       'not set')
	    return 1
	try:
	    open(config_file,'r')
	except:
	    text="Failed to open configuration file "+config_file
	    tkMessageBox.showwarning('Open failed',text)
	    return 1
	cfg=config.ConfigFile(config_file)
	clstName=cfg[('global',1,'farm_name')]
	if clstName:
	    setCluster(clstName)
	user=pwd.getpwuid(os.getuid())[0]
	self.fc=FBSClient(whoAmI=user,cfg=config_file)
	self.fc.setTimeOut(5)
	return 0

    def dropmenu(self):
	h=MenubuttonBase(self,'HOSTS')
	h.menu.add_command(label="Configuration",command=self.cpuConfig)
	h.menu.add_command(label="Status",command=self.cpuStatus)
	j=MenubuttonBase(self,'JOBS')
	j.menu.add_command(label="History",command=self.jobHist)
	j.menu.add_command(label="Running",command=self.jobRunning)
	j.menu.add_command(label="Pending",command=self.jobPending)
	r=MenubuttonBase(self,'RESOURCES')
	r.menu.add_command(label="Global",command=self.rsrcGlobal)
	r.menu.add_command(label="Local",command=self.rsrcLocal)
	r.menu.add_command(label="Resource Pools",command=self.rsrcPool)
	r.menu.add_command(label="By Process Type",command=self.rsrcProcType)
	ButtonQue(self,'QUEUES')
	itemList=[('simple',"Check FBS Configuration",'verify'),\
		  ('separator'),\
		  ('cascade',"Configure Local Resource",\
		   (('simple',"Create Local Resource","createLocalResource"),\
		    ('simple',"Remove Local Resource","removeLocalResource"))),\
		  ('cascade',"Configure Global Resource",\
		   (('simple',"Create Global Resource","createGlobalResource"),\
		    ('simple',"Remove Global Resource","removeGlobalResource"),\
		    ('simple',"Set Global Resource",'setGlobalResource'))),\
		    ('cascade',"Configure Resource Pool",\
		     (('simple',"Create Resource Pool","createRsrcPool"),\
		      ('simple',"Remove Resource Pool","removeRsrcPool"),\
		      ('simple',"Set Resource Pool",'setRsrcPool'))),\
		    ('cascade',"Configure Node Class",\
		     (('simple',"Create Node Class",'createNodeClass'),\
		      ('simple',"Remove Node Class",'removeNodeClass'),\
		      ('simple',"Set Resources",'setRsrcCap'),\
		      ('simple',"Set Local Disks",'setLocalDisks'),\
		      ('simple',"Add Node","addNode"),\
		      ('simple',"Remove Node",'removeNode'))),\
		  ('cascade',"Configure Process Type",\
		     (('simple',"Create Process Type",'createProcessType'),\
		      ('simple',"Remove Process Type",'removeProcessType'),\
		      ('simple',"Set Section Defaults","setSectRsrcDefs"),\
		      ('simple',"Set Process Defaults",'setProcRsrcDefs'),\
		      ('simple',"Set Resource Quota",'setRsrcQuota'),\
		      ('simple',"Set Max Priority Inc",'setMaxPrioInc'),\
		      ('simple',"Set Authorized Users",'setUsers'),\
		      ('simple',"Set Allowed Nodes",'allowNodes'),\
		      ('simple',"Set Disallowed Nodes",'disallowNodes'),\
		      ('simple',"Set Max Node Count",'setMaxNodeCount'),\
		      ('simple',"Set CPU Time Limit",'setCPUTimeLimit'),\
		      ('simple',"Set Real Time Limit",'setRealTimeLimit'),)),\
		  ('cascade',"Configure Queue",\
		     (('simple',"Create Queue","createQueue"),\
		      ('simple',"Remove Queue","removeQueue"),\
		      ('simple',"Set Queue Parameters",'update'))),\
		  ('separator'),\
		  ('cascade',"Manage Queues",\
		   (('simple',"Hold Queues","holdQueue"),\
		    ('simple',"Release Queues",'releaseQueue'),\
		    ('simple',"Lock Queues",'lockQueue'),\
		    ('simple',"Unlock Queues",'unlockQueue'))),\
		  ('cascade',"Manage Nodes",\
		   (('simple',"Hold Nodes","holdNode"),\
		    ('simple',"Release Nodes",'releaseNode')))]

	a=MenubuttonCascade(self,'ADMIN',itemList)
	ButtonHelp(self,'HELP')
	ButtonGlobPref(self,'GLOBAL PREF')
	ButtonExit(self,'EXIT')
    def adminCfg(self,funcName):
	if self.admin:
	    self.admin.destroy()
	self.admin=Administrator(self.master,self.fc,funcName,self.pref)
    def rsrcGlobal(self):
	self.rsrc.append(Resources(self.master,self.fc,self.pref,"GLOBAL"))
    def rsrcLocal(self):
	self.rsrc.append(Resources(self.master,self.fc,self.pref,"LOCAL"))
    def rsrcProcType(self):
	self.rsrc.append(Resources(self.master,self.fc,self.pref,"ProcType"))
    def rsrcPool(self):
	self.rsrc.append(Resources(self.master,self.fc,self.pref,"POOL"))
    
    def cpuConfig(self):
	CpuConfig(self.master,self.fc,self.pref)

    def cpuStatus(self):
        self.cpuSt.append(CpuStatus(self.master,self.fc,self.pref))

    def jobHist(self):
	JobsHist(self,self.fc,self.pref)

    def jobRunning(self):
	self.jobRun.append(JobsRun(self,self.fc,self.pref))

    def jobPending(self):
	JobsPend(self,self.fc,self.pref)
	
    
if __name__=="__main__": 
    root=Tk()
    mainMenu=MainMenu(root)  	
    root.mainloop()
