#
# @(#) $Id: FBSSectionInfo.py,v 1.27 2001/08/23 19:05:53 ivm Exp $
#
# $Log: FBSSectionInfo.py,v $
# Revision 1.27  2001/08/23 19:05:53  ivm
# Implemented search with feedback RM algorithm
# Added -v option to status.py
# Fixed handling of time limits in FBSSectionInfo
#
# Revision 1.26  2001/03/16 17:46:58  ivm
# Fixed some bugs
# Made v1_3_2
#
# Revision 1.25  2000/11/06 17:06:54  ivm
# Added nrunning/ntotal to sections.py
#
# Revision 1.24  2000/10/31 16:29:18  ivm
# Added Username
#
# Revision 1.23  2000/10/20 19:51:00  ivm
# Added misccmodule
# Call initgroups() before setgid() setuid() in launcher
# Copy kinit stderr, stdout to process stderr, stdout
#
# Revision 1.22  2000/08/08 17:11:18  ivm
# Renamed resource pool dictionaries to RsrcPoolDict
#
# Revision 1.21  2000/08/08 14:18:56  ivm
# Implemented pool dictionaries for SectionInfo and ProcessInfo
#
# Revision 1.20  2000/06/13 16:32:40  ivm
# Check only for "waiting" in isHeld()
#
# Revision 1.18  2000/05/11 17:21:59  ivm
# Added r2shm and related code.
# Added SectOutput related code
#
# Revision 1.17  2000/04/28 14:13:49  ivm
# Removed unnecessary fields from constructor of FBSSectionInfo
#
# Revision 1.15  2000/04/11 15:21:39  ivm
# Removed history stuff
#
# Revision 1.13  2000/04/10 15:26:55  ivm
# Added FBSClient.getProcess()
#
# Revision 1.12  2000/04/03 22:12:58  ivm
# Implemented hard kill
#
# Revision 1.10  2000/03/28 20:02:18  ivm
# Modified History and implemented some history functionality in FBSClient
#
# Revision 1.9  2000/03/22 19:30:27  ivm
# Implemented hold/release job/section
#
# Revision 1.8  2000/03/17 16:24:01  ivm
# Fixed and tested DepParser
#
# Revision 1.7  2000/03/14 16:15:09  ivm
# Added sections() and getSection()
#
# Revision 1.6  2000/03/13 19:48:03  ivm
# Added section.ExitCode
#
# Revision 1.4  2000/03/07 21:04:26  ivm
# Removed print-outs
#
# Revision 1.2  2000/03/06 17:52:53  ivm
# Implemented getQueue
#
# Revision 1.1  2000/03/02 22:17:37  ivm
# Initial version, submit, get job/section, kill
#
#

import fbs_misc
import Parser
import string
import time
from FBSProcessInfo import *

class	FBSSectionInfo:
	def __init__(self, fc, sid):
		self.ID = sid
		self.Client = fc
		self.Depend = ''
		self.Need = 0
		self.Stdout = '.'
		self.Stderr = '.'
		self.LeaderOnly = 0
		self.HoldTime = None
		self.Nice = 0
		self.PerProcRsrc = {}
		self.PerSectRsrc = {}
		self.CPUTimeLimit = -1
		self.RealTimeLimit = -1
		self.PrioInc = 0
		self.StartTime = None
		self.HoldTime = None
		self.EndTime = None
		self.JobID, self.Name = fbs_misc.decodeDotID(sid)
		self.ExitCode = None
		self.SectOutput = None
		self.RsrcPoolDict = {}
		self.ProcStats = {}
		self.Username = 'unknown'
		self.Placement = 'round-robin'
		self.OnNodes = None
		
	def isHeld(self):
		return self.HoldTime != None and \
			self.State == "waiting" and \
			(self.HoldTime == -1 or self.HoldTime >= time.time())
			
										
	def _parseLine(self, line):
		# this comes from BMGR in BMGR.getSection()
		kw, args = Parser.parseLine(line)
		inx = string.find(line, '=')
		rest = string.strip(line[inx+1:])
		if kw == 'PROC_TYPE':	self.ProcType = args[0]
		elif kw == 'NUMPROC':	self.NProc = args[0]
		elif kw == 'REAL_LIMIT':
								self.RealTimeLimit = args[0]
		elif kw == 'CPU_LIMIT':
								self.CPUTimeLimit = args[0]
		elif kw == 'EXEC':		self.Exec = rest
		elif kw == 'NEED':		self.Need = args[0]
		elif kw == 'STDOUT':	self.Stdout = args[0]
		elif kw == 'STDERR':	self.Stderr = args[0]
		elif kw == 'SECT_OUT':	self.SectOutput = args[0]
		elif kw == 'LEADER_ONLY':		self.LeaderOnly = args[0]
		elif kw == 'AFTER':		self.HoldTime = cvtime.parseDateTime(args[0])
		elif kw == 'QUEUE':		self.Queue = args[0]
		elif kw == 'NICE':		self.Nice = args[0]
		elif kw == 'UID':		self.UID = args[0]
		elif kw == 'GID':		self.GID = args[0]
		elif kw == 'PRIO_INC':	self.PrioInc = args[0]
		elif kw == 'MAILTO':	self.MailTo = args[0]
		elif kw == 'QINDEX':	self.QIndex = args[0]
		elif kw == 'DEPEND':	self.Depend = rest
		elif kw == 'PROC_RESOURCES':
			self.PerProcRsrc = Parser.wordsToDict(args, defValue = 0)
		elif kw == 'SECT_RESOURCES':
			self.PerSectRsrc = Parser.wordsToDict(args, defValue = 0)
		elif kw == 'SUB_TIME':	self.SubTime = fbs_misc.decodeTime(args[0])
		elif kw == 'HOLD_TIME':	
			self.HoldTime = fbs_misc.decodeTime(args[0])
			if self.HoldTime == -1.0:	self.HoldTime = -1
		elif kw == 'START_TIME':	self.StartTime = fbs_misc.decodeTime(args[0])
		elif kw == 'END_TIME':	self.EndTime = fbs_misc.decodeTime(args[0])
		elif kw == 'PRIO':		self.Prio = args[0]
		elif kw == 'STATE':		self.State = args[0]
		elif kw == 'PLACEMENT':		self.Placement = args[0]
		elif kw == 'ON_NODES':
			self.OnNodes = string.split(rest)
			if not self.OnNodes:
				self.OnNodes = None
		elif kw == 'EXITCODE':		self.ExitCode = args[0]
		elif kw == 'JDF_SEQ':		self.JDFSeq = args[0]
		elif kw == 'SECT_POOL_DICT':
								self.RsrcPoolDict = Parser.wordsToDict(rest)
		elif kw == 'PSTATS':	
			pslst = string.split(rest)
			for i in range(len(pslst)):
				self.ProcStats[i+1] = pslst[i]
		elif kw == 'USERNAME':	self.Username = args[0]
		else:
			raise ValueError, 'Invalid keyword %s' % kw

	def _parseList(self, lst):
		for l in lst:
			self._parseLine(l)

	def refresh(self):
		lst = self.Client._getSectionInfo(self.ID)
		#print 'refresh: lst = ', lst
		self._parseList(lst)

	def _getProcess(self, inx):
		if inx > self.NProc:
			raise KeyError, 'Section does not have process # %d' % inx
		p = FBSProcessInfo(self.Client, 
			fbs_misc.encodeProcID(self.JobID, self.Name, inx))
		p.refresh()
		return p

	def getProcess(self, inx, local_details = 1):
		bpid = fbs_misc.encodeProcID(self.JobID, self.Name, inx)
		pi = FBSProcessInfo(bpid, self.Client)
		pi.refresh(local_details)
		return pi
	
	def incPrio(self, pinc):
		return self.Client.incSectPrio(self.ID, pinc)
		
	def hold(self, t=None):
		return self.Client.holdSection(self.ID, t)
		
	def release(self):
		return self.Client.releaseSection(self.ID)

	def kill(self, now=0):
		return self.Client.killSection(self.ID, now)
