#
# @(#) $Id: FBSQueueInfo.py,v 1.12 2001/05/11 15:09:00 ivm Exp $
#
# $Log: FBSQueueInfo.py,v $
# Revision 1.12  2001/05/11 15:09:00  ivm
# Fixed many bugs
#
# Revision 1.11  2001/03/13 15:59:00  ivm
# Fixed bugs in object ownership
#
# Revision 1.10  2000/12/05 19:25:22  ivm
# Removed optional UPS dependency on Kerberos
# Count only "ready" sections in FBSQueueInfo.NPending
#
# Revision 1.9  2000/08/21 20:27:39  ivm
# Make MinSPrio obsolete
#
# Revision 1.8  2000/08/18 21:15:39  ivm
# Implemented dynamic re-configuration
#
# Revision 1.7  2000/07/17 17:25:09  ivm
# Added queue locking/unlocking
# Generate KeyError if queue not found in hold/releaseQueue
#
# Revision 1.6  2000/06/19 14:54:13  ivm
# Added fields to QueueInfo
# Fixed LCH,LCHIF
#
# Revision 1.5  2000/05/30 21:03:59  ivm
# Added missed fields
#
# Revision 1.4  2000/03/06 21:47:44  ivm
# Added DefProcType to FBSQueueInfo
#
# Revision 1.2  2000/03/06 21:15:51  ivm
# Added queue held/released status
#
# Revision 1.1  2000/03/06 17:52:53  ivm
# Implemented getQueue
#
#

import serialize

class	FBSQueueInfo:
	def __init__(self, client, name):
		self.Name = name
		self.Client = client
		self.Sections = []
		self._SectState = []
		self._SectPrio = []
		self.SectState = {}
		self.SectPrio = {}
		self.NPending = 0
		self.NRunning = 0
		self.MaxSPrio = 0
		self.MinSPrio = 0
		self.InitPrio = 0
		self.SPGap = 0
		self.MaxQPrio = 0
		self.MinQPrio = 0
		self.Prio = self.MinQPrio
		self.QPGap = 0
		self.SPInc = 0
		self.SPDec = 0
		self.QPInc = 0
		self.QPDec = 0
		self.IsHeld = 0
		self.IsLocked = 0
		self.DefProcType = ''
		self.RealTimeLimit = -1
		self.CPUTimeLimit = -1
		self.Users = ['*']
		self.ProcTypes = ['*']
						
	def refresh(self):
		str = self.Client._getQueueInfo(self.Name)
		dict, rest = serialize.deserialize(str)

		for k, v in dict.items():
			if self.__dict__.has_key(k):
				self.__dict__[k] = v
			
		self.NPending = 0
		self.NRunning = 0
		for sid in self.Sections:
			state = self.SectState[sid]
			if state == 'running':
				self.NRunning = self.NRunning + 1
			elif state == 'ready':
				self.NPending = self.NPending + 1
			
	def hold(self):
		return self.Client.holdQueue(self.Name)	
		
	def release(self):
		return self.Client.releaseQueue(self.Name)

	def lock(self):
		return self.Client.lockQueue(self.Name)

	def unlock(self):
		return self.Client.unlockQueue(self.Name)

	def update(self):
		dict = {}
		self.ProcTypes.sort()
		self.Users.sort()
		for k in ['QPGap', 'QPInc', 'QPDec', 'MaxQPrio', 'MinQPrio',
				'MaxSPrio','Prio', 'DefProcType', 'SPGap',
				'RealTimeLimit', 'CPUTimeLimit', 'Users','ProcTypes']:
			dict[k] = self.__dict__[k]
		return self.Client._updateQueueParams(self.Name, dict)
